/*
 * Decompiled with CFR 0.152.
 */
package ibase.ejb;

import ibase.ejb.ExtServiceLocal;
import ibase.ejb.ExtServiceRemote;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.utility.ITMException;
import java.io.ByteArrayInputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.HashMap;
import javax.ejb.Stateless;
import oracle.sql.BLOB;

@Stateless
public class ExtServiceEJB
implements ExtServiceRemote,
ExtServiceLocal {
    @Override
    public HashMap<String, String> getLoginUserDetails(UserInfoBean userInfoBean) {
        String userType = userInfoBean.getUserType();
        BaseLogger.log("2", userInfoBean, null, "User Type .....1= " + userType);
        if ("U".equalsIgnoreCase(userType)) {
            return this.getUserDetails(userInfoBean);
        }
        if ("E".equalsIgnoreCase(userType)) {
            return this.getEmployeeDetails(userInfoBean);
        }
        if ("P".equalsIgnoreCase(userType)) {
            BaseLogger.log("3", userInfoBean, null, "Not implemented for salesPerson ");
        } else if ("C".equalsIgnoreCase(userType)) {
            BaseLogger.log("3", userInfoBean, null, "Not implemented for customer");
        } else if ("S".equalsIgnoreCase(userType)) {
            BaseLogger.log("3", userInfoBean, null, "Not implemented for Supplier");
        }
        return null;
    }

    private HashMap<String, String> getUserDetails(UserInfoBean userInfoBean) {
        HashMap<String, String> resultDtlMap;
        block22: {
            Connection conn = null;
            Statement pstmt = null;
            ResultSet rs = null;
            resultDtlMap = new HashMap<String, String>();
            try {
                try {
                    BaseLogger.log("3", userInfoBean, null, "In get Users detail ejb");
                    E12GenericUtility genericUtility = new E12GenericUtility();
                    String transDB = E12GenericUtility.checkNull(userInfoBean.getTransDB());
                    ConnDriver connDriver = new ConnDriver();
                    conn = connDriver.getConnectDB(transDB);
                    connDriver = null;
                    String sql = "SELECT NAME, USER_ID, EMAIL_ID, MOBILE_NO FROM USERS WHERE CODE = ?";
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setString(1, userInfoBean.getLoginCode());
                    rs = pstmt.executeQuery();
                    ResultSetMetaData rsmd = rs.getMetaData();
                    int colCount = rsmd.getColumnCount();
                    while (rs.next()) {
                        int colNo = 1;
                        while (colNo <= colCount) {
                            String colName = rsmd.getColumnName(colNo);
                            colName = colName.toUpperCase();
                            colName = genericUtility.initCap(colName, "_");
                            String colValues = E12GenericUtility.checkNull(rs.getString(colNo));
                            resultDtlMap.put(colName, colValues);
                            ++colNo;
                        }
                    }
                    rs.close();
                    rs = null;
                    pstmt.close();
                    pstmt = null;
                }
                catch (Exception e) {
                    resultDtlMap = null;
                    e.printStackTrace();
                    try {
                        if (pstmt != null) {
                            pstmt.close();
                            pstmt = null;
                        }
                        if (rs != null) {
                            rs.close();
                            rs = null;
                        }
                        if (conn != null) {
                            conn.close();
                            conn = null;
                        }
                        break block22;
                    }
                    catch (Exception e2) {
                        BaseLogger.log("0", userInfoBean, null, "Exception :getUsereDtl " + e2.getMessage());
                        e2.printStackTrace();
                    }
                    break block22;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (Exception e) {
                    BaseLogger.log("0", userInfoBean, null, "Exception :getUsereDtl " + e.getMessage());
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfoBean, null, "Exception :getUsereDtl " + e.getMessage());
                e.printStackTrace();
            }
        }
        BaseLogger.log("2", userInfoBean, null, "In user Details - [" + resultDtlMap + "]");
        return resultDtlMap;
    }

    @Override
    public UserInfoBean updateUseInfo(UserInfoBean userInfoBean) {
        block21: {
            Connection conn = null;
            Statement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    BaseLogger.log("3", userInfoBean, null, "In UpdateUserInforBean");
                    E12GenericUtility genericUtility = new E12GenericUtility();
                    String transDB = E12GenericUtility.checkNull(userInfoBean.getTransDB());
                    ConnDriver connDriver = new ConnDriver();
                    conn = connDriver.getConnectDB(transDB);
                    connDriver = null;
                    String sql = "SELECT CODE,USER_TYPE FROM USERS WHERE USER_ID=? OR EMAIL_ID=? OR MOBILE_NO=? ";
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setString(1, userInfoBean.getLoginCode());
                    pstmt.setString(2, userInfoBean.getLoginCode());
                    pstmt.setString(3, userInfoBean.getLoginCode());
                    rs = pstmt.executeQuery();
                    BaseLogger.log("3", userInfoBean, null, "In update userInfBean before login code");
                    if (rs.next()) {
                        String loginCode = rs.getString("CODE");
                        userInfoBean.setLoginCode(loginCode);
                        BaseLogger.log("3", userInfoBean, null, "In update userInfBean login code" + loginCode);
                        String userType = rs.getString("USER_TYPE");
                        userInfoBean.setUserType(userType);
                        BaseLogger.log("3", userInfoBean, null, "In update userInfBean userType" + userType);
                    }
                    rs.close();
                    rs = null;
                    pstmt.close();
                    pstmt = null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        if (pstmt != null) {
                            pstmt.close();
                            pstmt = null;
                        }
                        if (rs != null) {
                            rs.close();
                            rs = null;
                        }
                        if (conn != null) {
                            conn.close();
                            conn = null;
                        }
                        break block21;
                    }
                    catch (Exception e2) {
                        BaseLogger.log("0", userInfoBean, null, "Exception :getUsereDtl " + e2.getMessage());
                        e2.printStackTrace();
                    }
                    break block21;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (Exception e) {
                    BaseLogger.log("0", userInfoBean, null, "Exception :getUsereDtl " + e.getMessage());
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfoBean, null, "Exception :getUsereDtl " + e.getMessage());
                e.printStackTrace();
            }
        }
        BaseLogger.log("2", userInfoBean, null, "userInfoBean in EJB - [" + userInfoBean + "]");
        return userInfoBean;
    }

    private HashMap<String, String> getEmployeeDetails(UserInfoBean userInfoBean) {
        HashMap<String, String> resultDtlMap;
        block22: {
            Connection conn = null;
            Statement pstmt = null;
            ResultSet rs = null;
            resultDtlMap = new HashMap<String, String>();
            try {
                try {
                    BaseLogger.log("3", userInfoBean, null, "in get employee detail ejb");
                    E12GenericUtility genericUtility = new E12GenericUtility();
                    String transDB = E12GenericUtility.checkNull(userInfoBean.getTransDB());
                    ConnDriver connDriver = new ConnDriver();
                    conn = connDriver.getConnectDB(transDB);
                    connDriver = null;
                    String sql = " SELECT (E1.EMP_FNAME || ' ' || E1.EMP_MNAME || ' ' || E1.EMP_LNAME) EMP_NAME, E1.GRADE, E1.CADRE, E1.DESIGNATION, E1.REPORT_TO,  (E2.EMP_FNAME || ' ' || E2.EMP_MNAME || ' ' || E2.EMP_LNAME) REPORT_TO_NAME, E1.EMAIL_ID_OFF, E1.EMP_SITE, E1.EMP_CODE__HOD,  (E3.EMP_FNAME || ' ' || E3.EMP_MNAME || ' ' || E3.EMP_LNAME) HOD_NAME, E2.EMAIL_ID_OFF REPORT_TO_EMAIL,  E3.EMAIL_ID_OFF HOD_EMAIL, E1.CCTR_CODE__SAL,  E1.PAY_SITE, E1.WORK_SITE, E1.ALTER_CODE FROM EMPLOYEE E1  LEFT OUTER JOIN EMPLOYEE E2 ON E2.EMP_CODE = E1.REPORT_TO  LEFT OUTER JOIN EMPLOYEE E3 ON E3.EMP_CODE = E1.EMP_CODE__HOD  WHERE E1.EMP_CODE = ? ";
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setString(1, userInfoBean.getEmpCode());
                    rs = pstmt.executeQuery();
                    ResultSetMetaData rsmd = rs.getMetaData();
                    int colCount = rsmd.getColumnCount();
                    while (rs.next()) {
                        int colNo = 1;
                        while (colNo <= colCount) {
                            String colName = rsmd.getColumnName(colNo);
                            colName = colName.toUpperCase();
                            colName = genericUtility.initCap(colName, "_");
                            String colValues = E12GenericUtility.checkNull(rs.getString(colNo));
                            resultDtlMap.put(colName, colValues);
                            ++colNo;
                        }
                    }
                    rs.close();
                    rs = null;
                    pstmt.close();
                    pstmt = null;
                }
                catch (Exception e) {
                    resultDtlMap = null;
                    e.printStackTrace();
                    try {
                        if (pstmt != null) {
                            pstmt.close();
                            pstmt = null;
                        }
                        if (rs != null) {
                            rs.close();
                            rs = null;
                        }
                        if (conn != null) {
                            conn.close();
                            conn = null;
                        }
                        break block22;
                    }
                    catch (Exception e2) {
                        BaseLogger.log("0", userInfoBean, null, "Exception :getEmployeeDtl " + e2.getMessage());
                        e2.printStackTrace();
                    }
                    break block22;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (Exception e) {
                    BaseLogger.log("0", userInfoBean, null, "Exception :getEmployeeDtl " + e.getMessage());
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfoBean, null, "Exception :getEmployeeDtl " + e.getMessage());
                e.printStackTrace();
            }
        }
        BaseLogger.log("2", userInfoBean, null, "resultDtlJson in EJB - [" + resultDtlMap + "]");
        return resultDtlMap;
    }

    @Override
    public String createExtServiceLog(String tokenId, String action, String params, String responseType, String response, String requestedTerm, String requestedUser, String hostName, String hostIP, UserInfoBean userInfo) throws ITMException {
        String returnString = "";
        Connection conn = null;
        Statement pstmt = null;
        try {
            try {
                E12GenericUtility genericUtility = new E12GenericUtility();
                BaseLogger.log("3", userInfo, null, "In createExtServiceLog - \ntokenId - [" + tokenId + "], \naction - [" + action + "], \nparams - [" + params + "]");
                ConnDriver connDriver = new ConnDriver();
                String transDB = "";
                if (userInfo != null) {
                    transDB = E12GenericUtility.checkNull(userInfo.getTransDB());
                }
                conn = connDriver.getConnectDB(transDB);
                conn.setAutoCommit(false);
                connDriver = null;
                String tranId = "";
                String seqQuery = "SELECT EXT_SERVICE_LOG_SEQ.NEXTVAL FROM DUAL";
                pstmt = conn.prepareStatement(seqQuery);
                ResultSet rs = pstmt.executeQuery();
                if (rs.next()) {
                    tranId = rs.getString(1);
                }
                rs.close();
                rs = null;
                pstmt.close();
                pstmt = null;
                String sql = "";
                int insertCnt = 0;
                if ("mysql".equalsIgnoreCase(CommonConstants.DB_NAME)) {
                    sql = "INSERT INTO EXT_SERVICE_LOG (TRAN_ID, TOKEN_ID, ACTION, PARAM, RESPONSE_TYPE, RESPONSE, REQ_ON, REQ_BY, REQ_TERM, HOST_NAME, HOST_IP)  VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                    byte[] paramsArray = params != null ? params.getBytes() : null;
                    ByteArrayInputStream paramsByteArray = paramsArray != null ? new ByteArrayInputStream(paramsArray) : null;
                    byte[] responseArray = response != null ? response.getBytes() : null;
                    ByteArrayInputStream responseByteArray = responseArray != null ? new ByteArrayInputStream(responseArray) : null;
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setString(1, tranId);
                    pstmt.setString(2, tokenId);
                    pstmt.setString(3, action);
                    if (paramsByteArray != null) {
                        pstmt.setBinaryStream(4, paramsByteArray, paramsByteArray.available());
                    } else {
                        pstmt.setBinaryStream(4, null, 0);
                    }
                    pstmt.setString(5, responseType);
                    if (responseByteArray != null) {
                        pstmt.setBinaryStream(6, responseByteArray, responseByteArray.available());
                    } else {
                        pstmt.setBinaryStream(6, null, 0);
                    }
                    pstmt.setTimestamp(7, new Timestamp(System.currentTimeMillis()));
                    pstmt.setString(8, requestedUser);
                    pstmt.setString(9, requestedTerm);
                    pstmt.setString(10, hostName);
                    pstmt.setString(11, hostIP);
                    insertCnt = pstmt.executeUpdate();
                    pstmt.close();
                    pstmt = null;
                } else {
                    sql = "INSERT INTO EXT_SERVICE_LOG (TRAN_ID, TOKEN_ID, ACTION, PARAM, RESPONSE_TYPE, RESPONSE, REQ_ON, REQ_BY, REQ_TERM, HOST_NAME, HOST_IP)  VALUES (?, ?, ?, EMPTY_BLOB(), ?, EMPTY_BLOB(), ?, ?, ?, ?, ?)";
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setString(1, tranId);
                    pstmt.setString(2, tokenId);
                    pstmt.setString(3, action);
                    pstmt.setString(4, responseType);
                    pstmt.setTimestamp(5, new Timestamp(System.currentTimeMillis()));
                    pstmt.setString(6, requestedUser);
                    pstmt.setString(7, requestedTerm);
                    pstmt.setString(8, hostName);
                    pstmt.setString(9, hostIP);
                    insertCnt = pstmt.executeUpdate();
                    pstmt.close();
                    pstmt = null;
                    boolean updateFlag = false;
                    if (insertCnt > 0) {
                        pstmt = conn.prepareStatement("SELECT PARAM, RESPONSE FROM EXT_SERVICE_LOG WHERE TRAN_ID = ? FOR UPDATE");
                        pstmt.setString(1, tranId);
                        rs = pstmt.executeQuery();
                        if (rs.next()) {
                            updateFlag = true;
                            Blob mapBlob = rs.getBlob(1);
                            OutputStream blobOutputStream = ((BLOB)mapBlob).getBinaryOutputStream();
                            params = E12GenericUtility.checkNull(params);
                            blobOutputStream.write(params.getBytes());
                            blobOutputStream.close();
                            blobOutputStream = null;
                            mapBlob = null;
                            mapBlob = rs.getBlob(2);
                            blobOutputStream = ((BLOB)mapBlob).getBinaryOutputStream();
                            response = E12GenericUtility.checkNull(response);
                            blobOutputStream.write(response.getBytes());
                            blobOutputStream.close();
                            blobOutputStream = null;
                            mapBlob = null;
                        }
                        pstmt.close();
                        pstmt = null;
                        rs.close();
                        rs = null;
                    }
                    BaseLogger.log("3", userInfo, null, "updateFlag - " + updateFlag);
                }
                BaseLogger.log("3", userInfo, null, "<..........ROW INSERTED.............> [" + insertCnt + "]");
                if (conn != null) {
                    conn.commit();
                    conn.close();
                    conn = null;
                }
                returnString = "<ROOT><RESULT>Success</RESULT></ROOT>";
            }
            catch (SQLException e) {
                returnString = "<ROOT><RESULT>" + e.getMessage() + "</RESULT></ROOT>";
                e.printStackTrace();
                throw new ITMException(e);
            }
            catch (Exception e) {
                returnString = "<ROOT><RESULT>" + e.getMessage() + "</RESULT></ROOT>";
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "Exception :" + e.getMessage());
                e.printStackTrace();
            }
        }
        BaseLogger.log("2", userInfo, null, "returnString - [" + returnString + "]");
        return returnString;
    }
}

