/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.utility;

import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.ActionHandlerEJB;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.ejb.EventManagerEJB;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.MasterDataStatefulEJB;
import ibase.webitm.utility.DWFactory;
import ibase.webitm.utility.DWObject;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GenericConfirm
extends ActionHandlerEJB {
    private final String OBJ_INFO_SEPARATOR = ";";
    private final String XTRA_PARAMS_SEPARATOR = "~~";
    private String user_lang = "en";
    private String user_country = "US";
    private HashMap<String, String> objFromInfoMap = new HashMap();

    public String confirm(String tranID, String xtraParams, String forcedFlag, String userInfoStr) throws RemoteException, ITMException {
        BaseLogger.log("3", null, null, "GenericConfirm.confirm()....... [tranID, xtraParams, forcedFlag, userInfo]");
        String responseStr = "";
        E12GenericUtility genericUtility = new E12GenericUtility();
        try {
            UserInfoBean userInfo = null;
            if (userInfoStr != null && userInfoStr.trim().length() > 0) {
                userInfo = new UserInfoBean(userInfoStr);
                this.setUserInfo(userInfo);
            }
            BaseLogger.log("3", null, null, "userInfo : [" + userInfo + "]");
            String transDB = userInfo.getTransDB();
            String objName = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "objName");
            String XTRA_PARAMS = "loginCode=" + userInfo.getLoginCode() + "~~" + "loginEmpCode=" + userInfo.getEmpCode() + "~~" + "loginSiteCode=" + userInfo.getSiteCode() + "~~" + "entityCode=" + userInfo.getEntityCode() + "~~" + "profileId=" + userInfo.getProfileId() + "~~" + "userType=" + userInfo.getUserType() + "~~" + "runMode=I" + "~~" + "user_lang=" + this.user_lang + "~~" + "user_country=" + this.user_country + "~~" + "site_code=" + userInfo.getSiteCode() + "~~" + "termId=" + userInfo.getRemoteHost() + "~~" + "chgTerm=" + userInfo.getRemoteHost() + "~~" + "objName=" + objName;
            BaseLogger.log("3", null, null, "XTRA_PARAMS [" + XTRA_PARAMS + "]");
            DBAccessEJB dbAccess = new DBAccessEJB();
            ArrayList objFormsDetailList = dbAccess.getObjFormsDetailList(objName, userInfo);
            BaseLogger.log("3", null, null, "objFormsDetailList : [" + objFormsDetailList + "]");
            this.setObjFormInfoMap(objFormsDetailList);
            String refSer = "";
            HashMap objDetailMap = null;
            if (transDB != null && !"null".equalsIgnoreCase(transDB.trim()) && transDB.trim().length() > 0) {
                objDetailMap = dbAccess.getObjDetailMap(objName, userInfo);
            }
            if (objDetailMap != null) {
                refSer = objDetailMap.get("REF_SER") != null ? (String)objDetailMap.get("REF_SER") : null;
            }
            MasterDataStatefulEJB masterDataStateful = new MasterDataStatefulEJB();
            String transDomString = masterDataStateful.getXMLFromDBForEdit(objName, "2", objFormsDetailList.size(), tranID, this.getHeaderPKFieldTypes(objName, userInfo), null, null, refSer, userInfo.toString(), objFormsDetailList);
            masterDataStateful = null;
            BaseLogger.log("3", null, null, "transDomString : [" + transDomString + "]");
            EventManagerEJB eventManager = new EventManagerEJB();
            eventManager.setUserInfo(userInfo);
            boolean isEventFound = eventManager.isEventExist(objName, "pre_confirm", userInfo);
            BaseLogger.log("3", null, null, "pre_confirm isEventFound : [" + isEventFound + "]");
            if (isEventFound) {
                responseStr = eventManager.executeSystemEvent(objName, "pre_confirm", null, transDomString, transDomString, XTRA_PARAMS, null, userInfo);
            } else {
                responseStr = this.updateWFStatus(objName, transDomString, "A", userInfo);
                if (responseStr != null && responseStr.indexOf("<Errors>") == -1) {
                    responseStr = new ITMDBAccessEJB().getErrorString("", "VTWFAPRV", "", "");
                }
            }
            eventManager = null;
            BaseLogger.log("3", null, null, "responseStr : [" + responseStr + "]");
            if (responseStr != null && responseStr.trim().length() > 0) {
                boolean isErrorNodeFound = genericUtility.isErrorNodeFound(responseStr);
                BaseLogger.log("3", null, null, "isErrorNodeFound : [" + isErrorNodeFound + "]");
                if (isErrorNodeFound) {
                    String errorDescr = genericUtility.getErrorMsgDescr(responseStr);
                    BaseLogger.log("3", null, null, "errorDescr : [" + errorDescr + "]");
                    responseStr = "<ROOT><STATUS><![CDATA[0]]></STATUS><RESULT><![CDATA[" + errorDescr + "]]></RESULT></ROOT>";
                } else {
                    responseStr = "<ROOT><STATUS><![CDATA[1]]></STATUS><RESULT><![CDATA[Success]]></RESULT></ROOT>";
                }
            } else {
                responseStr = "<ROOT><STATUS><![CDATA[1]]></STATUS><RESULT><![CDATA[Success]]></RESULT></ROOT>";
            }
            BaseLogger.log("3", null, null, "actual responseStr : [" + responseStr + "]");
        }
        catch (Exception e) {
            BaseLogger.log("3", null, null, "Exception :: GenericConfirm : [" + e.getMessage() + "]");
            e.printStackTrace();
            throw new ITMException(e);
        }
        return responseStr;
    }

    private void setObjFormInfoMap(ArrayList dbValues) {
        try {
            int i = 0;
            while (i < dbValues.size()) {
                ArrayList currForm = (ArrayList)dbValues.get(i);
                String title = (String)currForm.get(0);
                String objContext = (String)currForm.get(14);
                String scrType = currForm.get(15) == null ? "" : currForm.get(15);
                String dbFormType = currForm.get(16) == null ? "" : currForm.get(16);
                String formName = currForm.get(32) == null ? "" : currForm.get(32);
                String parentKeyCol = currForm.get(18) == null ? "" : currForm.get(18);
                BaseLogger.log("3", null, null, "objContext =[" + objContext + "], formName =[" + formName + "]");
                this.objFromInfoMap.put(objContext, String.valueOf(dbFormType) + ";" + parentKeyCol + ";" + scrType + ";" + formName);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getHeaderPKFieldTypes(String objName, UserInfoBean userInfo) throws Exception {
        DWObject dwObj = this.getDWObject(objName, 1, userInfo);
        ArrayList primaryKeyDataTypeList = dwObj.getPrimaryKeyDataTypeList();
        StringBuffer headerPKFieldDataTypesBuff = new StringBuffer();
        int i = 0;
        while (i < primaryKeyDataTypeList.size()) {
            headerPKFieldDataTypesBuff.append((String)primaryKeyDataTypeList.get(i)).append(":");
            ++i;
        }
        return headerPKFieldDataTypesBuff.toString();
    }

    private DWObject getDWObject(String objName, int formNo, UserInfoBean userInfo) throws ITMException {
        DWObject dwObject = null;
        try {
            String metaDataFileName = "";
            String formName = "";
            if (this.objFromInfoMap != null) {
                formName = this.getObjPropValue("" + formNo, "FORM_NAME");
            }
            metaDataFileName = String.valueOf(objName) + "2" + formNo;
            if (formName != null && formName.trim().length() > 0 && !"null".equalsIgnoreCase(formName)) {
                metaDataFileName = String.valueOf(objName) + "2" + formName;
            }
            DWFactory dws = new DWFactory(userInfo);
            dwObject = dws.getDataWindow(metaDataFileName);
        }
        catch (Exception e) {
            BaseLogger.log("3", null, null, "Exception : GenericConfirm : getDWObject : [" + e + "]");
            throw new ITMException(e);
        }
        return dwObject;
    }

    private String getObjPropValue(String formNo, String objPropName) {
        String value;
        block10: {
            value = "";
            if (this.objFromInfoMap != null) break block10;
            BaseLogger.log("3", null, null, String.valueOf(objPropName) + "= []");
            return "";
        }
        try {
            String objFromInfo = this.objFromInfoMap.get(formNo);
            String[] strArr = objFromInfo.split(";");
            if ("FORM_TYPE".equalsIgnoreCase(objPropName)) {
                value = strArr != null && strArr.length > 0 ? strArr[0] : "";
            } else if ("PARENT_KEY_COL".equalsIgnoreCase(objPropName)) {
                value = strArr != null && strArr.length > 1 ? strArr[1] : "";
            } else if ("SCR_FLAG".equalsIgnoreCase(objPropName)) {
                value = strArr != null && strArr.length > 2 ? strArr[2] : "";
            } else if ("FORM_NAME".equalsIgnoreCase(objPropName)) {
                value = strArr != null && strArr.length > 3 ? strArr[3] : "";
            }
            BaseLogger.log("3", null, null, String.valueOf(objPropName) + "= [" + value + "]");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return value;
    }

    /*
     * Loose catch block
     */
    private String updateWFStatus(String objName, String transDomStr, String wfStatus, UserInfoBean userInfo) throws ITMException {
        String response;
        block42: {
            response = "error";
            Statement psmt = null;
            ResultSet rs = null;
            Connection conn = null;
            ConnDriver connDriver = null;
            E12GenericUtility genericUtility = new E12GenericUtility();
            try {
                try {
                    Document transDom = genericUtility.parseString(transDomStr);
                    String detailNodeName = "Detail1";
                    Node detailNode = transDom.getElementsByTagName(detailNodeName).item(0);
                    String tranId = "";
                    if (detailNode.getAttributes().getNamedItem("dbID") != null) {
                        tranId = detailNode.getAttributes().getNamedItem("dbID").getNodeValue();
                    }
                    tranId = E12GenericUtility.checkNull(tranId);
                    BaseLogger.log("3", null, null, "dbID : [" + tranId + "]");
                    String pkNames = "";
                    NodeList subChildList = detailNode.getChildNodes();
                    int subChildListLen = subChildList.getLength();
                    Node childNode = null;
                    int i = 0;
                    while (i < subChildListLen) {
                        childNode = subChildList.item(i);
                        String childNodeName = childNode.getNodeName();
                        if (childNode.getNodeType() == 1 && "attribute".equalsIgnoreCase(childNodeName)) {
                            if (childNode.getAttributes().getNamedItem("pkNames") == null) break;
                            pkNames = childNode.getAttributes().getNamedItem("pkNames").getNodeValue();
                            break;
                        }
                        ++i;
                    }
                    if ((pkNames = E12GenericUtility.checkNull(pkNames)).length() > 0 && pkNames.endsWith(":")) {
                        pkNames = pkNames.substring(0, pkNames.length() - 1);
                    }
                    BaseLogger.log("3", null, null, "pkNames : [" + pkNames + "]");
                    if (pkNames.length() <= 0 || tranId.length() <= 0) break block42;
                    connDriver = new ConnDriver();
                    conn = connDriver.getConnectDB(userInfo.getTransDB());
                    connDriver = null;
                    String tableName = "";
                    String tranIdCol = "";
                    String transetupSql = "SELECT TABLE_NAME, TRAN_ID_COL FROM TRANSETUP WHERE TRAN_WINDOW = ?";
                    psmt = conn.prepareStatement(transetupSql);
                    psmt.setString(1, "w_" + objName);
                    rs = psmt.executeQuery();
                    if (rs.next()) {
                        tableName = E12GenericUtility.checkNull(rs.getString("TABLE_NAME"));
                        tranIdCol = E12GenericUtility.checkNull(rs.getString("TRAN_ID_COL"));
                    }
                    BaseLogger.log("3", null, null, "tableName : [" + tableName + "], tranIdCol : [" + tranIdCol + "]");
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (psmt != null) {
                        psmt.close();
                        psmt = null;
                    }
                    if (tableName.length() <= 0) break block42;
                    try {
                        String updateTransTbl = "UPDATE " + tableName + " SET WF_STATUS = '" + wfStatus + "' WHERE " + pkNames + " = '" + tranId + "'";
                        psmt = conn.prepareStatement(updateTransTbl);
                        int updateCnt = psmt.executeUpdate();
                        BaseLogger.log("3", null, null, "WF_STATUS updateCnt : [" + updateCnt + "]");
                        if (updateCnt > 0) {
                            response = "success";
                        }
                        if (psmt != null) {
                            psmt.close();
                            psmt = null;
                        }
                    }
                    catch (SQLException e) {
                        BaseLogger.log("0", null, null, "SQLException for WF_STATUS update : [" + e.getMessage() + "]");
                        e.printStackTrace();
                    }
                }
                catch (DOMException e) {
                    BaseLogger.log("0", null, null, "DOMException for WF_STATUS update : [" + e.getMessage() + "]");
                    response = "exception";
                    e.printStackTrace();
                    try {
                        if (rs != null) {
                            rs.close();
                            rs = null;
                        }
                        if (psmt != null) {
                            psmt.close();
                            psmt = null;
                        }
                        if (conn != null) {
                            conn.close();
                            conn = null;
                        }
                    }
                    catch (SQLException e2) {
                        e2.printStackTrace();
                    }
                }
                catch (SQLException e) {
                    BaseLogger.log("0", null, null, "SQLException for WF_STATUS update : [" + e.getMessage() + "]");
                    response = "exception";
                    e.printStackTrace();
                    try {
                        if (rs != null) {
                            rs.close();
                            rs = null;
                        }
                        if (psmt != null) {
                            psmt.close();
                            psmt = null;
                        }
                        if (conn != null) {
                            conn.close();
                            conn = null;
                        }
                    }
                    catch (SQLException e3) {
                        e3.printStackTrace();
                    }
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "Exception for WF_STATUS update : [" + e.getMessage() + "]");
                    response = "exception";
                    e.printStackTrace();
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    try {
                        if (rs != null) {
                            rs.close();
                            rs = null;
                        }
                        if (psmt != null) {
                            psmt.close();
                            psmt = null;
                        }
                        if (conn != null) {
                            conn.close();
                            conn = null;
                        }
                    }
                    catch (SQLException e4) {
                        e4.printStackTrace();
                    }
                }
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (psmt != null) {
                        psmt.close();
                        psmt = null;
                    }
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return response;
    }
}

