/*
 * Decompiled with CFR 0.152.
 */
package ibase.planner.ejb;

import ibase.planner.ejb.PlanApprovalEJBLocal;
import ibase.planner.ejb.PlanApprovalEJBRemote;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.utility.ITMException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import javax.ejb.Stateless;

@Stateless
public class PlanApprovalEJB
implements PlanApprovalEJBLocal,
PlanApprovalEJBRemote {
    @Override
    public String getPlan(String sprsCode, String periodCode, String frDate, String toDate, UserInfoBean userInfo, Connection conn) throws ITMException, Exception {
        BaseLogger.log("2", userInfo, null, "PlanApprovalEJB :sprsCode[" + sprsCode + "]" + "periodCode:" + periodCode + "frDate[" + frDate + "]" + "toDate:" + toDate);
        boolean isError = false;
        Statement pstmt = null;
        ResultSet rs = null;
        String plan_date = "";
        String plan_time_start = "";
        String plan_time_end = "";
        String locality_descr = "";
        String activity_descr = "";
        String activityType = "";
        String sql = "";
        StringBuffer mrsPlanBuffer = null;
        E12GenericUtility genericUtility = null;
        String transDB = "";
        try {
            try {
                genericUtility = new E12GenericUtility();
                mrsPlanBuffer = new StringBuffer();
                mrsPlanBuffer.append("<DocumentRoot>");
                Date frDate1 = genericUtility.getDateObject(frDate);
                Timestamp fromDate = new Timestamp(frDate1.getTime());
                Date toDate1 = genericUtility.getDateObject(toDate);
                Timestamp uptoDate = new Timestamp(toDate1.getTime());
                String dbName = CommonConstants.DB_NAME;
                sql = "DB2".equalsIgnoreCase(dbName) ? "SELECT SP.PLAN_DATE AS PLAN_DATE, SP.SPRS_CODE__PLAN, SP.SPRS_CODE__FOR, SP.STRG_CODE, SP.PLAN_STATUS, SP.PLAN_DESCR, SP.PLAN_ACTIVITY, SP.CHG_DATE, SP.CHG_USER, SP.CHG_TERM, SP.PLAN_TIME_START, SP.PLAN_TIME_END, SP.PLAN_ID, SP.WORK_STAN_CODE, SP.CONFIRM, SP.EMP_CODE__APRV, SP.CONF_DATE, SP.LOCALITY_CODE, SP.LINE__PLANBIFR, SP.PLAN_ID__PLANBIFR, SP.TYPE__PLANBIFR, SP.OTH_PARTICIPANT, SP.SALES_TEAM, SP.SPRS_CODE__WW, SP.LAST_PROD_BRF, SP.LAST_MEET_SUMM, SP.LAST_MEET_DATE, SP.TEMPLATE_FILE, SP.DATE_SUBMIT, ST.descr AS station_descr, LC.DESCR AS locality_descr, FD.DESCR AS activity_descr ,FD.Activity_Type AS Activity_Type FROM SPRS_PLAN SP inner join fieldactivity FD on sp.plan_activity = FD.activity_code inner join station ST on sp.work_stan_code = st.stan_code LEFT OUTER JOIN locality LC on sp.locality_code = lc.locality_code WHERE SP.SPRS_CODE__FOR = ? AND SP.PERIOD_CODE = ? AND SP.PLAN_DATE BETWEEN ? AND ? " : "SELECT TO_CHAR(SP.PLAN_DATE, 'YYYY-MM-DD') AS PLAN_DATE, SP.SPRS_CODE__PLAN, SP.SPRS_CODE__FOR, SP.STRG_CODE, SP.PLAN_STATUS, SP.PLAN_DESCR, SP.PLAN_ACTIVITY, SP.CHG_DATE, SP.CHG_USER, SP.CHG_TERM, SP.PLAN_TIME_START, SP.PLAN_TIME_END, SP.PLAN_ID, SP.WORK_STAN_CODE, SP.CONFIRM, SP.EMP_CODE__APRV, SP.CONF_DATE, SP.LOCALITY_CODE, SP.LINE__PLANBIFR, SP.PLAN_ID__PLANBIFR, SP.TYPE__PLANBIFR, SP.OTH_PARTICIPANT, SP.SALES_TEAM, SP.SPRS_CODE__WW, SP.LAST_PROD_BRF, SP.LAST_MEET_SUMM, SP.LAST_MEET_DATE, SP.TEMPLATE_FILE, SP.DATE_SUBMIT, ST.descr AS station_descr, LC.DESCR AS locality_descr, FD.DESCR AS activity_descr ,FD.Activity_Type AS Activity_Type FROM SPRS_PLAN SP inner join fieldactivity FD on sp.plan_activity = FD.activity_code inner join station ST on sp.work_stan_code = st.stan_code LEFT OUTER JOIN locality LC on sp.locality_code = lc.locality_code WHERE SP.SPRS_CODE__FOR = ? AND SP.PERIOD_CODE = ? AND SP.PLAN_DATE BETWEEN ? AND ? ";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, this.checkNull(sprsCode));
                pstmt.setString(2, this.checkNull(periodCode));
                pstmt.setTimestamp(3, fromDate);
                pstmt.setTimestamp(4, uptoDate);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    plan_date = this.checkNull(rs.getString("PLAN_DATE"));
                    plan_time_start = this.checkNull(rs.getString("PLAN_TIME_START"));
                    plan_time_end = this.checkNull(rs.getString("PLAN_TIME_END"));
                    locality_descr = this.checkNull(rs.getString("LOCALITY_DESCR"));
                    activity_descr = this.checkNull(rs.getString("ACTIVITY_DESCR"));
                    activityType = this.checkNull(rs.getString("ACTIVITY_TYPE"));
                    mrsPlanBuffer.append("<Detail>\r\n");
                    mrsPlanBuffer.append("<from_date><![CDATA[").append(genericUtility.getValidDateString(frDate, "yyyy-MM-dd")).append("]]></from_date>\r\n");
                    mrsPlanBuffer.append("<to_date><![CDATA[").append(genericUtility.getValidDateString(uptoDate, "yyyy-MM-dd")).append("]]></to_date>\r\n");
                    mrsPlanBuffer.append("<activity_descr><![CDATA[").append(activity_descr).append("]]></activity_descr>\r\n");
                    mrsPlanBuffer.append("<activity_type><![CDATA[").append(activityType).append("]]></activity_type>\r\n");
                    mrsPlanBuffer.append("<plan_date><![CDATA[").append(plan_date).append("]]></plan_date>\r\n");
                    mrsPlanBuffer.append("<plan_time_start><![CDATA[").append(plan_time_start).append("]]></plan_time_start>\r\n");
                    mrsPlanBuffer.append("<plan_time_end><![CDATA[").append(plan_time_end).append("]]></plan_time_end>\r\n");
                    mrsPlanBuffer.append("<locality_descr><![CDATA[").append(locality_descr).append("]]></locality_descr>\r\n");
                    mrsPlanBuffer.append("</Detail>\r\n");
                }
                String mrsPlan = this.getHolidayData(sprsCode, fromDate, frDate, uptoDate, conn);
                if (mrsPlan.length() > 0) {
                    mrsPlanBuffer.append(mrsPlan);
                }
                mrsPlanBuffer.append("</DocumentRoot>\r\n");
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "Exception: getPlan method ..> " + e.getMessage());
                isError = true;
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
            }
            catch (SQLException sqlEx) {
                BaseLogger.log("0", userInfo, null, "Exception in Finally 135 " + sqlEx.getMessage());
                sqlEx.printStackTrace();
                throw new ITMException(sqlEx);
            }
        }
        return mrsPlanBuffer.toString();
    }

    private String checkNull(String input) {
        input = input == null ? "" : input.trim();
        return input;
    }

    public String getHolidayData(String sprsCode, Timestamp fromDate, String frDate, Timestamp uptoDate, Connection conn) {
        StringBuffer mrsPlanBuffer;
        block24: {
            mrsPlanBuffer = new StringBuffer();
            Statement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    String holType = "";
                    String plan_time_end = "";
                    String locality_descr = "";
                    String activity_descr = "";
                    String sql = "";
                    java.sql.Date plan_date = null;
                    E12GenericUtility genericUtility = new E12GenericUtility();
                    String holidayData = "SELECT HOLIDAY.HOL_TBLNO,HOLIDAY.HOL_DATE,DAY_NAME(HOL_DATE) AS DAYS,HOLIDAY.HOL_TYPE,HOLIDAY.DESCR,HOLIDAY.CHG_DATE,HOLIDAY.CHG_USER,HOLIDAY.CHG_TERM,DDF_GET_CHANGE_HOLIDAY(HOLIDAY.HOL_TBLNO,HOLIDAY.HOL_DATE,EMPLOYEE.EMP_CODE) AS CHNG_HOLIDAY FROM  HOLIDAY  HOLIDAY,EMPLOYEE  EMPLOYEE  WHERE  ( HOLIDAY.HOL_TBLNO      = EMPLOYEE.HOL_TBLNO   ) AND   HOLIDAY  .  HOL_DATE      >=     ?   AND   HOLIDAY  .  HOL_DATE      <=      ?  AND EMPLOYEE.EMP_CODE = ? ";
                    pstmt = conn.prepareStatement(holidayData);
                    pstmt.setTimestamp(1, fromDate);
                    pstmt.setTimestamp(2, uptoDate);
                    pstmt.setString(3, this.checkNull(sprsCode));
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        plan_date = rs.getDate("CHNG_HOLIDAY");
                        activity_descr = this.checkNull(rs.getString("DESCR"));
                        holType = this.checkNull(rs.getString("HOL_TYPE"));
                        mrsPlanBuffer.append("<Detail>\r\n");
                        mrsPlanBuffer.append("<from_date><![CDATA[").append(genericUtility.getValidDateString(frDate, "yyyy-MM-dd")).append("]]></from_date>\r\n");
                        mrsPlanBuffer.append("<to_date><![CDATA[").append(genericUtility.getValidDateString(uptoDate, "yyyy-MM-dd")).append("]]></to_date>\r\n");
                        if (holType.equalsIgnoreCase("H")) {
                            mrsPlanBuffer.append("<activity_descr><![CDATA[").append("HOLIDAY").append("]]></activity_descr>\r\n");
                        } else if (holType.equalsIgnoreCase("W")) {
                            mrsPlanBuffer.append("<activity_descr><![CDATA[").append("WEEKLY OFF").append("]]></activity_descr>\r\n");
                        } else {
                            mrsPlanBuffer.append("<activity_descr><![CDATA[").append(activity_descr).append("]]></activity_descr>\r\n");
                        }
                        mrsPlanBuffer.append("<plan_date><![CDATA[").append(plan_date.toString()).append("]]></plan_date>\r\n");
                        mrsPlanBuffer.append("<plan_time_start><![CDATA[").append("").append("]]></plan_time_start>\r\n");
                        mrsPlanBuffer.append("<plan_time_end><![CDATA[").append("").append("]]></plan_time_end>\r\n");
                        mrsPlanBuffer.append("<locality_descr><![CDATA[").append(activity_descr).append("]]></locality_descr>\r\n");
                        mrsPlanBuffer.append("</Detail>\r\n");
                    }
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                }
                catch (Exception e) {
                    System.out.println("Exception: getPlan method ..> " + e.getMessage());
                    e.printStackTrace();
                    try {
                        if (rs != null) {
                            rs.close();
                            rs = null;
                        }
                        if (pstmt != null) {
                            pstmt.close();
                            pstmt = null;
                        }
                        break block24;
                    }
                    catch (SQLException sqlEx) {
                        BaseLogger.log("3", null, null, "sqlEx.getMessage() [" + sqlEx.getMessage() + "]" + "getMessage() [" + sqlEx.getMessage() + "]");
                        sqlEx.printStackTrace();
                    }
                    break block24;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                }
                catch (SQLException sqlEx) {
                    BaseLogger.log("3", null, null, "sqlEx.getMessage() [" + sqlEx.getMessage() + "]" + "getMessage() [" + sqlEx.getMessage() + "]");
                    sqlEx.printStackTrace();
                }
                throw throwable;
            }
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
            }
            catch (SQLException sqlEx) {
                BaseLogger.log("3", null, null, "sqlEx.getMessage() [" + sqlEx.getMessage() + "]" + "getMessage() [" + sqlEx.getMessage() + "]");
                sqlEx.printStackTrace();
            }
        }
        return mrsPlanBuffer.toString();
    }
}

