/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.servlet;

import com.oreilly.servlet.multipart.FilePart;
import com.oreilly.servlet.multipart.MultipartParser;
import com.oreilly.servlet.multipart.ParamPart;
import com.oreilly.servlet.multipart.Part;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.JSONtoXMLConverter;
import ibase.utility.UserInfoBean;
import ibase.utility.XMLtoJSONConverter;
import ibase.webitm.bean.TemplateDetails;
import ibase.webitm.bean.UploadTemplateBean;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.ejb.DBAccessRemote;
import ibase.webitm.ejb.DocumentHandlerEJB;
import ibase.webitm.ejb.E12CreateBatchLoadEjb;
import ibase.webitm.ejb.ITMUploadFileEJB;
import ibase.webitm.ejb.MasterApplyEJB;
import ibase.webitm.ejb.UploadFileEJB;
import ibase.webitm.utility.DWFactory;
import ibase.webitm.utility.DWObject;
import ibase.webitm.utility.ITMException;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.naming.NamingException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import jxl.Cell;
import jxl.Range;
import jxl.Sheet;
import jxl.Workbook;
import jxl.read.biff.BiffException;
import jxl.write.Label;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class UploadTemplateServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private ServletContext servletContext = null;
    private ServletConfig servletConfig = null;
    private HttpSession session = null;
    private UploadFileEJB uploadFile = null;
    private Workbook workbook = null;
    private Node rootNode = null;
    private int noOfSheet = 1;
    private String userId = "";
    private String objName = "";
    private String templateKey = "";
    private boolean isNewTemplate = false;
    private E12GenericUtility genericUtility = null;
    private TreeMap<String, String> requestParamMap = null;
    private UserInfoBean userInfo = null;
    private UploadTemplateBean uploadBean = null;
    private DBAccessEJB dbAccess = null;
    private final String COLUMN_SEPARATOR = ":";
    private String sessionId = "";
    private String fileFormatType = "";
    private String sampleFilePath = "";
    HashMap<Integer, String> sheetInfo = new HashMap();

    public void init(ServletConfig servletConfig) throws ServletException {
        try {
            this.servletConfig = servletConfig;
            this.servletContext = servletConfig.getServletContext();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        BaseLogger.log("2", null, null, "Inside doGet....");
        this.doPost(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        block109: {
            String responseStr = "";
            String caller = "";
            boolean isResponseWritten = true;
            try {
                try {
                    block108: {
                        this.session = request.getSession();
                        this.genericUtility = new E12GenericUtility();
                        this.isNewTemplate = false;
                        this.dbAccess = null;
                        this.uploadBean = null;
                        String action = this.checkNull(request.getParameter("action"));
                        BaseLogger.log("3", this.userInfo, null, "In UploadTemplateServlet.................., action - [" + action + "]");
                        BaseLogger.log("3", this.userInfo, null, "In doPost added by Ankush");
                        this.userInfo = (UserInfoBean)this.getSessionAttribute("USER_INFO");
                        String profileId = "";
                        String transDB = "";
                        try {
                            profileId = this.userInfo.getProfileId();
                            transDB = this.userInfo.getTransDB();
                            this.userId = this.userInfo.getLoginCode();
                        }
                        catch (NullPointerException e) {
                            response.sendRedirect("/ibase/webitm/jsp/E12UploadTemplate.jsp");
                        }
                        BaseLogger.log("3", this.userInfo, null, "profileId - [" + profileId + "]");
                        this.sessionId = request.getSession().getId();
                        this.requestParamMap = this.getRequestParamMap(request);
                        System.out.println("RequestParamMap" + this.requestParamMap);
                        this.noOfSheet = 1;
                        int formNo = 1;
                        this.workbook = null;
                        caller = this.getRequestParamValue("caller");
                        this.uploadBean = (UploadTemplateBean)this.getSessionAttribute(String.valueOf(caller) + "UPLOAD_BEAN");
                        if ("GET_OBJ_LIST".equals(action)) {
                            HashMap<String, String> objListMap = null;
                            objListMap = this.getUploadFile().getObjList(profileId, this.userInfo, caller);
                            this.uploadBean.setObjListMap(objListMap);
                            String respPath = "/webitm/jsp/SearchObject.jsp?caller=" + caller;
                            RequestDispatcher reqDis = this.servletContext.getRequestDispatcher(respPath);
                            reqDis.forward((ServletRequest)request, (ServletResponse)response);
                        } else if ("GET_SAMPLE".equals(action)) {
                            BaseLogger.log("3", this.userInfo, null, "excelSheetInfo=" + this.sheetInfo);
                            String sampleString = "<ROOT>";
                            int index = 1;
                            while (index <= this.sheetInfo.size()) {
                                sampleString = String.valueOf(sampleString) + "<Detail" + index + ">";
                                sampleString = String.valueOf(sampleString) + this.getSampleString(this.objName, index);
                                sampleString = String.valueOf(sampleString) + "</Detail" + index + ">";
                                ++index;
                            }
                            sampleString = String.valueOf(sampleString) + "</ROOT>";
                            BaseLogger.log("3", this.userInfo, null, "sampleString=" + sampleString);
                            String sampleFilePath = this.getSampleFile(sampleString, this.fileFormatType);
                            try {
                                int in;
                                File downloadFile = new File(sampleFilePath);
                                String fileName = downloadFile.getName();
                                String filePath = downloadFile.getAbsolutePath();
                                BaseLogger.log("3", this.userInfo, null, "sample file name=" + fileName);
                                fileName = String.valueOf(this.objName) + " Sample for upload." + FilenameUtils.getExtension((String)fileName);
                                BaseLogger.log("3", this.userInfo, null, "sample file name=" + fileName);
                                response.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
                                FileInputStream inStream = null;
                                if (this.fileFormatType.equals("excel")) {
                                    System.out.println("Download excel file");
                                    response.setContentLength((int)downloadFile.length());
                                    response.setContentType("application/x-download");
                                    ServletOutputStream servletOutputStream = response.getOutputStream();
                                    byte[] b = new byte[1024];
                                    int i = 0;
                                    inStream = new FileInputStream(downloadFile);
                                    while ((i = inStream.read(b)) > 0) {
                                        servletOutputStream.write(b, 0, i);
                                    }
                                    servletOutputStream.flush();
                                    servletOutputStream.close();
                                    downloadFile.delete();
                                    break block108;
                                }
                                response.setContentType("application/text");
                                inStream = new FileInputStream(downloadFile);
                                PrintWriter out = response.getWriter();
                                while ((in = inStream.read()) != -1) {
                                    out.write(in);
                                }
                                inStream.close();
                                out.close();
                                downloadFile.delete();
                            }
                            catch (Exception e) {
                                BaseLogger.log("3", this.userInfo, null, "Error in downloading file=[" + e.getMessage());
                                e.printStackTrace();
                            }
                        } else if ("GET_LOGICAL_DATA".equals(action)) {
                            String mapLogic = request.getParameter("mapLogic");
                            int colNo = Integer.parseInt(request.getParameter("colNo"));
                            BaseLogger.log("3", null, null, "colNo = [" + colNo + "], mapLogic = [" + mapLogic + "]");
                            Set<String> defineMapSet = this.getLogicalData(mapLogic, colNo, request);
                            this.uploadBean.setDefineMapSet(defineMapSet);
                            String respPath = "/webitm/jsp/E12UploadColMap.jsp?displayData=true&colNo=" + colNo + "&mapLogic=" + mapLogic + "&caller=" + caller;
                            RequestDispatcher reqDis = this.servletContext.getRequestDispatcher(respPath);
                            reqDis.forward((ServletRequest)request, (ServletResponse)response);
                        } else if ("GET_UPLOAD_STATUS".equals(action)) {
                            String batchId = this.checkNull(this.getRequestParamValue("BATCH_ID"));
                            responseStr = this.getUploadFile().getUploadStatusData(batchId, this.userInfo, null);
                            isResponseWritten = false;
                        } else if ("GET_ALL_UPLOAD_STATUS".equals(action)) {
                            String loadDate = this.checkNull(this.getRequestParamValue("loadDate"));
                            responseStr = this.getUploadFile().getAllUploadStatusData(this.userInfo, loadDate);
                            isResponseWritten = false;
                        } else if ("DELETE_TEMPLATE".equals(action)) {
                            String tempName = request.getParameter("TEMP_NAME");
                            String objName = request.getParameter("OBJ_NAME");
                            BaseLogger.log("3", null, null, "objName : [" + objName + "] tempName : [" + tempName + "]");
                            responseStr = this.getUploadFile().deleteTemplate(tempName, objName, this.userInfo);
                            BaseLogger.log("3", null, null, "responseStr : [" + responseStr + "]");
                            if (this.uploadBean != null && responseStr.equals("Success")) {
                                this.uploadBean.setSelectedTemplate("");
                                this.uploadBean.setFilePath(null);
                                this.uploadBean.setRightChar("");
                                this.uploadBean.setScopeValue("");
                                this.uploadBean.setTempAddUser("");
                                this.uploadBean.setShareScope("");
                                this.uploadBean.setTempRightsChar("");
                                HashMap<String, HashMap<String, String>> templateMap = this.getUploadFile().getTemplateDetail(objName, caller, this.userInfo);
                                this.uploadBean.setTemplateMap(templateMap);
                                this.uploadBean.setMatrixRowMap(null);
                                this.uploadBean.setSheetInfo(null);
                            }
                            isResponseWritten = false;
                        } else if ("DOWNLOAD_FILE".equals(action)) {
                            String batchId = this.checkNull(this.getRequestParamValue("BATCH_ID"));
                            BaseLogger.log("3", null, null, "batchId [" + batchId + "]");
                            String refSer = "";
                            if (batchId != null) {
                                refSer = this.getDBAccess().getDBColumnValue(" TRANSETUP ", " REF_SER ", " TRAN_WINDOW = 'I-BL'", transDB);
                            }
                            BaseLogger.log("3", null, null, "refSer : [" + refSer + "]");
                            String docId = this.getUploadFile().getDocId(batchId, refSer, this.userInfo);
                            BaseLogger.log("3", null, null, "DocId :[" + docId + "]");
                            responseStr = docId;
                            isResponseWritten = false;
                        } else if ("GET_UPLOAD_USER".equals(action)) {
                            String batchId = this.checkNull(this.getRequestParamValue("BATCH_ID"));
                            BaseLogger.log("3", null, null, "batchId [" + batchId + "]");
                            String userId = "";
                            if (batchId != null) {
                                userId = this.getDBAccess().getDBColumnValue("BATCHLOAD", "CHG_USER", "TRAN_SL = '1' AND BATCH_ID ='" + batchId + "'", transDB);
                            }
                            responseStr = userId;
                            isResponseWritten = false;
                        } else if ("CANCEL_UPLOAD".equals(action)) {
                            responseStr = "";
                            Set<Thread> threadSet = Thread.getAllStackTraces().keySet();
                            for (Thread thread : threadSet) {
                                String batchId = this.checkNull(this.getRequestParamValue("BATCH_ID"));
                                if (!batchId.equals(thread.getName())) continue;
                                MasterApplyEJB.cancelledUploadThreads.add(batchId);
                                responseStr = "success";
                                break;
                            }
                            isResponseWritten = false;
                        } else {
                            String excelFilePath;
                            String tempName;
                            this.objName = this.getRequestParamValue("objName");
                            if (this.objName.length() > 0) {
                                this.uploadBean.setObjName(this.objName);
                            }
                            if ("new_template".equalsIgnoreCase(tempName = this.getRequestParamValue("existingTemplate"))) {
                                this.isNewTemplate = true;
                            }
                            this.templateKey = String.valueOf(this.objName) + "::" + tempName;
                            BaseLogger.log("3", null, null, "templateKey - [" + this.templateKey + "]");
                            String isRetainPkValue = this.getRequestParamValue("isRetainPkValue");
                            if (isRetainPkValue.length() > 0) {
                                this.uploadBean.setIsRetainPkValue(isRetainPkValue);
                            }
                            if ((excelFilePath = this.getRequestParamValue("excelFilePath")).length() > 0 && !"structured_xml".equalsIgnoreCase(tempName)) {
                                this.uploadBean.setFilePath(excelFilePath);
                                if ("excel".equalsIgnoreCase(this.getRequestParamValue("fileType"))) {
                                    this.createExcelSheetInfo(excelFilePath, request);
                                } else if ("json".equalsIgnoreCase(this.getRequestParamValue("fileType"))) {
                                    this.createJsonFormDetailsInfo(excelFilePath);
                                }
                            }
                            if ("GET_TEMPLATE_LIST".equals(action)) {
                                BaseLogger.log("3", null, null, "objName - [" + this.objName + "]");
                                responseStr = this.setObjectDetail(this.userInfo);
                                if (responseStr.indexOf("<Errors>") == -1) {
                                    this.uploadBean.setObjName(this.objName);
                                    String objDesc = this.getRequestParamValue("objDesc");
                                    BaseLogger.log("3", null, null, "objDesc on get_template_list - [" + objDesc + "]");
                                    this.uploadBean.setObjDesc(objDesc);
                                    HashMap<String, HashMap<String, String>> templateMap = this.getUploadFile().getTemplateDetail(this.objName, caller, this.userInfo);
                                    this.uploadBean.setTemplateMap(templateMap);
                                    TemplateDetails.get(this.objName).setTemplateMap(templateMap);
                                    String defaultTemplate = TemplateDetails.get(this.objName).getDefaultTemplate();
                                    this.uploadBean.setDefaultTemplate(defaultTemplate);
                                    TreeMap<Integer, String> formDetailInfo = this.getUploadFile().getFormWiseTitleMap(this.objName, this.userInfo);
                                    this.uploadBean.setFormDetailInfo(formDetailInfo);
                                }
                                isResponseWritten = false;
                            } else if ("SET_SELECTED_TEMPLATE".equals(action)) {
                                String fileMappingXml = "";
                                BaseLogger.log("3", null, null, "tempName - [" + tempName + "]");
                                BaseLogger.log("3", null, null, "In SET_SELECTED_TEMPLATE =====>tempName - [" + tempName + "]");
                                if ("structured_xml".equalsIgnoreCase(tempName)) {
                                    this.uploadBean.setSelectedTemplate(tempName);
                                    this.uploadBean.setObjName(this.objName);
                                    String objDesc = this.getRequestParamValue("objDesc");
                                    this.uploadBean.setObjDesc(objDesc);
                                } else {
                                    if (!this.isNewTemplate()) {
                                        BaseLogger.log("3", this.userInfo, null, "OBJNAME - [" + this.objName + "]");
                                        fileMappingXml = this.checkNull(TemplateDetails.get(this.objName).getFileMapping(tempName));
                                        if (fileMappingXml.length() == 0) {
                                            responseStr = this.genericUtility.getErrorString("", "FILEMAPNOE", this.userId);
                                        }
                                    }
                                    BaseLogger.log("3", null, null, "fileMappingXml - [" + fileMappingXml + "]");
                                    if (responseStr.length() == 0) {
                                        String docId;
                                        BaseLogger.log("3", null, null, "tempName - [" + tempName + "]");
                                        this.uploadBean.setSelectedTemplate(tempName);
                                        BaseLogger.log("3", null, null, "objName - [" + this.objName + "]");
                                        this.uploadBean.setObjName(this.objName);
                                        String objDesc = this.getRequestParamValue("objDesc");
                                        BaseLogger.log("3", null, null, "objDesc - [" + objDesc + "]");
                                        this.uploadBean.setObjDesc(objDesc);
                                        if (!this.isNewTemplate() && !"Process_Temp".equalsIgnoreCase(caller) && (docId = this.checkNull(TemplateDetails.get(this.objName).getDocId(tempName))).length() > 0) {
                                            this.downloadTemplate(docId);
                                        }
                                        this.setSelectedTemplate(tempName);
                                    }
                                }
                                if (responseStr.indexOf("<Errors>") == -1) {
                                    responseStr = "<Root><Detail>Success</Detail></Root>";
                                }
                                isResponseWritten = false;
                            } else if ("GET_HEADER_ROW_COUNT".equals(action)) {
                                String fileType;
                                if (this.getRequestParamValue("formNo").length() > 0) {
                                    formNo = Integer.parseInt(this.getRequestParamValue("formNo"));
                                }
                                BaseLogger.log("3", null, null, "formNo - [" + formNo + "]");
                                this.fileFormatType = fileType = this.getRequestParamValue("fileType");
                                this.uploadBean.setFileType(fileType);
                                this.uploadBean.setExcelSheetInfo(null);
                                BaseLogger.log("3", null, null, "fileType - [" + fileType + "]");
                                excelFilePath = this.uploadBean.getFilePath();
                                BaseLogger.log("3", null, null, "excelFilePath - [" + excelFilePath + "]");
                                if (excelFilePath != null && !"structured_xml".equalsIgnoreCase(tempName)) {
                                    if ("excel".equalsIgnoreCase(fileType)) {
                                        responseStr = this.createExcelColumnMap(excelFilePath, request);
                                    } else if ("json".equalsIgnoreCase(fileType)) {
                                        responseStr = this.createJsonColumnMap(excelFilePath, request);
                                    } else if ("xml".equalsIgnoreCase(fileType)) {
                                        BaseLogger.log("3", null, null, "Got File Type XML in GET_HEADER_ROW_COUNT [" + excelFilePath + "]");
                                        responseStr = this.createXmlColumnMap(excelFilePath, request);
                                    }
                                    BaseLogger.log("3", null, null, "In GET_HEADER_ROW_COUNT =====>filePath - [" + this.uploadBean.getFilePath() + "]");
                                    this.sampleFilePath = this.uploadBean.getFilePath();
                                    this.sheetInfo.putAll(this.uploadBean.getFormDetailInfo());
                                    BaseLogger.log("3", this.userInfo, null, "responseStr - [" + responseStr + "]");
                                    BaseLogger.log("3", this.userInfo, null, "formdetailinfo new - [" + this.uploadBean.getFormDetailInfo() + "]");
                                    BaseLogger.log("3", this.userInfo, null, "formdetailinfo new - [" + this.uploadBean.getExcelSheetInfo() + "]");
                                }
                                if (responseStr.indexOf("<Errors>") == -1 && !"structured_xml".equalsIgnoreCase(tempName) && "excel".equalsIgnoreCase(fileType)) {
                                    responseStr = this.validateTemplate(formNo, request);
                                    BaseLogger.log("3", null, null, "responseStr GET_HEADER_ROW_COUNT - [" + responseStr + "]");
                                    if (responseStr.indexOf("<Errors>") == -1 && !this.isNewTemplate()) {
                                        String uploadRowCount = this.getUploadRowCount(tempName, fileType, this.userInfo, request, response, this.templateKey, action);
                                        BaseLogger.log("3", null, null, "--------------uploadRowCount : [" + uploadRowCount + "]");
                                        responseStr = "<Root><Detail><upload_row_count>" + uploadRowCount + "</upload_row_count></Detail></Root>";
                                    }
                                }
                                if (this.requestParamMap.containsKey("SERVER_DOWN")) {
                                    responseStr = this.genericUtility.getErrorString("", "SERDOWN", this.userId);
                                }
                                isResponseWritten = false;
                            } else if ("VALIDATE_TEMPLATE".equals(action)) {
                                BaseLogger.log("3", null, null, "tempName - [" + tempName + "]");
                                if (this.getRequestParamValue("formNo").length() > 0) {
                                    formNo = Integer.parseInt(this.getRequestParamValue("formNo"));
                                }
                                String templateXml = TemplateDetails.get(this.objName).getTemplateXml(tempName);
                                String fileMappingXml = TemplateDetails.get(this.objName).getFileMapping(tempName);
                                int totalForms = this.getNoOfForms();
                                TemplateDetails.get(this.templateKey).createTemplateDetail(templateXml, totalForms);
                                TemplateDetails.get(this.templateKey).createFileMappingDetail(fileMappingXml);
                                excelFilePath = this.uploadBean.getFilePath();
                                if (excelFilePath != null) {
                                    String fileType = this.getRequestParamValue("fileType");
                                    if ("excel".equalsIgnoreCase(fileType)) {
                                        responseStr = this.createExcelColumnMap(excelFilePath, request);
                                    } else if ("json".equalsIgnoreCase(fileType)) {
                                        responseStr = this.createJsonColumnMap(excelFilePath, request);
                                    }
                                }
                                if ((responseStr = this.validateTemplate(formNo, request)).indexOf("<Errors>") == -1) {
                                    BaseLogger.log("3", null, null, "valid");
                                    this.uploadBean.setSelectedTemplate(tempName);
                                    this.setSelectedTemplate(tempName);
                                } else {
                                    BaseLogger.log("3", null, null, "Invalid template");
                                }
                                isResponseWritten = false;
                            } else if ("SAVE_TEMPLATE".equals(action)) {
                                String fileType = this.uploadBean.getFileType();
                                BaseLogger.log("3", null, null, "fileType : [" + fileType + "]");
                                if ("excel".equalsIgnoreCase(fileType)) {
                                    this.setTemplateData();
                                }
                                responseStr = this.saveTemplate(request);
                                BaseLogger.log("3", null, null, "SAVE_TEMPLATE responseStr : [" + responseStr + "]");
                                isResponseWritten = false;
                            } else if ("PROCESS_TEMPLATE".equals(action)) {
                                System.out.println("In PROCESS_TEMPLATE Action");
                                BaseLogger.log("3", null, null, "tempName - [" + tempName + "]");
                                BaseLogger.log("3", null, null, "TemplateKey - [" + this.templateKey + "]");
                                BaseLogger.log("3", null, null, "tempName - [" + tempName + "]");
                                String userLevel = this.userInfo.getUserLevel();
                                BaseLogger.log("3", null, null, "userLevel :[" + userLevel + "]");
                                if (!"0".equals(userLevel)) {
                                    String resStr = this.getUploadFile().getUserRightInfo(this.objName, this.userId, this.userInfo);
                                    BaseLogger.log("3", null, null, "resStr [" + resStr + "]");
                                    if (resStr.indexOf("U") == -1 && resStr.indexOf("*") == -1) {
                                        responseStr = this.genericUtility.getErrorString("", "VTUPLDRGHT", this.userId);
                                    }
                                }
                                if (responseStr.indexOf("<Errors>") == -1 && responseStr.length() == 0) {
                                    String fileType = this.getRequestParamValue("fileType");
                                    BaseLogger.log("3", null, null, "Before filetype check FileType===>   " + fileType);
                                    if ("json".equals(fileType)) {
                                        int index = this.uploadBean.getFilePath().lastIndexOf("/");
                                        String fileName = this.uploadBean.getFilePath().substring(index + 1);
                                        System.out.println("In file type json===========>");
                                        String[] fileInfoArr = new String[]{"", fileName, this.objName, "", tempName};
                                        BaseLogger.log("3", null, null, " JSON fileInfoArr : [<=========In File type JSON==========>]");
                                        File DUMP_DIR = new File(this.uploadBean.getFilePath().substring(0, index + 1));
                                        BaseLogger.log("3", null, null, "DUMP_DIR : [" + DUMP_DIR + "]");
                                        responseStr = new ITMUploadFileEJB().insertFileData(fileInfoArr, this.userInfo, DUMP_DIR, CommonConstants.APPLICATION_CONTEXT, "", false, false);
                                    } else if ("xml".equalsIgnoreCase(fileType)) {
                                        BaseLogger.log("3", null, null, "Got file Type in process_template - [" + fileType + "]");
                                        int index = this.uploadBean.getFilePath().lastIndexOf("/");
                                        String fileName = this.uploadBean.getFilePath().substring(index + 1);
                                        System.out.println("In file type json===========>");
                                        String[] fileInfoArr = new String[]{"", fileName, this.objName, "", tempName};
                                        BaseLogger.log("3", null, null, " JSON fileInfoArr : [<=========In File type JSON==========>]");
                                        File DUMP_DIR = new File(this.uploadBean.getFilePath().substring(0, index + 1));
                                        BaseLogger.log("3", null, null, "DUMP_DIR : [" + DUMP_DIR + "]");
                                        responseStr = new ITMUploadFileEJB().insertFileData(fileInfoArr, this.userInfo, DUMP_DIR, CommonConstants.APPLICATION_CONTEXT, "", false, false);
                                        BaseLogger.log("3", null, null, "responseStr in process_template - [" + responseStr + "]");
                                    } else {
                                        responseStr = this.applyTemplate(tempName, fileType, this.userInfo, request, response, this.templateKey, action, this.sessionId);
                                    }
                                    BaseLogger.log("3", null, null, "--------------returnString : " + responseStr);
                                    if (responseStr.indexOf("<Errors>") == -1) {
                                        this.removeSessionAttribute(caller);
                                        responseStr = "<Root><Detail><BATCH_ID>" + responseStr + "</BATCH_ID></Detail></Root>";
                                    }
                                }
                                isResponseWritten = false;
                            } else if ("GET_TEMP_ATTACHMENT_DETAILS".equals(action)) {
                                String attachobjName = this.getRequestParamValue("OBJ_NAME");
                                String templName = request.getParameter("TEMPL_NAME");
                                String refId = this.checkNull(TemplateDetails.get(attachobjName).getTemplateId(templName));
                                String docId = this.checkNull(TemplateDetails.get(attachobjName).getDocId(templName));
                                responseStr = String.valueOf(refId) + "&" + docId;
                                if (refId.equals("") && docId.equals("")) {
                                    responseStr = this.getUploadFile().getDocIdNrefId(attachobjName, templName, this.userInfo);
                                }
                                BaseLogger.log("3", null, null, "responseStr : [" + responseStr + "]");
                                isResponseWritten = false;
                            } else if ("VALIDATE_INPUT_DATA".equals(action)) {
                                String fileType = this.uploadBean.getFileType();
                                BaseLogger.log("3", null, null, "fileType : [" + fileType + "]");
                                BaseLogger.log("3", null, null, "fileType : [" + this.uploadBean.getFilePath() + "]");
                                if ("excel".equalsIgnoreCase(fileType)) {
                                    responseStr = this.validateInputData();
                                }
                                if ("xml".equalsIgnoreCase(fileType)) {
                                    BaseLogger.log("3", this.userInfo, null, "Got XML file to validate Data");
                                    responseStr = this.validateXmlInputData();
                                } else {
                                    responseStr = "<Root><Detail>Success</Detail></Root>";
                                }
                                isResponseWritten = false;
                            } else if ("SET_TEMPLATE_DATA".equals(action)) {
                                String fileType = this.uploadBean.getFileType();
                                BaseLogger.log("3", null, null, "fileType : [" + fileType + "]");
                                BaseLogger.log("3", this.userInfo, null, "fileType in SET_TEMPLATE_DATA: [" + fileType + "]");
                                if ("excel".equalsIgnoreCase(fileType)) {
                                    responseStr = this.setTemplateData();
                                } else if ("json".equalsIgnoreCase(fileType)) {
                                    responseStr = this.setJsonTemplateData();
                                } else if ("xml".equalsIgnoreCase(fileType)) {
                                    BaseLogger.log("3", this.userInfo, null, "Got fileType XML in SET_TEMPLATE_DATA: [" + fileType + "]");
                                    responseStr = this.setXmlTemplateData();
                                }
                                isResponseWritten = false;
                            }
                        }
                    }
                    BaseLogger.log("3", null, null, "In UploadTemplateServlet..........., returnString - [" + responseStr + "]");
                }
                catch (ITMException e) {
                    isResponseWritten = false;
                    responseStr = this.genericUtility.createErrorString(e);
                    BaseLogger.log("0", null, null, "ITMException - responseStr - [" + responseStr + "]");
                    if (!isResponseWritten) {
                        if (responseStr != null && responseStr.indexOf("<Errors>") != -1 && responseStr.indexOf("<Errors>") != 0) {
                            responseStr = responseStr.substring(responseStr.indexOf("<Errors>"));
                        }
                        PrintWriter out = response.getWriter();
                        out.print(responseStr);
                        out.flush();
                    }
                }
                catch (Exception e) {
                    block110: {
                        isResponseWritten = false;
                        responseStr = this.genericUtility.createErrorString(e);
                        BaseLogger.log("0", null, null, "Exception -responseStr - [" + responseStr + "]");
                        if (isResponseWritten) break block109;
                        if (responseStr == null || responseStr.indexOf("<Errors>") == -1 || responseStr.indexOf("<Errors>") == 0) break block110;
                        responseStr = responseStr.substring(responseStr.indexOf("<Errors>"));
                    }
                    PrintWriter out = response.getWriter();
                    out.print(responseStr);
                    out.flush();
                }
            }
            finally {
                if (!isResponseWritten) {
                    if (responseStr != null && responseStr.indexOf("<Errors>") != -1 && responseStr.indexOf("<Errors>") != 0) {
                        responseStr = responseStr.substring(responseStr.indexOf("<Errors>"));
                    }
                    PrintWriter out = response.getWriter();
                    out.print(responseStr);
                    out.flush();
                }
            }
        }
    }

    private UploadFileEJB getUploadFile() throws NamingException {
        this.uploadFile = new UploadFileEJB();
        return this.uploadFile;
    }

    private String checkNull(String nullStr) {
        return E12GenericUtility.checkNull(nullStr);
    }

    private TreeMap<String, String> getRequestParamMap(HttpServletRequest request) {
        TreeMap<String, String> dataMap = new TreeMap<String, String>();
        try {
            String paramName = "";
            String paramValue = "";
            String newExcelFilePath = "";
            String uploadFilepath = "";
            String newFileName = "";
            if (this.isMultipart(request)) {
                MultipartParser parser = new MultipartParser(request, 0xA00000);
                Part part = null;
                while ((part = parser.readNextPart()) != null) {
                    boolean isServerStop;
                    FilePart filePart;
                    String fileName;
                    if (part.isParam()) {
                        ParamPart paramPart = (ParamPart)part;
                        paramName = this.checkNull(part.getName());
                        paramValue = this.checkNull(paramPart.getStringValue());
                        BaseLogger.log("3", null, null, "MultipartParser :: parameterName - [" + paramName + "], parameterValue - [" + paramValue + "]");
                        if (!paramValue.equalsIgnoreCase("none")) {
                            dataMap.put(paramName, paramValue);
                        }
                    }
                    if (!part.isFile() || (fileName = (filePart = (FilePart)part).getFileName()) == null) continue;
                    File DUMP_DIR = new File(CommonConstants.TEMP_FOLDER);
                    DUMP_DIR.mkdir();
                    long size = filePart.writeTo(DUMP_DIR);
                    String excelFilePath = DUMP_DIR + File.separator + fileName;
                    File excelFile = new File(excelFilePath);
                    BaseLogger.log("3", null, null, "filename: " + excelFile);
                    newFileName = fileName.substring(0, fileName.lastIndexOf("."));
                    String fileType = fileName.substring(fileName.lastIndexOf(".") + 1);
                    newFileName = String.valueOf(newFileName) + "_" + this.userId + "_" + System.currentTimeMillis() + "." + fileType;
                    newExcelFilePath = DUMP_DIR + File.separator + newFileName;
                    File newExcelFile = new File(newExcelFilePath);
                    if (excelFile.renameTo(newExcelFile)) {
                        BaseLogger.log("3", null, null, "File rename success");
                    } else {
                        BaseLogger.log("3", null, null, "File rename failed");
                    }
                    dataMap.put("excelFilePath", newExcelFilePath);
                    if (this.uploadBean == null) {
                        String caller = dataMap.get("caller");
                        this.uploadBean = (UploadTemplateBean)this.getSessionAttribute(String.valueOf(caller) + "UPLOAD_BEAN");
                    }
                    if (this.uploadBean != null) {
                        this.uploadBean.setFilePath(newExcelFilePath);
                    }
                    File DUMP_DIR2 = new File(String.valueOf(CommonConstants.TEMP_FOLDER) + File.separator + "to_upload");
                    DUMP_DIR2.mkdir();
                    uploadFilepath = DUMP_DIR2 + File.separator + newFileName;
                    FileInputStream inStream = null;
                    FileOutputStream outStream = null;
                    try {
                        int length;
                        File temp = new File(newExcelFilePath);
                        inStream = new FileInputStream(temp);
                        File temp2 = new File(uploadFilepath);
                        if (!temp2.exists()) {
                            temp2.createNewFile();
                        }
                        outStream = new FileOutputStream(temp2);
                        byte[] buffer = new byte[1024];
                        while ((length = ((InputStream)inStream).read(buffer)) > 0) {
                            ((OutputStream)outStream).write(buffer, 0, length);
                        }
                        ((InputStream)inStream).close();
                        ((OutputStream)outStream).close();
                        BaseLogger.log("3", null, null, "File is copied successful!");
                        if (this.uploadBean != null) {
                            this.uploadBean.setUploadFilepath(uploadFilepath);
                        }
                    }
                    catch (IOException e) {
                        BaseLogger.log("0", null, null, "IOException : [" + e.getMessage() + "]");
                        e.printStackTrace();
                    }
                    if (CommonConstants.BACKGROUND_JOB_SERVER.length() <= 0 || !(isServerStop = this.callRemoteUpoadTemplateServlet(newExcelFilePath, uploadFilepath, newFileName))) continue;
                    dataMap.put("SERVER_DOWN", CommonConstants.BACKGROUND_JOB_SERVER);
                }
            } else {
                Enumeration parameterNames = request.getParameterNames();
                while (parameterNames.hasMoreElements()) {
                    paramName = this.checkNull((String)parameterNames.nextElement());
                    paramValue = this.checkNull(request.getParameter(paramName));
                    BaseLogger.log("3", null, null, "parameterName - [" + paramName + "], parameterValue - [" + paramValue + "]");
                    dataMap.put(paramName, paramValue);
                }
            }
            BaseLogger.log("3", null, null, "dataMap - [" + dataMap + "]");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dataMap;
    }

    private boolean callRemoteUpoadTemplateServlet(String newExcelFilePath, String uploadFilepath, String newFileName) throws ITMException, RemoteException {
        boolean isServerStop;
        block5: {
            String path = CommonConstants.BACKGROUND_JOB_SERVER;
            String userId = this.userInfo.getLoginCode();
            DBAccessEJB accessEJB = new DBAccessEJB();
            String password = accessEJB.getDBColumnValue("USERS", "PASS_WD_SHA", "CODE ='" + userId + "'");
            BaseLogger.log("3", null, null, "password -> [" + password + "]");
            FileInputStream inStream = null;
            BufferedInputStream bfr = null;
            ByteArrayOutputStream bout = null;
            byte[] byteArray = new byte[1];
            String response = "";
            isServerStop = false;
            try {
                File temp = new File(newExcelFilePath);
                inStream = new FileInputStream(temp);
                bfr = new BufferedInputStream(inStream);
                bout = new ByteArrayOutputStream();
                int i = -1;
                while ((i = bfr.read()) != -1) {
                    bout.write(i);
                }
                byteArray = bout.toByteArray();
                inStream.close();
            }
            catch (IOException io) {
                io.printStackTrace();
                BaseLogger.log("0", null, null, " callRemoteUpalodTemplateServlet IOException : [" + io.getMessage() + "]");
            }
            String requestURL = String.valueOf(path) + "/ibase/WebITMRemoteUploadTemplateServlet?ACTION=MOVE_UPLOAD_FILE" + "&USER=" + userId + "&PASSWORD=" + password + "&isSHA256Appld=true";
            BaseLogger.log("3", null, null, "requestUrl : [" + requestURL + "]");
            try {
                CloseableHttpClient client = HttpClients.createDefault();
                HttpPost httpPost = new HttpPost(requestURL);
                MultipartEntityBuilder builder = MultipartEntityBuilder.create();
                builder.addBinaryBody("UPLOAD_FILE_DATA", byteArray, ContentType.DEFAULT_BINARY, newFileName);
                HttpEntity entity = builder.build();
                httpPost.setEntity(entity);
                CloseableHttpResponse httpResponse = client.execute((HttpUriRequest)httpPost);
                HttpEntity responseEntity = httpResponse.getEntity();
                BaseLogger.log("3", this.userInfo, null, "StatusCode : [" + httpResponse.getStatusLine().getStatusCode() + "], ReasonPhrase : [" + httpResponse.getStatusLine().getReasonPhrase() + "]");
                InputStream in = responseEntity.getContent();
                response = IOUtils.toString((InputStream)in, (String)CommonConstants.ENCODING);
                BaseLogger.log("0", null, null, "response : [" + response + "]");
                in.close();
                client.close();
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, " callRemoteUpalodTemplateServlet Exception getMessage :[" + e.getMessage() + "]");
                BaseLogger.log("0", null, null, " callRemoteUpalodTemplateServlet Exception getClass :[" + e.getClass() + "]");
                e.printStackTrace();
                if (!"org.apache.http.conn.HttpHostConnectException".equalsIgnoreCase(e.getClass().getName())) break block5;
                isServerStop = true;
            }
        }
        return isServerStop;
    }

    private String getRequestParamValue(String paramName) {
        if (this.requestParamMap != null) {
            return this.checkNull(this.requestParamMap.get(paramName));
        }
        return "";
    }

    private boolean isMultipart(HttpServletRequest request) {
        return request.getContentType() != null && request.getContentType().toLowerCase().indexOf("multipart/form-data") > -1;
    }

    private int getNoOfSheet() {
        return this.noOfSheet;
    }

    private void setNoOfSheet(int noOfSheet) {
        this.noOfSheet = noOfSheet;
    }

    private UserInfoBean getUserInfo() {
        return this.userInfo;
    }

    private Workbook getWorkbook(String excelFilePath) throws ITMException {
        try {
            if (this.workbook == null) {
                File excelFile = new File(excelFilePath);
                this.workbook = Workbook.getWorkbook((File)excelFile);
                this.setNoOfSheet(this.workbook.getNumberOfSheets());
            }
        }
        catch (BiffException e) {
            throw new ITMException((Exception)((Object)e));
        }
        catch (IOException e) {
            throw new ITMException(e);
        }
        return this.workbook;
    }

    private void createExcelSheetInfo(String excelFilePath, HttpServletRequest request) throws ITMException {
        try {
            HashMap<Integer, String> excelSheetInfo = this.uploadBean.getExcelSheetInfo();
            if (excelSheetInfo == null) {
                excelSheetInfo = new HashMap();
                this.workbook = this.getWorkbook(excelFilePath);
                int noOfSheet = this.getNoOfSheet();
                BaseLogger.log("3", null, null, "noOfSheet [" + noOfSheet + "]");
                int i = 0;
                while (i < noOfSheet) {
                    Sheet sheet = this.workbook.getSheet(i);
                    if (sheet.getColumns() != 0) {
                        excelSheetInfo.put(i + 1, sheet.getName());
                    }
                    ++i;
                }
                this.uploadBean.setExcelSheetInfo(excelSheetInfo);
                BaseLogger.log("3", null, null, "excelSheetInfo [" + excelSheetInfo + "]");
            }
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
    }

    private void createJsonFormDetailsInfo(String excelFilePath) throws Exception {
        HashMap<Integer, String> excelSheetInfo = this.uploadBean.getExcelSheetInfo();
        if (excelSheetInfo == null) {
            String jsonString = this.genericUtility.readFile(excelFilePath);
            excelSheetInfo = new JSONtoXMLConverter().getJSONFormDetailsMap(jsonString);
        }
        BaseLogger.log("3", null, null, "excelSheetInfo : [" + excelSheetInfo + "]");
        this.uploadBean.setExcelSheetInfo(excelSheetInfo);
    }

    private void createXmlFormDetailsInfo(String xmlFilePath) throws Exception {
        HashMap<Integer, String> excelSheetInfo = this.uploadBean.getExcelSheetInfo();
        BaseLogger.log("3", null, null, "excelSheetInfo in createXmlFormDetailsInfo : [" + excelSheetInfo + "]");
        try {
            if (excelSheetInfo == null) {
                excelSheetInfo = new HashMap();
                System.out.println("GOt xmlfilepath " + xmlFilePath);
                NodeList rootNodeChildList = null;
                this.rootNode = this.getRootNode(xmlFilePath);
                rootNodeChildList = this.rootNode.getChildNodes();
                int i = 0;
                while (i < rootNodeChildList.getLength()) {
                    Node childNode = rootNodeChildList.item(i);
                    System.out.println("sheet info nodename" + childNode.getNodeName());
                    if (!childNode.getNodeName().contains("#") && !excelSheetInfo.containsValue(childNode.getNodeName())) {
                        excelSheetInfo.put(excelSheetInfo.size() + 1, childNode.getNodeName());
                    }
                    ++i;
                }
            }
            BaseLogger.log("3", this.userInfo, null, "excelSheetInfo : [" + excelSheetInfo + "]");
            this.uploadBean.setExcelSheetInfo(excelSheetInfo);
        }
        catch (Exception e) {
            BaseLogger.log("3", this.userInfo, null, "Error in createXmlFormDetailsInfo==>" + e.getMessage());
            e.printStackTrace();
        }
    }

    private Node getRootNode(String xmlFilePath) {
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = documentBuilder.parse(xmlFilePath);
            NodeList rootNodeList = document.getChildNodes();
            if (rootNodeList.getLength() == 1) {
                this.rootNode = rootNodeList.item(0);
                BaseLogger.log("3", null, null, "Root Node Name [ " + this.rootNode.getNodeName() + "]");
                this.setNoOfSheet(this.rootNode.getChildNodes().getLength());
                BaseLogger.log("3", null, null, "No Of sheet [ " + this.noOfSheet + "]");
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            e.printStackTrace();
        }
        return this.rootNode;
    }

    private String createExcelColumnMap(String excelFilePath, HttpServletRequest request) throws ITMException {
        String action = this.checkNull(request.getParameter("action"));
        String retString = "<Root><Detail>Success</Detail></Root>";
        try {
            this.workbook = this.getWorkbook(excelFilePath);
            HashMap<Integer, String> excelSheetInfo = this.uploadBean.getExcelSheetInfo();
            if (excelSheetInfo == null) {
                this.createExcelSheetInfo(excelFilePath, request);
            }
            excelSheetInfo = this.uploadBean.getExcelSheetInfo();
            int noOfForms = this.getNoOfForms();
            BaseLogger.log("3", null, null, "noOfForms [ " + noOfForms + "]");
            HashMap<Integer, ArrayList<String>> excelColListMap = new HashMap<Integer, ArrayList<String>>();
            HashMap<Integer, LinkedHashMap<String, String>> actualColListMap = new HashMap<Integer, LinkedHashMap<String, String>>();
            HashMap<Integer, ArrayList<String>> allActualColListMap = new HashMap<Integer, ArrayList<String>>();
            String sheetName = "";
            int sheetNo = 1;
            int tabNo = 0;
            while (tabNo < noOfForms) {
                int formNo = tabNo + 1;
                BaseLogger.log("3", null, null, "createExcelColumnMap formNo [" + formNo + "]");
                if (this.isNewTemplate()) {
                    if (this.getRequestParamValue("sheetName" + formNo).length() > 0) {
                        sheetNo = Integer.parseInt(this.getRequestParamValue("sheetName" + formNo));
                    }
                    sheetName = this.checkNull(excelSheetInfo.get(sheetNo));
                } else {
                    sheetName = this.checkNull(TemplateDetails.get(this.templateKey).getSheetName(formNo));
                }
                BaseLogger.log("3", null, null, "createExcelColumnMap sheetName [" + sheetName + "]");
                if (sheetName.length() > 0) {
                    int headingRowNo = 0;
                    int matrixRowNo = -1;
                    int startMatrixColNo = 0;
                    int endMatrixColNo = 0;
                    int tempColSpan = 0;
                    try {
                        Sheet sheet = this.workbook.getSheet(sheetName);
                        BaseLogger.log("3", null, null, "createExcelColumnMap sheet [" + sheet + "]");
                        if (sheet == null) {
                            return this.genericUtility.getErrorString("", "INVEXCL", this.userId);
                        }
                        BaseLogger.log("3", null, null, "formNo - [" + formNo + "], tabNo - [" + tabNo + "]");
                        if (!this.isNewTemplate()) {
                            headingRowNo = TemplateDetails.get(this.templateKey).getHeadingRowNo(formNo);
                            BaseLogger.log("3", null, null, "headingRowNo - [" + headingRowNo + "]");
                            matrixRowNo = TemplateDetails.get(this.templateKey).getMatrixRowNo(formNo);
                            BaseLogger.log("3", null, null, "matrixRowNo - [" + matrixRowNo + "]");
                            startMatrixColNo = TemplateDetails.get(this.templateKey).getStartMatrixColNo(formNo);
                            BaseLogger.log("3", null, null, "startMatrixColNo :[" + startMatrixColNo + "]");
                            endMatrixColNo = TemplateDetails.get(this.templateKey).getEndMatrixColNo(formNo);
                            BaseLogger.log("3", null, null, "endMatrixColNo :[" + endMatrixColNo + "]");
                            tempColSpan = TemplateDetails.get(this.templateKey).getSheetColSpan(formNo);
                            BaseLogger.log("3", null, null, "tempColSpan :[" + tempColSpan + "]");
                        } else {
                            if (this.getRequestParamValue("headingRowNo" + formNo).length() > 0) {
                                headingRowNo = Integer.parseInt(this.getRequestParamValue("headingRowNo" + formNo));
                                --headingRowNo;
                            }
                            if (this.getRequestParamValue("matrixRowNo" + formNo).length() > 0) {
                                matrixRowNo = Integer.parseInt(this.getRequestParamValue("matrixRowNo" + formNo));
                                --matrixRowNo;
                            }
                            if (this.getRequestParamValue("startMatrixColNo" + formNo).length() > 0) {
                                startMatrixColNo = Integer.parseInt(this.getRequestParamValue("startMatrixColNo" + formNo));
                                --startMatrixColNo;
                            }
                            if (this.getRequestParamValue("endMatrixColNo" + formNo).length() > 0) {
                                endMatrixColNo = Integer.parseInt(this.getRequestParamValue("endMatrixColNo" + formNo));
                                --endMatrixColNo;
                            }
                        }
                        if ("GET_HEADER_ROW_COUNT".equals(action) && matrixRowNo >= 0) {
                            boolean isCorrectTemplate = this.checkMatrixTemplate(sheet, matrixRowNo, startMatrixColNo, endMatrixColNo, tempColSpan);
                            BaseLogger.log("3", null, null, "isCorrectTemplate :: [" + isCorrectTemplate + "]");
                            if (isCorrectTemplate) {
                                retString = this.genericUtility.getErrorString("", "INVTEMPL", this.userId);
                            }
                        }
                        ArrayList<String> excelColumnList = this.getExcelColumnList(formNo, sheet, headingRowNo, matrixRowNo);
                        BaseLogger.log("3", null, null, "excelColumns[" + excelColumnList + "]");
                        excelColListMap.put(formNo, excelColumnList);
                    }
                    catch (Exception e) {
                        throw new ITMException(e);
                    }
                }
                HashMap<String, String> colListMap = this.getActualColListMap(this.objName, formNo);
                BaseLogger.log("3", null, null, "colListMap - [" + colListMap + "]");
                ArrayList<String> actualColList = new ArrayList<String>();
                LinkedHashMap<String, String> actualColMap = new LinkedHashMap<String, String>();
                for (Map.Entry<String, String> entry : colListMap.entrySet()) {
                    String codeName = entry.getKey();
                    String simpleName = entry.getValue();
                    if (codeName.indexOf(46) != -1) {
                        codeName = codeName.substring(codeName.indexOf(46) + 1);
                    }
                    actualColMap.put(codeName, simpleName);
                    actualColList.add(codeName);
                }
                BaseLogger.log("3", null, null, "actualColMap - [" + actualColMap + "]");
                actualColListMap.put(formNo, actualColMap);
                BaseLogger.log("3", null, null, "actualColList - [" + actualColList + "]");
                allActualColListMap.put(formNo, actualColList);
                ++tabNo;
            }
            HashMap<Integer, HashMap<String, HashMap<String, String>>> defineValueAllMap = null;
            HashMap<Integer, LinkedHashMap<String, String>> mapLogicValueMap = null;
            if (!this.isNewTemplate()) {
                TemplateDetails.get(this.templateKey).setExcelColListMap(excelColListMap);
                TemplateDetails.get(this.templateKey).setActualColMap(actualColListMap);
                TemplateDetails.get(this.templateKey).setActualColListMap(allActualColListMap);
                defineValueAllMap = TemplateDetails.get(this.templateKey).getFormWiseDefineValueAllMap();
                mapLogicValueMap = TemplateDetails.get(this.templateKey).getFormWiseMapLogicValue();
            } else {
                defineValueAllMap = this.uploadBean.getAllFormDefineValueMap();
                mapLogicValueMap = this.uploadBean.getMapLogicValueMap();
            }
            this.uploadBean.setExcelColListMap(excelColListMap);
            this.uploadBean.setActualColListMap(actualColListMap);
            this.uploadBean.setAllFormActualColListMap(allActualColListMap);
            if (defineValueAllMap == null) {
                defineValueAllMap = new HashMap();
            }
            this.uploadBean.setAllFormDefineValueMap(defineValueAllMap);
            if (mapLogicValueMap == null) {
                mapLogicValueMap = new HashMap();
            }
            if (this.isNewTemplate()) {
                BaseLogger.log("3", null, null, "mapLogicValueMap sets empty in new template");
                mapLogicValueMap = new HashMap();
            }
            this.uploadBean.setMapLogicValueMap(mapLogicValueMap);
        }
        catch (IndexOutOfBoundsException e) {
            throw new ITMException(e);
        }
        return retString;
    }

    private String createJsonColumnMap(String jsonFilePath, HttpServletRequest request) throws ITMException, Exception {
        String retString = "<Root><Detail>Success</Detail></Root>";
        try {
            HashMap<Integer, String> excelSheetInfo = this.uploadBean.getExcelSheetInfo();
            if (excelSheetInfo == null) {
                this.createJsonFormDetailsInfo(jsonFilePath);
            }
            excelSheetInfo = this.uploadBean.getExcelSheetInfo();
            BaseLogger.log("3", null, null, "excelSheetInfo : [" + excelSheetInfo + "]");
            int noOfForms = this.getNoOfForms();
            BaseLogger.log("3", null, null, "noOfForms [" + noOfForms + "]");
            HashMap<Integer, ArrayList<String>> excelColListMap = new HashMap<Integer, ArrayList<String>>();
            HashMap<Integer, LinkedHashMap<String, String>> actualColListMap = new HashMap<Integer, LinkedHashMap<String, String>>();
            HashMap<Integer, ArrayList<String>> allActualColListMap = new HashMap<Integer, ArrayList<String>>();
            String sheetName = "";
            int sheetNo = 1;
            int tabNo = 0;
            while (tabNo < noOfForms) {
                int formNo = tabNo + 1;
                BaseLogger.log("3", null, null, "createExcelColumnMap formNo [" + formNo + "]");
                if (this.isNewTemplate()) {
                    if (this.getRequestParamValue("sheetName" + formNo).length() > 0) {
                        sheetNo = Integer.parseInt(this.getRequestParamValue("sheetName" + formNo));
                    }
                    sheetName = this.checkNull(excelSheetInfo.get(sheetNo));
                } else {
                    sheetName = this.checkNull(TemplateDetails.get(this.templateKey).getSheetName(formNo));
                }
                BaseLogger.log("3", null, null, "createExcelColumnMap sheetName [" + sheetName + "]");
                HashMap<Integer, ArrayList<String>> excelColumnList = this.getJsonColumnList(jsonFilePath);
                BaseLogger.log("3", null, null, "excelColumns [" + excelColumnList + "]");
                excelColListMap.put(formNo, excelColumnList.get(formNo));
                BaseLogger.log("3", null, null, "excelColListMap : [" + excelColListMap + "]");
                HashMap<String, String> colListMap = this.getActualColListMap(this.objName, formNo);
                BaseLogger.log("3", null, null, "colListMap : [" + colListMap + "]");
                ArrayList<String> actualColList = new ArrayList<String>();
                LinkedHashMap<String, String> actualColMap = new LinkedHashMap<String, String>();
                for (Map.Entry<String, String> entry : colListMap.entrySet()) {
                    String codeName = entry.getKey();
                    String simpleName = entry.getValue();
                    if (codeName.indexOf(46) != -1) {
                        codeName = codeName.substring(codeName.indexOf(46) + 1);
                    }
                    actualColMap.put(codeName, simpleName);
                    actualColList.add(codeName);
                }
                BaseLogger.log("3", null, null, "actualColMap : [" + actualColMap + "]");
                actualColListMap.put(formNo, actualColMap);
                BaseLogger.log("3", null, null, "actualColList : [" + actualColList + "]");
                allActualColListMap.put(formNo, actualColList);
                ++tabNo;
            }
            HashMap<Integer, HashMap<String, HashMap<String, String>>> defineValueAllMap = null;
            HashMap<Integer, LinkedHashMap<String, String>> mapLogicValueMap = null;
            if (!this.isNewTemplate()) {
                TemplateDetails.get(this.templateKey).setExcelColListMap(excelColListMap);
                TemplateDetails.get(this.templateKey).setActualColMap(actualColListMap);
                TemplateDetails.get(this.templateKey).setActualColListMap(allActualColListMap);
                defineValueAllMap = TemplateDetails.get(this.templateKey).getFormWiseDefineValueAllMap();
                mapLogicValueMap = TemplateDetails.get(this.templateKey).getFormWiseMapLogicValue();
            } else {
                defineValueAllMap = this.uploadBean.getAllFormDefineValueMap();
                mapLogicValueMap = this.uploadBean.getMapLogicValueMap();
            }
            this.uploadBean.setExcelColListMap(excelColListMap);
            this.uploadBean.setActualColListMap(actualColListMap);
            this.uploadBean.setAllFormActualColListMap(allActualColListMap);
            if (defineValueAllMap == null) {
                defineValueAllMap = new HashMap();
            }
            this.uploadBean.setAllFormDefineValueMap(defineValueAllMap);
            if (mapLogicValueMap == null) {
                mapLogicValueMap = new HashMap();
            }
            if (this.isNewTemplate()) {
                BaseLogger.log("3", null, null, "mapLogicValueMap sets empty in new template");
                mapLogicValueMap = new HashMap();
            }
            this.uploadBean.setMapLogicValueMap(mapLogicValueMap);
        }
        catch (IndexOutOfBoundsException e) {
            throw new ITMException(e);
        }
        BaseLogger.log("3", null, null, "In createJsonColumnMap :: retString : [" + retString + "]");
        return retString;
    }

    private String createXmlColumnMap(String xmlFilePath, HttpServletRequest request) throws ITMException, Exception {
        String retString = "<Root><Detail>Success</Detail></Root>";
        try {
            HashMap<Integer, String> excelSheetInfo = this.uploadBean.getExcelSheetInfo();
            if (excelSheetInfo == null) {
                this.createXmlFormDetailsInfo(xmlFilePath);
            }
            excelSheetInfo = this.uploadBean.getExcelSheetInfo();
            BaseLogger.log("3", this.userInfo, null, "excelSheetInfo : [" + excelSheetInfo + "]");
            int noOfForms = this.getNoOfForms();
            BaseLogger.log("3", null, null, "xml noOfForms [" + noOfForms + "]");
            HashMap<Integer, ArrayList<String>> xmlColListMap = new HashMap<Integer, ArrayList<String>>();
            HashMap<Integer, LinkedHashMap<String, String>> actualColListMap = new HashMap<Integer, LinkedHashMap<String, String>>();
            HashMap<Integer, ArrayList<String>> allActualColListMap = new HashMap<Integer, ArrayList<String>>();
            String sheetName = "";
            int sheetNo = 1;
            int tabNo = 0;
            while (tabNo < noOfForms) {
                int formNo = tabNo + 1;
                BaseLogger.log("3", this.userInfo, null, "createXmlColumnMap formNo [" + formNo + "]");
                if (this.isNewTemplate()) {
                    if (this.getRequestParamValue("sheetName" + formNo).length() > 0) {
                        sheetNo = Integer.parseInt(this.getRequestParamValue("sheetName" + formNo));
                    }
                    sheetName = this.checkNull(excelSheetInfo.get(sheetNo));
                } else {
                    sheetName = this.checkNull(TemplateDetails.get(this.templateKey).getSheetName(formNo));
                }
                BaseLogger.log("3", this.userInfo, null, "createExcelColumnMap sheetName [" + sheetName + "]");
                HashMap<Integer, ArrayList<String>> xmlColumnList = this.getXmlColumnList(xmlFilePath);
                BaseLogger.log("3", this.userInfo, null, "xmlColumns [" + xmlColumnList + "]");
                xmlColListMap.put(formNo, xmlColumnList.get(formNo));
                BaseLogger.log("3", this.userInfo, null, "xmlColListMap : [" + xmlColListMap + "]");
                BaseLogger.log("3", this.userInfo, null, "OBJNAME to get Actual col List : [" + this.objName + "]" + "Form No=" + formNo);
                HashMap<String, String> colListMap = this.getActualColListMap(this.objName, formNo);
                BaseLogger.log("3", this.userInfo, null, "actual colListMap : [" + colListMap + "]");
                ArrayList<String> actualColList = new ArrayList<String>();
                LinkedHashMap<String, String> actualColMap = new LinkedHashMap<String, String>();
                for (Map.Entry<String, String> entry : colListMap.entrySet()) {
                    String codeName = entry.getKey();
                    String simpleName = entry.getValue();
                    if (codeName.indexOf(46) != -1) {
                        codeName = codeName.substring(codeName.indexOf(46) + 1);
                    }
                    actualColMap.put(codeName, simpleName);
                    actualColList.add(codeName);
                }
                BaseLogger.log("3", this.userInfo, null, "actualColMap : [" + actualColMap + "]");
                actualColListMap.put(formNo, actualColMap);
                HashMap<Integer, HashMap<String, HashMap<String, String>>> defineValueAllMap = null;
                HashMap<Integer, LinkedHashMap<String, String>> mapLogicValueMap = null;
                if (!this.isNewTemplate()) {
                    TemplateDetails.get(this.templateKey).setExcelColListMap(xmlColListMap);
                    TemplateDetails.get(this.templateKey).setActualColMap(actualColListMap);
                    TemplateDetails.get(this.templateKey).setActualColListMap(allActualColListMap);
                    defineValueAllMap = TemplateDetails.get(this.templateKey).getFormWiseDefineValueAllMap();
                    mapLogicValueMap = TemplateDetails.get(this.templateKey).getFormWiseMapLogicValue();
                } else {
                    defineValueAllMap = this.uploadBean.getAllFormDefineValueMap();
                    mapLogicValueMap = this.uploadBean.getMapLogicValueMap();
                }
                this.uploadBean.setExcelColListMap(xmlColListMap);
                this.uploadBean.setActualColListMap(actualColListMap);
                this.uploadBean.setAllFormActualColListMap(allActualColListMap);
                if (defineValueAllMap == null) {
                    defineValueAllMap = new HashMap();
                }
                System.out.println("DefineValueALLMap=" + defineValueAllMap);
                this.uploadBean.setAllFormDefineValueMap(defineValueAllMap);
                if (mapLogicValueMap == null) {
                    mapLogicValueMap = new HashMap();
                }
                if (this.isNewTemplate()) {
                    BaseLogger.log("3", null, null, "mapLogicValueMap sets empty in new template");
                    mapLogicValueMap = new HashMap();
                }
                this.uploadBean.setMapLogicValueMap(mapLogicValueMap);
                ++tabNo;
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new ITMException(e);
        }
        BaseLogger.log("3", this.userInfo, null, "In createXmlolumnMap :: retString : [" + retString + "]");
        return retString;
    }

    private boolean checkMatrixTemplate(Sheet sheet, int matrixRowNo, int startMatrixColNum, int endMatrixColNum, int tempColSpan) {
        Range[] range = sheet.getMergedCells();
        int mainRange = range.length;
        int noOfColumns = sheet.getColumns();
        BaseLogger.log("3", null, null, "mainRange :[" + mainRange + "]");
        int existingTempDiff = endMatrixColNum + 1 - startMatrixColNum;
        if (mainRange == 0) {
            try {
                ArrayList<String> matrixCollist = new ArrayList<String>();
                int sigleMatrixNo = startMatrixColNum;
                while (sigleMatrixNo <= endMatrixColNum) {
                    String colName = sheet.getCell(sigleMatrixNo, matrixRowNo).getContents();
                    matrixCollist.add(colName);
                    ++sigleMatrixNo;
                }
                if (matrixCollist.size() == existingTempDiff) {
                    return false;
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                BaseLogger.log("3", null, null, "checkMatrixTemplate ArrayIndexOutOfBoundsException : [" + e.getMessage() + "]");
                e.printStackTrace();
                return true;
            }
        }
        if (mainRange > 0) {
            TreeMap<Integer, String> matrixColMap = new TreeMap<Integer, String>();
            int actualStartMatrixColNo = 0;
            int nextStartMatrixColNo = noOfColumns;
            int i = 0;
            while (i < range.length) {
                Cell cell = range[i].getTopLeft();
                if (cell.getRow() == matrixRowNo) {
                    matrixColMap.put(cell.getColumn(), cell.getContents());
                }
                ++i;
            }
            int matrixCnt = 0;
            for (Map.Entry entry : matrixColMap.entrySet()) {
                if (matrixCnt == 0) {
                    actualStartMatrixColNo = (Integer)entry.getKey();
                } else if (matrixCnt == 1) {
                    nextStartMatrixColNo = (Integer)entry.getKey();
                    break;
                }
                ++matrixCnt;
            }
            int selectedExcelColSpan = nextStartMatrixColNo - actualStartMatrixColNo;
            BaseLogger.log("3", null, null, "selectedExcelColSpan :[" + selectedExcelColSpan + "]");
            if (selectedExcelColSpan != tempColSpan) {
                return true;
            }
        }
        return false;
    }

    private String validateTemplate(int formNo, HttpServletRequest request) throws ITMException {
        String retString;
        block5: {
            retString = "<Root><Detail>Success</Detail></Root>";
            try {
                ArrayList<String> excelColList = null;
                LinkedHashMap<String, String> targetCol = null;
                if (this.isNewTemplate()) {
                    HashMap<Integer, ArrayList<String>> excelColListMap = this.uploadBean.getExcelColListMap();
                    excelColList = excelColListMap.get(formNo);
                } else {
                    excelColList = TemplateDetails.get(this.templateKey).getExcelColList(formNo);
                    targetCol = TemplateDetails.get(this.templateKey).getTargetCol(formNo);
                }
                BaseLogger.log("3", null, null, "excelColList - " + excelColList);
                BaseLogger.log("3", null, null, "targetCol - " + targetCol);
                if (targetCol == null) break block5;
                for (Map.Entry entry : ((HashMap)targetCol).entrySet()) {
                    String excelColName = this.checkNull((String)entry.getValue());
                    BaseLogger.log("3", null, null, "excelColName - [" + excelColName + "]");
                    if (excelColName.length() <= 0 || excelColList == null || excelColList.contains(excelColName)) continue;
                    BaseLogger.log("3", null, null, "Invalid template for - [" + excelColName + "]");
                    retString = this.genericUtility.getErrorString("", "INVTEMPL", this.userId);
                    break;
                }
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
        return retString;
    }

    private HashMap<String, String> getActualColListMap(String objName, int tabNo) throws ITMException {
        LinkedHashMap<String, String> targetUpdatableColMap = new LinkedHashMap<String, String>();
        try {
            HashMap targetColMap = new HashMap();
            String pageContext = "2";
            String objContext = Integer.toString(tabNo);
            String editor = "WebEditor";
            HashMap<String, String> propEditorInfoMap = new HashMap<String, String>();
            if (this.userInfo != null) {
                propEditorInfoMap.put("PROFILE_ID_RES", this.userInfo.getProfileIdRes());
                propEditorInfoMap.put("ENTERPRISE_ID_RES", "");
                propEditorInfoMap.put("USER_ID", this.checkNull(this.userInfo.getLoginCode()));
            }
            propEditorInfoMap.put("EDITOR", editor);
            String formName = this.checkNull(TemplateDetails.get(objName).getFormName(objContext));
            BaseLogger.log("3", null, null, "formName - [" + formName + "]");
            String metadataFilePath = this.genericUtility.getMetaDataFilePath(objName, objContext, pageContext, formName, propEditorInfoMap, this.userInfo.getTransDB());
            BaseLogger.log("3", null, null, "metadataFilePath - [" + metadataFilePath + "]");
            DWObject dw = new DWObject(metadataFilePath, this.userInfo);
            ArrayList actualColValue = dw.getColumnsList();
            targetColMap = dw.getPhysicalNameDisplayNameMap();
            Hashtable updateColMapTemp = dw.getUpdateableLogPhyColNames();
            BaseLogger.log("3", null, null, "updateColMapTemp === [" + updateColMapTemp + "]");
            Hashtable updateColMap = dw.getNonEditableLogPhyColNames();
            BaseLogger.log("3", null, null, "updateColMap === [" + updateColMap + "]");
            HashMap<String, String> tabOrderWiseLogicalNameMap = dw.getTabOrderWiseLogicalNameMap();
            BaseLogger.log("3", null, null, "tabOrderWiseLogicalNameMap [" + tabOrderWiseLogicalNameMap + "]");
            ArrayList<String> updatableColList = new ArrayList<String>();
            for (Object k : updateColMap.keySet()) {
                updatableColList.add(k.toString().trim());
            }
            for (Object object : tabOrderWiseLogicalNameMap.keySet()) {
                if (!updatableColList.contains(object.toString().trim())) continue;
                targetUpdatableColMap.put("" + object, tabOrderWiseLogicalNameMap.get(object));
            }
            dw.remove();
            dw = null;
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return targetUpdatableColMap;
    }

    private String getSampleFile(String sampleString, String fileFormatType) {
        String filePath;
        block23: {
            FileWriter fileWriter = null;
            filePath = "";
            Object bufferedWriter = null;
            try {
                Node sheetNode;
                DocumentBuilder documentBuilder;
                if ("json".equalsIgnoreCase(fileFormatType)) {
                    documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                    Document document = documentBuilder.parse(new ByteArrayInputStream(sampleString.getBytes()));
                    NodeList rootNodeList = document.getChildNodes();
                    NodeList rootNodeChild = rootNodeList.item(0).getChildNodes();
                    BaseLogger.log("3", null, null, "before pasrsing Sample String before=== [");
                    StringBuilder xmlString = new StringBuilder("<ROOT>");
                    int index = 0;
                    while (index < rootNodeChild.getLength()) {
                        sheetNode = rootNodeChild.item(index);
                        NodeList colNodeList = sheetNode.getChildNodes();
                        xmlString.append("<" + sheetNode.getNodeName() + ">");
                        int colIndex = 0;
                        while (colIndex < colNodeList.getLength()) {
                            Node colNode = colNodeList.item(colIndex);
                            xmlString.append("<" + colNode.getNodeName() + ">@");
                            xmlString.append("</" + colNode.getNodeName() + ">");
                            ++colIndex;
                        }
                        xmlString.append("</" + sheetNode.getNodeName() + ">");
                        ++index;
                    }
                    xmlString.append("</ROOT>");
                    BaseLogger.log("3", null, null, "Sample String before=== [" + xmlString.toString() + "]");
                    sampleString = xmlString.toString();
                    BaseLogger.log("3", null, null, "Sample String before=== [" + sampleString + "]");
                    String jsonData = new XMLtoJSONConverter().xmlToJSONString(sampleString);
                    jsonData = jsonData.replaceAll("@", "").replace("{\"ROOT\":", "");
                    jsonData = jsonData.replace(":{", ":[{");
                    jsonData = jsonData.replace("\"}", "\"}]");
                    jsonData = jsonData.substring(0, jsonData.length() - 1);
                    BaseLogger.log("3", null, null, "Sample JSON String === [" + jsonData + "]");
                    filePath = String.valueOf(this.sampleFilePath.split("\\.")[0]) + "_sample.json";
                    File file = new File(filePath);
                    fileWriter = new FileWriter(file);
                    fileWriter.write(jsonData);
                    fileWriter.close();
                    BaseLogger.log("3", null, null, "json file written @-[" + filePath);
                }
                if ("xml".equalsIgnoreCase(fileFormatType)) {
                    BaseLogger.log("3", null, null, "Sample JSON String === [" + sampleString + "]");
                    filePath = String.valueOf(this.sampleFilePath.split("\\.")[0]) + "_sample.xml";
                    File file = new File(filePath);
                    fileWriter = new FileWriter(file);
                    fileWriter.write(sampleString);
                    fileWriter.close();
                    BaseLogger.log("3", null, null, "xml file written @-[" + filePath);
                }
                if (!"excel".equalsIgnoreCase(fileFormatType)) break block23;
                WritableWorkbook workbook = null;
                try {
                    try {
                        filePath = String.valueOf(this.sampleFilePath.split("\\.")[0]) + "_sample.xls";
                        BaseLogger.log("3", null, null, "Sample xcel file path === [" + filePath + "]");
                        workbook = Workbook.createWorkbook((File)new File(filePath));
                        documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                        Document document = documentBuilder.parse(new ByteArrayInputStream(sampleString.getBytes()));
                        NodeList rootNodeList = document.getChildNodes();
                        NodeList rootNodeChild = rootNodeList.item(0).getChildNodes();
                        int index = 0;
                        while (index < rootNodeChild.getLength()) {
                            sheetNode = rootNodeChild.item(index);
                            WritableSheet excelSheet = workbook.createSheet(rootNodeChild.item(index).getNodeName(), 0);
                            Node rowNode = sheetNode.getChildNodes().item(0);
                            NodeList colNodeList = sheetNode.getChildNodes();
                            int colIndex = 0;
                            while (colIndex < colNodeList.getLength()) {
                                Node colNode = colNodeList.item(colIndex);
                                Label label = new Label(colIndex, 0, colNode.getNodeName());
                                excelSheet.addCell((WritableCell)label);
                                ++colIndex;
                            }
                            ++index;
                        }
                        workbook.write();
                        BaseLogger.log("3", null, null, "Excel file  generated");
                    }
                    catch (IOException | ParserConfigurationException | SAXException e) {
                        e.printStackTrace();
                        BaseLogger.log("3", null, null, "Error in creating Excel file[" + e.getMessage() + "]");
                        if (workbook == null) break block23;
                        try {
                            workbook.close();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                        catch (WriteException e3) {
                            e3.printStackTrace();
                        }
                    }
                }
                finally {
                    if (workbook != null) {
                        try {
                            workbook.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        catch (WriteException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            catch (Exception e) {
                BaseLogger.log("3", null, null, "Error in creating file[" + e.getMessage() + "]");
                e.printStackTrace();
            }
        }
        return filePath;
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getSampleString(String objName, int tabNo) {
        String sampleString = "";
        try {
            StringBuilder xmlString = new StringBuilder();
            String pageContext = "2";
            String objContext = String.valueOf(tabNo);
            String editor = "WebEditor";
            HashMap<String, String> colNames = this.getActualColListMap(objName, tabNo);
            HashMap<String, String> propEditorInfoMap = new HashMap<String, String>();
            if (this.userInfo != null) {
                propEditorInfoMap.put("PROFILE_ID_RES", this.userInfo.getProfileIdRes());
                propEditorInfoMap.put("ENTERPRISE_ID_RES", "");
                propEditorInfoMap.put("USER_ID", this.checkNull(this.userInfo.getLoginCode()));
            }
            propEditorInfoMap.put("EDITOR", editor);
            String formName = this.checkNull(TemplateDetails.get(objName).getFormName(objContext));
            String metadataFilePath = this.genericUtility.getMetaDataFilePath(objName, objContext, pageContext, formName, propEditorInfoMap, this.userInfo.getTransDB());
            BaseLogger.log("3", null, null, "metadataFilePath === [" + metadataFilePath + "]");
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = documentBuilder.parse(metadataFilePath);
            Node rNode = document.getFirstChild();
            BaseLogger.log("3", null, null, "Sample Root Node Name [ " + rNode.getNodeName() + "]");
            NodeList tableNodeList = document.getElementsByTagName("TableDefinition");
            NodeList tableNodeChildList = tableNodeList.item(0).getChildNodes();
            BaseLogger.log("3", null, null, "Sample table child Node list length= [ " + tableNodeChildList.getLength() + "]");
            int index = 0;
            while (index < tableNodeChildList.getLength()) {
                Node node = tableNodeChildList.item(index);
                if (node.getNodeName().equalsIgnoreCase("table_column")) {
                    BaseLogger.log("3", null, null, "Node name=[" + node.getNodeName());
                    NodeList dataList = node.getChildNodes();
                    BaseLogger.log("3", null, null, "data Node list size=[" + dataList.getLength());
                    String colName = "";
                    String label = "";
                    String dataType = "";
                    String attribute = "";
                    String isNull = "";
                    int dataIndex = 0;
                    while (dataIndex < dataList.getLength()) {
                        if (!dataList.item(dataIndex).getNodeName().contains("#")) {
                            Node data = dataList.item(dataIndex);
                            if (data.getNodeName().equalsIgnoreCase("name")) {
                                colName = data.getFirstChild().getTextContent();
                                label = this.checkNull((String)colNames.get(colName));
                                BaseLogger.log("3", null, null, "data Node label=[" + label);
                            }
                            if (data.getNodeName().equalsIgnoreCase("type")) {
                                dataType = data.getFirstChild().getTextContent();
                                if (data.getAttributes().getLength() > 0) {
                                    NamedNodeMap attributes = data.getAttributes();
                                    int attrIndex = 0;
                                    while (attrIndex < attributes.getLength()) {
                                        attribute = String.valueOf(attribute) + attributes.item(attrIndex).getNodeName() + "='" + attributes.item(attrIndex).getNodeValue() + "' ";
                                        ++attrIndex;
                                    }
                                }
                            }
                        }
                        ++dataIndex;
                    }
                    switch (colName) {
                        default: {
                            xmlString.append("<" + colName + " label='" + label + "' dataType='" + dataType + "' " + attribute + "></" + colName + ">");
                            break;
                        }
                        case "add_date": 
                        case "add_term": 
                        case "add_user": 
                        case "chg_date": 
                        case "chg_term": 
                        case "chg_user": 
                    }
                }
                ++index;
            }
            sampleString = xmlString.toString();
            BaseLogger.log("3", null, null, "created xmlString=[" + xmlString.toString());
            return sampleString;
        }
        catch (Exception e) {
            BaseLogger.log("3", null, null, "Exception reading sample=[ " + e.getMessage() + "]");
        }
        return sampleString;
    }

    private Object getSessionAttribute(String attribute) {
        Object sessionVal = null;
        if (this.session.getAttribute(attribute) != null) {
            sessionVal = this.session.getAttribute(attribute);
        }
        return sessionVal;
    }

    private ArrayList<String> getExcelColumnList(int formNo, Sheet sheet, int headingRowNo, int matrixRowNo) throws ITMException {
        ArrayList<String> excelColList = new ArrayList<String>();
        try {
            int noOfColumns = sheet.getColumns();
            BaseLogger.log("3", null, null, "headingRowNo - [" + headingRowNo + "]");
            BaseLogger.log("3", null, null, "matrixRowNo - [" + matrixRowNo + "]");
            if (matrixRowNo >= 0) {
                excelColList.add("MatrixColumn");
            }
            int i = 0;
            while (i < noOfColumns) {
                String colName = sheet.getCell(i, headingRowNo).getContents();
                if ((colName = this.checkNull(colName)).length() > 0 && !excelColList.contains(colName = colName.replaceAll(" ", "_"))) {
                    excelColList.add(colName);
                }
                ++i;
            }
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return excelColList;
    }

    private HashMap<Integer, ArrayList<String>> getJsonColumnList(String jsonFilePath) throws Exception {
        String jsonString = this.genericUtility.readFile(jsonFilePath);
        HashMap<Integer, ArrayList<String>> getFormColMap = new JSONtoXMLConverter().getFormColNameInfoMap(jsonString);
        return getFormColMap;
    }

    private HashMap<Integer, ArrayList<String>> getXmlColumnList(String xmlFilePath) throws Exception {
        HashMap<Integer, ArrayList<String>> getFormColMap = new HashMap<Integer, ArrayList<String>>();
        ArrayList<String> colNameList = null;
        DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document document = documentBuilder.parse(xmlFilePath);
        NodeList rootNodeList = document.getChildNodes();
        Node rootNode = null;
        NodeList rootNodeChildList = null;
        if (rootNodeList.getLength() == 1) {
            rootNode = rootNodeList.item(0);
            BaseLogger.log("3", this.userInfo, null, "RootNode name=" + rootNode.getNodeName());
            rootNodeChildList = rootNode.getChildNodes();
            int index = 1;
            int i = 0;
            while (i < rootNodeChildList.getLength()) {
                Node childNode = rootNodeChildList.item(i);
                if (!childNode.getNodeName().contains("#")) {
                    BaseLogger.log("3", this.userInfo, null, "detail name=" + childNode.getNodeName());
                    NodeList childNodeList = childNode.getChildNodes();
                    colNameList = new ArrayList<String>();
                    int j = 0;
                    while (j < childNodeList.getLength()) {
                        Node node = childNodeList.item(j);
                        if (!node.getNodeName().contains("#")) {
                            BaseLogger.log("3", this.userInfo, null, "detail child node name=" + node.getNodeName());
                            colNameList.add(node.getNodeName());
                        }
                        ++j;
                    }
                    BaseLogger.log("3", this.userInfo, null, "Col Name list==" + colNameList);
                    getFormColMap.put(index, colNameList);
                    ++index;
                }
                ++i;
            }
        }
        return getFormColMap;
    }

    private int getNoOfForms() {
        int noOfForms = 1;
        try {
            TreeMap<Integer, String> formDetailInfo = this.uploadBean.getFormDetailInfo();
            noOfForms = formDetailInfo.size();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return noOfForms;
    }

    private String getUploadRowCount(String tempName, String fileType, UserInfoBean userInfo, HttpServletRequest request, HttpServletResponse response, String templateKey, String action) throws ITMException {
        String uploadRowCount = "0";
        try {
            if (!this.isNewTemplate()) {
                int startsFrom;
                int uploadRowCnt;
                int noOfSheet = this.getNoOfSheet();
                int sheetRowCnt = 0;
                if (noOfSheet > 0) {
                    String sheetName = this.checkNull(TemplateDetails.get(templateKey).getSheetName(1));
                    Sheet sheet = sheetName.length() > 0 ? this.workbook.getSheet(sheetName) : this.workbook.getSheet(0);
                    sheetRowCnt = sheet.getRows();
                }
                uploadRowCnt = (uploadRowCnt = sheetRowCnt - (startsFrom = TemplateDetails.get(templateKey).getDataStartsFrom(1))) < 0 ? 0 : uploadRowCnt;
                uploadRowCount = "" + uploadRowCnt;
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new ITMException(e);
        }
        return uploadRowCount;
    }

    private String applyTemplate(String tempName, String fileType, UserInfoBean userInfo, HttpServletRequest request, HttpServletResponse response, String templateKey, String action, String sessionId) throws ITMException {
        String responseStr = "";
        try {
            BaseLogger.log("3", userInfo, null, "--------------File Type : [" + fileType + "]");
            String filePath = this.uploadBean.getFilePath();
            BaseLogger.log("3", userInfo, null, "--------------excelFilePath : [" + filePath + "]");
            TemplateDetails tempdetails = TemplateDetails.get(this.objName);
            BaseLogger.log("3", userInfo, null, "--------------Temp. tempdetails template map size : [" + tempdetails.getTemplateMap().size() + "]");
            String tempXml = tempdetails.getTemplateXml(tempName);
            System.out.println("tempName value in Map====>" + tempdetails.getTemplateMap().get(tempName));
            "xml".equalsIgnoreCase(fileType);
            BaseLogger.log("3", userInfo, null, "--------------Temp. tempXml : [" + tempXml + "]");
            String tempString = TemplateDetails.get(this.objName).getTemplateXml(tempName);
            BaseLogger.log("3", userInfo, null, "--------------Temp. Name : [" + tempName + "]");
            BaseLogger.log("3", userInfo, null, "--------------Temp. objName : [" + this.objName + "]");
            BaseLogger.log("3", userInfo, null, "--------------Temp. String : [" + tempString + "]");
            ArrayList<Integer> sheetsUsed = TemplateDetails.get(this.objName).getTotalRowsInTemplate(tempName);
            BaseLogger.log("3", userInfo, null, "--------------totalRowsInTemp : [" + sheetsUsed + "]");
            HashMap<Integer, HashMap<String, HashMap<String, String>>> sheetMapDetailMap = TemplateDetails.get(templateKey).getSheetMapDetailMap();
            BaseLogger.log("3", userInfo, null, "Sheet Detail Map : " + sheetMapDetailMap);
            HashMap<Integer, LinkedHashMap<String, String>> sheetSrcTargetColumnMap = TemplateDetails.get(templateKey).getFormWiseTargetCol();
            BaseLogger.log("3", userInfo, null, "sheet Src Target Column Map : " + sheetSrcTargetColumnMap);
            HashMap<Integer, LinkedHashMap<String, String>> sheetMappingLogicMap = TemplateDetails.get(templateKey).getFormWiseMapLogicData();
            BaseLogger.log("3", userInfo, null, "sheet Mapping Logic Map : " + sheetMappingLogicMap);
            LinkedHashMap<String, String> dataMap = null;
            if ("excel".equalsIgnoreCase(fileType)) {
                dataMap = this.buildExcelData(filePath, userInfo, sheetMapDetailMap, sheetSrcTargetColumnMap, sheetMappingLogicMap, sheetsUsed, templateKey);
            } else if ("xml".equalsIgnoreCase(fileType)) {
                dataMap = this.buildXmlData(filePath);
            } else {
                "csv".equalsIgnoreCase(fileType);
            }
            BaseLogger.log("3", userInfo, null, "dataMap : " + dataMap + "]");
            if (dataMap != null) {
                responseStr = !dataMap.containsKey("INPUT_DATA_ERR") ? this.createBatchLoadNProcess(this.objName, userInfo, request, response, filePath, templateKey, dataMap, fileType, tempName, sessionId) : dataMap.get("INPUT_DATA_ERR");
            }
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return responseStr;
    }

    private LinkedHashMap<String, String> buildExcelData(String excelFilePath, UserInfoBean userInfo, HashMap<Integer, HashMap<String, HashMap<String, String>>> sheetMapDetailMap, HashMap<Integer, LinkedHashMap<String, String>> sheetSrcTargetColumnMap, HashMap<Integer, LinkedHashMap<String, String>> sheetMappingLogicMap, ArrayList<Integer> sheetsUsed, String templateKey) throws ITMException {
        LinkedHashMap<String, String> detailDataMap = new LinkedHashMap<String, String>();
        LinkedHashMap<String, Integer> detailDomIdMap = new LinkedHashMap<String, Integer>();
        HashMap<String, Integer> matrixSheetColSpanMap = new HashMap<String, Integer>();
        try {
            Sheet sheet = null;
            String sheetName = "";
            ArrayList<String> parentPkNameList = TemplateDetails.get(this.objName).getPKFieldNameList("1");
            if (parentPkNameList == null) {
                detailDataMap.put("INPUT_DATA_ERR", this.genericUtility.getErrorString("", "INVTRANID", this.userId));
                return detailDataMap;
            }
            this.workbook = this.getWorkbook(excelFilePath);
            int n = 0;
            while (n < sheetsUsed.size()) {
                int tabNo = sheetsUsed.get(n);
                ArrayList<String> pkNameList = TemplateDetails.get(this.objName).getPKFieldNameList("" + tabNo);
                if (pkNameList == null) {
                    detailDataMap.put("INPUT_DATA_ERR", this.genericUtility.getErrorString("", "INVTRANID", this.userId));
                    return detailDataMap;
                }
                int detailDomId = 1;
                sheetName = TemplateDetails.get(templateKey).getSheetName(tabNo);
                if (sheetName.length() != 0 && (sheet = this.workbook.getSheet(sheetName)) != null) {
                    int noOfColumns = sheet.getColumns();
                    int noOfRows = sheet.getRows();
                    int headingRowNo = TemplateDetails.get(templateKey).getHeadingRowNo(tabNo);
                    int matrixRowNo = TemplateDetails.get(templateKey).getMatrixRowNo(tabNo);
                    int startMatrixColNo = TemplateDetails.get(templateKey).getStartMatrixColNo(tabNo);
                    int endMatrixColNo = TemplateDetails.get(templateKey).getEndMatrixColNo(tabNo);
                    if (endMatrixColNo == -1) {
                        endMatrixColNo = noOfColumns;
                    }
                    int startsFrom = TemplateDetails.get(templateKey).getDataStartsFrom(tabNo);
                    BaseLogger.log("3", userInfo, null, "headingRowNo [" + headingRowNo + "]");
                    BaseLogger.log("3", userInfo, null, "matrixRowNo [" + matrixRowNo + "]");
                    BaseLogger.log("3", userInfo, null, "startMatrixColNo [" + startMatrixColNo + "]");
                    BaseLogger.log("3", userInfo, null, "endMatrixColNo [" + endMatrixColNo + "]");
                    BaseLogger.log("3", userInfo, null, "startsFrom [" + startsFrom + "], noOfRows [" + noOfRows + "]");
                    if (headingRowNo > noOfRows) {
                        detailDataMap.put("INPUT_DATA_ERR", this.genericUtility.getErrorString("", "INVEXHDR", this.userId));
                        return detailDataMap;
                    }
                    if (startsFrom == -1 || startsFrom > noOfRows) {
                        detailDataMap.put("INPUT_DATA_ERR", this.genericUtility.getErrorString("", "INVDSF", this.userId));
                        return detailDataMap;
                    }
                    ArrayList<String> actualColList = TemplateDetails.get(templateKey).getActualColList(tabNo);
                    if (actualColList == null) {
                        actualColList = new ArrayList();
                    }
                    HashMap<String, String> dbColLogNameTypeMap = TemplateDetails.get(this.objName).getColumnTypeDB("" + tabNo);
                    HashMap<String, String> metaDataColLogNameTypeMap = TemplateDetails.get(this.objName).getColumnTypeMetaDeta("" + tabNo);
                    HashMap<String, Integer> colLogNameSizeMap = TemplateDetails.get(this.objName).getColumnSize("" + tabNo);
                    HashMap<String, String> fieldCaseValueMap = TemplateDetails.get(this.objName).getFieldCase("" + tabNo);
                    HashMap<String, HashMap<String, String>> dropDownColValueMap = TemplateDetails.get(this.objName).getDropDownColValueMap("" + tabNo);
                    HashMap<String, Integer> colLogNamePrecisionMap = TemplateDetails.get(this.objName).getColumnPrecision("" + tabNo);
                    int rowNo = startsFrom;
                    while (rowNo < noOfRows) {
                        if (!this.validateCell(sheet, rowNo, noOfColumns)) break;
                        String rowData = "";
                        LinkedHashMap<String, String> dataMap = null;
                        int colSpan = 0;
                        if (matrixRowNo >= 0) {
                            if (parentPkNameList.size() == 1) {
                                HashMap parentPkNameMap = sheetSrcTargetColumnMap.get(1);
                                String parentPkName = this.getTempPKVal(parentPkNameMap);
                                parentPkNameList.add(parentPkName);
                                parentPkNameList.add("Y");
                            }
                            if (pkNameList.size() == 1) {
                                HashMap pkNameMap = sheetSrcTargetColumnMap.get(tabNo);
                                String tempPkVal = this.getTempPKVal(pkNameMap);
                                pkNameList.add(tempPkVal);
                                pkNameList.add("Y");
                            }
                            HashMap<String, Object> matrixDetailMap = this.getMatrixDetailMap(sheet, matrixRowNo, startMatrixColNo, endMatrixColNo);
                            BaseLogger.log("3", userInfo, null, "matrixDetailMap [" + matrixDetailMap + "]");
                            TreeMap matrixColMap = (TreeMap)matrixDetailMap.get("MATRIX_COL_MAP");
                            BaseLogger.log("3", userInfo, null, "matrixColMap [" + matrixColMap + "]");
                            colSpan = (Integer)matrixDetailMap.get("COLSPAN");
                            matrixSheetColSpanMap.put(sheetName, colSpan);
                            BaseLogger.log("3", userInfo, null, "colSpan - [" + colSpan + "]");
                            for (Map.Entry matrixEntry : matrixColMap.entrySet()) {
                                int matrixStartFrom = (Integer)matrixEntry.getKey();
                                String matrixContentVal = (String)matrixEntry.getValue();
                                BaseLogger.log("3", userInfo, null, "matrixContentVal - [" + matrixContentVal + "]");
                                ArrayList<Integer> matrixColList = this.getMatrixColList(noOfColumns, startMatrixColNo, endMatrixColNo, matrixStartFrom, colSpan);
                                BaseLogger.log("3", userInfo, null, "columnList = " + matrixColList);
                                dataMap = this.buildDetailDataMap(sheet, tabNo, rowNo, actualColList, matrixColList, matrixContentVal, sheetMapDetailMap, sheetSrcTargetColumnMap, sheetMappingLogicMap, pkNameList, metaDataColLogNameTypeMap, dbColLogNameTypeMap, colLogNameSizeMap, parentPkNameList, dropDownColValueMap, fieldCaseValueMap, colLogNamePrecisionMap, colSpan);
                                if (dataMap == null) continue;
                                if (dataMap.containsKey("INPUT_DATA_ERR")) {
                                    detailDataMap.put("INPUT_DATA_ERR", this.genericUtility.getErrorString("", dataMap.get("INPUT_DATA_ERR"), "Invalid data!", ""));
                                    return detailDataMap;
                                }
                                String[] pkDetails = this.getPkDetails(dataMap, pkNameList, parentPkNameList);
                                String pkName = pkDetails[0];
                                String pkValue = pkDetails[1];
                                String parentPkValue = pkDetails[2];
                                if (pkNameList.contains("Y")) {
                                    String[] array1 = pkName.split("\\:");
                                    pkName = array1[0];
                                }
                                if (parentPkNameList.contains("Y")) {
                                    String[] array2 = pkValue.split("\\:");
                                    pkValue = array2[0];
                                }
                                String detailPkValue = String.valueOf(parentPkValue) + "~" + tabNo;
                                BaseLogger.log("3", userInfo, null, "detailPkValue [" + detailPkValue + "]");
                                if (detailDomIdMap.containsKey(detailPkValue)) {
                                    detailDomId = (Integer)detailDomIdMap.get(detailPkValue);
                                    ++detailDomId;
                                } else {
                                    detailDomId = 1;
                                }
                                detailDomIdMap.put(detailPkValue, detailDomId);
                                rowData = this.buildDetailData(dataMap, tabNo, pkValue, detailDomId, pkName);
                                if (tabNo == 1) {
                                    detailDataMap.put(parentPkValue, rowData);
                                    continue;
                                }
                                if (!detailDataMap.containsKey(parentPkValue)) continue;
                                StringBuffer dataBuff = new StringBuffer();
                                String existingData = detailDataMap.get(parentPkValue);
                                dataBuff.append(existingData).append(rowData);
                                detailDataMap.put(parentPkValue, dataBuff.toString());
                            }
                        } else {
                            dataMap = this.buildDetailDataMap(sheet, tabNo, rowNo, actualColList, null, null, sheetMapDetailMap, sheetSrcTargetColumnMap, sheetMappingLogicMap, pkNameList, metaDataColLogNameTypeMap, dbColLogNameTypeMap, colLogNameSizeMap, parentPkNameList, dropDownColValueMap, fieldCaseValueMap, colLogNamePrecisionMap, colSpan);
                            if (dataMap != null) {
                                if (dataMap.containsKey("INPUT_DATA_ERR")) {
                                    detailDataMap.put("INPUT_DATA_ERR", this.genericUtility.getErrorString("", dataMap.get("INPUT_DATA_ERR"), "Invalid data!", ""));
                                    return detailDataMap;
                                }
                                String[] pkDetails = this.getPkDetails(dataMap, pkNameList, parentPkNameList);
                                String pkName = pkDetails[0];
                                String pkValue = pkDetails[1];
                                String parentPkValue = pkDetails[2];
                                String detailPkValue = String.valueOf(parentPkValue) + "~" + tabNo;
                                BaseLogger.log("3", userInfo, null, "detailPkValue [" + detailPkValue + "]");
                                if (detailDomIdMap.containsKey(detailPkValue)) {
                                    detailDomId = (Integer)detailDomIdMap.get(detailPkValue);
                                    ++detailDomId;
                                } else {
                                    detailDomId = 1;
                                }
                                detailDomIdMap.put(detailPkValue, detailDomId);
                                rowData = this.buildDetailData(dataMap, tabNo, pkValue, detailDomId, pkName);
                                if (tabNo == 1) {
                                    detailDataMap.put(parentPkValue, rowData);
                                } else if (detailDataMap.containsKey(parentPkValue)) {
                                    StringBuffer dataBuff = new StringBuffer();
                                    String existingData = detailDataMap.get(parentPkValue);
                                    dataBuff.append(existingData).append(rowData);
                                    detailDataMap.put(parentPkValue, dataBuff.toString());
                                } else {
                                    for (Map.Entry<String, String> entry : detailDataMap.entrySet()) {
                                        String headerParentKey = entry.getKey();
                                        BaseLogger.log("3", userInfo, null, "headerParentKey :: ==> [" + headerParentKey + "]");
                                        String[] array3 = headerParentKey.split("\\:");
                                        String tempPkVal = array3[0];
                                        BaseLogger.log("3", userInfo, null, "tempPkVal : [" + tempPkVal + "]");
                                        if (!tempPkVal.equals(parentPkValue)) continue;
                                        StringBuffer dataBuff = new StringBuffer();
                                        String existingData = detailDataMap.get(headerParentKey);
                                        dataBuff.append(existingData).append(rowData);
                                        detailDataMap.put(headerParentKey, dataBuff.toString());
                                    }
                                }
                            }
                        }
                        ++rowNo;
                    }
                    BaseLogger.log("3", userInfo, null, "matrixSheetColSpanMap ::- [" + matrixSheetColSpanMap + "]");
                    TemplateDetails.get(templateKey).setMatrixColSpanMap(matrixSheetColSpanMap);
                }
                ++n;
            }
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return detailDataMap;
    }

    private boolean validateCell(Sheet sheet, int rowNo, int noOfCols) {
        boolean isValid = true;
        try {
            String columnData = "";
            int k = 0;
            while (k < noOfCols) {
                columnData = String.valueOf(columnData) + this.checkNull(sheet.getCell(k, rowNo).getContents());
                ++k;
            }
            if (columnData.length() == 0 || "END_OF_FILE".equalsIgnoreCase(columnData)) {
                isValid = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isValid;
    }

    private HashMap<String, Object> getMatrixDetailMap(Sheet sheet, int matrixRowNo, int startMatrixColNum, int endMatrixColNum) throws ITMException {
        HashMap<String, Object> matrixDetailMap = new HashMap<String, Object>();
        try {
            int noOfColumns = sheet.getColumns();
            int actualStartMatrixColNo = 0;
            int nextStartMatrixColNo = noOfColumns;
            Range[] range = sheet.getMergedCells();
            BaseLogger.log("3", null, null, "sheet.getMergedCells() [" + range.length + "]");
            TreeMap<Integer, String> matrixColMap = new TreeMap<Integer, String>();
            if (range.length == 0) {
                int sigleMatrixNo = startMatrixColNum;
                while (sigleMatrixNo <= endMatrixColNum) {
                    String colName = sheet.getCell(sigleMatrixNo, matrixRowNo).getContents();
                    matrixColMap.put(sigleMatrixNo, colName);
                    ++sigleMatrixNo;
                }
                BaseLogger.log("3", null, null, "matrixColMap  - [" + matrixColMap + "]");
            } else {
                int i = 0;
                while (i < range.length) {
                    BaseLogger.log("3", null, null, "i - [" + i + "]");
                    Cell cell = range[i].getTopLeft();
                    if (cell.getRow() == matrixRowNo) {
                        matrixColMap.put(cell.getColumn(), cell.getContents());
                    }
                    ++i;
                }
            }
            BaseLogger.log("3", null, null, "matrixMap [" + matrixColMap + "]");
            matrixDetailMap.put("MATRIX_COL_MAP", matrixColMap);
            int matrixCnt = 0;
            for (Map.Entry entry : matrixColMap.entrySet()) {
                if (matrixCnt == 0) {
                    actualStartMatrixColNo = (Integer)entry.getKey();
                } else if (matrixCnt == 1) {
                    nextStartMatrixColNo = (Integer)entry.getKey();
                    break;
                }
                ++matrixCnt;
            }
            BaseLogger.log("3", null, null, "nextStartMatrixColNo - [" + nextStartMatrixColNo + "], actualStartMatrixColNo - [" + actualStartMatrixColNo + "]");
            matrixDetailMap.put("ACTUAL_MATRIX_START_FROM", actualStartMatrixColNo);
            matrixDetailMap.put("NEXT_MATRIX_START_FROM", nextStartMatrixColNo);
            int colSpan = nextStartMatrixColNo - actualStartMatrixColNo;
            BaseLogger.log("3", null, null, "colSpan - [" + colSpan + "]");
            matrixDetailMap.put("COLSPAN", colSpan);
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return matrixDetailMap;
    }

    private ArrayList<Integer> getMatrixColList(int noOfColumns, int startMatrixColNo, int endMatrixColNo, int matrixStartFrom, int colSpan) {
        ArrayList<Integer> matrixColList = new ArrayList<Integer>();
        int colNo = 0;
        while (colNo < noOfColumns) {
            if (colNo < startMatrixColNo || colNo > endMatrixColNo) {
                matrixColList.add(colNo);
            } else if (colNo >= matrixStartFrom && colNo < matrixStartFrom + colSpan) {
                matrixColList.add(colNo);
            }
            ++colNo;
        }
        return matrixColList;
    }

    private String getExcelContent(Sheet sheet, int headingRowNo, int rowNo, String targetColName, ArrayList<Integer> matrixColList, String matrixColVal) throws ITMException {
        String contentData = "";
        try {
            int noOfColumns = sheet.getColumns();
            if (matrixColList != null) {
                if ("MatrixColumn".equalsIgnoreCase(targetColName)) {
                    contentData = matrixColVal;
                } else {
                    int i = 0;
                    while (i < noOfColumns) {
                        if (matrixColList != null && matrixColList.contains(i)) {
                            String colName = sheet.getCell(i, headingRowNo).getContents();
                            if ((colName = this.checkNull(colName).replaceAll(" ", "_")).equals(targetColName)) {
                                contentData = sheet.getCell(i, rowNo).getContents();
                            }
                        }
                        ++i;
                    }
                }
            } else {
                int i = 0;
                while (i < noOfColumns) {
                    String colName = sheet.getCell(i, headingRowNo).getContents();
                    if ((colName = this.checkNull(colName).replaceAll(" ", "_")).equals(targetColName)) {
                        contentData = sheet.getCell(i, rowNo).getContents();
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return contentData;
    }

    private String removeLastComma(String inputStr) {
        try {
            if (inputStr != null && inputStr.length() > 0 && inputStr.lastIndexOf(",") != -1) {
                inputStr = inputStr.substring(0, inputStr.length() - 1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return inputStr;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private LinkedHashMap<String, String> buildDetailDataMap(Sheet sheet, int formNo, int rowNo, ArrayList<String> actualColList, ArrayList<Integer> matrixColList, String matrixContentVal, HashMap<Integer, HashMap<String, HashMap<String, String>>> sheetMapDetailMap, HashMap<Integer, LinkedHashMap<String, String>> sheetSrcTargetColumnMap, HashMap<Integer, LinkedHashMap<String, String>> sheetMappingLogicMap, ArrayList<String> pkNameList, HashMap<String, String> metadataColLogNameTypeMap, HashMap<String, String> dbColLogNameTypeMap, HashMap<String, Integer> colLogNameSizeMap, ArrayList<String> parentPkNameList, HashMap<String, HashMap<String, String>> dropDownColValueMap, HashMap<String, String> fieldCaseValueMap, HashMap<String, Integer> colLogNamePrecisionMap, int colSpan) throws ITMException {
        LinkedHashMap<String, String> dataMap = new LinkedHashMap<String, String>();
        try {
            HashMap<String, HashMap<String, String>> innerMap = sheetMapDetailMap.get(formNo);
            HashMap srcTargetColumnMap = sheetSrcTargetColumnMap.get(formNo);
            HashMap mapLogicMap = sheetMappingLogicMap.get(formNo);
            int headingRowNo = TemplateDetails.get(this.templateKey).getHeadingRowNo(formNo);
            int colSpanCnt = 0;
            String rowData = "";
            String colName = "";
            String targetCol = "";
            int actualColListLen = actualColList.size();
            int colNo = 0;
            while (colNo < actualColListLen) {
                colName = actualColList.get(colNo);
                if (srcTargetColumnMap != null && srcTargetColumnMap.containsKey(colName)) {
                    targetCol = (String)srcTargetColumnMap.get(colName);
                    BaseLogger.log("3", null, null, "<====> target Colum Name : [" + targetCol + "]");
                    String excelContent = "";
                    HashMap<String, String> contentMap = innerMap.get(colName);
                    BaseLogger.log("3", null, null, "contentMap " + contentMap);
                    String mapLogic = (String)mapLogicMap.get(colName);
                    BaseLogger.log("3", null, null, "mapLogic [" + mapLogic + "]");
                    if ("R".equals(mapLogic)) {
                        String sqlInput = this.checkNull(contentMap.get("SQL_INPUT"));
                        BaseLogger.log("3", null, null, "sqlInput - [" + sqlInput + "]");
                        StringBuffer finalVal = new StringBuffer();
                        if (sqlInput.contains(",")) {
                            String[] sqlInputArray = sqlInput.split(",");
                            int cnt = 0;
                            while (cnt < sqlInputArray.length) {
                                String sqlInputArg = this.checkNull(sqlInputArray[cnt]);
                                String contentData = this.getExcelContent(sheet, headingRowNo, rowNo, sqlInputArg, matrixColList, matrixContentVal);
                                finalVal.append(contentData);
                                finalVal.append(",");
                                ++cnt;
                            }
                        } else {
                            String contentData = this.getExcelContent(sheet, headingRowNo, rowNo, sqlInput, matrixColList, matrixContentVal);
                            finalVal.append(contentData);
                            finalVal.append(",");
                        }
                        BaseLogger.log("3", null, null, "finalVal [" + finalVal + "]");
                        excelContent = this.checkNull(finalVal.toString());
                        excelContent = this.removeLastComma(excelContent);
                    } else {
                        excelContent = this.getExcelContent(sheet, headingRowNo, rowNo, targetCol, matrixColList, matrixContentVal);
                    }
                    BaseLogger.log("3", null, null, "excelContent: [" + excelContent + "]");
                    String finalContent = this.applyMapLogic(excelContent, contentMap, mapLogic, this.userInfo);
                    rowData = String.valueOf(rowData) + finalContent;
                    if (CommonConstants.UPLOAD_IGNORE_VALUES.trim().length() > 0 && finalContent.equalsIgnoreCase(CommonConstants.UPLOAD_IGNORE_VALUES)) {
                        if (matrixColList != null) {
                            if (colSpan > colSpanCnt) {
                                ++colSpanCnt;
                            }
                            if (colSpan == colSpanCnt) {
                                return null;
                            }
                        }
                    } else {
                        String errorDataStr = this.validateExcelInputData(colName, finalContent, metadataColLogNameTypeMap, dbColLogNameTypeMap, colLogNameSizeMap, dropDownColValueMap, colLogNamePrecisionMap);
                        if ((errorDataStr = this.checkNull(errorDataStr)).length() > 0) {
                            dataMap.put("INPUT_DATA_ERR", errorDataStr);
                            return dataMap;
                        }
                        if (finalContent != null && finalContent.length() > 0) {
                            finalContent = this.fieldCaseData(fieldCaseValueMap, colName, finalContent);
                        }
                        if ("line_no".equalsIgnoreCase(colName) || pkNameList.contains(colName)) {
                            finalContent = this.setCharFieldSpaces(dbColLogNameTypeMap, colLogNameSizeMap, colName, finalContent);
                        }
                        dataMap.put(colName, finalContent);
                    }
                }
                ++colNo;
            }
            if ((rowData = this.checkNull(rowData)).length() == 0) {
                return null;
            }
        }
        catch (ITMException e) {
            throw new ITMException(e);
        }
        return dataMap;
    }

    private String applyMapLogic(String excelContent, HashMap<String, String> dataMap, String mapLogic, UserInfoBean userInfo) throws ITMException {
        String respString;
        block10: {
            respString = "";
            try {
                if ("D".equals(mapLogic)) {
                    if ("".equals(excelContent)) {
                        excelContent = "~NOVALUE~";
                    }
                    BaseLogger.log("3", userInfo, null, "excelContent renamed = " + excelContent);
                    respString = dataMap.get(excelContent) != null && dataMap.get(excelContent).length() > 0 ? dataMap.get(excelContent) : excelContent;
                    break block10;
                }
                if ("R".equals(mapLogic)) {
                    respString = this.getSqlValue(dataMap.get("SQL"), excelContent);
                    break block10;
                }
                if ("S".equals(mapLogic)) {
                    if (this.checkNull(dataMap.get("START_FROM")).length() > 0 && this.checkNull(dataMap.get("UP_TO")).length() > 0) {
                        int startFrom = Integer.parseInt(dataMap.get("START_FROM"));
                        int upTo = Integer.parseInt(dataMap.get("UP_TO"));
                        BaseLogger.log("3", userInfo, null, " startFrom = " + startFrom);
                        BaseLogger.log("3", userInfo, null, " upTo = " + upTo);
                        try {
                            respString = excelContent.substring(startFrom, upTo);
                            break block10;
                        }
                        catch (Exception e) {
                            throw new ITMException(e);
                        }
                    }
                    respString = excelContent;
                    break block10;
                }
                if ("A".equals(mapLogic)) {
                    respString = excelContent;
                }
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
        BaseLogger.log("3", userInfo, null, "respString= " + respString);
        return respString;
    }

    private String getSqlValue(String sqlString, String sqlInput) throws ITMException {
        String respString = "";
        try {
            respString = this.getUploadFile().getSqlValue(sqlString, sqlInput, this.userInfo);
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return respString;
    }

    private String createBatchLoadNProcess(String objName, UserInfoBean userInfo, HttpServletRequest request, HttpServletResponse response, String excelFilePath, String templateKey, HashMap<String, String> detailDataMap, String fileType, String tempName, String sessionId) throws ITMException {
        String respString = "";
        try {
            String winName = "w_" + objName;
            String xtraParam = this.getXtraParams(userInfo);
            E12CreateBatchLoadEjb uBatchLoad = new E12CreateBatchLoadEjb();
            respString = uBatchLoad.createBatchLoad(detailDataMap, winName, "A", excelFilePath, xtraParam, userInfo, templateKey, fileType, tempName, sessionId);
            BaseLogger.log("3", userInfo, null, "respString : [" + respString + "]");
            uBatchLoad = null;
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return respString;
    }

    private String getXtraParams(UserInfoBean userInfo) throws Exception {
        String XTRA_PARAMS_SEPARATOR = "~~";
        StringBuffer xtraParamsBuff = new StringBuffer();
        xtraParamsBuff.append("loginCode=" + userInfo.getLoginCode());
        xtraParamsBuff.append("~~").append("loginEmpCode=" + userInfo.getEmpCode());
        xtraParamsBuff.append("~~").append("loginSiteCode=" + userInfo.getSiteCode());
        xtraParamsBuff.append("~~").append("entityCode=" + userInfo.getEntityCode());
        xtraParamsBuff.append("~~").append("profileId=" + userInfo.getProfileId());
        xtraParamsBuff.append("~~").append("userType=" + userInfo.getUserType());
        xtraParamsBuff.append("~~").append("runMode=I");
        xtraParamsBuff.append("~~").append("termId=" + userInfo.getRemoteHost());
        String chgTerm = userInfo.getRemoteHostName();
        if (chgTerm != null && chgTerm.length() > 15) {
            chgTerm = chgTerm.substring(0, 15);
        } else if (chgTerm == null || chgTerm.length() == 0) {
            chgTerm = userInfo.getRemoteHost();
        }
        xtraParamsBuff.append("~~").append("chgTerm=" + chgTerm);
        return xtraParamsBuff.toString();
    }

    private Set<String> getLogicalData(String mapLogic, int colNo, HttpServletRequest request) {
        HashSet<String> set;
        block21: {
            set = new HashSet<String>();
            try {
                String tempName;
                String filePath = this.checkNull(request.getParameter("excelFilePath"));
                BaseLogger.log("3", null, null, "filePath = " + filePath);
                String colName = this.checkNull(request.getParameter("colName"));
                BaseLogger.log("3", null, null, "colName = " + colName);
                this.objName = this.uploadBean.getObjName();
                if (request.getParameter("objName") != null) {
                    this.objName = request.getParameter("objName");
                    this.uploadBean.setObjName(this.objName);
                }
                if ("new_template".equalsIgnoreCase(tempName = this.uploadBean.getSelectedTemplate())) {
                    this.isNewTemplate = true;
                }
                this.templateKey = String.valueOf(this.objName) + "::" + tempName;
                BaseLogger.log("3", null, null, "templateKey = " + this.templateKey);
                String fileType = this.uploadBean.getFileType();
                BaseLogger.log("3", null, null, "fileType = " + fileType);
                int tabNo = this.uploadBean.getTabNo();
                if (request.getParameter("formNo") != null) {
                    tabNo = Integer.parseInt(request.getParameter("formNo"));
                }
                BaseLogger.log("3", null, null, "TAB No. :: " + tabNo);
                String tabName = this.uploadBean.getTabName();
                if (request.getParameter("sheetName") != null) {
                    tabName = request.getParameter("sheetName");
                }
                BaseLogger.log("3", null, null, "TAB NAME :: " + tabName);
                if ("D".equals(mapLogic) && "excel".equalsIgnoreCase(fileType)) {
                    this.workbook = this.getWorkbook(filePath);
                    BaseLogger.log("3", null, null, "sheetName [" + tabName + "]");
                    Sheet sheet = this.workbook.getSheet(tabName);
                    BaseLogger.log("3", null, null, "sheet [" + sheet + "]");
                    int noOfRows = sheet.getRows();
                    int noOfColumns = sheet.getColumns();
                    int headingRowNo = 0;
                    int startsFrom = 1;
                    if (!this.isNewTemplate()) {
                        headingRowNo = TemplateDetails.get(this.templateKey).getHeadingRowNo(tabNo);
                        startsFrom = TemplateDetails.get(this.templateKey).getDataStartsFrom(tabNo);
                    } else {
                        HashMap<String, Integer> matrixValueMap;
                        HashMap<Integer, HashMap<String, Integer>> matrixRowMap = this.uploadBean.getMatrixRowMap();
                        if (matrixRowMap != null && (matrixValueMap = matrixRowMap.get(tabNo)) != null) {
                            headingRowNo = matrixValueMap.get("HEADING_ROW");
                            startsFrom = matrixValueMap.get("DATA_STARTS_FROM_ROW");
                        }
                    }
                    BaseLogger.log("3", null, null, "headingRowNo - [" + headingRowNo + "]");
                    BaseLogger.log("3", null, null, "matrixRowNo - [" + startsFrom + "]");
                    if (startsFrom > noOfRows) {
                        startsFrom = 1;
                    }
                    BaseLogger.log("3", null, null, "startsFrom = [" + startsFrom + "] noOfRows = [" + noOfRows + "]");
                    int i = 0;
                    while (i < noOfColumns) {
                        String colsName = sheet.getCell(i, headingRowNo).getContents();
                        if (colName.equalsIgnoreCase(colsName = this.checkNull(colsName).replaceAll(" ", "_"))) {
                            colNo = i;
                        }
                        ++i;
                    }
                    i = startsFrom;
                    while (i < noOfRows) {
                        set.add(sheet.getCell(colNo, i).getContents());
                        ++i;
                    }
                    break block21;
                }
                if (!"D".equals(mapLogic) || !"xml".equalsIgnoreCase(fileType)) break block21;
                BaseLogger.log("3", null, null, "INSIDE XML MAP DATA ::: ");
                Document document = null;
                Node node = null;
                NodeList nodeList = null;
                Element element = null;
                File xmlFile = new File(filePath);
                DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                document = parser.parse(xmlFile);
                HashMap<Integer, String> tabMap = this.uploadBean.getSheetInfo();
                nodeList = document.getElementsByTagName("DETAIL");
                node = nodeList.item(0);
                String selectedNode = "";
                tabName = this.uploadBean.getTabName();
                if (tabName != null) {
                    selectedNode = tabMap.get(tabNo);
                    nodeList = node.getChildNodes();
                    int i = 0;
                    while (i < nodeList.getLength()) {
                        if (selectedNode.equalsIgnoreCase(nodeList.item(i).getNodeName())) {
                            element = (Element)nodeList.item(i);
                            break;
                        }
                        ++i;
                    }
                } else {
                    selectedNode = node.getNodeName();
                    nodeList = node.getChildNodes();
                    element = (Element)nodeList.item(0);
                }
                nodeList = element.getChildNodes();
                int length = nodeList.getLength();
                NodeList childNodeList = null;
                String nodeValue = "";
                int i = 0;
                while (i < length) {
                    node = nodeList.item(i);
                    childNodeList = node.getChildNodes();
                    int j = 0;
                    while (j < childNodeList.getLength()) {
                        if (j == colNo) {
                            node = childNodeList.item(j).getFirstChild();
                            nodeValue = node.getNodeValue();
                            set.add(nodeValue);
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        BaseLogger.log("3", null, null, "set = " + set);
        return set;
    }

    private String saveTemplate(HttpServletRequest request) throws ITMException {
        String returnStr = "";
        BufferedInputStream bfr = null;
        ByteArrayOutputStream bout = null;
        try {
            HashMap<Integer, LinkedHashMap<String, String>> mapLogicValueMap;
            String shareScope = this.getRequestParamValue("shareScope");
            String scopeValue = this.getRequestParamValue("SCOPE_VAL");
            String templateRightsChar = this.getRequestParamValue("RIGHT_CHAR");
            int noOfForms = this.getNoOfForms();
            BaseLogger.log("3", null, null, "noOfForms [" + noOfForms + "]");
            int noOfSheets = this.getNoOfSheet();
            BaseLogger.log("3", null, null, "noOfSheets [" + noOfSheets + "]");
            HashMap<Integer, HashMap<String, HashMap<String, String>>> defineValueAllMap = this.uploadBean.getAllFormDefineValueMap();
            BaseLogger.log("3", null, null, "defineValueAllMap [" + defineValueAllMap + "]");
            if (defineValueAllMap == null) {
                defineValueAllMap = new HashMap();
            }
            HashMap<Integer, LinkedHashMap<String, String>> actualColListMap = this.uploadBean.getActualColListMap();
            BaseLogger.log("3", null, null, "actualColListMap [" + actualColListMap + "]");
            if (actualColListMap == null) {
                actualColListMap = new HashMap();
            }
            if ((mapLogicValueMap = this.uploadBean.getMapLogicValueMap()) == null) {
                mapLogicValueMap = new HashMap();
            }
            LinkedHashMap<Object, Object> parsedLogicValue = new LinkedHashMap();
            LinkedHashMap<Object, Object> actualColMap = new LinkedHashMap();
            HashMap<Object, Object> defineValueMap = new HashMap();
            StringBuffer xmlString = new StringBuffer();
            xmlString.append("<TEMPLATE>");
            int formNum = 1;
            while (formNum <= noOfForms) {
                BaseLogger.log("3", null, null, "formNo [" + formNum + "]");
                if (mapLogicValueMap != null) {
                    parsedLogicValue = mapLogicValueMap.get(formNum);
                }
                BaseLogger.log("3", null, null, "parsedLogicValue ::: [" + parsedLogicValue + "]");
                actualColMap = actualColListMap.get(formNum);
                BaseLogger.log("3", null, null, "actualColMap ::: [" + actualColMap + "]");
                defineValueMap = defineValueAllMap.get(formNum);
                BaseLogger.log("3", null, null, "defineValueMap ::: [" + defineValueMap + "]");
                String colName = "";
                String targetCol = "";
                xmlString.append("<DETAIL" + formNum + ">");
                int rowCnt = 0;
                for (Map.Entry<Object, Object> entry : actualColMap.entrySet()) {
                    colName = (String)entry.getKey();
                    BaseLogger.log("3", null, null, "colName ::: [" + colName + "]");
                    targetCol = this.getRequestParamValue("targetCol" + rowCnt + "_" + formNum);
                    BaseLogger.log("3", null, null, "targetCol ::: [" + targetCol + "]");
                    if (targetCol.length() > 0 && !"none".equalsIgnoreCase(targetCol)) {
                        xmlString.append("<COLUMN>");
                        xmlString.append("<SRC_COL>" + colName + "</SRC_COL>");
                        String mapLogicVal = this.getRequestParamValue("mapLogic" + rowCnt + "_" + formNum);
                        BaseLogger.log("3", null, null, "mapLogicVal ::: [" + mapLogicVal + "]");
                        xmlString.append("<MAP_LOGIC TYPE = '" + mapLogicVal + "'>");
                        if ("D".equals(mapLogicVal)) {
                            if (defineValueMap.get("valueMap" + rowCnt) != null) {
                                HashMap valueMap = (HashMap)defineValueMap.get("valueMap" + rowCnt);
                                BaseLogger.log("3", null, null, "valueMap ::: [" + valueMap + "]");
                                for (String srcVal : valueMap.keySet()) {
                                    String replaceVal = (String)valueMap.get(srcVal);
                                    xmlString.append("<SRC_VAL KEY = '" + srcVal + "'><![CDATA[" + replaceVal + "]]>" + "</SRC_VAL>");
                                }
                            }
                        } else if ("R".equals(mapLogicVal)) {
                            String sql = (String)parsedLogicValue.get("SQL_" + colName);
                            String sqlInput = (String)parsedLogicValue.get("SQL_INPUT_" + colName);
                            BaseLogger.log("3", null, null, "sql - [" + sql + "], sqlInput - [" + sqlInput + "]");
                            xmlString.append("<SQL><![CDATA[" + sql + "]]></SQL>");
                            xmlString.append("<SQL_INPUT><![CDATA[" + sqlInput + "]]></SQL_INPUT>");
                        } else if ("S".equals(mapLogicVal)) {
                            String startFrom = (String)parsedLogicValue.get("START_FROM_" + colName);
                            String upTo = (String)parsedLogicValue.get("UP_TO_" + colName);
                            BaseLogger.log("3", null, null, "startFrom - [" + startFrom + "], upTo - [" + upTo + "]");
                            xmlString.append("<START_FROM><![CDATA[" + startFrom + "]]></START_FROM>");
                            xmlString.append("<UP_TO><![CDATA[" + upTo + "]]></UP_TO>");
                        }
                        xmlString.append("</MAP_LOGIC>");
                        xmlString.append("<TARGET_COL><![CDATA[" + targetCol + "]]></TARGET_COL>");
                        xmlString.append("</COLUMN>");
                    }
                    ++rowCnt;
                }
                xmlString.append("</DETAIL" + formNum + ">");
                ++formNum;
            }
            xmlString.append("</TEMPLATE>");
            BaseLogger.log("3", null, null, "CREATED TEMPLATE ::: " + xmlString);
            HashMap<Integer, String> excelSheetInfo = this.uploadBean.getExcelSheetInfo();
            StringBuffer mappingXml = new StringBuffer();
            mappingXml.append("<ROOT>");
            int formNum2 = 1;
            while (formNum2 <= noOfForms) {
                BaseLogger.log("3", null, null, "formNo [" + formNum2 + "]");
                mappingXml.append("<DETAIL" + formNum2 + ">");
                int sheetNo = Integer.parseInt(this.getRequestParamValue("sheetName" + formNum2));
                String sheetName = "";
                if (excelSheetInfo != null && excelSheetInfo.containsKey(sheetNo)) {
                    sheetName = excelSheetInfo.get(sheetNo);
                }
                if (this.getRequestParamValue("sheetName" + formNum2).length() > 0) {
                    sheetNo = Integer.parseInt(this.getRequestParamValue("sheetName" + formNum2));
                }
                sheetName = this.checkNull(excelSheetInfo.get(sheetNo));
                int colSpan = this.uploadBean.getMatrixColSpan(sheetName);
                mappingXml.append("<SHEETNAME><![CDATA[" + sheetName + "]]></SHEETNAME>");
                String headingRowNo = this.getRequestParamValue("headingRowNo" + formNum2);
                mappingXml.append("<HEADING_ROW><![CDATA[" + headingRowNo + "]]></HEADING_ROW>");
                String dataStartFrom = this.getRequestParamValue("dataStartFrom" + formNum2);
                mappingXml.append("<DATA_STARTS_FROM_ROW><![CDATA[" + dataStartFrom + "]]></DATA_STARTS_FROM_ROW>");
                String matrixRowNo = this.getRequestParamValue("matrixRowNo" + formNum2);
                mappingXml.append("<MATRIX_HEADER_ROW><![CDATA[" + matrixRowNo + "]]></MATRIX_HEADER_ROW>");
                String startMatrixColNo = this.getRequestParamValue("startMatrixColNo" + formNum2);
                mappingXml.append("<MATRIX_START_COL><![CDATA[" + startMatrixColNo + "]]></MATRIX_START_COL>");
                String endMatrixColNo = this.getRequestParamValue("endMatrixColNo" + formNum2);
                mappingXml.append("<MATRIX_END_COL><![CDATA[" + endMatrixColNo + "]]></MATRIX_END_COL>");
                mappingXml.append("<COL_SPAN><![CDATA[" + colSpan + "]]></COL_SPAN>");
                mappingXml.append("</DETAIL" + formNum2 + ">");
                ++formNum2;
            }
            mappingXml.append("</ROOT>");
            BaseLogger.log("3", null, null, "Mapping xml ::: " + mappingXml);
            String tempName = this.getRequestParamValue("existingTemplate");
            String isDefaultTemplate = this.getRequestParamValue("isDefault");
            String isAutoConfirm = this.getRequestParamValue("isAutoConfirm");
            BaseLogger.log("3", null, null, "isAutoConfirm : [" + isAutoConfirm + "]");
            String templateId = "";
            BaseLogger.log("3", this.userInfo, null, " isNewTemplate=[" + this.isNewTemplate() + "]");
            if (!this.isNewTemplate()) {
                templateId = this.checkNull(TemplateDetails.get(this.objName).getTemplateId(tempName));
            } else {
                tempName = this.getRequestParamValue("newTemplateName");
                this.uploadBean.setSelectedTemplate(tempName);
                BaseLogger.log("3", null, null, "tempName : [" + tempName + "]");
                boolean templetErrorMsg = this.getUploadFile().checkExistingTempName(this.objName, tempName, this.getUserInfo());
                BaseLogger.log("3", null, null, "tempErroMsg : [" + templetErrorMsg + "]");
                if (templetErrorMsg) {
                    String string = returnStr = this.genericUtility.getErrorString("", "VTEMPNAME", this.userId);
                    return string;
                }
            }
            try {
                File file;
                String filePath = this.uploadBean.getUploadFilepath();
                BaseLogger.log("3", this.userInfo, null, "filePath : [" + filePath + "]");
                byte[] byteArray = null;
                String fileName = "";
                if (filePath != null && filePath.length() > 0 && (file = new File(filePath)).exists()) {
                    fileName = file.getName();
                    FileInputStream input = new FileInputStream(file);
                    bfr = new BufferedInputStream(input);
                    bout = new ByteArrayOutputStream();
                    int j = -1;
                    while ((j = bfr.read()) != -1) {
                        bout.write(j);
                    }
                    byteArray = bout.toByteArray();
                    input.close();
                    input = null;
                }
                returnStr = this.getUploadFile().saveTemplate(templateId, this.objName, tempName, xmlString.toString(), isDefaultTemplate, mappingXml.toString(), shareScope, scopeValue, templateRightsChar, fileName, byteArray, filePath, isAutoConfirm, this.getUserInfo());
                if (filePath != null && filePath.length() > 0 && (file = new File(filePath)).exists()) {
                    file.delete();
                }
                BaseLogger.log("3", null, null, "returnStr ::: " + returnStr);
                if (returnStr.indexOf("Success") != -1) {
                    boolean isDefault;
                    this.templateKey = String.valueOf(this.objName) + "::" + tempName;
                    this.isNewTemplate = false;
                    String caller = this.uploadBean.getCaller();
                    HashMap<String, HashMap<String, String>> templateMap = this.getUploadFile().getTemplateDetail(this.objName, caller, this.userInfo);
                    this.uploadBean.setTemplateMap(templateMap);
                    TemplateDetails.get(this.objName).setTemplateMap(templateMap);
                    String defaultTemplate = TemplateDetails.get(this.objName).getDefaultTemplate();
                    this.uploadBean.setDefaultTemplate(defaultTemplate);
                    String templateXml = TemplateDetails.get(this.objName).getTemplateXml(tempName);
                    String fileMappingXml = TemplateDetails.get(this.objName).getFileMapping(tempName);
                    int totalForms = this.getNoOfForms();
                    TemplateDetails.get(this.templateKey).createTemplateDetail(templateXml, totalForms);
                    BaseLogger.log("3", this.userInfo, null, "excelSheetInfo=[" + excelSheetInfo + "]");
                    BaseLogger.log("3", this.userInfo, null, "fileMappingXml=[" + fileMappingXml + "]");
                    if ("json".equalsIgnoreCase(this.uploadBean.getFileType())) {
                        this.uploadBean.setSheetInfo(excelSheetInfo);
                    } else if ("xml".equalsIgnoreCase(this.uploadBean.getFileType())) {
                        System.out.println("Got file type xml in save template");
                        this.uploadBean.setSheetInfo(excelSheetInfo);
                    } else {
                        TemplateDetails.get(this.templateKey).createFileMappingDetail(fileMappingXml);
                    }
                    shareScope = TemplateDetails.get(this.objName).getShareScope(tempName);
                    this.uploadBean.setShareScope(shareScope);
                    scopeValue = TemplateDetails.get(this.objName).getScopeValue(tempName);
                    this.uploadBean.setScopeValue(scopeValue);
                    String tempRightsChar = TemplateDetails.get(this.objName).getTempRightsChar(tempName);
                    this.uploadBean.setTempRightsChar(tempRightsChar);
                    String excelFilePath = this.uploadBean.getFilePath();
                    if (excelFilePath != null) {
                        BaseLogger.log("3", null, null, "Filetype :: [" + this.uploadBean.getFileType() + "]");
                        if ("json".equalsIgnoreCase(this.uploadBean.getFileType())) {
                            this.createJsonColumnMap(excelFilePath, request);
                        } else if ("xml".equalsIgnoreCase(this.uploadBean.getFileType())) {
                            System.out.println("Creating xml columnMap");
                            this.createXmlColumnMap(excelFilePath, request);
                        } else {
                            if (this.workbook == null) {
                                this.getWorkbook(excelFilePath);
                            }
                            this.createExcelColumnMap(excelFilePath, request);
                        }
                    }
                    if (isDefault = TemplateDetails.get(this.objName).isDefaultTemplate(tempName)) {
                        this.uploadBean.setIsDefaultTemp("Y");
                    } else {
                        this.uploadBean.setIsDefaultTemp("N");
                    }
                    boolean autoConfirm = TemplateDetails.get(this.objName).isAutoConfirm(tempName);
                    if (autoConfirm) {
                        this.uploadBean.setAutoConfirm("Y");
                    } else {
                        this.uploadBean.setAutoConfirm("N");
                    }
                }
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (bfr != null) {
                    bfr.close();
                    bfr = null;
                }
                if (bout != null) {
                    bout.close();
                    bout = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return returnStr;
    }

    private String validateXmlInputData() throws ITMException {
        String retStr;
        block25: {
            retStr = "<Root><Detail>Success</Detail></Root>";
            try {
                String sheetName = "";
                int sheetNo = 0;
                Node rootNode = null;
                HashMap<Integer, String> excelSheetsInfo = this.uploadBean.getExcelSheetInfo();
                BaseLogger.log("3", null, null, "excelSheetInfo - [" + excelSheetsInfo + "]");
                TreeMap<Integer, String> formDetailInfo = this.uploadBean.getFormDetailInfo();
                if (formDetailInfo == null) {
                    formDetailInfo = new TreeMap();
                }
                String excelFilePath = this.uploadBean.getFilePath();
                BaseLogger.log("3", this.userInfo, null, "xmlFilePath - [" + excelFilePath + "]");
                BaseLogger.log("3", this.userInfo, null, " validateXML file formDetailInfo - [" + formDetailInfo + "]");
                rootNode = this.getRootNode(excelFilePath);
                BaseLogger.log("3", this.userInfo, null, "xml root node - [" + rootNode.getNodeName() + "]");
                int formNo = Integer.parseInt(this.getRequestParamValue("formNo"));
                BaseLogger.log("3", this.userInfo, null, "formNo - [" + formNo + "]");
                sheetNo = Integer.parseInt(this.getRequestParamValue("sheetName" + formNo));
                BaseLogger.log("3", this.userInfo, null, "sheetName - [" + sheetName + "]");
                String formName = formDetailInfo.get(formNo);
                BaseLogger.log("3", this.userInfo, null, "formName - [" + formName + "]");
                sheetName = excelSheetsInfo.get(sheetNo);
                BaseLogger.log("3", null, null, "sheetName 11 - [" + sheetName + "]");
                sheetName = "Detail" + sheetNo;
                NodeList childNodeList = rootNode.getChildNodes();
                Node childNode = null;
                ArrayList<Node> detailNodeList = new ArrayList<Node>();
                int i = 0;
                while (i < childNodeList.getLength()) {
                    BaseLogger.log("3", this.userInfo, null, "Node Name - [" + childNodeList.item(i).getNodeName() + "]");
                    if (childNodeList.item(i).getNodeName().equalsIgnoreCase(sheetName)) {
                        System.out.println("Got matched Child Node Name=" + sheetName);
                        childNode = childNodeList.item(i);
                        detailNodeList.add(childNodeList.item(i));
                    }
                    ++i;
                }
                BaseLogger.log("3", this.userInfo, null, "node Name - [" + childNode.getNodeName() + "]");
                detailNodeList.stream().forEach(e -> System.out.println("node name in list[" + e.getNodeName()));
                int noOfRows = 0;
                noOfRows = detailNodeList.size();
                NodeList childNodeNodeList = childNode.getChildNodes();
                Node childDataNode = null;
                ArrayList<Node> actualChildNodeList = new ArrayList<Node>();
                int i2 = 0;
                while (i2 < childNodeNodeList.getLength()) {
                    if (!childNodeNodeList.item(i2).getNodeName().contains("#")) {
                        System.out.println("Got Child Node=<" + childNodeNodeList.item(i2).getNodeName());
                        if (childDataNode == null) {
                            childDataNode = childNodeNodeList.item(i2);
                        }
                        actualChildNodeList.add(childNodeNodeList.item(i2));
                    }
                    ++i2;
                }
                childDataNode = childNode;
                System.out.println("Got childDataNode Name=" + childDataNode.getNodeName());
                System.out.println("Got actualChildNodeList Name=" + actualChildNodeList);
                BaseLogger.log("3", this.userInfo, null, "node no of rows - [" + noOfRows + "]");
                int noOfColumns = 0;
                NodeList childNodeDataNodeList = childDataNode.getChildNodes();
                int i3 = 0;
                while (i3 < childNodeDataNodeList.getLength()) {
                    if (!childNodeDataNodeList.item(i3).getNodeName().contains("#")) {
                        ++noOfColumns;
                    }
                    ++i3;
                }
                BaseLogger.log("3", this.userInfo, null, "noOfColumns - [" + noOfColumns + "]");
                BaseLogger.log("3", this.userInfo, null, "noOfRows - [" + noOfRows + "]");
                int headingRowNum = 1;
                int matrixRowNum = -1;
                int startMatrixColNum = -1;
                int endMatrixColNum = -1;
                int dataStartsFrom = 2;
                if (this.getRequestParamValue("dataStartFrom" + formNo).length() > 0) {
                    dataStartsFrom = Integer.parseInt(this.getRequestParamValue("dataStartFrom" + formNo));
                    BaseLogger.log("3", this.userInfo, null, "dataStartsFrom - [" + dataStartsFrom + "]");
                }
                --dataStartsFrom;
                if (this.getRequestParamValue("headingRowNo" + formNo).length() > 0) {
                    headingRowNum = Integer.parseInt(this.getRequestParamValue("headingRowNo" + formNo));
                    BaseLogger.log("3", this.userInfo, null, "headingRowNum - [" + --headingRowNum + "]");
                }
                if (this.getRequestParamValue("matrixRowNo" + formNo).length() > 0) {
                    matrixRowNum = Integer.parseInt(this.getRequestParamValue("matrixRowNo" + formNo));
                    BaseLogger.log("3", this.userInfo, null, "matrixRowNum - [" + matrixRowNum + "]");
                    --matrixRowNum;
                }
                if (this.getRequestParamValue("startMatrixColNo" + formNo).length() > 0) {
                    startMatrixColNum = Integer.parseInt(this.getRequestParamValue("startMatrixColNo" + formNo));
                    BaseLogger.log("3", this.userInfo, null, "startMatrixColNum - [" + startMatrixColNum + "]");
                    --startMatrixColNum;
                }
                if (this.getRequestParamValue("endMatrixColNo" + formNo).length() > 0) {
                    endMatrixColNum = Integer.parseInt(this.getRequestParamValue("endMatrixColNo" + formNo));
                    BaseLogger.log("3", this.userInfo, null, "endMatrixColNum - [" + endMatrixColNum + "]");
                    --endMatrixColNum;
                }
                if (matrixRowNum != -1 && endMatrixColNum == -1) {
                    endMatrixColNum = noOfColumns;
                }
                BaseLogger.log("3", null, null, "Form [" + formNo + "],xml dataStartsFrom - [" + dataStartsFrom + "]");
                BaseLogger.log("3", null, null, "Form [" + formNo + "],xml headingRowNo - [" + headingRowNum + "]");
                BaseLogger.log("3", null, null, "Form [" + formNo + "],xml matrixRowNo - [" + matrixRowNum + "]");
                BaseLogger.log("3", null, null, "Form [" + formNo + "],xml startMatrixColNum - [" + startMatrixColNum + "]");
                BaseLogger.log("3", null, null, "Form [" + formNo + "],xml endMatrixColNum - [" + endMatrixColNum + "]");
                if (dataStartsFrom > 0) {
                    --dataStartsFrom;
                }
                dataStartsFrom = 0;
                String rowdata = "";
                if (noOfRows >= dataStartsFrom) {
                    try {
                        int i4 = dataStartsFrom;
                        while (i4 < actualChildNodeList.size()) {
                            String data = "";
                            if (!((Node)actualChildNodeList.get(i4)).getNodeName().contains("#")) {
                                Node rowNode = (Node)actualChildNodeList.get(i4);
                                System.out.println("Data node Name" + ((Node)actualChildNodeList.get(i4)).getNodeName());
                                data = rowNode.getFirstChild() != null ? rowNode.getFirstChild().getTextContent() : "";
                                rowdata = String.valueOf(rowdata) + this.checkNull(data);
                                data = "";
                                NodeList rowChildNodeList = rowNode.getChildNodes();
                                if (rowdata.length() == 0) {
                                    retStr = this.genericUtility.getErrorString("", "INVDSF", this.userId);
                                }
                                if (retStr.indexOf("<Errors>") == -1 && headingRowNum != -1) {
                                    NodeList headingNodeList = rowChildNodeList.item(0).getChildNodes();
                                    rowdata = this.checkNull(rowdata);
                                }
                            }
                            ++i4;
                        }
                        BaseLogger.log("3", null, null, "rowdata = [" + rowdata + "]");
                        if (rowdata.length() == 0) {
                            retStr = this.genericUtility.getErrorString("", "INVEXHDR", this.userId);
                        }
                        break block25;
                    }
                    catch (Exception e2) {
                        BaseLogger.log("3", this.userInfo, null, "Exception [" + e2.getMessage() + "]");
                    }
                    break block25;
                }
                retStr = this.genericUtility.getErrorString("", "INVDSF", this.userId);
            }
            catch (Exception e3) {
                BaseLogger.log("0", this.userInfo, null, "Exception in validateInputData - [" + e3.getMessage() + "]");
                throw new ITMException(e3);
            }
        }
        BaseLogger.log("2", this.userInfo, null, "xml validateXmlInputData= retStr - [" + retStr + "]");
        return retStr;
    }

    private String validateInputData() throws ITMException {
        String retStr;
        block27: {
            retStr = "<Root><Detail>Success</Detail></Root>";
            try {
                String sheetName = "";
                int sheetNo = 0;
                HashMap<Integer, String> excelSheetsInfo = this.uploadBean.getExcelSheetInfo();
                BaseLogger.log("3", null, null, "excelSheetInfo - [" + excelSheetsInfo + "]");
                TreeMap<Integer, String> formDetailInfo = this.uploadBean.getFormDetailInfo();
                if (formDetailInfo == null) {
                    formDetailInfo = new TreeMap();
                }
                String excelFilePath = this.uploadBean.getFilePath();
                BaseLogger.log("3", null, null, "excelFilePath - [" + excelFilePath + "]");
                this.workbook = this.getWorkbook(excelFilePath);
                BaseLogger.log("3", null, null, "workbook - [" + this.workbook + "]");
                int formNo = Integer.parseInt(this.getRequestParamValue("formNo"));
                BaseLogger.log("3", null, null, "formNo - [" + formNo + "]");
                sheetNo = Integer.parseInt(this.getRequestParamValue("sheetName" + formNo));
                BaseLogger.log("3", null, null, "sheetName - [" + sheetName + "]");
                String formName = formDetailInfo.get(formNo);
                BaseLogger.log("3", null, null, "formName - [" + formName + "]");
                sheetName = excelSheetsInfo.get(sheetNo);
                BaseLogger.log("3", null, null, "sheetName 11 - [" + sheetName + "]");
                Sheet sheet = this.workbook.getSheet(sheetName);
                BaseLogger.log("3", null, null, "sheet - [" + sheet + "]");
                int noOfRows = sheet.getRows();
                BaseLogger.log("3", null, null, "noOfRows - [" + noOfRows + "]");
                int noOfColumns = sheet.getColumns();
                BaseLogger.log("3", null, null, "noOfColumns - [" + noOfColumns + "]");
                int headingRowNum = 1;
                int matrixRowNum = -1;
                int startMatrixColNum = -1;
                int endMatrixColNum = -1;
                int dataStartsFrom = 2;
                if (this.getRequestParamValue("dataStartFrom" + formNo).length() > 0) {
                    dataStartsFrom = Integer.parseInt(this.getRequestParamValue("dataStartFrom" + formNo));
                    BaseLogger.log("3", null, null, "dataStartsFrom - [" + dataStartsFrom + "]");
                }
                --dataStartsFrom;
                if (this.getRequestParamValue("headingRowNo" + formNo).length() > 0) {
                    headingRowNum = Integer.parseInt(this.getRequestParamValue("headingRowNo" + formNo));
                    BaseLogger.log("3", null, null, "headingRowNum - [" + --headingRowNum + "]");
                }
                if (this.getRequestParamValue("matrixRowNo" + formNo).length() > 0) {
                    matrixRowNum = Integer.parseInt(this.getRequestParamValue("matrixRowNo" + formNo));
                    BaseLogger.log("3", null, null, "matrixRowNum - [" + matrixRowNum + "]");
                    --matrixRowNum;
                }
                if (this.getRequestParamValue("startMatrixColNo" + formNo).length() > 0) {
                    startMatrixColNum = Integer.parseInt(this.getRequestParamValue("startMatrixColNo" + formNo));
                    BaseLogger.log("3", null, null, "startMatrixColNum - [" + startMatrixColNum + "]");
                    --startMatrixColNum;
                }
                if (this.getRequestParamValue("endMatrixColNo" + formNo).length() > 0) {
                    endMatrixColNum = Integer.parseInt(this.getRequestParamValue("endMatrixColNo" + formNo));
                    BaseLogger.log("3", null, null, "endMatrixColNum - [" + endMatrixColNum + "]");
                    --endMatrixColNum;
                }
                if (matrixRowNum != -1 && endMatrixColNum == -1) {
                    endMatrixColNum = noOfColumns;
                }
                BaseLogger.log("3", null, null, "Form [" + formNo + "], dataStartsFrom - [" + dataStartsFrom + "]");
                BaseLogger.log("3", null, null, "Form [" + formNo + "], headingRowNo - [" + headingRowNum + "]");
                BaseLogger.log("3", null, null, "Form [" + formNo + "], matrixRowNo - [" + matrixRowNum + "]");
                BaseLogger.log("3", null, null, "Form [" + formNo + "], startMatrixColNum - [" + startMatrixColNum + "]");
                BaseLogger.log("3", null, null, "Form [" + formNo + "], endMatrixColNum - [" + endMatrixColNum + "]");
                String rowdata = "";
                if (noOfRows >= dataStartsFrom) {
                    try {
                        int j = 0;
                        while (j < noOfColumns) {
                            rowdata = String.valueOf(rowdata) + this.checkNull(sheet.getCell(j, dataStartsFrom).getContents());
                            ++j;
                        }
                        BaseLogger.log("3", null, null, "rowdata = [" + rowdata + "]");
                        if (rowdata.length() == 0) {
                            retStr = this.genericUtility.getErrorString("", "INVDSF", this.userId);
                        }
                        if (retStr.indexOf("<Errors>") == -1 && headingRowNum != -1) {
                            rowdata = this.checkNull(sheet.getCell(0, headingRowNum).getContents());
                            BaseLogger.log("3", null, null, "rowdata = [" + rowdata + "]");
                            if (rowdata.length() == 0) {
                                retStr = this.genericUtility.getErrorString("", "INVEXHDR", this.userId);
                            }
                        }
                        if (retStr.indexOf("<Errors>") != -1 || matrixRowNum < 0) break block27;
                        HashMap<String, Object> matrixDetailMap = this.getMatrixDetailMap(sheet, matrixRowNum, startMatrixColNum, endMatrixColNum);
                        BaseLogger.log("3", null, null, "matrixMap [" + matrixDetailMap + "]");
                        int actualStartMatrixColNo = (Integer)matrixDetailMap.get("ACTUAL_MATRIX_START_FROM");
                        BaseLogger.log("3", null, null, "actualStartMatrixColNo - [" + actualStartMatrixColNo + "]");
                        if (startMatrixColNum != actualStartMatrixColNo) {
                            retStr = this.genericUtility.getErrorString("", "INVSTMCOL", this.userId);
                            break block27;
                        }
                        int colSpan = (Integer)matrixDetailMap.get("COLSPAN");
                        BaseLogger.log("3", null, null, "colSpan - [" + colSpan + "]");
                        int nextStartMatrixColNo = (Integer)matrixDetailMap.get("NEXT_MATRIX_START_FROM");
                        BaseLogger.log("3", null, null, "nextStartMatrixColNo - [" + nextStartMatrixColNo + "]");
                        ArrayList<String> matrixSubColList = new ArrayList<String>();
                        int j2 = actualStartMatrixColNo;
                        while (j2 < nextStartMatrixColNo) {
                            String colVal = sheet.getCell(j2, headingRowNum).getContents();
                            matrixSubColList.add(colVal);
                            ++j2;
                        }
                        BaseLogger.log("3", null, null, "matrixSubColList - " + matrixSubColList);
                        int loopCnt = 0;
                        int prevStartMatrixColNo = nextStartMatrixColNo;
                        TreeMap matrixColMap = (TreeMap)matrixDetailMap.get("MATRIX_COL_MAP");
                        BaseLogger.log("3", null, null, "matrixColMap - " + matrixColMap);
                        int matrixColSize = matrixColMap.size();
                        BaseLogger.log("3", null, null, "matrixColSize - " + matrixColSize);
                        for (Map.Entry matrixEntry : matrixColMap.entrySet()) {
                            int currentStartFromColNo = (Integer)matrixEntry.getKey();
                            BaseLogger.log("3", null, null, "loopCnt - [" + loopCnt + "], currentStartFromColNo - [" + currentStartFromColNo + "], prevStartMatrixColNo - [" + prevStartMatrixColNo + "]");
                            if (loopCnt >= 1) {
                                if (matrixColSize == loopCnt + 1) {
                                    if (endMatrixColNum + 1 - currentStartFromColNo != colSpan) {
                                        retStr = this.genericUtility.getErrorString("", "INVMSUBHDR", this.userId);
                                        break block27;
                                    }
                                } else {
                                    if (currentStartFromColNo - prevStartMatrixColNo != colSpan) {
                                        retStr = this.genericUtility.getErrorString("", "INVMSUBHDR", this.userId);
                                        break block27;
                                    }
                                    int j3 = prevStartMatrixColNo;
                                    while (j3 < currentStartFromColNo) {
                                        String colVal = sheet.getCell(j3, headingRowNum).getContents();
                                        if (!matrixSubColList.contains(colVal)) {
                                            retStr = this.genericUtility.getErrorString("", "INVHDRCONT", this.userId);
                                            break block27;
                                        }
                                        ++j3;
                                    }
                                    prevStartMatrixColNo = currentStartFromColNo;
                                }
                            } else {
                                prevStartMatrixColNo = currentStartFromColNo;
                            }
                            ++loopCnt;
                        }
                        break block27;
                    }
                    catch (Exception e) {
                        BaseLogger.log("0", null, null, "exception = [" + e.getMessage() + "]");
                        retStr = this.genericUtility.getErrorString("", "INVEXCONT", this.userId);
                        e.printStackTrace();
                    }
                    break block27;
                }
                retStr = this.genericUtility.getErrorString("", "INVDSF", this.userId);
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception in validateInputData - [" + e.getMessage() + "]");
                throw new ITMException(e);
            }
        }
        BaseLogger.log("2", null, null, "retStr - [" + retStr + "]");
        return retStr;
    }

    private String setTemplateData() throws ITMException {
        int formNo;
        HashMap<String, Integer> matrixValueMap;
        HashMap<Integer, String> sheetInfoMap;
        String retStr = "<Root><Detail>Success</Detail></Root>";
        HashMap<Integer, HashMap<String, Integer>> matrixRowMap = this.uploadBean.getMatrixRowMap();
        HashMap<String, Integer> matrixSheetColSpanMap = new HashMap<String, Integer>();
        if (matrixRowMap == null) {
            matrixRowMap = new HashMap();
        }
        if ((sheetInfoMap = this.uploadBean.getSheetInfo()) == null) {
            sheetInfoMap = new HashMap();
        }
        if ((matrixValueMap = matrixRowMap.get(formNo = Integer.parseInt(this.getRequestParamValue("formNo")))) == null) {
            matrixValueMap = new HashMap();
        }
        int headingRowNum = 1;
        int matrixRowNum = -1;
        int startMatrixColNum = -1;
        int endMatrixColNum = -1;
        int dataStartsFrom = 2;
        if (this.getRequestParamValue("dataStartFrom" + formNo).length() > 0) {
            dataStartsFrom = Integer.parseInt(this.getRequestParamValue("dataStartFrom" + formNo));
        }
        --dataStartsFrom;
        if (this.getRequestParamValue("headingRowNo" + formNo).length() > 0) {
            headingRowNum = Integer.parseInt(this.getRequestParamValue("headingRowNo" + formNo));
            --headingRowNum;
        }
        if (this.getRequestParamValue("matrixRowNo" + formNo).length() > 0) {
            matrixRowNum = Integer.parseInt(this.getRequestParamValue("matrixRowNo" + formNo));
            --matrixRowNum;
        }
        if (this.getRequestParamValue("startMatrixColNo" + formNo).length() > 0) {
            startMatrixColNum = Integer.parseInt(this.getRequestParamValue("startMatrixColNo" + formNo));
            --startMatrixColNum;
        }
        if (this.getRequestParamValue("endMatrixColNo" + formNo).length() > 0) {
            endMatrixColNum = Integer.parseInt(this.getRequestParamValue("endMatrixColNo" + formNo));
            --endMatrixColNum;
        }
        matrixValueMap.put("HEADING_ROW", headingRowNum);
        matrixValueMap.put("MATRIX_HEADER_ROW", matrixRowNum);
        matrixValueMap.put("MATRIX_START_COL", startMatrixColNum);
        matrixValueMap.put("MATRIX_END_COL", endMatrixColNum);
        matrixValueMap.put("DATA_STARTS_FROM_ROW", dataStartsFrom);
        matrixRowMap.put(formNo, matrixValueMap);
        this.uploadBean.setMatrixRowMap(matrixRowMap);
        BaseLogger.log("3", null, null, "matrixRowMap - [" + matrixRowMap + "]");
        HashMap<Integer, String> excelSheetInfo = this.uploadBean.getExcelSheetInfo();
        int sheetNo = Integer.parseInt(this.getRequestParamValue("sheetName" + formNo));
        BaseLogger.log("3", null, null, "sheetNo - [" + sheetNo + "]");
        String sheetName = "";
        Sheet sheet = null;
        if (excelSheetInfo != null && excelSheetInfo.containsKey(sheetNo)) {
            sheetName = excelSheetInfo.get(sheetNo);
        }
        sheetInfoMap.put(formNo, sheetName);
        this.uploadBean.setSheetInfo(sheetInfoMap);
        BaseLogger.log("3", null, null, "sheetInfoMap - [" + sheetInfoMap + "]");
        String shareScope = this.getRequestParamValue("shareScope");
        this.uploadBean.setShareScope(shareScope);
        String scopeValue = this.getRequestParamValue("SCOPE_VAL");
        this.uploadBean.setScopeValue(scopeValue);
        String tempRightsChar = this.getRequestParamValue("RIGHT_CHAR");
        this.uploadBean.setTempRightsChar(tempRightsChar);
        String excelFilePath = this.uploadBean.getFilePath();
        if (excelFilePath != null) {
            BaseLogger.log("3", null, null, "excelFilePath - [" + excelFilePath + "]");
            if (sheetName.length() > 0) {
                if (this.workbook == null) {
                    this.workbook = this.getWorkbook(excelFilePath);
                }
                sheet = this.workbook.getSheet(sheetName);
                BaseLogger.log("3", null, null, "sheet [" + sheet + "]");
                ArrayList<String> excelColList = this.getExcelColumnList(formNo, sheet, headingRowNum, matrixRowNum);
                BaseLogger.log("3", null, null, "excelColList - [" + excelColList + "]");
                HashMap<Integer, ArrayList<String>> excelColListMap = this.uploadBean.getExcelColListMap();
                if (excelColListMap == null) {
                    excelColListMap = new HashMap();
                }
                excelColListMap.put(formNo, excelColList);
                this.uploadBean.setExcelColListMap(excelColListMap);
            }
            if (matrixRowNum >= 0) {
                HashMap<String, Object> matrixDetailMap = this.getMatrixDetailMap(sheet, matrixRowNum, startMatrixColNum, endMatrixColNum);
                BaseLogger.log("3", null, null, "matrixDetailMap[" + matrixDetailMap + "]");
                int colSpan = (Integer)matrixDetailMap.get("COLSPAN");
                BaseLogger.log("3", null, null, "colSpan --[" + colSpan + "]");
                matrixSheetColSpanMap.put(sheetName, colSpan);
                BaseLogger.log("3", null, null, "matrixSheetColSpanMap :--: [" + matrixSheetColSpanMap + "]");
                this.uploadBean.setMatrixColSpanMap(matrixSheetColSpanMap);
            }
            LinkedHashMap<String, String> targetColMap = null;
            HashMap<Integer, LinkedHashMap<String, String>> targetColAllMap = this.uploadBean.getTargetColAllMap();
            BaseLogger.log("3", null, null, "targetColAllMap [" + targetColAllMap + "]");
            if (targetColAllMap != null) {
                targetColMap = targetColAllMap.get(formNo);
            } else {
                targetColAllMap = new HashMap();
            }
            if (targetColMap == null) {
                targetColMap = new LinkedHashMap();
            }
            BaseLogger.log("3", null, null, "targetColMap [" + targetColMap + "]");
            LinkedHashMap<String, String> mapLogicData = null;
            HashMap<Integer, LinkedHashMap<String, String>> mapLogicDataMap = this.uploadBean.getMapLogicDataMap();
            BaseLogger.log("3", null, null, "mapLogicDataMap - " + mapLogicDataMap);
            if (mapLogicDataMap != null) {
                mapLogicData = mapLogicDataMap.get(formNo);
            } else {
                mapLogicDataMap = new HashMap();
            }
            if (mapLogicData == null) {
                mapLogicData = new LinkedHashMap();
            }
            BaseLogger.log("3", null, null, "mapLogicData [" + mapLogicData + "]");
            LinkedHashMap<String, HashMap<String, String>> defineMapData = null;
            HashMap<Integer, LinkedHashMap<String, HashMap<String, String>>> defineMapDataMap = this.uploadBean.getDefineMapDataMap();
            BaseLogger.log("3", null, null, "defineMapDataMap - " + defineMapDataMap);
            if (defineMapDataMap != null) {
                defineMapData = defineMapDataMap.get(formNo);
            } else {
                defineMapDataMap = new HashMap();
            }
            if (defineMapData == null) {
                defineMapData = new LinkedHashMap();
            }
            BaseLogger.log("3", null, null, "defineMapData [" + defineMapData + "]");
            HashMap<Integer, HashMap<String, HashMap<String, String>>> defineValueAllMap = this.uploadBean.getAllFormDefineValueMap();
            BaseLogger.log("3", null, null, "defineValueAllMap [" + defineValueAllMap + "]");
            HashMap<String, HashMap<String, String>> defineValueMap = null;
            if (defineValueAllMap != null) {
                defineValueMap = defineValueAllMap.get(formNo);
            } else {
                defineValueAllMap = new HashMap();
            }
            if (defineValueMap == null) {
                defineValueMap = new HashMap();
            }
            BaseLogger.log("3", null, null, "defineValueMap [" + defineValueMap + "]");
            LinkedHashMap<String, String> mapLogicValue = null;
            HashMap<Integer, LinkedHashMap<String, String>> mapLogicValueMap = this.uploadBean.getMapLogicValueMap();
            BaseLogger.log("3", null, null, "mapLogicValueMap - " + mapLogicValueMap);
            if (mapLogicValueMap != null) {
                mapLogicValue = mapLogicValueMap.get(formNo);
            } else {
                mapLogicValueMap = new HashMap();
            }
            if (mapLogicValue == null) {
                mapLogicValue = new LinkedHashMap();
            }
            BaseLogger.log("3", null, null, "mapLogicValue [" + mapLogicValue + "]");
            HashMap<Integer, LinkedHashMap<String, String>> actualColListMap = this.uploadBean.getActualColListMap();
            BaseLogger.log("3", null, null, "actualColListMap [" + actualColListMap + "]");
            if (actualColListMap != null) {
                LinkedHashMap<String, String> actualColMap = actualColListMap.get(formNo);
                Set<String> keys = actualColMap.keySet();
                int loopCnt = 0;
                for (String colName : keys) {
                    String targetColValue = this.getRequestParamValue("targetCol" + loopCnt + "_" + formNo);
                    BaseLogger.log("3", null, null, "colName - [" + colName + "], targetColValue - [" + targetColValue + "]");
                    targetColMap.put(colName, targetColValue);
                    String mapLogicVal = this.getRequestParamValue("mapLogic" + loopCnt + "_" + formNo);
                    BaseLogger.log("3", null, null, "mapLogicVal - [" + colName + "], mapLogicVal - [" + mapLogicVal + "]");
                    LinkedHashMap<String, String> mapData = new LinkedHashMap<String, String>();
                    if ("D".equals(mapLogicVal)) {
                        if (defineValueMap.get("valueMap" + loopCnt) != null) {
                            HashMap<String, String> valueMap = defineValueMap.get("valueMap" + loopCnt);
                            BaseLogger.log("3", null, null, "valueMap ::: [" + valueMap + "]");
                            for (String srcVal : valueMap.keySet()) {
                                String replaceVal = valueMap.get(srcVal);
                                mapData.put(srcVal, replaceVal);
                            }
                            defineMapData.put(colName, mapData);
                        }
                    } else if ("R".equals(mapLogicVal)) {
                        String sql = mapLogicValue.get("SQL_" + colName);
                        String sqlInput = mapLogicValue.get("SQL_INPUT_" + colName);
                        BaseLogger.log("3", null, null, "sql - [" + sql + "], sqlInput - [" + sqlInput + "]");
                        mapLogicValue.put("SQL_" + colName, sql);
                        mapLogicValue.put("SQL_INPUT_" + colName, sqlInput);
                    } else if ("S".equals(mapLogicVal)) {
                        String startFrom = mapLogicValue.get("START_FROM_" + colName);
                        String upTo = mapLogicValue.get("UP_TO_" + colName);
                        BaseLogger.log("3", null, null, "startFrom - [" + startFrom + "], upTo - [" + upTo + "]");
                        mapLogicValue.put("START_FROM_" + colName, startFrom);
                        mapLogicValue.put("UP_TO_" + colName, upTo);
                    }
                    BaseLogger.log("3", null, null, "mapLogicValue - [" + mapLogicValue + "], defineMapData - [" + defineMapData + "]");
                    mapLogicData.put(colName, mapLogicVal);
                    ++loopCnt;
                }
                targetColAllMap.put(formNo, targetColMap);
                this.uploadBean.setTargetColAllMap(targetColAllMap);
                mapLogicDataMap.put(formNo, mapLogicData);
                this.uploadBean.setMapLogicDataMap(mapLogicDataMap);
                defineMapDataMap.put(formNo, defineMapData);
                this.uploadBean.setDefineMapDataMap(defineMapDataMap);
                mapLogicValueMap.put(formNo, mapLogicValue);
                this.uploadBean.setMapLogicValueMap(mapLogicValueMap);
            }
        }
        return retStr;
    }

    private String setJsonTemplateData() throws Exception, ITMException {
        String retStr = "<Root><Detail>Success</Detail></Root>";
        HashMap<Integer, String> sheetInfoMap = this.uploadBean.getSheetInfo();
        if (sheetInfoMap == null) {
            sheetInfoMap = new HashMap();
        }
        int formNo = Integer.parseInt(this.getRequestParamValue("formNo"));
        HashMap<Integer, String> excelSheetInfo = this.uploadBean.getExcelSheetInfo();
        int sheetNo = Integer.parseInt(this.getRequestParamValue("sheetName" + formNo));
        BaseLogger.log("3", null, null, "sheetNo - [" + sheetNo + "]");
        String sheetName = "";
        if (excelSheetInfo != null && excelSheetInfo.containsKey(sheetNo)) {
            sheetName = excelSheetInfo.get(sheetNo);
        }
        sheetInfoMap.put(formNo, sheetName);
        this.uploadBean.setSheetInfo(sheetInfoMap);
        BaseLogger.log("3", null, null, "sheetInfoMap - [" + sheetInfoMap + "]");
        String shareScope = this.getRequestParamValue("shareScope");
        this.uploadBean.setShareScope(shareScope);
        String scopeValue = this.getRequestParamValue("SCOPE_VAL");
        this.uploadBean.setScopeValue(scopeValue);
        String tempRightsChar = this.getRequestParamValue("RIGHT_CHAR");
        this.uploadBean.setTempRightsChar(tempRightsChar);
        String excelFilePath = this.uploadBean.getFilePath();
        if (excelFilePath != null) {
            BaseLogger.log("3", null, null, "excelFilePath - [" + excelFilePath + "]");
            if (sheetName.length() > 0) {
                HashMap<Integer, ArrayList<String>> excelColumnList = this.getJsonColumnList(this.uploadBean.getFilePath());
                BaseLogger.log("3", null, null, "excelColumns ==> :: [" + excelColumnList + "]");
                ArrayList<String> excelColList = excelColumnList.get(formNo);
                BaseLogger.log("3", null, null, "excelColList - [" + excelColList + "]");
                HashMap<Integer, ArrayList<String>> excelColListMap = this.uploadBean.getExcelColListMap();
                if (excelColListMap == null) {
                    excelColListMap = new HashMap();
                }
                excelColListMap.put(formNo, excelColList);
                this.uploadBean.setExcelColListMap(excelColListMap);
            }
            LinkedHashMap<String, String> targetColMap = null;
            HashMap<Integer, LinkedHashMap<String, String>> targetColAllMap = this.uploadBean.getTargetColAllMap();
            BaseLogger.log("3", null, null, "targetColAllMap [" + targetColAllMap + "]");
            if (targetColAllMap != null) {
                targetColMap = targetColAllMap.get(formNo);
            } else {
                targetColAllMap = new HashMap();
            }
            if (targetColMap == null) {
                targetColMap = new LinkedHashMap();
            }
            BaseLogger.log("3", null, null, "targetColMap [" + targetColMap + "]");
            LinkedHashMap<String, String> mapLogicData = null;
            HashMap<Integer, LinkedHashMap<String, String>> mapLogicDataMap = this.uploadBean.getMapLogicDataMap();
            BaseLogger.log("3", null, null, "mapLogicDataMap - " + mapLogicDataMap);
            if (mapLogicDataMap != null) {
                mapLogicData = mapLogicDataMap.get(formNo);
            } else {
                mapLogicDataMap = new HashMap();
            }
            if (mapLogicData == null) {
                mapLogicData = new LinkedHashMap();
            }
            BaseLogger.log("3", null, null, "mapLogicData [" + mapLogicData + "]");
            LinkedHashMap<String, HashMap<String, String>> defineMapData = null;
            HashMap<Integer, LinkedHashMap<String, HashMap<String, String>>> defineMapDataMap = this.uploadBean.getDefineMapDataMap();
            BaseLogger.log("3", null, null, "defineMapDataMap - " + defineMapDataMap);
            if (defineMapDataMap != null) {
                defineMapData = defineMapDataMap.get(formNo);
            } else {
                defineMapDataMap = new HashMap();
            }
            if (defineMapData == null) {
                defineMapData = new LinkedHashMap();
            }
            BaseLogger.log("3", null, null, "defineMapData [" + defineMapData + "]");
            HashMap<Integer, HashMap<String, HashMap<String, String>>> defineValueAllMap = this.uploadBean.getAllFormDefineValueMap();
            BaseLogger.log("3", null, null, "defineValueAllMap [" + defineValueAllMap + "]");
            HashMap<String, HashMap<String, String>> defineValueMap = null;
            if (defineValueAllMap != null) {
                defineValueMap = defineValueAllMap.get(formNo);
            } else {
                defineValueAllMap = new HashMap();
            }
            if (defineValueMap == null) {
                defineValueMap = new HashMap();
            }
            BaseLogger.log("3", null, null, "defineValueMap [" + defineValueMap + "]");
            LinkedHashMap<String, String> mapLogicValue = null;
            HashMap<Integer, LinkedHashMap<String, String>> mapLogicValueMap = this.uploadBean.getMapLogicValueMap();
            BaseLogger.log("3", null, null, "mapLogicValueMap - " + mapLogicValueMap);
            if (mapLogicValueMap != null) {
                mapLogicValue = mapLogicValueMap.get(formNo);
            } else {
                mapLogicValueMap = new HashMap();
            }
            if (mapLogicValue == null) {
                mapLogicValue = new LinkedHashMap();
            }
            BaseLogger.log("3", null, null, "mapLogicValue [" + mapLogicValue + "]");
            HashMap<Integer, LinkedHashMap<String, String>> actualColListMap = this.uploadBean.getActualColListMap();
            BaseLogger.log("3", null, null, "actualColListMap [" + actualColListMap + "]");
            if (actualColListMap != null) {
                LinkedHashMap<String, String> actualColMap = actualColListMap.get(formNo);
                Set<String> keys = actualColMap.keySet();
                int loopCnt = 0;
                for (String colName : keys) {
                    String targetColValue = this.getRequestParamValue("targetCol" + loopCnt + "_" + formNo);
                    BaseLogger.log("3", null, null, "colName - [" + colName + "], targetColValue - [" + targetColValue + "]");
                    targetColMap.put(colName, targetColValue);
                    String mapLogicVal = this.getRequestParamValue("mapLogic" + loopCnt + "_" + formNo);
                    BaseLogger.log("3", null, null, "mapLogicVal - [" + colName + "], mapLogicVal - [" + mapLogicVal + "]");
                    LinkedHashMap<String, String> mapData = new LinkedHashMap<String, String>();
                    if ("D".equals(mapLogicVal)) {
                        if (defineValueMap.get("valueMap" + loopCnt) != null) {
                            HashMap<String, String> valueMap = defineValueMap.get("valueMap" + loopCnt);
                            BaseLogger.log("3", null, null, "valueMap ::: [" + valueMap + "]");
                            for (String srcVal : valueMap.keySet()) {
                                String replaceVal = valueMap.get(srcVal);
                                mapData.put(srcVal, replaceVal);
                            }
                            defineMapData.put(colName, mapData);
                        }
                    } else if ("R".equals(mapLogicVal)) {
                        String sql = mapLogicValue.get("SQL_" + colName);
                        String sqlInput = mapLogicValue.get("SQL_INPUT_" + colName);
                        BaseLogger.log("3", null, null, "sql - [" + sql + "], sqlInput - [" + sqlInput + "]");
                        mapLogicValue.put("SQL_" + colName, sql);
                        mapLogicValue.put("SQL_INPUT_" + colName, sqlInput);
                    } else if ("S".equals(mapLogicVal)) {
                        String startFrom = mapLogicValue.get("START_FROM_" + colName);
                        String upTo = mapLogicValue.get("UP_TO_" + colName);
                        BaseLogger.log("3", null, null, "startFrom - [" + startFrom + "], upTo - [" + upTo + "]");
                        mapLogicValue.put("START_FROM_" + colName, startFrom);
                        mapLogicValue.put("UP_TO_" + colName, upTo);
                    }
                    BaseLogger.log("3", null, null, "mapLogicValue - [" + mapLogicValue + "], defineMapData - [" + defineMapData + "]");
                    mapLogicData.put(colName, mapLogicVal);
                    ++loopCnt;
                }
                targetColAllMap.put(formNo, targetColMap);
                this.uploadBean.setTargetColAllMap(targetColAllMap);
                mapLogicDataMap.put(formNo, mapLogicData);
                this.uploadBean.setMapLogicDataMap(mapLogicDataMap);
                defineMapDataMap.put(formNo, defineMapData);
                this.uploadBean.setDefineMapDataMap(defineMapDataMap);
                mapLogicValueMap.put(formNo, mapLogicValue);
                this.uploadBean.setMapLogicValueMap(mapLogicValueMap);
            }
        }
        return retStr;
    }

    private String setXmlTemplateData() throws Exception, ITMException {
        String retStr = "<Root><Detail>Success</Detail></Root>";
        HashMap<Integer, String> sheetInfoMap = this.uploadBean.getSheetInfo();
        if (sheetInfoMap == null) {
            sheetInfoMap = new HashMap();
        }
        int formNo = Integer.parseInt(this.getRequestParamValue("formNo"));
        BaseLogger.log("3", this.userInfo, null, "xml FormNo - [" + formNo + "]");
        HashMap<Integer, String> excelSheetInfo = this.uploadBean.getExcelSheetInfo();
        int sheetNo = Integer.parseInt(this.getRequestParamValue("sheetName" + formNo));
        BaseLogger.log("3", this.userInfo, null, "xml sheetNo - [" + sheetNo + "]");
        String sheetName = "";
        if (excelSheetInfo != null && excelSheetInfo.containsKey(sheetNo)) {
            sheetName = excelSheetInfo.get(sheetNo);
        }
        sheetInfoMap.put(formNo, sheetName);
        this.uploadBean.setSheetInfo(sheetInfoMap);
        BaseLogger.log("3", null, null, "sheetInfoMap - [" + sheetInfoMap + "]");
        String shareScope = this.getRequestParamValue("shareScope");
        this.uploadBean.setShareScope(shareScope);
        String scopeValue = this.getRequestParamValue("SCOPE_VAL");
        this.uploadBean.setScopeValue(scopeValue);
        String tempRightsChar = this.getRequestParamValue("RIGHT_CHAR");
        this.uploadBean.setTempRightsChar(tempRightsChar);
        String excelFilePath = this.uploadBean.getFilePath();
        if (excelFilePath != null) {
            BaseLogger.log("3", this.userInfo, null, "xmlFilePath - [" + excelFilePath + "]");
            if (sheetName.length() > 0) {
                HashMap<Integer, ArrayList<String>> excelColumnList = this.getXmlColumnList(this.uploadBean.getFilePath());
                BaseLogger.log("3", this.userInfo, null, "xmlColumns ==> :: [" + excelColumnList + "]");
                ArrayList<String> excelColList = excelColumnList.get(formNo);
                BaseLogger.log("3", this.userInfo, null, "xmlColList - [" + excelColList + "]");
                HashMap<Integer, ArrayList<String>> excelColListMap = this.uploadBean.getExcelColListMap();
                if (excelColListMap == null) {
                    excelColListMap = new HashMap();
                }
                excelColListMap.put(formNo, excelColList);
                this.uploadBean.setExcelColListMap(excelColListMap);
            }
            LinkedHashMap<String, String> targetColMap = null;
            HashMap<Integer, LinkedHashMap<String, String>> targetColAllMap = this.uploadBean.getTargetColAllMap();
            BaseLogger.log("3", this.userInfo, null, "targetColAllMap [" + targetColAllMap + "]");
            if (targetColAllMap != null) {
                targetColMap = targetColAllMap.get(formNo);
            } else {
                targetColAllMap = new HashMap();
            }
            if (targetColMap == null) {
                targetColMap = new LinkedHashMap();
            }
            BaseLogger.log("3", this.userInfo, null, "targetColMap [" + targetColMap + "]");
            LinkedHashMap<String, String> mapLogicData = null;
            HashMap<Integer, LinkedHashMap<String, String>> mapLogicDataMap = this.uploadBean.getMapLogicDataMap();
            BaseLogger.log("3", this.userInfo, null, "mapLogicDataMap - " + mapLogicDataMap);
            if (mapLogicDataMap != null) {
                mapLogicData = mapLogicDataMap.get(formNo);
            } else {
                mapLogicDataMap = new HashMap();
            }
            if (mapLogicData == null) {
                mapLogicData = new LinkedHashMap();
            }
            BaseLogger.log("3", this.userInfo, null, "mapLogicData [" + mapLogicData + "]");
            LinkedHashMap<String, HashMap<String, String>> defineMapData = null;
            HashMap<Integer, LinkedHashMap<String, HashMap<String, String>>> defineMapDataMap = this.uploadBean.getDefineMapDataMap();
            BaseLogger.log("3", this.userInfo, null, "defineMapDataMap - " + defineMapDataMap);
            if (defineMapDataMap != null) {
                defineMapData = defineMapDataMap.get(formNo);
            } else {
                defineMapDataMap = new HashMap();
            }
            if (defineMapData == null) {
                defineMapData = new LinkedHashMap();
            }
            BaseLogger.log("3", this.userInfo, null, "defineMapData [" + defineMapData + "]");
            HashMap<Integer, HashMap<String, HashMap<String, String>>> defineValueAllMap = this.uploadBean.getAllFormDefineValueMap();
            BaseLogger.log("3", this.userInfo, null, "defineValueAllMap [" + defineValueAllMap + "]");
            HashMap<String, HashMap<String, String>> defineValueMap = null;
            if (defineValueAllMap != null) {
                defineValueMap = defineValueAllMap.get(formNo);
            } else {
                defineValueAllMap = new HashMap();
            }
            if (defineValueMap == null) {
                defineValueMap = new HashMap();
            }
            BaseLogger.log("3", this.userInfo, null, "defineValueMap [" + defineValueMap + "]");
            LinkedHashMap<String, String> mapLogicValue = null;
            HashMap<Integer, LinkedHashMap<String, String>> mapLogicValueMap = this.uploadBean.getMapLogicValueMap();
            BaseLogger.log("3", this.userInfo, null, "mapLogicValueMap - " + mapLogicValueMap);
            if (mapLogicValueMap != null) {
                mapLogicValue = mapLogicValueMap.get(formNo);
            } else {
                mapLogicValueMap = new HashMap();
            }
            if (mapLogicValue == null) {
                mapLogicValue = new LinkedHashMap();
            }
            BaseLogger.log("3", this.userInfo, null, "mapLogicValue [" + mapLogicValue + "]");
            HashMap<Integer, LinkedHashMap<String, String>> actualColListMap = this.uploadBean.getActualColListMap();
            BaseLogger.log("3", this.userInfo, null, "actualColListMap [" + actualColListMap + "]");
            if (actualColListMap != null) {
                LinkedHashMap<String, String> actualColMap = actualColListMap.get(formNo);
                Set<String> keys = actualColMap.keySet();
                int loopCnt = 0;
                for (String colName : keys) {
                    String targetColValue = this.getRequestParamValue("targetCol" + loopCnt + "_" + formNo);
                    BaseLogger.log("3", this.userInfo, null, "colName - [" + colName + "], targetColValue - [" + targetColValue + "]");
                    targetColMap.put(colName, targetColValue);
                    String mapLogicVal = this.getRequestParamValue("mapLogic" + loopCnt + "_" + formNo);
                    BaseLogger.log("3", this.userInfo, null, "mapLogicVal - [" + colName + "], mapLogicVal - [" + mapLogicVal + "]");
                    LinkedHashMap<String, String> mapData = new LinkedHashMap<String, String>();
                    if ("D".equals(mapLogicVal)) {
                        if (defineValueMap.get("valueMap" + loopCnt) != null) {
                            HashMap<String, String> valueMap = defineValueMap.get("valueMap" + loopCnt);
                            BaseLogger.log("3", this.userInfo, null, "valueMap ::: [" + valueMap + "]");
                            for (String srcVal : valueMap.keySet()) {
                                String replaceVal = valueMap.get(srcVal);
                                mapData.put(srcVal, replaceVal);
                            }
                            defineMapData.put(colName, mapData);
                        }
                    } else if ("R".equals(mapLogicVal)) {
                        String sql = mapLogicValue.get("SQL_" + colName);
                        String sqlInput = mapLogicValue.get("SQL_INPUT_" + colName);
                        BaseLogger.log("3", this.userInfo, null, "sql - [" + sql + "], sqlInput - [" + sqlInput + "]");
                        mapLogicValue.put("SQL_" + colName, sql);
                        mapLogicValue.put("SQL_INPUT_" + colName, sqlInput);
                    } else if ("S".equals(mapLogicVal)) {
                        String startFrom = mapLogicValue.get("START_FROM_" + colName);
                        String upTo = mapLogicValue.get("UP_TO_" + colName);
                        BaseLogger.log("3", null, null, "startFrom - [" + startFrom + "], upTo - [" + upTo + "]");
                        mapLogicValue.put("START_FROM_" + colName, startFrom);
                        mapLogicValue.put("UP_TO_" + colName, upTo);
                    }
                    BaseLogger.log("3", this.userInfo, null, "mapLogicValue - [" + mapLogicValue + "], defineMapData - [" + defineMapData + "]");
                    mapLogicData.put(colName, mapLogicVal);
                    ++loopCnt;
                }
                targetColAllMap.put(formNo, targetColMap);
                this.uploadBean.setTargetColAllMap(targetColAllMap);
                mapLogicDataMap.put(formNo, mapLogicData);
                this.uploadBean.setMapLogicDataMap(mapLogicDataMap);
                defineMapDataMap.put(formNo, defineMapData);
                this.uploadBean.setDefineMapDataMap(defineMapDataMap);
                mapLogicValueMap.put(formNo, mapLogicValue);
                this.uploadBean.setMapLogicValueMap(mapLogicValueMap);
            }
        }
        BaseLogger.log("3", this.userInfo, null, "retStr=[" + retStr + "]");
        return retStr;
    }

    private boolean isNewTemplate() {
        return this.isNewTemplate;
    }

    private void removeSessionAttribute(String caller) {
        this.uploadBean = null;
        this.session.removeAttribute(String.valueOf(caller) + "UPLOAD_BEAN");
    }

    private void setSelectedTemplate(String tempName) {
        if (!this.isNewTemplate()) {
            String templateXml = TemplateDetails.get(this.objName).getTemplateXml(tempName);
            String fileMappingXml = TemplateDetails.get(this.objName).getFileMapping(tempName);
            String shareScope = TemplateDetails.get(this.objName).getShareScope(tempName);
            this.uploadBean.setShareScope(shareScope);
            String scopeValue = TemplateDetails.get(this.objName).getScopeValue(tempName);
            this.uploadBean.setScopeValue(scopeValue);
            String tempRightsChar = TemplateDetails.get(this.objName).getTempRightsChar(tempName);
            this.uploadBean.setTempRightsChar(tempRightsChar);
            String rightChar = TemplateDetails.get(this.objName).getRightChar(tempName);
            this.uploadBean.setRightChar(rightChar);
            String tempAddUser = TemplateDetails.get(this.objName).getAddUser(tempName);
            this.uploadBean.setTempAddUser(tempAddUser);
            int totalForms = this.getNoOfForms();
            TemplateDetails.get(this.templateKey).createTemplateDetail(templateXml, totalForms);
            TemplateDetails.get(this.templateKey).createFileMappingDetail(fileMappingXml);
            HashMap<Integer, HashMap<String, Integer>> matrixRowMap = TemplateDetails.get(this.templateKey).getFormWiseMatrixRowMap();
            this.uploadBean.setMatrixRowMap(matrixRowMap);
            BaseLogger.log("3", null, null, "matrixRowMap - [" + matrixRowMap + "]");
            HashMap<Integer, String> sheetInfoMap = TemplateDetails.get(this.templateKey).getSheetInfoMap();
            this.uploadBean.setSheetInfo(sheetInfoMap);
            BaseLogger.log("3", null, null, "sheetInfoMap - [" + sheetInfoMap + "]");
            HashMap<Integer, ArrayList<String>> allActualColListMap = TemplateDetails.get(this.templateKey).getActualColListMap();
            this.uploadBean.setAllFormActualColListMap(allActualColListMap);
            BaseLogger.log("3", null, null, "allActualColListMap - [" + allActualColListMap + "]");
            HashMap<Integer, LinkedHashMap<String, String>> mapLogicDataMap = TemplateDetails.get(this.templateKey).getFormWiseMapLogicData();
            this.uploadBean.setMapLogicDataMap(mapLogicDataMap);
            BaseLogger.log("3", null, null, "mapLogicDataMap - " + mapLogicDataMap);
            HashMap<Integer, LinkedHashMap<String, HashMap<String, String>>> defineMapDataMap = TemplateDetails.get(this.templateKey).getFormWiseDefineMapData();
            this.uploadBean.setDefineMapDataMap(defineMapDataMap);
            BaseLogger.log("3", null, null, "defineMapDataMap - " + defineMapDataMap);
            HashMap<Integer, LinkedHashMap<String, String>> mapLogicValueMap = TemplateDetails.get(this.templateKey).getFormWiseMapLogicValue();
            this.uploadBean.setMapLogicValueMap(mapLogicValueMap);
            BaseLogger.log("3", null, null, "mapLogicValueMap - " + mapLogicValueMap);
            HashMap<Integer, LinkedHashMap<String, String>> targetColAllMap = TemplateDetails.get(this.templateKey).getFormWiseTargetCol();
            this.uploadBean.setTargetColAllMap(targetColAllMap);
            BaseLogger.log("3", null, null, "targetColAllMap - " + targetColAllMap);
            boolean isDefault = TemplateDetails.get(this.objName).isDefaultTemplate(tempName);
            if (isDefault) {
                this.uploadBean.setIsDefaultTemp("Y");
            } else {
                this.uploadBean.setIsDefaultTemp("N");
            }
            boolean isAutoConfirm = TemplateDetails.get(this.objName).isAutoConfirm(tempName);
            if (isAutoConfirm) {
                this.uploadBean.setAutoConfirm("Y");
            } else {
                this.uploadBean.setAutoConfirm("N");
            }
        }
    }

    private void removeRowsFromExcel(String sheetName, String headingRow) {
        try {
            String uploadExcelpath = this.uploadBean.getUploadFilepath();
            if (uploadExcelpath != null && uploadExcelpath.length() > 0) {
                int headingRowNo = Integer.parseInt(headingRow);
                FileInputStream fsIP = new FileInputStream(new File(uploadExcelpath));
                HSSFWorkbook wb = new HSSFWorkbook((InputStream)fsIP);
                HSSFSheet worksheet = wb.getSheet(sheetName);
                HSSFRow row = worksheet.getRow(headingRowNo);
                int lastRowNum = worksheet.getLastRowNum();
                int lastCellNum = row.getLastCellNum();
                int rowCtr = headingRowNo;
                while (rowCtr <= lastRowNum) {
                    int columnCtr = 0;
                    while (columnCtr < lastCellNum) {
                        worksheet.getRow(rowCtr).getCell(columnCtr).setCellValue("");
                        ++columnCtr;
                    }
                    ++rowCtr;
                }
                fsIP.close();
                FileOutputStream output_file = new FileOutputStream(new File(uploadExcelpath));
                wb.write((OutputStream)output_file);
                output_file.flush();
                output_file.close();
            }
        }
        catch (IOException e) {
            BaseLogger.log("0", null, null, "IOException :: removeRowsFromExcel : [" + e.getMessage() + "]");
            e.printStackTrace();
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :: removeRowsFromExcel : [" + e.getMessage() + "]");
            e.printStackTrace();
        }
    }

    private void downloadTemplate(String docId) {
        byte[] byteArray = null;
        try {
            BaseLogger.log("3", null, null, "docId : [" + docId + "]");
            DocumentHandlerEJB docHandler = new DocumentHandlerEJB();
            byteArray = docHandler.getDocument(docId, this.getUserInfo());
            String fileName = docHandler.getDocumentName(docId, this.userInfo.getTransDB());
            BaseLogger.log("3", null, null, "fileName of Downloaded document [" + fileName + "]");
            String downloadedPath = String.valueOf(CommonConstants.TEMP_FOLDER) + File.separator + fileName;
            BaseLogger.log("3", null, null, "downloadedPath : [" + downloadedPath + "]");
            FileOutputStream fos = new FileOutputStream(downloadedPath);
            if (byteArray != null) {
                fos.write(byteArray);
            }
            fos.close();
            fos.flush();
            this.uploadBean.setFilePath(downloadedPath);
            String docType = fileName.substring(fileName.lastIndexOf(".") + 1);
            BaseLogger.log("3", null, null, "docType : [" + docType + "]");
            if ("xls".equalsIgnoreCase(docType)) {
                this.uploadBean.setFileType("excel");
            } else if ("xml".equalsIgnoreCase(docType)) {
                this.uploadBean.setFileType("xml");
            } else if ("json".equals(docType)) {
                BaseLogger.log("3", null, null, "heee i got json here : [" + docType + "]");
            }
        }
        catch (RemoteException e) {
            BaseLogger.log("0", null, null, "RemoteException : [" + e.getMessage() + "]");
            e.printStackTrace();
        }
        catch (ITMException e) {
            BaseLogger.log("0", null, null, "ITMException : [" + e.getMessage() + "]");
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            BaseLogger.log("0", null, null, "FileNotFoundException : [" + e.getMessage() + "]");
            e.printStackTrace();
        }
        catch (IOException e) {
            BaseLogger.log("0", null, null, "IOException : [" + e.getMessage() + "]");
            e.printStackTrace();
        }
    }

    private DBAccessRemote getDBAccess() {
        try {
            this.dbAccess = new DBAccessEJB();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.dbAccess;
    }

    private String setObjectDetail(UserInfoBean userInfo) throws ITMException {
        String responseStr = "<Root><Detail>Success</Detail></Root>";
        try {
            HashMap<String, Object> objDetailMap = new HashMap<String, Object>();
            HashMap tranSetupDtlMap = this.getDBAccess().getObjDetailMap(this.objName, userInfo);
            if (tranSetupDtlMap == null || tranSetupDtlMap.size() == 0) {
                return this.genericUtility.getErrorString("", "VTTRSET1", this.userId);
            }
            DWFactory dws = new DWFactory(userInfo);
            ArrayList objFormsDetailList = this.dbAccess.getObjFormsDetailList(this.objName, userInfo);
            HashMap<String, String> formWisePkFldNameMap = new HashMap<String, String>();
            HashMap<String, HashMap> formWiseColLogNameSizeMap = new HashMap<String, HashMap>();
            HashMap<String, HashMap<String, String>> dbWiseColLogNameTypeMap = new HashMap<String, HashMap<String, String>>();
            HashMap<String, HashMap> formWiseDropDownColValueMap = new HashMap<String, HashMap>();
            HashMap<String, HashMap> formWiseFieldCaseValueMap = new HashMap<String, HashMap>();
            HashMap<String, HashMap> formWiseFieldPrecisionValueMap = new HashMap<String, HashMap>();
            HashMap<String, HashMap> metadataWiseColLogNameTypeMap = new HashMap<String, HashMap>();
            HashMap<String, String> formNameMap = new HashMap<String, String>();
            int noOfForms = objFormsDetailList.size();
            int formNo = 0;
            while (formNo < noOfForms) {
                String formPkFldName;
                ArrayList currFormDetailList = (ArrayList)objFormsDetailList.get(formNo);
                String objContext = (String)currFormDetailList.get(14);
                String pkFldName = "";
                if ("1".equals(objContext)) {
                    pkFldName = this.checkNull((String)tranSetupDtlMap.get("TRAN_ID_COL"));
                }
                if ((formPkFldName = this.checkNull("" + currFormDetailList.get(27))).length() > 0) {
                    pkFldName = formPkFldName;
                }
                pkFldName = pkFldName.replaceAll(",", ":");
                pkFldName = pkFldName.toLowerCase();
                BaseLogger.log("3", null, null, "objContext : [" + objContext + "], pkFldName : [" + pkFldName + "]");
                formWisePkFldNameMap.put(objContext, pkFldName);
                String formName = this.checkNull("" + currFormDetailList.get(32));
                BaseLogger.log("3", null, null, "objContext : [" + objContext + "], formName : [" + formName + "]");
                formNameMap.put(objContext, formName);
                if (formName.length() == 0) {
                    formName = objContext;
                }
                String metaDataFileName = String.valueOf(this.objName) + "2" + formName;
                String filePath = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "server" + File.separator + "default" + File.separator + "deploy" + File.separator + "ibase.ear" + File.separator + "metadata" + File.separator + metaDataFileName + ".xml";
                File fileObj = new File(filePath);
                if (!fileObj.exists()) {
                    fileObj = null;
                    return this.genericUtility.getErrorString("", "METADATANT", this.userId);
                }
                fileObj = null;
                DWObject dwObj = dws.getDataWindow(metaDataFileName);
                if (pkFldName.length() == 0) {
                    ArrayList primaryKeyLogNameList = dwObj.getPrimaryKeyLogNameList();
                    StringBuffer pkFieldNameBuff = new StringBuffer();
                    int i = 0;
                    while (i < primaryKeyLogNameList.size()) {
                        String pkFieldName = (String)primaryKeyLogNameList.get(i);
                        pkFieldNameBuff.append(pkFieldName).append(":");
                        ++i;
                    }
                    pkFldName = pkFieldNameBuff.toString();
                    formWisePkFldNameMap.put(objContext, pkFldName);
                }
                HashMap colLogNameSizeMap = dwObj.getColLogNameSizeMap();
                formWiseColLogNameSizeMap.put(objContext, colLogNameSizeMap);
                HashMap metadataColLogNameTypeMap = dwObj.getColLogNameTypeMap();
                metadataWiseColLogNameTypeMap.put(objContext, metadataColLogNameTypeMap);
                String tableName = dwObj.getTableToBeUpdated();
                BaseLogger.log("3", userInfo, null, "tableName : [" + tableName + "]");
                HashMap<String, String> dbColLogNameTypeMap = this.getDBAccess().getColLogNameTypeMap(tableName, userInfo);
                BaseLogger.log("3", userInfo, null, "DBColLogNameTypeMap : [" + dbColLogNameTypeMap + "]");
                dbWiseColLogNameTypeMap.put(objContext, dbColLogNameTypeMap);
                HashMap dropDownColValueMap = dwObj.getDropDownColValueMap();
                formWiseDropDownColValueMap.put(objContext, dropDownColValueMap);
                HashMap fieldCaseValueMap = dwObj.getFieldCaseValueMap();
                formWiseFieldCaseValueMap.put(objContext, fieldCaseValueMap);
                HashMap fieldPrecisionValueMap = dwObj.getFieldPrecisionValueMap();
                formWiseFieldPrecisionValueMap.put(objContext, fieldPrecisionValueMap);
                dwObj.remove();
                dwObj = null;
                ++formNo;
            }
            objDetailMap.put("TOTAL_FORMS", noOfForms);
            objDetailMap.put("PK_NAME", formWisePkFldNameMap);
            objDetailMap.put("FORM_NAME", formNameMap);
            objDetailMap.put("TRANSETUP", tranSetupDtlMap);
            objDetailMap.put("COLUMN_SIZE", formWiseColLogNameSizeMap);
            objDetailMap.put("COLUMN_TYPE_DB", dbWiseColLogNameTypeMap);
            objDetailMap.put("COLUMN_TYPE_METADATA", metadataWiseColLogNameTypeMap);
            objDetailMap.put("COLUMN_TYPE_VALUES", formWiseDropDownColValueMap);
            objDetailMap.put("FIELD_CASE_VALUES", formWiseFieldCaseValueMap);
            objDetailMap.put("FIELD_PRECISION_VALUES", formWiseFieldPrecisionValueMap);
            dws = null;
            BaseLogger.log("3", null, null, "objDetailMap [" + objDetailMap + "]");
            TemplateDetails.get(this.objName).setObjDetailMap(objDetailMap);
        }
        catch (RemoteException e) {
            throw new ITMException(e);
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return responseStr;
    }

    private String validateExcelInputData(String colName, String excelContent, HashMap<String, String> metadataColLogNameTypeMap, HashMap<String, String> dbColLogNameTypeMap, HashMap<String, Integer> colLogNameSizeMap, HashMap<String, HashMap<String, String>> dropDownColValueMap, HashMap<String, Integer> colLogNamePrecisionMap) {
        StringBuffer errorDescr = new StringBuffer();
        try {
            String validStr;
            String colType;
            HashMap<String, String> errorMap = new HashMap<String, String>();
            if (dbColLogNameTypeMap != null && dbColLogNameTypeMap.containsKey(colName)) {
                colType = this.checkNull(dbColLogNameTypeMap.get(colName));
                BaseLogger.log("3", null, null, "colType : [" + colType + "]");
                if ("char".equalsIgnoreCase(colType)) {
                    if (colLogNameSizeMap != null && colLogNameSizeMap.containsKey(colName) && excelContent.length() > 0) {
                        int actualSize = colLogNameSizeMap.get(colName);
                        int dataSize = excelContent.length();
                        BaseLogger.log("3", null, null, "colName : [" + colName + "] actualSize : [" + actualSize + "], dataSize : [" + dataSize + "]");
                        if (dataSize > actualSize) {
                            validStr = "Value too large for [" + excelContent + "] column, (actual: " + dataSize + ", maximum: " + actualSize + ")";
                            errorMap.put(colName, validStr);
                        }
                    }
                } else if ("decimal".equalsIgnoreCase(colType)) {
                    try {
                        if (excelContent.length() > 0) {
                            Double.parseDouble(excelContent);
                        }
                    }
                    catch (Exception e) {
                        BaseLogger.log("0", null, null, "[" + colType + "] Exception - [" + e.getMessage() + "]");
                        e.printStackTrace();
                        String validStr2 = "Invalid number [" + colName + "] for [" + excelContent + "] column.";
                        errorMap.put(colName, validStr2);
                    }
                }
            }
            if (metadataColLogNameTypeMap != null && metadataColLogNameTypeMap.containsKey(colName)) {
                colType = this.checkNull(metadataColLogNameTypeMap.get(colName));
                BaseLogger.log("3", null, null, "colType : [" + colType + "] colName : [" + colName + "]");
                if ("datetime".equalsIgnoreCase(colType)) {
                    try {
                        if (excelContent.length() > 0) {
                            this.genericUtility.getValidDateTimeString(excelContent, this.genericUtility.getApplDateFormat(), this.genericUtility.getDBDateFormat());
                        }
                    }
                    catch (Exception e) {
                        BaseLogger.log("0", null, null, "[" + colType + "] -------->Exception - [" + e.getMessage() + "]");
                        e.printStackTrace();
                        String validStr3 = "Invalid date [" + excelContent + "] for [" + colName + "] column.";
                        errorMap.put(colName, validStr3);
                    }
                } else if ("date".equalsIgnoreCase(colType)) {
                    try {
                        if (excelContent.length() > 0) {
                            this.genericUtility.getValidDateString(excelContent, this.genericUtility.getApplDateFormat(), this.genericUtility.getDBDateFormat());
                        }
                    }
                    catch (Exception e) {
                        BaseLogger.log("0", null, null, "[" + colType + "] -------->Exception - [" + e.getMessage() + "]");
                        e.printStackTrace();
                        String validStr4 = "Invalid date [" + excelContent + "] for [" + colName + "] column.";
                        errorMap.put(colName, validStr4);
                    }
                }
            }
            if (dropDownColValueMap != null && dropDownColValueMap.get(colName) != null) {
                HashMap<String, String> itemData = dropDownColValueMap.get(colName);
                if (excelContent.length() > 0 && !itemData.containsKey(excelContent)) {
                    String validStr5 = "Invalid value [" + excelContent + "] for drop down field [" + colName + "]";
                    errorMap.put(colName, validStr5);
                }
            }
            if (colLogNamePrecisionMap != null && colLogNamePrecisionMap.get(colName) != 0) {
                int dataPrecision = colLogNamePrecisionMap.get(colName);
                BaseLogger.log("3", null, null, "dataPrecision : [" + dataPrecision + "]");
                String[] excelContentPrecision = excelContent.split("\\.");
                String dataCount = excelContentPrecision[1];
                BaseLogger.log("3", null, null, "dataCount : [" + dataCount + "]");
                if (dataCount.length() > dataPrecision) {
                    validStr = "Invalid value [" + excelContent + "], precision is greater for [" + colName + "], enter only [" + dataPrecision + "] precision";
                    errorMap.put(colName, validStr);
                }
            }
            int errCnt = 1;
            if (errorMap.size() > 0) {
                for (Map.Entry entry : errorMap.entrySet()) {
                    errorDescr.append(errCnt).append(". ").append((String)entry.getValue()).append("\n");
                    ++errCnt;
                }
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "In the validateExcelInputData Exception -- > [" + e.getMessage() + "]");
            e.printStackTrace();
        }
        return errorDescr.toString();
    }

    private String[] getPkDetails(HashMap<String, String> dataMap, ArrayList<String> pkNameList, ArrayList<String> parentPkNameList) {
        String[] pkDtlArr = new String[3];
        StringBuffer pkNameBuff = new StringBuffer();
        StringBuffer pkValueBuff = new StringBuffer();
        StringBuffer parentPkValueBuff = new StringBuffer();
        if (pkNameList != null && dataMap != null && parentPkNameList != null) {
            int pkCtr = 0;
            while (pkCtr < pkNameList.size()) {
                String pkName = this.checkNull(pkNameList.get(pkCtr));
                pkNameBuff.append(pkName).append(":");
                if (dataMap.containsKey(pkName)) {
                    pkValueBuff.append(dataMap.get(pkName)).append(":");
                    if (parentPkNameList.contains(pkName)) {
                        parentPkValueBuff.append(dataMap.get(pkName)).append(":");
                    }
                }
                ++pkCtr;
            }
            if (pkValueBuff.toString().endsWith(":")) {
                pkValueBuff = pkValueBuff.deleteCharAt(pkValueBuff.length() - 1);
            }
            if (parentPkValueBuff.toString().endsWith(":")) {
                parentPkValueBuff = parentPkValueBuff.deleteCharAt(parentPkValueBuff.length() - 1);
            }
        }
        pkDtlArr[0] = pkNameBuff.toString();
        pkDtlArr[1] = pkValueBuff.toString();
        pkDtlArr[2] = parentPkValueBuff.toString();
        return pkDtlArr;
    }

    /*
     * WARNING - void declaration
     */
    private LinkedHashMap<String, String> buildXmlData(String filePath) throws ITMException {
        Document doc = null;
        LinkedHashMap<String, String> dataMap = new LinkedHashMap<String, String>();
        try {
            E12GenericUtility genericUtility = new E12GenericUtility();
            doc = genericUtility.parseFile(filePath);
            int noOfForms = TemplateDetails.get(this.objName).getFormCount();
            BaseLogger.log("3", this.userInfo, null, "noOfForms in buildXmlData : " + noOfForms + "]");
            XPathFactory xpathFactory = XPathFactory.newInstance();
            XPath xpath = xpathFactory.newXPath();
            NodeList detail1NodeList = doc.getElementsByTagName("Detail1");
            int detail1NodeListLen = detail1NodeList.getLength();
            BaseLogger.log("3", this.userInfo, null, "detail1NodeListLen : " + detail1NodeListLen + "]");
            HashMap<String, String> dbColLogNameTypeMap = TemplateDetails.get(this.objName).getColumnTypeDB("1");
            HashMap<String, String> metaDataColLogNameTypeMap = TemplateDetails.get(this.objName).getColumnTypeMetaDeta("1");
            HashMap<String, Integer> colLogNameSizeMap = TemplateDetails.get(this.objName).getColumnSize("1");
            HashMap<String, HashMap<String, String>> colValueItemDropDownMap = TemplateDetails.get(this.objName).getDropDownColValueMap("1");
            HashMap<String, String> fieldCaseValueMap = TemplateDetails.get(this.objName).getFieldCase("1");
            HashMap<String, Integer> colLogNamePrecisionMap = TemplateDetails.get(this.objName).getColumnPrecision("1");
            Node detail1Node = null;
            String pkNames = "";
            String dbId = "";
            int detail1Itr = 0;
            while (detail1Itr < detail1NodeListLen) {
                StringBuffer detailDataBuff = new StringBuffer();
                detail1Node = detail1NodeList.item(detail1Itr);
                if (detail1Node != null) {
                    void var26_27;
                    void var26_29;
                    dbId = detail1Node.getAttributes().getNamedItem("dbID").getNodeValue();
                    BaseLogger.log("3", null, null, "dbId : [" + dbId + "]");
                    NodeList childList = detail1Node.getChildNodes();
                    int childListLen = childList.getLength();
                    String childNodeName = "";
                    String colValue = "";
                    HashMap<String, String> colNameNValueMap = new HashMap<String, String>();
                    boolean bl = false;
                    while (var26_29 < childListLen) {
                        Node subChildNode = childList.item((int)var26_29);
                        childNodeName = subChildNode.getNodeName();
                        if (!"#text".equals(childNodeName) && "attribute".equalsIgnoreCase(childNodeName)) {
                            if (subChildNode.getAttributes().getNamedItem("pkNames") != null) {
                                pkNames = subChildNode.getAttributes().getNamedItem("pkNames").getNodeValue();
                            }
                        } else if (!"#text".equals(childNodeName) && subChildNode.getFirstChild() != null) {
                            colValue = subChildNode.getFirstChild().getNodeValue();
                        }
                        colNameNValueMap.put(childNodeName, colValue);
                        ++var26_29;
                    }
                    if (pkNames != null && pkNames.endsWith(":")) {
                        pkNames = pkNames.substring(0, pkNames.length() - 1);
                    }
                    BaseLogger.log("3", null, null, " pkNames : [" + pkNames + "]");
                    for (Map.Entry entry : colNameNValueMap.entrySet()) {
                        String colName = (String)entry.getKey();
                        String colData = (String)entry.getValue();
                        String errorDataStr = this.validateExcelInputData(colName, colData, metaDataColLogNameTypeMap, dbColLogNameTypeMap, colLogNameSizeMap, colValueItemDropDownMap, colLogNamePrecisionMap);
                        if ((errorDataStr = this.checkNull(errorDataStr)).length() > 0) {
                            dataMap.put("INPUT_DATA_ERR", genericUtility.getErrorString("", errorDataStr, "Invalid data!", ""));
                            return dataMap;
                        }
                        if (colData == "") continue;
                        colData = this.fieldCaseData(fieldCaseValueMap, colName, colData);
                    }
                    detailDataBuff.append(genericUtility.serializeDom(detail1Node));
                    int n = 2;
                    while (var26_27 <= noOfForms) {
                        LinkedHashMap<String, String> detailNodeMap = this.getNodebypkValue(doc, xpath, (int)var26_27, dbId, pkNames);
                        if (detailNodeMap != null) {
                            if (detailNodeMap.containsKey("INPUT_DATA_ERR")) {
                                return detailNodeMap;
                            }
                            String detailDataStr = detailNodeMap.get(dbId);
                            detailDataBuff.append(detailDataStr);
                        }
                        ++var26_27;
                    }
                    dataMap.put(dbId, detailDataBuff.toString());
                }
                ++detail1Itr;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "in the BuildXmlData Exception : [" + e.getMessage() + "]");
            throw new ITMException(e);
        }
        return dataMap;
    }

    private LinkedHashMap<String, String> getNodebypkValue(Document doc, XPath xpath, int formNo, String pkValue, String pkName) {
        LinkedHashMap<String, String> detailNodeMap = new LinkedHashMap<String, String>();
        try {
            StringBuffer stringBuffer = new StringBuffer();
            String xpathExpr = this.getXPathExpr(pkName, pkValue);
            String xpathStr = "//Detail" + formNo + "[" + xpathExpr + "]";
            XPathExpression expr = xpath.compile(xpathStr);
            Object result = expr.evaluate(doc, XPathConstants.NODESET);
            NodeList detailNodeList = (NodeList)result;
            HashMap<String, String> dbColLogNameTypeMap = TemplateDetails.get(this.objName).getColumnTypeDB("" + formNo);
            HashMap<String, String> metaDataColLogNameTypeMap = TemplateDetails.get(this.objName).getColumnTypeMetaDeta("" + formNo);
            HashMap<String, Integer> colLogNameSizeMap = TemplateDetails.get(this.objName).getColumnSize("" + formNo);
            HashMap<String, HashMap<String, String>> colValueItemDropDownMap = TemplateDetails.get(this.objName).getDropDownColValueMap("" + formNo);
            HashMap<String, String> fieldCaseValueMap = TemplateDetails.get(this.objName).getFieldCase("" + formNo);
            HashMap<String, Integer> colLogNamePrecisionMap = TemplateDetails.get(this.objName).getColumnPrecision("" + formNo);
            if (detailNodeList != null) {
                int detailCnt = 0;
                while (detailCnt < detailNodeList.getLength()) {
                    Node detailNode = detailNodeList.item(detailCnt);
                    NodeList detNodeList = detailNode.getChildNodes();
                    String colValue = "";
                    int childNodeCtr = 0;
                    while (childNodeCtr < detNodeList.getLength()) {
                        Node childNode = detNodeList.item(childNodeCtr);
                        String cNodeName = childNode.getNodeName();
                        if (!"#text".equals(cNodeName) && childNode.getFirstChild() != null) {
                            colValue = this.checkNull(childNode.getFirstChild().getNodeValue());
                        }
                        String errorDataStr = this.validateExcelInputData(cNodeName, colValue, metaDataColLogNameTypeMap, dbColLogNameTypeMap, colLogNameSizeMap, colValueItemDropDownMap, colLogNamePrecisionMap);
                        if ((errorDataStr = this.checkNull(errorDataStr)).length() > 0) {
                            detailNodeMap.put("INPUT_DATA_ERR", this.genericUtility.getErrorString("", errorDataStr, "Invalid data!", ""));
                            return detailNodeMap;
                        }
                        if (colValue != "") {
                            colValue = this.fieldCaseData(fieldCaseValueMap, cNodeName, colValue);
                        }
                        ++childNodeCtr;
                    }
                    stringBuffer.append(this.genericUtility.serializeDom(detailNode));
                    ++detailCnt;
                }
                detailNodeMap.put(pkValue, stringBuffer.toString());
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "getNodebypkValue Exception [" + e.getMessage() + "]");
        }
        return detailNodeMap;
    }

    private String getXPathExpr(String pkNames, String pkValues) {
        StringBuffer exprStr = new StringBuffer();
        if (pkNames != null && pkValues != null) {
            String[] pkNameArr = pkNames.split(":");
            String[] pkValueArr = pkValues.split(":");
            int pkNameCtr = 0;
            while (pkNameCtr < pkNameArr.length) {
                exprStr.append(pkNameArr[pkNameCtr]).append("=").append("'" + pkValueArr[pkNameCtr] + "'").append(" and ");
                ++pkNameCtr;
            }
            if (exprStr.toString().endsWith(" and ")) {
                exprStr = new StringBuffer(exprStr.substring(0, exprStr.lastIndexOf(" and ")));
            }
        }
        BaseLogger.log("3", null, null, "exprStr : [" + exprStr + "]");
        return exprStr.toString();
    }

    private String buildDetailData(HashMap<String, String> dataMap, int formNo, String pkValue, int domId, String pkName) {
        StringBuffer detailDataBuff = new StringBuffer();
        detailDataBuff.append("<Detail" + formNo + " dbID='" + pkValue + "' domID='" + domId + "' objName='" + this.objName + "' objContext='" + formNo + "'>");
        detailDataBuff.append("<attribute pkNames='" + pkName + "' status='N' updateFlag='A' selected='N' />");
        for (Map.Entry<String, String> dataEntry : dataMap.entrySet()) {
            String colName = dataEntry.getKey();
            String colValue = dataEntry.getValue();
            detailDataBuff.append("<").append(colName).append(" isDataUpload=\"true\"").append("><![CDATA[").append(colValue).append("]]></").append(colName).append(">");
        }
        detailDataBuff.append("</Detail" + formNo + ">");
        return detailDataBuff.toString();
    }

    private String fieldCaseData(HashMap<String, String> fieldCaseValueMap, String colName, String dataContent) {
        String colCaseVal;
        String finalData = dataContent;
        if (fieldCaseValueMap != null && fieldCaseValueMap.get(colName) != null && (colCaseVal = fieldCaseValueMap.get(colName)).equalsIgnoreCase("upper")) {
            finalData = dataContent.toUpperCase();
        }
        return finalData;
    }

    /*
     * Unable to fully structure code
     */
    private String setCharFieldSpaces(HashMap<String, String> colLogNameTypeMap, HashMap<String, Integer> colLogNameSizeMap, String colName, String colValue) {
        block2: {
            if (colLogNameTypeMap == null || !colLogNameTypeMap.containsKey(colName) || !colLogNameTypeMap.get(colName).equalsIgnoreCase("char")) break block2;
            size = colLogNameSizeMap.get(colName);
            if (!"line_no".equals(colName)) ** GOTO lbl9
            while (colValue.length() != size) {
                colValue = " " + colValue;
            }
            break block2;
lbl-1000:
            // 1 sources

            {
                colValue = String.valueOf(colValue) + " ";
lbl9:
                // 2 sources

                ** while (colValue.length() != size)
            }
        }
        return colValue;
    }

    private String getTempPKVal(HashMap<String, String> parentPkNameMap) {
        String key = "";
        for (Map.Entry<String, String> entry : parentPkNameMap.entrySet()) {
            if (!"MatrixColumn".equals(entry.getValue())) continue;
            key = entry.getKey();
        }
        return key;
    }
}

