package ibase.webitm.ejb.wsfa.masters;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;

import javax.ejb.Stateless;
import javax.naming.InitialContext;

import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.DBAccessLocal;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import ibase.wrkflw.utility.WorkflowLogger;
import oracle.jdbc.OracleConnection;
import oracle.sql.CLOB;

/* 
	 Author Name: Sachin Satre on [19-Jul-18] for Request Id :W18BSUN009
 	 Created Date : 19-Jul-18 
*/

@Stateless
public class StrgSeriesChgConfirmation extends ValidatorEJB   
{
	E12GenericUtility genericUtility = new E12GenericUtility();
	public String doctorChangesConfirm( String tranID ,String xmlData ,String signBy ,String refSer, String SalesPers, String appoverCode,String userInfoStr )throws RemoteException, ITMException
	{
		//String xtraParams ="";
		System.out.println("[StrgSerChgStatConfirmation] doctorChangesConfirm Method called..."+signBy+"]::appoverCode:::["+appoverCode+"]");
		System.out.println("tranID : "+tranID);
		System.out.println("xmlData : "+xmlData);
		System.out.println("refSer : "+refSer);
		boolean isError=false;
		Connection connectionObject = null;		
		PreparedStatement pstmt = null;
		PreparedStatement pstmtInner = null;
		PreparedStatement pstmtCust = null;
		ResultSet rsCust = null;
		ResultSet rs = null;
		ResultSet rsInner = null;
		String childNodeName = "";
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null; 	
		int updCnt = 0;
		int parentNodeListLength = 0;
		int childNodeListLength = 0;	
		int noOfRecProcess = 0;
		String noVisit = "";
		String splCode = "";
		String classCode = "";
		String category = "";
		String noPatientDay = "";
		String businessToUs = "";
		String totalBusiness = "";
		String loginEmpCode = "";
		String chgTerm = "";
		String userId = "";
		String warningStr = "";
		String itemSer = "";
		String spCode = "";
		String scCode = "";
		String routeId = "";
		String status = "";
		String statusx = "";
		String sqlStr = null;
		String qualification="";
		String emailId="";
		String mobileNo="";
		//Statement stmt = null;
		String returnString = "<ROOT><STATUS><![CDATA[1]]></STATUS><RESULT><![CDATA[Success]]></RESULT></ROOT>";
		String updtSql = "";
		String tranId ="";
		String lineNo ="";
		String occuType ="";
		String subSplCode ="";
		String rxMode ="";
		String patientProfile ="";
		String ageBracket ="";
		String assoType ="";
		
		String noVisitExists ="";
		String splCodeExists ="";
		String classCodeExists ="";
		String categoryExists ="";
		String noPatientDayExists ="";
		String businessToUsExists ="";
		String totalBusinessExists ="";
		String qualificationExists ="";
		String mobileNoExists ="";
		String emailIdExists ="";
		
		String occuTypeExists ="";
		String subSplCodeExists ="";
		String rxModeExists ="";
		String patientProfileExists ="";
		String ageBracketExists ="";
		String assoTypeExists ="";
		String updateFlag ="";
		ConnDriver connDriver= null;
		ResultSet rs3 = null;
		PreparedStatement pstmt3 = null;
		ResultSet rs2 = null;
		PreparedStatement pstmt2 = null;
		ResultSet rs4 = null;
		PreparedStatement pstmt4 = null;
		String attachId="";
		try
		{
			
			//ConnDriver connDriver = null;
			//connDriver = new ConnDriver();
			//connectionObject = connDriver.getConnectDB("DriverValidator");
			//connectionObject = connDriver.getConnectDB("DriverITM");
			
			
			//added by mrunalini sinkar on 04-july-2019(start)
			UserInfoBean userInfo = new UserInfoBean(userInfoStr);
			if( userInfo != null && userInfo.getTransDB() != null )
			{
				String transDB = E12GenericUtility.checkNull( userInfo.getTransDB() );
				System.out.println("transDB doctorChangesConfirm is:["+transDB+"]");
				connDriver = new ConnDriver();
				connectionObject = connDriver.getConnectDB(transDB);
			}
			connectionObject.setAutoCommit(false);
			connDriver = null;
			//added by mrunalini sinkar on 04-july-2019(end)

	
			Document dom = genericUtility.parseString(xmlData);
	
			String tourCntSql = "SELECT count(*) as cnt FROM STRG_SERIES_AMD WHERE TRAN_ID = ? AND CONFIRM ='Y' ";
			pstmtInner = connectionObject.prepareStatement(tourCntSql);
			pstmtInner.setString(1, tranID);
			rsInner = pstmtInner.executeQuery();
			int tourCnt = 0;
			if ( rsInner.next() )
			{				
				tourCnt = rsInner.getInt("cnt");
			}
			if ( rsInner != null )
			{
				rsInner.close();
				rsInner = null;
			}
			if ( pstmtInner != null )
			{
				pstmtInner.close();
				pstmtInner = null;
			}
			if (tourCnt == 0)
			{
				System.out.println("Inside the block of tour ID not sibmitted, now will throw exception");
				Exception exp = new Exception("Transaction Not Submitted");
				//generateLog( exp, tourID, "\r\n XML Data received as below : \r\n "+xmlData+" \r\n","TOUR");
				throw new Exception("Tour Not Submitted");
			}
			java.sql.Timestamp chgDate = new java.sql.Timestamp(System.currentTimeMillis()); 
			userId=appoverCode.trim() ;
			parentNodeList = dom.getElementsByTagName("Detail2");
			parentNodeListLength = parentNodeList.getLength(); 
			System.out.println("parentNodeListLengthparentNodeListLength:::::["+parentNodeListLength+"]");
			for (int selectedRow = 0; selectedRow < parentNodeListLength; selectedRow++)
			{
				parentNode = parentNodeList.item(selectedRow);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();
				System.out.println("childNodeListLength::: "+ childNodeListLength+"\n");
				spCode = "";
				scCode = "";
				routeId = "";
				status = "";
				statusx = "";
				itemSer = "";
				noVisit = "";
				splCode = "";
				classCode = "";
				category = "";
				noPatientDay = "";
				businessToUs = "";
				totalBusiness = "";
				qualification="";
				mobileNo="";
				emailId="";
				occuType ="";
				subSplCode ="";
				rxMode ="";
				patientProfile ="";
				ageBracket ="";
				assoType ="";
				noVisitExists ="";
				splCodeExists ="";
				classCodeExists ="";
				categoryExists ="";
				noPatientDayExists ="";
				businessToUsExists ="";
				totalBusinessExists ="";
				qualificationExists ="";
				mobileNoExists ="";
				emailIdExists ="";
				occuTypeExists ="";
				subSplCodeExists ="";
				rxModeExists ="";
				patientProfileExists ="";
				ageBracketExists ="";
				assoTypeExists ="";
				updateFlag ="";
				lineNo ="";
				tranId ="";
				String other_1 ="";
				String retailer_pin ="";
				String pin ="";
				String retailer_addr1 ="";
				String retailer_addr2 ="";
				String retailer_addr3 ="";
				String retailer_tel ="";
				String retailer_tel2 ="";
				String birth_date ="";
				String wedd_aniv ="";
				String reg_no ="";
				attachId="";
				String other_2 ="";
				for (int childRow = 0; childRow < childNodeListLength; childRow++)
				{
					childNode = childNodeList.item(childRow);
					childNodeName = childNode.getNodeName();
					if(childNodeName.equalsIgnoreCase("attribute"))
					{
						updateFlag = childNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
						System.out.println("[getPlaceOfWorkValueFromDom][updateFlag]" +updateFlag);
						if("D".equalsIgnoreCase(updateFlag))
						{
							break;
						}
					}
					if (childNodeName.equals("sales_pers"))
					{
						if(childNode.getFirstChild()!=null)
						{
							spCode = childNode.getFirstChild().getNodeValue();
						}
					}
					if (childNodeName.equals("sc_code"))
					{
						if(childNode.getFirstChild()!=null)
						{
							scCode = childNode.getFirstChild().getNodeValue();
						}
					}
					if (childNodeName.equals("item_ser"))
					{
						if(childNode.getFirstChild()!=null)
						{
							itemSer = childNode.getFirstChild().getNodeValue();
						}
					}
					if (childNodeName.equals("route_id"))
					{
						if(childNode.getFirstChild()!=null)
						{
							routeId = childNode.getFirstChild().getNodeValue();
							if (routeId == null)
							{
								routeId = "";
							}
							System.out.println("routeId :"+routeId);
						}
					}
					if (childNodeName.equals("attach_id"))
					{
						if(childNode.getFirstChild()!=null)
						{
							attachId = childNode.getFirstChild().getNodeValue();
							if (attachId == null)
							{
								attachId = "";
							}
							System.out.println("attachId :"+attachId);
						}
					}
					if (childNodeName.equals("status"))
					{
						if(childNode.getFirstChild()!=null)
						{
							status = childNode.getFirstChild().getNodeValue();
							if (status == null)
							{
								status = "";
							}
							System.out.println("status :"+status);
						}
					}						
					if (childNodeName.equals("status__x"))
					{
						if(childNode.getFirstChild()!=null)
						{
							statusx = childNode.getFirstChild().getNodeValue();
							if (statusx == null)
							{
								statusx = "";
							}
							System.out.println("status__x :"+statusx);
						}
					}
					if (childNodeName.equals("no_visit__o"))
					{
						if(childNode.getFirstChild()!=null)
						{
							noVisit = childNode.getFirstChild().getNodeValue();							
							//System.out.println("[StrgSerChgStatConfirmation][process()][no_visit:::]......"+noVisit);
						}
					}																													
					if (childNodeName.equals("spl_code__o"))
					{
						if(childNode.getFirstChild()!=null)
						{
							splCode = childNode.getFirstChild().getNodeValue();
							if (splCode == null)
							{
								splCode = "";
							}
						//	System.out.println("[StrgSerChgStatConfirmation][process()][spl_code:::]......"+splCode);
						}
					}
					if (childNodeName.equals("class_code__o"))
					{
						if(childNode.getFirstChild()!=null)
						{
							classCode = childNode.getFirstChild().getNodeValue();							
							//System.out.println("[StrgSerChgStatConfirmation][process()][class_code:::]......"+classCode);
						}
					}
					if (childNodeName.equals("category__o"))
					{
						if(childNode.getFirstChild()!=null)
						{
							category = childNode.getFirstChild().getNodeValue();							
							//System.out.println("[StrgSerChgStatConfirmation][process()][category:::]......"+category);
						}
					}
					if (childNodeName.equals("no_patient_day__o"))
					{
						if(childNode.getFirstChild()!=null)
						{
							noPatientDay = childNode.getFirstChild().getNodeValue();							
							//System.out.println("[StrgSerChgStatConfirmation][process()][no_patient_day:::]......"+noPatientDay);
						}
					}
					if (childNodeName.equals("business_to_us__o"))
					{
						if(childNode.getFirstChild()!=null)
						{
							businessToUs = childNode.getFirstChild().getNodeValue();							
							//System.out.println("[StrgSerChgStatConfirmation][process()][business_to_us:::]......"+businessToUs);
						}
					}
					if (childNodeName.equals("total_business__o"))
					{
						if(childNode.getFirstChild()!=null)
						{
							totalBusiness = childNode.getFirstChild().getNodeValue();							
							//System.out.println("[StrgSerChgStatConfirmation][process()][total_business:::]......"+totalBusiness);
						}
					}
					if (childNodeName.equals("qualification__o"))
					{
						qualification="";
						if(childNode.getFirstChild()!=null)
						{
							qualification = childNode.getFirstChild().getNodeValue();	
							qualification=qualification.trim();
						}
						//System.out.println("[StrgSerChgStatConfirmation][process()][qualification:::]...OUT SIDE fgh.sd.SDFSD.."+qualification);
					}
					if (childNodeName.equals("mobile_no__o"))
					{
						mobileNo="";
						if(childNode.getFirstChild()!=null)
						{
							mobileNo = childNode.getFirstChild().getNodeValue();	
							mobileNo=mobileNo.trim();
						}
						//System.out.println("[StrgSerChgStatConfirmation][process()][mobile_no:::].OUT SIDE mobileNo.fgh...."+mobileNo);
					}
					if (childNodeName.equals("email_addr__o"))
					{
						emailId="";
						if(childNode.getFirstChild()!=null)
						{
							emailId = childNode.getFirstChild().getNodeValue();	
							emailId=emailId.trim();
						}
						//System.out.println("[StrgSerChgStatConfirmation][process()][email_addr:::].OUT SIDE fgh..ssd..."+emailId);
					}
					if (childNodeName.equals("occu_type__o"))
					{
						occuType ="";
						if(childNode.getFirstChild()!=null)
						{
							occuType = childNode.getFirstChild().getNodeValue();							
							//System.out.println("[StrgSerChgStatConfirmation][process()][occu_type__o:::]......"+occuType);
						}
					}
					if (childNodeName.equals("sub_spl_code__o"))
					{
						subSplCode ="";
						if(childNode.getFirstChild()!=null)
						{
							subSplCode = childNode.getFirstChild().getNodeValue();							
							//System.out.println("[StrgSerChgStatConfirmation][process()][sub_spl_code__o:::]......"+subSplCode);
						}
					}
					if (childNodeName.equals("rx_mode__o"))
					{
						rxMode ="";
						if(childNode.getFirstChild()!=null)
						{
							rxMode = childNode.getFirstChild().getNodeValue();							
							//System.out.println("[StrgSerChgStatConfirmation][process()][rx_mode__o:::]......"+rxMode);
						}
					}
					if (childNodeName.equals("asso_type__o"))
					{
						assoType="";
						if(childNode.getFirstChild()!=null)
						{
							assoType = childNode.getFirstChild().getNodeValue();	
							assoType=assoType.trim();
						}
						//System.out.println("[StrgSerChgStatConfirmation][process()][assoType:::]...OUT SIDE fgh.sd.SDFSD.."+assoType);
					}
					if (childNodeName.equals("patient_profile__o"))
					{
						patientProfile="";
						if(childNode.getFirstChild()!=null)
						{
							patientProfile = childNode.getFirstChild().getNodeValue();	
							patientProfile=patientProfile.trim();
						}
						//System.out.println("[StrgSerChgStatConfirmation][process()][patient_profile__o:::].OUT SIDE mobileNo.fgh...."+patientProfile);
					}
					if (childNodeName.equals("age_bracket__o"))
					{
						ageBracket="";
						if(childNode.getFirstChild()!=null)
						{
							ageBracket = childNode.getFirstChild().getNodeValue();	
							ageBracket = ageBracket.trim();
						}
						//System.out.println("[StrgSerChgStatConfirmation][process()][ageBracket:::].OUT SIDE fgh..ssd..."+ageBracket);
					}
					if (childNodeName.equals("tran_id"))
					{
						if(childNode.getFirstChild()!=null)
						{
							tranId = childNode.getFirstChild().getNodeValue();	
							tranId = tranId.trim();
						}
						//System.out.println("[StrgSerChgStatConfirmation][process()][tran_id:::].OUT SIDE fgh..ssd..."+tranId);
					}
					if (childNodeName.equals("line_no"))
					{
						if(childNode.getFirstChild()!=null)
						{
							lineNo = childNode.getFirstChild().getNodeValue();	
							lineNo = lineNo.trim();
						}
						//System.out.println("[StrgSerChgStatConfirmation][process()][lineNo:::].OUT SIDE fgh..ssd..."+lineNo);
					}
					
					if (childNodeName.equals("no_visit"))
					{
						if(childNode.getFirstChild()!=null)
						{
							noVisitExists = childNode.getFirstChild().getNodeValue();							
							System.out.println("[StrgSerChgStatPrc][process()][no_visit:::]......"+noVisitExists);
						}
					}																													
					if (childNodeName.equals("spl_code"))
					{
						if(childNode.getFirstChild()!=null)
						{
							splCodeExists = childNode.getFirstChild().getNodeValue();
							if (splCodeExists == null)
							{
								splCodeExists = "";
							}
							//System.out.println("[StrgSerChgStatPrc][process()][spl_code:::]......"+splCodeExists);
						}
					}
					if (childNodeName.equals("class_code"))
					{
						if(childNode.getFirstChild()!=null)
						{
							classCodeExists = childNode.getFirstChild().getNodeValue();							
							//System.out.println("[StrgSerChgStatPrc][process()][class_code:::]......"+classCodeExists);
						}
					}
					if (childNodeName.equals("category"))
					{
						if(childNode.getFirstChild()!=null)
						{
							categoryExists = childNode.getFirstChild().getNodeValue();							
							//System.out.println("[StrgSerChgStatPrc][process()][category:::]......"+categoryExists);
						}
					}
					if (childNodeName.equals("no_patient_day"))
					{
						if(childNode.getFirstChild()!=null)
						{
							noPatientDayExists = childNode.getFirstChild().getNodeValue();							
							System.out.println("[StrgSerChgStatPrc][process()][no_patient_day:::]......"+noPatientDayExists);
						}
					}
					if (childNodeName.equals("business_to_us"))
					{
						if(childNode.getFirstChild()!=null)
						{
							businessToUsExists = childNode.getFirstChild().getNodeValue();							
							//System.out.println("[StrgSerChgStatPrc][process()][business_to_us:::]......"+businessToUsExists);
						}
					}
					if (childNodeName.equals("total_business"))
					{
						if(childNode.getFirstChild()!=null)
						{
							totalBusinessExists = childNode.getFirstChild().getNodeValue();							
							//System.out.println("[StrgSerChgStatPrc][process()][total_business:::]......"+totalBusinessExists);
						}
					}
					
					if (childNodeName.equals("qualification"))
					{
						if(childNode.getFirstChild()!=null)
						{
							qualificationExists = childNode.getFirstChild().getNodeValue();	
							qualificationExists=qualificationExists.trim();
						//	System.out.println("[StrgSerChgStatPrc][process()][qualification:::].INSIDE fgh.sd..."+qualification);
						}
						//System.out.println("[StrgSerChgStatPrc][process()][qualification:::]...OUT SIDE fgh.sd.SDFSD.."+qualificationExists);
					}
					if (childNodeName.equals("mobile_no"))
					{
						//mobileNo="";
						if(childNode.getFirstChild()!=null)
						{
							mobileNoExists = childNode.getFirstChild().getNodeValue();	
							mobileNoExists=mobileNoExists.trim();
							//System.out.println("[StrgSerChgStatPrc][process()][mobile_no:::] INSIDE.mobileNo.fgh...."+mobileNo);
						}
						//System.out.println("[StrgSerChgStatPrc][process()][mobile_no:::].OUT SIDE mobileNo.fgh...."+mobileNoExists);
					}
					if (childNodeName.equals("email_addr"))
					{
						if(childNode.getFirstChild()!=null)
						{
							emailIdExists = childNode.getFirstChild().getNodeValue();	
							emailIdExists = emailIdExists.trim();
							//System.out.println("[StrgSerChgStatPrc][process()][email_addr:::].INSIDE fgh..ssd..."+emailId);
						}
						//System.out.println("[StrgSerChgStatPrc][process()][email_addr:::].OUT SIDE fgh..ssd..."+emailIdExists);
					}
					if (childNodeName.equals("occu_type"))
					{
						if(childNode.getFirstChild()!=null)
						{
							occuTypeExists = childNode.getFirstChild().getNodeValue();							
							//System.out.println("[StrgSerChgStatConfirmation][process()][occu_type__o:::]......"+occuTypeExists);
						}
					}
					if (childNodeName.equals("sub_spl_code"))
					{
						if(childNode.getFirstChild()!=null)
						{
							subSplCodeExists = childNode.getFirstChild().getNodeValue();							
							//System.out.println("[StrgSerChgStatConfirmation][process()][sub_spl_code__o:::]......"+subSplCodeExists);
						}
					}
					if (childNodeName.equals("rx_mode"))
					{
						if(childNode.getFirstChild()!=null)
						{
							rxModeExists = childNode.getFirstChild().getNodeValue();							
							//System.out.println("[StrgSerChgStatConfirmation][process()][rx_mode__o:::]......"+rxModeExists);
						}
					}
					if (childNodeName.equals("asso_type"))
					{
						if(childNode.getFirstChild()!=null)
						{
							assoTypeExists = childNode.getFirstChild().getNodeValue();	
							assoTypeExists = assoTypeExists.trim();
						}
						//System.out.println("[StrgSerChgStatConfirmation][process()][assoType:::]...OUT SIDE fgh.sd.SDFSD.."+assoTypeExists);
					}
					if (childNodeName.equals("patient_profile"))
					{
						if(childNode.getFirstChild()!=null)
						{
							patientProfileExists = childNode.getFirstChild().getNodeValue();	
							patientProfileExists = patientProfileExists.trim();
						}
						//System.out.println("[StrgSerChgStatConfirmation][process()][patient_profile__o:::].OUT SIDE mobileNo.fgh...."+patientProfileExists);
					}
					if (childNodeName.equals("age_bracket"))
					{
						if(childNode.getFirstChild()!=null)
						{
							ageBracketExists = childNode.getFirstChild().getNodeValue();	
							ageBracketExists = ageBracketExists.trim();
						}
						//System.out.println("[StrgSerChgStatConfirmation][process()][ageBracket:::].OUT SIDE fgh..ssd..."+ageBracketExists);
					}
					//Added by Sachin Satre on [09-Jan-19] for other_1 and other_2 field added [start]
					if (childNodeName.equals("other_1__o"))
					{
						other_1="";
						if(childNode.getFirstChild()!=null)
						{
							other_1 = childNode.getFirstChild().getNodeValue();	
							other_1=other_1.trim();
						}
					}
					if (childNodeName.equals("other_2__o"))
					{
						other_2="";
						if(childNode.getFirstChild()!=null)
						{
							other_2 = childNode.getFirstChild().getNodeValue();	
							other_2=other_2.trim();
						}
					}
					//Added by Sachin Satre on [09-Jan-19] for other_1 and other_2 field added [End]
					if (childNodeName.equals("tele1__o"))
					{
						retailer_tel="";
						if(childNode.getFirstChild()!=null)
						{
							retailer_tel = childNode.getFirstChild().getNodeValue();	
							retailer_tel=retailer_tel.trim();
						}
					}
					if (childNodeName.equals("res_tele1__o"))
					{
						retailer_tel2="";
						if(childNode.getFirstChild()!=null)
						{
							retailer_tel2 = childNode.getFirstChild().getNodeValue();	
							retailer_tel2=retailer_tel2.trim();
						}
					}
					if (childNodeName.equals("pin__o"))
					{
						pin="";
						if(childNode.getFirstChild()!=null)
						{
							pin = childNode.getFirstChild().getNodeValue();	
							pin=pin.trim();
						}
					}
					if (childNodeName.equals("res_pin__o"))
					{
						retailer_pin="";
						if(childNode.getFirstChild()!=null)
						{
							retailer_pin = childNode.getFirstChild().getNodeValue();	
							retailer_pin=retailer_pin.trim();
						}
					}
					if (childNodeName.equals("res_addr1__o"))
					{
						retailer_addr1="";
						if(childNode.getFirstChild()!=null)
						{
							retailer_addr1 = childNode.getFirstChild().getNodeValue();	
							retailer_addr1=retailer_addr1.trim();
						}
					}
					if (childNodeName.equals("res_addr2__o"))
					{
						retailer_addr2="";
						if(childNode.getFirstChild()!=null)
						{
							retailer_addr2 = childNode.getFirstChild().getNodeValue();	
							retailer_addr2=retailer_addr2.trim();
						}
					}
					if (childNodeName.equals("res_addr3__o"))
					{
						retailer_addr3="";
						if(childNode.getFirstChild()!=null)
						{
							retailer_addr3 = childNode.getFirstChild().getNodeValue();	
							retailer_addr3=retailer_addr3.trim();
						}
					}
					
					if (childNodeName.equals("birth_date__o"))
					{
						birth_date="";
						if(childNode.getFirstChild()!=null)
						{
							birth_date = childNode.getFirstChild().getNodeValue();	
							birth_date=birth_date.trim();
						}
					}
					if (childNodeName.equals("wedd_aniv__o"))
					{
						wedd_aniv="";
						if(childNode.getFirstChild()!=null)
						{
							wedd_aniv = childNode.getFirstChild().getNodeValue();	
							wedd_aniv=wedd_aniv.trim();
						}
					}
					if (childNodeName.equals("reg_no__o"))
					{
						reg_no="";
						if(childNode.getFirstChild()!=null)
						{
							reg_no = childNode.getFirstChild().getNodeValue();	
							reg_no=reg_no.trim();
						}
					}
				} //for (int childRow = 0; childRow < childNodeListLength; childRow++)
				
				
				
				if ((!status.equalsIgnoreCase("Y") && !status.equalsIgnoreCase("N")))
				{
					continue;
				}
				noOfRecProcess++;
				int scCodeCnt = 0;
				sqlStr = "SELECT COUNT(*) AS CNT " + 
						 "FROM STRG_CUSTOMER,SPRS_ROUTE " + 
						 "WHERE STRG_CUSTOMER.SC_CODE = SPRS_ROUTE.SPRS_CODE(+) " + 
						 "AND STRG_CUSTOMER.SC_CODE = '" + scCode + "' " + 
						 "AND (STRG_CUSTOMER.STATUS = 'N'	OR SPRS_ROUTE.STATUS = 'N') ";
				System.out.println("sqlStr :"+sqlStr);
				pstmt = connectionObject.prepareStatement(sqlStr);
				rs = pstmt.executeQuery();
				while (rs.next())
				{
					scCodeCnt = rs.getInt("CNT");
				}
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if (scCodeCnt <= 0)
				{
					sqlStr = "UPDATE STRG_SERIES " +
							 "SET REPLY_STATUS = '0' ," +
							 "CHG_USER = ? , " +
							 "CHG_DATE = ? " +
						//	 "CHG_TERM = ? " + // Changed by sachin satre on [23-Jul-18] for request Id :  W18BSUN009
							 "WHERE SALES_PERS = '" + spCode + "' " +
							 "AND SC_CODE = '" + scCode + "' ";
					System.out.println("@@@@ sqlStr :"+sqlStr);
					pstmt = connectionObject.prepareStatement(sqlStr);
					pstmt.setString(1 , userId);
					pstmt.setTimestamp(2,chgDate);
					//pstmt.setString(3 , chgTerm);
					updCnt = 0;
					updCnt = pstmt.executeUpdate();
					if (updCnt > 0)
					{
						System.out.println("@@@@ Updated into STRG_SERIES successfully [updCnt] :"+updCnt);
					}
					if ( pstmt != null )
					{
						pstmt.close();
						pstmt = null;
					}
				}
				else
				{
					sqlStr = "SELECT COUNT(*) AS CNT FROM STRG_CUSTOMER " + 
							 "WHERE STRG_CUSTOMER.SC_CODE = '" + scCode + "' " + 
							 "AND STRG_CUSTOMER.STATUS = 'N' " ;
					System.out.println("sqlStr :"+sqlStr);
					//rs = stmt.executeQuery(sqlStr);
					pstmt = connectionObject.prepareStatement(sqlStr);
					rs = pstmt.executeQuery();
					if (rs.next())
					{
						scCodeCnt = rs.getInt("CNT");
						if (scCodeCnt > 0)
						{
							warningStr = warningStr + "Customer is not active [" + scCode + "]\n";
						}
					}
					if ( rs != null )
					{
						rs.close();
						rs = null;
					}
					if ( pstmt != null )
					{
						pstmt.close();
						pstmt = null;
					}
					sqlStr = "SELECT COUNT(*) AS CNT FROM SPRS_ROUTE " + 
							 "WHERE SPRS_ROUTE.SPRS_CODE = '" + scCode + "' " + 
							 "AND SPRS_ROUTE.STATUS = 'N' " ;
					System.out.println("sqlStr :"+sqlStr);
					//rs = stmt.executeQuery(sqlStr);
					pstmt = connectionObject.prepareStatement(sqlStr);
					rs = pstmt.executeQuery();
					if (rs.next())
					{
						scCodeCnt = rs.getInt("CNT");
						if (scCodeCnt > 0)
						{
							warningStr = warningStr + "Route is not active [" + routeId + "]\n";
						}
					}
					if ( rs != null )
					{
						rs.close();
						rs = null;
					}
					if ( pstmt != null )
					{
						pstmt.close();
						pstmt = null;
					}
				}
				if ( statusx != null && !statusx.trim().equals("") )
				{
					java.util.Calendar dateCreated = java.util.Calendar.getInstance();
					java.text.DateFormat dtf = new java.text.SimpleDateFormat(genericUtility.getApplDateFormat());
					String sysDate = dtf.format(dateCreated.getTime());
					System.out.println("@@@@ sysDate===>>"+sysDate);
                   
					System.out.println("@@@@ outside  status 'Y' condition"+status+"@@@ In statusx 'N' condtion"+statusx);
					if (status != null && status.equalsIgnoreCase("Y") && statusx.equalsIgnoreCase("N"))
					{
						sqlStr = "UPDATE STRG_SERIES SET TOTAL_BUSINESS = '" +totalBusiness+ "',BUSINESS_TO_US = '" +businessToUs+ "',NO_PATIENT_DAY = '" +noPatientDay+ "' " +
								/*", QUALIFICATION ='"+ qualification+ "' "+
								", OCCU_TYPE ='"+ occuType+ "' "+
								", SUB_SPL_CODE ='"+ subSplCode+ "' "+
								", RX_MODE ='"+ rxMode+ "' "+
								", ASSO_TYPE ='"+ assoType+ "' "+
								", PATIENT_PROFILE ='"+ patientProfile+ "' "+
								", AGE_BRACKET ='"+ ageBracket+ "' "+
								//Added by Sachin Satre on [09-Jan-19] for other_1 and other_2 field added [End]
								", OTHER_1 ='"+ other_1+ "' "+
								", OTHER_2 ='"+ other_2+ "' "+*/
								//Added by Sachin Satre on [09-Jan-19] for other_1 and other_2 field added [End]
								" WHERE ITEM_SER = '" + itemSer + "' " + 
								" AND SALES_PERS = '" + spCode + "' " + 
								" AND SC_CODE = '" + scCode + "' " +
								" AND ROUTE_ID = '" + routeId + "'";
					}
					else
					{
						System.out.println("@@@@ In else of status 'Y' condition"+status);
						//System.out.println("in else conditionn qualification:::["+qualification+"]::mobileNo::["+mobileNo+"]::emailId:::>>::["+emailId+"]");
						sqlStr = "UPDATE STRG_SERIES SET TOTAL_BUSINESS = '" +totalBusiness+ "',BUSINESS_TO_US = '" +businessToUs+ "',NO_PATIENT_DAY = '" +noPatientDay+ "' " +
								/*", QUALIFICATION ='"+ qualification+ "' "+
								", OCCU_TYPE ='"+ occuType+ "' "+
								", SUB_SPL_CODE ='"+ subSplCode+ "' "+
								", RX_MODE ='"+ rxMode+ "' "+
								", ASSO_TYPE ='"+ assoType+ "' "+
								", PATIENT_PROFILE ='"+ patientProfile+ "' "+
								", AGE_BRACKET ='"+ ageBracket+ "' "+
								//Added by Sachin Satre on [09-Jan-19] for other_1 and other_2 field added [End]
								", OTHER_1 ='"+ other_1+ "' "+
								", OTHER_2 ='"+ other_2+ "' "+*/
								//Added by Sachin Satre on [09-Jan-19] for other_1 and other_2 field added [End]
								" WHERE ITEM_SER = '" + itemSer + "' " + 
								" AND SALES_PERS = '" + spCode + "' " + 
								" AND SC_CODE = '" + scCode + "' " +
								" AND ROUTE_ID = '" + routeId + "'";
					}
					
					System.out.println("@@@@ updated sqlStr :"+sqlStr);
					pstmt = connectionObject.prepareStatement(sqlStr);
					updCnt = 0;
					updCnt = pstmt.executeUpdate();
					System.out.println("::Updated into STRG_SERIES successfully [updCnt] SS:"+updCnt);
					if (updCnt > 0)
					{
						String updateSql ="UPDATE  STRG_SERIES_AMD SET WF_STATUS ='S'  WHERE TRAN_ID = '" + tranId + "' AND LINE_NO = '" + lineNo + "' ";
						pstmtInner = connectionObject.prepareStatement(updateSql);
						updCnt = 0;
						updCnt = pstmtInner.executeUpdate();
						System.out.println("updCnt:in amd table:::::["+updCnt+"]");
						if ( pstmtInner != null )
						{
							pstmtInner.close();
							pstmtInner = null;
						}
					}
					String custSql="UPDATE STRG_CUSTOMER SET"
							        +" BIRTH_DATE = '" +birth_date.trim() + "'"
							        +", REG_NO = '" +reg_no.trim() + "'"
							        +", WEDD_ANIV = '" +wedd_aniv.trim() + "'"
									+", PIN ='"+ pin+ "' "
									+", RES_PIN ='"+ retailer_pin+ "' "
									+", TELE1 ='"+ retailer_tel+ "' "
									+", RES_TELE1 ='"+ retailer_tel2+ "' "
									+", MOBILE_NO ='"+ mobileNo+ "' "
							      	+", EMAIL_ADDR ='"+ emailId+ "' "
									+", RES_ADDR1 ='"+ retailer_addr1+ "' "
									+", RES_ADDR2 ='"+ retailer_addr2+ "' "
									+", RES_ADDR3 ='"+ retailer_addr3+ "' "
						        	+"  WHERE SC_CODE = '" + scCode +"' ";
					pstmtCust=connectionObject.prepareStatement(custSql);
					pstmtCust.executeUpdate();
					
					if ( pstmtCust != null )
					{
						pstmtCust.close();
						pstmtCust = null;
					}
					
					pstmt.close();
					pstmt = null;
					
				}
				
				
				String salesPerson="", itemSeries="";
				
				String salesPersSql="Select sales_pers,item_ser from sales_pers where sales_pers = ?";
				pstmt2=connectionObject.prepareStatement(salesPersSql);
				pstmt2.setString(1,spCode);

				rs2 = pstmt2.executeQuery();	
				if(rs2.next())
				{
					salesPerson = rs2.getString("sales_pers");	
					itemSeries = rs2.getString("item_ser");	
					
				}
				if ( rs2 != null )
				{
					rs2.close();
					rs2 = null;
				}
				if ( pstmt2 != null )
				{
					pstmt2.close();
					pstmt2 = null;
				}
				System.out.println("attachId ======:::"+attachId+ "]");				
				String refId=scCode+":"+itemSeries+":"+salesPerson+":"+routeId;
				String docId="";
				System.out.println("refId ======:::["+refId+ "]");
				String docTransactionLinkSelect="Select DOC_ID, REF_SER, REF_ID, REF_COL,FILE_LOC,UUID_REFID,DOC_TYPE_ATTACH,FILE_TYPE_ATTACH,DOC_UUID,DOCUMENT_PATH from DOC_TRANSACTION_LINK where ref_id = ?";					
				pstmt2=connectionObject.prepareStatement(docTransactionLinkSelect);
				pstmt2.setString(1,attachId.trim());				
					
				rs2 = pstmt2.executeQuery();	
				while(rs2.next())
				{
					docId = checkNull(rs2.getString("DOC_ID"));	
																			
					String docTransactionLinkInsert="INSERT INTO DOC_TRANSACTION_LINK (DOC_ID, REF_SER, REF_ID, REF_COL,FILE_LOC,UUID_REFID,DOC_TYPE_ATTACH,FILE_TYPE_ATTACH,DOC_UUID,DOCUMENT_PATH) "
							+ "VALUES (?,?,?,?,?,?,?,?,?,?)";
					pstmt3 = connectionObject.prepareStatement(docTransactionLinkInsert);
					pstmt3.setString(1, docId);
					pstmt3.setString(2, "S-SER");
					pstmt3.setString(3, refId);
					pstmt3.setString(4, checkNull(rs2.getString("REF_COL")));
					pstmt3.setString(5, checkNull(rs2.getString("FILE_LOC")));
					pstmt3.setString(6, checkNull(rs2.getString("UUID_REFID")));
					pstmt3.setString(7, checkNull(rs2.getString("DOC_TYPE_ATTACH")));
					pstmt3.setString(8, checkNull(rs2.getString("FILE_TYPE_ATTACH")));
					pstmt3.setString(9, checkNull(rs2.getString("DOC_UUID")));
					pstmt3.setString(10,checkNull(rs2.getString("DOCUMENT_PATH")));
					int insCount = pstmt3.executeUpdate();
					System.out.println("insCount into DOC_TRANSACTION_LINK[ "+insCount+ "]");
					if(pstmt3!=null)
					{
						pstmt3.close();
						pstmt3=null;
					}							
																		
				}
				if ( rs2 != null )
				{
					rs2.close();
					rs2 = null;
				}
				if ( pstmt2 != null )
				{
					pstmt2.close();
					pstmt2 = null;
				}		
				
			
			}
			/*if ( noOfRecProcess == 0 ) 
			{
				returnString = "<?xml version=\"1.0\"?><Root><Errors><error id=\"VPROCESS1\" type=\"E\" column_name=\"\"><message>Process Not Done </message><description>No data Found For Process </description><type>E</type><option>Y</option><time>null</time><alarm>null</alarm><source>null</source><trace></trace><redirect>1</redirect></error></Errors></Root>";
			}*/
		}
		catch (SQLException se)
		{
			try
			{
				isError=true;
				connectionObject.rollback();
			}
			catch(Exception sqe)
			{
				sqe.printStackTrace();
				isError=true; 
				returnString = "<ROOT><STATUS><![CDATA[0]]></STATUS><RESULT><![CDATA[Rollback failed during SQLException]]></RESULT></ROOT>";
           }
 			returnString = "<ROOT><STATUS><![CDATA[0]]></STATUS><RESULT><![CDATA[Some SQLException occurred ]]></RESULT></ROOT>";

		}
		catch( Exception ex )
		{
			try
			{
				connectionObject.rollback();
				isError=true;
			}
			catch(Exception e)
			{
				e.printStackTrace();
				isError=true;
            }
			returnString = "<ROOT><STATUS><![CDATA[0]]></STATUS><RESULT><![CDATA[Some other Exception came]]></RESULT></ROOT>";
		}
		finally
		{
			try
			{
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(!isError)
				{
					connectionObject.commit();
					System.out.println("Connection committed.");
				}
				if(connectionObject != null)
				{
					connectionObject.close();
					connectionObject = null;
				}				
			}
			catch ( Exception e)
			{
				e.printStackTrace();
			}		
		}
		return returnString;
	}
	public String rejectionUpdate(String tranId,String userInfostr) throws RemoteException, ITMException 
	{

		System.out.println("rejectionUpdate CAALED");
		Connection conn = null;
		ConnDriver connDriver = null;
		
		PreparedStatement pStmt = null;
		//ConnDriver connDriver = null;
		boolean isError = false;
		int upateCnt =0;
		String salesPers ="";
		ResultSet rs1= null;
		ResultSet rs2= null;
		PreparedStatement pstmt1 = null;
		PreparedStatement pstmt2 = null; 
		int stpCount=0;
		String retString = "<ROOT><STATUS><![CDATA[1]]></STATUS><RESULT><![CDATA[ Rejected successfully ]]></RESULT></ROOT>";
		try
		{
			
			//added by mrunalini sinkar on 27-April-2018(start)
			UserInfoBean userInfo = new UserInfoBean(userInfostr);
			if( userInfo != null && userInfo.getTransDB() != null )
			{
				String transDB = E12GenericUtility.checkNull( userInfo.getTransDB() );
				System.out.println("transDB rejectionUpdate is:["+transDB+"]");
				connDriver = new ConnDriver();
				conn = connDriver.getConnectDB(transDB);
			}
			conn.setAutoCommit(false);
			connDriver = null;
			
			//connDriver = new ConnDriver();
			//conn = getConnection();
			//connDriver = null;
			//added by mrunalini sinkar on 27-April-2018(end)

			
			

			System.out.println("tran_id ..> " + tranId);
			tranId = checkNull(tranId);
			int updCnt = 0;

			String sql = "UPDATE STRG_SERIES_AMD SET WF_STATUS = 'O' , CONFIRM='N' WHERE TRAN_ID = ?"; //confirm
			pStmt = conn.prepareStatement(sql);
			pStmt.setString(1, tranId);
			updCnt = pStmt.executeUpdate();
			pStmt.clearParameters();
			System.out.println("in rejection records updated count is >>> "+updCnt);
			
			if(updCnt == 0)
			{
				retString = "<ROOT><STATUS><![CDATA[0]]></STATUS><RESULT><![CDATA[ Rejection Update failed for tran_id "+tranId+"  ]]></RESULT></ROOT>";
			}
			if(pStmt != null)
			{
				pStmt.close();
				pStmt = null;
			}
			System.out.println("updCntupdCnt:::["+updCnt+"]");
		} 
		catch (Exception e) 
		{
			isError = true;
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally 
		{
			if (conn != null) 
			{
				try 
				{
					if (isError) 
					{
						conn.rollback();
						System.out.println("StrgSerChgStatConfirmation Connection Rollback");
					} 
					else 
					{
						conn.commit();
						System.out.println("StrgSerChgStatConfirmation Connection Commit");
					}
					if(pStmt != null)
					{
						pStmt.close();
						pStmt = null;
					}
					if(conn != null)
					{
						conn.close();
						conn = null;
					}													
					
				}
				catch (Exception e) 
				{
					e.printStackTrace();
				}
			}
		}
		return retString;
	}
	private String checkNull(String input)
	{
		if (input==null)
		{
			input="";
		}
		else
		{
			input = input.trim();
		}
		return input;
	}
	public String getObjSignTransXmlData(String refSer,String refId,Connection conn) throws ITMException
	{
		System.out.println("getXmlDataObjSign called:::");
		System.out.println("");
		String retStr= "";
		try
		{
			String query1 = "";						
			
			if ( "oracle".equalsIgnoreCase( CommonConstants.DB_NAME )) 
			{
				query1 =  "SELECT WF.TRANS_INFO_XML.getClobval() FROM obj_sign_trans WF WHERE REF_SER = ? AND REF_ID = ? AND SIGN_STATUS = 'R' ";
			}
			else
			{
				query1 = "SELECT TRANS_INFO_XML FROM obj_sign_trans  WHERE REF_SER = ? AND REF_ID = ?  AND SIGN_STATUS = 'R' ";
			}	
			
			ArrayList bindVarValues1 = new ArrayList();
			bindVarValues1.add(refSer.trim());
			bindVarValues1.add(refId.trim());
			
			ArrayList bindVarTypes1 = new ArrayList();
			bindVarTypes1.add("String");
			
			//For DB2 Compatibility
			bindVarTypes1.add("Int");
			
			
			System.out.println("Getting BLOB obj signtrans from DBAccessEJB in SignManagerEJB sign4");
			String wfData1 ="";
			if( "oracle".equalsIgnoreCase( CommonConstants.DB_NAME ) )
			{	
				retStr = getXMLTypeStr( conn, query1, bindVarValues1, bindVarTypes1 );
			}
			else
			{
				retStr = getDBAccessObj().getBlob(query1, bindVarValues1, bindVarTypes1);
			}
			
			
		} 
		catch (Exception e) 
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		System.out.println("retStr string in getXmlDataObjSign::["+retStr+"]");
		return retStr;
		
	}
	private String getXMLTypeStr( Connection con, String query, ArrayList bindVarValues, ArrayList bindVarTypes) throws RemoteException, ITMException
	{
		System.out.println("@@@@ inside getXMLTypeStr with query :[ "+query+" ] bindVarValues :[ "+bindVarValues.toString()+" ] bindVarTypes :[ "+bindVarTypes+" ]");
		String dataStr = "";
		PreparedStatement pStmt = null;
		try
		{
			pStmt = con.prepareStatement(query);
			for (int ctr = 0; ctr < bindVarValues.size(); ctr++ )
			{
				if ( ((String)bindVarTypes.get(ctr)).indexOf("String") != -1)
				{
					pStmt.setString((ctr+1), (String)bindVarValues.get(ctr));
				}
				else if (((String)bindVarTypes.get(ctr)).indexOf("Int") != -1)
				{
					pStmt.setInt((ctr+1), Integer.parseInt((String)bindVarValues.get(ctr)) );
				}
			}
			
			ResultSet rs = pStmt.executeQuery();
			if (rs.next())
			{
				dataStr = (rs.getString(1) == null) ?"":rs.getString(1);
			}
			
			if (dataStr != null && dataStr.length() > 0 && dataStr.indexOf("</DocumentRoot>") != -1)
			{
				dataStr = dataStr.substring(0, dataStr.indexOf("</DocumentRoot>") + 15);
			}
			else if (dataStr != null && dataStr.length() > 0 && dataStr.indexOf("</Root>") != -1)
			{
				dataStr = dataStr.substring(0, dataStr.indexOf("</Root>") + 7);
			}
			rs.close();
			rs = null;
			pStmt.close();
			pStmt = null;
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{				
				if(pStmt != null)
				{
					pStmt.close();
					pStmt = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception :DBAccessEJB :getXMLTypeStr :==>finally\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		return dataStr;
	}
	private DBAccessLocal getDBAccessObj() throws ITMException
	{
		DBAccessLocal dbAccess = null;
		try
		{
			dbAccess = (DBAccessLocal)getInitialContext().lookup("ibase/DBAccessEJB/local");
		}
		catch (Exception e)
		{
			WorkflowLogger.info("Exception :SignManagerEJB :getDBAccessObj() :==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		return dbAccess;
	}
	private InitialContext getInitialContext()throws ITMException
	{
		InitialContext ctx = null;
		try
		{
			AppConnectParm appConnect = new AppConnectParm();
			ctx = new InitialContext(appConnect.getProperty());
		}
		catch(ITMException be)
		{
			throw be;
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		return ctx;
	}
	public String updateRejectedRemark(String domString, Connection conn) throws ITMException
	{
		System.out.println("updateAprvRemark() method called....["+domString+"]sd");
		String retStr="";
		PreparedStatement pStmt = null;
		Connection connectionObject = null;		
		ResultSet rs = null; 
		NodeList parentNodeList = null;
		Node parentNode = null;
		NodeList childNodeList = null;
		int childNodeListLength = 0;
		Node childNode = null;
		String childNodeName = "";
        Element nodeElement = null;
		int parentNodeListLength = 0;
		String refSer="";
		String refId="";
		String lineNo="";
		String roleCodeSign="";
		String signRemark="";
		String roleEntity="";
		String signStatus="";
		String signRemarkNew="",refSerNew="",trnID="",roleCodesign="",signStatusNew="";;
		Document dom =null;
		Document dom2 =null;
		Document dom1 =null;
		HashMap<String,String> signRamarkHM=  new HashMap<String, String>();
		String dataString ="";
		String dataStr ="";
		boolean isUpdate=false;
		boolean isError=false;
		String query="";
		String dataStrWfData="";
		String dataStringWfData="";
		String prcInst= "";
		String processId = "";
		String instanceId = "";
		try 
		{

			if (domString.trim().length() > 0 )
			{
				dom = genericUtility.parseString(domString);
			}
			refSerNew = genericUtility.getColumnValue("ref_ser",dom,"1");
			trnID = genericUtility.getColumnValue("ref_id",dom,"1");
			signStatusNew = genericUtility.getColumnValue("sign_status",dom,"1");
			signRemarkNew = genericUtility.getColumnValue("sign_remarks",dom,"1");
			roleCodesign = genericUtility.getColumnValue("role_code__sign",dom,"1");	
			parentNodeList = dom.getElementsByTagName("Detail1");
			parentNodeListLength = parentNodeList.getLength(); 
			for (int selectedRow = 0; selectedRow < parentNodeListLength; selectedRow++)
			{				
				parentNode = parentNodeList.item(selectedRow);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();
				
				for (int childRow = 0; childRow < childNodeListLength; childRow++)
				{
					childNode = childNodeList.item(childRow);
					childNodeName = childNode.getNodeName();
					if (childNodeName.equalsIgnoreCase("ref_ser"))
					{
						if(childNode.getFirstChild()!=null)
						{
							refSer = childNode.getFirstChild().getNodeValue();
						}
						//System.out.println("refSer::["+refSer+"]");
					}
					if (childNodeName.equalsIgnoreCase("ref_id"))
					{
						if(childNode.getFirstChild()!=null)
						{
							refId = checkNull(childNode.getFirstChild().getNodeValue());
						}
						//System.out.println("refId::["+refId+"]");
					}					
					if (childNodeName.equalsIgnoreCase("line_no"))
					{
						if(childNode.getFirstChild()!=null)
						{
							lineNo = checkNull(childNode.getFirstChild().getNodeValue());
						}
						//System.out.println("lineNo::["+lineNo+"]");
					}	
					if (childNodeName.equalsIgnoreCase("role_code__sign"))//role_code__sign
					{
						if(childNode.getFirstChild()!=null)
						{
							roleCodeSign = checkNull(childNode.getFirstChild().getNodeValue());
						}
						//System.out.println("roleCodeSign::["+roleCodeSign+"]");
					}	
					
					if (childNodeName.equalsIgnoreCase("sign_remarks"))//sign_remarks
					{
						if(childNode.getFirstChild()!=null)
						{
							signRemark = checkNull(childNode.getFirstChild().getNodeValue());
						}
					}
					if (childNodeName.equalsIgnoreCase("role_entity"))//role_entity
					{
						if(childNode.getFirstChild()!=null)
						{
							roleEntity = checkNull(childNode.getFirstChild().getNodeValue());
						}
						//System.out.println("roleEntity::["+roleEntity+"]");
					}	
					if (childNodeName.equalsIgnoreCase("sign_status"))//sign_status
					{
						if(childNode.getFirstChild()!=null)
						{
							signStatus = checkNull(childNode.getFirstChild().getNodeValue());
						}
						//System.out.println("signStatus::["+signStatus+"]");
					}
					if (childNodeName.equalsIgnoreCase("prc_inst__wf"))//PRC_INST__WF
					{
						if(childNode.getFirstChild()!=null)
						{
							prcInst = checkNull(childNode.getFirstChild().getNodeValue());
						}
						System.out.println("prcInst::["+prcInst+"]");
					}
				} 
				if(roleCodeSign.equalsIgnoreCase("FLM_SIGN") && signStatus.equalsIgnoreCase("R") )
				{
					System.out.println("update remakrdfjdf aprv remakrs");
					signRamarkHM.put("rejected_remarks", signRemark);
				}
			}
			
			if (prcInst != null && prcInst.trim().length() > 0)
			{
				String str[] = prcInst.split(":");
				 processId = str[0];
				 instanceId = str[1];
			}
			System.out.println("processId :fgg: "+processId);
			System.out.println("instanceId :g: "+instanceId);
			
			String sql = "SELECT ARGUMENT_VALUE_XML FROM WF_PRC_DATA WHERE PROCESS_ID = ? AND INSTANCE_ID = ? AND ARGUMENT_ID='$XML_DATA_ALL'";
			
			if ( "oracle".equalsIgnoreCase( CommonConstants.DB_NAME )) 
			{
				query = "SELECT WPD.ARGUMENT_VALUE_XML.getClobval() FROM WF_PRC_DATA WPD WHERE PROCESS_ID=? AND INSTANCE_ID=? AND ARGUMENT_ID='$XML_DATA_ALL' ";
			}
			else
			{
				query = "SELECT ARGUMENT_VALUE FROM WF_PRC_DATA WHERE PROCESS_ID=? AND INSTANCE_ID=? AND ARGUMENT_ID='$XML_DATA_ALL' ";
			}	
			ArrayList bindVarValues = new ArrayList();
			bindVarValues.add(processId.trim());
			bindVarValues.add(instanceId.trim());
			
			ArrayList bindVarTypes = new ArrayList();
			bindVarTypes.add("String");
			
			//For DB2 Compatibility
			bindVarTypes.add("String");
			System.out.println("Getting BLOB from DBAccessEJB in SignManagerEJB sign4");
			
			String wfData ="";
			if( "oracle".equalsIgnoreCase( CommonConstants.DB_NAME ) )
			{	
				dataStrWfData = getXMLTypeStr( conn, query, bindVarValues, bindVarTypes );
			}
			else
			{
				dataStrWfData = getDBAccessObj().getBlob(query, bindVarValues, bindVarTypes);
			}
			dataStringWfData =applyDataToXML(signRamarkHM,dataStrWfData,"1");
			dom2 = genericUtility.parseString(dataStringWfData);
			String modifiedArgumentXml=genericUtility.serializeDom(dom2);;
			System.out.println("modifiedArgumentXml::::updateAprvRemarkupdateAprvRemarkasd:::::::+"+modifiedArgumentXml);
			String sqlUpdtWfData = "UPDATE WF_PRC_DATA SET ARGUMENT_VALUE_XML = XMLType(?) WHERE PROCESS_ID = ? AND INSTANCE_ID = ? AND ARGUMENT_ID='$XML_DATA_ALL'";				
			ArrayList bindVarValuesUpd = new ArrayList();
			bindVarValuesUpd.add(processId);
			bindVarValuesUpd.add(instanceId);

			ArrayList bindVarTypesUpd = new ArrayList();
			bindVarTypesUpd.add("String");
			bindVarTypesUpd.add("String");
			
			boolean	updStatus = updateXMLTypeStr( conn, sqlUpdtWfData, modifiedArgumentXml, bindVarValuesUpd, bindVarTypesUpd );
			if(updStatus)
			{
				System.out.println("Updated wf_prc_data Successfull in updateAprvRemark");
			}
			
			
			
			dataStr=getObjSignTransXmlData(refSer,refId,conn);
			dataString =applyDataToXML(signRamarkHM,dataStr,"1");
			System.out.println(" updateApproveLevel obj signtrans dataStr. updateAprvRemark::::::+"+dataString);
			dom1 = genericUtility.parseString(dataString);
			
			System.out.println("Dom getting elements obj signtrans  abcd.::updateAprvRemark::::+"+genericUtility.serializeDom(dom1));
			
			String modifiedArgumentXml1=genericUtility.serializeDom(dom1);;
			System.out.println("modifiedArgumentXml:::updateAprvRemark::::::::+"+modifiedArgumentXml1);
			String sqlUpdtWfData1 = "UPDATE obj_sign_trans SET TRANS_INFO_XML = XMLType(?) WHERE REF_SER = ? AND REF_ID= ? AND SIGN_STATUS <>'S' ";				
			ArrayList bindVarValuesUpd1 = new ArrayList();
			bindVarValuesUpd1.add(refSer);
			bindVarValuesUpd1.add(refId);

			ArrayList bindVarTypesUpd1 = new ArrayList();
			bindVarTypesUpd1.add("String");
			bindVarTypesUpd1.add("String");
			
			boolean	updStatus1 = updateXMLTypeStr( conn, sqlUpdtWfData1, modifiedArgumentXml1, bindVarValuesUpd1, bindVarTypesUpd1 );
			if(updStatus1)
			{
				System.out.println("Updated OBJ_SIGN_TRANS Successfull in updateAprvRemark()");
			}
			if (signStatus.equalsIgnoreCase("R"))
			{
				String updateReject="UPDATE STRG_SERIES_AMD SET rejection_remarks= '" +signRemark.trim() + "'"
						+ " WHERE TRAN_ID= '" + refId +"' ";
				pStmt=conn.prepareStatement(updateReject);
				pStmt.executeUpdate();

				if ( pStmt != null )
				{
					pStmt.close();
					pStmt = null;
				}
			}
			
		} 
		catch (Exception e) 
		{
			isError = true;
			e.printStackTrace();
			throw new ITMException(e);
		}
		/*finally 
		{
			if (conn != null) 
			{
				try 
				{
					if (isError) 
					{
						conn.rollback();
						System.out.println("ChgCoverageAreaApproval Connection Rollback");
					} 
					else 
					{
						conn.commit();
						System.out.println("ChgCoverageAreaApproval Connection Commit");
					}
					
				}
				catch (Exception e) 
				{
					e.printStackTrace();
				}
			}
		}*/
		return retStr;
	}
	private boolean updateXMLTypeStr( Connection con, String query, String dataStr, ArrayList bindVarValues, ArrayList bindVarTypes ) throws RemoteException,ITMException
	{
		System.out.println("@@@@ inside updateXMLType");
		WorkflowLogger.info("query ["+query+"]");
		WorkflowLogger.info("bindVarTypes ["+bindVarTypes+"]");
		WorkflowLogger.info("bindVarValues ["+bindVarValues+"]");
		boolean updStatus = false;
		PreparedStatement pStmt = null;
		OracleConnection oConnection=null;
		try
		{
			byte[] dataByteArray = null;
			E12GenericUtility genericUtility = new E12GenericUtility();
			dataStr = genericUtility.remAllXmlDec(dataStr);
			
			if ( dataStr != null && dataStr.length() > 0 && dataStr.indexOf( "</DocumentRoot>" ) != -1 )
			{
				dataStr = dataStr.substring( 0, dataStr.indexOf( "</DocumentRoot>" ) + 15 );
				dataByteArray = dataStr.getBytes();
			}
			else if ( dataStr != null && dataStr.length() > 0 && dataStr.indexOf( "</Root>" ) != -1 )
			{
				dataStr = dataStr.substring(0, dataStr.indexOf( "</Root>" ) + 7 );
				dataByteArray = dataStr.getBytes();
			}
			pStmt = con.prepareStatement(query);
			CLOB dataStrXml = CLOB.createTemporary( con.getMetaData().getConnection(), true, CLOB.DURATION_SESSION );
			dataStrXml.putString( 1, dataStr );         
			pStmt.setClob(1, dataStrXml);
			System.out.println("modifiedxmlstring in updateXMLTypeStr::"+dataStrXml);
			//Commented and changed by Gulzar for XMLType on 17/DEC/13 : END
			
			for (int ctr = 0; ctr < bindVarValues.size(); ctr++ )
			{
				if ( ( ( String )bindVarTypes.get(ctr)).indexOf( "String" ) != -1 )
				{
					pStmt.setString( ( ctr + 2 ), ( String )bindVarValues.get( ctr ) );
				}
				else if ( ( ( String )bindVarTypes.get( ctr ) ).indexOf( "Int" ) != -1 )
				{
					pStmt.setInt( ( ctr + 2 ), Integer.parseInt( ( String )bindVarValues.get( ctr ) ) );
				}
			}
			
			int updateCnt = pStmt.executeUpdate();
			System.out.println("@@@@ updateCnt in updateXMLType"+updateCnt);
			if( updateCnt > 0 )
			{
				updStatus = true;
			}
			pStmt.close();
			pStmt = null;
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(pStmt != null)
				{
					pStmt.close();
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception :SignManagerEJB :updateBlob :==>finally\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		return updStatus;
	}
	public String applyDataToXML(HashMap hashMap, String dataString, String formNo)throws ITMException
	{
		System.out.println("applyDataToXML called in approval screen");
		Document dataDom = null;
		GenericUtility genericUtility = GenericUtility.getInstance(); 
		try
		{
			System.out.println(" applyDataToXML Applying Data XML....");
			System.out.println("applyDataToXML hashMap :: " + hashMap);
			System.out.println("applyDataToXML dataString :: " + dataString);
			System.out.println("applyDataToXML formNo =[" + formNo + "]");
			dataDom = genericUtility.parseString(dataString);
			//System.out.println("DataDom Created :: " +genericUtility.serializeDom(dataDom));
			if (hashMap != null && hashMap.size() > 0)
			{
				NodeList parentNodeList = dataDom.getElementsByTagName("Detail"+formNo);
				int parentNodeListLen = parentNodeList.getLength();
				System.out.println("parentNodeListLen :sdf: " + parentNodeListLen);
				for(int pCtr = 0; pCtr < parentNodeListLen; pCtr++)
				{
					Node parent1Node = parentNodeList.item(pCtr);
					NodeList colNodeList = parent1Node.getChildNodes();
					int noOfColNodes = colNodeList.getLength();
					//System.out.println("noOfColNodes :sdfdsf: " + noOfColNodes);

					for(int colCtr = 0; colCtr < noOfColNodes; colCtr++)
					{
						Node currColNode = colNodeList.item(colCtr);
						if( currColNode.getNodeType() != Node.ELEMENT_NODE )
						{
							continue;
						}
						String colName = currColNode.getNodeName();
						//System.out.println("colName :sdfdf: " + colName);
						String key = colName;
						if( hashMap.containsKey(key))
						{
							//System.out.println("colName found in hasmap:fdghfg: " + colName);
							Node colValueNode = currColNode.getFirstChild();
							//if(colValueNode != null && colValueNode.getNodeValue() != null)
							if(colValueNode != null && colValueNode.getNodeValue() != null)
							{
								//System.out.println("colName found in hasmap:: " + colName);
								String colVal = (String)hashMap.get(key);
								if( colVal != null )
								{
									colValueNode.setNodeValue(colVal);
								}
							}
							else
							{
								//System.out.println("cdata createtnsection shdfkjd");
								CDATASection cDataSection = dataDom.createCDATASection((String)hashMap.get(key));
								currColNode.appendChild(cDataSection);
							}
						}//if( hashMap.containsKey(key))

					}//for(int colCtr = 0; colCtr < noOfColNodes; colCtr++)
				}//parent for loop

				if ( dataDom == null)
				{
					System.out.println(" datadom is null ");
				}
				dataString = genericUtility.serializeDom(dataDom);

			}//if (hashMap != null && hashMap.size() > 0)
		}
		catch (ITMException be)
		{
			throw be;
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}

		System.out.println("applyDataToXML DataDom Returned :: " + dataString);
		return dataString;
	}
	
}
