package ibase.webitm.ejb.wsfa.transactions;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.json.JSONException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

import ibase.scheduler.utility.interfaces.Schedule;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;

public class StrgCustExcpScheduler implements Schedule
{

    public String getStrgCustExcp(String xml)
    {
        UserInfoBean userInfo = null;
        System.out.println("#Looking for getStrgCustExcp  ..  "+xml);
        try 
		{
			String userInfoStr = "",transDB = "", processId = "", serverUrl = "";
			DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();  
	        DocumentBuilder builder; 
	        builder = factory.newDocumentBuilder();  
            Document doc = builder.parse( new InputSource( new StringReader( xml )) ); 
            
            NodeList docRoot1 = doc.getElementsByTagName("ACTUALPARAMETERS");
            for (int i = 0; i < docRoot1.getLength(); i++)
            {
                NodeList childList1 = docRoot1.item(i).getChildNodes();
                for (int j = 0; j < childList1.getLength(); j++) 
                {
                    Node childNode = childList1.item(j);
                    if("ACTUALPARAMETER".equalsIgnoreCase(childNode.getNodeName())) 
                    {
                    	Element el = (org.w3c.dom.Element) childNode;
                    	String str = el.getAttribute("name");
                    	if("PROCESS_ID".equalsIgnoreCase(str))
                    	{
                            System.out.println("Value for processId : "+childNode.getFirstChild().getNodeValue());
                            processId = childNode.getFirstChild().getNodeValue();
                        }
                        if("SERVER_URL".equalsIgnoreCase(str))
                    	{
                            System.out.println("Value for processId : "+childNode.getFirstChild().getNodeValue());
                            serverUrl = childNode.getFirstChild().getNodeValue();
                    	}
                    }
                }
            }
            

            NodeList docRoot = doc.getElementsByTagName("USERINFOXML");
            for (int i = 0; i < docRoot.getLength(); i++)
            {
                NodeList childList = docRoot.item(i).getChildNodes();
                for (int j = 0; j < childList.getLength(); j++) 
                {
                    Node childNode = childList.item(j);
                    System.out.println(childNode.getNodeName());
                    if("UserInfo".equals(childNode.getNodeName())) 
                    {
                    	userInfoStr = nodeToString(childNode);
                        System.out.println("Final userInfoStr ::  "+userInfoStr);
                        if( userInfoStr != null && !"".equalsIgnoreCase(userInfoStr))
                        {
                            userInfo = new UserInfoBean(userInfoStr);
                        }
                    }
                }
            }

            try
            {
                StringBuffer queryParam = new StringBuffer();
                queryParam.append("processId=").append(processId);
                // queryParam.append("&argumentList=").append();
                // queryParam.append("&databaseType=").append(jwtToken);
                System.out.println("CommonConstants.TOMCAT_HOME in Scheduler : "+CommonConstants.TOMCAT_HOME);
                System.out.println("Session Id : "+userInfo.getSesstionId());
                System.out.println("serverUrl  : "+serverUrl);

                String requestURL =  CommonConstants.TOMCAT_HOME + "/ibase/rest/GenProcessPersistService/persist";
                
                BaseLogger.log( "3", userInfo, null, "requestURL ["+ requestURL +"]" );
                String serviceResponseStr = callStringResponseService( requestURL, queryParam.toString(), null, userInfo.getSesstionId() );
                BaseLogger.log( "3", userInfo, null, "serviceResponseStr ["+ serviceResponseStr +"]" );
            }
            catch(Exception e)
            {
                System.out.println("StrgCustExcpScheduler :: "+e.getMessage());
            }
            
            finally
            {
                try
                {
                    
                }
                catch(Exception e)
                {
                    e.printStackTrace();
                }
            
            }            
		}
		catch(Exception e)
		{
			System.out.println("TestClass :: "+e.getMessage());
		}
       
        return "";
    }
    
    private String checkNull(String str)
	{
		if(str == null)
		{
			return "NA";
		}
		else
		{
			return str ;
		}

	}

    @Override
	public String schedule(HashMap map) throws Exception {
		// TODO Auto-generated method stub
		BaseLogger.log("3",null,null,"schedule hashMap::"+map);
		return null;
	}

	@Override
	public String schedule(String scheduleXml) throws Exception 
	{
		BaseLogger.log("2",null,null,"schedule scheduleXml::"+scheduleXml);
		getStrgCustExcp(scheduleXml);
		return "";
	}

	@Override
	public String schedulePriority(String wrkflwPriority) throws Exception {
		// TODO Auto-generated method stub
		return null;
	}
	
	public String nodeToString(Node node) 
	{
		StringWriter sw = new StringWriter();
		try 
		{
			Transformer t = TransformerFactory.newInstance().newTransformer();
			t.setOutputProperty(OutputKeys.OMIT_XML_DECLARATION, "yes");
			t.setOutputProperty(OutputKeys.INDENT, "yes");
			t.transform(new DOMSource(node), new StreamResult(sw));
		}
		catch (TransformerException te) 
		{
			System.out.println("nodeToString Transformer Exception");
		}
		return sw.toString();
	}
	
	private String callStringResponseService( String serviceURL, String paramStr, InputStream postDataStream, String sessionId ) throws JSONException, UnsupportedEncodingException
	{
		BaseLogger.log( "2", null, null, "In callStringResponseService" );
		String result = "";
		try
		{
			if( paramStr != null )
			{
				postDataStream = new ByteArrayInputStream( paramStr.getBytes() );
			}
			byte[] resultBytes = makeRequest( serviceURL, postDataStream, 0 , sessionId);
			result = new String(resultBytes);
			BaseLogger.log( "2", null, null, "String result ["+ result +"]" );
		}
		catch (Exception ex)
		{
			BaseLogger.log( "0", null, null, "Exception in E12GenericUtility :: callStringResponseService : ["+ ex.getMessage() +"]" );
			result = "Error";
		}
		return result;
	}
	
	private byte[] makeRequest(String url, InputStream postDataInputStream, int readTimeout, String sessionId) throws IOException 
    {
		byte[] result = new byte[0];

		URL serviceURL = new URL(url);
		HttpURLConnection httpConnection = (HttpURLConnection)serviceURL.openConnection();
		if (readTimeout > 0) {
			httpConnection.setReadTimeout(2000);
		}

		httpConnection.setRequestMethod("GET");
		httpConnection.setDoOutput(true);
		httpConnection.setDoInput(true);
		httpConnection.setUseCaches(false);

		if (postDataInputStream != null) {
			httpConnection.setRequestMethod("POST");
			httpConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
			httpConnection.setRequestProperty("charset", "UTF-8");
			httpConnection.setRequestProperty("Content-Length", Integer.toString(postDataInputStream.available()));
			httpConnection.setRequestProperty( "Cookie", "JSESSIONID=" + URLEncoder.encode( sessionId, CommonConstants.ENCODING) );

			OutputStream connectionOutputStream = httpConnection.getOutputStream();
			E12GenericUtility.copy(postDataInputStream, connectionOutputStream);
		}

		httpConnection.connect();

		InputStream responseStream = httpConnection.getInputStream();
		result = E12GenericUtility.readStreamAsBytes(responseStream);

		return result;
    }
}