/*
 * Decompiled with CFR 0.152.
 */
package ibase.bis.utility;

import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.utility.ITMException;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BISUtility {
    private E12GenericUtility genericUtility = new E12GenericUtility();
    private ITMDBAccessEJB itmDbAccessRemote = null;
    private String invalidArgStr = "";
    private String invalidArgVal = "";
    private String invArgDefaultValue = "";

    private ITMDBAccessEJB getItmDbAccessRemote() throws ITMException {
        try {
            if (this.itmDbAccessRemote == null) {
                this.itmDbAccessRemote = new ITMDBAccessEJB();
            }
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return this.itmDbAccessRemote;
    }

    public String getErrorJsonString(String msgNo, String loginCode) throws Exception {
        return this.getErrorJsonString(msgNo, loginCode, null);
    }

    public String getErrorJsonString(String msgNo, String loginCode, String trace) throws Exception {
        return this.getErrorJsonString(msgNo, loginCode, trace, "vision", "");
    }

    public String getErrorJsonString(String msgNo, String loginCode, String trace, String responseTo, String addlResponseMsg) throws Exception {
        String errorStr = this.getItmDbAccessRemote().getErrorString("", msgNo, loginCode, "JSON");
        errorStr = this.updateValueInErrorJson(errorStr, this.getInvalidArgStr(), this.getInvalidArgVal(), this.getInvArgDefaultValue());
        JSONObject responseJson = new JSONObject(errorStr);
        if ((addlResponseMsg = E12GenericUtility.checkNull(addlResponseMsg)).length() > 0) {
            responseJson.getJSONObject("Root").put("addl_info", (Object)addlResponseMsg).toString();
            errorStr = responseJson.toString();
        }
        if ((trace = E12GenericUtility.checkNull(trace)).length() > 0) {
            new E12GenericUtility().updateValueInJson(responseJson, "Root:Errors:error", "trace", trace);
            errorStr = responseJson.toString();
        }
        if (!"vision".equalsIgnoreCase(responseTo)) {
            JSONObject errorJson = responseJson.getJSONObject("Root").getJSONObject("Errors").getJSONObject("error");
            String errorDescr = errorJson.getString("description");
            if (trace.length() > 0) {
                errorDescr = String.valueOf(errorDescr) + trace;
            }
            errorStr = this.generateSimpleResponse(errorDescr, "", addlResponseMsg).toString();
        }
        BaseLogger.log("3", null, null, "errorStr [" + errorStr + "]");
        return errorStr;
    }

    public String generateSucessString(String resultType, String resultTemplate, String objName, Object result, String addlResponseMsg) throws Exception {
        JSONObject resultDataJson = new JSONObject();
        resultDataJson.put("format", (Object)resultType);
        resultDataJson.put("data", result);
        resultDataJson.put("template", (Object)resultTemplate);
        if (addlResponseMsg != null && addlResponseMsg.trim().length() > 0) {
            resultDataJson.put("addl_info", (Object)addlResponseMsg);
        }
        if ((objName = E12GenericUtility.checkNull(objName)) != null && objName.length() > 0) {
            if ((objName = objName.toLowerCase()).startsWith("w_")) {
                objName = objName.substring(2, objName.length());
            }
            resultDataJson.put("objName", (Object)objName);
        }
        JSONObject resultJson = new JSONObject();
        resultJson.put("result", (Object)resultDataJson);
        JSONObject detailJson = new JSONObject();
        detailJson.put("Detail", (Object)resultJson);
        JSONObject responseJson = new JSONObject();
        responseJson.put("Root", (Object)detailJson);
        return responseJson.toString();
    }

    public JSONObject generateSimpleResponse(Object result, String resultType, String addlResponseMsg) {
        JSONObject simpleResponseJson = new JSONObject();
        try {
            if (resultType.equals("3") || resultType.equals("6")) {
                if (addlResponseMsg == null || addlResponseMsg.trim().length() == 0) {
                    addlResponseMsg = "Here is your result..";
                }
                simpleResponseJson.put("textToSpeech", (Object)addlResponseMsg);
                simpleResponseJson.put("tableCardResponse", result);
                simpleResponseJson.put("resultFormat", (Object)resultType);
            } else {
                if (addlResponseMsg != null && addlResponseMsg.trim().length() > 0) {
                    addlResponseMsg = String.valueOf(addlResponseMsg) + "\n\n";
                }
                result = String.valueOf(addlResponseMsg) + result;
                simpleResponseJson.put("textToSpeech", result);
                simpleResponseJson.put("displayText", result);
            }
        }
        catch (JSONException e) {
            BaseLogger.log("0", null, null, "JSONException :: generateSimpleResponse : [" + e.getMessage() + "]");
            e.printStackTrace();
        }
        return simpleResponseJson;
    }

    public JSONObject generateGoogleAssistantResponse(JSONObject resultJson) {
        JSONObject responseJson = new JSONObject();
        try {
            responseJson.put("expectUserResponse", true);
            JSONArray expectedInputsJsonArr = new JSONArray();
            JSONObject expectedInputsJson = new JSONObject();
            JSONObject inputPromptJson = new JSONObject();
            JSONObject richInitialPromptJson = new JSONObject();
            JSONArray itemsJsonArr = new JSONArray();
            JSONObject itemsJson = new JSONObject();
            String resultFormat = "";
            if (resultJson.length() > 2) {
                resultFormat = E12GenericUtility.checkNull((String)resultJson.get("resultFormat"));
            }
            if (resultFormat.equals("3") || resultFormat.equals("6")) {
                Object tableCardData = resultJson.get("tableCardResponse");
                resultJson.remove("tableCardResponse");
                resultJson.remove("resultFormat");
                itemsJson.put("simpleResponse", (Object)resultJson);
                itemsJsonArr.put((Object)itemsJson);
                itemsJsonArr.put(tableCardData);
            } else {
                itemsJson.put("simpleResponse", (Object)resultJson);
                itemsJsonArr.put((Object)itemsJson);
            }
            richInitialPromptJson.put("items", (Object)itemsJsonArr);
            inputPromptJson.put("richInitialPrompt", (Object)richInitialPromptJson);
            expectedInputsJson.put("inputPrompt", (Object)inputPromptJson);
            JSONArray possibleIntentsJsonArr = new JSONArray();
            JSONObject possibleIntentsJson = new JSONObject();
            possibleIntentsJson.put("intent", (Object)"actions.intent.TEXT");
            possibleIntentsJsonArr.put((Object)possibleIntentsJson);
            expectedInputsJson.put("possibleIntents", (Object)possibleIntentsJsonArr);
            expectedInputsJsonArr.put((Object)expectedInputsJson);
            responseJson.put("expectedInputs", (Object)expectedInputsJsonArr);
        }
        catch (JSONException e) {
            BaseLogger.log("0", null, null, "JSONException :: generateResponse : [" + e.getMessage() + "]");
            e.printStackTrace();
        }
        return responseJson;
    }

    public JSONObject generateGActionSignInResponse() {
        JSONObject responseJson = new JSONObject();
        try {
            responseJson.put("expectUserResponse", true);
            JSONArray expectedInputsJsonArr = new JSONArray();
            JSONObject expectedInputsJson = new JSONObject();
            JSONObject inputValueData = new JSONObject();
            inputValueData.put("@type", (Object)"type.googleapis.com/google.actions.v2.SignInValueSpec");
            JSONArray possibleIntentsJsonArr = new JSONArray();
            JSONObject possibleIntentsJson = new JSONObject();
            possibleIntentsJson.put("intent", (Object)"actions.intent.SIGN_IN");
            possibleIntentsJson.put("inputValueData", (Object)inputValueData);
            possibleIntentsJsonArr.put((Object)possibleIntentsJson);
            expectedInputsJson.put("possibleIntents", (Object)possibleIntentsJsonArr);
            expectedInputsJsonArr.put((Object)expectedInputsJson);
            responseJson.put("expectedInputs", (Object)expectedInputsJsonArr);
        }
        catch (JSONException e) {
            BaseLogger.log("0", null, null, "JSONException :: generateResponse : [" + e.getMessage() + "]");
            e.printStackTrace();
        }
        return responseJson;
    }

    public String getErrorMsg(String retString) {
        Document xmlData;
        String errMessage;
        block18: {
            errMessage = "";
            xmlData = this.genericUtility.parseString(retString);
            if (xmlData != null) break block18;
            return "";
        }
        try {
            NodeList parentNodeList = xmlData.getElementsByTagName("error");
            BaseLogger.log("3", null, null, "parentNodeList.getlength = " + parentNodeList.getLength());
            int cnt = parentNodeList.getLength();
            if (cnt == 0) {
                parentNodeList = xmlData.getElementsByTagName("Error");
                cnt = parentNodeList.getLength();
            }
            String errCode = "";
            String errorColumnName = "";
            String errType = "";
            String errorDescr = "";
            String errorTrace = "";
            String errMsg = "";
            String messageType = "";
            int errorCnt = 0;
            while (errorCnt < cnt) {
                Node parentNode = parentNodeList.item(errorCnt);
                if (parentNode != null) {
                    NodeList childNodeList = parentNode.getChildNodes();
                    int childNodeListLength = childNodeList.getLength();
                    errCode = parentNode.getAttributes().getNamedItem("id") == null ? "" : parentNode.getAttributes().getNamedItem("id").getNodeValue();
                    BaseLogger.log("3", null, null, "errCode : [" + errCode + "]");
                    errType = parentNode.getAttributes().getNamedItem("type") == null ? "" : parentNode.getAttributes().getNamedItem("type").getNodeValue();
                    BaseLogger.log("3", null, null, "errType : [" + errType + "]");
                    String string = errorColumnName = parentNode.getAttributes().getNamedItem("column_name") == null ? "" : parentNode.getAttributes().getNamedItem("column_name").getNodeValue();
                    if (errorColumnName != null && errorColumnName.length() > 0) {
                        errCode = String.valueOf(errorColumnName) + " : " + errCode;
                    }
                    int childRow = 0;
                    while (childRow < childNodeListLength) {
                        Node childNode = childNodeList.item(childRow);
                        String childNodeName = childNode.getNodeName();
                        BaseLogger.log("3", null, null, "childNodeName [" + childNodeName + "]");
                        int sequence = errorCnt;
                        if (childNodeName.equals("message")) {
                            if (childNode != null && childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null && childNode.getFirstChild().getNodeValue().trim().length() > 0) {
                                errMsg = String.valueOf(++sequence) + ". " + errCode + " : " + childNode.getFirstChild().getNodeValue().trim();
                            }
                        } else if (childNodeName.equals("description")) {
                            if (childNode != null && childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null && childNode.getFirstChild().getNodeValue().trim().length() > 0) {
                                errorDescr = childNode.getFirstChild().getNodeValue().trim();
                            }
                        } else if (childNodeName.equals("trace")) {
                            if (childNode != null && childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null && childNode.getFirstChild().getNodeValue().trim().length() > 0) {
                                errorTrace = " [ " + childNode.getFirstChild().getNodeValue().trim() + " ] ";
                            }
                        } else if (childNodeName.equalsIgnoreCase("type")) {
                            messageType = childNode.getFirstChild().getNodeValue();
                        }
                        ++childRow;
                    }
                }
                ++errorCnt;
            }
            errMessage = this.genericUtility.getErrorXmlToJsonString(errCode, messageType, errMsg, errorDescr, errorTrace);
        }
        catch (ITMException e) {
            e.printStackTrace();
        }
        return errMessage;
    }

    public String makeRequest(String urlStr, String xmlString, String sessionId) {
        String response;
        block6: {
            response = "";
            URL url = null;
            HttpURLConnection conn = null;
            StringBuffer responseBuff = new StringBuffer();
            try {
                try {
                    url = new URL(urlStr);
                    conn = (HttpURLConnection)url.openConnection();
                    conn.setDoOutput(true);
                    conn.setRequestMethod("POST");
                    conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                    conn.setRequestProperty("Cookie", "JSESSIONID=" + URLEncoder.encode(sessionId, CommonConstants.ENCODING));
                    BaseLogger.log("3", null, null, "URL: [" + url + "]");
                    DataOutputStream wr = new DataOutputStream(conn.getOutputStream());
                    wr.writeBytes(xmlString);
                    wr.flush();
                    BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                    while ((response = br.readLine()) != null) {
                        responseBuff.append(response);
                    }
                    response = responseBuff.toString();
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "RequestHandlerServlet makeRequest Exception 1710- [" + e.getMessage() + "]");
                    conn.disconnect();
                    break block6;
                }
            }
            catch (Throwable throwable) {
                conn.disconnect();
                throw throwable;
            }
            conn.disconnect();
        }
        BaseLogger.log("2", null, null, "Final response retString: " + response);
        return response;
    }

    public ArrayList<String> getDefaultValueList() {
        ArrayList<String> defaultValueList = new ArrayList<String>();
        defaultValueList.add("today");
        defaultValueList.add("yesterday");
        defaultValueList.add("tomorrow");
        defaultValueList.add("last month");
        defaultValueList.add("previous month");
        defaultValueList.add("this month");
        defaultValueList.add("next month");
        defaultValueList.add("this year");
        defaultValueList.add("last year");
        defaultValueList.add("two days ago");
        defaultValueList.add("this finacial year");
        defaultValueList.add("days of month");
        return defaultValueList;
    }

    public String getDefaultValues(String fieldName) {
        String fieldValue = fieldName;
        try {
            fieldName = E12GenericUtility.checkNull(fieldName).toLowerCase();
            BaseLogger.log("3", null, null, "fieldName : [" + fieldName + "]");
            LocalDate currDate = LocalDate.now();
            BaseLogger.log("3", null, null, "currDate : [" + currDate + "]");
            DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern(this.genericUtility.getApplDateFormat());
            if ("today".equalsIgnoreCase(fieldName)) {
                fieldValue = currDate.format(dateFormatter);
            } else if ("yesterday".equalsIgnoreCase(fieldName)) {
                LocalDate yesterday = currDate.minusDays(1L);
                fieldValue = yesterday.format(dateFormatter);
            } else if ("tomorrow".equalsIgnoreCase(fieldName)) {
                LocalDate tomorrow = currDate.plusDays(1L);
                fieldValue = tomorrow.format(dateFormatter);
            } else if ("last month".equalsIgnoreCase(fieldName) || "previous month".equalsIgnoreCase(fieldName)) {
                dateFormatter = DateTimeFormatter.ofPattern("yyyyMM");
                LocalDate prevMonth = currDate.minusMonths(1L);
                fieldValue = prevMonth.format(dateFormatter);
            } else if ("this month".equalsIgnoreCase(fieldName)) {
                dateFormatter = DateTimeFormatter.ofPattern("yyyyMM");
                fieldValue = currDate.format(dateFormatter);
            } else if ("next month".equalsIgnoreCase(fieldName)) {
                dateFormatter = DateTimeFormatter.ofPattern("yyyyMM");
                LocalDate prevMonth = currDate.plusMonths(1L);
                fieldValue = prevMonth.format(dateFormatter);
            } else if ("this year".equalsIgnoreCase(fieldName)) {
                fieldValue = "" + currDate.getYear();
            } else if ("last year".equalsIgnoreCase(fieldName)) {
                fieldValue = "" + (currDate.getYear() - 1);
            } else if ("two days ago".equalsIgnoreCase(fieldName)) {
                LocalDate twoDaysAgo = currDate.minusDays(2L);
                fieldValue = twoDaysAgo.format(dateFormatter);
            } else if ("this finacial year".equalsIgnoreCase(fieldName)) {
                fieldValue = String.valueOf(currDate.getYear() - 1) + "-" + currDate.getYear();
            } else if ("days of month".equalsIgnoreCase(fieldName)) {
                fieldValue = "" + currDate.getDayOfMonth();
            }
        }
        catch (ITMException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        BaseLogger.log("3", null, null, "fieldValue : [" + fieldValue + "]");
        return fieldValue;
    }

    public String getMapKeyFromValue(HashMap<String, String> map, String value) {
        return map.entrySet().stream().filter(entry -> value.equals(entry.getValue())).map(Map.Entry::getKey).findFirst().get();
    }

    private String getDataModelData(String dataModelName, String loginCode) {
        String dataModelData = "";
        try {
            String downloadedDataModelPath = String.valueOf(CommonConstants.APPLICATION_CONTEXT) + File.separator + "resource" + File.separator + "HeaderDataFiles" + File.separator + "SCOPE_DATA" + File.separator + loginCode + File.separator + dataModelName;
            File dataModelFile = new File(downloadedDataModelPath);
            if (dataModelFile.exists()) {
                FileInputStream is = new FileInputStream(dataModelFile);
                dataModelData = IOUtils.toString((InputStream)is, (String)"UTF-8");
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return dataModelData;
    }

    public JSONArray getJsonDataModelArgValue(String dataModelName, String loginCode, String argName, String invokeArgValue) throws ITMException {
        String argValue = "";
        JSONArray dataModelValueArr = new JSONArray();
        try {
            String dataModelData = E12GenericUtility.checkNull(this.getDataModelData(dataModelName, loginCode.trim()));
            if (dataModelData.length() > 0) {
                invokeArgValue = E12GenericUtility.checkNull(invokeArgValue);
                JSONObject fileJsonData = new JSONObject(dataModelData);
                BaseLogger.log("3", null, null, "fileJsonData : [" + fileJsonData + "]");
                if (fileJsonData.has("DETAILS")) {
                    JSONObject fileJsonDetail;
                    JSONObject dataModelArgValue;
                    JSONArray fileJsonArray = fileJsonData.getJSONArray("DETAILS");
                    int detCtr = 0;
                    while (detCtr < fileJsonArray.length()) {
                        dataModelArgValue = new JSONObject();
                        fileJsonDetail = (JSONObject)fileJsonArray.get(detCtr);
                        BaseLogger.log("3", null, null, "fileJsonDetail : [" + fileJsonDetail + "]");
                        if (fileJsonDetail.has("value") && fileJsonDetail.getString("value").equalsIgnoreCase(invokeArgValue)) {
                            argValue = fileJsonDetail.getString("id");
                            dataModelArgValue.put("ARG_VALUE", (Object)argValue);
                            dataModelArgValue.put("IS_EXACT_MATCH", true);
                            dataModelValueArr.put((Object)dataModelArgValue);
                            break;
                        }
                        ++detCtr;
                    }
                    if (argValue.trim().length() == 0) {
                        BaseLogger.log("3", null, null, "in getJsonDataModelArgValue no argValue matched!!");
                        detCtr = 0;
                        while (detCtr < fileJsonArray.length()) {
                            dataModelArgValue = new JSONObject();
                            dataModelArgValue.put("ARG_VALUE", (Object)"");
                            dataModelArgValue.put("IS_EXACT_MATCH", true);
                            fileJsonDetail = (JSONObject)fileJsonArray.get(detCtr);
                            if (fileJsonDetail.has("value") && (fileJsonDetail.getString("value").toLowerCase().startsWith(invokeArgValue.trim().toLowerCase()) || fileJsonDetail.getString("value").toLowerCase().contains(invokeArgValue.trim().toLowerCase()))) {
                                BaseLogger.log("3", null, null, "I");
                                argValue = fileJsonDetail.getString("id");
                                dataModelArgValue.put("ARG_VALUE", (Object)argValue);
                                dataModelArgValue.put("IS_EXACT_MATCH", false);
                                dataModelArgValue.put("INVOK_ARG_VALUE", (Object)fileJsonDetail.getString("value"));
                                dataModelValueArr.put((Object)dataModelArgValue);
                            }
                            ++detCtr;
                        }
                    }
                }
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
            throw new ITMException((Exception)((Object)e));
        }
        BaseLogger.log("3", null, null, "dataModelValueArr [" + dataModelValueArr + "]");
        return dataModelValueArr;
    }

    public String getXmlDataModelArgValue(String dataModelName, String loginCode, String argName, String invokeArgValue) throws ITMException {
        String argValue;
        block11: {
            argValue = "";
            try {
                BaseLogger.log("3", null, null, "argumentValue : [" + invokeArgValue + "] argName [" + argName + "]");
                String dataModelData = E12GenericUtility.checkNull(this.getDataModelData(dataModelName, loginCode));
                if (dataModelData.length() <= 0) break block11;
                Document xmlData = this.genericUtility.parseString(dataModelData);
                NodeList parentNodeList = xmlData.getElementsByTagName("DETAIL");
                BaseLogger.log("3", null, null, "getXmlDataModelArgValue parentNodeList : [" + parentNodeList.getLength() + "] ");
                int detailCnt = 0;
                while (detailCnt < parentNodeList.getLength()) {
                    Node parentNode = parentNodeList.item(detailCnt);
                    if (parentNode != null) {
                        NodeList childNodeList = parentNode.getChildNodes();
                        int childNodeListLength = childNodeList.getLength();
                        String id = "";
                        String value = "";
                        int childNodeCtr = 0;
                        while (childNodeCtr < childNodeListLength) {
                            Node childNode = childNodeList.item(childNodeCtr);
                            if (childNode.getNodeType() == 1) {
                                String childNodeName = childNode.getNodeName();
                                BaseLogger.log("3", null, null, "childNodeName [" + childNodeName + "]");
                                if ("id".equals(childNodeName) && childNode.getFirstChild() != null) {
                                    id = childNode.getFirstChild().getNodeValue();
                                } else if ("value".equals(childNodeName) && childNode.getFirstChild() != null) {
                                    value = childNode.getFirstChild().getNodeValue();
                                }
                            }
                            ++childNodeCtr;
                        }
                        if (value.equalsIgnoreCase(invokeArgValue)) {
                            argValue = id;
                            break;
                        }
                    }
                    ++detailCnt;
                }
            }
            catch (ITMException e) {
                e.printStackTrace();
                throw e;
            }
            catch (DOMException e) {
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        BaseLogger.log("3", null, null, "getXmlDataModelArgValue : [" + argValue + "] ");
        return argValue;
    }

    public ArrayList<String> getDataModelDataList(String dataModelName, String loginCode) throws ITMException {
        ArrayList<String> datModelListValues;
        block5: {
            datModelListValues = new ArrayList<String>();
            try {
                JSONObject fileJsonData;
                String dataModelData = E12GenericUtility.checkNull(this.getDataModelData(dataModelName, loginCode));
                if (dataModelData.length() <= 0 || !(fileJsonData = new JSONObject(dataModelData)).has("DETAILS")) break block5;
                JSONArray fileJsonArray = fileJsonData.getJSONArray("DETAILS");
                int detCtr = 0;
                while (detCtr < fileJsonArray.length()) {
                    JSONObject fileJsonDetail = (JSONObject)fileJsonArray.get(detCtr);
                    if (fileJsonDetail.has("value")) {
                        datModelListValues.add(fileJsonDetail.getString("value"));
                        if (detCtr == CommonConstants.MAX_ENTITY_TRAINING_VALUES) break;
                    }
                    ++detCtr;
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
                throw new ITMException((Exception)((Object)e));
            }
        }
        BaseLogger.log("3", null, null, "datModelListValues [" + datModelListValues + "]");
        return datModelListValues;
    }

    public ArrayList<Integer> getStartEndPosition(String sentence, String word) {
        ArrayList<Integer> starEndArr = new ArrayList<Integer>();
        int startingPosition = sentence.indexOf(word);
        int endingPosition = startingPosition + word.length();
        starEndArr.add(startingPosition);
        starEndArr.add(endingPosition);
        return starEndArr;
    }

    public int charaterOccurance(String inputStr) {
        Pattern pattern = Pattern.compile(":");
        Matcher matcher = pattern.matcher(inputStr);
        int count = 0;
        while (matcher.find()) {
            ++count;
        }
        return count;
    }

    public String updateValueInErrorJson(String errorJsonStr, String invArgName, String invArgValue, String invArgDefaultValue) throws Exception {
        try {
            if (errorJsonStr != null && (errorJsonStr.contains(":ARG_NAME") || errorJsonStr.contains(":DEFAULT_VALUE") || errorJsonStr.contains(":ARG_VALUE"))) {
                JSONObject errorRespJson = new JSONObject(errorJsonStr);
                JSONObject errorJson = errorRespJson.getJSONObject("Root").getJSONObject("Errors").getJSONObject("error");
                String errorDescr = errorJson.getString("description");
                if ((errorDescr = E12GenericUtility.checkNull(errorDescr)).contains(":ARG_NAME")) {
                    errorDescr = errorDescr.replace(":ARG_NAME", invArgName);
                }
                if (errorDescr.contains(":DEFAULT_VALUE")) {
                    errorDescr = errorDescr.replace(":DEFAULT_VALUE", invArgDefaultValue);
                }
                if (errorDescr.contains(":ARG_VALUE")) {
                    errorDescr = errorDescr.replace(":ARG_VALUE", invArgValue);
                }
                errorJson.put("description", (Object)errorDescr);
                errorJsonStr = errorRespJson.toString();
            }
            BaseLogger.log("3", null, null, "errorJsonStr [" + errorJsonStr + "]");
        }
        catch (Exception e) {
            BaseLogger.log("3", null, null, "Exception :: updateValueInErrorJson [" + e.getMessage() + "]");
            e.printStackTrace();
        }
        return errorJsonStr;
    }

    public String getInvalidArgStr() {
        return this.invalidArgStr;
    }

    public void setInvalidArgStr(String invalidArgStr) {
        this.invalidArgStr = invalidArgStr;
    }

    public String getInvalidArgVal() {
        return this.invalidArgVal;
    }

    public void setInvalidArgVal(String invalidArgVal) {
        this.invalidArgVal = invalidArgVal;
    }

    public String getInvArgDefaultValue() {
        return this.invArgDefaultValue;
    }

    public void setInvArgDefaultValue(String invArgDefaultValue) {
        this.invArgDefaultValue = invArgDefaultValue;
    }
}

