/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.bean;

import ibase.system.config.AppConnectParm;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.ejb.ITMBrowFormEJB;
import ibase.webitm.utility.I18NLabel;
import ibase.webitm.utility.ITMException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import javax.naming.InitialContext;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ITMAuditBean
implements Serializable {
    String objName;
    String refID;
    String chgID;
    String recObjName;
    String pContext = "1";
    String objContext = "1";
    String editFlag = "V";
    String reqParamStr = "";
    String user_lang = "en";
    String user_country = "US";
    UserInfoBean userInfo = null;

    public void setObjName(String objName) {
        this.objName = objName;
    }

    public String getObjName() {
        return this.objName;
    }

    public void setPContext(String pContext) {
        if (pContext != null && !"null".equalsIgnoreCase(pContext) && pContext.length() > 0) {
            this.pContext = pContext;
        }
    }

    public String getPContext() {
        return this.pContext;
    }

    public void setObjContext(String objContext) {
        if (objContext != null && !"null".equalsIgnoreCase(objContext) && objContext.length() > 0) {
            this.objContext = objContext;
        }
    }

    public String getObjContext() {
        return this.objContext;
    }

    public void setEditFlag(String editFlag) {
        if (editFlag != null && !"null".equalsIgnoreCase(editFlag) && editFlag.length() > 0) {
            this.editFlag = editFlag;
        }
    }

    public String getEditFlag() {
        return this.editFlag;
    }

    public void setRequestParamStr(String reqParamStr) {
        if (reqParamStr != null && !"null".equalsIgnoreCase(reqParamStr) && reqParamStr.length() > 0) {
            this.reqParamStr = reqParamStr;
        }
    }

    public void setChgID(String chgID) {
        if (chgID != null && !"null".equalsIgnoreCase(chgID) && chgID.length() > 0) {
            this.chgID = chgID;
        }
    }

    public void setRecObjName(String recOBJName) {
        if (recOBJName != null && !"null".equalsIgnoreCase(recOBJName) && recOBJName.length() > 0) {
            this.recObjName = recOBJName;
        }
    }

    public void setRefID(String refID) {
        if (refID != null && !"null".equalsIgnoreCase(refID) && refID.length() > 0) {
            this.refID = refID;
        }
    }

    public void setUserInfo(UserInfoBean userInfo) {
        this.userInfo = userInfo;
    }

    public String getDefaultPath() {
        String defaultPath = null;
        defaultPath = CommonConstants.APPLICATION_CONTEXT != null ? String.valueOf(CommonConstants.APPLICATION_CONTEXT) + "webitm" + File.separator : ".." + File.separator + "webapps" + File.separator + "ibase" + File.separator + "webitm" + File.separator;
        return defaultPath;
    }

    public String getXSLFileName() throws ITMException {
        String retFileName = null;
        try {
            String defaultPath = this.getDefaultPath();
            BaseLogger.log("3", this.userInfo, null, "ITMAuditBean.getXSLFileName() recObjName : [" + this.recObjName + "]");
            if (!"".equals(E12GenericUtility.checkNull(this.recObjName))) {
                String xslFileName = String.valueOf(this.objName) + "_" + this.recObjName + this.pContext + this.objContext + "_" + this.user_lang + "_" + this.user_country + "_" + this.editFlag + ".xsl";
                File tranxslFile = new File(String.valueOf(defaultPath) + "xsl", xslFileName);
                BaseLogger.log("3", this.userInfo, null, "Searching for transaction XSL File Abs Name :[" + defaultPath + "xsl/" + xslFileName + "]");
                if (tranxslFile.exists()) {
                    BaseLogger.log("3", this.userInfo, null, "XSL File Exists........");
                    retFileName = tranxslFile.getName();
                    return retFileName;
                }
            }
            String fileName = String.valueOf(this.objName) + this.pContext + this.objContext + "_" + this.user_lang + "_" + this.user_country + "_" + this.editFlag + ".xsl";
            File xslFile = new File(String.valueOf(defaultPath) + "xsl", fileName);
            BaseLogger.log("3", this.userInfo, null, "Searching for XSL File Abs Name :[" + defaultPath + "xsl/" + fileName + "]");
            if (xslFile.exists()) {
                BaseLogger.log("3", this.userInfo, null, "XSL File Exists........");
                retFileName = xslFile.getName();
            } else {
                BaseLogger.log("3", this.userInfo, null, "XSL File does not exist........");
                String xslString = "";
                if (this.pContext.equals("1")) {
                    xslString = this.getBrowFormXSLStr(this.userInfo);
                    BaseLogger.log("3", this.userInfo, null, "XSL File for Brow........");
                } else if (this.pContext.equals("2")) {
                    xslString = this.getFreeFormXSLStr(this.userInfo);
                    BaseLogger.log("3", this.userInfo, null, "XSL File for Detail........");
                }
                if (!xslString.endsWith(".xsl")) {
                    byte[] buffer = xslString.getBytes();
                    int bytes = buffer.length;
                    FileOutputStream fos = new FileOutputStream(xslFile);
                    fos.write(buffer, 0, bytes);
                    fos.flush();
                    fos.close();
                    fos = null;
                    retFileName = xslFile.getName();
                } else {
                    retFileName = xslString;
                }
            }
        }
        catch (ITMException itme) {
            BaseLogger.log("0", this.userInfo, null, "ITMException: ITMAuditBean: getXSLFileName :==>" + itme);
            retFileName = null;
            throw itme;
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception: ITMAuditBean :getXSLFileName :==>" + e);
            retFileName = null;
            e.printStackTrace();
            throw new ITMException(e);
        }
        BaseLogger.log("2", this.userInfo, null, "Returning XSL File Name :[" + retFileName + "]");
        return retFileName;
    }

    public String getXMLStrBrow() throws ITMException {
        BaseLogger.log("2", this.userInfo, null, "Getting Brow Form XML String....");
        InitialContext ctx = null;
        String xmlString = null;
        try {
            AppConnectParm appConnect = new AppConnectParm();
            ctx = new InitialContext(appConnect.getProperty());
            ITMBrowFormEJB ITMBrowForm = new ITMBrowFormEJB();
            xmlString = ITMBrowForm.getBrowForm(this.objName, this.objContext, String.valueOf(this.objName) + this.pContext + this.objContext, this.reqParamStr, this.userInfo);
            E12GenericUtility genericUtility = new E12GenericUtility();
            Document dom = genericUtility.parseString(xmlString);
            SimpleDateFormat formatter = new SimpleDateFormat(genericUtility.getDispDateFormat());
            Date date = new Date();
            String todaysDate = formatter.format(date);
            Date oneDayBeforeDate = new Date(System.currentTimeMillis() - 86400000L);
            String yesterdayDate = formatter.format(oneDayBeforeDate);
            NodeList parentNodeList = dom.getElementsByTagName("Detail1");
            if (parentNodeList != null && parentNodeList.getLength() > 0) {
                int i = 0;
                while (i < parentNodeList.getLength()) {
                    NodeList subChildList;
                    int totalDetailNodes;
                    Node currDetailNode = parentNodeList.item(i);
                    Node appendNode = null;
                    if (currDetailNode != null && currDetailNode.getNodeType() == 1 && (totalDetailNodes = (subChildList = currDetailNode.getChildNodes()).getLength()) > 0) {
                        int j = 0;
                        while (j < totalDetailNodes) {
                            String currNodeName;
                            appendNode = subChildList.item(j);
                            if (appendNode != null && appendNode.getNodeType() == 1 && (currNodeName = appendNode.getNodeName()).equalsIgnoreCase("chg_date") && appendNode.getFirstChild() != null && appendNode.getFirstChild().getNodeValue() != null) {
                                String currentDateValue = appendNode.getFirstChild().getNodeValue();
                                String[] dateString = currentDateValue.split(" ");
                                if (dateString[0].equalsIgnoreCase(todaysDate)) {
                                    appendNode.getFirstChild().setNodeValue("TODAY");
                                    break;
                                }
                                if (!dateString[0].equals(yesterdayDate)) break;
                                appendNode.getFirstChild().setNodeValue("YESTERDAY");
                                break;
                            }
                            ++j;
                        }
                    }
                    xmlString = genericUtility.serializeDom(dom);
                    BaseLogger.log("2", this.userInfo, null, "inside getXMLStrBrow...........269[[[[[[\n\n\n" + genericUtility.serializeDom(dom) + "]]]]]\n\n\n\n");
                    ++i;
                }
            }
            ITMBrowForm = null;
        }
        catch (ITMException itme) {
            BaseLogger.log("0", this.userInfo, null, "ITMException :ITMAuditBean :getXmlStr :==>");
            throw itme;
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception :ITMAuditBean :getXmlStr :==>");
            e.printStackTrace();
            throw new ITMException(e);
        }
        BaseLogger.log("2", this.userInfo, null, "Returning XML String Length :[" + xmlString.length() + "]bytes");
        return xmlString;
    }

    public String getXMLStrDetail() throws ITMException {
        BaseLogger.log("2", this.userInfo, null, "Getting Free Form XML String....");
        Object ctx = null;
        String xmlString = null;
        try {
            DBAccessEJB dbAccess = new DBAccessEJB();
            String query = "SELECT CHG_XML FROM AUDIT_TRAIL WHERE CHG_ID = ? AND OBJ_NAME=? AND REF_ID=?";
            ArrayList<String> bindVarValues = new ArrayList<String>();
            ArrayList<String> bindVarTypes = new ArrayList<String>();
            bindVarValues.add(this.chgID);
            bindVarValues.add(this.recObjName);
            bindVarValues.add(this.refID.trim());
            BaseLogger.log("3", this.userInfo, null, "query " + query);
            BaseLogger.log("3", this.userInfo, null, "this.chgID [" + this.chgID + "]");
            BaseLogger.log("3", this.userInfo, null, "this.recObjName [" + this.recObjName + "]");
            BaseLogger.log("3", this.userInfo, null, "this.refID [" + this.refID + "]");
            bindVarTypes.add("String");
            bindVarTypes.add("String");
            bindVarTypes.add("String");
            xmlString = dbAccess.getBlob(query, bindVarValues, bindVarTypes, this.userInfo);
            dbAccess = null;
        }
        catch (ITMException itme) {
            BaseLogger.log("0", this.userInfo, null, "ITMException :ITMAuditBean :getXmlStr :==>");
            throw itme;
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception :ITMAuditBean :getXmlStr :==>");
            e.printStackTrace();
            throw new ITMException(e);
        }
        BaseLogger.log("2", this.userInfo, null, "Returning XML String Length :[" + xmlString.length() + "]bytes");
        return xmlString;
    }

    private String getFreeFormXSLStr() throws Exception {
        BaseLogger.log("2", this.userInfo, null, "Building XSL Str......");
        String xslString = null;
        try {
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("IS_TAX_APPL", new Boolean(false));
            paramMap.put("KEY_FLAG", new String());
            paramMap.put("EDIT_TMPLT", new Integer(1));
            paramMap.put("CONFIRM_COL", "");
            paramMap.put("CONFIRM_VAL", "");
            I18NLabel localizer = new I18NLabel();
            Document metaDataDoc = localizer.setLocaleLabels(this.objName, this.objContext, this.user_lang, this.user_country, this.pContext, this.editFlag, this.userInfo.getProfileIdRes());
            xslString = localizer.getXSL(this.editFlag, CommonConstants.APPLICATION_CONTEXT, paramMap, this.userInfo);
            StringBuffer xslStrinBuff = new StringBuffer(xslString);
            xslString = xslStrinBuff.toString();
        }
        catch (ITMException itme) {
            BaseLogger.log("0", this.userInfo, null, "ITMException: ITMAuditBean: getFreeFormXSLStr:==>" + itme);
            throw itme;
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception: ITMAuditBean: getFreeFormXSLStr:==>" + e);
            e.printStackTrace();
            throw new ITMException(e);
        }
        BaseLogger.log("2", this.userInfo, null, "Returning XSL String Length :[" + xslString.length() + "]bytes");
        return xslString;
    }

    private String getBrowFormXSLStr() throws Exception {
        BaseLogger.log("2", this.userInfo, null, "Building XSL Str......");
        String xslString = null;
        try {
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("IS_TAX_APPL", new Boolean(false));
            paramMap.put("KEY_FLAG", new String());
            paramMap.put("EDIT_TMPLT", new Integer(1));
            paramMap.put("CONFIRM_COL", "");
            paramMap.put("CONFIRM_VAL", "");
            I18NLabel localizer = new I18NLabel();
            Document metaDataDoc = null;
            metaDataDoc = localizer.setLocaleLabels(this.objName, this.objContext, this.user_lang, this.user_country, this.pContext, this.editFlag, this.userInfo.getProfileIdRes());
            xslString = localizer.getXSL(this.editFlag, CommonConstants.APPLICATION_CONTEXT, paramMap, this.userInfo);
            StringBuffer xslStrinBuff = new StringBuffer(xslString);
            xslString = xslStrinBuff.toString();
        }
        catch (ITMException itme) {
            BaseLogger.log("0", this.userInfo, null, "ITMException: ITMAuditBean :getBrowFormXSLStr:==>" + itme);
            throw itme;
        }
        catch (Exception e) {
            BaseLogger.log("", this.userInfo, null, "Exception: ITMAuditBean :getBrowFormXSLStr:==>" + e);
            e.printStackTrace();
            throw new ITMException(e);
        }
        BaseLogger.log("2", this.userInfo, null, "Returning XSL String Length :[" + xslString.length() + "]bytes");
        return xslString;
    }

    public String getXSLFileName(UserInfoBean userInfo) throws ITMException {
        String retFileName = null;
        try {
            String defaultPath = this.getDefaultPath();
            BaseLogger.log("3", userInfo, null, "ITMAuditBean.getXSLFileName() recObjName : [" + this.recObjName + "]");
            if (!"".equals(E12GenericUtility.checkNull(this.recObjName))) {
                String xslFileName = String.valueOf(this.objName) + "_" + this.recObjName + this.pContext + this.objContext + "_" + this.user_lang + "_" + this.user_country + "_" + this.editFlag + ".xsl";
                File tranxslFile = new File(String.valueOf(defaultPath) + "xsl", xslFileName);
                BaseLogger.log("3", userInfo, null, "Searching for transaction XSL File Abs Name :[" + defaultPath + "xsl/" + xslFileName + "]");
                if (tranxslFile.exists()) {
                    BaseLogger.log("3", userInfo, null, "XSL File Exists........");
                    retFileName = tranxslFile.getName();
                    return retFileName;
                }
            }
            String fileName = String.valueOf(this.objName) + this.pContext + this.objContext + "_" + this.user_lang + "_" + this.user_country + "_" + this.editFlag + ".xsl";
            File xslFile = new File(String.valueOf(defaultPath) + "xsl", fileName);
            BaseLogger.log("3", userInfo, null, "Searching for XSL File Abs Name :[" + defaultPath + "xsl/" + fileName + "]");
            if (xslFile.exists()) {
                BaseLogger.log("3", userInfo, null, "XSL File Exists........");
                retFileName = xslFile.getName();
            } else {
                BaseLogger.log("3", userInfo, null, "XSL File does not exist........");
                String xslString = "";
                if (this.pContext.equals("1")) {
                    xslString = this.getBrowFormXSLStr(userInfo);
                    BaseLogger.log("3", userInfo, null, "XSL File for Brow........");
                } else if (this.pContext.equals("2")) {
                    xslString = this.getFreeFormXSLStr(userInfo);
                    BaseLogger.log("3", userInfo, null, "XSL File for Detail........");
                }
                if (!xslString.endsWith(".xsl")) {
                    byte[] buffer = xslString.getBytes();
                    int bytes = buffer.length;
                    FileOutputStream fos = new FileOutputStream(xslFile);
                    fos.write(buffer, 0, bytes);
                    fos.flush();
                    fos.close();
                    fos = null;
                    retFileName = xslFile.getName();
                } else {
                    retFileName = xslString;
                }
            }
        }
        catch (ITMException itme) {
            BaseLogger.log("0", userInfo, null, "ITMException: ITMAuditBean: getXSLFileName :==>" + itme);
            retFileName = null;
            throw itme;
        }
        catch (Exception e) {
            BaseLogger.log("0", userInfo, null, "Exception: ITMAuditBean :getXSLFileName :==>" + e);
            retFileName = null;
            e.printStackTrace();
            throw new ITMException(e);
        }
        BaseLogger.log("2", userInfo, null, "Returning XSL File Name :[" + retFileName + "]");
        return retFileName;
    }

    public String getXMLStrDetail(UserInfoBean userInfo) throws ITMException {
        BaseLogger.log("2", userInfo, null, "Getting Free Form XML String....");
        Object ctx = null;
        String xmlString = null;
        try {
            DBAccessEJB dbAccess = new DBAccessEJB();
            String query = "SELECT CHG_XML FROM AUDIT_TRAIL WHERE CHG_ID = ? AND OBJ_NAME=? AND REF_ID=?";
            ArrayList<String> bindVarValues = new ArrayList<String>();
            ArrayList<String> bindVarTypes = new ArrayList<String>();
            bindVarValues.add(this.chgID);
            bindVarValues.add(this.recObjName);
            bindVarValues.add(this.refID.trim());
            BaseLogger.log("3", userInfo, null, "query " + query);
            BaseLogger.log("3", userInfo, null, "this.chgID [" + this.chgID + "]");
            BaseLogger.log("3", userInfo, null, "this.recObjName [" + this.recObjName + "]");
            BaseLogger.log("3", userInfo, null, "this.refID [" + this.refID + "]");
            bindVarTypes.add("String");
            bindVarTypes.add("String");
            bindVarTypes.add("String");
            xmlString = dbAccess.getBlob(query, bindVarValues, bindVarTypes, userInfo);
            dbAccess = null;
        }
        catch (ITMException itme) {
            BaseLogger.log("0", userInfo, null, "ITMException :ITMAuditBean :getXmlStr :==>");
            throw itme;
        }
        catch (Exception e) {
            BaseLogger.log("0", userInfo, null, "Exception :ITMAuditBean :getXmlStr :==>");
            e.printStackTrace();
            throw new ITMException(e);
        }
        BaseLogger.log("2", userInfo, null, "Returning XML String Length :[" + xmlString.length() + "]bytes");
        return xmlString;
    }

    private String getFreeFormXSLStr(UserInfoBean userInfo) throws Exception {
        BaseLogger.log("2", userInfo, null, "Building XSL Str......");
        String xslString = null;
        try {
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("IS_TAX_APPL", new Boolean(false));
            paramMap.put("KEY_FLAG", new String());
            paramMap.put("EDIT_TMPLT", new Integer(1));
            paramMap.put("CONFIRM_COL", "");
            paramMap.put("CONFIRM_VAL", "");
            I18NLabel localizer = new I18NLabel();
            Document metaDataDoc = localizer.setLocaleLabels(this.objName, this.objContext, this.user_lang, this.user_country, this.pContext, this.editFlag, this.userInfo.getProfileIdRes());
            xslString = localizer.getXSL(this.editFlag, CommonConstants.APPLICATION_CONTEXT, paramMap, userInfo);
            StringBuffer xslStrinBuff = new StringBuffer(xslString);
            xslString = xslStrinBuff.toString();
        }
        catch (ITMException itme) {
            BaseLogger.log("0", userInfo, null, "ITMException: ITMAuditBean: getFreeFormXSLStr:==>" + itme);
            throw itme;
        }
        catch (Exception e) {
            BaseLogger.log("0", userInfo, null, "Exception: ITMAuditBean: getFreeFormXSLStr:==>" + e);
            e.printStackTrace();
            throw new ITMException(e);
        }
        BaseLogger.log("2", userInfo, null, "Returning XSL String Length :[" + xslString.length() + "]bytes");
        return xslString;
    }

    private String getBrowFormXSLStr(UserInfoBean userInfo) throws Exception {
        BaseLogger.log("2", userInfo, null, "Building XSL Str......");
        String xslString = null;
        try {
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("IS_TAX_APPL", new Boolean(false));
            paramMap.put("KEY_FLAG", new String());
            paramMap.put("EDIT_TMPLT", new Integer(1));
            paramMap.put("CONFIRM_COL", "");
            paramMap.put("CONFIRM_VAL", "");
            I18NLabel localizer = new I18NLabel();
            Document metaDataDoc = null;
            metaDataDoc = localizer.setLocaleLabels(this.objName, this.objContext, this.user_lang, this.user_country, this.pContext, this.editFlag, this.userInfo.getProfileIdRes());
            xslString = localizer.getXSL(this.editFlag, CommonConstants.APPLICATION_CONTEXT, paramMap, userInfo);
            StringBuffer xslStrinBuff = new StringBuffer(xslString);
            xslString = xslStrinBuff.toString();
        }
        catch (ITMException itme) {
            BaseLogger.log("0", userInfo, null, "ITMException: ITMAuditBean :getBrowFormXSLStr:==>" + itme);
            throw itme;
        }
        catch (Exception e) {
            BaseLogger.log("0", userInfo, null, "Exception: ITMAuditBean :getBrowFormXSLStr:==>" + e);
            e.printStackTrace();
            throw new ITMException(e);
        }
        BaseLogger.log("2", userInfo, null, "Returning XSL String Length :[" + xslString.length() + "]bytes");
        return xslString;
    }
}

