package ibase.webitm.ejb.wsfa.masters;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import org.apache.poi.util.SystemOutLogger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;

public class WsfaStrgCustPosSave extends ValidatorEJB {
	
	private	E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

	
	public String postSave(String domString, String objContext, String editFlag, String xtraParams, Connection conn)throws RemoteException, ITMException, SQLException
	{
		System.out.println("Inside the postSave Method...18/08/22");
		String retString="";
		String sql="";
		conn = getConnection();
		PreparedStatement pStmt = null;
		Document dom = null;
		
		try {
		
		dom = genericUtility.parseString(domString);

		String scCode = checkNull(genericUtility.getColumnValue("sc_code", dom, "1"));

		String custType = checkNull(genericUtility.getColumnValue("cust_type", dom, "1"));

		if(scCode != null && custType != null)
		{
			sql= "UPDATE strg_series SET CUST_TYPE=? WHERE SC_CODE=? ";
			pStmt = conn.prepareStatement(sql);
			pStmt.setString(1, custType);

			pStmt.setString(2, scCode);

		    int count=pStmt.executeUpdate();
		    System.out.println("update count is ["+count+"]");

		}
		if(pStmt != null)
		{
			pStmt.close();
			pStmt = null;
		}
		if (conn != null)
		{
			conn.close();
			conn = null;
		}
		}
		catch (Exception e)
		{
			System.out.println("Exception :==>\n" + e.getMessage());
			throw new ITMException(e);	
		}
		return retString;
	}

	
	private String checkNull(String input)
	{
		if (input == null || "null".equalsIgnoreCase(input))
		{
			input= "";
		}
		return input.trim();
	}

	
}
