package ibase.webitm.ejb.wsfa.transactions;

import ibase.webitm.ejb.*;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.system.config.AppConnectParm;
import ibase.webitm.utility.ITMException;
import ibase.system.config.ConnDriver;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.*;
import java.sql.*;
import java.sql.Date;

import javax.ejb.*;
import javax.naming.InitialContext;
import java.rmi.RemoteException;
import org.w3c.dom.*;

//@javax.ejb.Stateless		commented by Sagar M [22 Nov 2018].

public class StrgMeetDCRWizDelete extends ActionHandlerEJB implements  StrgMeetDCRWizDeleteRemote,StrgMeetDCRWizDeleteLocal
{
	SessionContext cSessionContext;
	E12GenericUtility genericUtility = new E12GenericUtility();

	public void setSessionContext(SessionContext mSessionContext)
	{
	}

	public String delete(String dcrId, String xtraParams, String forcedFlag) throws RemoteException,ITMException
	{
		String retString = "";
		boolean isError = false;
		PreparedStatement pStmt = null;
		PreparedStatement pstmtUpd = null;
		ResultSet rs = null;
		boolean isLocalConn = false, isDeleteDcr = false;
		//String dcrId = "";
		String empCodeConf = "", eventDate = "";
		String objName = "";
		String tranIdCol = "";
		java.sql.Date evDate = null;
		int count = 0, detCnt = 0;
		String tranId="";
		String activityCode="";
		Connection conn = null;

		try
		{
			System.out.println("dcrId ::"+dcrId);
			System.out.println(" StrgMeetDCRWizDelete delete method is called.........");
			ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
			if(conn == null)
			{
				conn = getConnection();
				isLocalConn = true;
				conn.setAutoCommit( false );
			}
			//Document dom = genericUtility.parseString(xmlString);
			//dcrId = checkNull(genericUtility.getColumnValue("survey_id", dom, "1"));
			if(!xtraParams.contains("#"))
			{
				empCodeConf = checkNull(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode"));
			}
			else
			{
				String[] xtraParmArr = xtraParams.split("#");
				empCodeConf = xtraParmArr[0];
			}

			objName = checkNull(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "objName"));
			objName = "w_" + objName;
			String sql1 = "SELECT TRAN_ID_COL FROM TRANSETUP WHERE TRAN_WINDOW = ?";
			pStmt = conn.prepareStatement( sql1 );
			pStmt.setString( 1, objName);
			rs = pStmt.executeQuery();
			if( rs.next())
			{
				tranIdCol = rs.getString("TRAN_ID_COL");

			}
			System.out.println("tranIdCol =["+tranIdCol+"]");
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if( pStmt != null )
			{
				pStmt.close();
				pStmt = null;
			}

			if("tran_id".equalsIgnoreCase(tranIdCol))
			{
				tranId = dcrId;// added by mrunakini sinkar on 27-02-2019
				
				sql1 = "SELECT DCR_ID FROM STRG_MEET WHERE TRAN_ID = ?";
				pStmt = conn.prepareStatement( sql1 );
				pStmt.setString( 1, dcrId);
				rs = pStmt.executeQuery();
				if( rs.next())
				{
					dcrId = checkNull(rs.getString("DCR_ID"));
				}
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if( pStmt != null )
				{
					pStmt.close();
					pStmt = null;
				}
			}

			System.out.println("dcrId =["+dcrId+"], empCodeConf=["+empCodeConf+"] tran Id is["+tranId);

			DateFormat dtFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());
			java.util.Date date = Calendar.getInstance().getTime();
			String currDate = dtFormat.format( date );
			java.sql.Date eventCurrDate = null;
			currDate = genericUtility.getValidDateTimeString( currDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );

			System.out.println("currDate =["+currDate+"]");


			String dateSql1 = "SELECT EVENT_DATE FROM SPRS_ACT_TRAN WHERE DCR_ID = ? AND SALES_PERS = ? ";

			pStmt = conn.prepareStatement( dateSql1 );
			pStmt.setString( 1, dcrId);
			pStmt.setString( 2, empCodeConf);
			rs = pStmt.executeQuery();
			if( rs.next())
			{
				eventDate = rs.getString("EVENT_DATE");

			}
			System.out.println("eventDate =["+eventDate+"]");
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if( pStmt != null )
			{
				pStmt.close();
				pStmt = null;
			}

			String actCode = ""; // added by rupali on 14/03/18 for prescription menu
			String dateSql = "SELECT EVENT_DATE, ACTIVITY_CODE FROM SPRS_ACT_TRAN WHERE DCR_ID = ? AND SALES_PERS = ? ";

			pStmt = conn.prepareStatement( dateSql );
			pStmt.setString( 1, dcrId);
			pStmt.setString( 2, empCodeConf);
			rs = pStmt.executeQuery();
			if( rs.next())
			{
				evDate = rs.getDate("EVENT_DATE");
				actCode = rs.getString("ACTIVITY_CODE"); // added by rupali on 14/03/18 for prescription menu
			}

			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if( pStmt != null )
			{
				pStmt.close();
				pStmt = null;
			}
			boolean dcrDelete = false;
			//added by Rupali on 12/02/18 for defining sfaparam value for sequential deletion[start]
			String parmValue = "";
			String sfaParmSql = "SELECT PARM_VALUE FROM SFAPARM WHERE PARM_NAME='SEQUENTIAL_DAR_DELETE' AND ? BETWEEN EFF_FROM AND VALID_UPTO AND ACTIVE='Y' ";
			PreparedStatement pstmtSfaParm = conn.prepareStatement(sfaParmSql);
			pstmtSfaParm.setTimestamp(1, java.sql.Timestamp.valueOf(currDate));
			ResultSet rsSfaParm = pstmtSfaParm.executeQuery();
			if (rsSfaParm.next())
			{
				parmValue = checkNull(rsSfaParm.getString("PARM_VALUE"));
			}
			if(rsSfaParm != null)
			{
				rsSfaParm.close();
				rsSfaParm = null;
			}
			if(pstmtSfaParm != null)
			{
				pstmtSfaParm.close();
				pstmtSfaParm = null;
			}
			System.out.println("In 1 If parmValue is :"+ parmValue);
			//added by Rupali on 12/02/18 for defining sfaparam value for sequential deletion[end]
			if(parmValue.equalsIgnoreCase("Y"))
			{
				java.sql.Date maxDate = null;
				SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
				PreparedStatement pstmtComp = null;
				String checkSql = "SELECT MAX(EVENT_DATE) AS MAXDATE FROM SPRS_ACT_TRAN WHERE  SALES_PERS = ? "+
						          "AND ACTIVITY_CODE IN (SELECT ACTIVITY_CODE FROM FIELDACTIVITY WHERE ACTIVITY_TYPE !='PR')";
				System.out.println("checkSql:- "+checkSql);
				pstmtComp = conn.prepareStatement(checkSql);
				pstmtComp.setString(1, empCodeConf);
				rs = pstmtComp.executeQuery();
				if(rs.next())
				{
					maxDate = rs.getDate("MAXDATE");
				}
				System.out.println("maxDate:::="+maxDate);
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if( pstmtComp != null )
				{
					pstmtComp.close();
					pstmtComp = null;
				}
				System.out.println("Event Date: ["+evDate+"] Max Date :["+maxDate);
				if(evDate.before(maxDate) && !"PR".equalsIgnoreCase(actCode)) // added condition by rupali on 14/03/18 for prescription menu
				{
					System.out.println("Value inside Event DAte ");
					// retString = "PENDING :" + getMessageDescr(conn,"PENDDCRDEL");
					retString =  itmDBAccessEJB.getErrorString("","PENDDCRDEL","");
					dcrDelete = true;
				}
			}
			if(!dcrDelete)
			{
				if( dcrId != null && dcrId.trim().length() > 0)
			   	{
					String deleteSql = "DELETE FROM SPRS_ACT_TRAN WHERE (SALES_PERS,";
			   	}
			 	//if( dcrId != null && (dcrId.contains("WF") || dcrId.contains("WD")))
		 		if( dcrId != null && dcrId.trim().length() > 0)
			   	{
			 		System.out.println("Delete from DCR Reporting............");
			 		String prDcrId = "";
			 		String idSql = "SELECT DCR_ID FROM SPRS_ACT_TRAN WHERE EVENT_DATE = ? AND SALES_PERS = ? AND ACTIVITY_CODE = 'PR'";

					pStmt = conn.prepareStatement( idSql );
					pStmt.setTimestamp( 1, java.sql.Timestamp.valueOf(eventDate) );
					pStmt.setString( 2, empCodeConf);

					rs = pStmt.executeQuery();
					if( rs.next())
					{
						prDcrId = rs.getString("DCR_ID");
					}
					System.out.println("prDcrId =["+prDcrId+"]  dcrId:::["+dcrId+"]");
					if(rs != null)
					{
						rs.close();
						rs = null;
					}
					if( pStmt != null )
					{
						pStmt.close();
						pStmt = null;
					}


				   	String dcrSql = "SELECT COUNT (1) COUNT FROM SPRS_ACT_TRAN WHERE DCR_ID = ? ";

					pStmt = conn.prepareStatement( dcrSql );
					pStmt.setString( 1, dcrId);
					rs = pStmt.executeQuery();
					if( rs.next())
					{
						count = rs.getInt("COUNT");
					}
					if(rs != null)
					{
						rs.close();
						rs = null;
					}
					if( pStmt != null )
					{
						pStmt.close();
						pStmt = null;
					}
					System.out.println("Deleted Data for DCR_ID =["+dcrId+"]");
					System.out.println("SPRS_ACT_TRAN count =["+count+"]");

					if(count == 1)
					{
						// added by mrunalini sinkar on 27-feb-2019(start)

						boolean isDeleted= false;
						if("tran_id".equalsIgnoreCase(tranIdCol))
						{
							 isDeleted = deleteReportDCR(tranId,dcrId, conn);
						}
						// added by mrunalini sinkar on 27-feb-2019(end)
						else
						{
							 isDeleted = deleteDCR(dcrId, conn);
						}
						
						if(isDeleted)
						{
							retString =	itmDBAccessEJB.getErrorString("","DCRDETSUCC","");
							isDeleteDcr = true;
						}
						else
						{
							retString =	itmDBAccessEJB.getErrorString("","DCRDETFALD","");
							isError=true;
						}
					}
					else if(count > 0)
					{
						retString =	itmDBAccessEJB.getErrorString("","DCRDETFALD","");
						isError = true;
					}

					// commented by rupali on 12/03/18 for separating deletion of pr and dcr report [start]
				/*	count = 0;
				 	String prSql = "SELECT COUNT (1) COUNT FROM SPRS_ACT_TRAN WHERE DCR_ID = ? ";

					pStmt = conn.prepareStatement( prSql );
					pStmt.setString( 1, prDcrId);
					rs = pStmt.executeQuery();
					if( rs.next())
					{
						count = rs.getInt("COUNT");
					}
					if(rs != null)
					{
						rs.close();
						rs = null;
					}
					if( pStmt != null )
					{
						pStmt.close();
						pStmt = null;
					}
					System.out.println("Deleted Data for prDcrId =["+prDcrId+"]");
					System.out.println(" prDcrId SPRS_ACT_TRAN count =["+count+"]");
					if(count == 1)
					{
						boolean isDeleted = deleteDCR(prDcrId, conn);
						if(isDeleted)
						{
							retString =	itmDBAccessEJB.getErrorString("","DCRDETSUCC","");
							isDeleteDcr = true;
						}
						else
						{
							retString =	itmDBAccessEJB.getErrorString("","DCRDETFALD","");
						}
					}
					else if(count > 0 )
					{
						retString =	itmDBAccessEJB.getErrorString("","DCRDETFALD","");
					}*/
					// commented by rupali on 12/03/18 for separating deletion of pr and dcr report [end]
			   	}
		 		/*
			 	else if(dcrId != null && dcrId.contains("WP"))
			 	{
			 		System.out.println("Delete from Prescription Reporting............");
			 		String prDcrId = "";
			 		String idSql = "SELECT DCR_ID FROM SPRS_ACT_TRAN WHERE EVENT_DATE = ? AND SALES_PERS = ? AND ACTIVITY_CODE <> 'PR'";

					pStmt = conn.prepareStatement( idSql );
					pStmt.setTimestamp( 1, java.sql.Timestamp.valueOf(eventDate) );
					pStmt.setString( 2, empCodeConf);

					rs = pStmt.executeQuery();
					if( rs.next())
					{
						prDcrId = rs.getString("DCR_ID");
					}
					System.out.println("dcrId =["+prDcrId+"]  prDcrId:::["+dcrId+"]");
					if(rs != null)
					{
						rs.close();
						rs = null;
					}
					if( pStmt != null )
					{
						pStmt.close();
						pStmt = null;
					}


				   	String dcrSql = "SELECT COUNT (1) COUNT FROM SPRS_ACT_TRAN WHERE DCR_ID = ? ";

					pStmt = conn.prepareStatement( dcrSql );
					pStmt.setString( 1, dcrId);
					rs = pStmt.executeQuery();
					if( rs.next())
					{
						count = rs.getInt("COUNT");
					}
					if(rs != null)
					{
						rs.close();
						rs = null;
					}
					if( pStmt != null )
					{
						pStmt.close();
						pStmt = null;
					}
					System.out.println("Deleted Data for DCR_ID =["+dcrId+"]");
					System.out.println("SPRS_ACT_TRAN count =["+count+"]");
					if(count == 1)
					{
						boolean isDeleted = deleteDCR(dcrId, conn);
						if(isDeleted)
						{
							retString =	itmDBAccessEJB.getErrorString("","DCRDETSUCC","");
							isDeleteDcr = true;
						}
						else
						{
							retString =	itmDBAccessEJB.getErrorString("","DCRDETFALD","");
						}
					}
					else if(count > 0)
					{
						retString =	itmDBAccessEJB.getErrorString("","DCRDETFALD","");
					}


					count = 0;
				 	String prSql = "SELECT COUNT (1) COUNT FROM SPRS_ACT_TRAN WHERE DCR_ID = ? ";

					pStmt = conn.prepareStatement( prSql );
					pStmt.setString( 1, prDcrId);
					rs = pStmt.executeQuery();
					if( rs.next())
					{
						count = rs.getInt("COUNT");
					}
					if(rs != null)
					{
						rs.close();
						rs = null;
					}
					if( pStmt != null )
					{
						pStmt.close();
						pStmt = null;
					}
					System.out.println("Deleted Data for prDcrId =["+prDcrId+"]");
					System.out.println(" prDcrId SPRS_ACT_TRAN count =["+count+"]");
					if(count == 1)
					{
						boolean isDeleted = deleteDCR(prDcrId, conn);
						if(isDeleted)
						{
							retString =	itmDBAccessEJB.getErrorString("","DCRDETSUCC","");
							isDeleteDcr = true;
						}
						else
						{
							retString =	itmDBAccessEJB.getErrorString("","DCRDETFALD","");
						}
					}
					else if(count > 0)
					{
						retString =	itmDBAccessEJB.getErrorString("","DCRDETFALD","");
					}

			 	}
			 	else if( dcrId != null && dcrId.contains("WM"))
			   	{
			 		System.out.println("Delete from MGR DCR Reporting............");
			 		String prDcrId = "";
			 		String idSql = "SELECT DCR_ID FROM SPRS_ACT_TRAN WHERE EVENT_DATE = ? AND SALES_PERS = ? AND ACTIVITY_CODE = 'PR'";

					pStmt = conn.prepareStatement( idSql );
					pStmt.setTimestamp( 1, java.sql.Timestamp.valueOf(eventDate) );
					pStmt.setString( 2, empCodeConf);

					rs = pStmt.executeQuery();
					if( rs.next())
					{
						prDcrId = rs.getString("DCR_ID");
					}
					System.out.println("prDcrId =["+prDcrId+"]  dcrId:::["+dcrId+"]");
					if(rs != null)
					{
						rs.close();
						rs = null;
					}
					if( pStmt != null )
					{
						pStmt.close();
						pStmt = null;
					}


				   	String dcrSql = "SELECT COUNT (1) COUNT FROM SPRS_ACT_TRAN WHERE DCR_ID = ? ";

					pStmt = conn.prepareStatement( dcrSql );
					pStmt.setString( 1, dcrId);
					rs = pStmt.executeQuery();
					if( rs.next())
					{
						count = rs.getInt("COUNT");
					}
					if(rs != null)
					{
						rs.close();
						rs = null;
					}
					if( pStmt != null )
					{
						pStmt.close();
						pStmt = null;
					}
					System.out.println("Deleted Data for DCR_ID =["+dcrId+"]");
					System.out.println("SPRS_ACT_TRAN count =["+count+"]");
					if(count == 1)
					{
						boolean isDeleted = deleteDCR(dcrId, conn);
						if(isDeleted)
						{
							retString =	itmDBAccessEJB.getErrorString("","DCRDETSUCC","");
							isDeleteDcr = true;
						}
						else
						{
							retString =	itmDBAccessEJB.getErrorString("","DCRDETFALD","");
						}
					}
					else if(count > 0)
					{
						retString =	itmDBAccessEJB.getErrorString("","DCRDETFALD","");
					}


					count = 0;
				 	String prSql = "SELECT COUNT (1) COUNT FROM SPRS_ACT_TRAN WHERE DCR_ID = ? ";

					pStmt = conn.prepareStatement( prSql );
					pStmt.setString( 1, prDcrId);
					rs = pStmt.executeQuery();
					if( rs.next())
					{
						count = rs.getInt("COUNT");
					}
					if(rs != null)
					{
						rs.close();
						rs = null;
					}
					if( pStmt != null )
					{
						pStmt.close();
						pStmt = null;
					}
					System.out.println("Deleted Data for prDcrId =["+prDcrId+"]");
					System.out.println(" prDcrId SPRS_ACT_TRAN count =["+count+"]");
					if(count == 1)
					{
						boolean isDeleted = deleteDCR(prDcrId, conn);
						if(isDeleted)
						{
							retString =	itmDBAccessEJB.getErrorString("","DCRDETSUCC","");
							isDeleteDcr = true;
						}
						else
						{
							retString =	itmDBAccessEJB.getErrorString("","DCRDETFALD","");
						}
					}
					else if(count > 0 )
					{
						retString =	itmDBAccessEJB.getErrorString("","DCRDETFALD","");
					}
			   	}
		 		*/
			 }
		}
		catch(Exception e)
		{
			isError = true;
			System.out.println("Exception :StrgMeetDCRWizDelete :==>\n"+e.getMessage());
			e.printStackTrace();
			retString =	new ITMDBAccessEJB().getErrorString("","DCRDETFALD","");
			throw new ITMException(e);
		}

		finally
		{
			try
			{
				System.out.println("isError ["+isError+"]");
				System.out.println("isLocalConn ["+isLocalConn+"]");
				if( conn != null )
				{

					if( isError )
					{
						conn.rollback();
					}
					if(pStmt != null)
					{
						pStmt.close();
						pStmt = null;
					}
					if ( isLocalConn )
					{
						if ( ! isError )
						{
							conn.commit();
							System.out.println("StrgMeetDCRWizDelete Connection commited........");
						}
						conn.close();
						conn = null;
					}

				}
			}
			catch(Exception e)
			{
				System.out.println("Exception :StrgMeetDCRWizDelete :confirm :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		System.out.println("[StrgMeetDCRWizDelete]Return string :"+retString);
		return retString;
	}
	private String checkNull(String value)
	{
		if ( value == null )
		{
			value = "";
		}
		return value.trim();
	}
	@Override
	public String delete(String tranId, String xtraParams, String forcedFlag,
			Connection conn) throws RemoteException, ITMException
	{
		// TODO Auto-generated method stub
		return null;
	}
	public boolean deleteDCR(String dcrId, Connection conn)
	{
		System.out.println("inside deleteDcr");
		boolean isSuccess= false;
		PreparedStatement pstmt=null;
		ResultSet rs=null;
		try
		{
			int count = 0, detCnt = 0;
			String salesPers="";

			String sqlactTran ="select sales_PERS from sprs_act_tran where DCR_ID=?";
			pstmt=conn.prepareStatement(sqlactTran);
			pstmt.setString(1, dcrId);
			rs=pstmt.executeQuery();
			if(rs.next())
			{
				salesPers=rs.getString("sales_PERS");
			}
			if( rs != null )
			{
				rs.close();
				rs = null;
			}
			if( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			StrgMeetDCRWizard strgMeetDCRWizard=new StrgMeetDCRWizard();
			String isFortune  = checkNull(strgMeetDCRWizard.getSfaParmValue(salesPers,"IS_FORTUNE_ACTIVITY",conn));

        	//added by prachi on 28-Sep-2022
			
			String getDetailsForSurveyUpdate ="SELECT STRG_CODE,SURVEY_TEMPL,SALES_PERS FROM STRG_MEET WHERE DCR_ID=?";
			pstmt=conn.prepareStatement(getDetailsForSurveyUpdate);
			pstmt.setString(1, dcrId);
			rs=pstmt.executeQuery();
			while(rs.next())
			{
					String salesPerson=checkNull(rs.getString("SALES_PERS"));
					String surveyTempl=checkNull(rs.getString("SURVEY_TEMPL"));
					String strgCode=checkNull(rs.getString("STRG_CODE"));
					
					String SurveyStatus="";
					String surveryStatusSQL ="SELECT DISTINCT(SURV_STATUS) AS SURV_STATUS FROM STRG_SURV_RES WHERE DCR_ID= ? AND STRG_CODE = ?";
					PreparedStatement pSS = conn.prepareStatement(surveryStatusSQL);
					pSS.setString(1, dcrId);
					pSS.setString(2, strgCode);
					ResultSet rSS = pSS.executeQuery();
					if(rSS.next())
					{
						SurveyStatus=checkNull(rSS.getString("SURV_STATUS"));
					}
					if( rSS != null )
					{
						rSS.close();
						rSS = null;
					}
					if( pSS != null )
					{
						pSS.close();
						pSS = null;
					}
					System.out.println("SurveyStatus:"+SurveyStatus);
					if(SurveyStatus.equals("Y"))
					{
						
						String maxDCRID="";
						String maxID="SELECT MAX(SM.DCR_ID) AS DCR_ID FROM STRG_MEET SM,STRG_SURV_RES SR WHERE SM.DCR_ID!=? AND SM.STRG_CODE=? AND SM.SURVEY_TEMPL=? AND SM.SALES_PERS=? AND"
								+ " SR.DCR_ID=SM.DCR_ID AND SR.STRG_CODE=SM.STRG_CODE";
						PreparedStatement ps = conn.prepareStatement(maxID);
						ps.setString(1, dcrId);
						ps.setString(2, strgCode);
						ps.setString(3, surveyTempl);
						ps.setString(4, salesPerson);
						ResultSet rs1=ps.executeQuery();
						if(rs1.next())
						{
							maxDCRID=checkNull(rs1.getString("DCR_ID"));
							String updSurveySubSql = " UPDATE STRG_SURV_RES SET SURV_STATUS = 'Y' WHERE DCR_ID = ? AND STRG_CODE = ?";
							PreparedStatement pstmtupdSurveySub =  conn.prepareStatement(updSurveySubSql);
							pstmtupdSurveySub.setString(1, maxDCRID);
							pstmtupdSurveySub.setString(2, strgCode);
							
							int updCount = pstmtupdSurveySub.executeUpdate();
							if(pstmtupdSurveySub!=null)
							{
							  pstmtupdSurveySub.close(); 
							  pstmtupdSurveySub = null;
							}
							System.out.println("STRG_SURV_RES is Updated updCount:["+updCount+"]");
						}
						if( rs1 != null )
						{
							rs1.close();
							rs1 = null;
						}
						if( ps != null )
						{
							ps.close();
							ps = null;
						}
					  
					}	
		    }
			if( rs != null )
			{
				rs.close();
				rs = null;
			}
			if( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			
			String delSurveySubSql = "DELETE FROM STRG_SURV_RES WHERE  DCR_ID = ?";
			PreparedStatement pstmtdelSurveySub =  conn.prepareStatement(delSurveySubSql);
			pstmtdelSurveySub.setString(1, dcrId);
			int detSurveyCnt = pstmtdelSurveySub.executeUpdate();
			pstmtdelSurveySub.close(); pstmtdelSurveySub = null;
			System.out.println("Data From STRG_SURV_RES is deleted detCnt:["+detSurveyCnt+"]");
			
			//end

			String delMeetItemSql = "DELETE FROM STRG_MEET_ITEMS WHERE DCR_ID = ? ";
			PreparedStatement pstmtDelItem =  conn.prepareStatement(delMeetItemSql);
			pstmtDelItem.setString(1, dcrId);
			detCnt = pstmtDelItem.executeUpdate();
			pstmtDelItem.close(); pstmtDelItem = null;
			System.out.println("Data From STRG_MEET_ITEMS is deleted detCnt:["+detCnt+"]");

			String delMeetOrderSql = "DELETE FROM STRG_MEET_ORDER WHERE DCR_ID = ? ";
			PreparedStatement pstmtDelOrd =  conn.prepareStatement(delMeetOrderSql);
			pstmtDelOrd.setString(1, dcrId);
			detCnt = pstmtDelOrd.executeUpdate();
			pstmtDelOrd.close(); pstmtDelOrd = null;
			System.out.println("Data From STRG_MEET_ORDER is deleted detCnt:["+detCnt+"]");
			
			//ADDED BY BHAGYASHRI T FOR DELETE DATA FROM INVOICE TABLE[04/08/2022]
			String delMeetInvoiceSql = "DELETE FROM STRG_MEET_INVOICE WHERE DCR_ID = ? ";
			PreparedStatement pstmtDelInv =  conn.prepareStatement(delMeetInvoiceSql);
			pstmtDelInv.setString(1, dcrId);
			detCnt = pstmtDelInv.executeUpdate();
			pstmtDelInv.close(); pstmtDelInv = null;
			System.out.println("Data From STRG_MEET_INVOICE is deleted detCnt:["+detCnt+"]");
			//ADDED BY BHAGYASHRI T FOR DELETE DATA FROM INVOICE TABLE[04/08/2022]

			String delMeetTeamSql = "DELETE FROM STRG_MEET_TEAM WHERE DCR_ID = ? ";
			PreparedStatement pstmtDelTeam =  conn.prepareStatement(delMeetTeamSql);
			pstmtDelTeam.setString(1, dcrId);
			detCnt= pstmtDelTeam.executeUpdate();
			pstmtDelTeam.close(); pstmtDelTeam = null;
			System.out.println("Data From STRG_MEET_TEAM is deleted detCnt:["+detCnt+"]");

			String delMeetbrandSql = "DELETE FROM STRG_BRAND_PITCH WHERE DCR_ID = ? ";
			PreparedStatement pstmtDelBarnd =  conn.prepareStatement(delMeetbrandSql);
			pstmtDelBarnd.setString(1, dcrId);
			detCnt = pstmtDelBarnd.executeUpdate();
			pstmtDelBarnd.close(); pstmtDelBarnd = null;
			System.out.println("Data From STRG_BRAND_PITCH is deleted detCnt:["+detCnt+"]");

			String delDisplSql = "DELETE FROM STRG_ITEM_DISPLAY WHERE DCR_ID = ? ";
			PreparedStatement pstmtDelDisp =  conn.prepareStatement(delDisplSql);
			pstmtDelDisp.setString(1, dcrId);
			detCnt = pstmtDelDisp.executeUpdate();
			pstmtDelDisp.close(); pstmtDelDisp = null;
			System.out.println("Data From STRG_ITEM_DISPLAY is deleted detCnt:["+detCnt+"]");

			String delCustSql = "DELETE FROM STRG_CUST_ADD WHERE  DCR_ID = ?";
			PreparedStatement pstmtDelCust =  conn.prepareStatement(delCustSql);
			pstmtDelCust.setString(1, dcrId);
			detCnt = pstmtDelCust.executeUpdate();
			pstmtDelCust.close(); pstmtDelCust = null;
			System.out.println("Data From STRG_MEET is deleted detCnt:["+detCnt+"]");

			// added by rupali on 11/09117 for survey form [start]
			String delSurveySql = "DELETE FROM STRG_BRAND_SURVEY WHERE  DCR_ID = ?";
			PreparedStatement pstmtdelSurvey =  conn.prepareStatement(delSurveySql);
			pstmtdelSurvey.setString(1, dcrId);
			detCnt = pstmtdelSurvey.executeUpdate();
			pstmtdelSurvey.close(); pstmtdelSurvey = null;
			System.out.println("Data From STRG_MEET is deleted detCnt:["+detCnt+"]");
			// added by rupali on 11/09117 for survey form [end]

			String delCoachingSubSql = "DELETE FROM SPRS_COACHING WHERE  DCR_ID = ?";
			PreparedStatement pstmtdelCoachingSub =  conn.prepareStatement(delCoachingSubSql);
			pstmtdelCoachingSub.setString(1, dcrId);
			detCnt = pstmtdelCoachingSub.executeUpdate();
			pstmtdelCoachingSub.close(); pstmtdelCoachingSub = null;
			
			System.out.println("Data From SPRS_COACHING is deleted detCnt:["+detCnt+"]");

			
			String delMeetSql = "DELETE FROM STRG_MEET WHERE  DCR_ID = ?";
			PreparedStatement pstmtDelMeet =  conn.prepareStatement(delMeetSql);
			pstmtDelMeet.setString(1, dcrId);
			detCnt = pstmtDelMeet.executeUpdate();
			pstmtDelMeet.close(); pstmtDelMeet = null;
			System.out.println("Data From STRG_MEET is deleted detCnt:["+detCnt+"]");
			
			String delTravelSql = "DELETE FROM SPRS_TRAVEL WHERE  DCR_ID = ?";
			PreparedStatement pstmtDelTravel =  conn.prepareStatement(delTravelSql);
			pstmtDelTravel.setString(1, dcrId);
			detCnt = pstmtDelTravel.executeUpdate();
			pstmtDelTravel.close(); pstmtDelTravel = null;
			
			// Added by Harion S for Activity form changes in fortune server --18-May-2021 [Start]
			//if("Y".equalsIgnoreCase(isFortune))
			//{
				String delActivitySql = "DELETE FROM SPRS_ACTIVITY WHERE  DCR_ID = ?";
				PreparedStatement pstmtDelActivity =  conn.prepareStatement(delActivitySql);
				pstmtDelActivity.setString(1, dcrId);
				detCnt = pstmtDelActivity.executeUpdate();
				pstmtDelActivity.close(); pstmtDelActivity = null;
			//}
			// Added by Harion S for Activity form changes in fortune server --18-May-2021 [End]

			String delActTranSql = "DELETE FROM SPRS_ACT_TRAN WHERE  DCR_ID = ? ";
			PreparedStatement pstmtDelActTran =  conn.prepareStatement(delActTranSql);
			pstmtDelActTran.setString(1, dcrId);
			detCnt = pstmtDelActTran.executeUpdate();
			pstmtDelActTran.close(); pstmtDelActTran = null;
			System.out.println("Data From SPRS_ACT_TRAN is deleted detCnt:["+detCnt+"]");
			
			//ADDED BY PRACHI K [W22EBAS005] ON 08-AUG-2022
			String delCollectSubSql = "DELETE FROM STRG_MEET_COLLECT WHERE  DCR_ID = ?";
			PreparedStatement pstmtdelCollectSub =  conn.prepareStatement(delCollectSubSql);
			pstmtdelCollectSub.setString(1, dcrId);
			detCnt = pstmtdelCollectSub.executeUpdate();
			pstmtdelCollectSub.close(); pstmtdelCollectSub = null;
			System.out.println("Data From STRG_MEET_COLLECT is deleted detCnt:["+detCnt+"]");
			
			isSuccess = true;
		}
		catch(Exception ex)
		{
			isSuccess =false;
			System.out.println("in CAtch Exception in deletDCR["+isSuccess+"]ex["+ex+"]");

			ex.printStackTrace();
		}
		return isSuccess;
	}
	
	// added by mrunalini sinkar on 27-feb-2019to delete realtime report (start)
	public boolean deleteReportDCR(String tranId,String dcrId, Connection conn)
	{
		System.out.println("deleteReportDCR is:["+tranId+"]");

		boolean isSuccess= false;
		PreparedStatement pstmt=null;
		ResultSet rs=null;
		try
		{
			String salesPers="";
			int count = 0, detCnt = 0,locCnt=0 , activityCount=0;

			String sqlactTran ="select sales_PERS from sprs_act_tran where DCR_ID=?";
			pstmt=conn.prepareStatement(sqlactTran);
			pstmt.setString(1, dcrId);
			rs=pstmt.executeQuery();
			if(rs.next())
			{
				salesPers=rs.getString("sales_PERS");
			}
			if( rs != null )
			{
				rs.close();
				rs = null;
			}
			if( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			StrgMeetDCRWizard strgMeetDCRWizard=new StrgMeetDCRWizard();
			String isFortune  = checkNull(strgMeetDCRWizard.getSfaParmValue(salesPers,"IS_FORTUNE_ACTIVITY",conn));

			
			String sql ="SELECT COUNT(*) AS CNT FROM STRG_MEET WHERE DCR_ID=?";
			pstmt=conn.prepareStatement(sql);
			pstmt.setString(1, dcrId);
			rs=pstmt.executeQuery();
			if(rs.next())
			{
				count=rs.getInt("CNT");
			}
			if( rs != null )
			{
				rs.close();
				rs = null;
			}
			if( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			

			String locality="";
			String locSql ="SELECT LOCALITY_CODE AS LOC_CODE FROM STRG_MEET WHERE TRAN_ID = ?";
			pstmt=conn.prepareStatement(locSql);
			pstmt.setString(1, tranId);
			rs=pstmt.executeQuery();
			if(rs.next())
			{
				locality=checkNull(rs.getString("LOC_CODE"));
			}
			if( rs != null )
			{
				rs.close();
				rs = null;
			}
			if( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			
			String locCntSql ="SELECT COUNT(*) AS LOC_CNT FROM STRG_MEET WHERE DCR_ID = ? AND LOCALITY_CODE = ?";
			pstmt=conn.prepareStatement(locCntSql);
			pstmt.setString(1, dcrId);
			pstmt.setString(2, locality);
			rs=pstmt.executeQuery();
		
			if(rs.next())
			{
				locCnt=rs.getInt("LOC_CNT");
			}
			if( rs != null )
			{
				rs.close();
				rs = null;
			}
			if( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			
			// Added by Harion S for Activity form changes in fortune server --18-May-2021 [Start]
			String activity="";
			String activitySql ="SELECT EVENT_TYPE FROM STRG_MEET WHERE TRAN_ID = ? ";
			pstmt=conn.prepareStatement(activitySql);
			pstmt.setString(1, tranId);
			rs=pstmt.executeQuery();
		
			if(rs.next())
			{
				activity=checkNull(rs.getString("EVENT_TYPE"));
			}
			if( rs != null )
			{
				rs.close();
				rs = null;
			}
			if( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			
			String activityCntSql ="SELECT COUNT(*) AS ACTIVITY_CNT FROM STRG_MEET WHERE DCR_ID = ? and EVENT_TYPE = ? ";
			pstmt=conn.prepareStatement(activityCntSql);
			pstmt.setString(1, dcrId);
			pstmt.setString(2, activity);
			rs=pstmt.executeQuery();
		
			if(rs.next())
			{
				activityCount=rs.getInt("ACTIVITY_CNT");
			}
			if( rs != null )
			{
				rs.close();
				rs = null;
			}
			if( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			// Added by Harion S for Activity form changes in fortune server --18-May-2021 [End]
			
			//added by prachi on 28-Sep-2022
			String delSurveySubSql = "DELETE FROM STRG_SURV_RES WHERE  TRAN_ID = ?";
			PreparedStatement pstmtdelSurveySub =  conn.prepareStatement(delSurveySubSql);
			pstmtdelSurveySub.setString(1, tranId);
			int detSurveyCnt = pstmtdelSurveySub.executeUpdate();
			pstmtdelSurveySub.close(); pstmtdelSurveySub = null;
			System.out.println("Data From STRG_SURV_RES is deleted detCnt:["+detSurveyCnt+"]");
			
			if(detSurveyCnt>0)
			{
                String getDetailsForSurveyUpdate ="SELECT STRG_CODE,SURVEY_TEMPL,SALES_PERS,DCR_ID FROM STRG_MEET WHERE TRAN_ID=?";
				pstmt=conn.prepareStatement(getDetailsForSurveyUpdate);
				pstmt.setString(1, tranId);
				rs=pstmt.executeQuery();
			    while(rs.next())
				{
					String salesPerson=checkNull(rs.getString("SALES_PERS"));
					String surveyTempl=checkNull(rs.getString("SURVEY_TEMPL"));
					String strgCode=checkNull(rs.getString("STRG_CODE"));
					String dcrID=checkNull(rs.getString("DCR_ID"));
					String maxDCRID="";
					String maxID="SELECT MAX(SM.DCR_ID) AS DCR_ID FROM STRG_MEET SM,STRG_SURV_RES SR WHERE SM.DCR_ID<(?) AND SM.STRG_CODE=? AND SM.SURVEY_TEMPL=? AND SM.SALES_PERS=? AND"
							+ " SR.DCR_ID=SM.DCR_ID AND SR.STRG_CODE=SM.STRG_CODE AND SR.TRAN_ID=SM.TRAN_ID";
					PreparedStatement ps = conn.prepareStatement(maxID);
					ps.setString(1, dcrId);
					ps.setString(2, strgCode);
					ps.setString(3, surveyTempl);
					ps.setString(4, salesPerson);
					ResultSet rs1=ps.executeQuery();
					if(rs1.next())
					{
						maxDCRID=checkNull(rs1.getString("DCR_ID"));
						String updSurveySubSql = " UPDATE STRG_SURV_RES SET SURV_STATUS = 'Y' WHERE DCR_ID = ? AND STRG_CODE = ?";
						PreparedStatement pstmtupdSurveySub =  conn.prepareStatement(updSurveySubSql);
						pstmtupdSurveySub.setString(1, maxDCRID);
						pstmtupdSurveySub.setString(2, strgCode);
						int updCount = pstmtupdSurveySub.executeUpdate();
						if(pstmtupdSurveySub!=null)
						{
						  pstmtupdSurveySub.close(); 
						  pstmtupdSurveySub = null;
						}
						System.out.println("STRG_SURV_RES is Updated updCount:["+updCount+"]");
					}
					if( rs1 != null )
					{
						rs1.close();
						rs1 = null;
					}
					if( ps != null )
					{
						ps.close();
						ps = null;
					}
				}
				if( rs != null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			//end
			

			String delMeetItemSql = "DELETE FROM STRG_MEET_ITEMS WHERE TRAN_ID = ? ";
			PreparedStatement pstmtDelItem =  conn.prepareStatement(delMeetItemSql);
			pstmtDelItem.setString(1, tranId);
			detCnt = pstmtDelItem.executeUpdate();
			pstmtDelItem.close(); pstmtDelItem = null;

			String delMeetOrderSql = "DELETE FROM STRG_MEET_ORDER WHERE TRAN_ID = ? ";
			PreparedStatement pstmtDelOrd =  conn.prepareStatement(delMeetOrderSql);
			pstmtDelOrd.setString(1, tranId);
			detCnt = pstmtDelOrd.executeUpdate();
			pstmtDelOrd.close(); pstmtDelOrd = null;
			
			//ADDED BY BHAGYASHRI T FOR DELETE DATA FROM INVOICE TABLE[04/08/2022]
			String delMeetInvoiceSql = "DELETE FROM STRG_MEET_INVOICE WHERE TRAN_ID = ? ";
			PreparedStatement pstmtDelInv =  conn.prepareStatement(delMeetInvoiceSql);
			pstmtDelInv.setString(1, tranId);
			detCnt = pstmtDelInv.executeUpdate();
			pstmtDelInv.close(); pstmtDelInv = null;
			System.out.println("Data From STRG_MEET_INVOICE is deleted detCnt:["+detCnt+"]");
			//ADDED BY BHAGYASHRI T FOR DELETE DATA FROM INVOICE TABLE[04/08/2022]

			String delMeetTeamSql = "DELETE FROM STRG_MEET_TEAM WHERE TRAN_ID = ? ";
			PreparedStatement pstmtDelTeam =  conn.prepareStatement(delMeetTeamSql);
			pstmtDelTeam.setString(1, tranId);
			detCnt= pstmtDelTeam.executeUpdate();
			pstmtDelTeam.close(); pstmtDelTeam = null;
			
			//ADDED BY PRACHI K [W22EBAS005] ON 08-AUG-2022
			String delMeetCollectSql = "DELETE FROM STRG_MEET_COLLECT WHERE TRAN_ID = ? ";
			PreparedStatement pstmtDelCollect =  conn.prepareStatement(delMeetCollectSql);
			pstmtDelCollect.setString(1, tranId);
			detCnt=pstmtDelCollect.executeUpdate();
			pstmtDelCollect.close(); pstmtDelCollect = null;

			String delMeetbrandSql = "DELETE FROM STRG_BRAND_PITCH WHERE TRAN_ID = ? ";
			PreparedStatement pstmtDelBarnd =  conn.prepareStatement(delMeetbrandSql);
			pstmtDelBarnd.setString(1, tranId);
			detCnt = pstmtDelBarnd.executeUpdate();
			pstmtDelBarnd.close(); pstmtDelBarnd = null;

			String delDisplSql = "DELETE FROM STRG_ITEM_DISPLAY WHERE TRAN_ID = ? ";
			PreparedStatement pstmtDelDisp =  conn.prepareStatement(delDisplSql);
			pstmtDelDisp.setString(1, tranId);
			detCnt = pstmtDelDisp.executeUpdate();
			pstmtDelDisp.close(); pstmtDelDisp = null;

			String delCustSql = "DELETE FROM STRG_CUST_ADD WHERE  TRAN_ID = ?";
			PreparedStatement pstmtDelCust =  conn.prepareStatement(delCustSql);
			pstmtDelCust.setString(1, tranId);
			detCnt = pstmtDelCust.executeUpdate();
			pstmtDelCust.close(); pstmtDelCust = null;

			String delSurveySql = "DELETE FROM STRG_BRAND_SURVEY WHERE  TRAN_ID = ?";
			PreparedStatement pstmtdelSurvey =  conn.prepareStatement(delSurveySql);
			pstmtdelSurvey.setString(1, tranId);
			detCnt = pstmtdelSurvey.executeUpdate();
			pstmtdelSurvey.close(); pstmtdelSurvey = null;

			String delCoachingSubSql = "DELETE FROM SPRS_COACHING WHERE  TRAN_ID = ?";
			PreparedStatement pstmtdelCoachingSub =  conn.prepareStatement(delCoachingSubSql);
			pstmtdelCoachingSub.setString(1, tranId);
			detCnt = pstmtdelCoachingSub.executeUpdate();
			pstmtdelCoachingSub.close(); pstmtdelCoachingSub = null;

			String delMeetSql = "DELETE FROM STRG_MEET WHERE  TRAN_ID = ?";
			PreparedStatement pstmtDelMeet =  conn.prepareStatement(delMeetSql);
			pstmtDelMeet.setString(1, tranId);
			detCnt = pstmtDelMeet.executeUpdate();
			pstmtDelMeet.close(); pstmtDelMeet = null;
			
			if(locCnt == 1 )
			{
				String delTravelSql = "DELETE FROM SPRS_TRAVEL WHERE  LOCALITY_CODE = ? AND DCR_ID=?";
				PreparedStatement pstmtDelTravel =  conn.prepareStatement(delTravelSql);
				pstmtDelTravel.setString(1, locality);
				pstmtDelTravel.setString(2, dcrId);
				detCnt = pstmtDelTravel.executeUpdate();
				pstmtDelTravel.close(); pstmtDelTravel = null;
			}
			else if(locCnt == 0 && locality.trim().length()==0)
			{
				String delTravelSql = "DELETE FROM SPRS_TRAVEL WHERE DCR_ID=?";
				PreparedStatement pstmtDelTravel =  conn.prepareStatement(delTravelSql);
				pstmtDelTravel.setString(1, dcrId);
				detCnt = pstmtDelTravel.executeUpdate();
				pstmtDelTravel.close(); pstmtDelTravel = null;
			}
			// Added by Harion S for Activity form changes in fortune server --18-May-2021 [Start]
			//if("Y".equalsIgnoreCase(isFortune))
			//{
				if(activityCount == 1 )
				{
					String delActivitySql = "DELETE FROM SPRS_ACTIVITY WHERE  DCR_ID = ? AND ACTIVITY_CODE = ? ";
					PreparedStatement pstmtDelActivity =  conn.prepareStatement(delActivitySql);
					pstmtDelActivity.setString(1, dcrId);
					pstmtDelActivity.setString(2, activity);
					detCnt = pstmtDelActivity.executeUpdate();
					pstmtDelActivity.close(); pstmtDelActivity = null;
				}
			//}
			// Added by Harion S for Activity form changes in fortune server --18-May-2021 [End]
			
			if(count == 1)
			{
				String delActTranSql = "DELETE FROM SPRS_ACT_TRAN WHERE  DCR_ID = ? ";
				PreparedStatement pstmtDelActTran =  conn.prepareStatement(delActTranSql);
				pstmtDelActTran.setString(1, dcrId);
				detCnt = pstmtDelActTran.executeUpdate();
				pstmtDelActTran.close(); pstmtDelActTran = null;
			}
			
			
			
			isSuccess = true;

		}
		catch(Exception ex)
		{
			isSuccess =false;
			ex.printStackTrace();
		}
		return isSuccess;
	}
	// added by mrunalini sinkar on 27-feb-2019to delete realtime report (end)
}
