/** 
*		Developed by	: Rupesh Jadhav
*		Company			: Base Information Management Pvt. Ltd
*		Start Date		: 29-Apr-2013
*		End Date		: 02-May-2013
*		Name			: SprsStockistCopyGWT.java
*		Purpose			: Migration of Copy Stockist menu option of Doctor Database in GWT
**/

package ibase.webitm.ejb.wsfa.transactions;

import ibase.ejb.*;
import ibase.system.config.*;
import ibase.webitm.ejb.*;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import ibase.utility.CommonConstants;

import java.io.*;
import java.rmi.RemoteException;
import java.sql.*;
import java.util.*;
import javax.ejb.*;
import javax.naming.InitialContext;
import javax.xml.parsers.*;
import org.w3c.dom.*;
//import oracle.jdbc.driver.OraclePreparedStatement; 

@Stateless
public class SprsStockistCopyWiz extends ValidatorEJB implements SprsStockistCopyWizLocal,SprsStockistCopyWizRemote//
{
	protected static String database = CommonConstants.DB_NAME;	

	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = null;

		GenericUtility genericUtility = GenericUtility.getInstance();
		try
		{
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString); 
			}
			if(xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1); 
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2); 
			}
			errString = wfValData(dom, dom1, dom2, objContext, editFlag, xtraParams);
			System.out.println("ErrString: " + errString);
		}
		catch(Exception e)
		{
			System.out.println("Exception: SprsStockistCopy: wfValData(String xmlString): " + e.getMessage() + ":");
			errString = genericUtility.createErrorString(e);
			e.printStackTrace();
		}
		System.out.println("Returning from SprsStockistCopy wfValData");
		return (errString); 
	}
	
	public String wfValData(Document dom, Document dom1, Document dom2, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		System.out.println(" Sprs Item in function wfValData(dom,dom1,dom2)");
		String columnName = "";
		String columnValue = "";
		String userId = "";
		String errString = "";
		String sql = "";
		Connection connectionObject = null;		
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		
		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;
		String childNodeName = null;

		int intDtRet = 0;
		int ctr = 0;
		int noOfChilds = 0;
		int currentFormNo = 0;
		String fldStaffSiteString = ""; //Added by shravan on [05-10-2016].
		
		GenericUtility genericUtility = GenericUtility.getInstance();

		try
		{
			//Commented and changed by AMOL S. 10-Apr-2019[START]
			/*InitialContext ctx = getInitialContext();
			ITMDBAccessLocal itmDBAccessLocal = (ITMDBAccessLocal)ctx.lookup( "ibase/ITMDBAccessEJB/local" );

			ConnDriver connDriver = null;
			connDriver = new ConnDriver();
			connectionObject = connDriver.getConnectDB("DriverValidator");*/
			ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
			connectionObject = getConnection();
			//Commented and changed by AMOL S. 10-Apr-2019[END]
			userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			//Modified by Rupesh on [07/08/2012] [To get Employee Hierarcy of loginEmpCode][Start]
			PreparedStatement pstmt2 = null;
			ResultSet rs2 = null;
			String loginEmpCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode");
			Vector v = new Vector();

			//Modified by Abhishek on [03/09/2012][To check the heirarchy in the login code is a Manager][Start]
			/*
			sql ="SELECT E.EMP_CODE EMP_CODE FROM EMPLOYEE E, GRADE G WHERE E.EMP_CODE IN (SELECT EMP_CODE  FROM EMPLOYEE WHERE EMP_SITE IN ('SP876','ST876','MP876','SP878','SP895')  AND RELIEVE_DATE IS NULL START WITH EMP_CODE = ?  CONNECT BY PRIOR emp_code = report_to ) AND G.GRADE_CODE = E.GRADE AND G.LEVEL_NO > 0 AND G.LEVEL_NO <= 4 AND E.RELIEVE_DATE IS NULL ";
			pstmt2 = connectionObject.prepareStatement(sql);
			pstmt2.setString(1, loginEmpCode);
			System.out.println("[SprsStockistCopy][wfValData]SQL of Hierarchy::"+sql);
			rs2 = pstmt2.executeQuery();
			while(rs2.next())
			{
				String empCodeHierarchy = rs2.getString( 1 ); 
				v.addElement(empCodeHierarchy.trim());
			}
			System.out.println("[SprsStockistCopy][wfValData] Employee report to "+loginEmpCode+" are "+v);
			if (rs2 != null)
			{
				rs2.close();
				rs2 = null;
			}
			if (pstmt2 != null)
			{
				pstmt2.close();
				pstmt2 = null;
			}
			*/
			String mgr = getUserType(loginEmpCode,connectionObject);
			if ( mgr.trim().length() > 0 && mgr.equalsIgnoreCase("M"))
			{
				fldStaffSiteString = getFldStaffSiteList(connectionObject);                                   //Added by shravan on [05-10-2016].
				System.out.println("Inside [][wfValData]fldStaffSiteString::["+fldStaffSiteString+"]");      //Added by shravan on [05-10-2016].
				//Modified by Ramchandra on [13/10/2012][To Validate for sales persons  if other than Hierarcy ][Start]
				//sql ="SELECT E.EMP_CODE EMP_CODE FROM EMPLOYEE E, GRADE G WHERE E.EMP_CODE IN (SELECT EMP_CODE  FROM EMPLOYEE WHERE EMP_SITE IN ('SP876','ST876','MP876','SP878','SP895')  AND RELIEVE_DATE IS NULL START WITH EMP_CODE = ?  CONNECT BY PRIOR emp_code = report_to ) AND G.GRADE_CODE = E.GRADE AND G.LEVEL_NO > 0 AND G.LEVEL_NO <= 4 AND E.RELIEVE_DATE IS NULL ";
				sql ="SELECT E.EMP_CODE EMP_CODE FROM EMPLOYEE E, GRADE G WHERE E.EMP_CODE IN (SELECT EMP_CODE  FROM EMPLOYEE WHERE EMP_SITE IN ("+getFormattedStringBuff(fldStaffSiteString)+")  START WITH EMP_CODE = ?  CONNECT BY PRIOR emp_code = report_to ) AND G.GRADE_CODE = E.GRADE AND G.LEVEL_NO > 0 AND G.LEVEL_NO <= 4 "; ////Added by shravan on [05-10-2016].
				pstmt2 = connectionObject.prepareStatement(sql);
				pstmt2.setString(1, loginEmpCode);
				System.out.println("[SprsStockistCopy][wfValData]SQL of Hierarchy::"+sql);
				rs2 = pstmt2.executeQuery();
				while(rs2.next())
				{
					String empCodeHierarchy = rs2.getString( 1 ); 
					v.addElement(empCodeHierarchy.trim());
				}
				System.out.println("[SprsStockistCopy][wfValData] Employee report to "+loginEmpCode+" are "+v);
				if (rs2 != null)
				{
					rs2.close();
					rs2 = null;
				}
				if (pstmt2 != null)
				{
					pstmt2.close();
					pstmt2 = null;
				}
			}
			//Modified by Abhishek on [03/09/2012][To check the heirarchy in the login code is a Manager][End]


			//Modified by Rupesh on [07/08/2012] [To get Employee Hierarcy of loginEmpCode][End]
			
			if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			parentList = dom.getElementsByTagName("Detail" + currentFormNo);
			parentNode = parentList.item(0);
			childList = parentNode.getChildNodes();
			noOfChilds = childList.getLength();
			for(ctr = 0; ctr < noOfChilds; ctr++)
			{
				childNode = childList.item(ctr);
				childNodeName = childNode.getNodeName();
				switch(currentFormNo)
				{
					case 1:
						if(childNodeName.equalsIgnoreCase("sales_pers__from"))
						{
							if(childNode.getFirstChild() == null)				
							{
								errString = itmDBAccessEJB.getErrorString("sales_pers__from","NULSLSPER",userId,errString,connectionObject);								
							}
							else
							{
								columnValue = childNode.getFirstChild().getNodeValue().trim();
								// Modified by Rupesh [08/08/2012] [To check empty string]
								//if(columnValue != null)
								if(columnValue != null && columnValue.length() > 0)
								{	
									sql = "SELECT * FROM SALES_PERS WHERE SALES_PERS =? ";
									pstmt = connectionObject.prepareStatement(sql);
									/*--Commented and Changes below - Gulzar - 04/09/08 Req ID :SY89SUN019
									if ( this.database.toUpperCase().startsWith("ORACLE") ) 
									{
										((OraclePreparedStatement)pstmt).setFixedCHAR(1,columnValue);
									}
									else
									{
										pstmt.setString(1, columnValue);
									}*/
									pstmt.setString(1, columnValue);
									//End Changes - Gulzar - 04/09/08 Req ID :SY89SUN019
									rs = pstmt.executeQuery();
									if(!rs.next())
									{
										errString = itmDBAccessEJB.getErrorString("sales_pers__from","SLPNOTEXT",userId,errString,connectionObject);
									}
									//Modified by Rupesh on [07/08/2012] [To Validate Employee other than Hierarcy of loginEmpCode][Start]
									else
									{
										//Modified by Abhishek on [03/09/2012][To validate in case of manager only]
										//if (!v.contains(columnValue))
										if (mgr.trim().length() > 0 && mgr.equalsIgnoreCase("M") && !v.contains(columnValue))
										{										
											errString = itmDBAccessEJB.getErrorString("sales_pers__from","INVHIEEMP",userId,errString,connectionObject);
										}
										else
										{
											System.out.println("[SprsStockistCopy][wfValData] Employe in Hierarchy");
										}
									}
									//Modified by Rupesh on [07/08/2012] [To Validate Employee other than Hierarcy of loginEmpCode][End]			
								}
								// Modified by Rupesh [08/08/2012] [To check empty string][Start]
								else
								{
									errString = itmDBAccessEJB.getErrorString("sales_pers__from","NULSLSPER",userId,errString,connectionObject);
								}
								// Modified by Rupesh [08/08/2012] [To check empty string][End]
							}							
						}

						// Modified by Rupesh [07/08/2012][To validate is employee relieved or not][Start]
						else if(childNodeName.equalsIgnoreCase("sales_pers__to"))
						{
							if(childNode.getFirstChild() == null)				
							{
								errString = itmDBAccessEJB.getErrorString("sales_pers__to","NULSLSPER",userId,errString,connectionObject);			
							}
						    else
							{
								String empRelieveDt = "";
								PreparedStatement pstmt1 = null;
								ResultSet rs1 = null;
								columnValue = childNode.getFirstChild().getNodeValue().trim();
								String  sprsFrom = genericUtility.getColumnValue("sales_pers__from",dom);
								sprsFrom = sprsFrom.trim();
								// Modified by Rupesh [08/08/2012] [To check empty string]
								//if(columnValue != null)							
								if(columnValue != null && columnValue.length() > 0)
								{	
									sql = "SELECT RELIEVE_DATE FROM EMPLOYEE WHERE EMP_CODE =? ";
									pstmt1 = connectionObject.prepareStatement(sql);
									pstmt1.setString(1, columnValue);
									rs1 = pstmt1.executeQuery();
									if(rs1.next())
									{
										empRelieveDt = rs1.getString("RELIEVE_DATE");
									}
									if (rs1 != null)
									{
										rs1.close();
										rs1 = null;
									}
									if (pstmt1 != null)
									{
										pstmt1.close();
										pstmt1 = null;
									}
									
									if (empRelieveDt != null && empRelieveDt.trim().length() > 0 )
									{										
										errString = itmDBAccessEJB.getErrorString("sales_pers__to","INVRELEMP",userId,errString,connectionObject);
									}
									//Modified by Rupesh on [07/08/2012] [To Validate Employee other than Hierarcy of loginEmpCode][Start]
									else
									{
										//Modified by Abhishek on [03/09/2012][To validate in case of manager only]
										//if (!v.contains(columnValue))
										if (mgr.trim().length() > 0 && mgr.equalsIgnoreCase("M") && !v.contains(columnValue))
										{											
											errString = itmDBAccessEJB.getErrorString("sales_pers__to","INVHIEEMP",userId,errString,connectionObject);
										}
										//Validation to check duplicate employee 
										else 
										{
											if (sprsFrom.equalsIgnoreCase(columnValue))
											{
												errString = itmDBAccessEJB.getErrorString("sales_pers__to","INVDUPEMP",userId,errString,connectionObject);
											}
										}										
									}
									//Modified by Rupesh on [07/08/2012] [To Validate Employee other than Hierarcy of loginEmpCode][End]			
									
									//Added by Rupesh on [30/04/2013] [Invalid employee to validation][Start]									
									sql = "SELECT * FROM SALES_PERS WHERE SALES_PERS =? ";
									pstmt = connectionObject.prepareStatement(sql);
									pstmt.setString(1, columnValue);
									//End Changes - Gulzar - 04/09/08 Req ID :SY89SUN019
									rs = pstmt.executeQuery();
									if(!rs.next())
									{
										errString = itmDBAccessEJB.getErrorString("sales_pers__to","SPTONOTEXT",userId,errString,connectionObject);
									}
									//Added by Rupesh on [30/04/2013] [Invalid employee to validation][End]
								}
								else
								{
									errString = itmDBAccessEJB.getErrorString("sales_pers__to","NULSLSPER",userId,errString,connectionObject);
								}
							}						 							
						}
						// Modified by Rupesh [07/08/2012][To validate is employee relieved or not][End]	
				}
				if (errString != null && errString.trim().length()>0)
				{
					break;
				}
			}
		}
		catch(SQLException se)//Gulzar - 04/09/08 Req ID :SY89SUN019
		{
			System.out.println("Exception: SprsStockistCopy: wfValData(Document dom): " + se.getMessage() + ":");
			errString = genericUtility.createErrorString(se);
		}
		catch(Exception e)
		{
			System.out.println("Exception: SprsStockistCopy: wfValData(Document dom): " + e.getMessage() + ":");
			errString = genericUtility.createErrorString(e);
		}
		finally //Gulzar - 04/09/08 Req ID :SY89SUN019
		{
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if ( connectionObject != null )
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e){}					
		}
		return (errString);
	}
	
	public String itemChanged() throws RemoteException, ITMException
	{
		return "";
	}

	public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{

		
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = null;
		GenericUtility genericUtility = GenericUtility.getInstance();
		try
		{
			if (xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString); 
				System.out.println ("xmlString ==>>"+xmlString);
			}
			if (xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1); 
				System.out.println ("xmlString 1==>>"+xmlString1);
			}
			if (xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2);
				System.out.println ("xmlString 2==>>"+xmlString2);
			}
			errString = itemChanged(dom, dom1, dom2, objContext, currentColumn, editFlag, xtraParams);
			System.out.println ("ErrString :" + errString);
		}
		catch (Exception e)
		{
			System.out.println ("Exception :SprsStockistCopy :itemChanged(String,String):" + e.getMessage() + ":");
			errString = genericUtility.createErrorString(e);
		}
		System.out.println ("returning from SprsStockistCopy itemChanged");
		return errString;
	}

	public String itemChanged(Document dom, Document dom1, Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		System.out.println("ITEMCHANGE is called...............................");
		String columnValue = "";
		String returnString = "";					
		Connection connectionObject = null;		
		Statement stmt = null; 
		ResultSet rs = null;		
		StringBuffer valueXmlString = new StringBuffer();

		String salesPersName = "";
		String selectSql = "";
		String salesPers = "";
		//Added by Rupesh on [30/04/2013] [To Pass the windowName][Start]
		//InitialContext ctx = null;
		String windowName = "w_"+getObjName(dom,objContext);
		System.out.println("Window Name Got :::["+windowName+"]");		
		//Added by Rupesh on [30/04/2013] [To Pass the windowName][End]

		int currentFormNo = 0;
		GenericUtility genericUtility = GenericUtility.getInstance();
		try
		{
			//Commented and changed by AMOL S on 15-Apr-19[START]
			/*ConnDriver connDriver = null;
			connDriver = new ConnDriver();
			connectionObject = connDriver.getConnectDB("DriverValidator");*/
			connectionObject =  getConnection();
			//Commented and changed by AMOL S on 15-Apr-19[END]
			columnValue = genericUtility.getColumnValue(currentColumn,dom);
			if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
            valueXmlString = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<editFlag>");
			valueXmlString.append(editFlag).append("</editFlag>\r\n</Header>\r\n");
			System.out.println("currentFormNo ["+currentFormNo+"] currentColumn ["+currentColumn+"]");
			//Modified by Rupesh on [30/04/2013] [Migration in GWT] [Start]			 
			String objNameDefault = "";
			objNameDefault  = checkNull(getObjNameFromDom( dom2 , "objName" , currentFormNo));
			//Modified by Rupesh on [30/04/2013] [Migration in GWT] [End]			
			
			switch (currentFormNo)
			{
				case 1:
					//Modified by Rupesh on [30/04/2013] [Migration in GWT] [Start]
					//valueXmlString.append("<Detail>\r\n");
					valueXmlString.append( "<Detail1 dbID='' domID='1' objContext='"+currentFormNo+"' objName='"+objNameDefault+"' selected='N'>\r\n" );
					valueXmlString.append("<attribute pkNames='' status='N' updateFlag='A' selected='N' />\r\n");
					//valueXmlString.append("<Detail1 domID='1' >\r\n");
					//Modified by Rupesh on [30/04/2013] [Migration in GWT] [End]
					if (currentColumn.trim().equalsIgnoreCase("itm_default")) 
					{
						salesPers = genericUtility.getColumnValue("sales_pers__to",dom);
						
						// Modified by Rupesh [07/08/2012][To validate is employee relieved or not][Start]
						String loginEmpCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode");
						String userType = "";
						userType = getUserType(loginEmpCode,connectionObject);
						System.out.println("[SprsStockistCopy][wfValData] userType1 -->> "+userType);

						// Modified by Rupesh [07/08/2012][To validate is employee relieved or not][End]

						// Modified by Rupesh [25/07/2012] [Add condition to check sales_pers__to value if Copy Stockist occurs from menu option directly.] [Start]
						if (salesPers != null && salesPers.trim().length() > 0)
						{
						// Modified by Rupesh [25/07/2012] [Add condition to check sales_pers__to value if Copy Stockist occurs from menu option directly.] [End]							
							selectSql = "SELECT SP_NAME FROM SALES_PERS WHERE SALES_PERS = '"+salesPers+"'";
							System.out.println("selectSql:: "+selectSql);
							stmt = connectionObject.createStatement();
							rs = stmt.executeQuery(selectSql);
							if ( rs.next() )
							{
								salesPersName = rs.getString("SP_NAME");								
								
								//Modified by Rupesh [08/08/2012] [To disable Emp To]  
								//valueXmlString.append("<sales_pers__to protect='1'>").append(salesPers).append("</sales_pers__to>\r\n");
								valueXmlString.append("<sales_pers__to protect='1'>").append(salesPers.toUpperCase()).append("</sales_pers__to>\r\n");
								valueXmlString.append("<name_to>").append("<![CDATA["+salesPersName+"]]>").append("</name_to>\r\n");
							}
							else
							{								
								//Modified by Rupesh [08/08/2012] [To disable Emp To]
								//valueXmlString.append("<sales_pers__to protect='1'>").append(salesPers).append("</sales_pers__to>\r\n");
								valueXmlString.append("<sales_pers__to protect='1'>").append(salesPers.toUpperCase()).append("</sales_pers__to>\r\n");
								
								valueXmlString.append("<name_to>").append("").append("</name_to>\r\n");
							}
							rs.close();
							stmt.close();//Gulzar - 04/09/08 Req ID :SY89SUN019
						// Modified by Rupesh [25/07/2012] [Add condition to check sales_pers__to value if Copy Stockist occurs from menu option directly.] [Start]
						}
						else 
						{										
							salesPers = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode");
							System.out.println("[SprsStockistCopy][itemChanged()] salesPers :: "+salesPers);																
							// Modified by Rupesh [07/08/2012][TO enables Emp To if login employee is manager or Ho][Start]					//valueXmlString.append("<sales_pers__to>").append("<![CDATA["+salesPers+"]]>").append("</sales_pers__to>\r\n");														
							salesPers = salesPers.trim();
							
							selectSql = "SELECT SP_NAME FROM SALES_PERS WHERE SALES_PERS = '"+salesPers+"'";
							System.out.println("[SprsStockistCopy][itemChanged()] selectSql :: "+selectSql);
							stmt = connectionObject.createStatement();
							rs = stmt.executeQuery(selectSql);
							if ( rs.next() )
							{								
								salesPersName = rs.getString("SP_NAME");							
								valueXmlString.append("<name_to>").append("<![CDATA["+salesPersName+"]]>").append("</name_to>\r\n");
							}
							else
							{						
								valueXmlString.append("<name_to>").append("").append("</name_to>\r\n");
							}
							if (rs != null)
							{
								rs.close();
								rs = null;
							}
							if (stmt != null)
							{
								stmt.close();
								stmt = null;
							}	


							if ( userType != null && (userType.equalsIgnoreCase("M")|| userType.equalsIgnoreCase("H")))
							{													
								System.out.println("In Protect 0 Condition");
								//Modified By Rupesh [11/01/2013] [To set blank emp_to] [Start]
								//valueXmlString.append("<sales_pers__to protect='0'>").append(salesPers).append("</sales_pers__to>\r\n");
								valueXmlString.append("<sales_pers__to protect='0'>").append("").append("</sales_pers__to>\r\n");

								valueXmlString.append("<name_to>").append("").append("</name_to>\r\n");
								//Modified By Rupesh [11/01/2013] [To set blank emp_to] [End]
							}
							else
							{	
								System.out.println("In Protect 1 Condition");
								
								valueXmlString.append("<sales_pers__to protect=\"1\">").append(salesPers).append("</sales_pers__to>\r\n");
								
								//Modified By Rupesh [12/01/2013] [To set name of emp_to] [Start]
								valueXmlString.append("<name_to>").append("<![CDATA["+salesPersName+"]]>").append("</name_to>\r\n");
								//Modified By Rupesh [12/01/2013] [To set name of emp_to] [End]
							}
							
							// Modified by Rupesh [07/08/2012][TO enables Emp To if login employee is manager or Ho][End]
																				
						}
						// Modified by Rupesh [25/07/2012] [Add condition to check sales_pers__to value if Copy Stockist occurs from menu option directly.] [End]						

						//}//Modified by Rupesh on [30/04/2013] [Predom exist]
						
					}
					else if (currentColumn.trim().equalsIgnoreCase("sales_pers__from")) 
					{
						columnValue = checkNull(genericUtility.getColumnValue(currentColumn,dom));	
						salesPersName = "";
						selectSql = "SELECT SP_NAME FROM SALES_PERS WHERE SALES_PERS = '"+columnValue+"'";
						stmt = connectionObject.createStatement();
						rs = stmt.executeQuery(selectSql);
						if ( rs.next() )
						{
							salesPersName = rs.getString("SP_NAME");							
							//valueXmlString.append("<name_from>").append("<![CDATA["+salesPersName+"]]>").append("</name_from>\r\n");
						}
						else
						{
							salesPersName = "";
							//valueXmlString.append("<name_from>").append(salesPersName).append("</name_from>\r\n");
						}
						rs.close();
						stmt.close();//Gulzar - 04/09/08 Req ID :SY89SUN019
						//Modified by Rupesh on [30/04/2013] [Migration in GWT] [Start]
						valueXmlString.append("<sales_pers__from>").append("<![CDATA["+columnValue.toUpperCase()+"]]>").append("</sales_pers__from>\r\n");
						valueXmlString.append("<name_from>").append(salesPersName).append("</name_from>\r\n");
						//Added by Arpit [26/05/2015][To correct itemchange bug of sales_pers__from field][Start]
						valueXmlString.append("<name_to>").append(genericUtility.getColumnValue("name_to",dom)).append("</name_to>\r\n");
						valueXmlString.append("<sales_pers__to>").append(genericUtility.getColumnValue("sales_pers__to",dom)).append("</sales_pers__to>\r\n");
						//Added by Arpit [26/05/2015][To correct itemchange bug of sales_pers__from field][End]
						//Modified by Rupesh on [30/04/2013] [Migration in GWT] [End]
						
					}
					// Modified by Rupesh [25/07/2012] [Add condition to check sales_pers__to value if Copy Stockist occurs from menu option directly.] [Start]
					else if (currentColumn.trim().equalsIgnoreCase("sales_pers__to")) 
					{						
						columnValue = checkNull(genericUtility.getColumnValue(currentColumn,dom));
						salesPersName = "";
						selectSql = "SELECT SP_NAME FROM SALES_PERS WHERE SALES_PERS = '"+columnValue+"'";
						System.out.println("[SprsStockistCopy][itemChanged()] selectSql ::: "+selectSql);
						stmt = connectionObject.createStatement();
						rs = stmt.executeQuery(selectSql);
						if ( rs.next() )
						{
							salesPersName = rs.getString("SP_NAME");							
							//valueXmlString.append("<name_to>").append("<![CDATA["+salesPersName+"]]>").append("</name_to>\r\n");
						}
						else
						{
							salesPersName = "";
							//valueXmlString.append("<name_to>").append(salesPersName).append("</name_to>\r\n");
						}
						if (rs != null)
						{
							rs.close();
							rs = null;
						}
						if (stmt != null)
						{
							stmt.close();
							stmt = null;
						}	
						//Modified by Rupesh on [30/04/2013] [Migration in GWT] [Start]
						valueXmlString.append("<sales_pers__to>").append("<![CDATA["+columnValue.toUpperCase()+"]]>").append("</sales_pers__to>\r\n");
						valueXmlString.append("<name_to>").append(salesPersName).append("</name_to>\r\n");
						//Added by arpit[26/06/2015][for mobile changes].start
						valueXmlString.append("<name_from>").append(genericUtility.getColumnValue("name_from",dom)).append("</name_from>\r\n");
						valueXmlString.append("<sales_pers__from>").append(genericUtility.getColumnValue("sales_pers__from",dom)).append("</sales_pers__from>\r\n");
						//Added by arpit[26/06/2015][for mobile changes].end
						//Modified by Rupesh on [30/04/2013] [Migration in GWT] [End]

					}
					// Modified by Rupesh [25/07/2012] [Add condition to check sales_pers__to value if Copy Stockist occurs from menu option directly.] [End]
					valueXmlString.append("</Detail1>\r\n");
					//Modified by Rupesh on [30/04/2013] [Migration in GWT] [Start]
					break;

			case 2:
					if (currentColumn.trim().equalsIgnoreCase("itm_default"))
					{
						String salesPersFr  = "";
						String salesPersTo  = "";
						salesPersFr = genericUtility.getColumnValue("sales_pers__from",dom2);
						salesPersTo = genericUtility.getColumnValue("sales_pers__to",dom2);
						//Commented and changed by AMOL S. 10-Apr-2019[START]
						/*ctx = getInitialContext(); 
						SprsStockistCopyPrcWizLocal sprsStockistCopyPrcGWT = (SprsStockistCopyPrcWizLocal)ctx.lookup("ibase/SprsStockistCopyPrcGWT/local");*/
						SprsStockistCopyPrcWiz sprsStockistCopyPrcGWT = new SprsStockistCopyPrcWiz();
						sprsStockistCopyPrcGWT.setUserInfo(getUserInfo());
						//Commented and changed by AMOL S. 10-Apr-2019[END]
						NodeList parentList = null;
						parentList = dom2.getElementsByTagName("Detail2");						
						System.out.println("parentList.getLength() <= 1 ::::"+""+(parentList.getLength() <= 1)+"");

						String stockistData = sprsStockistCopyPrcGWT.getData(dom2,dom2,windowName,xtraParams);
						valueXmlString.append(stockistData);
					}
					break;
					//Modified by Rupesh on [30/04/2013] [Migration in GWT] [End]
				}//End of switch
		}
		catch(SQLException se)//Gulzar - 04/09/08 Req ID :SY89SUN019
		{
			System.out.println("Exception: SprsStockistCopy: itemChanged(Document,String): " + se.getMessage() + ":");
			valueXmlString = valueXmlString.append(genericUtility.createErrorString(se));
		}
		catch(Exception e)
		{
			System.out.println("Exception :SprsStockistCopy :itemChanged(Document,String):" + e.getMessage() + ":");
			valueXmlString = valueXmlString.append(genericUtility.createErrorString(e));
		}
		finally 
		{
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( stmt != null )
				{
					stmt.close();
					stmt = null;
				}
				if ( connectionObject != null )
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e){}
		}
		valueXmlString.append("</Root>\r\n");	
		System.out.println("\n****ValueXmlString :" + valueXmlString + ":********");
		return valueXmlString.toString();
	}

	// Modified by Rupesh [07/08/2012][To identify is employee Manager or Ho][start]
	private String getUserType(String empCode,Connection conn) throws ITMException
	{
		System.out.println("In getUserType() method");
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String empCodeMGR = "";
		String empCodeHO = "";
		String userType1 = "";
		String selectSql = "";
		boolean isEmpMgr = false;
		try
		{
			selectSql = "SELECT A.EMP_CODE AS EMP_CODE FROM EMPLOYEE A, GRADE B " +
				  "WHERE A.EMP_CODE = ? " + 
				  "AND A.GRADE = B.GRADE_CODE " + 
				  "AND B.GRADE_TYPE = 'M' ";

			pstmt = conn.prepareStatement(selectSql);
			pstmt.setString( 1, empCode );
			System.out.println("[SprsStockistCopy][getUserType()] selectSql -->> "+selectSql);
			rs = pstmt.executeQuery();	
			if(rs.next())
			{
				empCodeMGR = checkNull(rs.getString("EMP_CODE"));	
			}
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			if (empCodeMGR != null && empCodeMGR.trim().length() > 0)
			{
				userType1 = "M";
				isEmpMgr = true;
			}
			if (isEmpMgr == false)
			{
				selectSql = "SELECT EMP_CODE FROM USERS A, USER_RIGHTS B " + 
				  "WHERE A.EMP_CODE = ? " + 
				  "AND A.PROFILE_ID = B.PROFILE_ID " +
				  "AND B.APPLICATION = 'MRO' " +
				  "AND B.MENU_ROW = 1 " +       
				  "AND B.MENU_COL = 1 " +       
				  "AND B.MENU_SUBCOL = 1 " +
				  "AND B.LEVEL_4 = 1 " +        
				  "AND B.LEVEL_5 = 1 " +        
				  "AND B.MENU_NAME = 'MR Online Application' ";

				pstmt = conn.prepareStatement(selectSql);
				pstmt.setString( 1, empCode );
				System.out.println("[SprsStockistCopy][getUserType()] selectSql for HO >> "+selectSql);
				rs = pstmt.executeQuery();	
				if(rs.next())
				{
					empCodeHO = checkNull(rs.getString("EMP_CODE"));	
				}
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if (empCodeHO != null && empCodeHO.trim().length() > 0)
				{
					userType1 = "H";				
				}
			}	
			System.out.println("[SprsStockistCopy][getUserType()] userType1 >> "+userType1);
		}
		catch ( Exception e )
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e1){}
		}
		return userType1;		
	}	
	// Modified by Rupesh [07/08/2012][To identify is employee Manager or Ho][End]
	
	private String checkNull(String input)
	{
		if (input==null || input.trim().length() == 0)
		{
			input="";
		}
		return input;
	}
	//Commented by AMOL S. on 10-Apr-2019 [START]
	/*protected InitialContext getInitialContext()throws ITMException
	{
		InitialContext ctx = null;
		try
		{
			AppConnectParm appConnect = new AppConnectParm();
			ctx = new InitialContext(appConnect.getProperty());
		}
		catch(ITMException itme)
		{
			System.out.println("ITMException :[EmpITDeclNewServlet] :getInitialContext :==>");
			throw itme;
		}
		catch(Exception e)
		{
			System.out.println("Exception :[EmpITDeclNewServlet] :getInitialContext :==>");
			throw new ITMException(e);
		}
		return ctx;
	}*/
	//Commented by AMOL S. on 10-Apr-2019 [END]
	//Added by Rupesh on [30/04/2013][To objName from dom][Start]
	private String getObjName(Document dom2,String objContext)
	{	
		Node elementName = null, parentNode = null;
		NodeList elementList = null;
		Element elementAttr = null;
		String objName = "";
		elementList = dom2.getElementsByTagName("Detail"+objContext);
		elementName = elementList.item(0);
		if (elementName!=null && ("Detail"+objContext).equalsIgnoreCase(elementName.getNodeName()))
		{
			NamedNodeMap etlAttributes = elementName.getAttributes();
			if (etlAttributes!=null)
			{
				if (etlAttributes.getNamedItem("objName")!=null)
				{
					objName = etlAttributes.getNamedItem("objName").getNodeValue();
				}
			}
		}
		return objName;
	}
	//Added by Rupesh on [30/04/2013][To objName from dom][End]

	//Modified by Rupesh on [30/04/2013][To fetch Object Name from Given DOM][Start]

	private String getObjNameFromDom( Document dom, String attribute , int currFormNo) throws RemoteException,ITMException
	{
		String objName = "";
		try
		{
			NodeList detailList = null;
			Node currDetail = null,reqDetail = null;			
			int	detailListLength = 0;

			detailList = dom.getElementsByTagName("Detail" + currFormNo);
			detailListLength = detailList.getLength();
			for (int ctr = 0;ctr < detailListLength;ctr++)
			{
				currDetail = detailList.item(ctr);
				objName = currDetail.getAttributes().getNamedItem(attribute).getNodeValue();
						
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		return objName;
	}
	//Modified by Rupesh on [30/04/2013][To fetch Object Name from Given DOM][End]
	//Added by shravan on [05-10-2016].start
	public String getFormattedStringBuff( String data )
	{
		StringBuffer dataString = new StringBuffer();
		try
		{
			String[] dataArr = null;
			
			if ( data.indexOf(",") == -1 )
			{
				dataString.append( "'"+data+"'" );
			}
			else
			{
				dataArr = data.split(",");
				for (int i=0; i < dataArr.length; i++ )
				{
					if ( i == 0 )
					{
						dataString.append( "'"+dataArr[i]+"'" );
					}
					else
					{ 
						dataString.append( "," );
						dataString.append( "'"+dataArr[i]+"'" );
					}										
				}
			}
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
		}	
		return dataString.toString();
	}
	public String getFldStaffSiteList(Connection conn)
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String fldStaffSiteString = "";
		String sql = "";
		try
		{
			sql = "SELECT PROP_VALUE FROM PROPERTIES WHERE PROP_NAME = 'FIELDSTAFF_SITELIST' AND ITEM_SER = 'ALL'";
			 pstmt = conn.prepareStatement(sql);
			 rs = pstmt.executeQuery();
			System.out.println("Inside [SprsStockistCopy][getFldStaffSiteList]sql::>"+sql);
	
			 if (rs.next())
			 {
				fldStaffSiteString = rs.getString("PROP_VALUE");
				fldStaffSiteString = (fldStaffSiteString == null)? "" : fldStaffSiteString.trim();
				System.out.println("Inside [SprsStockistCopy][getFldStaffSiteList]fldStaffSiteString::["+fldStaffSiteString+"]");
			 }
			 if (rs!=null)
			 {
				 rs.close();
				 rs = null;
			 }
			 if (pstmt!=null)
			 {
				 pstmt.close();
				 pstmt = null;
			 }
			
		}
		catch (Exception exp)
		{
			System.out.println("Inside Exception catch [SprsStockistCopy][getFldStaffSiteList]Exception:>>"+exp.getMessage());
			exp.printStackTrace();
		}
		finally
		{
			try
			{
				if (rs!=null)
				{
				 rs.close();
				 rs = null;
				}
				if (pstmt!=null)
				{
				 pstmt.close();
				 pstmt = null;
				}				
			}
			catch (Exception e)
			{
				System.out.println("Inside Exception finally [SprsStockistCopy][getFldStaffSiteList]Exception:>>"+e.getMessage());
				e.printStackTrace();
			}
		}
		System.out.println("Returning from [SprsStockistCopy][getFldStaffSiteList]["+fldStaffSiteString+"]");
		return fldStaffSiteString;
	}
	//Added by shravan on [05-10-2016].end
}
