/*
 * Decompiled with CFR 0.152.
 */
package ibase.webService;

import ibase.bean.ExtAuthApplicationBean;
import ibase.ejb.CommonDBAccessEJB;
import ibase.utility.BaseException;
import ibase.utility.BaseLogger;
import ibase.utility.CryptographyUtil;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONException;
import org.json.JSONObject;

public class RestAPIService {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isWhiteListIP(HttpServletRequest request, String appId) {
        try {
            String ipAddressRecvd = this.getRequestedIP(request);
            BaseLogger.log((String)"3", null, null, (Object)("isWhiteListIP :: ipAddressRecvd : [" + ipAddressRecvd + "]"));
            appId = E12GenericUtility.checkNull((String)appId);
            BaseLogger.log((String)"3", null, null, (Object)("isWhiteListIP :: appId : [" + appId + "]"));
            ExtAuthApplicationBean applicationBean = this.getCommonDBAccess().getExtAuthApplicationInfo(appId);
            if (applicationBean == null) return false;
            String whiteListIP = E12GenericUtility.checkNull((String)applicationBean.getWhiteListIP());
            if ("NO_IP_CONF_REQUIRED".equalsIgnoreCase(whiteListIP)) {
                BaseLogger.log((String)"3", null, null, (Object)"Not validating ip address!");
                return true;
            }
            if (ipAddressRecvd.length() > 0) {
                String[] ipAddressArr = ipAddressRecvd.split(",");
                int outer = 0;
                while (outer < ipAddressArr.length) {
                    String ipAddress = ipAddressArr[outer];
                    BaseLogger.log((String)"3", null, null, (Object)("isWhiteListIP :: ipAddress : before : [" + ipAddress + "]"));
                    if (ipAddress != null) {
                        ipAddress = ipAddress.trim();
                        BaseLogger.log((String)"3", null, null, (Object)("isWhiteListIP :: ipAddress : after trim : [" + ipAddress + "]"));
                    }
                    BaseLogger.log((String)"3", null, null, (Object)("isWhiteListIP :: ipAddress : [" + ipAddress + "]"));
                    if (whiteListIP.length() > 0) {
                        String[] whiteListIPArr = whiteListIP.split(",");
                        int i = 0;
                        while (i < whiteListIPArr.length) {
                            String IP = E12GenericUtility.checkNull((String)whiteListIPArr[i]);
                            if (!"".equals(IP) && ipAddress.equals(IP)) {
                                return true;
                            }
                            if (!"".equals(IP) && IP.endsWith("*")) {
                                if (ipAddress.startsWith(IP = IP.substring(0, IP.length() - 1))) {
                                    return true;
                                }
                            } else if (!"".equals(IP) && IP.contains("/")) {
                                String ipAddressSubStr = ipAddress.substring(0, ipAddress.lastIndexOf("."));
                                String ipSubStr = IP.substring(0, IP.lastIndexOf("."));
                                BaseLogger.log((String)"3", null, null, (Object)("ipAddressSubStr : [" + ipAddressSubStr + "] ipSubStr : [" + ipSubStr + "]"));
                                if (ipAddressSubStr.equals(ipSubStr)) {
                                    String ipEnd = IP.substring(IP.lastIndexOf(".") + 1);
                                    String ipAddressEnd = ipAddress.substring(ipAddress.lastIndexOf(".") + 1);
                                    BaseLogger.log((String)"3", null, null, (Object)("ipEnd : [" + ipEnd + "], ipAddressEnd : [" + ipAddressEnd + "]"));
                                    String[] ipRange = ipEnd.split("/");
                                    int start = Integer.parseInt(ipRange[0]);
                                    int end = Integer.parseInt(ipRange[1]);
                                    int userIP = Integer.parseInt(ipAddressEnd);
                                    BaseLogger.log((String)"3", null, null, (Object)("Start : [" + start + "], End : [" + end + "], userIP : [" + userIP + "]"));
                                    if (userIP >= start && userIP <= end) {
                                        return true;
                                    }
                                }
                            }
                            ++i;
                        }
                    }
                    ++outer;
                }
            }
            BaseLogger.log((String)"3", null, null, (Object)("isWhiteListIP :: whiteListIp : [" + whiteListIP + "]"));
            return false;
        }
        catch (Exception e) {
            BaseLogger.log((String)"0", null, null, (Object)("Exception :: isWhiteListIP : [" + e.getMessage() + "]"));
            e.printStackTrace();
            return false;
        }
    }

    public String validateAppId(HttpServletRequest request, String appId, String endpoint) {
        String result = "valid";
        try {
            appId = this.checkNull(appId);
            boolean isWhiteListIP = this.isWhiteListIP(request, appId);
            if (!isWhiteListIP) {
                result = "Requested IP not registered for AppID (" + appId + ")";
            } else {
                boolean isExtAppEndpointAllowed = this.getCommonDBAccess().isExtAppEndpointAllowed(endpoint, appId);
                if (!isExtAppEndpointAllowed) {
                    result = "This service not available for the AppID (" + appId + ")";
                }
            }
        }
        catch (Exception e) {
            BaseLogger.log((String)"0", null, null, (Object)("Exception : validateRequest : " + e.getMessage()));
            result = this.getStackTrace(e);
        }
        return result;
    }

    public String validateJWT(String jwt, String appId, String secretKey) {
        String result = "valid";
        try {
            String jwtResult = CryptographyUtil.parseBase64EncodedJWT((String)jwt, (String)secretKey);
            if ("expired".equalsIgnoreCase(jwtResult)) {
                result = "Token has been expired";
            } else if ("invalid".equalsIgnoreCase(jwtResult)) {
                result = "Invalid Token";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            result = "Invalid Token";
        }
        return result;
    }

    public CommonDBAccessEJB getCommonDBAccess() throws BaseException {
        CommonDBAccessEJB ejbObj = null;
        try {
            ejbObj = new CommonDBAccessEJB();
        }
        catch (Exception e) {
            BaseLogger.log((String)"0", null, null, (Object)("Exception :: VisionEDIService : getCommonDBAccess : [" + e.getMessage() + "]"));
            throw new BaseException(e);
        }
        return ejbObj;
    }

    public String getStackTrace(Exception e) {
        return new E12GenericUtility().createErrorString(e);
    }

    public String getStackTrace(Exception e, String dataFormat) {
        return new E12GenericUtility().createErrorString(e, dataFormat);
    }

    public String checkNull(String input) {
        return E12GenericUtility.checkNull((String)input);
    }

    public String getRequestedIP(HttpServletRequest request) {
        String ipAddress = "";
        try {
            if (ipAddress == null || ipAddress.equalsIgnoreCase("") || ipAddress.length() == 0) {
                ipAddress = request.getHeader("X-FORWARDED-FOR");
            }
            if (ipAddress == null || ipAddress.equalsIgnoreCase("") || ipAddress.length() == 0) {
                ipAddress = request.getHeader("HTTP_X_FORWARDED_FOR");
            }
            if (ipAddress == null || ipAddress.equalsIgnoreCase("") || ipAddress.length() == 0) {
                ipAddress = request.getHeader("Remote_Addr");
            }
            if ((ipAddress == null || ipAddress.equalsIgnoreCase("") || ipAddress.length() == 0) && (ipAddress = request.getHeader("X-Forwarded-For")) == null) {
                ipAddress = request.getRemoteAddr();
            }
            ipAddress = E12GenericUtility.checkNull((String)ipAddress);
            BaseLogger.log((String)"0", null, null, (Object)("getRequestedIP :: ipAddress : [" + ipAddress + "]"));
        }
        catch (Exception e) {
            BaseLogger.log((String)"0", null, null, (Object)("Exception :: getRequestedIP : [" + e.getMessage() + "]"));
            e.printStackTrace();
        }
        return ipAddress;
    }

    public UserInfoBean createUserInfo(HashMap<String, String> jwtData) {
        UserInfoBean basicInfo = null;
        if (jwtData != null) {
            basicInfo = new UserInfoBean();
            basicInfo.setUserType(this.checkNull(jwtData.get("entityType")));
            basicInfo.setEntityCode(this.checkNull(jwtData.get("entityCode")));
            basicInfo.setEnterprise(this.checkNull(jwtData.get("enterprise")));
            basicInfo.setTransDB(this.checkNull(jwtData.get("transDB")));
            basicInfo.setSiteCode(this.checkNull(jwtData.get("loginSite")));
            basicInfo.setLoginCode(this.checkNull(jwtData.get("userId")));
            basicInfo.setProfileId(this.checkNull(jwtData.get("profileId")));
        }
        return basicInfo;
    }

    public String getPayloadRequestData(HttpServletRequest request) throws IOException {
        String bodyData = null;
        StringBuilder stringBuilder = new StringBuilder();
        try (BufferedReader bufferedReader = null;){
            ServletInputStream inputStream = request.getInputStream();
            if (inputStream != null) {
                bufferedReader = new BufferedReader(new InputStreamReader((InputStream)inputStream));
                char[] charBuffer = new char[128];
                int bytesRead = -1;
                while ((bytesRead = bufferedReader.read(charBuffer)) > 0) {
                    stringBuilder.append(charBuffer, 0, bytesRead);
                }
            } else {
                stringBuilder.append("");
            }
        }
        bodyData = stringBuilder.toString();
        return bodyData;
    }

    public String getJsonStringValue(JSONObject inputArgJson, String key) throws JSONException {
        if (inputArgJson != null && inputArgJson.has(key)) {
            return this.checkNull(inputArgJson.getString(key));
        }
        return "";
    }
}

