/*
 * Decompiled with CFR 0.152.
 */
package ibase.bankIntegration;

import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.utility.ITMException;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Random;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CommonMethods {
    public static Document readXML(String filePath) {
        try {
            System.out.println("Inside CommonMethods readXML");
            File xmlFile = new File(filePath);
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", false);
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            return dBuilder.parse(xmlFile);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void modifyElementValue(Element root, String parentElementName, String elementName, String newValue) {
        System.out.println("Inside CommonMethods modifyElementValue");
        NodeList parentList = root.getElementsByTagName(parentElementName);
        if (parentList.getLength() > 0) {
            Element parentElement = (Element)parentList.item(0);
            NodeList nodeList = parentElement.getElementsByTagName(elementName);
            if (nodeList.getLength() > 0) {
                Node elementNode = nodeList.item(0);
                elementNode.setTextContent(newValue);
            } else {
                System.out.println("Element not found: " + elementName);
            }
        } else {
            System.out.println("Parent element not found: " + parentElementName);
        }
    }

    public static void saveChanges(Document doc, String filePath) throws Exception {
        System.out.println("Inside CommonMethods saveChanges filePath: [" + filePath + "]");
        System.out.println("Inside CommonMethods saveChanges doc: [" + doc.toString() + "]");
        File file = new File(filePath);
        if (!file.exists()) {
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            file.createNewFile();
        }
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(file);
        transformer.transform(source, result);
    }

    public static String generateRandomString(int length) {
        String characters = "0123456789";
        StringBuilder randomString = new StringBuilder();
        Random random = new Random();
        int i = 0;
        while (i < length) {
            int index = random.nextInt(characters.length());
            randomString.append(characters.charAt(index));
            ++i;
        }
        return randomString.toString();
    }

    public static JsonObject parseJsonString(String jsonString) {
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(jsonString));
        return jsonReader.readObject();
    }

    public static String getValueFromJson(JsonObject jsonObject, String key) {
        if (jsonObject.containsKey((Object)key)) {
            return jsonObject.getString(key);
        }
        return null;
    }

    public static String getPayIntArgsFromBankMaster(String tranID, UserInfoBean userInfo) throws SQLException {
        String payIntArgs = "";
        BaseLogger.log((String)"3", null, null, (Object)"Inside getBankCodeFromTranID method of BankIntegration class ...");
        Connection connection = null;
        Statement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                ConnDriver connDriver = new ConnDriver();
                connection = connDriver.getConnectDB(userInfo.getTransDB());
                String getPayIntArgsSQL = "SELECT B.PAY_INT_ARGS\nFROM BANK B\nINNER JOIN MISC_PAYMENT M ON B.BANK_CODE = M.BANK_CODE\nWHERE M.TRAN_ID = ?";
                pstmt = connection.prepareStatement(getPayIntArgsSQL);
                pstmt.setString(1, tranID);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    payIntArgs = rs.getString("PAY_INT_ARGS");
                    BaseLogger.log((String)"3", null, null, (Object)("Inside isIntegrated method of BankIntegration class PAY_INT_ARGS [" + payIntArgs + "]"));
                }
            }
            catch (Exception exp) {
                exp.printStackTrace();
                if (connection != null) {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (connection != null) {
                        connection.close();
                        connection = null;
                    }
                }
            }
        }
        finally {
            if (connection != null) {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (connection != null) {
                    connection.close();
                    connection = null;
                }
            }
        }
        return payIntArgs;
    }

    public static String getEventNotifyEmailFromBankMaster(String tranID, UserInfoBean userInfo) throws SQLException {
        String eventNotifyEmail = "";
        BaseLogger.log((String)"3", null, null, (Object)"Inside getBankCodeFromTranID method of BankIntegration class ...");
        Connection connection = null;
        Statement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                ConnDriver connDriver = new ConnDriver();
                connection = connDriver.getConnectDB(userInfo.getTransDB());
                String getEventNotifyEmailSQL = "SELECT B.EVENT_NOTIFY_EMAIL\nFROM BANK B\nINNER JOIN MISC_PAYMENT M ON B.BANK_CODE = M.BANK_CODE\nWHERE M.TRAN_ID = ?";
                pstmt = connection.prepareStatement(getEventNotifyEmailSQL);
                pstmt.setString(1, tranID);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    eventNotifyEmail = rs.getString("EVENT_NOTIFY_EMAIL");
                    BaseLogger.log((String)"3", null, null, (Object)("Inside isIntegrated method of BankIntegration class eventNotifyEmail [" + eventNotifyEmail + "]"));
                }
            }
            catch (Exception exp) {
                exp.printStackTrace();
                if (connection != null) {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (connection != null) {
                        connection.close();
                        connection = null;
                    }
                }
            }
        }
        finally {
            if (connection != null) {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (connection != null) {
                    connection.close();
                    connection = null;
                }
            }
        }
        return eventNotifyEmail;
    }

    public static String getBillNo(String tranID, UserInfoBean userInfo) throws ITMException {
        BaseLogger.log((String)"2", null, null, (Object)"getBillNo calling rsk------------------");
        Connection connection = null;
        Statement pstmt = null;
        ResultSet rs = null;
        String billno = "";
        StringBuffer bufferbillnumber = new StringBuffer();
        try {
            try {
                ConnDriver connDriver = new ConnDriver();
                connection = connDriver.getConnectDB(userInfo.getTransDB());
                String voucherTableNameOfNum = "";
                DBAccessEJB dbAccessEJB = new DBAccessEJB();
                connection = connDriver.getConnectDB(userInfo.getTransDB());
                String tranSerNumber = "";
                tranSerNumber = dbAccessEJB.getDBColumnValue("MISC_PAYDET", "TRAN_SER", "TRAN_ID  = '" + tranID + "'", userInfo.getTransDB());
                BaseLogger.log((String)"3", null, null, (Object)("Value of refserfor billnumber... [" + tranSerNumber + "]"));
                if (tranSerNumber.equalsIgnoreCase("M-VOUC")) {
                    voucherTableNameOfNum = "MISC_VOUCHER";
                } else if (tranSerNumber.equalsIgnoreCase("VOUCH")) {
                    voucherTableNameOfNum = "VOUCHER";
                }
                String result = "SELECT BILL_NO FROM " + voucherTableNameOfNum + " WHERE TRAN_ID in (select VOUCH_NO from MISC_PAYDET where tran_id = ?)";
                BaseLogger.log((String)"3", null, null, (Object)"getBillNo calling inside Confirm tan_id-----------");
                pstmt = connection.prepareStatement(result);
                pstmt.setString(1, tranID);
                rs = pstmt.executeQuery();
                StringBuilder resultLine = new StringBuilder();
                while (rs.next()) {
                    billno = rs.getString("BILL_NO");
                    resultLine.append(billno).append(",");
                    StringBuffer buffer = new StringBuffer();
                    buffer.append(tranID);
                    buffer.append(bufferbillnumber);
                }
                if (resultLine.length() > 0) {
                    resultLine.deleteCharAt(resultLine.length() - 1);
                }
                BaseLogger.log((String)"3", null, null, (Object)("****BILL_NO = " + resultLine.toString()));
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                bufferbillnumber.append(billno);
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return bufferbillnumber.toString();
    }

    public static String getBillDate(String tranID, UserInfoBean userInfo) throws ITMException {
        BaseLogger.log((String)"2", null, null, (Object)"getBillDate calling rsk--------------------");
        Connection connection = null;
        Statement pstmt = null;
        ResultSet rs = null;
        String billdate = "";
        StringBuffer bufferbilldate = new StringBuffer();
        try {
            try {
                ConnDriver connDriver = new ConnDriver();
                connection = connDriver.getConnectDB(userInfo.getTransDB());
                String voucherTableNameOfDate = "";
                DBAccessEJB dbAccessEJB = new DBAccessEJB();
                connection = connDriver.getConnectDB(userInfo.getTransDB());
                String tranSer = "";
                tranSer = dbAccessEJB.getDBColumnValue("MISC_PAYDET", "TRAN_SER", "TRAN_ID  = '" + tranID + "'", userInfo.getTransDB());
                BaseLogger.log((String)"3", null, null, (Object)("Value of tranSer... [" + tranSer + "]"));
                if (tranSer.equalsIgnoreCase("M-VOUC")) {
                    voucherTableNameOfDate = "MISC_VOUCHER";
                } else if (tranSer.equalsIgnoreCase("VOUCH")) {
                    voucherTableNameOfDate = "VOUCHER";
                }
                String result = "SELECT BILL_DATE FROM " + voucherTableNameOfDate + " WHERE TRAN_ID in (select VOUCH_NO from MISC_PAYDET where tran_id = ?)";
                BaseLogger.log((String)"3", null, null, (Object)"getBillDate calling inside Confirm tan_id-----------");
                pstmt = connection.prepareStatement(result);
                pstmt.setString(1, tranID);
                rs = pstmt.executeQuery();
                StringBuilder resultLineOfDate = new StringBuilder();
                while (rs.next()) {
                    billdate = rs.getString("BILL_DATE");
                    resultLineOfDate.append(billdate).append(",");
                    StringBuffer buffer = new StringBuffer();
                    buffer.append(tranID);
                    buffer.append(bufferbilldate);
                }
                if (resultLineOfDate.length() > 0) {
                    resultLineOfDate.deleteCharAt(resultLineOfDate.length() - 1);
                }
                BaseLogger.log((String)"3", null, null, (Object)("****BILL_Date = " + resultLineOfDate.toString()));
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                bufferbilldate.append(billdate);
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return bufferbilldate.toString();
    }

    public static String getCurrentDate() {
        BaseLogger.log((String)"3", null, null, (Object)"inside getCurrentDate .. ");
        LocalDateTime currentDateTime = LocalDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd/MM/yy HH:mm:ss");
        BaseLogger.log((String)"3", null, null, (Object)("currentDateTime is .. [" + currentDateTime.format(formatter) + "]"));
        return currentDateTime.format(formatter);
    }

    private static String getElementValueByTagName(Document document, String tagName) {
        NodeList nodeList = document.getElementsByTagName(tagName);
        if (nodeList.getLength() > 0) {
            Element element = (Element)nodeList.item(0);
            return element.getTextContent();
        }
        return null;
    }

    private static String getElementValue(Element parentElement, String parentTagName, String tagName) {
        NodeList parentNodes = parentElement.getElementsByTagName(parentTagName);
        int i = 0;
        while (i < parentNodes.getLength()) {
            int j = 0;
            Element parent = (Element)parentNodes.item(i);
            NodeList nodeList = parent.getElementsByTagName(tagName);
            if (j < nodeList.getLength()) {
                Element element = (Element)nodeList.item(j);
                return element.getTextContent();
            }
            ++i;
        }
        return null;
    }

    public static String getAcknowledgmentTagValue(String filePath, String tagName, String parentTagName) {
        String result = "";
        BaseLogger.log((String)"3", null, null, (Object)("Inside checkFirstAcknowledgement method filePath [" + filePath + "]"));
        BaseLogger.log((String)"3", null, null, (Object)("Inside checkFirstAcknowledgement method tagName [" + tagName + "]"));
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new File(filePath));
            BaseLogger.log((String)"3", null, null, (Object)("Acknowledgement document:[" + E12GenericUtility.documentToString((Document)document) + "]"));
            if (parentTagName.equalsIgnoreCase("")) {
                result = CommonMethods.getElementValueByTagName(document, tagName);
            } else {
                Element rootElement = document.getDocumentElement();
                System.out.println("Root Element gsb: " + document.getDocumentElement().getTagName());
                result = CommonMethods.getElementValue(rootElement, parentTagName, tagName);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        BaseLogger.log((String)"3", null, null, (Object)("result from getAcknowledgmentTagValue:[" + result + "]"));
        return result;
    }

    public static String generateBankXMLName(String tranId) {
        Date currentDate = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("ddMMyyHHmmss");
        String formattedDate = dateFormat.format(currentDate);
        String formattedTranId = String.valueOf(tranId) + formattedDate;
        BaseLogger.log((String)"3", null, null, (Object)(" value of formattedTranId [" + formattedTranId + "]"));
        return formattedTranId;
    }

    public static String extractDate(String dateTimeString) {
        DateTimeFormatter inputFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDateTime dateTime = LocalDateTime.parse(dateTimeString, inputFormatter);
        DateTimeFormatter outputFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        String datePart = dateTime.format(outputFormatter);
        return datePart;
    }
}

