/*
 * Decompiled with CFR 0.152.
 */
package ibase.marketingCampaign;

import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.utility.EMail;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.ActionHandlerEJB;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ValidatorEJB;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class MarketingCampaignPreSend
extends ActionHandlerEJB {
    ValidatorEJB validatorEJB = new ValidatorEJB();
    E12GenericUtility genericUtility = new E12GenericUtility();
    ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();

    private static String readHtmlFile(String filePath) throws IOException {
        BaseLogger.log((String)"3", null, null, (Object)"Calling readHtmlFile method");
        return new String(Files.readAllBytes(Paths.get(filePath, new String[0])));
    }

    private String buildMailXMLStr(HashMap<String, Object> mailFormatDetails, UserInfoBean userInfo) {
        BaseLogger.log((String)"2", null, null, (Object)("sendEmailToMe calling buildMailXMLStr-----------------[" + mailFormatDetails + "  ]"));
        String mailXMLStr = "";
        String emailID = mailFormatDetails.get("SEND_TO").toString();
        BaseLogger.log((String)"3", null, null, (Object)("buildMailXMLStr emailID [" + emailID + "]"));
        String bodyFilePath = mailFormatDetails.get("BODY").toString();
        String body = "";
        try {
            body = MarketingCampaignPreSend.readHtmlFile(bodyFilePath);
        }
        catch (IOException e1) {
            BaseLogger.log((String)"3", null, null, (Object)("Exception in readHtmlFile method [" + emailID + "]"));
            e1.printStackTrace();
        }
        String formatCode = "";
        String system = mailFormatDetails.get("SUBJECT").toString();
        BaseLogger.log((String)"3", null, null, (Object)("system [" + system + "]"));
        String objName = "";
        String workDateApp = "";
        try {
            BaseLogger.log((String)"2", null, null, (Object)"Inside try block method: buildMailXMLStr ---");
            mailXMLStr = "";
            mailXMLStr = String.valueOf(mailXMLStr) + "<ROOT>";
            mailXMLStr = String.valueOf(mailXMLStr) + "<TRANS_INFO>";
            mailXMLStr = String.valueOf(mailXMLStr) + "<OBJ_NAME><![CDATA[" + objName + "]]></OBJ_NAME>";
            mailXMLStr = String.valueOf(mailXMLStr) + "<REF_SER><![CDATA[]]></REF_SER>";
            mailXMLStr = String.valueOf(mailXMLStr) + "<REF_ID><![CDATA[" + workDateApp + "]]></REF_ID>";
            mailXMLStr = String.valueOf(mailXMLStr) + "<LINE_NO><![CDATA[1]]></LINE_NO>";
            mailXMLStr = String.valueOf(mailXMLStr) + "</TRANS_INFO>";
            mailXMLStr = String.valueOf(mailXMLStr) + "<EMAIL_TYPE><![CDATA[]]></EMAIL_TYPE>";
            mailXMLStr = String.valueOf(mailXMLStr) + "<ENTITY_CODE><![CDATA[]]></ENTITY_CODE>";
            mailXMLStr = String.valueOf(mailXMLStr) + "<FORMAT_CODE><![CDATA[" + formatCode + "]]></FORMAT_CODE>";
            mailXMLStr = String.valueOf(mailXMLStr) + "<LINK_ADDR><![CDATA[]]></LINK_ADDR>";
            mailXMLStr = String.valueOf(mailXMLStr) + "<TO_ADD><![CDATA[" + emailID + "]]></TO_ADD>";
            mailXMLStr = String.valueOf(mailXMLStr) + "<CC_ADD><![CDATA[" + mailFormatDetails.get("COPY_TO") + "]]></CC_ADD>";
            mailXMLStr = String.valueOf(mailXMLStr) + "<BCC_ADD><![CDATA[" + mailFormatDetails.get("BLIND_COPY") + "]]></BCC_ADD>";
            mailXMLStr = String.valueOf(mailXMLStr) + "<BODY_TEXT><![CDATA[" + body + "]]></BODY_TEXT>";
            mailXMLStr = String.valueOf(mailXMLStr) + "<SUBJECT><![CDATA[" + mailFormatDetails.get("SUBJECT") + "]]></SUBJECT>";
            mailXMLStr = String.valueOf(mailXMLStr) + "</ROOT>";
            System.out.println("mailXMLStr....::" + mailXMLStr);
        }
        catch (Exception e) {
            BaseLogger.log((String)"0", null, null, (Object)("Exception from buildMailXMLStr [" + system + "]"));
            e.printStackTrace();
        }
        return mailXMLStr;
    }

    public String sendEmail(String tranId, String xtraParams, String forcedFlag) throws Exception {
        UserInfoBean userInfo;
        ArrayList<String> mailList;
        String currentDate;
        int batchCount;
        String retString;
        String bodyText;
        String subject;
        String formatCode;
        String sql;
        ResultSet rs;
        PreparedStatement pstmt;
        Connection conn;
        block10: {
            String userId = "";
            conn = null;
            pstmt = null;
            rs = null;
            sql = "";
            formatCode = "";
            subject = "";
            bodyText = "";
            String mailListName = "";
            retString = "";
            batchCount = 0;
            SimpleDateFormat dtFormat = new SimpleDateFormat("dd-MMM-yy");
            Date date = Calendar.getInstance().getTime();
            currentDate = dtFormat.format(date);
            mailList = new ArrayList<String>();
            userInfo = this.getUserInfo();
            System.out.println("********************userinfo****************" + userInfo);
            conn = this.getConnection();
            userId = this.validatorEJB.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
            BaseLogger.log((String)"3", null, null, (Object)("user id2 [" + userId + "]"));
            BaseLogger.log((String)"3", null, null, (Object)("tran id2 [" + tranId + "]"));
            sql = "select mailing_list from mktg_campaign_det where campaign_id = ?";
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, tranId);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                mailListName = rs.getString("mailing_list");
            }
            this.closeResources(rs, pstmt);
            BaseLogger.log((String)"3", null, null, (Object)("mail list name [" + mailListName + "]"));
            sql = "select email_id from mailing_list_det where mail_list_id = ?";
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, mailListName);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                mailList.add(rs.getString("email_id"));
            }
            this.closeResources(rs, pstmt);
            BaseLogger.log((String)"3", null, null, (Object)("mail list [" + mailList + "]"));
            if (!mailList.isEmpty()) break block10;
            String string = retString = this.itmDBAccessEJB.getErrorString("", "NMAILIST", "", "", conn);
            this.closeResources(rs, pstmt, conn);
            return string;
        }
        try {
            try {
                conn.setAutoCommit(false);
                for (String emilId : mailList) {
                    sql = "insert into mktg_campaign_log (campaign_id,email_id,status,status_date) values (?,?,'N',?)";
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setString(1, tranId);
                    pstmt.setString(2, emilId);
                    pstmt.setString(3, currentDate);
                    BaseLogger.log((String)"3", null, null, (Object)("email for insert [" + emilId + "]"));
                    rs = pstmt.executeQuery();
                    this.closeResources(rs, pstmt);
                }
                conn.commit();
                sql = "select campaign_template,batch_count from mktg_campaign where campaign_id = ?";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, tranId);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    formatCode = rs.getString("campaign_template");
                    batchCount = rs.getInt("batch_count");
                }
                this.closeResources(rs, pstmt);
                BaseLogger.log((String)"3", null, null, (Object)("format code [" + formatCode + "]"));
                sql = "select subject,body_text from mail_format where format_code = ?";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, formatCode);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    subject = rs.getString("subject");
                    bodyText = rs.getString("body_text");
                }
                this.closeResources(rs, pstmt);
                BaseLogger.log((String)"3", null, null, (Object)("subject [" + subject + "]"));
                BaseLogger.log((String)"3", null, null, (Object)("body text [" + bodyText + "]"));
                retString = this.sendEmailWithBatchCount(mailList, batchCount, subject, bodyText, userInfo, tranId);
            }
            catch (Exception e) {
                System.out.println("Exception :MarketingCampaignPreSend :sendMail(Document,String):" + e.getMessage() + ":");
                e.printStackTrace();
                this.closeResources(rs, pstmt, conn);
            }
        }
        catch (Throwable throwable) {
            this.closeResources(rs, pstmt, conn);
            throw throwable;
        }
        this.closeResources(rs, pstmt, conn);
        return retString;
    }

    public List<String> getUpdatedEmail(String tranId, int batchCount) {
        ArrayList<String> mailListForMailSend;
        block9: {
            mailListForMailSend = new ArrayList<String>();
            Connection conn = null;
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            String sql = "";
            try {
                try {
                    conn = this.getConnection();
                    conn.setAutoCommit(false);
                    sql = "SELECT email_id FROM mktg_campaign_log WHERE status = 'N' AND campaign_id = ? FETCH NEXT ? ROWS ONLY";
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setString(1, tranId);
                    pstmt.setInt(2, batchCount);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        mailListForMailSend.add(rs.getString("email_id"));
                    }
                    BaseLogger.log((String)"3", null, null, (Object)("Mail list for mail sending [" + mailListForMailSend + "]"));
                    conn.commit();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    BaseLogger.log((String)"0", null, null, (Object)("Exception in getUpdatedEmail: " + e.getMessage()));
                    if (conn != null) {
                        try {
                            conn.rollback();
                            BaseLogger.log((String)"0", null, null, (Object)"Transaction rolled back due to exception.");
                        }
                        catch (SQLException se) {
                            se.printStackTrace();
                        }
                    }
                    this.closeResources(rs, pstmt, conn);
                    break block9;
                }
            }
            catch (Throwable throwable) {
                this.closeResources(rs, pstmt, conn);
                throw throwable;
            }
            this.closeResources(rs, pstmt, conn);
        }
        return mailListForMailSend;
    }

    public String sendEmailWithBatchCount(List<String> mailList2, int batchCount, String subject, String bodyText, UserInfoBean userInfo, String tranId) {
        BaseLogger.log((String)"3", null, null, (Object)("sendEmailWithBatchCount method calling [" + batchCount + "]"));
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String sql = "";
        String fromEmailId = "";
        String retString = "";
        String status = "";
        String errMsg = "";
        ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
        boolean updateFlag = false;
        try {
            conn = this.getConnection();
            conn.setAutoCommit(false);
            block16: while (true) {
                List<String> mailListForMailSend;
                if ((mailListForMailSend = this.getUpdatedEmail(tranId, batchCount)).isEmpty()) {
                    updateFlag = true;
                    break;
                }
                int totalMails = mailListForMailSend.size();
                int totalBatches = (int)Math.ceil((double)totalMails / (double)batchCount);
                int i = 0;
                while (true) {
                    if (i >= totalBatches) continue block16;
                    int start = i * batchCount;
                    int end = Math.min(start + batchCount, totalMails);
                    List<String> batchList = mailListForMailSend.subList(start, end);
                    for (String emailId : batchList) {
                        BaseLogger.log((String)"3", null, null, (Object)("Single emailId [" + emailId + "]"));
                        HashMap<String, Object> mailFormatDetails = new HashMap<String, Object>();
                        mailFormatDetails.put("SEND_TO", emailId);
                        mailFormatDetails.put("MAIL_SERVER", "192.168.137.1");
                        mailFormatDetails.put("SUBJECT", subject);
                        mailFormatDetails.put("BODY", bodyText);
                        EMail email = new EMail();
                        email.setMailFrom(mailFormatDetails.get("MAIL_SERVER").toString());
                        BaseLogger.log((String)"3", null, null, (Object)("Mail from [" + fromEmailId + "]"));
                        String mailXMLStr = this.buildMailXMLStr(mailFormatDetails, userInfo);
                        try {
                            String emailStatus = email.sendMail(mailXMLStr, "ITM", userInfo);
                            BaseLogger.log((String)"3", null, null, (Object)("Email status for [" + emailId + "]: " + emailStatus));
                            status = "S";
                            errMsg = "None";
                        }
                        catch (Exception e) {
                            BaseLogger.log((String)"3", null, null, (Object)("Error sending email to [" + emailId + "]: " + e.getMessage()));
                            status = "E";
                            errMsg = e.getMessage();
                        }
                        sql = "UPDATE mktg_campaign_log SET status = ?, err_msg = ? WHERE email_id = ? AND campaign_id = ?";
                        try {
                            Throwable e = null;
                            Object var31_36 = null;
                            try (PreparedStatement updatePstmt = conn.prepareStatement(sql);){
                                updatePstmt.setString(1, status);
                                updatePstmt.setString(2, errMsg);
                                updatePstmt.setString(3, emailId);
                                updatePstmt.setString(4, tranId);
                                int affectedRows = updatePstmt.executeUpdate();
                                BaseLogger.log((String)"3", null, null, (Object)("Rows affected by update for emailId [" + emailId + "]: " + affectedRows));
                            }
                            catch (Throwable throwable) {
                                if (e == null) {
                                    e = throwable;
                                } else if (e != throwable) {
                                    e.addSuppressed(throwable);
                                }
                                throw e;
                            }
                        }
                        catch (SQLException e) {
                            BaseLogger.log((String)"3", null, null, (Object)("Error updating log for emailId [" + emailId + "]: " + e.getMessage()));
                            conn.rollback();
                        }
                        conn.commit();
                    }
                    ++i;
                }
                break;
            }
            if (updateFlag) {
                String string = retString = itmDBAccessEJB.getErrorString("", "VTMAILSUCC", "", "", conn);
                return string;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            BaseLogger.log((String)"0", null, null, (Object)("Exception during email processing: " + e.getMessage()));
            if (conn != null) {
                try {
                    conn.rollback();
                    BaseLogger.log((String)"0", null, null, (Object)"Transaction rolled back due to exception.");
                }
                catch (SQLException se) {
                    se.printStackTrace();
                }
            }
        }
        finally {
            this.closeResources(rs, pstmt, conn);
        }
        return retString;
    }

    public String sendEmailToMe(String tranId, String xtraParams, String forcedFlag) {
        UserInfoBean userInfo;
        String retString;
        String bodyText;
        String subject;
        String formatCode;
        String userEmail;
        String sql;
        ResultSet rs;
        PreparedStatement pstmt;
        Connection conn;
        block10: {
            String userId = "";
            conn = null;
            pstmt = null;
            rs = null;
            sql = "";
            userEmail = "";
            formatCode = "";
            subject = "";
            bodyText = "";
            String msg = "";
            retString = "";
            userInfo = this.getUserInfo();
            System.out.println("********************userinfo****************" + userInfo);
            conn = this.getConnection();
            userId = this.validatorEJB.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
            BaseLogger.log((String)"3", null, null, (Object)("user id [" + userId + "]"));
            BaseLogger.log((String)"3", null, null, (Object)("tran id [" + tranId + "]"));
            sql = "select email_id from users where code = ?";
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, userId);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                userEmail = rs.getString("email_id");
            }
            this.closeResources(rs, pstmt);
            if (userEmail != null) break block10;
            BaseLogger.log((String)"3", null, null, (Object)("In null condition [" + userEmail + "]"));
            String string = retString = this.itmDBAccessEJB.getErrorString("", "NULEMAILID", "", "", conn);
            this.closeResources(rs, pstmt, conn);
            return string;
        }
        try {
            try {
                BaseLogger.log((String)"3", null, null, (Object)("user email [" + userEmail + "]"));
                sql = "select campaign_template from mktg_campaign where campaign_id = ?";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, tranId);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    formatCode = rs.getString("campaign_template");
                }
                this.closeResources(rs, pstmt);
                BaseLogger.log((String)"3", null, null, (Object)("format code [" + formatCode + "]"));
                sql = "select subject,body_text from mail_format where format_code = ?";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, formatCode);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    subject = rs.getString("subject");
                    bodyText = rs.getString("body_text");
                }
                this.closeResources(rs, pstmt);
                BaseLogger.log((String)"3", null, null, (Object)("New subject [" + subject + "]"));
                BaseLogger.log((String)"3", null, null, (Object)("body text [" + bodyText + "]"));
                HashMap<String, Object> mailFormatDetails = new HashMap<String, Object>();
                mailFormatDetails.put("SEND_TO", userEmail);
                mailFormatDetails.put("MAIL_SERVER", "192.168.137.1");
                mailFormatDetails.put("SUBJECT", subject);
                mailFormatDetails.put("BODY", bodyText);
                EMail email = new EMail();
                email.setMailFrom(mailFormatDetails.get("MAIL_SERVER").toString());
                System.out.println("getMailFrom1....::" + email.getMailFrom());
                String mailXMLStr = this.buildMailXMLStr(mailFormatDetails, userInfo);
                try {
                    BaseLogger.log((String)"3", null, null, (Object)"Before sendMail method calling");
                    String emailStatus = email.sendMail(mailXMLStr, "ITM", userInfo);
                    BaseLogger.log((String)"3", null, null, (Object)("Email Statsus[" + emailStatus + "]"));
                    retString = this.itmDBAccessEJB.getErrorString("", "VTMAILSUCC", "", "", conn);
                }
                catch (Exception e) {
                    retString = this.itmDBAccessEJB.getErrorString("", "MAILFAILED", "", "", conn);
                    System.out.println("Exception in senMail method" + e.getMessage() + ":");
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                System.out.println("Exception in EmailSendToMe method" + e.getMessage() + ":");
                e.printStackTrace();
                this.closeResources(rs, pstmt, conn);
            }
        }
        catch (Throwable throwable) {
            this.closeResources(rs, pstmt, conn);
            throw throwable;
        }
        this.closeResources(rs, pstmt, conn);
        return retString;
    }

    private void closeResources(ResultSet rs, PreparedStatement pstmt, Connection conn) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (pstmt != null) {
            try {
                pstmt.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    private void closeResources(ResultSet rs, PreparedStatement pstmt) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (pstmt != null) {
            try {
                pstmt.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }
}

