/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.utility;

import ibase.system.config.AppConnectParm;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.PopUpHandler;
import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.naming.InitialContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DW2XSLGenerator
implements Serializable {
    static final String outputEncoding = CommonConstants.ENCODING;
    final String COLUMN_SEPARATOR = ":";
    boolean ignoreComments = true;
    Locale currentLocale = null;
    transient ResourceBundle labels = null;
    String language = new String("en");
    String country = new String("US");
    String var = new String("BLOC");
    String labName = "";
    String objName = null;
    String objContext = null;
    String pageContext = null;
    String editFlag = null;
    String scrEditMode = null;
    String layoutPattern = null;
    String keyFlag = null;
    int editTmplt = -1;
    String confirmCol = null;
    String confirmVal = null;
    String editOpt = null;
    int varCount = 1;
    boolean isPBUnits = false;
    int tableWidth = 0;
    boolean isCssFile = true;
    String sub_nodeName = null;
    boolean isUnits = false;
    boolean editMask = false;
    String pkHiddenField = "";
    private StringBuffer xslStringBuff = null;
    Document dwDoc = null;
    HashMap primarykeyMap;
    HashMap dataTypeMap;
    HashMap optionMap = null;
    PopUpHandler popUpHandler;
    ArrayList itemChangeList = null;
    ArrayList globalColNameList = new ArrayList();
    String displayTheme = null;
    HashMap labelMap = new HashMap();
    boolean chkBoxClick = false;
    TreeMap<Integer, Object> sortedTextMap = null;

    public String generateXSLString(UserInfoBean userInfo) throws ITMException {
        try {
            this.xslStringBuff = new StringBuffer("<?xml version='1.0' encoding='" + CommonConstants.ENCODING + "'?>");
            this.xslStringBuff.append("\n<xsl:stylesheet version='1.0' xmlns:xsl='http://www.w3.org/1999/XSL/Transform'>");
            this.xslStringBuff.append("\n<xsl:template match='/'>");
            this.xslStringBuff.append("\n<html>");
            this.xslStringBuff.append("\n<head>");
            this.xslStringBuff.append("\n<link type='text/css' rel='stylesheet' href='/ibase/webitm/css/" + this.displayTheme + "/default.css'/>");
            this.xslStringBuff.append("\n</head>");
            this.xslStringBuff.append("\n<body id='groupDiv' class='headerDetailBody'  >");
            if (this.pageContext.equalsIgnoreCase("1")) {
                if (this.objContext.equalsIgnoreCase("1")) {
                    this.xslStringBuff.append("<FORM id=\"brow\" METHOD=\"POST\" ACTION=\"fwd.jsp\">\n");
                } else {
                    this.xslStringBuff.append("<FORM id=\"brow").append(this.objContext).append("\" METHOD=\"POST\" ACTION=\"fwd.jsp\">\n");
                }
            } else {
                this.xslStringBuff.append("<FORM id=\"detail\" METHOD=\"POST\" ACTION=\"MasterSave.jsp\">\n");
            }
            this.xslStringBuff.append("\n<INPUT type='hidden' name='OBJ_NAME' value='" + this.objName + "'/>");
            this.xslStringBuff.append("\n<INPUT type='hidden' name='PAGE_CONTEXT' value='" + this.pageContext + "'/>");
            this.xslStringBuff.append("\n<INPUT type='hidden' name='OBJ_CONTEXT' value='" + this.objContext + "'/>");
            this.xslStringBuff.append("\n<INPUT type='hidden' name='EDIT_FLAG' value='" + this.editFlag + "'/>");
            this.xslStringBuff.append("\n<INPUT type='hidden' name='EDIT_TMPLT' value='" + this.editTmplt + "'/>");
            this.xslStringBuff.append("\n<xsl:for-each select='/DocumentRoot/group0/Header0'>");
            this.setProperties();
            String columnHeading = this.staticTextDisplay();
            if ("T".equals(this.layoutPattern)) {
                this.xslStringBuff.append("\n<div id='dataDivID1" + this.objContext + "' class=''>");
                this.xslStringBuff.append("\n<TABLE name='main' id='main' class=\"tableClass\"");
                this.xslStringBuff.append(" style= 'class:header_css;position:relative;top:0;width:" + this.tableWidth + ";'>");
                this.xslStringBuff.append(" \n<THEAD class=\"table-head\">\n<TR>");
                this.xslStringBuff.append(columnHeading);
                this.xslStringBuff.append(" \n</TR>\n</THEAD>");
            } else if ("F".equals(this.layoutPattern)) {
                this.xslStringBuff.append("\n<SPAN name='PopUpIcon' id='PopUpIcon' style='z-index:1;visibility:hidden;width:20;height:20;border:none;' CUR_POPUP_PARAM=''>");
                this.xslStringBuff.append("<div title=\"Click to see list of values for this column in a pop up window\" onclick=\"getListOfValues();\" class=\"pophelp-Btn\" border=\"0\" z-index=\"1\"></div>");
                this.xslStringBuff.append("</SPAN>\n");
                this.xslStringBuff.append("\n<SPAN name='calender' id='calender'   style='z-index:1;visibility:hidden;width:30;height:30;border:none;' CUR_POPUP_PARAM=''>");
                this.xslStringBuff.append("<div title=\"Click to see calender\" onclick=\"setDate();\" class=\"calender-Btn\" border=\"0\" z-index=\"1\"></div>");
                this.xslStringBuff.append("</SPAN>\n");
            }
            if ("T".equals(this.layoutPattern)) {
                this.xslStringBuff.append("\n<TBODY class=\"table-body\">");
            }
            this.xslStringBuff.append("\n<xsl:for-each select=\"./Detail" + this.objContext + "[not(attribute/@updateFlag='D')]\">");
            this.xslStringBuff.append("\n <xsl:variable name=\"localDomId\">");
            this.xslStringBuff.append("\n <xsl:choose>");
            this.xslStringBuff.append("\n <xsl:when test=\"@domID!=''\">");
            this.xslStringBuff.append("\n <xsl:value-of select='@domID'/>");
            this.xslStringBuff.append("\n </xsl:when>");
            this.xslStringBuff.append("\n <xsl:otherwise>");
            this.xslStringBuff.append("\n <xsl:value-of select='position()'/>");
            this.xslStringBuff.append("\n </xsl:otherwise>");
            this.xslStringBuff.append("\n </xsl:choose>");
            this.xslStringBuff.append("\n </xsl:variable>");
            if ("T".equals(this.layoutPattern)) {
                this.xslStringBuff.append("\n<TR id='{@dbID}' name='{@domID}' class='trClass'  onClick='setSelection(this," + this.objContext + ")' onContextMenu='setSelection(this);showContexMenu(event);return false;'");
                if (this.objContext.equals("1")) {
                    this.xslStringBuff.append("  onDblClick=\"invokeAction(0,'S')\"");
                }
                this.xslStringBuff.append(">");
                this.xslStringBuff.append(this.dataFieldDisplay(this.editTmplt, userInfo));
                this.xslStringBuff.append("\n</TR>");
            } else if ("F".equals(this.layoutPattern)) {
                this.xslStringBuff.append("\n<div id='dataDivID2" + this.objContext + "' class='detailDataFreeFormDiv'>");
                this.xslStringBuff.append(columnHeading);
                this.xslStringBuff.append(this.dataFieldDisplay(this.editTmplt, userInfo));
                this.xslStringBuff.append("\n</div>");
            }
            this.xslStringBuff.append("\n</xsl:for-each>");
            if ("T".equals(this.layoutPattern)) {
                this.xslStringBuff.append("\n</TBODY>");
                this.xslStringBuff.append("\n</TABLE>");
                this.xslStringBuff.append("\n</div>");
            }
            this.xslStringBuff.append("\n</xsl:for-each>");
            this.xslStringBuff.append("\n</FORM>");
            this.xslStringBuff.append("\n<xsl:for-each select='/DocumentRoot/Message'>\n<xsl:value-of select='.'/></xsl:for-each>");
            this.xslStringBuff.append("\n</body>");
            this.xslStringBuff.append("\n</html>");
            this.xslStringBuff.append("\n</xsl:template>");
            this.xslStringBuff.append("\n</xsl:stylesheet>");
        }
        catch (ITMException itme) {
            throw itme;
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return this.xslStringBuff.toString();
    }

    private String staticTextDisplay() throws ITMException {
        StringBuffer staticTextBuff = new StringBuffer();
        try {
            NodeList txtNodeList = this.dwDoc.getElementsByTagName("TextObject");
            String childValue = "";
            int noOfTextNodes = txtNodeList.getLength();
            if (this.layoutPattern.equalsIgnoreCase("T")) {
                HashMap textMap = new HashMap();
                Set<Integer> sortedNodeKeys = null;
                int textNodeCtr = 0;
                while (textNodeCtr < noOfTextNodes) {
                    Node currTextNode = txtNodeList.item(textNodeCtr);
                    if (currTextNode.getNodeType() == 1 && currTextNode.getFirstChild() != null) {
                        NodeList currTextNodeList = currTextNode.getChildNodes();
                        int noOfChildNodes = currTextNodeList.getLength();
                        int noOfChildCtr = 0;
                        while (noOfChildCtr < noOfChildNodes) {
                            Node currChildNode = currTextNodeList.item(noOfChildCtr);
                            if (currChildNode.getNodeName().equalsIgnoreCase("X")) {
                                HashMap<String, Object> tempMap = new HashMap<String, Object>();
                                tempMap.put("textNodeCtr", textNodeCtr);
                                tempMap.put("currTextNode", currTextNode);
                                if (textMap.containsKey(new Integer(currChildNode.getTextContent()))) {
                                    textMap.put(new Integer(String.valueOf(currChildNode.getTextContent()) + 1), tempMap);
                                } else {
                                    textMap.put(new Integer(currChildNode.getTextContent()), tempMap);
                                }
                            }
                            ++noOfChildCtr;
                        }
                    }
                    ++textNodeCtr;
                }
                this.sortedTextMap = new TreeMap(textMap);
                sortedNodeKeys = this.sortedTextMap.keySet();
                boolean isCheck = false;
                for (Integer eachNodeKey : sortedNodeKeys) {
                    HashMap tempMap = new HashMap();
                    tempMap = (HashMap)this.sortedTextMap.get(eachNodeKey);
                    int textNodeCtr2 = (Integer)tempMap.get("textNodeCtr");
                    Node currTextNode = (Node)tempMap.get("currTextNode");
                    if (!this.getElementType(textNodeCtr2).equalsIgnoreCase("checkbox") && !isCheck && this.chkBoxClick) {
                        staticTextBuff.append("<th id='is_selected" + this.objContext + "' isNonSortable='true' class='thClass' STYLE =\" left:2;  top:2;  width:17;\"><Input id='selectAll" + this.objContext + "' type='checkbox' name='selectAll' onClick='checkAll(" + this.objContext + ")'/></th>\n");
                    }
                    if (currTextNode.getNodeType() == 1 && currTextNode.getFirstChild() != null) {
                        staticTextBuff.append(this.createTextNode(currTextNode, textNodeCtr2));
                    }
                    isCheck = true;
                }
            } else if (this.layoutPattern.equalsIgnoreCase("F")) {
                int textNodeCtr = 0;
                while (textNodeCtr < noOfTextNodes) {
                    Node currTextNode = txtNodeList.item(textNodeCtr);
                    if (currTextNode.getNodeType() == 1 && currTextNode.getFirstChild() != null) {
                        staticTextBuff.append(this.createTextNode(currTextNode, textNodeCtr));
                    }
                    ++textNodeCtr;
                }
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception:[I18NLabel]:staticTextDisplay" + e);
            throw new ITMException(e);
        }
        return staticTextBuff.toString();
    }

    private String getElementType(int textColumn) {
        String elemType = "";
        try {
            NodeList columnObjNodeList = this.dwDoc.getElementsByTagName("ColumnObject");
            Node currColumnObjNode = columnObjNodeList.item(textColumn);
            if (currColumnObjNode.getNodeType() == 1 && currColumnObjNode.getFirstChild() != null) {
                NodeList colNodeChildrenList = currColumnObjNode.getChildNodes();
                int noOfcolNodeChildren = colNodeChildrenList.getLength();
                int colNodeChildCtr = 0;
                while (colNodeChildCtr < noOfcolNodeChildren) {
                    Node styleAttrNode;
                    Node currColChildNode = colNodeChildrenList.item(colNodeChildCtr);
                    if (currColChildNode.getNodeType() == 1 && currColChildNode.getFirstChild() != null && currColChildNode.getFirstChild() != null && currColChildNode.getNodeName().equalsIgnoreCase("EDITSTYLE") && (styleAttrNode = currColChildNode.getAttributes().getNamedItem("style")) != null) {
                        elemType = styleAttrNode.getNodeValue();
                        BaseLogger.log("3", null, null, "Dayanand:elemType in getElementType()[" + elemType + "]");
                    }
                    ++colNodeChildCtr;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return elemType;
    }

    private String createTextNode(Node textNode, int textCtr) throws ITMException {
        try {
            String name = "";
            String datatype = "";
            String text = "";
            String left = "";
            String top = "";
            String width = "";
            String fontFamily = "";
            String fontSize = "";
            String textAlign = "";
            String border = "";
            boolean isVisible = false;
            String visibilityValue = "";
            NodeList textNodeChildrenList = textNode.getChildNodes();
            int noOfTextNodeChildren = textNodeChildrenList.getLength();
            int textNodeChildCtr = 0;
            while (textNodeChildCtr < noOfTextNodeChildren) {
                Node currTextChildNode = textNodeChildrenList.item(textNodeChildCtr);
                if (currTextChildNode.getNodeType() == 1 && currTextChildNode.getFirstChild() != null) {
                    String currNodeValue = currTextChildNode.getFirstChild().getNodeValue();
                    String currTextChildName = currTextChildNode.getNodeName();
                    if (currTextChildName.equalsIgnoreCase("NAME")) {
                        name = currNodeValue.endsWith("_t") ? currNodeValue.substring(0, currNodeValue.indexOf("_t")) : currNodeValue;
                        datatype = (String)this.dataTypeMap.get(currNodeValue);
                        datatype = datatype == null ? "text" : ("String".equalsIgnoreCase(datatype) ? "text" : ("datetime".equalsIgnoreCase(datatype) ? "date" : "number"));
                    } else if (currTextChildName.equalsIgnoreCase("TEXT")) {
                        text = currNodeValue;
                    } else if (currTextChildName.equalsIgnoreCase("X")) {
                        left = " left:" + (this.isPBUnits ? this.callWebservice(currNodeValue, "X") : currNodeValue) + ";";
                    } else if (currTextChildName.equalsIgnoreCase("Y")) {
                        top = " top:" + (this.isPBUnits ? this.callWebservice(currNodeValue, "Y") : currNodeValue) + ";";
                    } else if (currTextChildName.equalsIgnoreCase("WIDTH")) {
                        String string = currNodeValue = this.isPBUnits ? this.callWebservice(currNodeValue, "X") : currNodeValue;
                        if (currNodeValue != null) {
                            this.tableWidth += Integer.parseInt(currNodeValue.trim());
                        }
                        width = " width:" + Integer.parseInt(currNodeValue.trim()) + ";";
                    } else if (!currTextChildName.equalsIgnoreCase("HEIGHT") && currTextChildName.equalsIgnoreCase("VISIBLE")) {
                        isVisible = currNodeValue.equals("1");
                        BaseLogger.log("3", null, null, "currNodeValue for visible : [" + currNodeValue + "]");
                        visibilityValue = isVisible ? "visibility:visible;" : "visibility:hidden;";
                    }
                    if (!this.isCssFile) {
                        if (currTextChildName.equalsIgnoreCase("FONT")) {
                            NodeList fontProperties = currTextChildNode.getFirstChild().getChildNodes();
                            int k = 0;
                            while (k < fontProperties.getLength()) {
                                if (fontProperties.item(k).getNodeName().equalsIgnoreCase("face")) {
                                    fontFamily = "font-family:" + fontProperties.item(k).getNodeValue();
                                } else if (fontProperties.item(k).getNodeName().equalsIgnoreCase("height")) {
                                    fontSize = " font-size:" + fontProperties.item(k).getNodeValue();
                                }
                                ++k;
                            }
                        } else if (currTextChildName.equalsIgnoreCase("ALIGNMENT")) {
                            textAlign = " text-align:" + currTextChildNode.getFirstChild().getNodeValue() + "; ";
                        } else if (currTextChildName.equalsIgnoreCase("BORDER")) {
                            border = " border:" + currTextChildNode.getFirstChild().getNodeValue() + "; ";
                        }
                    }
                }
                ++textNodeChildCtr;
            }
            if (this.layoutPattern.equals("T")) {
                if (textCtr == 0 && this.getElementType(textCtr).equalsIgnoreCase("checkbox")) {
                    return "<th id='is_selected" + this.objContext + "' isNonSortable='true' class='thClass' STYLE =\" left:2;  top:2;  width:17;\"><Input id='selectAll" + this.objContext + "' type='checkbox' name='selectAll' onClick='checkAll(" + this.objContext + ")'/></th>\n";
                }
                this.labelMap.put(name, text);
                return "<th id='" + name + "' name='" + name + "' class='thClass' STYLE = \"" + left + " " + top + " " + width + " " + visibilityValue + "\"><nobr>" + text + "<IMAGE id='" + name + textCtr + "01" + "' style='visibility:hidden' src='../images/" + this.displayTheme + "/upsimple.png'/> </nobr></th>\n";
            }
            if (this.layoutPattern.equals("F")) {
                return "<span id='" + name + "_t' name='" + name + "_t' class='editLabelClass' style='" + left + " " + top + " " + width + "position:absolute;'>" + text + "</span>\n";
            }
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return "";
    }

    private String dataFieldDisplay(int editTmplt, UserInfoBean userInfo) throws ITMException {
        StringBuffer dataFieldDisplayBuff = new StringBuffer();
        try {
            NodeList columnObjNodeList = this.dwDoc.getElementsByTagName("ColumnObject");
            int noOfColumnObjNodes = columnObjNodeList.getLength();
            if (this.layoutPattern.equalsIgnoreCase("T")) {
                HashMap<Integer, Object> columnObjMap = new HashMap<Integer, Object>();
                TreeMap<Integer, Object> sortedColumnObjMap = null;
                Set<Integer> sortedNodeKeys = null;
                int colObjCtr = 0;
                while (colObjCtr < noOfColumnObjNodes) {
                    Node currColumnObjNode = columnObjNodeList.item(colObjCtr);
                    if (currColumnObjNode.getNodeType() == 1 && currColumnObjNode.getFirstChild() != null) {
                        NodeList currColumnObjNodeList = currColumnObjNode.getChildNodes();
                        int noOfChildNodes = currColumnObjNodeList.getLength();
                        int noOfChildCtr = 0;
                        while (noOfChildCtr < noOfChildNodes) {
                            Node currChildNode = currColumnObjNodeList.item(noOfChildCtr);
                            if (currChildNode.getNodeName().equalsIgnoreCase("X")) {
                                HashMap<String, Object> tempMap = new HashMap<String, Object>();
                                tempMap.put("colObjCtr", colObjCtr);
                                tempMap.put("currColumnObjNode", currColumnObjNode);
                                if (columnObjMap.containsKey(new Integer(currChildNode.getTextContent()))) {
                                    columnObjMap.put(new Integer(String.valueOf(currChildNode.getTextContent()) + 1), tempMap);
                                } else {
                                    columnObjMap.put(new Integer(currChildNode.getTextContent()), tempMap);
                                }
                            }
                            ++noOfChildCtr;
                        }
                    }
                    ++colObjCtr;
                }
                sortedColumnObjMap = this.getSortColumnObjectMap(this.sortedTextMap, columnObjMap);
                sortedNodeKeys = sortedColumnObjMap.keySet();
                boolean isCheck = false;
                for (Integer eachNodeKey : sortedNodeKeys) {
                    Element currColumnObjElement;
                    Element editStyleTagElement;
                    HashMap tempMap = new HashMap();
                    tempMap = (HashMap)sortedColumnObjMap.get(eachNodeKey);
                    int colObjCtr2 = (Integer)tempMap.get("colObjCtr");
                    Node currColumnObjNode = (Node)tempMap.get("currColumnObjNode");
                    if (currColumnObjNode.getNodeType() == 1 && currColumnObjNode.getFirstChild() != null && !(editStyleTagElement = (Element)(currColumnObjElement = (Element)currColumnObjNode).getElementsByTagName("EditStyle").item(0)).getAttribute("style").equalsIgnoreCase("checkbox") && !isCheck && this.chkBoxClick) {
                        dataFieldDisplayBuff.append("<TD id='td_is_selected" + this.objContext + "{@domID}' name='td_is_selected" + this.objContext + "' fontCase=\"\" align=\"LEFT\" TABINDEX=\"10\" TABORDER=\"10\" MAXLENGTH=\"-1\" POPUPEXISTS=\"false\" protect=\"{is_selected/@protect}\" protectExpr=\"\" ISCHANGED=\"false\" onBlur=\"validateFld(this)\" onFocus=\"gotFocus(this,'brow2')\" style=\"\"> \n" + " <NOBR> \n" + " <xsl:choose><xsl:when test=\"@selected='Y'\">\n<INPUT id='is_selected" + this.objContext + "{@domID}' type='checkbox' onClick=\"checkUnchek(this);\" NAME=\"is_selected" + this.objContext + "\" fontCase=\"\" align=\"LEFT\" TABINDEX=\"10\" TABORDER=\"10\" MAXLENGTH=\"-1\" POPUPEXISTS=\"false\" protect=\"{is_selected/@protect}\" protectExpr=\"\" ISCHANGED=\"false\" onBlur=\"validateFld(this)\" onFocus=\"gotFocus(this,'brow2')\" style=\";TYPE:String;text-align:LEFT;\" checked = 'checked'></INPUT>\n" + " </xsl:when><xsl:otherwise>\n<INPUT id='is_selected" + this.objContext + "{@domID}' type='checkbox' onClick=\"checkUnchek(this);\" NAME=\"is_selected" + this.objContext + "\" fontCase=\"\" align=\"LEFT\" TABINDEX=\"10\" TABORDER=\"10\" MAXLENGTH=\"-1\" POPUPEXISTS=\"false\" protect=\"{is_selected/@protect}\" protectExpr=\"\" ISCHANGED=\"false\" onBlur=\"validateFld(this)\" onFocus=\"gotFocus(this,'brow2')\" style=\";TYPE:String;text-align:LEFT;\"></INPUT>" + " </xsl:otherwise></xsl:choose></NOBR></TD>");
                    }
                    isCheck = true;
                    dataFieldDisplayBuff.append(this.createColObj(currColumnObjNode, colObjCtr2, userInfo));
                }
            } else if (this.layoutPattern.equalsIgnoreCase("F")) {
                int colObjCtr = 0;
                while (colObjCtr < noOfColumnObjNodes) {
                    Node currColumnObjNode = columnObjNodeList.item(colObjCtr);
                    if (currColumnObjNode.getNodeType() == 1 && currColumnObjNode.getFirstChild() != null) {
                        dataFieldDisplayBuff.append(this.createColObj(currColumnObjNode, colObjCtr, userInfo));
                    }
                    ++colObjCtr;
                }
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception:[I18NLabel]:dataFieldDisplay " + e);
            throw new ITMException(e);
        }
        return dataFieldDisplayBuff.toString();
    }

    private String createColObj(Node colNode, int textCtr, UserInfoBean userInfo) throws ITMException {
        StringBuffer dataFieldDisBuff = null;
        StringBuffer styleStrBuff = null;
        StringBuffer addAttrBuff = null;
        String currentNodeValue = "";
        String colName = "";
        String elemType = "text";
        boolean isEditableCol = false;
        String dataType = "";
        boolean isPrimaryKey = false;
        boolean popUpTobeAdded = false;
        int tabIndex = -1;
        int xPos = -1;
        int yPos = -1;
        int width = -1;
        int limit = -1;
        String caseString = "";
        String protectString = "";
        String optionString = "";
        String requiredString = "";
        boolean isVisible = false;
        String maskStr = "";
        int noOfRows = -1;
        String alignStr = null;
        String autoVScroll = "";
        NodeList colNodeChildrenList = colNode.getChildNodes();
        int noOfcolNodeChildren = colNodeChildrenList.getLength();
        int colNodeChildCtr = 0;
        while (colNodeChildCtr < noOfcolNodeChildren) {
            Node currColChildNode = colNodeChildrenList.item(colNodeChildCtr);
            if (currColChildNode.getNodeType() == 1 && currColChildNode.getFirstChild() != null && !currColChildNode.getNodeName().equalsIgnoreCase("#text") && currColChildNode.getFirstChild() != null) {
                currentNodeValue = currColChildNode.getFirstChild().getNodeValue();
                if (currColChildNode.getNodeName().equalsIgnoreCase("NAME")) {
                    colName = currentNodeValue;
                } else if (currColChildNode.getNodeName().equalsIgnoreCase("TABSEQUENCE")) {
                    tabIndex = Integer.parseInt(currentNodeValue);
                } else if (this.layoutPattern.equalsIgnoreCase("F") && currColChildNode.getNodeName().equalsIgnoreCase("X")) {
                    xPos = Integer.parseInt(this.isUnits ? this.callWebservice(currentNodeValue, "X") : currentNodeValue);
                } else if (this.layoutPattern.equalsIgnoreCase("F") && currColChildNode.getNodeName().equalsIgnoreCase("Y")) {
                    yPos = Integer.parseInt(this.isUnits ? this.callWebservice(currentNodeValue, "Y") : currentNodeValue);
                } else if (currColChildNode.getNodeName().equalsIgnoreCase("WIDTH")) {
                    width = Integer.parseInt(this.isUnits ? this.callWebservice(currentNodeValue, "X") : currentNodeValue);
                } else if (currColChildNode.getNodeName().equalsIgnoreCase("EDITSTYLE")) {
                    Node styleAttrNode = currColChildNode.getAttributes().getNamedItem("style");
                    if (styleAttrNode != null) {
                        elemType = styleAttrNode.getNodeValue();
                    }
                    NodeList editStyleChildNodeList = currColChildNode.getChildNodes();
                    int noOfEditStyleChilds = editStyleChildNodeList.getLength();
                    int k = 0;
                    while (k < noOfEditStyleChilds) {
                        Node editStyleCurrChild = editStyleChildNodeList.item(k);
                        if (editStyleCurrChild.getNodeName().equalsIgnoreCase("MASK") && elemType.equalsIgnoreCase("editmask") && (maskStr = editStyleCurrChild.getFirstChild().getNodeValue()) != null) {
                            limit = maskStr.length();
                        }
                        if (editStyleCurrChild.getNodeName().equalsIgnoreCase("LIMIT")) {
                            limit = Integer.parseInt(editStyleCurrChild.getFirstChild().getNodeValue());
                        }
                        if (editStyleCurrChild.getNodeName().equalsIgnoreCase("case")) {
                            caseString = editStyleCurrChild.getFirstChild().getNodeValue();
                        }
                        if (editStyleCurrChild.getNodeName().equalsIgnoreCase("required")) {
                            requiredString = editStyleCurrChild.getFirstChild().getNodeValue();
                        }
                        if (editStyleCurrChild.getNodeName().equalsIgnoreCase("AUTOVSCROLL")) {
                            autoVScroll = editStyleCurrChild.getFirstChild().getNodeValue();
                        }
                        ++k;
                    }
                } else if (currColChildNode.getNodeName().equalsIgnoreCase("PROTECT")) {
                    protectString = currColChildNode.getAttributes().getNamedItem("expression").getNodeValue();
                } else if (currColChildNode.getNodeName().equalsIgnoreCase("visible")) {
                    if ("T".equalsIgnoreCase(this.layoutPattern)) {
                        boolean isColumnVisible = false;
                        isColumnVisible = this.getColumnObjectVisibility(colName, this.sortedTextMap);
                        isVisible = isColumnVisible;
                    } else {
                        isVisible = currentNodeValue.equals("1");
                    }
                } else if (currColChildNode.getNodeName().equalsIgnoreCase("HEIGHT")) {
                    noOfRows = Integer.parseInt(currentNodeValue) / 15;
                } else if (currColChildNode.getNodeName().equalsIgnoreCase("ALIGNMENT")) {
                    alignStr = currColChildNode.getFirstChild().getNodeValue();
                    if (alignStr.equals("0")) {
                        alignStr = "LEFT";
                    } else if (alignStr.equals("1")) {
                        alignStr = "RIGHT";
                    } else if (alignStr.equals("2")) {
                        alignStr = "CENTER";
                    } else if (alignStr.equals("3")) {
                        alignStr = "JUSTIFY";
                    }
                }
            }
            ++colNodeChildCtr;
        }
        isPrimaryKey = Boolean.valueOf((String)this.primarykeyMap.get(colName));
        dataType = (String)this.dataTypeMap.get(colName);
        dataFieldDisBuff = new StringBuffer();
        styleStrBuff = new StringBuffer();
        addAttrBuff = new StringBuffer();
        String newColName = this.globalColNameList.size() == 0 || this.globalColNameList.size() < textCtr ? colName : (String)this.globalColNameList.get(textCtr);
        addAttrBuff.append(" NAME=\"").append(newColName).append("\"");
        addAttrBuff.append(" fontCase=\"" + caseString + "\"");
        if ("T".equals(this.layoutPattern)) {
            if (!this.isCssFile) {
                styleStrBuff.append("color:#330000;background:#FFFFFF;");
            }
            styleStrBuff.append("width:" + width + ";");
            if (isVisible) {
                styleStrBuff.append("visibility:visible;");
            } else {
                styleStrBuff.append("visibility:hidden;");
            }
        } else if (!this.isCssFile) {
            if (isVisible) {
                styleStrBuff.append("position:absolute;top:" + yPos + ";left:" + xPos + ";width:" + width + ";visibility:visible;");
            } else {
                styleStrBuff.append("position:absolute;top:" + yPos + ";left:" + xPos + ";width:" + width + ";visibility:hidden;");
            }
        } else if (isVisible) {
            styleStrBuff.append("position:absolute;top:" + yPos + ";left:" + xPos + ";width:" + width + ";visibility:visible;");
        } else {
            styleStrBuff.append("position:absolute;top:" + yPos + ";left:" + xPos + ";width:" + width + ";visibility:hidden;");
        }
        String textAlign = "number".equalsIgnoreCase(dataType) ? "RIGHT" : "LEFT";
        addAttrBuff.append(" align=\"" + textAlign + "\"");
        BaseLogger.log("3", userInfo, null, "isPrimaryKey" + isPrimaryKey + "]");
        BaseLogger.log("3", userInfo, null, "this.editFlag" + this.editFlag + "]");
        BaseLogger.log("3", userInfo, null, "tabIndex" + tabIndex + "]");
        BaseLogger.log("3", userInfo, null, "this.scrEditMode.equals(" + this.scrEditMode.equals("1") + "]");
        if (isPrimaryKey) {
            if (this.editFlag.equalsIgnoreCase("A") && this.keyFlag.equalsIgnoreCase("M")) {
                isEditableCol = true;
            }
        } else if (tabIndex != 32766 && (this.editFlag.equalsIgnoreCase("E") || this.editFlag.equalsIgnoreCase("A"))) {
            isEditableCol = true;
        } else if (tabIndex != 32766 && this.scrEditMode.equals("1")) {
            isEditableCol = true;
        }
        if ("datetime".equalsIgnoreCase(dataType) || "date".equalsIgnoreCase(dataType) || limit == 0) {
            addAttrBuff.append(" TABINDEX=\"" + tabIndex + "\"").append(" TABORDER=\"" + tabIndex + "\"");
            if ("datetime".equalsIgnoreCase(dataType) || "date".equalsIgnoreCase(dataType) || "timestamp".equalsIgnoreCase(dataType)) {
                dataType = maskStr.toLowerCase().startsWith("hh:mm:ss") ? "time" : (maskStr.toLowerCase().indexOf("hh:mm:ss") != -1 ? "datetime" : "date");
            }
        } else {
            addAttrBuff.append(" TABINDEX=\"" + tabIndex + "\"").append(" TABORDER=\"" + tabIndex + "\"").append(" MAXLENGTH=\"" + limit + "\"");
        }
        if (elemType.equalsIgnoreCase("ddlb")) {
            if (this.optionMap.size() == 0) {
                this.getOptionString(isPrimaryKey, tabIndex);
            }
            isEditableCol = true;
        }
        optionString = (String)this.optionMap.get(colName);
        if (isEditableCol) {
            styleStrBuff.append(";TYPE:" + dataType + ";text-align:" + textAlign);
            this.popUpHandler = new PopUpHandler(userInfo);
            String popUpString = this.popUpHandler.getFieldPopUpXML(colName, this.objName, this.pageContext);
            if (popUpString != null && !elemType.equalsIgnoreCase("ddlb")) {
                addAttrBuff.append(" POPUPEXISTS=\"true\"");
                if (popUpString.equalsIgnoreCase("NOPARAM")) {
                    addAttrBuff.append(" POPUPPARAMETERS=\"NULL\"");
                } else {
                    addAttrBuff.append(" POPUPPARAMETERS=\"" + popUpString + "\"");
                }
            } else {
                addAttrBuff.append(" POPUPEXISTS=\"false\"");
            }
            addAttrBuff.append(" protect=\"{").append(colName).append("/@protect}\"").append(" protectExpr=\"" + protectString + "\"");
            if (this.pageContext.equalsIgnoreCase("1")) {
                if (this.objContext.equalsIgnoreCase("1")) {
                    addAttrBuff.append(" ISCHANGED=\"false\"").append(" onBlur=\"validateFld(this").append(")\" onFocus=\"gotFocus(this,'brow')\"");
                } else {
                    addAttrBuff.append(" ISCHANGED=\"false\"").append(" onBlur=\"validateFld(this").append(")\" onFocus=\"gotFocus(this,'brow").append(this.objContext).append("')\"");
                }
            } else {
                addAttrBuff.append(" ISCHANGED=\"false\"").append(" onBlur=\"validateFld(this").append(")\" onFocus=\"gotFocus(this,'detail')\"");
            }
            if (this.itemChangeList != null && this.itemChangeList.contains(colName)) {
                addAttrBuff.append(" SRVCALLONCHANGE=\"true\"");
            }
            if ("T".equals(this.layoutPattern)) {
                if (!this.scrEditMode.equals("1")) {
                    dataFieldDisBuff.append("<TD>\n");
                } else {
                    dataFieldDisBuff.append("\n<TD id='td_").append(newColName).append("{@domID}'").append(addAttrBuff.toString()).append(" style=\"").append(styleStrBuff.toString()).append("\">\n<NOBR>\n");
                }
            } else {
                addAttrBuff.append(" REQUIRED=\"" + requiredString + "\"");
                if (!this.isCssFile) {
                    addAttrBuff.append(" class=\"" + currentNodeValue + "\"");
                } else {
                    addAttrBuff.append(" class=\"editInputClass\"");
                }
            }
            if (autoVScroll.equalsIgnoreCase("yes")) {
                addAttrBuff.append(" rows=\"" + noOfRows + "\" ");
                dataFieldDisBuff.append("<TEXTAREA ").append(addAttrBuff.toString()).append(" style=\"").append(styleStrBuff.toString()).append("\">\n");
                dataFieldDisBuff.append("<xsl:value-of select='").append(colName).append("'/>\n");
                dataFieldDisBuff.append("</TEXTAREA>\n");
            } else if (elemType.equalsIgnoreCase("ddlb")) {
                if ("T".equals(this.layoutPattern)) {
                    dataFieldDisBuff.append("<xsl:choose>");
                    dataFieldDisBuff.append("<xsl:when test=\"not(" + newColName + "/@visible='0')\">\n");
                    dataFieldDisBuff.append("<SELECT id='").append(newColName).append("{@domID}'").append(addAttrBuff.toString()).append(" domId='{@domID}' style=\"").append(styleStrBuff.toString()).append("\">\n");
                    dataFieldDisBuff.append(optionString).append("\n");
                    dataFieldDisBuff.append("</SELECT>\n");
                    dataFieldDisBuff.append("</xsl:when>\n");
                    dataFieldDisBuff.append("<xsl:otherwise>\n");
                    dataFieldDisBuff.append("</xsl:otherwise>\n");
                    dataFieldDisBuff.append("</xsl:choose>");
                } else {
                    dataFieldDisBuff.append("<SELECT id='").append(newColName).append("{@domID}'").append(addAttrBuff.toString()).append(" domId='{@domID}' style=\"").append(styleStrBuff.toString()).append("\">\n");
                    dataFieldDisBuff.append(optionString).append("\n");
                    dataFieldDisBuff.append("</SELECT>\n");
                }
            } else {
                String dateType;
                BaseLogger.log("3", userInfo, null, "%%%%[" + elemType + "]");
                if (elemType.equalsIgnoreCase("checkbox")) {
                    dataFieldDisBuff.append("<INPUT").append(" type='checkbox'").append(" style=\"").append(styleStrBuff.toString()).append("\" id='is_selected" + this.objContext + "{@domID}' onClick='checkUnchek(this);' NAME='is_selected" + this.objContext + "' >\n");
                } else {
                    dataFieldDisBuff.append("<xsl:variable name=\"myvar\">\n");
                    dataFieldDisBuff.append("<xsl:value-of select='" + newColName + "'/>\n");
                    dataFieldDisBuff.append("</xsl:variable>");
                    addAttrBuff.append(" domId = \"{@domID}\"");
                    addAttrBuff.append(" localDomId = '").append(newColName).append("{$localDomId}'");
                    if ("T".equals(this.layoutPattern)) {
                        dataFieldDisBuff.append("<INPUT value = \"{$myvar }\" type=\"text\"").append(" class='trEditInputClass' id=\"").append(newColName).append("{@domID}\"").append(addAttrBuff.toString()).append(" style=\"").append(styleStrBuff.toString()).append("\" size='").append(width).append("' title=\"Please enter a value.\"  coltype=\"" + dataType + "\">\n");
                    } else {
                        dataFieldDisBuff.append("<INPUT value = \"{$myvar }\" type=\"text\"").append(" id=\"").append(newColName).append("{@domID}\"").append(addAttrBuff.toString()).append(" style=\"").append(styleStrBuff.toString()).append("\" size='").append(width).append("' title=\"Please enter a value.\"  coltype=\"" + dataType + "\">\n");
                    }
                }
                if (!this.scrEditMode.equals("1")) {
                    dataFieldDisBuff.append("<xsl:attribute name=\"value\">\n");
                    dataFieldDisBuff.append("<xsl:value-of select='").append(colName).append("'/>\n");
                    dataFieldDisBuff.append("</xsl:attribute>\n");
                }
                dataFieldDisBuff.append("</INPUT>\n");
                if ("T".equals(this.layoutPattern) && ("datetime".equalsIgnoreCase(dateType = (String)this.dataTypeMap.get(colName)) || "date".equalsIgnoreCase(dateType))) {
                    dataFieldDisBuff.append("<div id=\"calender{@domID}\" NAME=\"calender{@domID}\" title=\"Click to see calender\" class=\"calender-Btn calender-Btn-Dtl\" border=\"0\" z-index=\"1\" ").append(" onClick=\"setDateWithPropagation(event,this);\"").append(" style=\"visibility:visible\" coltype=\"" + dataType + "\" localDomId='" + newColName + "{$localDomId}'>").append("</div>");
                }
                if (popUpString != null && !this.objContext.equalsIgnoreCase("1")) {
                    dataFieldDisBuff.append("<div id=\"PopUp" + colName + "{@domID}\" NAME=\"PopUp" + colName + "{@domID}\" title=\"Click to see list of values for this column in a pop up window\" class=\"pophelp-Btn\" border=\"0\" z-index=\"1\" ").append(" onClick=\"getPopupData(this)\"").append(" style=\"visibility:visible; display:inline;\"  localDomId='" + newColName + "{$localDomId}'>").append("</div>");
                }
            }
            if ("T".equals(this.layoutPattern)) {
                if (!this.scrEditMode.equals("1")) {
                    dataFieldDisBuff.append("</TD>\n");
                } else {
                    dataFieldDisBuff.append("</NOBR>\n</TD>");
                }
            }
        } else {
            addAttrBuff.append(" protect = '1' ");
            if ("T".equals(this.layoutPattern)) {
                if (alignStr != null && alignStr.length() > 0) {
                    alignStr = " align=\"" + alignStr + "\" ";
                }
                dataFieldDisBuff.append("\n<TD id='td_").append(newColName).append("{@domID}'").append(addAttrBuff.toString()).append(" style=\"").append(styleStrBuff.toString()).append("\">\n<NOBR>\n");
                if (elemType.equalsIgnoreCase("ddlb")) {
                    dataFieldDisBuff.append("<xsl:choose>");
                    dataFieldDisBuff.append("<xsl:when test=\"" + newColName + "/@visible='1'\">\n");
                    if (this.itemChangeList != null && this.itemChangeList.contains(colName)) {
                        addAttrBuff.append(" SRVCALLONCHANGE='true'");
                        styleStrBuff.append(";TYPE:" + dataType + ";text-align:" + textAlign);
                        if (this.pageContext.equalsIgnoreCase("1")) {
                            if (this.objContext.equalsIgnoreCase("1")) {
                                addAttrBuff.append(" ISCHANGED='false'").append(" onBlur='validateFld(this)' onFocus=\"gotFocus(this,'brow')\"");
                            } else {
                                addAttrBuff.append(" ISCHANGED='false'").append(" onBlur='validateFld(this)' onFocus=\"gotFocus(this,'brow").append(this.objContext).append("')\"");
                            }
                        } else {
                            addAttrBuff.append(" ISCHANGED='false'").append(" onBlur='validateFld(this)' onFocus=\"gotFocus(this,'detail')\"");
                        }
                    }
                    dataFieldDisBuff.append("<SELECT id='").append(newColName).append("{@domID}'").append(addAttrBuff.toString()).append(" domId='{@domID}'  style=\"").append(styleStrBuff.toString()).append("\" >\n");
                    dataFieldDisBuff.append(optionString).append("\n");
                    dataFieldDisBuff.append("</SELECT>\n");
                    dataFieldDisBuff.append("</xsl:when>\n");
                    dataFieldDisBuff.append("<xsl:otherwise>\n");
                    dataFieldDisBuff.append("</xsl:otherwise>\n");
                    dataFieldDisBuff.append("</xsl:choose>");
                } else {
                    dataFieldDisBuff.append("<xsl:choose>");
                    dataFieldDisBuff.append("<xsl:when test=\"" + newColName + "/@visible='1'\">\n");
                    addAttrBuff.append(" domId=\"{@domID}\"");
                    if (this.itemChangeList != null && this.itemChangeList.contains(colName)) {
                        addAttrBuff.append(" SRVCALLONCHANGE=\"true\"");
                    }
                    styleStrBuff.append(";TYPE:" + dataType + ";text-align:" + textAlign);
                    if (this.pageContext.equalsIgnoreCase("1")) {
                        if (this.objContext.equalsIgnoreCase("1")) {
                            addAttrBuff.append(" ISCHANGED=\"false\"").append(" onBlur=\"validateFld(this").append(")\" onFocus=\"gotFocus(this,'brow')\"");
                        } else {
                            addAttrBuff.append(" ISCHANGED=\"false\"").append(" onBlur=\"validateFld(this").append(")\" onFocus=\"gotFocus(this,'brow").append(this.objContext).append("')\"");
                        }
                    } else {
                        addAttrBuff.append(" ISCHANGED=\"false\"").append(" onBlur=\"validateFld(this").append(")\" onFocus=\"gotFocus(this,'detail')\"");
                    }
                    dataFieldDisBuff.append("<xsl:choose>");
                    dataFieldDisBuff.append("<xsl:when test=\"" + newColName + "/@protect='1'\">\n");
                    dataFieldDisBuff.append("<INPUT").append(" class='trEditInputClass' ").append(" id='").append(newColName).append("{@domID}'").append(" value='{" + newColName + "}' type='text' readOnly='true' label=").append("'" + this.labelMap.get(newColName) + "'").append(addAttrBuff.toString()).append(" REQUIRED='YES'").append(" style=\"visibility:hidden;").append(styleStrBuff.toString()).append("\" size='").append(width).append("' title=\"Please enter a value.\"  coltype=\"" + dataType + "\">\n");
                    dataFieldDisBuff.append("</INPUT>\n");
                    dataFieldDisBuff.append("</xsl:when>\n");
                    dataFieldDisBuff.append("<xsl:otherwise>\n");
                    dataFieldDisBuff.append("<INPUT").append(" class='trEditInputClass' ").append(" id='").append(newColName).append("{@domID}'").append(" value='{" + newColName + "}' type='text'").append(addAttrBuff.toString()).append(" style=\"").append(styleStrBuff.toString()).append("\" size='").append(width).append("' title=\"Please enter a value.\"  coltype=\"" + dataType + "\">\n");
                    dataFieldDisBuff.append("</INPUT>\n");
                    dataFieldDisBuff.append("</xsl:otherwise>\n");
                    dataFieldDisBuff.append("</xsl:choose>");
                    dataFieldDisBuff.append("</xsl:when>\n");
                    dataFieldDisBuff.append("<xsl:otherwise>\n");
                    if (dataType.equalsIgnoreCase("number")) {
                        if (maskStr != null && maskStr.length() > 0) {
                            dataFieldDisBuff.append("<xsl:variable name=\"numVal\"><xsl:value-of select=\"format-number(" + newColName + ",'" + maskStr + "')\"/></xsl:variable>\n");
                            dataFieldDisBuff.append("<xsl:choose>\n<xsl:when test=\"normalize-space($numVal)='NaN'\">");
                            dataFieldDisBuff.append("</xsl:when>\n<xsl:otherwise>");
                            dataFieldDisBuff.append("<xsl:value-of select=\"$numVal\"/>");
                            dataFieldDisBuff.append("</xsl:otherwise>\n</xsl:choose>\n");
                        } else {
                            dataFieldDisBuff.append("<xsl:value-of select='" + newColName + "'/>\n");
                        }
                    } else {
                        dataFieldDisBuff.append("<xsl:value-of select='" + newColName + "'/>\n");
                    }
                    dataFieldDisBuff.append("</xsl:otherwise>\n");
                    dataFieldDisBuff.append("</xsl:choose>");
                }
                dataFieldDisBuff.append("</NOBR>\n</TD>\n");
            } else {
                styleStrBuff.append(" text-align:" + textAlign + ";");
                addAttrBuff.append(" readOnly=\"true\" class=\"editDisplayClass\"");
                dataFieldDisBuff.append("<INPUT id='").append(newColName).append("{@domID}'").append(addAttrBuff.toString()).append(" style=\"").append(styleStrBuff.toString()).append("\" onFocus=\"gotFocus(this,'brow')\"").append(">\n");
                dataFieldDisBuff.append("<xsl:attribute name=\"value\">\n");
                if (elemType.equalsIgnoreCase("ddlb")) {
                    dataFieldDisBuff.append(optionString);
                } else {
                    dataFieldDisBuff.append("<xsl:value-of select='").append(colName).append("'/>\n");
                }
                dataFieldDisBuff.append("</xsl:attribute>\n");
                dataFieldDisBuff.append("</INPUT>\n");
            }
        }
        String dataFieldDis = dataFieldDisBuff.toString();
        addAttrBuff.delete(0, addAttrBuff.length());
        styleStrBuff.delete(0, styleStrBuff.length());
        dataFieldDisBuff.delete(0, dataFieldDisBuff.length());
        return dataFieldDis;
    }

    private void getOptionString(boolean isPrimaryKey, int tabIndex) throws ITMException {
        try {
            NodeList tableColumn = this.dwDoc.getElementsByTagName("table_column");
            int i = 0;
            while (i < tableColumn.getLength()) {
                Node eachColumn = tableColumn.item(i);
                NodeList eachColumnDetail = eachColumn.getChildNodes();
                String keyFlag = "false";
                String pkValue = "";
                String columntype = "";
                String optString = "";
                int j = 0;
                while (j < eachColumnDetail.getLength()) {
                    if (eachColumnDetail.item(j).getNodeName().equalsIgnoreCase("name")) {
                        pkValue = eachColumnDetail.item(j).getFirstChild().getNodeValue();
                    } else if (eachColumnDetail.item(j).getNodeName().equalsIgnoreCase("values")) {
                        Node opt = eachColumnDetail.item(j);
                        NodeList values = opt.getChildNodes();
                        boolean flag = true;
                        int ctr1 = 0;
                        while (ctr1 < values.getLength()) {
                            if (values.item(ctr1).getNodeName().equals("item")) {
                                NamedNodeMap nMap1 = values.item(ctr1).getAttributes();
                                String data1 = nMap1.getNamedItem("data").getNodeValue();
                                if (values.item(ctr1).getNodeName().equals("item")) {
                                    NamedNodeMap nMap = values.item(ctr1).getAttributes();
                                    String data = nMap.getNamedItem("data").getNodeValue();
                                    optString = String.valueOf(optString) + "<OPTION value=\"" + data + "\"><xsl:choose><xsl:when test=\"" + pkValue + "='" + data + "'\"><xsl:attribute name=\"selected\"/></xsl:when></xsl:choose><![CDATA[" + nMap.getNamedItem("display").getNodeValue() + "]]></OPTION>\n";
                                }
                            }
                            ++ctr1;
                        }
                    }
                    ++j;
                }
                this.optionMap.put(new String(pkValue), new String(optString));
                ++i;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Error In 18NLabel.getOptionString()");
            throw new ITMException(e);
        }
    }

    private void setProperties() throws ITMException {
        this.primarykeyMap = new HashMap();
        this.dataTypeMap = new HashMap();
        this.optionMap = new HashMap();
        try {
            NodeList table_column = this.dwDoc.getElementsByTagName("table_column");
            int i = 0;
            while (i < table_column.getLength()) {
                Node eachColumn = table_column.item(i);
                NodeList eachColumnDetail = eachColumn.getChildNodes();
                String keyFlag = "false";
                String pkValue = "";
                String columntype = "";
                String optString = "";
                int j = 0;
                while (j < eachColumnDetail.getLength()) {
                    if (!eachColumnDetail.item(j).getNodeName().equalsIgnoreCase("#text") && eachColumnDetail.item(j).getFirstChild() != null) {
                        if (eachColumnDetail.item(j).getNodeName().equalsIgnoreCase("type")) {
                            columntype = eachColumnDetail.item(j).getFirstChild().getNodeValue();
                            columntype = columntype.equalsIgnoreCase("char") || columntype.equalsIgnoreCase("String") ? "String" : (columntype.equalsIgnoreCase("datetime") ? "datetime" : (columntype.equalsIgnoreCase("date") ? "date" : "number"));
                        } else if (eachColumnDetail.item(j).getNodeName().equalsIgnoreCase("key")) {
                            keyFlag = "true";
                        } else if (eachColumnDetail.item(j).getNodeName().equalsIgnoreCase("name")) {
                            pkValue = eachColumnDetail.item(j).getFirstChild().getNodeValue();
                        }
                    }
                    ++j;
                }
                this.primarykeyMap.put(new String(pkValue), new String(keyFlag));
                this.dataTypeMap.put(new String(pkValue), new String(columntype));
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            BaseLogger.log("0", null, null, " Error in I18NLabel:setProperties()" + e);
        }
    }

    private String callWebservice(String units, String value) {
        String ret = "";
        return ret;
    }

    private ArrayList getElemItemChangeList(String objName, String formNo, UserInfoBean userInfo) throws ITMException {
        ArrayList itemChangeList = new ArrayList();
        try {
            AppConnectParm appConnect = new AppConnectParm();
            Properties p = appConnect.getProperty();
            InitialContext ctx = new InitialContext(p);
            DBAccessEJB dbAccess = new DBAccessEJB();
            itemChangeList = dbAccess.getItemChangeElementList(objName, formNo, userInfo);
            dbAccess.remove();
            dbAccess = null;
        }
        catch (Exception e) {
            BaseLogger.log("0", userInfo, null, "Error In 18NLabel.getElemItemChangeList()");
            throw new ITMException(e);
        }
        return itemChangeList;
    }

    public DW2XSLGenerator(String objName, String objContext, String pageContext, String editFlag, UserInfoBean userInfo) throws ITMException {
        this.editFlag = editFlag;
        try {
            E12GenericUtility genericUtility = new E12GenericUtility();
            this.displayTheme = genericUtility.getThemeFormat();
            this.initProps(objName, objContext, pageContext, editFlag, userInfo);
        }
        catch (ITMException itme) {
            throw itme;
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
    }

    private boolean initProps(String objName, String objContext, String pageContext, String editFlag, UserInfoBean userInfo) throws ITMException {
        try {
            this.objName = objName;
            this.objContext = objContext;
            this.pageContext = pageContext;
            this.scrEditMode = "0";
            this.layoutPattern = "F";
            InitialContext initialContext = new InitialContext(new AppConnectParm().getProperty());
            DBAccessEJB dbAccess = new DBAccessEJB();
            BaseLogger.log("3", userInfo, null, "initProps UserInfo called..." + userInfo.toString());
            HashMap objViewDetailMap = dbAccess.getObjViewDetailMap(objName, objContext, userInfo);
            if (objViewDetailMap != null) {
                this.keyFlag = objViewDetailMap.get("KEY_FLAG") != null ? (String)objViewDetailMap.get("KEY_FLAG") : "M";
                this.confirmCol = objViewDetailMap.get("CONFIRM_COL") != null ? (String)objViewDetailMap.get("CONFIRM_COL") : "";
                this.confirmVal = objViewDetailMap.get("CONFIRM_VAL") != null ? (String)objViewDetailMap.get("CONFIRM_VAL") : "";
                this.editOpt = objViewDetailMap.get("EDIT_OPT") != null ? (String)objViewDetailMap.get("EDIT_OPT") : this.editOpt;
                String scrFlag = objViewDetailMap.get("SCR_FLAG") != null ? (String)objViewDetailMap.get("SCR_FLAG") : this.editOpt;
                boolean bl = this.chkBoxClick = objViewDetailMap.get("SELECTION_OPT") != null && "0".equalsIgnoreCase((String)objViewDetailMap.get("SELECTION_OPT"));
                if (scrFlag != null) {
                    StringTokenizer strTokens = new StringTokenizer(scrFlag, ",");
                    while (strTokens.hasMoreTokens()) {
                        String currToken = strTokens.nextToken();
                        if (currToken.startsWith("T")) {
                            this.layoutPattern = "T";
                        } else if (currToken.startsWith("F")) {
                            this.layoutPattern = "F";
                        }
                        if (currToken.endsWith("E")) {
                            this.scrEditMode = "1";
                            continue;
                        }
                        if (!currToken.endsWith("V")) continue;
                        this.scrEditMode = "2";
                    }
                } else if ("1".equals(this.pageContext)) {
                    this.layoutPattern = "T";
                } else if ("2".equals(this.pageContext)) {
                    this.layoutPattern = "F";
                }
            }
            BaseLogger.log("3", userInfo, null, "layoutPattern[" + this.layoutPattern + "]");
            boolean isTaxApplicable = false;
            if (editFlag.equalsIgnoreCase("E") || editFlag.equalsIgnoreCase("A") || this.scrEditMode.equals("1")) {
                this.itemChangeList = this.getElemItemChangeList(this.objName, this.objContext, userInfo);
            }
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            dbf.setIgnoringComments(this.ignoreComments);
            DocumentBuilder db = dbf.newDocumentBuilder();
            OutputStreamWriter errorWriter = new OutputStreamWriter((OutputStream)System.err, outputEncoding);
            String fileName = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "server" + File.separator + "default" + File.separator + "deploy" + File.separator + "ibase.ear" + File.separator + "metadata" + File.separator + this.objName + this.pageContext + this.objContext + ".xml";
            File dwFile = new File(fileName);
            if (!dwFile.exists()) {
                throw new Exception("Metadata file :[" + dwFile.getAbsolutePath() + "] not found");
            }
            this.dwDoc = db.parse(dwFile);
            NodeList unitList = this.dwDoc.getElementsByTagName("units");
            if (unitList.getLength() > 0 && unitList.item(0).getFirstChild() != null && "0".equals(unitList.item(0).getFirstChild().getNodeValue())) {
                this.isPBUnits = true;
            }
            this.var = String.valueOf(this.objName) + this.pageContext + this.objContext;
            this.country = this.country;
            this.language = this.language;
            BaseLogger.log("3", userInfo, null, "this.var[" + this.var + "]this.country" + this.country + "]this.language[" + this.language + "]");
            dbAccess = null;
        }
        catch (ITMException itme) {
            throw itme;
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return true;
    }

    public boolean getColumnObjectVisibility(String currColName, TreeMap<Integer, Object> sortedTextNodeMap) {
        boolean isColumnVisibile = false;
        Set<Integer> sortedNodeKeys = null;
        sortedNodeKeys = sortedTextNodeMap.keySet();
        for (Integer eachNodeKey : sortedNodeKeys) {
            HashMap tempMap = new HashMap();
            tempMap = (HashMap)sortedTextNodeMap.get(eachNodeKey);
            int textNodeCtr = (Integer)tempMap.get("textNodeCtr");
            Node currTextNode = (Node)tempMap.get("currTextNode");
            if (currTextNode.getNodeType() != 1 || currTextNode.getFirstChild() == null) continue;
            Element currTextElement = (Element)currTextNode;
            Element colNameElement = (Element)currTextElement.getElementsByTagName("name").item(0);
            String colVisibleValue = currTextElement.getElementsByTagName("visible").item(0).getTextContent();
            if (!colNameElement.getTextContent().equalsIgnoreCase(String.valueOf(currColName) + "_t")) continue;
            boolean bl = isColumnVisibile = "1".equalsIgnoreCase(colVisibleValue);
        }
        return isColumnVisibile;
    }

    public TreeMap<Integer, Object> getSortColumnObjectMap(TreeMap<Integer, Object> sortedTextNodeMap, HashMap<Integer, Object> columnObjMap) {
        TreeMap<Integer, Object> columnObjectMap = new TreeMap<Integer, Object>();
        Set<Integer> sortedNodeKeys = null;
        Set<Integer> sortedColObjKeys = null;
        sortedNodeKeys = sortedTextNodeMap.keySet();
        for (Integer eachNodeKey : sortedNodeKeys) {
            HashMap tempMap1 = (HashMap)this.sortedTextMap.get(eachNodeKey);
            Node currTextNode = (Node)tempMap1.get("currTextNode");
            Element currTextElement = (Element)currTextNode;
            String currTextNodeName = currTextElement.getElementsByTagName("name").item(0).getTextContent();
            sortedColObjKeys = columnObjMap.keySet();
            for (Integer eachColObjKey : sortedColObjKeys) {
                HashMap tempMap2 = (HashMap)columnObjMap.get(eachColObjKey);
                Node currColNode = (Node)tempMap2.get("currColumnObjNode");
                Element currColElement = (Element)currColNode;
                String currColNodeName = currColElement.getElementsByTagName("name").item(0).getTextContent();
                if (!(currColNodeName = String.valueOf(currColNodeName) + "_t").equalsIgnoreCase(currTextNodeName)) continue;
                columnObjectMap.put(eachNodeKey, tempMap2);
            }
        }
        return columnObjectMap;
    }
}

