/*
 * Decompiled with CFR 0.152.
 */
package ibase.utility;

import SessionManager.Factory;
import SessionManager.FactoryHelper;
import SessionManager.Manager;
import SessionManager.ManagerHelper;
import SessionManager.Session;
import ibase.system.config.AppConnectParm;
import ibase.utility.ApplicationParams;
import ibase.utility.BaseException;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import java.io.File;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import webitm4.nvo_business_object_win_methods;
import webitm4.nvo_business_object_win_methodsHelper;

public class ApplicationInvoker {
    ApplicationParams applnParams = null;

    public ApplicationInvoker(String applnParamXML) throws BaseException {
        this.applnParams = new ApplicationParams(applnParamXML);
    }

    public ApplicationInvoker(ApplicationParams applnParams) throws BaseException {
        this.applnParams = applnParams;
    }

    public String invokeApplication() throws BaseException {
        BaseLogger.log("2", null, null, "Application Invoked..");
        String retString = "";
        Connection conn = null;
        try {
            retString = this.invokeApplication(conn);
        }
        catch (BaseException be) {
            be.printStackTrace();
            retString = "<ROOT><STATUS><![CDATA[0]]></STATUS><RESULT><![CDATA[" + be.getMessage() + "]]></RESULT></ROOT>";
        }
        catch (Exception e) {
            e.printStackTrace();
            retString = "<ROOT><STATUS><![CDATA[0]]></STATUS><RESULT><![CDATA[" + e.getMessage() + "]]></RESULT></ROOT>";
        }
        return retString;
    }

    public String invokeApplication(Connection conn) throws BaseException {
        BaseLogger.log("2", null, null, "Application Invoked..");
        String retString = "";
        try {
            String applnType = this.applnParams.getApplnType();
            if (applnType.equals("EJB")) {
                retString = this.invokeEJB(conn);
            } else if (applnType.equals("JB")) {
                retString = this.invokeJB(conn);
            } else if (applnType.equals("NVO")) {
                retString = this.invokeNVO(conn);
            }
        }
        catch (BaseException be) {
            be.printStackTrace();
            retString = "<ROOT><STATUS><![CDATA[0]]></STATUS><RESULT><![CDATA[" + be.getMessage() + "]]></RESULT></ROOT>";
        }
        catch (Exception e) {
            e.printStackTrace();
            retString = "<ROOT><STATUS><![CDATA[0]]></STATUS><RESULT><![CDATA[" + e.getMessage() + "]]></RESULT></ROOT>";
        }
        return retString;
    }

    private String invokeEJB(Connection conn) throws BaseException {
        BaseLogger.log("2", null, null, "ApplicationInvoker.invokeEJB()");
        String returnValue = null;
        String status = "1";
        try {
            LinkedHashMap<String, java.lang.Object> connParamMap = new LinkedHashMap<String, java.lang.Object>();
            String applnName = this.applnParams.getApplnName();
            String methodName = this.applnParams.getMethodName();
            ArrayList paramList = this.applnParams.getParamList();
            if (conn != null && ("ibase.wrkflw.TransSave".equals(applnName) && ("saveChangeInTrans".equals(methodName) || "saveAllChangeInTrans".equals(methodName)) || "ibase.wrkflw.SignTrans".equals(applnName) && ("insertSign".equals(methodName) || "insertSignCtx".equals(methodName)) || "ibase.utility.ExecuteQuery".equals(applnName) && "executeQuery".equalsIgnoreCase(methodName) || "ibase.utility.EMail".equalsIgnoreCase(applnName) && "sendMail".equalsIgnoreCase(methodName) || "ibase.wrkflw.utility.PerformCondition".equals(applnName) && "performCondition".equals(methodName) || "ibase.wrkflw.utility.JoinActivity".equals(applnName) && "join".equals(methodName) || "ibase.wrkflw.utility.AbortWorkflow".equals(applnName) && "abortWrkflw".equals(methodName))) {
                connParamMap.put("PARAM_DATA_TYPE", "java.sql.Connection");
                connParamMap.put("PARAM_VALUE", conn);
                paramList.add(connParamMap);
            }
            int noOfParams = paramList.size();
            BaseLogger.log("3", null, null, "noOfParams :" + noOfParams);
            Class[] paramSpec = new Class[noOfParams];
            java.lang.Object[] params = new java.lang.Object[noOfParams];
            int paramCtr = 0;
            while (paramCtr < noOfParams) {
                HashMap currParamMap = (HashMap)paramList.get(paramCtr);
                String dataType = (String)currParamMap.get("PARAM_DATA_TYPE");
                paramSpec[paramCtr] = dataType != null && "java.sql.Connection".equals(dataType) ? Class.forName("java.sql.Connection") : Class.forName("java.lang.String");
                params[paramCtr] = (String)currParamMap.get("PARAM_VALUE");
                ++paramCtr;
            }
            AppConnectParm appConnect = new AppConnectParm();
            Properties p = appConnect.getProperty();
            InitialContext ctx = new InitialContext(p);
            java.lang.Object comp = null;
            String lookUpName = "ibase/" + applnName + "/" + "local";
            BaseLogger.log("3", null, null, "invokeEJB:lookUpName [" + lookUpName + "]");
            Class<?> classObj = Class.forName(ctx.lookup(lookUpName).getClass().getName());
            BaseLogger.log("3", null, null, "Component Found !!!");
            Method metObj = classObj.getMethod(methodName, paramSpec);
            metObj.setAccessible(true);
            returnValue = (String)metObj.invoke(ctx.lookup(lookUpName), params);
        }
        catch (BaseException be) {
            status = "0";
            returnValue = "<ROOT><STATUS><![CDATA[" + status + "]]></STATUS><RESULT><![CDATA[" + be.getMessage() + "]]></RESULT></ROOT>";
            be.printStackTrace();
            BaseLogger.log("0", null, null, "Exception Occured");
        }
        catch (Exception e) {
            status = "0";
            e.printStackTrace();
            returnValue = "<ROOT><STATUS><![CDATA[" + status + "]]></STATUS><RESULT><![CDATA[" + e.getMessage() + "]]></RESULT></ROOT>";
        }
        return returnValue;
    }

    private String invokeJB(Connection conn) throws BaseException {
        BaseLogger.log("2", null, null, "ApplicationInvoker.invokeJB()");
        String returnValue = null;
        String status = "1";
        try {
            LinkedHashMap<String, java.lang.Object> connParamMap = new LinkedHashMap<String, java.lang.Object>();
            String applnName = this.applnParams.getApplnName();
            String compName = this.applnParams.getCompName();
            String methodName = this.applnParams.getMethodName();
            ArrayList paramList = this.applnParams.getParamList();
            if (compName == null) {
                compName = applnName;
            }
            if (conn != null && ("ibase.wrkflw.utility.TransSave".equals(compName) && ("saveChangeInTrans".equals(methodName) || "saveAllChangeInTrans".equals(methodName)) || "ibase.wrkflw.utility.SignTrans".equals(compName) && ("insertSign".equals(methodName) || "insertSignCtx".equals(methodName)) || "ibase.utility.ExecuteQuery".equals(compName) && "executeQuery".equals(methodName) || "ibase.utility.EMail".equalsIgnoreCase(compName) && "sendMail".equals(methodName) || "ibase.wrkflw.utility.PerformCondition".equals(compName) && "performCondition".equals(methodName) || "ibase.wrkflw.utility.JoinActivity".equals(compName) && "join".equals(methodName) || "ibase.wrkflw.utility.AbortWorkflow".equals(compName) && "abortWrkflw".equals(methodName))) {
                connParamMap.put("PARAM_DATA_TYPE", "java.sql.Connection");
                connParamMap.put("PARAM_VALUE", conn);
                paramList.add(connParamMap);
            }
            int noOfParams = paramList.size();
            BaseLogger.log("3", null, null, "noOfParams :" + noOfParams);
            BaseLogger.log("3", null, null, "paramList length :[" + paramList.size() + "]");
            Class[] paramSpec = new Class[noOfParams];
            java.lang.Object[] params = new java.lang.Object[noOfParams];
            int paramCtr = 0;
            while (paramCtr < noOfParams) {
                HashMap currParamMap = (HashMap)paramList.get(paramCtr);
                String dataType = (String)currParamMap.get("PARAM_DATA_TYPE");
                if (dataType != null && "java.sql.Connection".equals(dataType)) {
                    paramSpec[paramCtr] = Class.forName("java.sql.Connection");
                    params[paramCtr] = (Connection)currParamMap.get("PARAM_VALUE");
                } else {
                    paramSpec[paramCtr] = Class.forName("java.lang.String");
                    params[paramCtr] = (String)currParamMap.get("PARAM_VALUE");
                }
                ++paramCtr;
            }
            Class<?> classObj = Class.forName(compName);
            java.lang.Object comp = classObj.newInstance();
            BaseLogger.log("3", null, null, "methodName [" + methodName + "]");
            BaseLogger.log("3", null, null, "compName [" + compName + "]");
            BaseLogger.log("3", null, null, "comp [" + comp + "]");
            Method metObj = classObj.getMethod(methodName, paramSpec);
            metObj.setAccessible(true);
            java.lang.Object retVal = metObj.invoke(comp, params);
            returnValue = retVal.toString();
        }
        catch (Exception e) {
            status = "0";
            returnValue = e.getMessage();
            e.printStackTrace();
            returnValue = "<ROOT><STATUS><![CDATA[" + status + "]]></STATUS><RESULT><![CDATA[" + returnValue + "]]></RESULT></ROOT>";
        }
        BaseLogger.log("2", null, null, "Applicationinvoker : invokeApplication : returnValue [" + returnValue + "]");
        return returnValue;
    }

    private String invokeNVO(Connection conn) throws BaseException {
        BaseLogger.log("2", null, null, "Calling NVO.................");
        String returnValue = null;
        String status = "1";
        nvo_business_object_win_methods comp = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(String.valueOf(CommonConstants.APPLICATION_CONTEXT) + File.separator + "setting" + File.separator + "jagserver.xml");
            NodeList nlProURL = doc.getElementsByTagName("PROVIDER_URL");
            Node ndProURL = nlProURL.item(0);
            String PROVIDER_URL = ndProURL.getFirstChild().getNodeValue();
            Properties props = new Properties();
            props.put("org.omg.CORBA.ORBClass", "com.sybase.CORBA.ORB");
            ORB orb = ORB.init(null, (Properties)props);
            Manager manager = ManagerHelper.narrow((Object)orb.string_to_object(PROVIDER_URL));
            Session session = manager.createSession("jagadmin", "");
            Factory factory = FactoryHelper.narrow((Object)session.lookup("webitm4/nvo_business_object_win_methods"));
            comp = nvo_business_object_win_methodsHelper.narrow((Object)factory.create());
            BaseLogger.log("3", null, null, "NVO found !!!!!!!!!");
            Class<?> classObj = Class.forName("webitm4._st_nvo_business_object_win_methods");
            ArrayList paramList = this.applnParams.getParamList();
            int noOfParams = paramList.size();
            BaseLogger.log("3", null, null, "noOfParams :" + noOfParams);
            BaseLogger.log("3", null, null, "paramList length :[" + paramList.size() + "]");
            Class[] paramSpec = new Class[noOfParams];
            java.lang.Object[] params = new String[noOfParams];
            int paramCtr = 0;
            while (paramCtr < noOfParams) {
                HashMap currParamMap = (HashMap)paramList.get(paramCtr);
                String dataType = (String)currParamMap.get("PARAM_DATA_TYPE");
                paramSpec[paramCtr] = Class.forName("java.lang.String");
                params[paramCtr] = (String)currParamMap.get("PARAM_VALUE");
                ++paramCtr;
            }
            String componentName = this.applnParams.getApplnName();
            String methodName = this.applnParams.getMethodName();
            Method metObj = classObj.getMethod(methodName, paramSpec);
            metObj.setAccessible(true);
            returnValue = (String)metObj.invoke((java.lang.Object)comp, params);
        }
        catch (Exception e) {
            status = "0";
            returnValue = e.getMessage();
            e.printStackTrace();
        }
        return "<ROOT><STATUS><![CDATA[" + status + "]]></STATUS><RESULT><![CDATA[" + returnValue + "]]></RESULT></ROOT>";
    }
}

