
package ibase.test.userinfo;
//
import java.io.File;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.apache.commons.io.FileUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

import ibase.system.config.ConnDriver;
import ibase.utility.BaseException;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.DBAccessEJB;


public class CustomerUserInfo {
	public UserInfoBean createCustomerUserInfo(String userId) throws BaseException, Exception
	{
		return createCustomerUserInfo( userId, "CUST_CODE" );
	}
	//Added by Sainath T.on 06-03-2020 [For gaction authentication] - End
	
	//Changed by Pooja S on 6-NOV-2020 [//Changed by Pooja S on 6-NOV-2020 [passord should sent from common definition, not from enterprise]] start
	public UserInfoBean createCustomerUserInfo( String custCode, String whereConditionColumn ) throws BaseException, Exception
	{
		return createCustomerUserInfo( custCode, whereConditionColumn, true );
	}
	public UserInfoBean createCustomerUserInfo( String custCode, String whereConditionColumn, boolean isMailConfReq ) throws BaseException, Exception
	{
		UserInfoBean userInfoBean = new UserInfoBean();
		ConnDriver connDriver = null;
		Connection connection = null;
		Statement statement = null;
		ResultSet resultSet = null;
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		PreparedStatement preparedStatement = null;
		ResultSet res = null;
		try 
		{
			BaseLogger.log("3",null,null,"userId in createUserInfo of CommonDBAccessEJB=["+custCode+"]");
			connDriver = new ConnDriver();
			connection = connDriver.getConnectDB("Driver");
			statement = connection.createStatement();
			String sql = "SELECT CUST_CODE,CUST_TYPE,CHG_TERM,FULL_NAME,SITE_CODE,EMAIL_ADDR, "
					+ " FROM CUSTOMER "
					+ " WHERE "+ whereConditionColumn + " = '"+ custCode +"' ";
			
			DBAccessEJB dbAccessEJB = new DBAccessEJB();
			String profileId = dbAccessEJB.getDBColumnValue( "SYSPARM", "VAR_VALUE", (" VAR_NAME = 'PROFILE_ID_CUSTOMER'"), "Driver" );
			
			
			resultSet = statement.executeQuery(sql);
			if(resultSet.next())
			{
				// changes remaining add in userinfobean
				userInfoBean.setLoginCode(E12GenericUtility.checkNull(resultSet.getString("CUST_CODE")));
				userInfoBean.setUserType(E12GenericUtility.checkNull(resultSet.getString("CUST_TYPE")));
				userInfoBean.setTermId(E12GenericUtility.checkNull(resultSet.getString("CHG_TERM")));
				userInfoBean.setProfileId(E12GenericUtility.checkNull(resultSet.getString(profileId)));
				userInfoBean.setUserName(E12GenericUtility.checkNull(resultSet.getString("FULL_NAME")));
				userInfoBean.setSiteCode(E12GenericUtility.checkNull(resultSet.getString("SITE_CODE")));
				userInfoBean.setLoginEmailId(E12GenericUtility.checkNull(resultSet.getString("EMAIL_ADDR")));
					if( E12GenericUtility.checkNull(userInfoBean.getTransDB()).length() > 0 )
				{
					conn = connDriver.getConnectDB(userInfoBean.getTransDB());
					if( "".equals(E12GenericUtility.checkNull(userInfoBean.getEnterprise())) )
					{
						String sqlString = "select ENTERPRISE from site where site_code=?";
						BaseLogger.log("3",null,null,"siteCode["+userInfoBean.getSiteCode()+"]");
						pstmt = conn.prepareStatement(sqlString);
						pstmt.setString(1,userInfoBean.getSiteCode());
						rs = pstmt.executeQuery();
						while (rs.next())
						{
							userInfoBean.setEnterprise(E12GenericUtility.checkNull(rs.getString("ENTERPRISE")));
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;	
					}
					if( E12GenericUtility.checkNull(userInfoBean.getEnterprise()).length() > 0 )
					{
						String sqlString = "SELECT DOC_SERVER_ID, SMTP_FALLBACK FROM ENTERPRISE WHERE ENTERPRISE = ?";
						BaseLogger.log("3",null,null,"enterprise["+userInfoBean.getEnterprise()+"]");
						pstmt = conn.prepareStatement(sqlString);
						pstmt.setString(1,userInfoBean.getEnterprise());
						rs = pstmt.executeQuery();
						while (rs.next())
						{
							userInfoBean.setDocServerID(rs.getString("DOC_SERVER_ID"));
							BaseLogger.log("3",null,null,"DOC_SERVER_ID FROM ["+rs.getString("DOC_SERVER_ID")+"]");
							userInfoBean.setSmtpFallback(rs.getString("SMTP_FALLBACK"));
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
					}
					if( E12GenericUtility.checkNull(userInfoBean.getEnterprise()).length() > 0 && isMailConfReq )
					{
						String sqlString = "SELECT ENTERPRISE_DESCR, SMTP_HOST, SMTP_PORT, SMTP_USER, SMTP_PASS_WD, SMTP_PROTOCOL_TYPE, SMTP_MAILFROM, EMAIL_ID, SESS_TIMEOUT_SEC FROM ENTERPRISE WHERE ENTERPRISE = ?";
						BaseLogger.log("3",null,null,"enterprise["+userInfoBean.getEnterprise()+"]");
						pstmt = conn.prepareStatement(sqlString);
						pstmt.setString(1,userInfoBean.getEnterprise());
						rs = pstmt.executeQuery();
						while (rs.next())
						{
							userInfoBean.setEnterpriseDescr(rs.getString("ENTERPRISE_DESCR"));
							userInfoBean.setSmtpHost(rs.getString("SMTP_HOST"));
							userInfoBean.setSmtpPort(rs.getString("SMTP_PORT"));
							userInfoBean.setSmtpUser(rs.getString("SMTP_USER"));
							userInfoBean.setSmtpPassWD(rs.getString("SMTP_PASS_WD"));
							userInfoBean.setSmtpProtocolType(rs.getString("SMTP_PROTOCOL_TYPE"));
							userInfoBean.setSmtpMailFrom(rs.getString("SMTP_MAILFROM"));
							userInfoBean.setAdminEmailId(rs.getString("EMAIL_ID"));
                            userInfoBean.setSessTimeoutInSecs(rs.getString("SESS_TIMEOUT_SEC")); //Added by Jatin M on 24-Jun-2022 [To set prior session timeout in UserInfoBean]
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
					}
				}
				String termIdSQL = "SELECT CHG_TERM FROM LOGINTRACE WHERE USERID = ? AND LOGINTIME = ( SELECT MAX(LOGINTIME) FROM LOGINTRACE WHERE USERID = ? AND LOGIN_STATUS = ? )";
				preparedStatement = connection.prepareStatement(termIdSQL);
				preparedStatement.setString(1, custCode);
				preparedStatement.setString(2, custCode);
				preparedStatement.setString(3, "T");
				res = preparedStatement.executeQuery();
				if( res.next() )
				{
					userInfoBean.setTermId( res.getString("CHG_TERM") );
				}
				preparedStatement.close();
				preparedStatement = null;
				res.close();
				res = null;
				BaseLogger.log("3",null,null,"CommonDBAccessEjb createUserInfo()::::::"+userInfoBean.toString());
				if( E12GenericUtility.checkNull(userInfoBean.getTransDB()).length() > 0 )
				{
                    System.out.println("Vikas Dremio ..  "+userInfoBean.getTransDB());
                    try
                    {
                        setUserInfoInMem(userInfoBean.getTransDB(), userInfoBean);                    
                    }
                    catch ( Exception e )
                    {
                        System.out.println("Exception Vikas "+e.getMessage());
                    }
	            }
			}
		} 
		catch (Exception e) 
		{
			BaseLogger.log("0",null,null,"Exception in CommonDBAccessEJB createUserInfo()........."+e);
		}
		finally 
		{
			if (resultSet != null) resultSet.close();
			if (statement != null) statement.close();
			if (connection != null) connection.close();
			if( rs != null )
			{
				rs.close();
				rs =null;
			}
			if( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			if( conn != null )
			{
				conn.close();
				conn = null;
			}
			if( preparedStatement != null )
			{
				preparedStatement.close();
				preparedStatement = null;
			}
			if( res != null )
			{
				res.close();
				res = null;
			}
		}			
		return userInfoBean;
	}
	public void setUserInfoInMem(String transDB,UserInfoBean userInfoBean)
    {
        BaseLogger.log("3", null, null,"Inside setUserInfoInMem   "+transDB);
        String filePath = "",fileContent = "";
        try 
        {
            filePath = CommonConstants.JBOSSHOME + File.separator + "server" + File.separator + "default" + File.separator + "deploy" + File.separator + "ibase.ear" + File.separator + "ibase.war" + File.separator + CommonConstants.SETTINGS;
            filePath = filePath +  File.separator + transDB +"_IN_MEM.xml";
            BaseLogger.log("3", null, null,"File Path  ::   "+filePath);
            File xmlFile = new File( filePath );
			if( xmlFile != null )
			{
                fileContent = FileUtils.readFileToString(xmlFile);
                BaseLogger.log("3", null, null,"fileContent   ::   "+fileContent);
            }
		
			DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();  
	        DocumentBuilder builder; 
	        builder = factory.newDocumentBuilder();  
            Document doc = builder.parse( new InputSource( new StringReader( fileContent )) ); 
            
            NodeList docRoot1 = doc.getElementsByTagName("DATABASE");
            for (int i = 0; i < docRoot1.getLength(); i++)
            {
                NodeList childList1 = docRoot1.item(i).getChildNodes();
                for (int j = 0; j < childList1.getLength(); j++) 
                {
                    Node childNode = childList1.item(j);
                    if("URL".equalsIgnoreCase(childNode.getNodeName())) 
                    {
                        String url = childNode.getFirstChild().getNodeValue();
                        userInfoBean.setInMemUrl(url);
                        BaseLogger.log("3", null, null,"dremio url["+url+"]");
                    }
                    else if("LOGID".equalsIgnoreCase(childNode.getNodeName())) 
                    {
                        String userName = childNode.getFirstChild().getNodeValue();
                        userInfoBean.setInMemUserName(userName);
                    	BaseLogger.log("3", null, null,"dremio userName["+userName+"]");
                    }
                    else if("LOGPASSWORD".equalsIgnoreCase(childNode.getNodeName())) 
                    {
                        String pass = childNode.getFirstChild().getNodeValue();
                        userInfoBean.setInMemPassword(pass);
                        BaseLogger.log("3", null, null,"dremio pass["+pass+"]");

                    }
                }
            }
        }
        catch ( Exception e )
        {
             BaseLogger.log("3", null, null,"Exception while set UserInfo In Memory .. "+e.getMessage());
        }
    }	
}
