<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ page import="java.io.*, java.net.*, java.sql.*, javax.naming.Context, javax.naming.InitialContext, javax.sql.DataSource"%>
<%@ page import="ibase.utility.BaseLogger, ibase.utility.UserInfoBean, ibase.webitm.ejb.DBAccessEJB, ibase.system.config.ConnDriver"%>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Customer External Information</title>
    <style>
        button {
            background-color: blue;
            color: white;
            padding: 10px 20px;
            border: none;
            cursor: pointer;
        }

        button:hover {
            background-color: darkblue;
        }
    </style>
    <script>
        function updateInputBox() {
            var selectedOption = document.getElementById("idType").value;
            document.getElementById("selectedIdType").value = selectedOption;
        }

        function getDetails() {
            document.getElementById("detailsForm").submit();
        }
    </script>
</head>
<body>
<%
    String custCode = request.getParameter("CUST_CODE");
    if (custCode == null || custCode.isEmpty()) {
        custCode = (String) session.getAttribute("CUST_CODE");
    } else {
        session.setAttribute("CUST_CODE", custCode);
    }

    String selectedOption = request.getParameter("idType");

    BaseLogger.log("3", null, null, "CustCode [" + custCode + "]");
    BaseLogger.log("3", null, null, "Selected Option [" + selectedOption + "]");

    UserInfoBean userInfo = (UserInfoBean) session.getAttribute("USER_INFO");
    DBAccessEJB dbAccess = new DBAccessEJB();

    String infoResponse = null;
    String panNumber = null;
    String panVerificationResponse = null;

    if ("pan".equals(selectedOption)) {
        panNumber = dbAccess.getDBColumnValue("CUSTOMER", "PAN_NO", "CUST_CODE = '" + custCode + "'", userInfo.getTransDB());

        if (panNumber != null && !panNumber.isEmpty()) {
            panVerificationResponse = dbAccess.getDBColumnValue("CUST_EXT_INFO", "INFO_RESPONSE", "CUST_CODE = '" + custCode + "' AND INFO_TYPE = 'Pan Verification'", userInfo.getTransDB());

            if (panVerificationResponse == null) {
                // Call the API if panVerificationResponse is null
                try {
                    String apiUrl = "https://sandboxapi.atlas.vayana.com/AtlasApi/v1.0/aadhaar/udyam/verification";
                    URL url = new URL(apiUrl);
                    HttpURLConnection conn = (HttpURLConnection) url.openConnection();
                    conn.setRequestMethod("GET");

                    BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                    String inputLine;
                    StringBuffer apiResponse = new StringBuffer();

                    while ((inputLine = in.readLine()) != null) {
                        apiResponse.append(inputLine);
                    }
                    in.close();

                    panVerificationResponse = apiResponse.toString();
                    BaseLogger.log("3", null, null, "API Response for PAN Verification: " + panVerificationResponse);

                    // Store the API response in the database
                    Connection connection = null;
                    PreparedStatement pstmt = null;
                    try {
                        ConnDriver connDriver = new ConnDriver();
                        connection = connDriver.getConnectDB(userInfo.getTransDB());
                        String insertQuery = "INSERT INTO CUST_EXT_INFO (CUST_CODE, INFO_TYPE, INFO_RESPONSE) VALUES (?, ?, ?)";
                        pstmt = connection.prepareStatement(insertQuery);
                        pstmt.setString(1, custCode);
                        pstmt.setString(2, "Pan Verification");
                        pstmt.setString(3, panVerificationResponse);
                        pstmt.executeUpdate();
                    } catch (SQLException e) {
                        e.printStackTrace();
                    } finally {
                        if (pstmt != null) {
                            try {
                                pstmt.close();
                            } catch (SQLException e) {
                                e.printStackTrace();
                            }
                        }
                        if (connection != null) {
                            try {
                                connection.close();
                            } catch (SQLException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                } catch (Exception e) {
                    out.println("Error calling API for PAN Verification: " + e.getMessage());
                }
            }
        }
    }
%>

<h1>Customer External Information</h1>

<form id="detailsForm" method="post" action="">
    <label for="idType">Choose an ID type:</label>
    <select id="idType" name="idType" onchange="updateInputBox()">
        <option value="pan" <%= "pan".equals(selectedOption) ? "selected" : "" %>>Pan</option>
        <option value="aadharno" <%= "aadharno".equals(selectedOption) ? "selected" : "" %>>Aadharno</option>
        <option value="udyogno" <%= "udyogno".equals(selectedOption) ? "selected" : "" %>>Udyog no</option>
    </select>
    <input type="hidden" name="CUST_CODE" value="<%= custCode %>">
    <br><br>
    <label for="selectedIdType">Selected ID Type:</label>
    <input type="text" id="selectedIdType" name="selectedIdType" readonly value="<%= selectedOption != null ? selectedOption : "" %>">
    <br><br>
    <button type="button" onclick="getDetails()">Get Details</button>
</form>

<% if ("pan".equals(selectedOption)) { %>
    <h2>PAN Number</h2>
    <p><%= panNumber != null ? panNumber : "No PAN number found for the given customer code." %></p>

    <% if (panVerificationResponse != null && !panVerificationResponse.isEmpty()) { %>
        <h2>Pan Verification Info Response</h2>
        <table id="jsonData">
            <thead>
                <tr>
                    <th>Key</th>
                    <th>Value</th>
                </tr>
            </thead>
            <tbody>
                <script>
                    var jsonData = <%=panVerificationResponse.replaceAll("\"", "\\\"")%>;

                    function createTableFromJson(data, parentElement) {
                        for (var key in data) {
                            if (data.hasOwnProperty(key)) {
                                var value = data[key];
                                var row = parentElement.insertRow();
                                var cell1 = row.insertCell(0);
                                var cell2 = row.insertCell(1);
                                cell1.innerHTML = key;

                                if (typeof value === 'object' && value !== null) {
                                    cell2.innerHTML = "";
                                    var nestedTable = document.createElement("table");
                                    var nestedBody = document.createElement("tbody");
                                    nestedTable.appendChild(nestedBody);
                                    createTableFromJson(value, nestedBody);
                                    cell2.appendChild(nestedTable);
                                } else {
                                    cell2.innerHTML = value;
                                }
                            }
                        }
                    }

                    var tableBody = document.getElementById("jsonData").getElementsByTagName('tbody')[0];
                    createTableFromJson(JSON.parse(jsonData), tableBody);
                </script>
            </tbody>
        </table>
    <% } else { %>
        <p>No Pan Verification response found for the given customer code.</p>
    <% } %>
<% } %>

</body>
</html>
