/*
 * Decompiled with CFR 0.152.
 */
package ibase.wrkflw.utility;

import ibase.system.config.AppConnectParm;
import ibase.utility.BaseException;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.wrkflw.WorkflowProcessInstanceMonitorEJB;
import ibase.wrkflw.utility.WorkflowLogger;
import ibase.wrkflw.utility.WorkflowProcessIdGenerator;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.sql.Connection;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.naming.InitialContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.nfunk.jep.JEP;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PerformCondition {
    public String performCondition(String processInstanceId, String exprString, String varNamesString, String dataString) throws BaseException {
        Connection conn = null;
        try {
            this.performCondition(processInstanceId, exprString, varNamesString, dataString, conn);
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
        return "";
    }

    public String performCondition(String processInstanceId, String exprString, String varNamesString, String dataString, Connection conn) throws BaseException {
        try {
            boolean isExpr = false;
            String processId = WorkflowProcessIdGenerator.getInstance().getProcessId(processInstanceId);
            String instanceId = WorkflowProcessIdGenerator.getInstance().getInstanceId(processInstanceId);
            AppConnectParm appConnect = new AppConnectParm();
            Properties p = appConnect.getProperty();
            InitialContext ctx = new InitialContext(p);
            WorkflowProcessInstanceMonitorEJB workflowProcessInstanceMonitor = new WorkflowProcessInstanceMonitorEJB();
            isExpr = this.evaluateExpr(exprString, varNamesString, dataString);
            if (isExpr) {
                WorkflowLogger.info("Calling workflowProcessInstanceMonitor.updateActivityStatus with '2' from performCondition");
                String resultXmlStr = "<ROOT><STATUS><![CDATA[1]]></STATUS><RESULT><![CDATA[Condition Satisfied]]></RESULT></ROOT>";
                if (conn != null) {
                    workflowProcessInstanceMonitor.updateActivityStatus(processInstanceId, "2", null, null, null, null, null, resultXmlStr, conn);
                } else {
                    workflowProcessInstanceMonitor.updateActivityStatus(processInstanceId, "2", null, null, null, null, null, resultXmlStr);
                }
            }
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
        return "";
    }

    private boolean evaluateExpr(String exprString, String varNamesString, String dataString) throws BaseException {
        boolean isEvaluation = false;
        try {
            WorkflowLogger.info("Expr To Eval :[" + exprString + "]");
            JEP jep = new JEP();
            StringTokenizer expStringToken = null;
            if (varNamesString != null && varNamesString.length() > 0) {
                expStringToken = new StringTokenizer(varNamesString, ",");
                while (expStringToken.hasMoreTokens()) {
                    String currField = expStringToken.nextToken();
                    String currDataType = currField.substring(currField.lastIndexOf(".") + 1);
                    String curFieldName = currField.substring(0, currField.lastIndexOf("."));
                    Object currFieldValue = this.getValueOfField(dataString, curFieldName, currDataType);
                    if (currFieldValue == null) continue;
                    if (curFieldName.indexOf(".") != -1) {
                        curFieldName = curFieldName.substring(curFieldName.indexOf(".") + 1);
                    }
                    WorkflowLogger.info("Adding to JEP, Retrieved value of expr for Transition for :[" + curFieldName + "=" + currFieldValue + "]");
                    jep.addVariableAsObject(curFieldName, currFieldValue);
                }
            }
            StringBuffer expr = new StringBuffer(exprString);
            if (exprString.toUpperCase().indexOf(" AND ") > 0) {
                expr.replace(exprString.toUpperCase().indexOf(" AND "), exprString.toUpperCase().indexOf(" AND ") + " AND ".length(), " && ");
            }
            if (exprString.toUpperCase().indexOf(" OR ") > 0) {
                expr.replace(exprString.toUpperCase().indexOf(" OR "), exprString.toUpperCase().indexOf(" OR ") + " OR ".length(), " || ");
            }
            exprString = new String(expr);
            jep.parseExpression(exprString);
            Object resultObj = null;
            String errorString = jep.getErrorInfo();
            if (errorString != null) {
                resultObj = errorString;
            } else {
                resultObj = jep.getValueAsObject();
                if (resultObj.equals(Double.valueOf("1"))) {
                    isEvaluation = true;
                }
            }
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
        WorkflowLogger.info("Result of evaluation of expression :[" + isEvaluation + "]");
        return isEvaluation;
    }

    private Object getValueOfField(String dataString, String currFieldName, String currFieldType) throws BaseException {
        Object fieldValue = null;
        Node currField = null;
        Document dom = null;
        try {
            try {
                dom = new E12GenericUtility().parseString(dataString);
            }
            catch (Exception saxe) {
                WorkflowLogger.info("Exception :getValueOfField :parsingXMLString :==>\n" + saxe.getMessage());
                dom = this.parsingFile(dataString);
            }
            String currFieldValue = null;
            if (currFieldName.indexOf(".") != -1) {
                String detailName = currFieldName.substring(0, currFieldName.indexOf("."));
                String fieldName = currFieldName.substring(currFieldName.indexOf(".") + 1);
                NodeList detailNodeList = dom.getElementsByTagName(detailName).item(0).getChildNodes();
                int ctr = 0;
                while (ctr < detailNodeList.getLength()) {
                    Node currChild = detailNodeList.item(ctr);
                    if (currChild.getNodeName().equals(fieldName) && currChild.getFirstChild() != null) {
                        currField = currChild;
                    }
                    ++ctr;
                }
            } else {
                currField = dom.getElementsByTagName(currFieldName).item(0);
            }
            if (currField != null) {
                if (currField.getFirstChild() != null) {
                    currFieldValue = currField.getFirstChild().getNodeValue();
                }
                if (currFieldValue != null) {
                    fieldValue = currFieldType.equalsIgnoreCase("I") ? Integer.valueOf(currFieldValue.toString()) : (currFieldType.equalsIgnoreCase("Number") || currFieldType.equalsIgnoreCase("N") || currFieldType.equalsIgnoreCase("D") ? Double.valueOf(currFieldValue.toString()) : currFieldValue.trim());
                }
            }
        }
        catch (BaseException be) {
            throw be;
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
        return fieldValue;
    }

    private InitialContext getInitialContext() throws BaseException {
        InitialContext ctx = null;
        try {
            AppConnectParm appConnect = new AppConnectParm();
            ctx = new InitialContext(appConnect.getProperty());
        }
        catch (BaseException be) {
            throw be;
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
        return ctx;
    }

    private Document parsingFile(String writeFileString) throws BaseException {
        BufferedWriter parseFileWriter = null;
        Document dom = null;
        try {
            try {
                E12GenericUtility genericUtility = new E12GenericUtility();
                double randomNo = Math.random();
                if (!new File(String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "log" + File.separator + "workflwParseFile" + randomNo + ".xml").exists()) {
                    new File(String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "log" + File.separator + "workflwParseFile" + randomNo + ".xml").createNewFile();
                }
                String parseFileName = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "log" + File.separator + "workflwParseFile" + randomNo + ".xml";
                WorkflowLogger.info("writeParsingFile:parseFileName[" + parseFileName + "]");
                parseFileWriter = new BufferedWriter(new FileWriter(parseFileName));
                parseFileWriter.write(writeFileString);
                parseFileWriter.flush();
                parseFileWriter.close();
                parseFileWriter = null;
                dom = this.parseXMLFile(parseFileName);
            }
            catch (Exception e) {
                dom = null;
                throw new BaseException(e);
            }
        }
        finally {
            try {
                if (parseFileWriter != null) {
                    parseFileWriter.flush();
                    parseFileWriter.close();
                    parseFileWriter = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                parseFileWriter = null;
            }
        }
        return dom;
    }

    private Document parseXMLFile(Object sourceXMLFile) throws Exception {
        Document dom = null;
        try {
            File file = null;
            file = sourceXMLFile.getClass().getName().equalsIgnoreCase("java.lang.String") ? new File((String)sourceXMLFile) : (File)sourceXMLFile;
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            dbf.setIgnoringComments(true);
            DocumentBuilder parser = dbf.newDocumentBuilder();
            dom = parser.parse(file);
        }
        catch (Exception e) {
            dom = null;
            WorkflowLogger.info("Exception :WorkflowEngineEJB :parseFile :\n" + e.getMessage());
            throw e;
        }
        return dom;
    }
}

