/**
 * 
 */
package ibase.webService;

import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

import org.json.JSONException;

import ibase.utility.BaseLogger;
import ibase.utility.UserInfoBean;
import ibase.webitm.bean.wsfa.DCRSummaryBean;

/**
 * @author base
 *
 */
@Path("/E12WSFACommonService")
public class E12WSFACommonService 
{
	@GET
	@Path("/getNonVisitedRoute/")
	@Produces({ "application/json" })
	public Response getNonVisitedRoute( @QueryParam("SALES_PERS") String salesPers, @QueryParam("EVENT_DATE") String eventDate, @Context HttpServletRequest request ) throws JSONException
	{
        BaseLogger.log("2",null,null,"Inside getNonVisitedRoute :: salesPers ["+ salesPers +"]");
        UserInfoBean userInfo = ( UserInfoBean ) request.getSession().getAttribute( "USER_INFO" );

        DCRSummaryBean dcrSummaryBean = new DCRSummaryBean();
        String routes = dcrSummaryBean.getNonVisitedRoute(salesPers, eventDate, userInfo);
        BaseLogger.log("2",null,null,"Inside getNonVisitedRoute :: routes ["+ routes +"]");
        
        return Response.status(200).entity("Routes not selected : "+routes).build();
    }
}
