package ibase.webitm.ejb.wsfa.transactions;

import ibase.ejb.*;
import ibase.system.config.*;
import ibase.webitm.ejb.*;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;

import java.io.*;
import java.rmi.RemoteException;
import java.sql.*;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.*;

import javax.ejb.*;
import javax.naming.InitialContext;
import javax.xml.parsers.*;
import org.w3c.dom.*;

import com.sybase.jaguar.jdmk.SYBASE_Easnew_MIB;
//import oracle.jdbc.driver.OraclePreparedStatement; 

@Stateless
public class RetailSchemeClaimAdmAprv extends ValidatorEJB 
{
	E12GenericUtility genericUtility = new E12GenericUtility();
	protected static String database = CommonConstants.DB_NAME;

	public String wfValData() throws RemoteException, ITMException
	{
		return "";
	}

	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = null;
		try
		{
			System.out.println("xmlString in wfvaldata:"+xmlString);
			System.out.println("xmlString1 in wfvaldata:"+xmlString1);
			System.out.println("xmlString2 in wfvaldata:"+xmlString2);

			if(xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString); 
			}
			if(xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1); 
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2); 
			}
			errString = wfValData(dom, dom1, dom2, objContext, editFlag, xtraParams);
			System.out.println("ErrString: " + errString);
		}
		catch(Exception e)
		{
			System.out.println("Exception: RetailSchemeClaimAdmAprv: wfValData(String xmlString): " + e.getMessage() + ":");
			errString = genericUtility.createErrorString(e);
			e.printStackTrace();
		}
		System.out.println("Returning from RetailSchemeClaimAdmAprv wfValData");
		return (errString); 
	}

	public String wfValData(Document dom, Document dom1, Document dom2, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException
	{

		String userId = "";
		String errString = "";
		Connection connectionObject = null;		
		PreparedStatement pstmt = null;
		ResultSet rs = null;

		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;
		String childNodeName = null;

		int ctr = 0;
		int noOfChilds = 0;
		int currentFormNo = 0;
		try
		{
			connectionObject = getConnection(); 
			userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			parentList = dom2.getElementsByTagName("Detail" + currentFormNo);
			parentNode = parentList.item(0);
			childList = parentNode.getChildNodes();
			noOfChilds = childList.getLength();
			for(ctr = 0; ctr < noOfChilds; ctr++)
			{
				childNode = childList.item(ctr);
				childNodeName = childNode.getNodeName();
				switch(currentFormNo)
				{
				case 1:

					if("wf_remarks".equalsIgnoreCase(childNodeName))
					{
						String confirmed = checkNull(genericUtility.getColumnValue("confirmed", dom2));
						System.out.println("confirmed::::::::"+confirmed);
						if(childNode.getFirstChild() == null && confirmed.equalsIgnoreCase("R"))				
						{
							errString =  getErrorString("wf_remarks","BLNKREASON",userId);
							break;
						}
					}
					if("confirmed".equalsIgnoreCase(childNodeName))
					{
						String confirmVal = "";
						String tranId = checkNull(genericUtility.getColumnValue("tran_id", dom2));
						String sql = "SELECT CONFIRMED FROM RETAIL_SCH_CLAIM WHERE TRAN_ID = ? ";
						pstmt =  connectionObject.prepareStatement(sql);
						pstmt.setString(1, tranId);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							confirmVal = rs.getString("CONFIRMED");

						}
						if (rs!= null)
						{
							rs.close();
							rs = null;
						}
						if(pstmt!=null)
						{
							pstmt.close();
							pstmt = null;
						}
						System.out.println("confirmVal::::::::"+confirmVal);
						if(confirmVal.equalsIgnoreCase("R"))				
						{
							errString =  getErrorString("confirmed","TRALRDYREJ",userId);
							break;
						}
					}
					
					break;

				}

				if (errString != null && errString.trim().length()>0)
				{
					break;
				}
			}
		}
		catch(Exception se)
		{
			System.out.println("Exception: RetailSchemeClaimAdmAprv: wfValData(Document dom): " + se.getMessage() + ":");
			errString = genericUtility.createErrorString(se);
		}
		finally
		{
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if ( connectionObject != null )
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{
				throw new ITMException(e);
			}			
		}
		return (errString);
	}

	public String itemChanged() throws RemoteException, ITMException
	{
		return "";
	}

	public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = null;
		try
		{
			if (xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString); 
			}
			if (xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1); 
			}
			if (xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2); 
			}
			errString = itemChanged(dom, dom1, dom2, objContext, currentColumn, editFlag, xtraParams);
			System.out.println ("ErrString :" + errString);
		}
		catch (Exception e)
		{
			System.out.println ("Exception :RetailSchemeClaimAdmAprv :itemChanged(String,String):" + e.getMessage() + ":");
			errString = genericUtility.createErrorString(e);
		}
		System.out.println ("returning from RetailSchemeClaimAdmAprv itemChanged");
		return errString;
	}

	public String itemChanged(Document dom, Document dom1, Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		System.out.println("STRG RetailSchemeClaimAdmAprv ITEMCHANGE");
		String columnValue = "";
		String logInEmpCode = "";
		String sql=null;
		Connection connectionObject = null;		
		PreparedStatement pstmt = null;
		ResultSet rs = null;		
		StringBuffer valueXmlString = new StringBuffer();

		int currentFormNo = 0;
		try
		{
			connectionObject = getConnection();
			columnValue = genericUtility.getColumnValue(currentColumn,dom);
			logInEmpCode = getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode");
			logInEmpCode=logInEmpCode.trim();
			if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}

			DateFormat dtFormat = new SimpleDateFormat(getApplDateFormat());
			java.util.Date date = Calendar.getInstance().getTime(); 
			String chgDateAdd = dtFormat.format( date );
			String chgTerm = checkNull(genericUtility.getValueFromXTRA_PARAMS(xtraParams,"termId"));

			valueXmlString = new StringBuffer("<?xml version=\"1.0\" encoding='UTF-8'?>\r\n<Root>\r\n<Header>\r\n<editFlag>");
			valueXmlString.append(editFlag).append("</editFlag>\r\n</Header>\r\n");
			System.out.println("currentFormNo ["+currentFormNo+"] currentColumn ["+currentColumn+"]");
			String itmSer=getItemSer(logInEmpCode,connectionObject);
			String empHo=getDivisionHO(itmSer, connectionObject);
			switch (currentFormNo)
			{
			case 1:
					System.out.println("Inside case first::["+logInEmpCode+"]");
					
					if (currentColumn.trim().equalsIgnoreCase("itm_default"))
					{	
	
						valueXmlString.append("<Detail1 domId =\"1\">\r\n");
							
						valueXmlString.append("<chg_date><![CDATA[" ).append(chgDateAdd).append( "]]></chg_date>");
						valueXmlString.append("<chg_user><![CDATA[" ).append(logInEmpCode).append( "]]></chg_user>");
						valueXmlString.append("<chg_term><![CDATA[" ).append(chgTerm).append( "]]></chg_term>");
						valueXmlString.append("<emp_code__aprv><![CDATA[" ).append(logInEmpCode).append( "]]></emp_code__aprv>");
						valueXmlString.append("<conf_date><![CDATA[" ).append(chgDateAdd).append( "]]></conf_date>");
	
						valueXmlString.append("</Detail1>\r\n");
	
	
					}
					else if (currentColumn.trim().equalsIgnoreCase("itm_defaultedit"))
					{
						System.out.println("Inside item default edit");
						valueXmlString.append("<Detail1 domId =\"1\">\r\n");
						valueXmlString.append("<chg_date><![CDATA[" ).append(chgDateAdd).append( "]]></chg_date>");
						valueXmlString.append("<chg_user><![CDATA[" ).append(logInEmpCode).append( "]]></chg_user>");
						valueXmlString.append("<chg_term><![CDATA[" ).append(chgTerm).append( "]]></chg_term>");
						valueXmlString.append("<emp_code__aprv><![CDATA[" ).append(logInEmpCode).append( "]]></emp_code__aprv>");
						valueXmlString.append("<conf_date><![CDATA[" ).append(chgDateAdd).append( "]]></conf_date>");
						
						valueXmlString.append("</Detail1>\r\n");
					}

				break;


			}			

		}
		catch(SQLException se)
		{
			System.out.println("Exception: RetailSchemeClaimAdmAprv: itemChanged(Document,String): " + se.getMessage() + ":");
			valueXmlString = valueXmlString.append(genericUtility.createErrorString(se));
		}
		catch(Exception e)
		{
			System.out.println("Exception :RetailSchemeClaimAdmAprv :itemChanged(Document,String):" + e.getMessage() + ":");
			valueXmlString = valueXmlString.append(genericUtility.createErrorString(e));
		}
		finally 
		{
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if ( connectionObject != null )
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{
				throw new ITMException(e);
			}
		}
		valueXmlString.append("</Root>\r\n");	
		//System.out.println("\n****ValueXmlString :" + valueXmlString + ":********");
		return valueXmlString.toString();
	}

	private String checkNull(String input)
	{
		if (input == null || "null".equalsIgnoreCase(input))		
		{
			input="";
		}
		else
		{
			input = input.trim();
		}
		return input;
	}

	public String getDivisionHO(String itemSer,Connection conn) throws ITMException
	{
		System.out.println("In side getDivisionHO............");
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		String hoCode="";
		
		try
		{
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String sysDate = sdf.format(new java.util.Date());
			sysDate  = genericUtility.getValidDateString(sysDate, genericUtility.getApplDateFormat(), genericUtility.getDBDateTimeFormat());
			System.out.println("itemSer:::["+itemSer+"]");
			String sql=" SELECT PARM_VALUE FROM SFAPARM WHERE ORG_UNIT =?  "+
					" AND ACTIVE='Y'  "+
					" AND PARM_NAME='STRG_CUST_HO' "+
					" AND ?  BETWEEN EFF_FROM AND VALID_UPTO ";
			pstmt = conn.prepareStatement(sql);		
			pstmt.setString(1, "X"+"_"+itemSer);
			pstmt.setTimestamp(2,java.sql.Timestamp.valueOf(sysDate));										
			rs = pstmt.executeQuery();					
			if( rs.next() )
			{
				hoCode  = checkNull(rs.getString(1));				
			}
			System.out.println("hoCode:::["+hoCode+"]");
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}						
		}
		catch (Exception e) {
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
		}
		System.out.println("hoCode..:::=["+hoCode+"]");
		return hoCode;
	}
	
	public String getItemSer(String salesPers,Connection conn)  throws ITMException
	{
		PreparedStatement pstmt=null;
		ResultSet rs = null;
		String itemSer="";
		try
		{
			String sqlItmser="SELECT ITEM_SER FROM SALES_PERS WHERE SALES_PERS= ?";
			pstmt = conn.prepareStatement(sqlItmser);
			pstmt.setString(1, salesPers);
			rs=pstmt.executeQuery();
			if(rs.next())
			{
				itemSer=checkNull(rs.getString("ITEM_SER"));
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}	
		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
		return itemSer;
	}

	protected InitialContext getInitialContext()throws ITMException
	{
		InitialContext ctx = null;
		try
		{
			AppConnectParm appConnect = new AppConnectParm();
			ctx = new InitialContext(appConnect.getProperty());
		}
		catch(ITMException itme)
		{
			System.out.println("ITMException :[RetailSchemeClaimAdmAprv] :getInitialContext :==>");
			throw itme;
		}
		catch(Exception e)
		{
			System.out.println("Exception :[RetailSchemeClaimAdmAprv] :getInitialContext :==>");
			throw new ITMException(e);
		}
		return ctx;
	}
}


