package ibase.webitm.ejb.wsfa.masters;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import ibase.scheduler.utility.interfaces.Schedule;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.utility.EMail;
import ibase.utility.UserInfoBean;
import ibase.webitm.notification.ejb.PublishPushNotificationEJB;
import ibase.webitm.notification.ejb.PublishPushNotificationRemote;

public class SellInItemNotification implements Schedule
{
	private E12GenericUtility genericUtility = null;

	@Override
	public String schedule( String name ) throws Exception 
	{
		System.out.println( "SellInItemNotification schedule ["+ name +"]" );
		Connection conn = null;
		ConnDriver connDriver = null ;
		try
		{
			this.genericUtility = new  ibase.utility.E12GenericUtility();
			Document document = this.genericUtility.parseString( name );
			if ( document != null && document.getElementsByTagName( "USERINFOXML" ) != null 
					&& document.getElementsByTagName( "USERINFOXML" ).item( 0 ) != null
					&& document.getElementsByTagName( "USERINFOXML" ).item(0).getChildNodes().item(0) != null )
			{
				UserInfoBean userInfo = new UserInfoBean( this.genericUtility.serializeDom(document.getElementsByTagName( "USERINFOXML" ).item(0).getChildNodes().item(0)));
				connDriver = new ConnDriver();
				conn = connDriver.getConnectDB( userInfo.getTransDB() );
				connDriver = null;
				
				sendEmailAndNotification( userInfo, conn );
			}
		}
		catch(Exception e)
		{
			System.out.println("catch excepton  = "+e);
		}
		finally
		{
			try 
			{
				if ( conn != null )
				{
					conn.close();
					conn = null;
				}
			}
			catch (SQLException e) 
			{
				e.printStackTrace();
			}
		}
		return null;
	}

	public void sendEmailAndNotification( UserInfoBean userInfo, Connection conn )
	{
		System.out.println( "sendEmailAndNotification()" );
		String userCode  = "",loginEmpCode= "",emailId ="",name="",entityCode = "", currentMonthYear="";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try
		{
			ArrayList<String> userIdList = new ArrayList<String>();
			loginEmpCode = userInfo.getEmpCode();
			currentMonthYear = getCurrentMonthYear();
			String formatCode = "SELL_IN_NOTIFY";
			String mailSubject ="", mailBody ="", newMailBody ="" ;
			currentMonthYear = getCurrentMonthYear();
			
			String sql = "SELECT SUBJECT, BODY_TEXT FROM MAIL_FORMAT WHERE FORMAT_CODE = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, formatCode);
			rs = pstmt.executeQuery();
			if( rs.next() )
			{
				mailSubject = E12GenericUtility.checkNull(rs.getString("SUBJECT"));
				mailBody = E12GenericUtility.checkNull(rs.getString("BODY_TEXT"));
			}
			mailSubject = mailSubject.replace("#:currentDate:#", currentMonthYear );
			newMailBody = mailBody.replace("#:currentDate:#", currentMonthYear );
			
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			
			String currDate = "";
			String nextDate = "";
			try
			{
				SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
				Calendar calendar = Calendar.getInstance();
				Date date = calendar.getTime();
				calendar.setTime(date);
				calendar.add(5, 1);
				Date nextDay = calendar.getTime();

				currDate = sdf.format(date);
				currDate = genericUtility.getValidDateString(currDate, genericUtility.getApplDateFormat(), "dd-MMM-yyyy");
				nextDate = sdf.format(nextDay);
				nextDate = genericUtility.getValidDateString(nextDate, genericUtility.getApplDateFormat(), "dd-MMM-yyyy");
			}
			catch(Exception e)
			{
				BaseLogger.log("3", userInfo,null,"Exception While Parsing..........1300"+e.getMessage());
			}
			
			sql = "SELECT CODE,ENTITY_CODE,EMAIL_ID,NAME FROM USERS "
					+ "WHERE EMP_CODE IN ( SELECT DISTINCT SER.SALES_PERS FROM SELL_IN SELL_IN, STRG_SERIES SER "
					+ "WHERE SER.SC_CODE = SELL_IN.SC_CODE "
					+ "AND SELL_IN.CHG_DATE  between TO_DATE('"+currDate+"', 'dd-MON-yyyy') AND TO_DATE('"+nextDate+"', 'dd-MON-yyyy') )";
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			while( rs.next() )
			{
				userCode = E12GenericUtility.checkNull( rs.getString("CODE") );
				emailId = E12GenericUtility.checkNull( rs.getString("EMAIL_ID") );
				entityCode = E12GenericUtility.checkNull( rs.getString("ENTITY_CODE") );
				name = E12GenericUtility.checkNull( rs.getString("NAME") );
				
				userIdList.add( userCode );
				sendEmails( emailId, name, entityCode, mailSubject, newMailBody, formatCode, conn );
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			System.out.println("userIdList "+userIdList);
			
			String postMessage = "DSR data uploaded for "+currentMonthYear;
			PublishPushNotificationEJB publishPushNotificationEJB = new PublishPushNotificationEJB();
			publishPushNotificationEJB.invockPushNotification(postMessage, "", PublishPushNotificationRemote.OPEN_TARGET_TRANSACTION,"", userIdList , "", "", " ", loginEmpCode, 0,userInfo);
		}
		catch(Exception e)
		{
			System.out.println("sendEmailAndNotification catch excepton  = "+e);
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				System.out.println("sendEmailAndNotification Finally excepton  = "+e);
				e.printStackTrace();
			}
		}
	}
	private void sendEmails( String emailId, String name, String entityCode, String mailSubject, String newMailBody, String formatCode, Connection conn )
	{
		System.out.println("emailId["+emailId+"]name["+name+"]entityCode["+entityCode+"]mailSubject["+mailSubject+"]newMailBody["+newMailBody+"]formatCode["+formatCode+"]");
		String objName = "sell_in_item";
		
		try 
		{
			newMailBody = newMailBody.replace("#:userName:#", name);
			
			String mailDomStr = "<ROOT><TRANS_INFO><OBJ_NAME>"+objName+"</OBJ_NAME>"+
					"<XSL_FILE_NAME></XSL_FILE_NAME></TRANS_INFO>"+
					"<MAIL><EMAIL_TYPE>page</EMAIL_TYPE><ENTITY_CODE>"+entityCode+"</ENTITY_CODE>"+ //TO DO
					"<ENTITY_TYPE>"+"E"+"</ENTITY_TYPE><SUBJECT>"+mailSubject+"</SUBJECT>"+
					"<BODY_TEXT><![CDATA["+newMailBody+"]]></BODY_TEXT>"+
					"<TO_ADD>"+emailId+"</TO_ADD><CC_ADD></CC_ADD>"+
					"<FORMAT_CODE>"+formatCode+"</FORMAT_CODE>"+
					"<ATTACHMENT><BODY></BODY><LOCATION></LOCATION></ATTACHMENT>"+
					"</MAIL><XML_DATA></XML_DATA></ROOT>";
			System.out.println("AMY mailDomStr ==> "+mailDomStr);
			
			EMail email = new EMail();
			email.sendMail(mailDomStr, "ITM", conn);
		} 
		catch (Exception e) 
		{
			System.out.println("sendEmails excepton  = "+e);
			e.printStackTrace();
		}
	}
	
	private String getCurrentMonthYear()
	{
		String currentMonthYear = "";
		String[] monthName = { "January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December" };
		Calendar cal = Calendar.getInstance();
		String currentMonth = monthName[cal.get(Calendar.MONTH)];
		String currentyYear = String.valueOf( cal.get(Calendar.YEAR) );
		currentMonthYear = currentMonth+"-"+currentyYear;
		return currentMonthYear;
	}

	@Override
	public String schedule(HashMap map) throws Exception {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public String schedulePriority(String wrkflwPriority) throws Exception {
		// TODO Auto-generated method stub
		return null;
	}
}
