/*
 * Decompiled with CFR 0.152.
 */
package ibase.communication.telegram;

import com.fasterxml.jackson.databind.ObjectMapper;
import ibase.bean.ExtAuthApplicationBean;
import ibase.communication.telegram.TelegramBotUtility;
import ibase.communication.telegram.UserDetails;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.webitm.utility.APIUtility;
import ibase.webitm.utility.RestAPIServiceUtility;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.servlet.http.HttpServletRequest;

public class Utils {
    static String botToken;

    public Utils(String botToken) {
        Utils.botToken = botToken;
    }

    public String getEnterprise(String botToken, String botName, HttpServletRequest request) {
        String enterprise;
        block14: {
            System.out.println("Inside getEnterprise gsb");
            enterprise = "APPVIS";
            try {
                String urlStr = String.valueOf(this.getServerIP(request)) + "/ibase/rest/telegrambot/getEnterprise?botToken=" + botToken;
                System.out.println("Inside getEnterprise gsb urlStr[" + urlStr + "]");
                URL url = new URL(urlStr);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                conn.setRequestProperty("Accept", "application/json");
                conn.setConnectTimeout(5000);
                conn.setReadTimeout(10000);
                if (conn.getResponseCode() == 200) {
                    Throwable throwable = null;
                    Object var9_12 = null;
                    try (BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));){
                        String output;
                        StringBuilder response = new StringBuilder();
                        while ((output = br.readLine()) != null) {
                            response.append(output);
                        }
                        enterprise = response.toString().trim();
                        break block14;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                throw new RuntimeException("Failed : HTTP error code: " + conn.getResponseCode());
            }
            catch (SocketTimeoutException e) {
                System.out.println("Connection timed out while accessing the URL: " + e.getMessage());
            }
            catch (IOException e) {
                System.out.println("Error in accessing the URL: " + e.getMessage());
            }
        }
        System.out.println("Enterprise for BOT=" + enterprise);
        return enterprise;
    }

    public UserDetails getUserDetails(String email, String botName, HttpServletRequest request) {
        String ENTERPRISE;
        UserDetails user;
        block5: {
            System.out.println("Inside getUserDetails gsb");
            user = null;
            ENTERPRISE = this.getEnterprise(botToken, botName, request);
            if (ENTERPRISE != null && !ENTERPRISE.equals(null) && ENTERPRISE.length() != 0 && !ENTERPRISE.equals("")) break block5;
            return null;
        }
        try {
            String output;
            ObjectMapper mapper = new ObjectMapper();
            String urlStr = String.valueOf(this.getServerIP(request)) + "/ibase/rest/telegrambot/getUsersDetailsByEmail?emailId=" + email + "&enterprise=" + ENTERPRISE;
            System.out.println("URL=" + urlStr);
            URL url = new URL(urlStr);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setRequestProperty("Accept", "application/json");
            System.out.println("conn.getResponseCode()[" + conn.getResponseCode() + "]");
            if (conn.getResponseCode() != 200) {
                System.out.println("Inside if response code is not 200[" + conn.getResponseCode() + "]");
                throw new RuntimeException("Failed :HTTP error code:" + conn.getResponseCode());
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((output = br.readLine()) != null) {
                if (output.length() <= 2) continue;
                System.out.println("User before mapper=" + output);
                user = (UserDetails)mapper.readValue(output, UserDetails.class);
                System.out.println("User in Util class==>" + user);
            }
            return user;
        }
        catch (Exception e) {
            e.printStackTrace();
            return user;
        }
    }

    public void sendEmail(String toEmail, String msg) {
        System.out.println("[sendEmail] :: Inside Send Email");
        final Properties emailProp = new Properties();
        InputStream input = TelegramBotUtility.class.getClassLoader().getResourceAsStream("email.properties");
        try {
            emailProp.load(input);
        }
        catch (IOException e) {
            System.out.println("Error in loading email Properties");
            e.printStackTrace();
        }
        String to = toEmail;
        String from = emailProp.getProperty("EMAIL_FROM");
        String host = "smtp.gmail.com";
        Properties properties = System.getProperties();
        properties.put("mail.smtp.host", host);
        properties.put("mail.smtp.port", "465");
        properties.put("mail.smtp.ssl.enable", "true");
        properties.put("mail.smtp.auth", "true");
        Session session = Session.getInstance((Properties)properties, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(emailProp.getProperty("EMAIL_USER_NAME"), emailProp.getProperty("EMAIL_PASSWORD"));
            }
        });
        try {
            MimeMessage message = new MimeMessage(session);
            message.setFrom((Address)new InternetAddress(from));
            message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(to));
            message.setSubject("Vision BOT: OTP");
            message.setContent((Object)("<p>Hello, WELCOME TO VISION BOT</p><p> Your Bot OTP: <h3>" + msg + "</h3></p><p> Please Enter The OTP On Telegram Bot To Procced Further</p> <p>Thank You For Visiting.</p>"), "text/html");
            System.out.println("[sendEmail] :: sending...");
            Transport.send((Message)message);
            System.out.println("[sendEmail] :: Sent message successfully....");
        }
        catch (MessagingException mex) {
            System.out.println("Email sending error=" + mex.getMessage());
            mex.printStackTrace();
        }
    }

    public String generateOtp() {
        String otp = null;
        Random rnd = new Random();
        int number = rnd.nextInt(999999);
        otp = String.format("%06d", number);
        return otp;
    }

    public String addUsersChatid(String userEmail, String chatId, String userId, String userType, String botToken, String entityType, String botName, HttpServletRequest request) {
        try {
            String output;
            String response = "";
            String ENTERPRISE = this.getEnterprise(botToken, botName, request);
            String urlStr = String.valueOf(this.getServerIP(request)) + "/ibase/rest/telegrambot/addUsersChatid?" + "userEmail=" + userEmail + "&chatId" + chatId + "&userId" + userId + "&userType" + userType + "&botToken" + botToken + "&enterprise=" + ENTERPRISE + "&entityType=" + entityType;
            URL url = new URL(urlStr);
            System.out.println();
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Accept", "application/json");
            if (conn.getResponseCode() != 200) {
                throw new RuntimeException("Failed :HTTP error code:" + conn.getResponseCode());
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((output = br.readLine()) != null) {
                System.out.println(output);
                if (output.length() <= 2) continue;
                response = output;
            }
            return response;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "Error in storing User chatid";
        }
    }

    public String addUserOtp(String chatId, String otp, String userId, String userType, String botName, HttpServletRequest request) {
        try {
            String output;
            String response = "";
            String utlParameters = "chatId=" + chatId + "&otp=" + otp + "&userID=" + userId + "&userType=" + userType;
            byte[] postData = utlParameters.getBytes(StandardCharsets.UTF_8);
            int postDataLenght = postData.length;
            String urlStr = String.valueOf(this.getServerIP(request)) + "/ibase/rest/telegrambot/addTelegramOTP?chatId=" + chatId + "&otp=" + otp + "&userID=" + userId + "&userType=" + userType;
            URL url = new URL(urlStr);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setDoOutput(true);
            conn.setInstanceFollowRedirects(false);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            conn.setRequestProperty("charset", "utf-8");
            conn.setRequestProperty("Content-Length", Integer.toString(postDataLenght));
            conn.setUseCaches(false);
            if (conn.getResponseCode() != 200) {
                throw new RuntimeException("Failed :HTTP error code:" + conn.getResponseCode());
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((output = br.readLine()) != null) {
                if (output.length() <= 2) continue;
                response = output;
            }
            return response;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "Error in storing User chatid";
        }
    }

    public String verifyOTP(String chatid, String otp, String botName, HttpServletRequest request) {
        String result = "";
        try {
            String output;
            String ENTERPRISE = this.getEnterprise(botToken, botName, request);
            String urlStr = String.valueOf(this.getServerIP(request)) + "/ibase/rest/telegrambot/verifyOtp?chatId=" + chatid + "&otp=" + otp + "&enterprise=" + ENTERPRISE;
            URL url = new URL(urlStr);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setRequestProperty("Accept", "application/json");
            if (conn.getResponseCode() != 200) {
                throw new RuntimeException("Failed :HTTP error code:" + conn.getResponseCode());
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((output = br.readLine()) != null) {
                result = String.valueOf(result) + result + output;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public String getServerIP(HttpServletRequest request) {
        System.out.println("Inside getServerIP");
        String baseURL = CommonConstants.TOMCAT_HOME;
        if (E12GenericUtility.checkNull((String)baseURL).equalsIgnoreCase("")) {
            String portStr;
            String serverName;
            String scheme = request.getHeader("X-Forwarded-Proto");
            if (scheme == null) {
                scheme = request.getScheme();
            }
            if ((serverName = request.getHeader("X-Forwarded-Host")) == null) {
                serverName = request.getServerName();
            }
            int serverPort = (portStr = request.getHeader("X-Forwarded-Port")) != null ? Integer.parseInt(portStr) : request.getServerPort();
            baseURL = String.valueOf(scheme) + "://" + serverName + ":" + serverPort;
        }
        System.out.println("Inside getServerIP: result[" + baseURL + "]");
        return baseURL;
    }

    public String addChatIdOtp(String chatId, String otp, String botName, String emailID, String botToken, HttpServletRequest request) {
        try {
            String output;
            String response = "";
            String ENTERPRISE = this.getEnterprise(botToken, botName, request);
            String utlParameters = "chatId=" + chatId + "&otp=" + otp + "&enterprise=" + ENTERPRISE;
            byte[] postData = utlParameters.getBytes(StandardCharsets.UTF_8);
            int postDataLenght = postData.length;
            String urlStr = String.valueOf(this.getServerIP(request)) + "/ibase/rest/telegrambot/addUserOtp?chatId=" + chatId + "&otp=" + otp + "&enterprise=" + ENTERPRISE + "&emailID=" + emailID + "&botToken=" + botToken;
            System.out.println("URL=" + urlStr);
            URL url = new URL(urlStr);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setDoOutput(true);
            conn.setInstanceFollowRedirects(false);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            conn.setRequestProperty("charset", "utf-8");
            conn.setRequestProperty("Content-Length", Integer.toString(postDataLenght));
            conn.setUseCaches(false);
            if (conn.getResponseCode() != 200) {
                throw new RuntimeException("Failed :HTTP error code:" + conn.getResponseCode());
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((output = br.readLine()) != null) {
                if (output.length() <= 2) continue;
                response = output;
            }
            return response;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "Error in storing User chatid";
        }
    }

    public boolean addUserChatid(UserDetails userDetail, String chatid, String bottoken, String botName, String enterprise, HttpServletRequest request) {
        try {
            String output;
            String userId = userDetail.getUserCode();
            String entityType = userDetail.getEntity_type();
            String tokenId = "";
            RestAPIServiceUtility restapiserviceutility = new RestAPIServiceUtility();
            ExtAuthApplicationBean applicationBean = restapiserviceutility.getCommonDBAccess().getExtAuthApplicationInfo("TLG_APPVIS");
            APIUtility apiUtility = new APIUtility();
            tokenId = entityType.equalsIgnoreCase("U") ? apiUtility.getJWTToken(userId, applicationBean) : apiUtility.getJWTToken(userId, applicationBean, entityType, enterprise, chatid);
            System.out.println("addUserChatid token id gsb: [" + tokenId + "]");
            String response = null;
            String ENTERPRISE = this.getEnterprise(botToken, botName, request);
            String utlParameters = "userEmail=" + userDetail.getEmail() + "&chatId=" + chatid + "&userId=" + userDetail.getUserCode() + "&userType=" + userDetail.getUserType() + "&botToken=" + tokenId + "&enterprise=" + ENTERPRISE + "&entityType=" + userDetail.getEntity_type() + "&entityCode=" + userDetail.getEntity_code() + "&userName=" + userDetail.getUserName();
            byte[] postData = utlParameters.getBytes(StandardCharsets.UTF_8);
            int postDataLenght = postData.length;
            String urlStr = String.valueOf(this.getServerIP(request)) + "/ibase/rest/telegrambot/addUsersChatid?" + "userEmail=" + userDetail.getEmail().trim() + "&chatId=" + chatid + "&userId=" + userDetail.getUserCode().trim() + "&userType=" + userDetail.getUserType().trim() + "&botToken=" + tokenId + "&enterprise=" + ENTERPRISE + "&entityType=" + userDetail.getEntity_type().trim() + "&entityCode=" + userDetail.getEntity_code().trim() + "&userName=" + userDetail.getUserCode().trim();
            System.out.println("addUserChatid url=" + urlStr);
            URL url = new URL(urlStr);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setDoOutput(true);
            conn.setInstanceFollowRedirects(false);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            conn.setRequestProperty("charset", "utf-8");
            conn.setRequestProperty("Content-Length", Integer.toString(postDataLenght));
            conn.setUseCaches(false);
            if (conn.getResponseCode() != 200) {
                throw new RuntimeException("Failed :HTTP error code:" + conn.getResponseCode());
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((output = br.readLine()) != null) {
                if (output.length() <= 2) continue;
                response = output;
            }
            System.out.println("Response " + response);
            return response.contains("Chat id Stored");
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            String exceptionDetails = sw.toString();
            BaseLogger.log((String)"0", null, null, (Object)("Exception addUserChatID" + e.getMessage() + "]\n" + exceptionDetails));
            return false;
        }
    }

    public static void main(String[] args) {
    }

    public boolean isNumber(String otp) {
        try {
            Integer.parseInt(otp);
            return true;
        }
        catch (Exception e) {
            System.out.println("Not Number " + e.getMessage());
            return false;
        }
    }

    public boolean checkEmail(String email) {
        System.out.println("Inside checkEmail");
        String EMAIL_PATTERN = "^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$";
        Pattern pattern = Pattern.compile(EMAIL_PATTERN);
        Matcher matcher = pattern.matcher(email);
        return matcher.matches();
    }
}

