/*
 * Decompiled with CFR 0.152.
 */
package ibase.wrkflw.utility;

import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.wrkflw.utility.WorkflowProcessIdGenerator;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.Statement;
import java.util.Date;
import java.util.Properties;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.HTMLLayout;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.RollingFileAppender;

public class WorkflowLogger {
    public static Logger logger = null;
    public static int EXCEPTION_HANDLE_TYPE = 0;
    public static int checkFileChangeRate = 1;

    static {
        try {
            logger = Logger.getLogger((String)"WorkflowLogger");
            String propFileDir = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "server" + File.separator + "default" + File.separator + "configuration" + File.separator + "workflowlogger.properties";
            BaseLogger.log("3", null, null, "\n\n<<<<<<<<<<<<<< Properties File Directory : [" + propFileDir + "] >>>>>>>>>>>>>>>");
            File propFile = new File(propFileDir);
            if (propFile.exists()) {
                Properties properties = new Properties();
                FileInputStream fin = new FileInputStream(propFile);
                properties.load(fin);
                String layout = properties.getProperty("layout").trim();
                String appender = properties.getProperty("appender").trim();
                BaseLogger.log("3", null, null, "\n\n  PropertiesFile.layout : [" + layout + "], PropertiesFile.appender : [" + appender + "]\n\n");
                if (layout.equalsIgnoreCase("HTMLLayout")) {
                    HTMLLayout htmlLayout = new HTMLLayout();
                    String logFilePath = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "server" + File.separator + "default" + File.separator + "log" + File.separator + "workflowlog.html";
                    BaseLogger.log("3", null, null, "\n\n logFilePath ==> [" + logFilePath + "]");
                    if (appender.equalsIgnoreCase("FileAppender")) {
                        FileAppender fileApndr = new FileAppender((Layout)htmlLayout, logFilePath);
                        fileApndr.getEncoding();
                        logger.addAppender((Appender)fileApndr);
                    } else if (appender.equalsIgnoreCase("RollingFileAppender")) {
                        RollingFileAppender rFileApndr = new RollingFileAppender((Layout)htmlLayout, logFilePath);
                        rFileApndr.setMaxBackupIndex(Integer.parseInt(properties.getProperty("maxBackupIndex").trim()));
                        rFileApndr.setMaxFileSize(properties.getProperty("maxFileSize").trim());
                        logger.addAppender((Appender)rFileApndr);
                    }
                }
                fin.close();
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :ScheduleLogger :==>Unable to get RootLogger" + e.getMessage());
        }
    }

    public static void debug(Object msg) {
        logger.debug((Object)("\n " + msg));
    }

    public static void debug(Object msg, Throwable t) {
        logger.debug((Object)("\n " + msg), t);
    }

    public static void info(Object msg) {
        logger.info((Object)("\n " + msg));
    }

    public static void info(Object msg, Throwable t) {
        logger.info((Object)("\n " + msg), t);
    }

    public static void warn(Object msg) {
        logger.warn((Object)("\n " + msg));
    }

    public static void warn(Object msg, Throwable t) {
        logger.warn((Object)("\n " + msg), t);
    }

    public static void error(Object msg) {
        logger.error((Object)("\n " + msg));
    }

    public static void error(Object msg, Throwable t) {
        logger.error((Object)("\n " + msg), t);
    }

    public static void fatal(Object msg) {
        logger.fatal((Object)("\n " + msg));
    }

    public static void fatal(Object msg, Throwable t) {
        logger.fatal((Object)("\n " + msg), t);
    }

    public static void writeStackTraceToFile(Exception e, String processInstanceId) throws Exception {
        OutputStreamWriter fstream = null;
        BufferedWriter out = null;
        PrintWriter pWriter = null;
        Connection con = null;
        Statement stmt = null;
        try {
            try {
                String fileName = String.valueOf(processInstanceId) + new Date().toString();
                String filePath = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "server" + File.separator + "default" + File.separator + "log" + File.separator + fileName;
                fstream = new FileWriter(filePath, true);
                out = new BufferedWriter(fstream);
                pWriter = new PrintWriter((Writer)out, true);
                e.printStackTrace(pWriter);
                String processId = WorkflowProcessIdGenerator.getInstance().getProcessId(processInstanceId);
                String instanceId = WorkflowProcessIdGenerator.getInstance().getInstanceId(processInstanceId);
                String activityId = WorkflowProcessIdGenerator.getInstance().getActivityId(processInstanceId);
                String seqId = WorkflowProcessIdGenerator.getInstance().getSeqId(processInstanceId);
                String sysdateStr = "";
                sysdateStr = "DB2".equalsIgnoreCase(CommonConstants.DB_NAME) ? "fn_sysdate()" : ("mssql".equalsIgnoreCase(CommonConstants.DB_NAME) ? " getdate() " : " sysdate ");
                StringBuffer updQueryBuff = new StringBuffer("UPDATE WF_PRC_STATUS SET STATUS_DATE =");
                updQueryBuff.append(sysdateStr);
                updQueryBuff.append(", ERR_STATUS = '1', STATUS_REMARKS=' Error Stack at ");
                updQueryBuff.append(fileName).append("' ");
                updQueryBuff.append(" WHERE PROCESS_ID='").append(processId).append("' AND INSTANCE_ID=").append(Integer.parseInt(instanceId)).append(" AND ACTIVITY_ID='").append(activityId).append("' AND SEQ_ID=" + seqId + " ");
                WorkflowLogger.info(updQueryBuff);
                ConnDriver connDriver = new ConnDriver();
                con = connDriver.getConnectDB(CommonConstants.WRKFLW_DB);
                stmt = con.createStatement();
                stmt.executeUpdate(updQueryBuff.toString());
                con.commit();
            }
            catch (Exception ie) {
                throw new RuntimeException("Could not write Exception to file", ie);
            }
        }
        finally {
            if (fstream != null) {
                fstream.flush();
            }
            if (out != null) {
                out.flush();
            }
            if (pWriter != null) {
                pWriter.flush();
            }
            if (stmt != null) {
                stmt.close();
            }
            stmt = null;
            if (con != null) {
                con.close();
            }
            con = null;
        }
    }
}

