package ibase.webitm.ejb.wsfa.transactions;

/*
 * Author: Gagan B.
 * Date: 25-SEP-2023
 * Purpose: Java component which will be called on follow-up action and create task by getting details from TASK_MST.
 * */

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDate;

import ibase.ejb.CommonDBAccessEJB;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;

public class FollowUpActionGenerateTask extends ValidatorEJB {

	public String generateTask(String tranID, String xtraParam, Connection conn) {
		String result = "";
		CommonDBAccessEJB commonDBAccessEJB = new CommonDBAccessEJB();
		BaseLogger.log("3", null, null, "Inside generateTask tranID [" + tranID + "]");
		BaseLogger.log("3", null, null, "Inside generateTask xtraParam [" + xtraParam + "]");

		E12GenericUtility genericUtility = new E12GenericUtility();

		try {
			String userCode = genericUtility.getValueFromXTRA_PARAMS(xtraParam, "loginCode");
			BaseLogger.log("3", null, null, "Inside generateTask userCode [" + userCode + "]");

			UserInfoBean userInfo = commonDBAccessEJB.createUserInfo(userCode);
			String objName = genericUtility.getValueFromXTRA_PARAMS(xtraParam, "objName");
			BaseLogger.log("3", null, null, "Inside generateTask objName [" + objName + "]");

			DBAccessEJB dbAccessEJB = new DBAccessEJB();
			String refSer = "";
			String tranWindow = "w_" + objName;
			try {
				refSer = E12GenericUtility.checkNull(dbAccessEJB.getDBColumnValue("TRANSETUP", "REF_SER",
						"TRAN_WINDOW  = '" + tranWindow + "'", userInfo.getTransDB()));
				BaseLogger.log("3", null, null, "Inside generateTask refSer [" + refSer + "]");

				String getTaskDetailsFromTaskMstResult = getTaskDetailsFromTaskMst(refSer, userInfo);
				BaseLogger.log("3", null, null,
						"Inside generateTask getTaskDetailsFromTaskMstResult [" + getTaskDetailsFromTaskMstResult + "]");

			} catch (RemoteException | ITMException e) {
				e.printStackTrace();
			}

		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		return result;
	}

	// method for getting task details from TASK_MST.
	public String getTaskDetailsFromTaskMst(String refSer, UserInfoBean userInfo) throws ITMException, SQLException {
		String result = "";

		Connection connection = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;

		try {
			ConnDriver connDriver = new ConnDriver();
			connection = connDriver.getConnectDB(userInfo.getTransDB());

			String getTaskDetailsFromTaskMstSQL = "SELECT * FROM TASK_MST WHERE REF_SER = ?";
			pstmt = connection.prepareStatement(getTaskDetailsFromTaskMstSQL);

			pstmt.setString(1, refSer);

			rs = pstmt.executeQuery();

			while (rs.next()) {
				String taskCode = rs.getString("TASK_CODE");
				BaseLogger.log("3", null, null, "Inside createUserTask taskCode [" + taskCode + "]");

				String descr = rs.getString("DESCR");
				BaseLogger.log("3", null, null, "Inside createUserTask descr [" + descr + "]");

				String refID = rs.getString("REF_ID");
				BaseLogger.log("3", null, null, "Inside createUserTask refID [" + refID + "]");

				String expTat = rs.getString("EXP_TAT");
				BaseLogger.log("3", null, null, "Inside createUserTask expTat [" + expTat + "]");

				String taskDet = rs.getString("TASK_DET");
				BaseLogger.log("3", null, null, "Inside createUserTask taskDet [" + taskDet + "]");
				
//				createUserTask(String taskDescr, String taskCode, String expTat ,String refSer, String refID, String ipAddress, UserInfoBean userInfo)
				result = createUserTask(taskDet, taskCode, expTat, refSer, refID, "", userInfo);
				BaseLogger.log("3", null, null,
						"Inside getTaskDetailsFromTaskMst createUserTaskResult [" + result + "]");

			}

			rs.close();

			rs = null;
			pstmt.close();
			pstmt = null;
			connection.close();
			connection = null;

		} catch (Exception e) {
			BaseLogger.log("0", userInfo, null, "FollowUpActionGenerateTask.getTaskDetailsFromTaskMst() Exception = ["
					+ E12GenericUtility.getStackTrace(e) + "]");
			throw new ITMException(e);
		} finally {
			if (connection != null) {
				if (rs != null) {
					rs.close();
					rs = null;
				}
				if (pstmt != null) {
					pstmt.close();
					pstmt = null;
				}
				if (connection != null) {
					connection.close();
					connection = null;
				}
			}
		}
		return result;
	}

	// method for inserting value in USER_TASKS.
	public String createUserTask(String taskDescr, String taskCode, String expTat ,String refSer, String refID, String ipAddress, UserInfoBean userInfo) throws ITMException, SQLException {
		BaseLogger.log("3", null, null, "Inside createUserTask loginCode [" + userInfo.getLoginCode() + "]");
		String result = "";

		Connection connection = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		
		String tranID = "";
		CommonDBAccessEJB commonDBAccessEJB = new CommonDBAccessEJB();
		String chgTerm = ipAddress;
		String chgUser = userInfo.getLoginCode();
		int expTatInt = Integer.parseInt(expTat);
		
        LocalDate today = LocalDate.now();

		LocalDate expCompDate = today.plusDays(expTatInt);
		
		if (userInfo != null) {
			tranID = commonDBAccessEJB.generateSeq("comm_log_seq", 10, userInfo.getTransDB());
		}

		try {
			ConnDriver connDriver = new ConnDriver();
			connection = connDriver.getConnectDB(userInfo.getTransDB());

			String userTaskInsertSQL = "Insert into USER_TASKS "
					+ "(TRAN_ID,TRAN_DATE,USER_ID,TASK_DESCR,TASK_TYPE,"
					+ "TASK_DOMAIN,TASK_CODE,USER_ID__ASSIGNED,EXP_COMPL_DATE,CURR_STATUS,"
					+ "STATUS_DATE,COMPL_REMARKS,ADD_DATE,ADD_USER,ADD_TERM,"
					+ "CHG_DATE,CHG_USER,CHG_TERM,REF_SER,REF_ID) values \n"
					+ "(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
			pstmt = connection.prepareStatement(userTaskInsertSQL);

			pstmt.setString(1, tranID);
			pstmt.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
			pstmt.setString(3, userInfo.getLoginCode());
			pstmt.setString(4, taskDescr);
			pstmt.setString(5, "");
			pstmt.setString(6, "");
			pstmt.setString(7, taskCode);
			pstmt.setString(8, chgUser);
			pstmt.setDate(9, java.sql.Date.valueOf(expCompDate));
			pstmt.setString(10, "");
			pstmt.setString(11, "");
			pstmt.setString(12, "");
			pstmt.setTimestamp(13, new Timestamp(System.currentTimeMillis()));
			pstmt.setString(14, userInfo.getLoginCode());
			pstmt.setString(15, ipAddress);
			pstmt.setTimestamp(16, new Timestamp(System.currentTimeMillis()));
			pstmt.setString(17, userInfo.getLoginCode());
			pstmt.setString(18, ipAddress);
			pstmt.setString(19, refSer);
			pstmt.setString(20, refID);
			
			int insCnt = pstmt.executeUpdate();
			if (insCnt > 0) 
			{
				connection.commit();
				result = "Task created";
			} else {
				result = "Task not created";
			}

			rs = null;
			pstmt.close();
			pstmt = null;
			connection.close();
			connection = null;

		} catch (Exception e) {
			BaseLogger.log("0", userInfo, null, "FollowUpActionGenerateTask.createUserTask() Exception = ["
					+ E12GenericUtility.getStackTrace(e) + "]");
			throw new ITMException(e);
		} finally {
			if (connection != null) {
				if (rs != null) {
					rs.close();
					rs = null;
				}
				if (pstmt != null) {
					pstmt.close();
					pstmt = null;
				}
				if (connection != null) {
					connection.close();
					connection = null;
				}
			}
		}
		return result;
	}

}
