/*
 * Decompiled with CFR 0.152.
 */
package ibase.webService;

import com.auth0.jwt.JWT;
import com.auth0.jwt.exceptions.JWTDecodeException;
import com.auth0.jwt.interfaces.DecodedJWT;
import ibase.bis.bean.BusinessIntent;
import ibase.bis.bean.GoogleSignInIdToken;
import ibase.bis.ejb.BusinessIntentEJB;
import ibase.bis.utility.BISUtility;
import ibase.ejb.CommonDBAccessEJB;
import ibase.utility.BaseException;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.EventManagerEJB;
import ibase.webitm.notification.ejb.PublishPushNotificationEJB;
import ibase.webitm.utility.APIUtility;
import ibase.webitm.utility.ITMException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Path(value="/BISService")
public class BISService {
    private E12GenericUtility genericUtility = new E12GenericUtility();
    private BISUtility bisUtility = new BISUtility();
    private UserInfoBean userInfo = null;
    private static HashMap<String, String> intentAccessMap = new HashMap();
    private boolean isAuthenticatedByTokenGmail = false;
    private boolean isIdTokenAvailable = true;

    @POST
    @Path(value="/intent")
    @Produces(value={"application/json"})
    public Response getIntentMetadata(@Context HttpServletRequest request) throws BaseException, Exception {
        String result = "";
        String params = "";
        String status = "error";
        try {
            params = request.getQueryString();
            if (this.checkNull(params).length() == 0) {
                StringBuffer paramString = new StringBuffer();
                params = paramString.toString();
            }
            BaseLogger.log((String)"3", null, null, (Object)("params - " + params));
            BaseLogger.log((String)"3", null, null, (Object)("USER_INFO : [" + request.getSession().getAttribute("USER_INFO") + "]"));
            this.userInfo = (UserInfoBean)request.getSession().getAttribute("USER_INFO");
            BusinessIntentEJB businessIntent = new BusinessIntentEJB();
            businessIntent.setUserInfo(this.userInfo);
            result = businessIntent.getIntents(null);
            businessIntent = null;
            JSONArray intentJsonArr = null;
            result = this.checkNull(result);
            if (result.length() > 0) {
                intentJsonArr = new JSONArray(result);
            }
            status = "success";
        }
        catch (Exception e) {
            BaseLogger.log((String)"0", null, null, (Object)("Exception : getIntentMetadata : " + e.getMessage()));
            status = "exception";
            result = this.getStackTrace(e);
        }
        return Response.status((int)200).entity((Object)result).build();
    }

    @POST
    @Path(value="/invokeIntent")
    @Produces(value={"application/json"})
    public Response invokeIntent(@QueryParam(value="INTENT_PARAM") String intentParam, @Context HttpServletRequest request, @HeaderParam(value="TOKEN_ID") String tokenIDfromHeader) throws BaseException, Exception {
        String result;
        block69: {
            String uuidString;
            String userId;
            String pineconeIntentId;
            String intentIdDesc;
            JSONArray entitiesValArr;
            String responseTo;
            boolean isAuthenticated;
            boolean inferred;
            JSONObject nlpDetailsJson;
            String tranId;
            String userMsg;
            boolean isBrowser;
            String intents;
            JSONObject invokeJson;
            String respReturned;
            String intentFound;
            String excpInfo;
            String bisIntentId;
            String identity;
            String status;
            String params;
            block68: {
                result = "";
                params = "";
                status = "error";
                identity = "";
                bisIntentId = "";
                excpInfo = "";
                intentFound = "";
                respReturned = "";
                invokeJson = null;
                intents = "";
                String intentStoredKey = "";
                isBrowser = false;
                userMsg = "";
                tranId = "";
                nlpDetailsJson = null;
                inferred = false;
                isAuthenticated = false;
                String intentType = "";
                responseTo = "vision";
                BusinessIntentEJB businessIntent = new BusinessIntentEJB();
                this.isAuthenticatedByTokenGmail = false;
                this.isIdTokenAvailable = true;
                entitiesValArr = new JSONArray();
                intentIdDesc = "";
                pineconeIntentId = "";
                userId = "";
                uuidString = "";
                try {
                    try {
                        params = request.getQueryString();
                        if (this.checkNull(params).length() == 0) {
                            StringBuffer paramString = new StringBuffer();
                            params = paramString.toString();
                        }
                        BaseLogger.log((String)"3", null, null, (Object)("BISService.invokeIntent() params : " + params));
                        BaseLogger.log((String)"3", null, null, (Object)("BISService.invokeIntent() intentParam : [" + intentParam + "]"));
                        JSONObject inputArgJson = this.getInputArgJson(intentParam, request);
                        BaseLogger.log((String)"3", null, null, (Object)("BISService.invokeIntent() inputArgJson : [" + inputArgJson + "]"));
                        identity = this.getIdentity(inputArgJson);
                        bisIntentId = this.getJsonStringValue(inputArgJson, "BIS_INTENT_ID");
                        this.setUserInfo(inputArgJson, request);
                        if (this.userInfo == null) {
                            APIUtility apiUtility = new APIUtility();
                            this.userInfo = apiUtility.createUserInfoFromJWTToken(tokenIDfromHeader);
                            BaseLogger.log((String)"3", null, null, (Object)("BISService.invokeIntent() USER_INFO created from TOKEN: [" + this.userInfo + "]"));
                        }
                        BaseLogger.log((String)"3", null, null, (Object)("BISService.invokeIntent() USER_INFO : [" + this.userInfo + "]"));
                        if (this.userInfo == null) {
                            if (!inputArgJson.has("INPUT_TEXT")) {
                                responseTo = "google";
                            }
                            throw new Exception("SESSION_EXPIRED");
                        }
                        if (inputArgJson != null && inputArgJson.has("UUID") && inputArgJson.has("USER_ID")) {
                            uuidString = inputArgJson.optString("UUID");
                            userId = inputArgJson.optString("USER_ID");
                        }
                        if (uuidString == null || uuidString != null && this.checkNull(uuidString).length() == 0) {
                            userId = this.userInfo.getLoginCode();
                            String uuid = UUID.randomUUID().toString();
                            uuidString = uuid.toString().replace("-", "");
                            if (uuidString.length() > 20) {
                                uuidString = uuidString.substring(0, 20);
                            } else if (uuidString.length() < 20) {
                                uuidString = String.format("%-20s", uuidString).replace(' ', '0');
                            }
                        }
                        isAuthenticated = true;
                        String requestedTerm = this.getChgTerm(request);
                        isBrowser = this.isBrowser(inputArgJson);
                        userMsg = this.getJsonStringValue(inputArgJson, "USER_MSG");
                        BaseLogger.log((String)"3", null, null, (Object)("BISService.invokeIntent() userMsg [" + userMsg + "]"));
                        tranId = businessIntent.createBisServiceLog(this.userInfo, requestedTerm, params);
                        String inputIntentText = "";
                        if (inputArgJson.has("INPUT_TEXT")) {
                            inputIntentText = inputArgJson.getString("INPUT_TEXT").toLowerCase();
                            BaseLogger.log((String)"3", null, null, (Object)("BISService.invokeIntent() inputIntentText : [" + inputIntentText + "]"));
                        }
                        String posRespPhrases = "";
                        String negRespPhrases = "";
                        String lastIntentPrevValue = "";
                        BusinessIntent intentBean = (BusinessIntent)BusinessIntentEJB.userwiseLastBusinessIntent.get(String.valueOf(this.userInfo.getLoginCode()) + "_LAST_INTENTBEAN");
                        if (intentBean != null) {
                            BaseLogger.log((String)"3", null, null, (Object)("BISService.invokeIntent() intentBean : [" + intentBean.toString() + "]"));
                            lastIntentPrevValue = E12GenericUtility.checkNull((String)intentBean.getPreviewVal());
                            BaseLogger.log((String)"3", (UserInfoBean)this.userInfo, null, (Object)("BISService.invokeIntent() lastIntentPrevValue : [" + lastIntentPrevValue + "]"));
                            posRespPhrases = E12GenericUtility.checkNull((String)intentBean.getPositiveRespPhrase()).toLowerCase();
                            BaseLogger.log((String)"3", (UserInfoBean)this.userInfo, null, (Object)("BISService.invokeIntent() posRespPhrases : [" + posRespPhrases + "]"));
                            negRespPhrases = E12GenericUtility.checkNull((String)intentBean.getNegativeRespPhrase()).toLowerCase();
                            BaseLogger.log((String)"3", (UserInfoBean)this.userInfo, null, (Object)("BISService.invokeIntent() negRespPhrases : [" + negRespPhrases + "]"));
                        }
                        if (intentBean != null && "Y".equalsIgnoreCase(lastIntentPrevValue) && ("no".equalsIgnoreCase(inputIntentText) || negRespPhrases != null && negRespPhrases.contains(inputIntentText))) {
                            JSONObject intentInputJson = (JSONObject)BusinessIntentEJB.userwiseIntentInputJson.get(String.valueOf(this.userInfo.getLoginCode()) + "_LAST_INTENT_INPUT_JSON");
                            BaseLogger.log((String)"3", (UserInfoBean)this.userInfo, null, (Object)("BISService.invokeIntent() intentInputJson : [" + intentInputJson + "]"));
                            JSONObject respJson = (JSONObject)BusinessIntentEJB.userwiseIntentRespJson.get("LAST_INTENT_RESP_JSON");
                            BaseLogger.log((String)"3", null, null, (Object)("BISService.invokeIntent() respJson : [" + respJson + "]"));
                            String lastUserInput = E12GenericUtility.checkNull((String)intentInputJson.getString("USER_MSG"));
                            BaseLogger.log((String)"3", (UserInfoBean)this.userInfo, null, (Object)("BISService.invokeIntent() lastUserInput : [" + lastUserInput + "]"));
                            uuidString = E12GenericUtility.checkNull((String)intentInputJson.getString("UUID"));
                            BaseLogger.log((String)"3", null, null, (Object)("BISService.invokeIntent() uuidString : [" + uuidString + "]"));
                            userId = E12GenericUtility.checkNull((String)intentInputJson.getString("USER_ID"));
                            BaseLogger.log((String)"3", null, null, (Object)("BISService.invokeIntent() userId : [" + userId + "]"));
                            if (respJson != null && respJson.length() > 0) {
                                bisIntentId = this.getJsonStringValue(respJson, "bisIntentId");
                                BaseLogger.log((String)"3", null, null, (Object)("BISService.invokeIntent() bisIntentId : [" + bisIntentId + "]"));
                                inputArgJson = respJson.getJSONObject("inputArgJson");
                                BaseLogger.log((String)"3", null, null, (Object)("BISService.invokeIntent() inputArgJson : [" + inputArgJson + "]"));
                                inferred = respJson.getBoolean("inferred");
                                BaseLogger.log((String)"3", null, null, (Object)("BISService.invokeIntent() inferred : [" + inferred + "]"));
                                intents = this.getJsonStringValue(respJson, "intents");
                                BaseLogger.log((String)"3", null, null, (Object)("BISService.invokeIntent() intents : [" + intents + "]"));
                                intentParam = this.getJsonStringValue(respJson, "intentParam");
                                BaseLogger.log((String)"3", null, null, (Object)("BISService.invokeIntent() intentParam : [" + intentParam + "]"));
                                nlpDetailsJson = respJson.getJSONObject("nlp_details");
                                BaseLogger.log((String)"3", null, null, (Object)("BISService.invokeIntent() nlpDetailsJson : [" + nlpDetailsJson + "]"));
                                entitiesValArr = inputArgJson.getJSONArray("NER");
                                BaseLogger.log((String)"3", null, null, (Object)("BISService.invokeIntent() entitiesValArr : [" + entitiesValArr + "]"));
                                intentIdDesc = respJson.getString("intent_descr");
                                BaseLogger.log((String)"3", null, null, (Object)("BISService.invokeIntent() intentIdDesc : [" + intentIdDesc + "]"));
                                pineconeIntentId = respJson.getString("pinecone_intent_id");
                                BaseLogger.log((String)"3", null, null, (Object)("BISService.invokeIntent() pineconeIntentId : [" + pineconeIntentId + "]"));
                            }
                            BaseLogger.log((String)"3", null, null, (Object)("BISService.invokeIntent() processRequest result : [" + result + "]"));
                            businessIntent.setUserInfo(this.userInfo);
                            businessIntent.setResponseTo(responseTo);
                            result = businessIntent.generateSucessString((Object)"Ok", intentBean, "");
                            invokeJson = new JSONObject(result);
                            BaseLogger.log((String)"3", null, null, (Object)("BISService.invokeIntent() invokeJson : [" + invokeJson + "]"));
                            respReturned = "1";
                            status = "success";
                            intentFound = "1";
                            BusinessIntentEJB.userwiseIntentInputJson.clear();
                            BusinessIntentEJB.userwiseIntentRespJson.clear();
                            BusinessIntentEJB.userwiseLastBusinessIntent.clear();
                            BusinessIntentEJB.userwiseLastIntentDetail.clear();
                            break block68;
                        }
                        if (intentBean != null && "Y".equalsIgnoreCase(lastIntentPrevValue) && ("yes".equalsIgnoreCase(inputIntentText) || posRespPhrases != null && posRespPhrases.contains(inputIntentText))) {
                            String updatedXML = (String)BusinessIntentEJB.userwiseLastIntentDetail.get(String.valueOf(this.userInfo.getLoginCode()) + "_LAST_UPDATED_XML");
                            BaseLogger.log((String)"3", null, null, (Object)("BISService.invokeIntent() updatedXML : [" + updatedXML + "]"));
                            JSONObject intentInputJson = (JSONObject)BusinessIntentEJB.userwiseIntentInputJson.get(String.valueOf(this.userInfo.getLoginCode()) + "_LAST_INTENT_INPUT_JSON");
                            BaseLogger.log((String)"3", (UserInfoBean)this.userInfo, null, (Object)("BISService.invokeIntent() intentInputJson : [" + intentInputJson + "]"));
                            JSONObject respJson = (JSONObject)BusinessIntentEJB.userwiseIntentRespJson.get("LAST_INTENT_RESP_JSON");
                            BaseLogger.log((String)"3", null, null, (Object)("BISService.invokeIntent() respJson : [" + respJson + "]"));
                            String lastUserInput = E12GenericUtility.checkNull((String)intentInputJson.getString("USER_MSG"));
                            BaseLogger.log((String)"3", (UserInfoBean)this.userInfo, null, (Object)("BISService.invokeIntent() lastUserInput : [" + lastUserInput + "]"));
                            uuidString = E12GenericUtility.checkNull((String)intentInputJson.getString("UUID"));
                            BaseLogger.log((String)"3", null, null, (Object)("BISService.invokeIntent() uuidString : [" + uuidString + "]"));
                            userId = E12GenericUtility.checkNull((String)intentInputJson.getString("USER_ID"));
                            BaseLogger.log((String)"3", null, null, (Object)("BISService.invokeIntent() userId : [" + userId + "]"));
                            if (respJson != null && respJson.length() > 0) {
                                bisIntentId = this.getJsonStringValue(respJson, "bisIntentId");
                                BaseLogger.log((String)"3", null, null, (Object)("BISService.invokeIntent() bisIntentId : [" + bisIntentId + "]"));
                                inputArgJson = respJson.getJSONObject("inputArgJson");
                                BaseLogger.log((String)"3", null, null, (Object)("BISService.invokeIntent() inputArgJson : [" + inputArgJson + "]"));
                                inferred = respJson.getBoolean("inferred");
                                BaseLogger.log((String)"3", null, null, (Object)("BISService.invokeIntent() inferred : [" + inferred + "]"));
                                intents = this.getJsonStringValue(respJson, "intents");
                                BaseLogger.log((String)"3", null, null, (Object)("BISService.invokeIntent() intents : [" + intents + "]"));
                                intentParam = this.getJsonStringValue(respJson, "intentParam");
                                BaseLogger.log((String)"3", null, null, (Object)("BISService.invokeIntent() intentParam : [" + intentParam + "]"));
                                nlpDetailsJson = respJson.getJSONObject("nlp_details");
                                BaseLogger.log((String)"3", null, null, (Object)("BISService.invokeIntent() nlpDetailsJson : [" + nlpDetailsJson + "]"));
                                entitiesValArr = inputArgJson.getJSONArray("NER");
                                BaseLogger.log((String)"3", null, null, (Object)("BISService.invokeIntent() entitiesValArr : [" + entitiesValArr + "]"));
                                intentIdDesc = respJson.getString("intent_descr");
                                BaseLogger.log((String)"3", null, null, (Object)("BISService.invokeIntent() intentIdDesc : [" + intentIdDesc + "]"));
                                pineconeIntentId = respJson.getString("pinecone_intent_id");
                                BaseLogger.log((String)"3", null, null, (Object)("BISService.invokeIntent() pineconeIntentId : [" + pineconeIntentId + "]"));
                            }
                            result = businessIntent.callProcessRequest(updatedXML, this.userInfo, intentBean);
                            result = this.checkNull(result);
                            BaseLogger.log((String)"3", null, null, (Object)("BISService.invokeIntent() processRequest result : [" + result + "]"));
                            if (result.length() > 0) {
                                businessIntent.setUserInfo(this.userInfo);
                                businessIntent.setResponseTo(responseTo);
                                result = businessIntent.generateSucessString((Object)result, intentBean, "");
                                invokeJson = new JSONObject(result);
                                BaseLogger.log((String)"3", null, null, (Object)("BISService.invokeIntent() invokeJson : [" + invokeJson + "]"));
                                respReturned = "1";
                            } else {
                                respReturned = "0";
                            }
                            status = "success";
                            intentFound = "1";
                            BusinessIntentEJB.userwiseIntentInputJson.clear();
                            BusinessIntentEJB.userwiseIntentRespJson.clear();
                            BusinessIntentEJB.userwiseLastBusinessIntent.clear();
                            BusinessIntentEJB.userwiseLastIntentDetail.clear();
                            break block68;
                        }
                        if (bisIntentId.length() == 0 && "actions.intent.MAIN".equalsIgnoreCase(intentType = this.getRequestInputDetails(inputArgJson, "inputs", "intent"))) {
                            bisIntentId = "WELCOME";
                            inputArgJson.put("BIS_INTENT_ID", (Object)bisIntentId);
                            intentParam = String.valueOf(inputArgJson);
                            responseTo = "google";
                        }
                        if (bisIntentId.length() == 0) {
                            Map pythonServices;
                            String inputText = "";
                            if (inputArgJson.has("INPUT_TEXT")) {
                                inputText = inputArgJson.getString("INPUT_TEXT");
                            } else {
                                inputText = this.getRequestInputDetails(inputArgJson, "inputs", "query");
                                responseTo = "google";
                            }
                            if (inputText != null && inputText.trim().length() > 0 && (pythonServices = CommonConstants.PYTHON_SERVICES) != null) {
                                JSONObject respJson = this.processInputText(pythonServices, inputText, inputArgJson, intentParam);
                                BaseLogger.log((String)"3", null, null, (Object)("BISService.invokeIntent() OPenAI respJson : [" + respJson + "]"));
                                BusinessIntentEJB.userwiseIntentRespJson.put("LAST_INTENT_RESP_JSON", respJson);
                                if (respJson != null && respJson.length() > 0) {
                                    if (respJson.has("system_exception")) {
                                        excpInfo = respJson.toString();
                                    } else {
                                        bisIntentId = this.getJsonStringValue(respJson, "bisIntentId");
                                        inputArgJson = respJson.getJSONObject("inputArgJson");
                                        inferred = respJson.getBoolean("inferred");
                                        intents = this.getJsonStringValue(respJson, "intents");
                                        intentParam = this.getJsonStringValue(respJson, "intentParam");
                                        nlpDetailsJson = respJson.getJSONObject("nlp_details");
                                        entitiesValArr = inputArgJson.getJSONArray("NER");
                                        intentIdDesc = respJson.getString("intent_descr");
                                        pineconeIntentId = respJson.getString("pinecone_intent_id");
                                    }
                                }
                            }
                        }
                        if (excpInfo.indexOf("system_exception") != -1) {
                            status = "exception";
                            invokeJson = new JSONObject(excpInfo);
                            break block68;
                        }
                        intentFound = bisIntentId.trim().length() > 0 ? "1" : "0";
                        if (this.userInfo != null) {
                            String loginCode = this.getUserInfo().getLoginCode();
                            String intentKey = String.valueOf(loginCode) + "~SEP~" + bisIntentId;
                            if (!this.isIntentInProcess(intentKey, intentStoredKey = String.valueOf(intentKey) + "~SEP~" + identity, inputArgJson)) {
                                businessIntent.setUserInfo(this.userInfo);
                                businessIntent.setResponseTo(responseTo);
                                result = businessIntent.invokeIntent(intentParam, this.userInfo);
                                BaseLogger.log((String)"3", (UserInfoBean)this.userInfo, null, (Object)("businessIntentEJB result : [" + result + "]"));
                                intentAccessMap.remove(intentStoredKey);
                            } else {
                                result = !"vision".equalsIgnoreCase(responseTo) ? this.bisUtility.generateSimpleResponse((Object)"This request is already being processed.", "", "").toString() : this.bisUtility.generateSucessString("1", "", null, (Object)"This request is already being processed.", "");
                            }
                            result = this.checkNull(result);
                            if (result.length() > 0) {
                                invokeJson = new JSONObject(result);
                                respReturned = "1";
                            } else {
                                respReturned = "0";
                            }
                            status = "success";
                            break block68;
                        }
                        intentAccessMap.remove(intentStoredKey);
                        throw new Exception("SESSION_EXPIRED");
                    }
                    catch (Exception e) {
                        BaseLogger.log((String)"0", null, null, (Object)("Exception : invokeIntent : " + e.getMessage()));
                        intentAccessMap.remove(intentStoredKey);
                        String excpMsg = e.getMessage();
                        respReturned = excpMsg.equalsIgnoreCase("Session Expired") ? "2" : "3";
                        status = "exception";
                        excpInfo = new ITMException("JSON", e).getMessage();
                        invokeJson = new JSONObject(excpInfo);
                        invokeJson = this.getAvailIdToken() && !this.getAuthenticatedByTokenGmail() && !"vision".equalsIgnoreCase(responseTo) ? new JSONObject(this.bisUtility.getErrorJsonString("INVINTAUTH", null, null, responseTo, null)) : new JSONObject(excpInfo);
                        result = this.generateResponse(request, params, intentFound, bisIntentId, invokeJson, respReturned, excpInfo, status, identity, "JSON", inferred, intents, tranId, responseTo, nlpDetailsJson, entitiesValArr, intentIdDesc, pineconeIntentId, userId, uuidString);
                        BaseLogger.log((String)"3", null, null, (Object)("BISService.invokeIntent() in finally result : [" + result + "]"));
                        BaseLogger.log((String)"3", null, null, (Object)("in finally invockPushNotification :: bisIntentId : [" + bisIntentId + "] isBrowser : [" + isBrowser + "], responseTo : [" + responseTo + "]"));
                        try {
                            if (!("WELCOME".equalsIgnoreCase(bisIntentId) || isBrowser || "google".equals(responseTo))) {
                                JSONObject resultJson = new JSONObject(result);
                                String notificationMsg = this.getNotificationMsg(resultJson);
                                this.callPushNotifiaction(resultJson, identity, userMsg, notificationMsg, this.userInfo);
                            }
                        }
                        catch (Exception e2) {
                            BaseLogger.log((String)"0", null, null, (Object)("Exception while calling push notification[" + e2.getMessage() + "]"));
                        }
                        try {
                            BaseLogger.log((String)"3", null, null, (Object)("responseTo [" + responseTo + "], isAuthenticated : [" + isAuthenticated + "]"));
                            if ("google".equals(responseTo)) {
                                BaseLogger.log((String)"3", null, null, (Object)("invokeJson [" + invokeJson + "] getAvailIdToken()[" + this.getAvailIdToken() + "] getAuthenticatedByTokenGmail()[" + this.getAuthenticatedByTokenGmail() + "]"));
                                if (isAuthenticated && this.getAvailIdToken() && this.getAuthenticatedByTokenGmail()) {
                                    result = this.bisUtility.generateGoogleAssistantResponse(invokeJson).toString();
                                } else if (this.getAvailIdToken() && !this.getAuthenticatedByTokenGmail()) {
                                    result = this.bisUtility.generateGoogleAssistantResponse(invokeJson).toString();
                                } else if (!this.getAvailIdToken()) {
                                    result = this.bisUtility.generateGActionSignInResponse().toString();
                                }
                            }
                            BaseLogger.log((String)"3", null, null, (Object)("final result[" + result + "]"));
                        }
                        catch (Exception e3) {
                            BaseLogger.log((String)"0", null, null, (Object)("Exception while calling push notification[" + e3.getMessage() + "]"));
                        }
                        break block69;
                    }
                }
                catch (Throwable throwable) {
                    result = this.generateResponse(request, params, intentFound, bisIntentId, invokeJson, respReturned, excpInfo, status, identity, "JSON", inferred, intents, tranId, responseTo, nlpDetailsJson, entitiesValArr, intentIdDesc, pineconeIntentId, userId, uuidString);
                    BaseLogger.log((String)"3", null, null, (Object)("BISService.invokeIntent() in finally result : [" + result + "]"));
                    BaseLogger.log((String)"3", null, null, (Object)("in finally invockPushNotification :: bisIntentId : [" + bisIntentId + "] isBrowser : [" + isBrowser + "], responseTo : [" + responseTo + "]"));
                    try {
                        if (!("WELCOME".equalsIgnoreCase(bisIntentId) || isBrowser || "google".equals(responseTo))) {
                            JSONObject resultJson = new JSONObject(result);
                            String notificationMsg = this.getNotificationMsg(resultJson);
                            this.callPushNotifiaction(resultJson, identity, userMsg, notificationMsg, this.userInfo);
                        }
                    }
                    catch (Exception e) {
                        BaseLogger.log((String)"0", null, null, (Object)("Exception while calling push notification[" + e.getMessage() + "]"));
                    }
                    try {
                        BaseLogger.log((String)"3", null, null, (Object)("responseTo [" + responseTo + "], isAuthenticated : [" + isAuthenticated + "]"));
                        if ("google".equals(responseTo)) {
                            BaseLogger.log((String)"3", null, null, (Object)("invokeJson [" + invokeJson + "] getAvailIdToken()[" + this.getAvailIdToken() + "] getAuthenticatedByTokenGmail()[" + this.getAuthenticatedByTokenGmail() + "]"));
                            if (isAuthenticated && this.getAvailIdToken() && this.getAuthenticatedByTokenGmail()) {
                                result = this.bisUtility.generateGoogleAssistantResponse(invokeJson).toString();
                            } else if (this.getAvailIdToken() && !this.getAuthenticatedByTokenGmail()) {
                                result = this.bisUtility.generateGoogleAssistantResponse(invokeJson).toString();
                            } else if (!this.getAvailIdToken()) {
                                result = this.bisUtility.generateGActionSignInResponse().toString();
                            }
                        }
                        BaseLogger.log((String)"3", null, null, (Object)("final result[" + result + "]"));
                    }
                    catch (Exception e) {
                        BaseLogger.log((String)"0", null, null, (Object)("Exception while calling push notification[" + e.getMessage() + "]"));
                    }
                    throw throwable;
                }
            }
            result = this.generateResponse(request, params, intentFound, bisIntentId, invokeJson, respReturned, excpInfo, status, identity, "JSON", inferred, intents, tranId, responseTo, nlpDetailsJson, entitiesValArr, intentIdDesc, pineconeIntentId, userId, uuidString);
            BaseLogger.log((String)"3", null, null, (Object)("BISService.invokeIntent() in finally result : [" + result + "]"));
            BaseLogger.log((String)"3", null, null, (Object)("in finally invockPushNotification :: bisIntentId : [" + bisIntentId + "] isBrowser : [" + isBrowser + "], responseTo : [" + responseTo + "]"));
            try {
                if (!("WELCOME".equalsIgnoreCase(bisIntentId) || isBrowser || "google".equals(responseTo))) {
                    JSONObject resultJson = new JSONObject(result);
                    String notificationMsg = this.getNotificationMsg(resultJson);
                    this.callPushNotifiaction(resultJson, identity, userMsg, notificationMsg, this.userInfo);
                }
            }
            catch (Exception e) {
                BaseLogger.log((String)"0", null, null, (Object)("Exception while calling push notification[" + e.getMessage() + "]"));
            }
            try {
                BaseLogger.log((String)"3", null, null, (Object)("responseTo [" + responseTo + "], isAuthenticated : [" + isAuthenticated + "]"));
                if ("google".equals(responseTo)) {
                    BaseLogger.log((String)"3", null, null, (Object)("invokeJson [" + invokeJson + "] getAvailIdToken()[" + this.getAvailIdToken() + "] getAuthenticatedByTokenGmail()[" + this.getAuthenticatedByTokenGmail() + "]"));
                    if (isAuthenticated && this.getAvailIdToken() && this.getAuthenticatedByTokenGmail()) {
                        result = this.bisUtility.generateGoogleAssistantResponse(invokeJson).toString();
                    } else if (this.getAvailIdToken() && !this.getAuthenticatedByTokenGmail()) {
                        result = this.bisUtility.generateGoogleAssistantResponse(invokeJson).toString();
                    } else if (!this.getAvailIdToken()) {
                        result = this.bisUtility.generateGActionSignInResponse().toString();
                    }
                }
                BaseLogger.log((String)"3", null, null, (Object)("final result[" + result + "]"));
            }
            catch (Exception e) {
                BaseLogger.log((String)"0", null, null, (Object)("Exception while calling push notification[" + e.getMessage() + "]"));
            }
        }
        return Response.status((int)200).entity((Object)result).build();
    }

    private JSONObject getInputArgJson(String intentParam, HttpServletRequest request) throws JSONException, IOException {
        JSONObject inputArgJson = null;
        if (intentParam != null && intentParam.length() > 0) {
            inputArgJson = new JSONObject(intentParam);
        } else {
            String requestData = this.getPayloadRequestData(request);
            inputArgJson = new JSONObject(requestData);
        }
        return inputArgJson;
    }

    private void setUserInfo(JSONObject inputArgJson, HttpServletRequest request) throws JSONException, BaseException {
        String userInfoStr = (String)request.getSession().getAttribute("USER_INFO_STR");
        if (userInfoStr == null || userInfoStr.trim().length() == 0) {
            String bisIntentId;
            this.userInfo = (UserInfoBean)request.getSession().getAttribute("USER_INFO");
            if (this.userInfo == null && inputArgJson != null && (bisIntentId = this.getJsonStringValue(inputArgJson, "BIS_INTENT_ID")).length() == 0) {
                this.createUserInfoByGmailId(inputArgJson);
            }
        } else {
            this.userInfo = new UserInfoBean(userInfoStr);
        }
    }

    private String getChgTerm(HttpServletRequest request) {
        String requestedTerm = "";
        if (this.userInfo != null) {
            requestedTerm = this.checkNull(this.userInfo.getRemoteHost());
            if (requestedTerm.length() > 15) {
                requestedTerm = requestedTerm.substring(0, 15);
            }
        } else {
            requestedTerm = this.checkNull(request.getRemoteAddr());
            if (requestedTerm.length() > 15) {
                requestedTerm = requestedTerm.substring(0, 15);
            }
        }
        return requestedTerm;
    }

    private String getJsonStringValue(JSONObject inputArgJson, String key) throws JSONException {
        if (inputArgJson.has(key)) {
            return this.checkNull(inputArgJson.getString(key));
        }
        return "";
    }

    private String getIdentity(JSONObject inputArgJson) throws JSONException {
        String identity = this.getJsonStringValue(inputArgJson, "identity");
        if (identity.length() == 0) {
            identity = "" + new Random().nextInt();
        }
        return identity;
    }

    private boolean isBrowser(JSONObject inputArgJson) throws JSONException {
        if (inputArgJson.has("IS_BROWSER")) {
            return inputArgJson.getBoolean("IS_BROWSER");
        }
        return true;
    }

    private void createUserInfoByGmailId(JSONObject inputArgJson) {
        try {
            String authIdToken = this.getRequestInputDetails(inputArgJson, "user", "idToken");
            BaseLogger.log((String)"3", (UserInfoBean)this.userInfo, null, (Object)("authIdToken [" + authIdToken + "]"));
            if (authIdToken.trim().length() > 0) {
                String authEmailId = "";
                GoogleSignInIdToken idToken = this.idToken(authIdToken);
                authEmailId = idToken.getEmail();
                BaseLogger.log((String)"2", (UserInfoBean)this.userInfo, null, (Object)("authEmailId [" + authEmailId + "]"));
                this.userInfo = this.getCommonDBAccess().createUserInfo(authEmailId, "email_id", true);
                BaseLogger.log((String)"2", (UserInfoBean)this.userInfo, null, (Object)("userInfo [" + this.userInfo + "]"));
                String loginCode = this.checkNull(this.userInfo.getLoginCode());
                BaseLogger.log((String)"3", (UserInfoBean)this.userInfo, null, (Object)("loginCode [" + loginCode + "]"));
                if (this.userInfo != null && loginCode.length() != 0) {
                    this.setAuthenticatedByTokenGmail(true);
                } else {
                    this.setAuthenticatedByTokenGmail(false);
                    this.userInfo = null;
                }
            } else {
                this.setAvailIdToken(false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String generateResponse(HttpServletRequest request, String params, String intentFound, String bisIntentId, Object respData, String respReturned, String excpInfo, String status, String identity, String dataFormat, boolean inferred, String intents, String tranId, String responseTo, JSONObject nlpDetailsJson, JSONArray entitiesValArr, String intentIdDesc, String pineconeIntentId, String userId, String uuid) {
        String response = "";
        try {
            JSONObject responseJson = new JSONObject();
            JSONObject resultJson = new JSONObject();
            String result = "";
            String excpInfoResult = "";
            BaseLogger.log((String)"3", (UserInfoBean)this.userInfo, null, (Object)("respData : [" + respData + "]"));
            if (respData instanceof String) {
                result = (String)respData;
                result = this.checkNull(result);
                if (status != null && status.length() == 0) {
                    if (result.indexOf("Warning") != -1) {
                        status = "warning";
                    } else if (result.indexOf("Errors") != -1) {
                        status = "error";
                    } else if (result.indexOf("Exception") != -1) {
                        status = "exception";
                    }
                }
            } else if (respData instanceof JSONObject) {
                result = ((JSONObject)respData).toString();
                if (responseTo.equals("google") && ((JSONObject)respData).has("MultiValueEntities")) {
                    ((JSONObject)respData).remove("MultiValueEntities");
                }
            } else if (respData instanceof JSONArray) {
                result = ((JSONArray)respData).toString();
            }
            BaseLogger.log((String)"3", (UserInfoBean)this.userInfo, null, (Object)("result : [" + respData + "]"));
            if (excpInfo.length() > 0) {
                excpInfoResult = excpInfo.toString();
            }
            BaseLogger.log((String)"3", null, null, (Object)("excpInfoResult : [" + excpInfoResult + "]"));
            resultJson.put("status", (Object)status);
            resultJson.put("identity", (Object)identity);
            resultJson.put("intent_id", (Object)bisIntentId);
            CommonDBAccessEJB commonDBAccessEJB = new CommonDBAccessEJB();
            String fullFillMethod = commonDBAccessEJB.getDBColumnValue("BIS_INTENT", "FULLFILL_MTH", "WHERE BIS_INTENT_ID = '" + bisIntentId + "'", this.userInfo.getTransDB());
            resultJson.put("fullfill_method", (Object)fullFillMethod);
            resultJson.put("entities", (Object)entitiesValArr);
            resultJson.put("pinecone_intent_id", (Object)pineconeIntentId);
            resultJson.put("intent_descr", (Object)intentIdDesc);
            String processResp = this.checkNull(commonDBAccessEJB.getDBColumnValue("BIS_INTENT", "PROCESS_RESP", "WHERE BIS_INTENT_ID = '" + bisIntentId + "'", this.userInfo.getTransDB()));
            resultJson.put("process_resp", (Object)processResp);
            if (intents != null && intents.trim().length() > 0) {
                resultJson.put("intents", (Object)intents);
            }
            if (bisIntentId.equalsIgnoreCase("WELCOME")) {
                resultJson.put("user_id", (Object)userId);
                resultJson.put("uuid", (Object)uuid);
            }
            try {
                String logResult = "";
                if (tranId.length() > 0) {
                    logResult = this.generateBisServiceLog(tranId, intentFound, bisIntentId, result, respReturned, excpInfoResult, this.getUserInfo(), status, nlpDetailsJson);
                }
                BaseLogger.log((String)"3", null, null, (Object)("logResult - [" + logResult + "]"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            resultJson.put("results", respData);
            resultJson.put("inferred", inferred);
            if (nlpDetailsJson != null) {
                resultJson.put("modelName", (Object)("Proteus Sense-" + nlpDetailsJson.getString("NLP_AGENT")));
            } else {
                resultJson.put("modelName", (Object)"Proteus Sense");
            }
            responseJson.put("Response", (Object)resultJson);
            response = responseJson.toString();
            BaseLogger.log((String)"3", null, null, (Object)("BISService Responce [" + response + "]"));
        }
        catch (JSONException e) {
            BaseLogger.log((String)"0", null, null, (Object)("JSONException : generateResponse : " + e.getMessage()));
            response = this.getStackTrace((Exception)((Object)e));
        }
        catch (Exception e) {
            BaseLogger.log((String)"0", null, null, (Object)("Exception : generateResponse : " + e.getMessage()));
            response = this.getStackTrace(e);
        }
        return response;
    }

    private String generateBisServiceLog(String tranId, String intentFound, String bisIntentId, String respDataResult, String respReturned, String excpInfoResult, UserInfoBean userInfo, String responseType, JSONObject nlpDetailsJson) throws ITMException {
        String result = "";
        String requestedUser = "";
        BusinessIntentEJB businessIntentEJB = new BusinessIntentEJB();
        result = businessIntentEJB.updateBisServiceLog(userInfo, tranId, intentFound, bisIntentId, respDataResult, respReturned, excpInfoResult, nlpDetailsJson);
        if ("error".equals(responseType)) {
            String fileName = String.valueOf(requestedUser) + "_log_" + System.currentTimeMillis() + ".log";
            this.generateErrorLog(respDataResult, fileName);
        }
        return result;
    }

    public UserInfoBean getUserInfo() {
        return this.userInfo;
    }

    public void setUserInfo(UserInfoBean userInfo) {
        this.userInfo = userInfo;
    }

    private String getStackTrace(Exception e) {
        String exception = "";
        if (this.genericUtility == null) {
            this.genericUtility = new E12GenericUtility();
        }
        exception = this.genericUtility.createErrorString(e);
        return exception;
    }

    private void generateErrorLog(String log, String fileName) {
        try {
            String logDir = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "log" + File.separator + "BISService_Log" + File.separator + fileName;
            File outFile = new File(String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "log" + File.separator + "BISService_Log");
            if (!outFile.exists()) {
                outFile.mkdir();
            }
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(logDir, true)));
            out.println(log);
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String checkNull(String input) {
        if (input == null || "null".equalsIgnoreCase(input) || "undefined".equalsIgnoreCase(input)) {
            input = "";
        }
        return input.trim();
    }

    private JSONObject callProteusSenseService(String modelName, String[] modelActions, Map<String, String> queryParamters, InputStream postDataStream, String str) throws JSONException, UnsupportedEncodingException {
        BaseLogger.log((String)"0", (UserInfoBean)this.userInfo, null, (Object)"callProteusSenseService inside ");
        String pythonServerPath = this.getProteusSenseServicePath();
        String result = "{}";
        if (str != null) {
            postDataStream = new ByteArrayInputStream(str.getBytes());
        }
        try {
            byte[] resultBytes = E12GenericUtility.makeRequest((String)pythonServerPath, (InputStream)postDataStream);
            result = new String(resultBytes);
            BaseLogger.log((String)"0", (UserInfoBean)this.userInfo, null, (Object)("callProteusSenseService inside result [" + result + "]"));
        }
        catch (Exception ex) {
            BaseLogger.log((String)"0", (UserInfoBean)this.userInfo, null, (Object)("Exception in BISService :: callPythonModelService() While calling python service : " + ex));
            result = "{\"status\": 0, \"error\": \"" + ex + "\"}";
        }
        return new JSONObject(result);
    }

    private String getProteusSenseServicePath() {
        String pythonServerPath = null;
        Map pythonServicesMap = CommonConstants.PYTHON_SERVICES;
        if (pythonServicesMap != null) {
            Map proteusSenseServiceDetails = (Map)pythonServicesMap.get("PROTEUS_SENSE");
            String protocol = (String)proteusSenseServiceDetails.get("PROTOCOL");
            String host = (String)proteusSenseServiceDetails.get("HOST");
            String port = this.checkNull((String)proteusSenseServiceDetails.get("PORT"));
            String path = (String)proteusSenseServiceDetails.get("PATH");
            pythonServerPath = String.format("%s://%s%s/%s", protocol, host, port, path);
        }
        return pythonServerPath;
    }

    private boolean isIntentInProcess(String intentKey, String intentStoredKey, JSONObject inputArgJson) {
        boolean isInProcess = false;
        try {
            if (intentAccessMap != null && !intentAccessMap.isEmpty()) {
                for (Map.Entry<String, String> entry : intentAccessMap.entrySet()) {
                    int matchCount = 0;
                    isInProcess = false;
                    String mapKey = entry.getKey();
                    JSONObject mapArgJson = new JSONObject(entry.getValue());
                    if (!mapKey.startsWith(intentKey)) continue;
                    Iterator keys = inputArgJson.keys();
                    while (keys.hasNext()) {
                        String inputArgValue;
                        String mapArgValue;
                        String key = (String)keys.next();
                        if (key.equalsIgnoreCase("identity") || !(mapArgValue = this.checkNull(mapArgJson.getString(key))).equalsIgnoreCase(inputArgValue = this.checkNull(inputArgJson.getString(key)))) continue;
                        ++matchCount;
                    }
                    if (matchCount != mapArgJson.length() - 1) continue;
                    isInProcess = true;
                    break;
                }
                if (!isInProcess) {
                    intentAccessMap.put(intentStoredKey, inputArgJson.toString());
                }
            } else {
                intentAccessMap.put(intentStoredKey, inputArgJson.toString());
            }
            BaseLogger.log((String)"3", null, null, (Object)("intentAccessMap :: [" + intentAccessMap + "]"));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        BaseLogger.log((String)"3", null, null, (Object)("isInProcess [" + isInProcess + "]"));
        return isInProcess;
    }

    private String getIntents(HashMap<String, String> intentDetailMap, String bisIntentId) {
        String multipleIntents = "";
        for (Map.Entry<String, String> entry : intentDetailMap.entrySet()) {
            String intentKey = entry.getKey();
            float intentValue = Float.parseFloat(entry.getValue()) * 100.0f;
            if (!(intentValue > (float)CommonConstants.MIN_INTENT_PERC) || intentKey.equalsIgnoreCase(bisIntentId)) continue;
            multipleIntents = String.valueOf(multipleIntents) + entry.getKey() + ",";
        }
        if (multipleIntents != null && multipleIntents.length() > 1) {
            multipleIntents = multipleIntents.substring(0, multipleIntents.length() - 1);
        }
        BaseLogger.log((String)"3", (UserInfoBean)this.userInfo, null, (Object)("multipleIntents :::" + multipleIntents));
        return multipleIntents;
    }

    private void callPushNotifiaction(final JSONObject result, final String identity, final String userMsg, final String notificationMsg, final UserInfoBean userInfo) {
        new Thread(){

            @Override
            public void run() {
                try {
                    JSONObject notificationJson = new JSONObject();
                    BaseLogger.log((String)"3", null, null, (Object)"In callPushNotifiaction!!");
                    notificationJson.put("response", (Object)result);
                    notificationJson.put("userMsg", (Object)userMsg);
                    String loginUserCode = userInfo.getLoginCode();
                    String refId = identity.substring(0, 5);
                    String refSer = "";
                    int signTransLineNo = 1;
                    String notificationType = "I";
                    ArrayList<String> userIdList = new ArrayList<String>();
                    userIdList.add(loginUserCode);
                    PublishPushNotificationEJB publishPushNotificationEJB = new PublishPushNotificationEJB();
                    publishPushNotificationEJB.invockPushNotification(notificationMsg, loginUserCode, "V", refId, userIdList, notificationJson.toString(), refId, refSer, loginUserCode, signTransLineNo, notificationType, userInfo);
                }
                catch (Exception e) {
                    BaseLogger.log((String)"2", null, null, (Object)("Exception while calling push notifiaction::" + e.getMessage()));
                }
            }
        }.start();
    }

    private String getNotificationMsg(JSONObject resultJson) {
        String notificationMsg = "";
        String format = "";
        int msgLen = 0;
        try {
            if (resultJson.toString().indexOf("Errors") == -1) {
                format = resultJson.getJSONObject("Response").getJSONObject("results").getJSONObject("Root").getJSONObject("Detail").getJSONObject("result").getString("format");
                BaseLogger.log((String)"2", null, null, (Object)("Response format [" + format + "]"));
                if ("1".equalsIgnoreCase(format)) {
                    notificationMsg = resultJson.getJSONObject("Response").getJSONObject("results").getJSONObject("Root").getJSONObject("Detail").getJSONObject("result").getString("data");
                }
            } else {
                BaseLogger.log((String)"2", null, null, (Object)"In Error case");
                notificationMsg = resultJson.getJSONObject("Response").getJSONObject("results").getJSONObject("Root").getJSONObject("Errors").getJSONObject("error").getString("description");
            }
            BaseLogger.log((String)"2", null, null, (Object)("Response data [" + notificationMsg + "]"));
            msgLen = notificationMsg.length();
            notificationMsg = msgLen > 50 ? notificationMsg.substring(0, 50).concat("...") : notificationMsg.substring(0, msgLen - 2).concat("...");
            BaseLogger.log((String)"2", null, null, (Object)("Altered notificationMsg : [" + notificationMsg + "]"));
        }
        catch (Exception e) {
            BaseLogger.log((String)"2", null, null, (Object)("Exception while generate notification message" + e.getMessage()));
            notificationMsg = "";
        }
        return notificationMsg;
    }

    @POST
    @Path(value="/updateDataset/{type}")
    @Produces(value={"application/json"})
    public Response updateDataset(@Context HttpServletRequest request, @PathParam(value="type") String type) throws ITMException {
        String result = "";
        try {
            Map proteusSenseServiceDetails;
            HashMap<String, String> parameters = new HashMap<String, String>();
            Map pythonServices = CommonConstants.PYTHON_SERVICES;
            if (pythonServices != null && (proteusSenseServiceDetails = (Map)pythonServices.get("PROTEUS_SENSE")) != null) {
                String accessToken = (String)proteusSenseServiceDetails.get("ACCESS_TOKEN");
                parameters.put("token", accessToken);
            }
            if (type.equalsIgnoreCase("update")) {
                UserInfoBean userInfo = (UserInfoBean)request.getSession().getAttribute("USER_INFO");
                BusinessIntentEJB businessIntentEJB = new BusinessIntentEJB();
                businessIntentEJB.setUserInfo(userInfo);
                Object dataSetJson = null;
                if (dataSetJson != null && dataSetJson.length() > 0) {
                    String intents = dataSetJson.getString("intents");
                    dataSetJson.remove("intents");
                    BaseLogger.log((String)"3", null, null, (Object)("trainingIntents>>[" + intents + "]"));
                    ByteArrayInputStream fis = new ByteArrayInputStream(dataSetJson.toString().getBytes());
                    if (pythonServices != null) {
                        JSONObject response = this.callProteusSenseService("dataset", new String[]{"store"}, parameters, fis, null);
                        BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("response" + response));
                        String serviceResp = response.getString("result");
                        if (intents.length() != 0 && "Data Stored".equalsIgnoreCase(serviceResp)) {
                            String intentsToUpdateIntStat = intents.substring(0, intents.length() - 1);
                            businessIntentEJB.updateIntentStatus(intentsToUpdateIntStat);
                        }
                        result = response.toString();
                    }
                }
            } else if (type.equalsIgnoreCase("train")) {
                if (pythonServices != null) {
                    JSONObject trainResponse = this.callProteusSenseService("proteussense", new String[]{"train"}, parameters, null, null);
                    result = trainResponse.toString();
                }
            } else if (type.equalsIgnoreCase("ready") && pythonServices != null) {
                JSONObject readyResp = this.callProteusSenseService("proteussense", new String[]{"ready"}, parameters, null, null);
                result = readyResp.toString();
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return Response.status((int)200).entity((Object)result).build();
    }

    private CommonDBAccessEJB getCommonDBAccess() throws BaseException {
        CommonDBAccessEJB ejbObj = null;
        try {
            ejbObj = new CommonDBAccessEJB();
        }
        catch (Exception e) {
            BaseLogger.log((String)"0", null, null, (Object)("Exception: getCommonDBAccess:==>\n" + e));
            throw new BaseException(e);
        }
        return ejbObj;
    }

    private String getPayloadRequestData(HttpServletRequest request) throws IOException {
        String bodyData = null;
        StringBuilder stringBuilder = new StringBuilder();
        try (BufferedReader bufferedReader = null;){
            ServletInputStream inputStream = request.getInputStream();
            if (inputStream != null) {
                bufferedReader = new BufferedReader(new InputStreamReader((InputStream)inputStream));
                char[] charBuffer = new char[128];
                int bytesRead = -1;
                while ((bytesRead = bufferedReader.read(charBuffer)) > 0) {
                    stringBuilder.append(charBuffer, 0, bytesRead);
                }
            } else {
                stringBuilder.append("");
            }
        }
        bodyData = stringBuilder.toString();
        return bodyData;
    }

    private String getRequestInputDetails(JSONObject requestJson, String mainKey, String reqKey) {
        String response = "";
        try {
            JSONObject inputReqJson = new JSONObject();
            if (mainKey.equals("inputs") && requestJson.has("inputs")) {
                JSONArray inputReqJsonArr = requestJson.getJSONArray("inputs");
                inputReqJson = inputReqJsonArr.getJSONObject(0);
                if ("query".equals(reqKey)) {
                    response = this.getQueryString(inputReqJson);
                } else if ("intent".equals(reqKey)) {
                    response = this.getJsonStringValue(inputReqJson, "intent");
                }
            } else if (mainKey.equals("user") && requestJson.has("user")) {
                inputReqJson = requestJson.getJSONObject("user");
                response = this.getJsonStringValue(inputReqJson, "idToken");
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        BaseLogger.log((String)"2", null, null, (Object)("[" + reqKey + "] : [" + response + "]"));
        return response;
    }

    private String getQueryString(JSONObject inputReqJson) {
        String inputQuery = "";
        try {
            if (inputReqJson.has("rawInputs")) {
                JSONArray rawInputReqJsonArr = inputReqJson.getJSONArray("rawInputs");
                JSONObject rawInputReqJson = rawInputReqJsonArr.getJSONObject(0);
                inputQuery = this.getJsonStringValue(rawInputReqJson, "query");
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        BaseLogger.log((String)"2", null, null, (Object)("inputQuery : [" + inputQuery + "]"));
        return inputQuery;
    }

    private GoogleSignInIdToken idToken(String id_token) {
        try {
            DecodedJWT jwt = JWT.decode((String)id_token);
            return new GoogleSignInIdToken(jwt.getClaim("iss").asString(), jwt.getClaim("sub").asString(), jwt.getClaim("aud").asString(), jwt.getClaim("exp").asLong().longValue(), jwt.getClaim("iat").asLong().longValue(), jwt.getClaim("email").asString(), jwt.getClaim("name").asString());
        }
        catch (JWTDecodeException e) {
            BaseLogger.log((String)"3", (UserInfoBean)this.userInfo, null, (Object)"Exception in idToken");
            throw new RuntimeException(e);
        }
    }

    private JSONObject processInputText(Map<String, Map<String, String>> pythonServices, String inputText, JSONObject inputArgJson, String intentParam) throws Exception {
        JSONObject pythonRespJson = new JSONObject();
        try {
            boolean inferred = false;
            String intents = "";
            String processResponse = "";
            String userId = "";
            String uuid = "";
            userId = inputArgJson.getString("USER_ID");
            uuid = inputArgJson.getString("UUID");
            EventManagerEJB eventManagerEJB = new EventManagerEJB();
            StringBuffer valueXmlString = new StringBuffer();
            valueXmlString.append("<Root>\r\n");
            valueXmlString.append("<Detail1 domID='1' >\r\n");
            valueXmlString.append("<input_string><![CDATA[").append(String.valueOf(inputText) + "~" + userId + "~" + uuid).append("]]></input_string>\r\n");
            valueXmlString.append("</Detail1 >\r\n");
            valueXmlString.append("</Root>");
            BaseLogger.log((String)"3", null, null, (Object)("valueXmlString : [" + valueXmlString + "]"));
            String XTRA_PARAMS = this.getXtraParams();
            if (eventManagerEJB.isEventExist("bis_intent", "process_intent", this.userInfo)) {
                processResponse = eventManagerEJB.executeSystemEventByServiceCode("bis_intent", "process_intent", "1", "process_intent_default", valueXmlString.toString(), valueXmlString.toString(), XTRA_PARAMS, "1", this.userInfo);
            }
            processResponse = this.checkNull(processResponse);
            BaseLogger.log((String)"3", (UserInfoBean)this.userInfo, null, (Object)("processResponse : [" + processResponse + "]"));
            if (processResponse.length() > 0) {
                if (processResponse.indexOf("Errors") != -1) {
                    pythonRespJson.put("system_exception", (Object)processResponse);
                    BaseLogger.log((String)"3", (UserInfoBean)this.userInfo, null, (Object)("pythonRespJson 1297:::::: " + pythonRespJson));
                } else {
                    JSONObject response = new JSONObject(processResponse);
                    BaseLogger.log((String)"3", (UserInfoBean)this.userInfo, null, (Object)("response : [" + response + "]"));
                    JSONObject modelResult = response.getJSONObject("intent");
                    BaseLogger.log((String)"3", (UserInfoBean)this.userInfo, null, (Object)("modelResult [" + modelResult + "]"));
                    float confidence = (float)modelResult.getDouble("confidence");
                    BaseLogger.log((String)"3", (UserInfoBean)this.userInfo, null, (Object)("confidence1 [" + confidence + "]"));
                    BaseLogger.log((String)"3", (UserInfoBean)this.userInfo, null, (Object)("confidence2 [" + (confidence *= 100.0f) + "]"));
                    String bisIntentId = modelResult.getString("name");
                    if (confidence < (float)CommonConstants.MAX_INTENT_PERC) {
                        HashMap<String, String> intentDetailMap = new HashMap<String, String>();
                        JSONArray intentPredictions = response.getJSONArray("intent_ranking");
                        BaseLogger.log((String)"3", (UserInfoBean)this.userInfo, null, (Object)("intentPredictions [" + intentPredictions + "], length [" + intentPredictions.length() + "]"));
                        if (intentPredictions.length() > 0) {
                            int i = 0;
                            while (i < intentPredictions.length()) {
                                JSONObject objects = (JSONObject)intentPredictions.get(i);
                                intentDetailMap.put(objects.getString("name"), objects.get("confidence").toString());
                                ++i;
                            }
                            if (intentDetailMap != null && intentDetailMap.size() > 0) {
                                intents = this.getIntents(intentDetailMap, bisIntentId);
                            }
                        }
                        BaseLogger.log((String)"3", (UserInfoBean)this.userInfo, null, (Object)("intentDetailMap [" + intentDetailMap + "], intents [" + intents + "]"));
                    }
                    if (inputArgJson.has("INPUT_TEXT")) {
                        inputArgJson.remove("INPUT_TEXT");
                    }
                    inputArgJson.put("NER", response.get("entities"));
                    inputArgJson.put("BIS_INTENT_ID", (Object)bisIntentId.toUpperCase());
                    intentParam = String.valueOf(inputArgJson);
                    BaseLogger.log((String)"3", (UserInfoBean)this.userInfo, null, (Object)("Model intent [" + bisIntentId + "], intentParam [" + intentParam + "]"));
                    inferred = true;
                    pythonRespJson.put("inferred", inferred);
                    pythonRespJson.put("intent", (Object)intents);
                    pythonRespJson.put("inputArgJson", (Object)inputArgJson);
                    pythonRespJson.put("bisIntentId", (Object)bisIntentId);
                    pythonRespJson.put("intentParam", (Object)intentParam);
                    pythonRespJson.put("nlp_details", response.get("nlp_details"));
                    pythonRespJson.put("pinecone_intent_id", response.get("pinecone_intent_id"));
                    pythonRespJson.put("intent_descr", response.get("intent_descr"));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            BaseLogger.log((String)"0", (UserInfoBean)this.userInfo, null, (Object)("Exception in python service[" + e.getMessage() + "]"));
        }
        return pythonRespJson;
    }

    @GET
    @Path(value="/trainIntent")
    @Produces(value={"application/json"})
    public void trainIntent(@Context HttpServletRequest request) throws Exception {
        String trainResponse = "";
        String excpInfo = "";
        String respReturned = "";
        try {
            String action = request.getParameter("action");
            BaseLogger.log((String)"3", null, null, (Object)("action : [" + action + "]"));
            String params = this.checkNull(request.getQueryString());
            BaseLogger.log((String)"3", null, null, (Object)("params : [" + params + "]"));
            this.setUserInfo(null, request);
            BaseLogger.log((String)"3", null, null, (Object)("USER_INFO : [" + this.userInfo + "]"));
            if (this.userInfo == null) {
                throw new Exception("SESSION_EXPIRED");
            }
            String requestedTerm = this.getChgTerm(request);
            BaseLogger.log((String)"3", null, null, (Object)("requestedTerm : [" + requestedTerm + "]"));
            StringBuffer valueXmlString = new StringBuffer();
            valueXmlString.append("<Root>\r\n");
            valueXmlString.append("<Detail1 domID='1' >\r\n");
            valueXmlString.append("<train_option><![CDATA[").append(action).append("]]></train_option>\r\n");
            valueXmlString.append("</Detail1>\r\n");
            valueXmlString.append("</Root>");
            String XTRA_PARAMS = this.getXtraParams();
            EventManagerEJB eventManagerEJB = new EventManagerEJB();
            if (eventManagerEJB.isEventExist("bis_intent", "train_intent", this.userInfo)) {
                trainResponse = eventManagerEJB.executeSystemEventByServiceCode("bis_intent", "train_intent", "1", "train_intent_default", valueXmlString.toString(), valueXmlString.toString(), XTRA_PARAMS, "1", this.userInfo);
            }
            trainResponse = this.checkNull(trainResponse);
            BaseLogger.log((String)"3", (UserInfoBean)this.userInfo, null, (Object)("dataString  [" + trainResponse + "]"));
            respReturned = trainResponse.length() > 0 ? "1" : "0";
        }
        catch (Exception e) {
            BaseLogger.log((String)"0", null, null, (Object)("Exception : trainIntent : [" + e.getMessage() + "]"));
            String excpMsg = e.getMessage();
            respReturned = excpMsg.equalsIgnoreCase("Session Expired") ? "2" : "3";
            excpInfo = new ITMException("JSON", e).getMessage();
        }
    }

    private String getXtraParams() {
        String XTRA_PARAMS_SEPARATOR = "~~";
        String user_lang = "en";
        String user_country = "US";
        return "loginCode=" + this.userInfo.getLoginCode() + XTRA_PARAMS_SEPARATOR + "loginEmpCode=" + this.userInfo.getEmpCode() + XTRA_PARAMS_SEPARATOR + "loginSiteCode=" + this.userInfo.getSiteCode() + XTRA_PARAMS_SEPARATOR + "entityCode=" + this.userInfo.getEntityCode() + XTRA_PARAMS_SEPARATOR + "profileId=" + this.userInfo.getProfileId() + XTRA_PARAMS_SEPARATOR + "userType=" + this.userInfo.getUserType() + XTRA_PARAMS_SEPARATOR + "runMode=I" + XTRA_PARAMS_SEPARATOR + "user_lang=" + user_lang + XTRA_PARAMS_SEPARATOR + "user_country=" + user_country + XTRA_PARAMS_SEPARATOR + "site_code=" + this.userInfo.getSiteCode() + XTRA_PARAMS_SEPARATOR + "termId=" + this.userInfo.getRemoteHost() + XTRA_PARAMS_SEPARATOR + "chgTerm=" + this.userInfo.getRemoteHost() + XTRA_PARAMS_SEPARATOR + "objName=" + "bis_intent";
    }

    private void setAuthenticatedByTokenGmail(boolean flag) {
        this.isAuthenticatedByTokenGmail = flag;
    }

    private boolean getAuthenticatedByTokenGmail() {
        return this.isAuthenticatedByTokenGmail;
    }

    private void setAvailIdToken(boolean flag) {
        this.isIdTokenAvailable = flag;
    }

    private boolean getAvailIdToken() {
        return this.isIdTokenAvailable;
    }
}

