package ibase.webService;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.FormParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

import ibase.utility.BaseLogger;
import ibase.webitm.utility.CustomMenuImageServiceUtility;

@Path("/CustomMenuImageService")

public class CustomMenuImageService  extends RestAPIService{
	
	
	@POST
    @Produces("image/png")
    @Path("/generateImage")
    public Response generateImage(
            @FormParam("fldValue") String fldValue,
            @FormParam("object") String object,
            @FormParam("objName") String objName,
            @FormParam("ALT_FLD_VALUE") String ALT_FLD_VALUE,
            @HeaderParam("TOKEN_ID") String tokenIDfromHeader,
         //   @FormParam("Reload") String Reload,
            @Context HttpServletRequest request,
            @Context HttpServletResponse response) {
		
		CustomMenuImageServiceUtility customMenuImageServiceUtility =new CustomMenuImageServiceUtility();
		//customMenuImageServiceUtility.generateImage(fldValue, object, objName, ALT_FLD_VALUE,tokenIDfromHeader, request, response);

		Response rsResponse = customMenuImageServiceUtility.generateImage(fldValue, object, objName, ALT_FLD_VALUE,tokenIDfromHeader,  request, response);
		BaseLogger.log( "3", null, null, "response value  :"+ rsResponse );

        // Ensure the response is OK (status 200) and set the entity to response
        return Response.status(200).entity(rsResponse.getEntity()).build();
		
		
    }
	

}
