/*
 * Decompiled with CFR 0.152.
 */
package ibase.servlet;

import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.utility.ITMException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.naming.NamingException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import sun.misc.Signal;

public class VersionVerificationServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    public static final String ANSI_RESET = "\u001b[0m";
    public static final String ANSI_RED = "\u001b[31m";
    ServletConfig servletConfig = null;
    String dirName = "";

    public void init(ServletConfig config) throws ServletException {
        this.servletConfig = config;
        super.init(config);
        BaseLogger.log("3", null, null, "In VersionVerificationServlet init()");
        try {
            CommonConstants.setIBASEHOME();
            CommonConstants.setAPPLICATION_CONTEXT(this.servletConfig.getServletContext().getRealPath("/"));
        }
        catch (Exception e) {
            BaseLogger.log("3", null, null, "VersionVerificationServlet : [" + e.getMessage() + "]");
            e.printStackTrace();
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doPost(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
    }

    private void checkApplicationEntries() {
        try {
            DBAccessEJB dbAccess = new DBAccessEJB();
            boolean isValidate = dbAccess.validateProductInfo();
            BaseLogger.log("3", null, null, "isValidate[" + isValidate + "]");
            if (!isValidate) {
                BaseLogger.log("3", null, null, "Validation Failed");
                BaseLogger.log("3", null, null, "\u001b[31mProduct version is mismatch in BaseProductInfo xml and parameter tables ITM_VER column\u001b[0m");
                Signal.raise(new Signal("INT"));
                return;
            }
        }
        catch (ITMException e) {
            BaseLogger.log("0", null, null, "ITMException in Version verification servlet[" + e.getMessage() + "]");
            e.printStackTrace();
        }
        catch (NamingException e) {
            BaseLogger.log("0", null, null, "NamingException in Version verification servlet[" + e.getMessage() + "]");
            e.printStackTrace();
        }
        if (CommonConstants.J2EE_VERSION.equals("1")) {
            this.dirName = new File(CommonConstants.APPLICATION_CONTEXT).getParentFile() + File.separator;
        } else if (CommonConstants.J2EE_VERSION.equals("2")) {
            this.dirName = new File(CommonConstants.JBOSSHOME) + File.separator + "ibase.ear";
        }
        try {
            ArrayList<String> filesArrayList = new ArrayList<String>();
            ArrayList<String> fileInFolderArr = new ArrayList<String>();
            this.dirName = new File(CommonConstants.APPLICATION_CONTEXT).getParentFile() + File.separator + "META-INF" + File.separator;
            File appFile = new File(String.valueOf(this.dirName) + "application.xml");
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setIgnoringElementContentWhitespace(true);
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            Document document = builder.parse(appFile);
            document.getDocumentElement().normalize();
            NodeList nodeList = document.getElementsByTagName("module");
            int i = 0;
            while (i < nodeList.getLength()) {
                Node node = nodeList.item(i);
                if (node.getNodeType() == 1) {
                    Element elem = (Element)node;
                    try {
                        filesArrayList.add(elem.getElementsByTagName("ejb").item(0).getTextContent());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ++i;
            }
            this.dirName = new File(CommonConstants.APPLICATION_CONTEXT).getParentFile() + File.separator;
            BaseLogger.log("3", null, null, "dirName 1 :: " + this.dirName);
            File folder = new File(this.dirName);
            File[] fileArray = folder.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                String fileName = file.getName();
                if (!file.isDirectory() && fileName.contains(".jar") && !filesArrayList.contains(fileName)) {
                    fileInFolderArr.add(fileName);
                }
                ++n2;
            }
            BaseLogger.log("3", null, null, "fileInFolderArr.size()  :  " + (fileInFolderArr.size() > 0));
            if (fileInFolderArr.size() > 0) {
                BaseLogger.log("3", null, null, "\u001b[31mEntries are missing in application.xml for '" + fileInFolderArr + "' jar" + ANSI_RESET);
                Signal.raise(new Signal("INT"));
            }
        }
        catch (DOMException e) {
            BaseLogger.log("0", null, null, "VersionVerificationServlet.init() DOMException : " + e);
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            BaseLogger.log("0", null, null, "VersionVerificationServlet.init() ParserConfigurationException : " + e);
            e.printStackTrace();
        }
        catch (SAXException e) {
            BaseLogger.log("0", null, null, "VersionVerificationServlet.init() SAXException : " + e);
            e.printStackTrace();
        }
        catch (IOException e) {
            BaseLogger.log("0", null, null, "VersionVerificationServlet.init() IOException : " + e);
            e.printStackTrace();
        }
    }
}

