
package ibase.webitm.ejb.wsfa.transactions;

import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.utility.CommonConstants;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ITMDBAccessLocal;
import ibase.webitm.ejb.ValidatorEJB;
//import ibase.webitm.utility.GenericUtility;
import ibase.utility.E12GenericUtility;
import ibase.webitm.utility.ITMException;

import java.io.File;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;

import javax.naming.InitialContext;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;


//@javax.ejb.Stateless		commented by Sagar M [22 Nov 2018].
public class FlmCmeWizardEJB extends ValidatorEJB
{
	static int domID = 1;


	public String wfValSalesPersAct(Document dom, Document dom2, String currentFormNo, String userId) throws ITMException
	{
		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;

		//changed by Rahul Barve on 3-sep-2014
		//GenericUtility genericUtility = GenericUtility.getInstance();
		 E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();


		String errString = "";
		String checkSQL = "";
		String childNodeName = "";
		String columnValue = "";

		Connection connectionObject = null;
		PreparedStatement pstmt = null;
		ResultSet rSet = null ;

		ITMDBAccessEJB itmDBAccessLocal = null;//modified by kailash.

		int noOfChilds = 0;
		try
		{
			ConnDriver connDriver =new ConnDriver();
			connectionObject = connDriver.getConnectDB("DriverValidator");

			AppConnectParm appConnect = new AppConnectParm();
			Properties p = appConnect.getProperty();
			InitialContext ctx = new InitialContext(p);
			//Commented and modified by kailash on 20-07-18 as per gulzar sir[Start]
			//itmDBAccessLocal = (ITMDBAccessLocal)ctx.lookup("ibase/ITMDBAccessEJB/local");
			 itmDBAccessLocal = new ITMDBAccessEJB();
			//Commented and modified by kailash on 20-07-18 as per gulzar sir[End]

			parentList = dom.getElementsByTagName("Detail"+ currentFormNo);
			int parentNodeListLength = parentList.getLength();
			System.out.println("parentNodeListLength["+parentNodeListLength+"]");

			for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
			{
				parentNode = parentList.item(prntCtr);
				childList = parentNode.getChildNodes();
				noOfChilds = childList.getLength();
				for (int ctr = 0; ctr < noOfChilds; ctr++)
				{
					childNode = childList.item(ctr);
					if( childNode.getNodeType() != Node.ELEMENT_NODE )
					{
						continue;
					}

					if ( childNode != null && childNode.getFirstChild() != null )
					{
						columnValue = childNode.getFirstChild().getNodeValue();
					}
					childNodeName = childNode.getNodeName();

					if(childNodeName.equalsIgnoreCase("event_date"))
					{
						if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
								( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
						{
							errString = itmDBAccessLocal.getErrorString("event_date","NULLEVTCOD",userId);
							break;
						}
						else
						{
							SimpleDateFormat sdfFormat = new SimpleDateFormat(getApplDateFormat());
							java.util.Date eventDate = sdfFormat.parse( childNode.getFirstChild().getNodeValue());
							String evtdat=childNode.getFirstChild().getNodeValue();

							if (!sdfFormat.format(eventDate).equals(evtdat))
							{
								errString = itmDBAccessLocal.getErrorString( "event_date", "INVDTFRMT", userId );
								break;
							}

							if ( ( eventDate.compareTo( getDateObject( sdfFormat.format( new Date() ) ) ) ) > 0 )
							{
								errString = itmDBAccessLocal.getErrorString( "event_date", "FUTUREVENT", userId );
								break;
							}
							String salesPers = genericUtility.getColumnValue( "sales_pers" , dom );
							String dcrDate = genericUtility.getColumnValue( "event_date" , dom );
							String confirmed = "";
							dcrDate = genericUtility.getValidDateTimeString( dcrDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );
							String selectSql = "SELECT CONFIRMED FROM SPRS_ACT_TRAN WHERE SALES_PERS = ? AND EVENT_DATE = ?";
							PreparedStatement pstmtSel = connectionObject.prepareStatement(selectSql);
							pstmtSel.setString(1, userId);
							pstmtSel.setTimestamp(2, java.sql.Timestamp.valueOf(dcrDate));
							ResultSet rsSelect = pstmtSel.executeQuery();
							if(rsSelect.next())
							{
								confirmed = (rsSelect.getString("CONFIRMED") == null) ?"":rsSelect.getString("CONFIRMED").trim();
							}
							rsSelect.close(); rsSelect = null;
							pstmtSel.close(); pstmtSel = null;
							if("Y".equalsIgnoreCase(confirmed))
							{
								errString = itmDBAccessLocal.getErrorString( "event_date" , "DCRCONFD" , userId );
								break;
							}

							int allowDays = 0;
							checkSQL = "SELECT PROP_VALUE FROM PROPERTIES WHERE PROP_NAME ='MAX_ALLOW_PRD_MEET'";
							pstmt = connectionObject.prepareStatement(checkSQL);
							rSet = pstmt.executeQuery( checkSQL );
							if( rSet.next() )
							{
								allowDays = rSet.getInt("PROP_VALUE");
								System.out.println("allowDays Exist In Properties are ["+allowDays+"]");
								java.util.Calendar cal = java.util.Calendar.getInstance();
								java.util.Date currDate = new java.util.Date();
								cal.setTime( currDate );
								cal.add( cal.DATE, -allowDays );
								if( eventDate.before( cal.getTime() ) )
								{
									errString = itmDBAccessLocal.getErrorString( "event_date" , "XCIDMITLMT" , userId );
									break;
								}
							}
							if (rSet!= null)
							{
								rSet.close();
								rSet = null;
							}
							if(pstmt!=null)
							{
								pstmt.close();
								pstmt = null;
							}


							String eventdate = childNode.getFirstChild().getNodeValue();


							if( salesPers != null && eventdate != null )
							{
								errString = valHoliday( eventdate, salesPers, userId, itmDBAccessLocal, connectionObject );
								if(errString != null && errString.length()>0 && errString.indexOf("ERRORS")!=-1)
								{
									System.out.println("Holiday!");
									break;

								}
							}


						}

					}
					else if(childNodeName.equalsIgnoreCase("activity_code"))
					{

						String actDescr = genericUtility.getColumnValue( "activity_descr" , dom );

						if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
								( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue()))|| actDescr == null || (actDescr != null && "null".equalsIgnoreCase(actDescr)) )
						{
							errString = itmDBAccessLocal.getErrorString("activity_code","NULLACTCOD",userId);
							break;
						}
						else
						{
							if (columnValue.trim().length() > 2)
							{
								errString = itmDBAccessLocal.getErrorString("activity_code","LENGTH",userId);
								break;
							}
							else
							{
								checkSQL = "SELECT COUNT(1) COUNT FROM FIELDACTIVITY WHERE ACTIVITY_CODE = ?";
								pstmt = connectionObject.prepareStatement(checkSQL);
								pstmt.setString(1,checkNull(columnValue));
								rSet = pstmt.executeQuery();
								if(rSet.next() && rSet.getInt("COUNT") < 1 )
								{
									errString = itmDBAccessLocal.getErrorString("activity_code","INVEVET",userId);
									break;
								}
								if (rSet!= null)
								{
									rSet.close();
									rSet = null;
								}
								if(pstmt!=null)
								{
									pstmt.close();
									pstmt = null;
								}
								String eventDate = genericUtility.getColumnValue( "event_date" , dom );
								String salesPers = genericUtility.getColumnValue( "sales_pers" , dom );
								String pDate = "";
								try
								{
									pDate = genericUtility.getValidDateString( eventDate , getApplDateFormat() , "dd-MMM-yyyy");
								}
								catch ( Exception e )
								{
									System.out.println("------------- INVALIDFRMT ---------------");
									errString = itmDBAccessLocal.getErrorString( "event_date", "INVDTFRMT", userId );
									break;
								}

							}
						}

					}
					else if(childNodeName.equalsIgnoreCase("sales_pers"))
					{
						if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
								( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
						{
							errString = itmDBAccessLocal.getErrorString("sales_pers","NULLSPRSCD",userId);
							break;
						}
						else
						{
							if( parentNodeListLength > 1 )
							{
								errString = itmDBAccessLocal.getErrorString("sales_pers","SPRSONCE",userId);
								break;
							}

							String eventDate = genericUtility.getColumnValue( "event_date" , dom );
							String sprs = childNode.getFirstChild().getNodeValue();
							String dcrID = genericUtility.getColumnValue( "dcr_id" , dom );
							if( dcrID == null || "null".equalsIgnoreCase(dcrID) )
							{
								dcrID = "x";
							}
							checkSQL = "SELECT * FROM SALES_PERS WHERE SALES_PERS = ?";
							pstmt = connectionObject.prepareStatement(checkSQL);
							pstmt.setString(1,checkNull(sprs));
							rSet = pstmt.executeQuery();
							if(!rSet.next())
							{
								errString = itmDBAccessLocal.getErrorString("sales_pers","WRGSPRSCD",userId);
								break;
							}
							if (rSet!= null)
							{
								rSet.close();
								rSet = null;
							}
							if(pstmt!=null)
							{
								pstmt.close();
								pstmt = null;
							}
						}
					}
					else if(childNodeName.equalsIgnoreCase("sprs_route_stan_code"))
					{
						if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
								( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
						{
							errString = itmDBAccessLocal.getErrorString("sprs_route_stan_code","NULLSTANCD",userId);
							break;
						}
					}
				}
				if(errString.indexOf("<Errors>")!=-1)
				{
					break;
				}
			}
		}
		catch(Exception e)
		{
			System.out.println ( "Exception :StrgMeetWizardEJB :wfValData():" + e.getMessage() + ":" );
			throw new ITMException(e);

		}
		finally
		{
			try
			{
				if (rSet!= null)
				{
					rSet.close();
					rSet = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}

				if (connectionObject != null)
				{
					connectionObject.close();
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}

		return errString;
	}

	public String wfValSalesPersActRIA(Document dom, Document dom2, String currentFormNo, String userId) throws ITMException
	{
		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;

		//changed by Rahul Barve on 3-sep-2014
		//GenericUtility genericUtility = GenericUtility.getInstance();
		 E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();


		String errString = "";
		String checkSQL = "";
		String childNodeName = "";
		String columnValue = "";

		Connection connectionObject = null;
		PreparedStatement pstmt = null;
		ResultSet rSet = null ;

		ITMDBAccessEJB itmDBAccessLocal = null;// modifid by kailash.

		int noOfChilds = 0;
		try
		{
			ConnDriver connDriver =new ConnDriver();
			connectionObject = connDriver.getConnectDB("DriverValidator");

			AppConnectParm appConnect = new AppConnectParm();
			Properties p = appConnect.getProperty();
			InitialContext ctx = new InitialContext(p);
			//Commented and modified by kailash on 20-07-18 as per gulzar sir[Start]
			//itmDBAccessLocal = (ITMDBAccessLocal)ctx.lookup("ibase/ITMDBAccessEJB/local");
			new ITMDBAccessEJB();
			//Commented and modified by kailash on 20-07-18 as per gulzar sir[End]

			parentList = dom.getElementsByTagName("Detail"+ currentFormNo);
			int parentNodeListLength = parentList.getLength();
			System.out.println("parentNodeListLength["+parentNodeListLength+"]");

			for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
			{
				parentNode = parentList.item(prntCtr);
				childList = parentNode.getChildNodes();
				noOfChilds = childList.getLength();
				for (int ctr = 0; ctr < noOfChilds; ctr++)
				{
					childNode = childList.item(ctr);
					if( childNode.getNodeType() != Node.ELEMENT_NODE )
					{
						continue;
					}

					if ( childNode != null && childNode.getFirstChild() != null )
					{
						columnValue = childNode.getFirstChild().getNodeValue();
					}
					childNodeName = childNode.getNodeName();

					if(childNodeName.equalsIgnoreCase("event_date"))
					{
						if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
								( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
						{
							errString = itmDBAccessLocal.getErrorString("event_date","NULLEVTCOD",userId);
							break;
						}
						else
						{
							//SimpleDateFormat sdfFormat = new SimpleDateFormat("dd/MM/yyyy");//commented by vinayak
							SimpleDateFormat sdfFormat = new SimpleDateFormat(getApplDateFormat());//Added by vinayak to set Date Format on [03/10/2016]
							String evtdat= childNode.getFirstChild().getNodeValue();
							java.util.Date eventDate = sdfFormat.parse( evtdat);

							if (!sdfFormat.format(eventDate).equals(evtdat))
							{
								errString = itmDBAccessLocal.getErrorString( "event_date", "INVDTFRMT", userId );
								break;
							}


							if ( ( eventDate.compareTo( getDateObject( sdfFormat.format( new Date() ) ) ) ) > 0 )
							{
								errString = itmDBAccessLocal.getErrorString( "event_date", "FUTUREVENT", userId );
								break;
							}

							int allowDays = 0;
							checkSQL = "SELECT PROP_VALUE FROM PROPERTIES WHERE PROP_NAME ='MAX_ALLOW_PRD_MEET'";
							pstmt = connectionObject.prepareStatement(checkSQL);
							rSet = pstmt.executeQuery( checkSQL );
							if( rSet.next() )
							{
								allowDays = rSet.getInt("PROP_VALUE");
								System.out.println("allowDays Exist In Properties are ["+allowDays+"]");
								java.util.Calendar cal = java.util.Calendar.getInstance();
								cal.setTime( getDateObject( sdfFormat.format( new Date() ) ) );
								cal.add( cal.DATE, -allowDays );
								if( eventDate.before( cal.getTime() ) )
								{
									errString = itmDBAccessLocal.getErrorString( "event_date" , "XCIDMITLMT" , userId );
									break;
								}
							}
							if (rSet!= null)
							{
								rSet.close();
								rSet = null;
							}
							if(pstmt!=null)
							{
								pstmt.close();
								pstmt = null;
							}


							String salesPers = genericUtility.getColumnValue( "sales_pers" , dom );
							if( salesPers != null && evtdat != null )
							{
								errString = valHoliday( evtdat, salesPers, userId, itmDBAccessLocal, connectionObject);
								if(errString != null && errString.length()>0 && errString.indexOf("ERRORS")!=-1)
								{
									errString = itmDBAccessLocal.getErrorString("event_date","HOLIDAY",userId);
									System.out.println("Holiday!");
									break;

								}
							}

						}

					}
					else if(childNodeName.equalsIgnoreCase("activity_code"))
					{
						if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
						{

							errString = itmDBAccessLocal.getErrorString("activity_code", "NULLACTCOD",userId);
							break;
						}
						else
						{
							if (columnValue.trim().length() > 2)
							{
								errString = itmDBAccessLocal.getErrorString("activity_code","LENGTH",userId);
								break;
							}
							else
							{
								checkSQL = "SELECT COUNT(1) COUNT FROM FIELDACTIVITY WHERE ACTIVITY_CODE = ?";
								pstmt = connectionObject.prepareStatement(checkSQL);
								pstmt.setString(1,checkNull(columnValue));
								rSet = pstmt.executeQuery();
								if(rSet.next() && rSet.getInt("COUNT") < 1 )
								{
									errString = itmDBAccessLocal.getErrorString("activity_code","INVEVET",userId);
									break;
								}

								if (rSet!= null)
								{
									rSet.close();
									rSet = null;
								}
								if(pstmt!=null)
								{
									pstmt.close();
									pstmt = null;
								}
								String eventDate = genericUtility.getColumnValue( "event_date" , dom );
								String salesPers = genericUtility.getColumnValue( "sales_pers" , dom );
								String pDate = "";
								try
								{
									pDate = genericUtility.getValidDateString( eventDate , getApplDateFormat() , "dd-MMM-yyyy");
								}
								catch ( Exception e )
								{
									System.out.println("------------- INVALIDFRMT ---------------");
									errString = itmDBAccessLocal.getErrorString( "event_date", "INVDTFRMT", userId );
									break;
								}
								//checkSQL = "SELECT ACTIVITY_TYPE FROM STRG_MEET,FIELDACTIVITY WHERE EVENT_DATE=? AND SALES_PERS=?  AND FIELDACTIVITY.ACTIVITY_CODE = STRG_MEET.EVENT_TYPE";
								checkSQL = "SELECT ACTIVITY_TYPE FROM SPRS_ACT_TRAN,FIELDACTIVITY WHERE EVENT_DATE=? AND SALES_PERS=?  AND SPRS_ACT_TRAN.ACTIVITY_CODE = FIELDACTIVITY.ACTIVITY_CODE ";
								pstmt = connectionObject.prepareStatement(checkSQL);
								pstmt.setString(1, pDate);
								pstmt.setString(2, salesPers);
								rSet = pstmt.executeQuery();
								if( rSet.next() )
								{
									String activityType = rSet.getString(1);
									activityType = checkNull(activityType).toUpperCase();
									System.out.println("activity type is ===>"+activityType);
									if(activityType.indexOf("LEAVE")!=-1 )
									{
										checkSQL = " SELECT ACTIVITY_TYPE FROM FIELDACTIVITY WHERE ACTIVITY_CODE = ? ";
										pstmt = connectionObject.prepareStatement(checkSQL);
										pstmt.setString(1, columnValue);
										rSet = pstmt.executeQuery();
										if( rSet.next() )
										{
											if(!activityType.equalsIgnoreCase(rSet.getString(1)))
											{
												errString = itmDBAccessLocal.getErrorString( "event_type", "EPLANLEAVE", userId );
												break;
											}
										}
										if (rSet!= null)
										{
											rSet.close();
											rSet = null;
										}
										if(pstmt!=null)
										{
											pstmt.close();
											pstmt = null;
										}
									}
									else if (activityType.indexOf("NFW")!=-1)
									{
										checkSQL = " SELECT ACTIVITY_TYPE FROM FIELDACTIVITY WHERE ACTIVITY_CODE = ? ";
										pstmt = connectionObject.prepareStatement(checkSQL);
										pstmt.setString(1, columnValue);
										rSet =pstmt.executeQuery();
										if( rSet.next() )
										{
											if(!activityType.equalsIgnoreCase(rSet.getString(1)))
											{
												errString = itmDBAccessLocal.getErrorString( "event_type", "EPLANNFW", userId );
												break;
											}
										}
										if (rSet!= null)
										{
											rSet.close();
											rSet = null;
										}
										if(pstmt!=null)
										{
											pstmt.close();
											pstmt = null;
										}
									}
								}

								if (rSet!= null)
								{
									rSet.close();
									rSet = null;
								}
								if(pstmt!=null)
								{
									pstmt.close();
									pstmt = null;
								}
							}
						}

					}
					else if(childNodeName.equalsIgnoreCase("sales_pers"))
					{
						if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
								( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
						{
							errString = itmDBAccessLocal.getErrorString("sales_pers","NULLSPRSCD",userId);
							break;
						}
						else
						{
							if( parentNodeListLength > 1 )
							{
								errString = itmDBAccessLocal.getErrorString("sales_pers","SPRSONCE",userId);
								break;
							}

							String eventDate = genericUtility.getColumnValue( "event_date" , dom );
							String sprs = childNode.getFirstChild().getNodeValue();
							String dcrID = genericUtility.getColumnValue( "dcr_id" , dom );
							if( dcrID == null || "null".equalsIgnoreCase(dcrID) )
							{
								dcrID = "x";
							}
							checkSQL = "SELECT * FROM SALES_PERS WHERE SALES_PERS = ?";
							pstmt = connectionObject.prepareStatement(checkSQL);
							pstmt.setString(1,checkNull(sprs));
							rSet = pstmt.executeQuery();
							if(!rSet.next())
							{
								errString = itmDBAccessLocal.getErrorString("sales_pers","WRGSPRSCD",userId);
								break;
							}

							if (rSet!= null)
							{
								rSet.close();
								rSet = null;
							}
							if(pstmt!=null)
							{
								pstmt.close();
								pstmt = null;
							}
						}
					}
					else if(childNodeName.equalsIgnoreCase("sprs_route_stan_code"))
					{
						if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
								( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
						{
							errString = itmDBAccessLocal.getErrorString("sprs_route_stan_code","NULLSTANCD",userId);
							break;
						}
					}
				}
				if(errString.indexOf("<Errors>")!=-1)
				{
					break;
				}
			}
		}
		catch(Exception e)
		{

			System.out.println ( "Exception :StrgMeetWizardEJB :wfValData():" + e.getMessage() + ":" );
			errString = generateErrorString(genericUtility.createErrorString(e));
		}
		finally
		{
			try
			{
				if (rSet !=null )
				{
					rSet.close();
				}
				if(pstmt != null)
				{
					pstmt.close();
				}


				if (connectionObject != null)
				{
					connectionObject.close();
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}

		return errString;
	}
	public String wfValLocality(Document dom, String currentFormNo, String userId) throws ITMException
	{
		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;

		//changed by Rahul Barve on 3-sep-2014
		//GenericUtility genericUtility = GenericUtility.getInstance();
		 E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();


		String errString = "";
		String columnValue = "";
		String checkSQL = "";
		String childNodeName = "";
		String errString1 = "";
		String actType = "";

		Connection connectionObject = null;
		PreparedStatement pstmt = null;
		ResultSet rSet = null ;

		ITMDBAccessEJB itmDBAccessLocal = null;//modified by kaialsh.

		int ctr = 0;
		int noOfChilds = 0;
		try
		{
			AppConnectParm appConnect = new AppConnectParm();
			Properties p = appConnect.getProperty();
			InitialContext ctx = new InitialContext(p);
			//Commented and modified by kailash on 20-07-18 as per gulzar sir[Start]
			//itmDBAccessLocal = (ITMDBAccessLocal)ctx.lookup("ibase/ITMDBAccessEJB/local");
			new ITMDBAccessEJB();
			//Commented and modified by kailash on 20-07-18 as per gulzar sir[End]

			ConnDriver connDriver = connDriver = new ConnDriver();;
			connectionObject = connDriver.getConnectDB("DriverValidator");

			parentList = dom.getElementsByTagName("Detail" + currentFormNo);
			int parentNodeListLength = parentList.getLength();
			System.out.println("parentNodeListLength(wfValLocality)["+parentNodeListLength+"]");
			for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
			{
				String locDescr = getSelectedRowValue(dom, currentFormNo, "sprs_route_descr",prntCtr);
				String actCode = genericUtility.getColumnValue("activity_code", dom);
				parentNode = parentList.item(prntCtr);
				childList = parentNode.getChildNodes();
				noOfChilds = childList.getLength();
				for (ctr = 0; ctr < noOfChilds; ctr++)
				{
					childNode = childList.item(ctr);
					if( childNode.getNodeType() != Node.ELEMENT_NODE )
					{
						continue;
					}

					if ( childNode != null && childNode.getFirstChild() != null )
					{
						columnValue = childNode.getFirstChild().getNodeValue().trim();
					}
					childNodeName = childNode.getNodeName();
					if(childNodeName.equalsIgnoreCase("locality_code"))
					{
						if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) || ( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue()))||childNode.getFirstChild() == null)
						{
							errString = itmDBAccessLocal.getErrorString("locality_code","NULLLOCTCD",userId);
							break;
						}
					}
					else if( childNodeName.equalsIgnoreCase("travel_mode") )
					{
						if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) || ( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue()))||childNode.getFirstChild() == null)
						{
							errString = itmDBAccessLocal.getErrorString("travel_mode","NULLTRVLM",userId);
							break;
						}
					}
					else if(childNodeName.equalsIgnoreCase("over_night"))
					{
						if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) || ( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue()))||childNode.getFirstChild() == null)
						{
							errString = itmDBAccessLocal.getErrorString("over_night","NULLOVRNIT",userId);
							break;
						}
					}
					else if(childNodeName.equalsIgnoreCase("order_of_visit"))
					{
						if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) || ( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue()))||childNode.getFirstChild() == null)
						{
							errString = itmDBAccessLocal.getErrorString("order_of_visit","NULLORDVST",userId);
							break;
						}

					}
				}
				if( errString.indexOf("<Errors>")!=-1 || errString1.indexOf("<Errors>")!=-1 )
				{
					if( errString.length() > 0 )
					{
						String msgDescr = errString.substring(errString.indexOf("<description>")+("<description>").length(),errString.indexOf("</description>")) + " for locality " + locDescr ;

						errString = errString.substring(0, errString.indexOf("<description>")+("<description>").length()) + msgDescr + "" + errString.substring( errString.indexOf("</description>"), errString.length());
						break;
					}
					else if( errString1.length() > 0 )
					{
						errString = errString1;
						break;
					}

				}
			}

		}
		catch(Exception e)
		{
			System.out.println ( "Exception :StrgMeetWizardEJB :wfValData():" + e.getMessage() + ":" );
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rSet!= null)
				{
					rSet.close();
					rSet = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}

				if (connectionObject != null)
				{
					connectionObject.close();
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}

		return errString;

	}

	public String wfValCustomer(Document dom, String currentFormNo, String userId) throws ITMException
	{
		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;

		//changed by Rahul Barve on 3-sep-2014
		//GenericUtility genericUtility = GenericUtility.getInstance();
		 E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();


		String errString = "";
		String errString1 = "";
		String columnValue = "";
		String checkSQL = "";
		String childNodeName = "";

		Connection connectionObject = null;
		PreparedStatement pstmt = null;
		ResultSet rSet = null ;

		ITMDBAccessEJB itmDBAccessLocal = null;//modified by kailash.

		int ctr = 0;
		int noOfChilds = 0;
		try
		{
			AppConnectParm appConnect = new AppConnectParm();
			Properties p = appConnect.getProperty();
			InitialContext ctx = new InitialContext(p);
			//Commented and modified by kailash on 20-07-18 as per gulzar sir[Start]
			//itmDBAccessLocal = (ITMDBAccessLocal)ctx.lookup("ibase/ITMDBAccessEJB/local");
			new ITMDBAccessEJB();
			//Commented and modified by kailash on 20-07-18 as per gulzar sir[End]

			ConnDriver connDriver = connDriver = new ConnDriver();;
			connectionObject = connDriver.getConnectDB("DriverValidator");

			parentList = dom.getElementsByTagName("Detail" + currentFormNo);
			int parentNodeListLength = parentList.getLength();
			System.out.println("parentNodeListLength(wfValCustomer)["+parentNodeListLength+"]");
			for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
			{
				String custName = getSelectedRowValue(dom, currentFormNo, "cust_name",prntCtr);
				parentNode = parentList.item(prntCtr);
				childList = parentNode.getChildNodes();
				noOfChilds = childList.getLength();
				for (ctr = 0; ctr < noOfChilds; ctr++)
				{
					childNode = childList.item(ctr);
					if( childNode.getNodeType() != Node.ELEMENT_NODE )
					{
						continue;
					}
					if ( childNode != null && childNode.getFirstChild() != null )
					{
						columnValue = childNode.getFirstChild().getNodeValue().trim();
					}
					childNodeName = childNode.getNodeName();
					if(childNodeName.equalsIgnoreCase("short_id"))
					{
						String strgType = checkNull(getSelectedRowValue(dom, currentFormNo, "strg_type",prntCtr)).trim();
						if("D".equalsIgnoreCase(strgType))
						{
							if((childNode.getFirstChild() == null) || (childNode.getFirstChild().getNodeValue() == null) ||
									( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
							{
								errString = itmDBAccessLocal.getErrorString("short_id","NULLMPLNID",userId);
								break;
							}
						}
					}
					else if(childNodeName.equalsIgnoreCase("strg_code"))
					{
						String actCode = genericUtility.getColumnValue("event_type",dom);
						if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
								( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
						{
							errString1 = itmDBAccessLocal.getErrorString("strg_code","NULSTRGCD",userId);
							break;
						}
					}
					else if ( "strg_type".equalsIgnoreCase( childNodeName ) )
					{
						String strgCode = genericUtility.getColumnValue( "strg_code", dom );
						if(  strgCode != null &&  strgCode.length() > 0 && (   ( ! "null".equalsIgnoreCase(strgCode) ) || ( ! "-NA-".equalsIgnoreCase(strgCode) ) ) )
						{
							if ( childNode.getFirstChild() == null )
							{
								errString = itmDBAccessLocal.getErrorString("strg_type","NULSTRGT",userId);
								break;
							}

						}
					}
					else if ( "strg_class_code".equalsIgnoreCase( childNodeName ) )
					{
						String strgCode = genericUtility.getColumnValue("strg_code",dom);
						if(  strgCode != null &&  strgCode.length() > 0 && (   ( ! "null".equalsIgnoreCase(strgCode) ) || ( ! "-NA-".equalsIgnoreCase(strgCode) ) ) )
						{
							if ( childNode.getFirstChild() == null )
							{
								errString = itmDBAccessLocal.getErrorString("strg_class_code","NULSTRCC",userId);
								break;
							}
						}
					}
					else if ( "strg_no_visit".equalsIgnoreCase( childNodeName ) )
					{
						String strgCode = genericUtility.getColumnValue( "strg_code", dom );

						String strgType = checkNull(genericUtility.getColumnValue( "strg_type", dom ));
						if(  strgCode != null &&  strgCode.length() > 0 && ("D".equalsIgnoreCase(strgType)) && (   ( ! "null".equalsIgnoreCase(strgCode) ) || ( ! "-NA-".equalsIgnoreCase(strgCode) ) ) )
						{
							if ( childNode.getFirstChild() == null )
							{
								errString = itmDBAccessLocal.getErrorString("strg_no_visit","NULSTRGV",userId);
								break;
							}
						}
					}
					else if ( "strg_name".equalsIgnoreCase( childNodeName ) )
					{
						String strgCode = genericUtility.getColumnValue( "strg_code", dom );
						String strgType = genericUtility.getColumnValue( "strg_type", dom );
						if( strgCode == null  && strgType != null )
						{
							if ( childNode.getFirstChild() == null  )
							{
								errString = itmDBAccessLocal.getErrorString("strg_name","NULSTRGN",userId);
								break;
							}
						}
						else
						{
							if (strgCode != null && childNode.getFirstChild() != null)
							{
								errString = itmDBAccessLocal.getErrorString("strg_name","INSERTVALD",userId);
							}
						}
					}
				}
				if(errString.indexOf("<Errors>")!=-1 || errString1.indexOf("<Errors>")!=-1)
				{
					if( errString.length() > 0 )
					{
						String msgDescr = "";
						msgDescr = errString.substring(errString.indexOf("<description>")+("<description>").length(),errString.indexOf("</description>")) + " for customer " + custName ;

						if( custName.length() != 0 && !custName.equalsIgnoreCase("") )
						{
							errString = errString.substring(0, errString.indexOf("<description>")+("<description>").length()) + msgDescr + "" + errString.substring( errString.indexOf("</description>"), errString.length());
						}
						break;
					}
					else if( errString1.length() > 0 )
					{
						errString = errString1;
						break;
					}

				}
			}
		}
		catch(Exception e)
		{
			System.out.println ( "Exception :StrgMeetWizardEJB :wfValData():" + e.getMessage() + ":" );
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rSet!= null)
				{
					rSet.close();
					rSet = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}

				if (connectionObject != null)
				{
					connectionObject.close();
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return errString;

	}
	public String getSalesPers(Document dom, Document dom2, String currentForm, String userId, String salesPers, String actCode, String trvDate) throws ITMException
	{
		ResultSet rs = null;
		Connection connectionObject = null;
		//Statement stmt = null;
		PreparedStatement pstmt =null;
		String sql = "";
		String currDate = "";
		String chgTerm ="";
		String preFormDet ="";
		String actDescr = "";
		StringBuffer valueXmlString = new StringBuffer();
		boolean flag = false;
		ArrayList temp = new ArrayList();

		//changed by Rahul Barve on 3-sep-2014
		//GenericUtility genericUtility = GenericUtility.getInstance();
		 E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

		try
		{
			InetAddress ownIP=InetAddress.getLocalHost();
			chgTerm = ownIP.getHostAddress();

			DateFormat dtFormat = new SimpleDateFormat(getApplDateFormat());
			java.util.Date date = Calendar.getInstance().getTime();
			currDate = dtFormat.format( date );
			System.out.println("SalesPerson  (getSalesPers)> "+salesPers);
			if( salesPers != null && salesPers.trim().length() > 0 && !salesPers.equalsIgnoreCase("") )
			{
				salesPers = salesPers.trim().toUpperCase();
			}
			ConnDriver connDriver = new ConnDriver();
			connectionObject = connDriver.getConnectDB( "DriverValidator" );

			flag = preDomExists( dom, currentForm );
			System.out.println( "history detail exists["+ flag +"]" );
			if( flag )
			{
				preFormDet = getPrevFormValues( dom, currentForm, temp , "sales_pers");
				Document preFormDom =  genericUtility.parseString("<Root>"+preFormDet+"</Root>");
				String actCodePreDom = genericUtility.getColumnValue( "activity_code",preFormDom );
				java.util.Date eventDte = genericUtility.getDateObject(genericUtility.getColumnValue( "event_date", preFormDom ));

				//Commented and Bellow Changes Done By Shahu Mali on 04-10-13
				//sql = "SELECT DESCR FROM FIELDACTIVITY WHERE ACTIVITY_CODE = '"+actCodePreDom+"'";
				//stmt = connectionObject.createStatement();
				//rs = stmt.executeQuery(sql);
				sql = "SELECT DESCR FROM FIELDACTIVITY WHERE ACTIVITY_CODE = ? ";
				pstmt = connectionObject.prepareStatement(sql);
				pstmt.setString(1, actCodePreDom);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					actDescr = rs.getString("DESCR");

				}
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				/*if(stmt!=null)
				{
					stmt.close();
					stmt = null;
				}*/
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				Element element = (Element) preFormDom.getElementsByTagName("Detail"+currentForm).item(0);
				element.appendChild(preFormDom.createElement("activity_descr"));
				preFormDom.getElementsByTagName("activity_descr").item(0).appendChild(preFormDom.createCDATASection(actDescr));

				Node node = preFormDom.getElementsByTagName("Detail" + currentForm).item(0);
				NodeList nodeList = node.getChildNodes();
				for (int i = 0; i < nodeList.getLength(); i++ )
				{
					Node elementNode = nodeList.item(i);
					if ( elementNode.getNodeName().equals("event_date") )
					{
						if ( elementNode.getFirstChild() == null)
						{
							Element sourceElement = preFormDom.createElement( "event_date" );
							Text sourceText = preFormDom.createTextNode( Long.toString(eventDte.getTime()) );
							sourceElement.appendChild( sourceText );
							Node updatedNode = preFormDom.importNode( ( Node ) sourceElement,true );
							node.replaceChild( updatedNode, elementNode );
						}
						else
						{
							elementNode.getFirstChild().setNodeValue( Long.toString(eventDte.getTime()) );
						}
					}
				}

				preFormDet = genericUtility.serializeDom(preFormDom);
				if( preFormDet != null || !"null".equalsIgnoreCase( preFormDet ))
				{
					valueXmlString.append( preFormDet );
					domID = domID + 1;
				}

			}

			//Commented and Bellow Changes Done By Shahu Mali on 04-10-13


			sql = "SELECT DISTINCT SR.SPRS_CODE SALES_PERS, UPPER(SP.SP_NAME) SP_NAME FROM SPRS_ROUTE SR, SALES_PERS SP WHERE SR.SPRS_CODE = SP.SALES_PERS AND SP.SP_NAME LIKE '%"+checkNull(salesPers)+"%' ORDER BY SPRS_CODE ";
			//stmt = connectionObject.createStatement();
			//rs = stmt.executeQuery(sql);
			pstmt = connectionObject.prepareStatement(sql);
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				valueXmlString.append( "<Detail"+currentForm+" domID='" + domID + "' selected ='N'>\r\n" );
				valueXmlString.append( "<sales_pers><![CDATA[" ).append(checkNull(rs.getString("SALES_PERS"))).append( "]]></sales_pers>\r\n" );
				valueXmlString.append( "<sales_pers_sp_name><![CDATA[" ).append(checkNull(rs.getString("SP_NAME"))).append( "]]></sales_pers_sp_name>\r\n" );
				valueXmlString.append( "<event_date><![CDATA[" ).append( checkNull( trvDate ) ).append( "]]></event_date>\r\n" );
				valueXmlString.append( "<activity_code><![CDATA[" ).append( checkNull( actCode )).append( "]]></activity_code>\r\n" );
				valueXmlString.append( "<chg_date><![CDATA[" ).append(currDate).append( "]]></chg_date>\r\n" );
				valueXmlString.append( "<chg_user><![CDATA[" ).append(userId).append( "]]></chg_user>\r\n" );
				valueXmlString.append( "<chg_term><![CDATA[" ).append(chgTerm).append( "]]></chg_term>\r\n" );
				valueXmlString.append( "<dcr_id><![CDATA[]]></dcr_id>\r\n" );
				valueXmlString.append( "</Detail"+currentForm+">\r\n" );
				domID++;

			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			/*if(stmt!=null)
			{
				stmt.close();
				stmt = null;
			}*/
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}

			domID = 1;

		}
		catch(Exception e)
		{
			System.out.println( "Exception :StrgMeetWizardEJB :getSalesPers():" + e.getMessage() + ":" );
			valueXmlString = valueXmlString.append( generateErrorString( genericUtility.createErrorString( e ) ) );
		}
		finally
		{
			try
			{
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				/*

				if(stmt!=null)
				{
					stmt.close();
					stmt = null;
				}
				*/
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				if( connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :StrgMeetWizardEJB :getSalesPers :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		return valueXmlString.toString();
	}
	public String getPlaceOfWork( Document dom, Document dom2, String currentForm, String userId, String sprsCode, String actCode, String trvDate, String loginMode) throws ITMException
	{
		ResultSet rs = null;
		Connection connectionObject = null;
		PreparedStatement pstmt = null;

		String sql = "";
		String sqlEdit = "";
		String currDate = "";
		String chgTerm ="";
		String preFormDet ="";
		String locality ="";
		StringBuffer valueXmlString = new StringBuffer();
		//changed by Rahul Barve on 3-sep-2014
		//GenericUtility genericUtility = GenericUtility.getInstance();
		 E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

		boolean flag = false;
		int rowsRS = 0;
		ArrayList temp = new ArrayList();

		try{

			temp.add("'"+userId.trim()+"'");

			InetAddress ownIP=InetAddress.getLocalHost();
			chgTerm = ownIP.getHostAddress();

			DateFormat dtFormat = new SimpleDateFormat(getApplDateFormat());
			java.util.Date date = Calendar.getInstance().getTime();
			currDate = dtFormat.format( date );
			System.out.println("SalesPerson > " + sprsCode);

			ConnDriver connDriver = new ConnDriver();
			connectionObject = connDriver.getConnectDB( "DriverValidator" );
			flag = preDomExists( dom, currentForm );
			System.out.println( "history detail exists["+ flag +"]" );
			boolean flag1 = preDomExists( dom2, currentForm );
			System.out.println( "history detail exists in dom 2["+ flag1 +"]" );
			if( flag1 )
			{
				preFormDet = getPrevFormValues( dom2, currentForm, temp , "sales_pers");
				if( preFormDet != null || !"null".equalsIgnoreCase( preFormDet ))
				{
					locality = getLocFromDom( genericUtility.parseString("<Root>"+preFormDet+"</Root>"), currentForm, sprsCode );
					valueXmlString.append( preFormDet );
				}

			}
			else
			{

				sql = "SELECT COUNT(*) FROM SPRS_TRAVEL WHERE SALES_PERS = ? AND TRAVEL_DATE = ?";
				pstmt =  connectionObject.prepareStatement( sql );
				pstmt.setString(1, userId);
				pstmt.setTimestamp( 2, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( trvDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					rowsRS = rs.getInt(1);
				}
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}

				sqlEdit = "SELECT ST.*, SR.DESCR, DESCR,SP.SH_NAME FROM SPRS_TRAVEL ST, SPRS_ROUTE SR,SALES_PERS SP  WHERE ST.SPRS_CODE__WW = SR.SPRS_CODE AND ST.LOCALITY_CODE = SR.LOCALITY_CODE AND ST.SALES_PERS = ? AND ST.TRAVEL_DATE = ? AND ST.SPRS_CODE__WW = SP.SALES_PERS";

				if( rowsRS > 0 )
				{
					pstmt =  connectionObject.prepareStatement( sqlEdit );
					pstmt.setString(1, userId);
					pstmt.setTimestamp( 2, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( trvDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
					rs = pstmt.executeQuery();

					while(rs.next())
					{
						valueXmlString.append( "<Detail"+currentForm+" domID='"+ domID +"' selected = 'Y'>\r\n" );
						valueXmlString.append( "<locality_code><![CDATA[" ).append(checkNull(rs.getString("LOCALITY_CODE"))).append( "]]></locality_code>\r\n" );
						valueXmlString.append( "<sprs_route_descr><![CDATA[" ).append(checkNull(rs.getString("DESCR"))).append( "]]></sprs_route_descr>\r\n" );
						valueXmlString.append( "<stan_code><![CDATA[" ).append(checkNull(rs.getString("STAN_CODE"))).append( "]]></stan_code>\r\n" );
						valueXmlString.append( "<order_of_visit><![CDATA[" ).append(checkNull(rs.getString("ORDER_OF_VISIT"))).append( "]]></order_of_visit>\r\n" );
						valueXmlString.append( "<travel_mode><![CDATA[" ).append(checkNull(rs.getString("TRAVEL_MODE"))).append( "]]></travel_mode>\r\n" );
						valueXmlString.append( "<over_night><![CDATA[" ).append(checkNull(rs.getString("OVER_NIGHT"))).append( "]]></over_night>\r\n" );
						valueXmlString.append( "<sales_pers><![CDATA[" ).append(checkNull(userId)).append( "]]></sales_pers>\r\n" );
						valueXmlString.append( "<travel_date><![CDATA[" ).append(trvDate).append( "]]></travel_date>\r\n" );
						valueXmlString.append( "<activity_code><![CDATA[" ).append(checkNull(actCode)).append( "]]></activity_code>\r\n" );
						valueXmlString.append( "<chg_date><![CDATA[" ).append(currDate).append( "]]></chg_date>\r\n" );
						valueXmlString.append( "<chg_user><![CDATA[" ).append(userId).append( "]]></chg_user>\r\n" );
						valueXmlString.append( "<chg_term><![CDATA[" ).append(chgTerm).append( "]]></chg_term>\r\n" );
						valueXmlString.append( "<oth_participant><![CDATA[" ).append("").append( "]]></oth_participant>\r\n" );
						valueXmlString.append( "<plan_id><![CDATA[" ).append("").append( "]]></plan_id>\r\n" );
						valueXmlString.append( "<stan_code__from><![CDATA[" ).append("").append( "]]></stan_code__from>\r\n" );
						valueXmlString.append( "<sprs_code__ww><![CDATA[" ).append(checkNull(rs.getString("SPRS_CODE__WW"))).append( "]]></sprs_code__ww>\r\n" );
						valueXmlString.append( "<sprs_ww__name><![CDATA[" ).append(checkNull(rs.getString("SH_NAME"))).append( "]]></sprs_ww__name>\r\n" );
						valueXmlString.append( "<sales_team><![CDATA[" ).append("").append( "]]></sales_team>\r\n" );
						valueXmlString.append( "<template_file><![CDATA[" ).append("").append( "]]></template_file>\r\n" );
						valueXmlString.append( "<locality_code_from><![CDATA[" ).append("").append( "]]></locality_code_from>\r\n" );
						valueXmlString.append( "<dcr_id><![CDATA[]]></dcr_id>\r\n" );
						valueXmlString.append( "<line_no><![CDATA[]]></line_no>\r\n" );

						valueXmlString.append( "</Detail"+currentForm+">\r\n" );
						domID ++;

					}
					if (rs!= null)
					{
						rs.close();
						rs = null;
					}
					if(pstmt!=null)
					{
						pstmt.close();
						pstmt = null;
					}
					locality = getLocFromDom(genericUtility.parseString("<Root>"+valueXmlString.toString()+"</Root>"), currentForm, sprsCode);
				}
			}

			if( locality == null || locality.length() == 0 )
			{
				locality = "'x'";
			}
			if ( loginMode.equalsIgnoreCase("RIA") )
			{
				sql = "SELECT ST.LOCALITY_CODE, ST.DESCR, ST.STAN_CODE,ST.SPRS_CODE,SP.SH_NAME FROM SPRS_ROUTE ST,SALES_PERS SP WHERE ST.SPRS_CODE IN ("+sprsCode+") AND ST.STATUS='Y'";
			}
			else if ( loginMode.equalsIgnoreCase("HTML") )
			{
				sql = "SELECT ST.LOCALITY_CODE, ST.DESCR, ST.STAN_CODE,ST.SPRS_CODE,SP.SH_NAME FROM SPRS_ROUTE ST,SALES_PERS SP WHERE ST.SPRS_CODE IN ("+sprsCode+") AND ST.STATUS='Y' AND ST.SPRS_CODE = SP.SALES_PERS AND ST.LOCALITY_CODE NOT IN ("+locality+") ";
			}

			pstmt =  connectionObject.prepareStatement( sql );
			rs = pstmt.executeQuery();
			StringBuffer testStr = new StringBuffer("");
			int orderOfVisit = 1;
			while(rs.next())
			{
				String sprdWCode = checkNull(rs.getString("SPRS_CODE"));
				String localityCodeW = checkNull(rs.getString("LOCALITY_CODE"));
				{
					valueXmlString.append( "<Detail"+currentForm+" domID='"+ domID +"' selected = 'N'>\r\n" );
					valueXmlString.append( "<locality_code><![CDATA[" ).append(localityCodeW).append( "]]></locality_code>\r\n" );
					valueXmlString.append( "<sprs_route_descr><![CDATA[" ).append(checkNull(rs.getString("DESCR"))).append( "]]></sprs_route_descr>\r\n" );
					valueXmlString.append( "<stan_code><![CDATA[" ).append(checkNull(rs.getString("STAN_CODE"))).append( "]]></stan_code>\r\n" );
					valueXmlString.append( "<order_of_visit><![CDATA[" ).append("").append( "]]></order_of_visit>\r\n" );
					valueXmlString.append( "<sales_pers><![CDATA[" ).append(checkNull(userId)).append( "]]></sales_pers>\r\n" );
					valueXmlString.append( "<travel_date><![CDATA[" ).append(trvDate).append( "]]></travel_date>\r\n" );
					valueXmlString.append( "<activity_code><![CDATA[" ).append(checkNull(actCode)).append( "]]></activity_code>\r\n" );
					valueXmlString.append( "<chg_date><![CDATA[" ).append(currDate).append( "]]></chg_date>\r\n" );
					valueXmlString.append( "<chg_user><![CDATA[" ).append(userId).append( "]]></chg_user>\r\n" );
					valueXmlString.append( "<chg_term><![CDATA[" ).append(chgTerm).append( "]]></chg_term>\r\n" );
					valueXmlString.append( "<oth_participant><![CDATA[" ).append("").append( "]]></oth_participant>\r\n" );
					valueXmlString.append( "<plan_id><![CDATA[" ).append("").append( "]]></plan_id>\r\n" );
					valueXmlString.append( "<stan_code__from><![CDATA[" ).append("").append( "]]></stan_code__from>\r\n" );
					valueXmlString.append( "<sprs_code__ww><![CDATA[" ).append(sprdWCode).append( "]]></sprs_code__ww>\r\n" );
					valueXmlString.append( "<sprs_ww__name><![CDATA[" ).append(checkNull(rs.getString("SH_NAME"))).append( "]]></sprs_ww__name>\r\n" );
					valueXmlString.append( "<sales_team><![CDATA[" ).append("").append( "]]></sales_team>\r\n" );
					valueXmlString.append( "<template_file><![CDATA[" ).append("").append( "]]></template_file>\r\n" );
					valueXmlString.append( "<locality_code_from><![CDATA[" ).append("").append( "]]></locality_code_from>\r\n" );
					valueXmlString.append( "<dcr_id><![CDATA[]]></dcr_id>\r\n" );
					valueXmlString.append( "<line_no><![CDATA[]]></line_no>\r\n" );
					valueXmlString.append( "<travel_mode><![CDATA[" ).append("ROAD").append( "]]></travel_mode>\r\n" );
					valueXmlString.append( "<over_night><![CDATA[" ).append("N").append( "]]></over_night>\r\n" );
					valueXmlString.append( "</Detail"+currentForm+">\r\n" );
				}

				domID ++;

			}

			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
			valueXmlString = testStr.append(valueXmlString.toString());

			domID = 1;

		}
		catch(Exception e)
		{
			System.out.println( "Exception :StrgMeetWizardEJB :getPlaceOfWork():" + e.getMessage() + ":" );
			valueXmlString = valueXmlString.append( generateErrorString( genericUtility.createErrorString( e ) ) );
		}
		finally
		{
			try
			{
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				if( connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :StrgMeetWizardEJB :getPlaceOfWork :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		return  valueXmlString.toString();
	}

	public String getCustomerDetail(Document dom, Document dom2, String currentForm, String userId, String sprsCode, String actCode, String trvDate) throws ITMException
	{
		ResultSet rs = null;
		Connection connectionObject = null;
		//Statement stmt = null;
		PreparedStatement pstmt = null;

		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;

		String sql = "";
		String currDate = "";
		String chgTerm ="";
		String locality = "";
		String hours="";
		String startTime="";
		String hour = "";
		String minute = "";
		String interval ="";
		String preFormDet ="";
		String sqlEdit = "";
		String customers ="";
		String chgPreDet ="";
		String workTeamDescr ="";
		String [] temp;
		StringBuffer valueXmlString = new StringBuffer();
		List<String> list = null;
		//changed by Rahul Barve on 3-sep-2014
		//GenericUtility genericUtility = GenericUtility.getInstance();
		 E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

		boolean flag = false;
		int locForm = 0;
		int rowsRS = 0;
		String sqlJointWork = "";
		boolean isJointWork = false;
		try
		{
			InetAddress ownIP=InetAddress.getLocalHost();
			chgTerm = ownIP.getHostAddress();
			ConnDriver connDriver = new ConnDriver();
			connectionObject = connDriver.getConnectDB( "DriverValidator" );

			DateFormat dtFormat = new SimpleDateFormat(getApplDateFormat());
			java.util.Date date = Calendar.getInstance().getTime();
			currDate = dtFormat.format( date );
			System.out.println("USER ID IS ===========>"+userId);
			System.out.println("Salesperson >"+sprsCode);
			String trvDBDate =  genericUtility.getValidDateTimeString( trvDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );

			locForm = Integer.parseInt(currentForm) - 1;
			System.out.println("locForm is : ["+locForm+", currentForm"+currentForm);
			locality = getLocFromDom(dom2, Integer.toString(locForm), sprsCode);
			System.out.println("locality ::::::::"+locality);
			temp = locality.split(",");
			String actType = getActivityType( actCode,connectionObject );

			int strgMeetCount = 0;

			String checkStrgMeetSql = "SELECT COUNT(1) AS COUNT FROM SPRS_ACT_TRAN WHERE EVENT_DATE  = ? AND SALES_PERS = ? ";
			PreparedStatement pstmtCheckStrgMeet = connectionObject.prepareStatement(checkStrgMeetSql);

			String sprsCodeWW = "'";

			NodeList detail2NodeList = dom2.getElementsByTagName("Detail2");
			int detail2NodeListLen = detail2NodeList.getLength();
			for ( int p = 0; p < detail2NodeListLen; p++ )
			{
				NodeList detail2ChildNodeList = detail2NodeList.item(p).getChildNodes();
				int detail2ChildNodesLen = detail2ChildNodeList.getLength();
				for ( int c = 0; c < detail2ChildNodesLen; c++ )
				{
					String columnValue = "";
					Node detail2ChildNode = detail2ChildNodeList.item(c);
					if( detail2ChildNode.getNodeType() != Node.ELEMENT_NODE )
					{
						continue;
					}
					if ( detail2ChildNode != null && detail2ChildNode.getFirstChild() != null )
					{
						columnValue = detail2ChildNode.getFirstChild().getNodeValue();
					}
					String childNodeName = detail2ChildNode.getNodeName();
					System.out.println("childNodeName is : ["+childNodeName+"]"+"columnValue is ["+columnValue+"]");
				}
			}
			ArrayList strgCodeList = new ArrayList();

			int srNo = 0;
			flag = preDomExists( dom, currentForm );
			System.out.println( "history detail exists["+ flag +"]" );
			if(flag)
			{
				preFormDet = getPrevFormValues( dom, currentForm, new ArrayList<String>(Arrays.asList(temp)), "locality_code" );
				System.out.println("preform det ======>"+preFormDet);
				//String actCodePreDom = getSelectedRowValue(  genericUtility.parseString("<Root>"+preFormDet+"</Root>"), currentForm, "event_type", 0);
				String actTypePreDom = getActivityType( actCode, connectionObject );

				Document preFormDom =  genericUtility.parseString("<Root>"+preFormDet+"</Root>");
				NodeList preDomList = preFormDom.getElementsByTagName("Detail" + currentForm);
				for (int prntCtr = 0; prntCtr < preDomList.getLength(); prntCtr++ )
				{
					srNo++;
					String locDescr ="";
					String localityCode = getSelectedRowValue( preFormDom, currentForm,  "locality_code", prntCtr );
					sql = "SELECT DESCR FROM LOCALITY WHERE LOCALITY_CODE = ?";
					pstmt =  connectionObject.prepareStatement(sql);
					pstmt.setString(1, localityCode);
					rs = pstmt.executeQuery();
					if( rs.next())
					{
						locDescr = rs.getString("DESCR");

					}
					if (rs!= null)
					{
						rs.close();
						rs = null;
					}
					if(pstmt!=null)
					{
						pstmt.close();
						pstmt = null;
					}
					System.out.println(" locality descr ["+locDescr+"]");
					Element element = (Element) preFormDom.getElementsByTagName("Detail"+currentForm).item(prntCtr);
					element.appendChild(preFormDom.createElement("locality_descr"));
					preFormDom.getElementsByTagName("locality_descr").item(prntCtr).appendChild( preFormDom.createCDATASection( locDescr ) );
					element.appendChild(preFormDom.createElement("activity_type"));
					preFormDom.getElementsByTagName("activity_type").item(prntCtr).appendChild( preFormDom.createCDATASection( actTypePreDom ) );

					String toDisable = getSelectedRowValue( preFormDom, currentForm,  "to_disable", prntCtr );
					if(toDisable == null || toDisable.trim().length() == 0 )
					{
						strgMeetCount = 0;
						String custCode = getSelectedRowValue( preFormDom, currentForm,  "strg_code", prntCtr );
						pstmtCheckStrgMeet.setTimestamp(1, java.sql.Timestamp.valueOf(trvDBDate));
						pstmtCheckStrgMeet.setString(2, userId);
						pstmtCheckStrgMeet.setString(3, custCode);
						ResultSet rsCheckStrgMeet = pstmtCheckStrgMeet.executeQuery();
						if(rsCheckStrgMeet.next())
						{
							strgMeetCount = rsCheckStrgMeet.getInt("COUNT");
						}
						pstmtCheckStrgMeet.clearParameters();
						rsCheckStrgMeet.close(); rsCheckStrgMeet = null;
						if(strgMeetCount > 0 )
						{
							element.appendChild(preFormDom.createElement("to_disable"));
							preFormDom.getElementsByTagName("to_disable").item(prntCtr).appendChild( preFormDom.createCDATASection( "Y" ) );
						}
						else
						{
							element.appendChild(preFormDom.createElement("to_disable"));
							preFormDom.getElementsByTagName("to_disable").item(prntCtr).appendChild( preFormDom.createCDATASection( "N" ) );
						}
					}
					element.appendChild(preFormDom.createElement("sr_no"));
					preFormDom.getElementsByTagName("sr_no").item(prntCtr).appendChild( preFormDom.createCDATASection( ""+srNo ) );
				}
				if( pstmtCheckStrgMeet != null )
				{
					pstmtCheckStrgMeet.close(); pstmtCheckStrgMeet = null;
				}
				preFormDet = genericUtility.serializeDom( preFormDom );
				System.out.println("preFormDet.........::"+preFormDet);
				if( preFormDet != null || !"null".equalsIgnoreCase(preFormDet))
				{

					if ( actType.equalsIgnoreCase( actTypePreDom ) )
					{
						String preDomLocality = getLocFromDom( genericUtility.parseString("<Root>" + preFormDet + "</Root>"), currentForm, sprsCode );
						list = new ArrayList<String>( Arrays.asList( temp ) );
						list.removeAll( Arrays.asList( preDomLocality.split(",") ) );
						temp = list.toArray(new String[0]);
						customers = getCustFromDom( genericUtility.parseString("<Root>" + preFormDet + "</Root>"), currentForm, sprsCode , "Y");
						valueXmlString.append( preFormDet );
					}
				}
			}
			else
			{
				//Added by Rakesh kumar 04/03/13
				String dcrID="";
				//sql = "SELECT COUNT(*) FROM STRG_MEET WHERE SALES_PERS = ? AND EVENT_DATE = ?";
				sql = "SELECT DCR_ID FROM SPRS_ACT_TRAN WHERE EVENT_DATE = ? AND SALES_PERS = ?";
				PreparedStatement pstmtAacDCRID =  connectionObject.prepareStatement(sql);
				pstmtAacDCRID.setTimestamp(1, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( trvDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
				pstmtAacDCRID.setString(2, userId);
				ResultSet rsActDCRID = pstmtAacDCRID.executeQuery();
				if(rsActDCRID.next())
				{
					dcrID = checkNull(rsActDCRID.getString("DCR_ID"));
				}
				if(rsActDCRID !=null)
				{
					rsActDCRID.close();
					rsActDCRID = null;
				}
				if(pstmtAacDCRID != null)
				{
					pstmtAacDCRID.close();
					pstmtAacDCRID = null;
				}

				sql = "SELECT COUNT(*) FROM MKT_EVENT_PARTICIPANT WHERE DCR_ID = ?";

				pstmt =  connectionObject.prepareStatement( sql );
				pstmt.setString(1, dcrID);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					rowsRS = rs.getInt(1);
				}
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				sqlEdit="SELECT MKT_EVENT_PARTICIPANT.*,SPRS_TRAVEL.LOCALITY_CODE," +
				" UPPER(STRG_CUSTOMER.FIRST_NAME)||' '||UPPER(STRG_CUSTOMER.LAST_NAME) AS SC_NAME, " +
				" LOCALITY.DESCR LOC_DESCR,STRG_CUSTOMER.CUST_TYPE, STRG_SERIES.SHORT_ID SHORT_ID , " +
				" STRG_CUSTOMER.ADDR1,STRG_CUSTOMER.ADDR2,STRG_CUSTOMER.ADDR3 " +
				" FROM  SPRS_ACT_TRAN,SALES_PERS, MKT_EVENT_PARTICIPANT,STRG_CUSTOMER,LOCALITY,SPRS_TRAVEL," +
				" STRG_SERIES WHERE  MKT_EVENT_PARTICIPANT.STRG_CODE = STRG_CUSTOMER.SC_CODE" +
				" AND SPRS_ACT_TRAN.SALES_PERS=SALES_PERS .SALES_PERS" +
				" AND SPRS_TRAVEL.LOCALITY_CODE = LOCALITY.LOCALITY_CODE " +
				" AND SPRS_TRAVEL.LOCALITY_CODE = STRG_CUSTOMER.LOCALITY_CODE " +
				" AND MKT_EVENT_PARTICIPANT.STRG_CODE=STRG_SERIES.SC_CODE " +
				" AND MKT_EVENT_PARTICIPANT.DCR_ID = SPRS_ACT_TRAN.DCR_ID " +
				" AND SPRS_TRAVEL.DCR_ID = SPRS_ACT_TRAN.DCR_ID " +
				" AND SPRS_TRAVEL.SPRS_CODE__WW=STRG_SERIES .SALES_PERS "+
				" AND MKT_EVENT_PARTICIPANT.DCR_ID= ? " +
				" AND SPRS_ACT_TRAN.SALES_PERS= ? " +
				" AND MKT_EVENT_PARTICIPANT.STRG_CODE IN " +
				" ( SELECT SC_CODE  FROM STRG_STATUS_HIST " +
				" WHERE STRG_STATUS_HIST .EFF_FROM <= ? " +
				" AND STRG_STATUS_HIST .VALID_UPTO >= ? " +
				" AND STRG_CUSTOMER.CUST_TYPE = 'D' " +
				" AND STRG_STATUS_HIST.SALES_PERS = SPRS_TRAVEL.SPRS_CODE__WW  )" +
				" AND LOCALITY.LOCALITY_CODE IN ("+locality+ ") ORDER BY SHORT_ID ";

				System.out.println("Rows ["+rowsRS+"]");

				if( rowsRS > 0 )
				{

					pstmt =  connectionObject.prepareStatement( sqlEdit );
					pstmt.setString(1, dcrID);
					pstmt.setString(2, userId);
					pstmt.setTimestamp( 3, java.sql.Timestamp.valueOf( trvDBDate ) );
					pstmt.setTimestamp( 4, java.sql.Timestamp.valueOf( trvDBDate ) );
					rs = pstmt.executeQuery();
					while(rs.next())
					{
						srNo++;
						//if ( actType.equalsIgnoreCase(actypeDB) )
						{

							String places = checkNull(rs.getString("LOCALITY_CODE"));
							list = new ArrayList<String>( Arrays.asList( temp ) );
							list.removeAll( Arrays.asList("'"+places+"'" ) );
							temp = list.toArray(new String[0]);
							valueXmlString.append( "<Detail"+currentForm+" domID='"+domID+"' selected = 'Y'>\r\n" );
							valueXmlString.append("<sr_no><![CDATA[" ).append(srNo).append( "]]></sr_no>\r\n");
							valueXmlString.append("<to_disable><![CDATA[Y]]></to_disable>\r\n");
							valueXmlString.append("<short_id><![CDATA[" ).append( checkNull(rs.getString("SHORT_ID"))).append( "]]></short_id>\r\n");
							valueXmlString.append("<strg_code><![CDATA[" ).append( checkNull(rs.getString("STRG_CODE"))).append( "]]></strg_code>\r\n");
							valueXmlString.append("<cust_name><![CDATA[" ).append( checkNull(rs.getString("SC_NAME"))).append( "]]></cust_name>\r\n");
							valueXmlString.append( "<locality_descr><![CDATA[" ).append( checkNull(rs.getString("LOC_DESCR"))).append( "]]></locality_descr>\r\n" );
							System.out.println("@@@@@@@");
							valueXmlString.append( "<remarks><![CDATA[" ).append(checkNull(rs.getString("REMARKS"))).append( "]]></remarks>\r\n" );
							System.out.println("$$$$$$$$$$$");
							valueXmlString.append( "<sales_pers><![CDATA[" ).append(checkNull(userId)).append( "]]></sales_pers>\r\n" );
							valueXmlString.append( "<locality_code><![CDATA[" ).append(places).append( "]]></locality_code>\r\n" );
							//valueXmlString.append( "<meet_summ_mgr><![CDATA[" ).append(checkNull(rs.getString("meet_summ_mgr"))).append( "]]></meet_summ_mgr>\r\n" );
							valueXmlString.append( "<dcr_id><![CDATA[]]></dcr_id>\r\n" );
							valueXmlString.append("<line_no><![CDATA[" ).append(domID).append( "]]></line_no>\r\n");
							valueXmlString.append( "<event_date><![CDATA[" ).append(trvDate).append( "]]></event_date>\r\n" );
							valueXmlString.append( "</Detail"+currentForm+">\r\n" );
							domID++;
						}
						customers = getCustFromDom(genericUtility.parseString("<Root>"+valueXmlString.toString()+"</Root>"),currentForm ,sprsCode , "Y");
					}
					if (rs!= null)
					{
						rs.close();
						rs = null;
					}
					if(pstmt!=null)
					{
						pstmt.close();
						pstmt = null;
					}
				}
			}
			if( pstmtCheckStrgMeet != null )
			{
				pstmtCheckStrgMeet.close(); pstmtCheckStrgMeet = null;
			}
			if( customers != null && customers.length() == 0 )
			{
				customers = "'x'";
			}
			sql = "SELECT TRIM(PROP_VALUE) AS MEET_START_TIME FROM PROPERTIES WHERE PROP_NAME ='MEET_START_TIME'";
			//Commented & Below Changes Done By Shahu Mali on 04-10-13
			//stmt = connectionObject.createStatement();
			//rs = stmt.executeQuery( sql );
			pstmt = connectionObject.prepareStatement(sql);
			rs = pstmt.executeQuery();
			if( rs.next() )
			{
				startTime = checkNull(rs.getString( "MEET_START_TIME" ));
			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			/*if(stmt!=null)
			{
				stmt.close();
				stmt = null;
			}*/
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}

			sql = "SELECT TRIM(PROP_VALUE) AS MEET_INTERVAL FROM PROPERTIES WHERE PROP_NAME ='MEET_INTERVAL'";
			//stmt = connectionObject.createStatement();
			//rs = stmt.executeQuery( sql );
			pstmt = connectionObject.prepareStatement(sql);
			rs = pstmt.executeQuery();
			if( rs.next() )
			{
				interval = checkNull(rs.getString( "MEET_INTERVAL" ));
			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			/*if(stmt!=null)
			{
				stmt.close();
				stmt = null;
			}*/
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}


			sql = "SELECT SS.CUST_TYPE, SS.SHORT_ID MPLNO,SS.SALES_PERS,  "+
			" SC.SC_CODE CODE, UPPER(SC.FIRST_NAME)||' '||UPPER(SC.LAST_NAME) AS SC_NAME,  "+
			" L.DESCR LOC_DESCR, SS.CLASS_CODE CLASS_CODE,  "+
			" SS.NO_VISIT NO_VISIT, SC.LOCALITY_CODE LOCALITY_CODE  "+
			" FROM STRG_SERIES SS, STRG_CUSTOMER SC,  LOCALITY L  "+
			" WHERE SS.SC_CODE = SC.SC_CODE  "+
			" AND SC.LOCALITY_CODE = L.LOCALITY_CODE  "+
			" AND SS.SALES_PERS IN ("+sprsCode+") "+
			" AND SS.SC_CODE IN "+
			" (SELECT SC_CODE FROM STRG_STATUS_HIST WHERE STATUS = 'Y' "+
			" AND EFF_FROM <= ? AND VALID_UPTO >= ? "+
			" AND SALES_PERS = SS.SALES_PERS  "+
			" AND SC_CODE = SC.SC_CODE ) "+
			" AND SC.CUST_TYPE ='D' " +
			" AND SC.LOCALITY_CODE IN ( "+locality+") AND SS.SC_CODE NOT IN ( "+customers+" )  "+
			" ORDER BY SHORT_ID ";

			pstmt =  connectionObject.prepareStatement( sql );
			pstmt.setTimestamp( 1, java.sql.Timestamp.valueOf( trvDBDate ) );
			pstmt.setTimestamp(2, java.sql.Timestamp.valueOf( trvDBDate ) );
			System.out.println("actType =["+actType+"]");

			{
				rs = pstmt.executeQuery();
				while(rs.next())
				{
					srNo++;
					String strgCode = checkNull(rs.getString("CODE"));
					String sprsCodeW = checkNull(rs.getString("SALES_PERS")).trim();

					valueXmlString.append( "<Detail"+currentForm+" domID='"+domID+"' selected = 'N'>\r\n" );
					valueXmlString.append("<sr_no><![CDATA[").append(srNo).append("]]></sr_no>\r\n");
					valueXmlString.append("<short_id><![CDATA[").append(checkNull(rs.getString("MPLNO"))).append("]]></short_id>\r\n");
					valueXmlString.append("<strg_code><![CDATA[").append(strgCode).append("]]></strg_code>\r\n");
					valueXmlString.append("<cust_name><![CDATA[").append(checkNull(rs.getString("SC_NAME"))).append("]]></cust_name>\r\n");

					valueXmlString.append( "<locality_descr><![CDATA[" ).append( checkNull(rs.getString("LOC_DESCR"))).append( "]]></locality_descr>\r\n" );
					valueXmlString.append( "<order_booked><![CDATA[" ).append("0").append( "]]></order_booked>\r\n" );
					valueXmlString.append( "<event_time_start><![CDATA[" ).append( checkNull(startTime)).append( "]]></event_time_start>\r\n" );

					int position=startTime.indexOf(':');
					hour = startTime.substring(0,position).trim();
					minute = startTime.substring( position+1 , startTime.length() ).trim();
					int hr=Integer.parseInt(hour);
					int min=Integer.parseInt(minute);

					int intr =0;
					if( interval.length()>0 )
					{

						intr = Integer.parseInt( interval );
						min = min+intr;
						valueXmlString.append( "<sales_pers><![CDATA[" ).append(checkNull(userId)).append( "]]></sales_pers>\r\n" );
						valueXmlString.append( "<locality_code><![CDATA[" ).append(checkNull(rs.getString("LOCALITY_CODE"))).append( "]]></locality_code>\r\n" );
						valueXmlString.append( "<meet_summ><![CDATA[" ).append("").append( "]]></meet_summ>\r\n" );
						valueXmlString.append( "<remarks><![CDATA[" ).append("").append( "]]></remarks>\r\n" );
						valueXmlString.append( "<sales_pers_sp_name><![CDATA[" ).append("").append( "]]></sales_pers_sp_name>\r\n" );
						valueXmlString.append( "<sprs_code__ww><![CDATA[" ).append(sprsCodeW).append( "]]></sprs_code__ww>\r\n" );
						valueXmlString.append( "<event_type><![CDATA[" ).append(actCode).append( "]]></event_type>\r\n" );
						valueXmlString.append( "<activity_type><![CDATA[" ).append(actType).append( "]]></activity_type>\r\n" );
						valueXmlString.append( "<strg_name><![CDATA[]]></strg_name>\r\n" );
						valueXmlString.append( "<strg_type><![CDATA[" ).append(checkNull(rs.getString("CUST_TYPE"))).append( "]]></strg_type>\r\n" );//Dipak on 13/09/12
						valueXmlString.append( "<strg_no_visit><![CDATA[" ).append(checkNull(rs.getString("NO_VISIT"))).append( "]]></strg_no_visit>\r\n" );
						valueXmlString.append( "<sales_team><![CDATA[" ).append("").append( "]]></sales_team>\r\n" );
						valueXmlString.append( "<last_meet_summ><![CDATA[" ).append("").append( "]]></last_meet_summ>\r\n" );
						valueXmlString.append( "<ref_tran_id><![CDATA[" ).append("").append( "]]></ref_tran_id>\r\n" );
						valueXmlString.append( "<meet_summ_mgr><![CDATA[" ).append("").append( "]]></meet_summ_mgr>\r\n" );
						valueXmlString.append( "<dcr_id><![CDATA[]]></dcr_id>\r\n" );
						valueXmlString.append("<line_no><![CDATA[" ).append(domID).append( "]]></line_no>\r\n");
						valueXmlString.append( "<event_date><![CDATA[" ).append(trvDate).append( "]]></event_date>\r\n" );
					}
					valueXmlString.append( "</Detail"+currentForm+">\r\n" );
					domID++;
				}
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
			}

			domID = 1;
		}
		catch(Exception e)
		{
			System.out.println( "Exception :StrgMeetWizardEJB :getCustomerDetail():" + e.getMessage() + ":" );
			valueXmlString = valueXmlString.append( generateErrorString( genericUtility.createErrorString( e ) ) );
		}
		finally
		{
			try
			{
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				if( connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :StrgMeetWizardEJB :getCustomerDetail :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		return valueXmlString.toString();

	}

	public String getStanCodeFrom( Connection con, String sprsCode, String currDate ) throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String localityCodeFrom = "";
		//changed by Rahul Barve on 3-sep-2014
		//GenericUtility genericUtility = GenericUtility.getInstance();
		 E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

		try
		{
			pstmt =  con.prepareStatement( "SELECT ST.LOCALITY_CODE FROM  SPRS_TRAVEL ST, LOCALITY LOC WHERE TRAN_ID = ( SELECT MAX( TRAN_ID ) FROM SPRS_TRAVEL WHERE SALES_PERS= ? AND TRAVEL_DATE <= ? ) AND LOC.LOCALITY_CODE = ST.LOCALITY_CODE" );
			pstmt.setString(1, sprsCode );
			pstmt.setTimestamp( 2, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( currDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				localityCodeFrom = rs.getString(1);
			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}

		}
		catch ( Exception e )
		{
			System.out.println( "Exception :StrgMeetWizardEJB :defaultDataWiz :==>\n"+e.getMessage());
			throw new ITMException(e);
		}

		return localityCodeFrom;
	}

	//to check if input is null or "null"
	public String checkNull(String input)
	{
		if (input == null || "null".equalsIgnoreCase(input))
		{
			input = "";
		}
		return input.trim();
	}
	//to check if current dom contains values (for previous action)
	public boolean preDomExists(Document dom, String currentFormNo) throws ITMException
	{
		NodeList parentList = null;
		NodeList childList = null;
		Node childNode = null;
		boolean selected = false;

		try
		{
			parentList = dom.getElementsByTagName("Detail" + currentFormNo);
			if ( parentList.item(0) != null )
			{
				childList = parentList.item(0).getChildNodes();
				for (int ctr = 0; ctr < childList.getLength(); ctr++)
				{
					childNode = childList.item(ctr);
					if((childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null))
					{
						System.out.println("Column found!!!>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>" + childNode.getNodeName());
						selected = true;
						break;
					}
				}
			}


		}
		catch ( Exception e )
		{
			System.out.println( "Exception :StrgMeetWizardEJB :preDomExists :==>\n"+e.getMessage());
			throw new ITMException(e);
		}

		return selected;
	}

	//to get previous dom values and set selected attribute to 'y' (for previous action)
	public String getPrevFormValues( Document dom, String currentFormNo, ArrayList temp, String colName) throws ITMException
	{
		//changed by Rahul Barve on 3-sep-2014
		//GenericUtility genericUtility = GenericUtility.getInstance();
		 E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;
		Element elementAttr = null;
		String childNodeName = "";
		String columnValue = "";
		String returnPrevStr = "";
		Document chgPreDom = null;
		try
		{
			chgPreDom = genericUtility.parseString("<Root/>");
			System.out.println("currentFormNo ["+currentFormNo+"]");
			parentList = dom.getElementsByTagName("Detail" + currentFormNo);
			int parentNodeListLength = parentList.getLength();
			System.out.println("parentlistlength["+parentNodeListLength+"]");
			for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
			{
				parentNode = parentList.item(prntCtr);
				childList = parentNode.getChildNodes();
				for (int ctr = 0; ctr < childList.getLength(); ctr++)
				{
					childNode = childList.item(ctr);
					if((childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null))
					{
						columnValue = childNode.getFirstChild().getNodeValue().trim();
						System.out.println("columnValue["+columnValue+"]");
						if ( childNode.getNodeName().equalsIgnoreCase(colName) && temp.contains("'"+columnValue+"'"))
						{
							System.out.println("Inside Temp Contains]");
							elementAttr = (Element)parentNode;
							if ( parentNode.getAttributes().getNamedItem( "domID" ) != null )
							{
								elementAttr.setAttribute( "domID" , Integer.toString(domID) );
								elementAttr.setAttribute( "selected" , "Y" );
								domID++;
							}
							Node importedNode = chgPreDom.importNode( parentNode, true );
							chgPreDom.getDocumentElement().appendChild( importedNode );
							break;
						}

					}
				}

			}
			if(currentFormNo.equals("1"))
			{
				domID = 1;
			}
			returnPrevStr = genericUtility.serializeDom(chgPreDom);
			if(returnPrevStr.indexOf("Detail"+currentFormNo) != -1)
			{
				returnPrevStr = returnPrevStr.substring(returnPrevStr.indexOf(">") + 1, returnPrevStr.lastIndexOf("</"));
			}
			returnPrevStr = returnPrevStr.indexOf("Detail"+currentFormNo) != -1 ? returnPrevStr : "";
		}
		catch ( Exception e )
		{
			System.out.println( "Exception :StrgMeetWizardEJB :getPrevFormValues :==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		return returnPrevStr;

	}

	//get location selected from given dom in a String Buffer
	public String getLocFromDom(Document dom, String currentForm, String sprsCode) throws ITMException
	{
		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;

		Connection connectionObject = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null ;
		StringBuffer localityBuff = new StringBuffer();
		ArrayList temp = new ArrayList(100);
		String sql = "";
		String columnValue = "";
		try
		{
			ConnDriver connDriver = new ConnDriver();
			connectionObject = connDriver.getConnectDB("Driver");

			sql = "SELECT * FROM SPRS_ROUTE WHERE SPRS_CODE IN ("+sprsCode+") AND LOCALITY_CODE = ?";
			//Changed By Vidhya on 16/12/09[WS89NOV642 | to make connection before any loop]
			pstmt = connectionObject.prepareStatement(sql);

			parentList = dom.getElementsByTagName("Detail" + currentForm);
			int parentNodeListLength = parentList.getLength();
			for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
			{
				parentNode = parentList.item(prntCtr);
				childList = parentNode.getChildNodes();

				for (int ctr = 0; ctr < childList.getLength(); ctr++)
				{
					childNode = childList.item(ctr);
					if ( childNode != null && childNode.getFirstChild() != null )
					{
						columnValue = childNode.getFirstChild().getNodeValue().trim();
					}
					System.out.println("column Name =["+childNode.getNodeName()+"] and value =["+columnValue+"]");
					if( childNode.getNodeName().equalsIgnoreCase("locality_code"))
					{

						if ( temp.contains(columnValue))
						{
							continue;
						}

						pstmt.setString(1, columnValue);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							if(localityBuff.length() == 0)
							{
								localityBuff.append("'").append(columnValue.toUpperCase()).append("'");
							}
							else
							{
								localityBuff.append(",'").append(columnValue.toUpperCase()).append("'");
							}
						}
						if (rs!= null)
						{
							rs.close();
							rs = null;
						}
						temp.add(columnValue);
					}
				}
			}

			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
			temp.clear();

		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				if (connectionObject != null)
				{
					connectionObject.close();
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}

		return localityBuff.toString();

	}
	//get customers selected from given dom in a String Buffer
	public String getSprsFromDom(Document dom, String currentForm, String sprsCode) throws ITMException
	{
		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;

		Connection connectionObject = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null ;
		StringBuffer sprsBuff = new StringBuffer();
		ArrayList temp = new ArrayList(100);
		String sql = "";
		String columnValue = "";

		try
		{
			ConnDriver connDriver = new ConnDriver();
			connectionObject = connDriver.getConnectDB("Driver");

			parentList = dom.getElementsByTagName("Detail" + currentForm);
			int parentNodeListLength = parentList.getLength();
			for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
			{
				parentNode = parentList.item(prntCtr);
				childList = parentNode.getChildNodes();

				for (int ctr = 0; ctr < childList.getLength(); ctr++)
				{
					childNode = childList.item(ctr);
					if ( childNode != null && childNode.getFirstChild() != null )
					{
						columnValue = childNode.getFirstChild().getNodeValue().trim();
					}
					System.out.println("Current Node Name ["+childNode.getNodeName()+"]Value["+columnValue);
					if( childNode.getNodeName().equalsIgnoreCase("sprs_code__ww"))
					{

						if ( temp.contains(columnValue))
						{
							continue;
						}

						if(sprsBuff.length() == 0)
						{
							sprsBuff.append("'").append(columnValue.toUpperCase()).append("'");
						}
						else
						{
							sprsBuff.append(",'").append(columnValue.toUpperCase()).append("'");
						}

						temp.add(columnValue);
					}
				}
			}

			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
			temp.clear();

		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				if (connectionObject != null)
				{
					connectionObject.close();
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}

		return sprsBuff.toString();
	}
	public String getCustFromDom( Document dom, String currentForm, String sprsCode ) throws ITMException
	{
		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;

		Connection connectionObject = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null ;
		StringBuffer custBuff = new StringBuffer();
		ArrayList temp = new ArrayList(100);
		String sql = "";
		String columnValue = "";
		try
		{
			ConnDriver connDriver = new ConnDriver();
			connectionObject = connDriver.getConnectDB("Driver");
			parentList = dom.getElementsByTagName("Detail" + currentForm);
			int parentNodeListLength = parentList.getLength();
			sql = "SELECT * FROM STRG_SERIES SS, STRG_CUSTOMER SC WHERE SS.SC_CODE = SC.SC_CODE AND SS.SALES_PERS = ? AND LOCALITY_CODE = ? AND SS.SC_CODE = ?";
			pstmt = connectionObject.prepareStatement(sql);
			for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
			{
				String locality = getSelectedRowValue( dom, currentForm, "locality_code", prntCtr);

				parentNode = parentList.item(prntCtr);
				childList = parentNode.getChildNodes();

				for (int ctr = 0; ctr < childList.getLength(); ctr++)
				{
					childNode = childList.item(ctr);
					if ( childNode != null && childNode.getFirstChild() != null &&  childNode.getNodeName().equalsIgnoreCase("strg_code") )
					{
						columnValue = childNode.getFirstChild().getNodeValue();

						if( temp.contains(columnValue) )
						{
							continue;
						}
						//Changed By Vidhya on 16/12/09[WS89NOV642 | to make connection before any loop]Start
						pstmt.setString(1, sprsCode);
						pstmt.setString(2, locality);
						pstmt.setString(3, columnValue);
						rs = pstmt.executeQuery();
						//Changed By Vidhya on 16/12/09[WS89NOV642 | to make connection before any loop] End
						if( rs.next() )
						{
							if( custBuff.length() == 0)
							{
								custBuff.append("'").append( columnValue ).append("'");
							}
							else
							{
								custBuff.append(",'").append( columnValue ).append("'");
							}
						}
						temp.add( columnValue );

					}
				}
			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
			temp.clear();

		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}

				if (connectionObject != null)
				{
					connectionObject.close();
					connectionObject=null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return custBuff.toString();
	}

	//Vidhya on 23/10/09 overloaded method to get previoulsy customers selected from given dom in a String Buffer
	public String getCustFromDom( Document dom, String currentForm, String sprsCode, String attrValue ) throws ITMException
	{
		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;

		Connection connectionObject = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null ;
		StringBuffer custBuff = new StringBuffer();
		ArrayList temp = new ArrayList(100);
		String sql = "";
		String columnValue = "";
		try
		{
			ConnDriver connDriver = new ConnDriver();
			connectionObject = connDriver.getConnectDB("Driver");
			parentList = dom.getElementsByTagName("Detail" + currentForm);
			int parentNodeListLength = parentList.getLength();

			sql = "SELECT * FROM STRG_SERIES SS, STRG_CUSTOMER SC WHERE SS.SC_CODE = SC.SC_CODE AND SS.SALES_PERS IN ("+sprsCode+") AND SC.LOCALITY_CODE = ? AND SS.SC_CODE = ?";
			pstmt = connectionObject.prepareStatement(sql);

			for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
			{
				String locality = getSelectedRowValue( dom, currentForm, "locality_code", prntCtr);

				parentNode = parentList.item(prntCtr);
				childList = parentNode.getChildNodes();

				for (int ctr = 0; ctr < childList.getLength(); ctr++)
				{
					childNode = childList.item(ctr);
					if ( childNode != null && childNode.getFirstChild() != null &&  childNode.getNodeName().equalsIgnoreCase("strg_code") )
					{
						columnValue = childNode.getFirstChild().getNodeValue();
						if( parentNode.getAttributes().getNamedItem("selected").getNodeValue().equalsIgnoreCase(attrValue))
						{
							if( temp.contains(columnValue) )
							{

								continue;
							}
							pstmt.setString(1, locality);
							pstmt.setString(2, columnValue);
							rs = pstmt.executeQuery();
							if( rs.next() )
							{
								if( custBuff.length() == 0)
								{
									custBuff.append("'").append( columnValue ).append("'");
								}
								else
								{
									custBuff.append(",'").append( columnValue ).append("'");
								}
							}
							if (rs!= null)
							{
								rs.close();
								rs = null;
							}
							temp.add( columnValue );
						}
					}
				}
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
			temp.clear();

		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}

				if (connectionObject != null)
				{
					connectionObject.close();
					connectionObject=null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return custBuff.toString();
	}

	//to get current dom
	public String getCurrentDom(String objContext, Document dom)
	{
		String returnStr = "";
		Document returnDom = null;
		//changed by Rahul Barve on 3-sep-2014
		//GenericUtility genericUtility = GenericUtility.getInstance();
		 E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

		try
		{
			returnDom = genericUtility.parseString("<Root/>");
			NodeList nodeList =  dom.getElementsByTagName("Detail" + objContext);
			for(int i=0; i< nodeList.getLength(); i++)
			{
				Node currentDom = nodeList.item(i);
				if(currentDom != null)
				{
					Node importedNode = returnDom.importNode( currentDom, true);
					returnDom.getDocumentElement().appendChild(importedNode);
				}
			}

			returnStr = genericUtility.serializeDom(returnDom);
			if(returnStr.indexOf("Detail") != -1)
			{
				returnStr = returnStr.substring(returnStr.indexOf(">") + 1, returnStr.lastIndexOf("</"));
			}
			returnStr = returnStr.indexOf("Detail") != -1 ? returnStr : "";

		}
		catch (Exception e){
			e.printStackTrace();
		}
		return returnStr;
	}

	//Changed By Vidhya on  24/10/09[new method to generate errorString]
	public String generateErrorString(String errorString)
	{
		return ("<Error><error id = \"xxxx\" type=\"X\">" + errorString.substring(errorString.indexOf("<message>") , errorString.indexOf("</description>") + "</description>".length()) + "<redirect>1</redirect></error></Errors>");

	}
	//*****Public Methods ***** End

	//****Private Methods ***** Start
	//to validate holiday for saleperson
	//Connection parameter is addded by Gulzar on 18/12/12
	private String valHoliday(String eventdate, String sprs, String userId, ITMDBAccessLocal itmDBAccessLocal, Connection connectionObject) throws Exception
	{
		//changed by Rahul Barve on 3-sep-2014
		//GenericUtility genericUtility = GenericUtility.getInstance();
		 E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();


		String errString = "";
		String columnValue = "";
		String checkSQL = "";
		String childNodeName = "";

		PreparedStatement pstmtPeriod = null;
		ResultSet rsPeriod = null ;

		try
		{
			eventdate = genericUtility.getValidDateString( eventdate , getApplDateFormat() , "dd-MMM-yyyy");
			checkSQL = "SELECT CODE FROM PERIOD WHERE ? BETWEEN FR_DATE AND TO_DATE";
			System.out.println(" sql [" + checkSQL + "]" );
			pstmtPeriod = connectionObject.prepareStatement(checkSQL);
			pstmtPeriod.setString(1,checkNull(eventdate));
			rsPeriod = pstmtPeriod.executeQuery();
			if(rsPeriod.next())
			{
				String code = rsPeriod.getString( "CODE" );

				checkSQL = "SELECT DDF_GET_EMP_HOLIDAY(?,?,?,?) HOLDATE FROM DUAL ";
				System.out.println("sql [" + checkSQL + "] ");

				PreparedStatement pstmt = connectionObject.prepareStatement(checkSQL);
				pstmt.setString(1,checkNull(sprs));
				pstmt.setString(2,checkNull(code));
				pstmt.setString(3,checkNull(code));
				pstmt.setString(4,checkNull(eventdate));
				ResultSet rs = pstmt.executeQuery();
				if(rs.next())
				{
					String holDate = rs.getString( 1 );
					System.out.println(" holDate [" + holDate + "] ");
					if ( holDate != null )
					{
						errString = itmDBAccessLocal.getErrorString("event_date","HOLIDAY",userId);
					}
				}
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}

			}
			if (rsPeriod != null)
			{
				rsPeriod.close();
				rsPeriod = null;
			}
			if(pstmtPeriod !=null)
			{
				pstmtPeriod.close();
				pstmtPeriod = null;
			}

		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if (rsPeriod != null)
				{
					rsPeriod.close();
					rsPeriod = null;
				}
				if(pstmtPeriod !=null)
				{
					pstmtPeriod.close();
					pstmtPeriod = null;
				}

			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return errString;
	}

	//to get value of selected attribute
	private String getDomAttrVal( Document dom,String objContext, int rowNo, String attribute )
	{
		Node elementName = null, parentNode = null;
		NodeList elementList = null;
		Element elementAttr = null;
		String attrVal = "";
		elementList = dom.getElementsByTagName("Detail"+objContext);
		elementName = elementList.item(0);
		if ( elementName!=null && ("Detail"+objContext).equalsIgnoreCase( elementName.getNodeName()) )
		{
			NamedNodeMap etlAttributes = elementName.getAttributes();
			if (etlAttributes!=null)
			{
				if (etlAttributes.getNamedItem("domID")!=null && etlAttributes.getNamedItem("domID").getNodeValue().equalsIgnoreCase(Integer.toString(rowNo)))
				{
					attrVal = etlAttributes.getNamedItem( attribute ).getNodeValue();
				}
			}
		}
		return attrVal;
	}

	public String getSelectedRowValue(Document dom,String formNo, String colName, int rowNo) throws ITMException
	{
		NodeList detailList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;
		Element elementAttr = null;
		String childNodeName = "";
		String columnValue = "";
		int	detailListLength = 0;
		int noOfChilds = 0;

		try
		{
			detailList = dom.getElementsByTagName("Detail"+formNo);
			detailListLength = detailList.getLength();
			//System.out.println("Detail Length ["+detailListLength+"]");
			parentNode = detailList.item(rowNo);


			if ( parentNode != null )
			{
				elementAttr = (Element)parentNode;
				childList = parentNode.getChildNodes();
				noOfChilds = childList.getLength();

				for (int ctr = 0; ctr < noOfChilds; ctr++)
				{
					childNode = childList.item(ctr);
					childNodeName = childNode.getNodeName();
					if(childNodeName.equals(colName) )
					{
						if(childNode.getFirstChild()!=null )
						{
							columnValue = childNode.getFirstChild().getNodeValue();
							break;
						}
					}
				}
			}

			if(columnValue == null)
				columnValue = "";

		}
		catch( Exception exp )
		{
			exp.printStackTrace();
		}

		return columnValue;
	}

	//to get Activity type
	private String getActivityType( String actCode, Connection connectionObject )throws ITMException
	{
		String sql = "";
		String actType = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null ;

		//changed by Rahul Barve on 3-sep-2014
		//GenericUtility genericUtility = GenericUtility.getInstance();
		 E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();


		try
		{
			sql = "SELECT ACTIVITY_TYPE FROM FIELDACTIVITY WHERE ACTIVITY_CODE = ?";
			pstmt = connectionObject.prepareStatement(sql);
			pstmt.setString(1, actCode);
			rs = pstmt.executeQuery();
			if( rs.next() )
			{
				actType = rs.getString("ACTIVITY_TYPE");
				actType = checkNull(actType).toUpperCase();
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}

		return actType;
	}

	//formatted errorstring for Item Detail
	private String getItemErrorString( String errString, String custCode ,String itemDescr, String itemCode, String sprsProdGrp, Connection connectionObject)
	{
		String sql = "";
		String custName = "";
		String msgDescr = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null ;

		try
		{
			sql = "SELECT UPPER(FIRST_NAME)||\' \'||UPPER(LAST_NAME) AS SC_NAME FROM STRG_CUSTOMER WHERE SC_CODE = ?";
			pstmt =  connectionObject.prepareStatement( sql );
			pstmt.setString(1, checkNull(custCode));
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				custName = rs.getString("SC_NAME");
			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(itemCode.length() != 0 && !itemCode.equalsIgnoreCase(""))
			{
				itemDescr = "Promo Material for "+ itemDescr;
			}
			else if( sprsProdGrp.length() != 0 && !sprsProdGrp.equalsIgnoreCase(""))
			{
				itemDescr = "Pitch value for " + itemDescr;
			}

			msgDescr = errString.substring(errString.indexOf("<description>")+("<description>").length(),errString.indexOf("</description>"))+
			"" +itemDescr+ " selected for " + custName;

			errString = errString.substring(0, errString.indexOf("<description>")+("<description>").length()) + msgDescr + "" + errString.substring( errString.indexOf("</description>"), errString.length());
		}

		catch(Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}

			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}

		return errString;

	}

	public HashMap getWorkPlaceList(String SprsCode,String activityCode, String eventDate) throws ITMException
	{
		String sprsCodeWW = "";
		String localityCode = "";
		String sql = "";
		StringBuffer valueXmlString = new StringBuffer("");
		Connection connectionObject = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String eventDate1 = "";//Added By Dipak For db2
		//changed by Rahul Barve on 3-sep-2014
		//GenericUtility genericUtility = GenericUtility.getInstance();
		 E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();


		HashMap teamCustomerMap = new HashMap();

		try
		{
			if ( eventDate != null )
			{
				eventDate1 =  genericUtility.getValidDateTimeString( eventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );//Added By Dipak For DB2
			}

			if(SprsCode.indexOf("'") == -1)
			{
				SprsCode = "'"+SprsCode+"'";
			}

			sql = "SELECT  SALES_PERS,LOCALITY_CODE FROM SPRS_TRAVEL WHERE SALES_PERS IN ("+SprsCode+") AND TRAVEL_DATE=?";

			ConnDriver connDriver = new ConnDriver();
			connectionObject = connDriver.getConnectDB( "DriverValidator" );
			pstmt =  connectionObject.prepareStatement(sql);

			pstmt.setTimestamp(1, java.sql.Timestamp.valueOf( eventDate1) );//Added By Dipak For DB2

			rs = pstmt.executeQuery();

			while(rs.next())
			{
				sprsCodeWW = rs.getString("SALES_PERS");
				localityCode = rs.getString("LOCALITY_CODE");
				sprsCodeWW = sprsCodeWW!=null?sprsCodeWW.trim():sprsCodeWW;
				teamCustomerMap.put(localityCode, sprsCodeWW);
			}


			if(rs != null)
			{
				rs.close();
				rs = null;
			}

			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
			valueXmlString = valueXmlString.append( genericUtility.createErrorString( e ) );
		}
		finally
		{
			try
			{
				if( connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
				}
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}

				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}

			}
			catch(Exception e)
			{
				System.out.println( "Exception : :getWorkPlaceList(String) :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}

		return teamCustomerMap;

	}

	public HashMap getWorkWithSprs(String SprsCode,String activityCode,String eventDate) throws ITMException
	{
		String sprsCodeWW = "";
		String localityCode = "";
		String sql = "";
		StringBuffer valueXmlString = new StringBuffer("");
		Connection connectionObject = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		//changed by Rahul Barve on 3-sep-2014
		//GenericUtility genericUtility = GenericUtility.getInstance();
		 E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

		String eventDate1 = "";//Added By Dipak For db2
		HashMap teamCustomerMap = new HashMap();

		try
		{
			if ( eventDate != null )
			{
				eventDate1 =  genericUtility.getValidDateTimeString( eventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );//Added By Dipak For DB2
			}

			if(SprsCode.indexOf("'") == -1)
			{
				SprsCode = "'"+SprsCode+"'";
			}

			sql = "SELECT  SPRS_CODE__WW,LOCALITY_CODE FROM SPRS_TRAVEL WHERE SALES_PERS IN ("+SprsCode+") AND TRAVEL_DATE=?";

			ConnDriver connDriver = new ConnDriver();
			connectionObject = connDriver.getConnectDB( "DriverValidator" );
			pstmt =  connectionObject.prepareStatement(sql);

			pstmt.setTimestamp(1, java.sql.Timestamp.valueOf( eventDate1) );//Added By Dipak For DB2

			rs = pstmt.executeQuery();

			while(rs.next())
			{
				sprsCodeWW = rs.getString("SPRS_CODE__WW");
				localityCode = rs.getString("LOCALITY_CODE");
				sprsCodeWW = sprsCodeWW!=null?sprsCodeWW.trim():sprsCodeWW;
				teamCustomerMap.put(localityCode, sprsCodeWW);
			}


			if(rs != null)
			{
				rs.close();
				rs = null;
			}

			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}



		}
		catch (Exception e)
		{
			e.printStackTrace();
			valueXmlString = valueXmlString.append( genericUtility.createErrorString( e ) );
		}
		finally
		{
			try
			{
				if( connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
				}
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}

				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}

			}
			catch(Exception e)
			{
				System.out.println( "Exception : :getWorkPlaceList(String) :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}

		return teamCustomerMap;

	}


	//to check if input is a number
	private boolean checkIfNumber(String in)
	{
		try
		{
			Integer.parseInt(in);
		} catch (NumberFormatException ex)
		{
			return false;
		}
		return true;
	}
	//****Private Methods ***** End
	//Utility Functions End****************

}
