

function ganttChart(){
	if(view()!==1){
		return;
	}
	var chart = document.getElementById('gantt-chart');
	const tableView = document.getElementById('tableView');
	const calendarPlan = document.getElementById('calendarView');
	//const controlls = document.getElementById('controlls');
	//controlls.style.display="none";
	chart.style.display="block";
	tableView.style.display="none";
	calendarPlan.style.display="none";
	const charttable = document.getElementById('chart-table');
	
	var row = document.getElementById('chart-head');
	row.innerHTML="";
	var headEmp = row.insertCell();
	headEmp.innerHTML="Employee";
	
	var headReq = row.insertCell();
	headReq.innerHTML="RequestID";
	
	var description = row.insertCell();
	description.className="desc";
	description.innerHTML="Description";
	
	var act = row.insertCell();
	act.className="act";
	act.innerHTML="Action DTL";
	
	var dateFrom = $('#datepicker').val();
	var dateTo = $('#datepickerTo').val();
	
	
	var empCode = getSelectedEmployee();
	var requestid=$('#requestid').val();
	var start = new Date(dateFrom);
	var end = new Date(dateTo);
	const holidayResponse = getHolidayList(dateFrom,dateTo);
	var holidays = holidayResponse.responseJSON;
	for(let day= start;day<=end;day.setDate(day.getDate()+1)){
		var label = document.createElement('label');
		label.setAttribute('id','date-label');
		
		var dateStr=("0" + (day.getDate())).slice(-2) +"-"+day.toLocaleString('default', { month: 'short' }).toUpperCase()+"-"+day.getFullYear();
		label.innerHTML=("0" + (day.getDate())).slice(-2) +"-"+day.toLocaleString('default', { month: 'short' }).toUpperCase();//+"-"+day.getFullYear();
		var dateCell = row.insertCell();
		
		dateCell.appendChild(label);
		var holiday = checkHoliday(dateStr,holidays);
		if(dateStr===holiday){
				console.log("Found Holiday");
				dateCell.setAttribute("class","holiday");
			}
		if(day.getDay()==0 || day.getDay()==6){
			
			dateCell.setAttribute("class","weekend");
		}
	}
	var result = getPlanChartData(dateFrom,dateTo,requestid,empCode);
	writeChart(result,holidays);
	
	
}
function getPlanChartData(dateFrom,dateTo,requestid,empCode) {
		  return $.ajax({
		type:'GET',
		async:false,
		data:{
			empCode: empCode,
			dateFrom: dateFrom,
			dateTo: dateTo,
			requestid: requestid,
			action: "plangantt"
		},
		url:'emp',
		success:function(response){
			//console.log(response)
		},
		error:function(data){
			jQuery('.alert').show();
			jQuery('.alert').html(data.fail);
		}
	});
}
function getHolidayList(startDate,endDate){
	return $.ajax({
		type:'POST',
		async:false,
		data:{
			start:startDate,
			end:endDate,
			action:"holiday"
		},
		url:'emp',
		success:function(){
			
		},
		error:function(data){
			jQuery('.alert').show();
			jQuery('.alert').html(data.fail);
		}
	});
}
function getLeaveList(empcode,startDate,endDate){
	return $.ajax({
		type:'POST',
		async:false,
		data:{
			start:startDate,
			end:endDate,
			empcode:empcode,
			action:"leave"
		},
		url:'emp',
		success:function(){
			
		},
		error:function(data){
			jQuery('.alert').show();
			jQuery('.alert').html(data.fail);
		}
	});
}
function writeChart(result,holidays){
	
	const data = result.responseJSON;
	 
	 
	var table = document.getElementById('chart-table');
	var dateFrom = $('#datepicker').val();
	var dateTo = $('#datepickerTo').val();
	
	 var colCount = $("#chart-head td").length;
	 $("#chart-table").find("tr:gt(0)").remove();
	 
	 for(var i in data){		
		var plan = data[i];
		var rowEmp = table.insertRow();
		rowEmp.innerHTML=""
		//console.log(plan);
		var emp = rowEmp.insertCell(0);
		emp.innerHTML=plan.name;
		var request = rowEmp.insertCell(1);
		request.innerHTML=plan.requestid;
		var desc = rowEmp.insertCell(2);
		desc.innerHTML=plan.description+"("+plan.time+")";;
		desc.className="desc";
		var act = rowEmp.insertCell(3);
		act.innerHTML=plan.actiondtl;
		var date = new Date(dateFrom);
		var str = plan.name.split('(');
		var code = str[1].split(')');
		
		var leaveList = getLeaveList(code[0],dateFrom,dateTo).responseJSON;
		console.log(code[0]+"leave size"+leaveList.length);
		for(var j=4;j<colCount;j++){
			
			var datestr=("0" + (date.getDate())).slice(-2) +"-"+date.toLocaleString('default', { month: 'short' }).toUpperCase()+"-"+date.getFullYear();
			var holiday = checkHoliday(datestr,holidays);
			var leave = checkLeave(datestr,leaveList);
			//console.log(leave);
			var datacell = rowEmp.insertCell(j);
			datacell.setAttribute("id",datestr);
			
			var endDate =new Date( plan.enddate);
			
			var startDate = new Date(plan.date);
			if(plan.date==datestr){	
				datacell.innerHTML="";
				datacell.setAttribute("class","eng");
			}
			else{				
				datacell.innerHTML="";
				if(date>startDate && date<=endDate){
					datacell.setAttribute("class","eng");
				}
			}
			if(datestr===leave){
				console.log(leave);
				datacell.setAttribute("class","leave");
			}else{
				//datacell.setAttribute("class","leave");
			}
			if(datestr===holiday){
				datacell.setAttribute("class","holiday");
			}
			if(date.getDay()==0 || date.getDay()==6){
				datacell.setAttribute("class","weekend");
				//endDate.setDate(endDate.getDate()+1);
			}
			
			
			date.setDate(date.getDate()+1);
		}
		
	}
}
function getEndDate(plan){
	var date = new Date(plan.date);
	var days= Math.ceil(plan.time/9);
	var dateEnd =new Date(date.setDate(date.getDate()+(days))); 
	return dateEnd;
}
function checkLeave(date,leaves){
	var day = new Date(date);
	var dateStart,dateEnd;
	var flag=0;
	for(let i in leaves){
		
		
		dateStart = new Date(leaves[i].startdate.year+" "+leaves[i].startdate.month+" "+leaves[i].startdate.dayOfMonth);
		dateEnd = new Date(leaves[i].enddate.year+" "+leaves[i].enddate.month+" "+leaves[i].enddate.dayOfMonth);
		
		if(day>=dateStart && day<=dateEnd){			
			flag=1;
		}	
	}
	if(flag==1){
		return ("0" + (day.getDate())).slice(-2) +"-"+day.toLocaleString('default', { month: 'short' }).toUpperCase()+"-"+day.getFullYear();		
	}
	else return "";
}
function checkHoliday(date,holidays){
	var day = new Date(date);
	var dateStart,dateEnd;
	var flag=0;
	for(let i in holidays){
		
		
		dateStart = new Date(holidays[i].start.year+" "+holidays[i].start.month+" "+holidays[i].start.dayOfMonth);
		dateEnd = new Date(holidays[i].end.year+" "+holidays[i].end.month+" "+holidays[i].end.dayOfMonth);
		
		if(day>=dateStart && day<=dateEnd){
			//console.log(day);
			
			flag=1;
		}	
	}
	if(flag==1){
		return ("0" + (day.getDate())).slice(-2) +"-"+day.toLocaleString('default', { month: 'short' }).toUpperCase()+"-"+day.getFullYear();		
	}
	else return "";
}