package ibase.webitm.ejb.wsfa.transactions;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;

public class RetailSchemeClaimEJB extends ValidatorEJB  
{
	static int domID1 = 1;
	private E12GenericUtility genericUtility = new E12GenericUtility();

	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams, String formName) throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = null;
		try
		{
			System.out.println("Validation Start..........xmlString"+xmlString);
			System.out.println("Validation Start..........xmlString1"+xmlString1);
			System.out.println("Validation Start..........xmlString2"+xmlString2);
			dom = genericUtility.parseString(xmlString);
			dom1 = genericUtility.parseString(xmlString1);
			if (xmlString2.trim().length() > 0)
			{
				dom2 = genericUtility.parseString(xmlString2);
			}
			errString = wfValData(dom, dom1, dom2, objContext, editFlag, xtraParams,formName);
		} catch (Exception e)
		{
			System.out.println("Exception : RetailSchemeClaimEJB : wfValData(String xmlString) : ==>\n" + e.getMessage());
		}
		return (errString);
	}

	public String wfValData(Document dom, Document dom1, Document dom2, String objContext, String editFlag, String xtraParams, String formName) throws RemoteException, ITMException
	{
		String errString = " ";
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		String columnValue = null;
		String childNodeName = null;
		String tranDate = "",strgCode = "", errorType = "",schemeCode="",stockListCode= "",localityCode ="",routeId = "";
		String invoiceId="",invDate="",invAmt="",imageId="",quantity="";
		String errCode = null;
		String userId = null;
		int cnt = 0;
		int ctr = 0;
		int currentFormNo = 0;
		int childNodeListLength;
		Connection conn = null;
		PreparedStatement pstmt=null;
		ResultSet rs = null;
		String sql = null;
		String classCodeOultretail ="",classCodeSeries= "";
		System.out.println("IN VALIDATION wfValData()");
		ArrayList<String> errList = new ArrayList<String>();
		ArrayList<String> errFields = new ArrayList<String>();
		StringBuffer errStringXml = new StringBuffer("<?xml version = \"1.0\"?> \r\n <Root> <Errors>"); 
		String sqlCust = "", sqlSeries = "", dcrGroup = "", strgType = "";

		try
		{
			conn = getConnection();
			userId = getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			String loginEmpCode = getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode");

			if (objContext != null && objContext.trim().length() > 0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			System.out.println("wfValData called formName  "+formName);
			
			String stockistTable = getSfaParmValue(loginEmpCode,"GET_RETAIL_STOCKIST",conn);


			if (currentFormNo == 1 || "retail".equals(formName))
			{
				System.out.println("VALIDATION FOR DETAIL 1..........456");
				parentNodeList = dom.getElementsByTagName("Detail" + currentFormNo);
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();
				for (ctr = 0; ctr < childNodeListLength; ctr++)
				{
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					if(childNode.getFirstChild()!=null)
					{
						columnValue = childNode.getFirstChild().getNodeValue();
					}
					else
					{
						columnValue = "";
					}

					if (childNodeName.equalsIgnoreCase("tran_date"))
					{
						tranDate = columnValue.trim();
						System.out.println("tran_date>>>>>" + tranDate);

						if (tranDate == null || tranDate.trim().length() == 0 || tranDate.equals(""))
						{
							errCode = "VTRANDATE";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
						}
					}
					else if (childNodeName.equalsIgnoreCase("scheme_code"))
					{
						schemeCode = columnValue.trim();
						System.out.println("scheme_code>>>>>" + schemeCode);
						if(schemeCode == null || schemeCode.length() == 0)
						{
							errCode = "VTSCHMCODE";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
						}
						else if(schemeCode.length() > 0)
						{
							System.out.println("scheme_code>>>>>not null >>>>>>>>" + schemeCode);
							cnt = 0;
							sql = "select count(*) as cnt from RETAIL_SCHEME where SCHEME_CODE=? AND CONFIRMED = 'Y'";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, schemeCode);
							rs = pstmt.executeQuery();
							if (rs.next())
							{
								cnt = rs.getInt("cnt");
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;

							if (cnt == 0)
							{
								errCode = "VSCHCODE";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
						}
					}
					else if (childNodeName.equalsIgnoreCase("route_id"))
					{
						routeId = columnValue.trim();
						System.out.println("routeId>>>>>" + routeId);

						if (routeId == null || routeId.trim().length() == 0 || routeId.equals(""))
						{
							errCode = "VTROUTEID";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
						}
						else if (routeId != null && routeId.trim().length() > 0)
						{
							//String salesPers = checkNull( genericUtility.getColumnValue("sales_pers", dom) );
							String salesPers = checkNull( genericUtility.getColumnValue("sprs_code__ww", dom) );
							System.out.println("routeId != null" + routeId + "dfdsfds" + salesPers);
							cnt = 0;
							sql = "select COUNT(*) as cnt from sprs_route SR, locality l where SR.route_id = ?"
									+ " and SR.sprs_code = ? and SR.locality_code = l.locality_code";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, routeId);
							pstmt.setString(2, salesPers);
							rs = pstmt.executeQuery();
							if (rs.next())
							{
								cnt = rs.getInt("cnt");
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;

							if (cnt == 0)
							{
								errCode = "VTROUIDEX";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
						}
					}
					else if (childNodeName.equalsIgnoreCase("locality_code"))
					{
						localityCode = columnValue.trim();
						System.out.println("localityCode>>>>>" + localityCode);

						if (localityCode == null || localityCode.trim().length() == 0 || localityCode.equals(""))
						{
							errCode = "VTLOCALITY";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
						}
					}
					else if (childNodeName.equalsIgnoreCase("strg_code"))
					{
						strgCode = columnValue.trim();
						System.out.println("strg_code>>>>>" + strgCode);
						if(strgCode == null || strgCode.length() == 0)
						{
							errCode = "VSTRGCODE";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
						}
						else if (strgCode != null && strgCode.trim().length() > 0)
						{
							//System.out.println("strgCode != null" + strgCode);
							
							//String salesPers = checkNull( genericUtility.getColumnValue("sales_pers", dom) );
							String salesPers = checkNull( genericUtility.getColumnValue("sprs_code__ww", dom) );
							routeId = checkNull( genericUtility.getColumnValue("route_id", dom) );
							strgType = checkNull( genericUtility.getColumnValue("strg_type", dom) );
							System.out.println("strgCode != null" + routeId + "dfdsfds" + salesPers);

							cnt = 0;
							
							dcrGroup = getDcrGroup(strgType,conn);
							if (stockistTable.equalsIgnoreCase("SPRS_STOCKIST") && dcrGroup.equalsIgnoreCase("S"))
							{
								sqlCust = "select count(*) as cnt from customer where cust_code = ?";
								
								sqlSeries = "SELECT SS.CUST_CODE,'' AS CLASS_CODE,RS.CLASS_CODE__OUTLET, RS.DESCR FROM SPRS_STOCKIST SS ,RETAIL_SCHEME RS "+  
										    "WHERE SS.SPRS_CODE = ?  AND SS.ROUTE_ID = ?  AND SS.CUST_CODE = ? and RS.SCHEME_CODE = ?";
							}
							else
							{
								sqlCust = "select count(*) as cnt from strg_customer where sc_code = ?";
								
								sqlSeries = "SELECT SS.SC_CODE,SS.CLASS_CODE,RS.CLASS_CODE__OUTLET, RS.DESCR FROM STRG_SERIES SS ,RETAIL_SCHEME RS "
										  + "WHERE SS.SALES_PERS = ?  AND SS.ROUTE_ID = ?  AND SS.SC_CODE = ? and RS.SCHEME_CODE = ?";
							}
							
							//sql = "select count(*) as cnt from strg_customer where sc_code = ?";
							pstmt = conn.prepareStatement(sqlCust);
							pstmt.setString(1, strgCode);
							rs = pstmt.executeQuery();
							if (rs.next())
							{
								cnt = rs.getInt("cnt");
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;

							if (cnt == 0)
							{
								errCode = "VPSTRGCODE";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}

							/*sql = "SELECT SS.SC_CODE,SS.CLASS_CODE,RS.CLASS_CODE__OUTLET, RS.DESCR FROM STRG_SERIES SS ,RETAIL_SCHEME RS "
									+ "WHERE SS.SALES_PERS = ?  AND SS.ROUTE_ID = ?  AND SS.SC_CODE = ? and RS.SCHEME_CODE = ?";*/
							pstmt = conn.prepareStatement(sqlSeries);
							pstmt.setString(1, salesPers );
							pstmt.setString(2, routeId);
							pstmt.setString(3, strgCode);
							pstmt.setString(4, schemeCode);
							rs = pstmt.executeQuery();
							if (rs.next())
							{
								classCodeSeries = rs.getString("class_code");
								classCodeOultretail = rs.getString("class_code__outlet");
							}
							System.out.println("classCodeSeries "+classCodeSeries);
							System.out.println("classCodeOultretail "+classCodeOultretail);

							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;

							//ArrayList aList= new ArrayList<>();
							ArrayList aList= null;
							System.out.println(" -->"+aList);
							if( classCodeOultretail != null && classCodeOultretail.length() > 0)
							{
								if(classCodeOultretail.indexOf(",") != -1)
								{
									System.out.println("strgClasscode ddcfsdfdsfoes not contain");
									//aList.add(Arrays.asList(classCodeOultretail.split(",")));
									aList = new ArrayList<String>( Arrays.asList(classCodeOultretail.split(",")) );
								}
								else
								{
									if(aList == null)
									{
										aList = new ArrayList<>();
										aList.add(classCodeOultretail);
									}
								}
							}
							System.out.println(" -12313131->"+aList);
							if(aList != null)
							{
								if((aList.size() == 0 || !aList.contains(classCodeSeries)) && (classCodeOultretail == null || !classCodeOultretail.equalsIgnoreCase("All") ))
								{
									System.out.println("strgClasscode does not contain");
									errCode = "VTCLASSCD";
									errList.add(errCode);
									errFields.add(childNodeName.toLowerCase());
								}
							}
						}
					}
					else if (childNodeName.equalsIgnoreCase("stockist_code"))
					{
						stockListCode = columnValue.trim();
						System.out.println("stockist_code>>>>>1515" + stockListCode);
						if(stockListCode.length() > 0)
						{
							cnt = 0;
							if (stockistTable.equalsIgnoreCase("SPRS_STOCKIST")) 
							{
								sql = "select count(*) as cnt from customer where cust_code=?";
							}
							else
							{
								sql = "select count(*) as cnt from strg_customer where sc_code=?";
							}
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, stockListCode);
							rs = pstmt.executeQuery();
							if (rs.next())
							{
								cnt = rs.getInt("cnt");
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;

							if (cnt == 0)
							{
								errCode = "VSTJKLIST";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
						}
					}
				}
			}
			if (currentFormNo == 2 || "claim".equals(formName))
			{
				// added by rupali on 12/07/19 for applying validation on duplicate invoice id  [start]
				int invoiceHashSetCnt = 0, invoiceListCnt= 0;
				HashSet invoiceHashSet = new HashSet();
				ArrayList invoiceList = new ArrayList();
				// added by rupali on 12/07/19 for applying validation on duplicate invoice id  [end]
				System.out.println("VALIDATION FOR DETAIL 2..........4565616351"+genericUtility.serializeDom(dom));
				parentNodeList = dom.getElementsByTagName("Detail" + currentFormNo);

				for(int i = 0;i < parentNodeList.getLength();i++)
				{
					parentNode = parentNodeList.item(i);
					childNodeList = parentNode.getChildNodes();
					childNodeListLength = childNodeList.getLength();
					for (ctr = 0; ctr < childNodeListLength; ctr++)
					{
						childNode = childNodeList.item(ctr);
						childNodeName = childNode.getNodeName();
						if(childNode.getFirstChild()!=null)
						{
							columnValue = childNode.getFirstChild().getNodeValue();
						}
						else
						{
							columnValue = "";
						}

						if (childNodeName.equalsIgnoreCase("invoice_id"))
						{
							invoiceId = columnValue.trim();
							System.out.println("invoiceId>>>>>" + invoiceId);
							if(invoiceId == null || invoiceId.equalsIgnoreCase(""))
							{
								errCode = "VTINVOID";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
							// added by rupali on 12/07/19 for applying validation on duplicate invoice id  [start]
							else
							{
								invoiceHashSet.add(columnValue);
								invoiceList.add(columnValue);
								
								schemeCode = checkNull( genericUtility.getColumnValue("scheme_code", dom2));
								tranDate = checkNull( genericUtility.getColumnValue("tran_date", dom2));
								String tranID = checkNull( genericUtility.getColumnValue("tran_id", dom2));
								String stockistCode = checkNull( genericUtility.getColumnValue("stockist_code", dom2));
								localityCode = checkNull( genericUtility.getColumnValue("locality_code", dom2));
								
								if(tranID.trim().length() == 0)
								{
									tranID = "X";
								}
								
								sql = "SELECT COUNT(*) AS COUNT FROM RETAIL_SCH_CLAIM RSC, RETAIL_SCH_CLAIM_DET DET, RETAIL_SCHEME RS WHERE RS.SCHEME_CODE = RSC.SCHEME_CODE "+
									  "AND RSC.TRAN_ID = DET.TRAN_ID AND RSC.SCHEME_CODE = ? AND DET.INVOICE_ID = ? AND ? BETWEEN RS.EFF_FROM AND RS.VALID_UPTO AND RSC.TRAN_ID <> ? "+
								      "AND RSC.STOCKIST_CODE = ? AND RSC.LOCALITY_CODE = ? "; // added by rupali on 23/12/19 for adding condition in validation sql for duplicate scheme
								
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, schemeCode);
								pstmt.setString(2, invoiceId);
								pstmt.setTimestamp(3, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( tranDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() )));
								pstmt.setString(4, tranID);
								pstmt.setString(5, stockistCode);
								pstmt.setString(6, localityCode);
								rs = pstmt.executeQuery();
								if (rs.next())
								{
									cnt = rs.getInt("COUNT");
								}
								rs.close();
								rs = null;
								pstmt.close();
								pstmt = null;

								if (cnt > 0)
								{
									errCode = "INVOICEXST";
									errList.add(errCode);
									errFields.add(childNodeName.toLowerCase());
								}
							}
							// added by rupali on 12/07/19 for applying validation on duplicate invoice id  [end]
						}
						else if (childNodeName.equalsIgnoreCase("inv_date"))
						{
							invDate = columnValue.trim();
							System.out.println("invDate>>>>>" + invDate);
							String effFrom = checkNull(genericUtility.getColumnValue("eff_from", dom2)).trim();
							String validUpto = checkNull(genericUtility.getColumnValue("valid_upto", dom2)).trim();
							if(invDate == null || invDate.equalsIgnoreCase(""))
							{
								errCode = "VTINVDAT";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
							else
							{
								SimpleDateFormat sdf=new SimpleDateFormat(genericUtility.getApplDateFormat());

								Date effFromDate = sdf.parse( effFrom );
								Date validUptoDate = sdf.parse( validUpto );
								Date invoiceDate = sdf.parse( invDate );
								System.out.println("inside val inv date");
								if ( ( invoiceDate.compareTo(effFromDate) ) < 0 || ( validUptoDate.compareTo(invoiceDate) < 0 ) )
								{
									System.out.println("inside val inv date if loop");
									errCode = "INVALINVDT";
									errList.add(errCode);
									errFields.add(childNodeName.toLowerCase());
								}
							}
						}
						else if (childNodeName.equalsIgnoreCase("inv_amt"))
						{
							invAmt = columnValue.trim();
							System.out.println("invAmt>>>>>" + invAmt);
							if(invAmt == null || invAmt.equalsIgnoreCase(""))
							{
								errCode = "VTINVOAMT";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
							else if(Integer.parseInt(invAmt) <= 0 )
							{
								System.out.print("greater than zero ");
								errCode = "VINVAMTL";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
						}
						else if (childNodeName.equalsIgnoreCase("image_id"))
						{
							imageId = columnValue.trim();
							System.out.println("imageId>>>>>" + imageId);
							if(imageId == null || imageId.equalsIgnoreCase(""))
							{
								errCode = "VTIMGID";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
							// Added by Sainath T on 15/11/19 To resolve detail scheme related attachment issue[Start]
							else
							{
								String objName = checkNull( getObjNameFromDom( dom2, "objName", 1 ) );
								System.out.println("objName>" + objName);
								cnt = 0;
								sql = "select COUNT(*) as cnt from DOC_TRANSACTION_LINK where ref_id = ? and DELETE_FLAG is null and TRIM(ref_ser) in ( select REF_SER from TRANSETUP where tran_window = ? )";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, imageId);
								pstmt.setString(2, "w_"+objName);
								rs = pstmt.executeQuery();
								if (rs.next())
								{
									cnt = rs.getInt("cnt");
								}
								rs.close();
								rs = null;
								pstmt.close();
								pstmt = null;

								if (cnt == 0)
								{
									errCode = "VTIMGID";
									errList.add(errCode);
									errFields.add(childNodeName.toLowerCase());
								}	
							}
							// Added by Sainath T on 15/11/19 To resolve detail scheme related attachment issue[Start]
						}
					}
				}
				// added by rupali on 12/07/19 for applying validation on duplicate invoice id  [start]
				if(invoiceHashSet!=null)
				{
					invoiceHashSetCnt = invoiceHashSet.size();
				}
				if(invoiceList!=null)
				{
					invoiceListCnt = invoiceList.size();
				}
				if(invoiceHashSetCnt != invoiceListCnt)
				{
					errCode = "DUPINVOICE";
					errList.add(errCode);
					errFields.add(childNodeName.toLowerCase());
				}
				// added by rupali on 12/07/19 for applying validation on duplicate invoice id  [end]
			}
			if (currentFormNo == 3 || "item".equals(formName))
			{
				parentNodeList = dom.getElementsByTagName("Detail" + currentFormNo);
				for(int i = 0;i < parentNodeList.getLength();i++)
				{
					parentNode = parentNodeList.item(i);
					childNodeList = parentNode.getChildNodes();
					childNodeListLength = childNodeList.getLength();
					for (ctr = 0; ctr < childNodeListLength; ctr++)
					{
						childNode = childNodeList.item(ctr);
						childNodeName = childNode.getNodeName();
						if(childNode.getFirstChild()!=null)
						{
							columnValue = childNode.getFirstChild().getNodeValue();
						}
						else
						{
							columnValue = "";
						}

						if (childNodeName.equalsIgnoreCase("quantity"))
						{
							quantity = columnValue.trim();
							System.out.println("quantity>>>>>" + quantity);
							if(quantity == null || quantity.equalsIgnoreCase(""))
							{
								errCode = "VTQUNATITY";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
							else if(Integer.parseInt(quantity) <= 0 )
							{
								System.out.println("quantity>>>>> less than zero " );
								errCode = "VTQUNATITY";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
						}
					}
				}
			}// END SWITCH	
			int errListSize = errList.size();
			cnt = 0;
			String errFldName = null;
			if ((errList != null) && (errListSize > 0))
			{
				for (cnt = 0; cnt < errListSize; cnt++)
				{
					errCode = (String) errList.get(cnt);
					errFldName = (String) errFields.get(cnt);
					errString = getErrorString(errFldName, errCode, userId);
					errorType = errorType(conn, errCode);
					if (errString.length() > 0)
					{
						String bifurErrString = errString.substring(errString.indexOf("<Errors>") + 8, errString.indexOf("<trace>"));
						bifurErrString = bifurErrString + errString.substring(errString.indexOf("</trace>") + 8, errString.indexOf("</Errors>"));
						errStringXml.append(bifurErrString);
						errString = "";
					}
					if (errorType.equalsIgnoreCase("E"))
					{
						break;
					}
				}
				errStringXml.append("</Errors> </Root> \r\n");
			}
			else
			{
				errStringXml = new StringBuffer("");
			}
		}
		catch (Exception e) {
			e.printStackTrace();
			errString = e.getMessage();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (conn != null)
				{
					conn.close();
					conn = null;
				}
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch (Exception d)
			{
				d.printStackTrace();
				throw new ITMException(d);
			}
		}
		errString = errStringXml.toString();
		return errString;
	}// END OF VALIDATION

	public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams, String formName) throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String valueXmlString = "";

		try
		{
			dom = parseString(xmlString);
			dom1 = parseString(xmlString1);
			if (xmlString2.trim().length() > 0)
			{
				dom2 = parseString(xmlString2);
			}
			valueXmlString = itemChanged(dom, dom1, dom2, objContext, currentColumn, editFlag, xtraParams,formName);
			System.out.println("valueXmlString[" + valueXmlString + "]");
		}
		catch (Exception e)
		{
			System.out.println("Exception : [RetailSchemeClaimEJB][itemChanged( String, String )] :==>\n" + e.getMessage());
			throw new ITMException(e);
		}
		return valueXmlString;
	}

	public String itemChanged(Document dom, Document dom1, Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams ,String formName) throws RemoteException, ITMException
	{
		String returnStr="";
		try{

			returnStr = defaultDataWiz(dom, dom1, dom2, objContext, currentColumn, editFlag, xtraParams,formName);
		}
		catch(Exception e){
			e.printStackTrace();
		}
		return returnStr;
	}

	private String defaultDataWiz( Document dom, Document dom1, Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams,String formName ) throws RemoteException,ITMException
	{
		StringBuffer valueXmlString = new StringBuffer();
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		String childNodeName = null;
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String columnValue = "",schemeCode = "",routeId="",descr = "",strgFirstName="",strgCode = "",stckFirstName = "",stockistCode = "",salesPrs = "";
		String salesPrsName = "",localCodeDescr = "",localCode="";
		int ctr = 0;
		String sql = "";
		int currentFormNo = 0;
		String loginEmpCode= "";
		int aprvlevel=0;
		int childNodeListLength = 0;
		java.util.Date date = new Date();
		java.sql.Date tranDatePrv = null;
		String salesPersPrv="",schemeCodePrv="",strgCodePrvs="",localityCodePrv="",strgCodePrv="",stockistCodePrv="";
		String confirmedPrv ="",wfStatusPrv="", empCodeAprv ="",chgUserPrv ="",chgTrmsPrv="";
		java.sql.Date chgDatePrv = null;
		java.sql.Date confDatePrv  = null;
		java.sql.Date lastClaimDate = null;
		String tranDate ="";
		String confDate= "";
		String routeIdPrv ="",prvTranId="",strgFirstNamePrv="",descrPrv="",stckFirstNamePrv ="",localCodeDescrPrv="";
		String userId= "",hoLoginCode = "",itemSer="";
		String classCodeDescr = "", custTypeDescr = "";
		java.sql.Date payOutDatePrv = null;
		java.sql.Date effFromPrv = null;
		java.sql.Date validUptoPrv = null;
		String payOutDateStr = "", effFrom = "", validUpto = "";
		String strgName = "", stockistName = "";
		String wfRemarks = "";
		String shDescr = "";
		String sprsCodeWW = "";
		String visitedWith = "";
		String salesPersName = "";
		String dcrGroup = "", strgType = "";
		try
		{
			conn = getConnection();
			conn.setAutoCommit(false);
			if ((objContext != null) && (objContext.trim().length() > 0))
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			loginEmpCode = getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode");
			System.out.println( "loginEmpCode = [" + loginEmpCode + "]" );
			
			//Added by Amey W. [To get Division wise HO] on 24-06-2019 START
			userId = genericUtility.getValueFromXTRA_PARAMS( xtraParams,"loginCode" );
			if( loginEmpCode.trim().length() == 0 )
			{
				itemSer = checkNull( getItemSer( userId.trim(), conn ) );
			}
			else
			{
				itemSer = checkNull( getItemSer( loginEmpCode.trim(), conn ) );
			}

			String stockistTable = getSfaParmValue(loginEmpCode,"GET_RETAIL_STOCKIST",conn);
			
			hoLoginCode = getDivisionHO( itemSer.trim(), conn );
			System.out.println("userId: in post save:"+userId+"loginEmpCode: saasd::"+loginEmpCode);
			System.out.println("hoLoginCode hoLoginCode = "+hoLoginCode);
			//Added by Amey W. [To get Division wise HO] on 24-06-2019 END
			//Added by Amey W. [To get approver level] on 24-06-2019 START
			String apprSql = "SELECT COUNT(*) AS COUNT FROM EMPLOYEE E, GRADE G WHERE E.EMP_CODE IN (SELECT EMP_CODE FROM EMPLOYEE WHERE RELIEVE_DATE IS NULL START WITH EMP_CODE = ? CONNECT BY PRIOR REPORT_TO = EMP_CODE) AND G.GRADE_CODE = E.GRADE AND G.LEVEL_NO > 0 AND G.LEVEL_NO <= 4 AND E.RELIEVE_DATE IS NULL AND E.EMP_CODE <> ?";
			pstmt = conn.prepareStatement(apprSql);
			pstmt.setString(1, loginEmpCode);
			pstmt.setString(2, loginEmpCode);
			rs = pstmt.executeQuery();
			if( rs.next() ) 
			{
				aprvlevel = rs.getInt( 1 );
				System.out.println( "Amey  ==> sss aprvlevel = [" + aprvlevel + "]" );
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			//Added by Amey W. [To get approver level] on 24-06-2019 END
			/*if(aprvlevel != 3)
			{
				aprvlevel = aprvlevel + 1;
			}*/
			
			if(aprvlevel == 3)
			{
				aprvlevel = aprvlevel - 1;
			}
			
			String objName = checkNull( getObjNameFromDom( dom2, "objName", currentFormNo ) );
			
			//added by shraddha M for workflow header chanegs start (09-apr-2020)
			String empGrade="";
			String StanCodeHQ="";
			String posCode="";
			String itemserDesc="";
			String gradeDesc="";
			String StanCodeHQdesc="";
			String dataSql="";
		    dataSql = "SELECT EMP.STAN_CODE__HQ, EMP.POS_CODE, GRD.SH_DESCR FROM EMPLOYEE EMP, GRADE GRD WHERE EMP.GRADE=GRD.GRADE_CODE AND EMP.EMP_CODE = ? ";
			pstmt = conn.prepareStatement(dataSql);
			pstmt.setString(1, loginEmpCode);
			rs = pstmt.executeQuery();
			if( rs.next())
			{	
				gradeDesc= checkNull(rs.getString("SH_DESCR"));
				StanCodeHQ= checkNull(rs.getString("STAN_CODE__HQ"));
				posCode= checkNull(rs.getString("POS_CODE"));
			}	
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			
			sql="select descr as itemser_desc from itemser where item_ser in (select item_ser from sales_pers where sales_pers= ?)";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, loginEmpCode);
			rs = pstmt.executeQuery();
			if( rs.next())
			{	
				itemserDesc =  checkNull(rs.getString("itemser_desc"));		
			}	
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			
			sql="SELECT DESCR FROM STATION WHERE STAN_CODE = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, StanCodeHQ);
			rs = pstmt.executeQuery();
			if( rs.next())
			{	
				StanCodeHQdesc =  checkNull(rs.getString("DESCR"));		
			}	
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			//added by shraddha M for workflow header chanegs end (09-apr-2020)
			

			valueXmlString = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<editFlag>");
			valueXmlString.append(editFlag).append("</editFlag>\r\n</Header>\r\n");

			if ("retail".equalsIgnoreCase(formName))
			{
				prvTranId = genericUtility.getColumnValue( "prv_tran_id", dom2 );
				if(prvTranId != null && prvTranId.length() > 0 && prvTranId.indexOf(":") != -1)
				{
					prvTranId = prvTranId.substring(0, prvTranId.length() - 1);
				}

				if (!currentColumn.trim().equalsIgnoreCase("itm_default"))
				{
					parentNodeList = dom.getElementsByTagName("Detail" + currentFormNo);
					parentNode = parentNodeList.item(0);
					childNodeList = parentNode.getChildNodes();
					childNodeListLength = childNodeList.getLength();
					do
					{
						childNode = childNodeList.item(ctr);
						childNodeName = childNode.getNodeName();
						if (childNodeName.equals(currentColumn))
						{
							childNode.getFirstChild();
						}
						if(childNode.getFirstChild()!=null)
						{
							columnValue = childNode.getFirstChild().getNodeValue();
						}
						else
						{
							columnValue = "";
						}
						ctr++;
					} while ((ctr < childNodeListLength) && (!childNodeName.equals(currentColumn)));
				}

				if (currentColumn.trim().equalsIgnoreCase("itm_default") || currentColumn.trim().equalsIgnoreCase("itm_default_add")  )
				{
					// added by rupali on 12/07/19 for displaying field on workflow screen [start]
					String headQuarter = "";
					sql = "SELECT STAN_CODE__HQ, DESCR FROM EMPLOYEE,STATION WHERE STATION.STAN_CODE = EMPLOYEE.STAN_CODE__HQ AND EMP_CODE = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1,loginEmpCode);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						headQuarter = checkNull(rs.getString("DESCR"));
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
					// added by rupali on 12/07/19 for displaying field on workflow screen [end]
					
					String empCodeMGR = getMGREmployee(userId,conn);
					if(prvTranId != null && prvTranId.length() > 0 )
					{
						sql = "SELECT CLAIM.*, RS.LAST_CLAIM_DATE, SP.SH_NAME AS SALES_PERS_NAME, L.DESCR AS LOCALITY_DESCR, RS.DESCR AS RETAIL_DESCR, "
								+ " RS.PAYOUT_DATE, RS.EFF_FROM, RS.VALID_UPTO, RS.SH_DESCR AS SCHEME_SH_DESCR, SP.SP_NAME AS SP_NAME, "
								+ " (CASE WHEN CLAIM.SPRS_CODE__WW IS NULL THEN '' ELSE DDF_GET_EMPLOYEE_NAME(CLAIM.SPRS_CODE__WW) ||' (' || LTRIM(RTRIM(CLAIM.SPRS_CODE__WW)) || ') ' END) AS VISITED_WITH "
								+ " FROM RETAIL_SCH_CLAIM CLAIM "
								+ " LEFT OUTER JOIN SALES_PERS SP ON SP.SALES_PERS = CLAIM.SALES_PERS "
								+ " LEFT OUTER JOIN LOCALITY L ON L.LOCALITY_CODE = CLAIM.LOCALITY_CODE "
								+ " LEFT OUTER JOIN EMPLOYEE EMP ON EMP.EMP_CODE = CLAIM.SPRS_CODE__WW, RETAIL_SCHEME RS "
								+ " WHERE RS.SCHEME_CODE = CLAIM.SCHEME_CODE "
								+ " AND TRAN_ID = ?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1,prvTranId);
						rs = pstmt.executeQuery();
						System.out.println( " sql sss sql[" + sql	 + "]" );
						if(rs.next())
						{
							tranDatePrv = rs.getDate("tran_date");
							salesPersPrv = checkNull(rs.getString("sales_pers")).trim();
							schemeCodePrv = checkNull(rs.getString("scheme_code")).trim();
							descrPrv = checkNull(rs.getString("RETAIL_DESCR")).trim();
							localityCodePrv = checkNull(rs.getString("locality_code")).trim();
							strgCodePrv = checkNull(rs.getString("strg_code")).trim();
							stockistCodePrv = checkNull(rs.getString("stockist_code")).trim();
							confirmedPrv = checkNull(rs.getString("confirmed")).trim();
							confDatePrv = rs.getDate("conf_date");
							wfStatusPrv = checkNull(rs.getString("wf_status")).trim();
							empCodeAprv = checkNull(rs.getString("emp_code__aprv")).trim();
							chgDatePrv = rs.getDate("chg_date");
							chgUserPrv = checkNull(rs.getString("chg_user")).trim();
							chgTrmsPrv = checkNull(rs.getString("chg_term")).trim();
							routeIdPrv = checkNull(rs.getString("route_id")).trim();
							lastClaimDate = rs.getDate( "LAST_CLAIM_DATE" );
							salesPrsName = checkNull(rs.getString("SALES_PERS_NAME"));
							localCodeDescrPrv = checkNull(rs.getString("LOCALITY_DESCR"));
							payOutDatePrv = rs.getDate("PAYOUT_DATE");
							effFromPrv = rs.getDate("EFF_FROM");
							validUptoPrv = rs.getDate("VALID_UPTO");
							wfRemarks = checkNull(rs.getString("WF_REMARKS")).trim();
							shDescr = checkNull(rs.getString("SCHEME_SH_DESCR"));
							sprsCodeWW = checkNull(rs.getString("SPRS_CODE__WW"));
							visitedWith = checkNull(rs.getString("VISITED_WITH"));
							salesPersName = checkNull(rs.getString("SP_NAME"));
							strgType = checkNull(rs.getString("STRG_TYPE"));
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
						
						// added by rupali on 12/07/19 for displaying fields on workfow screen [start]
						/*sql = "SELECT SC.CUST_TYPE, SCT.SH_DESCR AS TYPE_DESCR, SSC.CLASS_CODE, SSC.DESCR AS CLASS_DESCR, SCT.DCR_GROUP AS DCR_GROUP FROM STRG_CUSTOMER SC , STRG_SERIES SS, STRG_CUST_TYPE SCT, STRG_SER_CLASS SSC " + 
							  "WHERE SC.SC_CODE = SS.SC_CODE AND SC.CUST_TYPE = SCT.TYPE AND SSC.CLASS_CODE = SS.CLASS_CODE AND SS.ITEM_SER = SSC.ITEM_SER AND SC.SC_CODE = ? AND SALES_PERS = ?"; */
						
						dcrGroup = getDcrGroup(strgType,conn);
						if (stockistTable.equalsIgnoreCase("SPRS_STOCKIST") && dcrGroup.equalsIgnoreCase("S"))
						{
							strgName = getStockistdescr(conn, strgCodePrv);
							
							sql = "SELECT CUST.CUST_TYPE, SCT.SH_DESCR AS TYPE_DESCR, '' AS CLASS_CODE, '' AS CLASS_DESCR FROM CUSTOMER CUST , SPRS_STOCKIST SS, STRG_CUST_TYPE SCT " + 
								  "WHERE CUST.CUST_CODE = SS.CUST_CODE AND CUST.CUST_TYPE = SCT.TYPE AND CUST.CUST_CODE = ? AND SPRS_CODE = ? ";
						}
						else
						{
							strgName = getStrgdescr(conn, strgCodePrv);
							
							sql = "SELECT SC.CUST_TYPE, SCT.SH_DESCR AS TYPE_DESCR, SSC.CLASS_CODE, SSC.DESCR AS CLASS_DESCR FROM STRG_CUSTOMER SC , STRG_SERIES SS, STRG_CUST_TYPE SCT, STRG_SER_CLASS SSC " + 
								  "WHERE SC.SC_CODE = SS.SC_CODE AND SC.CUST_TYPE = SCT.TYPE AND SSC.CLASS_CODE = SS.CLASS_CODE AND SS.ITEM_SER = SSC.ITEM_SER AND SC.SC_CODE = ? AND SALES_PERS = ?"; 
						}
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, strgCodePrv);
						pstmt.setString(2, sprsCodeWW);
						rs = pstmt.executeQuery();
						if (rs.next())
						{
							custTypeDescr = checkNull(rs.getString("TYPE_DESCR"));
							classCodeDescr = checkNull(rs.getString("CLASS_DESCR"));
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
						// added by rupali on 12/07/19 for displaying fields on workfow screen [end]
						
						System.out.println("wfStatusPrv:::::: " +wfStatusPrv);
						DateFormat dateFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());
						tranDate = dateFormat.format(tranDatePrv);
						String lastClaimDateStr = dateFormat.format(lastClaimDate);
						payOutDateStr = dateFormat.format(payOutDatePrv);
						effFrom = dateFormat.format(effFromPrv);
						validUpto = dateFormat.format(validUptoPrv);
						System.out.println("Current time of the day using Date - 12 hour format: " + tranDate);
						valueXmlString.append("<Detail" + currentFormNo + " domID='1' formName='"+formName+"' selected = 'Y'>\r\n");
						valueXmlString.append("<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\"/>\r\n");
						valueXmlString.append("<tran_id><![CDATA[" + prvTranId  + "]]></tran_id>");
						valueXmlString.append("<tran_date><![CDATA[" + tranDate  + "]]></tran_date>");
						valueXmlString.append("<sales_pers><![CDATA[" + salesPersPrv  + "]]></sales_pers>");
						valueXmlString.append("<scheme_code><![CDATA[" + schemeCodePrv  + "]]></scheme_code>");
						valueXmlString.append("<last_claim_date><![CDATA[" + lastClaimDateStr + "]]></last_claim_date>");
						valueXmlString.append("<route_id><![CDATA[" + routeIdPrv  + "]]></route_id>");
						valueXmlString.append("<locality_code><![CDATA[" + localityCodePrv  + "]]></locality_code>");
						valueXmlString.append("<strg_code><![CDATA[" + strgCodePrv  + "]]></strg_code>");
						valueXmlString.append("<stockist_code><![CDATA[" + stockistCodePrv  + "]]></stockist_code>");
						valueXmlString.append("<sh_name><![CDATA[" + salesPrsName  + "]]></sh_name>");
						valueXmlString.append("<locality_descr><![CDATA[" + localCodeDescrPrv  + "]]></locality_descr>");
						valueXmlString.append("<scheme_descr><![CDATA[" + descrPrv  + "]]></scheme_descr>");
						if(strgCodePrv != null && strgCodePrv.trim().length() > 0 )
						{
							//strgFirstNamePrv= getStrgdescr(conn,strgCodePrv);
							//valueXmlString.append("<strg_customer_first_name><![CDATA[" + strgFirstNamePrv  + "]]></strg_customer_first_name>");
							//strgName = getStrgdescr(conn,strgCodePrv);
							valueXmlString.append("<strg_customer_first_name><![CDATA[" + strgName  + "]]></strg_customer_first_name>");
						}
						if(stockistCodePrv != null && stockistCodePrv.trim().length() > 0)
						{
							//stckFirstNamePrv= getStrgdescr(conn,stockistCodePrv);
							//valueXmlString.append("<stck_customer_first_name><![CDATA[" + stckFirstNamePrv  + "]]></stck_customer_first_name>");
							if (stockistTable.equalsIgnoreCase("SPRS_STOCKIST"))
							{
								stockistName = getStockistdescr(conn,stockistCodePrv);
							}
							else
							{
								stockistName = getStrgdescr(conn,stockistCodePrv);
							}
							valueXmlString.append("<stck_customer_first_name><![CDATA[" + stockistName  + "]]></stck_customer_first_name>");
						}

						/*if((salesPersPrv != null && salesPersPrv.trim().length() > 0) || (schemeCodePrv != null && schemeCodePrv.trim().length() > 0) || (localityCodePrv != null && localityCodePrv.trim().length() > 0 ))
						{
							sql = "SELECT SP.SH_NAME, L.DESCR, RS.DESCR AS RETAILDESCR "
									+ " FROM SALES_PERS SP, LOCALITY L, RETAIL_SCHEME RS "
									+ " WHERE SP.SALES_PERS = ? AND L.LOCALITY_CODE = ? AND RS.SCHEME_CODE = ?";

							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, salesPersPrv);
							pstmt.setString(2, localityCodePrv);
							pstmt.setString(3, schemeCodePrv );
							rs = pstmt.executeQuery();
							if (rs.next())
							{
								salesPrsName = checkNull(rs.getString("SH_NAME"));
								localCodeDescrPrv = checkNull(rs.getString("descr"));
								descrPrv = checkNull(rs.getString("retailDescr"));
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;

							valueXmlString.append("<sh_name><![CDATA[" + salesPrsName  + "]]></sh_name>");
							valueXmlString.append("<locality_descr><![CDATA[" + localCodeDescrPrv  + "]]></locality_descr>");
							valueXmlString.append("<scheme_descr><![CDATA[" + descrPrv  + "]]></scheme_descr>");
						}*/
						if(confDatePrv == null)
						{
							valueXmlString.append("<conf_date><![CDATA[]]></conf_date>");
						}
						else 
						{
							DateFormat dateFormat1 = new SimpleDateFormat(genericUtility.getApplDateFormat());
							confDate = dateFormat1.format(confDatePrv);
							valueXmlString.append("<conf_date><![CDATA["+ confDate +"]]></conf_date>");
						}
						if(confirmedPrv.equalsIgnoreCase("R"))
						{
							valueXmlString.append("<confirmed><![CDATA[N]]></confirmed>");
						}
						else
						{
							valueXmlString.append("<confirmed><![CDATA[" + confirmedPrv  + "]]></confirmed>");
						}
						valueXmlString.append("<wf_status protect = \"0\"><![CDATA[" + wfStatusPrv  + "]]></wf_status>");
						valueXmlString.append("<emp_code_aprv><![CDATA[" + empCodeAprv  + "]]></emp_code_aprv>");
						valueXmlString.append("<chg_date><![CDATA[" + chgDatePrv  + "]]></chg_date>");
						valueXmlString.append("<chg_user><![CDATA[" + chgUserPrv  + "]]></chg_user>");
						valueXmlString.append("<chg_term><![CDATA[" + chgTrmsPrv  + "]]></chg_term>");
						valueXmlString.append("<emp_code__login>").append("<![CDATA[" + loginEmpCode + "]]>").append("</emp_code__login>");
						valueXmlString.append("<aprv_level>").append("<![CDATA[" + aprvlevel + "]]>").append("</aprv_level>");
						valueXmlString.append("<claim_div_ho>").append("<![CDATA[" + hoLoginCode + "]]>").append("</claim_div_ho>");
						valueXmlString.append("<head_quarter>").append("<![CDATA[" + headQuarter + "]]>").append("</head_quarter>");
						valueXmlString.append("<cust_type_descr><![CDATA[" + custTypeDescr  + "]]></cust_type_descr>");
						valueXmlString.append("<class_code_descr><![CDATA[" + classCodeDescr  + "]]></class_code_descr>");
						valueXmlString.append("<payout_date><![CDATA[" + payOutDateStr  + "]]></payout_date>");
						valueXmlString.append("<eff_from><![CDATA[" + effFrom  + "]]></eff_from>");
						valueXmlString.append("<valid_upto><![CDATA[" + validUpto  + "]]></valid_upto>");
						valueXmlString.append("<wf_remarks><![CDATA[" + wfRemarks  + "]]></wf_remarks>");
						valueXmlString.append("<sh_descr><![CDATA[" + shDescr  + "]]></sh_descr>");
						valueXmlString.append("<sprs_code__ww><![CDATA[").append(sprsCodeWW).append("]]></sprs_code__ww>");
						valueXmlString.append("<resign_emp><![CDATA[").append("Y").append("]]></resign_emp>\r\n");
						//added by shraddha M for workflow header chanegs strt (09-apr-2020)
						valueXmlString.append("<pos_code><![CDATA[").append(posCode).append("]]></pos_code>\r\n");
						valueXmlString.append("<itemser_descr><![CDATA[").append(itemserDesc).append("]]></itemser_descr>\r\n");
						valueXmlString.append("<emp_grade_descr><![CDATA[").append(gradeDesc).append("]]></emp_grade_descr>\r\n");
						valueXmlString.append("<emp_stan_code_hq_descr><![CDATA[").append(StanCodeHQdesc).append("]]></emp_stan_code_hq_descr>\r\n");
						//added by shraddha M for workflow header chanegs end ((09-apr-2020)
						
						if(empCodeMGR.trim().length()== 0)
						{
							valueXmlString.append("<visited_with visible = '0'><![CDATA[").append(visitedWith).append("]]></visited_with>\r\n");
						}
						else
						{
							valueXmlString.append("<visited_with visible = '1'><![CDATA[").append(visitedWith).append("]]></visited_with>\r\n");
						}
						valueXmlString.append("<reasons><![CDATA[").append("").append("]]></reasons>\r\n");
						valueXmlString.append("<remarks><![CDATA[").append("").append("]]></remarks>\r\n");
						valueXmlString.append("<sp_name><![CDATA[" + salesPersName  + "]]></sp_name>");
						valueXmlString.append("<strg_type><![CDATA[" + strgType  + "]]></strg_type>");
						
						valueXmlString.append("</Detail" + currentFormNo + ">");

						HashMap<String,String> subFormsMap = getSubForms( objContext, objName, conn );
						if(subFormsMap.containsKey("claim"))
						{
							String claimFormNo = subFormsMap.get("claim");
							if( !"".equalsIgnoreCase( strgCodePrv ) )
							{
								String claimDetail = getExistingClaimDetail( dom, dom2, prvTranId, Integer.parseInt(claimFormNo), strgCodePrv, conn, "claim", currentFormNo );
								if( claimDetail !=null && claimDetail.length() > 0 )
								{
									valueXmlString.append( claimDetail );
								}
							}
						}
						if(subFormsMap.containsKey("item"))
						{
							String itemFormNo = subFormsMap.get("item");
							if( !"".equalsIgnoreCase( strgCodePrv ) )
							{
								// added by rupali on 12/07/19 for getting items from participants item form [start]
								String newScCode = "";
								if( strgCodePrv != null && strgCodePrv.trim().length() > 0 && strgCodePrv.indexOf("'") == -1 )
								{
									newScCode = "'"+strgCodePrv+"'";
								}
								else
								{
									newScCode = strgCodePrv;
								}
								if( newScCode == null || newScCode.trim().length() == 0 )
								{
									newScCode = "''";
								}
								//String existingItem = getItemDetails( dom, dom2, salesPersPrv, tranDate, strgCodePrv, xtraParams, conn, itemFormNo, "item", prvTranId, currentFormNo );
								String existingItem = getExistingItemsDetail( salesPersPrv, tranDate, newScCode, itemFormNo, formName, conn, prvTranId, strgCodePrv );
								existingItem = "<Root>" + existingItem + "</Root>";
								String itemDetails = getRetailSchemeClaimItemList( dom, salesPersPrv, strgCodePrv, existingItem, tranDate, itemFormNo, formName, dom2, prvTranId, conn );
								// added by rupali on 12/07/19 for getting items from participants item form [end]
								if( itemDetails !=null && itemDetails.length() > 0 )
								{
									valueXmlString.append( itemDetails );
								}
							}
							System.out.println( "****itemDetails :" + valueXmlString.toString() + ":********" );
						}
					}
					else
					{
						DateFormat dateFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());
						String formattedDate1 = dateFormat.format(date);
						valueXmlString.append("<Detail" + currentFormNo + " domID='1' formName='"+formName+"' selected = 'Y'>\r\n");
						valueXmlString.append("<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");
						valueXmlString.append("<tran_id></tran_id>");
						valueXmlString.append("<tran_date><![CDATA[" + formattedDate1  + "]]></tran_date>");
						valueXmlString.append("<sales_pers><![CDATA[" + loginEmpCode  + "]]></sales_pers>");

						sql = "select SH_NAME,SP_NAME from sales_pers where sales_pers =?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, loginEmpCode);
						rs = pstmt.executeQuery();
						if (rs.next())
						{
							salesPrsName = checkNull(rs.getString("SH_NAME"));
							salesPersName = checkNull(rs.getString("SP_NAME"));
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;

						valueXmlString.append("<sh_name><![CDATA[" + salesPrsName  + "]]></sh_name>");
						valueXmlString.append("<confirmed ><![CDATA[N]]></confirmed>" );
						valueXmlString.append("<wf_status protect = \"0\"><![CDATA[D]]></wf_status>");
						valueXmlString.append("<emp_code__login>").append("<![CDATA[" + loginEmpCode + "]]>").append("</emp_code__login>");
						valueXmlString.append("<aprv_level>").append("<![CDATA[" + aprvlevel + "]]>").append("</aprv_level>");
						valueXmlString.append("<claim_div_ho>").append("<![CDATA[" + hoLoginCode + "]]>").append("</claim_div_ho>");
						valueXmlString.append("<head_quarter>").append("<![CDATA[" + headQuarter + "]]>").append("</head_quarter>");
						valueXmlString.append("<sprs_code__ww><![CDATA[").append(loginEmpCode).append("]]></sprs_code__ww>\r\n");
						valueXmlString.append("<resign_emp><![CDATA[").append(checkNull("Y")).append("]]></resign_emp>\r\n");
						//added by shraddha M for workflow header chanegs strt ()
						valueXmlString.append("<pos_code><![CDATA[").append(posCode).append("]]></pos_code>\r\n");
						valueXmlString.append("<itemser_descr><![CDATA[").append(itemserDesc).append("]]></itemser_descr>\r\n");
						valueXmlString.append("<emp_grade_descr><![CDATA[").append(gradeDesc).append("]]></emp_grade_descr>\r\n");
						valueXmlString.append("<emp_stan_code_hq_descr><![CDATA[").append(StanCodeHQdesc).append("]]></emp_stan_code_hq_descr>\r\n");
						//added by shraddha M for workflow header chanegs end ()
						
						if(empCodeMGR.trim().length()== 0)
						{
							valueXmlString.append("<visited_with visible = '0'><![CDATA[").append("").append("]]></visited_with>\r\n");
						}
						else
						{
							valueXmlString.append("<visited_with visible = '1'><![CDATA[").append("").append("]]></visited_with>\r\n");
						}
						valueXmlString.append("<reasons><![CDATA[").append("").append("]]></reasons>\r\n");
						valueXmlString.append("<remarks><![CDATA[").append("").append("]]></remarks>\r\n");
						valueXmlString.append("<sp_name><![CDATA[" + salesPersName  + "]]></sp_name>");
						
						valueXmlString.append("</Detail" + currentFormNo + ">");
					}
					
					
					
					
				}
				else if (currentColumn.trim().equalsIgnoreCase("scheme_code"))
				{
					schemeCode = columnValue.trim();
					String lastClaimDateStr = "";
					// changes made by rupali on 12/07/19 for displaying fields on workfow screen 
					//sql = "select descr, last_claim_date from retail_scheme where scheme_code =?";
					sql = "SELECT DESCR, LAST_CLAIM_DATE, PAYOUT_DATE, EFF_FROM, VALID_UPTO, SH_DESCR FROM RETAIL_SCHEME WHERE SCHEME_CODE = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, schemeCode);
					rs = pstmt.executeQuery();
					if (rs.next())
					{
						descr = checkNull(rs.getString("descr"));
						lastClaimDateStr = checkNull(rs.getString("last_claim_date"));
						// added by rupali on 12/07/19 for displaying fields on workfow screen [start]
						payOutDateStr = checkNull(rs.getString("payout_date"));
						effFrom = checkNull(rs.getString("eff_from"));
						validUpto = checkNull(rs.getString("valid_upto"));
						// added by rupali on 12/07/19 for displaying fields on workfow screen [end]
						shDescr = checkNull(rs.getString("sh_descr"));
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;

					valueXmlString.append("<Detail" + currentFormNo + " domID='1' formName='"+formName+"' selected = 'Y'>\r\n");
					valueXmlString.append("<scheme_descr><![CDATA[" + descr  + "]]></scheme_descr>");
					if ( lastClaimDateStr != null && lastClaimDateStr.length() > 0 )
					{
						String applDateLastClaimDate = genericUtility.getValidDateString( lastClaimDateStr, genericUtility.getDBDateTimeFormat(), genericUtility.getApplDateFormat() );
						valueXmlString.append("<last_claim_date><![CDATA[" + applDateLastClaimDate  + "]]></last_claim_date>");
					}
					// added by rupali on 12/07/19 for displaying fields on workfow screen [start]
					if ( payOutDateStr != null && payOutDateStr.length() > 0 )
					{
						String payOutDate = genericUtility.getValidDateString( payOutDateStr, genericUtility.getDBDateTimeFormat(), genericUtility.getApplDateFormat() );
						valueXmlString.append("<payout_date><![CDATA[" + payOutDate  + "]]></payout_date>");
					}
					if ( effFrom != null && effFrom.length() > 0 )
					{
						String effFromDate = genericUtility.getValidDateString( effFrom, genericUtility.getDBDateTimeFormat(), genericUtility.getApplDateFormat() );
						valueXmlString.append("<eff_from><![CDATA[" + effFromDate  + "]]></eff_from>");
					}
					if ( validUpto != null && validUpto.length() > 0 )
					{
						String validUptoDate = genericUtility.getValidDateString( validUpto, genericUtility.getDBDateTimeFormat(), genericUtility.getApplDateFormat() );
						valueXmlString.append("<valid_upto><![CDATA[" + validUptoDate  + "]]></valid_upto>");
					}
					// added by rupali on 12/07/19 for displaying fields on workfow screen [end]
					valueXmlString.append("<sh_descr><![CDATA[" + shDescr  + "]]></sh_descr>");
					valueXmlString.append("</Detail" + currentFormNo + ">");
				}
				else if (currentColumn.trim().equalsIgnoreCase("stockist_code"))
				{
					stockistCode = columnValue.trim();
					//stckFirstName =getStrgdescr(conn, stockistCode);
					if (stockistTable.equalsIgnoreCase("SPRS_STOCKIST"))
					{
						stockistName = getStockistdescr(conn, stockistCode);
					}
					else
					{
						stockistName = getStrgdescr(conn, stockistCode);
					}
					valueXmlString.append("<Detail" + currentFormNo + " domID='1' formName='"+formName+"' selected = 'Y'>\r\n");
					//valueXmlString.append("<stck_customer_first_name><![CDATA[" + stckFirstName  + "]]></stck_customer_first_name>");
					valueXmlString.append("<stck_customer_first_name><![CDATA[" + stockistName  + "]]></stck_customer_first_name>");
					valueXmlString.append("</Detail" + currentFormNo + ">");
				}
				else if (currentColumn.trim().equalsIgnoreCase("route_id"))
				{
					routeId = columnValue.trim();
					System.out.println("in the ItemDefault col itemchange route_id value "+routeId);

					sql = "select (CASE WHEN SR.ROUTE_DESCR IS NOT NULL THEN SR.ROUTE_DESCR ELSE SR.DESCR END) AS DESCR,"
							+ "SR.locality_code as locality_code from sprs_route SR, locality l where route_id = ? and sprs_code = ? and SR.locality_code = l.locality_code";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, routeId);
					//pstmt.setString(2, genericUtility.getColumnValue("sales_pers", dom));
					pstmt.setString(2, genericUtility.getColumnValue("sprs_code__ww", dom));
					rs = pstmt.executeQuery();
					if (rs.next())
					{
						localCodeDescr = checkNull(rs.getString("DESCR"));
						localCode = checkNull(rs.getString("locality_code"));
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
					
					stockistCode = checkNull( genericUtility.getColumnValue("stockist_code", dom) );
					if (stockistTable.equalsIgnoreCase("SPRS_STOCKIST"))
					{
						stockistName = getStockistdescr(conn, stockistCode);
					}
					else
					{
						stockistName = getStrgdescr(conn, stockistCode);
					}

					valueXmlString.append("<Detail" + currentFormNo + " domID='1' formName='"+formName+"' selected = 'Y'>\r\n");
					valueXmlString.append("<locality_descr><![CDATA[" + localCodeDescr  + "]]></locality_descr>");
					valueXmlString.append("<locality_code><![CDATA[" + localCode  + "]]></locality_code>");
					valueXmlString.append("<stck_customer_first_name><![CDATA[" + stockistName  + "]]></stck_customer_first_name>");
					valueXmlString.append("</Detail" + currentFormNo + ">");
				}
				else if (currentColumn.trim().equalsIgnoreCase("strg_code"))
				{
					strgCode = columnValue.trim();
					strgType = checkNull(genericUtility.getColumnValue( "strg_type" , dom2,"1" ));
					sprsCodeWW = checkNull(genericUtility.getColumnValue( "sprs_code__ww" , dom2,"1" ));
					System.out.println("strgType:::"+strgType);
					//strgFirstName = getStrgdescr(conn, strgCode);
					// added by rupali on 12/07/19 for displaying fields on workfow screen [start]
					/*sql = "SELECT SC.CUST_TYPE, SCT.SH_DESCR AS TYPE_DESCR, SSC.CLASS_CODE, SSC.DESCR AS CLASS_DESCR, SCT.DCR_GROUP FROM STRG_CUSTOMER SC , STRG_SERIES SS, STRG_CUST_TYPE SCT, STRG_SER_CLASS SSC " + 
						  "WHERE SC.SC_CODE = SS.SC_CODE AND SC.CUST_TYPE = SCT.TYPE AND SSC.CLASS_CODE = SS.CLASS_CODE AND SS.ITEM_SER = SSC.ITEM_SER AND SC.SC_CODE = ?"; */
					dcrGroup = getDcrGroup(strgType,conn);
					if (stockistTable.equalsIgnoreCase("SPRS_STOCKIST") && dcrGroup.equalsIgnoreCase("S"))
					{
						strgName = getStockistdescr(conn, strgCode);
						
						sql = "SELECT CUST.CUST_TYPE, SCT.SH_DESCR AS TYPE_DESCR, '' AS CLASS_CODE, '' AS CLASS_DESCR FROM CUSTOMER CUST , SPRS_STOCKIST SS, STRG_CUST_TYPE SCT " + 
							  "WHERE CUST.CUST_CODE = SS.CUST_CODE AND CUST.CUST_TYPE = SCT.TYPE AND CUST.CUST_CODE = ? AND SPRS_CODE = ? ";
					}
					else
					{
						strgName = getStrgdescr(conn, strgCode);
						
						sql = "SELECT SC.CUST_TYPE, SCT.SH_DESCR AS TYPE_DESCR, SSC.CLASS_CODE, SSC.DESCR AS CLASS_DESCR FROM STRG_CUSTOMER SC , STRG_SERIES SS, STRG_CUST_TYPE SCT, STRG_SER_CLASS SSC " + 
							  "WHERE SC.SC_CODE = SS.SC_CODE AND SC.CUST_TYPE = SCT.TYPE AND SSC.CLASS_CODE = SS.CLASS_CODE AND SS.ITEM_SER = SSC.ITEM_SER AND SC.SC_CODE = ? AND SALES_PERS = ?";
					}
					
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, strgCode);
					pstmt.setString(2, sprsCodeWW);
					rs = pstmt.executeQuery();
					if (rs.next())
					{
						custTypeDescr = checkNull(rs.getString("TYPE_DESCR"));
						classCodeDescr = checkNull(rs.getString("CLASS_DESCR"));
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
					
				
					//strgName = getStrgdescr(conn, strgCode);
					// added by rupali on 12/07/19 for displaying fields on workfow screen [end]
					valueXmlString.append("<Detail" + currentFormNo + " domID='1' formName='"+formName+"' selected = 'Y'>\r\n");
					//valueXmlString.append("<strg_customer_first_name><![CDATA[" + strgFirstName  + "]]></strg_customer_first_name>");
					valueXmlString.append("<strg_customer_first_name><![CDATA[" + strgName  + "]]></strg_customer_first_name>");
					// added by rupali on 12/07/19 for displaying fields on workfow screen [start]
					valueXmlString.append("<cust_type_descr><![CDATA[" + custTypeDescr  + "]]></cust_type_descr>");
					valueXmlString.append("<class_code_descr><![CDATA[" + classCodeDescr  + "]]></class_code_descr>");
					// added by rupali on 12/07/19 for displaying fields on workfow screen [end]
					valueXmlString.append("</Detail" + currentFormNo + ">");
				}
				else if( currentColumn.equalsIgnoreCase("visited_with"))
				{
					String selTeam = "";
					visitedWith = checkNull(genericUtility.getColumnValue( "visited_with" , dom2,"1" ));
					System.out.println("before if::::::::"+visitedWith);
					valueXmlString.append("<Detail" + currentFormNo + " domID='1' formName='"+formName+"' selected = 'Y'>\r\n");

					if(visitedWith.trim().length() > 0)
					{
						if(visitedWith.indexOf("(") != -1 && visitedWith.indexOf(")") != -1)
						{
							selTeam = checkNull(visitedWith.substring(visitedWith.indexOf("(")+1, visitedWith.indexOf(")")));
							valueXmlString.append("<sprs_code__ww protect = '0'><![CDATA[" ).append(checkNull(selTeam)).append( "]]></sprs_code__ww>\r\n" );
						}
						else if("SELF".equalsIgnoreCase(visitedWith))
						{
							valueXmlString.append("<sprs_code__ww protect = '0'><![CDATA[" ).append(checkNull(loginEmpCode)).append( "]]></sprs_code__ww>\r\n" );

						}
						else
						{
							valueXmlString.append("<sprs_code__ww protect = '0'><![CDATA[" ).append("").append( "]]></sprs_code__ww>\r\n" );

						}
					}
					valueXmlString.append("</Detail" + currentFormNo + ">");
				}
			}
			else if ("claim".equalsIgnoreCase(formName))
			{
				prvTranId =  checkNull(genericUtility.getColumnValue( "tran_id", dom1 ));

				strgCodePrvs =  checkNull(genericUtility.getColumnValue( "strg_code", dom1 ));
				System.out.println(" claim CURRENT strgCodePrvs [" + strgCodePrvs + "]");

				if (!currentColumn.trim().equalsIgnoreCase("itm_default"))
				{
					parentNodeList = dom.getElementsByTagName("Detail" + currentFormNo);
					parentNode = parentNodeList.item(0);
					childNodeList = parentNode.getChildNodes();

					childNodeListLength = childNodeList.getLength();
					do
					{
						childNode = childNodeList.item(ctr);
						childNodeName = childNode.getNodeName();
						if (childNodeName.equals(currentColumn))
						{
							childNode.getFirstChild();
						}
						if(childNode.getFirstChild()!=null)
						{
							columnValue = childNode.getFirstChild().getNodeValue();
						}
						else
						{
							columnValue = "";
						}
						ctr++;
					} while ((ctr < childNodeListLength) && (!childNodeName.equals(currentColumn)));
				}
				if (currentColumn.trim().equalsIgnoreCase("itm_default") || currentColumn.trim().equalsIgnoreCase("itm_default_add"))
				{
					if( ( prvTranId == null || prvTranId == "" ) || ( prvTranId != null && currentColumn.trim().equalsIgnoreCase( "itm_default_add" )) )
					{
						int maxDomId= 0;

						ArrayList domIdList = getMaxDomIdListFromDom( dom2, "domID" , currentFormNo);
						int maxVal = (int) Collections.max(domIdList);
						maxDomId = maxVal;
						valueXmlString.append("<Detail" + currentFormNo + " domID='"+maxDomId+"' formName='"+formName+"' selected = 'Y'>\r\n");
						valueXmlString.append("<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");
						valueXmlString.append("<selectbox><![CDATA[").append( "true" ).append("]]></selectbox>\r\n");
						valueXmlString.append("<tran_id></tran_id>\r\n");
						valueXmlString.append("<line_no><![CDATA["+ maxDomId +"]]></line_no>\r\n");
						valueXmlString.append("<invoice_id></invoice_id>\r\n");
						valueXmlString.append("<inv_date></inv_date>\r\n");
						valueXmlString.append("<inv_amt></inv_amt>\r\n");
						valueXmlString.append("<aprv_amt><![CDATA[0]]></aprv_amt>\r\n");
						valueXmlString.append("<image_id></image_id>\r\n");
						valueXmlString.append("<strg_code><![CDATA[" +  strgCodePrvs + "]]></strg_code>");
						valueXmlString.append("</Detail" + currentFormNo + ">");
					}
					else
					{
						String claimDetail = getExistingClaimDetail( dom, dom2, prvTranId, currentFormNo, strgCodePrvs, conn, formName, currentFormNo ) ;
						if( claimDetail !=null && claimDetail.length() > 0 )
						{
							valueXmlString.append( claimDetail );
						}
					}
				}
			}
			else if (currentFormNo == 3 || "item".equals(formName))
			{
				prvTranId = checkNull(genericUtility.getColumnValue( "tran_id", dom1 ));

				if (!currentColumn.trim().equalsIgnoreCase("itm_default"))
				{
					parentNodeList = dom.getElementsByTagName("Detail" + currentFormNo);
					parentNode = parentNodeList.item(0);
					childNodeList = parentNode.getChildNodes();

					childNodeListLength = childNodeList.getLength();
					do
					{
						childNode = childNodeList.item(ctr);
						childNodeName = childNode.getNodeName();
						if (childNodeName.equals(currentColumn))
						{
							childNode.getFirstChild();
						}
						if(childNode.getFirstChild()!=null)
						{
							columnValue = childNode.getFirstChild().getNodeValue();
						}
						else
						{
							columnValue = "";
						}
						ctr++;
					} while ((ctr < childNodeListLength) && (!childNodeName.equals(currentColumn)));
				}

				if (currentColumn.trim().equalsIgnoreCase("itm_default") || currentColumn.trim().equalsIgnoreCase("itm_default_add"))
				{
					String salePersCode = getSelectedRowValue(dom2, "1", "sales_pers", 0);
					String wrkDate = getSelectedRowValue(dom2, "1", "tran_date", 0);
					String scCode = getSelectedRowValue(dom2, "1", "strg_code", 0);
					valueXmlString.append( getItemDetails( dom, dom2, salePersCode, wrkDate, scCode, xtraParams, conn, objContext, formName, prvTranId, currentFormNo ) );
				}
			}
			valueXmlString.append("</Root>");
		}
		catch (Exception e)
		{
			e.printStackTrace();
			System.out.println("Exception ::" + e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (conn != null)
				{
					if (pstmt != null)
						pstmt.close();
					if (rs != null)
						rs.close();
					rs = null;
					pstmt = null;
					conn.close();
					conn = null;
				}
			}
			catch (Exception d)
			{
				d.printStackTrace();
				throw new ITMException(d);
			}
		}
		System.out.println( "\n****ValueXmlString :::::::::::" + valueXmlString.toString() + ":********" );
		return valueXmlString.toString();
	}

	private String errorType(Connection conn, String errorCode) throws ITMException
	{
		String msgType = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try
		{
			String sql = "SELECT MSG_TYPE FROM MESSAGES WHERE MSG_NO = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, errorCode);
			rs = pstmt.executeQuery();
			while (rs.next())
			{
				msgType = rs.getString("MSG_TYPE");
			}
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
			try {
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			} catch (Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			} catch (Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return msgType;
	}

	private String checkNull(String str)
	{
		if (str == null)
		{
			return "";
		}
		else
		{
			return str;
		}
	}

	private String getItemDetails( Document dom, Document dom2, String salePersCode, String tranDate, String scCode, String xtraParams, Connection conn, String formNo, String formName, String tranIdPrv, int currentFormNo ) throws ITMException
	{
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		StringBuffer valueXmlString = new StringBuffer();
		String selectedItem = "";
		boolean isLocalConn = false;
		try
		{
			if( conn == null )
			{
				conn = getConnection();
				isLocalConn =true;
			}
			if( "".equalsIgnoreCase( checkNull( salePersCode ) ) )
			{
				salePersCode = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginEmpCode" );
			}
			String[] temp = scCode.split(",");
			if ( preDomExists( dom2, formNo ))
			{
				selectedItem = getPrevFormValues( dom2, formNo, new ArrayList<String>(Arrays.asList(temp)), "strg_code" ) ;
			}
			else
			{
				String newScCode = "";
				if( scCode != null && scCode.trim().length() > 0 && scCode.indexOf("'") == -1 )
				{
					newScCode = "'"+scCode+"'";
				}
				else
				{
					newScCode = scCode;
				}
				if( newScCode == null || newScCode.trim().length() == 0 )
				{
					newScCode = "''";
				}
				selectedItem = getExistingItemsDetail( salePersCode, tranDate, newScCode, formNo, formName, conn, tranIdPrv, scCode );
			}
			String itemDetails = selectedItem;
			int formNum = Integer.parseInt( formNo );
			//if ( formNum == currentFormNo )
			{
				selectedItem = "<Root>" + selectedItem + "</Root>";
				// changes made by rupali on 12/07/19 for getting item from participants item form ]
				//itemDetails = getSalesPersItemList( dom, salePersCode, scCode, selectedItem, tranDate, formNo, formName, dom2, tranIdPrv, conn );
				itemDetails = getRetailSchemeClaimItemList( dom, salePersCode, scCode, selectedItem, tranDate, formNo, formName, dom2, tranIdPrv, conn );
			}
			valueXmlString.append(itemDetails);
		}
		catch(Exception e)
		{
			System.out.println( "Exception :StrgMeetITMMobileWizEJB:getItemDetails( Document dom2 , String salePersCode, String wrkDate , String scCode, String xtraParams):" + e.getMessage() + ":" );
			e.printStackTrace();
			throw new ITMException(e); 
		}
		finally
		{
			try
			{
				if (rs !=null )
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if (isLocalConn && conn != null)
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :RetailSchemeClaimEJB:defaultDataDAR :==>\n"+e.getMessage());
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return valueXmlString.toString();
	}

	private String getExistingItemsDetail( String salePersCode, String eventDate, String custList, String formNo, String formName, Connection conn, String tranIdPrv, String scCode) throws ITMException //Chnaged by sachin satre on 09-nov-16
	{
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		StringBuffer valueXmlString = new StringBuffer();
		boolean isLocalConn =false;
		try
		{
			int domID = 1;
			if( conn == null )
			{
				conn = getConnection();
				isLocalConn =true;
			}
			String itemDetailSql = "SELECT SMO.TRAN_ID,SMO.LINE_NO,SMO.ITEM_CODE,SMO.QUANTITY,SMO.REMARKS,ITEM.DESCR AS ITEMDESCR FROM RETAIL_CLAIM_ITEM SMO, ITEM ITEM"
					+" WHERE SMO.ITEM_CODE = ITEM.ITEM_CODE "
					+" AND SMO.TRAN_ID =  ? ";
			pstmt = conn.prepareStatement( itemDetailSql );
			pstmt.setString( 1, tranIdPrv );
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				valueXmlString.append("<Detail"+formNo+" domID='" + domID + "' selected = 'Y' formName='"+formName+"'>\r\n" );
				valueXmlString.append("<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\"/>\r\n");//Gaurav Singh on 03/06/15
				valueXmlString.append("<selectbox><![CDATA[").append( "true" ).append("]]></selectbox>\n");
				valueXmlString.append("<tran_id><![CDATA[").append( checkNull(rs.getString("TRAN_ID")) ).append("]]></tran_id>\r\n");
				valueXmlString.append("<line_no><![CDATA[").append( rs.getInt("LINE_NO") ).append("]]></line_no>\r\n");
				valueXmlString.append("<item_code><![CDATA[").append(checkNull(rs.getString("ITEM_CODE"))).append("]]></item_code>\n");
				valueXmlString.append("<item_descr><![CDATA[").append( checkNull(rs.getString("ITEMDESCR")) ).append("]]></item_descr>\n");
				valueXmlString.append("<quantity><![CDATA[").append(rs.getInt("QUANTITY")).append("]]></quantity>\n");//Gulzar
				valueXmlString.append("<strg_code><![CDATA[").append( scCode ).append("]]></strg_code>");
				valueXmlString.append("<remarks><![CDATA[").append( rs.getString("REMARKS") ).append("]]></remarks>\r\n");
				valueXmlString.append( "</Detail"+formNo+">\r\n" );
				domID++;
			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		catch(Exception e)
		{
			System.out.println( "Exception :WsfaDSRMobileWizardEJB :defaultDataWiz(Document,String):" + e.getMessage() + ":" );
			throw new ITMException(e); 
		}
		finally
		{
			try
			{
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				if( isLocalConn && conn != null && ! conn.isClosed() )
				{
					conn.close();
					conn = null;
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :WsfaDSRMobileWizardEJB :defaultDataWiz :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		return valueXmlString.toString();
	}

	private String getSelectedRowValue(Document dom,String formNo, String colName, int rowNo) throws ITMException
	{
		NodeList detailList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;
		Element elementAttr = null;
		String childNodeName = "";
		String columnValue = "";
		int	detailListLength = 0;
		int noOfChilds = 0;

		try
		{
			detailList = dom.getElementsByTagName("Detail"+formNo);
			detailListLength = detailList.getLength();
			parentNode = detailList.item(rowNo);
			elementAttr = (Element)parentNode;
			childList = parentNode.getChildNodes();
			noOfChilds = childList.getLength();

			if ( parentNode != null )
			{
				for (int ctr = 0; ctr < noOfChilds; ctr++)
				{
					childNode = childList.item(ctr);
					childNodeName = childNode.getNodeName();
					if(childNodeName.equals(colName) )
					{
						if(childNode.getFirstChild()!=null )
						{
							columnValue = childNode.getFirstChild().getNodeValue();
							break;
						}
					}
				}
			}
			if(columnValue == null)
				columnValue = "";
		}
		catch( Exception exp )
		{
			exp.printStackTrace();
		}

		return columnValue;
	}

	private boolean preDomExists(Document dom, String currentFormNo) throws ITMException
	{
		NodeList parentList = null;
		NodeList childList = null;
		Node childNode = null;
		boolean selected = false;

		try
		{
			parentList = dom.getElementsByTagName("Detail" + currentFormNo);
			if ( parentList.item(0) != null )
			{
				childList = parentList.item(0).getChildNodes();
				for (int ctr = 0; ctr < childList.getLength(); ctr++)
				{
					childNode = childList.item(ctr);
					if((childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null))
					{
						selected = true;
						break;
					}
				}
			}
		}
		catch ( Exception e )
		{
			System.out.println( "Exception :WsfaZuviusDsrMobileWizardEJB :preDomExists :==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		return selected;
	}

	private String getPrevFormValues( Document dom, String currentFormNo, ArrayList temp, String colName) throws ITMException
	{
		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;
		Element elementAttr = null;
		String childNodeName = "";
		String columnValue = "";
		String returnPrevStr = "";
		Document chgPreDom = null;
		try
		{
			chgPreDom = genericUtility.parseString("<Root/>");
			parentList = dom.getElementsByTagName("Detail" + currentFormNo);
			int parentNodeListLength = parentList.getLength();
			for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
			{
				parentNode = parentList.item(prntCtr);
				childList = parentNode.getChildNodes();
				for (int ctr = 0; ctr < childList.getLength(); ctr++)
				{
					childNode = childList.item(ctr);

					if((childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null))
					{
						columnValue = childNode.getFirstChild().getNodeValue().trim();
						if ( childNode.getNodeName().equalsIgnoreCase(colName) && temp.contains("'"+columnValue+"'"))
						{
							elementAttr = (Element)parentNode;
							if ( parentNode.getAttributes().getNamedItem( "domID" ) != null )
							{
								elementAttr.setAttribute( "selected" , "Y" );
								domID1++;
							}
							Node importedNode = chgPreDom.importNode( parentNode, true );
							chgPreDom.getDocumentElement().appendChild( importedNode );
							break;
						}

					}
				}
			}
			if(currentFormNo.equals("1"))
			{
				domID1 = 1;
			}
			returnPrevStr = genericUtility.serializeDom(chgPreDom);
			if(returnPrevStr.indexOf("Detail"+currentFormNo) != -1)
			{
				returnPrevStr = returnPrevStr.substring(returnPrevStr.indexOf(">") + 1, returnPrevStr.lastIndexOf("</"));
			}
			returnPrevStr = returnPrevStr.indexOf("Detail"+currentFormNo) != -1 ? returnPrevStr : "";
		}
		catch ( Exception e )
		{
			throw new ITMException(e);
		}
		return returnPrevStr;
	}

	private String getSalesPersItemList(Document dom, String sprsCode, String strgCode, String selectedItem, String eventDate, String formNo, String formName, Document dom2, String tranIdPrv, Connection connectionObject ) throws ITMException
	{
		String sql = "";
		StringBuffer valueXmlString = new StringBuffer();
		PreparedStatement pstmt = null;
		ResultSet rs = null;

		String bindValue = sprsCode;
		try
		{
			valueXmlString.append( "<Root>\r\n" );
			//HashMap itemAttribMap = getItemAttributeDetails(connectionObject, sql, bindValue, strgCustCnt, "'"+strgCode+"'", paramValue, sprsCnt);
			HashMap<String, String> itemMap = new HashMap<String, String>();
			HashMap<String, String> remarksMap = new HashMap<String, String>();
			HashMap<String, Integer> lineNoMap = new HashMap<String, Integer>();
			ArrayList<Integer> lineNoList = new ArrayList<Integer>();
			
			if ( selectedItem != null && selectedItem.trim().length() > 0 )
			{
				NodeList itemNodeList = ( genericUtility.parseString( selectedItem ) ).getElementsByTagName("Detail"+formNo+"");
				int nodeListLen = itemNodeList.getLength();
				for ( int i=0; i < nodeListLen ; i++ )
				{
					NodeList innerNodeList = itemNodeList.item( i ).getChildNodes();
					int innerNodeListLen = innerNodeList.getLength();
					String tranId = "";
					String itemCode = "";
					String qty = "";
					String remarks = "";
					String lineNo= "";
					
					for ( int j = 0; j < innerNodeListLen; j++ )
					{
						Node currNode = innerNodeList.item( j );
						if ( "tran_id".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild() != null)
							{
								tranId = currNode.getFirstChild().getNodeValue().trim() ;
							}
						}
						else if ( "item_code".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild() != null)
							{
								itemCode = currNode.getFirstChild().getNodeValue().trim() ;
							}
						}
						else if ( "quantity".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild().getNodeValue() != null )
							{
								qty = currNode.getFirstChild().getNodeValue().trim();
							}
						}
						else if ( "line_no".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild().getNodeValue() != null )
							{
								lineNo = currNode.getFirstChild().getNodeValue().trim();
							}
						}
						else if ( "remarks".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild() != null)
							{
								remarks = checkNull(currNode.getFirstChild().getNodeValue());
							}
						}
					}
					itemMap.put( itemCode, qty);
					remarksMap.put( (tranId + "~" + itemCode), remarks );
					lineNoMap.put( (tranId + "~" + itemCode), Integer.parseInt( lineNo ) );
					lineNoList.add( Integer.parseInt( lineNo ) );
				}
			}

			String itemSizeCol = getSfaParmValue(sprsCode,"ITEM_ATTRIB_SIZE",connectionObject);
			if(itemSizeCol.trim().length() == 0)
			{
				itemSizeCol = "PHY_ATTRIB_1";
			}
			int sprsCnt = 0;
			String sprsCntSql="SELECT COUNT(*) AS COUNT " + 
					" FROM SALES_PERS SP, STATE S ,ITEM ITEM LEFT OUTER JOIN PRICELIST  PM ON ITEM.ITEM_CODE = PM.ITEM_CODE " + 
					" LEFT OUTER JOIN PRODUCT P ON ITEM.PRODUCT_CODE = P.PRODUCT_CODE " + 
					" LEFT OUTER JOIN ITM_ATTRIB_VAL V ON ITEM."+itemSizeCol+"=V.ATTRIB_ID,SPRS_ITEM SI " + 
					" WHERE SP.STATE_CODE = S.STATE_CODE AND S.PRICE_LIST = PM.PRICE_LIST AND SI.ITEM_CODE= ITEM.ITEM_CODE AND SP.SALES_PERS=SI.SALES_PERS " + 
					" AND SP.SALES_PERS = ? AND ITEM.ACTIVE = 'Y'  AND SI.STATUS='Y' " + 
					" AND RTRIM((CASE WHEN ITEM.ITEM_USAGE IS NULL THEN 'O' ELSE ITEM.ITEM_USAGE END )) NOT IN('S','G') " + 
					" ORDER BY P.SORT_ORDER,V.SORT_ORDER";
			PreparedStatement pstmtCnt = connectionObject.prepareStatement(sprsCntSql);
			if(bindValue != null && bindValue.trim().length() > 0)
			{
				pstmtCnt.setString(1, bindValue);
			}
			rs = pstmtCnt.executeQuery();
			if(rs.next())
			{
				sprsCnt = rs.getInt("COUNT");
			}
			if(rs != null)
			{
				rs.close(); rs = null;
			}
			if(pstmtCnt != null)
			{
				pstmtCnt.close(); pstmtCnt = null;
			}
			
			System.out.print("strgCode in the item detail "+strgCode);
			
			String qty = "";
			int lineNo = 1;
			if ( lineNoList.size() > 0 )
			{
				lineNo = Collections.max( lineNoList ) + 1;
			}
			
			if(sprsCnt > 0)
			{
				sql = " SELECT DISTINCT ITEM.ITEM_CODE AS ITEM_CODE ,ITEM.DESCR AS DESCR, ITEM.SH_DESCR AS SH_DESCR, ITEM.UNIT AS ITEM_UNIT,S.PRICE_LIST AS PRICE_LIST " +
						" ,P.PRODUCT_CODE AS PRODUCT_CODE, P.DESCR AS PRODUCT_DESCR, P.PRODUCT_TYPE, P.SORT_ORDER, V.SORT_ORDER  "+
						" FROM SALES_PERS SP, STATE S ,ITEM ITEM LEFT OUTER JOIN PRICELIST  PM ON ITEM.ITEM_CODE = PM.ITEM_CODE "+
						" LEFT OUTER JOIN PRODUCT P ON ITEM.PRODUCT_CODE = P.PRODUCT_CODE "+
						" LEFT OUTER JOIN ITM_ATTRIB_VAL V ON ITEM."+itemSizeCol+"=V.ATTRIB_ID,SPRS_ITEM SI " +
						" WHERE SP.STATE_CODE = S.STATE_CODE AND S.PRICE_LIST = PM.PRICE_LIST AND SI.ITEM_CODE= ITEM.ITEM_CODE AND SP.SALES_PERS=SI.SALES_PERS "+
						" AND SP.SALES_PERS = ?  AND ITEM.ACTIVE = 'Y' AND SI.STATUS='Y' "+
						" AND RTRIM((CASE WHEN ITEM.ITEM_USAGE IS NULL THEN 'O' ELSE ITEM.ITEM_USAGE END )) NOT IN('S','G') "+
						" ORDER BY P.SORT_ORDER,V.SORT_ORDER ";
			}
			else
			{
				sql = " SELECT DISTINCT ITEM.ITEM_CODE AS ITEM_CODE ,ITEM.DESCR AS DESCR, ITEM.SH_DESCR AS SH_DESCR, ITEM.UNIT AS ITEM_UNIT,S.PRICE_LIST AS PRICE_LIST " +
						" ,P.PRODUCT_CODE AS PRODUCT_CODE, P.DESCR AS PRODUCT_DESCR, P.PRODUCT_TYPE, P.SORT_ORDER, V.SORT_ORDER  "+
						" FROM SALES_PERS SP, STATE S ,ITEM ITEM LEFT OUTER JOIN PRICELIST  PM ON ITEM.ITEM_CODE = PM.ITEM_CODE "+
						" LEFT OUTER JOIN PRODUCT P ON ITEM.PRODUCT_CODE = P.PRODUCT_CODE "+
						" LEFT OUTER JOIN ITM_ATTRIB_VAL V ON ITEM."+itemSizeCol+"=V.ATTRIB_ID " +
						" WHERE SP.STATE_CODE = S.STATE_CODE AND S.PRICE_LIST = PM.PRICE_LIST "+
						" AND SP.SALES_PERS = ? AND SP.ITEM_SER = ITEM.ITEM_SER AND ITEM.ACTIVE = 'Y' "+
						" AND RTRIM((CASE WHEN ITEM.ITEM_USAGE IS NULL THEN 'O' ELSE ITEM.ITEM_USAGE END )) NOT IN('S','G') "+
						" ORDER BY P.SORT_ORDER,V.SORT_ORDER ";
			}
			pstmt =  connectionObject.prepareStatement( sql );
			pstmt.setString(1, sprsCode);
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				String itemCode = checkNull(rs.getString("ITEM_CODE"));
				itemCode = itemCode.trim();
				String itemDescr = checkNull(rs.getString("DESCR"));
				if ( itemMap.get( itemCode ) != null )
				{
					qty = ( String ) itemMap.get( itemCode );
					
					String remarks = checkNull( remarksMap.get( tranIdPrv +"~"+ itemCode ) );
					int lineNum = lineNoMap.get( tranIdPrv +"~"+ itemCode );
					
					valueXmlString.append("<Detail"+formNo+" domID='"+lineNum+"' selected = 'Y' formName='"+formName+"'>\r\n" );
					valueXmlString.append("<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\"/>\r\n");
					valueXmlString.append("<selectbox><![CDATA[").append( "true" ).append("]]></selectbox>\n");
					valueXmlString.append("<tran_id><![CDATA["+tranIdPrv+"]]></tran_id>\r\n" );
					valueXmlString.append("<line_no><![CDATA["+lineNum+"]]></line_no>\r\n");
					valueXmlString.append("<quantity><![CDATA[" ).append( qty ).append( "]]></quantity>\r\n" );
					valueXmlString.append("<remarks><![CDATA[" ).append( remarks ).append( "]]></remarks>\r\n" );
				}
				else
				{
					valueXmlString.append("<Detail"+formNo+" domID='"+lineNo+"' selected = 'N' formName='"+formName+"'>\r\n" );
					valueXmlString.append("<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");
					valueXmlString.append("<selectbox><![CDATA[").append( "false" ).append("]]></selectbox>\n");
					valueXmlString.append("<tran_id></tran_id>\r\n" );
					valueXmlString.append("<line_no><![CDATA["+lineNo+"]]></line_no>\r\n");
					valueXmlString.append("<quantity></quantity>\r\n" );
					valueXmlString.append("<remarks></remarks>\r\n" );
					
					lineNo++;
				}
				valueXmlString.append("<item_descr><![CDATA[").append( itemDescr ).append("]]></item_descr>\r\n");
				valueXmlString.append("<item_code><![CDATA[").append( itemCode ).append("]]></item_code>\r\n");
				valueXmlString.append("<strg_code><![CDATA[" ).append( strgCode ).append( "]]></strg_code>\r\n" );
				valueXmlString.append("</Detail"+formNo+">\r\n" );

				qty = "";
			}
			if(rs != null)
			{
				rs.close(); rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close(); pstmt = null;
			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
			System.out.println( "Exception :ITMWizardStatefulEJB :getSalesPersItemList(String):" + e.getMessage() + ":" );
			throw new ITMException(e); 
		}
		finally
		{
			try
			{
				if( connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :ITMWizardStatefulEJB :getSalesPersItemList(String) :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		valueXmlString.append( "</Root>\r\n" );
		System.out.println( "****ValueXmlString :" + valueXmlString.toString() + ":********" );
		return valueXmlString.toString();
	}

	private String getSfaParmValue(String userId,String paramName,Connection connectionObject) throws ITMException//Chnaged by sachin satre on 11-nov-16
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		PreparedStatement pstmt1 = null;
		ResultSet rs1 = null;
		String empSite="";
		String itemSer="";
		String paramValue="";
		PreparedStatement allPstmt = null;
		ResultSet allRs = null;
		boolean isLocalConn =false;
		try
		{
			if(connectionObject == null)
			{
				connectionObject = getConnection();//chnged by sachin satre on [11-nov-16] to get connectioni
				isLocalConn =true;
			}
			String sql = "SELECT SITE_CODE__DEF FROM USERS WHERE CODE = ? ";
			pstmt = connectionObject.prepareStatement(sql);
			pstmt.setString(1, userId);

			rs = pstmt.executeQuery();
			if( rs.next() )
			{
				empSite  = checkNull(rs.getString("SITE_CODE__DEF"));
			}
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}

			String getSalesPerData = " SELECT SALES_PERS.ITEM_SER,ITEMSER.DESCR FROM ITEMSER LEFT OUTER JOIN SALES_PERS ON ITEMSER.ITEM_SER = SALES_PERS.ITEM_SER "+
					" WHERE  SALES_PERS.SALES_PERS = ? ";

			pstmt = connectionObject.prepareStatement(getSalesPerData);
			pstmt.setString(1, userId);

			rs = pstmt.executeQuery();
			if( rs.next() )
			{
				itemSer  = checkNull(rs.getString("ITEM_SER"));
			}
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}

			sql=" SELECT PARM_VALUE  "+
					" FROM SFAPARM  "+
					" WHERE ORG_UNIT =?  "+
					" AND ACTIVE='Y'  "+
					" AND PARM_NAME= ? ";

			pstmt = connectionObject.prepareStatement(sql);
			pstmt.setString(1, empSite+"_"+itemSer);
			pstmt.setString(2, paramName);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				paramValue  = checkNull(rs.getString(1));
			}
			else
			{
				pstmt1 = connectionObject.prepareStatement(sql);
				pstmt1.setString(1, itemSer);
				pstmt1.setString(2, paramName);
				rs1 = pstmt1.executeQuery();
				if(rs1.next())
				{
					paramValue  = checkNull(rs1.getString(1));
				}
				else
				{
					allPstmt = connectionObject.prepareStatement(sql);
					allPstmt.setString(1, "ALL");
					allPstmt.setString(2, paramName);
					allRs = allPstmt.executeQuery();
					if(allRs.next())
					{
						paramValue  = checkNull(allRs.getString(1));
					}
				}
				if ( allRs != null )
				{
					allRs.close();
					allRs = null;
				}
				if ( allPstmt != null )
				{
					allPstmt.close();
					allPstmt = null;
				}
				if ( rs1 != null )
				{
					rs1.close();
					rs1 = null;
				}
				if ( pstmt1 != null )
				{
					pstmt1.close();
					pstmt1 = null;
				}
			}
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}

		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e); 

		}
		finally
		{
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if( isLocalConn && connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch (SQLException e) {
				e.printStackTrace();
			}
		}
		return paramValue;
	}
	
	private String getObjNameFromDom( Document dom, String attribute , int currFormNo) throws ITMException
	{
		String objName = "";
		try
		{
			NodeList detailList = null;
			Node currDetail = null,reqDetail = null;
			int	detailListLength = 0;

			detailList = dom.getElementsByTagName("Detail" + currFormNo);
			detailListLength = detailList.getLength();
			for (int ctr = 0;ctr < detailListLength;ctr++)
			{
				currDetail = detailList.item(ctr);
				objName = currDetail.getAttributes().getNamedItem(attribute).getNodeValue();
				break;

			}
			if(objName == null || objName.trim().length() == 0)
			{
				NodeList objNameList = dom.getElementsByTagName("objName");
				if(objNameList != null && objNameList.getLength() > 0)
				{
					Node objNameNode = objNameList.item(0);
					if(objNameNode != null && objNameNode.getFirstChild() != null)
					{
						objName = checkNull(objNameNode.getFirstChild().getNodeValue());
					}
				}
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		return objName;
	}

	private HashMap getSubForms(String formNo, String objName, Connection conn) throws ITMException
	{
		PreparedStatement pStmt = null;
		PreparedStatement pStmtInner = null;
		ResultSet rs = null;
		ResultSet rsInner = null;
		String formType = "";
		HashMap<String, String> SubFormMap = new LinkedHashMap<String,String>();
		try
		{
			String winName = "w_"+objName;
			String sql = "SELECT FORM_NO,FORM_TYPE FROM OBJ_FORMS WHERE WIN_NAME = ? AND FORM_NO = ?";
			pStmt = conn.prepareStatement(sql);
			pStmt.setString(1, winName);
			pStmt.setString(2, formNo);
			rs = pStmt.executeQuery();
			if( rs.next() )
			{
				formType = checkNull(rs.getString("FORM_TYPE"));
			}
			if( rs !=null )
			{
				rs.close();
				rs = null;
			}
			if( pStmt !=null )
			{
				pStmt.close();
				pStmt = null;
			}
			String[] nextArr = formType.split(":",3);
			String  nextForm= nextArr[2];
			int nextFormNo = 0;
			int currFormNo = 0;
			if( nextForm != null && nextForm.trim().length() > 0 )
			{
				nextFormNo = Integer.parseInt( nextForm );
			}
			if( formNo != null && formNo.trim().length() > 0 )
			{
				currFormNo = Integer.parseInt( formNo );
			}
			String formNameSql = "SELECT FORM_NO,FORM_NAME FROM OBJ_FORMS WHERE WIN_NAME = ? AND FORM_NO = ? ";
			pStmtInner = conn.prepareStatement(formNameSql);

			for(int i = (currFormNo+1) ; i< nextFormNo; i++)
			{
				pStmtInner.setString(1, winName);
				pStmtInner.setInt(2, i);

				rsInner = pStmtInner.executeQuery();

				if(rsInner.next())
				{
					String _formNo = checkNull(rsInner.getString("FORM_NO"));
					String _formName = checkNull(rsInner.getString("FORM_NAME"));
					SubFormMap.put( _formName,_formNo);
				}
				pStmtInner.clearParameters();
				if( rsInner !=null )
				{
					rsInner.close();
					rsInner = null;
				}
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e); 

		}
		finally
		{
			try
			{
				if( rs !=null )
				{
					rs.close();
					rs = null;
				}
				if( pStmt !=null )
				{
					pStmt.close();
					pStmt = null;
				}
				if( pStmtInner !=null )
				{
					pStmtInner.close();
					pStmtInner = null;
				}

			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return SubFormMap;
	}

	private String getExistingClaimDetail( Document dom, Document dom2, String tranIdPrv, int formNo, String strgCodePrvs, Connection conn, String formName, int currentFormNo ) throws ITMException
	{
		System.out.println("getExistingClaimDetail getExistingClaimDetail" +tranIdPrv);
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		String sql= "";
		StringBuffer valueXmlString = new StringBuffer();
		try
		{
			String[] temp = strgCodePrvs.split(",");
			if ( preDomExists( dom2, ""+formNo ))
			{
				valueXmlString.append( getPrevFormValues( dom2, ""+formNo, new ArrayList<String>(Arrays.asList(temp)), "strg_code" ) );
			}
			else
			{
				int num = 1;
				sql = "SELECT * FROM RETAIL_SCH_CLAIM_DET WHERE TRAN_ID = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,tranIdPrv);
				rs = pstmt.executeQuery();
				while(rs.next())
				{
					valueXmlString.append("<Detail" + formNo + " domID='"+ num +"' formName='"+formName+"' selected = 'Y'>\r\n");
					valueXmlString.append("<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\"/>\r\n");
					valueXmlString.append("<selectbox><![CDATA[").append( "true" ).append("]]></selectbox>\n");
					valueXmlString.append("<tran_id><![CDATA[" + tranIdPrv  + "]]></tran_id>");
					valueXmlString.append("<line_no><![CDATA["+rs.getInt("line_no")+ "]]></line_no>");
					valueXmlString.append("<invoice_id><![CDATA[" + checkNull(rs.getString("invoice_id")).trim()  + "]]></invoice_id>");
					valueXmlString.append("<inv_date><![CDATA[" +genericUtility.getValidDateString((rs.getDate("inv_date")).toString(), genericUtility.getDBDateFormat(), genericUtility.getApplDateFormat())  + "]]></inv_date>");
					valueXmlString.append("<inv_amt><![CDATA[" + rs.getInt("inv_amt")  + "]]></inv_amt>");
					valueXmlString.append("<aprv_amt><![CDATA[" + rs.getInt("aprv_amt")  + "]]></aprv_amt>");
					valueXmlString.append("<image_id><![CDATA[" + checkNull(rs.getString("image_id"))  + "]]></image_id>");
					valueXmlString.append("<strg_code><![CDATA[" + strgCodePrvs  + "]]></strg_code>");
					valueXmlString.append("</Detail" + formNo + ">");

					num++;
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;

				if( num == 1 && formNo == currentFormNo )
				{
					int maxDomId= 0;
					ArrayList domIdList  = getMaxDomIdListFromDom( dom2, "domID", currentFormNo );
					System.out.println( " domIdList " + domIdList );

					int maxVal = (int) Collections.max(domIdList);
					maxDomId = maxVal;
					System.out.println( " maxDomId " + maxDomId );
					valueXmlString.append("<Detail"+ formNo +" domID='"+ maxDomId +"' formName='"+formName+"' selected = 'Y'>\r\n");
					valueXmlString.append("<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");
					valueXmlString.append("<selectbox><![CDATA[").append( "true" ).append("]]></selectbox>\r\n");
					valueXmlString.append("<tran_id></tran_id>\r\n");
					valueXmlString.append("<line_no><![CDATA["+ maxDomId +"]]></line_no>\r\n");
					valueXmlString.append("<invoice_id></invoice_id>\r\n");
					valueXmlString.append("<inv_date></inv_date>\r\n");
					valueXmlString.append("<inv_amt></inv_amt>\r\n");
					valueXmlString.append("<aprv_amt><![CDATA[0]]></aprv_amt>\r\n");
					valueXmlString.append("<image_id></image_id>\r\n");
					valueXmlString.append("<strg_code><![CDATA[" +  strgCodePrvs  + "]]></strg_code>");
					valueXmlString.append("</Detail" + formNo + ">");
				}
			}
		}
		catch(Exception e)
		{
			System.out.println( "Exception :RetailSchemeClaimEJB :getExistingClaimDetail :" + e.getMessage() + ":" );
			throw new ITMException(e); 
		}
		finally
		{
			try
			{
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :RetailSchemeClaimEJB :defaultDataWiz :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		return valueXmlString.toString();
	}

	private String getStrgdescr(Connection conn,String strgCodePrv) throws SQLException
	{
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		String sql= "",strgFirstNamePrv="";

		sql = "select FIRST_NAME || ' ' || LAST_NAME AS CUST_NAME from strg_customer where sc_code =?";
		pstmt = conn.prepareStatement(sql);
		pstmt.setString(1, strgCodePrv);
		rs = pstmt.executeQuery();
		if (rs.next())
		{
			//strgFirstNamePrv = checkNull(rs.getString("FIRST_NAME"));
			strgFirstNamePrv = checkNull(rs.getString("CUST_NAME"));
		}
		rs.close();
		rs = null;
		pstmt.close();
		pstmt = null;

		return strgFirstNamePrv;
	}

	private ArrayList getMaxDomIdListFromDom( Document dom, String attribute , int currFormNo) throws ITMException
	{
		String domID = "";
		ArrayList allSelectedDomIdList = new ArrayList();
		try
		{
			NodeList detailList = null;
			Node currDetail = null,reqDetail = null;
			int	detailListLength = 0;
			String indexDom = "";

			detailList = dom.getElementsByTagName("Detail" + currFormNo);
			detailListLength = detailList.getLength();
			System.out.println("detailListLength>>>>["+detailListLength+"]");
			if(detailListLength > 0)
			{
				for (int ctr = 0;ctr < detailListLength;ctr++)
				{
					System.out.println("detailListLength>>>> for loop ["+detailListLength+"]");
					currDetail = detailList.item(ctr);
					domID = currDetail.getAttributes().getNamedItem(attribute).getNodeValue();

					System.out.println("domID>>>>["+domID+"]");
					if ( domID.indexOf(":") > 0 )
					{
						String temp [] = domID.split(":");
						if ( temp != null && temp.length > 0 )
						{
							System.out.println("temp.length["+temp.length+"]");
							for ( int i=0; i<temp.length; i++)
							{
								indexDom = temp[i];
								System.out.println("teamMember =["+indexDom+"]");
							}
							indexDom= temp[0];
							System.out.println("teamMemberoooo =["+indexDom+"]");
						}
					}
					else
					{
						indexDom = domID;
						System.out.println("inside else"+indexDom+"]");
					}

					System.out.println("domID["+indexDom+"]");
					int intDomID = Integer.parseInt(indexDom);
					System.out.println("DomiD value is := intDomID"+intDomID);
					allSelectedDomIdList.add(intDomID);
				}
			}
			else
			{
				allSelectedDomIdList.add(1);
			}

			System.out.println("allSelectedDomIdList>>>>["+allSelectedDomIdList+"]");
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		System.out.println("allSelected Donm id on previous:-"+allSelectedDomIdList);
		return allSelectedDomIdList;
	}
	
	//Added by Amwy W. [ To get Division wise HO ] on 24-06-2019 STAT
	private String getItemSer( String empCode, Connection conn ) throws Exception 
	{
		ResultSet rs = null;
		Statement stmt = null;
		String itemSer = "";

		String distanceSql = "SELECT ITEM_SER FROM SALES_PERS WHERE SALES_PERS = '"+empCode+"'";
		try
		{
			stmt = conn.createStatement();
			rs = stmt.executeQuery(distanceSql);
			while(rs.next())
			{
				itemSer = checkNull(rs.getString("ITEM_SER"));
			}
			if( rs != null)
			{
				rs.close();
				rs = null;
			}
			if( stmt != null)
			{
				stmt.close();
				stmt = null;
			}
		}
		catch(Exception e)
		{
			throw e;
		}
		finally
		{
			if( rs != null)
			{
				rs.close();
				rs = null;
			}
			if( stmt != null)
			{
				stmt.close();
				stmt = null;
			}
		}
		return itemSer;
	}

	public String getDivisionHO(String itemSer,Connection conn) throws ITMException
	{
		System.out.println("In side getDivisionHO............");
		System.out.println("In side getDivisionHO............itemSer = "+itemSer+" conn  = "+conn);
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		String hoCode="";

		try
		{
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String sysDate = sdf.format(new java.util.Date());
			sysDate  = genericUtility.getValidDateString(sysDate, genericUtility.getApplDateFormat(), genericUtility.getDBDateTimeFormat());
			System.out.println("itemSer:::["+itemSer+"]");
			String sql=" SELECT PARM_VALUE  "+
					" FROM SFAPARM  "+
					" WHERE ORG_UNIT =?  "+
					" AND ACTIVE='Y'  "+
					" AND PARM_NAME='SCHEME_CLAIM_HO' "+
					" AND ?  BETWEEN EFF_FROM AND VALID_UPTO ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, "X"+"_"+itemSer);
			pstmt.setTimestamp(2,java.sql.Timestamp.valueOf(sysDate));
			rs = pstmt.executeQuery();
			if( rs.next() )
			{
				hoCode  = checkNull(rs.getString(1));
			}
			System.out.println("hoCode:::["+hoCode+"]");
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
		}
		catch (Exception e) 
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try 
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch (SQLException e) 
			{
				e.printStackTrace();
			}
		}
		System.out.println("hoCode..:::=["+hoCode+"]");
		return hoCode.trim();
	}
	////Added by Amwy W. [ To get Division wise HO ] on 24-06-2019 END
	// added by rupali on 12/07/19 for getting item from participants item form [start]
	private String getRetailSchemeClaimItemList(Document dom, String sprsCode, String strgCode, String selectedItem, String eventDate, String formNo, String formName, Document dom2, String tranIdPrv, Connection connectionObject ) throws ITMException
	{
		String sql = "";
		StringBuffer valueXmlString = new StringBuffer();
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		
		try
		{
			//valueXmlString.append( "<Root>\r\n" );
			HashMap<String, String> itemMap = new HashMap<String, String>();
			HashMap<String, String> remarksMap = new HashMap<String, String>();
			HashMap<String, Integer> lineNoMap = new HashMap<String, Integer>();
			ArrayList<Integer> lineNoList = new ArrayList<Integer>();
			String schemeCode = getSelectedRowValue(dom2, "1", "scheme_code", 0);
			
			if ( selectedItem != null && selectedItem.trim().length() > 0 )
			{
				NodeList itemNodeList = ( genericUtility.parseString( selectedItem ) ).getElementsByTagName("Detail"+formNo+"");
				int nodeListLen = itemNodeList.getLength();
				for ( int i=0; i < nodeListLen ; i++ )
				{
					NodeList innerNodeList = itemNodeList.item( i ).getChildNodes();
					int innerNodeListLen = innerNodeList.getLength();
					String tranId = "";
					String itemCode = "";
					String qty = "";
					String remarks = "";
					String lineNo= "";
					
					for ( int j = 0; j < innerNodeListLen; j++ )
					{
						Node currNode = innerNodeList.item( j );
						if ( "tran_id".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild() != null)
							{
								tranId = currNode.getFirstChild().getNodeValue().trim() ;
							}
						}
						else if ( "item_code".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild() != null)
							{
								itemCode = currNode.getFirstChild().getNodeValue().trim() ;
							}
						}
						else if ( "quantity".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild().getNodeValue() != null )
							{
								qty = currNode.getFirstChild().getNodeValue().trim();
							}
						}
						else if ( "line_no".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild().getNodeValue() != null )
							{
								lineNo = currNode.getFirstChild().getNodeValue().trim();
							}
						}
						else if ( "remarks".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild() != null)
							{
								remarks = checkNull(currNode.getFirstChild().getNodeValue());
							}
						}
					}
					itemMap.put( itemCode, qty);
					remarksMap.put( (tranId + "~" + itemCode), remarks );
					lineNoMap.put( (tranId + "~" + itemCode), Integer.parseInt( lineNo ) );
					lineNoList.add( Integer.parseInt( lineNo ) );
				}
			}

			System.out.print("strgCode in the item detail "+strgCode);
			
			String qty = "";
			int lineNo = 1;
			if ( lineNoList.size() > 0 )
			{
				lineNo = Collections.max( lineNoList ) + 1;
			}
			
			if(schemeCode == null || schemeCode.trim().length() == 0 ) 
			{
				sql = "select scheme_code from retail_sch_claim where tran_id = ?";
				pstmt =  connectionObject.prepareStatement( sql );
				pstmt.setString(1, tranIdPrv);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					schemeCode = checkNull(rs.getString("scheme_code"));
				}
			}
			
			sql = "SELECT ITEM.ITEM_CODE,ITEM.DESCR from RETAIL_SCHEME_ITEM RSI,ITEM ITEM WHERE RSI.ITEM_CODE = ITEM.ITEM_CODE AND RSI.SCHEME_CODE = ?";
			pstmt =  connectionObject.prepareStatement( sql );
			pstmt.setString(1, schemeCode);
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				String itemCode = checkNull(rs.getString("ITEM_CODE"));
				itemCode = itemCode.trim();
				String itemDescr = checkNull(rs.getString("DESCR"));
				if ( itemMap.get( itemCode ) != null )
				{
					qty = ( String ) itemMap.get( itemCode );
					
					String remarks = checkNull( remarksMap.get( tranIdPrv +"~"+ itemCode ) );
					int lineNum = lineNoMap.get( tranIdPrv +"~"+ itemCode );
					
					valueXmlString.append("<Detail"+formNo+" domID='"+lineNum+"' selected = 'Y' formName='"+formName+"'>\r\n" );
					valueXmlString.append("<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\"/>\r\n");
					valueXmlString.append("<selectbox><![CDATA[").append( "true" ).append("]]></selectbox>\n");
					valueXmlString.append("<tran_id><![CDATA["+tranIdPrv+"]]></tran_id>\r\n" );
					valueXmlString.append("<line_no><![CDATA["+lineNum+"]]></line_no>\r\n");
					valueXmlString.append("<quantity><![CDATA[" ).append( qty ).append( "]]></quantity>\r\n" );
					valueXmlString.append("<remarks><![CDATA[" ).append( remarks ).append( "]]></remarks>\r\n" );
				}
				else
				{
					valueXmlString.append("<Detail"+formNo+" domID='"+lineNo+"' selected = 'N' formName='"+formName+"'>\r\n" );
					valueXmlString.append("<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");
					valueXmlString.append("<selectbox><![CDATA[").append( "false" ).append("]]></selectbox>\n");
					valueXmlString.append("<tran_id></tran_id>\r\n" );
					valueXmlString.append("<line_no><![CDATA["+lineNo+"]]></line_no>\r\n");
					valueXmlString.append("<quantity></quantity>\r\n" );
					valueXmlString.append("<remarks></remarks>\r\n" );
					
					lineNo++;
				}
				valueXmlString.append("<item_descr><![CDATA[").append( itemDescr ).append("]]></item_descr>\r\n");
				valueXmlString.append("<item_code><![CDATA[").append( itemCode ).append("]]></item_code>\r\n");
				valueXmlString.append("<strg_code><![CDATA[" ).append( strgCode ).append( "]]></strg_code>\r\n" );
				valueXmlString.append("</Detail"+formNo+">\r\n" );

				qty = "";
			}
			if(rs != null)
			{
				rs.close(); rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close(); pstmt = null;
			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
			System.out.println( "Exception :ITMWizardStatefulEJB :getSalesPersItemList(String):" + e.getMessage() + ":" );
			throw new ITMException(e); 
		}
		finally
		{
			try
			{
				if( connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :ITMWizardStatefulEJB :getSalesPersItemList(String) :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		//valueXmlString.append( "</Root>\r\n" );
		System.out.println( "****ValueXmlString :" + valueXmlString.toString() + ":********" );
		return valueXmlString.toString();
	}
	// added by rupali on 12/07/19 for getting item from participants item form [end]
	public String getMGREmployee(String empCode,Connection con) throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String empCodeMGR = "";
		String selectSql = "";
		try
		{
			selectSql = "SELECT A.EMP_CODE AS EMP_CODE FROM EMPLOYEE A, GRADE B " + "WHERE A.EMP_CODE = ? " + "AND A.GRADE = B.GRADE_CODE " + "AND B.GRADE_TYPE = 'M' ";

			pstmt = con.prepareStatement(selectSql);
			pstmt.setString(1, empCode);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				empCodeMGR = checkNull(rs.getString("EMP_CODE"));
			}
			rs.close();
		} catch (Exception e)
		{
			throw new ITMException(e);
		} finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}


			}
			catch (Exception e1){}

		}
		return empCodeMGR;
	}
	private String getStockistdescr(Connection conn,String strgCodePrv) throws SQLException
	{
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		String sql= "",strgFirstNamePrv="";

		sql = "select cust_name from customer where cust_code =?";
		pstmt = conn.prepareStatement(sql);
		pstmt.setString(1, strgCodePrv);
		rs = pstmt.executeQuery();
		if (rs.next())
		{
			strgFirstNamePrv = checkNull(rs.getString("CUST_NAME"));
		}
		rs.close();
		rs = null;
		pstmt.close();
		pstmt = null;

		return strgFirstNamePrv;
	}
	public String getDcrGroup(String strgType,Connection conn)
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String dcrGroup="";
		try
		{
			String sql="SELECT DCR_GROUP FROM STRG_CUST_TYPE WHERE TYPE=?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, strgType);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				dcrGroup = checkNull(rs.getString("DCR_GROUP"));
			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}

		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		finally
		{

			try
			{
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}

		}
		return dcrGroup;
	}
}