/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.servlet;

import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.bean.E12TransEditorCoreModel;
import ibase.webitm.bean.ITMTransactionCoreModel;
import ibase.webitm.ejb.MasterStatefulRemote;
import ibase.webitm.servlet.ITMAuthenticateServlet;
import ibase.webitm.utility.ITMException;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.json.JSONObject;
import org.json.XML;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ServiceHandlerServlet3
extends ITMAuthenticateServlet {
    ServletContext servletContext = null;
    ServletConfig servletConfig = null;
    final String XTRA_PARAMS_SEPARATOR = "~~";
    private String user_lang = "en";
    private String user_country = "US";

    @Override
    public void init(ServletConfig servletConfig) throws ServletException {
        this.servletConfig = servletConfig;
        this.servletContext = servletConfig.getServletContext();
    }

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    @Override
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        BaseLogger.log("2", null, null, "\n\n****** ServiceHandlerServlet3 called ******");
        Object outputStream = null;
        HttpSession sess = null;
        String responseStr = "";
        try {
            if (Boolean.valueOf(this.authenticate(request)).booleanValue()) {
                sess = request.getSession();
                BaseLogger.log("3", null, null, "\n\nsess.getId()............... :" + sess.getId());
                String objName = request.getParameter("OBJ_NAME");
                String methodName = request.getParameter("METHOD_NAME");
                String compType = request.getParameter("COMP_TYPE");
                String compName = request.getParameter("COMP_NAME");
                String refID = request.getParameter("REF_ID");
                String forcedFlag = request.getParameter("FORCED_FLAG");
                String eventCode = request.getParameter("SERVICE_CODE");
                BaseLogger.log("3", null, null, "serviceCode(eventcode) :[" + eventCode + "]");
                String chgStr = request.getParameter("CHG_STR");
                String serviceHandler = request.getParameter("SERVICE_HANDLER");
                String clientInterface = request.getParameter("INTERFACE");
                String editorId = request.getParameter("CORE_MDL_ID");
                String returnType = request.getParameter("RTEURN_TYPE");
                responseStr = this.handleAction(editorId, objName, eventCode, serviceHandler, chgStr, sess, clientInterface, returnType);
                BaseLogger.log("3", null, null, "After Handle Action Call");
                response.setHeader("Content-Encoding", "gzip");
                GZIPOutputStream outStream = new GZIPOutputStream((OutputStream)response.getOutputStream());
                outStream.write(responseStr.getBytes());
                outStream.flush();
                outStream.close();
            }
        }
        catch (ITMException itme) {
            itme.printStackTrace();
            try {
                String itmExpMsg = itme.getMessage();
                BaseLogger.log("3", null, null, "ServiceHandlerServlet3.doPost() : ITMException Msg[" + itmExpMsg + "]");
                response.setHeader("Cache-Control", "no-cache");
                response.setContentType("text/html; charset=" + CommonConstants.ENCODING);
                response.getWriter().write(itmExpMsg);
                response.getWriter().flush();
                response.getWriter().close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                E12GenericUtility genericUtility = new E12GenericUtility();
                PrintWriter writer = response.getWriter();
                String errMsg = "";
                response.setContentType("text/xml; charset=" + CommonConstants.ENCODING);
                errMsg = genericUtility.createErrorString(e);
                BaseLogger.log("0", null, null, "ServiceHandlerServlet3 Exception in doPost:==>" + errMsg);
                response.setContentLength(errMsg.length());
                writer.println(errMsg);
                writer.flush();
                writer.close();
            }
            catch (Exception ex) {
                String msg = ex.toString();
                if (ex != null && ex.toString().contains("Posted content")) {
                    msg = msg.replace("java.io.IOException:", "");
                    msg = "Exception:" + msg;
                }
                BaseLogger.log("0", null, null, "ServiceHandlerServlet3 : Exception[" + ex.getMessage() + "]");
                ex.printStackTrace();
                response.getWriter().write(msg);
            }
        }
    }

    private String handleAction(String coreModelID, String objName, String eventCode, String serviceHandler, String chgStr, HttpSession session, String clientInterface, String returnType) throws ITMException {
        String retStr = "";
        try {
            if ("MOBILE".equalsIgnoreCase(clientInterface) || "BROWSER".equalsIgnoreCase(clientInterface)) {
                UserInfoBean userInfo = (UserInfoBean)session.getAttribute("USER_INFO");
                String user = userInfo.getLoginCode();
                E12TransEditorCoreModel transEditorCoreModel = null;
                if (session.getAttribute(String.valueOf(coreModelID) + user) instanceof E12TransEditorCoreModel) {
                    transEditorCoreModel = (E12TransEditorCoreModel)session.getAttribute(String.valueOf(coreModelID) + user);
                }
                if (transEditorCoreModel != null) {
                    MasterStatefulRemote masterRem = transEditorCoreModel.getMasterStateful();
                    if (masterRem != null) {
                        retStr = masterRem.handleAction(eventCode, serviceHandler, chgStr);
                        BaseLogger.log("3", null, null, "Return XML String :: [" + retStr + "]");
                        if (retStr.indexOf("<Errors>") == -1) {
                            String objContext = null;
                            Node objContextNode = new E12GenericUtility().parseString(chgStr).getElementsByTagName("objContext").item(0);
                            if (objContextNode != null && objContextNode.getFirstChild() != null) {
                                objContext = objContextNode.getFirstChild().getNodeValue();
                            }
                            String pageContext = null;
                            Node pageContextNode = new E12GenericUtility().parseString(chgStr).getElementsByTagName("pageContext").item(0);
                            if (pageContextNode != null && pageContextNode.getFirstChild() != null) {
                                pageContext = pageContextNode.getFirstChild().getNodeValue();
                            }
                            String editFlag = null;
                            Node editFlagNode = new E12GenericUtility().parseString(chgStr).getElementsByTagName("editFlag").item(0);
                            if (editFlagNode != null && editFlagNode.getFirstChild() != null) {
                                editFlag = editFlagNode.getFirstChild().getNodeValue();
                            }
                            BaseLogger.log("3", null, null, "handleAction - objContext :[" + objContext + "], pageContext :[" + pageContext + "], editFlag :[" + editFlag + "]");
                            BaseLogger.log("3", null, null, "handleAction - retXMLStr :[" + retStr + "]");
                            BaseLogger.log("3", null, null, "handleAction - returnType :[" + returnType + "]");
                            if ("json".equalsIgnoreCase(returnType)) {
                                if (retStr == null || retStr != null && retStr.startsWith("<?xml")) {
                                    retStr = "<Root>" + retStr + "</Root>";
                                }
                                JSONObject jsonObject = XML.toJSONObject((String)retStr);
                                retStr = jsonObject.toString();
                                BaseLogger.log("3", null, null, "handleAction - retXMLStr in json:[" + retStr + "]");
                            }
                        }
                    }
                } else {
                    retStr = "ERR_MSG :MasterStatefulRemote not in session";
                }
            } else {
                ITMTransactionCoreModel itmTransCoreMdl = null;
                if ("null".equalsIgnoreCase(coreModelID) || "".equals(coreModelID) || coreModelID == null) {
                    retStr = "Invalid Session Context";
                } else if (session.getAttribute(coreModelID) instanceof ITMTransactionCoreModel) {
                    itmTransCoreMdl = (ITMTransactionCoreModel)session.getAttribute(coreModelID);
                }
                if (itmTransCoreMdl != null) {
                    BaseLogger.log("3", null, null, "Event Code is ::- [" + eventCode + "]");
                    E12GenericUtility genericUtility = new E12GenericUtility();
                    Document dom = genericUtility.parseString(chgStr);
                    String pContext = dom.getElementsByTagName("pageContext").item(0).getFirstChild().getNodeValue();
                    String objContext = dom.getElementsByTagName("objContext").item(0).getFirstChild().getNodeValue();
                    String editFlag = "";
                    BaseLogger.log("3", null, null, "editFlag:- " + editFlag + " & objContext :-" + objContext + " & pContext ::-" + pContext);
                    byte[] data = new byte[]{};
                    UserInfoBean userInfo = (UserInfoBean)session.getAttribute("USER_INFO");
                    String xslFileName = itmTransCoreMdl.getXSLFileName(objContext, editFlag, pContext, userInfo.getProfileIdRes());
                    BaseLogger.log("3", null, null, "xslFileName:- " + xslFileName);
                    itmTransCoreMdl.masterStateful.setEditorId(coreModelID);
                    String xmlData = itmTransCoreMdl.masterStateful.handleAction(eventCode, serviceHandler, chgStr);
                    String targetDir = String.valueOf(CommonConstants.APPLICATION_CONTEXT) + File.separator + "temp";
                    if (xmlData != null && xmlData.length() > 0) {
                        BaseLogger.log("3", null, null, "Length of xmlData :[" + xmlData.length() + "]");
                        retStr = genericUtility.transformToString(xslFileName, xmlData, targetDir, "Output", ".html");
                    }
                    BaseLogger.log("3", null, null, "retStr ::" + retStr);
                } else {
                    retStr = "ERR_MSG :itmTransCoreMdl not in session";
                    BaseLogger.log("3", null, null, "Return XML String :: [" + retStr + "]");
                }
            }
        }
        catch (ITMException itme) {
            session.setAttribute("ERR_MSG", (Object)"INVALID_ACTION");
            BaseLogger.log("0", null, null, "ITMException :ServiceHandlerServlet3 :handleAction() :==>");
            throw itme;
        }
        catch (Exception e) {
            session.setAttribute("ERR_MSG", (Object)"INVALID_ACTION");
            BaseLogger.log("0", null, null, "Exception :ServiceHandlerServlet3 :handleAction() :==>");
            throw new ITMException(e);
        }
        return retStr;
    }

    private void debug(HttpServletRequest request) {
        Enumeration enum1 = request.getParameterNames();
        while (enum1.hasMoreElements()) {
            String param = (String)enum1.nextElement();
            BaseLogger.log("3", null, null, "Parameter Name:" + param);
            BaseLogger.log("3", null, null, "Parameter Value:" + request.getParameter(param));
        }
    }
}

