/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.utility;

import ibase.bean.EventLogInfoBean;
import ibase.bean.ExtAuthApplicationBean;
import ibase.bean.ExtAuthRespBean;
import ibase.ejb.CommonDBAccessEJB;
import ibase.servlet.Messages;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseException;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.CryptographyUtil;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.utility.APIUtility;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.RestAPIServiceUtility;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.json.JSONObject;
import org.w3c.dom.Document;

public class ExtAuthAppServiceUtility {
    private E12GenericUtility genericUtility = new E12GenericUtility();
    protected UserInfoBean userInfo = null;
    CommonDBAccessEJB commonDBAccessEJB = new CommonDBAccessEJB();
    APIUtility apiUtility = new APIUtility();

    public JSONObject Login(String userCode, String password, String isPwdEncrypt, String appId, String isAdminUser, HttpServletRequest request) throws ITMException {
        String result = "";
        String status = "";
        JSONObject resultJson = new JSONObject();
        try {
            result = this.validateRequest(request);
            if (result.equals("valid")) {
                if (this.userInfo == null) {
                    this.userInfo = this.commonDBAccessEJB.createUserInfo(userCode);
                }
                if (this.apiUtility.checkDailyAPILimit(this.userInfo)) {
                    status = "Reject";
                    result = "Daily API call limit exceeded";
                    resultJson.put(status, (Object)result);
                } else {
                    userCode = E12GenericUtility.checkNull(userCode);
                    password = E12GenericUtility.checkNull(password);
                    appId = E12GenericUtility.checkNull(appId);
                    isPwdEncrypt = E12GenericUtility.checkNull(isPwdEncrypt).length() > 0 ? E12GenericUtility.checkNull(isPwdEncrypt) : "true";
                    RestAPIServiceUtility restapiserviceutility = new RestAPIServiceUtility();
                    String string = isAdminUser = restapiserviceutility.checkNull(isAdminUser).length() > 0 ? restapiserviceutility.checkNull(isAdminUser) : "false";
                    if (userCode.length() > 0 && appId.length() > 0) {
                        String remoteHostName;
                        String chgIP = request.getHeader("X-Forwarded-For");
                        if (chgIP == null) {
                            chgIP = request.getRemoteAddr();
                        }
                        if ((remoteHostName = request.getParameter("MACHINENAME")) != null && remoteHostName.length() > 60) {
                            remoteHostName = remoteHostName.substring(0, 60);
                        } else if (remoteHostName == null || remoteHostName.length() == 0) {
                            remoteHostName = "";
                        }
                        ExtAuthApplicationBean applicationBean = restapiserviceutility.getCommonDBAccess().getExtAuthApplicationInfo(appId);
                        boolean isAllowLoginAttempts = this.isAllowLoginAttempts(userCode);
                        BaseLogger.log("3", null, null, "ExtAuthAppService >> isAllowLoginAttempts =[" + isAllowLoginAttempts + "]");
                        if (!isAllowLoginAttempts && E12GenericUtility.checkNull(applicationBean.getEnableSecurity()).equalsIgnoreCase("T") && E12GenericUtility.checkNull(applicationBean.getActive()).equalsIgnoreCase("T")) {
                            result = this.getMessage("ExtAuthAppService_maxAllowedLoginAttempts");
                            resultJson.put("status", (Object)"error");
                        } else if (!E12GenericUtility.checkNull(applicationBean.getActive()).equalsIgnoreCase("T")) {
                            result = this.getMessage("ExtAuthAppService_appNotActive");
                            resultJson.put("status", (Object)"error");
                        } else {
                            String authStatus = this.getAuthStatus(request, userCode, password, "", "I", isPwdEncrypt);
                            if ("VALID".equalsIgnoreCase(authStatus)) {
                                restapiserviceutility.getCommonDBAccess().insertSessionTrace(userCode, request.getSession().getId(), true, chgIP, remoteHostName, null);
                                result = this.getMessage("ExtAuthAppService_authenticationSuccessful");
                                String jwt = this.getJWTToken(userCode, applicationBean);
                                if (E12GenericUtility.checkNull(jwt).length() > 0) {
                                    resultJson.put("jwtToken", (Object)jwt);
                                    HttpSession session = request.getSession();
                                    session.setAttribute("tokenId", (Object)jwt);
                                    try {
                                        if ("true".equalsIgnoreCase(isAdminUser)) {
                                            HashMap<String, String> jwtData = CryptographyUtil.parseBase64EncodedJWTToken(jwt, applicationBean.getSharedKey());
                                            UserInfoBean userInfo = restapiserviceutility.createUserInfo(jwtData);
                                            restapiserviceutility.getCommonDBAccess().updateUserAccChannel("P", "", userInfo.getEnterprise(), userInfo.getLoginEmailId(), userInfo.getUserName(), jwt, "Y", userCode, chgIP, userInfo.getLoginCode());
                                        }
                                    }
                                    catch (Exception e) {
                                        BaseLogger.log("0", null, null, "Exception in updateUserAccChannel : [" + e.getMessage() + "]");
                                        e.printStackTrace();
                                    }
                                }
                            } else if (authStatus.equalsIgnoreCase("RESIGNED")) {
                                result = this.getMessage("ExtAuthAppService_employeeHasResigned");
                                resultJson.put("status", (Object)authStatus);
                            } else if (authStatus.equalsIgnoreCase("LOCKED")) {
                                result = this.getMessage("ExtAuthAppService_accountIsLockedContactAdmin");
                                resultJson.put("status", (Object)authStatus);
                            } else if (authStatus.indexOf("PASS_EXP") != -1) {
                                if (authStatus.equalsIgnoreCase("PASS_EXP_GRACE")) {
                                    result = this.getMessage("ExtAuthAppService_passwordExpiredWouldYouLikeToChange");
                                    resultJson.put("status", (Object)authStatus);
                                } else if (authStatus.equalsIgnoreCase("PASS_EXP_NOGRACE")) {
                                    result = this.getMessage("ExtAuthAppService_passwordExpiredChangeIt");
                                    resultJson.put("status", (Object)authStatus);
                                }
                            } else if (authStatus.equalsIgnoreCase("FIRST_LOGIN")) {
                                result = this.getMessage("ExtAuthAppService_compulsoryChangePasswordPleaseDoSo");
                                resultJson.put("status", (Object)authStatus);
                            } else if (authStatus.equalsIgnoreCase("ACCOUNT_LOCKED")) {
                                result = String.valueOf(Messages.getString("AuthenticateServlet_accountIsLocked", this.getUserLangAndCountry(request.getParameter("USER")))) + " " + CommonConstants.WRONG_LOGIN_COUNT + " times. " + Messages.getString("AuthenticateServlet_newPasswordIsSentToYourEmaiID", this.getUserLangAndCountry(request.getParameter("USER"))) + " " + Messages.getString("AuthenticateServlet_accountUnlocked", this.getUserLangAndCountry(request.getParameter("USER")));
                            } else if (authStatus.equalsIgnoreCase("WRONG_LOGIN_COUNT_EXCEED")) {
                                result = String.valueOf(Messages.getString("AuthenticateServlet_passwordBlockedSinceWronglyEntered", this.getUserLangAndCountry(request.getParameter("USER")))) + CommonConstants.WRONG_LOGIN_COUNT + Messages.getString("AuthenticateServlet_newPasswordSentToEmailID", this.getUserLangAndCountry(request.getParameter("USER")));
                            } else if (authStatus.equalsIgnoreCase("INVALID_USR") || authStatus.equalsIgnoreCase("INVALID_PWD")) {
                                restapiserviceutility.getCommonDBAccess().insertSessionTrace(userCode, request.getSession().getId(), false, chgIP, remoteHostName, null);
                                result = this.getMessage("ExtAuthAppService_pleaseEnterValidUserNameAndPassword");
                                resultJson.put("status", (Object)"error");
                            } else {
                                result = this.getMessage("ExtAuthAppService_pleaseLoginSunpharmaMetis");
                                resultJson.put("status", (Object)"error");
                            }
                        }
                    } else {
                        resultJson.put("status", (Object)this.getMessage("ExtAuthAppService_authFail"));
                        result = this.getMessage("ExtAuthAppService_notAuthorized");
                    }
                }
            }
            resultJson.put("results", (Object)result);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception in ExtAuthAppService :: authAPIService : " + e.getMessage());
            e.printStackTrace();
            throw new ITMException(e);
        }
        return resultJson;
    }

    public String updateJWTToken(String tokenId, String appId, String userCode) {
        String result = "";
        String status = "";
        JSONObject resultJson = new JSONObject();
        PreparedStatement psmt = null;
        Connection conn = null;
        ConnDriver connDriver = new ConnDriver();
        CommonDBAccessEJB commonDBAccessEJB = new CommonDBAccessEJB();
        try {
            UserInfoBean userInfo = commonDBAccessEJB.createUserInfo(userCode);
            if (this.apiUtility.checkDailyAPILimit(userInfo)) {
                status = "Reject";
                result = "Daily API call limit exceeded";
            } else {
                userInfo = commonDBAccessEJB.createUserInfo(userCode);
                conn = connDriver.getConnectDB(userInfo.getTransDB());
                String updateTokenIDsql = "UPDATE USER_ACC_CHANNEL SET TOKEN_ID = ? WHERE APP_ID = ?";
                psmt = conn.prepareStatement(updateTokenIDsql);
                psmt.setString(1, tokenId);
                psmt.setString(2, appId);
                int updateCount = psmt.executeUpdate();
                BaseLogger.log("2", userInfo, null, "Update Count :[" + updateCount + "]");
                if (updateCount > 0) {
                    status = "Accept";
                    result = "Sucess";
                }
                resultJson.put("Status", (Object)status);
                resultJson.put("Result", (Object)result);
                psmt.close();
                psmt = null;
                conn.commit();
            }
        }
        catch (BaseException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return resultJson.toString();
    }

    public JSONObject Logout(String jwt, String appId, HttpServletRequest request) throws ITMException {
        String result = "";
        String status = "";
        JSONObject resultJson = new JSONObject();
        try {
            result = this.validateRequest(request);
            if (result.equals("valid")) {
                if (this.userInfo == null) {
                    this.userInfo = this.apiUtility.createUserInfoFromJWTToken(jwt);
                }
                if (this.apiUtility.checkDailyAPILimit(this.userInfo)) {
                    status = "Reject";
                    result = "Daily API call limit exceeded";
                } else {
                    RestAPIServiceUtility restapiserviceutility = new RestAPIServiceUtility();
                    ExtAuthApplicationBean applicationBean = restapiserviceutility.getCommonDBAccess().getExtAuthApplicationInfo(appId);
                    String jwtResult = CryptographyUtil.parseBase64EncodedJWT(jwt, applicationBean.getSharedKey());
                    if (jwtResult.equalsIgnoreCase("expired")) {
                        status = "Reject";
                        result = "Token has been expired";
                        resultJson.put("results", (Object)result);
                    } else if (jwtResult.equalsIgnoreCase("invalid")) {
                        status = "Reject";
                        result = "Invalid Token";
                        resultJson.put("results", (Object)result);
                    } else if (E12GenericUtility.checkNull(jwtResult).length() > 0 && jwtResult.contains("~")) {
                        String[] tokenData = jwtResult.split("~");
                        if (E12GenericUtility.checkNull(tokenData[0]).length() > 0 && E12GenericUtility.checkNull(tokenData[1]).length() > 0) {
                            result = this.logout(tokenData[0], tokenData[1]);
                            if (result.equalsIgnoreCase("User has been logged out.")) {
                                request.getSession().invalidate();
                            }
                        } else {
                            status = "Reject";
                            result = "Invalid Token";
                        }
                        status = "Accept";
                        resultJson.put("results", (Object)result);
                    } else {
                        status = "Reject";
                        result = "Invalid Token";
                    }
                }
            }
            resultJson.put("Status", (Object)status);
            resultJson.put("results", (Object)result);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception in ExtAuthAppService :: logoutAPIService : " + e.getMessage());
            e.printStackTrace();
            throw new ITMException(e);
        }
        return resultJson;
    }

    public JSONObject tokenExchange(String jwtToken, String appId, HttpServletRequest request) throws ITMException {
        String result = "";
        String status = "error";
        JSONObject resultJson = new JSONObject();
        StringBuffer logBuff = new StringBuffer();
        SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
        String defaultFileLoc = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "dump";
        try {
            try {
                logBuff.append("/tokenExchange").append(" ").append(formatter.format(new Date())).append(" ");
                result = this.validateRequest(request);
                if ("valid".equalsIgnoreCase(result)) {
                    if (this.userInfo == null) {
                        this.userInfo = this.apiUtility.createUserInfoFromJWTToken(jwtToken);
                    }
                    if (this.apiUtility.checkDailyAPILimit(this.userInfo)) {
                        status = "Reject";
                        result = "Daily API call limit exceeded";
                    } else {
                        RestAPIServiceUtility restapiserviceutility = new RestAPIServiceUtility();
                        ExtAuthApplicationBean applicationBean = restapiserviceutility.getCommonDBAccess().getExtAuthApplicationInfo(appId);
                        result = restapiserviceutility.validateJWT(jwtToken, appId, applicationBean.getSharedKey());
                        if ("valid".equalsIgnoreCase(result)) {
                            status = "success";
                            result = CryptographyUtil.getShortLivedJWTToken(jwtToken, applicationBean.getSharedKey());
                            if ("invalid".equalsIgnoreCase(result) || "expired".equalsIgnoreCase(result)) {
                                status = "error";
                            }
                        }
                    }
                }
                resultJson.put("status", (Object)status);
                resultJson.put("results", (Object)result);
            }
            catch (Exception e) {
                e.printStackTrace();
                BaseLogger.log("0", null, null, "Exception in getShortLivedJWTToken :: fileWrite : [" + e.getMessage() + "]");
                status = "exception";
                result = "Getting exception (" + e.getMessage() + ") in tokenExchnage.";
                logBuff.append(formatter.format(new Date())).append(" ").append(status).append(" ").append(result);
                BaseLogger.log("3", null, null, "logBuff : [" + logBuff.toString() + "]");
                String fileName = "log_" + new SimpleDateFormat("yyyyMMdd").format(new Date()) + ".txt";
                String fileLoc = String.valueOf(defaultFileLoc) + File.separator + "log";
                new E12GenericUtility().writeFile(fileLoc, fileName, logBuff.toString(), true);
            }
        }
        finally {
            logBuff.append(formatter.format(new Date())).append(" ").append(status).append(" ").append(result);
            BaseLogger.log("3", null, null, "logBuff : [" + logBuff.toString() + "]");
            String fileName = "log_" + new SimpleDateFormat("yyyyMMdd").format(new Date()) + ".txt";
            String fileLoc = String.valueOf(defaultFileLoc) + File.separator + "log";
            new E12GenericUtility().writeFile(fileLoc, fileName, logBuff.toString(), true);
        }
        return resultJson;
    }

    public JSONObject fileWrite(String fileData, String fileDetails, String jwt, String appId, HttpServletRequest request) throws ITMException {
        JSONObject resultJson = new JSONObject();
        String result = "";
        String status = "error";
        StringBuffer logBuff = new StringBuffer();
        SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
        String defaultFileLoc = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "dump";
        try {
            try {
                RestAPIServiceUtility restapiserviceutility;
                logBuff.append("/fileWrite").append(" ").append(formatter.format(new Date())).append(" ");
                result = this.validateRequest(request);
                if ("valid".equalsIgnoreCase(result) && "valid".equalsIgnoreCase(result = (restapiserviceutility = new RestAPIServiceUtility()).validateAppId(request, appId, "fileWrite"))) {
                    if (this.userInfo == null) {
                        this.userInfo = this.apiUtility.createUserInfoFromJWTToken(jwt);
                    }
                    if (this.apiUtility.checkDailyAPILimit(this.userInfo)) {
                        status = "Reject";
                        result = "Daily API call limit exceeded";
                    } else {
                        ExtAuthApplicationBean applicationBean = restapiserviceutility.getCommonDBAccess().getExtAuthApplicationInfo(appId);
                        result = restapiserviceutility.validateJWT(jwt, appId, applicationBean.getSharedKey());
                        if ("valid".equalsIgnoreCase(result)) {
                            String fileName = "";
                            String fileLoc = "";
                            String fileType = "";
                            if ((fileDetails = restapiserviceutility.checkNull(fileDetails)).length() > 0) {
                                try {
                                    JSONObject jsonObj = new JSONObject(fileDetails);
                                    fileName = jsonObj.getString("file_name");
                                    fileLoc = jsonObj.getString("file_loc");
                                    fileType = jsonObj.getString("file_type");
                                }
                                catch (Exception e) {
                                    BaseLogger.log("0", null, null, "Exception : fileWrite JSON parse : [" + e.getMessage() + "]");
                                }
                            }
                            if ((fileName = restapiserviceutility.checkNull(fileName)).length() == 0) {
                                fileName = "" + System.currentTimeMillis();
                            }
                            BaseLogger.log("3", null, null, "fileName [" + fileName + "]");
                            fileLoc = restapiserviceutility.checkNull(fileLoc);
                            if (fileLoc.length() == 0) {
                                SimpleDateFormat dtf = new SimpleDateFormat(CommonConstants.APPL_DATE_FORMAT);
                                fileLoc = dtf.format(new Date());
                            }
                            BaseLogger.log("3", null, null, "fileLoc [" + fileLoc + "]");
                            fileType = restapiserviceutility.checkNull(fileType);
                            if (fileType.length() == 0) {
                                fileType = "txt";
                            }
                            if (!fileLoc.startsWith(File.separator)) {
                                fileLoc = String.valueOf(defaultFileLoc) + File.separator + fileLoc;
                            }
                            BaseLogger.log("3", null, null, "fileType [" + fileType + "]");
                            new E12GenericUtility().writeFile(fileLoc, String.valueOf(fileName) + "." + fileType, fileData);
                            status = "success";
                            JSONObject fileWriteDetailJson = new JSONObject();
                            fileWriteDetailJson.put("file_loc", (Object)fileLoc);
                            fileWriteDetailJson.put("file_name", (Object)(String.valueOf(fileName) + "." + fileType));
                            fileWriteDetailJson.put("response", (Object)"File written successfully");
                            result = fileWriteDetailJson.toString();
                        }
                    }
                }
                resultJson.put("status", (Object)status);
                resultJson.put("results", (Object)result);
            }
            catch (Exception e) {
                e.printStackTrace();
                BaseLogger.log("0", null, null, "Exception in ExtAuthAppService :: fileWrite : [" + e.getMessage() + "]");
                status = "exception";
                result = "Getting exception (" + e.getMessage() + ") while writting file.";
                logBuff.append(formatter.format(new Date())).append(" ").append(status).append(" ").append(result);
                BaseLogger.log("3", null, null, "logBuff : [" + logBuff.toString() + "]");
                String fileName = "log_" + new SimpleDateFormat("yyyyMMdd").format(new Date()) + ".txt";
                String fileLoc = String.valueOf(defaultFileLoc) + File.separator + "log";
                new E12GenericUtility().writeFile(fileLoc, fileName, logBuff.toString(), true);
            }
        }
        finally {
            logBuff.append(formatter.format(new Date())).append(" ").append(status).append(" ").append(result);
            BaseLogger.log("3", null, null, "logBuff : [" + logBuff.toString() + "]");
            String fileName = "log_" + new SimpleDateFormat("yyyyMMdd").format(new Date()) + ".txt";
            String fileLoc = String.valueOf(defaultFileLoc) + File.separator + "log";
            new E12GenericUtility().writeFile(fileLoc, fileName, logBuff.toString(), true);
        }
        return resultJson;
    }

    public JSONObject writeFileObject(HttpServletRequest request) throws ITMException {
        String result = "";
        String status = "error";
        JSONObject resultJson = new JSONObject();
        StringBuffer logBuff = new StringBuffer();
        SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
        String defaultFileLoc = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "dump";
        try {
            try {
                ExtAuthApplicationBean applicationBean;
                String jwt;
                String appId;
                RestAPIServiceUtility restapiserviceutility;
                logBuff.append("/writeFileObject").append(" ").append(formatter.format(new Date())).append(" ");
                HashMap<String, Object> reqDataMap = this.getFileItemData(request);
                result = this.validateRequest(request);
                if ("valid".equalsIgnoreCase(result) && "valid".equalsIgnoreCase(result = (restapiserviceutility = new RestAPIServiceUtility()).validateAppId(request, appId = (String)reqDataMap.get("APP_ID"), "writeFileObject")) && "valid".equalsIgnoreCase(result = restapiserviceutility.validateJWT(jwt = (String)reqDataMap.get("JWT"), appId, (applicationBean = restapiserviceutility.getCommonDBAccess().getExtAuthApplicationInfo(appId)).getSharedKey()))) {
                    String fileName = "";
                    String fileLoc = "";
                    String fileType = "";
                    String fileDetails = restapiserviceutility.checkNull((String)reqDataMap.get("fileDetails"));
                    if (fileDetails.length() > 0) {
                        try {
                            JSONObject jsonObj = new JSONObject(fileDetails);
                            fileName = jsonObj.getString("file_name");
                            fileLoc = jsonObj.getString("file_loc");
                            fileType = jsonObj.getString("file_type");
                        }
                        catch (Exception e) {
                            BaseLogger.log("0", null, null, "Exception : fileWrite JSON parse : [" + e.getMessage() + "]");
                        }
                    }
                    FileItem fileItem = (FileItem)reqDataMap.get("file");
                    if ((fileType = restapiserviceutility.checkNull(fileType)).length() == 0) {
                        fileType = "txt";
                    }
                    BaseLogger.log("3", null, null, "fileType [" + fileType + "]");
                    fileName = restapiserviceutility.checkNull(fileName);
                    fileName = fileName.length() == 0 ? fileItem.getName() : String.valueOf(fileName) + "." + fileType;
                    BaseLogger.log("3", null, null, "fileName [" + fileName + "]");
                    fileLoc = restapiserviceutility.checkNull(fileLoc);
                    if (fileLoc.length() == 0) {
                        SimpleDateFormat dtf = new SimpleDateFormat(CommonConstants.APPL_DATE_FORMAT);
                        fileLoc = dtf.format(new Date());
                    }
                    BaseLogger.log("3", null, null, "fileLoc [" + fileLoc + "]");
                    if (!fileLoc.startsWith(File.separator)) {
                        fileLoc = String.valueOf(defaultFileLoc) + File.separator + fileLoc;
                    }
                    status = "success";
                    result = this.createFileObject(fileItem, fileLoc, fileName);
                }
                resultJson.put("status", (Object)status);
                resultJson.put("results", (Object)result);
            }
            catch (Exception e) {
                e.printStackTrace();
                BaseLogger.log("0", null, null, "Exception :: writeFileObject : [" + e.getMessage() + "]");
                status = "exception";
                result = "Getting exception (" + e.getMessage() + ") while writting file.";
                logBuff.append(formatter.format(new Date())).append(" ").append(status).append(" ").append(result);
                BaseLogger.log("3", null, null, "logBuff : [" + logBuff.toString() + "]");
                String fileName = "log_" + new SimpleDateFormat("yyyyMMdd").format(new Date()) + ".txt";
                String fileLoc = String.valueOf(defaultFileLoc) + File.separator + "log";
                new E12GenericUtility().writeFile(fileLoc, fileName, logBuff.toString(), true);
            }
        }
        finally {
            logBuff.append(formatter.format(new Date())).append(" ").append(status).append(" ").append(result);
            BaseLogger.log("3", null, null, "logBuff : [" + logBuff.toString() + "]");
            String fileName = "log_" + new SimpleDateFormat("yyyyMMdd").format(new Date()) + ".txt";
            String fileLoc = String.valueOf(defaultFileLoc) + File.separator + "log";
            new E12GenericUtility().writeFile(fileLoc, fileName, logBuff.toString(), true);
        }
        return resultJson;
    }

    private String validateRequest(HttpServletRequest request) {
        String validStr = "valid";
        return validStr;
    }

    protected boolean isAllowLoginAttempts(String userCode) {
        boolean isAllowed = true;
        try {
            RestAPIServiceUtility restapiserviceutility = new RestAPIServiceUtility();
            isAllowed = restapiserviceutility.getCommonDBAccess().checkLoginAttempts(userCode);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception in ExtAuthAppService :: isAllowLoginAttempts() : " + e.getMessage());
        }
        return isAllowed;
    }

    public String getMessage(String key) {
        ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("ibase.webitm.utility.messages");
        try {
            return RESOURCE_BUNDLE.getString(key);
        }
        catch (MissingResourceException e) {
            return String.valueOf('!') + key + '!';
        }
    }

    private String getAuthStatus(HttpServletRequest request, String userCode, String password, String siteCode, String authMode, String isSHA256Appld) throws Exception, BaseException {
        String authStatus = "false";
        try {
            String xmlInfo = "";
            RestAPIServiceUtility restapiserviceutility = new RestAPIServiceUtility();
            if (restapiserviceutility.getCommonDBAccess() != null) {
                xmlInfo = restapiserviceutility.getCommonDBAccess().authenticate(userCode, password, siteCode, authMode, isSHA256Appld, request);
                BaseLogger.log("3", null, null, "xmlInfo - [" + xmlInfo + "]");
                authStatus = this.generateResponse(xmlInfo);
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception in ExtAuthAppService : getAuthStatus: " + e.getMessage());
            throw new BaseException(e);
        }
        BaseLogger.log("2", null, null, "isValidLogin - [" + authStatus + "]");
        return authStatus;
    }

    private String generateResponse(String xmlInfo) throws BaseException {
        BaseLogger.log("2", null, null, "Generating Response....");
        String responseString = "";
        try {
            Document document;
            if (E12GenericUtility.checkNull(xmlInfo).length() > 0 && (document = this.genericUtility.parseString(xmlInfo)).getElementsByTagName("STATUS_CODE").item(0) != null && document.getElementsByTagName("STATUS_CODE").item(0).getFirstChild() != null) {
                String statusCode;
                responseString = statusCode = document.getElementsByTagName("STATUS_CODE").item(0).getFirstChild().getNodeValue();
                if (statusCode.equalsIgnoreCase("VALID") && document.getElementsByTagName("SITE_CODE").item(0) != null) {
                    String siteCodeValue = document.getElementsByTagName("SITE_CODE").item(0).getFirstChild().getNodeValue();
                    if (siteCodeValue.equalsIgnoreCase("INVALID_SITE")) {
                        responseString = "INVALID_SITE";
                    } else if (siteCodeValue.equalsIgnoreCase("INACCESSIBLE_SITE")) {
                        responseString = "INACCESSIBLE_SITE";
                    }
                }
            }
        }
        catch (BaseException be) {
            BaseLogger.log("0", null, null, "Exception in ExtAuthAppService: generateResponse:==>" + be);
            throw be;
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception in ExtAuthAppService: generateResponse:==>" + e);
            throw new BaseException(e);
        }
        BaseLogger.log("2", null, null, "responseString - [" + responseString + "]");
        return responseString;
    }

    protected String getJWTToken(String userCode, ExtAuthApplicationBean applicationBean) throws BaseException, Exception {
        BaseLogger.log("2", null, null, "ExtAuthAppService :: getJWTToken");
        RestAPIServiceUtility restapiserviceutility = new RestAPIServiceUtility();
        ExtAuthRespBean userBean = restapiserviceutility.getCommonDBAccess().getExtAuthRespBean(userCode);
        String jwtToken = CryptographyUtil.createBase64EncodedJWT(applicationBean, userBean, "");
        BaseLogger.log("2", null, null, "ExtAuthAppService :: getJWTToken: jwtToken : [" + jwtToken + "]");
        return jwtToken;
    }

    private ArrayList<String> getUserLangAndCountry(String userCode) {
        ArrayList<String> langAndCountryList = new ArrayList<String>();
        try {
            RestAPIServiceUtility restapiserviceutility = new RestAPIServiceUtility();
            String userLanguage = restapiserviceutility.getCommonDBAccess().getDBColumnValue("USERS", "USER_LANG", "WHERE CODE = '" + userCode + "'");
            String userCountry = restapiserviceutility.getCommonDBAccess().getDBColumnValue("USERS", "USER_COUNTRY", "WHERE CODE = '" + userCode + "'");
            if (userLanguage != null && userCountry != null) {
                langAndCountryList.add(userLanguage);
                langAndCountryList.add(userCountry);
            }
            BaseLogger.log("3", null, null, "User Language[" + userLanguage + "], User Country[" + userCountry + "], List[" + langAndCountryList.toString() + "]");
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :: while accessing user country and user language from database. ");
            e.printStackTrace();
        }
        return langAndCountryList;
    }

    private HashMap<String, Object> getFileItemData(HttpServletRequest request) {
        HashMap<String, Object> reqDataMap = new HashMap<String, Object>();
        try {
            if (ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
                int MEMORY_THRESHOLD = 0x300000;
                int MAX_FILE_SIZE = 734003200;
                int MAX_REQUEST_SIZE = 744488960;
                DiskFileItemFactory factory = new DiskFileItemFactory();
                factory.setSizeThreshold(MEMORY_THRESHOLD);
                factory.setRepository(new File(System.getProperty("java.io.tmpdir")));
                ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
                upload.setFileSizeMax((long)MAX_FILE_SIZE);
                upload.setSizeMax((long)MAX_REQUEST_SIZE);
                List formItems = upload.parseRequest(request);
                if (formItems != null && formItems.size() > 0) {
                    for (FileItem item : formItems) {
                        String fieldName = item.getFieldName();
                        if (item.isFormField()) {
                            RestAPIServiceUtility restapiserviceutility = new RestAPIServiceUtility();
                            reqDataMap.put(fieldName, restapiserviceutility.checkNull(item.getString()));
                            continue;
                        }
                        reqDataMap.put(fieldName, item);
                    }
                }
            }
        }
        catch (FileUploadException e) {
            e.printStackTrace();
            BaseLogger.log("0", null, null, "FileUploadException :: FileUploadException : [" + e.getMessage() + "]");
        }
        return reqDataMap;
    }

    private String createFileObject(FileItem fileItem, String fileLoc, String fileName) throws ITMException {
        String result = "";
        try {
            File fileDir = new File(fileLoc);
            if (!fileDir.exists()) {
                fileDir.mkdirs();
                BaseLogger.log("3", null, null, "New Directory Created");
            }
            String newfilePath = String.valueOf(fileLoc) + File.separator + fileName;
            File storeFile = new File(newfilePath);
            fileItem.write(storeFile);
            JSONObject fileWriteDetailJson = new JSONObject();
            fileWriteDetailJson.put("file_loc", (Object)fileLoc);
            fileWriteDetailJson.put("file_name", (Object)fileName);
            fileWriteDetailJson.put("response", (Object)"File object written successfully");
            result = fileWriteDetailJson.toString();
        }
        catch (FileUploadException e) {
            e.printStackTrace();
            BaseLogger.log("0", null, null, "FileUploadException :: createFileObject : [" + e.getMessage() + "]");
            throw new ITMException((Exception)((Object)e));
        }
        catch (Exception e) {
            e.printStackTrace();
            BaseLogger.log("0", null, null, "Exception :: createFileObject : [" + e.getMessage() + "]");
            throw new ITMException(e);
        }
        return result;
    }

    private String logout(String userCode, String sessionId) throws BaseException {
        String result = "";
        try {
            String islogout = this.isLogout(userCode, sessionId);
            if (E12GenericUtility.checkNull(islogout).length() > 0) {
                result = "User has been already logged out.";
            } else {
                EventLogInfoBean eventInfoBean = new EventLogInfoBean(userCode);
                eventInfoBean.removeSessionActivity(sessionId);
                RestAPIServiceUtility restapiserviceutility = new RestAPIServiceUtility();
                restapiserviceutility.getCommonDBAccess().updateSessionTrace(userCode, sessionId);
                result = "User has been logged out.";
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception in ExtAuthAppService :: logout : " + e.getMessage());
            e.printStackTrace();
        }
        return result;
    }

    private String isLogout(String userCode, String sessionId) throws BaseException {
        String isLogout = "";
        try {
            RestAPIServiceUtility restapiserviceutility = new RestAPIServiceUtility();
            isLogout = restapiserviceutility.getCommonDBAccess().getLoginStatus(userCode, sessionId);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception in ExtAuthAppService :: logout : " + e.getMessage());
            e.printStackTrace();
        }
        return isLogout;
    }
}

