/*
 * Decompiled with CFR 0.152.
 */
package ibase.utility;

import com.opencsv.CSVWriter;
import ibase.utility.Event;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.io.FilenameUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class CSVConverter {
    public static void txtToXML() {
        File[] files;
        File directory = new File("/wildfly/server/default/UserActivity");
        File[] fileArray = files = directory.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.getName().endsWith(".txt")) {
                try {
                    String content = new String(Files.readAllBytes(file.toPath()));
                    content = "<root>" + content + "</root>";
                    String fileNameWithoutExt = FilenameUtils.removeExtension((String)file.getName());
                    File newFile = new File(directory, String.valueOf(fileNameWithoutExt) + ".xml");
                    Files.write(newFile.toPath(), content.getBytes(), new OpenOption[0]);
                    file.delete();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
    }

    public static void XML2XLSX(String XMLfilepath, String XLSXfilepath) {
        ArrayList<Event> eventArrayList = new ArrayList<Event>();
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            if (!XMLfilepath.contains(".xml")) {
                return;
            }
            Document doc = docBuilder.parse(new File(XMLfilepath));
            doc.getDocumentElement().normalize();
            System.out.println("Root element of the doc is :\" " + doc.getDocumentElement().getNodeName() + "\"");
            NodeList activitiesList = doc.getElementsByTagName("ACTIVITY");
            int totalActivities = activitiesList.getLength();
            System.out.println("Total no of ACTIVITY : " + totalActivities);
            int al = 0;
            while (al < activitiesList.getLength()) {
                Element activityNode = (Element)activitiesList.item(al);
                String USER_ID = activityNode.getAttributes().getNamedItem("USER_ID").getNodeValue();
                String ACTIVITY_OBJECT = CSVConverter.getNodeValue(activityNode, "ACTIVITY_OBJECT");
                String ACTIVITY_SESSION_ID = CSVConverter.getNodeValue(activityNode, "ACTIVITY_SESSION_ID");
                String ACTIVITY_TITLE = CSVConverter.getNodeValue(activityNode, "ACTIVITY_TITLE");
                String ACTIVITY_ICON = CSVConverter.getNodeValue(activityNode, "ACTIVITY_ICON");
                NodeList activityActionsList = activityNode.getElementsByTagName("ACTIVITY_ACTION");
                int aal = 0;
                while (aal < activityActionsList.getLength()) {
                    Element activityAction = (Element)activityActionsList.item(aal);
                    String ACTIVITY_DESCRP = CSVConverter.getNodeValue(activityAction, "ACTIVITY_DESCRP");
                    String EVENT_INFO = CSVConverter.getNodeValue(activityAction, "EVENT_INFO");
                    String ACTION_TYPE = CSVConverter.getNodeValue(activityAction, "ACTION_TYPE");
                    String ACTIVITY_EDITOR = CSVConverter.getNodeValue(activityAction, "ACTIVITY_EDITOR");
                    NodeList eventList = activityAction.getElementsByTagName("EVENT_ID");
                    int el = 0;
                    while (el < eventList.getLength()) {
                        Element event = (Element)eventList.item(el);
                        String EVENT_ID = event.getAttributes().getNamedItem("id").getNodeValue();
                        String EVENT_DESCRP = CSVConverter.getNodeValue(event, "EVENT_DESCRP");
                        String DB_NAME = CSVConverter.getNodeValue(event, "DB_NAME");
                        String FORM_NO = CSVConverter.getNodeValue(event, "FORM_NO");
                        String ARG_PARAM = CSVConverter.getNodeValue(event, "ARG_PARAM");
                        String ACCESS_START_TIME = CSVConverter.getNodeValue(event, "ACCESS_START_TIME");
                        String ACCESS_END_TIME = CSVConverter.getNodeValue(event, "ACCESS_END_TIME");
                        String PRIMARY_KEY = CSVConverter.getNodeValue(event, "PRIMARY_KEY");
                        String EXCEPTION_MSG = CSVConverter.getNodeValue(event, "EXCEPTION_MSG");
                        String EVENT_RESULT = CSVConverter.getNodeValue(event, "EVENT_RESULT");
                        Event eventObj = new Event();
                        eventObj.setACCESS_END_TIME(ACCESS_END_TIME);
                        eventObj.setACCESS_START_TIME(ACCESS_START_TIME);
                        eventObj.setACTION_TYPE(ACTION_TYPE);
                        eventObj.setACTIVITY(ACTIVITY_EDITOR);
                        eventObj.setACTIVITY_DESCRP(ACTIVITY_DESCRP);
                        eventObj.setACTIVITY_EDITOR(ACTIVITY_EDITOR);
                        eventObj.setACTIVITY_SESSION_ID(ACTIVITY_SESSION_ID);
                        eventObj.setACTIVITY_TITLE(ACTIVITY_TITLE);
                        eventObj.setARG_PARAM(ARG_PARAM);
                        eventObj.setDB_NAME(DB_NAME);
                        eventObj.setEVENT_DESCRP(EVENT_DESCRP);
                        eventObj.setEVENT_ID(EVENT_ID);
                        eventObj.setEVENT_RESULT(EVENT_RESULT);
                        eventObj.setEXCEPTION_MSG(EXCEPTION_MSG);
                        eventObj.setFORM_NO(FORM_NO);
                        eventObj.setPRIMARY_KEY(PRIMARY_KEY);
                        eventObj.setUSER_ID(USER_ID);
                        eventObj.setUSER_ID(USER_ID);
                        eventObj.setACTIVITY_ICON(ACTIVITY_ICON);
                        eventObj.setACTIVITY_OBJECT(ACTIVITY_OBJECT);
                        eventObj.setEVENT_INFO(EVENT_INFO);
                        eventArrayList.add(eventObj);
                        ++el;
                    }
                    ++aal;
                }
                ++al;
            }
        }
        catch (SAXParseException err) {
            System.out.println("** Parsing error, line " + err.getLineNumber() + ", uri " + err.getSystemId());
            System.out.println(" " + err.getMessage());
        }
        catch (SAXException e) {
            Exception x = e.getException();
            (x == null ? e : x).printStackTrace();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        try {
            System.out.println("eventArrayList.size() " + eventArrayList.size());
            XSSFWorkbook workbook = new XSSFWorkbook();
            XSSFSheet sheet = workbook.createSheet("Sample sheet");
            XSSFRow headerRow = sheet.createRow(0);
            headerRow.createCell(0).setCellValue("root");
            headerRow.createCell(1).setCellValue("ACTIVITY");
            headerRow.createCell(2).setCellValue("USER_ID");
            headerRow.createCell(3).setCellValue("ACTIVITY_ICON");
            headerRow.createCell(4).setCellValue("ACTIVITY_OBJECT");
            headerRow.createCell(5).setCellValue("ACTIVITY_SESSION_ID");
            headerRow.createCell(6).setCellValue("ACTIVITY_TITLE");
            headerRow.createCell(7).setCellValue("ACTIVITY_ACTION");
            headerRow.createCell(8).setCellValue("ACTIVITY_DESCRP");
            headerRow.createCell(9).setCellValue("ACTION_TYPE");
            headerRow.createCell(10).setCellValue("ACTIVITY_EDITOR");
            headerRow.createCell(11).setCellValue("EVENT_ID");
            headerRow.createCell(12).setCellValue("id");
            headerRow.createCell(13).setCellValue("EVENT_DESCRP");
            headerRow.createCell(14).setCellValue("DB_NAME");
            headerRow.createCell(15).setCellValue("FORM_NO");
            headerRow.createCell(16).setCellValue("ARG_PARAM");
            headerRow.createCell(17).setCellValue("ACCESS_START_TIME");
            headerRow.createCell(18).setCellValue("ACCESS_END_TIME");
            headerRow.createCell(19).setCellValue("PRIMARY_KEY");
            headerRow.createCell(20).setCellValue("EXCEPTION_MSG");
            headerRow.createCell(21).setCellValue("EVENT_RESULT");
            headerRow.createCell(22).setCellValue("DB_NAME");
            headerRow.createCell(23).setCellValue("EVENT_INFO");
            headerRow.createCell(24).setCellValue("root");
            XSSFFont headerFont = workbook.createFont();
            headerFont.setBold(true);
            XSSFCellStyle headerCellStyle = workbook.createCellStyle();
            headerCellStyle.setFont((Font)headerFont);
            for (Cell cell : headerRow) {
                cell.setCellStyle((CellStyle)headerCellStyle);
            }
            int rownum = 1;
            int i = 0;
            while (i < eventArrayList.size()) {
                Event eventObj = (Event)eventArrayList.get(i);
                XSSFRow row = sheet.createRow(rownum++);
                row.createCell(1).setCellValue(eventObj.getACTIVITY());
                row.createCell(2).setCellValue(eventObj.getUSER_ID());
                row.createCell(3).setCellValue(eventObj.getACTIVITY_ICON());
                row.createCell(4).setCellValue(eventObj.getACTIVITY_OBJECT());
                row.createCell(5).setCellValue(eventObj.getACTIVITY_SESSION_ID());
                row.createCell(6).setCellValue(eventObj.getACTIVITY_TITLE());
                row.createCell(7).setCellValue(eventObj.getACTIVITY_ACTION());
                row.createCell(8).setCellValue(eventObj.getACTIVITY_DESCRP());
                row.createCell(9).setCellValue(eventObj.getACTION_TYPE());
                row.createCell(10).setCellValue(eventObj.getACTIVITY_EDITOR());
                row.createCell(11).setCellValue("");
                row.createCell(12).setCellValue(eventObj.getEVENT_ID());
                row.createCell(13).setCellValue(eventObj.getEVENT_DESCRP());
                row.createCell(14).setCellValue(eventObj.getDB_NAME());
                row.createCell(15).setCellValue(eventObj.getFORM_NO());
                row.createCell(16).setCellValue(eventObj.getARG_PARAM());
                row.createCell(17).setCellValue(eventObj.getACCESS_START_TIME());
                row.createCell(18).setCellValue(eventObj.getACCESS_END_TIME());
                row.createCell(19).setCellValue(eventObj.getPRIMARY_KEY());
                row.createCell(20).setCellValue(eventObj.getEXCEPTION_MSG());
                row.createCell(21).setCellValue(eventObj.getEVENT_RESULT());
                row.createCell(22).setCellValue(eventObj.getDB_NAME());
                row.createCell(23).setCellValue(eventObj.getEVENT_INFO());
                ++i;
            }
            FileOutputStream out = new FileOutputStream(new File(XLSXfilepath));
            workbook.write((OutputStream)out);
            out.close();
            workbook.close();
            System.out.println("xlsx written successfully..");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void convertxlsx2csv(String xlsxFilePath, String csvFilePath) throws IOException {
        FileInputStream input = new FileInputStream(new File(xlsxFilePath));
        XSSFWorkbook workbook = new XSSFWorkbook((InputStream)input);
        XSSFSheet sheet = workbook.getSheetAt(0);
        CSVWriter writer = new CSVWriter((Writer)new FileWriter(csvFilePath));
        for (Row row : sheet) {
            String[] rowData = new String[row.getLastCellNum() - 2];
            int i = 0;
            int j = 1;
            while (j < row.getLastCellNum() - 1) {
                Cell cell = row.getCell(j);
                rowData[i++] = cell.getStringCellValue();
                ++j;
            }
            writer.writeNext(rowData);
        }
        writer.close();
        workbook.close();
    }

    public static void txt2csv() {
        File[] XLSXfiles;
        CSVConverter.txtToXML();
        File XMLdirectory = new File("/wildfly/server/default/UserActivity");
        File[] XMLfiles = XMLdirectory.listFiles();
        File XLSXdirectory = new File("/wildfly/server/default/UserActivity/ConvertedXLSX");
        if (!XLSXdirectory.exists()) {
            XLSXdirectory.mkdir();
        }
        File[] fileArray = XMLfiles;
        int n = XMLfiles.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            String xmlFilePath = file.getAbsolutePath();
            String xlsxFilePath = "/wildfly/server/default/UserActivity/ConvertedXLSX/" + file.getName().replace(".xml", "") + ".xlsx";
            System.out.println("xmlFilePath:: " + xmlFilePath);
            System.out.println("xlsxFilePath:: " + xlsxFilePath);
            CSVConverter.XML2XLSX(xmlFilePath, xlsxFilePath);
            ++n2;
        }
        File CSVDirectory = new File("/wildfly/server/default/UserActivityCSV");
        if (!CSVDirectory.exists()) {
            CSVDirectory.mkdir();
        }
        File[] fileArray2 = XLSXfiles = XLSXdirectory.listFiles();
        int n3 = XLSXfiles.length;
        int n4 = 0;
        while (n4 < n3) {
            File file = fileArray2[n4];
            String xlsxFilePath = file.getAbsolutePath();
            String csvFilePath = "/wildfly/server/default/UserActivityCSV/" + file.getName().replace(".xlsx", "") + ".csv";
            System.out.println("xlsxFilePath:: " + xlsxFilePath);
            System.out.println("csvFilePath:: " + csvFilePath);
            try {
                CSVConverter.convertxlsx2csv(xlsxFilePath, csvFilePath);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++n4;
        }
    }

    private static String getNodeValue(Element element, String fieldName) {
        String nodeValue = "";
        try {
            if (element.getElementsByTagName(fieldName).item(0) != null) {
                nodeValue = element.getElementsByTagName(fieldName).item(0).getTextContent();
            }
            System.out.println("getNodeValue: " + fieldName + " [" + nodeValue + "]");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return nodeValue;
    }
}

