/*
 * Decompiled with CFR 0.152.
 */
package ibase.bi.common.scheduler;

import ibase.bi.common.scheduler.Listener;
import ibase.bi.common.scheduler.MyTimerMBean;
import ibase.bi.utility.BIException;
import ibase.utility.BaseLogger;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.timer.TimerNotification;
import org.jboss.util.ServiceMBeanSupport;

public class MyTimer
extends ServiceMBeanSupport
implements MyTimerMBean {
    private MBeanServer server;
    private ObjectName timer;
    private long timeout;
    private Object timeoutTimer;
    private Listener listener;

    @Override
    public void init() throws MalformedObjectNameException, InstanceNotFoundException {
        Set<ObjectInstance> mbeans = this.server.queryMBeans(new ObjectName("DefaultDomain", "service", "timer"), null);
        if (!mbeans.isEmpty()) {
            this.timer = mbeans.iterator().next().getObjectName();
        } else {
            BaseLogger.log("3", null, null, "No TimerMBean found.");
        }
    }

    @Override
    public void start(String name, HashMap mailList, Date startDate) throws InstanceNotFoundException, MBeanException, ReflectionException {
        try {
            this.listener = new Listener();
            this.server.addNotificationListener(this.timer, this.listener, (NotificationFilter)new Filter(), (Object)mailList);
            BaseLogger.log("3", null, null, "interval is :" + this.timeout);
            Object[] objectArray = new Object[6];
            objectArray[0] = name;
            objectArray[1] = "";
            objectArray[3] = startDate;
            objectArray[4] = new Long(this.timeout);
            objectArray[5] = new Long(0L);
            this.timeoutTimer = this.server.invoke(this.timer, "addNotification", objectArray, new String[]{String.class.getName(), String.class.getName(), "java.lang.Object", "java.util.Date", Long.TYPE.getName(), Long.TYPE.getName()});
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
        }
    }

    @Override
    public void stop(String name) throws Exception {
        try {
            this.server.removeNotificationListener(this.timer, this.listener);
            this.server.invoke(this.timer, "removeNotifications", new Object[]{name}, new String[]{"java.lang.String"});
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public void setTimeout(long seconds) throws Exception {
        try {
            this.timeout = seconds;
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public long getTimeout() throws Exception {
        try {
            return this.timeout;
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    public String getName() {
        return "MyTimer";
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        try {
            this.server = server;
            BaseLogger.log("3", null, null, "objectName in preregister: " + name);
            return super.preRegister(server, name);
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    class Filter
    implements NotificationFilter {
        Filter() {
        }

        @Override
        public boolean isNotificationEnabled(Notification pNotification) {
            try {
                if (pNotification instanceof TimerNotification) {
                    TimerNotification lTimerNotification = (TimerNotification)pNotification;
                    return lTimerNotification.getNotificationID().equals(MyTimer.this.timeoutTimer);
                }
                return false;
            }
            catch (Exception e) {
                BIException.setErrorCode(0);
                e.printStackTrace();
                return false;
            }
        }
    }
}

