/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.bean;

import ibase.system.config.AppConnectParm;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.bean.ITMFilterModel;
import ibase.webitm.bean.ITMTransactionModel;
import ibase.webitm.bean.Messages;
import ibase.webitm.ejb.MasterDataEJB;
import ibase.webitm.ejb.XSLBuilderEJB;
import ibase.webitm.utility.ITMException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;
import javax.naming.InitialContext;

public class ITMTransactionHeaderModel
extends ITMTransactionModel
implements Serializable {
    private UserInfoBean userInfo = null;
    private String objName = "";
    private String titleName = "";
    private ArrayList pkNamesList = null;
    private ArrayList pkTypesList = null;
    private ArrayList pkValuesList = null;
    private int viewOpt = 0;
    private ITMFilterModel itmFilterModel = null;
    private String userLang = "en";
    private String userCountry = "US";
    private String editor = "WebEditor";

    public String getEditor() {
        return this.editor;
    }

    public void setEditor(String editor) {
        this.editor = editor;
    }

    public ITMTransactionHeaderModel() {
        this(null, null);
    }

    public ITMTransactionHeaderModel(String objName) {
        this(objName, null);
    }

    public ITMTransactionHeaderModel(String objName, String xmlString) {
        this.objName = objName;
    }

    @Override
    public void setUserInfo(UserInfoBean userInfo) {
        this.userInfo = userInfo;
    }

    @Override
    public UserInfoBean getUserInfo() {
        return this.userInfo;
    }

    @Override
    public void setObjName(String objName) throws ITMException {
        try {
            this.objName = objName;
            if (this.userInfo == null) {
                throw new Exception("Invalid Session");
            }
            this.itmFilterModel = new ITMFilterModel(objName, this.userInfo);
        }
        catch (ITMException itme) {
            throw itme;
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
    }

    @Override
    public String getObjName() {
        return this.objName;
    }

    public void setTitleName(String titleName) {
        this.titleName = titleName;
    }

    public String getTitleName() {
        return this.titleName;
    }

    public int getViewOpt() {
        return this.viewOpt;
    }

    @Override
    public ITMFilterModel getITMFilterModel() {
        return this.itmFilterModel;
    }

    public void setUserLang(String userLang) {
        this.userLang = userLang;
    }

    public String getUserLang() {
        return this.userLang;
    }

    public void setUserCountry(String userCountry) {
        this.userCountry = userCountry;
    }

    public String getUserCountry() {
        return this.userCountry;
    }

    public String getHTMLData() throws ITMException {
        String retHTMLStr = "";
        try {
            String xslFileName = this.getXSLFileName();
            String xmlData = this.getXMLData();
            if (xmlData != null && xmlData.length() > 0) {
                String targetDir = String.valueOf(CommonConstants.APPLICATION_CONTEXT) + File.separator + "temp";
                retHTMLStr = new E12GenericUtility().transformToString(xslFileName, xmlData, targetDir, "Output", ".html");
            }
        }
        catch (ITMException itme) {
            throw itme;
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return retHTMLStr;
    }

    public String getXMLData() throws ITMException {
        String retXMLStr = null;
        try {
            if (this.userInfo != null) {
                InitialContext ctx = new InitialContext(new AppConnectParm().getProperty());
                MasterDataEJB masterDataEJB = new MasterDataEJB();
                String formalFilterNames = this.itmFilterModel.getFormalFilterNamesString();
                String formalFilterValues = this.itmFilterModel.getFormalFilterValuesString();
                String formalFilterTypes = this.itmFilterModel.getFormalFilterTypesString();
                if (formalFilterNames == null || formalFilterNames.length() == 0 || formalFilterNames != null && formalFilterNames.length() > 0 && formalFilterValues != null && formalFilterValues.length() > 0) {
                    retXMLStr = masterDataEJB.getXMLFromDBForBrow(this.objName, "1", "1", formalFilterValues, formalFilterTypes, this.itmFilterModel.getUserFilterValuesString(), this.userInfo, true);
                }
                Object var3_5 = null;
            } else {
                retXMLStr = Messages.getString("ITMTransactionHeaderModel_userInfoNotInSession");
            }
        }
        catch (ITMException itme) {
            throw itme;
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return retXMLStr;
    }

    private String getXSLFileName() throws ITMException {
        String retFileName = null;
        try {
            String defaultPath = null;
            String fileName = String.valueOf(this.objName) + "11" + "_" + this.userLang + "_" + this.userCountry + "_" + "V.xsl";
            HashMap<String, String> propEditorInfoMap = new HashMap<String, String>();
            if (this.userInfo != null) {
                propEditorInfoMap.put("PROFILE_ID_RES", this.userInfo.getProfileIdRes());
                propEditorInfoMap.put("ENTERPRISE_ID_RES", this.userInfo.getEnterprise());
                propEditorInfoMap.put("USER_ID", this.userInfo.getLoginCode());
            }
            propEditorInfoMap.put("EDITOR", this.getEditor());
            defaultPath = new E12GenericUtility().getWebEditorXslPath(propEditorInfoMap, this.userInfo.getTransDB());
            File xslFile = new File(defaultPath, fileName);
            if (xslFile.exists()) {
                retFileName = xslFile.getAbsolutePath();
            } else {
                AppConnectParm appConnect = new AppConnectParm();
                Properties p = appConnect.getProperty();
                InitialContext ctx = new InitialContext(p);
                XSLBuilderEJB xslBuilderEJB = new XSLBuilderEJB();
                String xslString = "";
                String transDB = "";
                String profileId = "";
                String profileIdRes = "";
                if (this.userInfo != null) {
                    transDB = this.userInfo.getTransDB();
                    profileId = this.userInfo.getProfileId();
                    profileIdRes = this.userInfo.getProfileIdRes();
                }
                String propertyEditorDtl = String.valueOf(profileIdRes) + "~~SEP~~" + this.getEditor();
                xslString = transDB != null && !"null".equalsIgnoreCase(transDB) && transDB.trim().length() > 0 ? xslBuilderEJB.buildXSLString(this.objName, "1", this.userLang, this.userCountry, "1", "V", CommonConstants.APPLICATION_CONTEXT, propertyEditorDtl, this.userInfo) : xslBuilderEJB.buildXSLString(this.objName, "1", this.userLang, this.userCountry, "1", "V", CommonConstants.APPLICATION_CONTEXT, propEditorInfoMap, this.userInfo);
                if (!xslString.endsWith(".xsl")) {
                    byte[] buffer = xslString.getBytes();
                    int bytes = buffer.length;
                    FileOutputStream fos = new FileOutputStream(xslFile);
                    fos.write(buffer, 0, bytes);
                    fos.flush();
                    fos.close();
                    fos = null;
                    retFileName = xslFile.getAbsolutePath();
                } else {
                    retFileName = xslString;
                }
                xslBuilderEJB = null;
            }
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return retFileName;
    }

    public String getDisplayMsg(String language, String objName) {
        String message = null;
        String currentLine = null;
        try {
            Locale curLocale = new Locale(language);
            String msgFileURL = String.valueOf(CommonConstants.APPLICATION_CONTEXT) + File.separator + "setting" + File.separator + "CustomMessage" + "_" + curLocale + ".properties";
            File msgFile = new File(msgFileURL);
            if (msgFile.exists()) {
                message = Messages.getString("ITMTransactionHeaderModel_noDataFound");
                BufferedReader inputFile = new BufferedReader(new FileReader(msgFile));
                boolean isObjName = false;
                while ((currentLine = inputFile.readLine()) != null) {
                    String vName = currentLine.substring(0, currentLine.indexOf("="));
                    if (objName.trim().equalsIgnoreCase(vName.trim())) {
                        message = currentLine.substring(currentLine.indexOf("=") + 1, currentLine.length());
                        isObjName = true;
                        break;
                    }
                    if (isObjName) continue;
                    message = Messages.getString("ITMTransactionHeaderModel_noDataFound");
                }
                inputFile.close();
            } else {
                BaseLogger.log("3", this.userInfo, null, "Message file " + msgFileURL + " Does not exist");
                message = Messages.getString("ITMTransactionHeaderModel_noDataFound");
            }
        }
        catch (Exception expMsg) {
            BaseLogger.log("0", this.userInfo, null, " ITMTransactionHeaderModel :: getDisplayMsg ::=> ");
            expMsg.printStackTrace();
        }
        BaseLogger.log("2", this.userInfo, null, " ITMTransactionHeaderModel :: getDisplayMsg ::=> message [" + message + "]");
        return message;
    }

    @Override
    public String toString() {
        return null;
    }
}

