/*
 * Decompiled with CFR 0.152.
 */
package ibase.bi.utility;

import ibase.bi.ejb.session.Column;
import ibase.bi.ejb.session.GenaralProp;
import ibase.bi.utility.BIContentWriter;
import ibase.bi.utility.BIException;
import ibase.bi.utility.BIHtmlWriter;
import ibase.bi.utility.BIPDFWriter;
import ibase.bi.utility.BISpreadSheetWriter;
import ibase.bi.utility.BISpreadSheetWriterFitWidth;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BIContentManager
implements Serializable {
    String groupFileName = "";
    String tableFileName = "";
    String dataTableFileName = "";
    String toolBarFileName = String.valueOf(CommonConstants.BI_RESOURCE_PATH) + File.separator + "common" + File.separator + "xsl" + File.separator + "ToolBar.html";
    boolean groupDivPart;
    String target = "";
    String groupDiv = new String("<DIV id=\"groupFields\" style=\"position=absolute;top=6%;width=101%;height=5%;left=0%;z-index:auto;display=none;\" class=\"pagehead\"> <span name=\"addGroups\" id=\"addGroups\" onmouseup=\"swap(this,'ADD_TO_GROUP')\" style=\"font-family=Times New Roman;font-size=11pt;width=220;height=33;color=blue;font-weight=normal;cursor=hand;border:thin ridge lightgray;text-align=center;\">Drop Column to Add to the Group</span></DIV>");
    ArrayList colDefList = null;
    BIContentWriter biContentWriter = null;
    int noOfCrossTabCols = 0;
    int noOfFixedCols = 0;
    ArrayList arCrossTab = null;
    ArrayList crossTabDisplayNames = null;
    ArrayList crossTabLogicalNames = null;
    String outputFile = null;
    boolean isExcel = false;
    GenaralProp genProp = null;
    String footerData = "";
    int footerAlignment = 2;
    boolean showPageNo = true;
    String action = "";

    public void setGroupFileName(String groupFileName) throws Exception {
        try {
            this.groupFileName = groupFileName;
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    public void setTableFileName(String tableFileName) throws Exception {
        try {
            if (this.genProp.isServerFile()) {
                String fileName = String.valueOf(CommonConstants.BI_REPORTS) + File.separator + this.genProp.getOwner();
                File f = new File(fileName);
                if (!f.exists()) {
                    f.mkdirs();
                }
                fileName = this.genProp.getBiFileName() == null || this.genProp.getBiFileName().equalsIgnoreCase("null") ? String.valueOf(fileName) + File.separator + "noname" : String.valueOf(fileName) + File.separator + this.genProp.getBiFileName();
                if (this.genProp.getOutputType().equalsIgnoreCase("Word")) {
                    fileName = String.valueOf(fileName) + ".doc";
                }
                File file = new File(tableFileName);
                FileInputStream fis = new FileInputStream(file);
                byte[] fileBytes = new byte[(int)file.length()];
                fis.read(fileBytes);
                fis.close();
                FileOutputStream fos = new FileOutputStream(fileName);
                fos.write(fileBytes);
                fos.flush();
                fos.close();
                this.tableFileName = fileName;
            } else {
                this.tableFileName = tableFileName;
            }
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    public void setDataTableFileName(String tableFileName) throws Exception {
        try {
            this.dataTableFileName = tableFileName;
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    public void setColDefList(ArrayList colDefList) throws Exception {
        try {
            this.colDefList = colDefList;
            float[] colWidthArr = new float[colDefList.size()];
            int cnt = 0;
            while (cnt < colDefList.size()) {
                float width = 10.0f;
                if (((Column)colDefList.get(cnt)).getWidth() != null && !((Column)colDefList.get(cnt)).getWidth().equalsIgnoreCase("null")) {
                    width = Integer.parseInt(((Column)colDefList.get(cnt)).getWidth());
                }
                colWidthArr[cnt] = width;
                ++cnt;
            }
            this.biContentWriter.createTable(colWidthArr, this.genProp.isFitToWidth());
            this.biContentWriter.setTableWidthPercentage(100.0f);
            this.biContentWriter.setHeaderCount(this.noOfCrossTabCols + 1);
            this.createColHeadingData(colDefList);
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    private Column setHeaderPropToCol(Column colObj) throws Exception {
        Column newColObj = new Column();
        try {
            if (this.genProp.getOutputType().equalsIgnoreCase("HTML")) {
                if (colObj != null && colObj.getDataType() != null) {
                    if (colObj.getDataType().equalsIgnoreCase("java.lang.String") || colObj.getDataType().equalsIgnoreCase("String")) {
                        newColObj.setAlignment("1");
                    }
                    newColObj.setAlignment("3");
                }
                if (this.action.equalsIgnoreCase("print")) {
                    newColObj.setFGColor("#222020");
                    newColObj.setBGColor("#FFFFFF");
                } else {
                    newColObj.setFGColor("#222020");
                    newColObj.setBGColor("#FFFFFF");
                }
                newColObj.setFontSize(12);
                newColObj.setBold(1);
            } else {
                if (colObj != null && colObj.getDataType() != null) {
                    if (colObj.getDataType().equalsIgnoreCase("java.lang.String") || colObj.getDataType().equalsIgnoreCase("String")) {
                        newColObj.setAlignment("1");
                    }
                    newColObj.setAlignment(colObj.getAlignment());
                }
                if (this.action.equalsIgnoreCase("print")) {
                    newColObj.setBGColor("#FFFFFF");
                    newColObj.setFGColor("#000000");
                } else {
                    newColObj.setBGColor("#333399");
                    newColObj.setFGColor("#000000");
                }
                newColObj.setBold(1);
            }
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
        return newColObj;
    }

    private ArrayList getColDisplayNameList(ArrayList colDefList) throws Exception {
        ArrayList<String> colDisplayNameList = new ArrayList<String>();
        int i = 0;
        while (i < colDefList.size()) {
            Column curColObj = (Column)colDefList.get(i);
            String heading = curColObj.getDisplayName();
            if (heading.indexOf("~") != -1) {
                String crossTabValue = heading.substring(0, heading.indexOf("~"));
                heading = heading.substring(heading.lastIndexOf("~") + 1);
            }
            colDisplayNameList.add(heading);
            ++i;
        }
        return colDisplayNameList;
    }

    public void writeDocument() throws Exception {
        this.biContentWriter.setPageFooter(this.footerData, this.footerAlignment, this.showPageNo);
        this.biContentWriter.writeDocument();
    }

    private ArrayList getCrossTabsValues(ArrayList colDefList) throws Exception {
        ArrayList main = new ArrayList();
        this.arCrossTab = null;
        int ctCount = 0;
        while (ctCount < this.noOfCrossTabCols) {
            main.add(new ArrayList());
            ++ctCount;
        }
        int i = 0;
        while (i < colDefList.size()) {
            Column curColObj = (Column)colDefList.get(i);
            String heading = curColObj.getDisplayName();
            String crValue = "";
            int colonCount = 0;
            while (heading.indexOf("~") != -1) {
                crValue = heading.substring(0, heading.indexOf("~"));
                heading = heading.substring(heading.indexOf("~") + 1);
                this.arCrossTab = (ArrayList)main.get(colonCount);
                this.arCrossTab.add(crValue);
                ++colonCount;
            }
            ++i;
        }
        return main;
    }

    public void addDataRow(ArrayList rowDataList) throws Exception {
        try {
            BaseLogger.log("9", null, null, "rowDataList :" + rowDataList);
            int cnt = 0;
            while (cnt < rowDataList.size()) {
                this.biContentWriter.addDataCell((String)rowDataList.get(cnt), 0, (Column)this.colDefList.get(cnt));
                ++cnt;
            }
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    private void createColHeadingData(ArrayList colDefList) throws Exception {
        try {
            if (this.noOfCrossTabCols > 0) {
                ArrayList ctValuesList = this.getCrossTabsValues(colDefList);
                boolean prevColSpan = true;
                int i = 0;
                while (i < this.crossTabDisplayNames.size()) {
                    this.biContentWriter.addDataCell((String)this.crossTabDisplayNames.get(i), this.noOfFixedCols, this.setHeaderPropToCol(null));
                    ArrayList ct = (ArrayList)ctValuesList.get(i);
                    ArrayList ctArray = (ArrayList)ctValuesList.get(i);
                    HashMap hmVal = new HashMap();
                    HashMap hmCnt = new HashMap();
                    ArrayList<Integer> ctCount = new ArrayList<Integer>();
                    String ctTemp = "";
                    String ctNew = "";
                    int count = 0;
                    int j = 0;
                    while (j < ct.size()) {
                        ctNew = (String)ct.get(j);
                        count = !ctTemp.equalsIgnoreCase(ctNew) ? 1 : ++count;
                        ctTemp = (String)ct.get(j);
                        ctCount.add(new Integer(count));
                        ++j;
                    }
                    int k = 0;
                    while (k < ctArray.size()) {
                        ctNew = (String)ctArray.get(k);
                        if (ctTemp.equalsIgnoreCase(ctNew) && k > 0) {
                            ct.remove(k - 1);
                            ctCount.remove(k - 1);
                            --k;
                        }
                        ctTemp = (String)ctArray.get(k);
                        ++k;
                    }
                    k = 0;
                    while (k < ct.size()) {
                        String kStr = Integer.toString(k);
                        hmVal.put(kStr, ct.get(k));
                        hmCnt.put(kStr, ctCount.get(k));
                        ++k;
                    }
                    int m = 0;
                    while (m < ct.size()) {
                        String mStr = Integer.toString(m);
                        int colSpan = (Integer)hmCnt.get(mStr);
                        String hmValues = (String)hmVal.get(mStr);
                        Column formatingObj = this.setHeaderPropToCol(null);
                        formatingObj.setAlignment("3");
                        this.biContentWriter.addDataCell(hmValues, colSpan, formatingObj);
                        ++m;
                    }
                    ++i;
                }
            }
            ArrayList colDisplayNameList = this.getColDisplayNameList(colDefList);
            int i = 0;
            while (i < colDisplayNameList.size()) {
                this.biContentWriter.addDataCell((String)colDisplayNameList.get(i), 0, this.setHeaderPropToCol((Column)this.colDefList.get(i)));
                ++i;
            }
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    public void setCrossTabProperties(ArrayList ctElementList) throws Exception {
        try {
            if (ctElementList != null) {
                this.crossTabDisplayNames = new ArrayList();
                this.crossTabLogicalNames = new ArrayList();
                int ctr = 0;
                while (ctr < ctElementList.size()) {
                    this.crossTabDisplayNames.add(((Column)ctElementList.get(ctr)).getDisplayName());
                    this.crossTabLogicalNames.add(((Column)ctElementList.get(ctr)).getLogicalName());
                    ++ctr;
                }
            }
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    public void setGroupDivPart(boolean groupDivPart) throws Exception {
        try {
            this.groupDivPart = groupDivPart;
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    public void setPageHeader(String title) throws Exception {
        try {
            this.biContentWriter.setPageHeader(title, 3, false);
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    public void setReportHeader(String title) throws Exception {
        try {
            this.biContentWriter.setReportHeader(title);
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    public void setfilteredGroupFileName(String filteredGroupfName) throws Exception {
        try {
            if (filteredGroupfName != null && filteredGroupfName.length() > 0) {
                String grpInfo = this.getGroupInfo(filteredGroupfName);
                this.biContentWriter.setGroupInfo(grpInfo);
            }
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    private String getGroupInfo(String fileName) throws Exception {
        String grpStr = "";
        File fName = new File(fileName);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document dom = db.parse(fName);
        NodeList groupsList = dom.getElementsByTagName("group");
        int i = 0;
        while (i < groupsList.getLength()) {
            Node groupNode = groupsList.item(i);
            NamedNodeMap groupAtrib = groupNode.getAttributes();
            int j = 0;
            while (j < groupAtrib.getLength()) {
                Node groupAtribNode = groupAtrib.item(j);
                if (groupAtribNode.getNodeName().equalsIgnoreCase("disName")) {
                    grpStr = String.valueOf(grpStr) + groupAtribNode.getNodeValue() + " :";
                    break;
                }
                ++j;
            }
            boolean valueFound = false;
            NodeList groupList = groupNode.getChildNodes();
            int j2 = 0;
            while (j2 < groupList.getLength()) {
                Node valueNode = groupList.item(j2);
                if (valueNode.getNodeName().equalsIgnoreCase("value")) {
                    NamedNodeMap valueAtrib = valueNode.getAttributes();
                    int k = 0;
                    while (k < valueAtrib.getLength()) {
                        Node valueAtribNode = valueAtrib.item(k);
                        if (valueAtribNode.getNodeName().equalsIgnoreCase("selected") && valueAtribNode.getNodeValue().equalsIgnoreCase("1")) {
                            grpStr = String.valueOf(grpStr) + valueNode.getFirstChild().getNodeValue() + "  ";
                            valueFound = true;
                            break;
                        }
                        ++k;
                    }
                    if (valueFound) break;
                }
                ++j2;
            }
            if (!valueFound) {
                grpStr = String.valueOf(grpStr) + "All  ";
            }
            ++i;
        }
        return grpStr;
    }

    public void initTarget() throws Exception {
        try {
            this.target = this.genProp.getTarget();
            if (this.genProp.getOutputType().equalsIgnoreCase("ITM BI")) {
                if (!this.target.equalsIgnoreCase("dashboard") && !this.target.equalsIgnoreCase("Mail")) {
                    this.target = "browser";
                }
            } else if (this.target == null || !this.target.equalsIgnoreCase("Mail")) {
                this.target = "nonitm";
            }
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    public void initOutputType() throws Exception {
        try {
            String reportName = String.valueOf(CommonConstants.BI_REPORTS) + File.separator + this.genProp.getOwner();
            File f = new File(reportName);
            if (!f.exists()) {
                f.mkdirs();
            }
            reportName = this.genProp.getBiFileName() == null || this.genProp.getBiFileName().equalsIgnoreCase("null") ? String.valueOf(reportName) + File.separator + "noname" : String.valueOf(reportName) + File.separator + this.genProp.getBiFileName();
            this.outputFile = this.genProp.isServerFile() ? reportName : String.valueOf(CommonConstants.BIHOME) + File.separator + "xmldatafiles" + File.separator + "SaxTransformed" + Math.random();
            String timeStampInfo = null;
            if (this.genProp.isTimeStampInfo()) {
                timeStampInfo = this.genProp.getOwner();
                Date dt = new Date(System.currentTimeMillis());
                SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
                String printDate = sdf.format(dt);
                timeStampInfo = String.valueOf(timeStampInfo) + " " + printDate;
            }
            if (this.genProp.getOutputType().equalsIgnoreCase("Acrobat PDF")) {
                this.outputFile = String.valueOf(CommonConstants.APPLICATION_CONTEXT) + "bi" + File.separatorChar + "resource" + File.separatorChar + "temp" + File.separatorChar + "PdfTableHtml" + "noname" + ".pdf";
                this.biContentWriter = new BIPDFWriter(this.outputFile);
                this.biContentWriter.setPageSize(this.genProp.getPageWidth(), this.genProp.getPageHeight());
                this.biContentWriter.setPageMargin(this.genProp.getMarginLeft(), this.genProp.getMarginRight(), this.genProp.getMarginTop(), this.genProp.getMarginBottom());
                this.biContentWriter.setNewPageForGroup(this.genProp.isNewPageForGroup());
                this.biContentWriter.setTimeStampInfo(timeStampInfo);
                this.biContentWriter.setSuppressGrid(this.genProp.isSuppressGrid());
            } else if (this.genProp.getOutputType().equalsIgnoreCase("HTML")) {
                this.outputFile = String.valueOf(this.outputFile) + ".html";
                String excel = this.genProp.getIsExcel();
                if (excel == null) {
                    excel = "true";
                }
                this.biContentWriter = new BIHtmlWriter(this.outputFile, excel);
                this.biContentWriter.setCSSFile(this.action.equalsIgnoreCase("print") ? "print.css" : this.genProp.getDisplayOpt());
                this.biContentWriter.setSuppressGrid(this.genProp.isSuppressGrid());
                this.biContentWriter.setPageSize(this.genProp.getPageWidth(), this.genProp.getPageHeight());
                this.biContentWriter.setPageMargin(this.genProp.getMarginLeft(), this.genProp.getMarginRight(), this.genProp.getMarginTop(), this.genProp.getMarginBottom());
                this.biContentWriter.setNewPageForGroup(this.genProp.isNewPageForGroup());
                this.biContentWriter.setTimeStampInfo(timeStampInfo);
            } else if (this.genProp.getOutputType().equalsIgnoreCase("Excel")) {
                this.outputFile = String.valueOf(CommonConstants.BIHOME) + File.separator + "xmldatafiles" + File.separator + this.genProp.getOwner() + this.genProp.getBiFileName() + Math.random() + ".xls";
                this.biContentWriter = new BISpreadSheetWriter(this.outputFile);
                this.biContentWriter.setPageSize(this.genProp.getPageWidth(), this.genProp.getPageHeight());
                this.biContentWriter.setPageMargin(this.genProp.getMarginLeft(), this.genProp.getMarginRight(), this.genProp.getMarginTop(), this.genProp.getMarginBottom());
                this.biContentWriter.setNewPageForGroup(this.genProp.isNewPageForGroup());
                this.biContentWriter.setTimeStampInfo(timeStampInfo);
            } else if (this.genProp.getOutputType().equalsIgnoreCase("ExcelFitWidth")) {
                this.outputFile = String.valueOf(CommonConstants.BIHOME) + File.separator + "xmldatafiles" + File.separator + this.genProp.getOwner() + this.genProp.getBiFileName() + Math.random() + ".xls";
                this.biContentWriter = new BISpreadSheetWriterFitWidth(this.outputFile);
                this.biContentWriter.setPageSize(this.genProp.getPageWidth(), this.genProp.getPageHeight());
                this.biContentWriter.setPageMargin(this.genProp.getMarginLeft(), this.genProp.getMarginRight(), this.genProp.getMarginTop(), this.genProp.getMarginBottom());
                this.biContentWriter.setNewPageForGroup(this.genProp.isNewPageForGroup());
                this.biContentWriter.setTimeStampInfo(timeStampInfo);
            }
            BaseLogger.log("3", null, null, "biContentWriter Obj :" + this.biContentWriter);
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    public String getOutputString() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        String outputString = null;
        try {
            if (this.target.equalsIgnoreCase("browser") && this.genProp.getOutputType().equalsIgnoreCase("ITM BI")) {
                this.writeInBaos(this.toolBarFileName, baos, true);
                this.writeInBaos(this.dataTableFileName, baos, true);
            } else if (this.target.equalsIgnoreCase("dashboard") && this.genProp.getOutputType().equalsIgnoreCase("ITM BI")) {
                this.writeInBaos(this.dataTableFileName, baos, true);
            }
            if (this.groupDivPart) {
                this.writeInBaos(this.groupDiv, baos, false);
            } else {
                this.writeInBaos(this.groupFileName, baos, true);
            }
            String outputType = this.genProp.getOutputType();
            String str = "";
            str = this.genProp.getBiFileName() == null || this.genProp.getBiFileName().equalsIgnoreCase("null") ? "<P><CENTER><H5>Saved in Server Repository as &quot;noname&quot; </H5></CENTER></P>" : "<P><CENTER><H5>Saved in Server Repository as&quot;" + this.genProp.getBiFileName() + "&quot; </H5></CENTER></P>";
            if (outputType.equalsIgnoreCase("Acrobat PDF") || outputType.equalsIgnoreCase("HTML")) {
                if (this.biContentWriter.closeDocument() && !this.genProp.isServerFile()) {
                    InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(this.outputFile), CommonConstants.ENCODING);
                    int i = -1;
                    baos.write("<img/>".getBytes(CommonConstants.ENCODING));
                    while ((i = isr.read()) != -1) {
                        baos.write(i);
                    }
                }
                if (!this.genProp.isServerFile()) {
                    outputString = baos.toString(CommonConstants.ENCODING);
                } else {
                    outputString = baos.toString(CommonConstants.ENCODING);
                    outputString = outputString.substring(0, outputString.indexOf("</html>") + "</html>".length());
                    outputString = String.valueOf(outputString) + str;
                }
            } else if (outputType.equalsIgnoreCase("Excel")) {
                if (this.biContentWriter.closeDocument() && !this.genProp.isServerFile()) {
                    InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(this.outputFile), CommonConstants.XLS_ENCODING);
                    int i = -1;
                    baos.write("<img/>".getBytes(CommonConstants.XLS_ENCODING));
                    while ((i = isr.read()) != -1) {
                        baos.write(i);
                    }
                }
                if (!this.genProp.isServerFile()) {
                    outputString = baos.toString(CommonConstants.XLS_ENCODING);
                } else {
                    outputString = baos.toString(CommonConstants.XLS_ENCODING);
                    outputString = outputString.substring(0, outputString.indexOf("</html>") + "</html>".length());
                    outputString = String.valueOf(outputString) + str;
                }
            } else if (outputType.equalsIgnoreCase("ExcelFitWidth")) {
                if (this.biContentWriter.closeDocument() && !this.genProp.isServerFile()) {
                    InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(this.outputFile), CommonConstants.XLS_ENCODING);
                    int i = -1;
                    baos.write("<img/>".getBytes(CommonConstants.XLS_ENCODING));
                    while ((i = isr.read()) != -1) {
                        baos.write(i);
                    }
                }
                if (!this.genProp.isServerFile()) {
                    outputString = baos.toString(CommonConstants.XLS_ENCODING);
                } else {
                    outputString = baos.toString(CommonConstants.XLS_ENCODING);
                    outputString = outputString.substring(0, outputString.indexOf("</html>") + "</html>".length());
                    outputString = String.valueOf(outputString) + str;
                }
            } else if (outputType.equalsIgnoreCase("Word") && this.genProp.isServerFile()) {
                outputString = baos.toString(CommonConstants.ENCODING);
                outputString = outputString.substring(0, outputString.lastIndexOf("</html>") + "</html>".length());
                outputString = String.valueOf(outputString) + str;
            } else {
                this.writeInBaos(this.tableFileName, baos, true);
                outputString = baos.toString(CommonConstants.ENCODING);
            }
            this.clearFields();
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
        return outputString;
    }

    public ByteArrayOutputStream getBaos() throws Exception {
        ByteArrayOutputStream localBaos;
        try {
            String output = this.getOutputString();
            localBaos = new ByteArrayOutputStream();
            localBaos.write(output.getBytes());
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
        return localBaos;
    }

    private void writeInBaos(String data, OutputStream baos, boolean isFile) throws Exception {
        if (isFile) {
            File f = new File(data);
            if (f.exists()) {
                byte[] byteArray = new byte[(int)f.length()];
                FileInputStream fin = new FileInputStream(f);
                if (f.getName().indexOf("ITMBI") != -1) {
                    fin.skip(14L);
                }
                fin.read(byteArray);
                fin.close();
                baos.write(byteArray);
            }
        } else {
            baos.write(data.getBytes());
        }
        baos.flush();
    }

    public void setNoOfCrossTabCols(int noOfCrossTabCols) throws Exception {
        try {
            this.noOfCrossTabCols = noOfCrossTabCols;
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    public void setNoOfFixedCols(int noOfFixedCols) throws Exception {
        try {
            this.noOfFixedCols = noOfFixedCols;
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    public void setGenProp(GenaralProp genProp) throws Exception {
        try {
            this.genProp = genProp;
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    private void clearFields() throws Exception {
        this.groupFileName = "";
        this.tableFileName = "";
        this.biContentWriter = null;
    }

    public void setAction(String action) throws Exception {
        try {
            this.action = action;
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }
}

