package ibase.webitm.ejb.wsfa.transactions;
import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ITMDBAccessLocal;
import ibase.webitm.ejb.ProcessEJB;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;

import javax.ejb.Stateless;
import javax.naming.InitialContext;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

//@Stateless		commented by Sagar M [22 Nov 2018].
public class StrgRouteTransferPrc extends ValidatorEJB implements StrgRouteTransferPrcLocal,StrgRouteTransferPrcRemote
{
	String err = "";
	GenericUtility genericUtility = GenericUtility.getInstance();
	 ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
	ResultSet rs1 = null;
	PreparedStatement pstmt1 = null;
	String Sql1="";


	public String getData(String xmlString, String xmlString2, String windowName, String xtraParams) throws RemoteException,ITMException
	{

		String rtrStr = "";
		Document headerDom = null;
		Document detailDom = null;
		try
		{
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				headerDom = genericUtility.parseString(xmlString);
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				detailDom = genericUtility.parseString(xmlString2);
			}
			rtrStr = getData(headerDom, detailDom, windowName, xtraParams);
		}
		catch (Exception e)
		{
			rtrStr = e.getMessage();
		}
		return rtrStr;
	}

	public String getData(Document headerDom, Document detailDom, String windowName, String xtraParams) throws RemoteException,ITMException
	{
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		String resultString = "";
		String salesPersFrom = "";
		String salesPersTo = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		try
		{
			StringBuffer valueXmlString = new StringBuffer("<?xml version=\"1.0\" encoding='UTF-8'?>\r\n<DocumentRoot>\r\n<description>Datawindow Root</description>\r\n<group0>\r\n<description>Group0 description</description>\r\n<Header0>\r\n<description>Header0 members</description>\r\n");
			conn = connDriver.getConnectDB("DriverITM");


			salesPersFrom = genericUtility.getColumnValue("sales_pers_from",headerDom);
			salesPersTo = genericUtility.getColumnValue("sales_pers_to",headerDom);
			String userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			System.out.println("userId==== "+userId);
			System.out.println("salesPersFrom==== "+salesPersFrom);
			System.out.println("salesPersTo==== "+salesPersTo);

			System.out.println("detailDom======== "+detailDom);
			System.out.println("headerDom======== "+headerDom);

			String getDataSql=" SELECT SPRS_CODE,ROUTE_ID,DESCR,STAN_CODE,LOCALITY_CODE,STATION_TYPE FROM SPRS_ROUTE WHERE SPRS_CODE = ? " +
							  " AND DESCR NOT IN (SELECT DESCR FROM SPRS_ROUTE WHERE SPRS_CODE = ? AND STATUS = ?) AND STATUS = ? ";

			pstmt = conn.prepareStatement( getDataSql );
			pstmt.setString(1, salesPersFrom);
			pstmt.setString(2, salesPersTo);
			pstmt.setString(3, "Y");
			pstmt.setString(4, "Y");

			rs = pstmt.executeQuery();
			int i = 1;
			while( rs.next() )
			{
				String sprsCode = ( checkNull( rs.getString("SPRS_CODE") ) );
				String routeId = ( checkNull( rs.getString("ROUTE_ID") ) );
				String descr = ( checkNull( rs.getString("DESCR") ) );
				String stanCode = ( checkNull( rs.getString("STAN_CODE") ) );
				String locality = ( checkNull( rs.getString("LOCALITY_CODE") ) );
				String station = ( checkNull( rs.getString("LOCALITY_CODE") ) );

				valueXmlString.append("<Detail2 domID='"+i+"' >\r\n");
				valueXmlString.append("<attribute updateFlag='N' selected='N' />\r\n");
				valueXmlString.append("<is_selected><![CDATA[").append("").append("]]></is_selected>\r\n");
				valueXmlString.append("<sprs_code><![CDATA[").append( sprsCode ).append("]]></sprs_code>\r\n");
				valueXmlString.append("<route_id><![CDATA[").append( routeId ).append("]]></route_id>\r\n");
				valueXmlString.append("<descr><![CDATA[").append( descr ).append("]]></descr>\r\n");
				valueXmlString.append("<stan_code><![CDATA[").append( stanCode ).append("]]></stan_code>\r\n");
				valueXmlString.append("<locality_code><![CDATA[").append( locality ).append("]]></locality_code>\r\n");
				valueXmlString.append("<station_type><![CDATA[").append( station ).append("]]></station_type>\r\n");

				valueXmlString.append("</Detail2>\r\n");

				i++;
			}

			 if(pstmt != null)
			   {
					pstmt.close();
				}
			 if (conn != null)
			   {
					conn.close();
			   }


				valueXmlString.append("</Header0>\r\n");
				valueXmlString.append("</group0>\r\n");
				valueXmlString.append("</DocumentRoot>\r\n");
				resultString = valueXmlString.toString();
				System.out.println("valueXmlString :: "+resultString );
		}
		catch(Exception e)
		{
			System.out.println("Exception in getData-->"+e.toString());
			 throw new ITMException(e);
		}
		finally
		{
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if ( conn != null )
				{
					conn.close();
					conn = null;
				}
			}
			catch (Exception e)
			{
				System.out.println(e.getMessage());
			}
		}
		return resultString;
	}
	public String process(String xmlString, String xmlString2, String windowName, String xtraParams) throws RemoteException,ITMException
	{

		Document detailDom = null;
		Document headerDom = null;
		String retStr = "";

		try
		{

			if(xmlString != null && xmlString.trim().length()!=0)
			{
				headerDom = genericUtility.parseString(xmlString);
				System.out.println("headerDom" + headerDom);
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				detailDom = genericUtility.parseString(xmlString2);
				System.out.println("detailDom" + detailDom);
			}
			retStr = process(headerDom, detailDom, windowName, xtraParams);
		}
		catch (Exception e)
		{
			System.out.println("Exception :StrgSeriesPsrCopyPrc :process:" + e.getMessage() + ":");
			e.printStackTrace();
			retStr = e.getMessage();
		}
		System.out.println("Return from process-->"+retStr);
		return retStr;
	}

	public String process(Document headerDom, Document detailDom, String windowName, String xtraParams) throws RemoteException,ITMException
	{
		String userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
		String termId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"termId");
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		PreparedStatement pstmtIns1 = null;
		PreparedStatement pstmtIns2 = null;
		PreparedStatement pstmtSel1 = null;
		PreparedStatement pstmtSel2 = null;

		PreparedStatement selectSprsRoutePstmt=null;
		PreparedStatement insertSprsRoutePstmt =null;
		PreparedStatement selectStrgSeriesPstmt = null;
		PreparedStatement updateStrgSeriesPstmt = null;
		PreparedStatement updatestatusHistPstmt = null;



		ResultSet resSelect=null;
		Statement stmt = null;
		String childNodeName = "";
		String unlistChildNodeName = "";
		String retString = "";
		String currentDate = "";
		String sprsCode = "";
		String localityCode = "";
		String salesPersFrom = "";
		String salesPersTo = "";
		String routeId = "";
		String isSelected = ""; //Gulzar - 22/08/08 Req ID : SY89SUN001
		String isrouteSelected = "";
		String sprsCodeValue = "";
		String routeIdValue = "";
		String descrValue = "";
		String stanCodeValue = "";
		String localityValue = "";
		String stationValue = "";
		int insertSprsCodeCount=0;
		int updateStrgSeriesCount = 0;
		int updateStatusHistCount = 0;

		java.util.Date currDate =null;
		java.sql.Timestamp sysDate = null;
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		NodeList parentNodeListval = null;
		NodeList childNodeListval = null;
		NodeList unchildNodeList = null;
		Node parentNode = null;
		Node parentNodeval = null;
		Node unlistParentNode = null;
		Node childNode = null;
		Node childNodeval = null;
		Node unchildNode = null;
		int parentNodeListLength = 0;
		int childNodeListLength = 0;
		int unchildNodeListLength = 0;
		NodeList unlistedParentNodeList=null;// Added By Shahu Mali on 04-DEC-1
		int unlistedParentNodeListLength=0;
		int noOfRecSelect = 0;
		int noOfRecUnlistSelect = 0;
		PreparedStatement unlistPstmt = null;
		PreparedStatement strgSeriesPstmt=null;
		ResultSet unListRes=null;
		ResultSet strgSeriesRes=null;
		int unListedCount=0;
		int strgSeriesCount=0;
		String unListSql="";
		String strgSeriesSql="";
		String salesPersfrom = "", salesPersto = "";
		try
		{
			conn = connDriver.getConnectDB("DriverITM");
			conn.setAutoCommit(false);

			InitialContext ctx = getInitialContext();
			//Commented and modified by kailash on 20-07-18 as per gulzar sir[Start]
			//ITMDBAccessLocal itmDBAccessLocal = (ITMDBAccessLocal)ctx.lookup( "ibase/ITMDBAccessEJB/local" );
			ITMDBAccessEJB itmDBAccessLocal = new ITMDBAccessEJB();
			//Commented and modified by kailash on 20-07-18 as per gulzar sir[End]

			//Added By Gulzar - 21/08/08 Req ID : SY89SUN001
			parentNodeList = detailDom.getElementsByTagName("Detail2");
			parentNodeListLength = parentNodeList.getLength();
			System.out.println("parentNodeListLength:::::::::= "+parentNodeListLength);

			unlistedParentNodeList = detailDom.getElementsByTagName("Detail2");
			unlistedParentNodeListLength=unlistedParentNodeList.getLength();
			System.out.println("unlistedParentNodeListLength:::::::::= "+unlistedParentNodeListLength);

			currDate = new java.util.Date(System.currentTimeMillis());
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			currentDate = sdf.format(new java.util.Date());
			sysDate = java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString(currentDate, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()));

			salesPersFrom = genericUtility.getColumnValue("sales_pers_from",headerDom);
			salesPersTo = genericUtility.getColumnValue("sales_pers_to",headerDom);

			strgSeriesSql="SELECT COUNT(*) COUNT FROM STRG_SERIES WHERE SALES_PERS= ? ";
			strgSeriesPstmt= conn.prepareStatement(strgSeriesSql);
			strgSeriesPstmt.setString( 1, salesPersFrom );
			strgSeriesRes = strgSeriesPstmt.executeQuery();
			if(strgSeriesRes.next())
			{
				strgSeriesCount = Integer.parseInt(strgSeriesRes.getString("COUNT"));
			}
			strgSeriesPstmt.close();strgSeriesPstmt=null;
			strgSeriesRes.close();strgSeriesRes=null;
			System.out.println("Strg Series: strgSeriesCount=["+strgSeriesCount+"]");

			stmt = conn.createStatement();
			retString = "";

			for (int selectedRow = 0; selectedRow < parentNodeListLength; selectedRow++)
			{
				System.out.println("selectedRow==========>["+selectedRow+"]");
				parentNode = parentNodeList.item(selectedRow);
				childNodeList = parentNode.getChildNodes();
				System.out.println("childNodeList========"+childNodeList);
				childNodeListLength = childNodeList.getLength();
				System.out.println("childNodeListLength::: "+ childNodeListLength+"\n");
				for (int childRow = 0; childRow < childNodeListLength; childRow++)
				{
					childNode = childNodeList.item(childRow);
					childNodeName = childNode.getNodeName();
					System.out.println("childNodeName========="+childNodeName);
					if (childNodeName.equals("sprs_code"))
					{
						if(childNode.getFirstChild()!=null)
						{
							sprsCode = childNode.getFirstChild().getNodeValue();
							System.out.println("scCode::"+sprsCode);
						}
					}

					if (childNodeName.equals("route_id"))
					{
						if(childNode.getFirstChild()!=null)
						{
							routeId = childNode.getFirstChild().getNodeValue();
							System.out.println("routeId::"+routeId);
						}
					}

					if (childNodeName.equals("is_selected"))
					{
						if(childNode.getFirstChild()!=null)
						{
							isSelected = childNode.getFirstChild().getNodeValue();
							System.out.println("isSelected::"+isSelected);
						}
					}

				}
			}
			System.out.println("unlistedParentNodeListLength =============> ["+unlistedParentNodeListLength+"]");


			 parentNodeListval = detailDom.getElementsByTagName("Detail1");
			 System.out.println("parentNodeListval======"+parentNodeListval);
			 parentNodeval = parentNodeListval.item(0);
			 childNodeListval = parentNodeval.getChildNodes();
			 System.out.println("childNodeListval========"+childNodeListval);
			 for (int i = 0; i < childNodeListval.getLength(); i++)
			 {
		    	childNodeval = childNodeListval.item(i);
		    	if ("sales_pers_from".equalsIgnoreCase(childNodeval.getNodeName()))
		    	{
		    		salesPersfrom = childNodeval.getFirstChild() == null ? "" : childNodeval.getFirstChild().getNodeValue().trim();
		    	}
		    	else if ("sales_pers_to".equalsIgnoreCase(childNodeval.getNodeName()))
		    	{
		    		salesPersto = childNodeval.getFirstChild() == null ? "" : childNodeval.getFirstChild().getNodeValue().trim();
		    	}

			 }
			 System.out.println("salesPersfrom :::::["+salesPersfrom+"]");
			 System.out.println("salesPersto :::::["+salesPersto+"]");

		 	if("".equalsIgnoreCase(salesPersfrom))
		    {
		 		System.out.println("inside if 1.....:");
		    	retString = "<?xml version=\"1.0\"?><Root><Errors><error id=\"VMSALESPER\" type=\"E\" column_name=\"\"><message>Sales_Pers_From is Blank</message><description>Sales_Pers_From Can Not be Blank</description><type>E</type><option>Y</option><time>null</time><alarm>null</alarm><source>null</source><trace></trace><redirect>1</redirect></error></Errors></Root>";
		    	return retString;

		    }
		    else if(this.isEmpCodeFromValid(conn,salesPersfrom) )
			{
		    	System.out.println("inside if 2.....:");
		    	retString = "<?xml version=\"1.0\"?><Root><Errors><error id=\"VMSALESPER\" type=\"E\" column_name=\"\"><message>Sales_Pers_From Not Valid</message><description>Sales_Pers_From is Not Valid</description><type>E</type><option>Y</option><time>null</time><alarm>null</alarm><source>null</source><trace></trace><redirect>1</redirect></error></Errors></Root>";
		    	return retString;
			}
		    else if("".equalsIgnoreCase(salesPersto))
		    {
		    	System.out.println("inside if 3.....:");
		    	retString = "<?xml version=\"1.0\"?><Root><Errors><error id=\"VMSALESPER\" type=\"E\" column_name=\"\"><message>Sales_Pers_To is Blank</message><description>Sales_Pers_To Can Not be Blank</description><type>E</type><option>Y</option><time>null</time><alarm>null</alarm><source>null</source><trace></trace><redirect>1</redirect></error></Errors></Root>";
		    	return retString;
		    }
		    else if(this.isEmpCodeToValid(conn,salesPersto) )
			{
		    	System.out.println("inside if 4.....:");
		    	retString = "<?xml version=\"1.0\"?><Root><Errors><error id=\"VMSALESPER\" type=\"E\" column_name=\"\"><message>Sales_Pers_To Not Valid</message><description>Sales_Pers_To is Not Valid</description><type>E</type><option>Y</option><time>null</time><alarm>null</alarm><source>null</source><trace></trace><redirect>1</redirect></error></Errors></Root>";
		    	return retString;
			}

			 for (int selectedUnListRow = 0; selectedUnListRow < unlistedParentNodeListLength; selectedUnListRow++)
			 {
				System.out.println("selectedUnListRow==========>["+selectedUnListRow+"]");
				insertSprsCodeCount = 0;
				unlistParentNode = unlistedParentNodeList.item(selectedUnListRow);
				unchildNodeList = unlistParentNode.getChildNodes();
				unchildNodeListLength = unchildNodeList.getLength();
				System.out.println("unchildNodeListLength::: "+ unchildNodeListLength+"\n");
				for (int unchildRow = 0; unchildRow < unchildNodeListLength; unchildRow++)
				{
					unchildNode = unchildNodeList.item(unchildRow);
					unlistChildNodeName = unchildNode.getNodeName();
					if (unlistChildNodeName.equals("sprs_code"))
					{
						if(unchildNode.getFirstChild()!=null)
						{
							sprsCode = unchildNode.getFirstChild().getNodeValue();
							System.out.println("sprsCode :: "+sprsCode);
						}
					}
					if (unlistChildNodeName.equals("locality_code"))
					{
						if(unchildNode.getFirstChild()!=null)
						{
							localityCode = unchildNode.getFirstChild().getNodeValue();
							System.out.println("localityCode :: "+localityCode);
						}
					}

					if (unlistChildNodeName.equals("is_selected"))
					{
						noOfRecSelect++;
						if(unchildNode.getFirstChild()!=null)
						{
							isrouteSelected = unchildNode.getFirstChild().getNodeValue();
							System.out.println("isrouteSelected::"+isrouteSelected);
						}
					}
				}

				if ( isrouteSelected != null && isrouteSelected.trim().equalsIgnoreCase("true") )
				{
					noOfRecUnlistSelect++;
					String insertSprsRouteSql=" INSERT INTO SPRS_ROUTE (" +
	    			  " SPRS_CODE," +
	    			  " ROUTE_ID, " +
	    			  " DESCR," +
	    			  " SH_DESCR," +
	    			  " STAN_CODE, " +
	    			  " LOCALITY_CODE," +
	    			  " STATION_TYPE, " +
	    			  " STATUS, " +
	    			  " CHG_DATE, " +
	    			  " CHG_USER, " +
	    			  " CHG_TERM " +
	    			  " ) VALUES (?,?,?,?,?,?,?,?,?,?,? )";
					insertSprsRoutePstmt = conn.prepareStatement(insertSprsRouteSql);
					System.out.println("isrouteSelected=======>"+isrouteSelected);


					String selectDataSql=" SELECT SPRS_CODE,ROUTE_ID,DESCR,STAN_CODE,LOCALITY_CODE,STATION_TYPE FROM SPRS_ROUTE WHERE SPRS_CODE = ? " +
					  " AND DESCR NOT IN (SELECT DESCR FROM SPRS_ROUTE WHERE SPRS_CODE = ? AND STATUS ='Y') AND LOCALITY_CODE= ? ";

					selectSprsRoutePstmt = conn.prepareStatement(selectDataSql);
					selectSprsRoutePstmt.setString(1, salesPersFrom);
					selectSprsRoutePstmt.setString(2, salesPersTo);
					selectSprsRoutePstmt.setString(3, localityCode);
					resSelect=selectSprsRoutePstmt.executeQuery();

					while(resSelect.next())
					{
						 sprsCodeValue = ( checkNull( resSelect.getString("SPRS_CODE") ) );
						 routeIdValue = ( checkNull( resSelect.getString("ROUTE_ID") ) );
						 descrValue = ( checkNull( resSelect.getString("DESCR") ) );
						 stanCodeValue = ( checkNull( resSelect.getString("STAN_CODE") ) );
						 localityValue = ( checkNull( resSelect.getString("LOCALITY_CODE") ) );
						 stationValue = ( checkNull( resSelect.getString("LOCALITY_CODE") ) );

					}
					int maxRouteId = 0 ;
					String selectRoutId = "select max(cast(route_id as int))+1 as route_id from sprs_route where sprs_code= ?";
					PreparedStatement selRouteIdPstmt = conn.prepareStatement(selectRoutId);
					selRouteIdPstmt.setString(1,salesPersTo);
					ResultSet selrouteIdrs = selRouteIdPstmt.executeQuery();

					if(selrouteIdrs.next())
					{
						maxRouteId = selrouteIdrs.getInt("route_id");
					}

					insertSprsRoutePstmt.setString(1,salesPersTo);
					insertSprsRoutePstmt.setInt(2,maxRouteId);
					insertSprsRoutePstmt.setString(3,descrValue);
					insertSprsRoutePstmt.setString(4,descrValue);
					insertSprsRoutePstmt.setString(5,stanCodeValue);
					insertSprsRoutePstmt.setString(6,localityValue);
					insertSprsRoutePstmt.setString(7,stationValue);
					insertSprsRoutePstmt.setString(8,"Y");
					insertSprsRoutePstmt.setTimestamp(9,sysDate);
					insertSprsRoutePstmt.setString(10,userId);
					insertSprsRoutePstmt.setString(11,termId);

					insertSprsCodeCount = insertSprsRoutePstmt.executeUpdate();
					System.out.println("insertSprsCodeCount =============> ["+insertSprsCodeCount+"]");
					if(insertSprsCodeCount > 0)
					{
						retString = "";
						System.out.println(" Insertion of SPRS_ROUTE Table Successfully !!! insertSprsCodeCount= ["+insertSprsCodeCount+"]");
					}
					else
					{
						retString = itmDBAccessLocal.getErrorString("","DBINSERROR",userId);
						System.out.println("Error while Insertion of SPRS_ROUTE Table !!!");

						break;
					}

					insertSprsRoutePstmt.clearParameters();

					resSelect.close();
					resSelect=null;
					selectSprsRoutePstmt.close();
					selectSprsRoutePstmt=null;
					insertSprsRoutePstmt.close();
					insertSprsRoutePstmt=null;

						int sprsRouteCount=0;
						int updateRouteCount=0;
					  	String selDrUnlistSql="SELECT COUNT(1) AS COUNT FROM SPRS_ROUTE WHERE SPRS_CODE = ? AND LOCALITY_CODE= ?";
					  	pstmt = conn.prepareStatement(selDrUnlistSql);
						pstmt.setString(1, salesPersFrom);
						pstmt.setString(2, localityCode);
						rs=pstmt.executeQuery();
						while(rs.next())
						{
							sprsRouteCount=rs.getInt("COUNT");
						}
						if(sprsRouteCount > 0)
						{
							String updateRouteSql=" UPDATE SPRS_ROUTE SET STATUS= ? WHERE  SPRS_CODE = ? AND LOCALITY_CODE= ? ";
							PreparedStatement updateRoutePstmt = conn.prepareStatement(updateRouteSql);
							updateRoutePstmt.setString(1,"N" );
							updateRoutePstmt.setString(2,salesPersFrom );
							updateRoutePstmt.setString(3,localityCode);
							updateRouteCount = updateRoutePstmt.executeUpdate();
							if(updateRouteCount > 0)
							{
								retString = "";
								System.out.println(" Updated SPRS_ROUTE Table Successfully !!! ");
							}
						}

						String selectSeriesSql= "SELECT SC_CODE ,ITEM_SER, SALES_PERS, CLASS_CODE, NO_VISIT, TOTAL_BUSINESS , BUSINESS_TO_US, SALES_PERS__OLD," +
								" CHG_USER, CHG_DATE, CHG_TERM, SHORT_ID , REASON, CHG_TYPE, EFF_DATE, SPL_CODE, REPLY_STATUS , ROUTE_ID, SORT_SEQ ," +
								" STATUS, NO_PATIENT_DAY, NO_VISIT_PER, MIN_INTERVAL_VISIT, MAX_INTERVAL_VISIT, CLASS_CODE_DESCR, CUST_TYPE, LOCALITY_CODE, " +
								" SUBCLASS_CODE, TRAN_ID__REF, CATEGORY, LATTITUDE, LONGITUDE, STRG_SERIES__INITIATOR, WF_REJ__REMARK, WF_STATUS, CONFIRM, " +
								" RETAILER_LOCALITY, RETAILER_MOBNO, RETAILER_TEL2, RETAILER_TEL1, RETAILER_PIN, RETAILER_CITY, RETAILER_ADR1, RETAILER_ADR2, " +
								" RETAILER_ADR3, RETAILER_NAME, RETAILER_CODE" +
								" FROM STRG_SERIES WHERE SALES_PERS = ? AND ROUTE_ID = ? AND STATUS = ?";

						selectStrgSeriesPstmt = conn.prepareStatement(selectSeriesSql);
						selectStrgSeriesPstmt.setString(1,salesPersFrom);
						selectStrgSeriesPstmt.setString(2,routeIdValue);
						selectStrgSeriesPstmt.setString(3,"Y");
						ResultSet selectStrgSeriesRs = selectStrgSeriesPstmt.executeQuery();
						while (selectStrgSeriesRs.next())
						{
							String updateSeriesSql=" UPDATE STRG_SERIES SET " +
												   " SC_CODE= ?, ITEM_SER=?, SALES_PERS = ?, CLASS_CODE= ?, NO_VISIT= ?, TOTAL_BUSINESS= ?, " +
												   " BUSINESS_TO_US= ?, SALES_PERS__OLD= ?, CHG_USER= ?, CHG_DATE= ?, CHG_TERM= ?, SHORT_ID= ?, " +
												   " REASON= ?, CHG_TYPE= ?, EFF_DATE= ?, SPL_CODE= ?, REPLY_STATUS= ?, ROUTE_ID= ?, SORT_SEQ= ?, " +
												   " STATUS= ?, NO_PATIENT_DAY= ?, NO_VISIT_PER= ?, MIN_INTERVAL_VISIT= ?," +
												   " MAX_INTERVAL_VISIT= ?, CLASS_CODE_DESCR= ?, CUST_TYPE= ?, LOCALITY_CODE= ?, " +
												   " SUBCLASS_CODE= ?, TRAN_ID__REF= ?, CATEGORY= ?, LATTITUDE= ?, LONGITUDE= ?, STRG_SERIES__INITIATOR= ?," +
												   " WF_REJ__REMARK= ?, WF_STATUS= ?, CONFIRM= ?, RETAILER_LOCALITY= ?, RETAILER_MOBNO= ?, RETAILER_TEL2= ?, " +
												   " RETAILER_TEL1= ?, RETAILER_PIN= ?, RETAILER_CITY= ?, RETAILER_ADR1= ?, RETAILER_ADR2= ?, " +
												   " RETAILER_ADR3= ?, RETAILER_NAME= ?, RETAILER_CODE= ? " +
												   " WHERE SALES_PERS = ? AND ROUTE_ID = ? AND SC_CODE = ? AND STATUS = ? ";

							updateStrgSeriesPstmt = conn.prepareStatement(updateSeriesSql);
							System.out.println("changed....................");
							Date e1 = selectStrgSeriesRs.getDate("EFF_DATE");
							Date e2 = selectStrgSeriesRs.getDate("CHG_DATE");
							SimpleDateFormat sformat = new SimpleDateFormat(genericUtility.getApplDateFormat());
							//String dt = genericUtility.getValidDateString(selectStrgSeriesRs.getString("EFF_DATE"), getApplDateFormat());
							//String dt1 = genericUtility.getValidDateString(selectStrgSeriesRs.getString("CHG_DATE"), getApplDateFormat());
							String EffForm = sformat.format(e1);
							String chgDate = sformat.format(e2);
							//currDate = genericUtility.getValidDateTimeString( currDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );
							String EffDate = genericUtility.getValidDateTimeString( EffForm, genericUtility.getApplDateFormat() , genericUtility.getDBDateFormat());
							String changeDate = genericUtility.getValidDateTimeString( chgDate ,  genericUtility.getApplDateFormat() , genericUtility.getDBDateFormat());

							updateStrgSeriesPstmt.setString(1,selectStrgSeriesRs.getString("SC_CODE"));
							updateStrgSeriesPstmt.setString(2,selectStrgSeriesRs.getString("ITEM_SER"));
							updateStrgSeriesPstmt.setString(3,salesPersTo);
							updateStrgSeriesPstmt.setString(4,selectStrgSeriesRs.getString("CLASS_CODE"));
							updateStrgSeriesPstmt.setString(5,selectStrgSeriesRs.getString("NO_VISIT"));
							updateStrgSeriesPstmt.setString(6,selectStrgSeriesRs.getString("TOTAL_BUSINESS"));
							updateStrgSeriesPstmt.setString(7,selectStrgSeriesRs.getString("BUSINESS_TO_US"));
							updateStrgSeriesPstmt.setString(8,selectStrgSeriesRs.getString("SALES_PERS__OLD"));
							updateStrgSeriesPstmt.setString(9,selectStrgSeriesRs.getString("CHG_USER"));
							//updateStrgSeriesPstmt.setString(10,selectStrgSeriesRs.getString("CHG_DATE"));
							updateStrgSeriesPstmt.setTimestamp(10, java.sql.Timestamp.valueOf(changeDate));
							updateStrgSeriesPstmt.setString(11,selectStrgSeriesRs.getString("CHG_TERM"));

							updateStrgSeriesPstmt.setString(12,selectStrgSeriesRs.getString("SHORT_ID"));
							updateStrgSeriesPstmt.setString(13,selectStrgSeriesRs.getString("REASON"));
							updateStrgSeriesPstmt.setString(14,selectStrgSeriesRs.getString("CHG_TYPE"));
							//updateStrgSeriesPstmt.setString(15,selectStrgSeriesRs.getString("EFF_DATE"));
							updateStrgSeriesPstmt.setTimestamp(15, java.sql.Timestamp.valueOf(EffDate));
							updateStrgSeriesPstmt.setString(16,selectStrgSeriesRs.getString("SPL_CODE"));
							updateStrgSeriesPstmt.setString(17,selectStrgSeriesRs.getString("REPLY_STATUS"));
							updateStrgSeriesPstmt.setInt(18,maxRouteId);
							updateStrgSeriesPstmt.setString(19,selectStrgSeriesRs.getString("SORT_SEQ"));
							updateStrgSeriesPstmt.setString(20,selectStrgSeriesRs.getString("STATUS"));
							updateStrgSeriesPstmt.setString(21,selectStrgSeriesRs.getString("NO_PATIENT_DAY"));
							updateStrgSeriesPstmt.setString(22,selectStrgSeriesRs.getString("NO_VISIT_PER"));

							updateStrgSeriesPstmt.setString(23,selectStrgSeriesRs.getString("MIN_INTERVAL_VISIT"));
							updateStrgSeriesPstmt.setString(24,selectStrgSeriesRs.getString("MAX_INTERVAL_VISIT"));
							updateStrgSeriesPstmt.setString(25,selectStrgSeriesRs.getString("CLASS_CODE_DESCR"));
							updateStrgSeriesPstmt.setString(26,selectStrgSeriesRs.getString("CUST_TYPE"));
							updateStrgSeriesPstmt.setString(27,selectStrgSeriesRs.getString("LOCALITY_CODE"));
							updateStrgSeriesPstmt.setString(28,selectStrgSeriesRs.getString("SUBCLASS_CODE"));
							updateStrgSeriesPstmt.setString(29,selectStrgSeriesRs.getString("TRAN_ID__REF"));
							updateStrgSeriesPstmt.setString(30,selectStrgSeriesRs.getString("LATTITUDE"));
							updateStrgSeriesPstmt.setString(31,selectStrgSeriesRs.getString("LONGITUDE"));
							updateStrgSeriesPstmt.setString(32,selectStrgSeriesRs.getString("LOCALITY_CODE"));
							updateStrgSeriesPstmt.setString(33,selectStrgSeriesRs.getString("STRG_SERIES__INITIATOR"));
							updateStrgSeriesPstmt.setString(34,selectStrgSeriesRs.getString("WF_REJ__REMARK"));
							updateStrgSeriesPstmt.setString(35,selectStrgSeriesRs.getString("WF_STATUS"));
							updateStrgSeriesPstmt.setString(36,selectStrgSeriesRs.getString("CONFIRM"));
							updateStrgSeriesPstmt.setString(37,selectStrgSeriesRs.getString("RETAILER_LOCALITY"));
							updateStrgSeriesPstmt.setString(38,selectStrgSeriesRs.getString("RETAILER_MOBNO"));
							updateStrgSeriesPstmt.setString(39,selectStrgSeriesRs.getString("RETAILER_TEL2"));
							updateStrgSeriesPstmt.setString(40,selectStrgSeriesRs.getString("RETAILER_TEL1"));
							updateStrgSeriesPstmt.setString(41,selectStrgSeriesRs.getString("RETAILER_PIN"));
							updateStrgSeriesPstmt.setString(42,selectStrgSeriesRs.getString("RETAILER_CITY"));
							updateStrgSeriesPstmt.setString(43,selectStrgSeriesRs.getString("RETAILER_ADR1"));
							updateStrgSeriesPstmt.setString(44,selectStrgSeriesRs.getString("RETAILER_ADR2"));
							updateStrgSeriesPstmt.setString(45,selectStrgSeriesRs.getString("RETAILER_ADR3"));
							updateStrgSeriesPstmt.setString(46,selectStrgSeriesRs.getString("RETAILER_NAME"));
							updateStrgSeriesPstmt.setString(47,selectStrgSeriesRs.getString("RETAILER_CODE"));
							updateStrgSeriesPstmt.setString(48,salesPersFrom);
							updateStrgSeriesPstmt.setString(49,selectStrgSeriesRs.getString("ROUTE_ID"));
							updateStrgSeriesPstmt.setString(50,selectStrgSeriesRs.getString("SC_CODE"));
							updateStrgSeriesPstmt.setString(51,"Y");

							updateStrgSeriesCount = updateStrgSeriesPstmt.executeUpdate();

						}

						System.out.println("updateStrgSeriesCount...."+updateStrgSeriesCount);


						String selectStatusHistSql = " SELECT TRAN_ID, TRAN_DATE, SALES_PERS, SC_CODE, CUST_TYPE, ITEM_SER, ROUTE_ID, EFF_FROM , " +
													 " VALID_UPTO, STATUS, CHG_DATE, CHG_USER, CHG_TERM, EDITFLAG " +
													 " FROM STRG_STATUS_HIST WHERE SALES_PERS = ? AND ROUTE_ID = ?" ;

						PreparedStatement statusHistPstmt = conn.prepareStatement(selectStatusHistSql);
						statusHistPstmt.setString(1,salesPersFrom);
						statusHistPstmt.setString(2,routeIdValue);
						ResultSet statusHistRs = statusHistPstmt.executeQuery();

						while(statusHistRs.next())
						{
							String updateStatusHistSql = " UPDATE STRG_STATUS_HIST SET TRAN_DATE = ?, SALES_PERS = ?, SC_CODE = ?, CUST_TYPE = ?," +
														 " ITEM_SER = ?, ROUTE_ID = ?, EFF_FROM = ? , " +
														 " VALID_UPTO = ?, STATUS = ?, CHG_DATE = ?, CHG_USER = ?, CHG_TERM = ?, EDITFLAG = ? " +
														 " WHERE SALES_PERS = ? AND ROUTE_ID = ? AND SC_CODE = ? AND STATUS = ? "  ;

							updatestatusHistPstmt = conn.prepareStatement(updateStatusHistSql);

							System.out.println("changed....................");
							Date e = statusHistRs.getDate("VALID_UPTO");
							Date e1 = statusHistRs.getDate("EFF_FROM");
							Date e2 = statusHistRs.getDate("CHG_DATE");
							Date e3 = statusHistRs.getDate("TRAN_DATE");
							SimpleDateFormat sformat = new SimpleDateFormat(genericUtility.getApplDateFormat());
							String EffForm = sformat.format(e1);
							String chgDate = sformat.format(e2);
							String tdate = sformat.format(e3);
							String vdate = sformat.format(e);
							String EffDate = genericUtility.getValidDateTimeString( EffForm, genericUtility.getApplDateFormat() , genericUtility.getDBDateFormat());
							String changeDate = genericUtility.getValidDateTimeString( chgDate ,  genericUtility.getApplDateFormat() , genericUtility.getDBDateFormat());
							String tranDate = genericUtility.getValidDateTimeString( tdate ,  genericUtility.getApplDateFormat() , genericUtility.getDBDateFormat());
							String validUpto = genericUtility.getValidDateTimeString( vdate ,  genericUtility.getApplDateFormat() , genericUtility.getDBDateFormat());

							//updatestatusHistPstmt.setString(1,statusHistRs.getString("TRAN_ID"));
							//updatestatusHistPstmt.setString(2,statusHistRs.getString("TRAN_DATE"));
							updatestatusHistPstmt.setTimestamp(1, java.sql.Timestamp.valueOf(tranDate));
							updatestatusHistPstmt.setString(2,salesPersTo);
							updatestatusHistPstmt.setString(3,statusHistRs.getString("SC_CODE"));
							updatestatusHistPstmt.setString(4,statusHistRs.getString("CUST_TYPE"));
							updatestatusHistPstmt.setString(5,statusHistRs.getString("ITEM_SER"));
							updatestatusHistPstmt.setInt(6,maxRouteId);
							//updatestatusHistPstmt.setString(8,statusHistRs.getString("EFF_FROM"));
							updatestatusHistPstmt.setTimestamp(7, java.sql.Timestamp.valueOf(EffDate));
							//updatestatusHistPstmt.setString(9,statusHistRs.getString("VALID_UPTO"));
							updatestatusHistPstmt.setTimestamp(8, java.sql.Timestamp.valueOf(validUpto));
							updatestatusHistPstmt.setString(9,statusHistRs.getString("STATUS"));
							//updatestatusHistPstmt.setString(11,statusHistRs.getString("CHG_DATE"));
							updatestatusHistPstmt.setTimestamp(10, java.sql.Timestamp.valueOf(changeDate));
							updatestatusHistPstmt.setString(11,statusHistRs.getString("CHG_USER"));
							updatestatusHistPstmt.setString(12,statusHistRs.getString("CHG_TERM"));
							updatestatusHistPstmt.setString(13,statusHistRs.getString("EDITFLAG"));
							updatestatusHistPstmt.setString(14,salesPersFrom);
							updatestatusHistPstmt.setString(15,statusHistRs.getString("ROUTE_ID"));
							updatestatusHistPstmt.setString(16,statusHistRs.getString("SC_CODE"));
							updatestatusHistPstmt.setString(17,"Y");

							updateStatusHistCount = updatestatusHistPstmt.executeUpdate();
						}




			    }
			}
			System.out.println("noOfRecSelect=["+noOfRecSelect+"] ,noOfRecUnlistSelect["+noOfRecUnlistSelect+"]");
			if ( noOfRecSelect == 0 )
			{
				retString = "<?xml version=\"1.0\"?><Root><Errors><error id=\"DS000NRL\" type=\"E\" column_name=\"\"><message>Process Not Done For Transfer Customer</message><description>No Route Found For Process, Please select the Record for process</description><type>E</type><option>Y</option><time>null</time><alarm>null</alarm><source>null</source><trace></trace><redirect>1</redirect></error></Errors></Root>";
			}
			else if(noOfRecUnlistSelect == 0)
			{
				retString = "<?xml version=\"1.0\"?><Root><Errors><error id=\"DS000NRUL\" type=\"E\" column_name=\"\"><message>Process Not Done For UnListed Customer  </message><description>No Route Found For Process, Please select the Record for process</description><type>E</type><option>Y</option><time>null</time><alarm>null</alarm><source>null</source><trace></trace><redirect>1</redirect></error></Errors></Root>";
			}
			else if (retString != null && retString.trim().length() > 0)
			{
				conn.rollback();
			}
			else
			{
				conn.commit();
				retString = itmDBAccessLocal.getErrorString( "", "VPROCESS1", userId );
			}
		}
		catch(SQLException se)
		{
			System.out.println("Exception : StrgRouteTransferPrc : process():" +se.getMessage());
			try
			{
				conn.rollback();
			}
			catch(Exception se1){}
			throw new ITMException(se);
		}
		catch(Exception e)
		{
			try
			{
				conn.rollback();
			}
			catch(Exception se1){}
			System.out.println( e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if ( pstmtSel1 != null )
				{
					pstmtSel1.close();
					pstmtSel1 = null;
				}
				if ( pstmtSel2 != null )
				{
					pstmtSel2.close();
					pstmtSel2 = null;
				}
				if ( pstmtIns1 != null )
				{
					pstmtIns1.close();
					pstmtIns1 = null;
				}
				if ( pstmtIns2 != null )
				{
					pstmtIns2.close();
					pstmtIns2 = null;
				}
				if ( conn != null )
				{
					conn.close();
					conn = null;
				}
			}
			catch (Exception e)
			{
				System.out.println(e.getMessage());
				e.printStackTrace();
			}
		}
		return retString;
	}
	private String checkNull(String input)
	{
		if (input==null)
		{
			input="";
		}
		return input;
	}
	protected InitialContext getInitialContext()throws ITMException
	{
		InitialContext ctx = null;
		try
		{
			AppConnectParm appConnect = new AppConnectParm();
			ctx = new InitialContext(appConnect.getProperty());
		}
		catch(ITMException itme)
		{
			System.out.println("ITMException :[StrgSeriesPsrCopyPrc] :getInitialContext :==>");
			throw itme;
		}
		catch(Exception e)
		{
			System.out.println("Exception :[StrgSeriesPsrCopyPrc] :getInitialContext :==>");
			throw new ITMException(e);
		}
		return ctx;
	}

    public boolean isEmpCodeFromValid(Connection conn, String empCodeFrom)throws ITMException, RemoteException
    {
    	System.out.println("isEmpCodeFromValid called.........");
		PreparedStatement pStmt = null;
		ResultSet rs = null;
		String sql = "";
		int spCntr = 0;
		boolean isExist = false;
		try
		{
			sql = " SELECT COUNT(*) AS SPCNTR FROM SPRS_ROUTE WHERE SPRS_CODE = ?";
			pStmt = conn.prepareStatement(sql);
			pStmt.setString(1, empCodeFrom);

			rs = pStmt.executeQuery();
			if (rs.next())
			{
				spCntr = rs.getInt("SPCNTR");
			}
			if (spCntr == 0)
			{
				isExist = true;
			}
		}
		catch (Exception ex)
		{
			System.out.println(":: [isEmpCodeFromValid () ] :: "+ ex.getMessage());
			throw new ITMException(ex);
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pStmt != null)
				{
					pStmt.close();
					pStmt = null;
				}
			}
			catch (SQLException ex)
			{
				System.out.println(":: [isEmpCodeFromValid ()] [Finally] :: "+ ex.getMessage());
				throw new ITMException(ex);
			}
		}
		return isExist;
    }

    public boolean isEmpCodeToValid(Connection conn, String empCodeTo)throws ITMException, RemoteException
	{
    	System.out.println("isEmpCodeToValid called.........");
		PreparedStatement pStmt = null;
		ResultSet rs = null;
		String sql = "";
		int spCntr = 0;
		boolean isExist = false;
		try
		{
			sql = " SELECT COUNT(*) AS SPCNTR FROM SPRS_ROUTE WHERE SPRS_CODE = ?";
			pStmt = conn.prepareStatement(sql);
			pStmt.setString(1, empCodeTo);

			rs = pStmt.executeQuery();
			if (rs.next())
			{
				spCntr = rs.getInt("SPCNTR");
			}
			if (spCntr == 0)
			{
				isExist = true;
			}
		}
		catch (Exception ex)
		{
		System.out.println(":: [isEmpCodeToValid () ] :: "+ ex.getMessage());
		throw new ITMException(ex);
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pStmt != null)
				{
					pStmt.close();
					pStmt = null;
				}
			}
			catch (SQLException ex)
			{
				System.out.println(":: [isEmpCodeToValid ()] [Finally] :: "+ ex.getMessage());
				throw new ITMException(ex);
			}
		}
		return isExist;
	}

	@Override
	public String process() throws RemoteException, ITMException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public void remove() {
		// TODO Auto-generated method stub

	}

	@Override
	public String getData(String arg0, String arg1, String arg2, String arg3,
			UserInfoBean arg4) throws RemoteException, ITMException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public String getData(Document arg0, Document arg1, String arg2,
			String arg3, UserInfoBean arg4) throws RemoteException,
			ITMException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public String process(Document arg0, Document arg1, String arg2,
			String arg3, UserInfoBean arg4) throws RemoteException,
			ITMException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public String process(String arg0, String arg1, String arg2, String arg3,
			UserInfoBean arg4) throws RemoteException, ITMException {
		// TODO Auto-generated method stub
		return null;
	}

}