package ibase.webitm.ejb.wsfa.masters;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;

import javax.ejb.Stateless;
import javax.naming.InitialContext;

import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.DBAccessLocal;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import ibase.wrkflw.utility.WorkflowLogger;
import oracle.jdbc.OracleConnection;
import oracle.sql.CLOB;

/* 
	 Author Name: Sachin Satre on [19-Apr-19] 
 	 Created Date : 26-Apr-19 
*/

@Stateless
public class SprsRouteConfirmation extends ValidatorEJB  
{
	E12GenericUtility genericUtility = new E12GenericUtility();
	public String routeApprove( String refID ,String xmlData ,String signBy ,String refSer, String SalesPers, String appoverCode ,String userInfoStr )throws RemoteException, ITMException
	{
		//String xtraParams ="";
		System.out.println("[routeApprove] SprsRouteConfirmation Method called..."+signBy+"]::appoverCode:::["+appoverCode+"]");
		System.out.println("tranID : ["+refID+"]");
		System.out.println("xmlData : ["+xmlData+"]");
		System.out.println("refSer : ["+refSer+"]");
		boolean isError=false;
		Connection connectionObject = null;		
		PreparedStatement pstmt = null;
		PreparedStatement pstmtInner = null;
		ResultSet rs = null;
		ResultSet rsInner = null;
		String childNodeName = "";
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null; 	
		int updCnt = 0;
		int parentNodeListLength = 0;
		int childNodeListLength = 0;	
		int noOfRecProcess = 0;
		String noVisit = "";
		String splCode = "";
		String classCode = "";
		String category = "";
		String noPatientDay = "";
		String businessToUs = "";
		String totalBusiness = "";
		String loginEmpCode = "";
		String chgTerm = "";
		String userId = "";
		String warningStr = "";
		String itemSer = "";
		String spCode = "";
		String scCode = "";
		String routeId = "";
		//String status = "";
		String statusx = "";
		String sqlStr = null;
		String qualification="";
		String emailId="";
		String mobileNo="";
		Statement stmt = null;
		String returnString = "<ROOT><STATUS><![CDATA[1]]></STATUS><RESULT><![CDATA[Success]]></RESULT></ROOT>";
		String updtSql = "";
		String tranId ="";
		String lineNo ="";
		String occuType ="";
		String subSplCode ="";
		String rxMode ="";
		String patientProfile ="";
		String ageBracket ="";
		String assoType ="";
		
		String noVisitExists ="";
		String splCodeExists ="";
		String classCodeExists ="";
		String categoryExists ="";
		String noPatientDayExists ="";
		String businessToUsExists ="";
		String totalBusinessExists ="";
		String qualificationExists ="";
		String mobileNoExists ="";
		String emailIdExists ="";
		
		String occuTypeExists ="";
		String subSplCodeExists ="";
		String rxModeExists ="";
		String patientProfileExists ="";
		String ageBracketExists ="";
		String assoTypeExists ="";
		String updateFlag ="";
		
		try
		{
			
			ConnDriver connDriver = null;
			connDriver = new ConnDriver();
			//connectionObject = connDriver.getConnectDB("DriverValidator");
			//connectionObject = connDriver.getConnectDB("DriverITM");
			 
			
			String transDB="";
			System.out.println("Inside expenseConfirm confirm section: "+userInfoStr);
			UserInfoBean userInfo = new UserInfoBean(userInfoStr);
			if(userInfo!=null)
			{	
				transDB = userInfo.getTransDB();
			}
	    	System.out.println("get TransDB connection in expenseConfirm : "+transDB);
	    	
		    if (transDB != null && transDB.trim().length() > 0)
		    {
		    	connectionObject = connDriver.getConnectDB(transDB);
		    }
		    else
		    {
		    	connectionObject = connDriver.getConnectDB("DriverITM");
		    }
		    connectionObject.setAutoCommit( false );
			//connectionObject.setAutoCommit( false ); 
			Document dom = genericUtility.parseString(xmlData);
			// to find record COUNT for CONFIRMED ='A' [End]
			//Added By Nilesh For getting updated Flag Start :: 27-05-19
			parentNodeList = dom.getElementsByTagName("Detail1");
			parentNodeListLength = parentNodeList.getLength(); 
			for (int selectedRow = 0; selectedRow < parentNodeListLength; selectedRow++)
			{				
				parentNode = parentNodeList.item(selectedRow);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();
				System.out.println("childNodeListLength::routeApprove: "+ childNodeListLength+"\n");

				for (int childRow = 0; childRow < childNodeListLength; childRow++)
				{
					childNode = childNodeList.item(childRow);
					childNodeName = childNode.getNodeName();	
					if("attribute".equalsIgnoreCase(childNodeName))
					{
						if(childNode.getAttributes().getNamedItem("updateFlag") != null)
						{
							updateFlag = childNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
						}
					}

					
				}
			}	
			//Added By Nilesh For getting updated Flag End :: 27-05-19
			
			String salesPersDom = checkNull(genericUtility.getColumnValue("sprs_code",dom));
			String routeIdDom = checkNull(genericUtility.getColumnValue("route_id",dom));
			String localityCodeDom  = checkNull(genericUtility.getColumnValue("locality_code",dom));
			String stanCode  = checkNull(genericUtility.getColumnValue("stan_code",dom));
			String stationDescr  = checkNull(genericUtility.getColumnValue("station_descr",dom));
			String routeType  = checkNull(genericUtility.getColumnValue("route_type",dom));
			String stationType  = checkNull(genericUtility.getColumnValue("station_type",dom));
			String status  = checkNull(genericUtility.getColumnValue("status",dom));
			String empCodeAprv  = checkNull(genericUtility.getColumnValue("emp_code__aprv",dom));
			String routeDescr  = checkNull(genericUtility.getColumnValue("route_descr",dom));
            String routePath  = checkNull(genericUtility.getColumnValue("route_path",dom));
            String planDays  = checkNull(genericUtility.getColumnValue("plan_days",dom)); // Added by Pankaj R on 20-JUL-21 to save the planDay on edit mode
            String remarks  = checkNull(genericUtility.getColumnValue("remarks",dom)); // Added by Hariom S on 07-OCT-21 to remarks filed update

			System.out.println("status..["+status+"]");
			System.out.println("updateFlag..["+updateFlag+"]");
            System.out.println("empCodeAprv..["+empCodeAprv+"]");
            System.out.println("planDays..["+planDays+"]");
			
			String tourCntSql = "SELECT count(*) as cnt FROM SPRS_ROUTE WHERE SPRS_CODE = ?  AND LOCALITY_CODE = ?  AND ROUTE_ID = ? ";
			pstmtInner = connectionObject.prepareStatement(tourCntSql);
			pstmtInner.setString(1, salesPersDom);
			pstmtInner.setString(2,  localityCodeDom);
			pstmtInner.setString(3, routeIdDom);
			rsInner = pstmtInner.executeQuery();
			int submitCnt = 0;
			if ( rsInner.next() )
			{				
				submitCnt = rsInner.getInt("cnt");
			}
			System.out.println("submitCnt..["+submitCnt+"]");
			if ( rsInner != null )
			{
				rsInner.close();
				rsInner = null;
			}
			if ( pstmtInner != null )
			{
				pstmtInner.close();
				pstmtInner = null;
			}
			/*if (submitCnt == 0)
			{
				System.out.println("Inside the block of tour ID not sibmitted, now will throw exception");
				Exception exp = new Exception("Transaction Not Submitted");
				//generateLog( exp, tourID, "\r\n XML Data received as below : \r\n "+xmlData+" \r\n","TOUR");
				throw new Exception("Tour Not Submitted");
			}*/
			java.sql.Timestamp chgDate = new java.sql.Timestamp(System.currentTimeMillis()); 
			//userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			//chgTerm = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"termId");
			userId=appoverCode.trim() ;
			//Added By Nilesh For Add Mode need to update the status As Y Start :: 27-05-19
			if(updateFlag.equalsIgnoreCase("A") && status.equalsIgnoreCase("N"))
			{
				//System.out.println("::Updated into LOCALITY successfully [updCnt] SS:"+updCnt);
				//String updateSql ="UPDATE  LOCALITY SET APRV_STAT ='A' , STATUS = 'A' ,EMP_CODE__APRV = '" + userId + "'  WHERE LOCALITY_CODE = '" + localityCode + "' ";
				String updateSql = "UPDATE SPRS_ROUTE SET   WF_STATUS ='A' ,EMP_CODE__APRV = '" + userId + "' ,APRV_DATE = SYSDATE , STATUS='Y'  WHERE SPRS_CODE = ?  AND LOCALITY_CODE = ?  AND ROUTE_ID = ? "; 
				pstmtInner = connectionObject.prepareStatement(updateSql);
				//pstmtInner.setString(1 , userId);
				//pstmtInner.setTimestamp(2,chgDate);
				pstmtInner.setString(1, salesPersDom);
				pstmtInner.setString(2,  localityCodeDom);
				pstmtInner.setString(3, routeIdDom);
				updCnt = 0;
				updCnt = pstmtInner.executeUpdate();
			}
			else
			{
				System.out.println("userId..["+userId+"]");
				if("null".equalsIgnoreCase(userId) || userId.trim().length() == 0 )
				{
					userId = empCodeAprv;
				}
				//System.out.println("::Updated into LOCALITY successfully [updCnt] SS:"+updCnt);
				//String updateSql ="UPDATE  LOCALITY SET APRV_STAT ='A' , STATUS = 'A' ,EMP_CODE__APRV = '" + userId + "'  WHERE LOCALITY_CODE = '" + localityCode + "' ";
                //String updateSql = "UPDATE SPRS_ROUTE SET   WF_STATUS ='A' ,EMP_CODE__APRV = '" + userId + "' ,APRV_DATE = SYSDATE  WHERE SPRS_CODE = ?  AND LOCALITY_CODE = ?  AND ROUTE_ID = ? "; 
                // Commented and Added by Pankaj R on 20-JUL-21 to update the planDays on edit [START]
                //String updateSql = "UPDATE SPRS_ROUTE SET   WF_STATUS ='A',route_path = '"+routePath+"' ,EMP_CODE__APRV = '" + userId + "' ,APRV_DATE = SYSDATE, STATUS = '" + status + "' , ROUTE_DESCR = '"+routeDescr+"' WHERE SPRS_CODE = ?  AND LOCALITY_CODE = ?  AND ROUTE_ID = ? "; 
                String updateSql = "UPDATE SPRS_ROUTE SET   WF_STATUS ='A',route_path = '"+routePath+"' ,EMP_CODE__APRV = '" + userId + "' ,APRV_DATE = SYSDATE, STATUS = '" + status + "' , ROUTE_DESCR = '"+routeDescr+"', plan_days = ?, remarks = ? WHERE SPRS_CODE = ?  AND LOCALITY_CODE = ?  AND ROUTE_ID = ? "; 
                // Commented and Added by Pankaj R on 20-JUL-21 to update the planDays on edit [END]
				pstmtInner = connectionObject.prepareStatement(updateSql);
				//pstmtInner.setString(1 , userId);
                //pstmtInner.setTimestamp(2,chgDate);				
                pstmtInner.setString(1, planDays);
                pstmtInner.setString(2, remarks);
				pstmtInner.setString(3, salesPersDom);
				pstmtInner.setString(4,  localityCodeDom);
				pstmtInner.setString(5, routeIdDom);
				updCnt = 0;
				updCnt = pstmtInner.executeUpdate();
			}
			//Added By Nilesh For Add Mode need to update the status As Y End :: 27-05-19
			System.out.println("updCnt:LOCALITY in amd table:::::["+updCnt+"]");
			if ( pstmtInner != null )
			{
				pstmtInner.close();
				pstmtInner = null;
			}
			String updateSqlOther = "UPDATE SPRS_ROUTE SET  ROUTE_TYPE = ? ,STATION_TYPE = ? , STAN_CODE = ? WHERE SPRS_CODE = ?  AND LOCALITY_CODE = ?  "; 
			pstmtInner = connectionObject.prepareStatement(updateSqlOther);
			pstmtInner.setString(1, routeType);
			pstmtInner.setString(2,  stationType);
			pstmtInner.setString(3,  stanCode);
			pstmtInner.setString(4, salesPersDom);
			pstmtInner.setString(5,  localityCodeDom);
			updCnt = 0;
			updCnt = pstmtInner.executeUpdate();
			System.out.println("updCnt:LOCALITY in amd table:::::["+updCnt+"]");
			if ( pstmtInner != null )
			{
				pstmtInner.close();
				pstmtInner = null;
			}
			/*if(updCnt > 0 )
			{*/
				isError = insertRouteHistory( dom,  appoverCode, connectionObject) ;
				System.out.println("isError::["+isError+"]");
			/*}	*/

		}
		catch (SQLException se)
		{
			try
			{
				isError=true;
				connectionObject.rollback();
			}
			catch(Exception sqe)
			{
				sqe.printStackTrace();
				isError=true; 
				returnString = "<ROOT><STATUS><![CDATA[0]]></STATUS><RESULT><![CDATA[Rollback failed during SQLException]]></RESULT></ROOT>";
           }
 			returnString = "<ROOT><STATUS><![CDATA[0]]></STATUS><RESULT><![CDATA[Some SQLException occurred ]]></RESULT></ROOT>";

		}
		catch( Exception ex )
		{
			try
			{
				connectionObject.rollback();
				isError=true;
			}
			catch(Exception e)
			{
				e.printStackTrace();
				isError=true;
            }
			returnString = "<ROOT><STATUS><![CDATA[0]]></STATUS><RESULT><![CDATA[Some other Exception came]]></RESULT></ROOT>";
		}
		finally
		{
			try
			{
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(!isError)
				{
					connectionObject.commit();
					System.out.println("Connection committed.");
				}
				if(connectionObject != null)
				{
					connectionObject.close();
					connectionObject = null;
				}				
			}
			catch ( Exception e)
			{
				e.printStackTrace();
			}		
		}
		return returnString;
	}

	public boolean insertRouteHistory(Document dom, String approverCode,Connection conn) throws ITMException
	{
		System.out.println("insertRouteHistory::called");
		PreparedStatement pstmtInsert = null;
		boolean isError = false;
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null; 	
		int parentNodeListLength = 0;
		int childNodeListLength = 0;
		String childNodeName = "";
		Document dom2 = null;	
		String tranId ="";
		String sprs_code = ""; 
		String locality_code ="";
		String route_type ="";
		String station_type="";
		String status ="";
		String route_id ="";
		String stan_code ="";
		String route_descr ="";
		String chg_date ="";
		String newTranId="";
		PreparedStatement pStmt = null;
		ResultSet rs = null;
		PreparedStatement pstmtInner = null;
		ResultSet rsInner = null;
		try
		{
			E12GenericUtility genericUtility = new E12GenericUtility();
			String applFormat = genericUtility.getApplDateFormat();
			Calendar calDate = Calendar.getInstance();
			SimpleDateFormat simpleDateFormat = new SimpleDateFormat(applFormat);
			String currDateStr = simpleDateFormat.format(calDate.getTime());
			
			currDateStr = genericUtility.getValidDateTimeString( currDateStr, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ;
			//dom2 = genericUtility.parseString(XmlString);
			parentNodeList = dom.getElementsByTagName("Detail1");
			parentNodeListLength = parentNodeList.getLength(); 
			for (int selectedRow = 0; selectedRow < parentNodeListLength; selectedRow++)
			{				
				parentNode = parentNodeList.item(selectedRow);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();
				System.out.println("childNodeListLength::insertRouteHistory: "+ childNodeListLength+"\n");

				for (int childRow = 0; childRow < childNodeListLength; childRow++)
				{
					childNode = childNodeList.item(childRow);
					childNodeName = childNode.getNodeName();					
					
					if (childNodeName.equals("sprs_code"))
					{
						if(childNode.getFirstChild()!=null)
						{
							sprs_code = childNode.getFirstChild().getNodeValue();
						}
						System.out.println("[insertRouteHistory][process()][sprs_code:::]" +sprs_code);
					}
					if (childNodeName.equals("locality_code"))
					{
						if(childNode.getFirstChild()!=null)
						{
							locality_code = childNode.getFirstChild().getNodeValue();
						}
						System.out.println("[insertRouteHistory][process()][locality_code:::]" +locality_code);
					}
					if (childNodeName.equals("route_type"))
					{
						if(childNode.getFirstChild()!=null)
						{
							route_type = childNode.getFirstChild().getNodeValue();
						}
						System.out.println("[insertRouteHistory][process()][route_type:::]" +route_type);
					}
					if (childNodeName.equals("station_type"))
					{
						if(childNode.getFirstChild()!=null)
						{
							station_type = childNode.getFirstChild().getNodeValue();
						}
						System.out.println("[insertRouteHistory][process()][station_type:::]" +station_type);
					}
					if (childNodeName.equals("status"))
					{
						if(childNode.getFirstChild()!=null)
						{
							status = childNode.getFirstChild().getNodeValue();
						}
						System.out.println("[insertRouteHistory][process()][status:::]" +status);
					}
					if (childNodeName.equals("route_id"))
					{
						if(childNode.getFirstChild()!=null)
						{
							route_id = childNode.getFirstChild().getNodeValue();
						}
						System.out.println("[insertRouteHistory][process()][route_id:::]" +route_id);
					}
					if (childNodeName.equals("stan_code"))
					{
						if(childNode.getFirstChild()!=null)
						{
							stan_code = childNode.getFirstChild().getNodeValue();
						}
						System.out.println("[insertRouteHistory][process()][stan_code:::]" +stan_code);
					}
					if (childNodeName.equals("route_descr"))
					{
						if(childNode.getFirstChild()!=null)
						{
							route_descr = childNode.getFirstChild().getNodeValue();
						}
						System.out.println("[insertRouteHistory][process()][route_descr:::]" +route_descr);
					}
					if (childNodeName.equals("chg_date"))
					{
						if(childNode.getFirstChild()!=null)
						{
							chg_date = childNode.getFirstChild().getNodeValue();
						}
						System.out.println("[insertRouteHistory][process()][chg_date:::]" +chg_date);
					}
				} 
			}
			
			
			
		/*	String salesPersDom = checkNull(genericUtility.getColumnValue("sprs_code",dom));
			String routeIdDom = checkNull(genericUtility.getColumnValue("route_id",dom));
			String localityCodeDom  = checkNull(genericUtility.getColumnValue("locality_code",dom));*/
			
			String tourCntSql = "SELECT status FROM SPRS_ROUTE WHERE SPRS_CODE = ?  AND LOCALITY_CODE = ?  AND ROUTE_ID = ? ";
			pstmtInner = conn.prepareStatement(tourCntSql);
			pstmtInner.setString(1, sprs_code);
			pstmtInner.setString(2,  locality_code);
			pstmtInner.setString(3, route_id);
			rsInner = pstmtInner.executeQuery();
			String submitFinal = "";
			if ( rsInner.next() )
			{				
				submitFinal = checkNull(rsInner.getString("status"));
			}
			System.out.println("submitFinal..["+submitFinal+"]");
			if ( rsInner != null )
			{
				rsInner.close();
				rsInner = null;
			}
			if ( pstmtInner != null )
			{
				pstmtInner.close();
				pstmtInner = null;
			}
			
			String TranIdSeq = "";
			int count = 0;
			String nextseqQuery = " SELECT ROUTE_TRAN_ID_SEQ.NEXTVAL AS NEW_TRAN_ID FROM DUAL ";
			pStmt = conn.prepareStatement(nextseqQuery);

			rs = pStmt.executeQuery();
			while(rs.next())
			{				
				TranIdSeq = rs.getString("NEW_TRAN_ID");
			}
		    int newTranIdLen = 0;
		   
		    if( TranIdSeq != null && TranIdSeq.trim().length() > 0 )
			{
				newTranId = "0000000000"+TranIdSeq;
				newTranIdLen = newTranId.trim().length();
				newTranId = newTranId.substring(newTranIdLen-10, newTranIdLen);
			}
			else
			{
				newTranId = "0000000001";
				System.out.println("Create sequence ROUTE_TRAN_ID_SEQ [ Refer office sql ] in case duplicate tran_id issue...");
			}
		    System.out.println("newTranId =["+newTranId+"]");
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pStmt != null)
			{
				pStmt.close();
				pStmt = null;
			}
			chg_date = genericUtility.getValidDateTimeString( chg_date, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ;
			
			String insertRouteHistSql= "INSERT INTO ROUTE_STATUS_HIST (TRAN_ID ,TRAN_DATE ,SPRS_CODE ,ROUTE_ID ,LOCALITY_CODE ,"
					+ "STAN_CODE, ROUTE_TYPE, STATION_TYPE ,STATUS ,ROUTE_DESCR ,EMP_CODE__APRV ,APRV_DATE )"
					+ " VALUES (? ,? ,? ,?, ?, ? ,? ,? ,? ,?  ,? ,?)";
			pstmtInsert = conn.prepareStatement(insertRouteHistSql);
			
			pstmtInsert.setString(1, newTranId);
			pstmtInsert.setTimestamp(2, java.sql.Timestamp.valueOf(chg_date) );
			pstmtInsert.setString(3, sprs_code );
			pstmtInsert.setString(4, route_id);
			pstmtInsert.setString(5, locality_code);
			pstmtInsert.setString(6, stan_code);
			pstmtInsert.setString(7, route_type);
			pstmtInsert.setString(8, station_type);
			pstmtInsert.setString(9, submitFinal);//status
			pstmtInsert.setString(10, route_descr);
			pstmtInsert.setString(11, approverCode);
			pstmtInsert.setTimestamp(12, java.sql.Timestamp.valueOf(currDateStr) );

			int insertCnt = pstmtInsert.executeUpdate();
			System.out.println("insertCnt =["+insertCnt+"]");
			

		}
		catch(Exception e)
		{
			isError = true;
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(pstmtInsert != null)
				{
					pstmtInsert.close();
					pstmtInsert = null;
				}
			}
			catch(Exception ex)
			{
				
			}
		}
		return isError;
	}
	public String rejectionUpdate(String localitCode ,String userInfoStr ,String salesPersDom , String routeIdDom , String routeDescr ) throws RemoteException, ITMException 
	{

		System.out.println("rejectionUpdate CAALED");
		Connection conn = null;
		PreparedStatement pStmt = null;
		ConnDriver connDriver = null;
		boolean isError = false;
		int upateCnt =0;
		//String salesPers ="";
		ResultSet rs1= null;
		ResultSet rs2= null;
		PreparedStatement pstmt1 = null;
		PreparedStatement pstmt2 = null; 
		int stpCount=0;
		String retString = "<ROOT><STATUS><![CDATA[1]]></STATUS><RESULT><![CDATA[ Rejected successfully ]]></RESULT></ROOT>";
		try
		{
			/*connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");
			connDriver = null;*/
			//ConnDriver connDriver = null;
			connDriver = new ConnDriver();
			
			String transDB="";
			System.out.println("Inside BeatConfirm confirm section: "+userInfoStr);
			UserInfoBean userInfo = new UserInfoBean(userInfoStr);
			if(userInfo!=null)
			{	
				transDB = userInfo.getTransDB();
			}
	    	System.out.println("get TransDB connection in expenseConfirm : "+transDB);
	    	
		    if (transDB != null && transDB.trim().length() > 0)
		    {
		    	conn = connDriver.getConnectDB(transDB);
		    }
		    else
		    {
		    	conn = connDriver.getConnectDB("DriverITM");
		    }
		    conn.setAutoCommit( false );

			System.out.println("localitCode ..> " + localitCode);
			localitCode = checkNull(localitCode);
			int updCnt = 0;

			//String sql = "UPDATE LOCALITY SET WF_STATUS = 'D' , APRV_STAT='P' ,STATUS = 'N' WHERE LOCALITY_CODE = ?"; //confirm
			String sql =  "UPDATE SPRS_ROUTE SET  WF_STATUS ='R'  WHERE SPRS_CODE = ?  AND LOCALITY_CODE = ?  AND ROUTE_ID = ? ";
			pStmt = conn.prepareStatement(sql);
			pStmt.setString(1, salesPersDom);
			pStmt.setString(2, localitCode);
			pStmt.setString(3, routeIdDom);
			updCnt = pStmt.executeUpdate();
			pStmt.clearParameters();
			System.out.println("in rejection records updated count is >>> "+updCnt);
			
			if(updCnt == 0)
			{
				retString = "<ROOT><STATUS><![CDATA[0]]></STATUS><RESULT><![CDATA[ Rejection Update failed for tran_id "+localitCode+"  ]]></RESULT></ROOT>";
			}
			System.out.println("updCntupdCnt:::["+updCnt+"]");
		} 
		catch (Exception e) 
		{
			isError = true;
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally 
		{
			if (conn != null) 
			{
				try 
				{
					if (isError) 
					{
						conn.rollback();
						System.out.println("BeatConfirm Connection Rollback");
					} 
					else 
					{
						conn.commit();
						System.out.println("BeatConfirm Connection Commit");
					}
					if(pStmt != null)
					{
						pStmt.close();
						pStmt = null;
					}
					if(conn != null)
					{
						conn.close();
						conn = null;
					}													
					
				}
				catch (Exception e) 
				{
					e.printStackTrace();
				}
			}
		}
		return retString;
	}
	public String checkMode( String refID ,String xmlData ,String signBy ,String refSer, String SalesPers, String appoverCode ,String userInfoStr )throws RemoteException, ITMException
	{
		//String xtraParams ="";
		System.out.println("[checkMode] SprsRouteConfirmation Method called..."+signBy+"]::appoverCode:::["+appoverCode+"]");
		System.out.println("tranID : ["+refID+"]");
		System.out.println("xmlData : ["+xmlData+"]");
		System.out.println("refSer : ["+refSer+"]");
		boolean isError=false;
		Connection connectionObject = null;		
		PreparedStatement pstmt = null;
		PreparedStatement pstmtInner = null;
		ResultSet rs = null;
		ResultSet rsInner = null;
		String childNodeName = "";
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null; 	
		int updCnt = 0;
		int parentNodeListLength = 0;
		int childNodeListLength = 0;	
		int noOfRecProcess = 0;
		String noVisit = "";
		String splCode = "";
		String classCode = "";
		String category = "";
		String noPatientDay = "";
		String businessToUs = "";
		String totalBusiness = "";
		String loginEmpCode = "";
		String chgTerm = "";
		String userId = "";
		String warningStr = "";
		String itemSer = "";
		String spCode = "";
		String scCode = "";
		String routeId = "";
		String status = "";
		String statusx = "";
		String sqlStr = null;
		String qualification="";
		String emailId="";
		String mobileNo="";
		Statement stmt = null;
		String returnString = "<ROOT><STATUS><![CDATA[1]]></STATUS><RESULT><![CDATA[Success]]></RESULT></ROOT>";
		String updtSql = "";
		String tranId ="";
		String lineNo ="";
		String occuType ="";
		String subSplCode ="";
		String rxMode ="";
		String patientProfile ="";
		String ageBracket ="";
		String assoType ="";
		
		String noVisitExists ="";
		String splCodeExists ="";
		String classCodeExists ="";
		String categoryExists ="";
		String noPatientDayExists ="";
		String businessToUsExists ="";
		String totalBusinessExists ="";
		String qualificationExists ="";
		String mobileNoExists ="";
		String emailIdExists ="";
		
		String occuTypeExists ="";
		String subSplCodeExists ="";
		String rxModeExists ="";
		String patientProfileExists ="";
		String ageBracketExists ="";
		String assoTypeExists ="";
		String updateFlag ="";
		String retString = "0";
		try
		{
			
			ConnDriver connDriver = null;
			connDriver = new ConnDriver();
			//connectionObject = connDriver.getConnectDB("DriverValidator");
			//connectionObject = connDriver.getConnectDB("DriverITM");
			 
			
			String transDB="";
			System.out.println("Inside expenseConfirm confirm section: "+userInfoStr);
			UserInfoBean userInfo = new UserInfoBean(userInfoStr);
			if(userInfo!=null)
			{	
				transDB = userInfo.getTransDB();
			}
	    	System.out.println("get TransDB connection in expenseConfirm : "+transDB);
	    	
		    if (transDB != null && transDB.trim().length() > 0)
		    {
		    	connectionObject = connDriver.getConnectDB(transDB);
		    }
		    else
		    {
		    	connectionObject = connDriver.getConnectDB("DriverITM");
		    }
		    connectionObject.setAutoCommit( false );
			//connectionObject.setAutoCommit( false ); 
			Document dom = genericUtility.parseString(xmlData);
			// to find record COUNT for CONFIRMED ='A' [End]
			
			String salesPersDom = checkNull(genericUtility.getColumnValue("sprs_code",dom));
			String routeIdDom = checkNull(genericUtility.getColumnValue("route_id",dom));
			String localityCodeDom  = checkNull(genericUtility.getColumnValue("locality_code",dom));
			
			String tourCntSql = "SELECT count(*) as cnt FROM SPRS_ROUTE WHERE SPRS_CODE = ?  AND LOCALITY_CODE = ?  AND ROUTE_ID = ? ";
			pstmtInner = connectionObject.prepareStatement(tourCntSql);
			pstmtInner.setString(1, salesPersDom);
			pstmtInner.setString(2,  localityCodeDom);
			pstmtInner.setString(3, routeIdDom);
			rsInner = pstmtInner.executeQuery();
			int submitCnt = 0;
			if ( rsInner.next() )
			{				
				submitCnt = rsInner.getInt("cnt");
			}
			System.out.println("submitCnt..["+submitCnt+"]");
			if ( rsInner != null )
			{
				rsInner.close();
				rsInner = null;
			}
			if ( pstmtInner != null )
			{
				pstmtInner.close();
				pstmtInner = null;
			}
			
			if (submitCnt > 0)
			{
				//retString = "1";
				retString = "<ROOT><STATUS><![CDATA[1]]></STATUS></ROOT>";
			}
			else
			{
				//retString = "0";
				retString = "<ROOT><STATUS><![CDATA[0]]></STATUS></ROOT>";
			}	
			/*if (submitCnt == 0)
			{
				System.out.println("Inside the block of tour ID not sibmitted, now will throw exception");
				Exception exp = new Exception("Transaction Not Submitted");
				//generateLog( exp, tourID, "\r\n XML Data received as below : \r\n "+xmlData+" \r\n","TOUR");
				throw new Exception("Tour Not Submitted");
			}*/
			/*java.sql.Timestamp chgDate = new java.sql.Timestamp(System.currentTimeMillis()); 
			//userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			//chgTerm = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"termId");
			userId=appoverCode.trim() ;
			//System.out.println("::Updated into LOCALITY successfully [updCnt] SS:"+updCnt);
			//String updateSql ="UPDATE  LOCALITY SET APRV_STAT ='A' , STATUS = 'A' ,EMP_CODE__APRV = '" + userId + "'  WHERE LOCALITY_CODE = '" + localityCode + "' ";
			String updateSql = "UPDATE SPRS_ROUTE SET STATUS ='Y',  WF_STATUS ='A' ,EMP_CODE__APRV = '" + userId + "' ,APRV_DATE = SYSDATE  WHERE SPRS_CODE = ?  AND LOCALITY_CODE = ?  AND ROUTE_ID = ? "; 
			pstmtInner = connectionObject.prepareStatement(updateSql);
			//pstmtInner.setString(1 , userId);
			//pstmtInner.setTimestamp(2,chgDate);
			pstmtInner.setString(1, salesPersDom);
			pstmtInner.setString(2,  localityCodeDom);
			pstmtInner.setString(3, routeIdDom);
			updCnt = 0;
			updCnt = pstmtInner.executeUpdate();
			System.out.println("updCnt:LOCALITY in amd table:::::["+updCnt+"]");
			if ( pstmtInner != null )
			{
				pstmtInner.close();
				pstmtInner = null;
			}
			if(updCnt > 0 )
			{
				isError = insertRouteHistory( dom,  appoverCode, connectionObject) ;
				System.out.println("isError::["+isError+"]");
			}	*/

		}
		catch (SQLException se)
		{
			try
			{
				isError=true;
				connectionObject.rollback();
			}
			catch(Exception sqe)
			{
				sqe.printStackTrace();
				isError=true; 
				returnString = "<ROOT><STATUS><![CDATA[0]]></STATUS><RESULT><![CDATA[Rollback failed during SQLException]]></RESULT></ROOT>";
           }
 			returnString = "<ROOT><STATUS><![CDATA[0]]></STATUS><RESULT><![CDATA[Some SQLException occurred ]]></RESULT></ROOT>";

		}
		catch( Exception ex )
		{
			try
			{
				connectionObject.rollback();
				isError=true;
			}
			catch(Exception e)
			{
				e.printStackTrace();
				isError=true;
            }
			returnString = "<ROOT><STATUS><![CDATA[0]]></STATUS><RESULT><![CDATA[Some other Exception came]]></RESULT></ROOT>";
		}
		finally
		{
			try
			{
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(!isError)
				{
					connectionObject.commit();
					System.out.println("Connection committed.");
				}
				if(connectionObject != null)
				{
					connectionObject.close();
					connectionObject = null;
				}				
			}
			catch ( Exception e)
			{
				e.printStackTrace();
			}		
		}
		System.out.println("before return ..["+retString+"]");
		return retString ;
	}

	private String checkNull(String input)
	{
		if (input==null)
		{
			input="";
		}
		else
		{
			input = input.trim();
		}
		return input;
	}
	public String getObjSignTransXmlData(String refSer,String refId,Connection conn) throws ITMException
	{
		System.out.println("getXmlDataObjSign called:::");
		System.out.println("");
		String retStr= "";
		try
		{
			String query1 = "";						
			
			if ( "oracle".equalsIgnoreCase( CommonConstants.DB_NAME )) 
			{
				query1 =  "SELECT WF.TRANS_INFO_XML.getClobval() FROM obj_sign_trans WF WHERE REF_SER = ? AND REF_ID = ? AND SIGN_STATUS = 'R' ";
			}
			else
			{
				query1 = "SELECT TRANS_INFO_XML FROM obj_sign_trans  WHERE REF_SER = ? AND REF_ID = ?  AND SIGN_STATUS = 'R' ";
			}	
			
			ArrayList bindVarValues1 = new ArrayList();
			bindVarValues1.add(refSer.trim());
			bindVarValues1.add(refId.trim());
			
			ArrayList bindVarTypes1 = new ArrayList();
			bindVarTypes1.add("String");
			
			//For DB2 Compatibility
			bindVarTypes1.add("Int");
			
			
			System.out.println("Getting BLOB obj signtrans from DBAccessEJB in SignManagerEJB sign4");
			String wfData1 ="";
			if( "oracle".equalsIgnoreCase( CommonConstants.DB_NAME ) )
			{	
				retStr = getXMLTypeStr( conn, query1, bindVarValues1, bindVarTypes1 );
			}
			else
			{
				retStr = getDBAccessObj().getBlob(query1, bindVarValues1, bindVarTypes1);
			}
			
			
		} 
		catch (Exception e) 
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		System.out.println("retStr string in getXmlDataObjSign::["+retStr+"]");
		return retStr;
		
	}
	private String getXMLTypeStr( Connection con, String query, ArrayList bindVarValues, ArrayList bindVarTypes) throws RemoteException, ITMException
	{
		System.out.println("@@@@ inside getXMLTypeStr with query :[ "+query+" ] bindVarValues :[ "+bindVarValues.toString()+" ] bindVarTypes :[ "+bindVarTypes+" ]");
		String dataStr = "";
		PreparedStatement pStmt = null;
		try
		{
			pStmt = con.prepareStatement(query);
			for (int ctr = 0; ctr < bindVarValues.size(); ctr++ )
			{
				if ( ((String)bindVarTypes.get(ctr)).indexOf("String") != -1)
				{
					pStmt.setString((ctr+1), (String)bindVarValues.get(ctr));
				}
				else if (((String)bindVarTypes.get(ctr)).indexOf("Int") != -1)
				{
					pStmt.setInt((ctr+1), Integer.parseInt((String)bindVarValues.get(ctr)) );
				}
			}
			
			ResultSet rs = pStmt.executeQuery();
			if (rs.next())
			{
				dataStr = (rs.getString(1) == null) ?"":rs.getString(1);
			}
			
			if (dataStr != null && dataStr.length() > 0 && dataStr.indexOf("</DocumentRoot>") != -1)
			{
				dataStr = dataStr.substring(0, dataStr.indexOf("</DocumentRoot>") + 15);
			}
			else if (dataStr != null && dataStr.length() > 0 && dataStr.indexOf("</Root>") != -1)
			{
				dataStr = dataStr.substring(0, dataStr.indexOf("</Root>") + 7);
			}
			rs.close();
			rs = null;
			pStmt.close();
			pStmt = null;
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{				
				if(pStmt != null)
				{
					pStmt.close();
					pStmt = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception :DBAccessEJB :getXMLTypeStr :==>finally\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		return dataStr;
	}
	private DBAccessLocal getDBAccessObj() throws ITMException
	{
		DBAccessLocal dbAccess = null;
		try
		{
			dbAccess = (DBAccessLocal)getInitialContext().lookup("ibase/DBAccessEJB/local");
		}
		catch (Exception e)
		{
			WorkflowLogger.info("Exception :SignManagerEJB :getDBAccessObj() :==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		return dbAccess;
	}
	private InitialContext getInitialContext()throws ITMException
	{
		InitialContext ctx = null;
		try
		{
			AppConnectParm appConnect = new AppConnectParm();
			ctx = new InitialContext(appConnect.getProperty());
		}
		catch(ITMException be)
		{
			throw be;
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		return ctx;
	}
	public String updateRejectedRemark(String domString, Connection conn) throws ITMException
	{
		System.out.println("updateAprvRemark() method called....["+domString+"]sd");
		String retStr="";
		PreparedStatement pStmt = null;
		ResultSet rs = null; 
		NodeList parentNodeList = null;
		Node parentNode = null;
		NodeList childNodeList = null;
		int childNodeListLength = 0;
		Node childNode = null;
		String childNodeName = "";
        Element nodeElement = null;
		int parentNodeListLength = 0;
		String refSer="";
		String refId="";
		String lineNo="";
		String roleCodeSign="";
		String signRemark="";
		String roleEntity="";
		String signStatus="";
		String signRemarkNew="",refSerNew="",trnID="",roleCodesign="",signStatusNew="";;
		Document dom =null;
		Document dom2 =null;
		Document dom1 =null;
		HashMap<String,String> signRamarkHM=  new HashMap<String, String>();
		String dataString ="";
		String dataStr ="";
		boolean isUpdate=false;
		boolean isError=false;
		String query="";
		String dataStrWfData="";
		String dataStringWfData="";
		String prcInst= "";
		String processId = "";
		String instanceId = "";
		try 
		{
			
			if (domString.trim().length() > 0 )
			{
				dom = genericUtility.parseString(domString);
			}
			refSerNew = genericUtility.getColumnValue("ref_ser",dom,"1");
			trnID = genericUtility.getColumnValue("ref_id",dom,"1");
			signStatusNew = genericUtility.getColumnValue("sign_status",dom,"1");
			signRemarkNew = genericUtility.getColumnValue("sign_remarks",dom,"1");
			roleCodesign = genericUtility.getColumnValue("role_code__sign",dom,"1");	
			System.out.println("updateAprvRemark::refSerNew["+refSerNew+"]::trnID:::["+trnID+"]::signStatusNew::["+signStatusNew+"]::roleCodesign:::["+roleCodesign+"]");
			parentNodeList = dom.getElementsByTagName("Detail1");
			parentNodeListLength = parentNodeList.getLength(); 
			System.out.println(":::updateAprvRemark:: parentNodeListLength Detail1:::::::>>::"+parentNodeListLength);
			for (int selectedRow = 0; selectedRow < parentNodeListLength; selectedRow++)
			{				
				parentNode = parentNodeList.item(selectedRow);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();
				System.out.println("updateAprvRemark .....childNodeListLength::: sasa>>>"+ childNodeListLength+"\n");
				
				for (int childRow = 0; childRow < childNodeListLength; childRow++)
				{
					System.out.println("childNodeListLengthchildNodeListLength:sdfds:"+ childNodeListLength);
					childNode = childNodeList.item(childRow);
					childNodeName = childNode.getNodeName();
					if (childNodeName.equalsIgnoreCase("ref_ser"))
					{
						if(childNode.getFirstChild()!=null)
						{
							refSer = childNode.getFirstChild().getNodeValue();
						}
						//System.out.println("refSer::["+refSer+"]");
					}
					if (childNodeName.equalsIgnoreCase("ref_id"))
					{
						if(childNode.getFirstChild()!=null)
						{
							refId = checkNull(childNode.getFirstChild().getNodeValue());
						}
						//System.out.println("refId::["+refId+"]");
					}					
					if (childNodeName.equalsIgnoreCase("line_no"))
					{
						if(childNode.getFirstChild()!=null)
						{
							lineNo = checkNull(childNode.getFirstChild().getNodeValue());
						}
						//System.out.println("lineNo::["+lineNo+"]");
					}	
					if (childNodeName.equalsIgnoreCase("role_code__sign"))//role_code__sign
					{
						if(childNode.getFirstChild()!=null)
						{
							roleCodeSign = checkNull(childNode.getFirstChild().getNodeValue());
						}
						//System.out.println("roleCodeSign::["+roleCodeSign+"]");
					}	
					
					if (childNodeName.equalsIgnoreCase("sign_remarks"))//sign_remarks
					{
						if(childNode.getFirstChild()!=null)
						{
							signRemark = checkNull(childNode.getFirstChild().getNodeValue());
						}
					}
					if (childNodeName.equalsIgnoreCase("role_entity"))//role_entity
					{
						if(childNode.getFirstChild()!=null)
						{
							roleEntity = checkNull(childNode.getFirstChild().getNodeValue());
						}
						//System.out.println("roleEntity::["+roleEntity+"]");
					}	
					if (childNodeName.equalsIgnoreCase("sign_status"))//sign_status
					{
						if(childNode.getFirstChild()!=null)
						{
							signStatus = checkNull(childNode.getFirstChild().getNodeValue());
						}
						//System.out.println("signStatus::["+signStatus+"]");
					}
					if (childNodeName.equalsIgnoreCase("prc_inst__wf"))//PRC_INST__WF
					{
						if(childNode.getFirstChild()!=null)
						{
							prcInst = checkNull(childNode.getFirstChild().getNodeValue());
						}
						System.out.println("prcInst::["+prcInst+"]");
					}
				} 
				if(roleCodeSign.equalsIgnoreCase("FLM_SIGN") && signStatus.equalsIgnoreCase("R") )
				{
					System.out.println("update remakrdfjdf aprv remakrs");
					signRamarkHM.put("rejected_remarks", signRemark);
				}
			}
			
			if (prcInst != null && prcInst.trim().length() > 0)
			{
				String str[] = prcInst.split(":");
				 processId = str[0];
				 instanceId = str[1];
			}
			System.out.println("processId :fgg: "+processId);
			System.out.println("instanceId :g: "+instanceId);
			
			String sql = "SELECT ARGUMENT_VALUE_XML FROM WF_PRC_DATA WHERE PROCESS_ID = ? AND INSTANCE_ID = ? AND ARGUMENT_ID='$XML_DATA_ALL'";
			
			if ( "oracle".equalsIgnoreCase( CommonConstants.DB_NAME )) 
			{
				query = "SELECT WPD.ARGUMENT_VALUE_XML.getClobval() FROM WF_PRC_DATA WPD WHERE PROCESS_ID=? AND INSTANCE_ID=? AND ARGUMENT_ID='$XML_DATA_ALL' ";
			}
			else
			{
				query = "SELECT ARGUMENT_VALUE FROM WF_PRC_DATA WHERE PROCESS_ID=? AND INSTANCE_ID=? AND ARGUMENT_ID='$XML_DATA_ALL' ";
			}	
			ArrayList bindVarValues = new ArrayList();
			bindVarValues.add(processId.trim());
			bindVarValues.add(instanceId.trim());
			
			ArrayList bindVarTypes = new ArrayList();
			bindVarTypes.add("String");
			
			//For DB2 Compatibility
			bindVarTypes.add("String");
			System.out.println("Getting BLOB from DBAccessEJB in SignManagerEJB sign4");
			
			String wfData ="";
			if( "oracle".equalsIgnoreCase( CommonConstants.DB_NAME ) )
			{	
				dataStrWfData = getXMLTypeStr( conn, query, bindVarValues, bindVarTypes );
			}
			else
			{
				dataStrWfData = getDBAccessObj().getBlob(query, bindVarValues, bindVarTypes);
			}
			dataStringWfData =applyDataToXML(signRamarkHM,dataStrWfData,"1");
			dom2 = genericUtility.parseString(dataStringWfData);
			String modifiedArgumentXml=genericUtility.serializeDom(dom2);;
			System.out.println("modifiedArgumentXml::::updateAprvRemarkupdateAprvRemarkasd:::::::+"+modifiedArgumentXml);
			String sqlUpdtWfData = "UPDATE WF_PRC_DATA SET ARGUMENT_VALUE_XML = XMLType(?) WHERE PROCESS_ID = ? AND INSTANCE_ID = ? AND ARGUMENT_ID='$XML_DATA_ALL'";				
			ArrayList bindVarValuesUpd = new ArrayList();
			bindVarValuesUpd.add(processId);
			bindVarValuesUpd.add(instanceId);

			ArrayList bindVarTypesUpd = new ArrayList();
			bindVarTypesUpd.add("String");
			bindVarTypesUpd.add("String");
			
			boolean	updStatus = updateXMLTypeStr( conn, sqlUpdtWfData, modifiedArgumentXml, bindVarValuesUpd, bindVarTypesUpd );
			if(updStatus)
			{
				System.out.println("Updated wf_prc_data Successfull in updateAprvRemark");
			}
			
			
			
			dataStr=getObjSignTransXmlData(refSer,refId,conn);
			dataString =applyDataToXML(signRamarkHM,dataStr,"1");
			System.out.println(" updateApproveLevel obj signtrans dataStr. updateAprvRemark::::::+"+dataString);
			dom1 = genericUtility.parseString(dataString);
			
			System.out.println("Dom getting elements obj signtrans  abcd.::updateAprvRemark::::+"+genericUtility.serializeDom(dom1));
			
			String modifiedArgumentXml1=genericUtility.serializeDom(dom1);;
			System.out.println("modifiedArgumentXml:::updateAprvRemark::::::::+"+modifiedArgumentXml1);
			String sqlUpdtWfData1 = "UPDATE obj_sign_trans SET TRANS_INFO_XML = XMLType(?) WHERE REF_SER = ? AND REF_ID= ? AND SIGN_STATUS <>'S' ";				
			ArrayList bindVarValuesUpd1 = new ArrayList();
			bindVarValuesUpd1.add(refSer);
			bindVarValuesUpd1.add(refId);

			ArrayList bindVarTypesUpd1 = new ArrayList();
			bindVarTypesUpd1.add("String");
			bindVarTypesUpd1.add("String");
			
			boolean	updStatus1 = updateXMLTypeStr( conn, sqlUpdtWfData1, modifiedArgumentXml1, bindVarValuesUpd1, bindVarTypesUpd1 );
			if(updStatus1)
			{
				System.out.println("Updated OBJ_SIGN_TRANS Successfull in updateAprvRemark()");
			}
			
		} 
		catch (Exception e) 
		{
			isError = true;
			e.printStackTrace();
			throw new ITMException(e);
		}
		/*finally 
		{
			if (conn != null) 
			{
				try 
				{
					if (isError) 
					{
						conn.rollback();
						System.out.println("ChgCoverageAreaApproval Connection Rollback");
					} 
					else 
					{
						conn.commit();
						System.out.println("ChgCoverageAreaApproval Connection Commit");
					}
					
				}
				catch (Exception e) 
				{
					e.printStackTrace();
				}
			}
		}*/
		return retStr;
	}
	private boolean updateXMLTypeStr( Connection con, String query, String dataStr, ArrayList bindVarValues, ArrayList bindVarTypes ) throws RemoteException,ITMException
	{
		System.out.println("@@@@ inside updateXMLType");
		WorkflowLogger.info("query ["+query+"]");
		WorkflowLogger.info("bindVarTypes ["+bindVarTypes+"]");
		WorkflowLogger.info("bindVarValues ["+bindVarValues+"]");
		boolean updStatus = false;
		PreparedStatement pStmt = null;
		OracleConnection oConnection=null;
		try
		{
			byte[] dataByteArray = null;
			E12GenericUtility genericUtility = new E12GenericUtility();
			dataStr = genericUtility.remAllXmlDec(dataStr);
			
			if ( dataStr != null && dataStr.length() > 0 && dataStr.indexOf( "</DocumentRoot>" ) != -1 )
			{
				dataStr = dataStr.substring( 0, dataStr.indexOf( "</DocumentRoot>" ) + 15 );
				dataByteArray = dataStr.getBytes();
			}
			else if ( dataStr != null && dataStr.length() > 0 && dataStr.indexOf( "</Root>" ) != -1 )
			{
				dataStr = dataStr.substring(0, dataStr.indexOf( "</Root>" ) + 7 );
				dataByteArray = dataStr.getBytes();
			}
			pStmt = con.prepareStatement(query);
			CLOB dataStrXml = CLOB.createTemporary( con.getMetaData().getConnection(), true, CLOB.DURATION_SESSION );
			dataStrXml.putString( 1, dataStr );         
			pStmt.setClob(1, dataStrXml);
			System.out.println("modifiedxmlstring in updateXMLTypeStr::"+dataStrXml);
			//Commented and changed by Gulzar for XMLType on 17/DEC/13 : END
			
			for (int ctr = 0; ctr < bindVarValues.size(); ctr++ )
			{
				if ( ( ( String )bindVarTypes.get(ctr)).indexOf( "String" ) != -1 )
				{
					pStmt.setString( ( ctr + 2 ), ( String )bindVarValues.get( ctr ) );
				}
				else if ( ( ( String )bindVarTypes.get( ctr ) ).indexOf( "Int" ) != -1 )
				{
					pStmt.setInt( ( ctr + 2 ), Integer.parseInt( ( String )bindVarValues.get( ctr ) ) );
				}
			}
			
			int updateCnt = pStmt.executeUpdate();
			System.out.println("@@@@ updateCnt in updateXMLType"+updateCnt);
			if( updateCnt > 0 )
			{
				updStatus = true;
			}
			pStmt.close();
			pStmt = null;
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(pStmt != null)
				{
					pStmt.close();
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception :SignManagerEJB :updateBlob :==>finally\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		return updStatus;
	}
	public String applyDataToXML(HashMap hashMap, String dataString, String formNo)throws ITMException
	{
		System.out.println("applyDataToXML called in approval screen");
		Document dataDom = null;
		GenericUtility genericUtility = GenericUtility.getInstance(); 
		try
		{
			System.out.println(" applyDataToXML Applying Data XML....");
			System.out.println("applyDataToXML hashMap :: " + hashMap);
			System.out.println("applyDataToXML dataString :: " + dataString);
			System.out.println("applyDataToXML formNo =[" + formNo + "]");
			dataDom = genericUtility.parseString(dataString);
			//System.out.println("DataDom Created :: " +genericUtility.serializeDom(dataDom));
			if (hashMap != null && hashMap.size() > 0)
			{
				NodeList parentNodeList = dataDom.getElementsByTagName("Detail"+formNo);
				int parentNodeListLen = parentNodeList.getLength();
				System.out.println("parentNodeListLen :sdf: " + parentNodeListLen);
				for(int pCtr = 0; pCtr < parentNodeListLen; pCtr++)
				{
					Node parent1Node = parentNodeList.item(pCtr);
					NodeList colNodeList = parent1Node.getChildNodes();
					int noOfColNodes = colNodeList.getLength();
					//System.out.println("noOfColNodes :sdfdsf: " + noOfColNodes);

					for(int colCtr = 0; colCtr < noOfColNodes; colCtr++)
					{
						Node currColNode = colNodeList.item(colCtr);
						if( currColNode.getNodeType() != Node.ELEMENT_NODE )
						{
							continue;
						}
						String colName = currColNode.getNodeName();
						//System.out.println("colName :sdfdf: " + colName);
						String key = colName;
						if( hashMap.containsKey(key))
						{
							//System.out.println("colName found in hasmap:fdghfg: " + colName);
							Node colValueNode = currColNode.getFirstChild();
							//if(colValueNode != null && colValueNode.getNodeValue() != null)
							if(colValueNode != null && colValueNode.getNodeValue() != null)
							{
								//System.out.println("colName found in hasmap:: " + colName);
								String colVal = (String)hashMap.get(key);
								if( colVal != null )
								{
									colValueNode.setNodeValue(colVal);
								}
							}
							else
							{
								//System.out.println("cdata createtnsection shdfkjd");
								CDATASection cDataSection = dataDom.createCDATASection((String)hashMap.get(key));
								currColNode.appendChild(cDataSection);
							}
						}//if( hashMap.containsKey(key))

					}//for(int colCtr = 0; colCtr < noOfColNodes; colCtr++)
				}//parent for loop

				if ( dataDom == null)
				{
					System.out.println(" datadom is null ");
				}
				dataString = genericUtility.serializeDom(dataDom);

			}//if (hashMap != null && hashMap.size() > 0)
		}
		catch (ITMException be)
		{
			throw be;
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}

		System.out.println("applyDataToXML DataDom Returned :: " + dataString);
		return dataString;
	}
	public String routeApproveCheck( String refID ,String xmlData , String salesPers, String appoverLevel, String userInfoStr )throws RemoteException, ITMException
	{
		//String xtraParams ="";
		System.out.println("tranID : ["+refID+"]");
		System.out.println("xmlData : ["+xmlData+"]");
		System.out.println("salesPers : ["+salesPers+"]");
		boolean isError=false;
		Connection connectionObject = null;		
		PreparedStatement pstmt = null;
		PreparedStatement pstmtInner = null;
		ResultSet rs = null;
		ResultSet rsInner = null;
		String returnString = "";
		String getAprvEmp = ""; 
		
		try
		{
			
			ConnDriver connDriver = null;
			connDriver = new ConnDriver();
			
			String transDB="";
			System.out.println("Inside routeApproveCheck section: "+userInfoStr);
			UserInfoBean userInfo = new UserInfoBean(userInfoStr);
			if(userInfo!=null)
			{	
				transDB = userInfo.getTransDB();
			}
	    	System.out.println("get TransDB connection in routeApproveCheck : "+transDB);
	    	
		    if (transDB != null && transDB.trim().length() > 0)
		    {
		    	connectionObject = connDriver.getConnectDB(transDB);
		    }
		    else
		    {
		    	connectionObject = connDriver.getConnectDB("DriverITM");
		    }
		    connectionObject.setAutoCommit( false );
		    
		    String getAprvEmpSql = "SELECT FN_GET_APRV_EMP(?,?) AS EMP_CODE FROM DUAL";
		    pstmt = connectionObject.prepareStatement(getAprvEmpSql);
		    pstmt.setString(1, salesPers);
		    pstmt.setString(2, appoverLevel);
			
			rs = pstmt.executeQuery();
			int submitCnt = 0;
			if ( rs.next() )
			{				
				getAprvEmp = checkNull(rs.getString("EMP_CODE"));
			}
			System.out.println("getAprvEmp..["+getAprvEmp+"]");
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			
			if(getAprvEmp.length() == 0)
			{
				returnString = "N"; // going for HO approval
			}
			else
			{
				String aprvLevel = getEmpGradeLevel( getAprvEmp, connectionObject );
				if(aprvLevel.equalsIgnoreCase("1") || aprvLevel.equalsIgnoreCase("2") || aprvLevel.equalsIgnoreCase("3") || aprvLevel.equalsIgnoreCase("4"))
				{
					returnString = "Y"; // going for field level approval
				}
				else
				{
					returnString = "N"; // going for HO approval
				}
			}
		    
		}
		catch (SQLException se)
		{
			try
			{
				isError=true;
				connectionObject.rollback();
			}
			catch(Exception sqe)
			{
				sqe.printStackTrace();
				isError=true; 
				returnString = "<ROOT><STATUS><![CDATA[0]]></STATUS><RESULT><![CDATA[Rollback failed during SQLException]]></RESULT></ROOT>";
           }
 			returnString = "<ROOT><STATUS><![CDATA[0]]></STATUS><RESULT><![CDATA[Some SQLException occurred ]]></RESULT></ROOT>";

		}
		catch( Exception ex )
		{
			try
			{
				connectionObject.rollback();
				isError=true;
			}
			catch(Exception e)
			{
				e.printStackTrace();
				isError=true;
            }
			returnString = "<ROOT><STATUS><![CDATA[0]]></STATUS><RESULT><![CDATA[Some other Exception came]]></RESULT></ROOT>";
		}
		finally
		{
			try
			{
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(!isError)
				{
					connectionObject.commit();
					System.out.println("Connection committed.");
				}
				if(connectionObject != null)
				{
					connectionObject.close();
					connectionObject = null;
				}				
			}
			catch ( Exception e)
			{
				e.printStackTrace();
			}		
		}
		return returnString;
	}
	public String getEmpGradeLevel( String empCode, Connection conn ) throws Exception
	{
		String selectSql = "";
		String gradeLev = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try
		{
			selectSql = "SELECT GRADE.LEVEL_NO AS APRV_LEVEL FROM GRADE GRADE, EMPLOYEE EMP WHERE EMP.GRADE = GRADE.GRADE_CODE AND EMP.EMP_CODE = ? ";
			pstmt = conn.prepareStatement(selectSql);
			pstmt.setString(1, empCode);
			rs = pstmt.executeQuery();
			if ( rs.next() )
			{
				gradeLev = checkNull(rs.getString("APRV_LEVEL"));
			}
		}
		catch ( Exception e)
		{
			throw e;
		}
		finally
		{
			try
			{
				System.out.println("Closing Connection.....");
				if( rs != null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}catch(Exception e){}
		}
		System.out.println("gradeLev[getEmpGradeLevel] =["+gradeLev+"]");
		return gradeLev;
	}
	//Added by Bhagyashri T on 13/AUG/21 for workflow level changes[START]
	public String checkBeatDivHo(String refID ,String xmlData , String salesPers, String refSer, String userInfoStr) throws ITMException
	{
		System.out.println("Inside checkBeatDivHo....." );
		String sql = "";
		PreparedStatement pStmt = null;
		ResultSet rs = null;
		String retString = "";
		String reportTo = "";

		ConnDriver connDriver = null;
		Connection conn = null;

		boolean isError = false;
		String empCode = "";
		String entityCode = "";

		try
		{
			//connDriver = new ConnDriver();
			//conn = connDriver.getConnectDB("DriverITM");
			//conn.setAutoCommit(false);
			//connDriver = null;
			//added by mrunalini sinkar on 27-April-2018(start)
			System.out.println("Inside routeApproveCheck section: "+userInfoStr);
			UserInfoBean userInfo = new UserInfoBean(userInfoStr);
			if( userInfo != null && userInfo.getTransDB() != null )
			{
				String transDB = E12GenericUtility.checkNull( userInfo.getTransDB() );
				connDriver = new ConnDriver();
				conn = connDriver.getConnectDB(transDB);
			}
			conn.setAutoCommit(false);
			connDriver = null;
			//added by mrunalini sinkar on 27-April-2018(end)

			String hoEmpCode = checkNull(getSfaParmValue(salesPers,"BEAT_DIVISION_HO",conn));
			System.out.println("BeatdivisionHo>>["+hoEmpCode+"]");
			if (hoEmpCode != null && hoEmpCode.trim().length() > 0)
			{
				retString ="Y";
			}
			else
			{
				retString ="N";
			}

		}
		catch (Exception e)
		{
			isError = true;
			try
			{
				conn.rollback();
			}
			catch(Exception ee)
			{

			}
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( rs != null )
				{
					rs.close();
					rs = null;
				}
				if(pStmt != null )
				{
					pStmt.close();
					pStmt = null;
				}
				if(conn != null )
				{
					if(!isError)
					{
						conn.commit();
					}
					conn.close();
					conn = null;
				}

			}
			catch(Exception e)
			{
				System.out.println( "Exception in check beat divisionHo(String) :==>\n"+e.getMessage());
			}
		}
		return retString;
	}
	public String getSfaParmValue(String userId,String paramName,Connection connectionObject) throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		PreparedStatement pstmt1 = null;
		ResultSet rs1 = null;
		String empSite="";
		String itemSer="";
		String paramValue="";
		PreparedStatement allPstmt = null;
		ResultSet allRs = null;
		boolean isLocalConn =false;
		try
		{
			String sql = "SELECT SITE_CODE__DEF FROM USERS WHERE CODE = ? ";
			pstmt = connectionObject.prepareStatement(sql);
			pstmt.setString(1, userId);

			rs = pstmt.executeQuery();
			if( rs.next() )
			{
				empSite  = checkNull(rs.getString("SITE_CODE__DEF"));
			}
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}

			System.out.println("value of empSite is::........."+empSite);

			String getSalesPerData = " SELECT SALES_PERS.ITEM_SER,ITEMSER.DESCR FROM ITEMSER LEFT OUTER JOIN SALES_PERS ON ITEMSER.ITEM_SER = SALES_PERS.ITEM_SER "+
					" WHERE  SALES_PERS.SALES_PERS = ? ";

			pstmt = connectionObject.prepareStatement(getSalesPerData);
			pstmt.setString(1, userId);

			rs = pstmt.executeQuery();
			if( rs.next() )
			{
				itemSer  = checkNull(rs.getString("ITEM_SER"));
			}
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}

			sql=" SELECT PARM_VALUE  "+
					" FROM SFAPARM  "+
					" WHERE ORG_UNIT =?  "+
					" AND ACTIVE='Y'  "+
					" AND PARM_NAME= ? ";

			pstmt = connectionObject.prepareStatement(sql);
			pstmt.setString(1, empSite+"_"+itemSer);
			pstmt.setString(2, paramName);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				paramValue  = checkNull(rs.getString(1));
			}
			else
			{
				System.out.println("inside else");
				pstmt1 = connectionObject.prepareStatement(sql);
				pstmt1.setString(1, itemSer);
				pstmt1.setString(2, paramName);
				rs1 = pstmt1.executeQuery();
				if(rs1.next())
				{
					paramValue  = checkNull(rs1.getString(1));
				}
				else
				{
					allPstmt = connectionObject.prepareStatement(sql);
					allPstmt.setString(1, "ALL");
					allPstmt.setString(2, paramName);
					allRs = allPstmt.executeQuery();
					if(allRs.next())
					{
						paramValue  = checkNull(allRs.getString(1));
					}
				}
				if ( allRs != null )
				{
					allRs.close();
					allRs = null;
				}
				if ( allPstmt != null )
				{
					allPstmt.close();
					allPstmt = null;
				}
				if ( rs1 != null )
				{
					rs1.close();
					rs1 = null;
				}
				if ( pstmt1 != null )
				{
					pstmt1.close();
					pstmt1 = null;
				}
			}
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}

			System.out.println("value of isPlan is::........."+paramValue);
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);

		}
		finally
		{
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if( isLocalConn && connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch (SQLException e) {
				e.printStackTrace();
			}
		}
		return paramValue;
	}
	//Added by Bhagyashri T on 13/AUG/21 for workflow level changes[END]
}
