package ibase.webitm.ejb.sys;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

public class AcknowledgementReader {

    public static Map<String, Object[]> parseXMLFiles(String directoryPath)
    {
        Map<String, Object[]> resultMap = new HashMap<>();
        try {
            File directory = new File(directoryPath);

            if (directory.isDirectory()) {
                File[] files = directory.listFiles((dir, name) -> name.toLowerCase().endsWith(".xml"));

                if (files != null) {
                    for (File file : files) {
                        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                        Document doc = dBuilder.parse(file);
                        doc.getDocumentElement().normalize();

                        NodeList topLevelNodes = doc.getDocumentElement().getChildNodes();
                        processNodes(topLevelNodes, resultMap);
                    }
                }
            } 
            
            else 
            {
                System.out.println("Specified path is not a directory.");
            }

        } catch (Exception e) {
            e.printStackTrace();
        }

        return resultMap;
    }

    private static void processNodes(NodeList nodes, Map<String, Object[]> resultMap) 
    {
        for (int i = 0; i < nodes.getLength(); i++)
        {
            Node node = nodes.item(i);

            if (node.getNodeType() == Node.ELEMENT_NODE)
            {
                Element element = (Element) node;

                String orgnlEndToEndId = getElementValue(element, "OrgnlEndToEndId");
                String txSts = getElementValue(element, "TxSts");

                List<String> rsnList = new ArrayList<>();
                List<String> addtlInfList = new ArrayList<>();

                NodeList stsRsnInfNodes = element.getElementsByTagName("StsRsnInf");
                for (int k = 0; k < stsRsnInfNodes.getLength(); k++)
                {
                    Node stsRsnInfNode = stsRsnInfNodes.item(k);
                    Element stsRsnInfElement = (Element) stsRsnInfNode;

                    String rsnCd = getElementValue(stsRsnInfElement, "Cd");
                    String addtlInf = getElementValue(stsRsnInfElement, "AddtlInf");

                    if (!rsnCd.isEmpty() && !rsnList.contains(rsnCd))
                    {
                        rsnList.add(rsnCd);
                    }

                    if (!addtlInf.isEmpty() && !addtlInfList.contains(addtlInf)) {
                        addtlInfList.add(addtlInf);
                    }
                }

                String rsn = String.join(" ", rsnList);
                Object[] values = {txSts, new Object[]{rsn, addtlInfList.toArray(new String[0])}};
                resultMap.put(orgnlEndToEndId, values);

                // Recursively process child nodes
                processNodes(node.getChildNodes(), resultMap);
            }
        }
    }


    private static String getElementValue(Element element, String tagName) 
    {
        NodeList nodeList = element.getElementsByTagName(tagName);
        StringBuilder result = new StringBuilder();

        for (int i = 0; i < nodeList.getLength(); i++) {
            Node node = nodeList.item(i);
            result.append(getTextContent(node));
        }

        return result.toString().trim();
    }

    private static String getTextContent(Node node) 
    {
        StringBuilder textContent = new StringBuilder();

        if (node.getNodeType() == Node.TEXT_NODE || node.getNodeType() == Node.CDATA_SECTION_NODE) {
            textContent.append(node.getNodeValue());
        } else {
            NodeList childNodes = node.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); i++) {
                textContent.append(getTextContent(childNodes.item(i)));
            }
        }

        return textContent.toString();
    }

    public static void main(String[] args) {
        String directoryPath = "/home/amol.sonawane/Documents/Acknowledgement";
        Map<String, Object[]> result = parseXMLFiles(directoryPath);

        System.out.println("Tag Values are :");
        
        for (Map.Entry<String, Object[]> entry : result.entrySet())
        {
            String key = entry.getKey();

            // Exclude entries with repetitions of the pattern "Q2BP"
            if (!containsRepetition(key, "Q2BP"))
            {
                Object[] values = entry.getValue();
                String txSts = (String) values[0];
                String rsn = (String) ((Object[]) values[1])[0];
                String[] addtlInfArray = (String[]) ((Object[]) values[1])[1];
                // Check for non-empty values
                if (!key.isEmpty() || !txSts.isEmpty() || !rsn.isEmpty() || addtlInfArray.length > 0) 
                {
                    System.out.println("Key: " + key);
                    System.out.println("TxSts: " + txSts);
                    System.out.println("Rsn: " + rsn);

                    System.out.print("AddtlInf: ");
                    for (String addtlInf : addtlInfArray) 
                    {
                        System.out.print(addtlInf + " ");
                    }
                    System.out.println("\n");
                }
            }
        }
    }

    // Helper method to check if a string contains repetitions of a pattern
    private static boolean containsRepetition(String input, String pattern)
    {
        int index = input.indexOf(pattern);
        return index != -1 && input.indexOf(pattern, index + 1) != -1;
    }



}
