package ibase.webitm.ejb.wsfa.transactions;

import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Vector;

import javax.ejb.Stateless;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

//@Stateless		commented by Sagar M [22 Nov 2018].
public class StrgRouteTransferIc extends ValidatorEJB implements StrgRouteTransferIcLocal,StrgRouteTransferIcRemote
{
	GenericUtility genericUtility = GenericUtility.getInstance();

	public String wfValData() throws RemoteException,ITMException
	{
		return "";
	}

	public String itemChanged() throws RemoteException,ITMException
	{
		return "";
	}
	public String wfValData(String xmlString, String xmlString1,String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String  errString = null;
		System.out.println("Validation Start..........");
		try
		{
			System.out.println("xmlString:::"+xmlString);
			dom = parseString(xmlString);
			dom1 = parseString(xmlString1);
			if (xmlString2.trim().length() > 0 )
			{
				dom2 = parseString(xmlString2);
			}
			errString = wfValData(dom,dom1,dom2,objContext,editFlag,xtraParams);
		}
		catch(Exception e)
		{
			System.out.println("Exception : StrgSeriesPsrCopyEJB : wfValData(String xmlString) : ==>\n"+e.getMessage());
		}
		return (errString);
	}
	public String wfValData(Document dom, Document dom1,Document dom2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		ConnDriver connDriver = new ConnDriver();
		Connection conn = null;
		Statement stmt = null;
		ResultSet rs = null;
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		String sql = "";
		String errString = "";
		String errCode = "";
		String childNodeName = null;
		String userId = "";
		String userType = "";
		int ctr,currentFormNo=0;
		int childNodeListLength;

		try
		{
			System.out.println("inside try block.......");
			conn = connDriver.getConnectDB("DriverITM");
			conn.setAutoCommit(false);
			stmt = conn.createStatement();
			GenericUtility genericUtility = GenericUtility.getInstance();
			userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"userId");

			String loginEmpCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode");

			if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			switch(currentFormNo)
			{
				case 1:
					parentNodeList = dom.getElementsByTagName("Detail1");
					parentNode = parentNodeList.item(0);
					childNodeList = parentNode.getChildNodes();
					childNodeListLength = childNodeList.getLength();
					for(ctr = 0; ctr < childNodeListLength; ctr++)
					{
						childNode = childNodeList.item(ctr);
						childNodeName = childNode.getNodeName();
						System.out.println("childNodeName==== "+childNodeName);
						if (childNodeName.equals("sales_pers_from"))
						{
							System.out.println("childNode.getFirstChild()........ "+childNode.getFirstChild());
							if ( childNode.getFirstChild() == null ) //Condition Added By Gulzar - 25/08/08 Req ID: SY89SUN001
							{
								System.out.println("inside if loop.... ");
								errCode = "VMSALESPER";
								errString = getErrorString("sales_pers_from",errCode,userId);
								break;
							}
							else
							{
								System.out.println("inside else loop.... ");
								String salesPersFrom = genericUtility.getColumnValue("sales_pers_from",dom);
								int spCntr = 0;
								sql = "SELECT COUNT(*) AS COUNT FROM SPRS_ROUTE WHERE SPRS_CODE = '"+ salesPersFrom +"' ";
								rs = stmt.executeQuery(sql);
								if(rs.next())
								{
									spCntr = rs.getInt("COUNT");
								}
								rs.close();
								if (spCntr == 0)
								{
									errCode = "VSALPER";
									errString = getErrorString("sales_pers_from",errCode,userId);
									break;
								}

							}
						}
						else if (childNodeName.equals("sales_pers_to"))
						{
							if ( childNode.getFirstChild() == null ) //Condition Added By Gulzar - 25/08/08 Req ID: SY89SUN001
							{
								System.out.println("inside if loop:::: ");
								errCode = "VMSALESPER";
								errString = getErrorString("sales_pers_to",errCode,userId);
								break;
							}
							else
							{
								System.out.println("inside else loop:::: ");
								String salesPersTo = genericUtility.getColumnValue("sales_pers_to",dom);

								String salesPersFrom = genericUtility.getColumnValue("sales_pers_from",dom);
								salesPersFrom = salesPersFrom.trim();
								salesPersTo =salesPersTo.trim();
								System.out.println("salesPersFrom....."+salesPersFrom+" salesPersTo...."+salesPersTo);

								int spCntr = 0;

								sql = "SELECT COUNT(*) AS COUNT FROM SPRS_ROUTE WHERE SPRS_CODE = '"+ salesPersTo +"' ";
								System.out.println("SQL from sales_pers :: "+sql);
								rs = stmt.executeQuery(sql);
								if(rs.next())
								{
									spCntr = rs.getInt("COUNT");
								}
								rs.close();
								if (spCntr == 0)
								{
									errCode = "VSALPER";
									errString = getErrorString("sales_pers_to",errCode,userId);
									break;
								}
								else if (salesPersFrom.equalsIgnoreCase(salesPersTo))
								{
									errString = getErrorString("sales_pers_to","INVDUPEMP",userId);
									break;
								}

							}
						}
					}//END FOR
					break;
			}//END SWITCH
		}//END TRY
		catch(Exception e)
		{
			System.out.println("Exception ::"+e);
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if ( stmt != null )
				{
					stmt.close();
					stmt = null;
				}
				if ( conn != null )
				{
					conn.close();
					conn = null;
				}
			}
			catch ( Exception e){}
		}
		System.out.println("ErrString ::"+ errString);
		return errString;
	}//END OF VALIDATION

	public String itemChanged(String xmlString, String xmlString1,String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String valueXmlString = null;
		try
		{
			dom = parseString(xmlString);
			System.out.println("xmlString" + xmlString);
			dom1 = parseString(xmlString1);
			if (xmlString2.trim().length() > 0 )
			{
				dom2 = parseString(xmlString2);
			}
			valueXmlString = itemChanged(dom,dom1,dom2,objContext,currentColumn,editFlag,xtraParams);
		}
		catch(Exception e)
		{
			System.out.println("Exception : [StrgSeriesPsrCopyEJB][itemChanged(String,String)] :==>\n"+e.getMessage());
		}
        return valueXmlString;
	}

	public String itemChanged(Document dom, Document dom1,Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		Statement stmt = null;
		ResultSet rs = null;
		StringBuffer valueXmlString = new StringBuffer();
		String columnValue = "";
		String sql = "";
		String userId = "";
		String entityCode = "";//Added By Gulzar - 25/08/08 Req ID : SY89SUN001

		int currentFormNo = 0;
		Exception exc = new Exception("Editing is not allowed......");
		GenericUtility genericUtility = GenericUtility.getInstance();
		try
		{
			conn = connDriver.getConnectDB("DriverITM");
			conn.setAutoCommit(false);
			//stmt = conn.createStatement();
			userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"userId");
			entityCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"entityCode"); //Added By Gulzar - 25/08/08 Req ID : SY89SUN001

			if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			System.out.println("[StrgRouteTransferIC] [itemChanged] :currentFormNo ....." +currentFormNo);
			//valueXmlString = new StringBuffer("<?xml version=\"1.0\"?><Root><header><editFlag>");
			valueXmlString = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<editFlag>");
			valueXmlString.append(editFlag).append("</editFlag>\r\n</Header>\r\n");
			System.out.println("Current Form No ["+currentFormNo+"]");
			//valueXmlString.append("<Detail1>");
			switch (currentFormNo)
			{
			case 1:
				valueXmlString.append("<Detail>\r\n");
				if (currentColumn.trim().equalsIgnoreCase("itm_default"))
				{
					System.out.println("calling itm_default........");
					String salesPersTo = genericUtility.getColumnValue("sales_pers_to",dom);
					System.out.println("Sales Pers to ===========================>1 item default :: "+salesPersTo);
					String loginEmpCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode");

					String userType = "";
					userType = getUserType(loginEmpCode,conn);
					System.out.println("[StrgRouteTransferIC] [itemChanged()][userType] "+userType);


				}
				else if (currentColumn.trim().equalsIgnoreCase("sales_pers_from"))
				{

					System.out.println("calling sales_pers_from........");
					columnValue = genericUtility.getColumnValue(currentColumn,dom);
					String spName = "";
					sql = "SELECT FIRST_NAME||' '||MIDDLE_NAME||' '||LAST_NAME AS CUST_NAME FROM STRG_CUSTOMER WHERE SC_CODE = ? ";
					PreparedStatement pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, columnValue);
					rs = pstmt.executeQuery();

					if( rs.next())
					{
						spName = checkNull(rs.getString("CUST_NAME"));
						valueXmlString.append("<name_from>").append(spName).append("</name_from>\r\n");
					}
					else
					{
						valueXmlString.append("<name_from>").append("").append("</name_from>\r\n");
					}
					if (columnValue != null)
					{
						valueXmlString.append("<sales_pers_from><![CDATA[").append(columnValue).append("]]></sales_pers_from>\r\n");
					}
					else
					{
						valueXmlString.append("<sales_pers_from><![CDATA[").append("").append("]]></sales_pers_from>\r\n");
					}
					if(pstmt != null)
					{
						pstmt.close();
					}

				}
				else if (currentColumn.trim().equalsIgnoreCase("sales_pers_to"))
				{

					System.out.println("calling sales_pers_to........");
					columnValue = genericUtility.getColumnValue(currentColumn,dom);
					String spName = "";
					sql = "SELECT FIRST_NAME||' '||MIDDLE_NAME||' '||LAST_NAME AS CUST_NAME FROM STRG_CUSTOMER WHERE SC_CODE = ? ";
					PreparedStatement pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, columnValue);
					rs = pstmt.executeQuery();

					if( rs.next())
					{
						spName = checkNull(rs.getString("CUST_NAME"));
						valueXmlString.append("<name_to>").append(spName).append("</name_to>\r\n");
					}
					else
					{
						valueXmlString.append("<name_to>").append("").append("</name_to>\r\n");
					}
					if (columnValue != null)
					{
						valueXmlString.append("<sales_pers_to><![CDATA[").append(columnValue).append("]]></sales_pers_to>\r\n");
					}
					else
					{
						valueXmlString.append("<sales_pers_to><![CDATA[").append("").append("]]></sales_pers_to>\r\n");
					}
					if(pstmt != null)
					{
						pstmt.close();
					}

				}
				valueXmlString.append("</Detail>\r\n");


			}//END OF SWITCH

		}//END OF TRY
		catch(Exception e)
		{
			System.out.println("Exception ::"+ e.getMessage());
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if ( stmt != null )
				{
					stmt.close();
					stmt = null;
				}
				if ( conn != null )
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				System.out.println("Exception ::"+e);
				e.printStackTrace();
			}
		}
		valueXmlString.append("</Root>");
		return valueXmlString.toString();
	}//END OF ITEMCHANGE

	private String getUserType(String empCode,Connection conn) throws ITMException
	{
		System.out.println("In getUserType() method");
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String empCodeMGR = "";
		String empCodeHO = "";
		String userType1 = "";
		String selectSql = "";
		boolean isEmpMgr = false;
		try
		{
			selectSql = "SELECT A.EMP_CODE AS EMP_CODE FROM EMPLOYEE A, GRADE B " +
				  "WHERE A.EMP_CODE = ? " +
				  "AND A.GRADE = B.GRADE_CODE " +
				  "AND B.GRADE_TYPE = 'M' ";

			pstmt = conn.prepareStatement(selectSql);
			pstmt.setString( 1, empCode );
			System.out.println("[StrgRouteTransferIC][getUserType()][selectSQL >>]"+selectSql);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				empCodeMGR = checkNull(rs.getString("EMP_CODE"));
			}
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			if (empCodeMGR != null && empCodeMGR.trim().length() > 0)
			{
				userType1 = "M";
				isEmpMgr = true;
			}
			if (isEmpMgr == false)
			{
				selectSql = "SELECT EMP_CODE FROM USERS A, USER_RIGHTS B " +
				  "WHERE A.EMP_CODE = ? " +
				  "AND A.PROFILE_ID = B.PROFILE_ID " +
				  "AND B.APPLICATION = 'MRO' " +
				  "AND B.MENU_ROW = 1 " +
				  "AND B.MENU_COL = 1 " +
				  "AND B.MENU_SUBCOL = 1 " +
				  "AND B.LEVEL_4 = 1 " +
				  "AND B.LEVEL_5 = 1 " +
				  "AND B.MENU_NAME = 'MR Online Application' ";

				pstmt = conn.prepareStatement(selectSql);
				pstmt.setString( 1, empCode );
				System.out.println("[StrgSeriesPsrCopy][getUserType()][selectSQL for HO >>] "+selectSql);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					empCodeHO = checkNull(rs.getString("EMP_CODE"));
				}
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if (empCodeHO != null && empCodeHO.trim().length() > 0)
				{
					userType1 = "H";
				}
			}
			System.out.println("[StrgSeriesPsrCopy][getUserType()][userType1 >>]"+userType1);
		}
		catch ( Exception e )
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e1){}
		}
		return userType1;
	}
	private String checkNull(String input)
	{
		if (input==null)
		{
			input="";
		}
		return input;
	}

	public String getFldStaffSiteList(Connection conn)
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String fldStaffSiteString = "";
		String sql = "";
		try
		{
			sql = "SELECT PROP_VALUE FROM PROPERTIES WHERE PROP_NAME = 'FIELDSTAFF_SITELIST' AND ITEM_SER = 'ALL'";
			 pstmt = conn.prepareStatement(sql);
			 rs = pstmt.executeQuery();
			System.out.println("Inside [StrgSeriesPrsCopy][getFldStaffSiteList]sql::>"+sql);

			 if (rs.next())
			 {
				fldStaffSiteString = rs.getString("PROP_VALUE");
				fldStaffSiteString = (fldStaffSiteString == null)? "" : fldStaffSiteString.trim();
				System.out.println("Inside [StrgSeriesPrsCopy][getFldStaffSiteList]fldStaffSiteString::["+fldStaffSiteString+"]");
			 }
			 if (rs!=null)
			 {
				 rs.close();
				 rs = null;
			 }
			 if (pstmt!=null)
			 {
				 pstmt.close();
				 pstmt = null;
			 }

		}
		catch (Exception exp)
		{
			System.out.println("Inside Exception catch [StrgSeriesPrsCopy][getFldStaffSiteList]Exception:>>"+exp.getMessage());
			exp.printStackTrace();
		}
		finally
		{
			try
			{
				if (rs!=null)
				{
				 rs.close();
				 rs = null;
				}
				if (pstmt!=null)
				{
				 pstmt.close();
				 pstmt = null;
				}
			}
			catch (Exception e)
			{
				System.out.println("Inside Exception finally [StrgSeriesPrsCopy][getFldStaffSiteList]Exception:>>"+e.getMessage());
				e.printStackTrace();
			}
		}
		System.out.println("Returning from [StrgSeriesPrsCopy][getFldStaffSiteList]["+fldStaffSiteString+"]");
		return fldStaffSiteString;
	}

	public String getFormattedStringBuff( String data )
	{
		StringBuffer dataString = new StringBuffer();
		try
		{
			String[] dataArr = null;

			if ( data.indexOf(",") == -1 )
			{
				dataString.append( "'"+data+"'" );
			}
			else
			{
				dataArr = data.split(",");
				for (int i=0; i < dataArr.length; i++ )
				{
					if ( i == 0 )
					{
						dataString.append( "'"+dataArr[i]+"'" );
					}
					else
					{
						dataString.append( "," );
						dataString.append( "'"+dataArr[i]+"'" );
					}
				}
			}
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
		}
		return dataString.toString();
	}

}
