//Coding by Vidhya Prabhu on 24/06/09
package ibase.webitm.ejb.wsfa.transactions;

import java.lang.reflect.Array;
import java.net.InetAddress;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Properties;
import java.util.TreeMap;

import javax.naming.InitialContext;

import org.json.JSONArray;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
//import ibase.webitm.utility.GenericUtility;//changed by rahul 10-apr-2015
import ibase.utility.E12GenericUtility; //changed by rahul on 10-apr-2015
import ibase.webitm.bean.wsfa.DARCommonBean;
import ibase.webitm.bean.wsfa.OrgStructure;
import ibase.webitm.bean.wsfa.StrgMeetWizardBean;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ITMDBAccessLocal;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.ejb.dis.DistCommon;
//import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.wsfa.WSFACommon;

//@javax.ejb.Stateless			commented by Sagar M [22 Nov 2018].
public class StrgMeetDCRWizard extends ValidatorEJB implements StrgMeetDCRWizardLocal, StrgMeetDCRWizardRemote
{
	static int domID = 1;
	protected E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
	//Validation Start*********
	//Changed By Vidhya on 25/11/09[WS89NOV655 | separate method for validation in 'RIA'] Start
	public String wfValSalesPersActRIA(Document dom, Document dom2, String currentFormNo, String userId) throws ITMException
	{
		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;

		//changed by Rahul Barve on 10-Apr-2015
		//GenericUtility genericUtility = GenericUtility.getInstance();
		//E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

		String errString = "";
		String checkSQL = "";
		String childNodeName = "";
		String columnValue = "";

		Connection connectionObject = null;
		PreparedStatement pstmt = null;
		ResultSet rSet = null ;

		ITMDBAccessEJB itmDBAccessLocal = null;// modified by kailash.

		int noOfChilds = 0;
		try
		{
			/*ConnDriver connDriver =new ConnDriver();
			connectionObject = connDriver.getConnectDB("DriverValidator");*/
			connectionObject = getConnection();//chnged by sachin satre on [11-nov-16] to get connection

			AppConnectParm appConnect = new AppConnectParm();
			Properties p = appConnect.getProperty();
			InitialContext ctx = new InitialContext(p);
			//Commented and modified by kailash on 20-07-18 as per gulzar sir[Start]
			//itmDBAccessLocal = (ITMDBAccessLocal)ctx.lookup("ibase/ITMDBAccessEJB/local");
			itmDBAccessLocal = new ITMDBAccessEJB();
			//Commented and modified by kailash on 20-07-18 as per gulzar sir[End]

			parentList = dom.getElementsByTagName("Detail"+ currentFormNo);
			int parentNodeListLength = parentList.getLength();
			//System.out.println("parentNodeListLength["+parentNodeListLength+"]");

			for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
			{
				parentNode = parentList.item(prntCtr);
				childList = parentNode.getChildNodes();
				noOfChilds = childList.getLength();
				for (int ctr = 0; ctr < noOfChilds; ctr++)
				{
					childNode = childList.item(ctr);
					if( childNode.getNodeType() != Node.ELEMENT_NODE )
					{
						continue;
					}

					if ( childNode != null && childNode.getFirstChild() != null )
					{
						columnValue = childNode.getFirstChild().getNodeValue();
					}
					childNodeName = childNode.getNodeName();

					if(childNodeName.equalsIgnoreCase("event_date"))
					{
						if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
								( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
						{
							errString = itmDBAccessLocal.getErrorString("event_date","NULLEVTCOD",userId);
							break;
						}
						else //to validate future date and holidays
						{
							//SimpleDateFormat sdfFormat = new SimpleDateFormat("dd/MM/yyyy");//commented by vinayak
							SimpleDateFormat sdfFormat = new SimpleDateFormat(getApplDateFormat());//Added by vinayak to set Date Format on [03/10/2016]

							String evtdat= childNode.getFirstChild().getNodeValue();
							java.util.Date eventDate = sdfFormat.parse( evtdat);
							//Changed By Vidhya on 09/12/09[WS89NOV647 | date validation for 00/00/00] Start
							if (!sdfFormat.format(eventDate).equals(evtdat))
							{
								errString = itmDBAccessLocal.getErrorString( "event_date", "INVDTFRMT", userId );
								break;
							}
							//Changed By Vidhya on 09/12/09[WS89NOV647 | date validation for 00/00/00] End

							if ( ( eventDate.compareTo( getDateObject( sdfFormat.format( new Date() ) ) ) ) > 0 )
							{
								errString = itmDBAccessLocal.getErrorString( "event_date", "FUTUREVENT", userId );
								break;
							}

							int allowDays = 0;
							checkSQL = "SELECT PROP_VALUE FROM PROPERTIES WHERE PROP_NAME ='MAX_ALLOW_PRD_MEET'";
							pstmt = connectionObject.prepareStatement(checkSQL);
							rSet = pstmt.executeQuery( checkSQL );
							if( rSet.next() )
							{
								allowDays = rSet.getInt("PROP_VALUE");
								//System.out.println("allowDays Exist In Properties are ["+allowDays+"]");
								java.util.Calendar cal = java.util.Calendar.getInstance();
								cal.setTime( getDateObject( sdfFormat.format( new Date() ) ) );
								cal.add( cal.DATE, -allowDays );
								if( eventDate.before( cal.getTime() ) )
								{
									errString = itmDBAccessLocal.getErrorString( "event_date" , "XCIDMITLMT" , userId );
									break;
								}
							}
							if (rSet!= null)
							{
								rSet.close();
								rSet = null;
							}
							if(pstmt!=null)
							{
								pstmt.close();
								pstmt = null;
							}

							//for checking Holiday
							String salesPers = genericUtility.getColumnValue( "sales_pers" , dom );
							if( salesPers != null && evtdat != null )
							{
								errString = valHoliday( evtdat, salesPers, userId, itmDBAccessLocal, connectionObject,"");
								if(errString != null && errString.length()>0 && errString.indexOf("ERRORS")!=-1)
								{
									errString = itmDBAccessLocal.getErrorString("event_date","HOLIDAY",userId);
									System.out.println("Holiday!");
									break;

								}
							}

						}

					}
					else if(childNodeName.equalsIgnoreCase("activity_code"))
					{
						if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
						{

							errString = itmDBAccessLocal.getErrorString("activity_code", "NULLACTCOD",userId);
							break;
						}
						else
						{
							if (columnValue.trim().length() > 2)
							{
								errString = itmDBAccessLocal.getErrorString("activity_code","LENGTH",userId);
								break;
							}
							else
							{
								checkSQL = "SELECT COUNT(1) COUNT FROM FIELDACTIVITY WHERE ACTIVITY_CODE = ?";
								pstmt = connectionObject.prepareStatement(checkSQL);
								pstmt.setString(1,checkNull(columnValue));
								rSet = pstmt.executeQuery();
								if(rSet.next() && rSet.getInt("COUNT") < 1 )
								{
									errString = itmDBAccessLocal.getErrorString("activity_code","INVEVET",userId);
									break;
								}

								if (rSet!= null)
								{
									rSet.close();
									rSet = null;
								}
								if(pstmt!=null)
								{
									pstmt.close();
									pstmt = null;
								}
								String eventDate = genericUtility.getColumnValue( "event_date" , dom );

								if(eventDate == null || eventDate.trim().length() == 0 || "null".equalsIgnoreCase(eventDate))
								{
									errString = itmDBAccessLocal.getErrorString("event_date","NULLEVTCOD",userId);
									break;
								}

								String salesPers = genericUtility.getColumnValue( "sales_pers" , dom );
								String pDate = "";
								try
								{
									//pDate = genericUtility.getValidDateString( eventDate , getApplDateFormat() , "dd-MMM-yyyy");//Shahu - 27/10/12
									pDate = genericUtility.getValidDateTimeString( eventDate , getApplDateFormat() , getDBDateFormat());//Shahu - 27/10/12
								}
								catch ( Exception e )
								{
									//System.out.println("------------- INVALIDFRMT ---------------");
									errString = itmDBAccessLocal.getErrorString( "event_date", "INVDTFRMT", userId );
									break;
								}
								checkSQL = "SELECT ACTIVITY_TYPE FROM STRG_MEET,FIELDACTIVITY WHERE EVENT_DATE=? AND SALES_PERS=?  AND FIELDACTIVITY.ACTIVITY_CODE = STRG_MEET.EVENT_TYPE";
								pstmt = connectionObject.prepareStatement(checkSQL);
								//pstmt.setString(1, pDate);//Shahu - 27/10/12
								pstmt.setTimestamp(1, java.sql.Timestamp.valueOf(pDate));//Shahu - 27/10/12
								pstmt.setString(2, salesPers);
								rSet = pstmt.executeQuery();
								if( rSet.next() )
								{
									String activityType = rSet.getString(1);
									activityType = checkNull(activityType).toUpperCase();
									//System.out.println("activityType######["+activityType+"]");
									if(activityType.indexOf("LEAVE")!=-1 )
									{
										checkSQL = " SELECT ACTIVITY_TYPE FROM FIELDACTIVITY WHERE ACTIVITY_CODE = ? ";
										pstmt = connectionObject.prepareStatement(checkSQL);
										pstmt.setString(1, columnValue);
										rSet = pstmt.executeQuery();
										if( rSet.next() )
										{
											if(!activityType.equalsIgnoreCase(rSet.getString(1)))
											{
												errString = itmDBAccessLocal.getErrorString( "event_type", "EPLANLEAVE", userId );
												break;
											}
										}
										if (rSet!= null)
										{
											rSet.close();
											rSet = null;
										}
										if(pstmt!=null)
										{
											pstmt.close();
											pstmt = null;
										}
									}
									//else if (activityType.indexOf("NFW")!=-1)
									else if (!(activityType.equalsIgnoreCase("FW") && activityType.equalsIgnoreCase("LEAVE")))

									{
										checkSQL = " SELECT ACTIVITY_TYPE FROM FIELDACTIVITY WHERE ACTIVITY_CODE = ? ";
										pstmt = connectionObject.prepareStatement(checkSQL);
										pstmt.setString(1, columnValue);
										rSet =pstmt.executeQuery();
										if( rSet.next() )
										{
											if(!activityType.equalsIgnoreCase(rSet.getString(1)))
											{
												errString = itmDBAccessLocal.getErrorString( "event_type", "EPLANNFW", userId );
												break;
											}
										}
										if (rSet!= null)
										{
											rSet.close();
											rSet = null;
										}
										if(pstmt!=null)
										{
											pstmt.close();
											pstmt = null;
										}
									}
									else if (activityType.indexOf("FW")!=-1)
									{
										checkSQL = " SELECT ACTIVITY_TYPE FROM FIELDACTIVITY WHERE ACTIVITY_CODE = ? ";
										pstmt = connectionObject.prepareStatement(checkSQL);
										pstmt.setString(1, columnValue);
										rSet =pstmt.executeQuery();
										if( rSet.next() )
										{
											if(!activityType.equalsIgnoreCase(rSet.getString(1)))
											{
												errString = itmDBAccessLocal.getErrorString( "event_type", "EPLANFW", userId );
												break;
											}
										}
										if (rSet!= null)
										{
											rSet.close();
											rSet = null;
										}
										if(pstmt!=null)
										{
											pstmt.close();
											pstmt = null;
										}
									}

								}
								if (rSet!= null)
								{
									rSet.close();
									rSet = null;
								}
								if(pstmt!=null)
								{
									pstmt.close();
									pstmt = null;
								}
							}
						}

					}
					else if(childNodeName.equalsIgnoreCase("sales_pers"))
					{
						if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
								( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
						{
							errString = itmDBAccessLocal.getErrorString("sales_pers","NULLSPRSCD",userId);
							break;
						}
						else
						{
							if( parentNodeListLength > 1 )
							{
								errString = itmDBAccessLocal.getErrorString("sales_pers","SPRSONCE",userId);
								break;
							}

							String eventDate = genericUtility.getColumnValue( "event_date" , dom );
							String sprs = childNode.getFirstChild().getNodeValue();
							String dcrID = genericUtility.getColumnValue( "dcr_id" , dom );
							if( dcrID == null || "null".equalsIgnoreCase(dcrID) )
							{
								dcrID = "x";
							}
							checkSQL = "SELECT * FROM SALES_PERS WHERE SALES_PERS = ?";
							pstmt = connectionObject.prepareStatement(checkSQL);
							pstmt.setString(1,checkNull(sprs));
							rSet = pstmt.executeQuery();
							if(!rSet.next())
							{
								errString = itmDBAccessLocal.getErrorString("sales_pers","WRGSPRSCD",userId);
								break;
							}

							/* Changed by Danish on 10/1/2009 [ Not to validate anymore as to get data for edit ] Uncommented for the moment
							checkSQL = "SELECT COUNT(1) COUNT FROM SPRS_ACT_TRAN WHERE SALES_PERS = ? AND EVENT_DATE = ? AND DCR_ID <> ?";
							pstmt = connectionObject.prepareStatement(checkSQL);
							pstmt.setString(1,checkNull(sprs));
							pstmt.setTimestamp( 2,java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString(checkNull(eventDate),genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat())));
							pstmt.setString(3,dcrID);
							rSet = pstmt.executeQuery();
							if(rSet.next() && rSet.getInt("COUNT")>0)
							{
								errString = itmDBAccessLocal.getErrorString("sales_pers","SPRSEXIST",userId);
								break;
							}*/


							if (rSet!= null)
							{
								rSet.close();
								rSet = null;
							}
							if(pstmt!=null)
							{
								pstmt.close();
								pstmt = null;
							}
						}
					}
					else if(childNodeName.equalsIgnoreCase("sprs_route_stan_code"))
					{
						if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
								( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
						{
							errString = itmDBAccessLocal.getErrorString("sprs_route_stan_code","NULLSTANCD",userId);
							break;
						}
					}
				}
				if(errString.indexOf("<Errors>")!=-1)
				{
					break;
				}
			}
		}
		catch(Exception e)
		{

			System.out.println ( "Exception :WsfaZuviusDsrMobileWizardEJB :wfValData():" + e.getMessage() + ":" );

			//errString = generateErrorString(genericUtility.createErrorString(e));//Commented By Dipak
			throw new ITMException(e);//Commented By Dipak

		}
		finally
		{
			try
			{
				if (rSet !=null )
				{
					rSet.close();
				}
				if(pstmt != null)
				{
					pstmt.close();
				}


				if (connectionObject != null)
				{
					connectionObject.close();
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}

		return errString;
	}
	//Changed By Vidhya on 25/11/09[ WS89NOV655 | separate method for validation in 'RIA'] END
	public String wfValLocality(Document dom, String currentFormNo, String userId) throws ITMException
	{
		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;

		//changed by Rahul Barve on 10-Apr-2015
		//GenericUtility genericUtility = GenericUtility.getInstance();
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

		String errString = "";
		String columnValue = "";
		String checkSQL = "";
		String childNodeName = "";
		String errString1 = "";
		String actType = "";

		Connection connectionObject = null;
		PreparedStatement pstmt = null;
		ResultSet rSet = null ;

		ITMDBAccessEJB itmDBAccessLocal = null;// modified by kailash.

		int ctr = 0;
		int noOfChilds = 0;

		boolean isAnyCustomerSel = false;
		boolean isDoctorSelected = false;
		boolean isChemistSelected = false;
		boolean isStockistSelected = false;
		boolean toValidateDoctor = true;
		boolean toValidateChemist = true;
		boolean toValidateStockist = true;

		try
		{
			AppConnectParm appConnect = new AppConnectParm();
			Properties p = appConnect.getProperty();
			InitialContext ctx = new InitialContext(p);
			//Commented and modified by kailash on 20-07-18 as per gulzar sir[Start]
			//itmDBAccessLocal = (ITMDBAccessLocal)ctx.lookup("ibase/ITMDBAccessEJB/local");
			itmDBAccessLocal = new ITMDBAccessEJB();
			//Commented and modified by kailash on 20-07-18 as per gulzar sir[End]

			/*ConnDriver connDriver = connDriver = new ConnDriver();;
			connectionObject = connDriver.getConnectDB("DriverValidator");*/
			connectionObject = getConnection();//chnged by sachin satre on [11-nov-16] to get connection

			parentList = dom.getElementsByTagName("Detail" + currentFormNo);
			int parentNodeListLength = parentList.getLength();
			//System.out.println("parentNodeListLength(wfValLocality)["+parentNodeListLength+"]");
			for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
			{
				String locDescr = getSelectedRowValue(dom, currentFormNo, "sprs_route_descr",prntCtr);
				String actCode = genericUtility.getColumnValue("activity_code", dom);
				actType = getActivityType(actCode, connectionObject);
				parentNode = parentList.item(prntCtr);
				childList = parentNode.getChildNodes();
				noOfChilds = childList.getLength();
				for (ctr = 0; ctr < noOfChilds; ctr++)
				{
					childNode = childList.item(ctr);
					if( childNode.getNodeType() != Node.ELEMENT_NODE )
					{
						continue;
					}

					if ( childNode != null && childNode.getFirstChild() != null )
					{
						columnValue = childNode.getFirstChild().getNodeValue().trim();
					}
					childNodeName = childNode.getNodeName();

					//System.out.println("childNodeName ["+childNodeName+"] actType ["+actType+"]");

					if(childNodeName.equalsIgnoreCase("locality_code"))
					{
						if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) || ( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue()))||childNode.getFirstChild() == null)
						{
							errString = itmDBAccessLocal.getErrorString("locality_code","NULLLOCTCD",userId);
							break;
						}
						else
						{

							if( actType.indexOf("LEAVE")!= -1 )
							{
								if( parentNodeListLength > 1 )
								{
									errString1 = itmDBAccessLocal.getErrorString("locality_code","LOCALONCE",userId);
									break;
								}
							}
						}


					}
					else if( childNodeName.equalsIgnoreCase("travel_mode") )
					{
						if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) || ( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue()))||childNode.getFirstChild() == null)
						{
							errString = itmDBAccessLocal.getErrorString("travel_mode","NULLTRVLM",userId);
							break;
						}
						else
						{
							if(actType.indexOf("LEAVE")!=-1 )
							{
								if( !columnValue.equalsIgnoreCase("ROAD"))
								{
									errString = itmDBAccessLocal.getErrorString("travel_mode","TRMODENFW",userId);
									break;
								}
							}
						}

					}
					else if(childNodeName.equalsIgnoreCase("over_night"))
					{
						if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) || ( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue()))||childNode.getFirstChild() == null)
						{
							errString = itmDBAccessLocal.getErrorString("over_night","NULLOVRNIT",userId);
							break;
						}
						else
						{
							//if( actType.indexOf("NFW")!=-1 || actType.indexOf("LEAVE")!=-1 )//Added & commented by mrunalini sinkar for NFW activity type not found(13-02-2019)
							if( !"FW".equalsIgnoreCase(actType))
							{
								if( !columnValue.equalsIgnoreCase("N"))
								{
									errString = itmDBAccessLocal.getErrorString("over_night","OVRNITENFW",userId);
									break;
								}
							}

						}

					}
					else if(childNodeName.equalsIgnoreCase("order_of_visit"))
					{
						if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) || ( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue()))||childNode.getFirstChild() == null)
						{
							errString = itmDBAccessLocal.getErrorString("order_of_visit","NULLORDVST",userId);
							break;
						}

					}
					else if ( actType.equalsIgnoreCase("FW") &&  ( "dr_visit".equalsIgnoreCase( childNodeName )  || "chem_visit".equalsIgnoreCase( childNodeName ) || "stockist_visit".equalsIgnoreCase( childNodeName ) ) )
					{
						/*
						if ( columnValue != null && "Y".equalsIgnoreCase(columnValue))
						{

							isAnyCustomerSel = true;
							String selectSql = "";
							int count = 0;

							String localityCode = getSelectedRowValue(dom, currentFormNo, "locality_code",prntCtr);
							String salesPers = getSelectedRowValue(dom, currentFormNo, "sales_pers",prntCtr);

							System.out.println("Validating for "+childNodeName+" LocalityCode ["+localityCode+"] salesPers ["+salesPers+"]");

							if( "dr_visit".equalsIgnoreCase( childNodeName ) )
							{
								selectSql = "select count(1) as count from strg_series ss,strg_customer sc where sc.locality_Code = ? and ss.sales_pers= ? and ss.sc_code = sc.sc_code and sc.cust_type = 'D' and ss.status = 'Y'";

								System.out.println("selectSql ["+selectSql+"]");

								pstmt = connectionObject.prepareStatement(selectSql);
								pstmt.setString(1,localityCode);
								pstmt.setString(2,salesPers);
								rSet = pstmt.executeQuery();
								if(rSet.next())
								{
									count = rSet.getInt("count");
								}

								System.out.println("count ["+count+"]");

								if( count == 0 )
								{
									errString = itmDBAccessLocal.getErrorString( "","NODREXIST",userId );
									break;
								}
								isDoctorSelected = true;
							}
							else if( "chem_visit".equalsIgnoreCase( childNodeName ) )
							{
								selectSql = "select count(1) as count from strg_series ss,strg_customer sc where sc.locality_Code = ? and ss.sales_pers = ? and ss.sc_code = sc.sc_code and sc.cust_type = 'C' and ss.status = 'Y'";
								System.out.println("selectSql ["+selectSql+"]");

								pstmt = connectionObject.prepareStatement(selectSql);
								pstmt.setString(1,localityCode);
								pstmt.setString(2,salesPers);

								rSet = pstmt.executeQuery();
								if(rSet.next())
								{
									count = rSet.getInt("count");
								}

								System.out.println("count ["+count+"]");

								if( count == 0 )
								{
									errString = itmDBAccessLocal.getErrorString( "","NOCHMEXIST",userId );
									break;
								}
								isChemistSelected = true;
							}

						}//if ( columnValue != null && "Y".equalsIgnoreCase(columnValue))
						 */
						{

							String selectSql = "";
							int count = 0;

							String localityCode = getSelectedRowValue(dom, currentFormNo, "locality_code",prntCtr);
							String salesPers = getSelectedRowValue(dom, currentFormNo, "sales_pers",prntCtr);

							//System.out.println("Validating for "+childNodeName+" LocalityCode ["+localityCode+"] salesPers ["+salesPers+"]");

							if( "dr_visit".equalsIgnoreCase( childNodeName ) )
							{
								//isDoctorSelected = true;
								selectSql = "select count(1) as count from strg_series ss,strg_customer sc where sc.locality_Code = ? and ss.sales_pers= ? and ss.sc_code = sc.sc_code and sc.cust_type = 'D' and ss.status = 'Y'";

								//System.out.println("selectSql ["+selectSql+"]");

								pstmt = connectionObject.prepareStatement(selectSql);
								pstmt.setString(1,localityCode);
								pstmt.setString(2,salesPers);
								rSet = pstmt.executeQuery();
								if(rSet.next())
								{
									count = rSet.getInt("count");
								}
								//added by rakesh kumar 13/12/12
								if (rSet!= null)
								{
									rSet.close();
									rSet = null;
								}
								if(pstmt!=null)
								{
									pstmt.close();
									pstmt = null;
								}
								//ended by rakesh kumar 13/12/12

								//System.out.println("count ["+count+"]");

								if (columnValue != null && "Y".equalsIgnoreCase(columnValue))
								{
									isAnyCustomerSel = true;
									isDoctorSelected = true;

									if ( count == 0 )
									{
										errString = itmDBAccessLocal.getErrorString( "","NODREXIST",userId );
										break;
									}
								}
								else if (columnValue != null && "N".equalsIgnoreCase(columnValue))
								{
									if ( count > 0 )
									{
										isDoctorSelected = false;
									}
									else
									{
										toValidateDoctor = false;
									}
								}

							}
							else if( "chem_visit".equalsIgnoreCase( childNodeName ) )
							{
								//isChemistSelected = true;
								selectSql = "select count(1) as count from strg_series ss,strg_customer sc where sc.locality_Code = ? and ss.sales_pers = ? and ss.sc_code = sc.sc_code and sc.cust_type = 'C' and ss.status = 'Y'";
								//System.out.println("selectSql ["+selectSql+"]");

								pstmt = connectionObject.prepareStatement(selectSql);
								pstmt.setString(1,localityCode);
								pstmt.setString(2,salesPers);

								rSet = pstmt.executeQuery();
								if(rSet.next())
								{
									count = rSet.getInt("count");
								}
								//added by rakesh kumar 13/12/12
								if (rSet!= null)
								{
									rSet.close();
									rSet = null;
								}
								if(pstmt!=null)
								{
									pstmt.close();
									pstmt = null;
								}
								//ended by rakesh kumar 13/12/12

								//System.out.println("count ["+count+"]");

								if (columnValue != null && "Y".equalsIgnoreCase(columnValue))
								{
									isAnyCustomerSel = true;
									isChemistSelected = true;

									if ( count == 0 )
									{
										errString = itmDBAccessLocal.getErrorString( "","NOCHMEXIST",userId );
										break;
									}
								}
								else if (columnValue != null && "N".equalsIgnoreCase(columnValue))
								{
									if ( count > 0 )
									{
										isChemistSelected = false;
									}
									else
									{
										toValidateChemist = false;
									}
								}
							}
							//Added by Gaurav Singh on 23-APR-2015 for validating Stockist [Start]
							else if( "stockist_visit".equalsIgnoreCase( childNodeName ) )
							{
								//System.out.println("Inside stockist_visit validation");
								//isDoctorSelected = true;
								selectSql = "select count(1) as count from strg_series ss,strg_customer sc where sc.locality_Code = ? and ss.sales_pers= ? and ss.sc_code = sc.sc_code and sc.cust_type = 'S' and ss.status = 'Y'";

								//System.out.println("selectSql ["+selectSql+"]");

								pstmt = connectionObject.prepareStatement(selectSql);
								pstmt.setString(1,localityCode);
								pstmt.setString(2,salesPers);
								rSet = pstmt.executeQuery();
								if(rSet.next())
								{
									count = rSet.getInt("count");
								}
								//added by rakesh kumar 13/12/12
								if (rSet!= null)
								{
									rSet.close();
									rSet = null;
								}
								if(pstmt!=null)
								{
									pstmt.close();
									pstmt = null;
								}
								//ended by rakesh kumar 13/12/12

								//System.out.println("count ["+count+"]");

								if (columnValue != null && "Y".equalsIgnoreCase(columnValue))
								{
									isAnyCustomerSel = true;
									isStockistSelected = true;

									if ( count == 0 )
									{
										errString = itmDBAccessLocal.getErrorString( "","NOSTKEXIST",userId );
										break;
									}
								}
								else if (columnValue != null && "N".equalsIgnoreCase(columnValue))
								{
									if ( count > 0 )
									{
										isStockistSelected = false;
									}
									else
									{
										toValidateStockist = false;
									}
								}
								//System.out.println("isAnyCustomerSel::["+isAnyCustomerSel+"] isStockistSelected :: ["+isStockistSelected+"] toValidateStockist :: ["+toValidateStockist+"]");
							}
							//Added by Gaurav Singh on 23-APR-2015 for validating Stockist [End]
						}//

					}
				}
				if( errString.indexOf("<Errors>")!=-1 || errString1.indexOf("<Errors>")!=-1 )
				{
					if( errString.length() > 0 )
					{
						String msgDescr = errString.substring(errString.indexOf("<description>")+("<description>").length(),errString.indexOf("</description>")) + " for locality " + locDescr ;

						errString = errString.substring(0, errString.indexOf("<description>")+("<description>").length()) + msgDescr + "" + errString.substring( errString.indexOf("</description>"), errString.length());
						break;
					}
					else if( errString1.length() > 0 )
					{
						errString = errString1;
						break;
					}

				}
			}

			if( errString == null || errString.trim().length() == 0 )
			{
				//System.out.println("isAnyCustomerSel ["+isAnyCustomerSel+"], actType=["+actType+"], isDoctorSelected =["+isDoctorSelected+"]");
				if( ! isAnyCustomerSel && ( actType.equalsIgnoreCase("FW") ) )
				{
					errString = itmDBAccessLocal.getErrorString( "","NOCUSTSELD",userId );
				}
				else
				{
					if( ! isDoctorSelected && toValidateDoctor && ( actType.equalsIgnoreCase("FW") ) )
					{
						errString = itmDBAccessLocal.getErrorString( "","NODOCTSELD",userId );
					}

					if( ! isChemistSelected && toValidateChemist && ( actType.equalsIgnoreCase("FW") ) )
					{
						errString = itmDBAccessLocal.getErrorString( "","NOCHEMSELD",userId );
					}
					//Added by Gaurav Singh on 23-APR-2015 for validating stockist [Start]
					if( ! isStockistSelected && toValidateStockist && ( actType.equalsIgnoreCase("FW") ) )
					{
						errString = itmDBAccessLocal.getErrorString( "","NOSTKSELD",userId );
					}
					//Added by Gaurav Singh on 23-APR-2015 for validating stockist [End]
				}
			}

		}
		catch(Exception e)
		{
			System.out.println ( "Exception :WsfaZuviusDsrMobileWizardEJB :wfValData():" + e.getMessage() + ":" );
			//errString = generateErrorString(genericUtility.createErrorString(e));//Commented By Dipak
			throw new ITMException(e);//Commented By Dipak
		}
		finally
		{
			try
			{
				if (rSet!= null)
				{
					rSet.close();
					rSet = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}

				if (connectionObject != null)
				{
					connectionObject.close();
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}

		return errString;

	}

	public String wfValCustomer(Document dom, String currentFormNo, String userId) throws ITMException
	{
		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;

		//changed by Rahul Barve on 10-Apr-2015
		//GenericUtility genericUtility = GenericUtility.getInstance();
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

		String errString = "";
		String errString1 = "";
		String columnValue = "";
		String checkSQL = "";
		String childNodeName = "";

		Connection connectionObject = null;
		PreparedStatement pstmt = null;
		ResultSet rSet = null ;

		ITMDBAccessEJB itmDBAccessLocal = null;// modified by kailash.

		int ctr = 0;
		int noOfChilds = 0;



		try
		{
			AppConnectParm appConnect = new AppConnectParm();
			Properties p = appConnect.getProperty();
			InitialContext ctx = new InitialContext(p);
			//Commented and modified by kailash on 20-07-18 as per gulzar sir[Start]
			//itmDBAccessLocal = (ITMDBAccessLocal)ctx.lookup("ibase/ITMDBAccessEJB/local");
			itmDBAccessLocal = new ITMDBAccessEJB();
			//Commented and modified by kailash on 20-07-18 as per gulzar sir[End];

			/*ConnDriver connDriver = connDriver = new ConnDriver();;
			connectionObject = connDriver.getConnectDB("DriverValidator");*/
			connectionObject = getConnection();//chnged by sachin satre on [11-nov-16] to get connection

			parentList = dom.getElementsByTagName("Detail" + currentFormNo);
			int parentNodeListLength = parentList.getLength();
			//System.out.println("dddddd : parentNodeListLength(wfValCustomer)["+parentNodeListLength+"]");
			for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
			{
				String custName = getSelectedRowValue(dom, currentFormNo, "cust_name",prntCtr);
				parentNode = parentList.item(prntCtr);
				childList = parentNode.getChildNodes();
				noOfChilds = childList.getLength();
				for (ctr = 0; ctr < noOfChilds; ctr++)
				{
					childNode = childList.item(ctr);
					if( childNode.getNodeType() != Node.ELEMENT_NODE )
					{
						continue;
					}
					if ( childNode != null && childNode.getFirstChild() != null )
					{
						columnValue = childNode.getFirstChild().getNodeValue().trim();
					}
					childNodeName = childNode.getNodeName();
					if(childNodeName.equalsIgnoreCase("short_id"))
					{
						if((childNode.getFirstChild() == null) || (childNode.getFirstChild().getNodeValue() == null) ||
								( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
						{
							errString = itmDBAccessLocal.getErrorString("short_id","NULLMPLNID",userId);
							break;
						}

					}
					else if(childNodeName.equalsIgnoreCase("event_time_start"))
					{
						if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
								( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
						{
							errString = itmDBAccessLocal.getErrorString("event_time_start","NULEVENTTS",userId);
							break;
						}
						else
						{
							String startTime = childNode.getFirstChild().getNodeValue().trim();
							int position = startTime.indexOf(':');

							if ( position < 0 )
							{
								errString = itmDBAccessLocal.getErrorString ("event_time_start", "STIMENV", userId );
								break;
							}
							else
							{
								String hour = startTime.substring( 0, position );
								String minute = startTime.substring( position + 1, startTime.length() ).trim();
								if ( hour.length() == 2 )
								{
									if(!checkIfNumber(hour))
									{
										System.out.println("HOUR IS NOT A NUMBER!!!!");
										errString = itmDBAccessLocal.getErrorString ("event_time_start", "STINVTIME", userId);
										break;
									}
									else if ( Integer.parseInt( hour.trim() ) > 23 )
									{
										errString = itmDBAccessLocal.getErrorString ("event_time_start", "SHOURENV", userId);
										break;
									}

								}
								else
								{
									errString = itmDBAccessLocal.getErrorString ("event_time_start", "SHTIMENV", userId);
									break;
								}
								if ( minute.length() == 2 )
								{
									if(!checkIfNumber(minute))
									{
										System.out.println("MINUTE IS NOT A NUMBER!!!!");
										errString = itmDBAccessLocal.getErrorString ("event_time_start", "STINVTIME", userId);
										break;
									}
									else if ( Integer.parseInt(minute.trim()) >59 )
									{
										errString = itmDBAccessLocal.getErrorString ( "event_time_start", "SMINUTE", userId);
										break;
									}

								}
								else
								{
									errString = itmDBAccessLocal.getErrorString ("event_time_start", "SMTIMENV", userId);
									break;
								}
							}
						}

					}
					else if(childNodeName.equalsIgnoreCase("event_time_end"))
					{
						if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
								( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
						{
							errString = itmDBAccessLocal.getErrorString("event_time_end","NULEVENTTE",userId);
							break;
						}
						else
						{
							String endTime = childNode.getFirstChild().getNodeValue().trim();

							int position = endTime.indexOf(':');
							if ( position < 0 )
							{
								errString = itmDBAccessLocal.getErrorString( "event_time_end", "ETIMENV", userId);
								break;
							}
							else
							{
								String hour = endTime.substring( 0, position);
								String minute = endTime.substring( position + 1, endTime.length() ).trim();

								if (hour.length() == 2 )
								{
									if(!checkIfNumber(hour))
									{
										System.out.println("HOUR IS NOT A NUMBER!!!!");
										errString = itmDBAccessLocal.getErrorString ("event_time_end", "STINVTIME", userId);
										break;
									}
									else if ( Integer.parseInt(hour.trim()) > 23 )
									{
										errString = itmDBAccessLocal.getErrorString ("event_time_end","EHOURE",userId );
										break;
									}
								}
								else
								{
									errString = itmDBAccessLocal.getErrorString ("event_time_end","EHTIMENV",userId);
									break;
								}
								if ( minute.length() == 2 )
								{
									if(!checkIfNumber(minute))
									{
										System.out.println("MINUTE IS NOT A NUMBER!!!!");
										errString = itmDBAccessLocal.getErrorString ("event_time_end", "STINVTIME", userId);
										break;
									}
									else if ( Integer.parseInt(minute.trim()) > 59 )
									{
										errString = itmDBAccessLocal.getErrorString ("event_time_end","EMINUTE",userId);
										break;
									}
								}
								else
								{
									errString = itmDBAccessLocal.getErrorString ("event_time_end","EMTIMENV",userId);
									break;
								}
								String eventTimeStart = getSelectedRowValue(dom, currentFormNo, "event_time_start",prntCtr);

								int stPosition = eventTimeStart.indexOf(':');
								if ( stPosition < 0 )
								{
									errString = itmDBAccessLocal.getErrorString ("event_time_start","STIMENV",userId);
									break;
								}
								else
								{
									String stHoure = eventTimeStart.substring( 0, stPosition ).trim();
									String stMinute = eventTimeStart.substring( stPosition + 1, eventTimeStart.length() ).trim();

									position = endTime.indexOf(':');
									if ( position < 0 || stHoure.length() == 0 || stMinute.length() == 0 )
									{
										errString = itmDBAccessLocal.getErrorString ("event_time_end","ETIMENV",userId);
										break;
									}
									else
									{

										if ( stHoure.length() > 0 && hour.length() > 0 )
										{
											if ( Integer.parseInt(hour) < Integer.parseInt(stHoure) )
											{
												errString = itmDBAccessLocal.getErrorString ("event_time_end","ETHLSTH",userId);
												break;
											}

											if ( stHoure.equalsIgnoreCase( hour ) )
											{
												if ( stMinute.length() > 0 && minute.length() > 0 )
												{
													if ( Integer.parseInt( minute ) < Integer.parseInt( stMinute ) )
													{
														errString = itmDBAccessLocal.getErrorString ("event_time_end","ETMLSTM",userId);
														break;
													}
												}
											}
											if ( Integer.parseInt( stHoure ) == Integer.parseInt( hour ) && Integer.parseInt( stMinute ) == Integer.parseInt( minute ) )
											{
												errString = itmDBAccessLocal.getErrorString ("event_time_end","EQUAL",userId);
												break;
											}
										}
									}//End else(position)
								}//End else
							}//End else
						}
					}
					else if(childNodeName.equalsIgnoreCase("strg_code"))
					{
						String actCode = genericUtility.getColumnValue("event_type",dom);
						if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
								( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
						{
							if( actCode.equalsIgnoreCase("FW") || actCode.indexOf("FW")!= -1 )
							{
								errString1 = itmDBAccessLocal.getErrorString("strg_code","CUSTREQD",userId);
								break;

							}
							else
							{
								errString1 = itmDBAccessLocal.getErrorString("strg_code","NULSTRGCD",userId);
								break;
							}

						}
						else
						{
							String actType = getActivityType(actCode, connectionObject);
							if(actType.indexOf("LEAVE")!=-1)
							{
								if( parentNodeListLength > 1 )
								{
									errString1 = itmDBAccessLocal.getErrorString("strg_code","CUSTONCE",userId);
								}
							}

						}
					}
					else if ( "strg_type".equalsIgnoreCase( childNodeName ) )
					{
						String strgCode = genericUtility.getColumnValue( "strg_code", dom );
						//Verifying only in case "Doctor is selected"
						if(  strgCode != null &&  strgCode.length() > 0 && (   ( ! "null".equalsIgnoreCase(strgCode) ) || ( ! "-NA-".equalsIgnoreCase(strgCode) ) ) )
						{
							if ( childNode.getFirstChild() == null )
							{
								errString = itmDBAccessLocal.getErrorString("strg_type","NULSTRGT",userId);
								break;
							}

						}
					}
					else if ( "strg_class_code".equalsIgnoreCase( childNodeName ) )
					{
						String strgCode = genericUtility.getColumnValue("strg_code",dom);
						//Verifying only in case "Doctor is selected"
						if(  strgCode != null &&  strgCode.length() > 0 && (   ( ! "null".equalsIgnoreCase(strgCode) ) || ( ! "-NA-".equalsIgnoreCase(strgCode) ) ) )
						{
							if ( childNode.getFirstChild() == null )
							{
								errString = itmDBAccessLocal.getErrorString("strg_class_code","NULSTRCC",userId);
								break;
							}
						}
					}
					else if ( "strg_no_visit".equalsIgnoreCase( childNodeName ) )
					{
						String strgCode = genericUtility.getColumnValue( "strg_code", dom );
						//Verifying only in case "Doctor is selected"
						if(  strgCode != null &&  strgCode.length() > 0 && (   ( ! "null".equalsIgnoreCase(strgCode) ) || ( ! "-NA-".equalsIgnoreCase(strgCode) ) ) )
						{
							if ( childNode.getFirstChild() == null )
							{
								errString = itmDBAccessLocal.getErrorString("strg_no_visit","NULSTRGV",userId);
								break;
							}
						}
					}
					else if ( "strg_name".equalsIgnoreCase( childNodeName ) )
					{
						String strgCode = genericUtility.getColumnValue( "strg_code", dom );
						String strgType = genericUtility.getColumnValue( "strg_type", dom );
						if( strgCode == null  && strgType != null )
						{
							if ( childNode.getFirstChild() == null  )
							{
								errString = itmDBAccessLocal.getErrorString("strg_name","NULSTRGN",userId);
								break;
							}
						}
						else
						{
							if (strgCode != null && childNode.getFirstChild() != null)
							{
								errString = itmDBAccessLocal.getErrorString("strg_name","INSERTVALD",userId);
							}
						}
					}
					else if ( "order_booked".equalsIgnoreCase( childNodeName ) )
					{
						if ( childNode.getFirstChild() == null )
						{
							errString = itmDBAccessLocal.getErrorString("order_booked","ORBONONUL",userId );
							break;
						}
						else
						{
							//Changed By Vidhya on 19/11/09[WS89NOV613 | ORDER BOOKED LENGTH TO BE 6-DIGITS]
							//if( columnValue.length() > 2 )
							if( columnValue.length() > 6 )
							{
								String orderBooked =  "";
								String ordBookDec = "";
								if(columnValue.indexOf(".") != -1)
								{
									System.out.println("entered a decimal!!!!!");
									orderBooked =  columnValue.substring(0, columnValue.indexOf("."));
									ordBookDec =  columnValue.substring(columnValue.indexOf(".")+1,columnValue.length());
									if(!checkIfNumber(orderBooked) || !checkIfNumber(ordBookDec))
									{
										System.out.println("Not a number!!!!!");
										errString = itmDBAccessLocal.getErrorString( "order_booked","INVORDERBK",userId );
										break;

									}
									//Changed By Vidhya on 19/11/09[WS89NOV613 | ORDER BOOKED LENGTH TO BE 6-DIGITS]
									//else if(orderBooked.length() > 2)
									else if(orderBooked.length() > 6)
									{
										errString = itmDBAccessLocal.getErrorString( "order_booked","ORDERBKDGT",userId );
										break;
									}

								}
								else
								{
									//System.out.println("Not a two-digit number!!!");
									errString = itmDBAccessLocal.getErrorString("order_booked","ORDERBKDGT",userId );
									break;

								}

							}
							else
							{
								if(!checkIfNumber(columnValue))
								{
									//System.out.println("(2-dig)Not a number!!!!!");
									errString = itmDBAccessLocal.getErrorString( "order_booked","INVORDERBK",userId );
									break;

								}

							}

						}
					}

				}
				if(errString.indexOf("<Errors>")!=-1 || errString1.indexOf("<Errors>")!=-1)
				{
					if( errString.length() > 0 )
					{
						String msgDescr = "";
						msgDescr = errString.substring(errString.indexOf("<description>")+("<description>").length(),errString.indexOf("</description>")) + " for customer " + custName ;

						if( custName.length() != 0 && !custName.equalsIgnoreCase("") )
						{
							errString = errString.substring(0, errString.indexOf("<description>")+("<description>").length()) + msgDescr + "" + errString.substring( errString.indexOf("</description>"), errString.length());
						}
						break;
					}
					else if( errString1.length() > 0 )
					{
						errString = errString1;
						break;
					}

				}
			}


		}
		catch(Exception e)
		{
			System.out.println ( "Exception :WsfaZuviusDsrMobileWizardEJB :wfValData():" + e.getMessage() + ":" );

			//errString = generateErrorString(genericUtility.createErrorString(e));//Commented By Dipak
			throw new ITMException(e);//Commented By Dipak

		}
		finally
		{
			try
			{
				if (rSet!= null)
				{
					rSet.close();
					rSet = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}

				if (connectionObject != null)
				{
					connectionObject.close();
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return errString;

	}

	public String wfValItem(Document dom, Document dom2, String currentFormNo, String userId) throws ITMException
	{
		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;

		//changed by Rahul Barve on 10-Apr-2015
		//GenericUtility genericUtility = GenericUtility.getInstance();
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

		String errString = "";
		String errString1 = "";
		String checkSQL = "";
		String childNodeName = "";
		String columnValue = "";

		Connection connectionObject = null;
		PreparedStatement pstmt = null;
		ResultSet rSet = null ;

		ArrayList itemPitchList = new ArrayList();

		ITMDBAccessEJB itmDBAccessLocal = null;// modified by kailash.

		int ctr = 0;
		int noOfChilds = 0;

		try
		{
			AppConnectParm appConnect = new AppConnectParm();
			Properties p = appConnect.getProperty();
			InitialContext ctx = new InitialContext(p);
			//Commented and modified by kailash on 20-07-18 as per gulzar sir[Start]
			//itmDBAccessLocal = (ITMDBAccessLocal)ctx.lookup("ibase/ITMDBAccessEJB/local");
			itmDBAccessLocal = new ITMDBAccessEJB();
			//Commented and modified by kailash on 20-07-18 as per gulzar sir[End]

			/*ConnDriver connDriver = connDriver = new ConnDriver();
			connectionObject = connDriver.getConnectDB("DriverValidator");*/
			connectionObject = getConnection();//chnged by sachin satre on [11-nov-16] to get connection

			parentList = dom.getElementsByTagName("Detail" + currentFormNo);
			int parentNodeListLength = parentList.getLength();
			//System.out.println("parentNodeListLength(wfValItem)["+parentNodeListLength+"]");
			for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
			{
				String custCode = getSelectedRowValue(dom, currentFormNo, "strg_code",prntCtr);
				String sprsProdGrp = getSelectedRowValue(dom, currentFormNo, "sales_prod_grp", prntCtr);
				String itemCode = getSelectedRowValue(dom, currentFormNo, "item_code",prntCtr);
				String itemDescr = getSelectedRowValue(dom, currentFormNo, "item_descr",prntCtr);
				parentNode = parentList.item(prntCtr);
				childList = parentNode.getChildNodes();
				noOfChilds = childList.getLength();
				for (ctr = 0; ctr < noOfChilds; ctr++)
				{
					childNode = childList.item(ctr);
					if( childNode.getNodeType() != Node.ELEMENT_NODE )
					{
						continue;
					}
					if ( childNode != null && childNode.getFirstChild() != null )
					{
						columnValue = childNode.getFirstChild().getNodeValue().trim();
					}
					childNodeName = childNode.getNodeName();
					if(childNodeName.equalsIgnoreCase("item_code"))
					{
						if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) || ( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
						{
							if(sprsProdGrp == null || "null".equalsIgnoreCase(sprsProdGrp))
							{
								errString = itmDBAccessLocal.getErrorString("item_code","NULLITEMCD",userId);
								break;
							}
						}
						else
						{
							String pitch = getSelectedRowValue(dom, currentFormNo, "briefed_descr",prntCtr);
							if(!pitch.equalsIgnoreCase("Promo Material"))
							{
								errString = itmDBAccessLocal.getErrorString("item_code","INVLPITCH",userId);
								break;
							}
							String actCode = genericUtility.getColumnValue("activity_code",dom2);
							String actType = getActivityType(actCode,connectionObject);
							//if(actType.indexOf("NFW")!=-1 || actType.indexOf("LEAVE")!=-1)//Added & commented by mrunalini sinkar for NFW activity type not found(13-02-2019)
							if(!"FW".equalsIgnoreCase(actType))
							{
								if( parentNodeListLength > 0 )
								{
									errString1 = itmDBAccessLocal.getErrorString("item_code","ITEMNOTREQ",userId);
									break;
								}
							}

						}

					}
					else if(childNodeName.equalsIgnoreCase("sales_prod_grp"))
					{
						if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) || ( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
						{
							if(itemCode == null || "null".equalsIgnoreCase(itemCode))
							{
								errString = itmDBAccessLocal.getErrorString("sales_prod_grp","NULLSPGRP",userId);
								break;

							}

						}
						else
						{
							String pitch = getSelectedRowValue(dom, currentFormNo, "briefed_descr",prntCtr);
							if(pitch.equalsIgnoreCase("Promo Material"))
							{
								if(!(pitch.equalsIgnoreCase("P1") || pitch.equalsIgnoreCase("P2") || pitch.equalsIgnoreCase("P3") || pitch.equalsIgnoreCase("P4")))
								{
									errString = itmDBAccessLocal.getErrorString("sales_prod_grp","INVLPITCH",userId);
									break;
								}
							}

							String actCode = genericUtility.getColumnValue("activity_code",dom2);
							String actType = getActivityType(actCode,connectionObject);
							//if( actType.indexOf("NFW")!=-1 || actType.indexOf("LEAVE")!=-1 )//Added & commented by mrunalini sinkar for NFW activity type not found(13-02-2019)
							if(!"FW".equalsIgnoreCase(actType))
							{
								if( parentNodeListLength > 0 )
								{
									errString1 = itmDBAccessLocal.getErrorString("sales_prod_grp","ITEMNOTREQ",userId);
									break;
								}
							}
						}
					}
					else if(childNodeName.equalsIgnoreCase("briefed_descr"))
					{
						if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
								( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
						{
							errString = itmDBAccessLocal.getErrorString("briefed_descr","NULLPITCH", userId);
							break;
						}
						else
						{
							String pitch = columnValue + "["+custCode+"]";
							if(!pitch.startsWith("Promo Material") && itemPitchList.contains(pitch) )
							{
								if ( sprsProdGrp.length() != 0 && !"null".equalsIgnoreCase(sprsProdGrp) )
								{
									errString = itmDBAccessLocal.getErrorString("briefed_descr","ITEMONCE",userId);
									break;
								}

							}
							itemPitchList.add(pitch);

						}

					}
					else if ( "quantity".equalsIgnoreCase( childNodeName ) )
					{
						if ( (childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) || ( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())) )
						{
							errString = itmDBAccessLocal.getErrorString("quantity","NULQUACD",userId);
							break;
						}
						else
						{

							if( Integer.parseInt( columnValue ) > 0 )
							{
								if( sprsProdGrp.length() != 0 && !"null".equalsIgnoreCase(sprsProdGrp) )
								{
									errString = itmDBAccessLocal.getErrorString("quantity","INVLQUANT",userId);
									break;
								}

							}
							else if(!( Integer.parseInt( columnValue ) > 0 ))
							{
								if( itemCode.length() != 0 && !"null".equalsIgnoreCase(itemCode) )
								{
									errString = itmDBAccessLocal.getErrorString("quantity","QUANTREQD",userId);
									break;
								}

							}
						}

					}

				}
				if( errString.indexOf("<Errors>")!=-1 || errString1.indexOf("<Errors>")!=-1)
				{
					if( errString.length() > 0 )
					{
						errString = getItemErrorString( errString,  custCode, itemDescr, itemCode, sprsProdGrp,connectionObject); //Chnaged by sachin satre on 09-nov-16
						break;
					}
					else if( errString1.length() > 0 )
					{
						errString = errString1;
						break;
					}
				}
			}
			itemPitchList.clear();

		}
		catch(Exception e)
		{
			System.out.println ( "Exception :WsfaZuviusDsrMobileWizardEJB :wfValData():" + e.getMessage() + ":" );
			//errString = generateErrorString(genericUtility.createErrorString(e));//Commented By Dipak
			throw new ITMException(e);//Commented By Dipak

		}
		finally
		{
			try
			{
				if (rSet!= null)
				{
					rSet.close();
					rSet = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}


				if (connectionObject != null)
				{
					connectionObject.close();
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return errString;

	}
	//Validation End*********

	//Getting Default Values for forms Start*********
	//Changed By Vidhya on 15/10/09[WI89BAS033 | changing signature ]
	//public String getSalesPers(Document dom, String currentForm, String userId, String salesPers, String actCode, String trvDate) throws ITMException
	public String getSalesPers(Document dom, Document dom2, String currentForm, String userId, String salesPers, String actCode, String trvDate) throws ITMException
	{
		ResultSet rs = null;
		Connection connectionObject = null;
		Statement stmt = null;

		String sql = "";
		String currDate = "";
		String chgTerm ="";
		String preFormDet ="";
		String actDescr = "";
		StringBuffer valueXmlString = new StringBuffer();
		boolean flag = false;
		//Changed By Vidhya on 15/10/09[WI89BAS033 | Changing signature]
		ArrayList temp = new ArrayList();

		//changed by Rahul Barve on 10-Apr-2015
		//GenericUtility genericUtility = GenericUtility.getInstance();
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		try
		{
			InetAddress ownIP=InetAddress.getLocalHost();
			chgTerm = ownIP.getHostAddress();

			DateFormat dtFormat = new SimpleDateFormat(getApplDateFormat());
			java.util.Date date = Calendar.getInstance().getTime();
			currDate = dtFormat.format( date );
			//System.out.println("SalesPerson  (getSalesPers)> "+salesPers);
			if( salesPers != null && salesPers.trim().length() > 0 && !salesPers.equalsIgnoreCase("") )
			{
				salesPers = salesPers.trim().toUpperCase();
			}
			/*ConnDriver connDriver = new ConnDriver();
			connectionObject = connDriver.getConnectDB( "DriverValidator" );*/
			connectionObject = getConnection();//chnged by sachin satre on [11-nov-16] to get connection

			//to append previous values of current form from current dom on previous action
			flag = preDomExists( dom, currentForm );
			System.out.println( "history detail exists["+ flag +"]" );
			if( flag )
			{
				//Changed By Vidhya on 15/10/09[WI89BAS033 | Changing signature]Start
				//preFormDet = getPrevFormValues( dom, currentForm, domID );
				preFormDet = getPrevFormValues( dom, currentForm, temp , "sales_pers");
				Document preFormDom =  genericUtility.parseString("<Root>"+preFormDet+"</Root>");
				String actCodePreDom = genericUtility.getColumnValue( "activity_code",preFormDom );
				java.util.Date eventDte = genericUtility.getDateObject(genericUtility.getColumnValue( "event_date", preFormDom ));

				//for creating act_desr node
				sql = "SELECT DESCR FROM FIELDACTIVITY WHERE ACTIVITY_CODE = '"+actCodePreDom+"'";
				stmt = connectionObject.createStatement();
				rs = stmt.executeQuery(sql);
				if(rs.next())
				{
					actDescr = rs.getString("DESCR");

				}
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(stmt!=null)
				{
					stmt.close();
					stmt = null;
				}
				Element element = (Element) preFormDom.getElementsByTagName("Detail"+currentForm).item(0);
				element.appendChild(preFormDom.createElement("activity_descr"));
				preFormDom.getElementsByTagName("activity_descr").item(0).appendChild(preFormDom.createCDATASection(actDescr));

				//for eventdate as long
				Node node = preFormDom.getElementsByTagName("Detail" + currentForm).item(0);
				NodeList nodeList = node.getChildNodes();
				for (int i = 0; i < nodeList.getLength(); i++ )
				{
					Node elementNode = nodeList.item(i);
					if ( elementNode.getNodeName().equals("event_date") )
					{
						if ( elementNode.getFirstChild() == null)
						{
							Element sourceElement = preFormDom.createElement( "event_date" );
							Text sourceText = preFormDom.createTextNode( Long.toString(eventDte.getTime()) );
							sourceElement.appendChild( sourceText );
							Node updatedNode = preFormDom.importNode( ( Node ) sourceElement,true );
							node.replaceChild( updatedNode, elementNode );
						}
						else
						{
							elementNode.getFirstChild().setNodeValue( Long.toString(eventDte.getTime()) );
						}
					}
				}
				//Changed By Vidhya on 15/10/09[WI89BAS033 | Changing signature] End
				preFormDet = genericUtility.serializeDom(preFormDom);
				if( preFormDet != null || !"null".equalsIgnoreCase( preFormDet ))
				{
					valueXmlString.append( preFormDet );
					domID = domID + 1;
				}

			}

			//for sales person
			sql = "SELECT DISTINCT SR.SPRS_CODE SALES_PERS, UPPER(SP.SP_NAME) SP_NAME FROM SPRS_ROUTE SR, SALES_PERS SP WHERE SR.SPRS_CODE = SP.SALES_PERS AND SR.STATUS = 'Y' AND SP.SP_NAME LIKE '%"+checkNull(salesPers)+"%' ORDER BY SPRS_CODE ";
			stmt = connectionObject.createStatement();
			rs = stmt.executeQuery(sql);
			while(rs.next())
			{
				valueXmlString.append( "<Detail"+currentForm+" domID='" + domID + "' selected ='N'>\r\n" );
				valueXmlString.append( "<sales_pers><![CDATA[" ).append(checkNull(rs.getString("SALES_PERS"))).append( "]]></sales_pers>\r\n" );
				valueXmlString.append( "<sales_pers_sp_name><![CDATA[" ).append(checkNull(rs.getString("SP_NAME"))).append( "]]></sales_pers_sp_name>\r\n" );
				valueXmlString.append( "<event_date><![CDATA[" ).append( checkNull( trvDate ) ).append( "]]></event_date>\r\n" );
				valueXmlString.append( "<activity_code><![CDATA[" ).append( checkNull( actCode )).append( "]]></activity_code>\r\n" );
				valueXmlString.append( "<chg_date><![CDATA[" ).append(currDate).append( "]]></chg_date>\r\n" );
				valueXmlString.append( "<chg_user><![CDATA[" ).append(userId).append( "]]></chg_user>\r\n" );
				valueXmlString.append( "<chg_term><![CDATA[" ).append(chgTerm).append( "]]></chg_term>\r\n" );
				valueXmlString.append( "<dcr_id><![CDATA[]]></dcr_id>\r\n" );
				valueXmlString.append( "</Detail"+currentForm+">\r\n" );
				domID++;

			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(stmt!=null)
			{
				stmt.close();
				stmt = null;
			}

			domID = 1;

		}
		catch(Exception e)
		{
			System.out.println( "Exception :WsfaZuviusDsrMobileWizardEJB :getPlaceOfWork():" + e.getMessage() + ":" );
			//valueXmlString = valueXmlString.append( generateErrorString( genericUtility.createErrorString( e ) ) );
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		finally
		{
			try
			{
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(stmt!=null)
				{
					stmt.close();
					stmt = null;
				}
				if( connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :WsfaZuviusDsrMobileWizardEJB :getPlaceOfWork :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		return valueXmlString.toString();
	}
	//to get place of work
	public String getPlaceOfWork( Document dom, Document dom2, String currentForm,String formName, String userId, String sprsCode, String actCode,String actType, String trvDate, String loginMode,String loginCode,Connection connectionObject) throws ITMException //chnged by sachin satre on [9-nov-16] to get connection
	{
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		String custType = null;
		String localityCode=null;
		String sql = "";
		String sqlEdit = "";
		String currDate = "";
		String chgTerm ="";
		String preFormDet ="";
		String locality ="";
		String selRouteId ="";

		String planDataString="";
		String placeOfReturnStr="";
		String placeOfReturnDescr="";
		String cusType="";
		int cnt=0;
		StringBuffer valueXmlString = new StringBuffer();
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		boolean flag = false;
		int rowsRS = 0;
		int count=0;
		ArrayList temp = new ArrayList();
		int currForm = 0;
		String modeReport = "A";

		String dcrID = "";
		boolean isLocalConn=false;
		if(currentForm != null && currentForm.trim().length() > 0)
			currForm  = Integer.parseInt(currentForm);

		String objName = checkNull(getObjNameFromDom(dom2, "objName",currForm));
		String locFormNo = checkNull(getFormNo(objName, "place", connectionObject));
		String mainFormNo = checkNull(getFormNo(objName, "mainform", connectionObject));
		String retailFormNo = checkNull(getFormNo(objName, "retailer", connectionObject));
		String docFormNo = checkNull(getFormNo(objName, "doctor", connectionObject));
		String stockistFormNo = checkNull(getFormNo(objName, "stockist", connectionObject));
		String ncwFormNo = checkNull(getFormNo(objName, "ncw", connectionObject));


		try
		{
            // Added by Pankaj R on 15-JUN-21 to get the week and day of the event date to set the route as by default for plan_days[START]
            DateFormat dtAppFormat = new SimpleDateFormat(getApplDateFormat());
			Date parsedDate = dtAppFormat.parse(trvDate);
			Calendar calendar = Calendar.getInstance();
			calendar.setTime(parsedDate);
			String days[] = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
			String prefixes[] = new String[]{"1st", "2nd", "3rd", "4th", "5th"};
			String dayName = days[parsedDate.getDay()];
            String weekDayString = "";
			if(parsedDate.getDate() % 7 == 0)
			{
				weekDayString = prefixes[(int)Math.floor((parsedDate.getDate() / 7) - 1)] + ' ' + days[parsedDate.getDay()];
			}
			else
			{
				weekDayString = prefixes[(int)Math.floor(parsedDate.getDate() / 7)] + ' ' + days[parsedDate.getDay()];
			}
            System.out.println("weekDayString : ["+weekDayString+"]");
            // Added by Pankaj R on 15-JUN-21 to get the week and day of the event date to set the route as by default for plan_days[END]

			if(sprsCode != null && sprsCode.length()> 0)//changes by shraddha M null pointer exception in exception log[09-oct-2020]
			{
				temp.add("'"+sprsCode.trim()+"'");
			}
			//temp.add("'"+sprsCode.trim()+"'");

			InetAddress ownIP=InetAddress.getLocalHost();
			chgTerm = ownIP.getHostAddress();

			DateFormat dtFormat = new SimpleDateFormat(getApplDateFormat());
			java.util.Date date = Calendar.getInstance().getTime();
			currDate = dtFormat.format( date );
			//System.out.println("SalesPerson > " + sprsCode);
			if(connectionObject == null)
			{
				connectionObject = getConnection();
				isLocalConn=true;
			}

			//0- Don't allow if created from real time reporting, 1-Always Allow, 2-Never allow.
			String allowEditPlace = "0",allowEditCust = "0";
			allowEditPlace = getSfaParmValue(sprsCode,"ALLOW_EDIT_PLACE_DCR",connectionObject);
			allowEditCust = getSfaParmValue(sprsCode,"ALLOW_EDIT_CUST_DCR",connectionObject);
			//System.out.println("allowEditPlace:::"+allowEditPlace+"  allowEditCust:::"+allowEditCust);
			String stockParmData = checkNull(getSfaParmValue(userId, "ALLOW_STOCKIST_DAR", connectionObject));
			
			
			//Added by mrunalini sinkar for fortune call_outcome changes on 12-may-2021(Start)
			String isFortune  = checkNull(getSfaParmValue(userId,"IS_FORTUNE_ACTIVITY",connectionObject));
			String activityFormNo = checkNull(getFormNo(objName, "activity", connectionObject));
			String sprsActCode="";
			boolean isButtonDisable=false;
			if("Y".equalsIgnoreCase(isFortune))
			{
				isButtonDisable=true;
				NodeList actParentList = dom2.getElementsByTagName("Detail"+activityFormNo);
				int actparentNodeListLength = actParentList.getLength();
				for (int prntCtr = 0; prntCtr < actparentNodeListLength; prntCtr++ )
				{	
					sprsActCode = checkNull(getSelectedRowValue(dom2,activityFormNo, "activity_code",prntCtr));
					String sprsActivityType = checkNull(getActivityType( sprsActCode ,connectionObject));
					System.out.println("actType ===========>["+sprsActivityType+"]");
					if("FW".equalsIgnoreCase(sprsActivityType))
					{
						isButtonDisable=false;
						break;
					}
				}
			}
			//Added by mrunalini sinkar for fortune call_outcome changes on 12-may-2021(End)
			
			
			

			placeOfReturnStr = genericUtility.getColumnValue("last_place_of_return", dom2, mainFormNo);
			placeOfReturnDescr = genericUtility.getColumnValue("last_place_of_descr_return", dom2, mainFormNo);
			String copyPlan = checkNull(getSelectedRowValue(dom2, mainFormNo, "copy_plan", 0));
			dcrID = getDCRId(connectionObject,sprsCode, trvDate);
			//Addede by mrunalini sinkar to get by default travel mode descriptionon 05-10-2019 (start)
			String modeDescr="";
			sql = "SELECT TRAVEL_MODE_DESCR FROM TRAVEL_MODE_MASTER ORDER BY TRAVEL_MODE_ID";
			pstmt =  connectionObject.prepareStatement( sql );
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				modeDescr = checkNull(rs.getString("TRAVEL_MODE_DESCR"));
			}
			if (rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
			//Addede by mrunalini sinkar to get by default travel mode descriptionon 05-10-2019 (end)

			String stockistTable = getSfaParmValue(sprsCode,"GET_STOCKIST_DETAILS",connectionObject);
			//Added by Mrunalini sinkar to configure status_hist table changes11-02-2020(start)
			String statusHistConfig = getSfaParmValue(userId,"STATUS_HIST_REQUIRED",connectionObject);
			String statusHistCondition="";
			if("Y".equalsIgnoreCase(statusHistConfig))
			{
				statusHistCondition="AND SS.SC_CODE IN  (SELECT SC_CODE FROM STRG_STATUS_HIST WHERE STATUS = 'Y' AND EFF_FROM <= ? AND VALID_UPTO >= ? AND SALES_PERS = SS.SALES_PERS AND SC_CODE = SC.SC_CODE )";
			}
			//Added by Mrunalini sinkar to configure status_hist table changes11-02-2020(end)

			//System.out.println("dcrID =["+dcrID+"], custType =["+custType+"] copyPlan=["+copyPlan+"]");
			sql = "SELECT COUNT(*) FROM SPRS_TRAVEL WHERE SALES_PERS = ? AND TRAVEL_DATE = ?";
			PreparedStatement pstmtSprsTravel =  connectionObject.prepareStatement( sql );
			pstmtSprsTravel.setString(1, sprsCode);
			pstmtSprsTravel.setTimestamp( 2, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( trvDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
			ResultSet rsTravel = pstmtSprsTravel.executeQuery();
			if(rsTravel.next())
			{
				rowsRS = rsTravel.getInt(1);
			}
			if (rsTravel != null)
			{
				rsTravel.close();
				rsTravel = null;
			}
			if(pstmtSprsTravel!=null)
			{
				pstmtSprsTravel.close();
				pstmtSprsTravel = null;
			}
			//System.out.println("rowsRS:::::[ "+rowsRS+" ]");
			if(rowsRS > 0)
			{
				modeReport = "E";
			}
			flag = preDomExists( dom2, currentForm );
			//System.out.println( "history detail exists["+ flag +"]" );

			//Added by Rushikesh More On 20-03-17 for visibility of visit of doctor and retailer in specific locality

			/*ArrayList custTypeList = new ArrayList();
			String custTypeSql = "SELECT TYPE FROM STRG_CUST_TYPE";
			PreparedStatement pstmtCustType = connectionObject.prepareStatement(custTypeSql);
			ResultSet rsCustType = pstmtCustType.executeQuery();
			while(rsCustType.next())
			{
				custTypeList.add(checkNull(rsCustType.getString("TYPE")));
			}
			if(rsCustType != null)
			{
				rsCustType.close();
				rsCustType = null;
			}
			if(pstmtCustType != null)
			{
				pstmtCustType.close();
				pstmtCustType = null;
			}*/
			//ArrayList custTypeList = getCustType(connectionObject);
			ArrayList custTypeList = getCustType(connectionObject,userId,loginCode);

			HashMap< String, HashMap<String,Integer >> localityMap = new HashMap< String, HashMap<String,Integer >>();

			//commented & Added by mrunalini sinkar on 17-nov-2018 for provide provision of multiple locality to customer(start)
			/*String placesql= "SELECT SC.LOCALITY_CODE LOCALITY_CODE,SC.CUST_TYPE, COUNT(*) as COUNT " +
					" FROM STRG_CUSTOMER SC,  LOCALITY L ,STRG_CUST_TYPE ST, STRG_SERIES SS LEFT OUTER JOIN SPECIALITY SP ON SP.SPL_CODE = SS.SPL_CODE " +
					"WHERE SS.SC_CODE = SC.SC_CODE " +
					"AND SC.LOCALITY_CODE = L.LOCALITY_CODE " +
					"AND SS.SALES_PERS = ? AND SS.SC_CODE IN " +
					"(SELECT SC_CODE FROM STRG_STATUS_HIST WHERE STATUS = 'Y'" +
					"AND EFF_FROM <= ? " +
					"AND VALID_UPTO >= ? " +
					"AND SALES_PERS = SS.SALES_PERS AND SC_CODE = SC.SC_CODE ) " +
					"AND SS.STATUS IN('Y','A') AND SC.CUST_TYPE = ST.TYPE " +
					"group by SC.LOCALITY_CODE,SC.CUST_TYPE " +
					"order by SC.LOCALITY_CODE,SC.CUST_TYPE";*/
			//commented & Added by mrunalini sinkar on 03-Dec-2018 for dcr_group condtion(start)
			//commented & Added by mrunalini sinkar on 17-nov-2018 for provide provision of multiple locality to customer(end)
			/*String placesql= "SELECT L.LOCALITY_CODE LOCALITY_CODE,SC.CUST_TYPE, COUNT(*) as COUNT " +
					" FROM STRG_CUSTOMER SC LEFT OUTER JOIN STRG_VISIT_HOURS SVH ON SC.SC_CODE=SVH.SC_CODE ,  LOCALITY L ,STRG_CUST_TYPE ST, STRG_SERIES SS LEFT OUTER JOIN SPECIALITY SP ON SP.SPL_CODE = SS.SPL_CODE " +
					"WHERE SS.SC_CODE = SC.SC_CODE " +
					"AND SS.SALES_PERS = ? AND (SC.LOCALITY_CODE = L.LOCALITY_CODE OR SC.RES_LOCALITY_CODE = L.LOCALITY_CODE OR L.LOCALITY_CODE=SVH.LOCALITY_CODE) "+
					"AND SS.SC_CODE IN "+
					"(SELECT SC_CODE FROM STRG_STATUS_HIST WHERE STATUS = 'Y'" +
					"AND EFF_FROM <= ? " +
					"AND VALID_UPTO >= ? " +
					"AND SALES_PERS = SS.SALES_PERS AND SC_CODE = SC.SC_CODE ) " +
					"AND SS.STATUS IN('Y','A') AND SC.CUST_TYPE = ST.TYPE " +
					"group by L.LOCALITY_CODE,SC.CUST_TYPE " +
					"order by L.LOCALITY_CODE,SC.CUST_TYPE";*/
			//commented & Added by mrunalini sinkar on 17-nov-2018 for provide provision of multiple locality to customer(end)
			//commented by mrunalini sinkar to get the beat wise loclaity & visit on 26-april-2019(strat)
			/*String placesql= "SELECT L.LOCALITY_CODE LOCALITY_CODE,ST.DCR_GROUP as DCR_GROUP, COUNT(*) as COUNT " +
					" FROM STRG_CUSTOMER SC LEFT OUTER JOIN STRG_VISIT_HOURS SVH ON SC.SC_CODE=SVH.SC_CODE ,  LOCALITY L ,STRG_CUST_TYPE ST, STRG_SERIES SS LEFT OUTER JOIN SPECIALITY SP ON SP.SPL_CODE = SS.SPL_CODE " +
					"WHERE SS.SC_CODE = SC.SC_CODE " +
					"AND SS.SALES_PERS = ? AND (SC.LOCALITY_CODE = L.LOCALITY_CODE OR SC.RES_LOCALITY_CODE = L.LOCALITY_CODE OR L.LOCALITY_CODE=SVH.LOCALITY_CODE) "+
					"AND SS.SC_CODE IN "+
					"(SELECT SC_CODE FROM STRG_STATUS_HIST WHERE STATUS = 'Y'" +
					"AND EFF_FROM <= ? " +
					"AND VALID_UPTO >= ? " +
					"AND SALES_PERS = SS.SALES_PERS AND SC_CODE = SC.SC_CODE ) " +
					"AND SS.STATUS IN('Y','A') AND SC.CUST_TYPE = ST.TYPE " +
					"group by L.LOCALITY_CODE,ST.DCR_GROUP " +
					"order by L.LOCALITY_CODE,ST.DCR_GROUP";*/
			if (stockistTable.equalsIgnoreCase("SPRS_STOCKIST"))
			{
				String placesql = "SELECT SR.ROUTE_ID AS ROUTE_ID,ST.DCR_GROUP AS DCR_GROUP,COUNT(*) AS COUNT FROM STRG_CUSTOMER SC LEFT OUTER JOIN STRG_VISIT_HOURS SVH "+
						"ON SC.SC_CODE=SVH.SC_CODE,  SPRS_ROUTE SR,LOCALITY L,STRG_CUST_TYPE ST, STRG_SERIES SS "+
						"LEFT OUTER JOIN SPECIALITY SP ON SP.SPL_CODE = SS.SPL_CODE  WHERE SS.SC_CODE = SC.SC_CODE  AND SS.SALES_PERS=SR.SPRS_CODE "+
						"AND SS.ROUTE_ID=SR.ROUTE_ID  AND L.LOCALITY_CODE=SR.LOCALITY_CODE "+
						"AND (SC.LOCALITY_CODE = SR.LOCALITY_CODE OR SC.RES_LOCALITY_CODE = SR.LOCALITY_CODE OR SR.LOCALITY_CODE=SVH.LOCALITY_CODE) "+
						/*"AND SS.SC_CODE IN  (SELECT SC_CODE FROM STRG_STATUS_HIST WHERE STATUS = 'Y' AND EFF_FROM <= ? AND VALID_UPTO >= ? AND SALES_PERS = SS.SALES_PERS AND SC_CODE = SC.SC_CODE ) "+*/
						statusHistCondition+" "+
						"AND SS.SALES_PERS = ?  AND SS.STATUS IN('Y','A') AND SC.CUST_TYPE = ST.TYPE "+
						"AND SR.STATUS = 'Y' AND SC.CUST_TYPE NOT IN (SELECT TYPE FROM STRG_CUST_TYPE WHERE DCR_GROUP = 'S') GROUP BY SR.ROUTE_ID,ST.DCR_GROUP "+
						"UNION ALL "+
						"SELECT SR.ROUTE_ID,ST.DCR_GROUP AS DCR_GROUP,COUNT(*) AS COUNT FROM CUSTOMER CUST LEFT OUTER JOIN STRG_VISIT_HOURS SVH "+
						"ON CUST.CUST_CODE = SVH.SC_CODE, SPRS_ROUTE SR, LOCALITY L, STRG_CUST_TYPE ST, SPRS_STOCKIST SS "+
						"WHERE SS.CUST_CODE = CUST.CUST_CODE  AND SS.SPRS_CODE = SR.SPRS_CODE AND SS.ROUTE_ID = SR.ROUTE_ID  AND L.LOCALITY_CODE = SR.LOCALITY_CODE "+
						"AND (CUST.LOCALITY_CODE = SR.LOCALITY_CODE OR SR.LOCALITY_CODE = SVH.LOCALITY_CODE) AND SS.SPRS_CODE = ? AND SS.STATUS IN('Y','A') "+
						"AND CUST.CUST_TYPE = ST.TYPE AND SR.STATUS='Y' AND CUST.BLACK_LISTED <> 'Y' AND CUST.CUST_TYPE IN (SELECT TYPE FROM STRG_CUST_TYPE WHERE DCR_GROUP = 'S') "+
						"GROUP BY SR.ROUTE_ID,ST.DCR_GROUP ORDER BY ROUTE_ID,DCR_GROUP ";
				pstmt =  connectionObject.prepareStatement( placesql );
				if("Y".equalsIgnoreCase(statusHistConfig))
				{
					pstmt.setTimestamp( 1, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( trvDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
					pstmt.setTimestamp( 2, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( trvDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
					pstmt.setString(3, sprsCode);
					pstmt.setString(4, sprsCode);

				}
				else
				{
					pstmt.setString(1, sprsCode);
					pstmt.setString(2, sprsCode);

				}
			}
			else
			{
				String placesql= "SELECT SR.ROUTE_ID,ST.DCR_GROUP AS DCR_GROUP,COUNT(*) AS COUNT FROM STRG_CUSTOMER SC LEFT OUTER JOIN STRG_VISIT_HOURS SVH ON SC.SC_CODE=SVH.SC_CODE, " +
						" SPRS_ROUTE SR,LOCALITY L,STRG_CUST_TYPE ST, STRG_SERIES SS LEFT OUTER JOIN SPECIALITY SP ON SP.SPL_CODE = SS.SPL_CODE " +
						" WHERE SS.SC_CODE = SC.SC_CODE " +
						" AND SS.SALES_PERS=SR.SPRS_CODE AND SS.ROUTE_ID=SR.ROUTE_ID " +
						" AND L.LOCALITY_CODE=SR.LOCALITY_CODE " +
						" AND (SC.LOCALITY_CODE = SR.LOCALITY_CODE OR SC.RES_LOCALITY_CODE =SR.LOCALITY_CODE OR SR.LOCALITY_CODE=SVH.LOCALITY_CODE) " +
						/*" AND SS.SC_CODE IN " +
						" (SELECT SC_CODE FROM STRG_STATUS_HIST WHERE STATUS = 'Y' " +
						" AND EFF_FROM <= ? " +
						" AND VALID_UPTO >= ? " +
						" AND SALES_PERS = SS.SALES_PERS AND SC_CODE = SC.SC_CODE ) " + */
						statusHistCondition+" "+
						" AND SS.SALES_PERS = ? " +
						" AND SS.STATUS IN('Y','A') AND SC.CUST_TYPE = ST.TYPE AND SR.STATUS='Y'" +
						" GROUP BY SR.ROUTE_ID,ST.DCR_GROUP " +
						" ORDER BY SR.ROUTE_ID,ST.DCR_GROUP";
				//commented by mrunalini sinkar to get the beat wise loclaity & visit on 26-april-2019(end)
				//commented & Added by mrunalini sinkar on 17-nov-2018 for provide provision of multiple locality to customer(end)
				//commented & Added by mrunalini sinkar on 03-Dec-2018 for dcr_group condtion(end)
				pstmt =  connectionObject.prepareStatement( placesql );

				//pstmt.setTimestamp( 2, java.sql.Timestamp.valueOf( trvDate ) );
				//pstmt.setTimestamp( 3, java.sql.Timestamp.valueOf( trvDate ) );
				if("Y".equalsIgnoreCase(statusHistConfig))
				{
					pstmt.setTimestamp( 1, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( trvDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
					pstmt.setTimestamp( 2, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( trvDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
					pstmt.setString(3, sprsCode);
				}
				else
				{
					pstmt.setString(1, sprsCode);
				}
			}

			ResultSet rsPlace = pstmt.executeQuery();
			while(rsPlace.next())
			{
				//localityCode = checkNull(rsPlace.getString("LOCALITY_CODE"));//commented by mrunalini sinkar to get the beat wise loclaity & visit on 26-april-2019
				localityCode = checkNull(rsPlace.getString("ROUTE_ID"));
				custType= checkNull(rsPlace.getString("DCR_GROUP"));
				count= rsPlace.getInt("COUNT");

				if(localityMap != null && localityMap.containsKey(localityCode))
				{
					HashMap<String,Integer> hashmap=(HashMap)localityMap.get(localityCode);
					hashmap.put(custType,count);
					localityMap.put(localityCode, hashmap);
				}
				else
				{
					HashMap<String,Integer> custTypemap=new HashMap<String,Integer>();
					custTypemap.put(custType,count);
					localityMap.put(localityCode,custTypemap);
				}
			}

			if (rsPlace != null)
			{
				rsPlace.close();
				rsPlace = null;
			}
			if (pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			//Ended by Rushikesh More On 20-03-17 for visibility of visit of doctor and retailer in specific locality

			String lineCount = "";
			String sfaParmData  = getSfaParmValue(userId,"IS_PLAN_COMPULSORY",connectionObject); //Chnaged by sachin satre on 11-nov-16
			HashMap<String,String> planmap = new HashMap<String,String>();
			HashMap<String, ArrayList<String>> custTypeMap = new HashMap<String, ArrayList<String>>();
			if(sfaParmData.equalsIgnoreCase("Y") && !"E".equalsIgnoreCase(modeReport) && !flag && copyPlan.equalsIgnoreCase("Y"))
			{
				String workDate = checkNull(getSelectedRowValue(dom2, "1", "event_date", 0));
				// added by rupali on 20/09/17 for not displaying locality as selected in which customer is not selected in case of report from plan [start]
				ArrayList custList = new ArrayList();
				String planCustSql = "SELECT CUST.LOCALITY_CODE AS LOCALITY_CODE, HDR.SPRS_CODE__PLAN AS  SPRS_CODE,CUST.ROUTE_ID "+
						"FROM SPRS_PLAN_HDR HDR,SPRS_PLAN_CUST CUST,locality loc WHERE HDR.PLAN_DATE= ? "+
						"AND HDR.SPRS_CODE__PLAN= ? AND HDR.PLAN_ID = CUST.PLAN_ID AND TRIM(CUST.LOCALITY_CODE) = TRIM(LOC.LOCALITY_CODE)";
				pstmt = connectionObject.prepareStatement(planCustSql);
				pstmt.setTimestamp( 1, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( workDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
				pstmt.setString(2,userId);
				rs = pstmt.executeQuery();
				while(rs.next())
				{
					//custList.add(rs.getString("locality_code").trim()); //commenetd by mrunalini sinakr for beat description changes 06-05-2019
					custList.add(checkNull(rs.getString("ROUTE_ID")));//added by mrunalini sinakr for beat description changes 06-05-2019
				}
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				// added by rupali on 20/09/17 for not displaying locality as selected in which customer is not selected in case of report from plan [end]

				String planSql = " SELECT PLACE.LOCALITY_CODE AS LOCALITY_CODE,LOC.DESCR AS DESCR,PLACE.ROUTE_ID AS ROUTE_ID," +
						" LOC.LOCALITY_TYPE AS LOCALITY_TYPE, HDR.SPRS_CODE__PLAN AS  SPRS_CODE,PLACE.ORDER_OF_VISIT AS ORDER_OF_VISIT" +
						" FROM SPRS_PLAN_HDR HDR,SPRS_PLAN_PLACE PLACE,locality loc "+
						" WHERE HDR.PLAN_DATE= ? AND HDR.SPRS_CODE__PLAN= ? AND HDR.PLAN_ID = PLACE.PLAN_ID AND  PLACE.LOCALITY_CODE = LOC.LOCALITY_CODE";
				pstmt = connectionObject.prepareStatement(planSql);
				pstmt.setTimestamp( 1, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( workDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
				pstmt.setString(2,userId);
				rs = pstmt.executeQuery();
				while(rs.next())
				{
					//	planmap.put(rs.getString("LOCALITY_CODE").trim(), rs.getString("ORDER_OF_VISIT").trim());
					// added by rupali on 20/09/17 for not displaying locality as selected in which customer is not selected in case of report from plan [start]
					//commenetd & added by mrunalini sinakr for beat description changes 06-05-2019(start)
					/*if(custList.contains(rs.getString("LOCALITY_CODE").trim()))
					{
						planmap.put(rs.getString("LOCALITY_CODE").trim(), rs.getString("ORDER_OF_VISIT").trim());
					}*/
					String route=checkNull(rs.getString("ROUTE_ID"));
					//System.out.println("route is:["+route+"]");
					if(route==null || route.trim().length()==0)
					{
						//System.out.println("if route is blank is:["+rs.getString("LOCALITY_CODE")+"]");
						planmap.put(checkNull(rs.getString("LOCALITY_CODE")), checkNull(rs.getString("ORDER_OF_VISIT")));


					}
					else
					{
						//System.out.println("if route is not blank is:["+route+"]");

						planmap.put(checkNull(rs.getString("ROUTE_ID")), checkNull(rs.getString("ORDER_OF_VISIT")));


					}
					//System.out.println("if planmap is:["+planmap+"]");

					//commenetd & added  by mrunalini sinakr for beat description changes 06-05-2019(end)

					// added by rupali on 20/09/17 for not displaying locality as selected in which customer is not selected in case of report from plan [end]

				}
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				//System.out.println("planmap : "+planmap.toString());
			}

			if( flag )
			{
				preFormDet = getPrevFormLocValues( dom, currentForm, temp , "sales_pers", modeReport,stockistTable,connectionObject );
				//System.out.println("preFormDet:::"+preFormDet);
				if( preFormDet != null || !"null".equalsIgnoreCase( preFormDet ))
				{
					locality = getLocFromDom( genericUtility.parseString("<Root>"+preFormDet+"</Root>"), currentForm, sprsCode,connectionObject ); //Chnaged by sachin satre on 11-nov-16
					selRouteId = getRouteIdFromDom( genericUtility.parseString("<Root>"+preFormDet+"</Root>"), currentForm, sprsCode,connectionObject ); //add by mrunalini sinkar to add the beat description,route_id in DAR 25-04-2019
					//System.out.println("locality:::::::["+locality+"]");
					//System.out.println("preFormDet:::::::["+preFormDet+"]");
					valueXmlString.append( preFormDet );
				}
			}
			else
			{
				//commented & add by mrunalini sinkar to add the beat description,route_id in DAR 25-04-2019(start)
				/*	sqlEdit = "SELECT ST.*, SR.DESCR DESCR, loc.latitude latitude, loc.longitude longitude FROM SPRS_TRAVEL ST, SPRS_ROUTE SR, locality loc WHERE ST.SALES_PERS = SR.SPRS_CODE AND ST.LOCALITY_CODE = SR.LOCALITY_CODE and SR.LOCALITY_CODE = loc.locality_code AND SR.STATUS = 'Y' AND ST.SALES_PERS = ? AND ST.TRAVEL_DATE = ? "+
						"AND ACTIVITY_CODE IN (SELECT ACTIVITY_CODE FROM FIELDACTIVITY WHERE ACTIVITY_TYPE !='PR') ORDER BY ORDER_OF_VISIT, DESCR"; // added by condition rupali on 14/03/17 for separate pr menu*/
				//commented & add by mrunalini sinkar to showing travel mode description on summary paeg in DAR 05-10-2019(start)
				/*sqlEdit = "SELECT ST.*, (CASE WHEN SR.ROUTE_DESCR IS NOT NULL THEN SR.ROUTE_DESCR ELSE SR.DESCR END ) DESCR, LOC.LATITUDE LATITUDE, LOC.LONGITUDE LONGITUDE,S.DESCR AS STATION_DESCR,SR.ROUTE_TYPE FROM SPRS_TRAVEL ST, SPRS_ROUTE SR, LOCALITY LOC,STATION S  WHERE ST.SALES_PERS = SR.SPRS_CODE AND ST.LOCALITY_CODE = SR.LOCALITY_CODE AND SR.LOCALITY_CODE = LOC.LOCALITY_CODE AND SR.STATUS = 'Y'  AND S.STAN_CODE=ST.STAN_CODE AND SR.STAN_CODE=ST.STAN_CODE AND ST.SALES_PERS = ? AND ST.TRAVEL_DATE = ? "+
						"AND SR.ROUTE_ID=ST.ROUTE_ID AND ACTIVITY_CODE IN (SELECT ACTIVITY_CODE FROM FIELDACTIVITY WHERE ACTIVITY_TYPE !='PR') ORDER BY ORDER_OF_VISIT, DESCR";*/
				sqlEdit = "SELECT ST.*, (CASE WHEN SR.ROUTE_DESCR IS NOT NULL THEN SR.ROUTE_DESCR ELSE SR.DESCR END ) DESCR, LOC.LATITUDE LATITUDE, LOC.LONGITUDE LONGITUDE,S.DESCR AS STATION_DESCR,SR.ROUTE_TYPE,TM.TRAVEL_MODE_DESCR FROM SPRS_TRAVEL ST LEFT OUTER JOIN TRAVEL_MODE_MASTER TM ON ST.TRAVEL_MODE=TM.TRAVEL_MODE_ID, SPRS_ROUTE SR, LOCALITY LOC,STATION S  WHERE ST.SALES_PERS = SR.SPRS_CODE AND ST.LOCALITY_CODE = SR.LOCALITY_CODE AND SR.LOCALITY_CODE = LOC.LOCALITY_CODE AND SR.STATUS = 'Y'  AND S.STAN_CODE=ST.STAN_CODE AND SR.STAN_CODE=ST.STAN_CODE AND ST.SALES_PERS = ? AND ST.TRAVEL_DATE = ? "+
						"AND SR.ROUTE_ID=ST.ROUTE_ID AND ACTIVITY_CODE IN (SELECT ACTIVITY_CODE FROM FIELDACTIVITY WHERE ACTIVITY_TYPE !='PR') ORDER BY ORDER_OF_VISIT, DESCR";
				//commented & add by mrunalini sinkar to showing travel mode description on summary paeg in DAR 05-10-2019(END)
				//commented & add by mrunalini sinkar to add the beat description,route_id in DAR 25-04-2019(end)

				if( rowsRS > 0 )
				{
					modeReport = "E";
					pstmt =  connectionObject.prepareStatement( sqlEdit );
					pstmt.setString(1, sprsCode);
					pstmt.setTimestamp( 2, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( trvDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );

					rs = pstmt.executeQuery();

					while(rs.next())
					{
						count++;
						String drVisit = checkNull(rs.getString("dr_visit"));
						String chemVisit = checkNull(rs.getString("chem_visit"));
						String stockistVisit = checkNull(rs.getString("stockist_visit"));
						String ncwVisit = checkNull(rs.getString("other_visit"));
						String travelModeDescr= checkNull(rs.getString("TRAVEL_MODE_DESCR"));
						String lat = checkNull(rs.getString("LATITUDE"));
						String lon = checkNull(rs.getString("LONGITUDE"));
						String latLong = "";
						//if(lat != null && lon != null) // commented by rupali on 18/10/17 for display proper place map data in edit mode
						if(lat.trim().length() != 0 && lon.trim().length() != 0) // added by rupali on 18/10/17 for display proper place map data in edit mode
						{
							latLong = lat.trim() + "," + lon.trim();
						}

						String isDrExist = "N";
						String isChemExist = "N";
						String isStockExist = "N";
						String isNCWExist = "N";
						String routeId = checkNull(rs.getString("ROUTE_ID"));
						HashMap<String, Integer> cusTypeMap = null;
						if(localityMap.containsKey(routeId))
						{
							cusTypeMap =(HashMap)localityMap.get(routeId);
						}
						//System.out.println("cusTypeMap::::"+cusTypeMap);
						if(cusTypeMap != null && !cusTypeMap.isEmpty())
						{
							Iterator itrt= cusTypeMap.entrySet().iterator();
							while(itrt.hasNext())
							{
								Map.Entry en = (Map.Entry) itrt.next();
								cusType =   (String) en.getKey();
								cnt= (Integer) en.getValue();

								if ("D".equalsIgnoreCase(cusType))
								{
									if(cnt > 0)
									{
										isDrExist = "Y";
									}
									else
									{
										isDrExist = "N";
									}
								}
								else if ("C".equalsIgnoreCase(cusType))
								{
									if(cnt > 0)
									{
										isChemExist = "Y";
									}
									else
									{
										isChemExist = "N";
									}
								}
								else if ("S".equalsIgnoreCase(cusType))
								{
									if(cnt > 0)
									{
										isStockExist = "Y";
									}
									else
									{
										isStockExist = "N";
									}
								}
								else if ("O".equalsIgnoreCase(cusType))
								{
									if(cnt > 0)
									{
										isNCWExist = "Y";
									}
									else
									{
										isNCWExist = "N";
									}
								}
							}
						}

						//lineCount = planmap.get(rs.getString("LOCALITY_CODE").trim());//commenetd by mrunalini sinakr for beat description changes 06-05-2019
						lineCount = planmap.get(checkNull(rs.getString("ROUTE_ID")));//added by mrunalini sinakr for beat description changes 06-05-2019
						if(lineCount==null || lineCount.trim().length()==0)
						{
							lineCount = planmap.get(checkNull(rs.getString("LOCALITY_CODE")));//added by mrunalini sinakr for beat description changes 06-05-2019

						}
						String locCode = checkNull(rs.getString("LOCALITY_CODE"));
						valueXmlString.append( "<Detail"+currentForm+" domID='"+ domID +"' selected = 'Y' formName='"+formName+"'>\r\n" );
						valueXmlString.append( "<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\"/>\r\n");
						valueXmlString.append("<add_locality_code visible='0'><![CDATA[" ).append("").append( "]]></add_locality_code>\r\n" );
						valueXmlString.append( "<order_of_visit><![CDATA[" ).append(checkNull(rs.getString("ORDER_OF_VISIT"))).append( "]]></order_of_visit>\r\n" );
						valueXmlString.append( "<locality_code><![CDATA[" ).append(checkNull(rs.getString("LOCALITY_CODE"))).append( "]]></locality_code>\r\n" );
						valueXmlString.append( "<sprs_route_descr><![CDATA[" ).append(checkNull(rs.getString("DESCR"))).append( "]]></sprs_route_descr>\r\n" );
						valueXmlString.append( "<stan_code><![CDATA[" ).append(checkNull(rs.getString("STAN_CODE"))).append( "]]></stan_code>\r\n" );
						valueXmlString.append( "<travel_mode><![CDATA[" ).append(checkNull(rs.getString("TRAVEL_MODE"))).append( "]]></travel_mode>\r\n" );
						valueXmlString.append( "<over_night><![CDATA[" ).append(checkNull(rs.getString("OVER_NIGHT"))).append( "]]></over_night>\r\n" );
						valueXmlString.append( "<sales_pers><![CDATA[" ).append(checkNull(sprsCode)).append( "]]></sales_pers>\r\n" );
						valueXmlString.append( "<travel_date><![CDATA[" ).append(trvDate).append( "]]></travel_date>\r\n" );
						valueXmlString.append( "<activity_code><![CDATA[" ).append(checkNull(actCode)).append( "]]></activity_code>\r\n" );
						valueXmlString.append( "<chg_date><![CDATA[" ).append(currDate).append( "]]></chg_date>\r\n" );
						valueXmlString.append( "<chg_user><![CDATA[" ).append(userId).append( "]]></chg_user>\r\n" );
						valueXmlString.append( "<chg_term><![CDATA[" ).append(chgTerm).append( "]]></chg_term>\r\n" );
						valueXmlString.append( "<oth_participant><![CDATA[" ).append("").append( "]]></oth_participant>\r\n" );
						valueXmlString.append( "<plan_id><![CDATA[" ).append("").append( "]]></plan_id>\r\n" );
						valueXmlString.append( "<stan_code__from><![CDATA[" ).append(checkNull(rs.getString("STAN_CODE__FROM"))).append( "]]></stan_code__from>\r\n" );
						valueXmlString.append( "<sprs_code__ww><![CDATA[" ).append("").append( "]]></sprs_code__ww>\r\n" );
						valueXmlString.append( "<sales_team><![CDATA[" ).append("").append( "]]></sales_team>\r\n" );
						valueXmlString.append( "<template_file><![CDATA[" ).append("").append( "]]></template_file>\r\n" );
						valueXmlString.append( "<locality_code_from><![CDATA[" ).append(checkNull(rs.getString("LOCALITY_CODE_FROM"))).append( "]]></locality_code_from>\r\n" );
						valueXmlString.append( "<dcr_id><![CDATA[" ).append(checkNull(rs.getString("DCR_ID"))).append( "]]></dcr_id>\r\n" );
						valueXmlString.append( "<tran_id><![CDATA[" ).append(checkNull(rs.getString("TRAN_ID"))).append( "]]></tran_id>\r\n" );
						valueXmlString.append( "<line_no><![CDATA[" ).append(checkNull(rs.getString("LINE_NO"))).append( "]]></line_no>\r\n" );
						valueXmlString.append( "<to_disable><![CDATA[" ).append("Y").append( "]]></to_disable>\r\n" );
						/*valueXmlString.append( "<dr_visit protect='1'><![CDATA[" ).append(checkNull(rs.getString("dr_visit"))).append( "]]></dr_visit>\r\n" );
						valueXmlString.append( "<chem_visit protect='1'><![CDATA[" ).append(checkNull(rs.getString("chem_visit"))).append( "]]></chem_visit>\r\n" );
						valueXmlString.append( "<stockist_visit protect='1'><![CDATA[" ).append(checkNull(rs.getString("stockist_visit"))).append( "]]></stockist_visit>\r\n" );
						valueXmlString.append( "<other_visit protect='1'><![CDATA[" ).append(checkNull(rs.getString("other_visit"))).append( "]]></other_visit>\r\n" );*/

						if("2".equals(allowEditPlace))
						{
							valueXmlString.append( "<dr_visit protect='1'><![CDATA[" ).append(checkNull(rs.getString("dr_visit"))).append( "]]></dr_visit>\r\n" );
							valueXmlString.append( "<chem_visit protect='1'><![CDATA[" ).append(checkNull(rs.getString("chem_visit"))).append( "]]></chem_visit>\r\n" );
							valueXmlString.append( "<stockist_visit protect='1'><![CDATA[" ).append(checkNull(rs.getString("stockist_visit"))).append( "]]></stockist_visit>\r\n" );
							valueXmlString.append( "<other_visit protect='1'><![CDATA[" ).append(checkNull(rs.getString("other_visit"))).append( "]]></other_visit>\r\n" );
						}
						else
						{
							if(isDrExist.equalsIgnoreCase("N"))
							{
								valueXmlString.append( "<dr_visit protect='1'><![CDATA[" ).append(checkNull(rs.getString("dr_visit"))).append( "]]></dr_visit>\r\n" );
							}
							else
							{
								valueXmlString.append( "<dr_visit><![CDATA[" ).append(checkNull(rs.getString("dr_visit"))).append( "]]></dr_visit>\r\n" );
							}
							if(isChemExist.equalsIgnoreCase("N"))
							{
								valueXmlString.append( "<chem_visit protect='1'><![CDATA[" ).append(checkNull(rs.getString("chem_visit"))).append( "]]></chem_visit>\r\n" );
							}
							else
							{
								valueXmlString.append( "<chem_visit><![CDATA[" ).append(checkNull(rs.getString("chem_visit"))).append( "]]></chem_visit>\r\n" );
							}
							if(isStockExist.equalsIgnoreCase("N"))
							{
								valueXmlString.append( "<stockist_visit protect='1'><![CDATA[" ).append(checkNull(rs.getString("stockist_visit"))).append( "]]></stockist_visit>\r\n" );
							}
							else
							{
								valueXmlString.append( "<stockist_visit><![CDATA[" ).append(checkNull(rs.getString("stockist_visit"))).append( "]]></stockist_visit>\r\n" );
							}
							if(isNCWExist.equalsIgnoreCase("N"))
							{
								valueXmlString.append( "<other_visit protect='1'><![CDATA[" ).append(checkNull(rs.getString("other_visit"))).append( "]]></other_visit>\r\n" );
							}
							else
							{
								valueXmlString.append( "<other_visit><![CDATA[" ).append(checkNull(rs.getString("other_visit"))).append( "]]></other_visit>\r\n" );
							}
						}
						//Added by mrunalini sinkar for dispaly metadata
						if("Y".equalsIgnoreCase(drVisit))
						{
							valueXmlString.append("<dr_visit_display><![CDATA[" ).append( "Yes" ).append( "]]></dr_visit_display>\r\n" );
						}
						else
						{
							valueXmlString.append("<dr_visit_display><![CDATA[" ).append( "No" ).append( "]]></dr_visit_display>\r\n" );
						}
						if("Y".equalsIgnoreCase(chemVisit))
						{
							valueXmlString.append("<chem_visit_display><![CDATA[" ).append( "Yes" ).append( "]]></chem_visit_display>\r\n" );
						}
						else
						{
							valueXmlString.append("<chem_visit_display><![CDATA[" ).append( "No" ).append( "]]></chem_visit_display>\r\n" );
						}
						if("Y".equalsIgnoreCase(stockistVisit))
						{
							valueXmlString.append("<stockist_visit_display><![CDATA[" ).append( "Yes" ).append( "]]></stockist_visit_display>\r\n" );
						}
						else
						{
							valueXmlString.append("<stockist_visit_display><![CDATA[" ).append( "No" ).append( "]]></stockist_visit_display>\r\n" );
						}
						if("Y".equalsIgnoreCase(ncwVisit))
						{
							valueXmlString.append("<other_visit_display><![CDATA[" ).append( "Yes" ).append( "]]></other_visit_display>\r\n" );
						}
						else
						{
							valueXmlString.append("<other_visit_display><![CDATA[" ).append( "No" ).append( "]]></other_visit_display>\r\n" );
						}

						//Added by mrunalini sinkar for dispaly metadata
						valueXmlString.append( "<station_type><![CDATA[" ).append(checkNull(rs.getString("STATION_TYPE"))).append( "]]></station_type>\r\n" );// added STATION_TYPE by mrunalini sinkar for sun migration changes on 10-04-2019
						valueXmlString.append( "<route_id><![CDATA[" ).append(checkNull(rs.getString("ROUTE_ID"))).append( "]]></route_id>\r\n" );//add by mrunalini sinkar to add the beat description,route_id in DAR 25-04-2019
						valueXmlString.append( "<route_id_from><![CDATA[" ).append(checkNull(rs.getString("ROUTE_ID_FROM"))).append( "]]></route_id_from>\r\n" );
						valueXmlString.append( "<station_descr><![CDATA[" ).append(checkNull(rs.getString("STATION_DESCR"))).append( "]]></station_descr>\r\n" );// added station_descr by mrunalini sinkar for showing on summary page description on 20-05-2019
						valueXmlString.append( "<route_type><![CDATA[" ).append(checkNull(rs.getString("ROUTE_TYPE"))).append( "]]></route_type>\r\n" );// added ROUTE_TYPE by mrunalini sinkar for sun migration changes on 23-05-2019
						valueXmlString.append( "<dcr_mode><![CDATA[" ).append( "EDIT REPORT" ).append( "]]></dcr_mode>\r\n" );//added by hariom 19-oct-19


						if(custTypeList != null && !custTypeList.isEmpty())
						{
							String custTypeMst = "";
							int custTypeSelCnt = 0;
							for(int i = 0; i<custTypeList.size(); i++)
							{
								custTypeMst = (String)custTypeList.get(i);
								if("D".equalsIgnoreCase(custTypeMst) && "Y".equalsIgnoreCase(drVisit))
								{
									custTypeSelCnt++;
								}
								else if("C".equalsIgnoreCase(custTypeMst) && "Y".equalsIgnoreCase(chemVisit))
								{
									custTypeSelCnt++;
								}
								else if("S".equalsIgnoreCase(custTypeMst) && "Y".equalsIgnoreCase(stockistVisit))
								{
									custTypeSelCnt++;
								}
								else if("O".equalsIgnoreCase(custTypeMst) && "Y".equalsIgnoreCase(ncwVisit))
								{
									custTypeSelCnt++;
								}
							}
							if(custTypeSelCnt == custTypeList.size())
							{
								//valueXmlString.append( "<cust_visit_all protect='1'><![CDATA[" ).append("Y").append( "]]></cust_visit_all>\r\n" );
								if("2".equals(allowEditPlace))
								{
									valueXmlString.append( "<cust_visit_all protect='1'><![CDATA[" ).append("Y").append( "]]></cust_visit_all>\r\n" );
								}
								else
								{
									valueXmlString.append( "<cust_visit_all protect='0'><![CDATA[" ).append("Y").append( "]]></cust_visit_all>\r\n" );
								}
							}
							else
							{
								valueXmlString.append( "<cust_visit_all protect='1'><![CDATA[" ).append("N").append( "]]></cust_visit_all>\r\n" );
							}
						}

						valueXmlString.append( "<last_place_of_return><![CDATA[" ).append( placeOfReturnStr ).append( "]]></last_place_of_return>\r\n" );
						valueXmlString.append( "<last_place_of_descr_return><![CDATA[" ).append(placeOfReturnDescr).append( "]]></last_place_of_descr_return>\r\n" );
						valueXmlString.append( "<stan_code__fr><![CDATA[" ).append("").append( "]]></stan_code__fr>\r\n" );
						valueXmlString.append( "<stan_code__to><![CDATA[" ).append("").append( "]]></stan_code__to>\r\n" );
						//valueXmlString.append( "<add_geopos><![CDATA[" ).append(checkNull(rs.getString("ADD_GEOPOS"))).append( "]]></add_geopos>\r\n" );
						valueXmlString.append( "<add_geopos><![CDATA[" ).append(latLong).append( "]]></add_geopos>\r\n" );
						valueXmlString.append( "<chg_geopos><![CDATA[" ).append("").append( "]]></chg_geopos>\r\n" );
						valueXmlString.append( "<geopos_accuracy><![CDATA[" ).append("").append( "]]></geopos_accuracy>\r\n" ); //changes made by rupali on 20/07/18 for adding geopos_accuracy tag
						valueXmlString.append("<travel_mode_descr><![CDATA[" ).append(travelModeDescr).append( "]]></travel_mode_descr>\r\n" );//Added by mrunalni sinkar on 05-10-2019 to show travel mode description
						valueXmlString.append( "<allow_edit_place><![CDATA[" ).append(allowEditPlace).append( "]]></allow_edit_place>\r\n" );

						valueXmlString.append( "<is_place_fortune_act><![CDATA[" ).append(isFortune).append( "]]></is_place_fortune_act>\r\n" );
						valueXmlString.append( "<is_button_disable><![CDATA[" ).append(isButtonDisable).append( "]]></is_button_disable>\r\n" );

						valueXmlString.append( "</Detail"+currentForm+">\r\n" );
						domID ++;
					}
					if (rs!= null)
					{
						rs.close();
						rs = null;
					}
					if(pstmt!=null)
					{
						pstmt.close();
						pstmt = null;
					}
					locality = getLocFromDom(genericUtility.parseString("<Root>"+valueXmlString.toString()+"</Root>"), currentForm, sprsCode,connectionObject); //Chnaged by sachin satre on 11-nov-16
					selRouteId = getRouteIdFromDom(genericUtility.parseString("<Root>"+valueXmlString.toString()+"</Root>"), currentForm, sprsCode,connectionObject ); //add by mrunalini sinkar to add the beat description,route_id in DAR 25-04-2019

				}
			}



			if( locality != null && locality.length() == 0 )
			{
				locality = "'x'";
			}
			//add by mrunalini sinkar to add the beat description,route_id in DAR 25-04-2019(start)

			if( selRouteId != null && selRouteId.length() == 0 )
			{
				selRouteId = "'x'";
			}
			ArrayList<String> planLocality = new ArrayList<String>();
			// added by mrunalini sinkar on 20-may for station description chages(start)
			//add by mrunalini sinkar to add the beat description,route_id in DAR 25-04-2019(start)
			// added STATION_TYPE by mrunalini sinkar for sun migration changes on 10-04-2019
			//commented & add by mrunalini sinkar to add the beat description,route_id in DAR 25-04-2019(start)
            //sql = "SELECT SR.LOCALITY_CODE LOCALITY_CODE, SR.DESCR DESCR, SR.STAN_CODE STAN_CODE ,LOC.LATITUDE LATITUDE ,LOC.LONGITUDE LONGITUDE,SR.STATION_TYPE FROM SPRS_ROUTE SR, LOCALITY LOC WHERE SR.LOCALITY_CODE = LOC.LOCALITY_CODE AND SR.SPRS_CODE = ? AND SR.STATUS='Y' AND SR.LOCALITY_CODE NOT IN ("+locality+") ";
            // Commented and Added by Pankaj R on 15-JUL-21 to set the route by default as selected if plan_days is defined in sprs_route for that route [START]
            //sql = "SELECT SR.LOCALITY_CODE LOCALITY_CODE, (CASE WHEN SR.ROUTE_DESCR IS NOT NULL THEN SR.ROUTE_DESCR ELSE SR.DESCR END) DESCR, SR.STAN_CODE STAN_CODE ,LOC.LATITUDE LATITUDE ,LOC.LONGITUDE LONGITUDE,SR.STATION_TYPE,SR.ROUTE_ID AS ROUTE_ID,S.DESCR AS STATION_DESCR,SR.ROUTE_TYPE FROM SPRS_ROUTE SR, LOCALITY LOC,STATION S WHERE SR.LOCALITY_CODE = LOC.LOCALITY_CODE AND SR.SPRS_CODE = ? AND SR.STATUS='Y' AND SR.STAN_CODE=S.STAN_CODE AND SR.ROUTE_ID NOT IN ("+selRouteId+") ORDER BY DESCR ";
            int defCount = planmap.size();
            System.out.println("defCouunt : "+defCount);
            sql = "SELECT '2' as SR_NO, SR.LOCALITY_CODE LOCALITY_CODE, (CASE WHEN SR.ROUTE_DESCR IS NOT NULL THEN SR.ROUTE_DESCR ELSE SR.DESCR END) DESCR, SR.STAN_CODE STAN_CODE ,LOC.LATITUDE LATITUDE ,LOC.LONGITUDE LONGITUDE,SR.STATION_TYPE,SR.ROUTE_ID AS ROUTE_ID,S.DESCR AS STATION_DESCR,SR.ROUTE_TYPE,SR.PLAN_DAYS FROM SPRS_ROUTE SR, LOCALITY LOC,STATION S WHERE SR.LOCALITY_CODE = LOC.LOCALITY_CODE AND SR.SPRS_CODE = ? AND SR.STATUS='Y' AND SR.STAN_CODE=S.STAN_CODE AND SR.ROUTE_ID NOT IN ("+selRouteId+") and (SR.PLAN_DAYS is null OR SR.PLAN_DAYS NOT LIKE '%"+weekDayString+"%' ) UNION ALL SELECT '1' as SR_NO, SR.LOCALITY_CODE LOCALITY_CODE, (CASE WHEN SR.ROUTE_DESCR IS NOT NULL THEN SR.ROUTE_DESCR ELSE SR.DESCR END) DESCR, SR.STAN_CODE STAN_CODE ,LOC.LATITUDE LATITUDE ,LOC.LONGITUDE LONGITUDE,SR.STATION_TYPE,SR.ROUTE_ID AS ROUTE_ID,S.DESCR AS STATION_DESCR,SR.ROUTE_TYPE,SR.PLAN_DAYS FROM SPRS_ROUTE SR, LOCALITY LOC,STATION S WHERE SR.LOCALITY_CODE = LOC.LOCALITY_CODE AND SR.SPRS_CODE = ? AND SR.STATUS='Y' AND SR.STAN_CODE=S.STAN_CODE AND SR.ROUTE_ID NOT IN ("+selRouteId+") and SR.PLAN_DAYS LIKE '%"+weekDayString+"%' ORDER BY SR_NO, DESCR ";
            // Commented and Added by Pankaj R on 15-JUL-21 to set the route by default as selected if plan_days is defined in sprs_route for that route [END]
			//commented & add by mrunalini sinkar to add the beat description in DAR 25-04-2019(end)
			pstmt =  connectionObject.prepareStatement( sql );
            pstmt.setString(1, sprsCode);
            pstmt.setString(2, sprsCode); // Commented and Added by Pankaj R on 15-JUL-21 to set the route by default as selected if plan_days is defined in sprs_route for that route [START]
			rs = pstmt.executeQuery();

			if(flag)
			{
				ArrayList<Integer> domIdList = new ArrayList<Integer>();
				domIdList  = getDomIdListFromDom( dom, "domID" , currForm);
				int maxVal = Collections.max(domIdList);
				//System.out.println("Max DonID value is:- "+maxVal);
				domID = maxVal+1;
			}
			while(rs.next())
			{
				//Added by Rushikesh More On 20-03-17 for visibility of visit of doctor and retailer in specific locality
				String isDrExist = "N";
				String isChemExist = "N";
				String isStockExist = "N";
				String isNCWExist = "N";

				String lat = rs.getString("LATITUDE");
				String lon = rs.getString("LONGITUDE");
				String latLong = "";
				if(lat != null && lon != null)
				{
					latLong = lat.trim() + "," + lon.trim();
				}
				String locCode = checkNull(rs.getString("LOCALITY_CODE"));
                String routeId=checkNull(rs.getString("ROUTE_ID"));// add by mrunalini sinkar to add the beat description in DAR 25-04-2019
                String planDays = checkNull(rs.getString("PLAN_DAYS")); // Commented and Added by Pankaj R on 15-JUL-21 to set the route by default as selected if plan_days is defined in sprs_route for that route [START]
                String srNo = checkNull(rs.getString("SR_NO"));
                //System.out.println("locCode..assad....::[" +locCode+ "]");
				HashMap<String, Integer> cusTypeMap = null;
				//if(localityMap.containsKey(locCode))
				if(localityMap.containsKey(routeId))// add by mrunalini sinkar to add the beat description in DAR 25-04-2019
				{
					//cusTypeMap =(HashMap)localityMap.get(locCode);// add by mrunalini sinkar to add the beat description in DAR 25-04-2019
					cusTypeMap =(HashMap)localityMap.get(routeId);
					//System.out.println("custypeMap........::"+cusTypeMap);

				}
				if(cusTypeMap != null && !cusTypeMap.isEmpty())
				{
					Iterator itrt= cusTypeMap.entrySet().iterator();
					while(itrt.hasNext())
					{
						Map.Entry en = (Map.Entry) itrt.next();
						cusType =   (String) en.getKey();
						cnt= (Integer) en.getValue();
						//System.out.println("KEY.......::["+cusType+"]" );
						//System.out.println("VALUE.......::["+cnt+"]" );

						if ("D".equalsIgnoreCase(cusType))
						{
							if(cnt > 0 && "FW".equalsIgnoreCase(actType))
							{
								isDrExist = "Y";
							}
							else
							{
								isDrExist = "N";
							}
						}
						else if ("C".equalsIgnoreCase(cusType))
						{
							if(cnt > 0 && "FW".equalsIgnoreCase(actType))
							{
								isChemExist = "Y";
							}
							else
							{
								isChemExist = "N";
							}
						}
						else if ("S".equalsIgnoreCase(cusType))
						{
							if(cnt > 0 && "FW".equalsIgnoreCase(actType) && !"N".equalsIgnoreCase(stockParmData))
							{
								isStockExist = "Y";
							}
							else
							{
								isStockExist = "N";
							}
						}
						else if ("O".equalsIgnoreCase(cusType))
						{
							if(cnt > 0 && "FW".equalsIgnoreCase(actType))
							{
								isNCWExist = "Y";
							}
							else
							{
								isNCWExist = "N";
							}
						}
					}
				}
				//Ended by Rushikesh More On 20-03-17 for visibility of visit of doctor and retailer in specific locality

				//System.out.println("isDrExist =["+isDrExist+"], isChemExist=["+isChemExist+"], isStockExist=["+isStockExist+"], isNCWExist=["+isNCWExist+"]");
				count++;
				//System.out.println("locality_code:::>"+rs.getString("LOCALITY_CODE"));
				//lineCount = planmap.get(rs.getString("LOCALITY_CODE").trim());//commenetd by mrunalini sinakr for beat description changes 06-05-2019
				lineCount = planmap.get(checkNull(rs.getString("ROUTE_ID")));//added by mrunalini sinakr for beat description changes 06-05-2019
				//System.out.println("lineCount for plan is:["+lineCount+"]");
				if((lineCount==null || lineCount.trim().length()==0) && planmap.containsKey(checkNull(rs.getString("LOCALITY_CODE"))))
				{
					String planLoc=checkNull(rs.getString("LOCALITY_CODE"));
					//System.out.println("planLoc is["+planLoc+"]planLocality list for plan is:["+planLocality+"]");

					if(!planLocality.contains(planLoc))
					{
						planLocality.add(planLoc);
						//System.out.println("planLoc is["+planLoc+"]planLocality list for plan is:["+planLocality+"]");

						lineCount = planmap.get(checkNull(rs.getString("LOCALITY_CODE")));//added by mrunalini sinakr for beat description changes 06-05-2019

						if((planmap.containsKey(checkNull(rs.getString("ROUTE_ID"))) || planmap.containsKey(checkNull(rs.getString("LOCALITY_CODE")))) && "Y".equalsIgnoreCase(copyPlan) && !flag)
						{
							valueXmlString.append( "<Detail"+currentForm+" domID='"+ domID +"' selected = 'Y' formName='"+formName+"'>\r\n" );
							valueXmlString.append( "<attribute selected=\"Y\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");//Gaurav
							valueXmlString.append( "<order_of_visit><![CDATA[" ).append(lineCount).append( "]]></order_of_visit>\r\n" );
                        }
                        // Commented and Added by Pankaj R on 15-JUL-21 to set the route by default as selected if plan_days is defined in sprs_route for that route [START]
                        else if ("1".equalsIgnoreCase(srNo) && planDays.length() > 0 && !"E".equalsIgnoreCase(modeReport) && !flag )
                        {
                            defCount++;
                            valueXmlString.append( "<Detail"+currentForm+" domID='"+ domID +"' selected = 'Y' formName='"+formName+"'>\r\n" );
							valueXmlString.append( "<attribute selected=\"Y\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");//Gaurav
							valueXmlString.append( "<order_of_visit><![CDATA[" ).append(defCount).append( "]]></order_of_visit>\r\n" );
                        }
                        // Commented and Added by Pankaj R on 15-JUL-21 to set the route by default as selected if plan_days is defined in sprs_route for that route [END]
						else
						{
							valueXmlString.append( "<Detail"+currentForm+" domID='"+ domID +"' selected = 'N' formName='"+formName+"'>\r\n" );
							valueXmlString.append( "<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");//Gaurav Singh on 03/06/15
							valueXmlString.append( "<order_of_visit><![CDATA[" ).append("").append( "]]></order_of_visit>\r\n" );
						}
						valueXmlString.append( "<add_locality_code visible='0'><![CDATA[" ).append(checkNull(rs.getString("LOCALITY_CODE"))).append( "]]></add_locality_code>\r\n" );//added by mrunalini sinkar for repeat locality functionality of sun on 18-04-2019
						valueXmlString.append( "<locality_code><![CDATA[" ).append(checkNull(rs.getString("LOCALITY_CODE"))).append( "]]></locality_code>\r\n" );
						valueXmlString.append( "<sprs_route_descr><![CDATA[" ).append(checkNull(rs.getString("DESCR"))).append( "]]></sprs_route_descr>\r\n" );
						valueXmlString.append( "<stan_code><![CDATA[" ).append(checkNull(rs.getString("STAN_CODE"))).append( "]]></stan_code>\r\n" );
						valueXmlString.append( "<sales_pers><![CDATA[" ).append(checkNull(sprsCode)).append( "]]></sales_pers>\r\n" );
						valueXmlString.append( "<travel_date><![CDATA[" ).append(trvDate).append( "]]></travel_date>\r\n" );
						valueXmlString.append( "<activity_code><![CDATA[" ).append(checkNull(actCode)).append( "]]></activity_code>\r\n" );
						valueXmlString.append( "<chg_date><![CDATA[" ).append(currDate).append( "]]></chg_date>\r\n" );
						valueXmlString.append( "<chg_user><![CDATA[" ).append(userId).append( "]]></chg_user>\r\n" );
						valueXmlString.append( "<chg_term><![CDATA[" ).append(chgTerm).append( "]]></chg_term>\r\n" );
						valueXmlString.append( "<oth_participant><![CDATA[" ).append("").append( "]]></oth_participant>\r\n" );
						valueXmlString.append( "<plan_id><![CDATA[" ).append("").append( "]]></plan_id>\r\n" );
						valueXmlString.append( "<stan_code__from><![CDATA[" ).append("").append( "]]></stan_code__from>\r\n" );
						valueXmlString.append( "<sprs_code__ww><![CDATA[" ).append("").append( "]]></sprs_code__ww>\r\n" );
						valueXmlString.append( "<sales_team><![CDATA[" ).append("").append( "]]></sales_team>\r\n" );
						valueXmlString.append( "<template_file><![CDATA[" ).append("").append( "]]></template_file>\r\n" );
						valueXmlString.append( "<locality_code_from><![CDATA[" ).append("").append( "]]></locality_code_from>\r\n" );
						valueXmlString.append( "<dcr_id><![CDATA["+dcrID+"]]></dcr_id>\r\n" );
						valueXmlString.append( "<line_no><![CDATA[]]></line_no>\r\n" );
						valueXmlString.append( "<tran_id><![CDATA[]]></tran_id>\r\n" );//Added by hariom for primary key view
						valueXmlString.append( "<travel_mode><![CDATA[" ).append("1").append( "]]></travel_mode>\r\n" );//changes by shraddha M to display travel mode in table view[12-11-19]
						valueXmlString.append( "<over_night><![CDATA[" ).append("N").append( "]]></over_night>\r\n" );
						valueXmlString.append( "<to_disable><![CDATA[" ).append("N").append( "]]></to_disable>\r\n" );
						valueXmlString.append( "<station_type><![CDATA[" ).append(checkNull(rs.getString("STATION_TYPE"))).append( "]]></station_type>\r\n" );// added STATION_TYPE by mrunalini sinkar for sun migration changes on 10-04-2019
						valueXmlString.append( "<route_id><![CDATA[" ).append(checkNull(rs.getString("ROUTE_ID"))).append( "]]></route_id>\r\n" );// added ROUTE_ID by mrunalini sinkar for add route id for beat description on 26-04-2019
						valueXmlString.append( "<station_descr><![CDATA[" ).append(checkNull(rs.getString("STATION_DESCR"))).append( "]]></station_descr>\r\n" );// added station_descr by mrunalini sinkar for showing on summary page description on 20-05-2019
						valueXmlString.append( "<route_type><![CDATA[" ).append(checkNull(rs.getString("ROUTE_TYPE"))).append( "]]></route_type>\r\n" );// added ROUTE_TYPE by mrunalini sinkar for sun migration changes on 23-05-2019
						if(isDrExist.equalsIgnoreCase("N"))
						{
							valueXmlString.append( "<dr_visit protect='1'><![CDATA[" ).append("N").append( "]]></dr_visit>\r\n" );
							valueXmlString.append("<dr_visit_display><![CDATA[" ).append( "No" ).append( "]]></dr_visit_display>\r\n" );
						}
						else
						{
							valueXmlString.append( "<dr_visit><![CDATA[" ).append("Y").append( "]]></dr_visit>\r\n" );
							valueXmlString.append("<dr_visit_display><![CDATA[" ).append( "Yes" ).append( "]]></dr_visit_display>\r\n" );
						}
						if(isChemExist.equalsIgnoreCase("N"))
						{
							valueXmlString.append( "<chem_visit protect='1'><![CDATA[" ).append("N").append( "]]></chem_visit>\r\n" );
							valueXmlString.append("<chem_visit_display><![CDATA[" ).append( "No" ).append( "]]></chem_visit_display>\r\n" );

						}
						else
						{
							valueXmlString.append( "<chem_visit><![CDATA[" ).append("Y").append( "]]></chem_visit>\r\n" );
							valueXmlString.append("<chem_visit_display><![CDATA[" ).append( "Yes" ).append( "]]></chem_visit_display>\r\n" );
						}
						if(isStockExist.equalsIgnoreCase("N"))
						{
							valueXmlString.append( "<stockist_visit protect='1'><![CDATA[" ).append("N").append( "]]></stockist_visit>\r\n" );
							valueXmlString.append("<stockist_visit_display><![CDATA[" ).append( "No" ).append( "]]></stockist_visit_display>\r\n" );
						}
						else
						{
							valueXmlString.append( "<stockist_visit><![CDATA[" ).append("Y").append( "]]></stockist_visit>\r\n" );
							valueXmlString.append("<stockist_visit_display><![CDATA[" ).append( "Yes" ).append( "]]></stockist_visit_display>\r\n" );
						}
						if(isNCWExist.equalsIgnoreCase("N"))
						{
							valueXmlString.append( "<other_visit protect='1'><![CDATA[" ).append("N").append( "]]></other_visit>\r\n" );
							valueXmlString.append("<other_visit_display><![CDATA[" ).append( "No" ).append( "]]></other_visit_display>\r\n" );
						}
						else
						{
							valueXmlString.append( "<other_visit><![CDATA[" ).append("Y").append( "]]></other_visit>\r\n" );
							valueXmlString.append("<other_visit_display><![CDATA[" ).append( "Yes" ).append( "]]></other_visit_display>\r\n" );
						}
						valueXmlString.append( "<last_place_of_return><![CDATA[" ).append( placeOfReturnStr ).append( "]]></last_place_of_return>\r\n" );
						valueXmlString.append( "<last_place_of_descr_return><![CDATA[" ).append(placeOfReturnDescr).append( "]]></last_place_of_descr_return>\r\n" );
						valueXmlString.append( "<stan_code__fr><![CDATA[" ).append("").append( "]]></stan_code__fr>\r\n" );
						valueXmlString.append( "<stan_code__to><![CDATA[" ).append("").append( "]]></stan_code__to>\r\n" );
						valueXmlString.append( "<add_geopos><![CDATA[" ).append(latLong).append( "]]></add_geopos>\r\n" );
						valueXmlString.append( "<chg_geopos><![CDATA[" ).append("").append( "]]></chg_geopos>\r\n" );
						valueXmlString.append( "<geopos_accuracy><![CDATA[" ).append("").append( "]]></geopos_accuracy>\r\n" ); //changes made by rupali on 20/07/18 for adding geopos_accuracy tag
						valueXmlString.append("<travel_mode_descr><![CDATA[" ).append(modeDescr).append( "]]></travel_mode_descr>\r\n" );//Added by mrunalni sinkar on 05-10-2019 to show travel mode description
						valueXmlString.append( "<dcr_mode><![CDATA[" ).append( "ADD REPORT" ).append( "]]></dcr_mode>\r\n" );//added by hariom 19-oct-19

						//Added by Rushikesh More On 20-03-17 for visibility of visit of doctor and retailer in specific locality

						if(custTypeList != null && !custTypeList.isEmpty())
						{
							String custTypeMst = "";
							int custTypeSelCnt = 0;
							for(int i = 0; i<custTypeList.size(); i++)
							{
								custTypeMst = (String)custTypeList.get(i);
								if("D".equalsIgnoreCase(custTypeMst) && "Y".equalsIgnoreCase(isDrExist))
								{
									custTypeSelCnt++;
								}
								else if("C".equalsIgnoreCase(custTypeMst) && "Y".equalsIgnoreCase(isChemExist))
								{
									custTypeSelCnt++;
								}
								else if("S".equalsIgnoreCase(custTypeMst) && "Y".equalsIgnoreCase(isStockExist))
								{
									custTypeSelCnt++;
								}
								else if("O".equalsIgnoreCase(custTypeMst) && "Y".equalsIgnoreCase(isNCWExist))
								{
									custTypeSelCnt++;

								}
							}
							if(custTypeSelCnt == custTypeList.size())
							{
								valueXmlString.append( "<cust_visit_all><![CDATA[" ).append("Y").append( "]]></cust_visit_all>\r\n" );
							}
							else
							{
								valueXmlString.append( "<cust_visit_all protect='1' ><![CDATA[" ).append("N").append( "]]></cust_visit_all>\r\n" );
							}
						}
						valueXmlString.append( "<allow_edit_place><![CDATA[" ).append(allowEditPlace).append( "]]></allow_edit_place>\r\n" );
						valueXmlString.append( "<is_place_fortune_act><![CDATA[" ).append(isFortune).append( "]]></is_place_fortune_act>\r\n" );
						valueXmlString.append( "<is_button_disable><![CDATA[" ).append(isButtonDisable).append( "]]></is_button_disable>\r\n" );
						valueXmlString.append( "</Detail"+currentForm+">\r\n" );
						domID ++;
					}


				}
				else
				{
					if((planmap.containsKey(checkNull(rs.getString("ROUTE_ID"))) || planmap.containsKey(checkNull(rs.getString("LOCALITY_CODE")))) && "Y".equalsIgnoreCase(copyPlan) && !flag)
					{
						valueXmlString.append( "<Detail"+currentForm+" domID='"+ domID +"' selected = 'Y' formName='"+formName+"'>\r\n" );
						valueXmlString.append( "<attribute selected=\"Y\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");//Gaurav
						valueXmlString.append( "<order_of_visit><![CDATA[" ).append(lineCount).append( "]]></order_of_visit>\r\n" );
                    }
                    // Commented and Added by Pankaj R on 15-JUL-21 to set the route by default as selected if plan_days is defined in sprs_route for that route [START]
                    else if ("1".equalsIgnoreCase(srNo) && planDays.length() > 0 && !"E".equalsIgnoreCase(modeReport) && !flag )
                    {
                        defCount++;
                        valueXmlString.append( "<Detail"+currentForm+" domID='"+ domID +"' selected = 'Y' formName='"+formName+"'>\r\n" );
                        valueXmlString.append( "<attribute selected=\"Y\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");//Gaurav
                        valueXmlString.append( "<order_of_visit><![CDATA[" ).append(defCount).append( "]]></order_of_visit>\r\n" );
                    }
                    // Commented and Added by Pankaj R on 15-JUL-21 to set the route by default as selected if plan_days is defined in sprs_route for that route [END]
					else
					{
						valueXmlString.append( "<Detail"+currentForm+" domID='"+ domID +"' selected = 'N' formName='"+formName+"'>\r\n" );
						valueXmlString.append( "<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");//Gaurav Singh on 03/06/15
						valueXmlString.append( "<order_of_visit><![CDATA[" ).append("").append( "]]></order_of_visit>\r\n" );
					}
					valueXmlString.append( "<add_locality_code visible='0'><![CDATA[" ).append(checkNull(rs.getString("LOCALITY_CODE"))).append( "]]></add_locality_code>\r\n" );//added by mrunalini sinkar for repeat locality functionality of sun on 18-04-2019
					valueXmlString.append( "<locality_code><![CDATA[" ).append(checkNull(rs.getString("LOCALITY_CODE"))).append( "]]></locality_code>\r\n" );
					valueXmlString.append( "<sprs_route_descr><![CDATA[" ).append(checkNull(rs.getString("DESCR"))).append( "]]></sprs_route_descr>\r\n" );
					valueXmlString.append( "<stan_code><![CDATA[" ).append(checkNull(rs.getString("STAN_CODE"))).append( "]]></stan_code>\r\n" );
					valueXmlString.append( "<sales_pers><![CDATA[" ).append(checkNull(sprsCode)).append( "]]></sales_pers>\r\n" );
					valueXmlString.append( "<travel_date><![CDATA[" ).append(trvDate).append( "]]></travel_date>\r\n" );
					valueXmlString.append( "<activity_code><![CDATA[" ).append(checkNull(actCode)).append( "]]></activity_code>\r\n" );
					valueXmlString.append( "<chg_date><![CDATA[" ).append(currDate).append( "]]></chg_date>\r\n" );
					valueXmlString.append( "<chg_user><![CDATA[" ).append(userId).append( "]]></chg_user>\r\n" );
					valueXmlString.append( "<chg_term><![CDATA[" ).append(chgTerm).append( "]]></chg_term>\r\n" );
					valueXmlString.append( "<oth_participant><![CDATA[" ).append("").append( "]]></oth_participant>\r\n" );
					valueXmlString.append( "<plan_id><![CDATA[" ).append("").append( "]]></plan_id>\r\n" );
					valueXmlString.append( "<stan_code__from><![CDATA[" ).append("").append( "]]></stan_code__from>\r\n" );
					valueXmlString.append( "<sprs_code__ww><![CDATA[" ).append("").append( "]]></sprs_code__ww>\r\n" );
					valueXmlString.append( "<sales_team><![CDATA[" ).append("").append( "]]></sales_team>\r\n" );
					valueXmlString.append( "<template_file><![CDATA[" ).append("").append( "]]></template_file>\r\n" );
					valueXmlString.append( "<locality_code_from><![CDATA[" ).append("").append( "]]></locality_code_from>\r\n" );
					valueXmlString.append( "<dcr_id><![CDATA["+dcrID+"]]></dcr_id>\r\n" );
					valueXmlString.append( "<line_no><![CDATA[]]></line_no>\r\n" );
					valueXmlString.append( "<tran_id><![CDATA[]]></tran_id>\r\n" );  //Added by Hariom for primary Key View
					valueXmlString.append( "<travel_mode><![CDATA[" ).append("1").append( "]]></travel_mode>\r\n" );//changes by shraddha M to display travel mode in table view[12-11-19]
					valueXmlString.append( "<over_night><![CDATA[" ).append("N").append( "]]></over_night>\r\n" );
					valueXmlString.append( "<to_disable><![CDATA[" ).append("N").append( "]]></to_disable>\r\n" );
					valueXmlString.append( "<station_type><![CDATA[" ).append(checkNull(rs.getString("STATION_TYPE"))).append( "]]></station_type>\r\n" );// added STATION_TYPE by mrunalini sinkar for sun migration changes on 10-04-2019
					valueXmlString.append( "<route_id><![CDATA[" ).append(checkNull(rs.getString("ROUTE_ID"))).append( "]]></route_id>\r\n" );// added ROUTE_ID by mrunalini sinkar for add route id for beat description on 26-04-2019
					valueXmlString.append( "<station_descr><![CDATA[" ).append(checkNull(rs.getString("STATION_DESCR"))).append( "]]></station_descr>\r\n" );// added station_descr by mrunalini sinkar for showing on summary page description on 20-05-2019
					valueXmlString.append( "<route_type><![CDATA[" ).append(checkNull(rs.getString("ROUTE_TYPE"))).append( "]]></route_type>\r\n" );// added ROUTE_TYPE by mrunalini sinkar for sun migration changes on 23-05-2019
					valueXmlString.append( "<dcr_mode><![CDATA[" ).append( "ADD REPORT" ).append( "]]></dcr_mode>\r\n" );//added by hariom 19-oct-19


					/*
					isDrExist = checkCustExist(sprsCode, locCode, "D", connectionObject);
					isChemExist = checkCustExist(sprsCode, locCode, "C", connectionObject);
					isStockExist = checkCustExist(sprsCode, locCode, "S", connectionObject);
					isNCWExist = checkCustExist(sprsCode, locCode, "O", connectionObject);
					 */

					//System.out.println("isDrExifgst asd["+isDrExist+"]isNCWEdfgxist["+isNCWExist);
					String isDrPlan  = checkNull(checkCustExistInPlan(sprsCode,trvDate, locCode, "D", connectionObject));
					String isChemPlan = checkNull(checkCustExistInPlan(sprsCode,trvDate, locCode, "C", connectionObject));
					String isStockPlan = checkNull(checkCustExistInPlan(sprsCode,trvDate, locCode, "S", connectionObject));
					String isNCWPlan = checkNull(checkCustExistInPlan(sprsCode, trvDate, locCode, "O", connectionObject));
					//System.out.println("isDrExist 123["+isDrExist+"]isChemPlan["+isChemPlan);
					/*if((planmap.containsKey(checkNull(rs.getString("ROUTE_ID"))) ||  planmap.containsKey(checkNull(rs.getString("LOCALITY_CODE")))) && "Y".equalsIgnoreCase(copyPlan))
					{
						if(isDrExist.equalsIgnoreCase("N"))
						{
							valueXmlString.append( "<dr_visit protect='1'><![CDATA[" ).append("N").append( "]]></dr_visit>\r\n" );
						}
						else
						{
							if(isDrPlan.equalsIgnoreCase("N"))
							{
								valueXmlString.append( "<dr_visit><![CDATA[" ).append("N").append( "]]></dr_visit>\r\n" );
							}
							else
							{
								valueXmlString.append( "<dr_visit><![CDATA[" ).append("Y").append( "]]></dr_visit>\r\n" );
							}
						}
						if(isChemExist.equalsIgnoreCase("N"))
						{
							valueXmlString.append( "<chem_visit protect='1'><![CDATA[" ).append("N").append( "]]></chem_visit>\r\n" );
						}
						else
						{
							if(isChemPlan.equalsIgnoreCase("N"))
							{
								valueXmlString.append( "<chem_visit><![CDATA[" ).append("N").append( "]]></chem_visit>\r\n" );
							}
							else
							{
								valueXmlString.append( "<chem_visit><![CDATA[" ).append("Y").append( "]]></chem_visit>\r\n" );
							}
						}
						if(isStockExist.equalsIgnoreCase("N"))
						{
							valueXmlString.append( "<stockist_visit protect='1'><![CDATA[" ).append("N").append( "]]></stockist_visit>\r\n" );
						}
						else
						{
							if(isStockPlan.equalsIgnoreCase("N"))
							{
								valueXmlString.append( "<stockist_visit><![CDATA[" ).append("N").append( "]]></stockist_visit>\r\n" );
							}
							else
							{
								valueXmlString.append( "<stockist_visit><![CDATA[" ).append("Y").append( "]]></stockist_visit>\r\n" );
							}
						}
						if(isNCWExist.equalsIgnoreCase("N"))
						{

							valueXmlString.append( "<other_visit protect='1'><![CDATA[" ).append("N").append( "]]></other_visit>\r\n" );
						}
						else
						{
							if(isNCWPlan.equalsIgnoreCase("N"))
							{
								valueXmlString.append( "<other_visit><![CDATA[" ).append("N").append( "]]></other_visit>\r\n" );
							}
							else
							{
								valueXmlString.append( "<other_visit><![CDATA[" ).append("Y").append( "]]></other_visit>\r\n" );
							}
						}
					}
					else*/
					{

						if(isDrExist.equalsIgnoreCase("N"))
						{
							valueXmlString.append("<dr_visit protect='1'><![CDATA[" ).append("N").append( "]]></dr_visit>\r\n" );
							valueXmlString.append("<dr_visit_display><![CDATA[" ).append( "No" ).append( "]]></dr_visit_display>\r\n" );

						}
						else
						{
							valueXmlString.append("<dr_visit><![CDATA[" ).append("Y").append( "]]></dr_visit>\r\n" );
							valueXmlString.append("<dr_visit_display><![CDATA[" ).append( "Yes" ).append( "]]></dr_visit_display>\r\n" );

						}
						if(isChemExist.equalsIgnoreCase("N"))
						{
							valueXmlString.append("<chem_visit protect='1'><![CDATA[" ).append("N").append( "]]></chem_visit>\r\n" );
							valueXmlString.append("<chem_visit_display><![CDATA[" ).append( "No" ).append( "]]></chem_visit_display>\r\n" );

						}
						else
						{
							valueXmlString.append("<chem_visit><![CDATA[" ).append("Y").append( "]]></chem_visit>\r\n" );
							valueXmlString.append("<chem_visit_display><![CDATA[" ).append( "Yes" ).append( "]]></chem_visit_display>\r\n" );

						}
						if(isStockExist.equalsIgnoreCase("N"))
						{
							valueXmlString.append("<stockist_visit protect='1'><![CDATA[" ).append("N").append( "]]></stockist_visit>\r\n" );
							valueXmlString.append("<stockist_visit_display><![CDATA[" ).append( "No" ).append( "]]></stockist_visit_display>\r\n" );

						}
						else
						{
							valueXmlString.append("<stockist_visit><![CDATA[" ).append("Y").append( "]]></stockist_visit>\r\n" );
							valueXmlString.append("<stockist_visit_display><![CDATA[" ).append( "Yes" ).append( "]]></stockist_visit_display>\r\n" );

						}
						if(isNCWExist.equalsIgnoreCase("N"))
						{
							valueXmlString.append("<other_visit protect='1'><![CDATA[" ).append("N").append( "]]></other_visit>\r\n" );
							valueXmlString.append("<other_visit_display><![CDATA[" ).append( "No" ).append( "]]></other_visit_display>\r\n" );

						}
						else
						{
							valueXmlString.append("<other_visit><![CDATA[" ).append("Y").append( "]]></other_visit>\r\n" );
							valueXmlString.append("<other_visit_display><![CDATA[" ).append( "Yes" ).append( "]]></other_visit_display>\r\n" );

						}

					}
					valueXmlString.append( "<last_place_of_return><![CDATA[" ).append( placeOfReturnStr ).append( "]]></last_place_of_return>\r\n" );
					valueXmlString.append( "<last_place_of_descr_return><![CDATA[" ).append(placeOfReturnDescr).append( "]]></last_place_of_descr_return>\r\n" );
					valueXmlString.append( "<stan_code__fr><![CDATA[" ).append("").append( "]]></stan_code__fr>\r\n" );
					valueXmlString.append( "<stan_code__to><![CDATA[" ).append("").append( "]]></stan_code__to>\r\n" );
					valueXmlString.append( "<add_geopos><![CDATA[" ).append(latLong).append( "]]></add_geopos>\r\n" );
					valueXmlString.append( "<chg_geopos><![CDATA[" ).append("").append( "]]></chg_geopos>\r\n" );
					valueXmlString.append( "<geopos_accuracy><![CDATA[" ).append("").append( "]]></geopos_accuracy>\r\n" ); //changes made by rupali on 20/07/18 for adding geopos_accuracy tag

					//Added by Rushikesh More On 20-03-17 for visibility of visit of doctor and retailer in specific locality

					if(custTypeList != null && !custTypeList.isEmpty())
					{
						String custTypeMst = "";
						int custTypeSelCnt = 0;
						for(int i = 0; i<custTypeList.size(); i++)
						{
							custTypeMst = (String)custTypeList.get(i);
							if("D".equalsIgnoreCase(custTypeMst) && "Y".equalsIgnoreCase(isDrExist))
							{
								custTypeSelCnt++;
							}
							else if("C".equalsIgnoreCase(custTypeMst) && "Y".equalsIgnoreCase(isChemExist))
							{
								custTypeSelCnt++;
							}
							else if("S".equalsIgnoreCase(custTypeMst) && "Y".equalsIgnoreCase(isStockExist))
							{
								custTypeSelCnt++;
							}
							else if("O".equalsIgnoreCase(custTypeMst) && "Y".equalsIgnoreCase(isNCWExist))
							{
								custTypeSelCnt++;

							}
						}
						if(custTypeSelCnt == custTypeList.size())
						{
							valueXmlString.append( "<cust_visit_all><![CDATA[" ).append("Y").append( "]]></cust_visit_all>\r\n" );
						}
						else
						{
							valueXmlString.append( "<cust_visit_all protect='1' ><![CDATA[" ).append("N").append( "]]></cust_visit_all>\r\n" );
						}
					}

					/*if("Y".equalsIgnoreCase(isDrExist) && "Y".equalsIgnoreCase(isChemExist) && "Y".equalsIgnoreCase(isStockExist))
					{
						valueXmlString.append( "<cust_visit_all><![CDATA[" ).append("Y").append( "]]></cust_visit_all>\r\n" );
					}
					else
					{
						valueXmlString.append( "<cust_visit_all protect='1' ><![CDATA[" ).append("N").append( "]]></cust_visit_all>\r\n" );
					}*/
					//Ended by Rushikesh More On 20-03-17 for visibility of visit of doctor and retailer in specific locality
					valueXmlString.append("<travel_mode_descr><![CDATA[" ).append(modeDescr).append( "]]></travel_mode_descr>\r\n" );//Added by mrunalni sinkar on 05-10-2019 to show travel mode description
					valueXmlString.append( "<allow_edit_place><![CDATA[" ).append(allowEditPlace).append( "]]></allow_edit_place>\r\n" );
					valueXmlString.append( "<is_place_fortune_act><![CDATA[" ).append(isFortune).append( "]]></is_place_fortune_act>\r\n" );
					valueXmlString.append( "<is_button_disable><![CDATA[" ).append(isButtonDisable).append( "]]></is_button_disable>\r\n" );
					valueXmlString.append( "</Detail"+currentForm+">\r\n" );
					domID ++;
				}


			}
			domID = 1;
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			//System.out.println( "Exception :WsfaDSRMobileWizardEJB :getPlaceOfWork():" + e.getMessage() + ":" );
			//valueXmlString = valueXmlString.append( generateErrorString( genericUtility.createErrorString( e ) ) );
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		finally
		{
			try
			{
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(isLocalConn &&  connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{
				//System.out.println( "Exception :WsfaDSRMobileWizardEJB :getPlaceOfWork :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}

		//System.out.println("placeof work detail:::"+valueXmlString.toString());
		return valueXmlString.toString();
	}
	//Commented and added selLocality by kailash on 21-09-18[start]
	//public String getCustomerDetail(Document dom, Document dom2, String currentForm, String userId, String sprsCode, String actCode, String trvDate, String custType,String formName, Connection connectionObject) throws ITMException //Chnaged by sachin satre on 11-nov-16
	public String getCustomerDetail(Document dom, Document dom2, String currentForm, String userId, String sprsCode, String actCode, String trvDate, String custType,String formName,String selLocality,String selRouteId, Connection connectionObject) throws ITMException //Chnaged by sachin satre on 11-nov-16
	//Commented and added selLocality by kailash on 21-09-18[end]
	{
		System.out.println("Inside getCustomerDetail mathhod of DAR.............................:-  "+trvDate);
		ResultSet rs = null;
		Statement stmt = null;
		PreparedStatement pstmt = null;
		PreparedStatement pstmtPlan = null;
		ResultSet rsPlan = null;

		PreparedStatement strgVisitPstmt = null;
		ResultSet strgVisitRs = null;
		String sql = "";
		String currDate = "";
		String chgTerm ="";
		String locality = "";
		String routeId = "";
		String hours="";
		String startTime="";
		String hour = "";
		String minute = "";
		String interval ="";
		String preFormDet ="";
		String sqlEdit = "";
		String customers ="";
		String [] temp;
		String strgCode = "";
		String visitDatesInMonth = "";
		String dcrID = "";


		StringBuffer valueXmlString = new StringBuffer();
		List<String> list = null;
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		boolean flag = false;
		int locForm = 0;
		int rowsRS = 0;
		NodeList parentList = null;
		Node parentNode = null;
		String chemistVisit ="" ;
		String stockistVisit ="" ;
		String ncwVisit ="" ;
		boolean chemistExistFlag;
		boolean stockistExistFlag;
		boolean ncwExistFlag;
		boolean IsLocalConn = false;
		boolean unlistSun=true;
		String modeReport = "A";
		int currentFormNumber = 0;
		if( currentForm != null && currentForm.trim().length() > 0 )
		{
			currentFormNumber = Integer.parseInt( currentForm );
		}
		String sampleOrder="";
		String samplItem="";
		String display="";
		String brand="";
		String prescription="";
		String survey="";
		String coaching="";
		String doctorTeam="";
		String invoiceTeam="";
		String collectionTeam = "";
		String chemSampleOrder="";
		String chemSamplItem="";
		String chemDisplay="";
		String chembrand="";
		String chemPrescription="";
		String chemSurvey="";
		String chemCoaching="";
		String retailerTeam="";
		String stockSampleOrder="";
		String stockSamplItem="";
		String stockDisplay="";
		String stockbrand="";
		String stockPrescription="";
		String stockSurvey="";
		String stockCoaching="";
		String stockistTeam="";
		String ncwSampleOrder="";
		String ncwSamplItem="";
		String ncwDisplay="";
		String ncwbrand="";
		String ncwPrescription="";
		String ncwSurvey="";
		String ncwCoaching="";
		String ncwTeam="";
		// added by kailash
		NodeList childList = null;
		Node childNode = null;
		Element elementAttr = null;
		String childNodeName = "";
		String columnValue = "";
		String customerType = "";
		// added by kailash
		String customerTypeEdit="";


		String objName = checkNull(getObjNameFromDom(dom2, "objName",currentFormNumber));
		String locFormNo = checkNull(getFormNo(objName, "place", connectionObject));
		String mainFormNo = checkNull(getFormNo(objName, "mainform", connectionObject));
		/*		String retailFormNo = checkNull(getFormNo(objName, "retailer", connectionObject));
		String docFormNo = checkNull(getFormNo(objName, "doctor", connectionObject));
		String stockFormNo = checkNull(getFormNo(objName, "stockist", connectionObject));
		String ncwFormNo = checkNull(getFormNo(objName, "ncw", connectionObject));*/
		//Added by mrunalini sinkar for fortune call_outcome changes on 12-may-2021(Start)
		String isFortune  = checkNull(getSfaParmValue(userId,"IS_FORTUNE_ACTIVITY",connectionObject));
		String activityFormNo = checkNull(getFormNo(objName, "activity", connectionObject));
		//Added by mrunalini sinkar for fortune call_outcome changes on 12-may-2021(End)

		//added by mrunalini sinkar to showing custoerwise form number12-03-2019(start)
		String teamFormName="";
		if("D".equalsIgnoreCase(custType))
		{
			sampleOrder=checkNull(getFormNo(objName, "sampleorder", connectionObject));
			samplItem=checkNull(getFormNo(objName, "sampleitem", connectionObject));
			display=checkNull(getFormNo(objName, "display", connectionObject));
			brand=checkNull(getFormNo(objName, "brand", connectionObject));
			prescription=checkNull(getFormNo(objName, "brandsurvey", connectionObject));
			survey=checkNull(getFormNo(objName, "survey", connectionObject));
			coaching=checkNull(getFormNo(objName, "coaching", connectionObject));
			doctorTeam=checkNull(getFormNo(objName, "team", connectionObject));
			invoiceTeam=checkNull(getFormNo(objName, "invoice", connectionObject));
			collectionTeam=checkNull(getFormNo(objName, "collection", connectionObject));
			teamFormName=doctorTeam;
		}
		else if("C".equalsIgnoreCase(custType))
		{
			chemSampleOrder=checkNull(getFormNo(objName, "retailersampleorder", connectionObject));
			chemSamplItem=checkNull(getFormNo(objName, "retailersampleitem", connectionObject));
			chemDisplay=checkNull(getFormNo(objName, "retailerdisplay", connectionObject));
			chembrand=checkNull(getFormNo(objName, "retailerbrand", connectionObject));
			chemPrescription=checkNull(getFormNo(objName, "retailerbrandsurvey", connectionObject));
			chemSurvey=checkNull(getFormNo(objName, "retailersurvey", connectionObject));
			chemCoaching=checkNull(getFormNo(objName, "retailercoaching", connectionObject));
			retailerTeam=checkNull(getFormNo(objName, "retailerteam", connectionObject));
			teamFormName=retailerTeam;
		}
		else if("S".equalsIgnoreCase(custType))
		{
			stockSampleOrder=checkNull(getFormNo(objName, "stockistsampleorder", connectionObject));
			stockSamplItem=checkNull(getFormNo(objName, "stockistsampleitem", connectionObject));
			stockDisplay=checkNull(getFormNo(objName, "stockistdisplay", connectionObject));
			stockbrand=checkNull(getFormNo(objName, "stockistbrand", connectionObject));
			stockPrescription=checkNull(getFormNo(objName, "stockistbrandsurvey", connectionObject));
			stockSurvey=checkNull(getFormNo(objName, "stockistsurvey", connectionObject));
			stockCoaching=checkNull(getFormNo(objName, "stockistcoaching", connectionObject));
			stockistTeam=checkNull(getFormNo(objName, "stockistteam", connectionObject));
			teamFormName=stockistTeam;
		}
		else
		{
			ncwSampleOrder=checkNull(getFormNo(objName, "ncwsampleorder", connectionObject));
			ncwSamplItem=checkNull(getFormNo(objName, "ncwsampleitem", connectionObject));
			ncwDisplay=checkNull(getFormNo(objName, "ncwdisplay", connectionObject));
			ncwbrand=checkNull(getFormNo(objName, "ncwbrand", connectionObject));
			ncwPrescription=checkNull(getFormNo(objName, "ncwbrandsurvey", connectionObject));
			ncwSurvey=checkNull(getFormNo(objName, "ncwsurvey", connectionObject));
			ncwCoaching=checkNull(getFormNo(objName, "ncwcoaching", connectionObject));
			ncwTeam=checkNull(getFormNo(objName, "ncwteam", connectionObject));
			teamFormName=ncwTeam;
		}

		System.out.println("teamFormName is:::::["+teamFormName+"]");

		//added by mrunalini sinkar to showing custoerwise form number12-03-2019(end)
		String defVisitWithData  = checkNull(getSfaParmValue(userId,"DEF_VISIT_WITH_DATA",connectionObject));//Added by mrunalini sinkar for showing member present
		String isMemberPresent  = checkNull(getSfaParmValue(userId,"HIDE_UNLIST_DET",connectionObject));//Added by mrunalini sinkar for showing member present
		String eventHideTimeEnd  = checkNull(getSfaParmValue(userId,"HIDE_EVENT_TIME_END",connectionObject));//Added by mrunalini sinkar for showing member present
		String allowDrUnlist = checkNull(getSfaParmValue(userId,"ALLOW_DR_UNLIST_DAR",connectionObject));//Added by mrunalini sinkar for showing member present
		String allowChemistUnlist = checkNull(getSfaParmValue(userId,"ALLOW_CH_UNLIST_DAR",connectionObject));//Added by mrunalini sinkar for showing member present
		String stockistTable = getSfaParmValue(sprsCode,"GET_STOCKIST_DETAILS",connectionObject);
		String allowEditPlace = "0",allowEditCust = "0";
		allowEditPlace = getSfaParmValue(sprsCode,"ALLOW_EDIT_PLACE_DCR",connectionObject);
		allowEditCust = getSfaParmValue(sprsCode,"ALLOW_EDIT_CUST_DCR",connectionObject);
		String formMandatory = getSfaParmValue(userId,"IS_FORM_MANDATORY",connectionObject);//Added By Mrunalini sinkar for fortune server 20-May-2021
		//System.out.println("allowEditPlace:::"+allowEditPlace+"  allowEditCust:::"+allowEditCust);
		//String allowStockistVisit = checkNull(getSfaParmValue(userId,"ALLOW_SK_UNLIST_DAR",connectionObject));//Added by mrunalini sinkar for showing member present
		//Added by mrunalini sinkar to make server response  fast on 12-03-2020(start)
		String itemSer = checkNull(getItemSer(userId, connectionObject));
		String []eventTimes = new String [2];
		eventTimes = getEventStartEndTime(connectionObject,userId,trvDate);
		String timeFrom = eventTimes[0];
		String timeTo = eventTimes[1];
		HashMap<String, String> serClassMap = new HashMap<String, String>();
		HashMap<String, String> custClassMap = new HashMap<String, String>();
		int classCount = getCountFromSerClass(itemSer, connectionObject);
		if(classCount > 0)
		{
			serClassMap=getSerClassCodeDesc(itemSer, connectionObject);
		}
		else
		{
			custClassMap=getCustClassCodeDesc(custType,connectionObject);
		}
		//Added by mrunalini sinkar to make server response  fast on 12-03-2020(end)

		if("Y".equalsIgnoreCase(isMemberPresent))
		{
			unlistSun=false;
		}

		//0- Don't allow if created from real time reporting, 1-Always Allow, 2-Never allow.


		String visitedWithDisp = "";
		String visitedWithTeam = checkNull(genericUtility.getColumnValue( "visited_with" , dom2 ));
		if(visitedWithTeam.trim().length() > 0 )
		{
			String [] team = visitedWithTeam.split(",");
			for(int i = 0 ;i < team.length;i++)
			{
				String visitTeam = team[i];
				if(visitTeam!=null || !visitTeam.equalsIgnoreCase(""))
				{
					if(visitTeam.indexOf("(") != -1 && visitTeam.indexOf(")") != -1)
					{
						String selTeam = checkNull(visitTeam.substring(visitTeam.indexOf("(")+1, visitTeam.indexOf(")")));
						String dispName = checkNull(getEmpNameDesign(selTeam,connectionObject));
						if(visitedWithDisp.trim().length() > 0 )
						{
							visitedWithDisp = visitedWithDisp +","+dispName;
						}
						else
						{
							visitedWithDisp = dispName;
						}
					}
				}
			}
			//System.out.println("visitedWithDisp::::::"+visitedWithDisp);
		}

		ArrayList<String> multiCustomer = new ArrayList<String>();

		try
		{
			InetAddress ownIP=InetAddress.getLocalHost();
			chgTerm = ownIP.getHostAddress();
			if(connectionObject ==null)
			{
				connectionObject = getConnection();
				IsLocalConn = true;
			}

			String eventTime = geteventTime();



			DateFormat dtFormat = new SimpleDateFormat(getApplDateFormat());
			java.util.Date date = Calendar.getInstance().getTime();
			currDate = dtFormat.format( date );
			String currDate1 =  genericUtility.getValidDateTimeString( currDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );
			SimpleDateFormat applFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());//Added by mrunalini sinkar for next plan date
			SimpleDateFormat dbFormat = new SimpleDateFormat(genericUtility.getDBDateFormat());//Added by mrunalini sinkar for next plan date
			//System.out.println("Salesperson >"+sprsCode);
			chemistExistFlag=false;
			stockistExistFlag=false;
			ncwExistFlag=false;
			int detail3ListLen = 0;
			//valueXmlString.append("<Root>");
			String eventDate =  genericUtility.getValidDateString( trvDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );
			dcrID = getDCRId(connectionObject,userId, trvDate); //added by mrunalini sinkar on 14-may-2018
			locForm = Integer.parseInt(currentForm) - 1;
			//Changed and added by kailash on 27-09-18[start].
			//Added by mrunalini sinkar for get survey data
			String sfaParmVal  = getSfaParmValue(sprsCode,"CHC_SURVEY",connectionObject);
			//System.out.println("sfaParmVal =["+sfaParmVal+"]");
			// added by kailash
			parentList = dom.getElementsByTagName("Detail"+currentForm+"");
			int parentNodeListLength2 = parentList.getLength();
			for (int prntCtr = 0; prntCtr < parentNodeListLength2; prntCtr++ )
			{
				parentNode = parentList.item(prntCtr);
				childList = parentNode.getChildNodes();
				for (int ctr = 0; ctr < childList.getLength(); ctr++)
				{
					childNode = childList.item(ctr);
					childNodeName = childNode.getNodeName();
					//System.out.println("chileNodeName9434375["+childNodeName+"]");

					if ( "cust_type".equalsIgnoreCase(childNodeName))
					{
						if((childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null))
						{
							customerType = childNode.getFirstChild().getNodeValue().trim();
						}
					}
				}
				if(customerType.trim().length() > 0)
				{
					break;
				}
			}
			// added by kailash
			//Added by mrunalini sinkar for fortune call_outcome changes on 12-may-2021(Start)
			String sprsActCode="";
			if("Y".equalsIgnoreCase(isFortune))
			{
				sprsActCode = checkNull(getActCodeFromActivityFormDom(dom2, activityFormNo ,connectionObject ));
			}
			else
			{
				sprsActCode="'"+actCode+"'";
			}
			//Added by mrunalini sinkar for fortune call_outcome changes on 12-may-2021(End)
			//System.out.println("customerType["+customerType+"]");
			if("UNLISTED-DOCTOR".equalsIgnoreCase(customerType)|| "UNLISTED-RETAILER".equalsIgnoreCase(customerType)|| "UNLISTED-STOCKIST".equalsIgnoreCase(customerType)||"UNLISTED-OTHER".equalsIgnoreCase(customerType) || "UNLISTED-CHEMIST".equalsIgnoreCase(customerType))
			{
				locality = selLocality;
				routeId=selRouteId;
				//System.out.println("selRouteId"+selRouteId);
				//System.out.println("unlistLoc locality>>>>.["+locality+"]");
			}
			else
			{
				locality = getLocFromDom(dom2, locFormNo , sprsCode, custType,connectionObject );
				routeId = getRouteIdFromDom(dom2, locFormNo , sprsCode, custType,connectionObject );
				//System.out.println("routeId["+routeId+"]locality["+locality+"]");
			}

			String localityDom = getLocFromDom(dom2, locFormNo , sprsCode, custType,connectionObject );
			String routeIdDom = getRouteIdFromDom(dom2, locFormNo , sprsCode, custType,connectionObject );
			//System.out.println("routeIdDom["+routeIdDom+"]localityDom["+localityDom+"]");

			//System.out.println("locality------["+locality+"]");
			//Changed and added by kailash on 27-09-18[end].
			String otherParticipant = checkNull(genericUtility.getColumnValue("oth_participant", dom2, mainFormNo));
			String workWithOther = checkNull(genericUtility.getColumnValue("work_with_other", dom2, mainFormNo));
			String workWith = checkNull(genericUtility.getColumnValue("visited_with_display", dom2, mainFormNo));
			String copyPlan = checkNull(getSelectedRowValue(dom2, mainFormNo, "copy_plan", 0));
			String activityCodeDom = checkNull(genericUtility.getColumnValue("activity_code", dom2, mainFormNo));

			//System.out.println("otherParticipant=["+otherParticipant+"]");
			//System.out.println("workWith=["+workWith+"] copyPlan=["+copyPlan+"]");

			String trvDBDate =  genericUtility.getValidDateTimeString( trvDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );

			String winName= "w_"+objName;

			String formSql="SELECT FORM_NO,FORM_NAME FROM OBJ_FORMS WHERE WIN_NAME= ?  AND FORM_NO > ? AND FORM_TYPE <>'SP' ORDER BY TO_NUMBER(FORM_NO)";
			pstmt=connectionObject.prepareStatement(formSql);
			pstmt.setString(1, winName);
			pstmt.setInt(2, currentFormNumber);

			rs = pstmt.executeQuery();
			while(rs.next())
			{
				String strgType="";
				String formNo = checkNull(rs.getString("FORM_NO"));
				String currenFormName = checkNull(rs.getString("FORM_NAME"));
				if("doctor".equalsIgnoreCase(currenFormName))
				{
					strgType="D";
				}
				else if("retailer".equalsIgnoreCase(currenFormName))
				{
					strgType="C";
				}
				else if("stockist".equalsIgnoreCase(currenFormName))
				{
					strgType="S";
				}

				if(customerTypeEdit.trim().length()==0)
				{
					customerTypeEdit="'"+strgType+"'";
				}
				else
				{
					customerTypeEdit=customerTypeEdit + ","+"'"+strgType+"'";
				}
			}
			if (rs != null)
			{
				rs.close();
				rs = null;
			}
			if (pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(customerTypeEdit.trim().length()==0)
			{
				customerTypeEdit="''";
			}
			int editCustCnt=0;
			System.out.println("editcustomerTypes is:["+customerTypeEdit+"]");
			String cntSql="SELECT COUNT(*) AS CNT FROM STRG_MEET SM,STRG_CUST_TYPE SCT WHERE SM.STRG_TYPE=SCT.TYPE AND SM.EVENT_DATE=? AND SALES_PERS=? AND SCT.DCR_GROUP IN("+customerTypeEdit+")  AND SCT.DCR_GROUP <> ?";
			pstmt=connectionObject.prepareStatement(cntSql);
			pstmt.setTimestamp( 1, java.sql.Timestamp.valueOf( trvDBDate ) );
			pstmt.setString(2, sprsCode);
			pstmt.setString(3, custType);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				editCustCnt = rs.getInt("CNT");
			}
			if (rs != null)
			{
				rs.close();
				rs = null;
			}
			if (pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}

			System.out.println("editCustCnt is:["+editCustCnt+"]");

			temp = locality.split(",");

			locality = localityDom;
			routeId = routeIdDom;

			String actType = getActivityType( actCode, connectionObject );
			System.out.println("actType IS......= "+actType);
			int strgMeetCount = 0;
			String checkStrgMeetSql = "SELECT COUNT(1) AS COUNT FROM STRG_MEET WHERE EVENT_DATE  = ? AND SALES_PERS = ? AND STRG_CODE = ?";
			PreparedStatement pstmtCheckStrgMeet = connectionObject.prepareStatement(checkStrgMeetSql);
			sql = "SELECT COUNT(*) FROM STRG_MEET WHERE SALES_PERS = ? AND EVENT_DATE = ?";
			pstmt =  connectionObject.prepareStatement( sql );
			pstmt.setString(1, sprsCode);
			pstmt.setTimestamp( 2, java.sql.Timestamp.valueOf( trvDBDate ) );
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				rowsRS = rs.getInt(1);
			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rowsRS > 0)
			{
				modeReport = "E";
			}

			String parmValue = "N";
			String sqlVisit = "SELECT PARM_VALUE FROM SFAPARM WHERE PARM_NAME='VALIDATE_NO_VISIT' AND ? BETWEEN EFF_FROM AND VALID_UPTO AND ACTIVE='Y' ";
			pstmt = connectionObject.prepareStatement(sqlVisit);
			pstmt.setTimestamp(1, java.sql.Timestamp.valueOf(currDate1));
			rs = pstmt.executeQuery();

			if (rs.next())
			{
				parmValue = checkNull(rs.getString("PARM_VALUE"));
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}


			int srNo=0;
			//to append previous values of current form from current dom on previous action
			//Added by Bhagyashri T for CGST AND SGST[START]
			String totCgst ="";
			String totCgstSql = "SELECT DDF_TOTAL_TAX_AMOUNT( ? )AS TOTCGST FROM DUAL";
			pstmt = connectionObject.prepareStatement( totCgstSql );
			pstmt.setString(1, "CGST");
			ResultSet rset = pstmt.executeQuery();
			if ( rset.next() )
			{
				totCgst = checkNull( rset.getString( "TOTCGST" ) );
			}
			if (rset !=null )
			{
				rset.close();
				rset = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			String totSgst="";
			String totSgstSql = "SELECT DDF_TOTAL_TAX_AMOUNT( ? )AS TOTSGST FROM DUAL";
			pstmt = connectionObject.prepareStatement( totSgstSql );
			pstmt.setString(1, "SGST");
			rset = pstmt.executeQuery();
			if ( rset.next() )
			{
				totSgst = checkNull( rset.getString( "TOTSGST" ) );
			}
			if (rset !=null )
			{
				rset.close();
				rset = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			//Added by Bhagyashri T for CGST AND SGST[END]
			//flag = preDomExists( dom, currentForm );
			flag = preDomExists( dom2, currentForm );
			System.out.println( "history detail exists in DAR["+ flag +"]" );
			String formNo = "";
			HashMap<String,String> subFormsMap = getSubForms(currentForm, objName, connectionObject);

			//System.out.println( "subFormsMap"+ subFormsMap +"]" );
			Iterator itrt= subFormsMap.entrySet().iterator();
			String subFormDetails = "";
			while(itrt.hasNext())
			{
				Map.Entry en = (Map.Entry) itrt.next();
				formNo =   (String) en.getKey();
				String subformNa =  (String)en.getValue();
				if(subFormDetails == null || subFormDetails.trim().length() == 0)
				{
					subFormDetails = subformNa;
				}
				else
				{
					subFormDetails = subFormDetails + "," + subformNa;
				}
			}
			//System.out.println( "subFormDetails"+ subFormDetails  );

			if(flag)
			{
				System.out.println("Inside Predom exist Flag is True");
				//System.out.println("temp["+new ArrayList<String>(Arrays.asList(temp))+"]");
				//Commented and added by kailash on 28-09-18[start]
				//preFormDet = getPrevFormCustValues( dom2, currentForm, new ArrayList<String>(Arrays.asList(temp)), "locality_code", connectionObject);
				preFormDet = getPrevFormCustValues( dom2, currentForm, new ArrayList<String>(Arrays.asList(temp)), "locality_code", customerType,connectionObject);
				//preFormDet = getPrevFormCustValues( dom, currentForm, new ArrayList<String>(Arrays.asList(temp)), "locality_code", customerType,connectionObject);

				//Commented and added by kailash on 28-09-18[end]
				//TODO
				System.out.println( "preFormDet DAR::::::::::::::"+preFormDet);

				if(preFormDet != null && preFormDet.trim().length() > 0)
				{
					String actCodePreDom = getSelectedRowValue(  genericUtility.parseString("<Root>"+preFormDet+"</Root>"), currentForm, "event_type", 0);
					String actTypePreDom = getActivityType( actCodePreDom, connectionObject );

					Document preFormDom =  genericUtility.parseString("<Root>"+preFormDet+"</Root>");
					NodeList preDomList = preFormDom.getElementsByTagName("Detail" + currentForm);
					for (int prntCtr = 0; prntCtr < preDomList.getLength(); prntCtr++ )
					{
						srNo++;
						String locDescr ="";
						String localityCode = getSelectedRowValue( preFormDom, currentForm,  "locality_code", prntCtr );
						sql = "SELECT DESCR FROM LOCALITY WHERE LOCALITY_CODE = ?";
						pstmt =  connectionObject.prepareStatement(sql);
						pstmt.setString(1, localityCode);
						rs = pstmt.executeQuery();
						if( rs.next())
						{
							locDescr = rs.getString("DESCR");

						}
						if (rs!= null)
						{
							rs.close();
							rs = null;
						}
						if(pstmt!=null)
						{
							pstmt.close();
							pstmt = null;
						}
						//Added By Mrunalini SInakr to draw one unlisetd feed for sun migration(start)
						String customerTypes = getSelectedRowValue( preFormDom, currentForm,  "cust_type", prntCtr );
						System.out.println("customerType in preDOM Of DAR is:["+customerTypes+"]customerType.contains UNLISTED["+customerTypes.contains("UNLISTED")+"]");
						if(customerTypes!=null && customerTypes.contains("UNLISTED"))
						{
							System.out.println("in case if customer type contian unlisted DAR");
							unlistSun=true;
						}
						else
						{
							unlistSun=false;
						}
						//Added By Mrunalini SInakr to draw one unlisetd feed for sun migration(end)
						//System.out.println(" locality descr ["+locDescr+"]");
						Element element = (Element) preFormDom.getElementsByTagName("Detail"+currentForm).item(prntCtr);
						element.appendChild(preFormDom.createElement("activity_type"));
						preFormDom.getElementsByTagName("activity_type").item(prntCtr).appendChild( preFormDom.createCDATASection( actTypePreDom ) );
						String custCode = getSelectedRowValue( preFormDom, currentForm,  "strg_code", prntCtr );
						pstmtCheckStrgMeet.setTimestamp(1, java.sql.Timestamp.valueOf(trvDBDate));
						pstmtCheckStrgMeet.setString(2, userId);
						pstmtCheckStrgMeet.setString(3, custCode);
						ResultSet rsCheckStrgMeet = pstmtCheckStrgMeet.executeQuery();
						if(rsCheckStrgMeet.next())
						{
							strgMeetCount = rsCheckStrgMeet.getInt("COUNT");
						}
						pstmtCheckStrgMeet.clearParameters();
						rsCheckStrgMeet.close(); rsCheckStrgMeet = null;
						if(strgMeetCount > 0 )
						{
							element.appendChild(preFormDom.createElement("to_disable"));
							preFormDom.getElementsByTagName("to_disable").item(prntCtr).appendChild( preFormDom.createCDATASection( "Y" ) );
						}
						else
						{
							element.appendChild(preFormDom.createElement("to_disable"));
							preFormDom.getElementsByTagName("to_disable").item(prntCtr).appendChild( preFormDom.createCDATASection( "N" ) );
						}
						element.appendChild(preFormDom.createElement("sr_no"));
						preFormDom.getElementsByTagName("sr_no").item(prntCtr).appendChild( preFormDom.createCDATASection( ""+srNo ) );
					}
					if( pstmtCheckStrgMeet != null )
					{
						pstmtCheckStrgMeet.close(); pstmtCheckStrgMeet = null;
					}
					preFormDet = genericUtility.serializeDom( preFormDom );
					System.out.println("preFormDet123:--- "+preFormDet);
					if( preFormDet != null || !"null".equalsIgnoreCase(preFormDet))
					{
						if ( actType.equalsIgnoreCase( actTypePreDom ) )
						{
							String preDomLocality = getLocFromDom( genericUtility.parseString("<Root>" + preFormDet + "</Root>"), currentForm, sprsCode,connectionObject ); //Chnaged by sachin satre on 11-nov-16
							list = new ArrayList<String>( Arrays.asList( temp ) );
							list.removeAll( Arrays.asList( preDomLocality.split(",") ) );
							temp = list.toArray(new String[0]);
							customers = getCustFromDom( genericUtility.parseString("<Root>" + preFormDet + "</Root>"), currentForm, sprsCode , "Y",connectionObject); //Chnaged by sachin satre on 11-nov-16
							System.out.println("preFormDet121:-"+preFormDet);
							preFormDet = preFormDet.replace("<Root>", "");
							preFormDet = preFormDet.replace("</Root>", "");
							valueXmlString.append( preFormDet );
							//System.out.println("valueXmlString 123k "+valueXmlString);
						}
					}
				}
			}
			else
			{
				sql = "SELECT COUNT(*) FROM STRG_MEET WHERE SALES_PERS = ? AND EVENT_DATE = ?";
				pstmt =  connectionObject.prepareStatement( sql );
				pstmt.setString(1, sprsCode);
				pstmt.setTimestamp( 2, java.sql.Timestamp.valueOf( trvDBDate ) );
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					rowsRS = rs.getInt(1);
				}
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				if ( locality == null || locality.trim().length() == 0 )
				{
					locality = "''";
				}
				if ( routeId == null || routeId.trim().length() == 0 )
				{
					routeId = "''";
				}
				/*Added By Shahu for DB2 Start*/

				if(!"Y".equalsIgnoreCase(isMemberPresent))
				{
					if (custType.equalsIgnoreCase("O"))
					{
						/*sqlEdit="SELECT STRG_MEET.*,LOCALITY.DESCR LOC_DESCR,FIELDACTIVITY.ACTIVITY_TYPE ACT_TYPE,"+
								"   UPPER(STRG_CUSTOMER.FIRST_NAME)||' '||UPPER(STRG_CUSTOMER.LAST_NAME) AS SC_NAME,"+
								"STRG_CUSTOMER.ADDR1,STRG_CUSTOMER.ADDR2,STRG_CUSTOMER.ADDR3  "+
								" FROM LOCALITY , FIELDACTIVITY,STRG_MEET LEFT OUTER JOIN STRG_CUSTOMER ON STRG_MEET.STRG_CODE = STRG_CUSTOMER.SC_CODE "+
								"  WHERE STRG_MEET.EVENT_TYPE =FIELDACTIVITY.ACTIVITY_CODE"+
								" AND STRG_MEET.LOCALITY_CODE = LOCALITY.LOCALITY_CODE "+
								" AND STRG_MEET.SALES_PERS = ? "+
								" AND STRG_MEET.EVENT_DATE = ? "+
								" AND STRG_MEET.STRG_CODE IN "+
								" ( SELECT SC_CODE  FROM STRG_STATUS_HIST "+
								"    WHERE STRG_STATUS_HIST .EFF_FROM<= ?  "+
								"    AND STRG_STATUS_HIST .VALID_UPTO >= ?"+
								"    AND STRG_CUSTOMER.CUST_TYPE NOT IN ('D','C','S') " +
								"    AND STRG_STATUS_HIST.SALES_PERS = STRG_MEET.SALES_PERS  ) AND STRG_MEET.EVENT_TYPE <> 'PR' AND STRG_MEET.LOCALITY_CODE IN ("+locality+")" +
								" ORDER BY STRG_MEET.SHORT_ID ";*/
						/*sqlEdit="SELECT STRG_MEET.*,LOCALITY.DESCR LOC_DESCR,FIELDACTIVITY.ACTIVITY_TYPE ACT_TYPE,"+
								"   UPPER(STRG_CUSTOMER.FIRST_NAME)||' '||UPPER(STRG_CUSTOMER.LAST_NAME) AS SC_NAME,SCT.DESCR AS CUST_TYPE_DESCR "+
								" FROM LOCALITY , FIELDACTIVITY,STRG_MEET LEFT OUTER JOIN STRG_CUSTOMER ON STRG_MEET.STRG_CODE = STRG_CUSTOMER.SC_CODE, "+
								" STRG_CUST_TYPE SCT WHERE STRG_MEET.EVENT_TYPE =FIELDACTIVITY.ACTIVITY_CODE"+
								" AND STRG_MEET.LOCALITY_CODE = LOCALITY.LOCALITY_CODE "+
								" AND STRG_MEET.SALES_PERS = ? "+
								" AND STRG_MEET.EVENT_DATE = ? "+
								" AND SCT.TYPE=STRG_CUSTOMER.CUST_TYPE"+
								" AND STRG_MEET.STRG_CODE IN "+
								" ( SELECT SC_CODE  FROM STRG_STATUS_HIST "+
								"    WHERE STRG_STATUS_HIST .EFF_FROM<= ?  "+
								"    AND STRG_STATUS_HIST .VALID_UPTO >= ?"+
								"    AND SCT.DCR_GROUP NOT IN ('D','C','S') " +
								"    AND STRG_STATUS_HIST.SALES_PERS = STRG_MEET.SALES_PERS  ) AND STRG_MEET.EVENT_TYPE <> 'PR' AND STRG_MEET.LOCALITY_CODE IN ("+locality+")" +
								" UNION ALL "+
								" SELECT STRG_MEET.*,LOCALITY.DESCR LOC_DESCR,FIELDACTIVITY.ACTIVITY_TYPE ACT_TYPE,STRG_CUST_ADD.STRG_NAME AS SC_NAME,SCT.DESCR AS CUST_TYPE_DESCR "+
								" FROM LOCALITY,FIELDACTIVITY,STRG_MEET LEFT OUTER JOIN STRG_CUST_ADD ON STRG_MEET.STRG_CODE = STRG_CUST_ADD.STRG_CODE,STRG_CUST_TYPE SCT  "+
								" WHERE STRG_MEET.EVENT_TYPE =FIELDACTIVITY.ACTIVITY_CODE "+
								" AND STRG_MEET.LOCALITY_CODE = LOCALITY.LOCALITY_CODE "
								+ " AND SCT.TYPE=STRG_CUST_ADD.STRG_TYPE "+
								" AND SCT.DCR_GROUP NOT IN ('D','C','S') " +
								" AND STRG_MEET.SALES_PERS = ? "+
								" AND STRG_MEET.SALES_PERS=STRG_CUST_ADD.SALES_PERS "+
								" AND STRG_MEET.EVENT_DATE = ? "+
								" AND STRG_CUST_ADD.EVENT_DATE = ? "+
								" AND STRG_MEET.EVENT_TYPE <> 'PR' "+
								//" AND STRG_MEET.LOCALITY_CODE IN ("+locality+")"+ //commented by kailash on 24-09-18.
								" AND STRG_MEET.LOCALITY_CODE IN ("+selLocality+")"+ //Changed by kailash for unlisted case localtiy code get from place screen.
								" ORDER BY SC_NAME ";//changed by Ashutosh -26-Dec-17*/
						sqlEdit="SELECT STRG_MEET.*,(CASE WHEN SR.ROUTE_DESCR IS NOT NULL THEN SR.ROUTE_DESCR ELSE SR.DESCR END ) LOC_DESCR,FIELDACTIVITY.ACTIVITY_TYPE ACT_TYPE,"+
								" UPPER(STRG_CUSTOMER.FIRST_NAME)||' '||UPPER(STRG_CUSTOMER.MIDDLE_NAME)||' '||UPPER(STRG_CUSTOMER.LAST_NAME) AS SC_NAME,SCT.DESCR AS CUST_TYPE_DESCR " +
								" ,SCS.SUBCLASS_DESCR,SCC.CLASS_CODE_DESCR,SCT.DCR_GROUP AS DCR_GROUP, "+
								" (CASE WHEN SCT.SURVEY_TEMPL IS NULL THEN '"+sfaParmVal+"' ELSE SCT.SURVEY_TEMPL END) AS SURVEY_TEMPL" + //added by shrradhda M for SURVEY_TEMPL mising in select [19-mar-2021]
								" ,STRG_CUSTOMER.QUALIFICATION AS QUALIFICATION,STRG_CUSTOMER.GST_NO AS STRG_GST_NO,STATE.DESCR AS STRG_STATE "+  // added by shweta for displaying reg_no
								" FROM LOCALITY , FIELDACTIVITY,STRG_MEET LEFT OUTER JOIN STRG_CUSTOMER ON STRG_MEET.STRG_CODE = STRG_CUSTOMER.SC_CODE " +
								" LEFT OUTER JOIN STRG_CUST_CLASS SCC  ON STRG_CUSTOMER.CUST_TYPE = SCC.CUST_TYPE AND STRG_CUSTOMER.CLASS_CODE= SCC.CLASS_CODE "+
								" LEFT OUTER JOIN STRG_CUST_SUBCLASS SCS  ON STRG_CUSTOMER.CUST_TYPE = SCS.CUST_TYPE AND STRG_CUSTOMER.CLASS_CODE= SCS.CLASS_CODE "+
								" LEFT OUTER JOIN STATE ON STRG_CUSTOMER.STATE_CODE = STATE.STATE_CODE," +
								" STRG_CUST_TYPE SCT,SPRS_ROUTE SR WHERE STRG_MEET.EVENT_TYPE =FIELDACTIVITY.ACTIVITY_CODE"+
								" AND STRG_MEET.LOCALITY_CODE = LOCALITY.LOCALITY_CODE AND SR.LOCALITY_CODE = LOCALITY.LOCALITY_CODE AND SR.SPRS_CODE=STRG_MEET.SALES_PERS AND SR.ROUTE_ID=STRG_MEET.ROUTE_ID "+
								" AND STRG_MEET.SALES_PERS = ? "+
								" AND STRG_MEET.EVENT_DATE = ? "+
								" AND SCT.TYPE=STRG_CUSTOMER.CUST_TYPE "+
								" AND SCT.DCR_GROUP NOT IN ('D','C','S') "+
								//Comment and  Added by mrunalini sinkar to remove status hist condition from edit mode13-02-2020(start)
								/*" AND STRG_MEET.STRG_CODE IN "+
								" ( SELECT SC_CODE  FROM STRG_STATUS_HIST "+
								"    WHERE STRG_STATUS_HIST .EFF_FROM<= ?  "+
								"    AND STRG_STATUS_HIST .VALID_UPTO >= ?"+
								"    AND SCT.DCR_GROUP NOT IN ('D','C','S') " +
								"    AND STRG_STATUS_HIST.SALES_PERS = STRG_MEET.SALES_PERS  ) "+*/
								//Comment and  Added by mrunalini sinkar to remove status hist condition from edit mode13-02-2020(end)
								" AND STRG_MEET.EVENT_TYPE <> 'PR' AND STRG_MEET.LOCALITY_CODE IN ("+locality+") AND STRG_MEET.ROUTE_ID IN("+routeId+")" +
								" UNION ALL "+
								" SELECT STRG_MEET.*,(CASE WHEN SR.ROUTE_DESCR IS NOT NULL THEN SR.ROUTE_DESCR ELSE SR.DESCR END ) LOC_DESCR,FIELDACTIVITY.ACTIVITY_TYPE ACT_TYPE,STRG_CUST_ADD.STRG_NAME AS SC_NAME,SCT.DESCR AS CUST_TYPE_DESCR " +
								" ,SCS.SUBCLASS_DESCR,SCC.CLASS_CODE_DESCR,SCT.DCR_GROUP AS DCR_GROUP, (CASE WHEN SCT.SURVEY_TEMPL IS NULL THEN '"+sfaParmVal+"' ELSE SCT.SURVEY_TEMPL END) AS SURVEY_TEMPL " + //added by shradhda M for SURVEY_TEMPL mising in select [24-mar-2021]
								" ,'' AS QUALIFICATION,'' AS STRG_GST_NO,'' AS STRG_STATE  "+   // added by shweta m  for registration value //added by shweta for registration value 21-05-21
								" FROM LOCALITY,FIELDACTIVITY,STRG_MEET LEFT OUTER JOIN STRG_CUST_ADD ON STRG_MEET.STRG_CODE = STRG_CUST_ADD.STRG_CODE" +
								" LEFT OUTER JOIN STRG_CUST_CLASS SCC  ON STRG_CUST_ADD.STRG_TYPE = SCC.CUST_TYPE AND STRG_CUST_ADD.STRG_CLASS_CODE= SCC.CLASS_CODE " +
								" LEFT OUTER JOIN STRG_CUST_SUBCLASS SCS  ON STRG_CUST_ADD.STRG_TYPE = SCS.CUST_TYPE AND STRG_CUST_ADD.STRG_CLASS_CODE= SCS.CLASS_CODE, " +
								" STRG_CUST_TYPE SCT,SPRS_ROUTE SR "+
								" WHERE STRG_MEET.EVENT_TYPE =FIELDACTIVITY.ACTIVITY_CODE "+
								" AND STRG_MEET.LOCALITY_CODE = LOCALITY.LOCALITY_CODE AND SR.LOCALITY_CODE = LOCALITY.LOCALITY_CODE AND SR.SPRS_CODE=STRG_MEET.SALES_PERS  AND SR.ROUTE_ID=STRG_MEET.ROUTE_ID  "+
								" AND SCT.TYPE=STRG_CUST_ADD.STRG_TYPE "+
								" AND SCT.DCR_GROUP NOT IN ('D','C','S') " +
								" AND STRG_MEET.SALES_PERS = ? "+
								" AND STRG_MEET.SALES_PERS=STRG_CUST_ADD.SALES_PERS "+
								" AND STRG_MEET.EVENT_DATE = ? "+
								" AND STRG_CUST_ADD.EVENT_DATE = ? "+
								" AND STRG_MEET.EVENT_TYPE <> 'PR' "+
								//" AND STRG_MEET.LOCALITY_CODE IN ("+locality+")"+ //commented by kailash on 24-09-18.
								" AND STRG_MEET.LOCALITY_CODE IN ("+selLocality+") AND STRG_MEET.ROUTE_ID IN("+selRouteId+")"+ //Changed by kailash for unlisted case localtiy code get from place screen.
								" ORDER BY LOC_DESCR,SC_NAME ";//changed by Ashutosh -26-Dec-17

					}
					else if (custType.equalsIgnoreCase("S") && stockistTable.equalsIgnoreCase("SPRS_STOCKIST"))
					{
						sqlEdit = "SELECT STRG_MEET.*,(CASE WHEN SR.ROUTE_DESCR IS NOT NULL THEN SR.ROUTE_DESCR ELSE SR.DESCR END ) LOC_DESCR,FIELDACTIVITY.ACTIVITY_TYPE ACT_TYPE, "+
								"CUSTOMER.CUST_NAME AS SC_NAME, SCT.DESCR AS CUST_TYPE_DESCR ,SCT.DCR_GROUP AS DCR_GROUP,(CASE WHEN SCT.SURVEY_TEMPL IS NULL THEN '"+sfaParmVal+"' "+
								"ELSE SCT.SURVEY_TEMPL END) AS SURVEY_TEMPL, '' AS SUBCLASS_DESCR,'' AS CLASS_CODE_DESCR "+
								",'' AS QUALIFICATION,'' AS STRG_GST_NO,'' AS STRG_STATE  "+            //added by shweta m for registration value //added by shweta for registration value 21-05-21
								"FROM LOCALITY, FIELDACTIVITY, STRG_MEET LEFT OUTER JOIN CUSTOMER ON STRG_MEET.STRG_CODE = CUSTOMER.CUST_CODE ,STRG_CUST_TYPE SCT,SPRS_ROUTE SR "+
								"WHERE STRG_MEET.EVENT_TYPE = FIELDACTIVITY.ACTIVITY_CODE AND STRG_MEET.LOCALITY_CODE = LOCALITY.LOCALITY_CODE "+
								"AND SR.LOCALITY_CODE = LOCALITY.LOCALITY_CODE AND SR.SPRS_CODE = STRG_MEET.SALES_PERS  AND SR.ROUTE_ID = STRG_MEET.ROUTE_ID "+
								"AND STRG_MEET.SALES_PERS = ? AND STRG_MEET.EVENT_DATE = ? AND SCT.TYPE = CUSTOMER.CUST_TYPE AND SCT.DCR_GROUP = 'S' "+
								"AND STRG_MEET.EVENT_TYPE <> 'PR' AND STRG_MEET.LOCALITY_CODE IN ("+locality+") AND STRG_MEET.ROUTE_ID IN("+routeId+") "+
								"UNION ALL "+
								"SELECT STRG_MEET.*,(CASE WHEN SR.ROUTE_DESCR IS NOT NULL THEN SR.ROUTE_DESCR ELSE SR.DESCR END ) LOC_DESCR, FIELDACTIVITY.ACTIVITY_TYPE ACT_TYPE, "+
								"STRG_CUST_ADD.STRG_NAME AS SC_NAME,SCT.DESCR AS CUST_TYPE_DESCR ,SCT.DCR_GROUP AS DCR_GROUP,(CASE WHEN SCT.SURVEY_TEMPL IS NULL "+
								"THEN '"+sfaParmVal+"' ELSE SCT.SURVEY_TEMPL END) AS SURVEY_TEMPL, SCS.SUBCLASS_DESCR, SCC.CLASS_CODE_DESCR "+
								",'' AS QUALIFICATION,'' AS STRG_GST_NO,'' AS STRG_STATE "+            //added by shweta m for registration //added by shweta for registration value 21-05-21
								"FROM LOCALITY, FIELDACTIVITY, STRG_MEET LEFT OUTER JOIN STRG_CUST_ADD ON STRG_MEET.STRG_CODE = STRG_CUST_ADD.STRG_CODE "+
								"LEFT OUTER JOIN STRG_CUST_CLASS SCC  ON STRG_CUST_ADD.STRG_TYPE = SCC.CUST_TYPE AND STRG_CUST_ADD.STRG_CLASS_CODE= SCC.CLASS_CODE "+
								
								"LEFT OUTER JOIN STRG_CUST_SUBCLASS SCS  ON STRG_CUST_ADD.STRG_TYPE = SCS.CUST_TYPE AND STRG_CUST_ADD.STRG_CLASS_CODE= SCS.CLASS_CODE, STRG_CUST_TYPE SCT,SPRS_ROUTE SR "+
								"WHERE STRG_MEET.EVENT_TYPE = FIELDACTIVITY.ACTIVITY_CODE AND STRG_MEET.LOCALITY_CODE = LOCALITY.LOCALITY_CODE AND SR.LOCALITY_CODE = LOCALITY.LOCALITY_CODE "+
								"AND SR.SPRS_CODE=STRG_MEET.SALES_PERS  AND SR.ROUTE_ID = STRG_MEET.ROUTE_ID AND SCT.TYPE = STRG_CUST_ADD.STRG_TYPE AND SCT.DCR_GROUP = 'S' "+
								"AND STRG_MEET.SALES_PERS = ? AND STRG_MEET.SALES_PERS = STRG_CUST_ADD.SALES_PERS AND STRG_MEET.EVENT_DATE = ? AND STRG_CUST_ADD.EVENT_DATE = ? "+
								"AND STRG_MEET.EVENT_TYPE <> 'PR' AND STRG_MEET.LOCALITY_CODE IN ("+locality+") AND STRG_MEET.ROUTE_ID IN("+routeId+") ORDER BY LOC_DESCR,SC_NAME ";
					}

					else
					{
						/*sqlEdit="SELECT STRG_MEET.*,LOCALITY.DESCR LOC_DESCR,FIELDACTIVITY.ACTIVITY_TYPE ACT_TYPE,"+
							"   UPPER(STRG_CUSTOMER.FIRST_NAME)||' '||UPPER(STRG_CUSTOMER.LAST_NAME) AS SC_NAME,"+
							"STRG_CUSTOMER.ADDR1,STRG_CUSTOMER.ADDR2,STRG_CUSTOMER.ADDR3  "+
							" FROM LOCALITY , FIELDACTIVITY,STRG_MEET LEFT OUTER JOIN STRG_CUSTOMER ON STRG_MEET.STRG_CODE = STRG_CUSTOMER.SC_CODE "+
							"  WHERE STRG_MEET.EVENT_TYPE =FIELDACTIVITY.ACTIVITY_CODE"+
							" AND STRG_MEET.LOCALITY_CODE = LOCALITY.LOCALITY_CODE "+
							" AND STRG_MEET.SALES_PERS = ? "+
							" AND STRG_MEET.EVENT_DATE = ? "+
							" AND STRG_MEET.STRG_CODE IN "+
							" ( SELECT SC_CODE  FROM STRG_STATUS_HIST "+
							"    WHERE STRG_STATUS_HIST .EFF_FROM<= ?  "+
							"    AND STRG_STATUS_HIST .VALID_UPTO >= ?"+
							"    AND STRG_CUSTOMER.CUST_TYPE = ? " +
							"    AND STRG_STATUS_HIST.SALES_PERS = STRG_MEET.SALES_PERS  ) AND STRG_MEET.EVENT_TYPE <> 'PR' AND STRG_MEET.LOCALITY_CODE IN ("+locality+")" +
							" ORDER BY STRG_MEET.SHORT_ID ";*/

						/*sqlEdit="SELECT STRG_MEET.*,LOCALITY.DESCR LOC_DESCR,FIELDACTIVITY.ACTIVITY_TYPE ACT_TYPE,"+
								"   UPPER(STRG_CUSTOMER.FIRST_NAME)||' '||UPPER(STRG_CUSTOMER.LAST_NAME) AS SC_NAME,SCT.DESCR AS CUST_TYPE_DESCR "+
								" FROM LOCALITY , FIELDACTIVITY,STRG_MEET LEFT OUTER JOIN STRG_CUSTOMER ON STRG_MEET.STRG_CODE = STRG_CUSTOMER.SC_CODE, "+
								"  STRG_CUST_TYPE SCT WHERE STRG_MEET.EVENT_TYPE =FIELDACTIVITY.ACTIVITY_CODE"+
								" AND STRG_MEET.LOCALITY_CODE = LOCALITY.LOCALITY_CODE "+
								" AND STRG_MEET.SALES_PERS = ? "+
								" AND STRG_MEET.EVENT_DATE = ? "+
								" AND SCT.TYPE=STRG_CUSTOMER.CUST_TYPE "+ // added by mrunalini s. for dcr_group changes  on 03-dec-2018
								" AND STRG_MEET.STRG_CODE IN "+
								" ( SELECT SC_CODE  FROM STRG_STATUS_HIST "+
								"    WHERE STRG_STATUS_HIST .EFF_FROM<= ?  "+
								"    AND STRG_STATUS_HIST .VALID_UPTO >= ?"+
								//"    AND STRG_CUSTOMER.CUST_TYPE = ? " +  // commented & added by mrunalini s. for dcr_group changes  on 03-dec-2018
								"    AND SCT.DCR_GROUP = ? " +
								"    AND STRG_STATUS_HIST.SALES_PERS = STRG_MEET.SALES_PERS  ) AND STRG_MEET.EVENT_TYPE <> 'PR' AND STRG_MEET.LOCALITY_CODE IN ("+locality+")" +
								" UNION ALL "+
								" SELECT STRG_MEET.*,LOCALITY.DESCR LOC_DESCR,FIELDACTIVITY.ACTIVITY_TYPE ACT_TYPE,STRG_CUST_ADD.STRG_NAME AS SC_NAME,SCT.DESCR AS CUST_TYPE_DESCR "+
								" FROM LOCALITY,FIELDACTIVITY,STRG_MEET LEFT OUTER JOIN STRG_CUST_ADD ON STRG_MEET.STRG_CODE = STRG_CUST_ADD.STRG_CODE,  "+
								" STRG_CUST_TYPE SCT WHERE STRG_MEET.EVENT_TYPE =FIELDACTIVITY.ACTIVITY_CODE "+
								" AND STRG_MEET.LOCALITY_CODE = LOCALITY.LOCALITY_CODE "+
								" AND SCT.TYPE=STRG_CUST_ADD.STRG_TYPE "+ // added by mrunalini s. for dcr_group changes  on 03-dec-2018
								//" AND STRG_CUST_ADD.STRG_TYPE = ?" + // commented & added by mrunalini s. for dcr_group changes  on 03-dec-2018
								" AND SCT.DCR_GROUP = ? " +
								" AND STRG_MEET.SALES_PERS = ? "+
								" AND STRG_MEET.SALES_PERS=STRG_CUST_ADD.SALES_PERS "+
								" AND STRG_MEET.EVENT_DATE = ? "+
								" AND STRG_CUST_ADD.EVENT_DATE = ? "+
								" AND STRG_MEET.EVENT_TYPE <> 'PR' "+
								//" AND STRG_MEET.LOCALITY_CODE IN ("+locality+")"+ //commented by kailash on 24-09-18.
								" AND STRG_MEET.LOCALITY_CODE IN ("+selLocality+")"+ //Changed by kailash for unlisted case localtiy code get from place screen.
								"ORDER BY SC_NAME"; //changed by Ashutosh -26-Dec-17 */

						/*sqlEdit="SELECT STRG_MEET.*,LOCALITY.DESCR LOC_DESCR,FIELDACTIVITY.ACTIVITY_TYPE ACT_TYPE,"+
								"   UPPER(STRG_CUSTOMER.FIRST_NAME)||' '||UPPER(STRG_CUSTOMER.LAST_NAME) AS SC_NAME,SCT.DESCR AS CUST_TYPE_DESCR "+
								" ,SCS.SUBCLASS_DESCR,SCC.CLASS_CODE_DESCR,SCT.DCR_GROUP AS DCR_GROUP "+
								" FROM LOCALITY , FIELDACTIVITY,STRG_MEET LEFT OUTER JOIN STRG_CUSTOMER ON STRG_MEET.STRG_CODE = STRG_CUSTOMER.SC_CODE "+
								" LEFT OUTER JOIN STRG_CUST_CLASS SCC  ON STRG_CUSTOMER.CUST_TYPE = SCC.CUST_TYPE AND STRG_CUSTOMER.CLASS_CODE= SCC.CLASS_CODE "+
								" LEFT OUTER JOIN STRG_CUST_SUBCLASS SCS  ON STRG_CUSTOMER.CUST_TYPE = SCS.CUST_TYPE AND STRG_CUSTOMER.CLASS_CODE= SCS.CLASS_CODE, "+
								" STRG_CUST_TYPE SCT WHERE STRG_MEET.EVENT_TYPE =FIELDACTIVITY.ACTIVITY_CODE"+
								" AND STRG_MEET.LOCALITY_CODE = LOCALITY.LOCALITY_CODE "+
								" AND STRG_MEET.SALES_PERS = ? "+
								" AND STRG_MEET.EVENT_DATE = ? "+
								" AND SCT.TYPE=STRG_CUSTOMER.CUST_TYPE "+ // added by mrunalini s. for dcr_group changes  on 03-dec-2018
								" AND STRG_MEET.STRG_CODE IN "+
								" ( SELECT SC_CODE  FROM STRG_STATUS_HIST "+
								"    WHERE STRG_STATUS_HIST .EFF_FROM<= ?  "+
								"    AND STRG_STATUS_HIST .VALID_UPTO >= ?"+
								//"    AND STRG_CUSTOMER.CUST_TYPE = ? " +  // commented & added by mrunalini s. for dcr_group changes  on 03-dec-2018
								"    AND SCT.DCR_GROUP = ? " +
								"    AND STRG_STATUS_HIST.SALES_PERS = STRG_MEET.SALES_PERS  ) AND STRG_MEET.EVENT_TYPE <> 'PR' AND STRG_MEET.LOCALITY_CODE IN ("+locality+")" +
								" UNION ALL "+
								" SELECT STRG_MEET.*,LOCALITY.DESCR LOC_DESCR,FIELDACTIVITY.ACTIVITY_TYPE ACT_TYPE,STRG_CUST_ADD.STRG_NAME AS SC_NAME,SCT.DESCR AS CUST_TYPE_DESCR " +
								" ,SCS.SUBCLASS_DESCR,SCC.CLASS_CODE_DESCR,SCT.DCR_GROUP AS DCR_GROUP "+
								" FROM LOCALITY,FIELDACTIVITY,STRG_MEET LEFT OUTER JOIN STRG_CUST_ADD ON STRG_MEET.STRG_CODE = STRG_CUST_ADD.STRG_CODE  "+
								" LEFT OUTER JOIN STRG_CUST_CLASS SCC  ON STRG_CUST_ADD.STRG_TYPE = SCC.CUST_TYPE AND STRG_CUST_ADD.STRG_CLASS_CODE= SCC.CLASS_CODE "+
								" LEFT OUTER JOIN STRG_CUST_SUBCLASS SCS  ON STRG_CUST_ADD.STRG_TYPE = SCS.CUST_TYPE AND STRG_CUST_ADD.STRG_CLASS_CODE= SCS.CLASS_CODE, "+
								" STRG_CUST_TYPE SCT WHERE STRG_MEET.EVENT_TYPE =FIELDACTIVITY.ACTIVITY_CODE "+
								" AND STRG_MEET.LOCALITY_CODE = LOCALITY.LOCALITY_CODE "+
								" AND SCT.TYPE=STRG_CUST_ADD.STRG_TYPE "+ // added by mrunalini s. for dcr_group changes  on 03-dec-2018
								//" AND STRG_CUST_ADD.STRG_TYPE = ?" + // commented & added by mrunalini s. for dcr_group changes  on 03-dec-2018
								" AND SCT.DCR_GROUP = ? " +
								" AND STRG_MEET.SALES_PERS = ? "+
								" AND STRG_MEET.SALES_PERS=STRG_CUST_ADD.SALES_PERS "+
								" AND STRG_MEET.EVENT_DATE = ? "+
								" AND STRG_CUST_ADD.EVENT_DATE = ? "+
								" AND STRG_MEET.EVENT_TYPE <> 'PR' "+
								//" AND STRG_MEET.LOCALITY_CODE IN ("+locality+")"+ //commented by kailash on 24-09-18.
								" AND STRG_MEET.LOCALITY_CODE IN ("+selLocality+")"+ //Changed by kailash for unlisted case localtiy code get from place screen.
								"ORDER BY SC_NAME"; //changed by Ashutosh -26-Dec-17*/
						//Changed by Pooja S on 27-JULY-2020 [Customerwise template display form realted implementation]
						sqlEdit="SELECT STRG_MEET.*,(CASE WHEN SR.ROUTE_DESCR IS NOT NULL THEN SR.ROUTE_DESCR ELSE SR.DESCR END ) LOC_DESCR,FIELDACTIVITY.ACTIVITY_TYPE ACT_TYPE,"+
								"   UPPER(STRG_CUSTOMER.FIRST_NAME)||' '||UPPER(STRG_CUSTOMER.MIDDLE_NAME)||' '||UPPER(STRG_CUSTOMER.LAST_NAME) AS SC_NAME,SCT.DESCR AS CUST_TYPE_DESCR "+
								" ,SCS.SUBCLASS_DESCR,SCC.CLASS_CODE_DESCR,SCT.DCR_GROUP AS DCR_GROUP,(case when STRG_CUSTOMER.SURVEY_TEMPL is null then (CASE WHEN SCT.SURVEY_TEMPL IS NULL THEN '"+sfaParmVal+"' ELSE SCT.SURVEY_TEMPL END) else STRG_CUSTOMER.SURVEY_TEMPL END) AS SURVEY_TEMPL "+
								" ,STRG_CUSTOMER.QUALIFICATION AS QUALIFICATION,STRG_CUSTOMER.GST_NO AS STRG_GST_NO,STATE.DESCR AS STRG_STATE  "+        // added by shweta for registartion value //added by shweta for registration value 21-05-21
								" FROM LOCALITY , FIELDACTIVITY,STRG_MEET LEFT OUTER JOIN STRG_CUSTOMER ON STRG_MEET.STRG_CODE = STRG_CUSTOMER.SC_CODE "+
								" LEFT OUTER JOIN STRG_CUST_CLASS SCC  ON STRG_CUSTOMER.CUST_TYPE = SCC.CUST_TYPE AND STRG_CUSTOMER.CLASS_CODE= SCC.CLASS_CODE "+
								" LEFT OUTER JOIN STRG_CUST_SUBCLASS SCS  ON STRG_CUSTOMER.CUST_TYPE = SCS.CUST_TYPE AND STRG_CUSTOMER.CLASS_CODE= SCS.CLASS_CODE "+
								" LEFT OUTER JOIN STATE ON STRG_CUSTOMER.STATE_CODE = STATE.STATE_CODE," +
								" STRG_CUST_TYPE SCT,SPRS_ROUTE SR WHERE STRG_MEET.EVENT_TYPE =FIELDACTIVITY.ACTIVITY_CODE"+
								" AND STRG_MEET.LOCALITY_CODE = LOCALITY.LOCALITY_CODE AND SR.LOCALITY_CODE = LOCALITY.LOCALITY_CODE AND SR.SPRS_CODE=STRG_MEET.SALES_PERS  AND SR.ROUTE_ID=STRG_MEET.ROUTE_ID "+
								" AND STRG_MEET.SALES_PERS = ? "+
								" AND STRG_MEET.EVENT_DATE = ? "+
								" AND SCT.TYPE=STRG_CUSTOMER.CUST_TYPE "+// added by mrunalini s. for dcr_group changes  on 03-dec-2018
								" AND SCT.DCR_GROUP = ? " +
								//Comment and  Added by mrunalini sinkar to remove status hist condition from edit mode13-02-2020(start)
								/*" AND STRG_MEET.STRG_CODE IN "+
								" ( SELECT SC_CODE  FROM STRG_STATUS_HIST "+
								"    WHERE STRG_STATUS_HIST .EFF_FROM<= ?  "+
								"    AND STRG_STATUS_HIST .VALID_UPTO >= ?"+
								//"    AND STRG_CUSTOMER.CUST_TYPE = ? " +  // commented & added by mrunalini s. for dcr_group changes  on 03-dec-2018
								"    AND SCT.DCR_GROUP = ? " +
								"    AND STRG_STATUS_HIST.SALES_PERS = STRG_MEET.SALES_PERS  ) "+*/
								//Comment and  Added by mrunalini sinkar to remove status hist condition from edit mode13-02-2020(end)

								" AND STRG_MEET.EVENT_TYPE <> 'PR' AND STRG_MEET.LOCALITY_CODE IN ("+locality+") AND STRG_MEET.ROUTE_ID IN("+routeId+") " +
								" UNION ALL "+
								" SELECT STRG_MEET.*,(CASE WHEN SR.ROUTE_DESCR IS NOT NULL THEN SR.ROUTE_DESCR ELSE SR.DESCR END ) LOC_DESCR,FIELDACTIVITY.ACTIVITY_TYPE ACT_TYPE,STRG_CUST_ADD.STRG_NAME AS SC_NAME,SCT.DESCR AS CUST_TYPE_DESCR " +
								" ,SCS.SUBCLASS_DESCR,SCC.CLASS_CODE_DESCR,SCT.DCR_GROUP AS DCR_GROUP,(CASE WHEN SCT.SURVEY_TEMPL IS NULL THEN '"+sfaParmVal+"' ELSE SCT.SURVEY_TEMPL END) AS SURVEY_TEMPL "+
								" ,'' AS QUALIFICATION,'' AS STRG_GST_NO,'' AS STRG_STATE  "+            //added by shweta m registration value  //added by shweta for registration value 21-05-21
								" FROM LOCALITY,FIELDACTIVITY,STRG_MEET LEFT OUTER JOIN STRG_CUST_ADD ON STRG_MEET.STRG_CODE = STRG_CUST_ADD.STRG_CODE  "+
								" LEFT OUTER JOIN STRG_CUST_CLASS SCC  ON STRG_CUST_ADD.STRG_TYPE = SCC.CUST_TYPE AND STRG_CUST_ADD.STRG_CLASS_CODE= SCC.CLASS_CODE "+
								" LEFT OUTER JOIN STRG_CUST_SUBCLASS SCS  ON STRG_CUST_ADD.STRG_TYPE = SCS.CUST_TYPE AND STRG_CUST_ADD.STRG_CLASS_CODE= SCS.CLASS_CODE, "+
								" STRG_CUST_TYPE SCT,SPRS_ROUTE SR  WHERE STRG_MEET.EVENT_TYPE =FIELDACTIVITY.ACTIVITY_CODE "+
								" AND STRG_MEET.LOCALITY_CODE = LOCALITY.LOCALITY_CODE AND SR.LOCALITY_CODE = LOCALITY.LOCALITY_CODE AND SR.SPRS_CODE=STRG_MEET.SALES_PERS  AND SR.ROUTE_ID=STRG_MEET.ROUTE_ID "+
								" AND SCT.TYPE=STRG_CUST_ADD.STRG_TYPE "+ // added by mrunalini s. for dcr_group changes  on 03-dec-2018
								//" AND STRG_CUST_ADD.STRG_TYPE = ?" + // commented & added by mrunalini s. for dcr_group changes  on 03-dec-2018
								" AND SCT.DCR_GROUP = ? " +
								" AND STRG_MEET.SALES_PERS = ? "+
								" AND STRG_MEET.SALES_PERS=STRG_CUST_ADD.SALES_PERS "+
								" AND STRG_MEET.EVENT_DATE = ? "+
								" AND STRG_CUST_ADD.EVENT_DATE = ? "+
								" AND STRG_MEET.EVENT_TYPE <> 'PR' "+
								//" AND STRG_MEET.LOCALITY_CODE IN ("+locality+")"+ //commented by kailash on 24-09-18.
								" AND STRG_MEET.LOCALITY_CODE IN ("+selLocality+") AND STRG_MEET.ROUTE_ID IN("+selRouteId+")"+ //Changed by kailash for unlisted case localtiy code get from place screen.
								"ORDER BY LOC_DESCR,SC_NAME"; //changed by Ashutosh -26-Dec-17

					}
				}
				else
				{
					if (custType.equalsIgnoreCase("O"))
					{
						/*sqlEdit="SELECT STRG_MEET.*,LOCALITY.DESCR LOC_DESCR,FIELDACTIVITY.ACTIVITY_TYPE ACT_TYPE,"+
								"   UPPER(STRG_CUSTOMER.FIRST_NAME)||' '||UPPER(STRG_CUSTOMER.LAST_NAME) AS SC_NAME,"+
								"STRG_CUSTOMER.ADDR1,STRG_CUSTOMER.ADDR2,STRG_CUSTOMER.ADDR3  "+
								" FROM LOCALITY , FIELDACTIVITY,STRG_MEET LEFT OUTER JOIN STRG_CUSTOMER ON STRG_MEET.STRG_CODE = STRG_CUSTOMER.SC_CODE "+
								"  WHERE STRG_MEET.EVENT_TYPE =FIELDACTIVITY.ACTIVITY_CODE"+
								" AND STRG_MEET.LOCALITY_CODE = LOCALITY.LOCALITY_CODE "+
								" AND STRG_MEET.SALES_PERS = ? "+
								" AND STRG_MEET.EVENT_DATE = ? "+
								" AND STRG_MEET.STRG_CODE IN "+
								" ( SELECT SC_CODE  FROM STRG_STATUS_HIST "+
								"    WHERE STRG_STATUS_HIST .EFF_FROM<= ?  "+
								"    AND STRG_STATUS_HIST .VALID_UPTO >= ?"+
								"    AND STRG_CUSTOMER.CUST_TYPE NOT IN ('D','C','S') " +
								"    AND STRG_STATUS_HIST.SALES_PERS = STRG_MEET.SALES_PERS  ) AND STRG_MEET.EVENT_TYPE <> 'PR' AND STRG_MEET.LOCALITY_CODE IN ("+locality+")" +
								" ORDER BY STRG_MEET.SHORT_ID ";*/
						/*sqlEdit="SELECT STRG_MEET.*,LOCALITY.DESCR LOC_DESCR,FIELDACTIVITY.ACTIVITY_TYPE ACT_TYPE,"+
								"   UPPER(STRG_CUSTOMER.FIRST_NAME)||' '||UPPER(STRG_CUSTOMER.LAST_NAME) AS SC_NAME,SCT.DESCR AS CUST_TYPE_DESCR "+
								" FROM LOCALITY , FIELDACTIVITY,STRG_MEET LEFT OUTER JOIN STRG_CUSTOMER ON STRG_MEET.STRG_CODE = STRG_CUSTOMER.SC_CODE, "+
								" STRG_CUST_TYPE SCT WHERE STRG_MEET.EVENT_TYPE =FIELDACTIVITY.ACTIVITY_CODE"+
								" AND STRG_MEET.LOCALITY_CODE = LOCALITY.LOCALITY_CODE "+
								" AND STRG_MEET.SALES_PERS = ? "+
								" AND STRG_MEET.EVENT_DATE = ? "+
								" AND SCT.TYPE=STRG_CUSTOMER.CUST_TYPE"+
								" AND STRG_MEET.STRG_CODE IN "+
								" ( SELECT SC_CODE  FROM STRG_STATUS_HIST "+
								"    WHERE STRG_STATUS_HIST .EFF_FROM<= ?  "+
								"    AND STRG_STATUS_HIST .VALID_UPTO >= ?"+
								"    AND SCT.DCR_GROUP NOT IN ('D','C','S') " +
								"    AND STRG_STATUS_HIST.SALES_PERS = STRG_MEET.SALES_PERS  ) AND STRG_MEET.EVENT_TYPE <> 'PR' AND STRG_MEET.LOCALITY_CODE IN ("+locality+")" +
								" UNION ALL "+
								" SELECT STRG_MEET.*,LOCALITY.DESCR LOC_DESCR,FIELDACTIVITY.ACTIVITY_TYPE ACT_TYPE,STRG_CUST_ADD.STRG_NAME AS SC_NAME,SCT.DESCR AS CUST_TYPE_DESCR "+
								" FROM LOCALITY,FIELDACTIVITY,STRG_MEET LEFT OUTER JOIN STRG_CUST_ADD ON STRG_MEET.STRG_CODE = STRG_CUST_ADD.STRG_CODE,STRG_CUST_TYPE SCT  "+
								" WHERE STRG_MEET.EVENT_TYPE =FIELDACTIVITY.ACTIVITY_CODE "+
								" AND STRG_MEET.LOCALITY_CODE = LOCALITY.LOCALITY_CODE "
								+ " AND SCT.TYPE=STRG_CUST_ADD.STRG_TYPE "+
								" AND SCT.DCR_GROUP NOT IN ('D','C','S') " +
								" AND STRG_MEET.SALES_PERS = ? "+
								" AND STRG_MEET.SALES_PERS=STRG_CUST_ADD.SALES_PERS "+
								" AND STRG_MEET.EVENT_DATE = ? "+
								" AND STRG_CUST_ADD.EVENT_DATE = ? "+
								" AND STRG_MEET.EVENT_TYPE <> 'PR' "+
								//" AND STRG_MEET.LOCALITY_CODE IN ("+locality+")"+ //commented by kailash on 24-09-18.
								" AND STRG_MEET.LOCALITY_CODE IN ("+selLocality+")"+ //Changed by kailash for unlisted case localtiy code get from place screen.
								" ORDER BY SC_NAME ";//changed by Ashutosh -26-Dec-17*/
						sqlEdit="SELECT STRG_MEET.*,(CASE WHEN SR.ROUTE_DESCR IS NOT NULL THEN SR.ROUTE_DESCR ELSE SR.DESCR END ) LOC_DESCR,FIELDACTIVITY.ACTIVITY_TYPE ACT_TYPE,"+
								"   UPPER(STRG_CUSTOMER.FIRST_NAME)||' '||UPPER(STRG_CUSTOMER.MIDDLE_NAME)||' '||UPPER(STRG_CUSTOMER.LAST_NAME) AS SC_NAME,SCT.DESCR AS CUST_TYPE_DESCR " +
								" ,SCS.SUBCLASS_DESCR,SCC.CLASS_CODE_DESCR,SCT.DCR_GROUP AS DCR_GROUP, "+
								" (CASE WHEN SCT.SURVEY_TEMPL IS NULL THEN '"+sfaParmVal+"' ELSE SCT.SURVEY_TEMPL END) AS SURVEY_TEMPL" + //added by shrradhda M for SURVEY_TEMPL mising in select [19-mar-2021]
								" ,STRG_CUSTOMER.QUALIFICATION AS QUALIFICATION,STRG_CUSTOMER.GST_NO AS STRG_GST_NO,STATE.DESCR AS STRG_STATE  "+  //added by shweta for registration value //added by shweta for registration value 21-05-21
  								" FROM LOCALITY , FIELDACTIVITY,STRG_MEET LEFT OUTER JOIN STRG_CUSTOMER ON STRG_MEET.STRG_CODE = STRG_CUSTOMER.SC_CODE " +
								" LEFT OUTER JOIN STRG_CUST_CLASS SCC  ON STRG_CUSTOMER.CUST_TYPE = SCC.CUST_TYPE AND STRG_CUSTOMER.CLASS_CODE= SCC.CLASS_CODE "+
								" LEFT OUTER JOIN STRG_CUST_SUBCLASS SCS  ON STRG_CUSTOMER.CUST_TYPE = SCS.CUST_TYPE AND STRG_CUSTOMER.CLASS_CODE= SCS.CLASS_CODE "+
								" LEFT OUTER JOIN STATE ON STRG_CUSTOMER.STATE_CODE = STATE.STATE_CODE," +
								" STRG_CUST_TYPE SCT,SPRS_ROUTE SR WHERE STRG_MEET.EVENT_TYPE =FIELDACTIVITY.ACTIVITY_CODE"+
								" AND STRG_MEET.LOCALITY_CODE = LOCALITY.LOCALITY_CODE AND SR.LOCALITY_CODE = LOCALITY.LOCALITY_CODE AND SR.SPRS_CODE=STRG_MEET.SALES_PERS AND SR.ROUTE_ID=STRG_MEET.ROUTE_ID "+
								" AND STRG_MEET.SALES_PERS = ? "+
								" AND STRG_MEET.EVENT_DATE = ? "+
								" AND SCT.TYPE=STRG_CUSTOMER.CUST_TYPE "+
								" AND SCT.DCR_GROUP NOT IN ('D','C','S') " +
								/*" AND STRG_MEET.STRG_CODE IN "+
								" ( SELECT SC_CODE  FROM STRG_STATUS_HIST "+
								"    WHERE STRG_STATUS_HIST .EFF_FROM<= ?  "+
								"    AND STRG_STATUS_HIST .VALID_UPTO >= ?"+
								"    AND STRG_STATUS_HIST.SALES_PERS = STRG_MEET.SALES_PERS  ) "+*/
								" AND STRG_MEET.EVENT_TYPE <> 'PR' AND STRG_MEET.LOCALITY_CODE IN ("+locality+") AND STRG_MEET.ROUTE_ID IN("+routeId+")" +
								" UNION ALL "+
								" SELECT STRG_MEET.*,(CASE WHEN SR.ROUTE_DESCR IS NOT NULL THEN SR.ROUTE_DESCR ELSE SR.DESCR END ) LOC_DESCR,FIELDACTIVITY.ACTIVITY_TYPE ACT_TYPE, " +
								" STRG_MEET.STRG_NAME AS SC_NAME,SCT.DESCR  AS CUST_TYPE_DESCR ,SCS.SUBCLASS_DESCR,SCC.CLASS_CODE_DESCR,SCT.DCR_GROUP AS DCR_GROUP, " +
								" (CASE WHEN SCT.SURVEY_TEMPL IS NULL THEN '"+sfaParmVal+"' ELSE SCT.SURVEY_TEMPL END) AS SURVEY_TEMPL,"+
								" '' AS QUALIFICATION,'' AS STRG_GST_NO,'' AS STRG_STATE "+            //added by shweta m //added by shweta for registration value 21-05-21
						        "FROM LOCALITY,FIELDACTIVITY,STRG_MEET " +
								" LEFT OUTER JOIN STRG_CUST_CLASS SCC ON strg_meet.STRG_TYPE = SCC.CUST_TYPE AND strg_meet.STRG_CLASS_CODE= SCC.CLASS_CODE " +
								" LEFT OUTER JOIN STRG_CUST_SUBCLASS SCS ON strg_meet.STRG_TYPE= SCS.CUST_TYPE AND strg_meet.STRG_CLASS_CODE= SCS.CLASS_CODE, " +
								" STRG_CUST_TYPE SCT,SPRS_ROUTE SR WHERE STRG_MEET.EVENT_TYPE  =FIELDACTIVITY.ACTIVITY_CODE AND STRG_MEET.LOCALITY_CODE  = LOCALITY.LOCALITY_CODE " +
								" AND SR.LOCALITY_CODE = LOCALITY.LOCALITY_CODE AND SR.SPRS_CODE =STRG_MEET.SALES_PERS AND SR.ROUTE_ID =STRG_MEET.ROUTE_ID AND SCT.TYPE=STRG_MEET.STRG_TYPE " +
								" AND SCT.DCR_GROUP NOT IN ('D','C','S') " +
								" AND STRG_MEET.SALES_PERS = ? "+
								" AND STRG_MEET.EVENT_DATE = ? "+
								" AND STRG_MEET.EVENT_TYPE <> 'PR' "+
								" AND STRG_MEET.STRG_CODE NOT IN(SELECT SC_CODE FROM STRG_CUSTOMER)"+
								" AND STRG_MEET.LOCALITY_CODE IN ("+selLocality+") AND STRG_MEET.ROUTE_ID IN("+selRouteId+")"+ //Changed by kailash for unlisted case localtiy code get from place screen.
								" ORDER BY LOC_DESCR,SC_NAME ";//changed by Ashutosh -26-Dec-17

					}
					else if(custType.equalsIgnoreCase("S") && stockistTable.equalsIgnoreCase("SPRS_STOCKIST"))
					{
						sqlEdit = "SELECT STRG_MEET.*,(CASE WHEN SR.ROUTE_DESCR IS NOT NULL THEN SR.ROUTE_DESCR ELSE SR.DESCR END ) LOC_DESCR,FIELDACTIVITY.ACTIVITY_TYPE ACT_TYPE, "+
								"CUSTOMER.CUST_NAME AS SC_NAME,SCT.DESCR AS CUST_TYPE_DESCR ,SCT.DCR_GROUP AS DCR_GROUP,(CASE WHEN SCT.SURVEY_TEMPL IS NULL "+
								"THEN '"+sfaParmVal+"' ELSE SCT.SURVEY_TEMPL END) AS SURVEY_TEMPL, '' AS SUBCLASS_DESCR, '' AS CLASS_CODE_DESCR "+
								" ,'' AS QUALIFICATION,'' AS STRG_GST_NO,'' AS STRG_STATE  "+            //added by shweta m //added by shweta for registration value 21-05-21
								"FROM LOCALITY, FIELDACTIVITY, STRG_MEET LEFT OUTER JOIN CUSTOMER ON STRG_MEET.STRG_CODE = CUSTOMER.CUST_CODE, STRG_CUST_TYPE SCT, SPRS_ROUTE SR "+
								"WHERE STRG_MEET.EVENT_TYPE = FIELDACTIVITY.ACTIVITY_CODE AND STRG_MEET.LOCALITY_CODE = LOCALITY.LOCALITY_CODE AND SR.LOCALITY_CODE = LOCALITY.LOCALITY_CODE "+
								"AND SR.SPRS_CODE = STRG_MEET.SALES_PERS  AND SR.ROUTE_ID = STRG_MEET.ROUTE_ID AND STRG_MEET.SALES_PERS = ? AND STRG_MEET.EVENT_DATE = ? "+
								"AND SCT.TYPE = CUSTOMER.CUST_TYPE AND SCT.DCR_GROUP = 'S' AND STRG_MEET.EVENT_TYPE <> 'PR' AND STRG_MEET.LOCALITY_CODE IN ("+locality+") AND STRG_MEET.ROUTE_ID IN("+routeId+") "+
								"UNION ALL "+
								"SELECT STRG_MEET.*,(CASE WHEN SR.ROUTE_DESCR IS NOT NULL THEN SR.ROUTE_DESCR ELSE SR.DESCR END ) LOC_DESCR,FIELDACTIVITY.ACTIVITY_TYPE ACT_TYPE, "+
								"STRG_MEET.STRG_NAME AS SC_NAME,SCT.DESCR  AS CUST_TYPE_DESCR ,SCS.SUBCLASS_DESCR,SCC.CLASS_CODE_DESCR,SCT.DCR_GROUP AS DCR_GROUP, "+
								"(CASE WHEN SCT.SURVEY_TEMPL IS NULL THEN '"+sfaParmVal+"' ELSE SCT.SURVEY_TEMPL END) AS SURVEY_TEMPL, '' AS QUALIFICATION,'' AS STRG_GST_NO,'' AS STRG_STATE  "+            //added by shweta m //added by shweta for registration value 21-05-21
								"FROM LOCALITY,FIELDACTIVITY,STRG_MEET "+
								"LEFT OUTER JOIN STRG_CUST_CLASS SCC ON strg_meet.STRG_TYPE = SCC.CUST_TYPE AND strg_meet.STRG_CLASS_CODE= SCC.CLASS_CODE  "+
								"LEFT OUTER JOIN STRG_CUST_SUBCLASS SCS ON strg_meet.STRG_TYPE= SCS.CUST_TYPE AND strg_meet.STRG_CLASS_CODE= SCS.CLASS_CODE, "+
								"STRG_CUST_TYPE SCT,SPRS_ROUTE SR WHERE STRG_MEET.EVENT_TYPE  =FIELDACTIVITY.ACTIVITY_CODE AND STRG_MEET.LOCALITY_CODE  = LOCALITY.LOCALITY_CODE "+
								"AND SR.LOCALITY_CODE = LOCALITY.LOCALITY_CODE AND SR.SPRS_CODE =STRG_MEET.SALES_PERS AND SR.ROUTE_ID =STRG_MEET.ROUTE_ID AND SCT.TYPE=STRG_MEET.STRG_TYPE "+
								"AND SCT.DCR_GROUP = 'S' AND STRG_MEET.SALES_PERS = ? AND STRG_MEET.EVENT_DATE = ? AND STRG_MEET.EVENT_TYPE <> 'PR' "+
								"AND STRG_MEET.STRG_CODE NOT IN(SELECT CUST_CODE FROM CUSTOMER) AND STRG_MEET.LOCALITY_CODE IN ("+selLocality+") AND STRG_MEET.ROUTE_ID IN("+selRouteId+") ORDER BY LOC_DESCR,SC_NAME ";
					}

					else
					{
						/*sqlEdit="SELECT STRG_MEET.*,LOCALITY.DESCR LOC_DESCR,FIELDACTIVITY.ACTIVITY_TYPE ACT_TYPE,"+
							"   UPPER(STRG_CUSTOMER.FIRST_NAME)||' '||UPPER(STRG_CUSTOMER.LAST_NAME) AS SC_NAME,"+
							"STRG_CUSTOMER.ADDR1,STRG_CUSTOMER.ADDR2,STRG_CUSTOMER.ADDR3  "+
							" FROM LOCALITY , FIELDACTIVITY,STRG_MEET LEFT OUTER JOIN STRG_CUSTOMER ON STRG_MEET.STRG_CODE = STRG_CUSTOMER.SC_CODE "+
							"  WHERE STRG_MEET.EVENT_TYPE =FIELDACTIVITY.ACTIVITY_CODE"+
							" AND STRG_MEET.LOCALITY_CODE = LOCALITY.LOCALITY_CODE "+
							" AND STRG_MEET.SALES_PERS = ? "+
							" AND STRG_MEET.EVENT_DATE = ? "+
							" AND STRG_MEET.STRG_CODE IN "+
							" ( SELECT SC_CODE  FROM STRG_STATUS_HIST "+
							"    WHERE STRG_STATUS_HIST .EFF_FROM<= ?  "+
							"    AND STRG_STATUS_HIST .VALID_UPTO >= ?"+
							"    AND STRG_CUSTOMER.CUST_TYPE = ? " +
							"    AND STRG_STATUS_HIST.SALES_PERS = STRG_MEET.SALES_PERS  ) AND STRG_MEET.EVENT_TYPE <> 'PR' AND STRG_MEET.LOCALITY_CODE IN ("+locality+")" +
							" ORDER BY STRG_MEET.SHORT_ID ";*/

						/*sqlEdit="SELECT STRG_MEET.*,LOCALITY.DESCR LOC_DESCR,FIELDACTIVITY.ACTIVITY_TYPE ACT_TYPE,"+
								"   UPPER(STRG_CUSTOMER.FIRST_NAME)||' '||UPPER(STRG_CUSTOMER.LAST_NAME) AS SC_NAME,SCT.DESCR AS CUST_TYPE_DESCR "+
								" FROM LOCALITY , FIELDACTIVITY,STRG_MEET LEFT OUTER JOIN STRG_CUSTOMER ON STRG_MEET.STRG_CODE = STRG_CUSTOMER.SC_CODE, "+
								"  STRG_CUST_TYPE SCT WHERE STRG_MEET.EVENT_TYPE =FIELDACTIVITY.ACTIVITY_CODE"+
								" AND STRG_MEET.LOCALITY_CODE = LOCALITY.LOCALITY_CODE "+
								" AND STRG_MEET.SALES_PERS = ? "+
								" AND STRG_MEET.EVENT_DATE = ? "+
								" AND SCT.TYPE=STRG_CUSTOMER.CUST_TYPE "+ // added by mrunalini s. for dcr_group changes  on 03-dec-2018
								" AND STRG_MEET.STRG_CODE IN "+
								" ( SELECT SC_CODE  FROM STRG_STATUS_HIST "+
								"    WHERE STRG_STATUS_HIST .EFF_FROM<= ?  "+
								"    AND STRG_STATUS_HIST .VALID_UPTO >= ?"+
								//"    AND STRG_CUSTOMER.CUST_TYPE = ? " +  // commented & added by mrunalini s. for dcr_group changes  on 03-dec-2018
								"    AND SCT.DCR_GROUP = ? " +
								"    AND STRG_STATUS_HIST.SALES_PERS = STRG_MEET.SALES_PERS  ) AND STRG_MEET.EVENT_TYPE <> 'PR' AND STRG_MEET.LOCALITY_CODE IN ("+locality+")" +
								" UNION ALL "+
								" SELECT STRG_MEET.*,LOCALITY.DESCR LOC_DESCR,FIELDACTIVITY.ACTIVITY_TYPE ACT_TYPE,STRG_CUST_ADD.STRG_NAME AS SC_NAME,SCT.DESCR AS CUST_TYPE_DESCR "+
								" FROM LOCALITY,FIELDACTIVITY,STRG_MEET LEFT OUTER JOIN STRG_CUST_ADD ON STRG_MEET.STRG_CODE = STRG_CUST_ADD.STRG_CODE,  "+
								" STRG_CUST_TYPE SCT WHERE STRG_MEET.EVENT_TYPE =FIELDACTIVITY.ACTIVITY_CODE "+
								" AND STRG_MEET.LOCALITY_CODE = LOCALITY.LOCALITY_CODE "+
								" AND SCT.TYPE=STRG_CUST_ADD.STRG_TYPE "+ // added by mrunalini s. for dcr_group changes  on 03-dec-2018
								//" AND STRG_CUST_ADD.STRG_TYPE = ?" + // commented & added by mrunalini s. for dcr_group changes  on 03-dec-2018
								" AND SCT.DCR_GROUP = ? " +
								" AND STRG_MEET.SALES_PERS = ? "+
								" AND STRG_MEET.SALES_PERS=STRG_CUST_ADD.SALES_PERS "+
								" AND STRG_MEET.EVENT_DATE = ? "+
								" AND STRG_CUST_ADD.EVENT_DATE = ? "+
								" AND STRG_MEET.EVENT_TYPE <> 'PR' "+
								//" AND STRG_MEET.LOCALITY_CODE IN ("+locality+")"+ //commented by kailash on 24-09-18.
								" AND STRG_MEET.LOCALITY_CODE IN ("+selLocality+")"+ //Changed by kailash for unlisted case localtiy code get from place screen.
								"ORDER BY SC_NAME"; //changed by Ashutosh -26-Dec-17 */

						/*sqlEdit="SELECT STRG_MEET.*,LOCALITY.DESCR LOC_DESCR,FIELDACTIVITY.ACTIVITY_TYPE ACT_TYPE,"+
								"   UPPER(STRG_CUSTOMER.FIRST_NAME)||' '||UPPER(STRG_CUSTOMER.LAST_NAME) AS SC_NAME,SCT.DESCR AS CUST_TYPE_DESCR "+
								" ,SCS.SUBCLASS_DESCR,SCC.CLASS_CODE_DESCR,SCT.DCR_GROUP AS DCR_GROUP "+
								" FROM LOCALITY , FIELDACTIVITY,STRG_MEET LEFT OUTER JOIN STRG_CUSTOMER ON STRG_MEET.STRG_CODE = STRG_CUSTOMER.SC_CODE "+
								" LEFT OUTER JOIN STRG_CUST_CLASS SCC  ON STRG_CUSTOMER.CUST_TYPE = SCC.CUST_TYPE AND STRG_CUSTOMER.CLASS_CODE= SCC.CLASS_CODE "+
								" LEFT OUTER JOIN STRG_CUST_SUBCLASS SCS  ON STRG_CUSTOMER.CUST_TYPE = SCS.CUST_TYPE AND STRG_CUSTOMER.CLASS_CODE= SCS.CLASS_CODE, "+
								" STRG_CUST_TYPE SCT WHERE STRG_MEET.EVENT_TYPE =FIELDACTIVITY.ACTIVITY_CODE"+
								" AND STRG_MEET.LOCALITY_CODE = LOCALITY.LOCALITY_CODE "+
								" AND STRG_MEET.SALES_PERS = ? "+
								" AND STRG_MEET.EVENT_DATE = ? "+
								" AND SCT.TYPE=STRG_CUSTOMER.CUST_TYPE "+ // added by mrunalini s. for dcr_group changes  on 03-dec-2018
								" AND STRG_MEET.STRG_CODE IN "+
								" ( SELECT SC_CODE  FROM STRG_STATUS_HIST "+
								"    WHERE STRG_STATUS_HIST .EFF_FROM<= ?  "+
								"    AND STRG_STATUS_HIST .VALID_UPTO >= ?"+
								//"    AND STRG_CUSTOMER.CUST_TYPE = ? " +  // commented & added by mrunalini s. for dcr_group changes  on 03-dec-2018
								"    AND SCT.DCR_GROUP = ? " +
								"    AND STRG_STATUS_HIST.SALES_PERS = STRG_MEET.SALES_PERS  ) AND STRG_MEET.EVENT_TYPE <> 'PR' AND STRG_MEET.LOCALITY_CODE IN ("+locality+")" +
								" UNION ALL "+
								" SELECT STRG_MEET.*,LOCALITY.DESCR LOC_DESCR,FIELDACTIVITY.ACTIVITY_TYPE ACT_TYPE,STRG_CUST_ADD.STRG_NAME AS SC_NAME,SCT.DESCR AS CUST_TYPE_DESCR " +
								" ,SCS.SUBCLASS_DESCR,SCC.CLASS_CODE_DESCR,SCT.DCR_GROUP AS DCR_GROUP "+
								" FROM LOCALITY,FIELDACTIVITY,STRG_MEET LEFT OUTER JOIN STRG_CUST_ADD ON STRG_MEET.STRG_CODE = STRG_CUST_ADD.STRG_CODE  "+
								" LEFT OUTER JOIN STRG_CUST_CLASS SCC  ON STRG_CUST_ADD.STRG_TYPE = SCC.CUST_TYPE AND STRG_CUST_ADD.STRG_CLASS_CODE= SCC.CLASS_CODE "+
								" LEFT OUTER JOIN STRG_CUST_SUBCLASS SCS  ON STRG_CUST_ADD.STRG_TYPE = SCS.CUST_TYPE AND STRG_CUST_ADD.STRG_CLASS_CODE= SCS.CLASS_CODE, "+
								" STRG_CUST_TYPE SCT WHERE STRG_MEET.EVENT_TYPE =FIELDACTIVITY.ACTIVITY_CODE "+
								" AND STRG_MEET.LOCALITY_CODE = LOCALITY.LOCALITY_CODE "+
								" AND SCT.TYPE=STRG_CUST_ADD.STRG_TYPE "+ // added by mrunalini s. for dcr_group changes  on 03-dec-2018
								//" AND STRG_CUST_ADD.STRG_TYPE = ?" + // commented & added by mrunalini s. for dcr_group changes  on 03-dec-2018
								" AND SCT.DCR_GROUP = ? " +
								" AND STRG_MEET.SALES_PERS = ? "+
								" AND STRG_MEET.SALES_PERS=STRG_CUST_ADD.SALES_PERS "+
								" AND STRG_MEET.EVENT_DATE = ? "+
								" AND STRG_CUST_ADD.EVENT_DATE = ? "+
								" AND STRG_MEET.EVENT_TYPE <> 'PR' "+
								//" AND STRG_MEET.LOCALITY_CODE IN ("+locality+")"+ //commented by kailash on 24-09-18.
								" AND STRG_MEET.LOCALITY_CODE IN ("+selLocality+")"+ //Changed by kailash for unlisted case localtiy code get from place screen.
								"ORDER BY SC_NAME"; //changed by Ashutosh -26-Dec-17*/
						//Changed by Pooja S on 27-JULY-2020 [Customerwise template display form realted implementation]
						sqlEdit="SELECT STRG_MEET.*,(CASE WHEN SR.ROUTE_DESCR IS NOT NULL THEN SR.ROUTE_DESCR ELSE SR.DESCR END ) LOC_DESCR,FIELDACTIVITY.ACTIVITY_TYPE ACT_TYPE,"+
								"   UPPER(STRG_CUSTOMER.FIRST_NAME)||' '||UPPER(STRG_CUSTOMER.MIDDLE_NAME)||' '||UPPER(STRG_CUSTOMER.LAST_NAME) AS SC_NAME,SCT.DESCR AS CUST_TYPE_DESCR "+
								" ,SCS.SUBCLASS_DESCR,SCC.CLASS_CODE_DESCR,SCT.DCR_GROUP AS DCR_GROUP,(case when STRG_CUSTOMER.SURVEY_TEMPL is null then (CASE WHEN SCT.SURVEY_TEMPL IS NULL THEN '"+sfaParmVal+"' ELSE SCT.SURVEY_TEMPL END) else STRG_CUSTOMER.SURVEY_TEMPL END) AS SURVEY_TEMPL "+
								" ,STRG_CUSTOMER.QUALIFICATION AS QUALIFICATION,STRG_CUSTOMER.GST_NO AS STRG_GST_NO,STATE.DESCR AS STRG_STATE  "+  //added by shweta m //added by shweta for registration value 21-05-21
								" FROM LOCALITY , FIELDACTIVITY,STRG_MEET LEFT OUTER JOIN STRG_CUSTOMER ON STRG_MEET.STRG_CODE = STRG_CUSTOMER.SC_CODE "+
								" LEFT OUTER JOIN STRG_CUST_CLASS SCC  ON STRG_CUSTOMER.CUST_TYPE = SCC.CUST_TYPE AND STRG_CUSTOMER.CLASS_CODE= SCC.CLASS_CODE "+
								" LEFT OUTER JOIN STRG_CUST_SUBCLASS SCS  ON STRG_CUSTOMER.CUST_TYPE = SCS.CUST_TYPE AND STRG_CUSTOMER.CLASS_CODE= SCS.CLASS_CODE "+
								" LEFT OUTER JOIN STATE ON STRG_CUSTOMER.STATE_CODE = STATE.STATE_CODE," +
								" STRG_CUST_TYPE SCT,SPRS_ROUTE SR WHERE STRG_MEET.EVENT_TYPE =FIELDACTIVITY.ACTIVITY_CODE"+
								" AND STRG_MEET.LOCALITY_CODE = LOCALITY.LOCALITY_CODE AND SR.LOCALITY_CODE = LOCALITY.LOCALITY_CODE AND SR.SPRS_CODE=STRG_MEET.SALES_PERS  AND SR.ROUTE_ID=STRG_MEET.ROUTE_ID "+
								" AND STRG_MEET.SALES_PERS = ? "+
								" AND STRG_MEET.EVENT_DATE = ? "+
								" AND SCT.TYPE=STRG_CUSTOMER.CUST_TYPE "+ // added by mrunalini s. for dcr_group changes  on 03-dec-2018
								"    AND SCT.DCR_GROUP = ? " +
								/*" AND STRG_MEET.STRG_CODE IN "+
								" ( SELECT SC_CODE  FROM STRG_STATUS_HIST "+
								"    WHERE STRG_STATUS_HIST .EFF_FROM<= ?  "+
								"    AND STRG_STATUS_HIST .VALID_UPTO >= ?"+
								//"    AND STRG_CUSTOMER.CUST_TYPE = ? " +  // commented & added by mrunalini s. for dcr_group changes  on 03-dec-2018
								"  AND STRG_STATUS_HIST.SALES_PERS = STRG_MEET.SALES_PERS  ) "+*/
								" AND STRG_MEET.EVENT_TYPE <> 'PR' AND STRG_MEET.LOCALITY_CODE IN ("+locality+") AND STRG_MEET.ROUTE_ID IN("+routeId+") " +
								" UNION ALL "+
								" SELECT STRG_MEET.*,(CASE WHEN SR.ROUTE_DESCR IS NOT NULL THEN SR.ROUTE_DESCR ELSE SR.DESCR END ) LOC_DESCR,FIELDACTIVITY.ACTIVITY_TYPE ACT_TYPE, " +
								" STRG_MEET.STRG_NAME AS SC_NAME,SCT.DESCR  AS CUST_TYPE_DESCR ,SCS.SUBCLASS_DESCR,SCC.CLASS_CODE_DESCR,SCT.DCR_GROUP AS DCR_GROUP, " +
								" (CASE WHEN SCT.SURVEY_TEMPL IS NULL THEN '"+sfaParmVal+"' ELSE SCT.SURVEY_TEMPL END) AS SURVEY_TEMPL, '' AS QUALIFICATION,'' AS STRG_GST_NO,'' AS STRG_STATE "+            //added by shweta m //added by shweta for registration value 21-05-21
								"FROM LOCALITY,FIELDACTIVITY,STRG_MEET " +
								" LEFT OUTER JOIN STRG_CUST_CLASS SCC ON strg_meet.STRG_TYPE = SCC.CUST_TYPE AND strg_meet.STRG_CLASS_CODE= SCC.CLASS_CODE " +
								" LEFT OUTER JOIN STRG_CUST_SUBCLASS SCS ON strg_meet.STRG_TYPE= SCS.CUST_TYPE AND strg_meet.STRG_CLASS_CODE= SCS.CLASS_CODE, " +
								" STRG_CUST_TYPE SCT,SPRS_ROUTE SR WHERE STRG_MEET.EVENT_TYPE  =FIELDACTIVITY.ACTIVITY_CODE AND STRG_MEET.LOCALITY_CODE  = LOCALITY.LOCALITY_CODE " +
								" AND SR.LOCALITY_CODE = LOCALITY.LOCALITY_CODE AND SR.SPRS_CODE =STRG_MEET.SALES_PERS AND SR.ROUTE_ID =STRG_MEET.ROUTE_ID AND SCT.TYPE=STRG_MEET.STRG_TYPE " +
								" AND SCT.DCR_GROUP = ? " +
								" AND STRG_MEET.SALES_PERS = ? "+
								" AND STRG_MEET.EVENT_DATE = ? "+
								" AND STRG_MEET.EVENT_TYPE <> 'PR' "+
								" AND STRG_MEET.STRG_CODE NOT IN(SELECT SC_CODE FROM STRG_CUSTOMER)"+
								" AND STRG_MEET.LOCALITY_CODE IN ("+selLocality+") AND STRG_MEET.ROUTE_ID IN("+selRouteId+")"+ //Changed by kailash for unlisted case localtiy code get from place screen.
								"ORDER BY LOC_DESCR,SC_NAME"; //changed by Ashutosh -26-Dec-17

					}
				}


				//System.out.println("Rows ["+rowsRS+"]");

				if( rowsRS > 0 )
				{
					//Added by kailash on 21-09-18 [start]
					System.out.println("Inside edit mode sql");
					ArrayList unlistedCustList = getUnlistedCustomerList(connectionObject,dcrID);
					//System.out.println("unlistedCustList["+unlistedCustList+"]selLocality["+selLocality+"]");
					HashMap placeData=getLocalityForStrgVisitHrsCustomer(locality,routeId,"ROUTE_ID",sprsCode,stockistTable,connectionObject);
					//Added by kailash on 21-09-18 [end]
					modeReport = "E";
					pstmt =  connectionObject.prepareStatement( sqlEdit );
					pstmt.setString(1, sprsCode);
					pstmt.setTimestamp( 2, java.sql.Timestamp.valueOf( trvDBDate ) );

					if((custType.equalsIgnoreCase("S") && stockistTable.equalsIgnoreCase("SPRS_STOCKIST")))
					{
						pstmt.setString( 3, sprsCode);
						pstmt.setTimestamp( 4, java.sql.Timestamp.valueOf( trvDBDate ) );
						if(!"Y".equalsIgnoreCase(isMemberPresent))
						{
							pstmt.setTimestamp( 5, java.sql.Timestamp.valueOf( trvDBDate ) );
						}
					}
					else
					{
						/*pstmt.setTimestamp( 3, java.sql.Timestamp.valueOf( trvDBDate ) );
						pstmt.setTimestamp( 4, java.sql.Timestamp.valueOf( trvDBDate ) );*/
						if(custType.equalsIgnoreCase("O"))
						{
							pstmt.setString(3, sprsCode);
							pstmt.setTimestamp( 4, java.sql.Timestamp.valueOf( trvDBDate ) );
							if(!"Y".equalsIgnoreCase(isMemberPresent))
							{
								pstmt.setTimestamp( 5, java.sql.Timestamp.valueOf( trvDBDate ) );
							}

						}
						if (!custType.equalsIgnoreCase("O"))
						{
							pstmt.setString(3, custType);//Gulzar on 17/06/12
							pstmt.setString(4, custType);
							pstmt.setString(5, sprsCode);
							pstmt.setTimestamp( 6, java.sql.Timestamp.valueOf( trvDBDate ) );
							if(!"Y".equalsIgnoreCase(isMemberPresent))
							{
								pstmt.setTimestamp( 7, java.sql.Timestamp.valueOf( trvDBDate ) );
							}
						}
					}

					rs = pstmt.executeQuery();

					while(rs.next())
					{
						System.out.println("Inside while loop of edit sql");
						Date planDate=null;
						String showDate="";
						srNo++;
						Date lastDarDate=null;         // added by shweta for display last remark and last met deta 06-05-21 
						String priorVisitDate="";      // added by shweta for display last remark and last met deta 06-05-21 
						String actypeDB = checkNull(rs.getString("ACT_TYPE"));
						strgCode = checkNull(rs.getString("STRG_CODE"));//Gulzar on 17/06/12
						String classCode = checkNull(rs.getString("STRG_CLASS_CODE"));
						//dcrID = checkNull(rs.getString("DCR_ID")); //commented by mrunalini sinkar
						// added by rupali on 08/11/17 for displaying class code descr on customer screen [start]
						String cusType = checkNull(rs.getString("STRG_TYPE"));
						String meetRouteID = checkNull(rs.getString("ROUTE_ID"));
						String dcrGroup = checkNull(rs.getString("DCR_GROUP")); // added by mrunalini sinakr on 12-03-2019
						String surveyTempl=checkNull(rs.getString("SURVEY_TEMPL"));
						//Added by mrunalini sinkar for next plan date(start)
						String nextPlanDate=checkNull(rs.getString("NEXT_PLAN_DATE"));
						String regNumber=checkNull(rs.getString("REG_NO"));
						String priceList=checkNull(rs.getString("PRICE_LIST"));//Added by bhagyashri T For Price_list SO[W22EBAS016]
						//System.out.println("inside the edit SO sql priceList :::::["+priceList+"]");//Added by bhagyashri T For Price_list SO[W22EBAS016]
						//System.out.println("inside the edit SO sql :::::["+regNumber+"]");
						String totalamount =  checkNull(rs.getString("AMOUNT")) ;
						//System.out.println("inside the edit sql totalamount::::::["+totalamount+"]");
						String taxAmount =  checkNull(rs.getString("TAX_AMOUNT")) ;
						//System.out.println("inside the edit sql taxAmount::::::["+taxAmount+"]");
						double amt =0d;
						double invoiceAmount =0d;
						String invoicAmount ="";
						double sgstamt =0d;
						double sgstAmt =0d;
						String sgstAmount ="";
						String cgstAmount ="";
						if(totalamount!=null && totalamount.trim().length()>0)
						{
						  amt=Double.parseDouble(totalamount);
						  invoiceAmount=Math.round(amt);
						  invoicAmount=Double.toString(invoiceAmount);
						}
						if(taxAmount!=null && taxAmount.trim().length()>0)
						{
							sgstamt=Double.parseDouble(taxAmount);
							sgstAmt=(sgstamt/2);
							sgstAmount=Double.toString(sgstAmt);
							cgstAmount =sgstAmount;
						}
						String strgState = checkNull(rs.getString("STRG_STATE"));
						String strgGstNo = checkNull(rs.getString("STRG_GST_NO"));
						// added by shweta for display last remark and last met deta 06-05-21 started
						String lastMeetSumm=checkNull(rs.getString("LAST_MEET_SUMM"));  
				        String lastVisitDar=checkNull(rs.getString("LAST_MEET_DATE")); 
				        String eventType=checkNull(rs.getString("EVENT_TYPE"));
				        String eventActType = checkNull(getActivityType(eventType, connectionObject));
				        String eventTypeDescr = checkNull(getActivityDescr(eventType, connectionObject));
						if(lastVisitDar!=null && lastVisitDar.trim().length()>0)
						{
							lastDarDate=dbFormat.parse(lastVisitDar);
							priorVisitDate=applFormat.format(lastDarDate);
						}
						// added by shweta for display last remark and last met deta 06-05-21 end
						
						
						
						if(nextPlanDate!=null && nextPlanDate.trim().length()>0)
						{
							planDate=dbFormat.parse(nextPlanDate);
							showDate=applFormat.format(planDate);
						}
						//Added by mrunalini sinkar for next plan date(end)
						//Added by mrunalini sinkar to make server response  fast on 12-03-2020(start)
						String classCodeDescr="";
						if(classCount > 0)
						{
							if ( serClassMap.get( classCode) != null )
							{
								classCodeDescr=serClassMap.get(classCode);
							}
						}
						else
						{
							if ( custClassMap.get( cusType+"@"+classCode) != null )
							{
								classCodeDescr=custClassMap.get(cusType+"@"+classCode);

							}
						}
						//String classCodeDescr = getClassCodeDesc(classCode,cusType,sprsCode,itemSer,connectionObject); //add sprs code condition by mrunalini sinakr
						//Added by mrunalini sinkar to make server response  fast on 12-03-2020(end)
						String otherParticipantDb = checkNull(rs.getString("OTH_PARTICIPANT"));

						if (otherParticipantDb == null || otherParticipantDb.trim().length() == 0)
						{
							otherParticipantDb = otherParticipant;
						}
						//Added by Bhagyashri T for Fortune for add column contact_pers[22-FEB-2022][START]
						String contactPersDb = checkNull(rs.getString("CONTACT_PERS"));
						String contactPersName = checkNull(rs.getString("CONTACT_PERS_NAME"));
						//Added by Bhagyashri T for Fortune for add column contact_pers[22-FEB-2022][END]
						String specialityDescr = checkNull(getSplDescr(strgCode, sprsCode, connectionObject));
						//System.out.println("specialityDescr:-- "+specialityDescr+"--- strgCode--- "+strgCode+"-- sprsCode-- ");
						if(parmValue.equalsIgnoreCase("Y"))
						{
							visitDatesInMonth = getDocVistDatesInMonth(strgCode,sprsCode,trvDate,connectionObject);

						}
						int strgPriorVisitNo = 0;
						if(visitDatesInMonth != null && visitDatesInMonth.trim().length() > 0)
						{
							String strgPriorVisit [] = visitDatesInMonth.split(",");
							strgPriorVisitNo = strgPriorVisit.length;
						}
						//System.out.println("Edit strgPriorVisitNo :::=["+strgPriorVisitNo+"]actType  :- ["+actType+"]actypeDB:- ["+actypeDB+"]");
						// added by rupali on 07/11/17 for showing stockist_code and name in edit mode [start]
						String stockistCode = "";
						String stockistName = "";
						String stockSql = "";
						if (stockistTable.equalsIgnoreCase("SPRS_STOCKIST"))
						{
							stockSql = "SELECT SMO.STOCKIST_CODE AS STOCKIST_CODE, UPPER(CUST.CUST_NAME) AS STOCKIST_NAME, DCR_ID "+
									"FROM STRG_MEET_ORDER SMO, CUSTOMER CUST WHERE STRG_CODE = ? AND DCR_ID = ? AND CUST.CUST_CODE = SMO.STOCKIST_CODE";
						}
						else
						{
							stockSql = "SELECT SMO.STOCKIST_CODE AS STOCKIST_CODE, UPPER(SC.FIRST_NAME)||' '||UPPER(SC.LAST_NAME) AS STOCKIST_NAME, DCR_ID "+
									"FROM STRG_MEET_ORDER SMO, STRG_CUSTOMER SC WHERE STRG_CODE = ? AND DCR_ID = ? AND SC.SC_CODE = SMO.STOCKIST_CODE";
						}

						pstmtPlan =  connectionObject.prepareStatement( stockSql );
						pstmtPlan.setString(1, strgCode);
						pstmtPlan.setString(2, dcrID);
						rsPlan = pstmtPlan.executeQuery();
						if(rsPlan.next())
						{
							stockistCode = checkNull(rsPlan.getString("STOCKIST_CODE"));
							stockistName = checkNull(rsPlan.getString("STOCKIST_NAME"));
						}
						if(rsPlan != null)
						{
							rsPlan.close();
							rsPlan = null;
						}
						if(pstmtPlan != null)
						{
							pstmtPlan.close();
							pstmtPlan = null;
						}
						// added by rupali on 07/11/17 for showing stockist_code and name in edit mode [end]
						if ( actType.equalsIgnoreCase(actypeDB) )
						{

							String places = checkNull(rs.getString("LOCALITY_CODE"));
							String callOutCome = checkNull(rs.getString("CALL_OUTCOME"));
							String strgType = checkNull(rs.getString("STRG_TYPE"));
							list = new ArrayList<String>( Arrays.asList( temp ) );
							list.removeAll( Arrays.asList("'"+places+"'" ) );
							temp = list.toArray(new String[0]);

							/*if(unlistedCustList.contains(strgCode) && ("0000000000".equalsIgnoreCase(strgCode) || "UR00000000".equalsIgnoreCase(strgCode) ))
							{
								System.out.println("unlisted sun module");
								valueXmlString.append( "<Detail"+currentForm+" domID='"+domID+"' selected = 'Y' formName='"+formName+"' protectSubform=\""+teamFormName+"\"><protect_subform><![CDATA["+teamFormName+"]]></protect_subform>\r\n" );
								valueXmlString.append( "<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\" protectSubform=\""+teamFormName+"\"/>\r\n");
							}
							else
							{
								System.out.println("listed sun module");

							if(callOutCome.equalsIgnoreCase("0"))
							{
								valueXmlString.append( "<Detail"+currentForm+" domID='"+domID+"' selected = 'Y' formName='"+formName+"' protectSubform=\""+subFormDetails+"\"><protect_subform><![CDATA["+subFormDetails+"]]></protect_subform>\r\n" );
								valueXmlString.append( "<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\" protectSubform=\""+subFormDetails+"\"/>\r\n");
							}
							else
							{
								valueXmlString.append( "<Detail"+currentForm+" domID='"+domID+"' selected = 'Y' formName='"+formName+"'>\r\n" );
								valueXmlString.append( "<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\"/>\r\n");
							}
							}*/

							// added by mrunalini sinakr on 12-03-2019 for summary page changes(start)
							if(callOutCome.equalsIgnoreCase("0"))
							{
								valueXmlString.append( "<Detail"+currentForm+" domID='"+domID+"' selected = 'Y' formName='"+formName+"' protectSubform=\""+subFormDetails+"\"><protect_subform><![CDATA["+subFormDetails+"]]></protect_subform>\r\n" );
								valueXmlString.append( "<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\" protectSubform=\""+subFormDetails+"\"/>\r\n");
							}
							else
							{
								valueXmlString.append( "<Detail"+currentForm+" domID='"+domID+"' selected = 'Y' formName='"+formName+"'>\r\n" );
								valueXmlString.append( "<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\"/>\r\n");
							}
							if("D".equalsIgnoreCase(dcrGroup))
							{
								valueXmlString.append("<order_form_no><![CDATA[" ).append(sampleOrder).append( "]]></order_form_no>\r\n" );
								valueXmlString.append("<team_form_no><![CDATA[" ).append(doctorTeam).append( "]]></team_form_no>\r\n" );
								valueXmlString.append("<invoice_form_no><![CDATA[" ).append(invoiceTeam).append( "]]></invoice_form_no>\r\n" );
								valueXmlString.append("<collection_form_no><![CDATA[" ).append(collectionTeam).append( "]]></collection_form_no>\r\n" );
								valueXmlString.append("<item_form_no><![CDATA[" ).append(samplItem).append( "]]></item_form_no>\r\n" );
								valueXmlString.append("<brand_form_no><![CDATA[" ).append(brand).append( "]]></brand_form_no>\r\n" );
								valueXmlString.append("<display_form_no><![CDATA[" ).append(display).append( "]]></display_form_no>\r\n" );
								valueXmlString.append("<prescription_form_no><![CDATA[" ).append(prescription).append( "]]></prescription_form_no>\r\n" );
								valueXmlString.append("<survey_form_no><![CDATA[" ).append(survey).append( "]]></survey_form_no>\r\n" );
								valueXmlString.append("<coaching_form_no><![CDATA[" ).append(coaching).append( "]]></coaching_form_no>\r\n" );
								valueXmlString.append("<visited_with_display><![CDATA[" ).append(visitedWithDisp).append( "]]></visited_with_display>\r\n" );
							}
							else if("C".equalsIgnoreCase(dcrGroup))
							{
								valueXmlString.append("<order_form_no><![CDATA[" ).append(chemSampleOrder).append( "]]></order_form_no>\r\n" );
								valueXmlString.append("<team_form_no><![CDATA[" ).append(retailerTeam).append( "]]></team_form_no>\r\n" );
								valueXmlString.append("<item_form_no><![CDATA[" ).append(chemSamplItem).append( "]]></item_form_no>\r\n" );
								valueXmlString.append("<brand_form_no><![CDATA[" ).append(chembrand).append( "]]></brand_form_no>\r\n" );
								valueXmlString.append("<display_form_no><![CDATA[" ).append(chemDisplay).append( "]]></display_form_no>\r\n" );
								valueXmlString.append("<prescription_form_no><![CDATA[" ).append(chemPrescription).append( "]]></prescription_form_no>\r\n" );
								valueXmlString.append("<survey_form_no><![CDATA[" ).append(chemSurvey).append( "]]></survey_form_no>\r\n" );
								valueXmlString.append("<coaching_form_no><![CDATA[" ).append(chemCoaching).append( "]]></coaching_form_no>\r\n" );
								valueXmlString.append("<visited_with_display><![CDATA[" ).append(visitedWithDisp).append( "]]></visited_with_display>\r\n" );
							}
							else if("S".equalsIgnoreCase(dcrGroup))
							{
								valueXmlString.append("<order_form_no><![CDATA[" ).append(stockSampleOrder).append( "]]></order_form_no>\r\n" );
								valueXmlString.append("<team_form_no><![CDATA[" ).append(stockistTeam).append( "]]></team_form_no>\r\n" );
								valueXmlString.append("<item_form_no><![CDATA[" ).append(stockSamplItem).append( "]]></item_form_no>\r\n" );
								valueXmlString.append("<brand_form_no><![CDATA[" ).append(stockbrand).append( "]]></brand_form_no>\r\n" );
								valueXmlString.append("<display_form_no><![CDATA[" ).append(stockDisplay).append( "]]></display_form_no>\r\n" );
								valueXmlString.append("<prescription_form_no><![CDATA[" ).append(stockPrescription).append( "]]></prescription_form_no>\r\n" );
								valueXmlString.append("<survey_form_no><![CDATA[" ).append(stockSurvey).append( "]]></survey_form_no>\r\n" );
								valueXmlString.append("<coaching_form_no><![CDATA[" ).append(stockCoaching).append( "]]></coaching_form_no>\r\n" );
								valueXmlString.append("<visited_with_display><![CDATA[" ).append(visitedWithDisp).append( "]]></visited_with_display>\r\n" );
							}
							else
							{
								valueXmlString.append("<order_form_no><![CDATA[" ).append(ncwSampleOrder).append( "]]></order_form_no>\r\n" );
								valueXmlString.append("<team_form_no><![CDATA[" ).append(ncwTeam).append( "]]></team_form_no>\r\n" );
								valueXmlString.append("<item_form_no><![CDATA[" ).append(ncwSamplItem).append( "]]></item_form_no>\r\n" );
								valueXmlString.append("<brand_form_no><![CDATA[" ).append(ncwbrand).append( "]]></brand_form_no>\r\n" );
								valueXmlString.append("<display_form_no><![CDATA[" ).append(ncwDisplay).append( "]]></display_form_no>\r\n" );
								valueXmlString.append("<prescription_form_no><![CDATA[" ).append(ncwPrescription).append( "]]></prescription_form_no>\r\n" );
								valueXmlString.append("<survey_form_no><![CDATA[" ).append(ncwSurvey).append( "]]></survey_form_no>\r\n" );
								valueXmlString.append("<coaching_form_no><![CDATA[" ).append(ncwCoaching).append( "]]></coaching_form_no>\r\n" );
								valueXmlString.append("<visited_with_display><![CDATA[" ).append(visitedWithDisp).append( "]]></visited_with_display>\r\n" );
							}
							valueXmlString.append("<host_url><![CDATA[" ).append(CommonConstants.TOMCAT_HOME).append( "]]></host_url>\r\n" );
							// added by mrunalini sinakr on 12-03-2019 for summary page changes(end)
							valueXmlString.append("<route_id><![CDATA[" ).append(meetRouteID).append( "]]></route_id>\r\n" );
							valueXmlString.append("<survey_templ><![CDATA[").append(surveyTempl).append("]]></survey_templ>\r\n");
							valueXmlString.append( "<oth_participant><![CDATA[" ).append(otherParticipantDb).append( "]]></oth_participant>\r\n" );
							valueXmlString.append( "<contact_pers><![CDATA[" ).append(contactPersDb).append( "]]></contact_pers>\r\n" );////Added by bhagyashri T For Change OTH_PARTICIPANT TO CONTACT_PERS[22/02/22][START]
							valueXmlString.append( "<contact_pers_name visible='1' protect='1'><![CDATA[" ).append(contactPersName).append( "]]></contact_pers_name>\r\n" );////Added by bhagyashri T For Change OTH_PARTICIPANT TO CONTACT_PERS[22/02/22][START]			
							if(editCustCnt>0)
							{
								valueXmlString.append("<is_finish_disable><![CDATA[" ).append("Y").append( "]]></is_finish_disable>\r\n" );
							}
							else
							{
								valueXmlString.append("<is_finish_disable><![CDATA[" ).append("N").append( "]]></is_finish_disable>\r\n" );
							}
							valueXmlString.append("<dcr_group visible='0' protect='1'><![CDATA[" ).append(checkNull(getDcrGroup(strgType,connectionObject ))).append( "]]></dcr_group>\r\n" );
							if("Y".equalsIgnoreCase(isFortune))
							{
								valueXmlString.append( "<event_type visible='1'><![CDATA[" ).append(eventType).append( "]]></event_type>\r\n" );
								valueXmlString.append( "<activity_type><![CDATA[" ).append(eventActType).append( "]]></activity_type>\r\n" );
								valueXmlString.append( "<event_type_descr><![CDATA[" ).append(eventTypeDescr).append( "]]></event_type_descr>\r\n" );
							}
							else
							{
								valueXmlString.append( "<event_type visible='0'><![CDATA[" ).append(checkNull(activityCodeDom)).append( "]]></event_type>\r\n" );
								valueXmlString.append( "<activity_type><![CDATA[" ).append(actypeDB).append( "]]></activity_type>\r\n" );

							}

							
							if(!unlistedCustList.contains(strgCode))//Added condition for shoiwng listed customer
							{
								valueXmlString.append("<member_present visible='0'><![CDATA[" ).append(checkNull(rs.getString("MEMBER_PRESENT"))).append( "]]></member_present>\r\n" );

								valueXmlString.append("<cust_type protect='1'><![CDATA[" ).append(checkNull(rs.getString("CUST_TYPE_DESCR"))).append( "]]></cust_type>\r\n" );
								valueXmlString.append("<sr_no><![CDATA[" ).append(srNo).append( "]]></sr_no>\r\n");
								valueXmlString.append("<to_disable><![CDATA[Y]]></to_disable>\r\n");
								valueXmlString.append("<short_id><![CDATA[" ).append( checkNull(rs.getString("SHORT_ID")).trim()).append( "]]></short_id>\r\n");
								valueXmlString.append("<strg_code visible='1'><![CDATA[" ).append( checkNull(rs.getString("STRG_CODE")).trim()).append( "]]></strg_code>\r\n");
								valueXmlString.append("<uniq_strg_code protect = '1' visible = '0'><![CDATA[" ).append( checkNull(rs.getString("STRG_CODE")).trim()).append( "]]></uniq_strg_code>\r\n" );//Added by Bhagyashri for [W21JFOR007]
								//if(actType.indexOf("NFW")!=-1 || actType.indexOf("LEAVE")!=-1)
								if(!"FW".equalsIgnoreCase(actType))//Added & commented by mrunalini sinkar for NFW activity type not found(13-02-2019)
								{
									valueXmlString.append("<cust_name><![CDATA[-NA-]]></cust_name>\r\n");
								}
								else
								{
									valueXmlString.append("<cust_name><![CDATA[" ).append( checkNull(rs.getString("SC_NAME")).trim()).append( "]]></cust_name>\r\n");//Added protect ='1' by kailash on 20-09-18.
								}
								valueXmlString.append( "<locality_descr><![CDATA[" ).append( checkNull(rs.getString("LOC_DESCR"))).append( "]]></locality_descr>\r\n" );
								valueXmlString.append( "<order_booked><![CDATA[" ).append( checkNull(rs.getString("ORDER_BOOKED"))).append( "]]></order_booked>\r\n" );
								valueXmlString.append( "<event_time_start><![CDATA[" ).append( checkNull(rs.getString("EVENT_TIME_START"))).append( "]]></event_time_start>\r\n" );
								valueXmlString.append( "<visit_time_from visible='0'><![CDATA[" ).append( checkNull(rs.getString("EVENT_TIME_START"))).append( "]]></visit_time_from>\r\n" );
								if("Y".equalsIgnoreCase(eventHideTimeEnd))
								{
									valueXmlString.append( "<event_time_end visible='0'><![CDATA[" ).append( checkNull(rs.getString("EVENT_TIME_END"))).append( "]]></event_time_end>\r\n" );
								}
								else
								{
									valueXmlString.append( "<event_time_end visible='1' protect='0'><![CDATA[" ).append( checkNull(rs.getString("EVENT_TIME_END"))).append( "]]></event_time_end>\r\n" );//Added by Hariom S for Table View ralated Changes -08-July-2021
								}


								valueXmlString.append( "<remarks><![CDATA[" ).append(checkNull(rs.getString("REMARKS"))).append( "]]></remarks>\r\n" );

								//	String callOutCome = checkNull(rs.getString("CALL_OUTCOME"));
								valueXmlString.append( "<call_outcome><![CDATA[" ).append(checkNull(callOutCome)).append( "]]></call_outcome>\r\n" );
								if("Y".equalsIgnoreCase(isFortune))
								{
									String meetingStatus="";
									//added by Bhagyashri T for Fortune meeting_status issue[22/11/21]
									String mettingSql="SELECT CALL_OUTCOME_DESCR FROM CALL_OUTCOME WHERE CALL_OUTCOME = ? AND ACTIVITY_CODE= ? ";
									PreparedStatement meetPstmt =connectionObject.prepareStatement(mettingSql);
									meetPstmt.setString(1, callOutCome);
									meetPstmt.setString(2, eventType);
									ResultSet meetRs=meetPstmt.executeQuery();
									if(meetRs.next())
									{
										meetingStatus=checkNull(meetRs.getString("CALL_OUTCOME_DESCR"));
									}
									if (meetRs!= null)
									{
										meetRs.close();
										meetRs = null;
									}
									if(meetPstmt!=null)
									{
										meetPstmt.close();
										meetPstmt = null;
									}
									valueXmlString.append( "<meet_summ><![CDATA[" ).append(checkNull(rs.getString("MEET_SUMM"))).append( "]]></meet_summ>\r\n" );
									valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append(meetingStatus).append( "]]></calloutcome_descr>\r\n" );
									valueXmlString.append( "<meeting_status><![CDATA[" ).append(meetingStatus).append( "]]></meeting_status>\r\n" );
									valueXmlString.append( "<subform_meeting_status><![CDATA[" ).append(meetingStatus).append( "]]></subform_meeting_status>\r\n" );

								}
								else
								{
									if(callOutCome.equalsIgnoreCase("4"))
									{
										valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Very Positive").append( "]]></calloutcome_descr>\r\n" );
									}
									else if(callOutCome.equalsIgnoreCase("3"))
									{
										valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Average").append( "]]></calloutcome_descr>\r\n" );
									}
									else if(callOutCome.equalsIgnoreCase("2"))
									{
										valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Below Average").append( "]]></calloutcome_descr>\r\n" );
									}
									else if(callOutCome.equalsIgnoreCase("1"))
									{
										valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Negative").append( "]]></calloutcome_descr>\r\n" );
									}
									else if(callOutCome.equalsIgnoreCase("5"))
									{
										valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Supporter").append( "]]></calloutcome_descr>\r\n" );
									}
									else if(callOutCome.equalsIgnoreCase("6"))
									{
										valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Believer").append( "]]></calloutcome_descr>\r\n" );
									}
									else if(callOutCome.equalsIgnoreCase("7"))
									{
										valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Non Believer").append( "]]></calloutcome_descr>\r\n" );
									}
									else if(callOutCome.equalsIgnoreCase("0"))
									{
										valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Refused").append( "]]></calloutcome_descr>\r\n" );
									}
									if(callOutCome.equalsIgnoreCase("0"))
									{
										valueXmlString.append( "<meet_summ protect = '1'><![CDATA[" ).append("").append( "]]></meet_summ>\r\n" );
									}
									else
									{
										valueXmlString.append( "<meet_summ><![CDATA[" ).append(checkNull(rs.getString("MEET_SUMM"))).append( "]]></meet_summ>\r\n" );
									}
								}


								//valueXmlString.append( "<visited_with_display><![CDATA[" ).append(workWith).append( "]]></visited_with_display>\r\n" );
								if("JW".equalsIgnoreCase(actCode) && "FW".equalsIgnoreCase(actType))//Gulzar on 17/06/12
								{
									valueXmlString.append( "<work_with_other><![CDATA[" ).append(workWithOther).append( "]]></work_with_other>\r\n" );
								}
								else
								{
									valueXmlString.append( "<work_with_other><![CDATA[" ).append("").append( "]]></work_with_other>\r\n" );
								}
								valueXmlString.append( "<work_team><![CDATA[" ).append(checkNull(rs.getString("WORK_TEAM"))).append( "]]></work_team>\r\n" );
								valueXmlString.append( "<sales_pers><![CDATA[" ).append(checkNull(sprsCode)).append( "]]></sales_pers>\r\n" );
								valueXmlString.append( "<chg_date><![CDATA[" ).append(currDate).append( "]]></chg_date>\r\n" );
								valueXmlString.append( "<chg_user><![CDATA[" ).append(userId).append( "]]></chg_user>\r\n" );
								valueXmlString.append( "<chg_term><![CDATA[" ).append(chgTerm).append( "]]></chg_term>\r\n" );
								valueXmlString.append( "<locality_code visible='1' protect='1'><![CDATA[" ).append(places).append( "]]></locality_code>\r\n" );//added visible "0" by kailash.
								valueXmlString.append( "<sales_pers_sp_name><![CDATA[" ).append("").append( "]]></sales_pers_sp_name>\r\n" );
								valueXmlString.append( "<sprs_code__ww><![CDATA[" ).append("").append( "]]></sprs_code__ww>\r\n" );
								valueXmlString.append( "<event_date><![CDATA[" ).append(trvDate).append( "]]></event_date>\r\n" );
								//valueXmlString.append( "<strg_name><![CDATA[]]></strg_name>\r\n" );
								// added by rupali on 31/08/18 for inserting strg name and address as in strg_meet table [start]
								valueXmlString.append( "<strg_name visible='0'><![CDATA[" ).append(checkNull(rs.getString("SC_NAME"))).append( "]]></strg_name>\r\n" );//added visible "0" by kailash.
								//valueXmlString.append( "<address_as visible='0'><![CDATA[" ).append( checkNull(rs.getString("ADDRESS_AS")) ).append( "]]></address_as>\r\n" );//added visible "0" by kailash.
								valueXmlString.append( "<address_as protect='1' visible='1'><![CDATA[" ).append( checkNull(rs.getString("ADDRESS_AS")) ).append( "]]></address_as>\r\n" );//added visible 1 by Bhagyashri T
								// added by rupali on 31/08/18 for inserting strg name and address as in strg_meet table [end]
								valueXmlString.append( "<strg_type><![CDATA[" ).append(checkNull(rs.getString("STRG_TYPE"))).append( "]]></strg_type>\r\n" );
								valueXmlString.append( "<strg_no_visit><![CDATA[" ).append(checkNull(rs.getString("STRG_NO_VISIT"))).append("]]></strg_no_visit>\r\n" );
								//if(actType.indexOf("NFW")!=-1 || actType.indexOf("LEAVE")!=-1)//Added & commented by mrunalini sinkar for NFW activity type not found(13-02-2019)
								if(!"FW".equalsIgnoreCase(actType))
								{
									valueXmlString.append( "<strg_class_code visible='0'><![CDATA[ ]]></strg_class_code>\r\n" );//added visible "0" by kailash.
								}
								else
								{
									valueXmlString.append( "<strg_class_code visible='0'><![CDATA[" ).append(checkNull(rs.getString("STRG_CLASS_CODE"))).append( "]]></strg_class_code>\r\n" );//added visible "0" by kailash.
								}
								valueXmlString.append( "<sales_team><![CDATA[" ).append("").append( "]]></sales_team>\r\n" );
								valueXmlString.append( "<template_file><![CDATA[" ).append("").append( "]]></template_file>\r\n" );
								/*valueXmlString.append( "<last_meet_summ><![CDATA[" ).append("").append( "]]></last_meet_summ>\r\n" );
								valueXmlString.append( "<last_meet_date><![CDATA[" ).append("").append( "]]></last_meet_date>\r\n" ); */ // commenetd by shweta 06-05-21
								valueXmlString.append( "<last_meet_summ><![CDATA[" ).append(lastMeetSumm).append( "]]></last_meet_summ>\r\n" );   // added by shweta for display last remark and last met deta 06-05-21
								valueXmlString.append( "<last_meet_date><![CDATA[" ).append(priorVisitDate).append( "]]></last_meet_date>\r\n" ); // added by shweta for display last remark and last met deta 06-05-21
								valueXmlString.append( "<reg_no protect='1'><![CDATA[" ).append(regNumber).append( "]]></reg_no>\r\n" );         // added by shweta //added by shweta for registration value 21-05-21
								valueXmlString.append( "<price_list protect='1' visible='0'><![CDATA[" ).append(priceList).append( "]]></price_list>\r\n" ); //Added by bhagyashri T For Price_list SO[W22EBAS004]
								valueXmlString.append( "<last_prod_brf><![CDATA[" ).append("").append( "]]></last_prod_brf>\r\n" );
								valueXmlString.append( "<ref_tran_id><![CDATA[" ).append("").append( "]]></ref_tran_id>\r\n" );
								valueXmlString.append( "<conf_date><![CDATA[" ).append("").append( "]]></conf_date>\r\n" );
								valueXmlString.append( "<confirmed><![CDATA[" ).append("").append( "]]></confirmed>\r\n" );
								valueXmlString.append( "<emp_code__aprv><![CDATA[" ).append("").append( "]]></emp_code__aprv>\r\n" );
								valueXmlString.append( "<sc_code__ref><![CDATA[" ).append("").append( "]]></sc_code__ref>\r\n" );
								valueXmlString.append( "<meet_summ_mgr><![CDATA[" ).append("").append( "]]></meet_summ_mgr>\r\n" );
								valueXmlString.append( "<dcr_id><![CDATA[" ).append(dcrID).append( "]]></dcr_id>\r\n" );//Gaurav Singh on 10-06-2015
								valueXmlString.append( "<tran_id><![CDATA[" ).append(checkNull(rs.getString("TRAN_ID"))).append( "]]></tran_id>\r\n" );//Gulzar on 04/07/17
								valueXmlString.append( "<doc_visit_dates><![CDATA[" ).append(strgPriorVisitNo).append( "]]></doc_visit_dates>\r\n" );
								//added visible "0" by kailash[start]
								valueXmlString.append( "<addr1 visible='0'><![CDATA[" ).append(checkNull(rs.getString("ADDR1"))).append( "]]></addr1>\r\n" );//Gulzar on 17/06/12
								valueXmlString.append( "<addr2 visible='0'><![CDATA[" ).append(checkNull(rs.getString("ADDR2"))).append( "]]></addr2>\r\n" );//Gulzar on 17/06/12
								valueXmlString.append( "<addr3 visible='0'><![CDATA[" ).append(checkNull(rs.getString("ADDR3"))).append( "]]></addr3>\r\n" );//Gulzar on 17/06/12
								//added visible "0" by kailash[end]
								//added by prachi
								//System.out.println("lineno8121pk");
								valueXmlString.append( "<age visible='0'><![CDATA[" ).append("").append( "]]></age>\r\n" );
								valueXmlString.append( "<add_geopos><![CDATA[" ).append(checkNull(rs.getString("ADD_GEOPOS"))).append( "]]></add_geopos>\r\n" );
								valueXmlString.append( "<chg_geopos><![CDATA[" ).append(checkNull(rs.getString("CHG_GEOPOS"))).append( "]]></chg_geopos>\r\n" );
								valueXmlString.append( "<geopos_accuracy><![CDATA[" ).append(checkNull(rs.getString("GEOPOS_ACCURACY"))).append( "]]></geopos_accuracy>\r\n" ); //changes made by rupali on 20/07/18 for adding geopos_accuracy tag
								String visitedWith = checkNull(genericUtility.getColumnValue("visited_with", dom2, "1"));
								if("Y".equalsIgnoreCase(defVisitWithData))
								{
									valueXmlString.append( "<select_team><![CDATA[" ).append(visitedWith).append( "]]></select_team>\r\n" );

								}
								else
								{
									valueXmlString.append( "<select_team><![CDATA[" ).append("").append( "]]></select_team>\r\n" );

								}
								valueXmlString.append( "<speciality_descr visible='1'><![CDATA[" ).append(specialityDescr).append( "]]></speciality_descr>\r\n" );//added visible "0" by kailash.
								// added by rupali on 08/11/17 for displaying class code descr on customer screen
								valueXmlString.append( "<class_code_descr visible='0'><![CDATA[" ).append(classCodeDescr).append( "]]></class_code_descr>\r\n" );//added visible "0" by kailash.

								if("A".equalsIgnoreCase(classCode))
								{
									valueXmlString.append( "<class_code_color><![CDATA[green]]></class_code_color>\r\n" );
								}
								else if("B".equalsIgnoreCase(classCode))
								{
									valueXmlString.append( "<class_code_color><![CDATA[yellow]]></class_code_color>\r\n" );
								}
								else if("C".equalsIgnoreCase(classCode))
								{
									valueXmlString.append( "<class_code_color><![CDATA[red]]></class_code_color>\r\n" );
								}
								else
								{
									valueXmlString.append( "<class_code_color><![CDATA[]]></class_code_color>\r\n" );
								}
								valueXmlString.append( "<sku_value><![CDATA[" ).append( checkNull(rs.getString("SKU_VALUE")) ).append( "]]></sku_value>\r\n" );
								
								valueXmlString.append( "<strg_gst_no><![CDATA[" ).append( strgGstNo).append( "]]></strg_gst_no>\r\n" ); 
								valueXmlString.append( "<strg_state><![CDATA[" ).append( strgState).append( "]]></strg_state>\r\n" );
								valueXmlString.append( "<net_amt protect='1' visible='1'><![CDATA[" ).append( checkNull(rs.getString("NET_AMT")) ).append( "]]></net_amt>\r\n" );//Added by bhagayshri to set total on edit mode
								valueXmlString.append( "<tax_amount protect='1' visible='1'><![CDATA[" ).append( checkNull(rs.getString("TAX_AMOUNT")) ).append( "]]></tax_amount>\r\n" );//Added by bhagayshri to set total on edit mode
								valueXmlString.append( "<amount protect='1' visible='1'><![CDATA[" ).append( checkNull(rs.getString("AMOUNT")) ).append( "]]></amount>\r\n" );//Added by bhagayshri to set total on edit mode
								valueXmlString.append( "<invoice_amount><![CDATA[" ).append(invoicAmount).append( "]]></invoice_amount>\r\n" ); 
								valueXmlString.append( "<total_sgst_amt><![CDATA[" ).append( sgstAmount).append( "]]></total_sgst_amt>\r\n" ); 
								valueXmlString.append( "<total_cgst_amt><![CDATA[" ).append( cgstAmount).append( "]]></total_cgst_amt>\r\n" ); 
								valueXmlString.append( "<total_cgst><![CDATA[" ).append(totCgst).append( "]]></total_cgst>\r\n" ); //Added by Bhagyashri T for CGST AND SGST
								valueXmlString.append( "<total_sgst><![CDATA[" ).append(totSgst).append( "]]></total_sgst>\r\n" ); //Added by Bhagyashri T for CGST AND SGST
								
								valueXmlString.append( "<validate_no_visit><![CDATA[" ).append( checkNull(parmValue) ).append( "]]></validate_no_visit>\r\n" );
								valueXmlString.append( "<form_name><![CDATA[" ).append( checkNull(formName) ).append( "]]></form_name>\r\n" );
								valueXmlString.append( "<current_form_subform><![CDATA[" ).append( subFormDetails ).append( "]]></current_form_subform>\r\n" );
								// added by rupali on 07/11/17 for showing stockist_code and name in edit mode [start]
								valueXmlString.append( "<stockist_code><![CDATA[" ).append(stockistCode).append( "]]></stockist_code>\r\n" );
								valueXmlString.append( "<stockist_name><![CDATA[" ).append(stockistName).append( "]]></stockist_name>\r\n" );
								valueXmlString.append( "<reg_no protect='1'><![CDATA[" ).append(regNumber).append( "]]></reg_no>\r\n" );         // added by shweta //added by shweta for registration value 21-05-21
								valueXmlString.append( "<price_list protect='1' visible='0'><![CDATA[" ).append(priceList).append( "]]></price_list>\r\n" ); //Added by bhagyashri T For Price_list SO[W22EBAS016]
								// added by rupali on 07/11/17 for showing stockist_code and name in edit mode [end]
								// added by rupali on 04/09/18 for inserting speciality_code in strg_meet table [start]
								//Added and changed by kailash on 14-09-18[start]
								valueXmlString.append( "<spl_code visible='0'><![CDATA[" ).append( checkNull(rs.getString("SPL_CODE")) ).append( "]]></spl_code>\r\n" );
								valueXmlString.append( "<mobile_no visible='0'><![CDATA[" ).append( checkNull(rs.getString("MOBILE_NO")) ).append( "]]></mobile_no>\r\n" );// change for newcustadd
								valueXmlString.append( "<email_addr visible='0'><![CDATA[" ).append( checkNull(rs.getString("EMAIL_ADDR")) ).append( "]]></email_addr>\r\n" );
								valueXmlString.append( "<gender visible='0'><![CDATA[" ).append( checkNull(rs.getString("GENDER")) ).append( "]]></gender>\r\n" );
								//added by mrunalini sinkar to provide multiple locality selection on 17-nov-2018(start)
								//String placeData[]=getLocalityForStrgVisitHrsCustomer(strgCode,routeId,"ROUTE_ID",sprsCode,stockistTable,connectionObject);

								//selLocality = getLocalityForStrgVisitHrsCustomer(strgCode,locality,"LOCALITY_CODE",sprsCode,stockistTable,connectionObject);
								//selRouteId = getLocalityForStrgVisitHrsCustomer(strgCode,routeId,"ROUTE_ID",sprsCode,stockistTable,connectionObject);
								/*								selLocality=placeData[0];
								selRouteId=placeData[1];*/
								if(placeData!=null && placeData.containsKey(checkNull(strgCode)))
								{
									String mapValue=(String) placeData.get(checkNull(strgCode));
									String allValue[]=mapValue.split("@");
									selRouteId=allValue[0];
									selLocality=allValue[1];
								}
								valueXmlString.append("<sel_loc_code><![CDATA[" ).append(selLocality).append( "]]></sel_loc_code>\r\n" );
								valueXmlString.append("<sel_route_id><![CDATA[" ).append(selRouteId).append( "]]></sel_route_id>\r\n" );
								//added by mrunalini sinkar to provide multiple locality selection on 17-nov-2018(end)
								//Added by kailash on 23-01-19 for chc related changes[start].
								valueXmlString.append("<subclass_code visible='0'><![CDATA[" ).append(checkNull(rs.getString("SUBCLASS_CODE"))).append( "]]></subclass_code>\r\n" );
								valueXmlString.append("<subclass_descr visible='0'><![CDATA[" ).append(checkNull(rs.getString("SUBCLASS_DESCR"))).append( "]]></subclass_descr>\r\n" );
								valueXmlString.append("<pin visible='0'><![CDATA[" ).append(checkNull(rs.getString("PIN"))).append( "]]></pin>\r\n" );
								valueXmlString.append("<promoter_name visible='0'><![CDATA[" ).append(checkNull(rs.getString("PROMOTER_NAME"))).append( "]]></promoter_name>\r\n" );
								valueXmlString.append("<man_power visible='0'><![CDATA[" ).append(rs.getInt("MAN_POWER")).append( "]]></man_power>\r\n" );
								valueXmlString.append("<image_id visible='0'><![CDATA[" ).append(checkNull(rs.getString("IMAGE_ID"))).append( "]]></image_id>\r\n" );
								valueXmlString.append("<gst_no visible='0'><![CDATA[" ).append(checkNull(rs.getString("GST_NO"))).append( "]]></gst_no>\r\n" );
								//Added by kailash on 23-01-19 for chc related changes[end].
								valueXmlString.append("<next_plan_date visible='1'><![CDATA[" ).append(checkNull(showDate)).append( "]]></next_plan_date>\r\n" );//Added by mrunalini sinkar for next plan date
								//valueXmlString.append("<allow_edit_cust><![CDATA[" ).append(allowEditCust).append( "]]></allow_edit_cust>\r\n" );

							}
							else
							{
								//System.out.println("inside else of cust list");
								String unlistedSplCode = checkNull(rs.getString("SPL_CODE"));
								String splDescr = getSplDescrUnlistedCustomer(sprsCode,unlistedSplCode,connectionObject);
								//System.out.println("unlistedSplCode["+unlistedSplCode+"]splDescr["+splDescr+"]");
								//commented & added  by mrunalini sinkar on 30-01-2019(start)
								/*if(strgType.equalsIgnoreCase("D"))
								{
									valueXmlString.append("<cust_type visible='1' protect='0'><![CDATA[" ).append("UNLISTED-DOCTOR").append( "]]></cust_type>\r\n" );
								}
								else if(strgType.equalsIgnoreCase("C"))
								{
									valueXmlString.append("<cust_type visible='1' protect='0'><![CDATA[" ).append("UNLISTED-RETAILER").append( "]]></cust_type>\r\n" );
								}
								else if(strgType.equalsIgnoreCase("S"))
								{
									valueXmlString.append("<cust_type visible='1' protect='0'><![CDATA[" ).append("UNLISTED-STOCKIST").append( "]]></cust_type>\r\n" );
								}
								else if(strgType.equalsIgnoreCase("O"))
								{
									valueXmlString.append("<cust_type visible='1' protect='0'><![CDATA[" ).append("UNLISTED-OTHER").append( "]]></cust_type>\r\n" );
								}*/

								if(!isMemberPresent.equalsIgnoreCase("Y"))//added by mrunalini sinakr for member present
								{
									if("D".equalsIgnoreCase(strgType) || "C".equalsIgnoreCase(strgType))
									{
										valueXmlString.append( "<stockist_code visible='1' protect='0'><![CDATA[" ).append(stockistCode).append( "]]></stockist_code>\r\n" );
										valueXmlString.append( "<stockist_name visible='1' protect='1'><![CDATA[" ).append(stockistName).append( "]]></stockist_name>\r\n" );
									}
									else
									{
										valueXmlString.append( "<stockist_code visible='0' protect='0'><![CDATA[" ).append(stockistCode).append( "]]></stockist_code>\r\n" );
										valueXmlString.append( "<stockist_name visible='0' protect='1'><![CDATA[" ).append(stockistName).append( "]]></stockist_name>\r\n" );
									}
									if(!"FW".equalsIgnoreCase(actType))
									{
										valueXmlString.append("<cust_name><![CDATA[-NA-]]></cust_name>\r\n");
									}
									else
									{
										valueXmlString.append("<cust_name visible='0' protect='1'><![CDATA[" ).append( checkNull(rs.getString("SC_NAME")).trim()).append( "]]></cust_name>\r\n");
									}
									valueXmlString.append( "<call_outcome visible='1'><![CDATA[" ).append(checkNull(callOutCome)).append( "]]></call_outcome>\r\n" );
									valueXmlString.append( "<addr1 visible='1' protect='0'><![CDATA[" ).append(checkNull(rs.getString("ADDR1"))).append( "]]></addr1>\r\n" );
									valueXmlString.append( "<addr2 visible='1' protect='0'><![CDATA[" ).append(checkNull(rs.getString("ADDR2"))).append( "]]></addr2>\r\n" );
									valueXmlString.append( "<addr3 visible='1' protect='0'><![CDATA[" ).append(checkNull(rs.getString("ADDR3"))).append( "]]></addr3>\r\n" );
									//added by prachi
									System.out.println("lineno8222pk MRDAR");
									valueXmlString.append( "<age visible='1' protect='0'><![CDATA[" ).append(checkNull(rs.getString("AGE"))).append( "]]></age>\r\n" );

									valueXmlString.append( "<strg_name visible='1' protect ='0'><![CDATA[" ).append(checkNull(rs.getString("SC_NAME"))).append( "]]></strg_name>\r\n" );
									valueXmlString.append( "<address_as visible='1' protect ='0'><![CDATA[" ).append( checkNull(rs.getString("ADDRESS_AS")) ).append( "]]></address_as>\r\n" );
									if(!"FW".equalsIgnoreCase(actType))
									{
										valueXmlString.append( "<strg_class_code visible='0'><![CDATA[ ]]></strg_class_code>\r\n" );
									}
									else
									{
										valueXmlString.append( "<strg_class_code visible='1' protect ='0'><![CDATA[" ).append(checkNull(rs.getString("STRG_CLASS_CODE"))).append( "]]></strg_class_code>\r\n" );
									}
									valueXmlString.append( "<class_code_descr visible='1' protect ='1'><![CDATA[" ).append(classCodeDescr).append( "]]></class_code_descr>\r\n" );
									valueXmlString.append( "<spl_code visible='1' protect='0'><![CDATA[" ).append( checkNull(rs.getString("SPL_CODE")) ).append( "]]></spl_code>\r\n" );
									valueXmlString.append( "<speciality_descr visible='1' protect='1'><![CDATA[" ).append(splDescr).append( "]]></speciality_descr>\r\n" );
									valueXmlString.append( "<mobile_no visible='1' protect='0'><![CDATA[" ).append( checkNull(rs.getString("MOBILE_NO")) ).append( "]]></mobile_no>\r\n" );
									valueXmlString.append( "<email_addr visible='1' protect='0'><![CDATA[" ).append( checkNull(rs.getString("EMAIL_ADDR")) ).append( "]]></email_addr>\r\n" );
									valueXmlString.append( "<gender visible='1' protect='0'><![CDATA[" ).append( checkNull(rs.getString("GENDER")) ).append( "]]></gender>\r\n" );
									valueXmlString.append( "<event_time_start visible='1'><![CDATA[" ).append( checkNull(rs.getString("EVENT_TIME_START"))).append( "]]></event_time_start>\r\n" );//Added by Hariom S for Table View ralated Changes -08-July-2021
									valueXmlString.append( "<visit_time_from visible='0'><![CDATA[" ).append( checkNull(rs.getString("EVENT_TIME_START"))).append( "]]></visit_time_from>\r\n" );// For chc to dhow visit tme from for unlisted
									if("Y".equalsIgnoreCase(eventHideTimeEnd))
									{
										valueXmlString.append( "<event_time_end visible='0'><![CDATA[" ).append( checkNull(rs.getString("EVENT_TIME_END"))).append( "]]></event_time_end>\r\n" );
									}
									else
									{
										valueXmlString.append( "<event_time_end visible='1'><![CDATA[" ).append( checkNull(rs.getString("EVENT_TIME_END"))).append( "]]></event_time_end>\r\n" );
									}
									//Added by kailash on 23-01-19 for chc related changes[start].
									valueXmlString.append("<subclass_code visible='1'><![CDATA[" ).append( checkNull(rs.getString("SUBCLASS_CODE"))).append( "]]></subclass_code>\r\n" );
									valueXmlString.append("<subclass_descr visible='1'><![CDATA[" ).append(checkNull(rs.getString("SUBCLASS_DESCR"))).append( "]]></subclass_descr>\r\n" );
									valueXmlString.append("<pin visible='1'><![CDATA[" ).append(checkNull(rs.getString("PIN"))).append( "]]></pin>\r\n" );
									valueXmlString.append("<promoter_name visible='1'><![CDATA[" ).append(checkNull(rs.getString("PROMOTER_NAME"))).append( "]]></promoter_name>\r\n" );
									valueXmlString.append("<man_power visible='1'><![CDATA[" ).append(rs.getInt("MAN_POWER")).append( "]]></man_power>\r\n" );
									valueXmlString.append("<image_id visible='1'><![CDATA[" ).append(checkNull(rs.getString("IMAGE_ID"))).append( "]]></image_id>\r\n" );
									valueXmlString.append("<gst_no visible='1'><![CDATA[" ).append(checkNull(rs.getString("GST_NO"))).append( "]]></gst_no>\r\n" );
									valueXmlString.append("<next_plan_date visible='1'><![CDATA[" ).append(checkNull(showDate)).append( "]]></next_plan_date>\r\n" );//Added by mrunalini sinkar for next plan date
									valueXmlString.append( "<locality_code visible='1' protect='0'><![CDATA[" ).append(places).append( "]]></locality_code>\r\n" );
									valueXmlString.append( "<locality_descr protect='1'><![CDATA[" ).append( checkNull(rs.getString("LOC_DESCR"))).append( "]]></locality_descr>\r\n" );
									valueXmlString.append("<cust_type visible='1' protect='0'><![CDATA[" ).append(checkNull(getCustTypeDesc(strgType,connectionObject ))).append( "]]></cust_type>\r\n" );
									//System.out.println("activitycode in unlist:"+eventType);
									if("Y".equalsIgnoreCase(isFortune))
									{
										String meetingStatus="";
										//added by Bhagyashri T for Fortune meeting_status issue[22/11/21]
										String mettingSql="SELECT CALL_OUTCOME_DESCR FROM CALL_OUTCOME WHERE CALL_OUTCOME = ? AND ACTIVITY_CODE= ? ";
										PreparedStatement meetPstmt =connectionObject.prepareStatement(mettingSql);
										meetPstmt.setString(1, callOutCome);
										meetPstmt.setString(2, eventType);
										ResultSet meetRs=meetPstmt.executeQuery();
										if(meetRs.next())
										{
											meetingStatus=checkNull(meetRs.getString("CALL_OUTCOME_DESCR"));
										}
										if (meetRs!= null)
										{
											meetRs.close();
											meetRs = null;
										}
										if(meetPstmt!=null)
										{
											meetPstmt.close();
											meetPstmt = null;
										}
										valueXmlString.append( "<meet_summ><![CDATA[" ).append(checkNull(rs.getString("MEET_SUMM"))).append( "]]></meet_summ>\r\n" );
										valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append(meetingStatus).append( "]]></calloutcome_descr>\r\n" );
										valueXmlString.append( "<meeting_status><![CDATA[" ).append(meetingStatus).append( "]]></meeting_status>\r\n" );
										valueXmlString.append( "<subform_meeting_status><![CDATA[" ).append(meetingStatus).append( "]]></subform_meeting_status>\r\n" );

									}
									else
									{
										if(callOutCome.equalsIgnoreCase("4"))
										{
											valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Very Positive").append( "]]></calloutcome_descr>\r\n" );
										}
										else if(callOutCome.equalsIgnoreCase("3"))
										{
											valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Average").append( "]]></calloutcome_descr>\r\n" );
										}
										else if(callOutCome.equalsIgnoreCase("2"))
										{
											valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Below Average").append( "]]></calloutcome_descr>\r\n" );
										}
										else if(callOutCome.equalsIgnoreCase("1"))
										{
											valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Negative").append( "]]></calloutcome_descr>\r\n" );
										}
										else if(callOutCome.equalsIgnoreCase("5"))
										{
											valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Supporter").append( "]]></calloutcome_descr>\r\n" );
										}
										else if(callOutCome.equalsIgnoreCase("6"))
										{
											valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Believer").append( "]]></calloutcome_descr>\r\n" );
										}
										else if(callOutCome.equalsIgnoreCase("7"))
										{
											valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Non Believer").append( "]]></calloutcome_descr>\r\n" );
										}
										else if(callOutCome.equalsIgnoreCase("0"))
										{
											valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Refused").append( "]]></calloutcome_descr>\r\n" );
										}
										if(callOutCome.equalsIgnoreCase("0"))
										{
											valueXmlString.append( "<meet_summ protect = '1'><![CDATA[" ).append("").append( "]]></meet_summ>\r\n" );
										}
										else
										{
											valueXmlString.append( "<meet_summ><![CDATA[" ).append(checkNull(rs.getString("MEET_SUMM"))).append( "]]></meet_summ>\r\n" );
										}
									}
									
									valueXmlString.append("<member_present visible='0'><![CDATA[" ).append(checkNull(rs.getString("MEMBER_PRESENT"))).append( "]]></member_present>\r\n" );
									valueXmlString.append("<qualification visible='1'><![CDATA[" ).append(checkNull(rs.getString("QUALIFICATION")) ).append( "]]></qualification>\r\n" );
									valueXmlString.append( "<strg_no_visit visible='1'><![CDATA[" ).append(checkNull(rs.getString("STRG_NO_VISIT"))).append("]]></strg_no_visit>\r\n" );

								}
								else//added by mrunalini sinakr for member present
								{
									unlistSun=true;
									valueXmlString.append("<cust_type visible='1' protect='1'><![CDATA[" ).append(checkNull(getCustTypeDesc(strgType,connectionObject ))).append( "]]></cust_type>\r\n" );
									valueXmlString.append("<stockist_code visible='0' protect='0'><![CDATA[" ).append(stockistCode).append( "]]></stockist_code>\r\n" );
									valueXmlString.append("<stockist_name visible='0' protect='1'><![CDATA[" ).append(stockistName).append( "]]></stockist_name>\r\n" );
									//valueXmlString.append("<cust_name visible='0' protect='1' format='[unlisted-customer:member_present]'><![CDATA[" ).append( checkNull(rs.getString("SC_NAME")).trim()).append( "]]></cust_name>\r\n"); //Commended by Hariom S for Table View ralated Changes -08-July-2021
									valueXmlString.append("<cust_name visible='0' protect='1' format='[unlisted-customer:member_present]'><![CDATA[" ).append( checkNull(rs.getString("SC_NAME")).trim()).append( "]]></cust_name>\r\n"); //Added by Hariom S for Table View ralated Changes -08-July-2021
									valueXmlString.append( "<call_outcome visible='0'><![CDATA[" ).append(checkNull(callOutCome)).append( "]]></call_outcome>\r\n" );
									valueXmlString.append( "<addr1 visible='0' protect='0'><![CDATA[" ).append(checkNull(rs.getString("ADDR1"))).append( "]]></addr1>\r\n" );
									valueXmlString.append( "<addr2 visible='0' protect='0'><![CDATA[" ).append(checkNull(rs.getString("ADDR2"))).append( "]]></addr2>\r\n" );
									valueXmlString.append( "<addr3 visible='0' protect='0'><![CDATA[" ).append(checkNull(rs.getString("ADDR3"))).append( "]]></addr3>\r\n" );
									//added by prachi
									valueXmlString.append( "<age visible='0' protect='0'><![CDATA[" ).append(checkNull(rs.getString("AGE"))).append( "]]></age>\r\n" );
									valueXmlString.append( "<strg_name visible='0' protect ='0'><![CDATA[" ).append(checkNull(rs.getString("SC_NAME"))).append( "]]></strg_name>\r\n" );
									valueXmlString.append( "<address_as visible='0' protect ='0'><![CDATA[" ).append( checkNull(rs.getString("ADDRESS_AS")) ).append( "]]></address_as>\r\n" );
									valueXmlString.append( "<strg_class_code visible='0' protect ='0'><![CDATA[" ).append(checkNull(rs.getString("STRG_CLASS_CODE"))).append( "]]></strg_class_code>\r\n" );
									valueXmlString.append( "<class_code_descr visible='0' protect ='1'><![CDATA[" ).append(classCodeDescr).append( "]]></class_code_descr>\r\n" );
									valueXmlString.append( "<spl_code visible='0' protect='0'><![CDATA[" ).append( checkNull(rs.getString("SPL_CODE")) ).append( "]]></spl_code>\r\n" );
									valueXmlString.append( "<speciality_descr visible='0' protect='1'><![CDATA[" ).append(splDescr).append( "]]></speciality_descr>\r\n" );
									valueXmlString.append( "<mobile_no visible='0' protect='0'><![CDATA[" ).append( checkNull(rs.getString("MOBILE_NO")) ).append( "]]></mobile_no>\r\n" );
									valueXmlString.append( "<email_addr visible='0' protect='0'><![CDATA[" ).append( checkNull(rs.getString("EMAIL_ADDR")) ).append( "]]></email_addr>\r\n" );
									valueXmlString.append( "<gender visible='0' protect='0'><![CDATA[" ).append( checkNull(rs.getString("GENDER")) ).append( "]]></gender>\r\n" );
									//valueXmlString.append( "<event_time_start visible='1' protect='0'><![CDATA[" ).append( checkNull(rs.getString("EVENT_TIME_START"))).append( "]]></event_time_start>\r\n" );
									valueXmlString.append( "<event_time_start visible='1' protect='0'><![CDATA[" ).append( checkNull(rs.getString("EVENT_TIME_START"))).append( "]]></event_time_start>\r\n" );//Added by Hariom S for Table View ralated Changes -08-July-2021
									valueXmlString.append( "<visit_time_from visible='0' protect='0'><![CDATA[" ).append( checkNull(rs.getString("EVENT_TIME_START"))).append( "]]></visit_time_from>\r\n" );
									valueXmlString.append( "<event_time_end visible='1' protect='0'><![CDATA[" ).append( checkNull(rs.getString("EVENT_TIME_END"))).append( "]]></event_time_end>\r\n" );
									//Added by kailash on 23-01-19 for chc related changes[start].
									valueXmlString.append("<subclass_code visible='0'><![CDATA[" ).append( checkNull(rs.getString("SUBCLASS_CODE"))).append( "]]></subclass_code>\r\n" );
									valueXmlString.append("<subclass_descr visible='0'><![CDATA[" ).append(checkNull(rs.getString("SUBCLASS_DESCR"))).append( "]]></subclass_descr>\r\n" );
									valueXmlString.append("<pin visible='0'><![CDATA[" ).append(checkNull(rs.getString("PIN"))).append( "]]></pin>\r\n" );
									valueXmlString.append("<promoter_name visible='0'><![CDATA[" ).append(checkNull(rs.getString("PROMOTER_NAME"))).append( "]]></promoter_name>\r\n" );
									valueXmlString.append("<man_power visible='0'><![CDATA[" ).append(rs.getInt("MAN_POWER")).append( "]]></man_power>\r\n" );
									valueXmlString.append("<image_id visible='0'><![CDATA[" ).append(checkNull(rs.getString("IMAGE_ID"))).append( "]]></image_id>\r\n" );
									valueXmlString.append("<gst_no visible='0'><![CDATA[" ).append(checkNull(rs.getString("GST_NO"))).append( "]]></gst_no>\r\n" );
									valueXmlString.append("<next_plan_date visible='0'><![CDATA[" ).append(checkNull(showDate)).append( "]]></next_plan_date>\r\n" );//Added by mrunalini sinkar for next plan date
									valueXmlString.append("<locality_code visible='0' protect='0'><![CDATA[" ).append(places).append( "]]></locality_code>\r\n" );
									//valueXmlString.append("<locality_descr protect='0'><![CDATA[" ).append( checkNull(rs.getString("LOC_DESCR"))).append( "]]></locality_descr>\r\n" );commented by mrunalini sinkar as per discusttion with Gulzar Sir
									valueXmlString.append( "<meet_summ visible='0'><![CDATA[" ).append(checkNull(rs.getString("MEET_SUMM"))).append( "]]></meet_summ>\r\n" );
									valueXmlString.append("<member_present visible='1'><![CDATA[" ).append(checkNull(rs.getString("MEMBER_PRESENT"))).append( "]]></member_present>\r\n" );
									//valueXmlString.append("<allow_edit_cust><![CDATA[" ).append(allowEditCust).append( "]]></allow_edit_cust>\r\n" );
									valueXmlString.append("<qualification visible='0'><![CDATA[" ).append(checkNull(rs.getString("QUALIFICATION")) ).append( "]]></qualification>\r\n" );
									valueXmlString.append( "<strg_no_visit visible='0'><![CDATA[" ).append(checkNull(rs.getString("STRG_NO_VISIT"))).append("]]></strg_no_visit>\r\n" );
								}

								//commented & added  by mrunalini sinkar on 30-01-2019(start)
								valueXmlString.append("<sr_no><![CDATA[" ).append(srNo).append( "]]></sr_no>\r\n");
								valueXmlString.append("<to_disable><![CDATA[Y]]></to_disable>\r\n");
								valueXmlString.append("<short_id><![CDATA[" ).append( checkNull(rs.getString("SHORT_ID")).trim()).append( "]]></short_id>\r\n");
								valueXmlString.append("<strg_code visible='0'><![CDATA[" ).append( checkNull(rs.getString("STRG_CODE")).trim()).append( "]]></strg_code>\r\n");
								valueXmlString.append("<uniq_strg_code protect = '1' visible = '0'><![CDATA[" ).append( checkNull(rs.getString("STRG_CODE")).trim()).append( "]]></uniq_strg_code>\r\n" );//Added by Bhagyashri for [W21JFOR007]
								//if(actType.indexOf("NFW")!=-1 || actType.indexOf("LEAVE")!=-1)//Added & commented by mrunalini sinkar for NFW activity type not found(13-02-2019)

								valueXmlString.append("<sel_loc_code><![CDATA[" ).append(selLocality).append( "]]></sel_loc_code>\r\n" );
								valueXmlString.append("<sel_route_id><![CDATA[" ).append(selRouteId).append( "]]></sel_route_id>\r\n" );// added by mrunalini sinakr for route id on 27-april-2019
								valueXmlString.append("<order_booked><![CDATA[" ).append( checkNull(rs.getString("ORDER_BOOKED"))).append( "]]></order_booked>\r\n" );
								valueXmlString.append("<remarks><![CDATA[" ).append(checkNull(rs.getString("REMARKS"))).append( "]]></remarks>\r\n" );

								//valueXmlString.append( "<call_outcome><![CDATA[" ).append(checkNull(callOutCome)).append( "]]></call_outcome>\r\n" );

								//valueXmlString.append( "<addr1 visible='1' protect='0'><![CDATA[" ).append(checkNull(rs.getString("ADDR1"))).append( "]]></addr1>\r\n" );
								//valueXmlString.append( "<addr2 visible='1' protect='0'><![CDATA[" ).append(checkNull(rs.getString("ADDR2"))).append( "]]></addr2>\r\n" );
								//valueXmlString.append( "<addr3 visible='1' protect='0'><![CDATA[" ).append(checkNull(rs.getString("ADDR3"))).append( "]]></addr3>\r\n" );

								//valueXmlString.append( "<oth_participant><![CDATA[" ).append(otherParticipantDb).append( "]]></oth_participant>\r\n" );
								//valueXmlString.append( "<visited_with_display><![CDATA[" ).append(workWith).append( "]]></visited_with_display>\r\n" );
								if("JW".equalsIgnoreCase(actCode) && "FW".equalsIgnoreCase(actType))//Gulzar on 17/06/12
								{
									valueXmlString.append( "<work_with_other><![CDATA[" ).append(workWithOther).append( "]]></work_with_other>\r\n" );
								}
								else
								{
									valueXmlString.append( "<work_with_other><![CDATA[" ).append("").append( "]]></work_with_other>\r\n" );
								}
								valueXmlString.append( "<work_team><![CDATA[" ).append(checkNull(rs.getString("WORK_TEAM"))).append( "]]></work_team>\r\n" );
								valueXmlString.append( "<sales_pers><![CDATA[" ).append(checkNull(sprsCode)).append( "]]></sales_pers>\r\n" );
								valueXmlString.append( "<chg_date><![CDATA[" ).append(currDate).append( "]]></chg_date>\r\n" );
								valueXmlString.append( "<chg_user><![CDATA[" ).append(userId).append( "]]></chg_user>\r\n" );
								valueXmlString.append( "<chg_term><![CDATA[" ).append(chgTerm).append( "]]></chg_term>\r\n" );

								valueXmlString.append( "<sales_pers_sp_name><![CDATA[" ).append("").append( "]]></sales_pers_sp_name>\r\n" );
								valueXmlString.append( "<sprs_code__ww><![CDATA[" ).append("").append( "]]></sprs_code__ww>\r\n" );
								valueXmlString.append( "<event_date><![CDATA[" ).append(trvDate).append( "]]></event_date>\r\n" );
								//valueXmlString.append( "<strg_name visible='1' protect ='0'><![CDATA[" ).append(checkNull(rs.getString("SC_NAME"))).append( "]]></strg_name>\r\n" );
								//valueXmlString.append( "<address_as visible='1' protect ='0'><![CDATA[" ).append( checkNull(rs.getString("ADDRESS_AS")) ).append( "]]></address_as>\r\n" );
								valueXmlString.append( "<strg_type><![CDATA[" ).append(checkNull(rs.getString("STRG_TYPE"))).append( "]]></strg_type>\r\n" );
								//valueXmlString.append( "<strg_no_visit><![CDATA[" ).append(checkNull(rs.getString("STRG_NO_VISIT"))).append("]]></strg_no_visit>\r\n" );
								//if(actType.indexOf("NFW")!=-1 || actType.indexOf("LEAVE")!=-1)//Added & commented by mrunalini sinkar for NFW activity type not found(13-02-2019)
								/*if(!"FW".equalsIgnoreCase(actType))
								{
									valueXmlString.append( "<strg_class_code visible='0'><![CDATA[ ]]></strg_class_code>\r\n" );
								}
								else
								{
									valueXmlString.append( "<strg_class_code visible='1' protect ='0'><![CDATA[" ).append(checkNull(rs.getString("STRG_CLASS_CODE"))).append( "]]></strg_class_code>\r\n" );
								}*/
								//valueXmlString.append( "<class_code_descr visible='1' protect ='0'><![CDATA[" ).append(classCodeDescr).append( "]]></class_code_descr>\r\n" );
								valueXmlString.append( "<sales_team><![CDATA[" ).append("").append( "]]></sales_team>\r\n" );
								valueXmlString.append( "<template_file><![CDATA[" ).append("").append( "]]></template_file>\r\n" );
								/*valueXmlString.append( "<last_meet_summ><![CDATA[" ).append("").append( "]]></last_meet_summ>\r\n" );
								valueXmlString.append( "<last_meet_date><![CDATA[" ).append("").append( "]]></last_meet_date>\r\n" );*/ // commented by shweta 06-05-21
								valueXmlString.append( "<last_meet_summ><![CDATA[" ).append(lastMeetSumm).append( "]]></last_meet_summ>\r\n" );  // added by shweta 06-05-21
								valueXmlString.append( "<last_meet_date><![CDATA[" ).append(priorVisitDate).append( "]]></last_meet_date>\r\n" );
								valueXmlString.append( "<reg_no protect='0'><![CDATA[" ).append(regNumber).append( "]]></reg_no>\r\n" );         // added by shweta //added by shweta for registration value 21-05-21
								valueXmlString.append( "<price_list protect='1' visible='0'><![CDATA[" ).append(priceList).append( "]]></price_list>\r\n" );//Added by bhagyashri T For Price_list SO[W22EBAS016]
								valueXmlString.append( "<last_prod_brf><![CDATA[" ).append("").append( "]]></last_prod_brf>\r\n" );
								valueXmlString.append( "<ref_tran_id><![CDATA[" ).append("").append( "]]></ref_tran_id>\r\n" );
								valueXmlString.append( "<conf_date><![CDATA[" ).append("").append( "]]></conf_date>\r\n" );
								valueXmlString.append( "<confirmed><![CDATA[" ).append(checkNull(rs.getString("CONFIRMED"))).append( "]]></confirmed>\r\n" );
								valueXmlString.append( "<emp_code__aprv><![CDATA[" ).append("").append( "]]></emp_code__aprv>\r\n" );
								valueXmlString.append( "<sc_code__ref><![CDATA[" ).append("").append( "]]></sc_code__ref>\r\n" );
								valueXmlString.append( "<meet_summ_mgr><![CDATA[" ).append("").append( "]]></meet_summ_mgr>\r\n" );
								valueXmlString.append( "<dcr_id><![CDATA[" ).append(dcrID).append( "]]></dcr_id>\r\n" );
								valueXmlString.append( "<tran_id><![CDATA[" ).append(checkNull(rs.getString("TRAN_ID"))).append( "]]></tran_id>\r\n" );
								valueXmlString.append( "<doc_visit_dates><![CDATA[" ).append(strgPriorVisitNo).append( "]]></doc_visit_dates>\r\n" );

								valueXmlString.append( "<add_geopos><![CDATA[" ).append(checkNull(rs.getString("ADD_GEOPOS"))).append( "]]></add_geopos>\r\n" );
								valueXmlString.append( "<chg_geopos><![CDATA[" ).append(checkNull(rs.getString("CHG_GEOPOS"))).append( "]]></chg_geopos>\r\n" );
								valueXmlString.append( "<geopos_accuracy><![CDATA[" ).append(checkNull(rs.getString("GEOPOS_ACCURACY"))).append( "]]></geopos_accuracy>\r\n" );
								String visitedWith = checkNull(genericUtility.getColumnValue("visited_with", dom2, "1"));
								if("Y".equalsIgnoreCase(defVisitWithData))
								{
									valueXmlString.append( "<select_team><![CDATA[" ).append(visitedWith).append( "]]></select_team>\r\n" );

								}
								else
								{
									valueXmlString.append( "<select_team><![CDATA[" ).append("").append( "]]></select_team>\r\n" );

								}


								//valueXmlString.append( "<spl_code visible='1' protect='0'><![CDATA[" ).append( checkNull(rs.getString("SPL_CODE")) ).append( "]]></spl_code>\r\n" );
								//valueXmlString.append( "<speciality_descr visible='1' protect='1'><![CDATA[" ).append(splDescr).append( "]]></speciality_descr>\r\n" );


								if("A".equalsIgnoreCase(classCode))
								{
									valueXmlString.append( "<class_code_color><![CDATA[green]]></class_code_color>\r\n" );
								}
								else if("B".equalsIgnoreCase(classCode))
								{
									valueXmlString.append( "<class_code_color><![CDATA[yellow]]></class_code_color>\r\n" );
								}
								else if("C".equalsIgnoreCase(classCode))
								{
									valueXmlString.append( "<class_code_color><![CDATA[red]]></class_code_color>\r\n" );
								}
								else
								{
									valueXmlString.append( "<class_code_color><![CDATA[]]></class_code_color>\r\n" );
								}
								valueXmlString.append( "<sku_value visible='1' protect='1'><![CDATA[" ).append( checkNull(rs.getString("SKU_VALUE")) ).append( "]]></sku_value>\r\n" );
								
								valueXmlString.append( "<net_amt protect='1' visible='1'><![CDATA[" ).append( checkNull(rs.getString("NET_AMT")) ).append( "]]></net_amt>\r\n" );//Added by bhagayshri to set total on edit mode
								valueXmlString.append( "<tax_amount protect='1' visible='1'><![CDATA[" ).append( checkNull(rs.getString("TAX_AMOUNT")) ).append( "]]></tax_amount>\r\n" );//Added by bhagayshri to set total on edit mode
								valueXmlString.append( "<amount protect='1' visible='1'><![CDATA[" ).append( checkNull(rs.getString("AMOUNT")) ).append( "]]></amount>\r\n" );//Added by bhagayshri to set total on edit mode
								valueXmlString.append( "<invoice_amount><![CDATA[" ).append(invoicAmount).append( "]]></invoice_amount>\r\n" ); 
								valueXmlString.append( "<total_sgst_amt><![CDATA[" ).append( sgstAmount).append( "]]></total_sgst_amt>\r\n" ); 
								valueXmlString.append( "<total_cgst_amt><![CDATA[" ).append( cgstAmount).append( "]]></total_cgst_amt>\r\n" ); 
								valueXmlString.append( "<total_cgst><![CDATA[" ).append(totCgst).append( "]]></total_cgst>\r\n" ); //Added by Bhagyashri T for CGST AND SGST
								valueXmlString.append( "<total_sgst><![CDATA[" ).append(totSgst).append( "]]></total_sgst>\r\n" ); //Added by Bhagyashri T for CGST AND SGST
								
								valueXmlString.append( "<validate_no_visit><![CDATA[" ).append( checkNull(parmValue) ).append( "]]></validate_no_visit>\r\n" );
								valueXmlString.append( "<form_name><![CDATA[" ).append( checkNull(formName) ).append( "]]></form_name>\r\n" );
								valueXmlString.append( "<dcr_mode><![CDATA[" ).append( "EDIT REPORT" ).append( "]]></dcr_mode>\r\n" );//added by hariom 19-oct-19

								valueXmlString.append( "<current_form_subform><![CDATA[" ).append( subFormDetails ).append( "]]></current_form_subform>\r\n" );
								//valueXmlString.append( "<stockist_code visible='1' protect='0'><![CDATA[" ).append(stockistCode).append( "]]></stockist_code>\r\n" );
								//valueXmlString.append( "<stockist_name visible='1' protect='1'><![CDATA[" ).append(stockistName).append( "]]></stockist_name>\r\n" );

								/*valueXmlString.append( "<mobile_no visible='1' protect='0'><![CDATA[" ).append( checkNull(rs.getString("MOBILE_NO")) ).append( "]]></mobile_no>\r\n" );
								valueXmlString.append( "<email_addr visible='1' protect='0'><![CDATA[" ).append( checkNull(rs.getString("EMAIL_ADDR")) ).append( "]]></email_addr>\r\n" );
								valueXmlString.append( "<gender visible='1' protect='0'><![CDATA[" ).append( checkNull(rs.getString("GENDER")) ).append( "]]></gender>\r\n" );
								valueXmlString.append( "<event_time_start visible='0' protect='1'><![CDATA[" ).append( checkNull(rs.getString("EVENT_TIME_START"))).append( "]]></event_time_start>\r\n" );
								valueXmlString.append( "<event_time_end visible='0' protect='1'><![CDATA[" ).append( checkNull(rs.getString("EVENT_TIME_END"))).append( "]]></event_time_end>\r\n" );
								//Added by kailash on 23-01-19 for chc related changes[start].
								valueXmlString.append("<subclass_code visible='1'><![CDATA[" ).append( checkNull(rs.getString("SUBCLASS_CODE"))).append( "]]></subclass_code>\r\n" );
								valueXmlString.append("<subclass_descr visible='1'><![CDATA[" ).append(checkNull(rs.getString("SUBCLASS_DESCR"))).append( "]]></subclass_descr>\r\n" );
								valueXmlString.append("<pin visible='1'><![CDATA[" ).append(checkNull(rs.getString("PIN"))).append( "]]></pin>\r\n" );
								valueXmlString.append("<promoter_name visible='1'><![CDATA[" ).append(checkNull(rs.getString("PROMOTER_NAME"))).append( "]]></promoter_name>\r\n" );
								valueXmlString.append("<man_power visible='1'><![CDATA[" ).append(rs.getInt("MAN_POWER")).append( "]]></man_power>\r\n" );
								valueXmlString.append("<image_id visible='1'><![CDATA[" ).append(checkNull(rs.getString("IMAGE_ID"))).append( "]]></image_id>\r\n" );
								valueXmlString.append("<gst_no visible='1'><![CDATA[" ).append(checkNull(rs.getString("GST_NO"))).append( "]]></gst_no>\r\n" );
								 */								//Added by kailash on 23-01-19 for chc related changes[end].
							}
							//Added and changed by kailash on 14-09-18[end]
							// added by rupali on 04/09/18 for inserting speciality_code in strg_meet table [end]
							valueXmlString.append("<allow_edit_cust><![CDATA[" ).append(allowEditCust).append( "]]></allow_edit_cust>\r\n" );
							//Added by Mrunalini Sinkar For Fortune(Start)
							valueXmlString.append("<is_form_mandatory><![CDATA[" ).append(formMandatory).append( "]]></is_form_mandatory>\r\n" );
							valueXmlString.append("<is_member_present><![CDATA[" ).append(isMemberPresent).append( "]]></is_member_present>\r\n" );
							valueXmlString.append("<sprs_act_code><![CDATA[" ).append(sprsActCode).append( "]]></sprs_act_code>\r\n" );
							valueXmlString.append("<is_fortune_activity><![CDATA[" ).append(isFortune).append( "]]></is_fortune_activity>\r\n" );
							//Added by Mrunalini Sinkar For Fortune(End)

							valueXmlString.append( "</Detail"+currentForm+">\r\n" );
							domID++;
						}
						customers = getCustFromDom(genericUtility.parseString("<Root>"+valueXmlString.toString()+"</Root>"),currentForm ,sprsCode , "Y",connectionObject); //Chnaged by sachin satre on 11-nov-16

					}
					if (rs!= null)
					{
						rs.close();
						rs = null;
					}
					if(pstmt!=null)
					{
						pstmt.close();
						pstmt = null;
					}
				}
			}
			if(pstmtCheckStrgMeet!=null)
			{
				pstmtCheckStrgMeet.close();
				pstmtCheckStrgMeet = null;
			}
			if( customers != null && customers.length() == 0 )
			{
				customers = "'x'";
			}
			//Added by Hariom for get Max dom if of preDomExist -- 12-Apr-2021 [Start]
			if(flag)
			{
				//System.out.println("domID----------"+domID);
				ArrayList<Integer> domIdList = new ArrayList<Integer>();
				//domIdList  = getDomIdListFromDom2( dom,  currentFormNumber);
				domIdList  = getDomIdListFromDom2( dom, "domID" , currentFormNumber);
				//System.out.println("domIdList----------"+domIdList);
				if(!domIdList.isEmpty())
				{
					int maxVal = Collections.max(domIdList);
					domID = maxVal+1;
				}

			}
			//Added by Hariom for get Max dom if of preDomExist -- 12-Apr-2021 [End]

			/*sql = "SELECT TRIM(PROP_VALUE) AS MEET_START_TIME FROM PROPERTIES WHERE PROP_NAME ='MEET_START_TIME'";
			//System.out.println( " [StrgMeetWizEJB]sql [" + sql + "]" );
			stmt = connectionObject.createStatement();
			rs = stmt.executeQuery( sql );
			if( rs.next() )
			{
				startTime = checkNull(rs.getString( "MEET_START_TIME" ));
			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(stmt!=null)
			{
				stmt.close();
				stmt = null;
			}
			// added by rupali on 14/12/17 for showing event_time_from and event_time_to fields on customer screen [start]
			String format = "AM";
			String timeFrom = startTime+" "+format;
			String timeTo = "";
			// added by rupali on 14/12/17 for showing event_time_from and event_time_to fields on customer screen [end]
			sql = "SELECT TRIM(PROP_VALUE) AS MEET_INTERVAL FROM PROPERTIES WHERE PROP_NAME ='MEET_INTERVAL'";
			//System.out.println( " [StrgMeetWizEJB]sql [" + sql + "]" );
			stmt = connectionObject.createStatement();
			rs = stmt.executeQuery( sql );
			if( rs.next() )
			{
				interval = checkNull(rs.getString( "MEET_INTERVAL" ));
			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(stmt!=null)
			{
				stmt.close();
				stmt = null;
			}*/

			//Cfor duplicate doctor entry.start

			//System.out.println("locality=["+locality+"]");

			if ( locality == null || locality.trim().length() == 0 )
			{
				locality = "''";
			}
			if ( routeId == null || routeId.trim().length() == 0 )
			{
				routeId = "''";
			}
			String sfaParmData  = getSfaParmValue(userId,"IS_PLAN_COMPULSORY",connectionObject); //Chnaged by sachin satre on 11-nov-16
			ArrayList<String> custList = new ArrayList<String>();
			//Added vinayak to not check plan on previous click and to show data as per selection [start]
			if(sfaParmData.equalsIgnoreCase("Y") && !"E".equalsIgnoreCase(modeReport))
			{
				String workDate = checkNull(getSelectedRowValue(dom2, mainFormNo, "event_date", 0));
				String planSql = "SELECT SC_CODE  FROM SPRS_PLAN_CUST CUST,SPRS_PLAN_HDR HDR WHERE " +
						"HDR.PLAN_DATE= ? AND HDR.SPRS_CODE__PLAN= ?  " +
						"AND HDR.PLAN_ID = CUST.PLAN_ID";
				pstmtPlan = connectionObject.prepareStatement(planSql);
				pstmtPlan.setTimestamp( 1, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( workDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
				pstmtPlan.setString(2,userId);
				rsPlan = pstmtPlan.executeQuery();
				while(rsPlan.next())
				{
					custList.add(rsPlan.getString("SC_CODE").trim());
				}
				//added Bu Nilesh Start::02-06-2017
				if (rsPlan!= null)
				{
					rsPlan.close();
					rsPlan = null;
				}
				if(pstmtPlan!=null)
				{
					pstmtPlan.close();
					pstmtPlan = null;
				}
				//added By Nilesh End::02-06-2017
				//System.out.println("custList :::: "+custList.toString());
			}
			//Added vinayak to not check plan on previous click and to show data as per selection [end]

			//Added by Mrunalini sinkar to configure status_hist table changes11-02-2020(start)
			String statusHistConfig = checkNull(getSfaParmValue(userId,"STATUS_HIST_REQUIRED",connectionObject));//Added by Mrunalini sinkar to configure status_hist table changes on 11-02-2020
			String statusHistCondition="";
			if("Y".equalsIgnoreCase(statusHistConfig))
			{
				statusHistCondition="AND SS.SC_CODE IN (SELECT SC_CODE FROM STRG_STATUS_HIST WHERE STATUS = 'Y' AND EFF_FROM <= ? AND VALID_UPTO >= ? AND SALES_PERS = SS.SALES_PERS AND SC_CODE = SC.SC_CODE )" ;
			}
			//Added by Mrunalini sinkar to configure status_hist table changes11-02-2020(end)
			System.out.println("Before the add sql for check gst_no and strg_state");
			if (custType.equalsIgnoreCase("O"))
			{
				// commented & added by mrunalini sinkar to provide multiple locality selection on 17-nov-2018(start)

				/*sql = "SELECT SS.SHORT_ID MPLNO, SS.SPL_CODE, SP.DESCR SPL_DECR, "+
						" SC.SC_CODE CODE, UPPER(SC.FIRST_NAME)||' '||UPPER(SC.LAST_NAME) AS SC_NAME, SC.ADDRESS_AS,  "+
						" L.DESCR LOC_DESCR, SS.CLASS_CODE CLASS_CODE,  "+
						" SS.NO_VISIT NO_VISIT, SC.CUST_TYPE CUST_TYPE, SC.LOCALITY_CODE LOCALITY_CODE,  "+
						" SC.ADDR1 AS ADDR1, SC.ADDR2 AS ADDR2, SC.ADDR3  AS ADDR3 " +
						" FROM STRG_CUSTOMER SC,  LOCALITY L, STRG_SERIES SS LEFT OUTER JOIN SPECIALITY SP ON SP.SPL_CODE = SS.SPL_CODE "+
						" WHERE SS.SC_CODE = SC.SC_CODE  "+
						" AND SC.LOCALITY_CODE = L.LOCALITY_CODE  "+
						" AND SS.SALES_PERS = ? "+
						" AND SS.SC_CODE IN "+
						" (SELECT SC_CODE FROM STRG_STATUS_HIST WHERE STATUS = 'Y' "+
						" AND EFF_FROM <= ? AND VALID_UPTO >= ? "+
						" AND SALES_PERS = SS.SALES_PERS  "+
						" AND SC_CODE = SC.SC_CODE ) "+
						" AND SC.CUST_TYPE NOT IN ('D','C','S') " +//Gulzar on 6/10/2012
						" AND SC.LOCALITY_CODE IN ( "+locality+") AND SS.SC_CODE NOT IN ( "+customers+" ) "+
						//" ORDER BY SHORT_ID ";
						" ORDER BY SC_NAME "; //changed by Ashutosh -26-Dec-17*/
				//Added by mrunalini sinkar to add dcr_group cahnges in strg_cust_type table on 3-dec-2018(start)
				sql = "SELECT DISTINCT(SC.SC_CODE) CODE, SS.SPL_CODE, SP.DESCR SPL_DECR,SCT.DESCR  CUST_TYPE_DESCR,SR.ROUTE_ID AS ROUTE_ID, "+//added CUST_TYPE_DESCR by mrunalini S. on 03-nov-2018
						" SS.SHORT_ID MPLNO,SC.SC_CODE CODE, UPPER(SC.FIRST_NAME)||' '||UPPER(SC.MIDDLE_NAME)||' '||UPPER(SC.LAST_NAME) AS SC_NAME, SC.ADDRESS_AS, SC.MOBILE_NO, SC.EMAIL_ADDR, SC.SEX, "+
						" (CASE WHEN SR.ROUTE_DESCR IS NOT NULL THEN SR.ROUTE_DESCR ELSE SR.DESCR END ) LOC_DESCR, SS.CLASS_CODE CLASS_CODE,  "+
						" SS.NO_VISIT NO_VISIT, SC.CUST_TYPE CUST_TYPE, L.LOCALITY_CODE LOCALITY_CODE,  "+
						" SC.ADDR1 AS ADDR1, SC.ADDR2 AS ADDR2, SC.ADDR3  AS ADDR3,L.DEF_DISTRIBUTOR AS DEF_DISTRIBUTOR, " +
						" SC.PROMOTER_NAME AS PROMOTER_NAME, SC.GST_NO AS GST_NO, SC.MAN_POWER AS MAN_POWER, SS.SUBCLASS_CODE AS SUBCLASS_CODE,SC.PIN AS PIN,(case when SC.SURVEY_TEMPL is null then (CASE WHEN SCT.SURVEY_TEMPL IS NULL THEN '"+sfaParmVal+"' ELSE SCT.SURVEY_TEMPL END) else SC.SURVEY_TEMPL END) AS SURVEY_TEMPL  "+//Added by kailash on 24-01-19 for chc related changes.
						" ,SC.QUALIFICATION AS QUALIFICATION,SCS.SUBCLASS_DESCR AS SUBCLASS_DESCR ,SC.REG_NO,SC.PRICE_LIST,STATE.DESCR AS STRG_STATE "+ // added by shweta //added by shweta for registration value 21-05-21
						" FROM STRG_CUSTOMER SC LEFT OUTER JOIN STRG_VISIT_HOURS SVH ON SC.SC_CODE=SVH.SC_CODE LEFT OUTER JOIN STATE STATE ON SC.STATE_CODE=STATE.STATE_CODE,  LOCALITY L, STRG_SERIES SS LEFT OUTER JOIN SPECIALITY SP ON SP.SPL_CODE = SS.SPL_CODE"+
						" LEFT OUTER JOIN STRG_CUST_SUBCLASS SCS ON SS.CLASS_CODE=SCS.SUBCLASS_CODE AND SS.CUST_TYPE=SCS.CUST_TYPE AND SS.SUBCLASS_CODE=SCS.SUBCLASS_CODE, "+
						" STRG_CUST_TYPE SCT,SPRS_ROUTE SR  WHERE SS.SC_CODE = SC.SC_CODE AND SR.SPRS_CODE=SS.SALES_PERS AND SR.ROUTE_ID=SS.ROUTE_ID AND SR.LOCALITY_CODE=L.LOCALITY_CODE "+ //added STRG_CUST_TYPE table by mrunalini S. on 03-nov-2018
						" AND  (SC.LOCALITY_CODE=L.LOCALITY_CODE OR SVH.LOCALITY_CODE=L.LOCALITY_CODE OR SC.RES_LOCALITY_CODE=L.LOCALITY_CODE) "+
						" AND SS.SALES_PERS = ?  AND SS.STATUS IN('Y','A') AND SR.STATUS='Y'"+
						//Added by Mrunalini sinkar to configure status_hist table changes11-02-2020(start)
						/*
						" AND SS.SC_CODE IN "+
						" (SELECT SC_CODE FROM STRG_STATUS_HIST WHERE STATUS = 'Y' "+
						" AND EFF_FROM <= ? AND VALID_UPTO >= ? "+
						" AND SALES_PERS = SS.SALES_PERS  "+
						" AND SC_CODE = SC.SC_CODE ) "+*/
						statusHistCondition+" "+
						//Added by Mrunalini sinkar to configure status_hist table changes11-02-2020(end)
						" AND SCT.TYPE=SC.CUST_TYPE "+ 	//added condition & dcr_group table by mrunalini S. on 03-nov-2018
						" AND SCT.DCR_GROUP NOT IN ('D','C','S') " +
						" AND L.LOCALITY_CODE IN ( "+locality+") AND SS.SC_CODE NOT IN ( "+customers+" ) AND SR.ROUTE_ID IN("+routeId+") "+
						" ORDER BY LOC_DESCR,SC_NAME ";
				//Added by mrunalini sinkar to add dcr_group cahnges in strg_cust_type table on 3-dec-2018(end)
				// commented & added by mrunalini sinkar to provide multiple locality selection on 17-nov-2018(END)

			}
			else if(custType.equalsIgnoreCase("S") && stockistTable.equalsIgnoreCase("SPRS_STOCKIST"))
			{
				sql = "SELECT DISTINCT(CUST.CUST_CODE) CODE, SS.SHORT_ID MPLNO, SCT.DESCR CUST_TYPE_DESCR,SR.ROUTE_ID AS ROUTE_ID, CUST_NAME AS SC_NAME, "+
						"CUST.EMAIL_ADDR,(CASE WHEN SR.ROUTE_DESCR IS NOT NULL THEN SR.ROUTE_DESCR ELSE SR.DESCR END )  LOC_DESCR, CUST.CUST_TYPE CUST_TYPE, "+
						"L.LOCALITY_CODE LOCALITY_CODE, CUST.ADDR1 AS ADDR1, CUST.ADDR2 AS ADDR2, CUST.ADDR3  AS ADDR3, L.DEF_DISTRIBUTOR AS DEF_DISTRIBUTOR, "+
						"CUST.PIN AS PIN,(CASE WHEN SCT.SURVEY_TEMPL IS NULL THEN 'ST00000001'  ELSE SCT.SURVEY_TEMPL END) AS SURVEY_TEMPL, CUST.BLACK_LISTED, "+
						"'' AS SPL_CODE, '' AS SPL_DECR, CUST.SH_NAME AS ADDRESS_AS,'' AS MOBILE_NO, '' AS SEX, '' AS CLASS_CODE, '' AS NO_VISIT, '' AS PROMOTER_NAME, "+
						"'' AS GST_NO, '' AS MAN_POWER, '' AS SUBCLASS_CODE, '' AS QUALIFICATION,'' AS SUBCLASS_DESCR ,'' AS REG_NO,'' AS PRICE_LIST,'' ASSTRG_STATE "+ // added by shweta 
						"FROM CUSTOMER CUST LEFT OUTER JOIN STRG_VISIT_HOURS SVH ON CUST.CUST_CODE = SVH.SC_CODE,  LOCALITY L, SPRS_STOCKIST SS, STRG_CUST_TYPE SCT,SPRS_ROUTE SR "+
						"WHERE SS.CUST_CODE = CUST.CUST_CODE AND SR.SPRS_CODE = SS.SPRS_CODE AND SR.ROUTE_ID = SS.ROUTE_ID AND SR.LOCALITY_CODE = L.LOCALITY_CODE "+
						"AND (CUST.LOCALITY_CODE = L.LOCALITY_CODE OR SVH.LOCALITY_CODE = L.LOCALITY_CODE )  AND SS.SPRS_CODE = ? AND SS.STATUS IN ('Y','A') "+
						"AND SR.STATUS='Y' AND SCT.TYPE = CUST.CUST_TYPE AND SCT.DCR_GROUP = 'S' AND L.LOCALITY_CODE IN ( "+locality+") "+
						"AND SS.CUST_CODE NOT IN ("+customers+" ) AND SR.ROUTE_ID IN("+routeId+") AND CUST.BLACK_LISTED <> 'Y' ORDER BY LOC_DESCR,SC_NAME ";
			}
			else
			{
				// commented & added by mrunalini sinkar to provide multiple locality selection on 17-nov-2018(start)
				/*sql = "SELECT SS.SHORT_ID MPLNO, SS.SPL_CODE, SP.DESCR SPL_DECR, "+
						" SC.SC_CODE CODE, UPPER(SC.FIRST_NAME)||' '||UPPER(SC.LAST_NAME) AS SC_NAME, SC.ADDRESS_AS, SC.MOBILE_NO, SC.EMAIL_ADDR, SC.SEX, "+ //Sex added by kailash on 10-09-18.
						" L.DESCR LOC_DESCR, SS.CLASS_CODE CLASS_CODE,  "+
						" SS.NO_VISIT NO_VISIT, SC.CUST_TYPE CUST_TYPE, SC.LOCALITY_CODE LOCALITY_CODE,  "+
						" SC.ADDR1 AS ADDR1, SC.ADDR2 AS ADDR2, SC.ADDR3  AS ADDR3, L.DEF_DISTRIBUTOR AS DEF_DISTRIBUTOR " + // added by rupali on 29 dec for getting def_distributor value
						" FROM STRG_CUSTOMER SC,  LOCALITY L, STRG_SERIES SS LEFT OUTER JOIN SPECIALITY SP ON SP.SPL_CODE = SS.SPL_CODE "+
						" WHERE SS.SC_CODE = SC.SC_CODE  "+
						" AND SC.LOCALITY_CODE = L.LOCALITY_CODE  "+
						" AND SS.SALES_PERS = ? "+
						" AND SS.SC_CODE IN "+
						" (SELECT SC_CODE FROM STRG_STATUS_HIST WHERE STATUS = 'Y' "+
						" AND EFF_FROM <= ? AND VALID_UPTO >= ? "+
						" AND SALES_PERS = SS.SALES_PERS  "+
						" AND SC_CODE = SC.SC_CODE ) "+
						" AND SC.CUST_TYPE =? " +//Gulzar on 6/10/2012
						" AND SC.LOCALITY_CODE IN ( "+locality+") AND SS.SC_CODE NOT IN ( "+customers+" ) "+
						//" ORDER BY SHORT_ID ";
						" ORDER BY SC_NAME ";*/
				//Added by mrunalini sinkar to add dcr_group cahnges in strg_cust_type table on 3-dec-2018(start)
				//commented & added by mrunalini sinkar for showing BEAT DESCRIPTION CHANGES ON 26-03-2019(start)
				/*sql = "SELECT DISTINCT(SC.SC_CODE) CODE, SS.SHORT_ID MPLNO, SS.SPL_CODE, SP.DESCR SPL_DECR,SCT.DESCR  CUST_TYPE_DESCR, "+//added CUST_TYPE_DESCR by mrunalini S. on 03-nov-2018
						" UPPER(SC.FIRST_NAME)||' '||UPPER(SC.LAST_NAME) AS SC_NAME, SC.ADDRESS_AS, SC.MOBILE_NO, SC.EMAIL_ADDR, SC.SEX, "+
						" L.DESCR LOC_DESCR, SS.CLASS_CODE CLASS_CODE,  "+
						" SS.NO_VISIT NO_VISIT, SC.CUST_TYPE CUST_TYPE, L.LOCALITY_CODE LOCALITY_CODE,  "+
						" SC.ADDR1 AS ADDR1, SC.ADDR2 AS ADDR2, SC.ADDR3  AS ADDR3, L.DEF_DISTRIBUTOR AS DEF_DISTRIBUTOR, " +
						" SC.PROMOTER_NAME AS PROMOTER_NAME, SC.GST_NO AS GST_NO, SC.MAN_POWER AS MAN_POWER, SS.SUBCLASS_CODE AS SUBCLASS_CODE,SC.PIN AS PIN "+//Added by kailash on 24-01-19 for chc related changes.
						" FROM STRG_CUSTOMER SC LEFT OUTER JOIN STRG_VISIT_HOURS SVH ON SC.SC_CODE=SVH.SC_CODE,  LOCALITY L, STRG_SERIES SS LEFT OUTER JOIN SPECIALITY SP ON SP.SPL_CODE = SS.SPL_CODE, "+
						" STRG_CUST_TYPE SCT WHERE SS.SC_CODE = SC.SC_CODE  "+			//added STRG_CUST_TYPE table by mrunalini S. on 03-nov-2018
						" AND (SC.LOCALITY_CODE=L.LOCALITY_CODE OR SVH.LOCALITY_CODE=L.LOCALITY_CODE OR SC.RES_LOCALITY_CODE=L.LOCALITY_CODE) "+
						" AND SS.SALES_PERS = ? "+
						" AND SS.SC_CODE IN "+
						" (SELECT SC_CODE FROM STRG_STATUS_HIST WHERE STATUS = 'Y' "+
						" AND EFF_FROM <= ? AND VALID_UPTO >= ? "+
						" AND SALES_PERS = SS.SALES_PERS  "+
						" AND SC_CODE = SC.SC_CODE ) "+
						" AND SCT.TYPE=SC.CUST_TYPE "+       	//added condition & dcr_group table by mrunalini S. on 03-nov-2018
						" AND SCT.DCR_GROUP =? " +
						" AND L.LOCALITY_CODE IN ( "+locality+") AND SS.SC_CODE NOT IN ( "+customers+" ) "+
						" ORDER BY CUST_TYPE,SC_NAME ";*/


				sql="SELECT DISTINCT(SC.SC_CODE) CODE, SS.SHORT_ID MPLNO, SS.SPL_CODE, SP.DESCR SPL_DECR,SCT.DESCR  CUST_TYPE_DESCR,SR.ROUTE_ID AS ROUTE_ID, " +
						" UPPER(SC.FIRST_NAME)||' '||UPPER(SC.MIDDLE_NAME)||' '||UPPER(SC.LAST_NAME) AS SC_NAME, SC.ADDRESS_AS, SC.MOBILE_NO, SC.EMAIL_ADDR, SC.SEX, " +
						" (CASE WHEN SR.ROUTE_DESCR IS NOT NULL THEN SR.ROUTE_DESCR ELSE SR.DESCR END )  LOC_DESCR, SS.CLASS_CODE CLASS_CODE,  " +
						" SS.NO_VISIT NO_VISIT, SC.CUST_TYPE CUST_TYPE, L.LOCALITY_CODE LOCALITY_CODE,  " +
						" SC.ADDR1 AS ADDR1, SC.ADDR2 AS ADDR2, SC.ADDR3  AS ADDR3, L.DEF_DISTRIBUTOR AS DEF_DISTRIBUTOR, " +
						" SC.PROMOTER_NAME AS PROMOTER_NAME, SC.GST_NO AS GST_NO, SC.MAN_POWER AS MAN_POWER, SS.SUBCLASS_CODE AS SUBCLASS_CODE,SC.PIN AS PIN,(case when SC.SURVEY_TEMPL is null then (CASE WHEN SCT.SURVEY_TEMPL IS NULL THEN '"+sfaParmVal+"'  ELSE SCT.SURVEY_TEMPL END) else SC.SURVEY_TEMPL END) AS SURVEY_TEMPL  " +
						" ,SC.QUALIFICATION AS QUALIFICATION,SCS.SUBCLASS_DESCR AS SUBCLASS_DESCR ,SC.REG_NO,SC.PRICE_LIST,STATE.DESCR AS STRG_STATE "+  // added vy shweta //added by shweta for registration value 21-05-21
						" FROM STRG_CUSTOMER SC LEFT OUTER JOIN STRG_VISIT_HOURS SVH ON SC.SC_CODE=SVH.SC_CODE LEFT OUTER JOIN STATE STATE ON SC.STATE_CODE=STATE.STATE_CODE,  LOCALITY L, STRG_SERIES SS LEFT OUTER JOIN SPECIALITY SP ON SP.SPL_CODE = SS.SPL_CODE"+
						" LEFT OUTER JOIN STRG_CUST_SUBCLASS SCS ON SS.CLASS_CODE=SCS.SUBCLASS_CODE AND SS.CUST_TYPE=SCS.CUST_TYPE AND SS.SUBCLASS_CODE=SCS.SUBCLASS_CODE, " +
						" STRG_CUST_TYPE SCT,SPRS_ROUTE SR WHERE SS.SC_CODE = SC.SC_CODE  AND SR.SPRS_CODE=SS.SALES_PERS AND SR.ROUTE_ID=SS.ROUTE_ID AND SR.LOCALITY_CODE=L.LOCALITY_CODE " +
						" AND (SC.LOCALITY_CODE=L.LOCALITY_CODE OR SVH.LOCALITY_CODE=L.LOCALITY_CODE OR SC.RES_LOCALITY_CODE=L.LOCALITY_CODE) " +
						" AND SS.SALES_PERS = ? AND SS.STATUS IN('Y','A') AND SR.STATUS='Y' " +
						//Added by Mrunalini sinkar to configure status_hist table changes11-02-2020(start)
						/*
						/*" AND SS.SC_CODE IN " +
						" (SELECT SC_CODE FROM STRG_STATUS_HIST WHERE STATUS = 'Y' " +
						" AND EFF_FROM <= ? AND VALID_UPTO >= ? " +
						" AND SALES_PERS = SS.SALES_PERS " +
						" AND SC_CODE = SC.SC_CODE ) " + */
						statusHistCondition+" "+
						//Added by Mrunalini sinkar to configure status_hist table changes11-02-2020(start)/*
						" AND SCT.TYPE=SC.CUST_TYPE " +
						" AND SCT.DCR_GROUP =?  " +
						" AND L.LOCALITY_CODE IN ("+locality+") AND SS.SC_CODE NOT IN ( "+customers+") AND SR.ROUTE_ID IN("+routeId+") " +
						" ORDER BY LOC_DESCR,SC_NAME";
				//commented & added by mrunalini sinkar for showing BEAT DESCRIPTION CHANGES ON 26-03-2019(start)
				//Added by mrunalini sinkar to add dcr_group cahnges in strg_cust_type table on 3-dec-2018(end)

				// commented & added by mrunalini sinkar to provide multiple locality selection on 17-nov-2018(end)
			}
			pstmt =  connectionObject.prepareStatement( sql );
			pstmt.setString(1, checkNull(sprsCode));
			if(!(custType.equalsIgnoreCase("S") && stockistTable.equalsIgnoreCase("SPRS_STOCKIST")) && "Y".equalsIgnoreCase(statusHistConfig))
			{
				pstmt.setTimestamp( 2, java.sql.Timestamp.valueOf( trvDBDate ) );
				pstmt.setTimestamp(3, java.sql.Timestamp.valueOf( trvDBDate ) );
			}
			else if(!custType.equalsIgnoreCase("O") && !(custType.equalsIgnoreCase("S") && stockistTable.equalsIgnoreCase("SPRS_STOCKIST")) && !"Y".equalsIgnoreCase(statusHistConfig))
			{
				pstmt.setString(2, custType);//Gulzar on 17/06/12
			}
			//if(!custType.equalsIgnoreCase("O"))
			if(!custType.equalsIgnoreCase("O") && !(custType.equalsIgnoreCase("S") && stockistTable.equalsIgnoreCase("SPRS_STOCKIST")) && "Y".equalsIgnoreCase(statusHistConfig))
			{
				pstmt.setString(4, custType);//Gulzar on 17/06/12
			}
			//System.out.println("actType:::::::= "+actType);
			//Added by bhagyashri T For check the Price_list SO[start][W22EBAS016]
			String pricelistS ="";
			String pricelistSQL = "SELECT ST.PRICE_LIST FROM STATE ST LEFT OUTER JOIN SALES_PERS SP ON ST.STATE_CODE=SP.STATE_CODE WHERE SP.SALES_PERS=? ";				
			PreparedStatement pstmts = connectionObject.prepareStatement(pricelistSQL);
            pstmts.setString(1, sprsCode);
            ResultSet rss = pstmts.executeQuery();
            if(rss.next())
            {
            	pricelistS=checkNull(rss.getString("PRICE_LIST"));
            }
            if (rss != null)
			{
				rss.close();
				rss = null;
			}
			if (pstmts != null)
			{
				pstmts.close();
				pstmts = null;
			}
			System.out.println("pricelistS of So is :::::::= "+pricelistS);
			//Added by bhagyashri T For check the Price_list SO[end][W22EBAS016]
			//if( actType.indexOf("NFW")!=-1 || actType.indexOf("LEAVE")!=-1)//Added & commented by mrunalini sinkar for NFW activity type not found(13-02-2019)
			if(!"FW".equalsIgnoreCase(actType))
			{
				//System.out.println("INSIDE THE GETCUSTOMER DETAIL WHEN nfw OR leAVE ACTIVITY");

				String sqlLoc = "SELECT DESCR FROM LOCALITY WHERE LOCALITY_CODE = ?";
				pstmt =  connectionObject.prepareStatement( sqlLoc );
				if ( temp.length > 0 )
				{
					for(int i = 0; i < temp.length; i++)
					{
						srNo++;
						String place = temp[i];
						//System.out.println("place =["+place+"]");
						if (place != null && place.trim().length() > 0 )
						{
							place = place.substring(1, place.length()-1);
						}
						//System.out.println("Before Activity Type");
						//if("NFW".equalsIgnoreCase(actType) && actType.trim().length() > 0) //Added & commented by mrunalini sinkar for NFW activity type not found(13-02-2019)
						if(!"FW".equalsIgnoreCase(actType) && !"LEAVE".equalsIgnoreCase(actType) && actType.trim().length() > 0)
						{
							//System.out.println("Inside Activity Type");
							valueXmlString.append( "<Detail"+currentForm+" domID='"+domID+"' selected = 'Y' formName='"+formName+"'>\r\n" );
							valueXmlString.append( "<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\"/>\r\n");//Gaurav Singh on 03/06/15
						}
						else
						{
							//System.out.println("Inside Activity Type3");
							valueXmlString.append( "<Detail"+currentForm+" domID='"+domID+"' selected = 'N' formName='"+formName+"'>\r\n" );
							valueXmlString.append( "<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");//Gaurav Singh on 03/06/15
						}
						if(editCustCnt>0)
						{
							valueXmlString.append("<is_finish_disable><![CDATA[" ).append("Y").append( "]]></is_finish_disable>\r\n" );
						}
						else
						{
							valueXmlString.append("<is_finish_disable><![CDATA[" ).append("N").append( "]]></is_finish_disable>\r\n" );
						}
						valueXmlString.append("<sr_no><![CDATA[" ).append(srNo).append( "]]></sr_no>\r\n"); // Added By Shahu Mali on  28/12/12
						valueXmlString.append("<short_id><![CDATA[NA]]></short_id>\r\n");
						valueXmlString.append("<strg_code><![CDATA[-NA-]]></strg_code>\r\n");
						valueXmlString.append("<cust_name><![CDATA[-NA-]]></cust_name>\r\n");
						pstmt.setString(1, checkNull(place));
						rs = pstmt.executeQuery();
						if ( rs.next())
						{
							valueXmlString.append( "<locality_descr><![CDATA[" ).append( checkNull(rs.getString("DESCR"))).append( "]]></locality_descr>\r\n" );
						}
						valueXmlString.append( "<order_booked><![CDATA[" ).append("0").append( "]]></order_booked>\r\n" );

						//	valueXmlString.append( "<event_time_start><![CDATA[" ).append(eventTime).append( "]]></event_time_start>\r\n" );//VINAYAKK
						valueXmlString.append( "<event_time_start><![CDATA[" ).append(timeFrom).append( "]]></event_time_start>\r\n" );//VINAYAKK
						valueXmlString.append( "<visit_time_from><![CDATA[" ).append(timeFrom).append( "]]></visit_time_from>\r\n" );
						/*int position=startTime.indexOf(':');
						hour = startTime.substring(0,position).trim();
						minute = startTime.substring( position+1 , startTime.length() ).trim();
						//System.out.println("hour =["+hour+"], minute=["+minute+"], interval=["+interval+"]");
						int hr=Integer.parseInt(hour);
						int min=Integer.parseInt(minute);
						// added by rupali on 14/12/17 for showing event_time_from and event_time_to fields on customer screen [start]
						int minIntrvl=Integer.parseInt(interval);
						minIntrvl = min + minIntrvl;
						if(hr == 11 && minIntrvl >= 60)
						{
							if("AM".equals(format))
							{
								format = "PM";
							}
							else if("PM".equals(format))
							{
								format = "AM";
							}
						}
						// added by rupali on 14/12/17 for showing event_time_from and event_time_to fields on customer screen [end]
						int intr =0;
						if( interval.length()>0 )
						{
							intr = Integer.parseInt( interval );
							min = min+intr;
							if( min>59 )
							{
								while( min > 59 )
								{
									hr=hr+1;
									min=min-60;
									// added by rupali on 15/12/17 for showing event_time_from and event_time_to fields on customer screen [start]
									if(hr == 11 && min >= 60)
									{
										if("AM".equals(format))
										{
											format = "PM";
										}
										else if("PM".equals(format))
										{
											format = "AM";
										}
									}
									// added by rupali on 15/12/17 for showing event_time_from and event_time_to fields on customer screen [end]
								}
								if( min==0 )
								{
									if( hr < 10 )
									{
										hours = "0"+hr;
									}
									else
									{
										hours = String.valueOf( hr );
									}
									timeTo = hours+":00"+" "+format; // added by rupali on 14/12/17 for showing event_time_from and event_time_to fields on customer screen
									//valueXmlString.append( "<event_time_end><![CDATA[" ).append( checkNull(hours+":00")).append( "]]></event_time_end>\r\n" );
								}
								else
								{
									if( hr < 10 )
									{
										hours="0"+hr;
									}
									else
									{
										hours=String.valueOf( hr );
									}
									if(min<10)
									{
										timeTo = hours+":0"+min+" "+format; // added by rupali on 14/12/17 for showing event_time_from and event_time_to fields on customer screen
										//valueXmlString.append( "<event_time_end><![CDATA[" ).append( checkNull(hours+":0"+min)).append( "]]></event_time_end>\r\n" );
									}
									else
									{
										timeTo = hours+":"+min+" "+format; // added by rupali on 14/12/17 for showing event_time_from and event_time_to fields on customer screen
										//valueXmlString.append( "<event_time_end><![CDATA[" ).append( checkNull(hours+":"+min)).append( "]]></event_time_end>\r\n" );
									}
								}
							}
							else
							{

								if( hr < 10 )
								{
									hours="0"+hr;
								}
								else
								{
									hours=String.valueOf( hr );
								}
								timeTo = hours+":"+min+" "+format; // added by rupali on 14/12/17 for showing event_time_from and event_time_to fields on customer screen
								//valueXmlString.append( "<event_time_end><![CDATA[" ).append( checkNull(hours+":"+min)).append( "]]></event_time_end>\r\n" );
							}
						}*/
						//valueXmlString.append( "<oth_participant><![CDATA[" ).append("").append( "]]></oth_participant>\r\n" );//Gulzar on 17/06/12
						//	valueXmlString.append( "<event_time_end><![CDATA[" ).append(eventTime).append( "]]></event_time_end>\r\n" );//VINAYAKK
						if("Y".equalsIgnoreCase(eventHideTimeEnd))
						{
							valueXmlString.append( "<event_time_end visible='0'><![CDATA[" ).append(timeTo).append( "]]></event_time_end>\r\n" );
						}
						else
						{
							valueXmlString.append( "<event_time_end visible='1'><![CDATA[" ).append(timeTo).append( "]]></event_time_end>\r\n" );
						}
						valueXmlString.append( "<oth_participant><![CDATA[" ).append("").append( "]]></oth_participant>\r\n" );
						valueXmlString.append( "<conatct_pers><![CDATA[" ).append("").append( "]]></contact_pers>\r\n" );//Added by bhagyashri T For Change OTH_PARTICIPANT TO CONTACT_PERS[22/02/22]
						valueXmlString.append( "<contact_pers_name><![CDATA[" ).append("").append( "]]></contact_pers>\r\n" );//Added by bhagyashri T For Change OTH_PARTICIPANT TO CONTACT_PERS[22/02/22]
						//valueXmlString.append( "<visited_with_display><![CDATA[" ).append(workWith).append( "]]></visited_with_display>\r\n" );
						if("JW".equalsIgnoreCase(actCode) && "FW".equalsIgnoreCase(actType))//Gulzar on 17/06/12
						{
							valueXmlString.append( "<work_with_other><![CDATA[" ).append(workWithOther).append( "]]></work_with_other>\r\n" );
						}
						else
						{
							valueXmlString.append( "<work_with_other><![CDATA[" ).append("").append( "]]></work_with_other>\r\n" );
						}
						valueXmlString.append( "<work_team><![CDATA[" ).append("Alone").append( "]]></work_team>\r\n" );
						valueXmlString.append( "<sales_pers><![CDATA[" ).append(checkNull(sprsCode)).append( "]]></sales_pers>\r\n" );
						valueXmlString.append( "<chg_date><![CDATA[" ).append(currDate).append( "]]></chg_date>\r\n" );
						valueXmlString.append( "<chg_user><![CDATA[" ).append(userId).append( "]]></chg_user>\r\n" );
						valueXmlString.append( "<chg_term><![CDATA[" ).append(chgTerm).append( "]]></chg_term>\r\n" );
						valueXmlString.append( "<locality_code><![CDATA[" ).append(place).append( "]]></locality_code>\r\n" );
						valueXmlString.append( "<meet_summ><![CDATA[" ).append("").append( "]]></meet_summ>\r\n" );
						valueXmlString.append( "<remarks><![CDATA[" ).append("").append( "]]></remarks>\r\n" );
						//commented by vishal pathare on 25.10.17 for[initial value should apply (Default Call outcome should be believer)].
						//valueXmlString.append( "<call_outcome><![CDATA[" ).append("5").append( "]]></call_outcome>\r\n" );
						//valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Supporter").append( "]]></calloutcome_descr>\r\n" );
						valueXmlString.append( "<sales_pers_sp_name><![CDATA[" ).append("").append( "]]></sales_pers_sp_name>\r\n" );
						valueXmlString.append( "<sprs_code__ww><![CDATA[" ).append("").append( "]]></sprs_code__ww>\r\n" );
						valueXmlString.append( "<event_date><![CDATA[" ).append(trvDate).append( "]]></event_date>\r\n" );
						valueXmlString.append( "<event_type><![CDATA[" ).append(actCode).append( "]]></event_type>\r\n" );
						valueXmlString.append( "<activity_type><![CDATA[" ).append(actType).append( "]]></activity_type>\r\n" );
						valueXmlString.append( "<strg_name><![CDATA[]]></strg_name>\r\n" );
						valueXmlString.append( "<strg_type><![CDATA[ ]]></strg_type>\r\n" );
						valueXmlString.append( "<strg_no_visit><![CDATA[0.0]]></strg_no_visit>\r\n" );
						valueXmlString.append( "<strg_class_code><![CDATA[ ]]></strg_class_code>\r\n" );
						valueXmlString.append( "<sales_team><![CDATA[" ).append("").append( "]]></sales_team>\r\n" );
						valueXmlString.append( "<template_file><![CDATA[" ).append("").append( "]]></template_file>\r\n" );
						valueXmlString.append( "<last_meet_summ><![CDATA[" ).append("").append( "]]></last_meet_summ>\r\n" );
						valueXmlString.append( "<last_meet_date><![CDATA[" ).append("").append( "]]></last_meet_date>\r\n" );
						valueXmlString.append( "<last_prod_brf><![CDATA[" ).append("").append( "]]></last_prod_brf>\r\n" );
						valueXmlString.append( "<ref_tran_id><![CDATA[" ).append("").append( "]]></ref_tran_id>\r\n" );
						valueXmlString.append( "<conf_date><![CDATA[" ).append("").append( "]]></conf_date>\r\n" );
						valueXmlString.append( "<confirmed><![CDATA[" ).append("").append( "]]></confirmed>\r\n" );
						valueXmlString.append( "<emp_code__aprv><![CDATA[" ).append("").append( "]]></emp_code__aprv>\r\n" );
						valueXmlString.append( "<sc_code__ref><![CDATA[" ).append("").append( "]]></sc_code__ref>\r\n" );
						valueXmlString.append( "<meet_summ_mgr><![CDATA[" ).append("").append( "]]></meet_summ_mgr>\r\n" );
						valueXmlString.append( "<dcr_id><![CDATA["+dcrID+"]]></dcr_id>\r\n" );
						valueXmlString.append( "<doc_visit_dates><![CDATA[" ).append("").append( "]]></doc_visit_dates>\r\n" );//Gulzar on 17/06/12
						valueXmlString.append( "<addr1><![CDATA[]]></addr1>\r\n" );//Gulzar on 17/06/12
						valueXmlString.append( "<addr2><![CDATA[]]></addr2>\r\n" );//Gulzar on 17/06/12
						valueXmlString.append( "<addr3><![CDATA[]]></addr3>\r\n" );//Gulzar on 17/06/12
						valueXmlString.append( "<age><![CDATA[]]></age>\r\n" );//added by prachi 140322
						valueXmlString.append( "<order_of_visit><![CDATA[" ).append("").append( "]]></order_of_visit>\r\n" );
						valueXmlString.append( "<add_geopos><![CDATA[" ).append("").append( "]]></add_geopos>\r\n" );
						valueXmlString.append( "<chg_geopos><![CDATA[" ).append("").append( "]]></chg_geopos>\r\n" );
						valueXmlString.append( "<geopos_accuracy><![CDATA[" ).append("").append( "]]></geopos_accuracy>\r\n" ); //changes made by rupali on 20/07/18 for adding geopos_accuracy tag
						String visitedWith = checkNull(genericUtility.getColumnValue("visited_with", dom2, "1"));
						if("Y".equalsIgnoreCase(defVisitWithData))
						{
							valueXmlString.append( "<select_team><![CDATA[" ).append(visitedWith).append( "]]></select_team>\r\n" );

						}
						else
						{
							valueXmlString.append( "<select_team><![CDATA[" ).append("").append( "]]></select_team>\r\n" );

						}
						valueXmlString.append( "<class_code_color><![CDATA[]]></class_code_color>\r\n" );
						valueXmlString.append( "<sku_value><![CDATA[" ).append("0").append( "]]></sku_value>\r\n" );
						valueXmlString.append( "<validate_no_visit><![CDATA[" ).append( checkNull(parmValue) ).append( "]]></validate_no_visit>\r\n" );
						valueXmlString.append( "<form_name><![CDATA[" ).append( checkNull(formName) ).append( "]]></form_name>\r\n" );
						valueXmlString.append( "<current_form_subform><![CDATA[" ).append( subFormDetails ).append( "]]></current_form_subform>\r\n" );
						//Added by kailash on 23-01-19 for chc related changes[start].
						valueXmlString.append("<subclass_code visible='1'><![CDATA[" ).append("").append( "]]></subclass_code>\r\n" );
						valueXmlString.append("<subclass_descr visible='1'><![CDATA[" ).append("").append( "]]></subclass_descr>\r\n" );
						valueXmlString.append("<pin visible='1'><![CDATA[" ).append("").append( "]]></pin>\r\n" );
						valueXmlString.append("<promoter_name visible='1'><![CDATA[" ).append("").append( "]]></promoter_name>\r\n" );
						valueXmlString.append("<man_power visible='1'><![CDATA[" ).append("").append( "]]></man_power>\r\n" );
						valueXmlString.append("<image_id visible='1'><![CDATA[" ).append("").append( "]]></image_id>\r\n" );
						valueXmlString.append("<gst_no visible='1'><![CDATA[" ).append("").append( "]]></gst_no>\r\n" );
						valueXmlString.append("<member_present visible='0'><![CDATA[" ).append("0").append( "]]></member_present>\r\n" );
						valueXmlString.append("<next_plan_date visible='1'><![CDATA[" ).append("").append( "]]></next_plan_date>\r\n" );//Added by mrunalini sinkar for next plan date
						//Added by kailash on 23-01-19 for chc related changes[end].
						valueXmlString.append( "<dcr_mode><![CDATA[" ).append( "ADD REPORT" ).append( "]]></dcr_mode>\r\n" );//added by hariom 19-oct-19
						valueXmlString.append("<allow_edit_cust><![CDATA[" ).append(allowEditCust).append( "]]></allow_edit_cust>\r\n" );
						valueXmlString.append("<qualification><![CDATA[" ).append("").append( "]]></qualification>\r\n" );

						valueXmlString.append( "</Detail"+currentForm+">\r\n" );
						domID++;
						if (rs!= null)
						{
							rs.close();
							rs = null;
						}
					}
					if(pstmt!=null)
					{
						pstmt.close();
						pstmt = null;
					}
				}
			}
			else
			{

				rs = pstmt.executeQuery();
				HashMap placeData=getLocalityForStrgVisitHrsCustomer(locality,routeId,"ROUTE_ID",sprsCode,stockistTable,connectionObject);
				//System.out.println("Inside  else loop");
				while(rs.next())
				{
					srNo++;
					strgCode = rs.getString("CODE");
					String regNumber=checkNull(rs.getString("REG_NO"));  // added by shweta m for regNumber //added by shweta for registration value 21-05-21
					String priceList=checkNull(rs.getString("PRICE_LIST"));//Added by bhagyashri T For Price_list SO[W22EBAS004]
					System.out.println("Inside the add sql in SOcustomer Price list ::::::["+priceList+"]");
					if(priceList==null || priceList.trim().length()==0)
					{
						priceList=pricelistS;
					}
					System.out.println("Inside the add sql in SOcustomer Price list after So add ::::::["+priceList+"]");
					String strgState = checkNull(rs.getString("STRG_STATE"));
					String strgGstNo = checkNull(rs.getString("GST_NO"));
					//System.out.println("Inside the add sql in SO ::::::["+regNumber+"]");  // added by shweta //added by shweta for registration value 21-05-21
					//added by mrunalini sinkar on 16-may-2017 for protect the fields and subform when number of visit excced(start)
					//added by mrunalini sinkar to provide multiple locality selection on 17-nov-2018(start)
					String addrChange2="";
					String addr2=checkNull(rs.getString("ADDR2"));
					if(addr2!=null && addr2.trim().length()>0)
					{
						if(addr2.trim().length()>40)
						{
							addrChange2=addr2.substring(0,39);
						}
						else
						{
							addrChange2=addr2;
						}
					}
					if(!multiCustomer.contains(strgCode))
					{
						String allValue[]=null;
						if(placeData!=null && placeData.containsKey(checkNull(strgCode)))
						{
							String mapValue=(String) placeData.get(checkNull(strgCode));
							allValue=mapValue.split("@");
						}
						multiCustomer.add(strgCode)	;
						//String strgVisitHrsLoc = getLocalityVisitHours(strgCode,locality,connectionObject);

						//added by mrunalini sinkar to provide multiple locality selection on 17-nov-2018(end)

						int visit=0;
						String noOfVisit = rs.getString("NO_VISIT") ;//added by Mrunalini Sinkar
						if(noOfVisit!=null)
						{
							visit=Integer.parseInt(noOfVisit);
						}
						//added by mrunalini sinkar on 16-may-2017 for protect the fields and subform when number of visit excced(end)
						String classCode = checkNull(rs.getString("CLASS_CODE"));
						// added by rupali on 08/11/17 for displaying class code descr on customer screen [start]
						String cusType = checkNull(rs.getString("CUST_TYPE"));
						//Added by mrunalini sinkar to make server response  fast on 12-03-2020(start)

						String classCodeDescr="";
						if(classCount > 0)
						{
							if ( serClassMap.get( classCode) != null )
							{
								classCodeDescr=serClassMap.get(classCode);
							}
						}
						else
						{
							if ( custClassMap.get( cusType+"@"+classCode) != null )
							{
								classCodeDescr=custClassMap.get(cusType+"@"+classCode);

							}
						}
						//String classCodeDescr = getClassCodeDesc(classCode,cusType,sprsCode,itemSer,connectionObject);
						//Added by mrunalini sinkar to make server response  fast on 12-03-2020(end)

						// added by rupali on 08/11/17 for displaying class code descr on customer screen [end]
						// added by kailash on 30/01/19 for chc related changes [start]
						String subClassCode = checkNull(rs.getString("SUBCLASS_CODE"));
						//String subClassDescr = getSubclassCodeDesc(classCode,cusType,subClassCode,connectionObject);
						String subClassDescr = checkNull(rs.getString("SUBCLASS_DESCR"));
						//System.out.println("subClassDescr>>>4041["+subClassDescr+"]");
						// added by kailash on 30/01/19 for chc related changes [end]
							
						//Added by Mrunalini sinkar to configure status_hist table changes11-02-2020(end)
						
						//Added by Shweta More to get remark and prior  changes 07-05-21(started)
						Date lastDarDate=null;
				        String priorVisitDate="";
			            String previousRemark=checkNull(getPreviousRemark(sprsCode,trvDBDate,strgCode,custType,connectionObject));
			            String previousDateDar=checkNull(getPreviousVisitDate(sprsCode,trvDBDate,strgCode,custType,connectionObject));
			            
			            if(previousDateDar!=null && previousDateDar.trim().length()>0)
						{
							lastDarDate=dbFormat.parse(previousDateDar);
							priorVisitDate=applFormat.format(lastDarDate);
						}
			           
			            
			          //Added by Shweta More to get remark and prior  changes 07-05-21(started)
			            
						if(parmValue.equalsIgnoreCase("Y"))
						{
							visitDatesInMonth = getDocVistDatesInMonth(strgCode,sprsCode,trvDate,connectionObject);
						}
						int strgPriorVisitNo = 0;
						if(visitDatesInMonth != null && visitDatesInMonth.trim().length() > 0)
						{
							String strgPriorVisit [] = visitDatesInMonth.split(",");
							strgPriorVisitNo = strgPriorVisit.length;
						}

						//System.out.println("Edit strgPriorVisitNo :::=["+strgPriorVisitNo+"]");
						//String isOtherVisit = checkNull(genericUtility.getColumnValue("other_visit", dom2, locFormNo));
						//System.out.println("isOtherVisit value is in case :- "+isOtherVisit);
						//String isDrVisit = checkNull(genericUtility.getColumnValue("dr_visit", dom2, locFormNo));
						//System.out.println("isDrVisit value is in case :- "+isDrVisit);
						//String isChemVisit = checkNull(genericUtility.getColumnValue("chem_visit", dom2, locFormNo));
						//System.out.println("chem_visit value is in case :- "+isChemVisit);
						//String isStockVisit = checkNull(genericUtility.getColumnValue("stockist_visit", dom2, locFormNo));
						//System.out.println("stockist_visit value is in case :- "+isStockVisit);
						//System.out.println("custList value is:--- "+custList);
						//System.out.println("rs.getString caode value is:--- "+rs.getString("CODE"));
						if("doctor".equalsIgnoreCase(formName))
						{
							if(custList != null && custList.size() > 0 && custList.contains(rs.getString("CODE").trim()) && "Y".equalsIgnoreCase(copyPlan) )
							{
								//commented by mrunalini sinkar for remove the no of visit code changes on 23-April-2018(start)
								/*if(strgPriorVisitNo > visit && noOfVisit!= null)   //added by mrunalini sinkar
							{
								valueXmlString.append( "<Detail"+currentForm+" domID='"+domID+"' selected = 'Y' formName='"+formName+"' protectSubform=\"4,5,6,7,8\"><protect_subform><![CDATA[4,5,6,7,8]]></protect_subform>\r\n" );
								valueXmlString.append( "<attribute selected=\"Y\" updateFlag=\"A\" status=\"N\" pkNames=\"\" protectSubform=\"4,5,6,7,8\"/>\r\n");
								valueXmlString.append( "<meet_summ protect='1'><![CDATA[" ).append("").append( "]]></meet_summ>\r\n" );
								valueXmlString.append( "<call_outcome protect='1'><![CDATA[" ).append("5").append( "]]></call_outcome>\r\n" );
							}
							else
							{*/
								//commented by mrunalini sinkar for remove the no of visit code changes on 23-April-2018(end)
								valueXmlString.append( "<Detail"+currentForm+" domID='"+domID+"' selected = 'Y' formName='"+formName+"'>\r\n" );
								valueXmlString.append( "<attribute selected=\"Y\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");//Gaurav Singh on 03/06/15
								valueXmlString.append("<order_form_no><![CDATA[" ).append(sampleOrder).append( "]]></order_form_no>\r\n" );
								valueXmlString.append("<item_form_no><![CDATA[" ).append(samplItem).append( "]]></item_form_no>\r\n" );
								valueXmlString.append("<brand_form_no><![CDATA[" ).append(brand).append( "]]></brand_form_no>\r\n" );
								valueXmlString.append("<display_form_no><![CDATA[" ).append(display).append( "]]></display_form_no>\r\n" );
								valueXmlString.append("<prescription_form_no><![CDATA[" ).append(prescription).append( "]]></prescription_form_no>\r\n" );
								valueXmlString.append("<survey_form_no><![CDATA[" ).append(survey).append( "]]></survey_form_no>\r\n" );
								valueXmlString.append("<team_form_no><![CDATA[" ).append(doctorTeam).append( "]]></team_form_no>\r\n" );
								valueXmlString.append("<invoice_form_no><![CDATA[" ).append(invoiceTeam).append( "]]></invoice_form_no>\r\n" );
								valueXmlString.append("<collection_form_no><![CDATA[" ).append(collectionTeam).append( "]]></collection_form_no>\r\n" );
								valueXmlString.append("<visited_with_display><![CDATA[" ).append(visitedWithDisp).append( "]]></visited_with_display>\r\n" );

								//System.out.println("Value in IF doctor form:-- ");
								//}
							}
							else
							{
								//commented by mrunalini sinkar for remove the no of visit code changes on 23-April-2018(start)
								/*if(strgPriorVisitNo > visit && noOfVisit!= null)    //added by mrunalini sinkar
							{
								valueXmlString.append( "<Detail"+currentForm+" domID='"+domID+"' selected = 'N' formName='"+formName+"' protectSubform=\"4,5,6,7,8\"><protect_subform><![CDATA[4,5,6,7,8]]></protect_subform>\r\n" );
								valueXmlString.append( "<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\" protectSubform=\"4,5,6,7,8\"/>\r\n");
								valueXmlString.append( "<meet_summ protect='1'><![CDATA[" ).append("").append( "]]></meet_summ>\r\n" );
								valueXmlString.append( "<call_outcome protect='1'><![CDATA[" ).append("5").append( "]]></call_outcome>\r\n" );
							}
							else
							{*/
								//commented by mrunalini sinkar for remove the no of visit code changes on 23-April-2018(end)
								valueXmlString.append( "<Detail"+currentForm+" domID='"+domID+"' formName='"+formName+"' selected = 'N'>\r\n" );
								valueXmlString.append( "<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");
								valueXmlString.append("<order_form_no><![CDATA[" ).append(sampleOrder).append( "]]></order_form_no>\r\n" );
								valueXmlString.append("<team_form_no><![CDATA[" ).append(doctorTeam).append( "]]></team_form_no>\r\n" );
								valueXmlString.append("<invoice_form_no><![CDATA[" ).append(invoiceTeam).append( "]]></invoice_form_no>\r\n" );
								valueXmlString.append("<collection_form_no><![CDATA[" ).append(collectionTeam).append( "]]></collection_form_no>\r\n" );valueXmlString.append("<item_form_no><![CDATA[" ).append(samplItem).append( "]]></item_form_no>\r\n" );
								valueXmlString.append("<brand_form_no><![CDATA[" ).append(brand).append( "]]></brand_form_no>\r\n" );
								valueXmlString.append("<display_form_no><![CDATA[" ).append(display).append( "]]></display_form_no>\r\n" );
								valueXmlString.append("<prescription_form_no><![CDATA[" ).append(prescription).append( "]]></prescription_form_no>\r\n" );
								valueXmlString.append("<survey_form_no><![CDATA[" ).append(survey).append( "]]></survey_form_no>\r\n" );
								valueXmlString.append("<visited_with_display><![CDATA[" ).append(visitedWithDisp).append( "]]></visited_with_display>\r\n" );

								//}
								//System.out.println("Value in ELSE doctorform:-- ");

							}
						}
						/*else if("6".equalsIgnoreCase(currentForm.trim()))
					{
						if(custList.contains(rs.getString("CODE").trim()) && "Y".equalsIgnoreCase(copyPlan) && "Y".equalsIgnoreCase(isChemVisit))
						{
							valueXmlString.append( "<Detail"+currentForm+" domID='"+domID+"' selected = 'Y'>\r\n" );
							valueXmlString.append( "<attribute selected=\"Y\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");
							System.out.println("Value in IF 6th form:-- ");
						}
						else
						{
							valueXmlString.append( "<Detail"+currentForm+" domID='"+domID+"' selected = 'N'>\r\n" );
							valueXmlString.append( "<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");
							System.out.println("Value in IELSEF 7th form:-- ");
						}
					}
					else if("8".equalsIgnoreCase(currentForm.trim()))
					{
						if(custList.contains(rs.getString("CODE").trim()) && "Y".equalsIgnoreCase(copyPlan) && "Y".equalsIgnoreCase(isStockVisit))
						{
							valueXmlString.append( "<Detail"+currentForm+" domID='"+domID+"' selected = 'Y'>\r\n" );
							valueXmlString.append( "<attribute selected=\"Y\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");
							System.out.println("Value in IF 7th form:-- ");
						}
						else
						{
							valueXmlString.append( "<Detail"+currentForm+" domID='"+domID+"' selected = 'N'>\r\n" );
							valueXmlString.append( "<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");
							System.out.println("Value in IELSEF 8th form:-- ");
						}
					}
					else if("10".equalsIgnoreCase(currentForm.trim()))
					{
						if(custList.contains(rs.getString("CODE").trim()) && "Y".equalsIgnoreCase(copyPlan) && "Y".equalsIgnoreCase(isOtherVisit))
						{
							valueXmlString.append( "<Detail"+currentForm+" domID='"+domID+"' selected = 'Y'>\r\n" );
							valueXmlString.append( "<attribute selected=\"Y\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");
							System.out.println("Value in IF 7th form:-- ");
						}
						else
						{
							valueXmlString.append( "<Detail"+currentForm+" domID='"+domID+"' selected = 'N'>\r\n" );
							valueXmlString.append( "<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");
							System.out.println("Value in IELSEF 7th form:-- ");
						}
					}*/
						if("retailer".equalsIgnoreCase(formName))
						{
							if(custList != null && custList.contains(rs.getString("CODE").trim()) && "Y".equalsIgnoreCase(copyPlan) )
							{
								/*if(strgPriorVisitNo > visit &&  noOfVisit!= null)     //added by mrunalini sinkar
							{
								valueXmlString.append( "<Detail"+currentForm+" domID='"+domID+"' selected = 'Y' protectSubform=\"9,10,11,12\"><protect_subform><![CDATA[9,10,11,12]]></protect_subform>\r\n" );
								valueXmlString.append( "<attribute selected=\"Y\" updateFlag=\"A\" status=\"N\" pkNames=\"\" protectSubform=\"9,10,11,12\"/>\r\n");
								valueXmlString.append( "<meet_summ protect='1'><![CDATA[" ).append("").append( "]]></meet_summ>\r\n" );
								valueXmlString.append( "<call_outcome protect='1'><![CDATA[" ).append("5").append( "]]></call_outcome>\r\n" );
							}
							else
							{*/
								valueXmlString.append( "<Detail"+currentForm+" domID='"+domID+"' selected = 'Y' formName='"+formName+"'>\r\n" );
								valueXmlString.append( "<attribute selected=\"Y\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");
								valueXmlString.append("<order_form_no><![CDATA[" ).append(chemSampleOrder).append( "]]></order_form_no>\r\n" );
								valueXmlString.append("<team_form_no><![CDATA[" ).append(retailerTeam).append( "]]></team_form_no>\r\n" );
								valueXmlString.append("<item_form_no><![CDATA[" ).append(chemSamplItem).append( "]]></item_form_no>\r\n" );
								valueXmlString.append("<brand_form_no><![CDATA[" ).append(chembrand).append( "]]></brand_form_no>\r\n" );
								valueXmlString.append("<display_form_no><![CDATA[" ).append(chemDisplay).append( "]]></display_form_no>\r\n" );
								valueXmlString.append("<prescription_form_no><![CDATA[" ).append(chemPrescription).append( "]]></prescription_form_no>\r\n" );
								valueXmlString.append("<survey_form_no><![CDATA[" ).append(chemSurvey).append( "]]></survey_form_no>\r\n" );
								valueXmlString.append("<visited_with_display><![CDATA[" ).append(visitedWithDisp).append( "]]></visited_with_display>\r\n" );
								//}
								//System.out.println("Value in IF retailer form:-- ");
							}
							else
							{
								/*if(strgPriorVisitNo > visit &&  noOfVisit!= null)     //added by mrunalini sinkar
							{
								valueXmlString.append( "<Detail"+currentForm+" domID='"+domID+"' selected = 'N' formName='"+formName+"' protectSubform=\"9,10,11,12\"><protect_subform><![CDATA[9,10,11,12]]></protect_subform>\r\n" );
								valueXmlString.append( "<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\" protectSubform=\"9,10,11,12\"/>\r\n");
								valueXmlString.append( "<meet_summ protect='1'><![CDATA[" ).append("").append( "]]></meet_summ>\r\n" );
								valueXmlString.append( "<call_outcome protect='1'><![CDATA[" ).append("5").append( "]]></call_outcome>\r\n" );
							}
							else
							{*/
								valueXmlString.append( "<Detail"+currentForm+" domID='"+domID+"' selected = 'N' formName='"+formName+"'>\r\n" );
								valueXmlString.append( "<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");
								valueXmlString.append("<order_form_no><![CDATA[" ).append(chemSampleOrder).append( "]]></order_form_no>\r\n" );
								valueXmlString.append("<team_form_no><![CDATA[" ).append(retailerTeam).append( "]]></team_form_no>\r\n" );
								valueXmlString.append("<item_form_no><![CDATA[" ).append(chemSamplItem).append( "]]></item_form_no>\r\n" );
								valueXmlString.append("<brand_form_no><![CDATA[" ).append(chembrand).append( "]]></brand_form_no>\r\n" );
								valueXmlString.append("<display_form_no><![CDATA[" ).append(chemDisplay).append( "]]></display_form_no>\r\n" );
								valueXmlString.append("<prescription_form_no><![CDATA[" ).append(chemPrescription).append( "]]></prescription_form_no>\r\n" );
								valueXmlString.append("<survey_form_no><![CDATA[" ).append(chemSurvey).append( "]]></survey_form_no>\r\n" );
								valueXmlString.append("<visited_with_display><![CDATA[" ).append(visitedWithDisp).append( "]]></visited_with_display>\r\n" );

								//}
								//System.out.println("Value in IELSEF retailer form:-- ");
							}
						}
						//Added by Mrunalini Sinkar on 08-may-2017 for stockist & ncw(start)
						if("stockist".equalsIgnoreCase(formName))
						{
							if(custList != null && custList.contains(rs.getString("CODE").trim()) && "Y".equalsIgnoreCase(copyPlan) )
							{
								//commented by mrunalini sinkar for remove the no of visit code changes on 23-April-2018(start)
								/*if(strgPriorVisitNo > visit &&  noOfVisit!= null)         //added by mrunalini sinkar
							{
								valueXmlString.append( "<Detail"+currentForm+" domID='"+domID+"' selected = 'Y' formName='"+formName+"' protectSubform=\"14,15,16,17\"><protect_subform><![CDATA[14,15,16,17]]></protect_subform>\r\n" );
								valueXmlString.append( "<attribute selected=\"Y\" updateFlag=\"A\" status=\"N\" pkNames=\"\" protectSubform=\"14,15,16,17\"/>\r\n");
								valueXmlString.append( "<meet_summ protect='1'><![CDATA[" ).append("").append( "]]></meet_summ>\r\n" );
								valueXmlString.append( "<call_outcome protect='1'><![CDATA[" ).append("5").append( "]]></call_outcome>\r\n" );
							}
							else
							{*/
								//commented by mrunalini sinkar for remove the no of visit code changes on 23-April-2018(end)
								valueXmlString.append( "<Detail"+currentForm+" domID='"+domID+"' selected = 'Y' formName='"+formName+"'>\r\n" );
								valueXmlString.append( "<attribute selected=\"Y\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");
								valueXmlString.append("<order_form_no><![CDATA[" ).append(stockSampleOrder).append( "]]></order_form_no>\r\n" );
								valueXmlString.append("<team_form_no><![CDATA[" ).append(stockistTeam).append( "]]></team_form_no>\r\n" );
								valueXmlString.append("<item_form_no><![CDATA[" ).append(stockSamplItem).append( "]]></item_form_no>\r\n" );
								valueXmlString.append("<brand_form_no><![CDATA[" ).append(stockbrand).append( "]]></brand_form_no>\r\n" );
								valueXmlString.append("<display_form_no><![CDATA[" ).append(stockDisplay).append( "]]></display_form_no>\r\n" );
								valueXmlString.append("<prescription_form_no><![CDATA[" ).append(stockPrescription).append( "]]></prescription_form_no>\r\n" );
								valueXmlString.append("<survey_form_no><![CDATA[" ).append(stockSurvey).append( "]]></survey_form_no>\r\n" );
								valueXmlString.append("<visited_with_display><![CDATA[" ).append(visitedWithDisp).append( "]]></visited_with_display>\r\n" );

								//}
								//System.out.println("Value in IF retailer form:-- ");
							}
							else
							{
								//commented by mrunalini sinkar for remove the no of visit code changes on 23-April-2018(start)
								/*if(strgPriorVisitNo > visit &&  noOfVisit!= null)     //added by mrunalini sinkar
							{
								valueXmlString.append( "<Detail"+currentForm+" domID='"+domID+"' selected = 'N' formName='"+formName+"' protectSubform=\"14,15,16,17\"><protect_subform><![CDATA[14,15,16,17]]></protect_subform>\r\n" );
								valueXmlString.append( "<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\" protectSubform=\"14,15,16,17\"/>\r\n");
								valueXmlString.append( "<meet_summ protect='1'><![CDATA[" ).append("").append( "]]></meet_summ>\r\n" );
								valueXmlString.append( "<call_outcome protect='1'><![CDATA[" ).append("5").append( "]]></call_outcome>\r\n" );

							}
							else
							{*/
								//commented by mrunalini sinkar for remove the no of visit code changes on 23-April-2018(end)
								valueXmlString.append( "<Detail"+currentForm+" domID='"+domID+"' selected = 'N' formName='"+formName+"'>\r\n" );
								valueXmlString.append( "<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");
								valueXmlString.append("<order_form_no><![CDATA[" ).append(stockSampleOrder).append( "]]></order_form_no>\r\n" );
								valueXmlString.append("<team_form_no><![CDATA[" ).append(stockistTeam).append( "]]></team_form_no>\r\n" );
								valueXmlString.append("<item_form_no><![CDATA[" ).append(stockSamplItem).append( "]]></item_form_no>\r\n" );
								valueXmlString.append("<brand_form_no><![CDATA[" ).append(stockbrand).append( "]]></brand_form_no>\r\n" );
								valueXmlString.append("<display_form_no><![CDATA[" ).append(stockDisplay).append( "]]></display_form_no>\r\n" );
								valueXmlString.append("<prescription_form_no><![CDATA[" ).append(stockPrescription).append( "]]></prescription_form_no>\r\n" );
								valueXmlString.append("<survey_form_no><![CDATA[" ).append(stockSurvey).append( "]]></survey_form_no>\r\n" );
								valueXmlString.append("<visited_with_display><![CDATA[" ).append(visitedWithDisp).append( "]]></visited_with_display>\r\n" );

								//}
								//System.out.println("Value in IELSEF retailer form:-- ");
							}
						}
						if("ncw".equalsIgnoreCase(formName))
						{
							if(custList != null && custList.contains(rs.getString("CODE").trim()) && "Y".equalsIgnoreCase(copyPlan) )
							{
								//commented by mrunalini sinkar for remove the no of visit code changes on 23-April-2018(start)
								/*if(strgPriorVisitNo > visit &&  noOfVisit!= null)        //added by mrunalini sinkar
							{
								valueXmlString.append( "<Detail"+currentForm+" domID='"+domID+"' selected = 'Y' formName='"+formName+"' protectSubform=\"9,10,11,12\"><protect_subform><![CDATA[9,10,11,12]]></protect_subform>\r\n" );
								valueXmlString.append( "<attribute selected=\"Y\" updateFlag=\"A\" status=\"N\" pkNames=\"\" protectSubform=\"9,10,11,12\"/>\r\n");
								valueXmlString.append( "<meet_summ protect='1'><![CDATA[" ).append("").append( "]]></meet_summ>\r\n" );
								valueXmlString.append( "<call_outcome protect='1'><![CDATA[" ).append("5").append( "]]></call_outcome>\r\n" );
							}
							else
							{*/
								//commented by mrunalini sinkar for remove the no of visit code changes on 23-April-2018(end)
								valueXmlString.append( "<Detail"+currentForm+" domID='"+domID+"' selected = 'Y' formName='"+formName+"'>\r\n" );
								valueXmlString.append( "<attribute selected=\"Y\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");
								valueXmlString.append("<order_form_no><![CDATA[" ).append(ncwSampleOrder).append( "]]></order_form_no>\r\n" );
								valueXmlString.append("<team_form_no><![CDATA[" ).append(ncwTeam).append( "]]></team_form_no>\r\n" );
								valueXmlString.append("<item_form_no><![CDATA[" ).append(ncwSamplItem).append( "]]></item_form_no>\r\n" );
								valueXmlString.append("<brand_form_no><![CDATA[" ).append(ncwbrand).append( "]]></brand_form_no>\r\n" );
								valueXmlString.append("<display_form_no><![CDATA[" ).append(ncwDisplay).append( "]]></display_form_no>\r\n" );
								valueXmlString.append("<prescription_form_no><![CDATA[" ).append(ncwPrescription).append( "]]></prescription_form_no>\r\n" );
								valueXmlString.append("<survey_form_no><![CDATA[" ).append(ncwSurvey).append( "]]></survey_form_no>\r\n" );
								valueXmlString.append("<visited_with_display><![CDATA[" ).append(visitedWithDisp).append( "]]></visited_with_display>\r\n" );
								//}
								//System.out.println("Value in IF retailer form:-- ");
							}
							else
							{
								//commented by mrunalini sinkar for remove the no of visit code changes on 23-April-2018(start)
								/*if(strgPriorVisitNo > visit &&  noOfVisit!= null)        //added by mrunalini sinkar
							{
								valueXmlString.append( "<Detail"+currentForm+" domID='"+domID+"' selected = 'N' formName='"+formName+"' protectSubform=\"4,5,6,7\"><protect_subform><![CDATA[4,5,6,7]]></protect_subform>\r\n" );
								valueXmlString.append( "<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\" protectSubform=\"4,5,6,7\"/>\r\n");
								valueXmlString.append( "<meet_summ protect='1'><![CDATA[" ).append("").append( "]]></meet_summ>\r\n" );
								valueXmlString.append( "<call_outcome protect='1'><![CDATA[" ).append("5").append( "]]></call_outcome>\r\n" );

							}
							else
							{*/
								//commented by mrunalini sinkar for remove the no of visit code changes on 23-April-2018(end)
								valueXmlString.append( "<Detail"+currentForm+" domID='"+domID+"' formName='"+formName+"' selected = 'N'>\r\n" );
								valueXmlString.append( "<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");
								valueXmlString.append("<order_form_no><![CDATA[" ).append(ncwSampleOrder).append( "]]></order_form_no>\r\n" );
								valueXmlString.append("<team_form_no><![CDATA[" ).append(ncwTeam).append( "]]></team_form_no>\r\n" );
								valueXmlString.append("<item_form_no><![CDATA[" ).append(ncwSamplItem).append( "]]></item_form_no>\r\n" );
								valueXmlString.append("<brand_form_no><![CDATA[" ).append(ncwbrand).append( "]]></brand_form_no>\r\n" );
								valueXmlString.append("<display_form_no><![CDATA[" ).append(ncwDisplay).append( "]]></display_form_no>\r\n" );
								valueXmlString.append("<prescription_form_no><![CDATA[" ).append(ncwPrescription).append( "]]></prescription_form_no>\r\n" );
								valueXmlString.append("<survey_form_no><![CDATA[" ).append(ncwSurvey).append( "]]></survey_form_no>\r\n" );
								valueXmlString.append("<visited_with_display><![CDATA[" ).append(visitedWithDisp).append( "]]></visited_with_display>\r\n" );
								//}
								//System.out.println("Value in IELSEF retailer form:-- ");
							}
						}
						if(editCustCnt>0)
						{
							valueXmlString.append("<is_finish_disable><![CDATA[" ).append("Y").append( "]]></is_finish_disable>\r\n" );
						}
						else
						{
							valueXmlString.append("<is_finish_disable><![CDATA[" ).append("N").append( "]]></is_finish_disable>\r\n" );
						}
						//Added by Mrunalini Sinkar on 08-may-2017 for stockist & ncw(end)
						valueXmlString.append( "<speciality_descr visible='1'><![CDATA[" ).append(checkNull(rs.getString("SPL_DECR"))).append( "]]></speciality_descr>\r\n" );//Changed by kailash on 10-09-18.
						//String eventTime = geteventTime();
						valueXmlString.append("<sr_no><![CDATA[").append(srNo).append("]]></sr_no>\r\n");
						valueXmlString.append("<short_id><![CDATA[").append(checkNull(rs.getString("MPLNO"))).append("]]></short_id>\r\n");
						valueXmlString.append("<strg_code visible = '1'><![CDATA[").append(checkNull(rs.getString("CODE"))).append("]]></strg_code>\r\n");
						valueXmlString.append("<cust_name protect='1'><![CDATA[").append(checkNull(rs.getString("SC_NAME"))).append("]]></cust_name>\r\n");//Changed by kailash on 10-09-18.
						valueXmlString.append( "<strg_name visible='0'><![CDATA[" ).append(checkNull(rs.getString("SC_NAME"))).append( "]]></strg_name>\r\n" );//Change visible "0" by kailash on 10-09-18
						valueXmlString.append( "<order_booked><![CDATA[" ).append("0").append( "]]></order_booked>\r\n" );
						//	valueXmlString.append( "<event_time_start><![CDATA[" ).append(eventTime).append( "]]></event_time_start>\r\n" );
						valueXmlString.append( "<event_time_start><![CDATA[" ).append(timeFrom).append( "]]></event_time_start>\r\n" );
						valueXmlString.append( "<visit_time_from visible = '0'><![CDATA[" ).append(timeFrom).append( "]]></visit_time_from>\r\n" );
						String visitedWith = checkNull(genericUtility.getColumnValue("visited_with", dom2, "1"));
						if("Y".equalsIgnoreCase(defVisitWithData))
						{
							valueXmlString.append( "<select_team><![CDATA[" ).append(visitedWith).append( "]]></select_team>\r\n" );

						}
						else
						{
							valueXmlString.append( "<select_team><![CDATA[" ).append("").append( "]]></select_team>\r\n" );

						}

						/*int position=startTime.indexOf(':');
						hour = startTime.substring(0,position).trim();
						minute = startTime.substring( position+1 , startTime.length() ).trim();
						int hr=Integer.parseInt(hour);
						int min=Integer.parseInt(minute);

						int minIntrvl=Integer.parseInt(interval);
						minIntrvl = min + minIntrvl;
						if(hr == 11 && minIntrvl >= 60)
						{
							if("AM".equals(format))
							{
								format = "PM";
							}
							else if("PM".equals(format))
							{
								format = "AM";
							}
						}
						int intr =0;
						if( interval.length()>0 )
						{
							intr = Integer.parseInt( interval );
							min = min+intr;
							if( min>59 )
							{
								while( min > 59 )
								{
									hr=hr+1;
									min=min-60;
									// added by rupali on 15/12/17 for showing event_time_from and event_time_to fields on customer screen [start]
									if(hr == 11 && min >= 60)
									{
										if("AM".equals(format))
										{
											format = "PM";
										}
										else if("PM".equals(format))
										{
											format = "AM";
										}
									}
									// added by rupali on 15/12/17 for showing event_time_from and event_time_to fields on customer screen [end]
								}
								if( min==0 )
								{
									if( hr < 10 )
									{
										hours = "0"+hr;
									}
									else
									{
										hours = String.valueOf( hr );
									}
									timeTo = hours+":00"+" "+format; // added by rupali on 14/12/17 for showing event_time_from and event_time_to fields on customer screen
									//valueXmlString.append( "<event_time_end><![CDATA[" ).append( checkNull(hours+":00")).append( "]]></event_time_end>\r\n" );//vinayakk
								}
								else
								{
									if( hr < 10 )
									{
										hours="0"+hr;
									}
									else
									{
										hours=String.valueOf( hr );
									}
									if(min<10)
									{
										timeTo = hours+":0"+min+" "+format; // added by rupali on 14/12/17 for showing event_time_from and event_time_to fields on customer screen
										//valueXmlString.append( "<event_time_end><![CDATA[" ).append( checkNull(hours+":0"+min)).append( "]]></event_time_end>\r\n" );//vinayakk
									}
									else
									{
										timeTo = hours+":"+min+" "+format; // added by rupali on 14/12/17 for showing event_time_from and event_time_to fields on customer screen
										//valueXmlString.append( "<event_time_end><![CDATA[" ).append( checkNull(hours+":"+min)).append( "]]></event_time_end>\r\n" );//vinayakk
									}
								}
							}
							else
							{

								if( hr < 10 )
								{
									hours="0"+hr;
								}
								else
								{
									hours=String.valueOf( hr );
								}
								timeTo = hours+":"+min+" "+format; // added by rupali on 14/12/17 for showing event_time_from and event_time_to fields on customer screen
								//valueXmlString.append( "<event_time_end><![CDATA[" ).append( checkNull(hours+":"+min)).append( "]]></event_time_end>\r\n" );//vinayakk
							}
						}*/
						//	valueXmlString.append( "<event_time_end><![CDATA[" ).append(eventTime).append( "]]></event_time_end>\r\n" );
						if("Y".equalsIgnoreCase(eventHideTimeEnd))
						{
							valueXmlString.append( "<event_time_end visible='0'><![CDATA[" ).append(timeTo).append( "]]></event_time_end>\r\n" );
						}
						else
						{
							valueXmlString.append( "<event_time_end visible='1'><![CDATA[" ).append(timeTo).append( "]]></event_time_end>\r\n" );
						}

						valueXmlString.append( "<oth_participant><![CDATA[" ).append(otherParticipant).append( "]]></oth_participant>\r\n" );
						valueXmlString.append( "<contact_pers_name visible='1' protect='1'><![CDATA[" ).append("").append( "]]></contact_pers_name>\r\n" );
						//valueXmlString.append( "<visited_with_display><![CDATA[" ).append(workWith).append( "]]></visited_with_display>\r\n" );
						if("JW".equalsIgnoreCase(actCode) && "FW".equalsIgnoreCase(actType))//Gulzar on 17/06/12
						{
							valueXmlString.append( "<work_with_other><![CDATA[" ).append(workWithOther).append( "]]></work_with_other>\r\n" );
						}
						else
						{
							valueXmlString.append( "<work_with_other><![CDATA[" ).append("").append( "]]></work_with_other>\r\n" );
						}
						valueXmlString.append( "<work_team><![CDATA[" ).append("Alone").append( "]]></work_team>\r\n" );
						//Changed By Vidhya on 08/12/09[WS89NOV642 |Commenting work team display]
						//valueXmlString.append( "<work_team_disp><![CDATA[Alone]]></work_team_disp>\r\n" );
						valueXmlString.append( "<sales_pers><![CDATA[" ).append(checkNull(sprsCode)).append( "]]></sales_pers>\r\n" );
						valueXmlString.append( "<chg_date><![CDATA[" ).append(currDate).append( "]]></chg_date>\r\n" );
						valueXmlString.append( "<chg_user><![CDATA[" ).append(userId).append( "]]></chg_user>\r\n" );
						valueXmlString.append( "<chg_term><![CDATA[" ).append(chgTerm).append( "]]></chg_term>\r\n" );
						//added by mrunalini sinkar to provide multiple locality selection on 17-nov-2018(start)

						if(!"false".equalsIgnoreCase(allValue[2]) && !"false".equalsIgnoreCase(allValue[3]))
						{
							String loc=checkNull(allValue[2]);
							String locDescr="",defDistributer="";
							String strgVisitHrssql="SELECT DESCR,DEF_DISTRIBUTOR FROM LOCALITY WHERE LOCALITY_CODE = ?";
							strgVisitPstmt =connectionObject.prepareStatement(strgVisitHrssql);
							strgVisitPstmt.setString(1, loc);
							strgVisitRs=strgVisitPstmt.executeQuery();
							if(strgVisitRs.next())
							{
								locDescr = checkNull(strgVisitRs.getString("DESCR"));
								defDistributer = checkNull(strgVisitRs.getString("DEF_DISTRIBUTOR"));
							}
							if (strgVisitRs!= null)
							{
								strgVisitRs.close();
								strgVisitRs = null;
							}
							if(strgVisitPstmt!=null)
							{
								strgVisitPstmt.close();
								strgVisitPstmt = null;
							}
							valueXmlString.append("<locality_code visible='1' protect='0' ><![CDATA[" ).append(checkNull(loc)).append( "]]></locality_code>\r\n" );
							valueXmlString.append("<route_id><![CDATA[" ).append(checkNull(allValue[3]) ).append( "]]></route_id>\r\n" );

							valueXmlString.append( "<locality_descr visible='1' protect='1'><![CDATA[" ).append(locDescr).append( "]]></locality_descr>\r\n" );
							valueXmlString.append( "<stockist_code><![CDATA[" ).append(defDistributer).append( "]]></stockist_code>\r\n" );
							valueXmlString.append( "<stockist_name protect = '1'><![CDATA[" ).append(getStokistName(defDistributer,sprsCode,stockistTable,connectionObject)).append( "]]></stockist_name>\r\n" );
						}
						else
						{
							valueXmlString.append( "<locality_code visible='1' protect='1' ><![CDATA[" ).append(checkNull(rs.getString("LOCALITY_CODE"))).append( "]]></locality_code>\r\n" );
							valueXmlString.append("<route_id><![CDATA[" ).append(checkNull(rs.getString("ROUTE_ID")) ).append( "]]></route_id>\r\n" );
							valueXmlString.append( "<locality_descr visible='1' protect='1'><![CDATA[" ).append( checkNull(rs.getString("LOC_DESCR"))).append( "]]></locality_descr>\r\n" );//Changed by kailash on 10-09-18.
							valueXmlString.append( "<stockist_code><![CDATA[" ).append(rs.getString("DEF_DISTRIBUTOR")).append( "]]></stockist_code>\r\n" );
							valueXmlString.append( "<stockist_name protect = '1'><![CDATA[" ).append(getStokistName(checkNull(rs.getString("DEF_DISTRIBUTOR")),sprsCode,stockistTable,connectionObject)).append( "]]></stockist_name>\r\n" );

						}
						//added by mrunalini sinkar to provide multiple locality selection on 17-nov-2018(end)

						valueXmlString.append( "<meet_summ><![CDATA[" ).append("").append( "]]></meet_summ>\r\n" );
						valueXmlString.append( "<remarks><![CDATA[" ).append("").append( "]]></remarks>\r\n" );
						//commented by vishal pathare on 25.10.17 for[initial value should apply (Default Call outcome should be believer)].
						//valueXmlString.append( "<call_outcome><![CDATA[" ).append(checkNull("5")).append( "]]></call_outcome>\r\n" );
						//valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Supporter").append( "]]></calloutcome_descr>\r\n" );
						valueXmlString.append( "<sales_pers_sp_name><![CDATA[" ).append("").append( "]]></sales_pers_sp_name>\r\n" );
						valueXmlString.append( "<sprs_code__ww><![CDATA[" ).append("").append( "]]></sprs_code__ww>\r\n" );
						valueXmlString.append( "<event_date><![CDATA[" ).append(trvDate).append( "]]></event_date>\r\n" );
						if("Y".equalsIgnoreCase(isFortune))
						{
							valueXmlString.append( "<event_type visible='1'><![CDATA[" ).append("").append( "]]></event_type>\r\n" );
							valueXmlString.append( "<activity_type><![CDATA[" ).append("").append( "]]></activity_type>\r\n" );						
						}
						else
						{
							valueXmlString.append( "<event_type visible='0'><![CDATA[" ).append(actCode).append( "]]></event_type>\r\n" );
							valueXmlString.append( "<activity_type><![CDATA[" ).append(actType).append( "]]></activity_type>\r\n" );
						}
						//valueXmlString.append( "<strg_name><![CDATA[]]></strg_name>\r\n" );
						// added by rupali on 31/08/18 for inserting strg name and address as in strg_meet table [start]
						valueXmlString.append( "<address_as protect ='1' visible='1'><![CDATA[" ).append( checkNull(rs.getString("ADDRESS_AS")) ).append( "]]></address_as>\r\n" );//Added by kailash on 10-09-18.
						// added by rupali on 31/08/18 for inserting strg name and address as in strg_meet table [end]
						valueXmlString.append( "<strg_type><![CDATA[" ).append(checkNull(rs.getString("CUST_TYPE"))).append( "]]></strg_type>\r\n" );
						valueXmlString.append( "<strg_no_visit><![CDATA[" ).append(checkNull(rs.getString("NO_VISIT"))).append( "]]></strg_no_visit>\r\n" );
						valueXmlString.append( "<strg_class_code visible='0'><![CDATA[" ).append(checkNull(rs.getString("CLASS_CODE"))).append( "]]></strg_class_code>\r\n" );//Added by kailash on 10-09-18.
						valueXmlString.append( "<sales_team><![CDATA[" ).append("").append( "]]></sales_team>\r\n" );
						valueXmlString.append( "<template_file><![CDATA[" ).append("").append( "]]></template_file>\r\n" );
						/*valueXmlString.append( "<last_meet_summ><![CDATA[" ).append("").append( "]]></last_meet_summ>\r\n" );
						valueXmlString.append( "<last_meet_date><![CDATA[" ).append("").append( "]]></last_meet_date>\r\n" );*/  // commented by shweta 06-05-21
						valueXmlString.append( "<last_meet_summ><![CDATA[" ).append(previousRemark).append( "]]></last_meet_summ>\r\n" );  // added by shweta for display last remark and last met deta 06-05-21
						valueXmlString.append( "<last_meet_date><![CDATA[" ).append(priorVisitDate).append( "]]></last_meet_date>\r\n" );  // added by shweta for display last remark and last met deta 06-05-21
						valueXmlString.append( "<reg_no protect='1'><![CDATA[" ).append(regNumber).append( "]]></reg_no>\r\n" );   // added by shweta //added by shweta for registration value 21-05-21
						valueXmlString.append( "<last_prod_brf><![CDATA[" ).append("").append( "]]></last_prod_brf>\r\n" );
						valueXmlString.append( "<ref_tran_id><![CDATA[" ).append("").append( "]]></ref_tran_id>\r\n" );
						valueXmlString.append( "<conf_date><![CDATA[" ).append("").append( "]]></conf_date>\r\n" );
						valueXmlString.append( "<confirmed><![CDATA[" ).append("").append( "]]></confirmed>\r\n" );
						valueXmlString.append( "<emp_code__aprv><![CDATA[" ).append("").append( "]]></emp_code__aprv>\r\n" );
						valueXmlString.append( "<sc_code__ref><![CDATA[" ).append("").append( "]]></sc_code__ref>\r\n" );
						valueXmlString.append( "<meet_summ_mgr><![CDATA[" ).append("").append( "]]></meet_summ_mgr>\r\n" );
						valueXmlString.append( "<doc_visit_dates><![CDATA[" ).append(strgPriorVisitNo).append( "]]></doc_visit_dates>\r\n" );
						//Changed by kailash on 10-09-18 [Start]
						valueXmlString.append( "<addr1 visible='0'><![CDATA[" ).append(checkNull(rs.getString("ADDR1"))).append( "]]></addr1>\r\n" );//Gulzar on 17/06/12
						valueXmlString.append( "<addr2 visible='0'><![CDATA[" ).append(checkNull(addrChange2)).append( "]]></addr2>\r\n" );//Gulzar on 17/06/12
						valueXmlString.append( "<addr3 visible='0'><![CDATA[" ).append(checkNull(rs.getString("ADDR3"))).append( "]]></addr3>\r\n" );//Gulzar on 17/06/12
						
						//Changed by kailash on 10-09-18 [End]
						
						//added by prachi
						valueXmlString.append( "<age visible='0'><![CDATA[" ).append("").append( "]]></age>\r\n" );
						valueXmlString.append( "<order_of_visit><![CDATA[" ).append("").append( "]]></order_of_visit>\r\n" );
						valueXmlString.append( "<sku_value><![CDATA[" ).append("0").append( "]]></sku_value>\r\n" );
						if(chemistExistFlag)
						{
							valueXmlString.append( "<chemist_exist><![CDATA[" ).append("Y").append( "]]></chemist_exist>\r\n" );
						}
						else
						{
							valueXmlString.append( "<chemist_exist><![CDATA[" ).append("N").append( "]]></chemist_exist>\r\n" );
						}
						valueXmlString.append( "<dcr_id><![CDATA["+dcrID+"]]></dcr_id>\r\n" );
						valueXmlString.append( "<add_geopos><![CDATA[" ).append("").append( "]]></add_geopos>\r\n" );
						valueXmlString.append( "<chg_geopos><![CDATA[" ).append("").append( "]]></chg_geopos>\r\n" );
						valueXmlString.append( "<geopos_accuracy><![CDATA[" ).append("").append( "]]></geopos_accuracy>\r\n" ); //changes made by rupali on 20/07/18 for adding geopos_accuracy tag
						valueXmlString.append( "<tran_id><![CDATA[" ).append("").append( "]]></tran_id>\r\n" );//Gulzar on 04/07/17
						valueXmlString.append("<member_present visible='0'><![CDATA[" ).append("0").append( "]]></member_present>\r\n" );
						if("A".equalsIgnoreCase(classCode))
						{
							valueXmlString.append( "<class_code_color><![CDATA[green]]></class_code_color>\r\n" );
						}
						else if("B".equalsIgnoreCase(classCode))
						{
							valueXmlString.append( "<class_code_color><![CDATA[yellow]]></class_code_color>\r\n" );
						}
						else if("C".equalsIgnoreCase(classCode))
						{
							valueXmlString.append( "<class_code_color><![CDATA[red]]></class_code_color>\r\n" );
						}
						else
						{
							valueXmlString.append( "<class_code_color><![CDATA[]]></class_code_color>\r\n" );
						}
						//}
						// added by rupali on 08/11/17 for displaying class code descr on customer screen
						valueXmlString.append( "<class_code_descr visible='0'><![CDATA[" ).append(classCodeDescr).append( "]]></class_code_descr>\r\n" );//Changed by kailash on 10-09-18.
						valueXmlString.append( "<validate_no_visit><![CDATA[" ).append( checkNull(parmValue) ).append( "]]></validate_no_visit>\r\n" );
						valueXmlString.append( "<form_name><![CDATA[" ).append( checkNull(formName) ).append( "]]></form_name>\r\n" );
						valueXmlString.append( "<current_form_subform><![CDATA[" ).append(subFormDetails).append( "]]></current_form_subform>\r\n" );
						//valueXmlString.append( "<stockist_code><![CDATA[" ).append(rs.getString("DEF_DISTRIBUTOR")).append( "]]></stockist_code>\r\n" );
						//valueXmlString.append( "<stockist_name protect = '1'><![CDATA[" ).append(getStokistName(checkNull(rs.getString("DEF_DISTRIBUTOR")),connectionObject)).append( "]]></stockist_name>\r\n" );
						// added by rupali on 04/09/18 for inserting speciality_code in strg_meet table [start]
						// Changed and added by kailash on 10-09-18 [start]
						valueXmlString.append( "<spl_code visible='0'><![CDATA[" ).append( checkNull(rs.getString("SPL_CODE")) ).append( "]]></spl_code>\r\n" );
						valueXmlString.append( "<mobile_no visible='0'><![CDATA[" ).append( checkNull(rs.getString("MOBILE_NO")) ).append( "]]></mobile_no>\r\n" );
						valueXmlString.append( "<email_addr visible='0'><![CDATA[" ).append( checkNull(rs.getString("EMAIL_ADDR")) ).append( "]]></email_addr>\r\n" );
						valueXmlString.append( "<gender visible='0'><![CDATA[" ).append( checkNull(rs.getString("SEX")) ).append( "]]></gender>\r\n" );
						valueXmlString.append( "<cust_type protect ='1'><![CDATA[" ).append(checkNull(rs.getString("CUST_TYPE_DESCR")) ).append( "]]></cust_type>\r\n" );
						//added by mrunalini sinkar to provide multiple locality selection on 17-nov-2018(start)

						if("UNLISTED-DOCTOR".equalsIgnoreCase(customerType)|| "UNLISTED-RETAILER".equalsIgnoreCase(customerType)|| "UNLISTED-STOCKIST".equalsIgnoreCase(customerType)||"UNLISTED-OTHER".equalsIgnoreCase(customerType))
						{
							valueXmlString.append("<sel_loc_code><![CDATA[" ).append(selLocality).append( "]]></sel_loc_code>\r\n" );
							valueXmlString.append("<sel_route_id><![CDATA[" ).append(selRouteId).append( "]]></sel_route_id>\r\n" );

						}
						else
						{

							//selLocality = getLocalityForStrgVisitHrsCustomer(strgCode,locality,"LOCALITY_CODE",sprsCode,stockistTable,connectionObject);
							//selRouteId = getLocalityForStrgVisitHrsCustomer(strgCode,routeId,"ROUTE_ID",sprsCode,stockistTable,connectionObject);
							if(allValue[0].trim().length()> 0)
							{
								valueXmlString.append("<sel_loc_code><![CDATA[" ).append(allValue[1]).append( "]]></sel_loc_code>\r\n" );
								valueXmlString.append("<sel_route_id><![CDATA[" ).append(allValue[0]).append( "]]></sel_route_id>\r\n" );

							}

						}
						//added by mrunalini sinkar to provide multiple locality selection on 17-nov-2018(end)
						// Changed by kailash on 10-09-18 [end]
						// added by rupali on 04/09/18 for inserting speciality_code in strg_meet table [end]
						//Added by kailash on 23-01-19 for chc related changes[start].
						valueXmlString.append("<subclass_code visible='0'><![CDATA[" ).append(checkNull(subClassCode) ).append( "]]></subclass_code>\r\n" );
						valueXmlString.append("<subclass_descr visible='0'><![CDATA[" ).append(subClassDescr ).append( "]]></subclass_descr>\r\n" );
						valueXmlString.append("<pin visible='0'><![CDATA[" ).append(checkNull(rs.getString("PIN")) ).append( "]]></pin>\r\n" );
						valueXmlString.append("<promoter_name visible='0'><![CDATA[" ).append(checkNull(rs.getString("PROMOTER_NAME")) ).append( "]]></promoter_name>\r\n" );
						valueXmlString.append("<man_power visible='0'><![CDATA[" ).append(checkNull(rs.getString("MAN_POWER")) ).append( "]]></man_power>\r\n" );
						valueXmlString.append("<gst_no visible='0'><![CDATA[" ).append(strgGstNo).append( "]]></gst_no>\r\n" );
						//Added by kailash on 23-01-19 for chc related changes[end].
						valueXmlString.append("<host_url><![CDATA[" ).append(CommonConstants.TOMCAT_HOME).append( "]]></host_url>\r\n" );
						valueXmlString.append("<survey_templ><![CDATA[").append(checkNull(rs.getString("SURVEY_TEMPL"))).append("]]></survey_templ>\r\n");
						valueXmlString.append( "<dcr_mode><![CDATA[" ).append( "ADD REPORT" ).append( "]]></dcr_mode>\r\n" );//added by hariom 19-oct-19
						valueXmlString.append("<allow_edit_cust><![CDATA[" ).append(allowEditCust).append( "]]></allow_edit_cust>\r\n" );
						valueXmlString.append("<qualification visible='1'><![CDATA[" ).append(checkNull(rs.getString("QUALIFICATION")) ).append( "]]></qualification>\r\n" );
						valueXmlString.append("<is_fortune_activity><![CDATA[" ).append(isFortune).append( "]]></is_fortune_activity>\r\n" );
						valueXmlString.append("<is_form_mandatory><![CDATA[" ).append(formMandatory).append( "]]></is_form_mandatory>\r\n" );
						valueXmlString.append("<sprs_act_code><![CDATA[" ).append(sprsActCode).append( "]]></sprs_act_code>\r\n" );
						valueXmlString.append("<is_member_present><![CDATA[" ).append(isMemberPresent).append( "]]></is_member_present>\r\n" );
						valueXmlString.append("<dcr_group visible='0' protect='1'><![CDATA[" ).append(checkNull(getDcrGroup(cusType,connectionObject ))).append( "]]></dcr_group>\r\n" );
						valueXmlString.append("<price_list><![CDATA[" ).append(priceList).append( "]]></price_list>\r\n" );
						valueXmlString.append( "<strg_gst_no><![CDATA[" ).append( strgGstNo).append( "]]></strg_gst_no>\r\n" ); 
						valueXmlString.append( "<strg_state><![CDATA[" ).append( strgState).append( "]]></strg_state>\r\n" );
						valueXmlString.append( "<amount><![CDATA[" ).append("0").append( "]]></amount>\r\n" ); 
						valueXmlString.append( "<net_amt><![CDATA[" ).append("0").append( "]]></net_amt>\r\n" ); 
						valueXmlString.append( "<tax_amount><![CDATA[" ).append("0").append( "]]></tax_amount>\r\n" ); 
						valueXmlString.append( "<invoice_amount><![CDATA[" ).append("0").append( "]]></invoice_amount>\r\n" ); 
						valueXmlString.append( "<total_sgst_amt><![CDATA[" ).append("0").append( "]]></total_sgst_amt>\r\n" ); 
						valueXmlString.append( "<total_cgst_amt><![CDATA[" ).append("0").append( "]]></total_cgst_amt>\r\n" );
						valueXmlString.append( "</Detail"+currentForm+">\r\n" );
						domID++;
					}
				}//end of while
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}

				if(unlistSun==false && !"S".equalsIgnoreCase(custType) && (("D".equalsIgnoreCase(custType) && "Y".equalsIgnoreCase(allowDrUnlist)) || ("C".equalsIgnoreCase(custType) && "Y".equalsIgnoreCase(allowChemistUnlist))))
				{
					srNo++;
					String dcrGroup =checkNull(getDcrGroup(custType,connectionObject)); // adde by mrunalini sinkar on 29-jan-2019

					/*String localityCode = checkNull(genericUtility.getColumnValue("locality_code", dom2, locFormNo));
					String routeIds = checkNull(genericUtility.getColumnValue("route_id", dom2, locFormNo));
					String descr = checkNull(genericUtility.getColumnValue("sprs_route_descr", dom2, locFormNo));*/

					String [] localityData = getLocDataFromDom(dom2, locFormNo, sprsCode, connectionObject);

					String localityCode = localityData[0];
					String routeIds = localityData[1];
					String descr = localityData[2];

					//String []eventTimes = new String [2];
					//valueXmlString.append("<Detail"+currentForm+" domID='"+domID+"' formName='"+formName+"' selected = 'N' protectSubform=\""+teamFormName+"\"><protect_subform><![CDATA["+teamFormName+"]]></protect_subform>\r\n" );
					//valueXmlString.append("<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\" protectSubform=\""+teamFormName+"\"/>\r\n");
					valueXmlString.append( "<Detail"+currentForm+" domID='"+domID+"' formName='"+formName+"' selected = 'N'>\r\n" );
					valueXmlString.append( "<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");
					valueXmlString.append( "<event_type visible='0'><![CDATA[" ).append(actCode).append( "]]></event_type>\r\n" );
					valueXmlString.append( "<activity_type><![CDATA[" ).append(actType).append( "]]></activity_type>\r\n" );
					valueXmlString.append("<member_present visble='1'><![CDATA[" ).append("0").append( "]]></member_present>\r\n" );
					valueXmlString.append("<locality_code protect = '0' visible='0'><![CDATA[" ).append(localityCode).append( "]]></locality_code>\r\n" );
					//valueXmlString.append("<locality_descr protect = '1' visible='0'><![CDATA[" ).append(descr).append( "]]></locality_descr>\r\n" );commented by mrunalini sinkar as per discusttion with Gulzar Sir
					valueXmlString.append("<route_id protect = '0' visible='0'><![CDATA[" ).append(routeIds).append( "]]></route_id>\r\n" );
					//valueXmlString.append("<event_time_start protect = '0' visible = '1'><![CDATA[" ).append(eventTimes[0]).append( "]]></event_time_start>\r\n" );
					valueXmlString.append("<sku_value protect = '0' visible = '1'><![CDATA[" ).append("0").append( "]]></sku_value>\r\n" );
					valueXmlString.append("<stockist_code visible='0'><![CDATA[" ).append("").append( "]]></stockist_code>\r\n" );
					valueXmlString.append("<stockist_name visible='0'><![CDATA[" ).append("").append( "]]></stockist_name>\r\n" );
					valueXmlString.append("<subclass_code visible='0'><![CDATA[" ).append("").append( "]]></subclass_code>\r\n" );
					valueXmlString.append("<subclass_descr visible='0'><![CDATA[" ).append("").append( "]]></subclass_descr>\r\n" );
					valueXmlString.append("<pin visible='0'><![CDATA[" ).append("").append( "]]></pin>\r\n" );
					valueXmlString.append("<promoter_name visible='0'><![CDATA[" ).append("").append( "]]></promoter_name>\r\n" );
					valueXmlString.append("<man_power visible='0'><![CDATA[" ).append("").append( "]]></man_power>\r\n" );
					valueXmlString.append("<image_id visible='0'><![CDATA[" ).append("").append( "]]></image_id>\r\n" );
					valueXmlString.append("<gst_no visible='0'><![CDATA[" ).append("").append( "]]></gst_no>\r\n" );
					valueXmlString.append("<address_as visible='0'><![CDATA[" ).append("").append( "]]></address_as>\r\n" );
					valueXmlString.append("<addr1 visible='0'><![CDATA[" ).append("").append( "]]></addr1>\r\n" );
					valueXmlString.append("<addr2 visible='0'><![CDATA[" ).append("").append( "]]></addr2>\r\n" );
					valueXmlString.append("<addr3 visible='0'><![CDATA[" ).append("").append( "]]></addr3>\r\n" );
					//added by prachi
					valueXmlString.append("<age visible='0'><![CDATA[" ).append("").append( "]]></age>\r\n" );
					valueXmlString.append("<call_outcome visible='0'><![CDATA[" ).append("").append( "]]></call_outcome>\r\n" );
					valueXmlString.append("<gender visible='0'><![CDATA[" ).append("M").append( "]]></gender>\r\n" );
					valueXmlString.append("<mobile_no visible='0'><![CDATA[" ).append( "").append( "]]></mobile_no>\r\n" );
					valueXmlString.append("<email_addr visible='0'><![CDATA[" ).append("").append( "]]></email_addr>\r\n" );
					valueXmlString.append("<strg_class_code visible='0'><![CDATA[" ).append("").append( "]]></strg_class_code>\r\n" );
					valueXmlString.append("<class_code_descr visible='0'><![CDATA[" ).append("").append( "]]></class_code_descr>\r\n" );
					valueXmlString.append("<subclass_code visible='0'><![CDATA[" ).append("").append( "]]></subclass_code>\r\n" );
					valueXmlString.append("<subclass_descr visible='0'><![CDATA[" ).append("").append( "]]></subclass_descr>\r\n" );
					valueXmlString.append("<spl_code visible='0'><![CDATA[" ).append( "" ).append( "]]></spl_code>\r\n" );
					valueXmlString.append("<speciality_descr visible='0'><![CDATA[" ).append( "" ).append( "]]></speciality_descr>\r\n" );
					valueXmlString.append("<next_plan_date visible='0'><![CDATA[" ).append("").append( "]]></next_plan_date>\r\n" );//Added by mrunalini sinkar for next plan date

					valueXmlString.append("<confirmed><![CDATA[" ).append("N").append( "]]></confirmed>\r\n" );
					/*valueXmlString.append("<cust_name protect = '0' visible = '0'><![CDATA[" ).append("").append( "]]></cust_name>\r\n");*/
					valueXmlString.append("<event_date><![CDATA[" ).append(trvDate).append( "]]></event_date>\r\n" );
					valueXmlString.append("<sales_pers><![CDATA[" ).append(sprsCode).append( "]]></sales_pers>\r\n" );
					valueXmlString.append("<remarks><![CDATA[" ).append("").append( "]]></remarks>\r\n" );
					valueXmlString.append("<meet_summ visible = '0'><![CDATA[" ).append("").append( "]]></meet_summ>\r\n" );
					valueXmlString.append("<visited_with_display><![CDATA[" ).append(visitedWithDisp).append( "]]></visited_with_display>\r\n" );
					valueXmlString.append( "<reg_no protect='0'><![CDATA[" ).append("").append( "]]></reg_no>\r\n" );  //added by hariom s for registration value 26-05-21
					//Added by Hariom S for Table View ralated Changes -08-July-2021 [Start]
					valueXmlString.append( "<chg_date><![CDATA[" ).append(currDate).append( "]]></chg_date>\r\n" );
					valueXmlString.append( "<chg_user><![CDATA[" ).append(userId).append( "]]></chg_user>\r\n" );
					valueXmlString.append( "<chg_term><![CDATA[" ).append(chgTerm).append( "]]></chg_term>\r\n" );
					valueXmlString.append("<sr_no><![CDATA[" ).append(srNo).append( "]]></sr_no>\r\n");
					//Added by Hariom S for Table View ralated Changes -08-July-2021 [End]
					if("D".equalsIgnoreCase(custType))
					{
						valueXmlString.append("<cust_type protect = '1' visible = '1'><![CDATA[" ).append("UNLISTED-DOCTOR").append( "]]></cust_type>\r\n" );
						valueXmlString.append("<strg_name protect = '0' visible = '0'><![CDATA[" ).append("UNLISTED DOCTOR MET").append( "]]></strg_name>\r\n" );
						/*valueXmlString.append("<cust_name protect = '0' visible = '0'><![CDATA[" ).append("Unlisted Doctor Met").append( "]]></cust_name>\r\n" );//added by shraddha m to display cust_name in case of unlisted customer[12-11-19]*/
						//valueXmlString.append("<cust_name protect = '0' visible = '0' format='[unlisted-customer:member_present]'><![CDATA[" ).append("Unlisted Doctor Met").append( "]]></cust_name>\r\n" );//Added by Hariom S for Table View ralated Changes -08-July-2021
						valueXmlString.append("<cust_name protect = '0' visible = '0' format='[unlisted-customer:member_present]'><![CDATA[" ).append("UNLISTED DOCTOR MET").append( "]]></cust_name>\r\n" );//Added by Hariom S for Table View ralated Changes -08-July-2021
						valueXmlString.append("<strg_code visible = '0'><![CDATA[" ).append("0000000000").append( "]]></strg_code>\r\n" );
						valueXmlString.append("<order_form_no><![CDATA[" ).append(sampleOrder).append( "]]></order_form_no>\r\n" );
						valueXmlString.append("<team_form_no><![CDATA[" ).append(doctorTeam).append( "]]></team_form_no>\r\n" );
						valueXmlString.append("<invoice_form_no><![CDATA[" ).append(invoiceTeam).append( "]]></invoice_form_no>\r\n" );
						valueXmlString.append("<collection_form_no><![CDATA[" ).append(collectionTeam).append( "]]></collection_form_no>\r\n" );
						valueXmlString.append("<item_form_no><![CDATA[" ).append(samplItem).append( "]]></item_form_no>\r\n" );
						valueXmlString.append("<brand_form_no><![CDATA[" ).append(brand).append( "]]></brand_form_no>\r\n" );
						valueXmlString.append("<display_form_no><![CDATA[" ).append(display).append( "]]></display_form_no>\r\n" );
						valueXmlString.append("<prescription_form_no><![CDATA[" ).append(prescription).append( "]]></prescription_form_no>\r\n" );
						valueXmlString.append("<survey_form_no><![CDATA[" ).append(survey).append( "]]></survey_form_no>\r\n" );
					}
					else if("C".equalsIgnoreCase(custType))
					{
						valueXmlString.append("<cust_type protect = '1' visible = '1'><![CDATA[" ).append("UNLISTED-CHEMIST").append( "]]></cust_type>\r\n" );
						valueXmlString.append("<strg_name protect = '0' visible = '0'><![CDATA[" ).append("NO OF CHEMISTS").append( "]]></strg_name>\r\n" );
						//valueXmlString.append("<cust_name protect = '0' visible = '0'><![CDATA[" ).append("No of Chemists").append( "]]></cust_name>\r\n" );////added by shraddha m to display cust_name in case of unlisted customer[12-11-19]
						valueXmlString.append("<cust_name protect = '0' visible = '0' format='[unlisted-customer:member_present]'><![CDATA[" ).append("NO OF CHEMISTS").append( "]]></cust_name>\r\n" );//Added by Hariom S for Table View ralated Changes -08-July-2021
						valueXmlString.append("<strg_code visible = '0'><![CDATA[" ).append("UR00000000").append( "]]></strg_code>\r\n" );
						valueXmlString.append("<order_form_no><![CDATA[" ).append(chemSampleOrder).append( "]]></order_form_no>\r\n" );
						valueXmlString.append("<team_form_no><![CDATA[" ).append(retailerTeam).append( "]]></team_form_no>\r\n" );
						valueXmlString.append("<item_form_no><![CDATA[" ).append(chemSamplItem).append( "]]></item_form_no>\r\n" );
						valueXmlString.append("<brand_form_no><![CDATA[" ).append(chembrand).append( "]]></brand_form_no>\r\n" );
						valueXmlString.append("<display_form_no><![CDATA[" ).append(chemDisplay).append( "]]></display_form_no>\r\n" );
						valueXmlString.append("<prescription_form_no><![CDATA[" ).append(chemPrescription).append( "]]></prescription_form_no>\r\n" );
						valueXmlString.append("<survey_form_no><![CDATA[" ).append(chemSurvey).append( "]]></survey_form_no>\r\n" );
					}
					else if("S".equalsIgnoreCase(custType))
					{
						valueXmlString.append("<cust_type protect = '1' visible = '1'><![CDATA[" ).append("UNLISTED-STOCKIST").append( "]]></cust_type>\r\n" );
						valueXmlString.append("<strg_name protect = '0' visible = '0'><![CDATA[" ).append("Stockist Details").append( "]]></strg_name>\r\n" );
						//valueXmlString.append("<cust_name protect = '0' visible = '0'><![CDATA[" ).append("Stockist Details").append( "]]></cust_name>\r\n" );//added by shraddha m to display cust_name in case of unlisted customer[12-11-19]
						valueXmlString.append("<cust_name protect = '0' visible = '0' format='[unlisted-customer:member_present]'><![CDATA[" ).append("Stockist Details").append( "]]></cust_name>\r\n" );//Added by Hariom S for Table View ralated Changes -08-July-2021
						valueXmlString.append("<strg_code visible = '0'><![CDATA[" ).append("US00000000").append( "]]></strg_code>\r\n" );
						valueXmlString.append("<order_form_no><![CDATA[" ).append(stockSampleOrder).append( "]]></order_form_no>\r\n" );
						valueXmlString.append("<team_form_no><![CDATA[" ).append(stockistTeam).append( "]]></team_form_no>\r\n" );
						valueXmlString.append("<item_form_no><![CDATA[" ).append(stockSamplItem).append( "]]></item_form_no>\r\n" );
						valueXmlString.append("<brand_form_no><![CDATA[" ).append(stockbrand).append( "]]></brand_form_no>\r\n" );
						valueXmlString.append("<display_form_no><![CDATA[" ).append(stockDisplay).append( "]]></display_form_no>\r\n" );
						valueXmlString.append("<prescription_form_no><![CDATA[" ).append(stockPrescription).append( "]]></prescription_form_no>\r\n" );
						valueXmlString.append("<survey_form_no><![CDATA[" ).append(stockSurvey).append( "]]></survey_form_no>\r\n" );
					}
					else
					{
						valueXmlString.append("<cust_type protect = '1' visible = '1'><![CDATA[" ).append("UNLISTED-OTHER").append( "]]></cust_type>\r\n" );
						valueXmlString.append("<cust_name protect = '0' visible = '0' format='[unlisted-customer:member_present]'><![CDATA[" ).append("").append( "]]></cust_name>\r\n");//Added by Hariom S for Table View ralated Changes -08-July-2021
						valueXmlString.append("<strg_name protect = '0' visible = '0'><![CDATA[" ).append("Other Details").append( "]]></strg_name>\r\n" );
						valueXmlString.append("<strg_code visible = '0'><![CDATA[" ).append("UO00000000").append( "]]></strg_code>\r\n" );
						valueXmlString.append("<order_form_no><![CDATA[" ).append(ncwSampleOrder).append( "]]></order_form_no>\r\n" );
						valueXmlString.append("<team_form_no><![CDATA[" ).append(ncwTeam).append( "]]></team_form_no>\r\n" );
						valueXmlString.append("<item_form_no><![CDATA[" ).append(ncwSamplItem).append( "]]></item_form_no>\r\n" );
						valueXmlString.append("<brand_form_no><![CDATA[" ).append(ncwbrand).append( "]]></brand_form_no>\r\n" );
						valueXmlString.append("<display_form_no><![CDATA[" ).append(ncwDisplay).append( "]]></display_form_no>\r\n" );
						valueXmlString.append("<prescription_form_no><![CDATA[" ).append(ncwPrescription).append( "]]></prescription_form_no>\r\n" );
						valueXmlString.append("<survey_form_no><![CDATA[" ).append(ncwSurvey).append( "]]></survey_form_no>\r\n" );

					}
					valueXmlString.append("<member_present visble='1'><![CDATA[" ).append("0").append( "]]></member_present>\r\n" );
					valueXmlString.append("<event_time_start protect = '0' visible = '1'><![CDATA[" ).append(timeFrom).append( "]]></event_time_start>\r\n" );//Added by Hariom S for Table View ralated Changes -08-July-2021
					valueXmlString.append("<visit_time_from protect = '0' visible = '1'><![CDATA[" ).append(eventTimes[0]).append( "]]></visit_time_from>\r\n" );
					valueXmlString.append("<event_time_end protect = '0' visible = '1'><![CDATA[" ).append(timeTo).append( "]]></event_time_end>\r\n" );

					valueXmlString.append("<strg_type protect = '1' visible = '0'><![CDATA[" ).append(custType).append( "]]></strg_type>\r\n" );
					valueXmlString.append("<dcr_group protect = '1' visible = '0'><![CDATA[" ).append(dcrGroup).append( "]]></dcr_group>\r\n" );
					valueXmlString.append("<current_form_subform><![CDATA[" ).append(subFormDetails).append( "]]></current_form_subform>\r\n" );
					valueXmlString.append("<allow_edit_cust><![CDATA[" ).append(allowEditCust).append( "]]></allow_edit_cust>\r\n" );
					valueXmlString.append("<qualification visible = '0'><![CDATA[" ).append("").append( "]]></qualification>\r\n" );
					valueXmlString.append("<strg_no_visit visible = '0'><![CDATA[" ).append("").append("]]></strg_no_visit>\r\n" );
					if(editCustCnt>0)
					{
						valueXmlString.append("<is_finish_disable><![CDATA[" ).append("Y").append( "]]></is_finish_disable>\r\n" );
					}
					else
					{
						valueXmlString.append("<is_finish_disable><![CDATA[" ).append("N").append( "]]></is_finish_disable>\r\n" );
					}
					valueXmlString.append("<is_fortune_activity><![CDATA[" ).append(isFortune).append( "]]></is_fortune_activity>\r\n" );
					valueXmlString.append("<is_member_present><![CDATA[" ).append(isMemberPresent).append( "]]></is_member_present>\r\n" );
					valueXmlString.append("<sprs_act_code><![CDATA[" ).append(sprsActCode).append( "]]></sprs_act_code>\r\n" );
					valueXmlString.append("<last_meet_summ visible='0'><![CDATA[" ).append("").append( "]]></last_meet_summ>\r\n" );     // added by shweta 07-05-21
					valueXmlString.append("<last_meet_date visible='0'><![CDATA[" ).append("").append( "]]></last_meet_date>\r\n" );    // added by shweta 07-05-21
					valueXmlString.append("<meeting_status visible='0'><![CDATA[" ).append("").append( "]]></meeting_status>\r\n" );
					valueXmlString.append("<price_list><![CDATA[" ).append(pricelistS).append( "]]></price_list>\r\n" ); //Added by bhagyashri T For Price_list SO[W22EBAS004]
					valueXmlString.append( "</Detail"+currentForm+">\r\n" );




				}
			}
			domID = 1;
			//valueXmlString.append( "</Root>\r\n" );//vinayak 31jan

		}
		catch(Exception e)
		{
			System.out.println( "Exception :WsfaZuviusDsrMobileWizardEJB :getCustomerDetail():" + e.getMessage() + ":" );
			e.printStackTrace();
			//valueXmlString = valueXmlString.append( generateErrorString( genericUtility.createErrorString( e ) ) );
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		finally
		{
			try
			{
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}

				if( IsLocalConn && connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :WsfaZuviusDsrMobileWizardEJB :getCustomerDetail :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		return valueXmlString.toString();

	}
	
	// added by shweta for display last remark and last met deta 06-05-21 started 
    public String getPreviousRemark(String salesPers, String workDate, String scCode, String custType,Connection conn) throws Exception
	{
		String prevRemark = "";
		PreparedStatement pstmtPrevRemark = null;
		ResultSet rsPrevRemark = null;
		try
		{
			E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
			String getPrevRemarkSql = "SELECT REMARKS FROM STRG_MEET WHERE SALES_PERS = ? AND EVENT_DATE < ? AND STRG_CODE=?  ORDER BY EVENT_DATE DESC ";
			pstmtPrevRemark = conn.prepareStatement(getPrevRemarkSql);
			pstmtPrevRemark.setString(1,salesPers);
			pstmtPrevRemark.setTimestamp(2,java.sql.Timestamp.valueOf(workDate));
			pstmtPrevRemark.setString(3,scCode);
			rsPrevRemark = pstmtPrevRemark.executeQuery();
			while (rsPrevRemark.next())
			{
				prevRemark = checkNull(rsPrevRemark.getString("REMARKS"));
				if(prevRemark != null && prevRemark.trim().length() > 0)
				{
					break;
				}
			}
			if(rsPrevRemark != null)
			{
				rsPrevRemark.close(); 
				rsPrevRemark = null;
			}
			if(pstmtPrevRemark != null)
			{
				pstmtPrevRemark.close();
				pstmtPrevRemark = null;
			}

		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(rsPrevRemark != null)
				{
					rsPrevRemark.close(); rsPrevRemark = null;
				}
				if(pstmtPrevRemark != null)
				{
					pstmtPrevRemark.close(); pstmtPrevRemark = null;
				}
			}
			catch(Exception e1)
			{}
		}
		return prevRemark;
	}
    
    public String getPreviousVisitDate(String salesPers, String workDate, String scCode, String custType,Connection conn) throws Exception
	{
		String prevDate = "";
		PreparedStatement pstmtPrevDate = null;
		ResultSet rsPrevRemark = null;
		try
		{
			E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
			String getPrevDatesql = "SELECT MAX(EVENT_DATE) AS EVENT_DATE FROM STRG_MEET WHERE SALES_PERS = ? AND EVENT_DATE < ? AND STRG_CODE=?  ORDER BY EVENT_DATE DESC ";
			pstmtPrevDate = conn.prepareStatement(getPrevDatesql);
			pstmtPrevDate.setString(1,salesPers);
			pstmtPrevDate.setTimestamp(2,java.sql.Timestamp.valueOf(workDate));
			pstmtPrevDate.setString(3,scCode);
			rsPrevRemark = pstmtPrevDate.executeQuery();
			while (rsPrevRemark.next())
			{
				prevDate = checkNull(rsPrevRemark.getString("EVENT_DATE"));
				if(prevDate != null && prevDate.trim().length() > 0)
				{
					break;
				}
			}
			if(rsPrevRemark != null)
			{
				rsPrevRemark.close(); 
				rsPrevRemark = null;
			}
			if(pstmtPrevDate != null)
			{
				pstmtPrevDate.close(); 
				pstmtPrevDate = null;
			}

		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(rsPrevRemark != null)
				{
					rsPrevRemark.close(); rsPrevRemark = null;
				}
				if(pstmtPrevDate != null)
				{
					pstmtPrevDate.close(); pstmtPrevDate = null;
				}
			}
			catch(Exception e1)
			{}
		}
		return prevDate;
	}
    
    
 // added by shweta for display last remark and last met deta 06-05-21(End)
	
	
	
	//Changed By Vidhya on 15/10/09[WI89BAS033 | changing signature]
	//public String getItemDetail( Document dom, String currentForm, String userId, String sprsCode, String custCode, String actCode) throws ITMException
	public String getItemDetail( Document dom, Document dom2, String currentForm, String userId, String sprsCode, String custCode, String actCode) throws ITMException
	{
		ResultSet rs = null;
		Connection connectionObject = null;
		PreparedStatement pstmt = null;

		String sql = "";
		String sql1 = "";
		String currDate = "";
		String chgTerm ="";
		String preFormDet ="";
		String trvDate = "";
		String preFormItems ="";
		String salesProdItems ="";
		String items ="";
		boolean flag = false;
		StringBuffer valueXmlString = new StringBuffer();
		String [] temp;

		//changed by Rahul Barve on 10-Apr-2015
		//GenericUtility genericUtility = GenericUtility.getInstance();
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		try
		{
			/*ConnDriver connDriver = new ConnDriver();
			connectionObject = connDriver.getConnectDB( "DriverValidator" );*/
			connectionObject = getConnection();//chnged by sachin satre on [11-nov-16] to get connection
			int custForm = Integer.parseInt(currentForm) - 1;
			//to append previous values of current form from current dom on previous action START
			flag = preDomExists( dom, currentForm );
			//System.out.println( "history detail exists["+ flag +"]" );
			//changes done by prathamesh on 06/7/17 for joins
			//sql = "SELECT DISTINCT SPG.SALES_PROD_GRP CODE, SPG.DESCR DESCRIPTION FROM SALES_PROD_GRP SPG, ITEM M  WHERE M.ITEM_CODE IN ( SELECT ITEM_CODE FROM SPRS_ITEM WHERE SALES_PERS = ? ) AND M.SALES_PROD_GRP = SPG.SALES_PROD_GRP( + )";
			sql= "SELECT DISTINCT SPG.SALES_PROD_GRP CODE, SPG.DESCR DESCRIPTION FROM SALES_PROD_GRP SPG left outer join  ITEM M on M.SALES_PROD_GRP = SPG.SALES_PROD_GRP WHERE M.ITEM_CODE IN ( SELECT ITEM_CODE FROM SPRS_ITEM WHERE SALES_PERS = ? )";

			//sql1 = "SELECT M.ITEM_CODE CODE, M.DESCR DESCRIPTION FROM ITEM M, SALES_PROD_GRP SPG WHERE M.ITEM_CODE IN ( SELECT ITEM_CODE FROM SPRS_ITEM WHERE SALES_PERS = ? ) AND M.SALES_PROD_GRP = SPG.SALES_PROD_GRP( + )";
			sql1= "SELECT M.ITEM_CODE CODE, M.DESCR DESCRIPTION FROM ITEM M left outer join SALES_PROD_GRP SPG on  M.SALES_PROD_GRP = SPG.SALES_PROD_GRP WHERE M.ITEM_CODE IN ( SELECT ITEM_CODE FROM SPRS_ITEM WHERE SALES_PERS = ? )";
			String actType = getActivityType( actCode, connectionObject );
			//if( actType.indexOf("NFW") == -1 && actType.indexOf("LEAVE") == -1 )
			if(actType.equalsIgnoreCase("FW"))
			{
				pstmt =  connectionObject.prepareStatement( sql );
				pstmt.setString(1, checkNull(sprsCode));
				rs = pstmt.executeQuery();
				while(rs.next())
				{

					valueXmlString.append( "<Detail"+currentForm+" domID='" + domID + "' selected = 'N'>\r\n" );
					valueXmlString.append( "<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");//Gaurav Singh on 03/06/15
					valueXmlString.append("<item_descr><![CDATA[").append(checkNull(rs.getString("DESCRIPTION"))).append("]]></item_descr>\r\n");
					valueXmlString.append( "<quantity><![CDATA[" ).append( "0" ).append( "]]></quantity>\r\n" );					valueXmlString.append("<item_code><![CDATA[").append("").append("]]></item_code>\r\n");
					valueXmlString.append( "<sales_prod_grp><![CDATA[" ).append(checkNull(rs.getString("CODE"))).append( "]]></sales_prod_grp>\r\n" );
					valueXmlString.append("<strg_code><![CDATA[").append(checkNull(custCode)).append("]]></strg_code>\r\n");
					valueXmlString.append("<line_no><![CDATA[]]></line_no>\r\n");
					valueXmlString.append( "<item_type><![CDATA[" ).append("").append( "]]></item_type>\r\n" );
					valueXmlString.append( "<briefed><![CDATA[" ).append("").append( "]]></briefed>\r\n" );
					valueXmlString.append( "<item_pob><![CDATA[" ).append("").append( "]]></item_pob>\r\n" );
					valueXmlString.append( "<dcr_id><![CDATA[]]></dcr_id>\r\n" );
					valueXmlString.append( "<briefed_descr><![CDATA[" ).append("P1").append( "]]></briefed_descr>\r\n" );
					valueXmlString.append( "</Detail"+currentForm+">\r\n" );
					domID++;

				}
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}

				pstmt =  connectionObject.prepareStatement( sql1 );
				pstmt.setString(1, checkNull(sprsCode));
				rs = pstmt.executeQuery();
				while(rs.next())
				{
					valueXmlString.append( "<Detail"+currentForm+" domID='" + domID + "' selected = 'N'>\r\n" );
					valueXmlString.append( "<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");//Gaurav Singh on 03/06/15
					valueXmlString.append("<item_descr><![CDATA[").append(checkNull(rs.getString("DESCRIPTION"))).append("]]></item_descr>\r\n");
					valueXmlString.append( "<quantity><![CDATA[" ).append( "0" ).append( "]]></quantity>\r\n" );					valueXmlString.append("<item_code><![CDATA[").append(checkNull(rs.getString("CODE"))).append("]]></item_code>\r\n");
					valueXmlString.append( "<sales_prod_grp><![CDATA[" ).append("").append( "]]></sales_prod_grp>\r\n" );
					valueXmlString.append("<strg_code><![CDATA[").append(checkNull(custCode)).append("]]></strg_code>\r\n");
					valueXmlString.append("<line_no><![CDATA[]]></line_no>\r\n");
					valueXmlString.append( "<item_type><![CDATA[" ).append("").append( "]]></item_type>\r\n" );
					valueXmlString.append( "<briefed><![CDATA[" ).append("").append( "]]></briefed>\r\n" );
					valueXmlString.append( "<item_pob><![CDATA[" ).append("").append( "]]></item_pob>\r\n" );
					valueXmlString.append( "<dcr_id><![CDATA[]]></dcr_id>\r\n" );
					valueXmlString.append( "<briefed_descr><![CDATA[" ).append("Promo Material").append( "]]></briefed_descr>\r\n" );
					valueXmlString.append( "</Detail"+currentForm+">\r\n" );
					domID++;
				}
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				domID = 1;
			}
			if(flag)
			{
				//Changed By Vidhya on 15/10/09[WI89BAS033 | changing signature]
				//preFormDet = getPrevFormValues( dom, currentForm, domID );
				String customers = getCustFromDom( dom2, Integer.toString( custForm ), sprsCode,connectionObject ); //Chnaged by sachin satre on 11-nov-16
				temp = customers.split(",");
				preFormDet = getPrevFormValues( dom, currentForm, new ArrayList<String>( Arrays.asList( temp ) ), "strg_code" );
				if( preFormDet != null || !"null".equalsIgnoreCase(preFormDet))
				{
					valueXmlString.append( preFormDet );
					domID = domID + 1;
				}

			}
			else
			{
				trvDate =  getSelectedRowValue( dom2, "1", "event_date", 0);
				if ( trvDate != null )
				{
					trvDate = genericUtility.getValidDateString( trvDate , getApplDateFormat() , "dd-MMM-yyyy");
				}

				String dcrID = "";
				String smiQuery = "SELECT DCR_ID FROM SPRS_ACT_TRAN WHERE EVENT_DATE =? AND SALES_PERS = ?";
				pstmt = connectionObject.prepareStatement( smiQuery );
				//pstmt.setString(1, trvDate);//Shahu - 27/10/12
				pstmt.setTimestamp(1, java.sql.Timestamp.valueOf(trvDate));//Shahu - 27/10/12
				pstmt.setString(2, sprsCode);
				rs = pstmt.executeQuery();
				while( rs.next() )
				{
					dcrID = checkNull(rs.getString("DCR_ID"));
				}
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}


				//smiQuery = "SELECT ITEM.DESCR DESCR, LINE_NO, ITEM_POB, STRG_MEET_ITEMS.ITEM_CODE, STRG_MEET_ITEMS.SALES_PROD_GRP, STRG_CODE, ITEM.ITEM_TYPE, ITEM.ITEM_USAGE, STRG_MEET_ITEMS.BRIEFED, STRG_MEET_ITEMS.QUANTITY, STRG_MEET_ITEMS.BRIEFED_DESCR, SALES_PROD_GRP.DESCR AS SPG_DESCR FROM STRG_MEET_ITEMS, ITEM ITEM ,SALES_PROD_GRP SALES_PROD_GRP  WHERE (STRG_MEET_ITEMS.ITEM_CODE = ITEM.ITEM_CODE (+)) AND (STRG_MEET_ITEMS.SALES_PROD_GRP = SALES_PROD_GRP.SALES_PROD_GRP (+)) AND STRG_MEET_ITEMS.DCR_ID= '"+dcrID+"' ";
				smiQuery = "SELECT ITEM.DESCR DESCR, LINE_NO, ITEM_POB, STRG_MEET_ITEMS.ITEM_CODE, STRG_MEET_ITEMS.SALES_PROD_GRP, STRG_CODE, ITEM.ITEM_TYPE, ITEM.ITEM_USAGE, STRG_MEET_ITEMS.BRIEFED, STRG_MEET_ITEMS.QUANTITY, STRG_MEET_ITEMS.BRIEFED_DESCR, SALES_PROD_GRP.DESCR AS SPG_DESCR " +
						"   FROM STRG_MEET_ITEMS LEFT OUTER JOIN ITEM ITEM ON (STRG_MEET_ITEMS.ITEM_CODE = ITEM.ITEM_CODE ) LEFT OUTER JOIN SALES_PROD_GRP SALES_PROD_GRP ON (STRG_MEET_ITEMS.SALES_PROD_GRP = SALES_PROD_GRP.SALES_PROD_GRP ) " +
						"   WHERE STRG_MEET_ITEMS.DCR_ID= '"+dcrID+"' ";

				pstmt = connectionObject.prepareStatement(smiQuery);
				rs = pstmt.executeQuery();
				while(rs.next())
				{
					String item = checkNull(rs.getString("DESCR"));
					String sprogrp = checkNull(rs.getString("SPG_DESCR"));


					valueXmlString.append( "<Detail5 domID='" + domID + "' selected = 'Y'>\r\n" );
					valueXmlString.append( "<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\"/>\r\n");//Gaurav Singh on 03/06/15
					if( !item.equals("") )
					{
						valueXmlString.append("<item_descr>").append( item ).append("</item_descr>\n");

					}
					else if ( ! sprogrp.equals("") )
					{
						valueXmlString.append("<item_descr>").append(sprogrp).append("</item_descr>\n");
					}

					//valueXmlString.append("<quantity>").append(checkNull(rs.getString("QUANTITY"))).append("</quantity>\n");//Gulzar
					valueXmlString.append("<quantity>").append(rs.getInt("QUANTITY")).append("</quantity>\n");//Gulzar
					valueXmlString.append("<item_code><![CDATA[").append(checkNull(rs.getString("ITEM_CODE"))).append("]]></item_code>\n");
					valueXmlString.append("<sales_prod_grp><![CDATA[").append(checkNull(rs.getString("SALES_PROD_GRP"))).append("]]></sales_prod_grp>\n");
					valueXmlString.append("<strg_code><![CDATA[").append( checkNull(rs.getString("STRG_CODE")) ).append("]]></strg_code>\r\n");
					valueXmlString.append("<line_no><![CDATA[").append( checkNull(rs.getString("LINE_NO")) ).append("]]></line_no>\r\n");

					valueXmlString.append( "<item_type><![CDATA[" ).append( checkNull(rs.getString("ITEM_TYPE")) ).append( "]]></item_type>\r\n" );
					valueXmlString.append( "<briefed><![CDATA[" ).append( checkNull(rs.getString("BRIEFED"))).append( "]]></briefed>\r\n" );
					valueXmlString.append( "<item_pob><![CDATA[" ).append( checkNull(rs.getString("ITEM_POB")) ).append( "]]></item_pob>\r\n" );
					valueXmlString.append( "<briefed_descr><![CDATA[" ).append( checkNull(rs.getString("BRIEFED_DESCR")) ).append( "]]></briefed_descr>\r\n" );

					valueXmlString.append( "</Detail5>\r\n" );
					domID++;

				}
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
			}


		}
		catch(Exception e)
		{
			System.out.println( "Exception :WsfaZuviusDsrMobileWizardEJB :defaultDataWiz(Document,String):" + e.getMessage() + ":" );
			//valueXmlString = valueXmlString.append( generateErrorString( genericUtility.createErrorString( e ) ) );
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}

				if( connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :WsfaZuviusDsrMobileWizardEJB :defaultDataWiz :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		return valueXmlString.toString();

	}

	//New overloaded method is added to select the pitch detail - Gulzar on 18/06/12

	//Getting Default Values for forms End*********

	//Utility Functions Start****************
	//*****Public Methods ***** Start
	//to get StanCodeFrom of the salesPerson's last visited place from DB
	//Commented by Gaurav Singh on 02-Jun-2015 for Request Id [W15BMIT002].Start
	/*
	public String getStanCodeFrom( Connection con, String userId, String currDate ) throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String localityCodeFrom = "";
		//changed by Rahul Barve on 10-Apr-2015
		//GenericUtility genericUtility = GenericUtility.getInstance();
		 E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		try
		{
			//Commented and changes by gulzar to get the last sation based on their max ordr of visit
			String stanCodeSql = "SELECT ST.LOCALITY_CODE FROM  SPRS_TRAVEL ST, LOCALITY LOC "+
								" WHERE ORDER_OF_VISIT = ( SELECT MAX( ORDER_OF_VISIT) "+
								" FROM SPRS_TRAVEL WHERE SALES_PERS= ? AND TRAVEL_DATE =(SELECT MAX(TRAVEL_DATE) FROM SPRS_TRAVEL WHERE SALES_PERS=?) ) "+
								" AND LOC.LOCALITY_CODE = ST.LOCALITY_CODE "+
								" AND ST.SALES_PERS= ? AND ST.TRAVEL_DATE  =(SELECT MAX(TRAVEL_DATE) FROM SPRS_TRAVEL WHERE SALES_PERS=?) ";
			//pstmt =  con.prepareStatement( "SELECT ST.LOCALITY_CODE FROM  SPRS_TRAVEL ST, LOCALITY LOC WHERE TRAN_ID = ( SELECT MAX( TRAN_ID ) FROM SPRS_TRAVEL WHERE SALES_PERS= ? AND TRAVEL_DATE <= ? ) AND LOC.LOCALITY_CODE = ST.LOCALITY_CODE" );
			pstmt =  con.prepareStatement(stanCodeSql);
			pstmt.setString(1, userId );
			//pstmt.setTimestamp( 2, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( currDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
			pstmt.setString(2, userId );
			pstmt.setString(3, userId );
			pstmt.setString(4, userId );
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				localityCodeFrom = rs.getString(1);
			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}

		}
		catch ( Exception e )
		{
			System.out.println( "Exception :WsfaZuviusDsrMobileWizardEJB :defaultDataWiz :==>\n"+e.getMessage());
			throw new ITMException(e);
		}

		return localityCodeFrom;
	}
	 */
	//Commented by Gaurav Singh on 02-Jun-2015 for Request Id [W15BMIT002].End
	//to check if input is null or "null"
	public String checkNull(String input)
	{
		if (input == null || "null".equalsIgnoreCase(input))
		{
			input= "";
		}
		return input.trim();
	}
	public String checkNullNum(String input)
	{
		if (input == null || "null".equalsIgnoreCase(input))
		{
			input= "0";
		}
		return input.trim();
	}
	//to check if current dom contains values (for previous action)
	public boolean preDomExists(Document dom, String currentFormNo) throws ITMException
	{
		System.out.println("Inside DAR preDomExists");
		NodeList parentList = null;
		NodeList childList = null;
		Node childNode = null;
		boolean selected = false;

		try
		{
			parentList = dom.getElementsByTagName("Detail" + currentFormNo);
			System.out.println("Inside DAR preDomExists parentList:"+parentList);
			if ( parentList.item(0) != null )
			{
				childList = parentList.item(0).getChildNodes();
				System.out.println("Inside DAR preDomExists childList:"+childList);
				for (int ctr = 0; ctr < childList.getLength(); ctr++)
				{
					childNode = childList.item(ctr);
					System.out.println("Inside DAR preDomExists childNode:"+childNode);
					if((childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null))
					{
						System.out.println("Column found DAR!!!" + childNode.getNodeName());
						selected = true;
						break;
					}
				}
			}


		}
		catch ( Exception e )
		{
			System.out.println( "Exception :WsfaStrgMeetDCREJB :preDomExists :==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		System.out.println("preDomExists in  DAR =["+selected+"] and currentFormNo in DAR =["+currentFormNo+"]");

		return selected;
	}

	//to get previous dom values and set selected attribute to 'y' (for previous action)
	public String getPrevFormValues( Document dom, String currentFormNo, ArrayList temp, String colName) throws ITMException
	{
		//changed by Rahul Barve on 10-Apr-2015
		//GenericUtility genericUtility = GenericUtility.getInstance();
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;
		Element elementAttr = null;
		String childNodeName = "";
		String columnValue = "";
		String returnPrevStr = "";
		Document chgPreDom = null;
		try
		{
			chgPreDom = genericUtility.parseString("<Root/>");
			//System.out.println("currentFormNo ["+currentFormNo+"]");
			parentList = dom.getElementsByTagName("Detail" + currentFormNo);
			int parentNodeListLength = parentList.getLength();
			for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
			{
				parentNode = parentList.item(prntCtr);
				childList = parentNode.getChildNodes();
				for (int ctr = 0; ctr < childList.getLength(); ctr++)
				{
					childNode = childList.item(ctr);

					if((childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null))
					{
						columnValue = childNode.getFirstChild().getNodeValue().trim();
						if ( childNode.getNodeName().equalsIgnoreCase(colName) && temp.contains("'"+columnValue+"'"))
						{
							elementAttr = (Element)parentNode;
							if ( parentNode.getAttributes().getNamedItem( "domID" ) != null )
							{
								//elementAttr.setAttribute( "domID" , Integer.toString(domID) );
								elementAttr.setAttribute( "selected" , "Y" );
								domID++;
							}
							Node importedNode = chgPreDom.importNode( parentNode, true );
							chgPreDom.getDocumentElement().appendChild( importedNode );
							break;
						}

					}
				}

			}
			if(currentFormNo.equals("1"))
			{
				domID = 1;
			}
			returnPrevStr = genericUtility.serializeDom(chgPreDom);
			if(returnPrevStr.indexOf("Detail"+currentFormNo) != -1)
			{
				returnPrevStr = returnPrevStr.substring(returnPrevStr.indexOf(">") + 1, returnPrevStr.lastIndexOf("</"));
			}
			returnPrevStr = returnPrevStr.indexOf("Detail"+currentFormNo) != -1 ? returnPrevStr : "";
		}
		catch ( Exception e )
		{
			//System.out.println( "Exception :WsfaZuviusDsrMobileWizardEJB :getPrevFormValues :==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		return returnPrevStr;

	}
	public String getLocFromDom(Document dom, String currentForm, String sprsCode,Connection connectionObject) throws ITMException //Chnaged by sachin satre on 11-nov-16
	{
		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;

		//Connection connectionObject = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null ;
		StringBuffer localityBuff = new StringBuffer();
		ArrayList temp = new ArrayList(100);
		String sql = "";
		String columnValue = "";
		boolean isLocalConn =false;
		try
		{
			if(connectionObject == null)
			{
				/*ConnDriver connDriver = new ConnDriver();
				connectionObject = connDriver.getConnectDB("Driver");*/
				connectionObject = getConnection();//chnged by sachin satre on [11-nov-16] to get connection
				isLocalConn =true;
			}
			sql = "SELECT * FROM SPRS_ROUTE WHERE SPRS_CODE = ? AND LOCALITY_CODE = ?";
			//Changed By Vidhya on 16/12/09[WS89NOV642 | to make connection before any loop]
			pstmt = connectionObject.prepareStatement(sql);

			String CheckUpdateFlag = "";
			parentList = dom.getElementsByTagName("Detail" + currentForm);
			int parentNodeListLength = parentList.getLength();
			for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
			{
				parentNode = parentList.item(prntCtr);
				childList = parentNode.getChildNodes();

				for (int ctr = 0; ctr < childList.getLength(); ctr++)
				{
					childNode = childList.item(ctr);
					if(childNode.getNodeName().equalsIgnoreCase("attribute"))
					{
						if(childNode.getAttributes().getNamedItem("updateFlag") != null)
						{
							CheckUpdateFlag = checkNull(childNode.getAttributes().getNamedItem("updateFlag").getNodeValue());
						}
					}
					if ( childNode != null && childNode.getFirstChild() != null )
					{
						columnValue = childNode.getFirstChild().getNodeValue().trim();
					}
					if( childNode.getNodeName().equalsIgnoreCase("locality_code") && !"D".equalsIgnoreCase(CheckUpdateFlag))
					{

						if ( temp.contains(columnValue))
						{
							continue;
						}

						pstmt.setString(1, sprsCode);
						pstmt.setString(2, columnValue);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							if(localityBuff.length() == 0)
							{
								localityBuff.append("'").append(columnValue.toUpperCase()).append("'");
							}
							else
							{
								localityBuff.append(",'").append(columnValue.toUpperCase()).append("'");
							}
						}
						temp.add(columnValue);
					}
				}
			}

			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
			temp.clear();

		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		finally
		{
			try
			{
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				if (isLocalConn && connectionObject != null )
				{
					connectionObject.close();
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}

		return localityBuff.toString();

	}

	//get location selected from given dom in a String Buffer
	public String getLocFromDom(Document dom, String currentForm, String sprsCode, String custType,Connection connectionObject) throws ITMException //Chnaged by sachin satre on 11-nov-16
	{
		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;

		//Connection connectionObject = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null ;
		StringBuffer localityBuff = new StringBuffer();
		ArrayList temp = new ArrayList(100);
		String sql = "";
		String columnValue = "";
		String drVisit = "";//Gulzar  on 6/10/2012
		String chemVisit = "";//Gulzar on 17/06/12
		String stockVisit = "";//Gulzar on 17/06/12
		String othVisit = "";//Gulzar on 17/06/12
		String localityCode = "";//Gulzar  on 6/10/2012
		boolean isLocalConn =false;
		int currFormNo = 0;
		if(currentForm != null && currentForm.trim().length()>0)
			currFormNo = Integer.parseInt(currentForm);
		String objName = checkNull(getObjNameFromDom(dom, "objName",currFormNo));
		//String locFormNo = checkNull(getFormNo(objName, "place", connectionObject));
		String mainFormNo = checkNull(getFormNo(objName, "mainform", connectionObject));
		try
		{
			if(connectionObject == null )
			{
				/*ConnDriver connDriver = new ConnDriver();
				connectionObject = connDriver.getConnectDB("Driver");*/
				connectionObject = getConnection();//chnged by sachin satre on [11-nov-16] to get connection
				isLocalConn =true;
			}
			//changed by Rahul Barve on 10-Apr-2015
			//GenericUtility genericUtility = GenericUtility.getInstance();
			E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

			//System.out.println("dom2:::"+genericUtility.serializeDom(dom));

			String activityCode = genericUtility.getColumnValue("activity_code", dom, mainFormNo);
			String activityType = checkNull(getActivityType(activityCode, connectionObject));
			if (!"FW".equalsIgnoreCase(activityType))
			{
				String localityDetail = getLocFromDom(dom, currentForm, sprsCode,connectionObject); //Chnaged by sachin satre on 11-nov-16
				//System.out.println("localityDetail :::"+localityDetail);
				return localityDetail;
			}

			sql = "SELECT * FROM SPRS_ROUTE WHERE SPRS_CODE = ? AND LOCALITY_CODE = ?";
			//Changed By Vidhya on 16/12/09[WS89NOV642 | to make connection before any loop]
			pstmt = connectionObject.prepareStatement(sql);

			parentList = dom.getElementsByTagName("Detail" + currentForm);
			int parentNodeListLength = parentList.getLength();
			for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
			{
				parentNode = parentList.item(prntCtr);
				childList = parentNode.getChildNodes();

				drVisit = "";
				localityCode = "";
				String updateFlag = "";
				for (int ctr = 0; ctr < childList.getLength(); ctr++)
				{
					childNode = childList.item(ctr);
					if ( childNode != null && childNode.getFirstChild() != null )
					{
						columnValue = childNode.getFirstChild().getNodeValue().trim();
					}
					//Added by vinayak
					//System.out.println("Outside if flag:-");
					if(childNode.getNodeName().equalsIgnoreCase("attribute"))
					{
						//if(childNode.getAttributes().getNamedItem("updateFlag") != null)
						if(childNode.getAttributes().getNamedItem("updateFlag") != null)
						{
							//System.out.println("Outside if flag232:-");
							updateFlag = childNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
						}
					}
					//Added by vinayak
					//System.out.println("Value of update flag:-  "+updateFlag);
					if(!updateFlag.trim().equalsIgnoreCase("D"))
					{
						//System.out.println("Value of update flag:-  "+updateFlag);
						if( childNode.getNodeName().equalsIgnoreCase("locality_code"))
						{
							if ( temp.contains(columnValue))
							{
								continue;
							}
							localityCode = columnValue;

							/*--Gulzar on 6/11/2012
							pstmt.setString(1, sprsCode);
							pstmt.setString(2, columnValue);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								if(localityBuff.length() == 0)
								{
									localityBuff.append("'").append(columnValue.toUpperCase()).append("'");
								}
								else
								{
									localityBuff.append(",'").append(columnValue.toUpperCase()).append("'");
								}
							}
							temp.add(columnValue);
							 */
						}
						else if( childNode.getNodeName().equalsIgnoreCase("dr_visit"))
						{
							drVisit = columnValue;
						}
						else if( childNode.getNodeName().equalsIgnoreCase("chem_visit"))
						{
							chemVisit = columnValue;
						}

						else if( childNode.getNodeName().equalsIgnoreCase("stockist_visit"))
						{
							stockVisit = columnValue;
						}
						else if( childNode.getNodeName().equalsIgnoreCase("other_visit"))
						{
							othVisit = columnValue;
						}
					}

				}
				//System.out.println("drVisit=["+drVisit+"]");
				//System.out.println("localityCode=["+localityCode+"]");
				int countLoc = 0;
				if(!updateFlag.trim().equalsIgnoreCase("D"))
				{
					if ( "D".equalsIgnoreCase(custType) && drVisit != null && drVisit.trim().length() > 0 && "Y".equalsIgnoreCase(drVisit.trim()) && localityCode != null && localityCode.trim().length() > 0 )
					{
						pstmt.setString(1, sprsCode);
						pstmt.setString(2, localityCode);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							if(localityBuff.length() == 0)
							{
								localityBuff.append("'").append(localityCode.toUpperCase()).append("'");
							}
							else
							{
								localityBuff.append(",'").append(localityCode.toUpperCase()).append("'");
							}
						}
						pstmt.clearParameters();
						temp.add(localityCode);
						countLoc++;
					}
					else if ( "C".equalsIgnoreCase(custType) && chemVisit != null && chemVisit.trim().length() > 0 && "Y".equalsIgnoreCase(chemVisit.trim()) && localityCode != null && localityCode.trim().length() > 0 )
					{
						pstmt.setString(1, sprsCode);
						pstmt.setString(2, localityCode);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							if(localityBuff.length() == 0)
							{
								localityBuff.append("'").append(localityCode.toUpperCase()).append("'");
							}
							else
							{
								localityBuff.append(",'").append(localityCode.toUpperCase()).append("'");
							}
						}
						pstmt.clearParameters();
						temp.add(localityCode);
						countLoc++;
					}
					//changed by rahul barve on 6-apr-2015 [Start] to display stockist details.
					else if ( "S".equalsIgnoreCase(custType) && stockVisit != null && stockVisit.trim().length() > 0 && "Y".equalsIgnoreCase(stockVisit.trim()) && localityCode != null && localityCode.trim().length() > 0 )
					{
						pstmt.setString(1, sprsCode);
						pstmt.setString(2, localityCode);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							if(localityBuff.length() == 0)
							{
								localityBuff.append("'").append(localityCode.toUpperCase()).append("'");
							}
							else
							{
								localityBuff.append(",'").append(localityCode.toUpperCase()).append("'");
							}
						}
						pstmt.clearParameters();
						temp.add(localityCode);
						countLoc++;
					}
					else if ( "O".equalsIgnoreCase(custType) && othVisit != null && othVisit.trim().length() > 0 && "Y".equalsIgnoreCase(othVisit.trim()) && localityCode != null && localityCode.trim().length() > 0 )
					{
						pstmt.setString(1, sprsCode);
						pstmt.setString(2, localityCode);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							if(localityBuff.length() == 0)
							{
								localityBuff.append("'").append(localityCode.toUpperCase()).append("'");
							}
							else
							{
								localityBuff.append(",'").append(localityCode.toUpperCase()).append("'");
							}
						}
						pstmt.clearParameters();
						temp.add(localityCode);
						countLoc++;
					}
					/*
						else if(countLoc == 0)
						{
							pstmt.setString(1, sprsCode);
							pstmt.setString(2, localityCode);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								if(localityBuff.length() == 0)
								{
									localityBuff.append("'").append(localityCode.toUpperCase()).append("'");
								}
								else
								{
									localityBuff.append(",'").append(localityCode.toUpperCase()).append("'");
								}
							}
							pstmt.clearParameters();
							temp.add(localityCode);
						}
					 */

				}
				//changed by rahul barve on 6-apr-2015 [End] to display stockist details.
			}

			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
			temp.clear();

		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				if (isLocalConn && connectionObject != null)
				{
					connectionObject.close();
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		//System.out.println("localityBuff =["+localityBuff.toString()+"]");

		return localityBuff.toString();

	}
	//get customers selected from given dom in a String Buffer
	public String getCustFromDom( Document dom, String currentForm, String sprsCode ,Connection connectionObject) throws ITMException //Chnaged by sachin satre on 11-nov-16
	{
		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;

		//Connection connectionObject = null;
		//Changed By Vidhya on 16/12/09[WS89NOV642 | to make connection before any loop]
		//Statement stmt = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null ;
		StringBuffer custBuff = new StringBuffer();
		ArrayList temp = new ArrayList(100);
		String sql = "";
		String columnValue = "";
		boolean isLocalConn=false;
		try
		{
			if(connectionObject == null)
			{
				/*ConnDriver connDriver = new ConnDriver();
				connectionObject = connDriver.getConnectDB("Driver");*/
				connectionObject = getConnection();//chnged by sachin satre on [11-nov-16] to get connection
				isLocalConn =true;
			}
			parentList = dom.getElementsByTagName("Detail" + currentForm);
			int parentNodeListLength = parentList.getLength();
			//Changed By Vidhya on 16/12/09[WS89NOV642 | to make connection before any loop] Start
			sql = "SELECT * FROM STRG_SERIES SS, STRG_CUSTOMER SC WHERE SS.SC_CODE = SC.SC_CODE AND SS.SALES_PERS = ? AND LOCALITY_CODE = ? AND SS.SC_CODE = ?";
			pstmt = connectionObject.prepareStatement(sql);
			//Changed By Vidhya on 16/12/09[WS89NOV642 | to make connection before any loop] end
			for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
			{
				String locality = getSelectedRowValue( dom, currentForm, "locality_code", prntCtr);

				parentNode = parentList.item(prntCtr);
				childList = parentNode.getChildNodes();

				for (int ctr = 0; ctr < childList.getLength(); ctr++)
				{
					childNode = childList.item(ctr);
					if ( childNode != null && childNode.getFirstChild() != null &&  childNode.getNodeName().equalsIgnoreCase("strg_code") )
					{
						columnValue = childNode.getFirstChild().getNodeValue();

						if( temp.contains(columnValue) )
						{
							continue;
						}
						//Changed By Vidhya on 16/12/09[WS89NOV642 | to make connection before any loop]Start
						pstmt.setString(1, sprsCode);
						pstmt.setString(2, locality);
						pstmt.setString(3, columnValue);
						rs = pstmt.executeQuery();
						//Changed By Vidhya on 16/12/09[WS89NOV642 | to make connection before any loop] End
						if( rs.next() )
						{
							if( custBuff.length() == 0)
							{
								custBuff.append("'").append( columnValue ).append("'");
							}
							else
							{
								custBuff.append(",'").append( columnValue ).append("'");
							}
						}
						//added by rakesh kumar 14/12/12.
						if (rs!= null)
						{
							rs.close();
							rs = null;
						}
						temp.add( columnValue );

					}
				}
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
			temp.clear();

		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		finally
		{
			try
			{
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				//Changed By Vidhya on 16/12/09[WS89NOV642 | to make connection before any loop] End

				if (isLocalConn && connectionObject != null)
				{
					connectionObject.close();
					connectionObject=null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return custBuff.toString();
	}

	//Vidhya on 23/10/09 overloaded method to get previoulsy customers selected from given dom in a String Buffer
	public String getCustFromDom( Document dom, String currentForm, String sprsCode, String attrValue ,Connection connectionObject) throws ITMException //Chnaged by sachin satre on 11-nov-16
	{
		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;

		//Connection connectionObject = null;
		//Changed By Vidhya on 16/12/09[WS89NOV642 | to make connection before any loop]
		//Statement stmt = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null ;
		StringBuffer custBuff = new StringBuffer();
		ArrayList temp = new ArrayList(100);
		String sql = "";
		String columnValue = "";
		boolean isLocalConn =false;
		try
		{
			if( connectionObject == null)
			{
				/*ConnDriver connDriver = new ConnDriver();
				connectionObject = connDriver.getConnectDB("Driver");*/
				connectionObject = getConnection();//chnged by sachin satre on [11-nov-16] to get connection
				isLocalConn =true;
			}
			parentList = dom.getElementsByTagName("Detail" + currentForm);
			int parentNodeListLength = parentList.getLength();
			//Changed By Pragyan 2/9/2011 to Solve the bug
			//Changed By Vidhya on 16/12/09[WS89NOV642 | to make connection before any loop] Start
			//sql = "SELECT * FROM STRG_SERIES SS, STRG_CUSTOMER SC WHERE SS.SC_CODE = SC.SC_CODE AND SS.SALES_PERS = ? AND LOCALITY_CODE = ? AND SS.SC_CODE = ?";
			sql = "SELECT * FROM STRG_SERIES SS, STRG_CUSTOMER SC WHERE SS.SC_CODE = SC.SC_CODE AND SS.SALES_PERS = ? AND SC.LOCALITY_CODE = ? AND SS.SC_CODE = ?";
			pstmt = connectionObject.prepareStatement(sql);
			//Changed By Vidhya on 16/12/09[WS89NOV642 | to make connection before any loop] End
			for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
			{
				String locality = getSelectedRowValue( dom, currentForm, "locality_code", prntCtr);

				parentNode = parentList.item(prntCtr);
				childList = parentNode.getChildNodes();

				for (int ctr = 0; ctr < childList.getLength(); ctr++)
				{
					childNode = childList.item(ctr);
					if ( childNode != null && childNode.getFirstChild() != null &&  childNode.getNodeName().equalsIgnoreCase("strg_code") )
					{
						columnValue = childNode.getFirstChild().getNodeValue();
						if( parentNode.getAttributes().getNamedItem("selected").getNodeValue().equalsIgnoreCase(attrValue))
						{
							if( temp.contains(columnValue) )
							{

								continue;
							}
							//Changed By Vidhya on 16/12/09[WS89NOV642 | to make connection before any loop] Start
							/*pstmt.setString(1, sprsCode);
							pstmt.setString(2, locality);
							pstmt.setString(3, columnValue);
							rs = pstmt.executeQuery();
							//Changed By Vidhya on 16/12/09[WS89NOV642 | to make connection before any loop] End
							if( rs.next() )
							{*/
							if( custBuff.length() == 0)
							{
								custBuff.append("'").append( columnValue ).append("'");
							}
							else
							{
								custBuff.append(",'").append( columnValue ).append("'");
							}
							//}
							//added by rakesh kumar 14/12/12.
							/*if (rs != null)
							{
								rs.close();
								rs = null;
							}*/
							temp.add( columnValue );
						}
					}
				}
			}

			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
			temp.clear();

		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018


		}
		finally
		{
			try
			{
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				//Changed By Vidhya on 16/12/09[WS89NOV642 | to make connection before any loop] End
				if (isLocalConn && connectionObject != null)
				{
					connectionObject.close();
					connectionObject=null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return custBuff.toString();
	}


	public String getItemsFromDom( Document dom, String currentForm, String sprsCode, String attrValue ) throws ITMException
	{
		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;

		Connection connectionObject = null;
		Statement stmt = null;
		ResultSet rs = null ;
		StringBuffer itemBuff = new StringBuffer();
		ArrayList temp = new ArrayList(100);
		String sql = "";
		String columnValue = "";
		try
		{
			/*ConnDriver connDriver = new ConnDriver();
			connectionObject = connDriver.getConnectDB("Driver");*/
			connectionObject = getConnection();//chnged by sachin satre on [11-nov-16] to get connection
			parentList = dom.getElementsByTagName("Detail" + currentForm);
			int parentNodeListLength = parentList.getLength();
			for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
			{

				parentNode = parentList.item(prntCtr);
				childList = parentNode.getChildNodes();

				for (int ctr = 0; ctr < childList.getLength(); ctr++)
				{
					childNode = childList.item(ctr);
					if ( childNode != null && childNode.getFirstChild() != null &&  childNode.getNodeName().equalsIgnoreCase("sales_prod_grp") )
					{
						columnValue = childNode.getFirstChild().getNodeValue().trim();
						if( parentNode.getAttributes().getNamedItem("selected").getNodeValue().equalsIgnoreCase(attrValue))
						{
							if( temp.contains(columnValue.trim()+"-SPG") )
							{
								continue;
							}
							// changes done by prathamesh jangam on 06 jul for left outer join in db2
							//sql = "SELECT DISTINCT SPG.SALES_PROD_GRP CODE FROM SALES_PROD_GRP SPG, ITEM M  WHERE M.ITEM_CODE IN ( SELECT ITEM_CODE FROM SPRS_ITEM WHERE SALES_PERS = '"+sprsCode+"' ) AND M.SALES_PROD_GRP = SPG.SALES_PROD_GRP( + ) AND SPG.SALES_PROD_GRP='"+columnValue+"'";
							sql = "SELECT DISTINCT SPG.SALES_PROD_GRP CODE FROM SALES_PROD_GRP SPG left outer join ITEM M on M.SALES_PROD_GRP = SPG.SALES_PROD_GRP WHERE M.ITEM_CODE IN ( SELECT ITEM_CODE FROM SPRS_ITEM  WHERE SALES_PERS  = '"+sprsCode+"' ) AND SPG.SALES_PROD_GRP='"+columnValue+"'";

							stmt = connectionObject.createStatement();
							rs = stmt.executeQuery(sql);
							if( rs.next() )
							{
								if( itemBuff.length() == 0)
								{
									itemBuff.append("'").append( columnValue ).append("'");
								}
								else
								{
									itemBuff.append(",'").append( columnValue ).append("'");
								}
							}
							//added by rakesh kumar 13/12/12
							if (rs!= null)
							{
								rs.close();
								rs = null;
							}
							if(stmt!=null)
							{
								stmt.close();
								stmt = null;
							}
							//ended by rakesh kumar 13/12/12
							temp.add( columnValue+"-SPG");
						}
					}
					else if ( childNode != null && childNode.getFirstChild() != null &&  childNode.getNodeName().equalsIgnoreCase("item_code"))
					{
						columnValue = childNode.getFirstChild().getNodeValue().trim();
						if( parentNode.getAttributes().getNamedItem("selected").getNodeValue().equalsIgnoreCase(attrValue))
						{
							if( temp.contains(columnValue) )
							{

								continue;
							}
							//commented by prathamesh jangam for joins in db2 on 06/07/17
							//sql = "SELECT M.ITEM_CODE CODE FROM ITEM M, SALES_PROD_GRP SPG WHERE M.ITEM_CODE IN ( SELECT ITEM_CODE FROM SPRS_ITEM WHERE SALES_PERS =  '"+sprsCode+"' ) AND M.SALES_PROD_GRP = SPG.SALES_PROD_GRP( + ) AND M.ITEM_CODE= '"+columnValue+"'";

							sql = "SELECT M.ITEM_CODE CODE FROM ITEM M left outer join SALES_PROD_GRP SPG on M.SALES_PROD_GRP = SPG.SALES_PROD_GRP WHERE M.ITEM_CODE IN ( SELECT ITEM_CODE FROM SPRS_ITEM WHERE SALES_PERS = '"+sprsCode+"' )  AND M.ITEM_CODE='"+columnValue+"'";

							stmt = connectionObject.createStatement();
							rs = stmt.executeQuery(sql);
							if( rs.next() )
							{
								if( itemBuff.length() == 0)
								{
									itemBuff.append("'").append( columnValue ).append("'");
								}
								else
								{
									itemBuff.append(",'").append( columnValue ).append("'");
								}
							}
							//added by rakesh kumar 13/12/12
							if (rs!= null)
							{
								rs.close();
								rs = null;
							}
							if(stmt!=null)
							{
								stmt.close();
								stmt = null;
							}
							//ended by rakesh kumar 13/12/12
							temp.add( columnValue );
						}

					}

				}
			}
			temp.clear();

		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		finally
		{
			try
			{
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}

				if(stmt != null)
				{
					stmt.close();
					stmt = null;
				}
				if (connectionObject != null)
				{
					connectionObject.close();
					connectionObject=null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return itemBuff.toString();
	}

	//to get current dom
	public String getCurrentDom(String objContext, Document dom)
	{
		String returnStr = "";
		Document returnDom = null;
		//changed by Rahul Barve on 10-Apr-2015
		//GenericUtility genericUtility = GenericUtility.getInstance();
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		try
		{
			returnDom = genericUtility.parseString("<Root/>");
			NodeList nodeList =  dom.getElementsByTagName("Detail" + objContext);
			for(int i=0; i< nodeList.getLength(); i++)
			{
				Node currentDom = nodeList.item(i);
				if(currentDom != null)
				{
					Node importedNode = returnDom.importNode( currentDom, true);
					returnDom.getDocumentElement().appendChild(importedNode);
				}
			}

			returnStr = genericUtility.serializeDom(returnDom);
			if(returnStr.indexOf("Detail") != -1)
			{
				returnStr = returnStr.substring(returnStr.indexOf(">") + 1, returnStr.lastIndexOf("</"));
			}
			returnStr = returnStr.indexOf("Detail") != -1 ? returnStr : "";

		}
		catch (Exception e){
			e.printStackTrace();
		}
		return returnStr;
	}

	//Changed By Vidhya on  24/10/09[new method to generate errorString]
	public String generateErrorString(String errorString)
	{
		//Changed By Sumit Sarkar on 12/11/11 [SY1GNOV001] update return xml <Errors> in place of <Error>
		//return ("<Error><error id = \"xxxx\" type=\"X\">" + errorString.substring(errorString.indexOf("<message>") , errorString.indexOf("</description>") + "</description>".length()) + "<redirect>1</redirect></error></Errors>");
		return ("<Errors><error id = \"xxxx\" type=\"X\">" + errorString.substring(errorString.indexOf("<message>") , errorString.indexOf("</description>") + "</description>".length()) + "<redirect>1</redirect></error></Errors>");

	}
	//*****Public Methods ***** End

	//****Private Methods ***** Start
	//to validate holiday for saleperson
	public String valHoliday(String eventdate, String empCode, String userId, ITMDBAccessLocal itmDBAccessLocal, Connection connectionObject,String updateFlag) throws Exception
	{
		String errString = "";
		StrgMeetWizardBean strgMeetWizardBean = new StrgMeetWizardBean();
		eventdate = genericUtility.getValidDateTimeString( eventdate , getApplDateFormat() , getDBDateFormat());
		boolean isHoliday = strgMeetWizardBean.isEmpHoliday(empCode, eventdate, connectionObject);
		if(isHoliday && ! updateFlag.equalsIgnoreCase("E"))
		{
			errString = itmDBAccessLocal.getErrorString("event_date","HOLIDAY",userId);
		}
		return errString;
	}

	/*public String valHoliday(String eventdate, String sprs, String userId, ITMDBAccessLocal itmDBAccessLocal, Connection connectionObject) throws Exception
	{
		//changed by Rahul Barve on 10-Apr-2015
		//GenericUtility genericUtility = GenericUtility.getInstance();
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

		String errString = "";
		String columnValue = "";
		String checkSQL = "";
		String childNodeName = "";

		//Connection connectionObject = null;
		PreparedStatement pstmtPeriod = null;
		ResultSet rsPeriod = null ;

		try
		{
			//ConnDriver connDriver = new ConnDriver();
			//connectionObject = connDriver.getConnectDB( "DriverValidator" );
			//Checking Hodiday
			//eventdate = genericUtility.getValidDateString( eventdate , getApplDateFormat() , "dd-MMM-yyyy");//Shahu - 27/10/12
			eventdate = genericUtility.getValidDateTimeString( eventdate , getApplDateFormat() , getDBDateFormat());//Shahu - 27/10/12
			checkSQL = "SELECT CODE FROM PERIOD WHERE ? BETWEEN FR_DATE AND TO_DATE";
			//System.out.println(" sql [" + checkSQL + "]" );
			pstmtPeriod = connectionObject.prepareStatement(checkSQL);
			//pstmt.setString(1,checkNull(eventdate));//Shahu - 27/10/12
			pstmtPeriod.setTimestamp(1, java.sql.Timestamp.valueOf(eventdate));//Shahu - 27/10/12
			rsPeriod = pstmtPeriod.executeQuery();

			if(rsPeriod.next())
			{
				String code = rsPeriod.getString( "CODE" );
				//changes dobne by prathamesh jangam for db2
				if("ORACLE".equalsIgnoreCase(CommonConstants.DB_NAME))
				{
					checkSQL = "SELECT DDF_GET_EMP_HOLIDAY(?,?,?,?) HOLDATE FROM DUAL ";
				}
				else if("db2".equalsIgnoreCase(CommonConstants.DB_NAME))
				{
					checkSQL = "SELECT FN_GET_EMP_HOLIDAY(CAST(? AS CHAR(10)),CAST(? AS CHAR(6)),CAST(? AS CHAR(6)),CAST(? AS TIMESTAMP)) HOLDATE FROM DUAL ";
				}
				//System.out.println("sql [" + checkSQL + "] ");

				PreparedStatement pstmt = connectionObject.prepareStatement(checkSQL);
				pstmt.setString(1,checkNull(sprs));
				pstmt.setString(2,checkNull(code));
				pstmt.setString(3,checkNull(code));
				//pstmt.setString(4,checkNull(eventdate));//Shahu - 27/10/12
				pstmt.setTimestamp(4, java.sql.Timestamp.valueOf(eventdate));//Shahu - 27/10/12
				ResultSet rs = pstmt.executeQuery();
				if(rs.next())
				{
					String holDate = rs.getString( 1 );
					//System.out.println(" holDate [" + holDate + "] ");
					if ( holDate != null )
					{
						errString = itmDBAccessLocal.getErrorString("event_date","HOLIDAY",userId);
					}
				}
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}

			}
			if (rsPeriod != null)
			{
				rsPeriod.close();
				rsPeriod = null;
			}
			if(pstmtPeriod !=null)
			{
				pstmtPeriod.close();
				pstmtPeriod = null;
			}

		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw e;
		}
		finally
		{
			try
			{
				if (rsPeriod != null)
				{
					rsPeriod.close();
					rsPeriod = null;
				}
				if(pstmtPeriod !=null)
				{
					pstmtPeriod.close();
					pstmtPeriod = null;
				}

				if (connectionObject != null)
				{
					connectionObject.close();
					connectionObject=null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return errString;
	}
	 */
	//to get value of selected attribute
	private String getDomAttrVal( Document dom,String objContext, int rowNo, String attribute )
	{
		Node elementName = null, parentNode = null;
		NodeList elementList = null;
		Element elementAttr = null;
		String attrVal = "";
		elementList = dom.getElementsByTagName("Detail"+objContext);
		elementName = elementList.item(0);
		if ( elementName!=null && ("Detail"+objContext).equalsIgnoreCase( elementName.getNodeName()) )
		{
			NamedNodeMap etlAttributes = elementName.getAttributes();
			if (etlAttributes!=null)
			{
				if (etlAttributes.getNamedItem("domID")!=null && etlAttributes.getNamedItem("domID").getNodeValue().equalsIgnoreCase(Integer.toString(rowNo)))
				{
					attrVal = etlAttributes.getNamedItem( attribute ).getNodeValue();
				}
			}
		}
		return attrVal;
	}

	//Changed By Vidhya on 08/12/09 [WS89NOV642 | made public for work team issue] Start
	//private String getSelectedRowValue(Document dom,String formNo, String colName, int rowNo) throws ITMException
	public String getSelectedRowValue(Document dom,String formNo, String colName, int rowNo) throws ITMException
	{
		NodeList detailList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;
		Element elementAttr = null;
		String childNodeName = "";
		String columnValue = "";
		int	detailListLength = 0;
		int noOfChilds = 0;

		try
		{
			detailList = dom.getElementsByTagName("Detail"+formNo);
			//System.out.println("detailList....."+detailList);
			detailListLength = detailList.getLength();
			parentNode = detailList.item(rowNo);
			//System.out.println("parentNode....."+parentNode);
			elementAttr = (Element)parentNode;
			childList = parentNode.getChildNodes();
			//System.out.println("childList....."+childList);
			noOfChilds = childList.getLength();

			if ( parentNode != null )
			{
				for (int ctr = 0; ctr < noOfChilds; ctr++)
				{
					childNode = childList.item(ctr);
					childNodeName = childNode.getNodeName();
					if(childNodeName.equals(colName) )
					{
						if(childNode.getFirstChild()!=null )
						{
							columnValue = childNode.getFirstChild().getNodeValue();
							break;
						}
					}
				}
			}

			if(columnValue == null)
				columnValue = "";

		}
		catch( Exception exp )
		{
			exp.printStackTrace();
		}

		return columnValue;
	}

	//to get Activity type
	public String getActivityType( String actCode, Connection connectionObject )throws ITMException
	{
		String sql = "";
		String actType = "";
		//Connection connectionObject = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null ;

		//changed by Rahul Barve on 10-Apr-2015
		//GenericUtility genericUtility = GenericUtility.getInstance();
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

		try
		{
			//ConnDriver connDriver = new ConnDriver();
			//connectionObject = connDriver.getConnectDB( "DriverValidator" );

			sql = "SELECT ACTIVITY_TYPE FROM FIELDACTIVITY WHERE ACTIVITY_CODE = ?";
			pstmt = connectionObject.prepareStatement(sql);
			pstmt.setString(1, actCode);
			rs = pstmt.executeQuery();
			if( rs.next() )
			{
				actType = rs.getString("ACTIVITY_TYPE");
				actType = checkNull(actType).toUpperCase();
			}
			//added by mrnunalini sinkar on 11-04-2018(start)
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
			//added by mrnunalini sinkar on 11-04-2018(end)

		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		finally
		{
			try
			{
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				/*
				if (connectionObject != null)
				{
					connectionObject.close();
					connectionObject=null;
				}*/
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}

		return actType;
	}

	//formatted errorstring for Item Detail
	private String getItemErrorString( String errString, String custCode ,String itemDescr, String itemCode, String sprsProdGrp,Connection connectionObject) throws ITMException//Chnaged by sachin satre on 11-nov-16
	{
		String sql = "";
		String custName = "";
		String msgDescr = "";
		//Connection connectionObject = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null ;
		boolean isLocalConn =false;
		try
		{
			if(connectionObject == null )
			{
				/*ConnDriver connDriver = new ConnDriver();
				connectionObject = connDriver.getConnectDB( "DriverValidator" );*/
				connectionObject = getConnection();//chnged by sachin satre on [11-nov-16] to get connection
				isLocalConn =true;
			}
			sql = "SELECT UPPER(FIRST_NAME)||\' \'||UPPER(LAST_NAME) AS SC_NAME FROM STRG_CUSTOMER WHERE SC_CODE = ?";
			pstmt =  connectionObject.prepareStatement( sql );
			pstmt.setString(1, checkNull(custCode));
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				custName = rs.getString("SC_NAME");
			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(itemCode.length() != 0 && !itemCode.equalsIgnoreCase(""))
			{
				itemDescr = "Promo Material for "+ itemDescr;
			}
			else if( sprsProdGrp.length() != 0 && !sprsProdGrp.equalsIgnoreCase(""))
			{
				itemDescr = "Pitch value for " + itemDescr;
			}

			msgDescr = errString.substring(errString.indexOf("<description>")+("<description>").length(),errString.indexOf("</description>"))+
					"" +itemDescr+ " selected for " + custName;

			errString = errString.substring(0, errString.indexOf("<description>")+("<description>").length()) + msgDescr + "" + errString.substring( errString.indexOf("</description>"), errString.length());
		}

		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		finally
		{
			try
			{
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				if (isLocalConn && connectionObject != null)
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}

		return errString;

	}

	//to check if input is a number
	private boolean checkIfNumber(String in)
	{
		try
		{
			//System.out.println("=====>IN VALUE"+in);
			//Integer.parseInt(in);//Commented By Dipak
			Double.parseDouble(in);//Added By Dipak

		} catch (NumberFormatException ex)
		{
			return false;
		}
		return true;
	}
	//****Private Methods ***** End
	//Utility Functions End****************
	public String getSelectedCustomerDetail( Document dom, String reqFormNo,String repformNo, ArrayList temp, String colName) throws ITMException
	{
		//changed by Rahul Barve on 10-Apr-2015
		//GenericUtility genericUtility = GenericUtility.getInstance();
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;
		Element elementAttr = null;
		String childNodeName = "";
		String columnValue = "";
		String returnPrevStr = "";
		Document chgPreDom = null;
		try
		{
			chgPreDom = genericUtility.parseString("<Root/>");
			//System.out.println("currentFormNo ["+reqFormNo+"]");
			parentList = dom.getElementsByTagName("Detail" + reqFormNo);
			int parentNodeListLength = parentList.getLength();
			//System.out.println("parentlistlength["+parentNodeListLength+"]");
			for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
			{
				parentNode = parentList.item(prntCtr);
				childList = parentNode.getChildNodes();
				for (int ctr = 0; ctr < childList.getLength(); ctr++)
				{
					childNode = childList.item(ctr);
					if((childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null))
					{
						columnValue = childNode.getFirstChild().getNodeValue().trim();
						//System.out.println("columnValue["+columnValue+"]");
						//System.out.println("TEMP ARRAY ["+temp.toString()+"]");
						//System.out.println("TEMP ARRAY ["+temp[]+"]");

						if ( childNode.getNodeName().equalsIgnoreCase(colName) && temp.contains("'"+columnValue+"'"))
						{
							//System.out.println("Inside temp Contains Column value["+columnValue+"]");
							elementAttr = (Element)parentNode;
							if ( parentNode.getAttributes().getNamedItem( "domID" ) != null )
							{
								elementAttr.setAttribute( "domID" , Integer.toString(domID) );
								elementAttr.setAttribute( "selected" , "Y" );
								elementAttr.setAttribute( "objContext" , repformNo );
								domID++;
							}
							Node importedNode = chgPreDom.importNode( parentNode, true );
							chgPreDom.getDocumentElement().appendChild( importedNode );
							break;
						}
					}
				}

			}

			returnPrevStr = genericUtility.serializeDom(chgPreDom);
			if(returnPrevStr.indexOf("Detail"+reqFormNo) != -1)
			{
				returnPrevStr = returnPrevStr.substring(returnPrevStr.indexOf(">") + 1, returnPrevStr.lastIndexOf("</"));
			}
			returnPrevStr = returnPrevStr.indexOf("Detail"+reqFormNo) != -1 ? returnPrevStr : "";

			returnPrevStr = returnPrevStr.replace("Detail"+reqFormNo,"Detail"+repformNo);
		}
		catch ( Exception e )
		{
			System.out.println( "Exception :StrgMeetOtcWizardEJB :getSelectedCustomerDetail :==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		return returnPrevStr;

	}
	public String getDocVistDatesInMonth(String strgCode,String sprsCode, String eventDate, Connection conn) throws ITMException
	{
		String visitDates = "";
		String sql="";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		//changed by Rahul Barve on 10-Apr-2015
		//GenericUtility genericUtility = GenericUtility.getInstance();
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		int maxDate = 0;
		StringBuffer sb = new StringBuffer();
		try
		{
			//commented by mrunalini sinkar on 14-july-17 for number of visit changes (start)
			/*String dbDateFormat = genericUtility.getDBDateFormat();

			Calendar cal  = Calendar.getInstance();
			cal.setTime( new Date( java.sql.Timestamp.valueOf( eventDate+" 00:00:00" ).getTime() ) );
			maxDate =	cal.getActualMaximum(Calendar.DAY_OF_MONTH);
			int monInt =	cal.get( Calendar.MONTH );
			int yearInt =	cal.get( Calendar.YEAR );

			String dbName =CommonConstants .DB_NAME;

			//System.out.println("maxDate ["+maxDate+"] monInt ["+monInt+"] yearInt ["+yearInt+"]");
			//System.out.println("DATABASE NAME===>"+dbName);
			//System.out.println("Commented code for visted dates===>");

			if(dbName.equalsIgnoreCase("ORACLE"))
			{

				Commented By Shahu Mali on 29-12-12
			 * sql = "select  to_char(event_date,'dd') as VisitDates from strg_meet "+
				"where strg_code = ? "+
				"and sales_pers = ? "+
				"and event_date >=  '01' || '-' || to_char(to_date(?,?),'MON') || to_char(to_date(?,?),'yy') "+
				"and event_date <  ?";


				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,strgCode);
				pstmt.setString(2,sprsCode);
				pstmt.setString(3,eventDate);
				pstmt.setString(4,dbDateFormat);
				pstmt.setString(5,eventDate);
				pstmt.setString(6,dbDateFormat);
				pstmt.setTimestamp(7,java.sql.Timestamp.valueOf(eventDate +" 00:00:00"));



				//Added By Shahu Mali on 29-12-12
				sql = "select  to_char(event_date,'dd/MON') as VisitDates from strg_meet "+
				"where strg_code = ? "+
				"and sales_pers = ? "+
				"and event_date <  ? order by event_date desc ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,strgCode);
				pstmt.setString(2,sprsCode);
				pstmt.setTimestamp(3,java.sql.Timestamp.valueOf(eventDate +" 00:00:00"));
				//Ended  By Shahu Mali on 29-12-12


			}
			else if(dbName.equalsIgnoreCase("DB2"))
			{


				Added For DB2 BY DIPAK
				sql = "select VARCHAR_FORMAT(event_date,'DD') as VisitDates from strg_meet "+
						"where strg_code = ? "+
						"and sales_pers = ? "+
						"and event_date >=  VARCHAR_FORMAT(?,'YYYY')|| '-' ||VARCHAR_FORMAT(?,'MM')  || '-' ||'01' "+
						"and event_date <  ?";

				Ended For DB2 BY DIPAK

				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,strgCode);
				pstmt.setString(2,sprsCode);
				pstmt.setTimestamp(3,java.sql.Timestamp.valueOf(eventDate +" 00:00:00"));
				pstmt.setTimestamp(4,java.sql.Timestamp.valueOf(eventDate +" 00:00:00"));
				pstmt.setTimestamp(5,java.sql.Timestamp.valueOf(eventDate +" 00:00:00"));

			}
			rs = pstmt.executeQuery();
			int visitDtCnt = 0;
			while (rs.next())
			{
				visitDtCnt++;
				String dates = rs.getString("VisitDates");
				sb.append(dates).append(",");
				if(visitDtCnt == 3)
				{
					break;
				}
			}
			visitDates = sb.toString();
			if(visitDates.length() > 0 && visitDates.lastIndexOf(",") > 0  )
			{
				visitDates = visitDates.substring(0,visitDates.length() - 1);
			}
			System.out.println("visitDates =["+visitDates+"]");

			 */
			//commented by mrunalini sinkar on 14-july-17 for number of visit changes (end)

			//added by mrunalini sinkar for number of visit changes on 14-july-17(start)
			String startDate = eventDate;
			//commented by mrunalini sinkar to remove the hardcode date format changes  on 23-April-2018
			//String sdate = startDate.substring(0,startDate.indexOf("/"));
			//added by mrunalini sinkar for remove the hardcode date format changes  on 23-April-2018 (START)
			String sdate="";
			String applFormat = getApplDateFormat();
			if(applFormat.contains("/"))
			{
				sdate = startDate.substring(0,startDate.indexOf("/"));
			}
			else if(applFormat.contains("-"))
			{
				sdate = startDate.substring(0,startDate.indexOf("-"));
			}
			//added by mrunalini sinkar for remove the hardcode date format changes  on 23-April-2018 (end)
			startDate = startDate.replaceFirst(sdate,"01");

			if(startDate != null  && !"".equals(startDate))
			{
				startDate = genericUtility.getValidDateTimeString( startDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ;
			}
			//SimpleDateFormat dateFormat = new SimpleDateFormat("dd/mm/yy"); //commented by mrunalini sinkar to remove the hardcode dateformat
			SimpleDateFormat dateFormat = new SimpleDateFormat(applFormat);
			Date prvDate = dateFormat.parse(eventDate);
			Calendar calendar = Calendar.getInstance();
			calendar.setTime(prvDate);
			calendar.add(Calendar.DAY_OF_YEAR, -1);
			Date previousDate = calendar.getTime();
			String prevDate = dateFormat.format(previousDate);
			if(prevDate != null  && !"".equals(prevDate))
			{
				prevDate = genericUtility.getValidDateTimeString( prevDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ;
			}
			sql = "SELECT  STRG_CODE, EVENT_DATE AS VISITDATES  FROM STRG_MEET WHERE SALES_PERS = ? " +
					"  AND STRG_CODE = ? AND EVENT_DATE BETWEEN ? AND ?";

			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,sprsCode);
			pstmt.setString(2,strgCode);
			pstmt.setTimestamp(3,java.sql.Timestamp.valueOf(startDate) );
			pstmt.setTimestamp(4,java.sql.Timestamp.valueOf(prevDate) );

			rs = pstmt.executeQuery();

			while (rs.next())
			{
				String dates = rs.getString("VISITDATES");
				dates =  genericUtility.getValidDateString( dates, genericUtility.getDBDateFormat(), genericUtility.getApplDateFormat() );
				sb.append(dates).append(",");
			}
			visitDates = sb.toString();
			if(visitDates.length() > 0 && visitDates.lastIndexOf(",") > 0  )
			{
				visitDates = visitDates.substring(0,visitDates.length() - 1);
			}
			//added by mrunalini sinkar for number of visit changes on 14-july-17(end)


		}

		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{

			}
		}
		//System.out.println("visitDates ::::::=["+visitDates+"]");
		return visitDates;
	}
	//Overloaded method is added by Gulzar [eventDate] on 18/06/12
	//Added By Gaurav Singh on 02-JUN-2015 [ Start ]

	public String getSalesPersItemList( String sprsCode, String strgCode, String selectedItem, String eventDate ) throws ITMException
	{
		//Form 4 defaultData()
		String sql = "";
		String sql1 = "";
		StringBuffer valueXmlString = new StringBuffer();
		Connection connectionObject = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		boolean isMasterPitchFound = false;
		try
		{
			DARCommonBean darCommonBean= new DARCommonBean();

			valueXmlString.append( "<Root>\r\n" );
			/*ConnDriver connDriver = new ConnDriver();
			connectionObject = connDriver.getConnectDB( "DriverValidator" );*/
			connectionObject = getConnection();//chnged by sachin satre on [11-nov-16] to get connection

			/*sql1 = "SELECT M.ITEM_CODE ITEM, M.DESCR DESCR "+
					"FROM ITEM M LEFT OUTER JOIN SALES_PROD_GRP SPG ON M.SALES_PROD_GRP = SPG.SALES_PROD_GRP "+
					"WHERE M.ITEM_CODE IN ( SELECT ITEM_CODE FROM SPRS_ITEM WHERE SALES_PERS = ? AND STATUS='Y' ) ";*/



			sql1 =" SELECT ITEM.ITEM_CODE AS ITEM_CODE ,ITEM.DESCR AS DESCR, ITEM.SH_DESCR AS SH_DESCR, S.PRICE_LIST FROM  ITEM ITEM, STRG_CUSTOMER SC ," +
					"PRICELIST  PM, STATE S  "+
					"WHERE ITEM.ITEM_CODE = PM.ITEM_CODE AND SC.STATE_CODE = S.STATE_CODE AND S.PRICE_LIST = PM.PRICE_LIST "+
					"AND SC.SC_CODE= ? "+
					"ORDER BY ITEM.SH_DESCR ";


			//System.out.println(" selectedItem string vala parameter["+selectedItem+"]");
			HashMap itemMap = new HashMap();

			String dcrID = getDCRId(connectionObject,sprsCode, eventDate);

			if ( selectedItem != null && selectedItem.trim().length() > 0 )
			{
				NodeList itemNodeList = ( genericUtility.parseString( selectedItem ) ).getElementsByTagName("Detail5");
				int nodeListLen = itemNodeList.getLength();
				for ( int i=0; i < nodeListLen ; i++ )
				{
					NodeList innerNodeList = itemNodeList.item( i ).getChildNodes();
					int innerNodeListLen = innerNodeList.getLength();
					String itemCode = "";
					String pitch = "";
					String qty = "";
					String columnValue = "";
					String itemDescr = "";
					for ( int j = 0; j < innerNodeListLen; j++ )
					{
						Node currNode = innerNodeList.item( j );
						//System.out.println("COLUMNAME ["+ currNode.getNodeName()+"] COLUMKN VALUE["+currNode.getFirstChild()+"] ");
						if ( "item_code".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild() != null)
							{
								itemCode = currNode.getFirstChild().getNodeValue().trim() ;
							}
						}
						else if ( "quantity".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild().getNodeValue() != null )
							{
								qty = currNode.getFirstChild().getNodeValue().trim();
							}
						}
						else if("scheme_code".equals( currNode.getNodeName() ))
						{
							if(currNode.getFirstChild() != null)
							{
								itemCode = checkNull(currNode.getFirstChild().getNodeValue());
								itemCode = itemCode.trim();
							}
						}
						else if ( "item_descr".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild() != null)
							{
								itemDescr = checkNull(currNode.getFirstChild().getNodeValue());
							}
						}
					}
					//System.out.println("itemCode["+itemCode+"] pitch["+pitch+"] qty["+qty+"]" );
					itemMap.put( itemCode, pitch+"~"+qty);

					//System.out.println(" itemMap ["+itemMap+"]");
				}
			}

			String qty = "";
			String pitch = "";
			int num = 1;
			int lineNo=1;

			double value = 0d;
			double rate = 0d;


			pstmt =  connectionObject.prepareStatement( sql1 );
			pstmt.setString(1, strgCode);//changed by poonam
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				String itemCode = rs.getString("ITEM_CODE");
				//System.out.println("itemCode["+itemCode+"]");
				String itemDescr = checkNull(rs.getString("DESCR"));
				String itemShDescr = checkNull(rs.getString("SH_DESCR"));
				String priceList = checkNull(rs.getString("PRICE_LIST"));
				//	String domQty = getSelectedRowValue(dom, 5, colName, rowNo)
				rate = darCommonBean.getLandingRate( strgCode, itemCode, eventDate, sprsCode, priceList, connectionObject);

				//	System.out.println("RATE:::==["+rate+"]");
				if ( itemMap.get( itemCode.trim() ) != null )
				{
					String data = ( String ) itemMap.get( itemCode.trim() );
					qty = data.substring( data.indexOf("~") + 1 );
					//System.out.println("itemCode inside if["+itemCode+"]");
					valueXmlString.append("<Detail5 domID='"+num+"' selected = 'Y'>\r\n" );
					valueXmlString.append( "<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\"/>\r\n");//Gaurav Singh on 03-06-15
					valueXmlString.append("<selectbox><![CDATA[").append( "true" ).append("]]></selectbox>\n");
				}
				else
				{
					valueXmlString.append("<Detail5 domID='"+num+"' selected = 'N'>\r\n" );
					valueXmlString.append( "<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");//Gaurav Singh on 03-06-15
				}

				valueXmlString.append("<strg_code><![CDATA[").append( strgCode ).append("]]></strg_code>\r\n");
				valueXmlString.append("<item_descr><![CDATA[").append(rs.getString("DESCR")).append("]]></item_descr>\r\n");
				valueXmlString.append( "<quantity><![CDATA[" ).append( qty ).append( "]]></quantity>\r\n" );
				valueXmlString.append("<landing_rate><![CDATA[" ).append( rate ).append( "]]></landing_rate>\r\n" );
				//System.out.println("qty::::==["+qty+"]");
				//System.out.println("value::::==["+value+"]");
				valueXmlString.append("<value><![CDATA[" ).append(value).append( "]]></value>\r\n" );
				valueXmlString.append("<item_code><![CDATA[").append( rs.getString("ITEM_CODE") ).append("]]></item_code>\r\n");
				valueXmlString.append("<tooltip_descr><![CDATA[").append(itemDescr).append("]]></tooltip_descr>\r\n");
				valueXmlString.append("<line_no><![CDATA["+lineNo+"]]></line_no>\r\n");
				valueXmlString.append( "<dcr_id><![CDATA["+dcrID+"]]></dcr_id>\r\n" );
				valueXmlString.append("<sales_pers><![CDATA[").append(sprsCode).append("]]></sales_pers>\r\n");
				valueXmlString.append( "</Detail5>\r\n" );

				qty = "";
				num++;
				lineNo++;
			}//end of while
			if(rs != null)
			{
				rs.close(); rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close(); pstmt = null;
			}
			num = 1;
		}
		catch (Exception e)
		{
			e.printStackTrace();
			System.out.println( "Exception :ITMWizardStatefulEJB :getSalesPersItemList(String):" + e.getMessage() + ":" );
			//valueXmlString = valueXmlString.append( genericUtility.createErrorString( e ) );
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018
		}
		finally
		{
			try
			{
				if( connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :ITMWizardStatefulEJB :getSalesPersItemList(String) :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		valueXmlString.append( "</Root>\r\n" );
		System.out.println( "\n****ValueXmlString :" + valueXmlString.toString() + ":********" );
		return valueXmlString.toString();
	}
	//Method to get order Item details
	//public String getSalesPersItemList(Document dom, String sprsCode, String strgCode, String selectedItem, String eventDate,String formNo, String formName,Document dom2 ) throws ITMException
	public String getSalesPersItemList(Document dom, String sprsCode, String strgCode, String selectedItem, String eventDate,String formNo, String formName,Document dom2,String prcListTemp ) throws ITMException
	{
		String sql = "";
		String sql1 = "";
		StringBuffer valueXmlString = new StringBuffer();
		Connection connectionObject = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		PreparedStatement pstmt1 = null;
		ResultSet rs1 = null;
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		boolean isMasterPitchFound = false;

		int strgCustCnt = 0;
		HashMap tranIDMap = new HashMap();

		//String bindValue = "";
		String bindValue = sprsCode;

		try
		{
			DARCommonBean darCommonBean= new DARCommonBean();

			valueXmlString.append( "<Root>\r\n" );
			connectionObject = getConnection();
			String itemSer = getProdItmSer(sprsCode, connectionObject);
			System.out.println("ITEMSER is"+itemSer);
			String paramValue="";
			String custCode="";
			String codeSql="SELECT COUNT(*) AS COUNT FROM STRG_CUSTOMER WHERE SC_CODE= ?";
			pstmt=connectionObject.prepareStatement(codeSql);
			pstmt.setString(1, strgCode);
			rs  = pstmt.executeQuery();
			if(rs.next())
			{
				strgCustCnt = rs.getInt("COUNT");

			}
			if(rs!=null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
			//System.out.println("strgCustCnt =["+strgCustCnt+"]");
			String orderParam = checkNull(getSfaParmValue(sprsCode, "ORDER_QTY", connectionObject));
			String mrpPriceList = checkNull(getSfaParmValue(sprsCode, "MRP_PRICELIST", connectionObject)); //Added By Haseeb Khan on [18-10-2021]
			
			System.out.println("SFA ======> "+mrpPriceList);

			String isStockInfo = getSfaParmValue(sprsCode,"IS_STOCK_INFO",connectionObject); // added by mrunalini sinkar on 10-august-2018(start)
			//System.out.println("isStockInfo =["+isStockInfo+"]");

			// commentted and added by rupali on 01/02/19 for getting only active items [start]
			/*if(strgCustCnt  > 0)
			{
				bindValue = strgCode;
				//added join with item_lot_info in sql by rupali on 30/10/17 for getting exp_date of item
				//Commented and changed by Gulzar on 07/12/17 : START

				sql = " SELECT ITEM.ITEM_CODE AS ITEM_CODE ,ITEM.DESCR AS DESCR, ITEM.SH_DESCR AS SH_DESCR, ITEM.UNIT AS ITEM_UNIT,S.PRICE_LIST AS PRICE_LIST " +
						" FROM  STRG_CUSTOMER SC, STATE S ,ITEM ITEM LEFT OUTER JOIN PRICELIST  PM ON ITEM.ITEM_CODE = PM.ITEM_CODE "+
						" WHERE SC.STATE_CODE = S.STATE_CODE AND S.PRICE_LIST = PM.PRICE_LIST "+
						"AND SC.SC_CODE= ? "+
						"AND ITEM.ITEM_USAGE NOT IN('S','G') "+
						"ORDER BY ITEM.SH_DESCR ";

				// added by rupali on 16/01/17 for applying distinct condition for fetching proper data in order form
				sql = " SELECT DISTINCT ITEM.ITEM_CODE AS ITEM_CODE ,ITEM.DESCR AS DESCR, ITEM.SH_DESCR AS SH_DESCR, ITEM.UNIT AS ITEM_UNIT,S.PRICE_LIST AS PRICE_LIST " +
						" ,P.PRODUCT_CODE AS PRODUCT_CODE, P.DESCR AS PRODUCT_DESCR, P.PRODUCT_TYPE, V.SORT_ORDER  "+
						" FROM  STRG_CUSTOMER SC, STATE S ,ITEM ITEM LEFT OUTER JOIN PRICELIST  PM ON ITEM.ITEM_CODE = PM.ITEM_CODE "+
						" LEFT OUTER JOIN PRODUCT P ON ITEM.PRODUCT_CODE = P.PRODUCT_CODE "+
						" LEFT OUTER JOIN ITM_ATTRIB_VAL V ON ITEM.PHY_ATTRIB_1=V.ATTRIB_ID " +
						" WHERE SC.STATE_CODE = S.STATE_CODE AND S.PRICE_LIST = PM.PRICE_LIST "+
						" AND SC.SC_CODE= ? "+
						" AND RTRIM((CASE WHEN ITEM.ITEM_USAGE IS NULL THEN 'O' ELSE ITEM.ITEM_USAGE END )) NOT IN('S','G') "+
						//" ORDER BY ITEM.SH_DESCR ";
						" ORDER BY V.SORT_ORDER ";
				//Commented and changed by Gulzar on 07/12/17 : END

			}
			else
			{

				//String Paramsql = "SELECT PARM_VALUE FROM SFAPARM WHERE PARM_NAME='WSFA_UNLISTCUST_PRICELIST'";
				String Paramsql = "SELECT PARM_VALUE FROM SFAPARM WHERE PARM_NAME='SFA_UNLISTCUST_PLIST'";
				pstmt = connectionObject.prepareStatement(Paramsql);
				rs  = pstmt.executeQuery();
				if(rs.next())
				{
					paramValue = checkNull(rs.getString("PARM_VALUE"));
					System.out.println("param value is :"+paramValue);

				}
				if(rs!=null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				// commented and added by rupali on 30/10/17 for getting exp_date of item [strat]
				//Commented and changed by Gulzar on 07/12/17 : START

				sql = " SELECT ITEM.ITEM_CODE AS ITEM_CODE ,ITEM.DESCR AS DESCR, ITEM.SH_DESCR AS SH_DESCR, ITEM.UNIT AS ITEM_UNIT, PM.PRICE_LIST AS PRICE_LIST FROM  ITEM ITEM, PRICELIST  PM "+
						" WHERE ITEM.ITEM_CODE = PM.ITEM_CODE AND  PM.PRICE_LIST= ? AND ITEM.ITEM_USAGE NOT IN('S','G')"+
						" ORDER BY ITEM.SH_DESCR";

				// added by rupali on 16/01/17 for applying distinct condition for fetching proper data in order form
				sql = " SELECT DISTINCT ITEM.ITEM_CODE AS ITEM_CODE ,ITEM.DESCR AS DESCR, ITEM.SH_DESCR AS SH_DESCR, ITEM.UNIT AS ITEM_UNIT, PM.PRICE_LIST AS PRICE_LIST "+
						" ,P.PRODUCT_CODE AS PRODUCT_CODE, P.DESCR AS PRODUCT_DESCR, P.PRODUCT_TYPE, V.SORT_ORDER  "+
						" FROM ITEM ITEM LEFT OUTER JOIN PRICELIST  PM ON ITEM.ITEM_CODE = PM.ITEM_CODE "+
						" LEFT OUTER JOIN PRODUCT P ON ITEM.PRODUCT_CODE = P.PRODUCT_CODE "+
						" LEFT OUTER JOIN ITM_ATTRIB_VAL V ON ITEM.PHY_ATTRIB_1=V.ATTRIB_ID " +
						" WHERE PM.PRICE_LIST= ? AND RTRIM((CASE WHEN ITEM.ITEM_USAGE IS NULL THEN 'O' ELSE ITEM.ITEM_USAGE END )) NOT IN('S','G') "+
						//" ORDER BY ITEM.SH_DESCR";
						" ORDER BY V.SORT_ORDER ";
				//Commented and changed by Gulzar on 07/12/17 : END
				sql = " SELECT ITEM.ITEM_CODE AS ITEM_CODE ,ITEM.DESCR AS DESCR, ITEM.SH_DESCR AS SH_DESCR, ITEM.UNIT AS ITEM_UNIT, PM.PRICE_LIST AS PRICE_LIST, INF.EXP_DATE AS EXP_DATE FROM PRICELIST PM, ITEM ITEM "+
						" LEFT OUTER JOIN ITEM_LOT_INFO INF ON INF.ITEM_CODE = ITEM.ITEM_CODE WHERE ITEM.ITEM_CODE = PM.ITEM_CODE AND  PM.PRICE_LIST= ? AND ITEM.ITEM_USAGE NOT IN('S','G')"+
						" ORDER BY ITEM.SH_DESCR";
				// commented and added by rupali on 30/10/17 for getting exp_date of item [strat]
				bindValue = paramValue;
			}*/
			// changes made by rupali on 03/05/19 for mapping og physical attribute [start]
			String itemSizeCol = getSfaParmValue(sprsCode,"ITEM_ATTRIB_SIZE",connectionObject);
			if(itemSizeCol.trim().length() == 0)
			{
				itemSizeCol = "PHY_ATTRIB_1";
			}
			// changes made by rupali on 03/05/19 for mapping og physical attribute [end]
			// added by mrunalini sinkar for adding sprs_item condition to geeting item on  25-April-2019(start)
			String itemUSage="";
			String parmItemUsage = getSfaParmValue(sprsCode,"SAMPLE_ITEM_USAGE",connectionObject);
			if(parmItemUsage!=null && parmItemUsage.trim().length()>0)
			{
				itemUSage=checkNull(getFormattedStringBuff( parmItemUsage ));
			}
			else
			{
				itemUSage="'G','S'";
			}

			int sprsCnt=0;
			/*String sprsCntSql="SELECT COUNT(*) AS COUNT " +
					" FROM SALES_PERS SP, STATE S ,ITEM ITEM LEFT OUTER JOIN PRICELIST  PM ON ITEM.ITEM_CODE = PM.ITEM_CODE " +
					" LEFT OUTER JOIN PRODUCT P ON ITEM.PRODUCT_CODE = P.PRODUCT_CODE " +
					//" LEFT OUTER JOIN ITM_ATTRIB_VAL V ON ITEM.PHY_ATTRIB_1=V.ATTRIB_ID,SPRS_ITEM SI " + // changes made by rupali on 03/05/19 for mapping og physical attribute
					" LEFT OUTER JOIN ITM_ATTRIB_VAL V ON ITEM."+itemSizeCol+"=V.ATTRIB_ID,SPRS_ITEM SI " +
					" WHERE SP.STATE_CODE = S.STATE_CODE AND S.PRICE_LIST = PM.PRICE_LIST AND SI.ITEM_CODE= ITEM.ITEM_CODE AND SP.SALES_PERS=SI.SALES_PERS " +
					" AND SP.SALES_PERS = ? AND ITEM.ACTIVE = 'Y'  AND SI.STATUS='Y' " +
					" AND RTRIM((CASE WHEN ITEM.ITEM_USAGE IS NULL THEN 'O' ELSE ITEM.ITEM_USAGE END )) NOT IN("+itemUSage+") " +
					" ORDER BY P.SORT_ORDER,V.SORT_ORDER";*/
			String sprsCntSql="SELECT COUNT(*) AS COUNT " +
					" FROM SALES_PERS SP, STATE S ,ITEM ITEM LEFT OUTER JOIN PRICELIST  PM ON ITEM.ITEM_CODE = PM.ITEM_CODE " +
					" LEFT OUTER JOIN PRODUCT P ON ITEM.PRODUCT_CODE = P.PRODUCT_CODE " +
					//" LEFT OUTER JOIN ITM_ATTRIB_VAL V ON ITEM.PHY_ATTRIB_1=V.ATTRIB_ID,SPRS_ITEM SI " + // changes made by rupali on 03/05/19 for mapping og physical attribute
					" LEFT OUTER JOIN ITM_ATTRIB_VAL V ON ITEM."+itemSizeCol+"=V.ATTRIB_ID,SPRS_ITEM SI " +
					" WHERE PM.PRICE_LIST= ? AND SI.ITEM_CODE= ITEM.ITEM_CODE AND SP.SALES_PERS=SI.SALES_PERS " +
					" AND SP.SALES_PERS = ? AND ITEM.ACTIVE = 'Y'  AND SI.STATUS='Y' " +
					" AND RTRIM((CASE WHEN ITEM.ITEM_USAGE IS NULL THEN 'O' ELSE ITEM.ITEM_USAGE END )) NOT IN("+itemUSage+") " +
					" ORDER BY P.SORT_ORDER,V.SORT_ORDER";
			PreparedStatement pstmtCnt = connectionObject.prepareStatement(sprsCntSql);
			pstmtCnt.setString(1, prcListTemp);
			if(bindValue != null && bindValue.trim().length() > 0)
			{
				pstmtCnt.setString(2, bindValue);
			}
			rs = pstmtCnt.executeQuery();
			if(rs.next())
			{
				sprsCnt = rs.getInt("COUNT");
			}
			if(rs != null)
			{
				rs.close(); rs = null;
			}
			if(pstmtCnt != null)
			{
				pstmtCnt.close(); pstmtCnt = null;
			}
			if(sprsCnt > 0)
			{

				/*sql = " SELECT DISTINCT ITEM.ITEM_CODE AS ITEM_CODE ,ITEM.DESCR AS DESCR, ITEM.SH_DESCR AS SH_DESCR, ITEM.UNIT AS ITEM_UNIT,S.PRICE_LIST AS PRICE_LIST " +
						" ,P.PRODUCT_CODE AS PRODUCT_CODE, P.DESCR AS PRODUCT_DESCR, P.PRODUCT_TYPE, P.SORT_ORDER, V.SORT_ORDER  "+
						" FROM SALES_PERS SP, STATE S ,ITEM ITEM LEFT OUTER JOIN PRICELIST  PM ON ITEM.ITEM_CODE = PM.ITEM_CODE "+
						" LEFT OUTER JOIN PRODUCT P ON ITEM.PRODUCT_CODE = P.PRODUCT_CODE "+
						//" LEFT OUTER JOIN ITM_ATTRIB_VAL V ON ITEM.PHY_ATTRIB_1=V.ATTRIB_ID,SPRS_ITEM SI " + // changes made by rupali on 03/05/19 for mapping og physical attribute
						" LEFT OUTER JOIN ITM_ATTRIB_VAL V ON ITEM."+itemSizeCol+"=V.ATTRIB_ID,SPRS_ITEM SI " +
						" WHERE SP.STATE_CODE = S.STATE_CODE AND S.PRICE_LIST = PM.PRICE_LIST AND SI.ITEM_CODE= ITEM.ITEM_CODE AND SP.SALES_PERS=SI.SALES_PERS "+
						" AND SP.SALES_PERS = ?  AND ITEM.ACTIVE = 'Y' AND SI.STATUS='Y' "+
						" AND RTRIM((CASE WHEN ITEM.ITEM_USAGE IS NULL THEN 'O' ELSE ITEM.ITEM_USAGE END )) NOT IN("+itemUSage+") "+
						" ORDER BY P.SORT_ORDER,V.SORT_ORDER ";*/
				sql = " SELECT DISTINCT ITEM.ITEM_CODE AS ITEM_CODE ,ITEM.DESCR AS DESCR, ITEM.SH_DESCR AS SH_DESCR, ITEM.UNIT AS ITEM_UNIT,PM.PRICE_LIST AS PRICE_LIST " +
						" ,P.PRODUCT_CODE AS PRODUCT_CODE, P.DESCR AS PRODUCT_DESCR, P.PRODUCT_TYPE, P.SORT_ORDER, V.SORT_ORDER  "+
						" FROM SALES_PERS SP, STATE S ,ITEM ITEM LEFT OUTER JOIN PRICELIST  PM ON ITEM.ITEM_CODE = PM.ITEM_CODE "+
						" LEFT OUTER JOIN PRODUCT P ON ITEM.PRODUCT_CODE = P.PRODUCT_CODE "+
						//" LEFT OUTER JOIN ITM_ATTRIB_VAL V ON ITEM.PHY_ATTRIB_1=V.ATTRIB_ID,SPRS_ITEM SI " + // changes made by rupali on 03/05/19 for mapping og physical attribute
						" LEFT OUTER JOIN ITM_ATTRIB_VAL V ON ITEM."+itemSizeCol+"=V.ATTRIB_ID,SPRS_ITEM SI " +
						" WHERE PM.PRICE_LIST= ? AND SI.ITEM_CODE= ITEM.ITEM_CODE AND SP.SALES_PERS=SI.SALES_PERS "+
						" AND SP.SALES_PERS = ?  AND ITEM.ACTIVE = 'Y' AND SI.STATUS='Y' "+
						" AND RTRIM((CASE WHEN ITEM.ITEM_USAGE IS NULL THEN 'O' ELSE ITEM.ITEM_USAGE END )) NOT IN("+itemUSage+") "+
						" ORDER BY P.SORT_ORDER,V.SORT_ORDER ";

			}
			// added by mrunalini sinkar for adding sprs_item condition to geeting item on  25-April-2019(end)
			else
			{
				/*sql = " SELECT DISTINCT ITEM.ITEM_CODE AS ITEM_CODE ,ITEM.DESCR AS DESCR, ITEM.SH_DESCR AS SH_DESCR, ITEM.UNIT AS ITEM_UNIT,S.PRICE_LIST AS PRICE_LIST " +
						" ,P.PRODUCT_CODE AS PRODUCT_CODE, P.DESCR AS PRODUCT_DESCR, P.PRODUCT_TYPE, P.SORT_ORDER, V.SORT_ORDER  "+
						" FROM SALES_PERS SP, STATE S ,ITEM ITEM LEFT OUTER JOIN PRICELIST  PM ON ITEM.ITEM_CODE = PM.ITEM_CODE "+
						" LEFT OUTER JOIN PRODUCT P ON ITEM.PRODUCT_CODE = P.PRODUCT_CODE "+
						//" LEFT OUTER JOIN ITM_ATTRIB_VAL V ON ITEM.PHY_ATTRIB_1=V.ATTRIB_ID " + // changes made by rupali on 03/05/19 for mapping og physical attribute
						" LEFT OUTER JOIN ITM_ATTRIB_VAL V ON ITEM."+itemSizeCol+"=V.ATTRIB_ID " +
						" WHERE SP.STATE_CODE = S.STATE_CODE AND S.PRICE_LIST = PM.PRICE_LIST "+
						" AND SP.SALES_PERS = ? AND SP.ITEM_SER = ITEM.ITEM_SER AND ITEM.ACTIVE = 'Y' "+
						" AND RTRIM((CASE WHEN ITEM.ITEM_USAGE IS NULL THEN 'O' ELSE ITEM.ITEM_USAGE END )) NOT IN("+itemUSage+") "+
						" ORDER BY P.SORT_ORDER,V.SORT_ORDER ";*/
				/*sql = " SELECT DISTINCT ITEM.ITEM_CODE AS ITEM_CODE ,ITEM.DESCR AS DESCR, ITEM.SH_DESCR AS SH_DESCR, ITEM.UNIT AS ITEM_UNIT,PM.PRICE_LIST AS PRICE_LIST " +
						" ,P.PRODUCT_CODE AS PRODUCT_CODE, P.DESCR AS PRODUCT_DESCR, P.PRODUCT_TYPE, P.SORT_ORDER, V.SORT_ORDER  "+
						" FROM SALES_PERS SP, STATE S ,ITEM ITEM LEFT OUTER JOIN PRICELIST  PM ON ITEM.ITEM_CODE = PM.ITEM_CODE "+
						" LEFT OUTER JOIN PRODUCT P ON ITEM.PRODUCT_CODE = P.PRODUCT_CODE "+
						//" LEFT OUTER JOIN ITM_ATTRIB_VAL V ON ITEM.PHY_ATTRIB_1=V.ATTRIB_ID " + // changes made by rupali on 03/05/19 for mapping og physical attribute
						" LEFT OUTER JOIN ITM_ATTRIB_VAL V ON ITEM."+itemSizeCol+"=V.ATTRIB_ID " +
						" WHERE PM.PRICE_LIST= ? "+
						" AND SP.SALES_PERS = ? AND SP.ITEM_SER = ITEM.ITEM_SER AND ITEM.ACTIVE = 'Y' "+
						" AND RTRIM((CASE WHEN ITEM.ITEM_USAGE IS NULL THEN 'O' ELSE ITEM.ITEM_USAGE END )) NOT IN("+itemUSage+") "+
						" ORDER BY P.SORT_ORDER,V.SORT_ORDER ";*/
				sql = " SELECT DISTINCT ITEM.ITEM_CODE AS ITEM_CODE ,ITEM.DESCR AS DESCR, ITEM.SH_DESCR AS SH_DESCR, ITEM.UNIT AS ITEM_UNIT,PM.PRICE_LIST AS PRICE_LIST " +
						" ,P.PRODUCT_CODE AS PRODUCT_CODE, P.DESCR AS PRODUCT_DESCR, P.PRODUCT_TYPE, P.SORT_ORDER, V.SORT_ORDER  "+
						" FROM STATE S ,ITEM ITEM LEFT OUTER JOIN PRICELIST  PM ON ITEM.ITEM_CODE = PM.ITEM_CODE "+
						" LEFT OUTER JOIN PRODUCT P ON ITEM.PRODUCT_CODE = P.PRODUCT_CODE "+
						//" LEFT OUTER JOIN ITM_ATTRIB_VAL V ON ITEM.PHY_ATTRIB_1=V.ATTRIB_ID " + // changes made by rupali on 03/05/19 for mapping og physical attribute
						" LEFT OUTER JOIN ITM_ATTRIB_VAL V ON ITEM."+itemSizeCol+"=V.ATTRIB_ID " +
						" WHERE PM.PRICE_LIST= ? "+
						" AND ITEM.ITEM_SER IN("+itemSer+") AND ITEM.ACTIVE = 'Y' "+
						" AND RTRIM((CASE WHEN ITEM.ITEM_USAGE IS NULL THEN 'O' ELSE ITEM.ITEM_USAGE END )) NOT IN("+itemUSage+") "+
						" ORDER BY P.SORT_ORDER,V.SORT_ORDER ";
			}


			// commentted and added by rupali on 01/02/19 for getting only active items [start]
			String sqlStr = "";
			/*
			//Gulzar on 08/12/17
			if(strgCustCnt  > 0)
			{
				sqlStr = " SELECT DISTINCT P.PRODUCT_CODE AS PRODUCT_CODE, P.PRODUCT_TYPE AS PRODUCT_TYPE " +
						" FROM  STRG_CUSTOMER SC, STATE S ,ITEM ITEM LEFT OUTER JOIN PRICELIST  PM ON ITEM.ITEM_CODE = PM.ITEM_CODE "+
						" LEFT OUTER JOIN PRODUCT P ON ITEM.PRODUCT_CODE = P.PRODUCT_CODE "+
						" WHERE SC.STATE_CODE = S.STATE_CODE AND S.PRICE_LIST = PM.PRICE_LIST "+
						" AND SC.SC_CODE= ? "+
						" AND (CASE WHEN ITEM.ITEM_USAGE IS NULL THEN 'O' ELSE ITEM.ITEM_USAGE END ) NOT IN('S','G') "+
						" ORDER BY ITEM.SH_DESCR ";
				bindValue = strgCode;
			}
			else
			{
				sqlStr = " SELECT DISTINCT P.PRODUCT_CODE AS PRODUCT_CODE, P.PRODUCT_TYPE AS PRODUCT_TYPE " +
						" ,P.PRODUCT_CODE AS PRODUCT_CODE, P.DESCR AS PRODUCT_DESCR, P.PRODUCT_TYPE "+
						" FROM ITEM ITEM LEFT OUTER JOIN PRICELIST  PM ON ITEM.ITEM_CODE = PM.ITEM_CODE "+
						" LEFT OUTER JOIN PRODUCT P ON ITEM.PRODUCT_CODE = P.PRODUCT_CODE "+
						" WHERE PM.PRICE_LIST= ? AND (CASE WHEN ITEM.ITEM_USAGE IS NULL THEN 'O' ELSE ITEM.ITEM_USAGE END )NOT IN('S','G') "+
						" ORDER BY ITEM.SH_DESCR";
				bindValue = paramValue;
			}
			 */
			//HashMap itemAttribMap = darCommonBean.getItemAttributeDetails(connectionObject, sql, bindValue, strgCustCnt, "'"+strgCode+"'", paramValue, sprsCnt);
			HashMap itemAttribMap = darCommonBean.getItemAttributeDetails(connectionObject, sql, bindValue, strgCustCnt, "'"+strgCode+"'", prcListTemp, sprsCnt);
			//System.out.println(" itemAttribMap["+itemAttribMap+"]");
			//System.out.println(" selectedItem in dom parametr["+selectedItem+"]");
			HashMap itemMap = new HashMap();
			HashMap rateMap = new HashMap(); //added by rupali on 07/09/17 for rate and discount of order form
			HashMap stockMap = new HashMap(); //added by rupali on 30/10/17 for lot_no and stock_qty of order form [start]
			HashMap stockInfoMap = new HashMap(); //added by rupali on 22/12/17 for getting data of stock_info field in edit mode
			HashMap promoCodeMap = new HashMap(); //added by rupali on 11/12/18 for getting data of promo_code field in edit mode
			HashMap promoPercMap = new HashMap(); // added by mrunalini sinkar for promo_perc on 10/04/2019
			HashMap remarkDescrMap = new HashMap(); 
			HashMap remarkMap = new HashMap(); 
			HashMap focusDeviReasMap = new HashMap(); 

			String dcrID = getDCRId(connectionObject,sprsCode, eventDate);
			//System.out.println("Value of dcr id is123:- -"+dcrID);
			if ( selectedItem != null && selectedItem.trim().length() > 0 )
			{
				NodeList itemNodeList = ( genericUtility.parseString( selectedItem ) ).getElementsByTagName("Detail"+formNo+"");
				int nodeListLen = itemNodeList.getLength();
				for ( int i=0; i < nodeListLen ; i++ )
				{
					NodeList innerNodeList = itemNodeList.item( i ).getChildNodes();
					int innerNodeListLen = innerNodeList.getLength();
					String itemCode = "";
					String pitch = "";
					String qty = "";
					String val = "";
					String columnValue = "";
					String itemDescr = "";
					String tranID = "";
					//added by rupali on 07/09/17 for rate and discount of order form [start]
					String discount = "";
					String chgRate = "";
					//added by rupali on 07/09/17 for rate and discount of order form [end]
					//added by rupali on 30/10/17 for lot_no and stock_qty of order form [start]
					String lotNo = "";
					String stockQty = "";
					//added by rupali on 30/10/17 for lot_no and stock_qty of order form [end]
					String stockInfo = ""; //added by rupali on 22/12/17 for getting data of stock_info field in edit mode
					String promoCode = ""; //added by rupali on 22/12/17 for getting data of promo_code field in edit mode
					String promoPerc="";// added by mrunalini sinkar on 10/04/2019
					String remarkDescr="";
					String remarks="";
					String focusDeviReas="";
					for ( int j = 0; j < innerNodeListLen; j++ )
					{
						Node currNode = innerNodeList.item( j );
						//System.out.println("COLUMNAME ["+ currNode.getNodeName()+"] COLUMKN VALUE["+currNode.getFirstChild()+"] ");
						if ( "item_code".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild() != null)
							{
								itemCode = currNode.getFirstChild().getNodeValue().trim() ;
							}
						}
						else if ( "quantity".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild().getNodeValue() != null )
							{
								qty = currNode.getFirstChild().getNodeValue().trim();
							}
						}
						else if("scheme_code".equals( currNode.getNodeName() ))
						{
							if(currNode.getFirstChild() != null)
							{
								itemCode = checkNull(currNode.getFirstChild().getNodeValue());
								itemCode = itemCode.trim();
							}
						}
						else if ( "item_descr".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild() != null)
							{
								itemDescr = checkNull(currNode.getFirstChild().getNodeValue());
							}
						}
						else if ( "value".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild() != null)
							{
								val = checkNull(currNode.getFirstChild().getNodeValue());
							}
						}
						else if ( "tran_id".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild() != null)
							{
								tranID = checkNull(currNode.getFirstChild().getNodeValue());
							}
						}
						//added by rupali on 07/09/17 for rate and discount of order form [start]
						else if ( "rate".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild() != null)
							{
								chgRate = checkNull(currNode.getFirstChild().getNodeValue());
							}
						}
						else if ( "disc_perc".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild() != null)
							{
								discount = checkNull(currNode.getFirstChild().getNodeValue());
							}
						}
						//added by rupali on 07/09/17 for rate and discount of order form [end]
						//added by rupali on 30/10/17 for lot_no and stock_qty of order form [start]
						else if ( "lot_no".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild() != null)
							{
								lotNo = checkNull(currNode.getFirstChild().getNodeValue());
							}
						}
						else if ( "stock_qty".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild() != null)
							{
								stockQty = checkNull(currNode.getFirstChild().getNodeValue());
							}
						}
						//added by rupali on 30/10/17 for lot_no and stock_qty of order form [start]
						//added by rupali on 22/12/17 for getting data of stock_info field in edit mode[start]
						else if ( "stock_info".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild() != null)
							{
								stockInfo = checkNull(currNode.getFirstChild().getNodeValue());
							}
						}
						//added by rupali on 22/12/17 for getting data of stock_info field in edit mode[end]
						//added by rupali on 11/12/18 for getting data of promo_code field in edit mode[start]
						else if ( "promo_code".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild() != null)
							{
								promoCode = checkNull(currNode.getFirstChild().getNodeValue());
							}
						}
						//added by rupali on 11/12/18 for getting data of promo_code field in edit mode[end]
						//added by mrunalini sinkar on 10/04/2019 for promo_perc field[start]
						else if ( "promo_perc".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild() != null)
							{
								promoPerc = checkNull(currNode.getFirstChild().getNodeValue());
							}
						}
						//added by mrunalini sinkar on 10/04/2019 for promo_perc field[end]
						else if ( "remarks_ord".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild() != null)
							{
								remarks = checkNull(currNode.getFirstChild().getNodeValue());
							}
						}
						else if ( "remark_descr".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild() != null)
							{
								remarkDescr = checkNull(currNode.getFirstChild().getNodeValue());
							}
						}
						else if ( "focus_devi_reas".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild() != null)
							{
								focusDeviReas = checkNull(currNode.getFirstChild().getNodeValue());
							}
						}
					}
				System.out.println("remarks["+remarks+"] remarkDescr["+remarkDescr+"] focusDeviReas["+focusDeviReas+"]" );
					itemMap.put( itemCode, pitch+"~"+qty);
					tranIDMap.put( itemCode, tranID);
					rateMap.put(itemCode,"*"+chgRate+"~"+ discount); //added by rupali on 07/09/17 for rate and discount of order form
					stockMap.put(itemCode,"*"+lotNo+"~"+ stockQty); //added by rupali on 30/10/17 for lot_no and stock_qty of order form [start]
					stockInfoMap.put(itemCode,stockInfo); //added by rupali on 22/12/17 for getting data of stock_info field in edit mode
					promoCodeMap.put(itemCode,promoCode); //added by rupali on 11/12/18 for getting data of promo_code field in edit mode
					promoPercMap.put(itemCode, promoPerc);//added by mrunalini sinkar on 10/04/2019 for promo_perc field
					//System.out.println(" itemMap ["+itemMap+"]");
					//System.out.println(" stockMap ["+stockMap+"]");
					remarkMap.put(itemCode, remarks);
					focusDeviReasMap.put(itemCode, focusDeviReas);
					
					remarkDescrMap.put(itemCode, remarkDescr);

				}
			}

			String qty = "";
			String pitch = "";
			//added by rupali on 07/09/17 for rate and discount of order form [start]
			String chgRate = "";
			String discount = "";
			//added by rupali on 07/09/17 for rate and discount of order form [end]
			int num = 1;
			int lineNo=1;

			double value = 0d;
			double stockValue = 0d;//Added by kailash 26/dec/17
			double rate = 0d;
			double mrprate = 0d;
			//added by rupali on 30/10/17 for lot_no and stock_qty of order form [start]
			String lotNum = "";
			String stock = "";
			//added by rupali on 30/10/17 for lot_no and stock_qty of order form [end]

			pstmt =  connectionObject.prepareStatement( sql );
			// commentted and added by rupali on 01/02/19 for getting only active items [start]
//			pstmt.setString(1, prcListTemp);//Added by Bhagyashri T for PriceList[W22BASE016]
//			pstmt.setString(2, sprsCode);
			if(sprsCnt > 0)
			{
				pstmt.setString(1, prcListTemp);
				pstmt.setString(2, sprsCode);
			}
			else
			{
				pstmt.setString(1, prcListTemp);
			}
			
			/*if(strgCustCnt  > 0)
			{
				pstmt.setString(1, strgCode);//changed by poonam
			}
			else
			{
				pstmt.setString(1, paramValue);
			}*/
			// commentted and added by rupali on 01/02/19 for getting only active items [end]
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				//String stockInfoData = "{\"name\":\"stock_info|stock|expiry_date\", \"disp_name\":\"Batch No.|Stock|Expiry\", \"type\":\"text|number|text\", \"protect\":\"0|0|1\", \"1\":\"||\"}"; //added by rupali on 22/12/17 for getting data of stock_info field in edit mode
				String stockInfoData = "";
				String remark="",remarkdescrs="",focusDeviReas="";
				String promoCode = "";
				String schemeDescr = "";
				String promoPerc="";
				String tranID = "";
				String isProductEco="";
				String productDays="";
				String isItemEco="";
				String itemDays="";
				String isProductFocus="";
				String isItemFocus="";

				int minQunt=0;
				int proDiffDays=0;
				String itemCode = checkNull(rs.getString("ITEM_CODE"));
				String productCode=checkNull(rs.getString("PRODUCT_CODE"));
				String itemDescr = checkNull(rs.getString("DESCR"));
				String itemShDescr = checkNull(rs.getString("SH_DESCR"));
				String priceList = checkNull(rs.getString("PRICE_LIST"));   //added by mrunalini sinkar for getLandingRate
				String domQty1 = genericUtility.getColumnValue("quantity", dom, formNo);
				String expDate = ""; //added by rupali on 30/10/17 for dispalying exp_date of item
				int currFormNo = Integer.parseInt(formNo);
				String objName = checkNull(getObjNameFromDom(dom2, "objName",currFormNo));
				String parentFormNo = checkNull(getParentformNo(formNo, objName, connectionObject ));
				String stockistCode = genericUtility.getColumnValue("stockist_code", dom2, parentFormNo);
				//System.out.println("stockist_code is:::::"+stockistCode);
				/*//added by rupali on 30/10/17 for calculating months between two dates [start]
				Date date = Calendar.getInstance().getTime();
		        DateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
		        String today = sdf.format(date);
		        System.out.println("Today : " + today);
		        String totMonths = "";
				//added by rupali on 30/10/17 for calculating months between two dates [end]
				 */
				//added by rupali on 07/09/17 for rate and discount of order form [start]

				String maxTwoOrder=darCommonBean.getPreviousTwoOrderDetails(itemCode,eventDate,strgCode,sprsCode,connectionObject);

				String ecoProSql="SELECT 'N' NO_ECO,(CASE WHEN STRG_PROD.LAST_ORDER_DATE IS NOT NULL THEN (TRUNC(SYSDATE) - NVL(TRUNC(STRG_PROD.LAST_ORDER_DATE), SYSDATE+1)) else -1 end )AS DIFF " + 
						" FROM STRG_CUST_EXCEPTION STRG_CUST_EXCP, STRG_PRODUCT STRG_PROD, PRODUCT PROD " + 
						" WHERE STRG_CUST_EXCP.SC_CODE = STRG_PROD.SC_CODE " + 
						" AND STRG_CUST_EXCP.PRODUCT_CODE = STRG_PROD.PRODUCT_CODE " + 
						" AND PROD.PRODUCT_CODE = STRG_PROD.PRODUCT_CODE " + 
						" AND STRG_CUST_EXCP.PRODUCT_CODE =? " +
						" AND (STRG_CUST_EXCP.ITEM_CODE IS NULL OR UPPER(STRG_CUST_EXCP.ITEM_CODE) = 'NULL') " +
						" AND (STRG_PROD.ITEM_CODE IS NULL OR UPPER(STRG_PROD.ITEM_CODE) = 'NULL') " + 
						" AND STRG_CUST_EXCP.SC_CODE = ? AND EXCEP_FLAG = '1'";
			
			PreparedStatement ecoPstmt = connectionObject.prepareStatement(ecoProSql);
			ecoPstmt.setString(1,productCode);
			ecoPstmt.setString(2,strgCode);
			ResultSet ecoRS = ecoPstmt.executeQuery();
			if( ecoRS.next() )
			{
				isProductEco=checkNull(ecoRS.getString("NO_ECO"));
				productDays = checkNull(ecoRS.getString("DIFF")); 
			}
			if (ecoRS!= null)
			{
				ecoRS.close();
				ecoRS = null;
			}
			if(ecoPstmt!=null)
			{
				ecoPstmt.close();
				ecoPstmt = null;
			}
			String ecoItemsql="SELECT 'N' NO_ECO,(CASE WHEN STRG_PROD.LAST_ORDER_DATE IS NOT NULL THEN (TRUNC(SYSDATE) - NVL(TRUNC(STRG_PROD.LAST_ORDER_DATE), SYSDATE+1)) else -1 end )AS DIFF "+
					" FROM STRG_CUST_EXCEPTION STRG_CUST_EXCP, STRG_PRODUCT STRG_PROD, ITEM ITEM " + 
					" WHERE STRG_CUST_EXCP.SC_CODE = STRG_PROD.SC_CODE " + 
					" AND STRG_CUST_EXCP.PRODUCT_CODE = STRG_PROD.PRODUCT_CODE  "+
					" AND STRG_CUST_EXCP.ITEM_CODE = STRG_PROD.ITEM_CODE "+
					" AND ITEM.ITEM_CODE = STRG_PROD.ITEM_CODE " + 
					" AND STRG_CUST_EXCP.PRODUCT_CODE =? AND STRG_CUST_EXCP.ITEM_CODE =? " +
					" AND (STRG_PROD.ITEM_CODE IS NOT NULL OR UPPER(STRG_PROD.ITEM_CODE) != 'NULL') " + 
					" AND STRG_CUST_EXCP.SC_CODE=? AND EXCEP_FLAG = '1'";
			PreparedStatement ecoItemPstmt = connectionObject.prepareStatement(ecoItemsql);
			ecoItemPstmt.setString(1,productCode);
			ecoItemPstmt.setString(2,itemCode);
			ecoItemPstmt.setString(3,strgCode);
			ResultSet ecoItemRS = ecoItemPstmt.executeQuery();
			if( ecoItemRS.next() )
			{
				isItemEco=checkNull(ecoItemRS.getString("NO_ECO"));
				itemDays = checkNull(ecoItemRS.getString("DIFF")); 
			}
			if (ecoItemRS!= null)
			{
				ecoItemRS.close();
				ecoItemRS = null;
			}
			if(ecoItemPstmt!=null)
			{
				ecoItemPstmt.close();
				ecoItemPstmt = null;
			}			
			int focusProductCnt=0;
			String focusProSql="SELECT COUNT(*) AS FOCUS_PRODUCT_CNT "
					+ " FROM STRG_PRODUCT "
					+ " WHERE PRODUCT_CODE=? "
					+ " AND (ITEM_CODE IS NOT NULL OR UPPER(ITEM_CODE) != 'NULL') "
					+ " AND SC_CODE=?";
			PreparedStatement focusPstmt = connectionObject.prepareStatement(focusProSql);
			focusPstmt.setString(1,productCode);
			focusPstmt.setString(2,strgCode);
			ResultSet focusProRS = focusPstmt.executeQuery();
			if( focusProRS.next() )
			{
				focusProductCnt=focusProRS.getInt("FOCUS_PRODUCT_CNT");
			}
			if (focusProRS!= null)
			{
				focusProRS.close();
				focusProRS = null;
			}
			if(focusPstmt!=null)
			{
				focusPstmt.close();
				focusPstmt = null;
			}
			if(focusProductCnt>0)
			{
				isProductFocus="Y";
			}			
			
			String minQuansql="SELECT MIN_QTY AS MIN_QTY FROM STRG_PRODUCT WHERE PRODUCT_CODE=? AND ITEM_CODE =? AND SC_CODE=?";
			PreparedStatement minQuanPstmt = connectionObject.prepareStatement(minQuansql);
			minQuanPstmt.setString(1,productCode);
			minQuanPstmt.setString(2,itemCode);
			minQuanPstmt.setString(3,strgCode);
			ResultSet minQuanRS = minQuanPstmt.executeQuery();
			if( minQuanRS.next() )
			{
				minQunt=minQuanRS.getInt("MIN_QTY");
			}
			if (minQuanRS!= null)
			{
				minQuanRS.close();
				minQuanRS = null;
			}
			if(minQuanPstmt!=null)
			{
				minQuanPstmt.close();
				minQuanPstmt = null;
			}	
			
			int focusItemCnt=0;
			String focusItemSql="SELECT COUNT(*) AS FOCUS_ITEM_CNT FROM STRG_PRODUCT WHERE PRODUCT_CODE=? AND ITEM_CODE=? AND SC_CODE=?";
			PreparedStatement focusItemPstmt = connectionObject.prepareStatement(focusItemSql);
			focusItemPstmt.setString(1,productCode);
			focusItemPstmt.setString(2,itemCode);
			focusItemPstmt.setString(3,strgCode);

			ResultSet focusItemRS = focusItemPstmt.executeQuery();
			if( focusItemRS.next() )
			{
				focusItemCnt=focusItemRS.getInt("FOCUS_ITEM_CNT");
			}
			if (focusItemRS!= null)
			{
				focusItemRS.close();
				focusItemRS = null;
			}
			if(focusItemPstmt!=null)
			{
				focusItemPstmt.close();
				focusItemPstmt = null;
			}
			if(focusItemCnt>0)
			{
				isItemFocus="Y";
			}
			
				String domRate = genericUtility.getColumnValue("rate", dom, formNo);
				discount = genericUtility.getColumnValue("disc_pers", dom, formNo);
				//System.out.println("dom discount inside if["+discount+"]");
				//added by rupali on 07/09/17 for rate and discount of order form [end]
				//added by rupali on 30/10/17 for lot_no and stock_qty of order form [start]
				lotNum = genericUtility.getColumnValue("lot_no", dom, formNo);
				stock = genericUtility.getColumnValue("stock_qty", dom, formNo);
				//added by rupali on 30/10/17 for lot_no and stock_qty of order form [end]
				mrprate = darCommonBean.getLandingRate( strgCode, itemCode, eventDate, sprsCode,mrpPriceList, connectionObject); //Added By Haseeb Khan on [18-10-2021]				
				rate = darCommonBean.getLandingRate( strgCode, itemCode, eventDate, sprsCode,priceList, connectionObject);
				DecimalFormat df = new DecimalFormat("###.##"); //added by rupali on 08/18/17 for rate and discount of order form
				//added condition by rupali on 07/09/17 for rate and discount of order form
				if ( itemMap.get( itemCode.trim() ) != null || rateMap.get( itemCode.trim() ) != null )
				{
					String data = ( String ) itemMap.get( itemCode.trim() );
					qty = data.substring( data.indexOf("~") + 1 );
					//added by rupali on 07/09/17 for rate and discount of order form [start]
					String data1 = ( String ) rateMap.get( itemCode.trim() );
					//rate = Double.parseDouble(data1.substring( data1.indexOf("*") + 1 ,data1.indexOf("~")));//Comment for Check rate according to the Price_list
					discount = data1.substring( data1.indexOf("~") + 1 );
					//added by rupali on 07/19/17 for rate and discount of order form [end]
					//added by rupali on 31/10/17 for lot_no and stock_qty of order form [start]
					if(stockMap != null && !stockMap.isEmpty())
					{
						String stkData = ( String ) stockMap.get( itemCode.trim() );
						lotNum = stkData.substring( stkData.indexOf("*") + 1 ,stkData.indexOf("~"));
						stock = stkData.substring( stkData.indexOf("~") + 1 );
					}
					//added by rupali on 31/10/17 for lot_no and stock_qty of order form [end]
					//added by rupali on 22/12/17 for getting data of stock_info field in edit mode[start]
					if(stockInfoMap != null && !stockInfoMap.isEmpty())
					{
						stockInfoData = ( String ) stockInfoMap.get( itemCode.trim() );
					}
					//added by rupali on 22/12/17 for getting data of stock_info field in edit mode[end]
					if(remarkMap != null && !remarkMap.isEmpty())
					{
						remark = ( String ) remarkMap.get( itemCode.trim() );
					}	
					if(focusDeviReasMap != null && !focusDeviReasMap.isEmpty())
					{
						focusDeviReas = ( String ) focusDeviReasMap.get( itemCode.trim() );
						remarkdescrs = ( String ) remarkDescrMap.get( itemCode.trim() );
					}	
					//added by rupali on 11/12/18 for getting data of promo_code field in edit mode[start]
					if(promoCodeMap != null && !promoCodeMap.isEmpty())
					{
						promoCode = ( String ) promoCodeMap.get( itemCode.trim() );
						sql = "SELECT DESCR FROM BOM WHERE BOM_CODE = ?";
						PreparedStatement pstmtPromo = connectionObject.prepareStatement(sql);
						pstmtPromo.setString(1,promoCode);
						ResultSet rsPromo = pstmtPromo.executeQuery();
						if(rsPromo.next())
						{
							schemeDescr = checkNull(rsPromo.getString("DESCR"));
							//System.out.println("Descr"+schemeDescr);
						}
						if (rsPromo != null)
						{
							rsPromo.close();
							rsPromo = null;
						}
						if (pstmtPromo != null)
						{
							pstmtPromo.close();
							pstmtPromo = null;
						}
					}
					//added by rupali on 11/12/18 for getting data of promo_code field in edit mode[end]
					//added by mrunalini sinkar on 10/04/2019 for promo_perc field[start]
					if(promoPercMap != null && !promoPercMap.isEmpty())
					{
						promoPerc = ( String ) promoPercMap.get( itemCode.trim() );

					}
					//added by mrunalini sinkar on 10/04/2019 for promo_perc field[end]
					//System.out.println("itemCode inside if["+itemCode+"]");
					valueXmlString.append("<Detail"+formNo+" domID='"+num+"' selected = 'Y' formName='"+formName+"'>\r\n" );
					valueXmlString.append("<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\"/>\r\n");
					valueXmlString.append("<selectbox><![CDATA[").append( "true" ).append("]]></selectbox>\n");
					valueXmlString.append("<strg_code><![CDATA[").append( strgCode ).append("]]></strg_code>\r\n");
				}
				else
				{
					stock = "0";
					valueXmlString.append("<Detail"+formNo+" domID='"+num+"' selected = 'N' formName='"+formName+"'>\r\n" );
					valueXmlString.append("<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");
					valueXmlString.append("<strg_code><![CDATA[").append( "" ).append("]]></strg_code>\r\n");
				}
				if(tranIDMap.containsKey(itemCode))
				{
					tranID = (String)tranIDMap.get(itemCode);
				}
				//System.out.println("lotno:::::["+lotNum+"]"+"stock::::::["+stock+"]");
				String totMonths = darCommonBean.getTotalMonths(itemCode,lotNum,connectionObject);
				/*// added by rupali on 06/11/17 for getting expirt date of item [start]
				String expSql = "select exp_date from item_lot_info where item_code = ? and  lot_no = ?";
				pstmt1 =  connectionObject.prepareStatement(expSql);
				pstmt1.setString(1, itemCode);
				pstmt1.setString(2, lotNum);
				rs1 = pstmt1.executeQuery();
				if(rs1.next())
				{
					expDate = (rs1.getString("exp_date") == null) ?"":rs1.getString("exp_date").trim();
					System.out.println("expDate is::::::"+expDate);
				}
				if (rs1!= null)
				{
					rs1.close();
					rs1 = null;
				}
				if(pstmt1!=null)
				{
					pstmt1.close();
					pstmt1 = null;
				}
				if(expDate.trim().length() != 0)
		        {
			        SimpleDateFormat inputFormat=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
					Date eventDate1=null;
					eventDate1 = inputFormat.parse(expDate);
					expDate=sdf.format(eventDate1);
					System.out.println("expDate is:::::"+expDate);

				    totMonths = Integer.toString(monthsBetween(sdf.parse(today), sdf.parse(expDate)));
				    System.out.println("totMonths:::::"+totMonths);
		        }
				// added by rupali on 06/11/17 for getting expirt date of item [end]
				 */				
				 valueXmlString.append("<tran_id><![CDATA[" ).append(checkNull(tranID)).append( "]]></tran_id>\r\n" );//Gulzar on 04/07/17
				 valueXmlString.append("<item_descr><![CDATA[").append(rs.getString("DESCR")).append("]]></item_descr>\r\n");
				if("Y".equalsIgnoreCase(orderParam))
				{
					 valueXmlString.append("<quantity><![CDATA[" ).append( qty ).append( "]]></quantity>\r\n" );

				}
				else
				{
					System.out.println("qty is october::::::::::::["+qty+"]");
					if("0".equalsIgnoreCase(qty))
					{
						valueXmlString.append("<quantity><![CDATA[" ).append( "" ).append( "]]></quantity>\r\n" );

					}
					else
					{
						valueXmlString.append("<quantity><![CDATA[" ).append( qty ).append( "]]></quantity>\r\n" );

					}

				}
				 valueXmlString.append("<landing_rate><![CDATA[" ).append( rate ).append( "]]></landing_rate>\r\n" );
				 //added by rupali on 07/09/17 for rate and discount of order form [start]
				 valueXmlString.append("<rate><![CDATA[" ).append(df.format(rate)).append( "]]></rate>\r\n" );
				 valueXmlString.append("<mrp_rate><![CDATA[" ).append(df.format(mrprate)).append( "]]></mrp_rate>\r\n" ); //Added By Haseeb Khan on [18-10-2021]
				 valueXmlString.append("<disc_perc><![CDATA[" ).append( discount ).append( "]]></disc_perc>\r\n" );
				 //added by rupali on 07/09/17 for rate and discount of order form [end]
				 //added by rupali on 30/10/17 for dispalying exp_date of item [start]
				 valueXmlString.append("<lot_no><![CDATA[" ).append( lotNum ).append( "]]></lot_no>\r\n" );
				 valueXmlString.append("<stock_qty><![CDATA[" ).append( stock ).append( "]]></stock_qty>\r\n" );
				 /*if(totMonths.trim().length() > 0)
				{*/
				 valueXmlString.append("<expiry_date><![CDATA[").append( totMonths ).append("]]></expiry_date>\r\n");
				 //}
				 // commented and added by rupali on 02/11/17 for applying itemchange of lot_no in order form [start]
				 /*if(totMonths.trim().length() != 0)
				{
					valueXmlString.append("<expiry_date><![CDATA[").append( totMonths +"M" ).append("]]></expiry_date>\r\n");
				}
				else
				{
					valueXmlString.append("<expiry_date><![CDATA[").append( "" ).append("]]></expiry_date>\r\n");
				}*/
				 //valueXmlString.append("<expiry_date><![CDATA[").append( "" ).append("]]></expiry_date>\r\n");
				 // commented and added by rupali on 02/11/17 for applying itemchange of lot_no in order form [end]
				 //added by rupali on 30/10/17 for dispalying exp_date of item [end]
				 //System.out.println("qty::::==["+qty+"]");
				 //System.out.println("value::::==["+value+"]");
				 //DecimalFormat df = new DecimalFormat("###.##"); //added by rupali on 07/09/17 for rate and discount of order form
				 //System.out.println(" Before if >::::==["+ qty+"]");
				 if(qty != null && qty.trim().length()!= 0)
				 {
					 double value1= 0d;
					 // System.out.println(" rate>::::==["+ rate+"]");
					 // System.out.println(" discount>::::==["+ discount+"]");
					 double qty1 = 0d;
					 double discPerc = 0d; //added by rupali on 08/09/17 for rate and discount of order form
					 qty1= Double.parseDouble(qty);
					 //added by rupali on 08/09/17 for rate and discount of order form [start]
					 if(discount != null && discount.trim().length()!= 0)
					 {
						 discPerc= Double.parseDouble(discount);
					 }
					 //added by rupali on 08/09/17 for rate and discount of order form [end]
					 value1 = qty1 * rate;
					 //added by rupali on 08/09/17 for rate and discount of order form [start]
					 if(discount != null && discount.trim().length()!= 0)
					 {
						 value1 = qty1 * rate - (discPerc * value1 /100);
					 }
					 //added by rupali on 08/09/17 for rate and discount of order form [end]
					 //value1 = Integer.parseInt(qty) * rate;
					 //System.out.println("value::::==["+value1+"]");
					 valueXmlString.append("<value><![CDATA[" ).append(df.format(value1)).append( "]]></value>\r\n" );
				 }
				 else
				 {
					 //System.out.println(" Else if>::::==["+ value+"]");
					 valueXmlString.append("<value><![CDATA[" ).append(value).append( "]]></value>\r\n" );
				 }
				 //Added by kailash on 26/dec/17 to calculate stock value[Start]
				 if(stock != null && stock.trim().length()!= 0)
				 {
					 //System.out.println(" rate>::::==["+ rate+"],stock["+stock+"]");
					 double stkValue= 0d;
					 double stockVal = 0d;
					 stockVal= Double.parseDouble(stock);
					 stkValue = stockVal * rate;
					 valueXmlString.append("<stock_value><![CDATA[" ).append(df.format(stkValue)).append( "]]></stock_value>\r\n" );
				 }
				 else
				 {
					 valueXmlString.append("<stock_value><![CDATA[" ).append(stockValue).append( "]]></stock_value>\r\n" );
				 }
				 //Added by kailash on 26/dec/17 to calculate stock value[end]

				 //valueXmlString.append("<value><![CDATA[" ).append(value).append( "]]></value>\r\n" );
				 valueXmlString.append("<item_code><![CDATA[").append( rs.getString("ITEM_CODE") ).append("]]></item_code>\r\n");
				 valueXmlString.append("<tooltip_descr><![CDATA[").append(rs.getString("DESCR")).append("]]></tooltip_descr>\r\n");
				 valueXmlString.append("<line_no><![CDATA["+lineNo+"]]></line_no>\r\n");
				 valueXmlString.append("<dcr_id><![CDATA["+dcrID+"]]></dcr_id>\r\n" );
				 valueXmlString.append("<sales_pers><![CDATA[").append(sprsCode).append("]]></sales_pers>\r\n");
				 valueXmlString.append("<stockist_code><![CDATA[").append(stockistCode).append("]]></stockist_code>\r\n");
				 valueXmlString.append("<stock_info><![CDATA[").append(stockInfoData).append("]]></stock_info>\r\n"); //added by rupali on 22/12/17 for getting data of stock_info field in edit mode
				 //Changed by Gulzar on 08/12/17
				 String itemSize = "";
				 String itemAttribute = "";
				 if(itemAttribMap != null && !itemAttribMap.isEmpty() && itemAttribMap.size() > 0 && itemAttribMap.containsKey(itemCode))
				 {
					 HashMap attribMap = (HashMap)itemAttribMap.get(itemCode);
					 if(attribMap != null && !attribMap.isEmpty() && attribMap.size() > 0)
					 {
						 itemSize = (String)attribMap.get("ITEM_SIZE");
						 itemAttribute = (String)attribMap.get("ITEM_ATTRIBUTE");
					 }
				 }
				 //System.out.println("itemAttribute>>"+itemAttribute);
				 valueXmlString.append("<product_code><![CDATA[").append( checkNull(rs.getString("PRODUCT_CODE")) ).append("]]></product_code>\r\n");
				 valueXmlString.append("<product_descr><![CDATA[").append( checkNull(rs.getString("PRODUCT_DESCR")) ).append("]]></product_descr>\r\n");
				 valueXmlString.append("<item_size><![CDATA[").append( itemSize ).append("]]></item_size>\r\n");
				 valueXmlString.append("<item_attrib_descr><![CDATA[").append( itemAttribute ).append("]]></item_attrib_descr>\r\n");
				 valueXmlString.append("<is_stock_info><![CDATA[").append( isStockInfo ).append("]]></is_stock_info>\r\n"); // added by mrunalini sinkar on 10-august-2018
				 valueXmlString.append("<event_date><![CDATA[").append( eventDate ).append("]]></event_date>\r\n"); // added by rupali on 01/11/18 for dispalying scheme description in link
				 valueXmlString.append("<promo_code><![CDATA[").append( promoCode ).append("]]></promo_code>\r\n"); // added by rupali on 11/12/18 for getting promo_code in edit mode
				 valueXmlString.append("<description><![CDATA[").append( schemeDescr ).append("]]></description>\r\n"); // added by rupali on 11/12/18 for getting description in edit mode
				 valueXmlString.append( "<promo_perc><![CDATA[" ).append(promoPerc).append( "]]></promo_perc>\r\n" ); // added by mrunalini sinkar PROMO_PERC on 10/04/2019
				 valueXmlString.append("<remarks_ord><![CDATA[" ).append(remark).append( "]]></remarks_ord>\r\n" );
				 valueXmlString.append("<remark_descr><![CDATA[" ).append(remarkdescrs).append( "]]></remark_descr>\r\n" );
				 valueXmlString.append("<focus_devi_reas><![CDATA[" ).append(focusDeviReas).append( "]]></focus_devi_reas>\r\n" );
				 valueXmlString.append("<prev_two_order><![CDATA[").append(maxTwoOrder).append("]]></prev_two_order>\r\n");
				 valueXmlString.append("<is_product_eco><![CDATA[").append(isProductEco).append("]]></is_product_eco>\r\n");
				 valueXmlString.append("<product_last_visit><![CDATA[").append(productDays).append("]]></product_last_visit>\r\n");
				 valueXmlString.append("<is_item_eco><![CDATA[").append(isItemEco).append("]]></is_item_eco>\r\n");
				 valueXmlString.append("<item_last_visit><![CDATA[").append(itemDays).append("]]></item_last_visit>\r\n");
				 valueXmlString.append("<min_quantity><![CDATA[").append(minQunt).append("]]></min_quantity>\r\n");
				 valueXmlString.append("<is_focus_product><![CDATA[").append(isProductFocus).append("]]></is_focus_product>\r\n");
				 valueXmlString.append("<is_focus_item><![CDATA[").append(isItemFocus).append("]]></is_focus_item>\r\n");
				 valueXmlString.append("</Detail"+formNo+">\r\n" );

				 qty = "";
				 num++;
				 lineNo++;
			}//end of while
			if(rs != null)
			{
				rs.close(); rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close(); pstmt = null;
			}
			num = 1;
		}
		catch (Exception e)
		{
			e.printStackTrace();
			System.out.println( "Exception :ITMWizardStatefulEJB :getSalesPersItemList(String):" + e.getMessage() + ":" );
			//valueXmlString = valueXmlString.append( genericUtility.createErrorString( e ) );
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		finally
		{
			try
			{
				if( connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :ITMWizardStatefulEJB :getSalesPersItemList(String) :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		valueXmlString.append( "</Root>\r\n" );
		System.out.println( "\n****ValueXmlString :" + valueXmlString.toString() + ":********" );
		return valueXmlString.toString();
	}

	/*private double getLandingRate(String strgCode, String itemCode, String workDate, String sprsCode, String priceList,Connection connectionObject) throws Exception
	{
		//System.out.println("Inside getLandingRate()::::::" );
		double rate = 0d;
		String sql = "";
		String stateCode = "";
		PreparedStatement pStmt = null;
		ResultSet rs = null;
		// commented and added by rupali on 12/01/17 for changing logic of getting rate from pricelist [start]
		String listType = "";
		String lsUnit = "";
		String lsRefNo = "";
		Double mQty = 1d;
		// commented and added by rupali on 12/01/17 for changing logic of getting rate from pricelist [end]
		try
		{
			//System.out.println("strgCode:::>>>>[" + strgCode +"]" );

			//System.out.println("stateCode:::>>>>[" + stateCode +"]");
			DistCommon distComn = new DistCommon();
			// commented and added by rupali on 12/01/17 for changing logic of getting rate from pricelist [start]
			//	rate = distComn.pickRate(priceList, workDate, itemCode, connectionObject);
			sql = " select list_type from pricelist_mst where price_list = ? ";
			pStmt = connectionObject.prepareStatement(sql);
			pStmt.setString(1, priceList);
			rs = pStmt.executeQuery();
			if (rs.next())
			{
				listType = rs.getString("list_type");
			}
			rs.close();
			rs = null;
			pStmt.close();
			pStmt = null;
			//System.out.println("List Type:-[" + listType + "]");

			sql = "select unit  from item where item_code = ?";
			pStmt = connectionObject.prepareStatement(sql);
			pStmt.setString(1, itemCode);
			rs = pStmt.executeQuery();
			if (rs.next()) {
				lsUnit = rs.getString("unit");
			}
			rs.close();
			rs = null;
			pStmt.close();
			pStmt = null;

			sql = "select max(ref_no) from pricelist where price_list  =? and item_code= ? and unit=? and list_type= ?"
					+ " and eff_from<=? and valid_upto>=? and min_qty<=? and max_qty>=? and (ref_no is not null)";
			pStmt = connectionObject.prepareStatement(sql);
			pStmt.setString(1, priceList);
			pStmt.setString(2, itemCode);
			pStmt.setString(3, lsUnit);
			pStmt.setString(4, listType);
			pStmt.setTimestamp(5, java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString( workDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat())));
			pStmt.setTimestamp(6, java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString( workDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat())));
			pStmt.setDouble(7, mQty);
			pStmt.setDouble(8, mQty);
			rs = pStmt.executeQuery();
			if (rs.next())
			{
				lsRefNo = checkNull(rs.getString(1));
			}
			//System.out.println("inside getLandingRate lsRefNo is"+lsRefNo);
			rate = distComn.pickRateRefnoWise(priceList,workDate, itemCode, "", listType,mQty, connectionObject);
			// commented and added by rupali on 12/01/17 for changing logic of getting rate from pricelist [end]
			//System.out.println("getLandingRate_RATE::>>>>["+itemCode+"] [" + rate +"]");
		}
		catch (Exception e)
		{
			e.printStackTrace();
			//System.out.println( "Exception :getLandingRate(String):" + e.getMessage() + ":" );
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		finally
		{
			try
			{
				if( rs != null )
				{
					rs.close();
					rs = null;
				}

				if(pStmt != null )
				{
					pStmt.close();
					pStmt = null;
				}

			}
			catch(Exception e)
			{
				System.out.println( "Exception getLandingRate(String) :==>\n"+e.getMessage());
			}
		}

		return rate;
	}*/
	//Added by Poonam Gole on 26-10-2015 [ End ]
	//Added method by Gulzar on 18/06/12

	private String findValue(Connection conn, String columnName ,String tableName, String columnName2, String value) throws  ITMException
	{
		PreparedStatement pstmt = null ;
		ResultSet rs = null ;
		String sql = "";
		String findValue = "";
		try
		{
			sql = "SELECT " + columnName + " from " + tableName + " where " + columnName2 +"= ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,value);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				findValue = rs.getString(1);
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
		}
		catch(Exception e)
		{
			System.out.println("Exception in findValue ");
			e.printStackTrace();
			throw new ITMException(e);
		}
		//System.out.println("returning String from findValue " + findValue);
		return findValue;
	}

	private ArrayList getTeamList(String workWith) throws  ITMException
	{
		ArrayList teamList = new ArrayList();
		try
		{
			if ( workWith != null && workWith.trim().length() > 0 )
			{
				String searchIndex = "";
				if ( workWith.indexOf("<BR/>") > 0 )
				{
					searchIndex = "<BR/>";
				}
				else if ( workWith.indexOf(",") > 0 )
				{
					searchIndex = ",";
				}
				//System.out.println("searchIndex =["+searchIndex+"]");
				if ( workWith.indexOf(searchIndex) > 0 )
				{
					String workWitthTeam [] = workWith.split(searchIndex);
					if ( workWitthTeam != null && workWitthTeam.length > 0 )
					{
						String teamMember = "";

						for ( int i=0; i<workWitthTeam.length; i++)
						{
							teamMember = workWitthTeam[i];
							//System.out.println("teamMember =["+teamMember+"]");
							int leftIndex = teamMember.indexOf("(");
							int rightIndex = teamMember.indexOf(")");
							String newStr = "";
							if (leftIndex >= 0 && rightIndex >= 0 )
							{
								newStr = teamMember.substring(leftIndex+1,teamMember.lastIndexOf(")"));
								//System.out.println("leftIndex_rightIndex =["+newStr+"]");
							}
							else if (leftIndex >= 0 )
							{
								newStr = teamMember.substring(leftIndex+1);
								//System.out.println("newStr_leftIndex =["+newStr+"]");
							}
							else if (rightIndex >= 0 )
							{
								newStr = teamMember.substring(0,rightIndex);
								//System.out.println("newStr_rightIndex =["+newStr+"]");
							}
							teamList.add(newStr.trim());
						}

					}
				}
				else
				{
					teamList.add(workWith);
				}
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		//System.out.println("Team List ::"+teamList);
		return teamList;
	}

	public String getSalesPersTeamList( String salesPers, String strgCode, String selectedTeam, String workWith ) throws ITMException
	{
		//System.out.println("<===::: getSalesPersTeamList is called :::===>");
		String sql = "";
		String [] team = new String [25];
		StringBuffer valueXmlString = new StringBuffer("<Root>\r\n");
		Connection connectionObject = null;
		PreparedStatement pstmtPophelp = null;
		ResultSet rsPophelp = null;
		//changed by Rahul Barve on 10-Apr-2015
		//GenericUtility genericUtility = GenericUtility.getInstance();
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

		try
		{
			ArrayList teamList = getTeamList(workWith);//Gulzar on 23/06/12

			/*ConnDriver connDriver = new ConnDriver();
			connectionObject = connDriver.getConnectDB( "DriverValidator" );*/
			connectionObject = getConnection();//chnged by sachin satre on [11-nov-16] to get connection

			selectedTeam = ( selectedTeam != null ) ? selectedTeam.trim() : selectedTeam;
			team = selectedTeam.split(",");
			//System.out.println("Team selected ["+Arrays.asList(team)+"] strgCode["+strgCode+"]");
			sql = "SELECT SQL_STR FROM POPHELP WHERE FIELD_NAME='SALES_PERS' AND MOD_NAME='W_WSFA_DSR_MOB_WIZ'";
			pstmtPophelp =  connectionObject.prepareStatement( sql );
			rsPophelp = pstmtPophelp.executeQuery();
			int num = 1;
			if (rsPophelp.next())
			{
				sql = rsPophelp.getString("SQL_STR").trim().replace("'?'", "?");
				PreparedStatement pstmt =  connectionObject.prepareStatement( sql );
				pstmt.setString(1, salesPers);
				ResultSet rs = pstmt.executeQuery();
				while(rs.next())
				{
					String reportTo = rs.getString("REPORT_TO");
					String desgn= rs.getString("DESIGNATION");
					//System.out.println("reportTo["+reportTo+"] desgn ["+desgn+"]");
					reportTo = ( reportTo != null ) ? reportTo.trim() : reportTo;
					if ( new ArrayList<String>(Arrays.asList(team)).contains( reportTo ) || (teamList != null && teamList.contains(reportTo)) )
					{

						valueXmlString.append( "<Detail10 domID='" + num + "' selected = 'Y'>\r\n" );
						valueXmlString.append( "<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\"/>\r\n");//Gaurav Singh on 03/06/15
					}
					else
					{
						valueXmlString.append( "<Detail10 domID='" + num + "' selected = 'N'>\r\n" );
						valueXmlString.append( "<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");//Gaurav Singh on 03/06/15
					}

					valueXmlString.append("<sales_pers><![CDATA[").append( reportTo ).append("]]></sales_pers>\r\n");
					valueXmlString.append("<name><![CDATA[").append( rs.getString("NAME") ).append("]]></name>\r\n");
					valueXmlString.append("<member_name visible='0'><![CDATA[" ).append( rs.getString("NAME") ).append("]]></member_name>\r\n"); //Added by Bhagyashri t for team subform add [W21KJOH015]
					valueXmlString.append("<designation><![CDATA[").append( rs.getString("DESIGNATION")).append("]]></designation>\r\n");
					valueXmlString.append("<strg_code><![CDATA[").append( strgCode ).append("]]></strg_code>\r\n");
					valueXmlString.append("<role_code><![CDATA[]]></role_code>\r\n");

					sql = "SELECT DESIGN_CODE FROM EMPLOYEE WHERE EMP_CODE = ?";
					PreparedStatement pstmtEmp =  connectionObject.prepareStatement( sql );
					pstmtEmp.setString(1, reportTo);
					ResultSet rset = pstmtEmp.executeQuery();
					if ( rset.next())
					{
						String desgnCode = rset.getString("DESIGN_CODE") != null ?rset.getString("DESIGN_CODE").trim() :"";
						valueXmlString.append("<design_code><![CDATA[").append( desgnCode ).append("]]></design_code>\r\n");
						valueXmlString.append("<disp_descr><![CDATA[").append( desgnCode ).append("]]></disp_descr>\r\n");
						//Added by Bhagyashri t for team subform add [W21KJOH015]
					}
					rset.close(); rset = null;
					pstmtEmp.close(); pstmtEmp = null;

					valueXmlString.append("<line_no><![CDATA[]]></line_no>\r\n");
					valueXmlString.append( "<deselect_strg_code><![CDATA[" ).append("N").append( "]]></deselect_strg_code>\r\n" );//Gulzar on 02/08/12
					valueXmlString.append( "</Detail10>\r\n" );
					num++;
				}
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;

				}
			}
			if(rsPophelp != null)
			{
				rsPophelp.close();
				rsPophelp = null;
			}
			if(pstmtPophelp != null)
			{
				pstmtPophelp.close();
				pstmtPophelp = null;

			}

		}
		catch (Exception e)
		{
			e.printStackTrace();
			System.out.println( "Exception :ITMWizardStatefulEJB :getSalesPersTeamList(String):" + e.getMessage() + ":" );
			//valueXmlString = valueXmlString.append( genericUtility.createErrorString( e ) );
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		finally
		{
			try
			{
				if ( rsPophelp != null )
				{
					rsPophelp.close();
					rsPophelp = null;
				}

				if ( pstmtPophelp != null )
				{
					pstmtPophelp.close();
					pstmtPophelp = null;
				}
				if( connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :ITMWizardStatefulEJB :getSalesPersTeamList(String) :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		valueXmlString.append( "</Root>\r\n" );
		//System.out.println( "\n****ValueXmlString :" + valueXmlString.toString() + ":********" );
		return valueXmlString.toString();

	}

	//End Added by Gulzar on 18/06/12
	//Added By Gulzar on 16-APR-13.START
	private String getDCRId(Connection conn, String salesPers, String dcrDate, String selActCode) throws Exception
	{
		String dcrID = "";
		PreparedStatement pstmtDCRID = null;
		ResultSet rsDCRID = null;
		try
		{
			String activityCode = "";
			//changed by Rahul Barve on 10-Apr-2015
			//GenericUtility genericUtility = GenericUtility.getInstance();
			E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
			dcrDate = genericUtility.getValidDateTimeString( dcrDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );

			//Select the activity type of selected activity code
			String selActType = "";
			String actTypeSql = "SELECT ACTIVITY_TYPE FROM FIELDACTIVITY WHERE ACTIVITY_CODE = ? ";

			PreparedStatement pstmtActType = conn.prepareStatement( actTypeSql );
			pstmtActType.setString(1, selActCode);
			ResultSet rsActType = pstmtActType.executeQuery();
			if( rsActType.next() )
			{
				selActType = checkNull(rsActType.getString("ACTIVITY_TYPE"));
			}
			rsActType.close();rsActType = null;
			pstmtActType.close();pstmtActType = null;

			//Select the activity code from sprs_act_tran of selected activity type
			String actCodeDb = "";
			String actCodeSql = "SELECT A.ACTIVITY_CODE FROM SPRS_ACT_TRAN A, FIELDACTIVITY B WHERE A.ACTIVITY_CODE = B.ACTIVITY_CODE AND A.EVENT_DATE = ? AND A.SALES_PERS = ? AND B.ACTIVITY_TYPE = ? ";

			PreparedStatement pstmtActCode = conn.prepareStatement( actCodeSql );
			pstmtActCode.setTimestamp(1, java.sql.Timestamp.valueOf(dcrDate));
			pstmtActCode.setString(2, salesPers);
			pstmtActCode.setString(3, selActType);
			ResultSet rsActCode = pstmtActCode.executeQuery();
			if( rsActCode.next() )
			{
				actCodeDb = checkNull(rsActCode.getString("ACTIVITY_CODE"));
			}
			rsActCode.close();rsActCode = null;
			pstmtActCode.close();pstmtActCode = null;

			if(actCodeDb.trim().length() > 0)
			{
				activityCode = actCodeDb;
			}
			else
			{
				activityCode = selActCode;
			}

			String dcrSql = "SELECT DCR_ID FROM SPRS_ACT_TRAN WHERE EVENT_DATE =? AND SALES_PERS = ? AND ACTIVITY_CODE = ? ";

			pstmtDCRID = conn.prepareStatement( dcrSql );
			pstmtDCRID.setTimestamp(1, java.sql.Timestamp.valueOf(dcrDate));
			pstmtDCRID.setString(2, salesPers);
			pstmtDCRID.setString(3, activityCode);
			rsDCRID = pstmtDCRID.executeQuery();
			if( rsDCRID.next() )
			{
				dcrID = checkNull(rsDCRID.getString("DCR_ID"));
			}
			//added By Nilesh Start::02-06-2017
			if (rsDCRID!= null)
			{
				rsDCRID.close();
				rsDCRID = null;
			}
			if(pstmtDCRID!=null)
			{
				pstmtDCRID.close();
				pstmtDCRID = null;
			}
			//added By Nilesh End::02-06-2017
		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rsDCRID != null)
				{
					rsDCRID.close();
					rsDCRID = null;
				}
				if(pstmtDCRID !=null)
				{
					pstmtDCRID.close();
					pstmtDCRID = null;
				}
			}
			catch(Exception e1){}
		}
		return dcrID;
	}
	//Added by Gulzar on 16-APR-13.END
	//Added By Shahu Mali on 11/04/13 for Request Id [WS3ANOV003].START
	public ArrayList halfDayActivityList( String propName, Connection conn ) throws ITMException
	{
		String propVal = "";
		PreparedStatement pstmtProp = null;
		ResultSet rsProp = null;
		boolean isActivityExist=false;
		ArrayList halfDayActList = new ArrayList();
		try
		{
			String propSql = "SELECT PROP_VALUE FROM PROPERTIES WHERE PROP_NAME = ?";
			pstmtProp = conn.prepareStatement(propSql);
			pstmtProp.setString(1,propName);
			rsProp = pstmtProp.executeQuery();
			if(rsProp.next())
			{
				propVal = (rsProp.getString("PROP_VALUE") == null) ?"":rsProp.getString("PROP_VALUE");
			}
			if(propVal.length() > 0)
			{
				halfDayActList = new ArrayList<String>(Arrays.asList(propVal.split(",")));
			}

		}
		catch(Exception e)
		{
			System.out.println("isActivityCodeExist Catch Exception"+e.getMessage());
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		finally
		{
			try
			{
				if(rsProp != null)
				{
					rsProp.close(); rsProp = null;
				}
				if(pstmtProp != null)
				{
					pstmtProp.close(); pstmtProp = null;
				}
			}
			catch(Exception e)
			{
				System.out.println("Finaly Catch Exception"+e.getMessage());
			}
		}
		//System.out.println("is Activity code exist =["+isActivityExist+"]");

		return 	 halfDayActList;

	}
	//Added By Shahu Mali on 11/04/13 for Request Id [WS3ANOV003].END

	////////////////////////////////////////////////////////////////////

	//Addded by Gaurav Singh on 02-Jun-2015 for Request Id [W15BMIT002].Start
	public String[] getStanCodeFrom( Connection con, String userId, String currDate ) throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String localityCodeFrom = "";
		String overNight = "N";
		java.sql.Timestamp travelDate = null;

		String stanCodeFrom[] = new String[2];
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		boolean isLocalConn = false;

		try
		{
			if(con == null)
			{
				/*ConnDriver connDriver = new ConnDriver();
					con = connDriver.getConnectDB( "DriverITM" );*/
				con = getConnection();//chnged by sachin satre on [11-nov-16] to get connection
				isLocalConn = true;
			}
			//Changed by kailash on 04-03-19 [start]
			String maxTravelDate = "";
			String maxTravelSql = "SELECT MAX(TRAVEL_DATE) AS TRAVEL_DATE FROM SPRS_TRAVEL WHERE SALES_PERS = ? AND TRAVEL_DATE < ?";
			pstmt =  con.prepareStatement(maxTravelSql);
			pstmt.setString(1, userId );
			pstmt.setTimestamp( 2, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString(currDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				maxTravelDate = checkNull(rs.getString("TRAVEL_DATE"));
			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
			String activityType = "";
			/*String sprsTrvSql = "SELECT A.LOCALITY_CODE, A.ACTIVITY_CODE, A.OVER_NIGHT, B.ACTIVITY_TYPE, C.DESCR FROM SPRS_TRAVEL A, FIELDACTIVITY B, LOCALITY C " +
					" WHERE A.ACTIVITY_CODE = B.ACTIVITY_CODE AND A.LOCALITY_CODE = C.LOCALITY_CODE AND A.SALES_PERS = ?  " +
					" AND A.TRAVEL_DATE = (SELECT MAX(TRAVEL_DATE) FROM SPRS_TRAVEL WHERE SALES_PERS = ? AND TRAVEL_DATE < ?) ";

			PreparedStatement pstmtTrv = con.prepareStatement(sprsTrvSql);
			pstmtTrv.setString(1, userId );
			pstmtTrv.setString(2, userId );
			pstmtTrv.setTimestamp( 3, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( currDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
			 */
			if(maxTravelDate != null && maxTravelDate.trim().length() > 0) // added this condtion if travel date is blanck then exception is occured
			{
				String sprsTrvSql = "SELECT A.LOCALITY_CODE, A.ACTIVITY_CODE, A.OVER_NIGHT, B.ACTIVITY_TYPE, C.DESCR FROM SPRS_TRAVEL A, FIELDACTIVITY B, LOCALITY C " +
						" WHERE A.ACTIVITY_CODE = B.ACTIVITY_CODE AND A.LOCALITY_CODE = C.LOCALITY_CODE AND A.SALES_PERS = ?  " +
						" AND A.TRAVEL_DATE = ? ";
				PreparedStatement pstmtTrv = con.prepareStatement(sprsTrvSql);
				pstmtTrv.setString(1, userId );
				pstmtTrv.setTimestamp( 2, java.sql.Timestamp.valueOf(maxTravelDate) );
				ResultSet rsTrv = pstmtTrv.executeQuery();
				//Changed by kailash on 04-03-19 [end]
				if(rsTrv.next())
				{
					localityCodeFrom = (rsTrv.getString("LOCALITY_CODE") == null) ?"":rsTrv.getString("LOCALITY_CODE").trim();
					activityType = (rsTrv.getString("ACTIVITY_TYPE") == null) ?"":rsTrv.getString("ACTIVITY_TYPE").trim();
					//overNight = (rsTrv.getString("OVER_NIGHT") == null) ?"":rsTrv.getString("OVER_NIGHT").trim();
				}
				rsTrv.close(); rsTrv = null;
				pstmtTrv.close(); pstmtTrv = null;

				//if(!("LEAVE".equalsIgnoreCase(activityType) || "NFW".equalsIgnoreCase(activityType)))
				if("FW".equalsIgnoreCase(activityType))
				{
					//Changed by kailash on 04-03-19 [start]
					/*String stanCodeSql = "SELECT ST.LOCALITY_CODE, ST.TRAVEL_DATE FROM  SPRS_TRAVEL ST, LOCALITY LOC "+
							" WHERE ORDER_OF_VISIT = ( SELECT MAX( ORDER_OF_VISIT) "+
							" FROM SPRS_TRAVEL WHERE SALES_PERS= ? AND TRAVEL_DATE =(SELECT MAX(TRAVEL_DATE) FROM SPRS_TRAVEL WHERE SALES_PERS=?  and TRAVEL_DATE < ?) " +
							" AND (DR_VISIT ='Y' OR RETAILER_VISIT ='Y' OR MERCH_VISIT='Y') "+
							") "+
							" AND LOC.LOCALITY_CODE = ST.LOCALITY_CODE "+
							" AND ST.SALES_PERS= ? AND ST.TRAVEL_DATE  =(SELECT MAX(TRAVEL_DATE) FROM SPRS_TRAVEL WHERE SALES_PERS=?  and TRAVEL_DATE < ? )";
					pstmt =  con.prepareStatement(stanCodeSql);
					pstmt.setString(1, userId );
					pstmt.setString(2, userId );
					pstmt.setTimestamp( 3, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( currDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
					pstmt.setString(4, userId );
					pstmt.setString(5, userId );
					pstmt.setTimestamp( 6, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( currDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
					 */
					String stanCodeSql = "SELECT ST.LOCALITY_CODE, ST.TRAVEL_DATE FROM  SPRS_TRAVEL ST, LOCALITY LOC "+
							" WHERE ORDER_OF_VISIT = ( SELECT MAX( ORDER_OF_VISIT) "+
							" FROM SPRS_TRAVEL WHERE SALES_PERS= ? AND TRAVEL_DATE = ? " +
							" AND (DR_VISIT ='Y' OR RETAILER_VISIT ='Y' OR MERCH_VISIT='Y' OR CHEM_VISIT='Y' OR STOCKIST_VISIT='Y' OR OTHER_VISIT='Y') "+
							") "+
							" AND LOC.LOCALITY_CODE = ST.LOCALITY_CODE "+
							" AND ST.SALES_PERS= ? AND ST.TRAVEL_DATE  = ? ";
					pstmt =  con.prepareStatement(stanCodeSql);
					pstmt.setString(1, userId );
					pstmt.setTimestamp( 2, java.sql.Timestamp.valueOf(maxTravelDate) );
					pstmt.setString(3, userId );
					pstmt.setTimestamp( 4, java.sql.Timestamp.valueOf(maxTravelDate) );
					//Changed by kailash on 04-03-19 [end]
					rs = pstmt.executeQuery();

					if(rs.next())
					{
						localityCodeFrom = (rs.getString(1) == null)?"":rs.getString(1).trim();
						travelDate = rs.getTimestamp("TRAVEL_DATE");
					}
					if (rs!= null)
					{
						rs.close();
						rs = null;
					}
					if(pstmt!=null)
					{
						pstmt.close();
						pstmt = null;
					}

				}
			}

			stanCodeFrom[0] = localityCodeFrom;
			stanCodeFrom[1] = overNight;

		}
		catch ( Exception e )
		{
			System.out.println( "Exception :WsfaZuviusDsrMobileWizardEJB :defaultDataWiz :==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(con != null && isLocalConn)
				{
					con.close();
					con = null;
				}
			}
			catch(Exception e1){}
		}
		//System.out.println("localityCodeFrom =["+localityCodeFrom+"], overNight =["+overNight+"]");
		//return localityCodeFrom;
		return stanCodeFrom;
	}

	public String[] getPlaceOfReturnFrom( Connection con, String userId, String eventDate ) throws ITMException
	{
		//System.out.println("getPlaceOfReturnFrom......Called event_date=["+eventDate+"]");
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String  []localityCodeFrom = new String[2];
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		try
		{
			//Added by kailash on 04-03-19 [start]
			String maxTravelDate = "";
			String maxTravelSql = "SELECT MAX(TRAVEL_DATE) AS TRAVEL_DATE FROM SPRS_TRAVEL WHERE SALES_PERS = ? AND TRAVEL_DATE < ?";
			pstmt =  con.prepareStatement(maxTravelSql);
			pstmt.setString(1, userId );
			pstmt.setTimestamp( 2, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString(eventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				maxTravelDate = checkNull(rs.getString("TRAVEL_DATE"));
			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
			//Added by kailash on 04-03-19 [end]
			String activityType = "";
			//Changed by kailash on 04-03-19 [start]
			/*String sprsTrvSql = "SELECT A.LOCALITY_CODE, A.ACTIVITY_CODE, B.ACTIVITY_TYPE, C.DESCR LOC_DESCR FROM SPRS_TRAVEL A, FIELDACTIVITY B, LOCALITY C " +
					" WHERE A.ACTIVITY_CODE = B.ACTIVITY_CODE AND A.LOCALITY_CODE = C.LOCALITY_CODE AND A.SALES_PERS = ?  " +
					" AND A.TRAVEL_DATE = (SELECT MAX(TRAVEL_DATE) FROM SPRS_TRAVEL WHERE SALES_PERS = ? AND TRAVEL_DATE < ? )";

			PreparedStatement pstmtTrv = con.prepareStatement(sprsTrvSql);
			pstmtTrv.setString(1, userId );
			pstmtTrv.setString(2, userId );
			pstmtTrv.setTimestamp( 3, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( eventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
			 */
			String sprsTrvSql = "SELECT A.LOCALITY_CODE, A.ACTIVITY_CODE, B.ACTIVITY_TYPE, C.DESCR LOC_DESCR FROM SPRS_TRAVEL A, FIELDACTIVITY B, LOCALITY C " +
					" WHERE A.ACTIVITY_CODE = B.ACTIVITY_CODE AND A.LOCALITY_CODE = C.LOCALITY_CODE AND A.SALES_PERS = ?  " +
					" AND A.TRAVEL_DATE = ? ";

			PreparedStatement pstmtTrv = con.prepareStatement(sprsTrvSql);
			pstmtTrv.setString(1, userId );
			pstmtTrv.setTimestamp( 2, java.sql.Timestamp.valueOf(maxTravelDate) );
			//Changed by kailash on 04-03-19 [end]
			ResultSet rsTrv = pstmtTrv.executeQuery();
			if(rsTrv.next())
			{
				localityCodeFrom[0] = (rsTrv.getString("LOCALITY_CODE") == null) ?"":rsTrv.getString("LOCALITY_CODE").trim();
				localityCodeFrom[1] = (rsTrv.getString("LOC_DESCR") == null) ?"":rsTrv.getString("LOC_DESCR").trim();
				activityType = (rsTrv.getString("ACTIVITY_TYPE") == null) ?"":rsTrv.getString("ACTIVITY_TYPE").trim();
			}
			rsTrv.close(); rsTrv = null;
			pstmtTrv.close(); pstmtTrv = null;

			//if(!("LEAVE".equalsIgnoreCase(activityType) || "NFW".equalsIgnoreCase(activityType)))//Added & commented by mrunalini sinkar for NFW activity type not found(13-02-2019)
			if("FW".equalsIgnoreCase(activityType))
			{
				//Changed by kailash on 04-03-19 [start]
				/*String stanCodeSql = " SELECT ST.LOCALITY_CODE , LOC.descr FROM  SPRS_TRAVEL ST, LOCALITY LOC "+
						" WHERE LOC.LOCALITY_CODE = ST.LOCALITY_CODE  "+
						" AND  SALES_PERS= ? AND TRAVEL_DATE =(SELECT MAX(TRAVEL_DATE) FROM SPRS_TRAVEL WHERE SALES_PERS=? and TRAVEL_DATE < ? )  "+
						" AND ST.OVER_NIGHT='Y'";
				pstmt =  con.prepareStatement(stanCodeSql);
				pstmt.setString(1, userId );
				pstmt.setString(2, userId );
				pstmt.setTimestamp(3,java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString( eventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat())));*/
				String stanCodeSql = " SELECT ST.LOCALITY_CODE , LOC.descr FROM  SPRS_TRAVEL ST, LOCALITY LOC "+
						" WHERE LOC.LOCALITY_CODE = ST.LOCALITY_CODE  "+
						" AND  SALES_PERS= ? AND TRAVEL_DATE = ? "+
						" AND ST.OVER_NIGHT='Y'";
				pstmt =  con.prepareStatement(stanCodeSql);
				pstmt.setString(1, userId );
				pstmt.setTimestamp(2,java.sql.Timestamp.valueOf(maxTravelDate));
				//Changed by kailash on 04-03-19 [end]
				rs = pstmt.executeQuery();

				if(rs.next())
				{
					localityCodeFrom[0] = rs.getString(1);
					localityCodeFrom[1] = rs.getString(2);

				}

				//System.out.println("getPlaceOfReturnFrom......CalledlocalityCodeFrom[0].."+localityCodeFrom[0]+"localityCodeFrom[1].."+localityCodeFrom[1]);

				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
			}

		}
		catch ( Exception e )
		{
			System.out.println( "Exception :WsfaZuviusDsrMobileWizardEJB :defaultDataWiz :==>\n"+e.getMessage());
			throw new ITMException(e);
		}

		return localityCodeFrom ;
	}

	public String getLastStanCode( String salesPers, String eventDate ) throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String localityCodeFrom = "";
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		Connection conn = null;
		String localityDescr = "";
		String planDataStr="";
		StringBuffer valueXmlString = new StringBuffer();
		java.sql.Timestamp travelDate = null;
		try
		{
			/*ConnDriver connDriver = new ConnDriver();
				conn = connDriver.getConnectDB( "DriverITM" );*/
			conn = getConnection();//chnged by sachin satre on [11-nov-16] to get connection

			valueXmlString = new StringBuffer( "<?xml version=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<editFlag>" );
			valueXmlString.append( "" ).append( "</editFlag>\r\n</Header>\r\n<Errors>\r\n</Errors>\r\n" );
			valueXmlString.append( "<Detail1 domID='1'>\r\n" );

			String activityType = "";
			String overNight = "";

			String remarkStr="";
			String sprsRemark  = "SELECT SP.REMARK AS REMARK"
					+" FROM SPRS_ACT_TRAN SP,FIELDACTIVITY FD WHERE EVENT_DATE=? "
					+" AND SALES_PERS=? AND FD.ACTIVITY_CODE = SP.ACTIVITY_CODE AND FD.ACTIVITY_TYPE <> 'MKTEV'";
			PreparedStatement pstmtRemark = conn.prepareStatement(sprsRemark);

			pstmtRemark.setTimestamp( 1, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( eventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
			pstmtRemark.setString(2, checkNull(salesPers));

			ResultSet rsRemark = pstmtRemark.executeQuery();
			if(rsRemark.next())
			{
				remarkStr = (rsRemark.getString("REMARK") == null) ?"":rsRemark.getString("REMARK").trim();

			}
			rsRemark.close(); rsRemark = null;
			pstmtRemark.close(); pstmtRemark = null;

			//Added by kailash on 04-03-19 [start]
			String maxTravelDate = "";
			String maxTravelSql = "SELECT MAX(TRAVEL_DATE) AS TRAVEL_DATE FROM SPRS_TRAVEL WHERE SALES_PERS = ? AND TRAVEL_DATE < ?";
			pstmt =  conn.prepareStatement(maxTravelSql);
			pstmt.setString(1, salesPers );
			pstmt.setTimestamp( 2, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString(eventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				maxTravelDate = checkNull(rs.getString("TRAVEL_DATE"));
			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}

			/*String sprsTrvSql = "SELECT A.LOCALITY_CODE, A.OVER_NIGHT, B.ACTIVITY_TYPE, C.DESCR LOC_DESCR FROM SPRS_TRAVEL A, FIELDACTIVITY B, LOCALITY C " +
					" WHERE A.ACTIVITY_CODE = B.ACTIVITY_CODE AND A.LOCALITY_CODE = C.LOCALITY_CODE AND A.SALES_PERS = ?  " +
					" AND A.TRAVEL_DATE = (SELECT MAX(TRAVEL_DATE) FROM SPRS_TRAVEL WHERE SALES_PERS = ? AND TRAVEL_DATE < ? )";


			PreparedStatement pstmtTrv = conn.prepareStatement(sprsTrvSql);
			pstmtTrv.setString(1, salesPers );
			pstmtTrv.setString(2, salesPers );
			pstmtTrv.setTimestamp( 3, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( eventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
			 */
			String sprsTrvSql = "SELECT A.LOCALITY_CODE, A.OVER_NIGHT, B.ACTIVITY_TYPE, C.DESCR LOC_DESCR FROM SPRS_TRAVEL A, FIELDACTIVITY B, LOCALITY C " +
					" WHERE A.ACTIVITY_CODE = B.ACTIVITY_CODE AND A.LOCALITY_CODE = C.LOCALITY_CODE AND A.SALES_PERS = ?  " +
					" AND A.TRAVEL_DATE = ? ";
			PreparedStatement pstmtTrv = conn.prepareStatement(sprsTrvSql);
			pstmtTrv.setString(1, salesPers );
			pstmtTrv.setTimestamp( 2, java.sql.Timestamp.valueOf(maxTravelDate) );
			//Added by kailash on 04-03-19 [end]
			ResultSet rsTrv = pstmtTrv.executeQuery();
			if(rsTrv.next())
			{
				localityCodeFrom = (rsTrv.getString("LOCALITY_CODE") == null) ?"":rsTrv.getString("LOCALITY_CODE").trim();
				localityDescr = (rsTrv.getString("LOC_DESCR") == null) ?"":rsTrv.getString("LOC_DESCR").trim();
				activityType = (rsTrv.getString("ACTIVITY_TYPE") == null) ?"":rsTrv.getString("ACTIVITY_TYPE").trim();
				//overNight = (rsTrv.getString("OVER_NIGHT") == null) ?"":rsTrv.getString("OVER_NIGHT").trim();
			}
			rsTrv.close(); rsTrv = null;
			pstmtTrv.close(); pstmtTrv = null;

			//System.out.println("localityCodeFrom=["+localityCodeFrom+"]");
			//if(!("LEAVE".equalsIgnoreCase(activityType) || "NFW".equalsIgnoreCase(activityType)))//Added & commented by mrunalini sinkar for NFW activity type not found(13-02-2019)
			if("FW".equalsIgnoreCase(activityType))
			{

				//Changed by kailash on 04-03-19[start]
				/*String stanCodeSql = "SELECT ST.LOCALITY_CODE AS LOC_CODE, ST.TRAVEL_DATE AS TRAVEL_DATE, LOC.DESCR AS LOC_DESCR FROM  SPRS_TRAVEL ST, LOCALITY LOC "+
						" WHERE ORDER_OF_VISIT = ( SELECT MAX( ORDER_OF_VISIT) "+
						" FROM SPRS_TRAVEL WHERE SALES_PERS= ? AND TRAVEL_DATE =(SELECT MAX(TRAVEL_DATE) FROM SPRS_TRAVEL WHERE SALES_PERS=?  and TRAVEL_DATE < ?) " +
						" AND (DR_VISIT ='Y' OR RETAILER_VISIT ='Y' OR MERCH_VISIT='Y')) "+
						" AND LOC.LOCALITY_CODE = ST.LOCALITY_CODE "+
						" AND ST.SALES_PERS= ? AND ST.TRAVEL_DATE  =(SELECT MAX(TRAVEL_DATE) FROM SPRS_TRAVEL WHERE SALES_PERS=?  and TRAVEL_DATE < ?) ";
				pstmt =  conn.prepareStatement(stanCodeSql);
				pstmt.setString(1, salesPers );
				pstmt.setString(2, salesPers );
				pstmt.setTimestamp( 3, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( eventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
				pstmt.setString(4, salesPers );
				pstmt.setString(5, salesPers );
				pstmt.setTimestamp( 6, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( eventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
				 */
				String stanCodeSql = "SELECT ST.LOCALITY_CODE AS LOC_CODE, ST.TRAVEL_DATE AS TRAVEL_DATE, LOC.DESCR AS LOC_DESCR FROM  SPRS_TRAVEL ST, LOCALITY LOC "+
						" WHERE ORDER_OF_VISIT = ( SELECT MAX( ORDER_OF_VISIT) "+
						" FROM SPRS_TRAVEL WHERE SALES_PERS= ? AND TRAVEL_DATE = ? " +
						" AND (DR_VISIT ='Y' OR RETAILER_VISIT ='Y' OR MERCH_VISIT='Y' OR CHEM_VISIT='Y' OR STOCKIST_VISIT='Y' OR OTHER_VISIT='Y')) "+
						" AND LOC.LOCALITY_CODE = ST.LOCALITY_CODE "+
						" AND ST.SALES_PERS= ? AND ST.TRAVEL_DATE  = ? ";
				pstmt =  conn.prepareStatement(stanCodeSql);
				pstmt.setString(1, salesPers );
				pstmt.setTimestamp( 2, java.sql.Timestamp.valueOf(maxTravelDate) );
				pstmt.setString(3, salesPers );
				pstmt.setTimestamp( 4, java.sql.Timestamp.valueOf(maxTravelDate) );
				//Changed by kailash on 04-03-19[end]
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					localityCodeFrom = (rs.getString("LOC_CODE") == null)?"":rs.getString("LOC_CODE").trim();
					localityDescr = (rs.getString("LOC_DESCR") == null)?"":rs.getString("LOC_DESCR").trim();
					travelDate = rs.getTimestamp("TRAVEL_DATE");
				}
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				valueXmlString.append( "<last_place_of_return><![CDATA[" ).append( localityCodeFrom ).append( "]]></last_place_of_return>\r\n" );
				valueXmlString.append( "<last_place_of_descr_return><![CDATA[" ).append(localityDescr).append( "]]></last_place_of_descr_return>\r\n" );

			}
			else
			{
				valueXmlString.append( "<last_place_of_return><![CDATA[" ).append( localityCodeFrom ).append( "]]></last_place_of_return>\r\n" );
				valueXmlString.append( "<last_place_of_descr_return><![CDATA[" ).append(localityDescr).append( "]]></last_place_of_descr_return>\r\n" );
			}
			valueXmlString.append( "<sprs_route_locality_code><![CDATA[" ).append( localityCodeFrom ).append( "]]></sprs_route_locality_code>\r\n" );
			valueXmlString.append( "<sprs_route_descr><![CDATA[" ).append( localityDescr ).append( "]]></sprs_route_descr>\r\n" );
			valueXmlString.append( "<remark><![CDATA[" ).append( remarkStr ).append( "]]></remark>\r\n" );

			valueXmlString.append("</Detail1>\r\n");
			valueXmlString.append("</Root>\r\n");

		}
		catch ( Exception e )
		{
			System.out.println( "Exception :WsfaZuviusDsrMobileWizardEJB :defaultDataWiz :==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(conn != null )
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception e1){}
		}

		return valueXmlString.toString();
	}
	//public String getExistingTeamDetail( String salePersCode, String eventDate, String custType, Connection conn ) throws ITMException
	public String getExistingTeamDetail( String salePersCode, String eventDate, Connection conn ) throws ITMException
	{
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		int domID= 1;

		String teamData = "";
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		try
		{

			String dcrID = getDCRId(conn,salePersCode, eventDate);

			if(dcrID != null && dcrID.trim().length() > 0)
			{

				String strgCode = "";
				StringBuffer strgCodeBuff = new StringBuffer();
				//String meetSql = "SELECT STRG_CODE FROM STRG_MEET WHERE DCR_ID = ? AND STRG_TYPE = ?";
				String meetSql = "SELECT DISTINCT(STRG_CODE) FROM STRG_MEET WHERE DCR_ID = ? ";
				PreparedStatement pstmtMeet = conn.prepareStatement(meetSql);
				pstmtMeet.setString(1, dcrID);
				//pstmtMeet.setString(2, custType);

				ResultSet rsMeet = pstmtMeet.executeQuery();
				while(rsMeet.next())
				{
					strgCode = checkNull(rsMeet.getString("STRG_CODE"));

					if(strgCodeBuff.length() == 0)
					{
						strgCodeBuff.append("'").append(strgCode.toUpperCase()).append("'");
					}
					else
					{
						strgCodeBuff.append(",'").append(strgCode.toUpperCase()).append("'");
					}
				}
				rsMeet.close(); rsMeet = null;
				pstmtMeet.close(); pstmtMeet = null;

				String strgCodeList = strgCodeBuff.toString();

				if(strgCodeList == null || strgCodeList.trim().length() == 0)
				{
					strgCodeList = "''";
				}

				String smtQuery = "SELECT DISTINCT ST.SALES_PERS,UPPER(EMP.EMP_FNAME) ||' ' ||UPPER(EMP.EMP_MNAME) ||' '|| UPPER(EMP.EMP_LNAME) AS EMP_NAME, EMP.DESIGNATION DESIGNATION FROM STRG_MEET_TEAM ST LEFT OUTER JOIN EMPLOYEE EMP ON ST.SALES_PERS = EMP.EMP_CODE WHERE ST.DCR_ID = ? AND STRG_CODE IN("+strgCodeList+")";

				pstmt = conn.prepareStatement(smtQuery);
				pstmt.setString(1, dcrID);

				rs = pstmt.executeQuery();
				while(rs.next())
				{
					teamData = teamData + checkNull(rs.getString("EMP_NAME")) +" ("+checkNull(rs.getString("SALES_PERS"))+")," ;
				}
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}

				if(teamData.lastIndexOf(",")!= -1)
				{
					teamData = teamData.substring(0, teamData.length()-1);
				}
			}
		}
		catch(Exception e)
		{
			System.out.println( "Exception :WsfaDSRMobileWizardEJB :getExistingTeamDetail:" + e.getMessage() + ":" );
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :WsfaDSRMobileWizardEJB :getExistingTeamDetail :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		//System.out.println("teamData ::"+teamData);
		return teamData;

	}
	public String getDCRId(Connection conn, String salesPers, String dcrDate) throws Exception
	{
		String dcrID = "";
		PreparedStatement pstmtDCRID = null;
		ResultSet rsDCRID = null;
		try
		{
			String activityCode = "";
			E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
			dcrDate = genericUtility.getValidDateTimeString( dcrDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );

			String dcrSql = "SELECT DCR_ID FROM SPRS_ACT_TRAN A, FIELDACTIVITY B WHERE A.ACTIVITY_CODE = B.ACTIVITY_CODE AND A.EVENT_DATE = ? AND A.SALES_PERS = ? AND B.ACTIVITY_TYPE <>'PR'" ;

			pstmtDCRID = conn.prepareStatement( dcrSql );
			pstmtDCRID.setTimestamp(1, java.sql.Timestamp.valueOf(dcrDate));
			pstmtDCRID.setString(2, salesPers);
			rsDCRID = pstmtDCRID.executeQuery();
			if( rsDCRID.next() )
			{
				dcrID = (rsDCRID.getString("DCR_ID") == null )?"":rsDCRID.getString("DCR_ID");
			}

		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rsDCRID != null)
				{
					rsDCRID.close();
					rsDCRID = null;
				}
				if(pstmtDCRID !=null)
				{
					pstmtDCRID.close();
					pstmtDCRID = null;
				}
			}
			catch(Exception e1){}
		}
		//System.out.println("dcrID =["+dcrID+"]");
		return dcrID;
	}

	public String getDSRPlanData(String salesPers,String eventDate,Connection conn) throws ITMException //Chnaged by sachin satre on 11-nov-16
	{
		String returnXmlString="";
		String sprsPlanSql="";
		String planActivity="";
		String planLocality="";
		PreparedStatement sprsPstmt=null;
		ResultSet sprsResultSet= null;
		//Connection conn = null;
		//Commented and Changes Done By Gaurav Singh on 03-Sep-14
		//GenericUtility genericUtility = GenericUtility.getInstance();
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		StringBuffer valueXmlString = new StringBuffer();
		StringBuffer sprsPlanDetail = new StringBuffer();
		int count=0;
		boolean isLocalConn =false;
		try
		{
			if(conn == null)
			{
				/*ConnDriver connDriver = new ConnDriver();
					conn = connDriver.getConnectDB( "DriverITM" );*/
				conn = getConnection();//chnged by sachin satre on [11-nov-16] to get connection
				isLocalConn =true;
			}
			sprsPlanSql=" SELECT A.LOCALITY_CODE, B.ACTIVITY_TYPE  ACTIVITY_TYPE, C.DESCR LOC_DESCR FROM SPRS_PLAN A, FIELDACTIVITY B, LOCALITY C " +
					" WHERE A.PLAN_ACTIVITY = B.ACTIVITY_CODE AND A.LOCALITY_CODE = C.LOCALITY_CODE AND A.SPRS_CODE__PLAN = ? " +
					" AND A.PLAN_DATE = ? ";
			//valueXmlString.append("<table>\r\n");
			sprsPstmt = conn.prepareStatement(sprsPlanSql);
			sprsPstmt.setString(1, salesPers );
			//sprsPstmt.setString(2, salesPers );
			sprsPstmt.setTimestamp( 2, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( eventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
			sprsResultSet = sprsPstmt.executeQuery();
			while(sprsResultSet.next())
			{
				count++;
				planActivity=sprsResultSet.getString("ACTIVITY_TYPE");
				planLocality=sprsResultSet.getString("LOC_DESCR");
				//System.out.println("planActivity=["+planActivity+"],planLocality=["+planLocality+"]");
				valueXmlString.append("<tr>");
				//System.out.println("\n Count =["+count+"]");
				if(count==1)
				{
					valueXmlString.append("<td class=\"td_leftAlign\"><plan_activity>").append(planActivity).append("</plan_activity></td>");
				}
				else
				{
					valueXmlString.append("<td class=\"td_leftAlign\"><plan_activity>").append("").append("</plan_activity></td>");
				}
				valueXmlString.append("<td class=\"td_leftAlign\"><plan_locality>").append(planLocality).append("</plan_locality></td>");
				valueXmlString.append("</tr>");
			}
			//sprsPlanDetail.append("<dsr_plan_data>").append(valueXmlString).append("</dsr_plan_data>\r\n");
			sprsPlanDetail.append("<dsr_plan_data>").append("<![CDATA["+valueXmlString+"]]>").append("</dsr_plan_data>\r\n");
			//valueXmlString.append("</table>\r\n");
			sprsResultSet.close();sprsResultSet=null;
			sprsPstmt.close();sprsPstmt=null;
		}
		catch (Exception e)
		{
			System.out.println("Exception :WsfaDSRMobileWizardEJB:getDSRPlanData()\n"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		finally
		{
			try
			{
				if(sprsResultSet!=null)
				{
					sprsResultSet.close();
					sprsResultSet=null;
				}
				if(sprsPstmt!=null)
				{
					sprsPstmt.close();
					sprsPstmt=null;
				}
				if(isLocalConn && conn!=null)
				{
					conn.close();
					conn=null;
				}

			}
			catch(Exception fe)
			{
				//System.out.println("Exception :WsfaDSRMobileWizardEJB:getDSRPlanData(): finaly block \n"+fe.getMessage());
				fe.printStackTrace();
			}
		}
		returnXmlString=sprsPlanDetail.toString();
		//System.out.println("returnXmlString=["+returnXmlString+"]");

		return returnXmlString;
	}
	/*public String valHoliday(String eventdate, String sprs, String userId, ITMDBAccessLocal itmDBAccessLocal)
	{
		GenericUtility genericUtility = GenericUtility.getInstance();

		String errString = "";
		String columnValue = "";
		String checkSQL = "";
		String childNodeName = "";

		Connection connectionObject = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null ;

		try
		{
			connectionObject = getConnection();
			//Checking Hodiday
			eventdate = genericUtility.getValidDateString( eventdate , getApplDateFormat() , "dd-MMM-yyyy");
			checkSQL = "SELECT CODE FROM PERIOD WHERE ? BETWEEN FR_DATE AND TO_DATE";
			//System.out.println(" sql [" + checkSQL + "]" );
			pstmt = connectionObject.prepareStatement(checkSQL);
			pstmt.setString(1,checkNull(eventdate));
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				String code = rs.getString( "CODE" );
				//changes done by prathamesh jangam for db2 on 06/7/17
				//checkSQL = "SELECT FN_GET_EMP_HOLIDAY(?,?,?,?) HOLDATE FROM DUAL ";
				if("ORACLE".equalsIgnoreCase(CommonConstants.DB_NAME))
				{
					checkSQL = "SELECT DDF_GET_EMP_HOLIDAY(?,?,?,?) HOLDATE FROM DUAL ";
				}
				else if("DB2".equalsIgnoreCase(CommonConstants.DB_NAME))
				{
					checkSQL = "SELECT FN_GET_EMP_HOLIDAY(CAST(? AS CHAR(10)),CAST(? AS CHAR(6)),CAST(? AS CHAR(6)),CAST(? AS TIMESTAMP)) HOLDATE FROM DUAL ";
				}

				System.out.println("sql [" + checkSQL + "] ");

				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				pstmt = connectionObject.prepareStatement(checkSQL);
				pstmt.setString(1,checkNull(sprs));
				pstmt.setString(2,checkNull(code));
				pstmt.setString(3,checkNull(code));
				pstmt.setString(4,checkNull(eventdate));
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					String holDate = rs.getString( 1 );
					//System.out.println(" holDate [" + holDate + "] ");
					if ( holDate != null )
					{
						errString = itmDBAccessLocal.getErrorString("event_date","HOLIDAY",userId);
					}
				}
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}

				if (connectionObject != null)
				{
					connectionObject.close();
					connectionObject=null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return errString;
	}*/
	public String checkSequentialReporting(Connection connectionObject, String salesPers, String dcrDate)throws  ITMException
	{
		boolean isError = false;
		PreparedStatement pstmt = null ;
		ResultSet rs = null ;
		String sql = "";
		PreparedStatement pstmtLastDcr = null;//modified by kailash.
		ResultSet rsLastDcr = null;//modified by kailash.
		String errString = "";
		try
		{
			StrgMeetWizardBean strgMeetWizardBean = new StrgMeetWizardBean();
			SimpleDateFormat sdfFormat = new SimpleDateFormat(getApplDateFormat());

			//GenericUtility genericUtility = GenericUtility.getInstance();
			String dcrDateString = dcrDate;
			dcrDate = genericUtility.getValidDateTimeString( dcrDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );

			//System.out.println("::::salesPers" + salesPers + "::::dcrDate" + dcrDate);
			DateFormat dtFormat = new SimpleDateFormat(getApplDateFormat());
			String dateOfJoin = "";
			java.util.Date date = null;
			Object dateObj = null;
			//added by mruanlini sinkar fro check sequentail reporting only when salesperson REP_CONT_CHK_DAYS value is 0 on 5-april-2019(start)

			int repContChkDays = 0;
			String checkSQL = " SELECT REP_CONT_CHK_DAYS FROM SALES_PERS WHERE SALES_PERS = ? ";
			pstmt = connectionObject.prepareStatement(checkSQL);
			pstmt.setString(1, salesPers);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				repContChkDays = rs.getInt("REP_CONT_CHK_DAYS");
			}
			if (rs != null)
			{
				rs.close();
				rs = null;
			}
			if (pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}

			//added by mruanlini sinkar fro check sequentail reporting only when salesperson REP_CONT_CHK_DAYS value is 0 on 5-april-2019(end)



			String oldLastDCRDate="";
			String oldData=checkNull(getSfaParmValue(salesPers, "OLD_METIS_DAR_DATA", connectionObject));
			String actTrandcrDate = "";
			String lastDCRDate = "";
			String sqlLastDcr = "";
			sqlLastDcr = "SELECT MAX(EVENT_DATE) LAST_DCR_DATE FROM SPRS_ACT_TRAN WHERE SALES_PERS = ?  AND  EVENT_DATE <= ? "+
					"AND ACTIVITY_CODE IN (SELECT ACTIVITY_CODE FROM FIELDACTIVITY WHERE ACTIVITY_TYPE != 'PR')"; // added by condition rupali on 14/03/17 for separate pr menu;;
			pstmt =  connectionObject.prepareStatement(sqlLastDcr);
			pstmt.setString(1, salesPers);
			pstmt.setTimestamp(2, java.sql.Timestamp.valueOf(dcrDate));
			rs = pstmt.executeQuery();

			if(rs.next())
			{

				dateObj =  ((rs.getDate("LAST_DCR_DATE") == null) ?"":rs.getDate("LAST_DCR_DATE"));
				if(dateObj.toString() != null && dateObj.toString().trim().length() > 0)
				{
					date = (Date) dateObj;
					actTrandcrDate = dtFormat.format( date );
				}
				System.out.println("actTrandcrDate =["+actTrandcrDate+"]");
				if("Y".equalsIgnoreCase(oldData) && actTrandcrDate!=null  && actTrandcrDate.trim().length() > 0)
				{

					Object olddateObj = null;
					java.util.Date oldDate = null;
					String oldLastDcr = "SELECT MAX(WORK_DATE) LAST_DCR_DATE FROM DR_MAIN WHERE SALES_PERS = ?  AND  WORK_DATE <= ? "+
							"AND ACTIVITY_CODE IN (SELECT ACTIVITY_CODE FROM FIELDACTIVITY WHERE ACTIVITY_TYPE != 'PR')"; // added by condition rupali on 14/03/17 for separate pr menu;;
					pstmtLastDcr =  connectionObject.prepareStatement(oldLastDcr);
					pstmtLastDcr.setString(1, salesPers);
					pstmtLastDcr.setTimestamp(2, java.sql.Timestamp.valueOf(dcrDate));
					rsLastDcr = pstmtLastDcr.executeQuery();

					if(rsLastDcr.next())
					{

						olddateObj =  ((rsLastDcr.getDate("LAST_DCR_DATE") == null) ?"":rsLastDcr.getDate("LAST_DCR_DATE"));
						if(olddateObj.toString() != null && olddateObj.toString().trim().length() > 0)
						{
							oldDate = (Date) olddateObj;
							oldLastDCRDate = dtFormat.format( oldDate );
						}
					}
					if (rsLastDcr!= null)
					{
						rsLastDcr.close();
						rsLastDcr = null;
					}
					if(pstmtLastDcr!=null)
					{
						pstmtLastDcr.close();
						pstmtLastDcr = null;
					}

					SimpleDateFormat dbFormat = new SimpleDateFormat(genericUtility.getDBDateFormat());
					java.util.Date drMainDate = null;
					java.util.Date actTranDate = null;
					if (oldLastDCRDate != null && oldLastDCRDate.trim().length() > 0)
					{
						drMainDate = sdfFormat.parse(oldLastDCRDate);
					}
					if (actTrandcrDate != null && actTrandcrDate.trim().length() > 0)
					{
						actTranDate = sdfFormat.parse(actTrandcrDate);
					}

					if (drMainDate != null && actTranDate != null )
					{
						if(drMainDate.after(actTranDate))
						{
							lastDCRDate = oldLastDCRDate;
						}
						else
						{
							lastDCRDate = actTrandcrDate;
						}
					}
				}
				else if("Y".equalsIgnoreCase(oldData) && actTrandcrDate.trim().length() == 0)
				{
					Object olddateObj = null;
					java.util.Date oldDate = null;
					String oldLastDcr = "SELECT MAX(WORK_DATE) LAST_DCR_DATE FROM DR_MAIN WHERE SALES_PERS = ?  AND  WORK_DATE <= ? "+
							"AND ACTIVITY_CODE IN (SELECT ACTIVITY_CODE FROM FIELDACTIVITY WHERE ACTIVITY_TYPE != 'PR')"; // added by condition rupali on 14/03/17 for separate pr menu;;
					pstmtLastDcr =  connectionObject.prepareStatement(oldLastDcr);
					pstmtLastDcr.setString(1, salesPers);
					pstmtLastDcr.setTimestamp(2, java.sql.Timestamp.valueOf(dcrDate));
					rsLastDcr = pstmtLastDcr.executeQuery();

					if(rsLastDcr.next())
					{

						olddateObj =  ((rsLastDcr.getDate("LAST_DCR_DATE") == null) ?"":rsLastDcr.getDate("LAST_DCR_DATE"));
						if(olddateObj.toString() != null && olddateObj.toString().trim().length() > 0)
						{
							oldDate = (Date) olddateObj;
							lastDCRDate = dtFormat.format( oldDate );
						}
					}
					if (rsLastDcr!= null)
					{
						rsLastDcr.close();
						rsLastDcr = null;
					}
					if(pstmtLastDcr!=null)
					{
						pstmtLastDcr.close();
						pstmtLastDcr = null;
					}
				}
				else if(!"Y".equalsIgnoreCase(oldData) && actTrandcrDate!=null  && actTrandcrDate.trim().length() > 0)
				{
					lastDCRDate=actTrandcrDate;
				}
				System.out.println("lastDCRDate["+lastDCRDate+"]");

				if(lastDCRDate == null || lastDCRDate.trim().length()==0 || lastDCRDate == "" )
				{
					String sqlDateJoin = "";
					sqlDateJoin = "SELECT DATE_JOIN  FROM EMPLOYEE WHERE EMP_CODE = ? ";
					PreparedStatement pstmtDateJoin = null;
					ResultSet rsDateJoin = null;
					pstmtDateJoin =  connectionObject.prepareStatement(sqlDateJoin);
					pstmtDateJoin.setString(1, salesPers);
					rsDateJoin = pstmtDateJoin.executeQuery();

					java.util.Date dateJoin = null;

					if(rsDateJoin.next())
					{
						dateObj =  ((rsDateJoin.getDate("DATE_JOIN") == null) ?"":rsDateJoin.getDate("DATE_JOIN"));
						if(dateObj.toString()!=null && dateObj.toString().trim().length() > 0)
						{
							date = (Date)dateObj;
							dateJoin = date;
							dateOfJoin = dtFormat.format( date );
						}
						//System.out.println("dateOfJoin =["+dateOfJoin+"]");
					}
					if (rsDateJoin!= null)
					{
						rsDateJoin.close();
						rsDateJoin = null;
					}
					if(pstmtDateJoin!=null)
					{
						pstmtDateJoin.close();
						pstmtDateJoin = null;
					}

					//Changed by Gulzar on 31/08/13 : START
					String applStartDCRDateProp = "";
					java.util.Date applStartDCRDate = null;
					//String propSql = "SELECT PROP_VALUE FROM PROPERTIES WHERE PROP_NAME='APPL_START_DCR'";
					String propSql = "SELECT PROP_VALUE FROM PROPERTIES WHERE PROP_NAME='APPL_START_DAR'";
					PreparedStatement pstmtProp = connectionObject.prepareStatement(propSql);

					ResultSet rsProp = pstmtProp.executeQuery();

					if(rsProp.next())
					{
						applStartDCRDateProp = rsProp.getString("PROP_VALUE");
					}
					//Added by kailash on 05-04-18 for closing resultset and prepare stmt[Start]
					if (rsProp!= null)
					{
						rsProp.close();
						rsProp = null;
					}
					if(pstmtProp!=null)
					{
						pstmtProp.close();
						pstmtProp = null;
					}
					//Added by kailash on 05-04-18 for closing resultset and prepare stmt[End]
					java.util.Date searchDateFrom = dateJoin;

					if(applStartDCRDateProp != null && applStartDCRDateProp.trim().length() > 0)
					{
						try
						{
							/*// added by rupali on 09/11/17 for slving date parsing issue while entering first dcr [start]
							SimpleDateFormat inputFormat=new SimpleDateFormat("dd/MM/yyyy");
							Date eventDate=null;
							eventDate = inputFormat.parse(applStartDCRDateProp);
						    DateFormat sdf = new SimpleDateFormat("dd-MMM-yyyy");
						    applStartDCRDateProp=sdf.format(eventDate);
						    // added by rupali on 09/11/17 for slving date parsing issue while entering first dcr [end]
							 */							applStartDCRDate = sdfFormat.parse(applStartDCRDateProp);

							 if(applStartDCRDate.after(dateJoin))
							 {
								 searchDateFrom = applStartDCRDate;
							 }
						}
						catch(Exception ex)
						{
							errString = getErrorString("event_date","INVDATEFMT","");
							return errString;
						}
					}

					SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getDBDateFormat());

					java.util.Calendar cal = java.util.Calendar.getInstance();

					ArrayList<String> dateArr1 = new ArrayList<String>();

					Date eventDate1 = sdfFormat.parse(dcrDateString);
					cal.setTime( getDateObject( sdfFormat.format( eventDate1 ) ) );
					cal.add( cal.DATE, -1 );
					//sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());//Gulzar on 31/08/13
					String dcrDateString1 = sdfFormat.format(cal.getTime());
					Date eventDate2 = sdfFormat.parse(dcrDateString1);

					if(searchDateFrom.before(eventDate2))
					{
						int diffInDays = (int) Math.round((eventDate2.getTime()-searchDateFrom.getTime()) / (1000 * 60 * 60 * 24) );
						//System.out.println("::::diffInDays" + diffInDays + "::::eventDate1" + eventDate1 +"::::searchDateFrom" + searchDateFrom);
						cal.setTime( getDateObject( sdfFormat.format( searchDateFrom ) ) );

						for(int i=0;i< diffInDays;i++)
						{
							boolean flag1 = false;

							cal.add( cal.DATE, 1 );
							sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
							String newDcrDate = sdf.format(cal.getTime());
							String newDcrDateString = genericUtility.getValidDateTimeString( newDcrDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );
							//Commented by Mrunalini sinkar to make common boolean method of holiday(start)
							//flag1 = validateHoliday( newDcrDateString ,salesPers, salesPers, connectionObject);
							flag1 = strgMeetWizardBean.isEmpHoliday(salesPers, newDcrDateString, connectionObject);
							//Commented by Mrunalini sinkar to make common boolean method of holiday(end)
							if(flag1 == false)
							{
								dateArr1.add(newDcrDate);
							}
						}

						//if(dateArr1 != null && dateArr1.size() > 0)// commented by mrunalini sinkar to add repContChkDays condition
						if(dateArr1 != null && dateArr1.size() > 0 && repContChkDays==0)
						{
							StringBuffer errStringXml = new StringBuffer("<?xml version = \"1.0\"?> \r\n <Root> <Errors>");
							errString = getErrorString("event_date", "PENDDCR", salesPers);
							String bifurErrString = errString.substring(errString.indexOf("<Errors>") + 8, errString.indexOf("<trace>"));
							bifurErrString = bifurErrString + errString.substring(errString.indexOf("</trace>") + 8, errString.indexOf("</Errors>"));
							errStringXml.append(bifurErrString);
							errStringXml.append("</Errors> </Root> \r\n");

							errString =errStringXml.toString();

							String msgDescr = errString.substring(errString.indexOf("<description>")+("<description>").length(),errString.indexOf("</description>"));
							String messageValue = msgDescr.substring(msgDescr.indexOf("<![CDATA[")+("<![CDATA[").length(),msgDescr.indexOf("]")) + dateArr1.toString();  ;
							String messageDescr = errString.substring(errString.indexOf("<message>")+("<message>").length(),errString.indexOf("</message>"));
							String message = messageDescr.substring(messageDescr.indexOf("<![CDATA[")+("<![CDATA[").length(),messageDescr.indexOf("]"));

							errString = "";
							StringBuffer valueXmlErrorString = new StringBuffer( "<?xml version=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<Errors>\r\n" );
							valueXmlErrorString.append("<error id=\"PENDDCR\" type=\"E\" column_name=\"event_date\">");
							valueXmlErrorString.append("<message><![CDATA[").append(message).append("]]></message>\r\n");
							valueXmlErrorString.append("<description><![CDATA[").append(messageValue).append("]]></description>\r\n");
							valueXmlErrorString.append("<type>E</type>\r\n");
							valueXmlErrorString.append("<option></option>\r\n");
							valueXmlErrorString.append("<time></time>\r\n");
							valueXmlErrorString.append("<alarm></alarm>\r\n");
							valueXmlErrorString.append("<source></source>\r\n");
							valueXmlErrorString.append("<trace>Error : NO DATA</trace>\r\n");
							valueXmlErrorString.append("<redirect>1</redirect>\r\n");
							valueXmlErrorString.append("</error>\r\n");
							valueXmlErrorString.append("</Errors>\r\n");
							valueXmlErrorString.append("</Header>\r\n");
							valueXmlErrorString.append( "</Root>\r\n" );
							//System.out.println( "\n****valueXmlErrorString :" + valueXmlErrorString.toString() + ":********" );
							errString =valueXmlErrorString.toString();
							return errString;
						}
					}
					//vishal
					if(rsProp != null)
					{
						rsProp.close(); rsProp = null;
					}
					if(pstmtProp != null)
					{
						pstmtProp.close(); pstmtProp = null;
					}

				}
				else
				{
					SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getDBDateFormat());
					java.util.Calendar cal = java.util.Calendar.getInstance();



					ArrayList<String> dateArr = new ArrayList<String>();
					Date lastDCRDate1 = sdfFormat.parse(lastDCRDate);

					Date eventDate1 = sdfFormat.parse(dcrDateString);
					cal.setTime( getDateObject( sdfFormat.format( eventDate1 ) ) );
					cal.add( cal.DATE, -1 );
					sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
					String dcrDateString1 = sdf.format(cal.getTime());
					Date eventDate2 = sdfFormat.parse(dcrDateString1);
					//System.out.println("eventDate2 =["+eventDate2+"]");

					if(lastDCRDate1.before(eventDate2))
					{
						int diffInDays = (int) Math.round((eventDate2.getTime()-lastDCRDate1.getTime()) / (1000 * 60 * 60 * 24) );
						//System.out.println("::::diffInDays" + diffInDays + "::::eventDate1" + eventDate1 +"::::lastDCRDate1" + lastDCRDate1);
						cal.setTime( getDateObject( sdfFormat.format( lastDCRDate1 ) ) );

						for(int i=0;i< diffInDays;i++)
						{
							boolean flagDCR1 = false;
							cal.add( cal.DATE, 1 );
							sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
							String newDcrDate = sdf.format(cal.getTime());
							String newDcrDateString = genericUtility.getValidDateTimeString( newDcrDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );
							//Commented by Mrunalini sinkar to make common boolean method of holiday(start)
							//flagDCR1 = validateHoliday( newDcrDateString ,salesPers, salesPers, connectionObject);
							flagDCR1 = strgMeetWizardBean.isEmpHoliday(salesPers, newDcrDateString, connectionObject);
							//Commented by Mrunalini sinkar to make common boolean method of holiday(end)

							if(flagDCR1 == false)
							{
								dateArr.add(newDcrDate);
							}
						}

						//if(dateArr != null && dateArr.size() > 0)// commented by mrunalini sinkar to add repContChkDays condition
						if(dateArr != null && dateArr.size() > 0 && repContChkDays == 0)
						{

							StringBuffer errStringXml = new StringBuffer("<?xml version = \"1.0\"?> \r\n <Root> <Errors>");
							errString = getErrorString("event_date", "PENDDCR", salesPers);
							String bifurErrString = errString.substring(errString.indexOf("<Errors>") + 8, errString.indexOf("<trace>"));
							bifurErrString = bifurErrString + errString.substring(errString.indexOf("</trace>") + 8, errString.indexOf("</Errors>"));
							errStringXml.append(bifurErrString);
							errStringXml.append("</Errors> </Root> \r\n");

							errString =errStringXml.toString();

							String msgDescr = errString.substring(errString.indexOf("<description>")+("<description>").length(),errString.indexOf("</description>"));
							String messageValue = msgDescr.substring(msgDescr.indexOf("<![CDATA[")+("<![CDATA[").length(),msgDescr.indexOf("]")) + dateArr.toString();  ;
							String messageDescr = errString.substring(errString.indexOf("<message>")+("<message>").length(),errString.indexOf("</message>"));
							String message = messageDescr.substring(messageDescr.indexOf("<![CDATA[")+("<![CDATA[").length(),messageDescr.indexOf("]"));

							errString = "";
							StringBuffer valueXmlErrorString = new StringBuffer( "<?xml version=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<Errors>\r\n" );
							valueXmlErrorString.append("<error id=\"PENDDCR\" type=\"E\" column_name=\"event_date\">");
							valueXmlErrorString.append("<message><![CDATA[").append(message).append("]]></message>\r\n");
							valueXmlErrorString.append("<description><![CDATA[").append(messageValue).append("]]></description>\r\n");
							valueXmlErrorString.append("<type>E</type>\r\n");
							valueXmlErrorString.append("<option></option>\r\n");
							valueXmlErrorString.append("<time></time>\r\n");
							valueXmlErrorString.append("<alarm></alarm>\r\n");
							valueXmlErrorString.append("<source></source>\r\n");
							valueXmlErrorString.append("<trace>Error : NO DATA</trace>\r\n");
							valueXmlErrorString.append("<redirect>1</redirect>\r\n");
							valueXmlErrorString.append("</error>\r\n");
							valueXmlErrorString.append("</Errors>\r\n");
							valueXmlErrorString.append("</Header>\r\n");
							valueXmlErrorString.append( "</Root>\r\n" );
							//System.out.println( "\n****valueXmlErrorString :" + valueXmlErrorString.toString() + ":********" );
							errString =valueXmlErrorString.toString();
							return errString;
						}
					}
				}
			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		catch(Exception e)
		{
			//System.out.println("Exception in findValue ");
			e.printStackTrace();
			throw new ITMException(e);
		}
		//Added by kailash on 05-04-18 for closing resultset and prepare stmt[Start]
		finally
		{
			try
			{
				if (rsLastDcr!= null)
				{
					rsLastDcr.close();
					rsLastDcr = null;
				}
				if(pstmtLastDcr!=null)
				{
					pstmtLastDcr.close();
					pstmtLastDcr = null;
				}
				//Added by Bhagyashri T  for dirty connection live[11/01/22][Start]
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				//Added by Bhagyashri T  for dirty connection live[11/01/22][End]
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		//Added by kailash on 05-04-18 for closing resultset and prepare stmt[End]
		//System.out.println("checkSequentialReporting >> errString =[" + errString +"]");
		return errString;
	}
	/*private boolean validateHoliday(String eventdate, String sprs, String userId, Connection connectionObject) throws ITMException
	{
		//System.out.println("@@@@@@@@@@@@@@@@@@@valHoliday@@@@@@@@@@@@");
		//GenericUtility genericUtility = GenericUtility.getInstance();

		String errString = "";
		String columnValue = "";
		String checkSQL = "";
		String childNodeName = "";

		PreparedStatement pstmtPeriod = null;
		ResultSet rsPeriod = null ;

		boolean isHoliday = false;

		try
		{

			checkSQL = "SELECT CODE FROM PERIOD WHERE ? BETWEEN FR_DATE AND TO_DATE";
			//System.out.println(" sql [" + checkSQL + "]" );
			pstmtPeriod = connectionObject.prepareStatement(checkSQL);
			pstmtPeriod.setTimestamp(1, java.sql.Timestamp.valueOf(eventdate));
			rsPeriod = pstmtPeriod.executeQuery();

			if(rsPeriod.next())
			{
				String code = rsPeriod.getString( "CODE" );
				String holDate = getEmpHoliday (sprs ,code ,code ,eventdate, connectionObject);
				if ( holDate != null )
				{
					isHoliday = true;
				}
				else
				{
					isHoliday =  false;
				}
			}
			else
			{
				isHoliday =  false;
			}

			if (rsPeriod != null)
			{
				rsPeriod.close();
				rsPeriod = null;
			}
			if(pstmtPeriod !=null)
			{
				pstmtPeriod.close();
				pstmtPeriod = null;
			}

		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018
		}
		finally
		{
			try
			{
				if (rsPeriod != null)
				{
					rsPeriod.close();
					rsPeriod = null;
				}
				if(pstmtPeriod !=null)
				{
					pstmtPeriod.close();
					pstmtPeriod = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return isHoliday;
	}*/

	/*private String getEmpHoliday (String empCode , String prdCodeFr , String prdCodeTo , String date, Connection conn) throws Exception
	{
		String holDate = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try
		{
			String holtblno = getHoltblno(empCode,date, conn);

			String Sql = " SELECT HOL_DATE AS A_HOL_DATE FROM HOLIDAY WHERE HOL_TBLNO = ? AND HOL_DATE = ? ";
			pstmt = conn.prepareStatement(Sql);
			pstmt.setString(1, holtblno);
			pstmt.setTimestamp(2, java.sql.Timestamp.valueOf(date));
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				holDate = rs.getString("A_HOL_DATE");
			}
			//added by mrunalini sinkar (start)
			if (rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt !=null)
			{
				pstmt.close();
				pstmt = null;
			}
			//adde by mrunalini sinkar (end)
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt !=null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		//System.out.println("holDate =["+holDate+"]");
		return holDate;
	}*/

	public String getHoltblno (String emplCode, String eventDate, Connection conn ) throws Exception
	{
		int count = 0;
		int cnt = 0;
		String sql = null;
		String sqlCnt = null;
		String holTblNo = null;
		String sqlTbl = null;
		String sqlTblNo = null;
		PreparedStatement pstmtCount = null;
		ResultSet rsCount = null;
		PreparedStatement pstmtCnt = null;
		ResultSet rsCnt = null;
		PreparedStatement pstmtSet = null;
		ResultSet rsSet = null;
		PreparedStatement pstmtTbl = null;
		ResultSet rsTbl = null;
		PreparedStatement pstmtTblno = null;
		ResultSet rsTblno = null;

		try
		{
			sql = " SELECT COUNT(*) AS COUNT FROM EMP_EMPLOY_EVENTS WHERE EMP_CODE = ? AND CONFIRMED = 'Y'";
			pstmtCount = conn.prepareStatement(sql);
			pstmtCount.setString(1, emplCode);
			rsCount = pstmtCount.executeQuery();

			if(rsCount.next())
			{
				count = rsCount.getInt("COUNT");
			}
			//added by mrunalini sinkar (start)
			if (rsCount != null)
			{
				rsCount.close();
				rsCount = null;
			}
			if(pstmtCount !=null)
			{
				pstmtCount.close();
				pstmtCount = null;
			}
			//adde by mrunalini sinkar (end)
			//System.out.println("EMP_EMPLOY_EVENTS count =["+count+"]");
			if(count > 0 )
			{
				String sql1 = " SELECT COUNT(*) AS COUNT FROM EMP_EMPLOY_EVENTS WHERE EMP_CODE = ? AND EFF_DATE = (SELECT MAX(EFF_DATE) FROM EMP_EMPLOY_EVENTS WHERE EMP_CODE = ? AND CONFIRMED =  'Y'AND EFF_DATE <= ?) AND CONFIRMED = 'Y'";
				pstmtCnt = conn.prepareStatement(sql1);
				pstmtCnt.setString(1, emplCode);
				pstmtCnt.setString(2, emplCode);
				pstmtCnt.setTimestamp(3, java.sql.Timestamp.valueOf(eventDate));

				rsCnt = pstmtCnt.executeQuery();

				if(rsCnt.next())
				{
					cnt = rsCnt.getInt("COUNT");
				}
				//System.out.println("EMP_EMPLOY_EVENTS cnt =["+cnt+"]");
				//added by mrunalini sinkar (start)
				if (rsCnt != null)
				{
					rsCnt.close();
					rsCnt = null;
				}
				if(pstmtCnt !=null)
				{
					pstmtCnt.close();
					pstmtCnt = null;
				}
				//adde by mrunalini sinkar (end)
				if(cnt > 0 )
				{
					sqlCnt = " SELECT AA.HOL_TBLNO__TO AS HOL_TBLNO FROM EMP_EMPLOY_EVENTS AA WHERE AA.EMP_CODE = ? AND AA.CONFIRMED = 'Y' AND AA.TRAN_ID = ( SELECT MAX(BB.TRAN_ID) FROM EMP_EMPLOY_EVENTS BB WHERE BB.EMP_CODE = AA.EMP_CODE AND BB.EFF_DATE = ( SELECT MAX(CC.EFF_DATE) FROM EMP_EMPLOY_EVENTS CC WHERE CC.EMP_CODE = AA.EMP_CODE AND CC.EFF_DATE <= ? AND CC.CONFIRMED = 'Y' ) AND BB.CONFIRMED = 'Y')";
				}
				else
				{
					sqlCnt = " SELECT AA.HOL_TBLNO__FR AS HOL_TBLNO FROM EMP_EMPLOY_EVENTS AA WHERE AA.EMP_CODE = ? AND AA.CONFIRMED = 'Y' AND AA.TRAN_ID = ( SELECT MIN(BB.TRAN_ID) FROM EMP_EMPLOY_EVENTS BB WHERE BB.EMP_CODE = AA.EMP_CODE AND BB.EFF_DATE = ( SELECT MIN(CC.EFF_DATE) FROM EMP_EMPLOY_EVENTS CC WHERE CC.EMP_CODE = AA.EMP_CODE AND CC.EFF_DATE > ? AND CC.CONFIRMED = 'Y' ) AND BB.CONFIRMED = 'Y')";
				}
				pstmtSet = conn.prepareStatement(sqlCnt);
				pstmtSet.setString(1, emplCode);
				pstmtSet.setTimestamp(2, java.sql.Timestamp.valueOf(eventDate));
				rsSet = pstmtSet.executeQuery();
				if(rsSet.next())
				{
					holTblNo = rsSet.getString("HOL_TBLNO");
				}
				//added by mrunalini sinkar (start)
				if (rsSet != null)
				{
					rsSet.close();
					rsSet = null;
				}
				if(pstmtSet !=null)
				{
					pstmtSet.close();
					pstmtSet = null;
				}
				//adde by mrunalini sinkar (end)
			}

			if(holTblNo == null || (holTblNo).trim().length() == 0  )
			{
				String workSite = "";
				sqlTbl = "SELECT HOL_TBLNO, WORK_SITE FROM EMPLOYEE WHERE EMP_CODE = ? ";
				pstmtTbl = conn.prepareStatement(sqlTbl);
				pstmtTbl.setString(1, emplCode);
				rsTbl = pstmtTbl.executeQuery();
				if(rsTbl.next())
				{
					holTblNo = rsTbl.getString("HOL_TBLNO");
					workSite = rsTbl.getString("WORK_SITE");
				}
				//added by mrunalini sinkar (start)
				if (rsTbl != null)
				{
					rsTbl.close();
					rsTbl = null;
				}
				if(pstmtTbl !=null)
				{
					pstmtTbl.close();
					pstmtTbl = null;
				}
				//adde by mrunalini sinkar (end)
				if(holTblNo == null || (holTblNo).trim().length() == 0  )
				{
					sqlTblNo = "SELECT HOL_TBLNO FROM SITE WHERE SITE_CODE = ? ";
					pstmtTblno = conn.prepareStatement(sqlTblNo);
					pstmtTblno.setString(1, workSite);
					rsTblno = pstmtTblno.executeQuery();

					if(rsTblno.next())
					{
						holTblNo = rsTblno.getString("HOL_TBLNO");
					}
					//added by mrunalini sinkar (start)
					if (rsTblno != null)
					{
						rsTblno.close();
						rsTblno = null;
					}
					if(pstmtTblno !=null)
					{
						pstmtTblno.close();
						pstmtTblno = null;
					}
					//adde by mrunalini sinkar (end)
				}
			}
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rsCount != null)
				{
					rsCount.close();
					rsCount = null;
				}
				if(pstmtCount !=null)
				{
					pstmtCount.close();
					pstmtCount = null;
				}
				if (rsCnt != null)
				{
					rsCnt.close();
					rsCnt = null;
				}
				if(pstmtCnt !=null)
				{
					pstmtCnt.close();
					pstmtCnt = null;
				}
				if (rsSet != null)
				{
					rsSet.close();
					rsSet = null;
				}
				if(pstmtSet !=null)
				{
					pstmtSet.close();
					pstmtSet = null;
				}
				if (rsTbl != null)
				{
					rsTbl.close();
					rsTbl = null;
				}
				if(pstmtTbl !=null)
				{
					pstmtTbl.close();
					pstmtTbl = null;
				}
				if (rsTblno != null)
				{
					rsTblno.close();
					rsTblno = null;
				}
				if(pstmtTblno !=null)
				{
					pstmtTblno.close();
					pstmtTblno = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		//System.out.println("holTblNo =["+holTblNo+"]");
		return holTblNo;
	}
	//Addded by Gaurav Singh on 02-Jun-2015 for Request Id [W15BMIT002].End

	// Changed by Rahul on 19-May-2016 [START] to check value of IS_PLAN_COMPULSARY from SFAPARM table
	public String getSfaParmValue(String userId,String paramName,Connection connectionObject) throws ITMException//Chnaged by sachin satre on 11-nov-16
	{
		//Connection connectionObject = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		PreparedStatement pstmt1 = null;//Added by kailash.
		ResultSet rs1 = null;//Added by kailash.
		String empSite="";
		String itemSer="";
		String paramValue="";
		PreparedStatement allPstmt = null;
		ResultSet allRs = null;
		boolean isLocalConn =false;
		try
		{
			//chnged by sachin satre on [11-nov-16] to get connectioni
			if(connectionObject == null)
			{
				/*ConnDriver connDriver = new ConnDriver();
					connectionObject = connDriver.getConnectDB( "DriverValidator" );*/
				connectionObject = getConnection();//chnged by sachin satre on [11-nov-16] to get connectioni
				isLocalConn =true;
			}
			//chnged by sachin satre on [11-nov-16] to get connection
			String sql = "SELECT SITE_CODE__DEF FROM USERS WHERE CODE = ? ";
			pstmt = connectionObject.prepareStatement(sql);
			pstmt.setString(1, userId);

			rs = pstmt.executeQuery();
			if( rs.next() )
			{
				empSite  = checkNull(rs.getString("SITE_CODE__DEF"));
			}
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}

			//System.out.println("value of empSite is::........."+empSite);

			String getSalesPerData = " SELECT SALES_PERS.ITEM_SER,ITEMSER.DESCR FROM ITEMSER LEFT OUTER JOIN SALES_PERS ON ITEMSER.ITEM_SER = SALES_PERS.ITEM_SER "+
					" WHERE  SALES_PERS.SALES_PERS = ? ";

			pstmt = connectionObject.prepareStatement(getSalesPerData);
			pstmt.setString(1, userId);

			rs = pstmt.executeQuery();
			if( rs.next() )
			{
				itemSer  = checkNull(rs.getString("ITEM_SER"));
			}
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}

			sql=" SELECT PARM_VALUE  "+
					" FROM SFAPARM  "+
					" WHERE ORG_UNIT =?  "+
					" AND ACTIVE='Y'  "+
					" AND PARM_NAME= ? ";

			pstmt = connectionObject.prepareStatement(sql);
			pstmt.setString(1, empSite+"_"+itemSer);
			pstmt.setString(2, paramName);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				paramValue  = checkNull(rs.getString(1));
			}
			else
			{
				//System.out.println("inside else");
				pstmt1 = connectionObject.prepareStatement(sql);
				pstmt1.setString(1, itemSer);
				pstmt1.setString(2, paramName);
				rs1 = pstmt1.executeQuery();
				if (rs1.next())
				{
					paramValue  = checkNull(rs1.getString(1));
				}
				//added by mrunalni sinkar on 10-aug-2018(start)
				else
				{
					allPstmt = connectionObject.prepareStatement(sql);
					allPstmt.setString(1, "ALL");
					allPstmt.setString(2, paramName);
					allRs = allPstmt.executeQuery();
					if(allRs.next())
					{
						paramValue  = checkNull( allRs.getString(1) );
					}
				}
				if ( allRs != null )
				{
					allRs.close();
					allRs = null;
				}
				if ( allPstmt != null )
				{
					allPstmt.close();
					allPstmt = null;
				}
				//added by mrunalni sinkar on 10-aug-2018(end)
				//Added by kailash on 05-04-18 for closing resultset and prepare stmt[Start]
				if ( rs1 != null )
				{
					rs1.close();
					rs1 = null;
				}
				if ( pstmt1 != null )
				{
					pstmt1.close();
					pstmt1 = null;
				}
				//Added by kailash on 05-04-18 for closing resultset and prepare stmt[End]
			}
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}

			//System.out.println("value of isPlan is::........."+paramValue);
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		finally
		{
			try
			{
				if ( allRs != null )
				{
					allRs.close();
					allRs = null;
				}
				if ( allPstmt != null )
				{
					allPstmt.close();
					allPstmt = null;
				}
				if ( rs1 != null )
				{
					rs1.close();
					rs1 = null;
				}
				if ( pstmt1 != null )
				{
					pstmt1.close();
					pstmt1 = null;
				}
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				//chnged by sachin satre on [11-nov-16] to get connectioni
				if( isLocalConn && connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
				}
				//chnged by sachin satre on [11-nov-16] to get connectioni
			}
			catch (SQLException e) {
				e.printStackTrace();
			}
		}
		return paramValue;
	}
	// Changed by Rahul on 19-May-2016 [END] to check value of IS_PLAN_COMPULSARY from SFAPARM table
	//Added by Gulzar on 07-Oct-2016 for getting call note types [START]
	/*public String getCallNoteTypes( String xmlString, String xtraParams) throws Exception
		{
			System.out.println("in getCallNoteTypes");
			String listType = "";
			PreparedStatement pstmtNoteType = null;
			ResultSet rsNoteType = null;
			Connection conn = null;

			String noteType = "";
			String descr = "";
			String shDescr = "";
			String colorCode = "";
			JSONObject jsonObj = new JSONObject();
			String jSonKey="";

			try
			{
				JSONObject jsonNoteTypeObj = new JSONObject();
				E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
				Document dom=genericUtility.parseString(xmlString);
				System.out.println("Dom >>>:: "+dom);
				System.out.println("xmlString>>>::"+xmlString);
				jSonKey=genericUtility.getColumnValue("scope_object",dom);
				System.out.println("jSonKey>>>::"+jSonKey);
				if(jSonKey==null && jSonKey.trim().length()==0)
				{
					jSonKey="JSON";
				}

				ConnDriver connDriver = new ConnDriver();
				conn = connDriver.getConnectDB( "DriverITM" );
				conn = getConnection();//chnged by sachin satre on [11-nov-16] to get connection
				String noteTypeSql = "SELECT NOTE_TYPE, DESCR, SH_DESCR, REQ_FOLL_UP, TASK_TYPE, COLOR_CODE FROM CALL_NOTE_TYPE ";
				pstmtNoteType = conn.prepareStatement(noteTypeSql);
				rsNoteType = pstmtNoteType.executeQuery();
				while(rsNoteType.next())
				{
					noteType = checkNull(rsNoteType.getString("NOTE_TYPE"));
					descr = checkNull(rsNoteType.getString("DESCR"));
					shDescr = checkNull(rsNoteType.getString("SH_DESCR"));
					colorCode = checkNull(rsNoteType.getString("COLOR_CODE"));

					jsonNoteTypeObj.put(noteType, shDescr+","+colorCode);

				}
				System.out.println("jSonKey>>>::"+jSonKey);
				jsonObj.put(jSonKey, jsonNoteTypeObj);

				System.out.println("jsonConvertedData ::"+jsonObj.toString());
			}
			catch(Exception e)
			{
				System.out.println("Exception in getcallnotetype ::"+e.getMessage());
				throw e;
			}
			finally
			{
				try
				{
					if(rsNoteType != null)
					{
						rsNoteType.close();
						rsNoteType = null;
					}
					if(pstmtNoteType != null)
					{
						pstmtNoteType.close();
						pstmtNoteType = null;
					}
					if(conn != null)
					{
						conn.close();
						conn = null;
					}
				}
				catch(Exception e)
				{

				}
			}
			return jsonObj.toString();
		}*/
	//Added by Gulzar on 07-Oct-2016 for getting call note types [END]

	public String getPrevFormVal( Document dom, String currentFormNo, ArrayList temp, String colName ) throws ITMException
	{
		//GenericUtility genericUtility = GenericUtility.getInstance();
		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;
		Element elementAttr = null;
		String childNodeName = "";
		String columnValue = "";
		String returnPrevStr = "";
		Document chgPreDom = null;
		try
		{
			chgPreDom = genericUtility.parseString("<Root/>");
			//System.out.println("currentFormNo ["+currentFormNo+"] \n dom["+genericUtility.serializeDom(dom)+"]");
			parentList = dom.getElementsByTagName("Detail" + currentFormNo);
			int parentNodeListLength = parentList.getLength();
			//System.out.println("parentlistlength["+parentNodeListLength+"]");
			for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
			{
				parentNode = parentList.item(prntCtr);
				childList = parentNode.getChildNodes();
				for (int ctr = 0; ctr < childList.getLength(); ctr++)
				{
					childNode = childList.item(ctr);
					if((childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null))
					{
						columnValue = childNode.getFirstChild().getNodeValue().trim();
						//	System.out.println("childNode.getNodeName()["+childNode.getNodeName()+"]columnValue["+columnValue+"]temp["+temp+"] ");
						if ( childNode.getNodeName().equalsIgnoreCase(colName) && temp.contains(columnValue))
						{
							elementAttr = (Element)parentNode;
							if ( parentNode.getAttributes().getNamedItem( "domID" ) != null )
							{
								//Changes By Prajyot On 22-11-2011
								//[ For Items Details to maintain the default domID it is necessary to discard the new domID generation ]
								//elementAttr.setAttribute( "domID" , Integer.toString(domID) );
								elementAttr.setAttribute( "selected" , "Y" );
								domID++;
							}
							Node importedNode = chgPreDom.importNode( parentNode, true );
							chgPreDom.getDocumentElement().appendChild( importedNode );
							break;
						}

					}
				}

			}
			if(currentFormNo.equals("1"))
			{
				domID = 1;
			}
			returnPrevStr = genericUtility.serializeDom(chgPreDom);
			if(returnPrevStr.indexOf("Detail"+currentFormNo) != -1)
			{
				returnPrevStr = returnPrevStr.substring(returnPrevStr.indexOf(">") + 1, returnPrevStr.lastIndexOf("</"));
			}
			returnPrevStr = returnPrevStr.indexOf("Detail"+currentFormNo) != -1 ? returnPrevStr : "";
		}
		catch ( Exception e )
		{
			System.out.println( "Exception :SavexWizardEJB :getPrevFormValues :==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		return returnPrevStr;

	}
	public String getCallNoteTypes( String xmlString, String xtraParams) throws ITMException
	{
		//System.out.println("in getCallNoteTypes");
		String listType = "";
		PreparedStatement pstmtNoteType = null;
		ResultSet rsNoteType = null;
		Connection conn = null;
		String noteType = "";
		String descr = "";
		String shDescr = "";
		String colorCode = "";
		JSONObject jsonObj = new JSONObject();
		String jSonKey="";
		try
		{
			JSONObject jsonNoteTypeObj = new JSONObject();
			E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
			Document dom=genericUtility.parseString(xmlString);
			//System.out.println("Dom >>>:: "+dom);
			//System.out.println("xmlString>>>::"+xmlString);
			jSonKey=genericUtility.getColumnValue("scope_object",dom);
			//System.out.println("jSonKey>>>::"+jSonKey);
			if(jSonKey==null && jSonKey.trim().length()==0)
			{
				jSonKey="JSON";
			}
			/*ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB( "DriverITM" );*/
			conn = getConnection();//chnged by sachin satre on [11-nov-16] to get connection
			String noteTypeSql = "SELECT NOTE_TYPE, DESCR, SH_DESCR, REQ_FOLL_UP, TASK_TYPE, COLOR_CODE FROM CALL_NOTE_TYPE ";
			pstmtNoteType = conn.prepareStatement(noteTypeSql);
			rsNoteType = pstmtNoteType.executeQuery();
			while(rsNoteType.next())
			{
				noteType = checkNull(rsNoteType.getString("NOTE_TYPE"));
				descr = checkNull(rsNoteType.getString("DESCR"));
				shDescr = checkNull(rsNoteType.getString("SH_DESCR"));
				colorCode = checkNull(rsNoteType.getString("COLOR_CODE"));
				jsonNoteTypeObj.put(noteType, shDescr+","+colorCode);
			}
			//added by mrunalini sinkar on 9-april-2018(start)
			if(rsNoteType != null)
			{
				rsNoteType.close();
				rsNoteType = null;
			}
			if(pstmtNoteType != null)
			{
				pstmtNoteType.close();
				pstmtNoteType = null;
			}
			//added by mrunalini sinkar on 9-april-2018(end)
			//System.out.println("jSonKey>>>::"+jSonKey);
			jsonObj.put(jSonKey, jsonNoteTypeObj);
			//System.out.println("jsonConvertedData ::"+jsonObj.toString());
		}
		catch(Exception e)
		{
			System.out.println("Exception in getcallnotetype ::"+e.getMessage());
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018
		}
		finally
		{
			try
			{
				if(rsNoteType != null)
				{
					rsNoteType.close();
					rsNoteType = null;
				}
				if(pstmtNoteType != null)
				{
					pstmtNoteType.close();
					pstmtNoteType = null;
				}
				if(conn != null)
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return jsonObj.toString();
	}
	public String getPrevFormLocValues( Document dom, String currentFormNo, ArrayList temp, String colName, String modeReport, String stockistTable,Connection conn) throws ITMException
	{
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;
		Element elementAttr = null;
		String childNodeName = "";
		String columnValue = "";
		String returnPrevStr = "";
		Document chgPreDom = null;
		String updateFlag = "";

		try
		{

			chgPreDom = genericUtility.parseString("<Root/>");
			//System.out.println("currentFormNo ["+currentFormNo+"]");
			parentList = dom.getElementsByTagName("Detail" + currentFormNo);
			int parentNodeListLength = parentList.getLength();
			String objName = checkNull(getObjNameFromDom(dom, "objName",Integer.parseInt(currentFormNo)));
			String locFormNo = checkNull(getFormNo(objName, "place", conn));
			for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
			{
				boolean isFound = false;
				parentNode = parentList.item(prntCtr);
				childList = parentNode.getChildNodes();
				for (int ctr = 0; ctr < childList.getLength(); ctr++)
				{
					childNode = childList.item(ctr);
					childNodeName =  childNode.getNodeName();

					if((childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null))
					{
						columnValue = childNode.getFirstChild().getNodeValue().trim();
						if ( childNode.getNodeName().equalsIgnoreCase(colName) && temp.contains("'"+columnValue+"'"))
						{
							elementAttr = (Element)parentNode;
							if ( parentNode.getAttributes().getNamedItem( "domID" ) != null )
							{
								isFound = true;
								elementAttr.setAttribute( "selected", "Y" );
								domID++;
							}
							/*Node importedNode = chgPreDom.importNode(parentNode  , true );
							chgPreDom.getDocumentElement().appendChild( importedNode );*/
							break;
						}
					}
					//added by Mrunalini Sinkar To Solve Locality Issue On 31-07-2017(start)
					if(childNodeName.equalsIgnoreCase("attribute"))
					{
						//if(childNode.getAttributes().getNamedItem("updateFlag") != null)
						if(childNode.getAttributes().getNamedItem("updateFlag") != null)
						{
							updateFlag = checkNull(childNode.getAttributes().getNamedItem("updateFlag").getNodeValue());
							//System.out.println("update flag is:"+updateFlag);
						}
					}
				}
				//added by Mrunalini Sinkar To Solve Locality Issue On 31-07-2017(end)
				//System.out.println( "parentNode - ["+ genericUtility.serializeDom( parentNode ) +"]" );

				if( isFound && "E".equalsIgnoreCase(modeReport) )
				{
					String cchgDomStr = genericUtility.serializeDom(parentNode);
					/*if(cchgDomStr.indexOf("<dr_visit>") != -1 && !updateFlag.equalsIgnoreCase("A"))
					{
						cchgDomStr = cchgDomStr.replaceAll("<dr_visit>", "<dr_visit protect='1'>");
					}
					if(cchgDomStr.indexOf("<chem_visit>") != -1 && !updateFlag.equalsIgnoreCase("A"))
					{
						cchgDomStr = cchgDomStr.replaceAll("<chem_visit>", "<chem_visit protect='1'>");
					}
					if(cchgDomStr.indexOf("<stockist_visit>") != -1 && !updateFlag.equalsIgnoreCase("A"))
					{
						cchgDomStr = cchgDomStr.replaceAll("<stockist_visit>", "<stockist_visit protect='1'>");
					}
					if(cchgDomStr.indexOf("<other_visit>") != -1 && !updateFlag.equalsIgnoreCase("A"))
					{
						cchgDomStr = cchgDomStr.replaceAll("<other_visit>", "<other_visit protect='1'>");
					}*/

					Document chgParentDom = genericUtility.parseString(cchgDomStr);
					Node selNode = chgParentDom.getElementsByTagName("Detail"+currentFormNo).item(0);
					Node importedNode = chgPreDom.importNode( selNode, true );
					chgPreDom.getDocumentElement().appendChild( importedNode );
				}
				else if( isFound && !"E".equalsIgnoreCase(modeReport) )
				{
					String locCode = getSelectedRowValue(dom ,locFormNo ,"locality_code",prntCtr);
					String sprsCode = getSelectedRowValue(dom ,""+2 ,"sales_pers",prntCtr);
					String isDrExist = "";
					String isNCWExist = "";
					String isChemExist = "";
					String isStockExist = "";
					if(locCode != null && locCode.trim().length()>0)
					{
						isDrExist = checkCustExist(sprsCode, locCode, "D",stockistTable, conn);
						isChemExist = checkCustExist(sprsCode, locCode, "C",stockistTable, conn);
						isStockExist = checkCustExist(sprsCode, locCode, "S",stockistTable, conn);
						isNCWExist = checkCustExist(sprsCode, locCode, "O",stockistTable, conn);
					}
					//System.out.println("isDrExist 123["+isDrExist+"]isNCWExist123["+isNCWExist);
					//System.out.println("locality["+locCode+"]isNCWAva");
					//System.out.println("Inside drotherif");
					String cchgDomStr = genericUtility.serializeDom(parentNode);
					if(cchgDomStr.indexOf("<dr_visit>") != -1 && isDrExist.equalsIgnoreCase("N"))
					{
						//System.out.println("Inside drvisit");
						cchgDomStr = cchgDomStr.replace("<dr_visit>", "<dr_visit protect='1'>");
					}
					if(cchgDomStr.indexOf("<chem_visit>") != -1 && isChemExist.equalsIgnoreCase("N"))
					{
						//System.out.println("Inside chem_visit");
						cchgDomStr = cchgDomStr.replace("<chem_visit>", "<chem_visit protect='1'>");
					}
					if(cchgDomStr.indexOf("<stockist_visit>") != -1 && isStockExist.equalsIgnoreCase("N"))
					{
						//System.out.println("Inside stockist_visit");
						cchgDomStr = cchgDomStr.replace("<stockist_visit>", "<stockist_visit protect='1'>");
					}
					if(cchgDomStr.indexOf("<other_visit>") != -1 && isNCWExist.equalsIgnoreCase("N"))
					{
						//System.out.println("Inside other_visit");
						cchgDomStr = cchgDomStr.replace("<other_visit>", "<other_visit protect='1'>");
					}
					Document chgParentDom = genericUtility.parseString(cchgDomStr);
					Node selNode = chgParentDom.getElementsByTagName("Detail"+currentFormNo).item(0);
					//System.out.println("Chgpredom value:- "+genericUtility.serializeDom( chgPreDom )+"Node value is:---"+genericUtility.serializeDom( chgParentDom ));
					Node importedNode = chgPreDom.importNode( selNode, true );
					chgPreDom.getDocumentElement().appendChild( importedNode );
				}
			}
			if(currentFormNo.equals("1"))
			{
				domID = 1;
			}
			returnPrevStr = genericUtility.serializeDom(chgPreDom);
			if(returnPrevStr.indexOf("Detail"+currentFormNo) != -1)
			{
				returnPrevStr = returnPrevStr.substring(returnPrevStr.indexOf(">") + 1, returnPrevStr.lastIndexOf("</"));
			}
			returnPrevStr = returnPrevStr.indexOf("Detail"+currentFormNo) != -1 ? returnPrevStr : "";
		}
		catch ( Exception e )
		{
			System.out.println( "Exception :WsfaZuviusDsrMobileWizardEJB :getPrevFormValues :==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		return returnPrevStr;

	}
	//TODO
	//Commented and added by kailash on 28-09-18[start]
	//public String getPrevFormCustValues( Document dom, String currentFormNo, ArrayList temp, String colName,Connection conn) throws ITMException
	public String getPrevFormCustValues( Document dom, String currentFormNo, ArrayList temp, String colName,String unlistCustType,Connection conn) throws ITMException
	//Commented and added by kailash on 28-09-18[end]
	{
		//changed by Rahul Barve on 10-Apr-2015
		//GenericUtility genericUtility = GenericUtility.getInstance();
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;
		Element elementAttr = null;
		String childNodeName = "";
		String columnValue = "";
		String returnPrevStr = "";
		Document chgPreDom = null;

		HashMap locVisitMap = new HashMap();
		String objName = checkNull(getObjNameFromDom(dom, "objName",Integer.parseInt(currentFormNo)));
		String locFormNo = checkNull(getFormNo(objName, "place", conn));
		String retailFormNo = checkNull(getFormNo(objName, "retailer", conn));
		String docFormNo = checkNull(getFormNo(objName, "doctor", conn));
		//Added by Mrunalini Sinkar on 08-may-2017 to show stockist form detail on previous(start)
		String stockistFormNo = checkNull(getFormNo(objName, "stockist", conn));
		String ncwFormNo = checkNull(getFormNo(objName, "ncw", conn));
		//Added by Mrunalini Sinkar on 08-may-2017 to show stockist form detail on previous(end)

		try
		{
			//String drVisit = checkNull(genericUtility.getColumnValue("dr_visit", dom, "3"));
			//String othVisit = checkNull(genericUtility.getColumnValue("other_visit", dom, "3"));

			///////////////////
			System.out.println("inside getPrevFormValues() DAR........");
			parentList = dom.getElementsByTagName("Detail"+locFormNo+"");
			int parentNodeListLength1 = parentList.getLength();
			System.out.println("currentFormNo DAR["+currentFormNo+"]");
			for (int prntCtr = 0; prntCtr < parentNodeListLength1; prntCtr++ )
			{
				ArrayList custVisitList = new ArrayList();
				String localityCode = "";
				String drVisit = "";
				String ncwVisit = "";
				String chemVisit = "";
				String stockVisit = "";
				String chileNodeName = "";
				parentNode = parentList.item(prntCtr);
				childList = parentNode.getChildNodes();
				for (int ctr = 0; ctr < childList.getLength(); ctr++)
				{
					childNode = childList.item(ctr);

					chileNodeName = childNode.getNodeName();

					if ( "locality_code".equalsIgnoreCase(chileNodeName))
					{
						if((childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null))
						{
							localityCode = childNode.getFirstChild().getNodeValue().trim();
						}

					}
					else if ( "dr_visit".equalsIgnoreCase(chileNodeName))
					{
						if((childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null))
						{
							drVisit = childNode.getFirstChild().getNodeValue().trim();
						}

					}
					else if ( "chem_visit".equalsIgnoreCase(chileNodeName))
					{
						if((childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null))
						{
							chemVisit = childNode.getFirstChild().getNodeValue().trim();
						}

					}
					else if ( "stockist_visit".equalsIgnoreCase(chileNodeName))
					{
						if((childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null))
						{
							stockVisit = childNode.getFirstChild().getNodeValue().trim();
						}

					}
					else if ( "other_visit".equalsIgnoreCase(chileNodeName))
					{
						if((childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null))
						{
							ncwVisit = childNode.getFirstChild().getNodeValue().trim();
						}

					}

				}
				custVisitList.add(0, drVisit);
				custVisitList.add(1, ncwVisit);
				custVisitList.add(2, chemVisit);
				custVisitList.add(3, stockVisit);
				custVisitList.add(4, unlistCustType);//added by kailash on 27-09-18.
				locVisitMap.put(localityCode, custVisitList);


			}
			////////////////

			//System.out.println("locVisitMap ::"+locVisitMap);

			String CheckUpdateFlag = "";
			String locColName = "", locColValue = "";
			chgPreDom = genericUtility.parseString("<Root/>");
			//System.out.println("currentFormNo ["+currentFormNo+"]");
			parentList = dom.getElementsByTagName("Detail" + currentFormNo);
			int parentNodeListLength = parentList.getLength();
			for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
			{
				parentNode = parentList.item(prntCtr);
				childList = parentNode.getChildNodes();
				for (int ctr = 0; ctr < childList.getLength(); ctr++)
				{
					childNode = childList.item(ctr);
					if(childNode.getNodeName().equalsIgnoreCase("attribute"))
					{
						if(childNode.getAttributes().getNamedItem("updateFlag") != null)
						{
							CheckUpdateFlag = checkNull(childNode.getAttributes().getNamedItem("updateFlag").getNodeValue());
						}
					}

					if((childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null))
					{
						columnValue = childNode.getFirstChild().getNodeValue().trim();

						//if ( childNode.getNodeName().equalsIgnoreCase(colName) && temp.contains("'"+columnValue+"'"))
						if ( childNode.getNodeName().equalsIgnoreCase(colName) && temp.contains("'"+columnValue+"'") && !"D".equalsIgnoreCase(CheckUpdateFlag))
						{
							ArrayList visitList = (ArrayList)locVisitMap.get(columnValue);
							//Add the condition stockist and ncw to show stockist form detail on previous Mrunalini Sinkar on 08-may-2017
							if(visitList != null && ("Y".equalsIgnoreCase((String)visitList.get(0)) && docFormNo.trim().equalsIgnoreCase(currentFormNo)) || ("Y".equalsIgnoreCase((String)visitList.get(1)) && ncwFormNo.trim().equalsIgnoreCase(currentFormNo) ) || ("Y".equalsIgnoreCase((String)visitList.get(2)) && retailFormNo.equalsIgnoreCase(currentFormNo) ) || ("Y".equalsIgnoreCase((String)visitList.get(3)) && stockistFormNo.trim().equalsIgnoreCase(currentFormNo) )
									|| ("UNLISTED-DOCTOR".equalsIgnoreCase((String)visitList.get(4)) && docFormNo.trim().equalsIgnoreCase(currentFormNo))
									|| (("UNLISTED-RETAILER".equalsIgnoreCase((String)visitList.get(4)) || "UNLISTED-CHEMIST".equalsIgnoreCase((String)visitList.get(4))) && retailFormNo.trim().equalsIgnoreCase(currentFormNo))
									|| ("UNLISTED-STOCKIST".equalsIgnoreCase((String)visitList.get(4)) && stockistFormNo.trim().equalsIgnoreCase(currentFormNo))
									|| ("UNLISTED-OTHER".equalsIgnoreCase((String)visitList.get(4)) && ncwFormNo.trim().equalsIgnoreCase(currentFormNo)))
							{
								elementAttr = (Element)parentNode;
								if ( parentNode.getAttributes().getNamedItem( "domID" ) != null )
								{
									//elementAttr.setAttribute( "domID" , Integer.toString(domID) );
									elementAttr.setAttribute( "selected" , "Y" );
									domID++;
								}
								Node importedNode = chgPreDom.importNode( parentNode, true );
								chgPreDom.getDocumentElement().appendChild( importedNode );
								break;
							}
						}

					}
				}

			}
			if(currentFormNo.equals("1"))
			{
				domID = 1;
			}
			returnPrevStr = genericUtility.serializeDom(chgPreDom);
			if(returnPrevStr.indexOf("Detail"+currentFormNo) != -1)
			{
				returnPrevStr = returnPrevStr.substring(returnPrevStr.indexOf(">") + 1, returnPrevStr.lastIndexOf("</"));
			}
			returnPrevStr = returnPrevStr.indexOf("Detail"+currentFormNo) != -1 ? returnPrevStr : "";
		}
		catch ( Exception e )
		{
			System.out.println( "Exception :WsfaZuviusDsrMobileWizardEJB :getPrevFormValues :==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		System.out.println("returnPrevStr DAR ["+returnPrevStr+"]");
		return returnPrevStr;

	}
	private String checkCustExist(String sprsCode, String locCode, String scType,String stockistTable,Connection connectionObject) throws ITMException
	{
		String custPresent = "Y";
		try
		{
			String selectSql = "";
			int count = 0;
			PreparedStatement pstmt = null;
			ResultSet rSet = null;

			if(scType.equalsIgnoreCase("S") && stockistTable.equalsIgnoreCase("SPRS_STOCKIST"))
			{
				selectSql = "select count(1) as count from sprs_stockist ss,customer cust where cust.locality_Code = ? and ss.sprs_code = ? and ss.cust_code = cust.cust_code and cust.cust_type = ? and ss.status = 'Y'";
			}
			else if(!scType.equalsIgnoreCase("O"))
			{
				selectSql = "select count(1) as count from strg_series ss,strg_customer sc where sc.locality_Code = ? and ss.sales_pers= ? and ss.sc_code = sc.sc_code and sc.cust_type = ? and ss.status = 'Y'";
			}
			else if(scType.equalsIgnoreCase("O"))
			{
				selectSql = "select count(1) as count from strg_series ss,strg_customer sc where sc.locality_Code = ? and ss.sales_pers= ? and ss.sc_code = sc.sc_code and sc.cust_type not in ('D','S','C') and ss.status = 'Y'";
			}
			//System.out.println("selectSql ["+selectSql+"]");

			pstmt = connectionObject.prepareStatement(selectSql);
			pstmt.setString(1,locCode);
			pstmt.setString(2,sprsCode);
			if(!scType.trim().equalsIgnoreCase("O"))
			{
				pstmt.setString(3,scType);
			}
			rSet = pstmt.executeQuery();
			if(rSet.next())
			{
				count = rSet.getInt("count");
			}
			if (rSet!= null)
			{
				rSet.close();
				rSet = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
			//System.out.println("count ["+count+"]");

			if (count <= 0)
			{
				custPresent = "N";
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		return custPresent;
	}
	private String checkCustExistInPlan(String sprsCode,String trvDate, String locCode, String scType,Connection connectionObject) throws ITMException
	{
		String custPresent = "N";
		try
		{
			String selectSql = "";
			int count = 0;
			PreparedStatement pstmt = null;
			ResultSet rSet = null;
			if(trvDate!=null && trvDate.length() > 0) //changes by shraddha M for null pointer exception[12-oct-2020] start
			{
				if(!scType.equalsIgnoreCase("O"))
				{
					selectSql = "SELECT  COUNT(1) COUNT FROM SPRS_PLAN_CUST CUST,SPRS_PLAN_HDR HDR WHERE HDR.PLAN_DATE= ? AND HDR.SPRS_CODE__PLAN= ? AND LOCALITY_CODE = ? AND SC_TYPE = ? AND HDR.PLAN_ID = CUST.PLAN_ID";

				}
				else if(scType.equalsIgnoreCase("O"))
				{
					selectSql = "SELECT  COUNT(1) COUNT FROM SPRS_PLAN_CUST CUST,SPRS_PLAN_HDR HDR WHERE HDR.PLAN_DATE= ? AND HDR.SPRS_CODE__PLAN= ? AND LOCALITY_CODE = ? AND SC_TYPE NOT IN ('D','S','C') AND HDR.PLAN_ID = CUST.PLAN_ID";

				}
				//System.out.println("selectSql ["+selectSql+"]");

				pstmt = connectionObject.prepareStatement(selectSql);
				pstmt.setTimestamp( 1, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( trvDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
				pstmt.setString(2,sprsCode);
				pstmt.setString(3,locCode);
				if(!scType.trim().equalsIgnoreCase("O"))
				{
					pstmt.setString(4,scType);
				}
				rSet = pstmt.executeQuery();
				if(rSet.next())
				{
					count = rSet.getInt("COUNT");
				}
				if (rSet!= null)
				{
					rSet.close();
					rSet = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				//System.out.println("count 454["+count+"]");

				if (count > 0)
				{
					custPresent = "Y";
				}
			} //changes by shraddha M for  null pointer exception[12-oct-2020] end
			
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		return custPresent;
	}
	public String wfValSalesPersAct(Document dom, Document dom2, String currentFormNo, String userId,Connection connectionObject) throws ITMException //chnged by sachin satre on [9-nov-16] to get connection
	{
		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;

		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

		String errString = "";
		String errStringNew = "";
		String checkSQL = "";
		String childNodeName = "";
		String columnValue = "";

		PreparedStatement pstmt = null;
		ResultSet rSet = null ;

		ITMDBAccessEJB itmDBAccessLocal = null;// modified by kailash.
		boolean isLocalConn=false;
		int noOfChilds = 0;
		try
		{

			if(connectionObject == null)
			{
				connectionObject = getConnection();//chnged by sachin satre on [9-nov-16] to get connection
				isLocalConn=true;
			}

			String updateFlag = "";
			AppConnectParm appConnect = new AppConnectParm();
			Properties p = appConnect.getProperty();
			InitialContext ctx = new InitialContext(p);
			//Commented and modified by kailash on 20-07-18 as per gulzar sir[Start]
			//itmDBAccessLocal = (ITMDBAccessLocal)ctx.lookup("ibase/ITMDBAccessEJB/local");
			itmDBAccessLocal = new ITMDBAccessEJB();
			//Commented and modified by kailash on 20-07-18 as per gulzar sir[End]

			parentList = dom.getElementsByTagName("Detail"+ currentFormNo);
			int parentNodeListLength = parentList.getLength();
			//System.out.println("parentNodeListLength["+parentNodeListLength+"]");

			for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
			{
				parentNode = parentList.item(prntCtr);
				childList = parentNode.getChildNodes();
				noOfChilds = childList.getLength();
				for (int ctr = 0; ctr < noOfChilds; ctr++)
				{
					childNode = childList.item(ctr);
					if( childNode.getNodeType() != Node.ELEMENT_NODE )
					{
						continue;
					}

					if ( childNode != null && childNode.getFirstChild() != null )
					{
						columnValue = childNode.getFirstChild().getNodeValue();
					}
					childNodeName = childNode.getNodeName();
					//System.out.println("childNodeName =["+childNodeName+"]");
					if(childNodeName.equalsIgnoreCase("attribute"))
					{
						if(childNode.getAttributes().getNamedItem("updateFlag") != null)
						{
							updateFlag = checkNull(childNode.getAttributes().getNamedItem("updateFlag").getNodeValue());
						}
					}
					if(childNodeName.equalsIgnoreCase("event_date"))
					{
						if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
								( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
						{
							errString = itmDBAccessLocal.getErrorString("event_date","NULLEVTCOD",userId);
							break;
						}
						else //to validate future date and holidays
						{
							SimpleDateFormat sdfFormat = new SimpleDateFormat(getApplDateFormat());
							java.util.Date eventDate = sdfFormat.parse( childNode.getFirstChild().getNodeValue());
							String evtdat=childNode.getFirstChild().getNodeValue();
							//Changed By Vidhya on 09/12/09[WS89NOV647 | date validation for 00/00/00] Start
							if (!sdfFormat.format(eventDate).equals(evtdat))
							{
								errString = itmDBAccessLocal.getErrorString( "event_date", "INVDTFRMT", userId );
								break;
							}
							//Changed By Vidhya on 09/12/09[WS89NOV647 | date validation for 00/00/00] End

							/*if ( ( eventDate.compareTo( getDateObject( sdfFormat.format( new Date() ) ) ) ) > 0 )
							{
								errString = itmDBAccessLocal.getErrorString( "event_date", "FUTUREVENT", userId );
								break;
							}*/


							String salesPers = genericUtility.getColumnValue( "sales_pers" , dom );

							//changed for not allow to edit the DCR once confirmed - Gulzar
							String dcrDate = genericUtility.getColumnValue( "event_date" , dom );

							String confirmed = "";
							dcrDate = genericUtility.getValidDateTimeString( dcrDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );
							String selectSql = "SELECT CONFIRMED FROM SPRS_ACT_TRAN WHERE SALES_PERS = ? AND EVENT_DATE = ?"+
									"AND ACTIVITY_CODE NOT IN (SELECT ACTIVITY_CODE FROM FIELDACTIVITY WHERE ACTIVITY_TYPE ='PR')"; // added by condition rupali on 14/03/17 for separate pr menu
							PreparedStatement pstmtSel = connectionObject.prepareStatement(selectSql);
							pstmtSel.setString(1, salesPers);
							pstmtSel.setTimestamp(2, java.sql.Timestamp.valueOf(dcrDate));
							ResultSet rsSelect = pstmtSel.executeQuery();
							if(rsSelect.next())
							{
								confirmed = (rsSelect.getString("CONFIRMED") == null) ?"":rsSelect.getString("CONFIRMED").trim();
							}
							rsSelect.close(); rsSelect = null;
							pstmtSel.close(); pstmtSel = null;
							if("Y".equalsIgnoreCase(confirmed))
							{
								errString = itmDBAccessLocal.getErrorString( "event_date" , "DCRCONFD" , userId );
								break;
							}


							int allowDays = 0;
							String propName = "MAX_ALLOW_PRD_MEET";//ADDED BY DIPAK FOR DB2
							//checkSQL = "SELECT PROP_VALUE FROM PROPERTIES WHERE PROP_NAME ='MAX_ALLOW_PRD_MEET'";//Commented By Dipak FOR DB2
							checkSQL = "SELECT PROP_VALUE FROM PROPERTIES WHERE PROP_NAME = ? ";//ADDED By Dipak FOR DB2
							pstmt = connectionObject.prepareStatement(checkSQL);
							pstmt.setString(1, propName);//ADDED By Dipak FOR DB2
							rSet = pstmt.executeQuery();//ADDED By Dipak FOR DB2
							if( rSet.next() )
							{
								allowDays = rSet.getInt("PROP_VALUE");
								//System.out.println("allowDays Exist In Properties are ["+allowDays+"]");
								java.util.Calendar cal = java.util.Calendar.getInstance();
								java.util.Date currDate = new java.util.Date();
								cal.setTime( currDate );
								cal.add( cal.DATE, -allowDays );
								if( eventDate.before( cal.getTime() ) )
								{
									errString = itmDBAccessLocal.getErrorString( "event_date" , "XCIDMITLMT" , userId );
									break;
								}
							}
							if (rSet!= null)
							{
								rSet.close();
								rSet = null;
							}
							if(pstmt!=null)
							{
								pstmt.close();
								pstmt = null;
							}

							//for checking Holiday
							String eventdate = childNode.getFirstChild().getNodeValue();

							//changed by kailash pal on 04/04/17:start
							String activityCode = checkNull(genericUtility.getColumnValue( "activity_code" , dom ));
							String activityType = checkNull(genericUtility.getColumnValue( "activity_type" , dom ));
							//System.out.println("before activityCode"+ activityCode);
							//System.out.println("before activity"+ activityType);
							if(activityCode==null || activityCode.length()==0)
							{
								errString = itmDBAccessLocal.getErrorString("activity_code","NULLACTCOD",userId);
								break;
							}

							if(activityType==null || activityType.length()==0)
							{
								String sql= "select activity_type from fieldactivity where activity_code= ?";
								pstmt = connectionObject.prepareStatement(sql);
								pstmt.setString(1, activityCode);
								rSet = pstmt.executeQuery();
								if( rSet.next() )
								{
									activityType= checkNull(rSet.getString("ACTIVITY_TYPE"));
									//System.out.println("In If"+ activityType);
								}
								if (rSet!= null)
								{
									rSet.close();
									rSet = null;
								}
								if(pstmt!=null)
								{
									pstmt.close();
									pstmt = null;
								}

							}
							if( salesPers != null && evtdat != null )
							{
								//added by Rupali on 23/05/17 for defining sfaparam value for sequential reporting[start]
								//commented by mrunalini sinkar 21-feb-18 for sequntial dar adding org unit(start)
								/*String parmValue = "";
								SimpleDateFormat dtFormat = new SimpleDateFormat(genericUtility.getDBDateTimeFormat());
								String currDate = dtFormat.format(new java.util.Date());
								String sfaParmSql = "SELECT PARM_VALUE FROM SFAPARM WHERE PARM_NAME='SEQUENTIAL_DAR' AND ? BETWEEN EFF_FROM AND VALID_UPTO AND ACTIVE='Y' ";
								PreparedStatement pstmtSfaParm = connectionObject.prepareStatement(sfaParmSql);
								pstmtSfaParm.setTimestamp(1, java.sql.Timestamp.valueOf(currDate));
								ResultSet rsSfaParm = pstmtSfaParm.executeQuery();
								if (rsSfaParm.next())
								{
									parmValue = checkNull(rsSfaParm.getString("PARM_VALUE"));
								}
								if(rsSfaParm != null)
								{
									rsSfaParm.close();
									rsSfaParm = null;
								}
								if(pstmtSfaParm != null)
								{
									pstmtSfaParm.close();
									pstmtSfaParm = null;
								}*/
								//commented by mrunalini sinkar 21-feb-18 for sequntial dar adding org unit(end)

								String parmValue = getSfaParmValue(userId,"SEQUENTIAL_DAR",connectionObject); // added by mrunalini sinkar on 21-Feb-2018(start)
								//System.out.println("In 1 If parmValue is :"+ parmValue);
								//added by Rupali on 23/05/17 for defining sfaparam value for sequential reporting[end]
								if(parmValue.equalsIgnoreCase("Y"))
								{
									//	System.out.println("In 2 If parmValue is :"+ parmValue);
									errStringNew = checkSequentialReporting(connectionObject, salesPers, evtdat);
									if(errStringNew != null && errStringNew.indexOf("<Errors>") != -1)
									{
										errString = errStringNew;
										break;
									}
								}
								int actCount = 0;
								String sql= "select activity_type,count(*) as count from fieldactivity where activity_code= ? group by activity_type";
								pstmt = connectionObject.prepareStatement(sql);
								pstmt.setString(1, activityCode);
								rSet = pstmt.executeQuery();
								if( rSet.next() )
								{
									activityType= checkNull(rSet.getString("ACTIVITY_TYPE"));
									actCount = rSet.getInt("count");
									//System.out.println("In If"+ activityType);
								}
								if (rSet!= null)
								{
									rSet.close();
									rSet = null;
								}
								if(pstmt!=null)
								{
									pstmt.close();
									pstmt = null;
								}
								// added by rupali on 10/11/17 for not allowing to enter DAR if 3 DCR are pending to confirm [start]
								//commenetd & Added by mrunalini sinkar for adding Sun Changes on 1-april-2019(start)
								/*String parmVal = "";
								String sfaParmSql = "SELECT PARM_VALUE FROM SFAPARM WHERE PARM_NAME='VALIDATE_UNCONFIRM_DCR' AND ACTIVE='Y' ";
								PreparedStatement pstmtSfaParm = connectionObject.prepareStatement(sfaParmSql);
								ResultSet rsSfaParm = pstmtSfaParm.executeQuery();
								if (rsSfaParm.next())
								{
									parmVal = checkNull(rsSfaParm.getString("PARM_VALUE"));
								}
								if(rsSfaParm != null)
								{
									rsSfaParm.close();
									rsSfaParm = null;
								}
								if(pstmtSfaParm != null)
								{
									pstmtSfaParm.close();
									pstmtSfaParm = null;
								}*/
								int maxUnconfAllow=0;
								String parmVal = getSfaParmValue(userId, "UNCONF_DAR", connectionObject);
								System.out.println("UNCONF_DAR IS["+parmVal+"]");
								if (parmVal.trim().length() > 0)
								{
									try
									{
										maxUnconfAllow = Integer.parseInt(parmVal.trim());
									}
									catch (NumberFormatException ne)
									{
										maxUnconfAllow = 0;
									}
								}
								System.out.println("maxUnconfAllow IS["+maxUnconfAllow+"]");

								//commenetd & Added by mrunalini sinkar for adding Sun Changes on 1-april-2019(end)
								//if(parmVal.equalsIgnoreCase("Y"))
								if(maxUnconfAllow > 0)
								{
									String oldData=checkNull(getSfaParmValue(salesPers, "OLD_METIS_DAR_DATA", connectionObject));

									String unConfDcrDates="";
									int count=0;
									int MeetCount=0;
									String selectConfirmSql = "SELECT DISTINCT EVENT_DATE FROM SPRS_ACT_TRAN  WHERE SALES_PERS = ? " +
											" AND (CASE WHEN CONFIRMED IS NULL THEN 'N' ELSE CONFIRMED END ) <> 'Y'" +
											" AND  EVENT_DATE < ? ORDER BY EVENT_DATE ";
									PreparedStatement pstmtSelect = connectionObject.prepareStatement(selectConfirmSql);
									pstmtSelect.setString(1, salesPers);
									pstmtSelect.setTimestamp(2, java.sql.Timestamp.valueOf(dcrDate));
									ResultSet resultSelect = pstmtSelect.executeQuery();
									while(resultSelect.next())
									{
										MeetCount++;
										String unConfDcrDate = (resultSelect.getString("EVENT_DATE")) == null ?"":resultSelect.getString("EVENT_DATE").trim();
										unConfDcrDate = genericUtility.getValidDateString( unConfDcrDate, genericUtility.getDBDateFormat(),genericUtility.getApplDateFormat() );
										unConfDcrDates += unConfDcrDate+",";

									}
									resultSelect.close(); resultSelect = null;
									pstmtSelect.close(); pstmtSelect = null;
									System.out.println( "Event Dates >>> ["+unConfDcrDates+"] count["+count+"]");
									//if(count >=3)
									if(MeetCount==0 && "Y".equalsIgnoreCase(oldData))
									{
										int drCount=0;
										String oldConfirmSql = "SELECT DISTINCT WORK_DATE FROM DR_MAIN  WHERE SALES_PERS = ? " +
												" AND (CASE WHEN CONFIRMATION_FLAG IS NULL THEN 'N' ELSE CONFIRMATION_FLAG END ) <> 'Y'" +
												" AND  WORK_DATE < ? ORDER BY WORK_DATE ";
										PreparedStatement pstmtOld = connectionObject.prepareStatement(oldConfirmSql);
										pstmtOld.setString(1, salesPers);
										pstmtOld.setTimestamp(2, java.sql.Timestamp.valueOf(dcrDate));
										ResultSet resultSelectOld = pstmtOld.executeQuery();
										while(resultSelectOld.next())
										{
											drCount++;
											String unConfDcrDate = (resultSelectOld.getString("WORK_DATE")) == null ?"":resultSelectOld.getString("WORK_DATE").trim();
											unConfDcrDate = genericUtility.getValidDateString( unConfDcrDate, genericUtility.getDBDateFormat(),genericUtility.getApplDateFormat() );
											unConfDcrDates += unConfDcrDate+",";

										}
										resultSelectOld.close(); resultSelectOld = null;
										pstmtOld.close(); pstmtOld = null;
										count=drCount;
									}
									else
									{
										count=MeetCount;
									}
									if(count >= maxUnconfAllow)
									{
										String message=getMsgDescr("DCRUNCONFD",connectionObject);
										errString = "";
										String messageValue ="\r\n"+message+"\n"+unConfDcrDates;
										StringBuffer valueXmlErrorString = new StringBuffer( "<?xmlversion=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<Errors>\r\n" );
										valueXmlErrorString.append("<error id=\"DCRUNCONFD\" type=\"E\" >");
										valueXmlErrorString.append("<message><![CDATA[").append("").append("]]></message>\r\n");
										valueXmlErrorString.append("<description><![CDATA[").append(messageValue).append("]]></description>\r\n");
										valueXmlErrorString.append("<type>E</type>\r\n");
										valueXmlErrorString.append("<option></option>\r\n");
										valueXmlErrorString.append("<time></time>\r\n");
										valueXmlErrorString.append("<alarm></alarm>\r\n");
										valueXmlErrorString.append("<source></source>\r\n");
										valueXmlErrorString.append("<trace>Error : NO DATA</trace>\r\n");
										valueXmlErrorString.append("<redirect>1</redirect>\r\n");
										valueXmlErrorString.append("</error>\r\n");
										valueXmlErrorString.append("</Errors>\r\n");
										valueXmlErrorString.append("</Header>\r\n");
										valueXmlErrorString.append( "</Root>\r\n" );
										//System.out.println( "\n****valueXmlErrorString :" + valueXmlErrorString.toString() + ":********" );
										errString =valueXmlErrorString.toString();
										return errString;
									}
								}
								// added by rupali on 10/11/17 for not allowing to enter DAR if 3 DCR are pending to confirm [end]
								if(!updateFlag.equalsIgnoreCase("E"))
								{
									errString = valHoliday( evtdat, salesPers, userId, itmDBAccessLocal, connectionObject,"");
								}
								if(errString != null && errString.length()>0 && (errString.indexOf("ERRORS")!=-1 || errString.indexOf("Errors")!=-1))
								{
									//System.out.println("CAME HERE");
									//System.out.println("activity"+ activityType);
									if(actCount == 0)
									{
										errString = itmDBAccessLocal.getErrorString( "activity_code", "ACTNOTFND", userId );
										break;
									}
									if(activityType !=null && activityType.length() > 0 && "LEAVE".equalsIgnoreCase(activityType))
									{
										//System.out.println("Checking leave not allowed");
										errString = itmDBAccessLocal.getErrorString("activity_code","LVENOTALOW",userId);
										break;
									}
									// added by rupali on 28/04/17 for validating wrong activity on holiday[start]
									/*else if(activityType == null && activityType.length() < 0)
									{
										errString = itmDBAccessLocal.getErrorString( "activity_code", "ACTNOTFND", userId );
										break;
									}*/
									// added by rupali on 28/04/17 for validating wrong activity on holiday[end]
									else
									{
										//System.out.println("Checking leave not allowed--- in else");
										if(!updateFlag.equalsIgnoreCase("E"))
										{
											errString = itmDBAccessLocal.getErrorString("event_date","HOLIDAY",userId);
										}
									}

									//System.out.println("Holiday!");
									break;

								}

							}
							//changed by kailash on 04/04/17:End

							//commented by kailash on 04/04/17:Start
							/*if( salesPers != null && eventdate != null )
							{
								// Changed by Rahul on 26-june-2015 [Start] for Sequential Reporting message on Holiday.
								errStringNew = checkSequentialReporting(connectionObject, salesPers, evtdat);
								if(errStringNew != null && errStringNew.indexOf("<Errors>") != -1)
								{
									//System.out.println("Sequential.......:");
									errString = errStringNew;
									break;
								}
								// Changed by Rahul on 26-june-2015 [End] for Sequential Reporting message on Holiday.
								errString = valHoliday( eventdate, salesPers, userId, itmDBAccessLocal, connectionObject );
								if(errString != null && errString.length()>0 && errString.indexOf("Errors")!=-1)
								{
									//System.out.println("Holiday.......:");
									break;

								}

							}
							//Changed By Vidhya on 09/12/09[WS89NOV647 | validation order change] end*/
							//commented by kailash on 04/04/17:End

						}

					}
				}
				if(errString.indexOf("<Errors>")!=-1)
				{
					break;
				}
			}
		}
		catch(Exception e)
		{
			System.out.println ( "Exception :WsfaZuviusDsrWizardEJB :wfValData():" + e.getMessage() + ":" );
			//Commented and added by Dipak 05/11/12
			//errString = generateErrorString(genericUtility.createErrorString(e));
			throw new ITMException(e);
			//End changes by Dipak 05/11/12
		}
		finally
		{
			try
			{
				if (rSet!= null)
				{
					rSet.close();
					rSet = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}

				//chnged by sachin satre on 9-nov-16 [] to get connection from parameter [start]
				if( isLocalConn && connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
				}
				//chnged by sachin satre on 9-nov-16 [] to get connection from parameter [start]
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}

		return errString;
	}

	public String getExistingPitchForDoctor( String salePersCode, String wrkDate, String scCode, String objNameDefault, String callOutcome, String currentFormNo, String formName,Connection connectionObject ) throws ITMException
	{
		//System.out.println("In side getExistingPitchForDoctor.......");
		ResultSet rs = null;
		//Connection connectionObject = null;
		PreparedStatement pstmt = null;
		int domID = 1;
		StringBuffer valueXmlString = new StringBuffer();
		String wrkDateInDbFmt = "", sdQuery = "", pitchDetData ="";
		ResultSet rs1 = null;
		PreparedStatement pstmt1 = null;

		//GenericUtility genericUtility = GenericUtility.getInstance();
		try
		{
			//ConnDriver connDriver = new ConnDriver();
			//connectionObject = connDriver.getConnectDB( "DriverValidator" );
			DateFormat dtFormat = new SimpleDateFormat(getApplDateFormat());
			java.util.Date date = Calendar.getInstance().getTime();
			String currDate = dtFormat.format( date );

			//System.out.println("getExistingPitchForDoctor callOutcome ::["+callOutcome+"]");
			HashMap callOutMap = new HashMap();
			if(callOutcome.contains(",") && callOutcome != null )
			{
				///callOutMap = getExistingCallOutcome( salePersCode,  wrkDate,  scCode, currentFormNo , connectionObject);
				//System.out.println("callOutMap ::==="+callOutMap);
			}
			else
			{
				//System.out.println("callOutcome ::===["+callOutcome+"]");
			}

			////pitchDetData = getCallOutcomePitch(callOutcome, connectionObject);
			//System.out.println("pitchDetData ::["+pitchDetData+"]");

			if ( wrkDate != null )
			{
				//COMMENTED BY PRATHAMESH JANGAM FOR DB2
				//wrkDateInDbFmt = genericUtility.getValidDateString( wrkDate , getApplDateFormat() , "dd-MMM-yyyy");
				//wrkDateInDbFmt = genericUtility.getValidDateString( wrkDate , getApplDateFormat(),getDBDateFormat());
				if("ORACLE".equalsIgnoreCase(CommonConstants.DB_NAME))
				{
					//System.out.println("inside oracle");
					wrkDateInDbFmt = genericUtility.getValidDateString( wrkDate , getApplDateFormat() , "dd-MMM-yyyy");
				}
				else if("DB2".equalsIgnoreCase(CommonConstants.DB_NAME))
				{
					//System.out.println("inside db2");
					wrkDateInDbFmt =  genericUtility.getValidDateTimeString( wrkDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );
				}

				//System.out.println("wrkDateInDbFmt:::::>>>>["+wrkDateInDbFmt+"]");
			}
			//System.out.println(" PITCH :: scCode = ["+scCode+"]");
			if(scCode.contains(","))
			{
				//					sdQuery = " SELECT SB.*, ITEM.DESCR FROM STRG_BRAND_PITCH SB, ITEM ITEM WHERE SB.ITEM_CODE = ITEM.ITEM_CODE " +
				//							  " AND SALES_PERS = '"+salePersCode+"' AND WORK_DATE = '"+wrkDateInDbFmt+"' AND SC_CODE IN ("+getFormattedStringBuff(scCode)+") ";

				sdQuery = " SELECT SB.* FROM STRG_BRAND_PITCH SB WHERE SB.SALES_PERS = '"+salePersCode+"' AND SB.WORK_DATE = '"+wrkDateInDbFmt+"' AND SB.SC_CODE IN ("+scCode+") ";
			}
			else
			{
				//					sdQuery = " SELECT SB.*, ITEM.DESCR FROM STRG_BRAND_PITCH SB, ITEM ITEM WHERE SB.ITEM_CODE = ITEM.ITEM_CODE AND SALES_PERS = '"+salePersCode+"' AND WORK_DATE = '"+wrkDateInDbFmt+"' AND SC_CODE='"+scCode+"' ";

				sdQuery = " SELECT SB.* FROM STRG_BRAND_PITCH SB WHERE SB.SALES_PERS = '"+salePersCode+"' AND SB.WORK_DATE = '"+wrkDateInDbFmt+"' AND SB.SC_CODE= "+scCode+"";
			}
			//System.out.println(" PITCH :: SavexWizardSQL[ ---- >] "+sdQuery);
			pstmt = connectionObject.prepareStatement(sdQuery);
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				//String item = checkNull(rs.getString("DESCR"));
				String brand = checkNull(rs.getString("BRAND_DESCR"));
				String brandCode = checkNull(rs.getString("BRAND_CODE"));
				String pitchDet = checkNull(rs.getString("PITCH_DETAIL"));
				String custCode = checkNull( rs.getString("SC_CODE") );
				//Added by Mrunalini Sinkar for fortune
				String pitchDetDescr ="";
								String pitchDetSql = "SELECT FLD_VALUE AS PITCH_DETAIL, DESCR AS PITCH_DETAIL_DESCR FROM GENCODES WHERE FLD_NAME = 'PITCH_DETAIL' AND MOD_NAME = 'W_WSFA_FORTUNE' "
						+ "AND ACTIVE = 'Y' AND FLD_VALUE=?";
				pstmt1 = connectionObject.prepareStatement(pitchDetSql);
				pstmt1.setString(1,pitchDet);
				rs1 = pstmt1.executeQuery();
				if(rs1.next())
				{
					pitchDetDescr = checkNull(rs1.getString("PITCH_DETAIL_DESCR"));
					System.out.println("PITCH_DETAIL_DESCR is::::::::"+pitchDetDescr);

				}
				if (rs1 != null)
				{
					rs1.close();
					rs1 = null;
				}
				if (pstmt1 != null)
				{
					pstmt1.close();
					pstmt1 = null;
				}

				String callOutExt  = "";
				if( callOutMap.get( custCode.trim() ) != null )
				{
					callOutExt = ( String ) callOutMap.get( custCode.trim() );
					//System.out.println("callOutExt ::::["+callOutExt+"]");
					///pitchDetDescr = getPitchDescr(callOutExt, pitchDet);
					//System.out.println(" pitchDetDescr ::::["+pitchDetDescr+"]");
				}

				//String pitchDetDescr = getPitchDescr(callOutcome, pitchDet);
				//System.out.println("item["+item+"]");
				valueXmlString.append( "<Detail"+currentFormNo+" dbID='' domID='"+ domID +"' objContext='"+currentFormNo+"' objName='"+objNameDefault+"' selected='Y' formName='"+formName+"'>\r\n" );
				//Changed By Bhushan on 06-10-16
				valueXmlString.append("<attribute pkNames='' status='O' updateFlag='E' selected='Y' />\r\n");
				//valueXmlString.append("<attribute pkNames='' status='N' updateFlag='A' selected='Y' />\r\n");

				valueXmlString.append( "<work_date><![CDATA[" ).append(wrkDate).append( "]]></work_date>\r\n" );
				valueXmlString.append( "<sales_pers><![CDATA[").append(checkNull(salePersCode)).append("]]></sales_pers>\n");
				//valueXmlString.append( "<sc_code><![CDATA[").append( checkNull( scCode ) ).append("]]></sc_code>\r\n");
				valueXmlString.append( "<sc_code><![CDATA[").append( checkNull( rs.getString("SC_CODE") ) ).append("]]></sc_code>\r\n");
				valueXmlString.append( "<strg_code><![CDATA[").append( checkNull( rs.getString("SC_CODE") ) ).append("]]></strg_code>\r\n");

				valueXmlString.append( "<brand_code><![CDATA[").append(checkNull(rs.getString("BRAND_CODE"))).append("]]></brand_code>\n");
				valueXmlString.append( "<pitch_detail><![CDATA[").append(checkNull(rs.getString("PITCH_DETAIL"))).append("]]></pitch_detail>\r\n" );
				valueXmlString.append( "<pitch_feedback><![CDATA[]]></pitch_feedback>\r\n" );
				valueXmlString.append( "<pres_pattern><![CDATA[]]></pres_pattern>\r\n" );
				valueXmlString.append( "<remarks><![CDATA[]]></remarks>\r\n" );
				valueXmlString.append( "<line_no><![CDATA["+domID+"]]></line_no>\r\n" );

				valueXmlString.append( "<pitch_sequence><![CDATA[").append(checkNull(rs.getString("PITCH_SEQUENCE"))).append("]]></pitch_sequence>\n");

				valueXmlString.append( "<item_code><![CDATA[").append(checkNull(rs.getString("ITEM_CODE"))).append("]]></item_code>\n");
				//valueXmlString.append( "<item_descr protect =\"1\"><![CDATA[").append(item).append("]]></item_descr>\n");
				valueXmlString.append( "<item_descr protect =\"1\"><![CDATA[").append("").append("]]></item_descr>\n");
				valueXmlString.append( "<brand_descr protect =\"1\"><![CDATA[").append(brand).append("]]></brand_descr>\n");
				valueXmlString.append( "<brand_type><![CDATA[]]></brand_type>\r\n" );
				valueXmlString.append( "<cur_val><![CDATA[]]></cur_val>\r\n" );
				valueXmlString.append( "<cur_nos><![CDATA[]]></cur_nos>\r\n" );
				valueXmlString.append( "<source><![CDATA[]]></source>\r\n" );
				valueXmlString.append( "<pitch_detail_data><![CDATA[" ).append( pitchDetData ).append( "]]></pitch_detail_data>\r\n" );
				//Added By Bhushan on 17-11-16
				valueXmlString.append( "<tran_id><![CDATA[" ).append( checkNull(rs.getString("TRAN_ID")) ).append( "]]></tran_id>\r\n" );
				valueXmlString.append( "<dcr_id><![CDATA[" ).append( checkNull(rs.getString("DCR_ID")) ).append( "]]></dcr_id>\r\n" );
				valueXmlString.append( "<call_outcome_data><![CDATA[" ).append(callOutcome).append( "]]></call_outcome_data>\r\n" );
				valueXmlString.append( "<call_outcome><![CDATA[" ).append(callOutExt).append( "]]></call_outcome>\r\n" );
				valueXmlString.append( "<pitch_detail_descr><![CDATA[" ).append( pitchDetDescr ).append( "]]></pitch_detail_descr>\r\n" );
				valueXmlString.append( "<sc_code_pitch><![CDATA[" ).append( checkNull( rs.getString("SC_CODE") ) ).append( "]]></sc_code_pitch>\r\n" );
				valueXmlString.append( "</Detail"+currentFormNo+">\r\n" );
				domID++;
			}
			if (rs != null)
			{
				rs.close();
				rs = null;
			}
			if (pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		catch(Exception e)
		{
			System.out.println( "Exception :SavexWizardEJB :getExistingPitchForDoctor :" + e.getMessage() + ":" );
			//valueXmlString = valueXmlString.append( genericUtility.createErrorString( e ) );
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		finally
		{
			try
			{
				if (rs !=null )
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}

			}
			catch(Exception e)
			{
				System.out.println( "Exception :SavexWizardEJB :getExistingPitchForDoctor :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		return valueXmlString.toString();

	}
	public String getPitchDetails( String salePersCode, String wrkDate , String copyPlan,String scCode, String localityCode,String xtraParams,String objNameDefault, String callOutcome, String currentFormNo,String formName, Connection connectionObject ) throws ITMException
	{
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		int domID = 1;
		StringBuffer valueXmlString = new StringBuffer();
		String wrkDateInDbFmt = "", pitchDetData ="", brandSql = "";
		//GenericUtility genericUtility = GenericUtility.getInstance();

		try
		{
			System.out.println("inside pitch detail method::"+localityCode);
			DateFormat dtFormat = new SimpleDateFormat(getApplDateFormat());
			java.util.Date date = Calendar.getInstance().getTime();
			String currDate = dtFormat.format( date );
			String itemSer = getProdItmSer(salePersCode, connectionObject);
			//added by mrunalini sinkar for Edetaling changes of real time report(adding contents tag)(start)
			HashMap<String, String> documentMap=new HashMap<String, String>();
			try
			{

				System.out.println("inside pitch detail localitycode::"+localityCode);

				if(localityCode != null)
				{
					localityCode="'"+localityCode+"'";
					if(localityCode.indexOf(",")!= -1)
					{
						localityCode = localityCode.replaceAll(",", "','");
						System.out.println("localityCode is:"+localityCode);
					}
				}
				else
				{
					localityCode="''";
				}
				//Modified by mrunalini sinkar on 27-07-2018 for document list(start)
				//documentMap=getDocumentList(salePersCode,localityCode,connectionObject);
				System.out.println("before methodcall");
				documentMap=getDocumentList(salePersCode,localityCode,copyPlan,scCode,wrkDate,connectionObject);
				//Modified by mrunalini sinkar on 27-07-2018 for document list(end)
			}
			//added by mrunalini sinkar for Edetaling changes of real time report(end)
			catch(Exception e)
			{

			}
			if( "".equalsIgnoreCase( checkNull( salePersCode ) ) )
			{
				salePersCode = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginEmpCode" );
			}
			//	System.out.println("In getPitchDetails:: salePersCode : [" + salePersCode + "] scCode :[" + scCode +"] wrkDate:["+wrkDate+"]");

			if ( wrkDate != null )
			{
				wrkDateInDbFmt = genericUtility.getValidDateString( wrkDate , getApplDateFormat()  , getDBDateFormat() );
			}

			//System.out.println("wrkDateInDbFmt:["+wrkDateInDbFmt+"]");
			String wrkDBDate =  genericUtility.getValidDateTimeString( wrkDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );
			//System.out.println("wrkDBDate:["+wrkDBDate+"]");
			int rsRowCnt = 0;
			boolean isbrandAct = false;
			boolean isbrandPrd = false;
			String brandActCnt = "SELECT COUNT(*) AS COUNT " +
					"FROM STRG_BRAND_ACT SBA, STRG_BRAND_ACT_DET SBD, BRAND BR , PERIOD PR  " +
					"WHERE SBA.TRAN_ID = SBD.TRAN_ID AND SBD.BRAND_CODE = BR.BRAND_CODE  AND SBA.PRD_CODE = PR.CODE " +
					"AND SBA.SALES_PERS = ?  AND SBD.SC_CODE = '"+scCode+"'  " +
					"AND SBA.CONFIRMED = 'Y' AND  ?  BETWEEN PR.FR_DATE AND PR.TO_DATE ";
			// "ORDER BY BR.DESCRIPTION "; commented by prathamesh for db2

			pstmt = connectionObject.prepareStatement(brandActCnt);
			pstmt.setString(1,salePersCode);
			pstmt.setTimestamp( 2, java.sql.Timestamp.valueOf( wrkDBDate ) );
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				rsRowCnt = rs.getInt(1);
				//System.out.println("STRG_BRAND_ACT rsRowCnt:["+rsRowCnt+"]");
				if(rsRowCnt > 0)
				{
					isbrandAct = true;
				}
			}
			if (rs !=null )
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}

			String brandPrdCnt = "SELECT COUNT(*) AS COUNT " +
					"FROM  STRG_PRODUCT SPR , BRAND BR  WHERE SPR.BRAND_CODE = BR.BRAND_CODE " +
					"AND SPR.SALES_PERS = ? AND SPR.SC_CODE = '"+scCode+"'  " +
					"AND ?  BETWEEN SPR.VALID_FROM AND SPR.VALID_TO";
			//ORDER BY BR.DESCRIPTION ";//COMMENTED BY PRATHAMESH JANGAM FOR DB2 TESTING

			pstmt = connectionObject.prepareStatement(brandPrdCnt);
			pstmt.setString(1,salePersCode);
			pstmt.setTimestamp( 2, java.sql.Timestamp.valueOf( wrkDBDate ) );
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				rsRowCnt = rs.getInt(1);
				//System.out.println("STRG_PRODUCT rsRowCnt:["+rsRowCnt+"]");
				if(rsRowCnt > 0)
				{
					isbrandPrd = true;
				}
			}
			if (rs !=null )
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}

			//System.out.println("isbrandAct:["+isbrandAct+"] isbrandPrd:["+isbrandPrd+"]");
			//
			if(isbrandAct)
			{
				brandSql = "SELECT BR.BRAND_CODE, BR.DESCRIPTION ,BR.TAG_LINE,BR.SH_DESCR,SBD.PITCH_PRIORITY " +
						"FROM STRG_BRAND_ACT SBA, STRG_BRAND_ACT_DET SBD, BRAND BR , PERIOD PR  " +
						"WHERE SBA.TRAN_ID = SBD.TRAN_ID AND SBD.BRAND_CODE = BR.BRAND_CODE  AND SBA.PRD_CODE = PR.CODE " +
						"AND SBA.SALES_PERS = ?  AND SBD.SC_CODE = '"+scCode+"'  " +
						"AND SBA.CONFIRMED = 'Y' AND  ?  BETWEEN PR.FR_DATE AND PR.TO_DATE " +
						"ORDER BY BR.PITCH_PRIORITY, BR.DESCRIPTION ";// Changes by Harion S for order sequence as per PITCH_PRIORITY -- 01-Aug-2022
				pstmt = connectionObject.prepareStatement(brandSql);
				pstmt.setString(1,salePersCode);
				pstmt.setTimestamp( 2, java.sql.Timestamp.valueOf( wrkDBDate ) );
			}
			else if(isbrandPrd)
			{

				brandSql = "SELECT BR.BRAND_CODE, BR.DESCRIPTION,BR.TAG_LINE,BR.SH_DESCR , SPR.PITCH_PRIORITY " +
						"FROM  STRG_PRODUCT SPR , BRAND BR  WHERE SPR.BRAND_CODE = BR.BRAND_CODE " +
						"AND SPR.SALES_PERS = ? AND SPR.SC_CODE = '"+scCode+"'  " +
						"AND  ?  BETWEEN SPR.VALID_FROM AND SPR.VALID_TO ORDER BY BR.PITCH_PRIORITY, BR.DESCRIPTION ";// Changes by Harion S for order sequence as per PITCH_PRIORITY -- 01-Aug-2022

				pstmt = connectionObject.prepareStatement(brandSql);
				pstmt.setString(1,salePersCode);
				pstmt.setTimestamp( 2, java.sql.Timestamp.valueOf( wrkDBDate ) );
			}
			else
			{
				System.out.println(" getpitchdetails ::::[]");
				brandSql = " SELECT BRAND.BRAND_CODE, BRAND.DESCRIPTION ,BRAND.TAG_LINE,BRAND.SH_DESCR , BRAND.PITCH_PRIORITY " +
						" FROM BRAND BRAND "+
						" WHERE BRAND.ITEM_SER IN("+itemSer+") ORDER BY BRAND.PITCH_PRIORITY, BRAND.DESCRIPTION ";// Changes by Harion S for order sequence as per PITCH_PRIORITY -- 01-Aug-2022
				pstmt = connectionObject.prepareStatement(brandSql);
//				pstmt.setString(1,salePersCode);
			}
			//Added by kailash on 01-10-18 [start]
			String dcrID = getDCRId(connectionObject,salePersCode, wrkDate);
			//Added by kailash on 01-10-18 [end]
			//System.out.println("getPitchDetails :: brandSql::::=["+brandSql+"]");
			valueXmlString.append( "<Root>\r\n" );

			List<String> brandCodeList = new ArrayList<String>();
			List<String> pitchDetailList = new ArrayList<String>();

			//System.out.println("callOutcome ::["+callOutcome+"]");
			//pitchDetData = getCallOutcomePitch(callOutcome, connectionObject);
			//System.out.println("pitchDetData ::["+pitchDetData+"]");
			String brandCodeVals = "" , pitchDetailVals = "";
			String scCodeExt = "'"+scCode+"'";
			String existingBrand = getExistingPitchForDoctor( salePersCode, wrkDate, scCodeExt, objNameDefault, callOutcome, currentFormNo,formName, connectionObject );

			//System.out.println("existingBrand ::["+existingBrand+"]");
			//Added By Bhushan on 28-11-16 :START
			String brandCodeExt = "", pitchSeqExt="", currDet = "",
					pitchSeq="", pitchDetDescr="", tranId ="",tranIdExt ="", tranIdBrd ="", dcrIdExt ="", dcrIdBrd ="" ,pitchDetExt="",pitchDetDataExt="";
			HashMap pitchMap = new HashMap();
			HashMap pitchMapTranId = new HashMap();
			HashMap pitchDetailMap = new HashMap();
			HashMap PitchDetailDescriptionMap = new HashMap();
			if( existingBrand != null && existingBrand.length() > 0 )
			{
				existingBrand = "<Root>" + existingBrand + "</Root>";
				currDet = "Detail"+currentFormNo;
				//System.out.println(" currDet ::::["+currDet+"]");
				NodeList itemNodeList = ( genericUtility.parseString( existingBrand ) ).getElementsByTagName(currDet);
				int nodeListLen = itemNodeList.getLength();
				for ( int i=0; i < nodeListLen ; i++ )
				{
					NodeList innerNodeList = itemNodeList.item( i ).getChildNodes();
					int innerNodeListLen = innerNodeList.getLength();
					String itemTypeSel = "";
					for ( int j = 0; j < innerNodeListLen; j++ )
					{
						Node currNode = innerNodeList.item( j );

						//System.out.println("COLUMN NAME ["+ currNode.getNodeName()+"] COLUMN VALUE["+currNode.getFirstChild()+"] ");

						if("brand_code".equals( currNode.getNodeName() ))
						{
							if(currNode.getFirstChild() != null)
							{
								brandCodeExt = currNode.getFirstChild().getNodeValue().trim();
								brandCodeList.add( brandCodeExt );
							}
						}
						else if ( "pitch_sequence".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild() != null )
							{
								pitchSeqExt = currNode.getFirstChild().getNodeValue().trim();
							}
						}
						else if ( "tran_id".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild() != null )
							{
								tranIdExt = currNode.getFirstChild().getNodeValue().trim();
							}
						}
						else if ( "dcr_id".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild() != null )
							{
								dcrIdExt = currNode.getFirstChild().getNodeValue().trim();
							}
						}
						else if ( "pitch_detail".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild() != null )
							{
								pitchDetExt = currNode.getFirstChild().getNodeValue().trim();
							}
						}
						else if ( "pitch_detail_descr".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild() != null )
							{
								pitchDetDataExt = currNode.getFirstChild().getNodeValue().trim();
							}
						}

					}
					//	System.out.println(" brandCode["+brandCodeExt+"] pitch_sequence["+pitchSeqExt+"] dcrIdExt["+dcrIdExt+"]" );
					pitchMap.put( brandCodeExt, pitchSeqExt);
					pitchMapTranId.put( brandCodeExt, dcrIdExt);
					pitchDetailMap.put( brandCodeExt, pitchDetExt);
					PitchDetailDescriptionMap.put( brandCodeExt, pitchDetDataExt);




				}
				//System.out.println("existingBrand  pitchMap ::::["+pitchMap+"]");
				//System.out.println("existingBrand  pitchMapTranId :::: "+pitchMapTranId);
			}
			tranId = getPitchTranId(connectionObject);
			//System.out.println("PitchDetails tranId ::::["+tranId+"]");
			//Added By Bhushan on 28-11-16 :END


			rs = pstmt.executeQuery();

			while(rs.next())
			{
				//String item = checkNull(rs.getString("DESCR"));
				String brand = checkNull(rs.getString("DESCRIPTION"));
				String brandCode = checkNull( rs.getString("BRAND_CODE") );
				//added by mrunalini sinkar for show the tag_line into brand sub form
				String tagLine = checkNull(rs.getString("TAG_LINE"));
				String shDescr = checkNull(rs.getString("SH_DESCR"));

				//String itemCode = checkNull( rs.getString("ITEM_CODE") );
				//System.out.println("brandCode :: ["+brandCode+"]" + " Exist brandCodeList :: " + brandCodeList+"");
				pitchSeq="";
				pitchDetDescr="";
				tranIdBrd="";
				dcrIdBrd="";
				String pitchDetBrd="";
				String pitchDetDataBrd="";

				String attachment="";
				if ( brandCodeList.contains( brandCode ) )
				{
					int pos = brandCodeList.indexOf(brandCode);
					//System.out.println("if :: pos["+pos+"]\n");

					if( pitchMap.get( brandCode.trim() ) != null )
					{
						pitchSeq = ( String ) pitchMap.get( brandCode.trim() );
						//System.out.println(" pitchSeq ::::["+pitchSeq+"]");
					}

					if( pitchMapTranId.get( brandCode.trim() ) != null )
					{
						dcrIdBrd = ( String ) pitchMapTranId.get( brandCode.trim() );
						//System.out.println("existing dcrIdBrd ::::["+dcrIdBrd+"]");
					}
										if( pitchDetailMap.get( brandCode.trim() ) != null )
					{
						pitchDetBrd = ( String ) pitchDetailMap.get( brandCode.trim() );
						//System.out.println("existing dcrIdBrd ::::["+dcrIdBrd+"]");
					}
					if( PitchDetailDescriptionMap.get( brandCode.trim() ) != null )
					{
						pitchDetDataBrd = ( String ) PitchDetailDescriptionMap.get( brandCode.trim() );
						//System.out.println("existing dcrIdBrd ::::["+dcrIdBrd+"]");
					}	
					valueXmlString.append("<Detail"+currentFormNo+" dbID='' domID='"+ domID +"' objContext='"+currentFormNo+"' objName='"+objNameDefault+"' selected='Y' formName='"+formName+"'>\r\n" );
					//Changed By Bhushan on 06-10-16
					valueXmlString.append("<attribute pkNames='' status='O' updateFlag='E' selected='Y' />\r\n");
					//valueXmlString.append("<attribute pkNames='' status='N' updateFlag='A' selected='Y' />\r\n");
					valueXmlString.append("<selectbox><![CDATA[").append( "true" ).append("]]></selectbox>\n");
					valueXmlString.append("<work_date><![CDATA[" ).append(wrkDate).append( "]]></work_date>\r\n" );
					valueXmlString.append("<sales_pers><![CDATA[").append(checkNull(salePersCode)).append("]]></sales_pers>\n");
					valueXmlString.append("<sc_code><![CDATA[").append( checkNull( scCode ) ).append("]]></sc_code>\r\n");
					valueXmlString.append("<strg_code><![CDATA[").append( checkNull( scCode ) ).append("]]></strg_code>\r\n");

					valueXmlString.append("<brand_code><![CDATA[").append(checkNull(rs.getString("BRAND_CODE"))).append("]]></brand_code>\n");
					//valueXmlString.append("<pitch_detail><![CDATA[").append( checkNull( pos, pitchDetailList ) ).append("]]></pitch_detail>\r\n" );
					valueXmlString.append("<pitch_detail><![CDATA[").append( checkNull(pitchDetBrd) ).append("]]></pitch_detail>\r\n" );

					valueXmlString.append("<pitch_feedback><![CDATA[]]></pitch_feedback>\r\n" );
					valueXmlString.append("<pres_pattern><![CDATA[]]></pres_pattern>\r\n" );
					valueXmlString.append("<remarks><![CDATA[]]></remarks>\r\n" );
					valueXmlString.append("<line_no><![CDATA["+domID+"]]></line_no>\r\n" );

					valueXmlString.append("<pitch_priority><![CDATA[").append(checkNull(rs.getString("PITCH_PRIORITY"))).append("]]></pitch_priority>\n");
					valueXmlString.append("<pitch_sequence><![CDATA[").append(pitchSeq).append("]]></pitch_sequence>\n");

					valueXmlString.append("<item_code><![CDATA[").append(checkNull(rs.getString("BRAND_CODE"))).append("]]></item_code>\n");
					valueXmlString.append("<item_descr><![CDATA[").append("").append("]]></item_descr>\n");
					valueXmlString.append("<brand_descr><![CDATA[").append(brand).append("]]></brand_descr>\n");
					valueXmlString.append("<brand_type><![CDATA[]]></brand_type>\r\n" );
					valueXmlString.append("<cur_val><![CDATA[]]></cur_val>\r\n" );
					valueXmlString.append("<cur_nos><![CDATA[]]></cur_nos>\r\n" );
					valueXmlString.append("<source><![CDATA[]]></source>\r\n" );
					valueXmlString.append( "<pitch_detail_data><![CDATA[" ).append( pitchDetData ).append( "]]></pitch_detail_data>\r\n" );
					//Added By Bhushan on 17-11-16
					valueXmlString.append( "<tran_id><![CDATA[" ).append( tranId ).append( "]]></tran_id>\r\n" );
					//Commented and modified by kailash on 01-10-18[start]
					//valueXmlString.append( "<dcr_id><![CDATA[" ).append( dcrIdBrd ).append( "]]></dcr_id>\r\n" );
					valueXmlString.append( "<dcr_id><![CDATA[" ).append( dcrID ).append( "]]></dcr_id>\r\n" );
					//Commented and modified by kailash on 01-10-18[ens]
					valueXmlString.append( "<call_outcome_data><![CDATA[" ).append(callOutcome).append( "]]></call_outcome_data>\r\n" );
					valueXmlString.append( "<call_outcome><![CDATA[" ).append(callOutcome).append( "]]></call_outcome>\r\n" );
					valueXmlString.append( "<pitch_detail_descr><![CDATA[" ).append( checkNull(pitchDetDataBrd )).append( "]]></pitch_detail_descr>\r\n" );
					valueXmlString.append( "<sc_code_pitch><![CDATA[" ).append( scCode ).append( "]]></sc_code_pitch>\r\n" );
					//added by mrunalini sinkar for show the tag_line into brand sub form

					valueXmlString.append("<brand_tag_line><![CDATA[").append(tagLine).append("]]></brand_tag_line>\n");
					valueXmlString.append("<brand_sh_descr><![CDATA[").append(shDescr).append("]]></brand_sh_descr>\n");

					valueXmlString.append("</Detail"+currentFormNo+">\r\n" );
				}
				else
				{
					int pos = brandCodeList.indexOf(brandCode);

					valueXmlString.append("<Detail"+currentFormNo+" dbID='' domID='"+ domID +"' objContext='"+currentFormNo+"' objName='"+objNameDefault+"' selected='N' formName='"+formName+"'>\r\n" );
					valueXmlString.append("<attribute pkNames='' status='N' updateFlag='A' selected='N' />\r\n" );
					valueXmlString.append("<work_date><![CDATA[" ).append(wrkDate).append( "]]></work_date>\r\n" );
					valueXmlString.append("<sales_pers><![CDATA[").append(checkNull(salePersCode)).append("]]></sales_pers>\n");
					//Commented By Bhushan on 01-12-16 For All selection issues on previous condition  in Mobile DAR
					//valueXmlString.append("<sc_code><![CDATA[").append( checkNull( scCode ) ).append("]]></sc_code>\r\n");
					valueXmlString.append("<sc_code><![CDATA[").append( scCode ).append("]]></sc_code>\r\n");
					valueXmlString.append("<strg_code><![CDATA[").append( "" ).append("]]></strg_code>\r\n");

					valueXmlString.append("<brand_code><![CDATA[").append(checkNull(rs.getString("BRAND_CODE"))).append("]]></brand_code>\n");
					valueXmlString.append("<pitch_detail><![CDATA[]]></pitch_detail>\r\n" );
					valueXmlString.append("<pitch_feedback><![CDATA[]]></pitch_feedback>\r\n" );
					valueXmlString.append("<pres_pattern><![CDATA[]]></pres_pattern>\r\n" );
					valueXmlString.append("<remarks><![CDATA[]]></remarks>\r\n" );
					valueXmlString.append("<line_no><![CDATA["+domID+"]]></line_no>\r\n" );

					valueXmlString.append("<pitch_priority><![CDATA[").append(checkNull(rs.getString("PITCH_PRIORITY"))).append("]]></pitch_priority>\n");
					valueXmlString.append("<pitch_sequence><![CDATA[").append("").append("]]></pitch_sequence>\n");

					valueXmlString.append("<item_code><![CDATA[").append(checkNull(rs.getString("BRAND_CODE"))).append("]]></item_code>\n");
					valueXmlString.append("<item_descr><![CDATA[").append("").append("]]></item_descr>\n");
					valueXmlString.append("<brand_descr><![CDATA[").append(brand).append("]]></brand_descr>\n");
					valueXmlString.append("<brand_type><![CDATA[]]></brand_type>\r\n" );
					valueXmlString.append("<cur_val><![CDATA[]]></cur_val>\r\n" );
					valueXmlString.append("<cur_nos><![CDATA[]]></cur_nos>\r\n" );
					valueXmlString.append("<source><![CDATA[]]></source>\r\n" );
					valueXmlString.append( "<pitch_detail_data><![CDATA[" ).append( pitchDetData ).append( "]]></pitch_detail_data>\r\n" );
					//Added By Bhushan on 17-11-16
					valueXmlString.append( "<tran_id><![CDATA[" ).append( tranId ).append( "]]></tran_id>\r\n" );
					//Commented and modified by kailash on 01-10-18[start]
					//valueXmlString.append( "<dcr_id><![CDATA[" ).append( "" ).append( "]]></dcr_id>\r\n" );
					valueXmlString.append( "<dcr_id><![CDATA[" ).append(dcrID).append( "]]></dcr_id>\r\n" );
					//Commented and modified by kailash on 01-10-18[end]
					valueXmlString.append( "<call_outcome_data><![CDATA[" ).append(callOutcome).append( "]]></call_outcome_data>\r\n" );
					valueXmlString.append( "<call_outcome><![CDATA[" ).append(callOutcome).append( "]]></call_outcome>\r\n" );
					valueXmlString.append( "<pitch_detail_descr><![CDATA[" ).append( "" ).append( "]]></pitch_detail_descr>\r\n" );
					valueXmlString.append( "<sc_code_pitch><![CDATA[" ).append( scCode ).append( "]]></sc_code_pitch>\r\n" );
					//added by mrunalini sinkar for show the tag_line into brand sub form

					valueXmlString.append("<brand_tag_line><![CDATA[").append(tagLine).append("]]></brand_tag_line>\n");
					valueXmlString.append("<brand_sh_descr><![CDATA[").append(shDescr).append("]]></brand_sh_descr>\n");

					//added by mrunalini sinkar for Edetaling changes of real time report(adding contents tag)(start)
					//if(documentMap!=null && !documentMap.isEmpty() && documentMap.containsValue(brandCode))
					if(documentMap!=null && !documentMap.isEmpty() && (documentMap.containsValue(brandCode) || documentMap.containsValue("STRG_CODE")))
					{
						System.out.println("14107");
						
						for (Entry<String, String> documentEntry: documentMap.entrySet())
						{
							System.out.println("documentEntry.getValue()::"+documentEntry.getValue()+" brandCode:"+brandCode);
							
							if(brandCode.equals(documentEntry.getValue()) || "STRG_CODE".equalsIgnoreCase(documentEntry.getValue()))
							{
								String documentKey=documentEntry.getKey();
								System.out.println("docuemnet key:"+documentKey);
								String docPageInfo = "";
								String [] splitMapKey=documentKey.split("@");
								System.out.println("splitMapKey:"+splitMapKey);
								
								String docId=checkNull(splitMapKey[0]);
								String docName=checkNull(splitMapKey[1]);
								//String docRefId=checkNull(splitMapKey[3]);
								if(splitMapKey[3].trim().length()>0)
								{
									docPageInfo = checkNull(splitMapKey[3]); //commented and added by rupali on 30/07/18 for adding page_info in contents
								}
								String docRefId=checkNull(splitMapKey[4]);
								
								System.out.println("brandCode is:"+brandCode+"Attachment is:"+attachment);
								if(attachment==null || attachment.trim().length()==0)
								{
									//commented and added by rupali on 30/07/18 for adding page_info in contents [start]
									//attachment=docId + "::" +docName + ",";
									// attachment=docId + "::" +docName + "::" +docPageInfo +",";
									System.out.println("lin2 14136: "+attachment);
									
									attachment = docId + "::" + docName + "::" + docPageInfo + "~SEP~";
									//commented and added by rupali on 30/07/18 for adding page_info in contents [end]
								}
								else
								{
									//commented and added by rupali on 30/07/18 for adding page_info in contents [start]
									//attachment=attachment+docId + "::" +docName + ",";
									// attachment=attachment+docId + "::" +docName + "::" +docPageInfo +",";
									attachment = attachment + docId + "::" + docName + "::" + docPageInfo + "~SEP~";
									System.out.println("lin2 14148: "+attachment);
									//commented and added by rupali on 30/07/18 for adding page_info in contents [end]

								}
								//System.out.println("Attachment iss:"+attachment);

							}

						}
						System.out.println("line 14158::"+attachment);
						
						// if(attachment != null && attachment.length() > 0 && attachment.charAt(attachment.length() - 1) == ',')
						if(attachment != null && attachment.length() > 0 && attachment.endsWith("~SEP~"))
						{
							attachment = attachment.substring(0, attachment.length() - 5);
							System.out.println("Attachment scCode is:"+attachment+"sccode is:"+scCode);
						}

						valueXmlString.append("<contents><![CDATA[").append(attachment).append("]]></contents>\n");
					}
					else
					{
						System.out.println("line 14170");
						
						valueXmlString.append("<contents><![CDATA[").append("").append("]]></contents>\n");
					}
					//added by mrunalini sinkar for Edetaling changes of real time report(adding contents tag)(end)
					valueXmlString.append("</Detail"+currentFormNo+">\r\n" );

				}
				domID++;
			}
			valueXmlString.append( "</Root>\r\n" );
			if (rs != null)
			{
				rs.close();
				rs = null;
			}
			if (pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		catch(Exception e)
		{
			System.out.println( "Exception :SavexWizardEJB :defaultDataDAR(Document,String):" + e.getMessage() + ":" );
			e.printStackTrace();
			//valueXmlString = valueXmlString.append( genericUtility.createErrorString( e ) );
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		finally
		{
			try
			{
				if (rs !=null )
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}

			}
			catch(Exception e)
			{
				System.out.println( "Exception :SavexWizardEJB :defaultDataDAR :==>\n"+e.getMessage());
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return valueXmlString.toString();

	}

	public String getFormattedStringBuff( String data )
	{
		StringBuffer dataString = new StringBuffer();
		try
		{
			String[] dataArr = null;

			if ( data.indexOf(",") == -1 )
			{
				dataString.append( "'"+data+"'" );
			}
			else
			{
				dataArr = data.split(",");
				for (int i=0; i < dataArr.length; i++ )
				{
					if ( i == 0 )
					{
						dataString.append( "'"+dataArr[i]+"'" );
					}
					else
					{
						dataString.append( "," );
						dataString.append( "'"+dataArr[i]+"'" );
					}
				}
			}
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
		}
		return dataString.toString();
	}
	//Method to get SampleItem
	public String getSampleItemDetails( Document dom, Document dom2 , String salePersCode, String wrkDate , String scCode, String xtraParams, Connection connectionObject ,String formNo,String editScCode,String formName) throws ITMException //Chnaged by sachin satre on 09-nov-16
	{
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		int domID = 1;
		int num = 0;
		StringBuffer valueXmlString = new StringBuffer();
		String wrkDateInDbFmt = "";
		String selectedItem = "";
		String dcrId="";
		String sql="";
		String userId="";
		String dcrID="";
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		boolean isLocalConn =false;
		try
		{
			if(connectionObject ==  null )
			{
				connectionObject = getConnection();
				isLocalConn =true;
			}
			DateFormat dtFormat = new SimpleDateFormat(getApplDateFormat());
			java.util.Date date = Calendar.getInstance().getTime();
			String currDate = dtFormat.format( date );
			userId = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" );
			if( "".equalsIgnoreCase( checkNull( salePersCode ) ) )
			{
				salePersCode = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginEmpCode" );
			}


			String [] temp = scCode.split(",");
			if ( preDomExists( dom2, formNo ))
			{
				selectedItem = getPrevFormValues( dom2, formNo, new ArrayList<String>(Arrays.asList(temp)), "strg_code" ) ;
			}
			else
			{
				String newScCode = "";
				if(editScCode != null && editScCode.trim().length() > 0 && editScCode.indexOf("'") == -1)
				{
					newScCode = "'"+editScCode+"'";
				}
				else
				{
					newScCode = editScCode;
				}
				selectedItem = getSampleExistingItemsDetail( salePersCode, wrkDate , newScCode,formNo ,formName,connectionObject) ; //Chnaged by sachin satre on 09-nov-16
			}
			selectedItem = "<Root>" + selectedItem + "</Root>";
			//System.out.println("selectedItem>>>"+selectedItem);
			String itemDetails = getSampleSalesPersItemList(dom, salePersCode, scCode, selectedItem, wrkDate,formNo,formName );

			//System.out.println("itemDetails>>>"+itemDetails);
			valueXmlString.append(itemDetails);
		}
		catch(Exception e)
		{
			System.out.println( "Exception :StrgMeetITMMobileWizEJB:getItemDetails( Document dom2 , String salePersCode, String wrkDate , String scCode, String xtraParams):" + e.getMessage() + ":" );
			e.printStackTrace();
			valueXmlString = valueXmlString.append( genericUtility.createErrorString( e ) );
		}
		finally
		{
			try
			{
				if (rs !=null )
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if (isLocalConn && connectionObject != null)
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :StrgMeetITMMobileWizEJB:getItemDetails( Document dom2 , String salePersCode, String wrkDate , String scCode, String xtraParams):" + e.getMessage() + ":" );
				System.out.println( "Exception :StrgMeetITMMobileWizEJB:defaultDataDAR :==>\n"+e.getMessage());
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		System.out.println("Return valueXmlString===>"+valueXmlString);
		return valueXmlString.toString();

	}
	//Method to get Existing item details
	public String getSampleExistingItemsDetail( String salePersCode, String eventDate , String custList ,String formNo,String formName,Connection connectionObject) throws ITMException //Chnaged by sachin satre on 09-nov-16
	{

		ResultSet rs = null;
		//Connection connectionObject = null;
		PreparedStatement pstmt = null;
		int domID=1;
		
		//BY PRACHI ON 13JUNE2022 ID:W22CSUN019
		HashMap<String, String> itemUsageMap = new HashMap<String, String>();
		DARCommonBean dcb = new DARCommonBean();
		
		StringBuffer valueXmlString = new StringBuffer();
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		boolean isLocalConn =false;
		try
		{
			if(connectionObject ==null )
			{
				/*ConnDriver connDriver = new ConnDriver();
				connectionObject = connDriver.getConnectDB( "DriverValidator" );*/
				connectionObject = getConnection();//chnged by sachin satre on [9-nov-16] to get connection
				isLocalConn =true;
			}
			String smiQuery = "";

			String dcrID = getDCRId(connectionObject,salePersCode, eventDate);
			//System.out.println("dcrID>>>"+dcrID);

			//smiQuery = "SELECT ITEM.DESCR, LINE_NO, ITEM_POB, STRG_MEET_ITEMS.ITEM_CODE,STRG_MEET_ITEMS.SALES_PROD_GRP, STRG_CODE, ITEM.ITEM_TYPE, ITEM.ITEM_USAGE, ITEM.DESCR ,STRG_MEET_ITEMS.BRIEFED, STRG_MEET_ITEMS.QUANTITY, STRG_MEET_ITEMS.BRIEFED_DESCR,SALES_PROD_GRP.DESCR AS SPG_DESCR FROM STRG_MEET_ITEMS,ITEM ITEM ,SALES_PROD_GRP SALES_PROD_GRP  WHERE (STRG_MEET_ITEMS.ITEM_CODE = ITEM.ITEM_CODE (+)) AND (STRG_MEET_ITEMS.SALES_PROD_GRP = SALES_PROD_GRP.SALES_PROD_GRP (+)) AND STRG_MEET_ITEMS.DCR_ID= '"+dcrID+"' AND STRG_MEET_ITEMS.STRG_CODE IN (" + custList + ")";
			/*smiQuery = "SELECT ITEM.DESCR, LINE_NO, ITEM_POB, STRG_MEET_ITEMS.ITEM_CODE,STRG_MEET_ITEMS.SALES_PROD_GRP, STRG_CODE, ITEM.ITEM_TYPE, ITEM.ITEM_USAGE, ITEM.DESCR ,STRG_MEET_ITEMS.BRIEFED, STRG_MEET_ITEMS.QUANTITY, STRG_MEET_ITEMS.BRIEFED_DESCR,SALES_PROD_GRP.DESCR AS SPG_DESCR, STRG_MEET_ITEMS.DCR_ID " +
						"   FROM STRG_MEET_ITEMS LEFT OUTER JOIN ITEM ITEM ON (STRG_MEET_ITEMS.ITEM_CODE = ITEM.ITEM_CODE) LEFT OUTER JOIN SALES_PROD_GRP SALES_PROD_GRP ON (STRG_MEET_ITEMS.SALES_PROD_GRP = SALES_PROD_GRP.SALES_PROD_GRP )" +
						"   WHERE STRG_MEET_ITEMS.DCR_ID= '"+dcrID+"'" +
						"   AND STRG_MEET_ITEMS.STRG_CODE IN (" + custList + ")";*/

			//Changed by Poonam Gole for fetching from strg_meet_order
			/*
			smiQuery="SELECT SMO.LINE_NO,SMO.STRG_CODE,SMO.ITEM_CODE,SMO.QUANTITY, ITEM.DESCR AS ITEMDESCR,SMO.DCR_ID,ITEM.UNIT, SMO.TRAN_ID AS TRAN_ID, "
					+ "(CASE WHEN ITEM.ITEM_USAGE ='G' THEN 'GIFT' WHEN ITEM.ITEM_USAGE ='S' THEN 'SAMPLE' WHEN ITEM.ITEM_USAGE ='GFT' THEN 'GIFT' WHEN ITEM.ITEM_USAGE ='SPK' THEN 'SAMPLE' END) AS ITEM_USAGE "
					+" FROM STRG_MEET_ITEMS SMO, ITEM ITEM"
					+" WHERE SMO.ITEM_CODE = ITEM.ITEM_CODE "
					+" AND SMO.DCR_ID =  '"+dcrID+"' "+
					"   AND SMO.STRG_CODE IN (" + custList + ")";
			*/
			//BY PRACHI ON 13JUNE2022 ID:W22CSUN019
			smiQuery="SELECT SMO.LINE_NO,SMO.STRG_CODE,SMO.ITEM_CODE,SMO.QUANTITY, ITEM.DESCR AS ITEMDESCR,SMO.DCR_ID,ITEM.UNIT, SMO.TRAN_ID AS TRAN_ID, "
					+ " ITEM_USAGE AS ITEM_USAGE "
					+" FROM STRG_MEET_ITEMS SMO, ITEM ITEM"
					+" WHERE SMO.ITEM_CODE = ITEM.ITEM_CODE "
					+" AND SMO.DCR_ID =  '"+dcrID+"' "+
					"   AND SMO.STRG_CODE IN (" + custList + ")";


			itemUsageMap = dcb.getItemUsageData(connectionObject);//BY PRACHI ON 13JUNE2022 ID:W22CSUN019

			//System.out.println(" StrgMeetSQL[ ---- >] "+smiQuery);
			pstmt = connectionObject.prepareStatement(smiQuery);
			rs = pstmt.executeQuery();
			while(rs.next())
			{

				String item = checkNull(rs.getString("ITEMDESCR"));
				String itemUnit = checkNull(rs.getString("UNIT"));
				//String sprogrp = checkNull(rs.getString("SPG_DESCR"));
				//System.out.println("item["+item+"]");
				//ADDED BY PRACHI ON 13JUNE2022 ID:W22CSUN019
				String descr="";
				if ( itemUsageMap.get( (rs.getString("ITEM_USAGE")).trim()) != null )
				{
					descr=itemUsageMap.get((rs.getString("ITEM_USAGE")).trim());
					System.out.println("descr is::["+descr+"]");
				}
				

				valueXmlString.append( "<Detail"+formNo+" domID='" + domID + "' selected = 'Y' formName='"+formName+"'>\r\n" );
				valueXmlString.append( "<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\"/>\r\n");//Gaurav Singh on 03/06/15
				if( !item.equals("") )
				{
					//added by  mrunalini snkar to solve the & issues 12-04-2018(start)
					//valueXmlString.append("<item_descr>").append( item ).append("</item_descr>\n");
					valueXmlString.append("<item_descr><![CDATA[").append(item).append("]]></item_descr>\n");
					//added by  mrunalini snkar to solve the & issues 12-04-2018(end)
				}

				valueXmlString.append("<quantity>").append(rs.getInt("QUANTITY")).append("</quantity>\n");//Gulzar
				valueXmlString.append("<item_code><![CDATA[").append(checkNull(rs.getString("ITEM_CODE"))).append("]]></item_code>\n");
				//valueXmlString.append("<sales_prod_grp><![CDATA[").append(checkNull(rs.getString("SALES_PROD_GRP"))).append("]]></sales_prod_grp>\n");
				//valueXmlString.append("<sales_prod_grp_descr><![CDATA[").append(checkNull(rs.getString("SPG_DESCR"))).append("]]></sales_prod_grp_descr>\n");
				valueXmlString.append("<strg_code><![CDATA[").append( checkNull(rs.getString("STRG_CODE")) ).append("]]></strg_code>\r\n");
				valueXmlString.append("<line_no><![CDATA[").append( checkNull(rs.getString("LINE_NO")) ).append("]]></line_no>\r\n");
				//valueXmlString.append("<scheme_code><![CDATA[").append(checkNull(rs.getString("SCHEME_CODE"))).append("]]></scheme_code>\n");
				//valueXmlString.append("<value>").append(checkNull(rs.getString("VALUE"))).append("</value>\n");
				//valueXmlString.append( "<item_type><![CDATA[" ).append( checkNull(rs.getString("ITEM_TYPE")) ).append( "]]></item_type>\r\n" );
				//valueXmlString.append( "<briefed><![CDATA[" ).append( checkNull(rs.getString("BRIEFED"))).append( "]]></briefed>\r\n" );
				//valueXmlString.append( "<item_pob><![CDATA[" ).append( checkNull(rs.getString("ITEM_POB")) ).append( "]]></item_pob>\r\n" );
				//valueXmlString.append( "<briefed_descr><![CDATA[" ).append( checkNull(rs.getString("BRIEFED_DESCR")) ).append( "]]></briefed_descr>\r\n" );
				//valueXmlString.append("<stockist_code><![CDATA[").append(checkNull(rs.getString("STOCKIST_CODE"))).append("]]></stockist_code>\n");
				valueXmlString.append( "<dcr_id><![CDATA[" ).append(checkNull(rs.getString("DCR_ID"))).append( "]]></dcr_id>\r\n" );
				valueXmlString.append( "<tran_id><![CDATA[" ).append(checkNull(rs.getString("TRAN_ID"))).append( "]]></tran_id>\r\n" );//Gulzar on 04/07/17
				valueXmlString.append( "<item_unit><![CDATA[" ).append(itemUnit).append( "]]></item_unit>\r\n" );
				//valueXmlString.append( "<item_usage><![CDATA[" ).append(checkNull(rs.getString("ITEM_USAGE"))).append( "]]></item_usage>\r\n" );//Added by mrunalini sinkar
				valueXmlString.append( "<item_usage><![CDATA[" ).append(descr).append( "]]></item_usage>\r\n" );//added by prachi

				valueXmlString.append( "</Detail"+formNo+">\r\n" );
				domID++;
			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		catch(Exception e)
		{
			System.out.println( "Exception :WsfaDSRMobileWizardEJB :defaultDataWiz(Document,String):" + e.getMessage() + ":" );
			//valueXmlString = valueXmlString.append( genericUtility.createErrorString( e ) );
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		finally
		{
			try
			{
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				if( isLocalConn && connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :WsfaDSRMobileWizardEJB :defaultDataWiz :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		return valueXmlString.toString();
	}
	//Method to get Sample item Details
	public String getSampleSalesPersItemList(Document dom, String sprsCode, String strgCode, String selectedItem, String eventDate,String formNo,String formName ) throws ITMException
	{
		//Form 4 defaultData()
		String sql = "";
		String sql1 = "";
		StringBuffer valueXmlString = new StringBuffer();
		Connection connectionObject = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		boolean isMasterPitchFound = false;
		int maxLineNo = 0;
		int currentFormNo=0;
		String custTranID = null;
		StringBuffer selectedXmlString = new StringBuffer();
		StringBuffer unselectedString = new StringBuffer();
		StringBuffer unlistedString = new StringBuffer();
		StringBuffer listedString = new StringBuffer();
		
		//BY PRACHI ON 13JUNE2022 ID:W22CSUN019
		HashMap<String, String> itemUsageMap = new HashMap<String, String>();
		DARCommonBean dcb = new DARCommonBean();
		try
		{
			valueXmlString.append( "<Root>\r\n" );
			connectionObject = getConnection();//chnged by sachin satre on [11-nov-16] to get connection
			String paramValue="";
			String custCode="";
			/*int strgCustCnt=0;
			String codeSql="SELECT COUNT(*) AS COUNT FROM STRG_CUSTOMER WHERE SC_CODE= ?";
			pstmt=connectionObject.prepareStatement(codeSql);
			pstmt.setString(1, strgCode);
			rs  = pstmt.executeQuery();
			if(rs.next())
			{
				strgCustCnt = rs.getInt("COUNT");

			}
			if(rs!=null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
			System.out.println("strgCustCnt =["+strgCustCnt+"]");*/

			// Added by Ashutosh on 10-11-17  [START]
			/*String parmSampleVal = "";
			String parmSampleSql = "SELECT PARM_VALUE FROM SFAPARM WHERE PARM_NAME='SAMPLE_ALLOW' AND ORG_UNIT='ALL'";
			pstmt = connectionObject.prepareStatement( parmSampleSql );
			rs = pstmt.executeQuery();

			if(rs.next())
			{
				parmSampleVal = checkNull(rs.getString("PARM_VALUE"));
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}*/
			String itemMasterDataValue = getSfaParmValue(sprsCode,"SHOW_SAMPLE_LIST",connectionObject);//Added for consider item form data on the basis of sfaparm  -30-Dec-2020
			System.out.println("itemMasterDataValue ["+itemMasterDataValue+"]");
			
			String parmSampleVal = getSfaParmValue(sprsCode,"SAMPLE_ALLOW",connectionObject);

			String itemUSage="";
			String parmItemUsage = getSfaParmValue(sprsCode,"SAMPLE_ITEM_USAGE",connectionObject);
			if(parmItemUsage!=null && parmItemUsage.trim().length()>0)
			{
				itemUSage=checkNull(getFormattedStringBuff( parmItemUsage ));
			}
			else
			{
				itemUSage="'G','S'";
			}

			//commented & adde by mrunalini sinakar foe sample item related changes on 01-feb-2019(start)
			// Added by Ashutosh on 10-11-17 [END]
			/*if(strgCustCnt  > 0)
					{
						sql = " SELECT ITEM.ITEM_CODE AS ITEM_CODE ,ITEM.DESCR AS DESCR, ITEM.SH_DESCR AS SH_DESCR, ITEM.UNIT AS ITEM_UNIT,S.PRICE_LIST AS PRICE_LIST " +
								" FROM  STRG_CUSTOMER SC, STATE S ,ITEM ITEM LEFT OUTER JOIN PRICELIST  PM ON ITEM.ITEM_CODE = PM.ITEM_CODE "+
								"WHERE SC.STATE_CODE = S.STATE_CODE AND S.PRICE_LIST = PM.PRICE_LIST "+
								"AND SC.SC_CODE= ? "+
								"AND ITEM.ITEM_USAGE NOT IN('S','G') "+
								"ORDER BY ITEM.SH_DESCR ";

						// Added by Ashutosh on 10-11-17 [START]
						//sql = "SELECT DISTINCT ITEM.ITEM_CODE AS ITEM_CODE ,ITEM.DESCR AS DESCR, ITEM.SH_DESCR AS SH_DESCR, ITEM.UNIT AS ITEM_UNIT FROM  ITEM ITEM, SAMPLE_INVTRACE SI"+
						//	  " WHERE SI.ITEM_CODE = ITEM.ITEM_CODE AND SI.EMP_CODE = ?";

						//System.out.println("9968 Inisde");

						System.out.println("10005 param value is :"+parmSampleVal);
						if("N".equalsIgnoreCase(parmSampleVal) )
						{
							//Changes By Mrunalini Sinkar To Remove Pricelist on 04-Oct-2018(start)
							sql = " SELECT ITEM.ITEM_CODE AS ITEM_CODE ,ITEM.DESCR AS DESCR, ITEM.SH_DESCR AS SH_DESCR, ITEM.UNIT AS ITEM_UNIT,S.PRICE_LIST AS PRICE_LIST " +
									" FROM  STRG_CUSTOMER SC, STATE S ,ITEM ITEM LEFT OUTER JOIN PRICELIST  PM ON ITEM.ITEM_CODE = PM.ITEM_CODE "+
									"WHERE SC.STATE_CODE = S.STATE_CODE AND S.PRICE_LIST = PM.PRICE_LIST "+
									"AND SC.SC_CODE= ? "+
									"AND ITEM.ITEM_USAGE IN('S','G') "+ //removed not in condition by rupali on 02/01/17 for ipc/mojobar requirement
									"ORDER BY ITEM.SH_DESCR ";
							sql = " SELECT ITEM.ITEM_CODE AS ITEM_CODE ,ITEM.DESCR AS DESCR, ITEM.SH_DESCR AS SH_DESCR, ITEM.UNIT AS ITEM_UNIT " +
									"FROM ITEM ITEM WHERE ITEM.ITEM_USAGE IN('S','G') ORDER BY ITEM.SH_DESCR ";

							//Changes By Mrunalini Sinkar To Remove Pricelist on 04-Oct-2018(start)


						}
						else if( "E".equalsIgnoreCase(parmSampleVal) )
						{
							sql = "SELECT DISTINCT ITEM.ITEM_CODE AS ITEM_CODE ,ITEM.DESCR AS DESCR, ITEM.SH_DESCR AS SH_DESCR, ITEM.UNIT AS ITEM_UNIT FROM  ITEM ITEM, SAMPLE_INVTRACE SI"+
									" WHERE SI.ITEM_CODE = ITEM.ITEM_CODE AND SI.EMP_CODE = ? and SI.quantity > 0 ORDER BY ITEM.DESCR";

						}
						// Added by Ashutosh on 10-11-17 [END]
					}
					else
					{

						//String Paramsql = "SELECT PARM_VALUE FROM SFAPARM WHERE PARM_NAME='WSFA_UNLISTCUST_PRICELIST'";
						String Paramsql = "SELECT PARM_VALUE FROM SFAPARM WHERE PARM_NAME='SFA_UNLISTCUST_PLIST'";
						pstmt = connectionObject.prepareStatement(Paramsql);
						rs  = pstmt.executeQuery();
						if(rs.next())
						{
							paramValue = checkNull(rs.getString("PARM_VALUE"));
							System.out.println("param value is :"+paramValue);

						}
						if(rs!=null)
						{
							rs.close();
							rs = null;
						}
						if(pstmt!=null)
						{
							pstmt.close();
							pstmt = null;
						}
						sql = " SELECT ITEM.ITEM_CODE AS ITEM_CODE ,ITEM.DESCR AS DESCR, ITEM.SH_DESCR AS SH_DESCR, ITEM.UNIT AS ITEM_UNIT, PM.PRICE_LIST AS PRICE_LIST FROM  ITEM ITEM, PRICELIST  PM "+
								" WHERE ITEM.ITEM_CODE = PM.ITEM_CODE AND  PM.PRICE_LIST= ?"+
								" ORDER BY ITEM.SH_DESCR";
					}*/
			int sampCnt=0;
			String cntSql="";
			if("C".equalsIgnoreCase(parmSampleVal) )
			{
				cntSql ="SELECT COUNT(*) AS COUNT " +
						"  FROM ITEM ITEM,SPRS_ITEM SI WHERE ITEM.ITEM_CODE=SI.ITEM_CODE " +
						//"  AND SI.STATUS='Y' " + commented by mrunaalini sinkar if item present in sprs item master then need to come from sprs_item if it is activ or inative
						"  AND SI.SALES_PERS=? AND " +
						"  ITEM.ITEM_USAGE IN("+itemUSage+") ORDER BY ITEM.SH_DESCR ";
			}
			else
			{
				cntSql ="SELECT COUNT(*) AS COUNT " +
						"  FROM ITEM ITEM,SPRS_ITEM SI WHERE ITEM.ITEM_CODE=SI.ITEM_CODE " +
						//"  AND ITEM.ACTIVE='Y' AND SI.STATUS='Y' " +  commented by mrunaalini sinkar if item present in sprs item master then need to come from sprs_item if it is activ or inative
						"  AND SI.SALES_PERS=? AND " +
						"  ITEM.ITEM_USAGE IN("+itemUSage+") ORDER BY ITEM.SH_DESCR ";
			}

			pstmt = connectionObject.prepareStatement( cntSql );
			pstmt.setString(1, sprsCode);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				sampCnt = rs.getInt("COUNT");
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			// Added by Hariom S for Aldevis common promotion data should display [Start]
			String itemSeries = getProdItmSer(sprsCode, connectionObject);
			int itemCnt=0;
			String itemSql ="SELECT COUNT(*) AS COUNT " +
					"FROM ITEM ITEM,SALES_PERS SP WHERE ITEM.ITEM_USAGE IN("+itemUSage+") AND ITEM.ITEM_SER=SP.ITEM_SER AND ITEM.ACTIVE='Y' "+
					"AND SP.SALES_PERS= ? ORDER BY ITEM.ITEM_USAGE,ITEM.DESCR ";
			pstmt = connectionObject.prepareStatement( itemSql );
			pstmt.setString(1, sprsCode);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				itemCnt = rs.getInt("COUNT");
			}
			else
			{
				if(sampCnt>0)
				{
					itemCnt = 1;
				}
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			// Added by Hariom S for Aldevis common promotion data should display [End]
						
			//Added for consider item form data on the basis of sfaparm  -30-Dec-2020 [Start]
			if(itemMasterDataValue.trim().equalsIgnoreCase("1"))
			{
				/*
				sql ="SELECT ITEM.ITEM_CODE AS ITEM_CODE ,ITEM.DESCR AS DESCR, ITEM.SH_DESCR AS SH_DESCR, ITEM.UNIT AS ITEM_UNIT, "+
						"(CASE WHEN ITEM.ITEM_USAGE ='G' THEN 'GIFT' WHEN ITEM.ITEM_USAGE ='S' THEN 'SAMPLE' WHEN ITEM.ITEM_USAGE ='GFT' THEN 'GIFT' WHEN ITEM.ITEM_USAGE ='SPK' THEN 'SAMPLE' END) AS ITEM_USAGE " +
						"FROM ITEM ITEM,SALES_PERS SP WHERE ITEM.ITEM_USAGE IN("+itemUSage+") AND ITEM.ITEM_SER=SP.ITEM_SER AND ITEM.ACTIVE='Y' "+
						"AND SP.SALES_PERS= ? ORDER BY ITEM.ITEM_USAGE,ITEM.DESCR ";
				*/
				
				//BY PRACHI ON 13JUNE2022 ID:W22CSUN019
				sql ="SELECT ITEM.ITEM_CODE AS ITEM_CODE ,ITEM.DESCR AS DESCR, ITEM.SH_DESCR AS SH_DESCR, ITEM.UNIT AS ITEM_UNIT, "+
						"ITEM_USAGE AS ITEM_USAGE " +
						"FROM ITEM ITEM,SALES_PERS SP WHERE ITEM.ITEM_USAGE IN("+itemUSage+") AND ITEM.ITEM_SER=SP.ITEM_SER AND ITEM.ACTIVE='Y' "+
						"AND SP.SALES_PERS= ? ORDER BY ITEM.ITEM_USAGE,ITEM.DESCR ";
						
			}
			else if(itemMasterDataValue.trim().equalsIgnoreCase("2"))
			{
				/*
					sql ="SELECT ITEM.ITEM_CODE AS ITEM_CODE ,ITEM.DESCR AS DESCR, ITEM.SH_DESCR AS SH_DESCR, ITEM.UNIT AS ITEM_UNIT, "+
								"  (CASE WHEN ITEM.ITEM_USAGE ='G' THEN 'GIFT' WHEN ITEM.ITEM_USAGE ='S' THEN 'SAMPLE' WHEN ITEM.ITEM_USAGE ='GFT' THEN 'GIFT' WHEN ITEM.ITEM_USAGE ='SPK' THEN 'SAMPLE' END) AS ITEM_USAGE " +
								"  FROM ITEM ITEM,SPRS_ITEM SI WHERE ITEM.ITEM_CODE=SI.ITEM_CODE " +
								"  AND SI.STATUS='Y' " +
								"  AND SI.SALES_PERS=? "+
								"  AND (CASE WHEN SI.QUANTITY IS NULL THEN 0 ELSE SI.QUANTITY END - CASE WHEN SI.ISSUE_QTY IS NULL THEN 0 ELSE SI.ISSUE_QTY END ) > 0" +
								"  AND ITEM.ITEM_USAGE IN("+itemUSage+") ORDER BY ITEM.ITEM_USAGE,ITEM.DESCR ";					
				*///BY PRACHI ON 13JUNE2022 ID:W22CSUN019
				sql ="SELECT ITEM.ITEM_CODE AS ITEM_CODE ,ITEM.DESCR AS DESCR, ITEM.SH_DESCR AS SH_DESCR, ITEM.UNIT AS ITEM_UNIT, "+
						"  ITEM_USAGE AS ITEM_USAGE " +
						"  FROM ITEM ITEM,SPRS_ITEM SI WHERE ITEM.ITEM_CODE=SI.ITEM_CODE " +
						"  AND SI.STATUS='Y' " +
						"  AND SI.SALES_PERS=? "+
						"  AND (CASE WHEN SI.QUANTITY IS NULL THEN 0 ELSE SI.QUANTITY END - CASE WHEN SI.ISSUE_QTY IS NULL THEN 0 ELSE SI.ISSUE_QTY END ) > 0" +
						"  AND ITEM.ITEM_USAGE IN("+itemUSage+") ORDER BY ITEM.ITEM_USAGE,ITEM.DESCR ";	
			}
			else if(itemMasterDataValue.trim().equalsIgnoreCase("3"))
			{	
				  /*
					sql ="SELECT ITEM.ITEM_CODE AS ITEM_CODE ,ITEM.DESCR AS DESCR, ITEM.SH_DESCR AS SH_DESCR, ITEM.UNIT AS ITEM_UNIT, "+
							"  (CASE WHEN ITEM.ITEM_USAGE ='G' THEN 'GIFT' WHEN ITEM.ITEM_USAGE ='S' THEN 'SAMPLE' WHEN ITEM.ITEM_USAGE ='GFT' THEN 'GIFT' WHEN ITEM.ITEM_USAGE ='SPK' THEN 'SAMPLE' END) AS ITEM_USAGE " +
							"  FROM ITEM ITEM,SPRS_ITEM SI WHERE ITEM.ITEM_CODE=SI.ITEM_CODE " +
							"  AND ITEM.ACTIVE='Y' AND SI.STATUS='Y' " +
							"  AND SI.SALES_PERS=? AND " +
							"  ITEM.ITEM_USAGE IN("+itemUSage+") ORDER BY ITEM.ITEM_USAGE,ITEM.DESCR ";
					*///BY PRACHI ON 13JUNE2022 ID:W22CSUN019
					sql ="SELECT ITEM.ITEM_CODE AS ITEM_CODE ,ITEM.DESCR AS DESCR, ITEM.SH_DESCR AS SH_DESCR, ITEM.UNIT AS ITEM_UNIT, "+
							" ITEM_USAGE AS ITEM_USAGE " +
							"  FROM ITEM ITEM,SPRS_ITEM SI WHERE ITEM.ITEM_CODE=SI.ITEM_CODE " +
							"  AND ITEM.ACTIVE='Y' AND SI.STATUS='Y' " +
							"  AND SI.SALES_PERS=? AND " +
							"  ITEM.ITEM_USAGE IN("+itemUSage+") ORDER BY ITEM.ITEM_USAGE,ITEM.DESCR ";
				
			}
			else if(itemMasterDataValue.trim().equalsIgnoreCase("4"))
			{
				if(sampCnt>0)
				{
					if("C".equalsIgnoreCase(parmSampleVal) )
					{
						/*
					  sql ="SELECT ITEM.ITEM_CODE AS ITEM_CODE ,ITEM.DESCR AS DESCR, ITEM.SH_DESCR AS SH_DESCR, ITEM.UNIT AS ITEM_UNIT, "+
								"  (CASE WHEN ITEM.ITEM_USAGE ='G' THEN 'GIFT' WHEN ITEM.ITEM_USAGE ='S' THEN 'SAMPLE' WHEN ITEM.ITEM_USAGE ='GFT' THEN 'GIFT' WHEN ITEM.ITEM_USAGE ='SPK' THEN 'SAMPLE' END) AS ITEM_USAGE " +
								"  FROM ITEM ITEM,SPRS_ITEM SI WHERE ITEM.ITEM_CODE=SI.ITEM_CODE " +
								"  AND SI.STATUS='Y' " +
								"  AND SI.SALES_PERS=? "+
								"  AND (CASE WHEN SI.QUANTITY IS NULL THEN 0 ELSE SI.QUANTITY END - CASE WHEN SI.ISSUE_QTY IS NULL THEN 0 ELSE SI.ISSUE_QTY END ) > 0" +
								"  AND ITEM.ITEM_USAGE IN("+itemUSage+") ORDER BY ITEM.ITEM_USAGE,ITEM.DESCR ";
					  */
					 //BY PRACHI ON 13JUNE2022 ID:W22CSUN019
					  sql ="SELECT ITEM.ITEM_CODE AS ITEM_CODE ,ITEM.DESCR AS DESCR, ITEM.SH_DESCR AS SH_DESCR, ITEM.UNIT AS ITEM_UNIT, "+
							"  ITEM_USAGE AS ITEM_USAGE " +
							"  FROM ITEM ITEM,SPRS_ITEM SI WHERE ITEM.ITEM_CODE=SI.ITEM_CODE " +
							"  AND SI.STATUS='Y' " +
							"  AND SI.SALES_PERS=? "+
							"  AND (CASE WHEN SI.QUANTITY IS NULL THEN 0 ELSE SI.QUANTITY END - CASE WHEN SI.ISSUE_QTY IS NULL THEN 0 ELSE SI.ISSUE_QTY END ) > 0" +
							"  AND ITEM.ITEM_USAGE IN("+itemUSage+") ORDER BY ITEM.ITEM_USAGE,ITEM.DESCR ";
					}
					else
					{
						/*
						sql ="SELECT ITEM.ITEM_CODE AS ITEM_CODE ,ITEM.DESCR AS DESCR, ITEM.SH_DESCR AS SH_DESCR, ITEM.UNIT AS ITEM_UNIT, "+
								"  (CASE WHEN ITEM.ITEM_USAGE ='G' THEN 'GIFT' WHEN ITEM.ITEM_USAGE ='S' THEN 'SAMPLE' WHEN ITEM.ITEM_USAGE ='GFT' THEN 'GIFT' WHEN ITEM.ITEM_USAGE ='SPK' THEN 'SAMPLE' END) AS ITEM_USAGE " +
								"  FROM ITEM ITEM,SPRS_ITEM SI WHERE ITEM.ITEM_CODE=SI.ITEM_CODE " +
								"  AND ITEM.ACTIVE='Y' AND SI.STATUS='Y' " +
								"  AND SI.SALES_PERS=? AND " +
								"  ITEM.ITEM_USAGE IN("+itemUSage+") ORDER BY ITEM.ITEM_USAGE,ITEM.DESCR ";
						*///BY PRACHI ON 13JUNE2022 ID:W22CSUN019
						sql ="SELECT ITEM.ITEM_CODE AS ITEM_CODE ,ITEM.DESCR AS DESCR, ITEM.SH_DESCR AS SH_DESCR, ITEM.UNIT AS ITEM_UNIT, "+
								" ITEM_USAGE AS ITEM_USAGE " +
								"  FROM ITEM ITEM,SPRS_ITEM SI WHERE ITEM.ITEM_CODE=SI.ITEM_CODE " +
								"  AND ITEM.ACTIVE='Y' AND SI.STATUS='Y' " +
								"  AND SI.SALES_PERS=? AND " +
								"  ITEM.ITEM_USAGE IN("+itemUSage+") ORDER BY ITEM.ITEM_USAGE,ITEM.DESCR ";
					}
				}
				else
				{
					/*
						sql ="SELECT ITEM.ITEM_CODE AS ITEM_CODE ,ITEM.DESCR AS DESCR, ITEM.SH_DESCR AS SH_DESCR, ITEM.UNIT AS ITEM_UNIT, "+
								"(CASE WHEN ITEM.ITEM_USAGE ='G' THEN 'GIFT' WHEN ITEM.ITEM_USAGE ='S' THEN 'SAMPLE' WHEN ITEM.ITEM_USAGE ='GFT' THEN 'GIFT' WHEN ITEM.ITEM_USAGE ='SPK' THEN 'SAMPLE' END) AS ITEM_USAGE " +
								"FROM ITEM ITEM,SALES_PERS SP WHERE ITEM.ITEM_USAGE IN("+itemUSage+") AND ITEM.ITEM_SER=SP.ITEM_SER AND ITEM.ACTIVE='Y' "+
								"AND SP.SALES_PERS= ? ORDER BY ITEM.ITEM_USAGE,ITEM.DESCR ";
					*/	
					//BY PRACHI ON 13JUNE2022 ID:W22CSUN019
						sql ="SELECT ITEM.ITEM_CODE AS ITEM_CODE ,ITEM.DESCR AS DESCR, ITEM.SH_DESCR AS SH_DESCR, ITEM.UNIT AS ITEM_UNIT, "+
								"ITEM_USAGE AS ITEM_USAGE " +
								"FROM ITEM ITEM,SALES_PERS SP WHERE ITEM.ITEM_USAGE IN("+itemUSage+") AND ITEM.ITEM_SER=SP.ITEM_SER AND ITEM.ACTIVE='Y' "+
								"AND SP.SALES_PERS= ? ORDER BY ITEM.ITEM_USAGE,ITEM.DESCR ";
				}
			}
			else if(itemMasterDataValue.trim().equalsIgnoreCase("5"))
			{
				if(sampCnt>0)
				{
					  /*
						sql ="SELECT ITEM.ITEM_CODE AS ITEM_CODE ,ITEM.DESCR AS DESCR, ITEM.SH_DESCR AS SH_DESCR, ITEM.UNIT AS ITEM_UNIT, "+
								"  (CASE WHEN ITEM.ITEM_USAGE ='G' THEN 'GIFT' WHEN ITEM.ITEM_USAGE ='S' THEN 'SAMPLE' WHEN ITEM.ITEM_USAGE ='GFT' THEN 'GIFT' WHEN ITEM.ITEM_USAGE ='SPK' THEN 'SAMPLE' END) AS ITEM_USAGE " +
								"  FROM ITEM ITEM,SPRS_ITEM SI WHERE ITEM.ITEM_CODE=SI.ITEM_CODE " +
								"  AND ITEM.ACTIVE='Y' AND SI.STATUS='Y' " +
								"  AND SI.SALES_PERS=? AND " +
								"  ITEM.ITEM_USAGE IN("+itemUSage+") ORDER BY ITEM.ITEM_USAGE,ITEM.DESCR ";
						*/
					    //BY PRACHI ON 13JUNE2022 ID:W22CSUN019
						sql ="SELECT ITEM.ITEM_CODE AS ITEM_CODE ,ITEM.DESCR AS DESCR, ITEM.SH_DESCR AS SH_DESCR, ITEM.UNIT AS ITEM_UNIT, "+
								" ITEM_USAGE AS ITEM_USAGE " +
								"  FROM ITEM ITEM,SPRS_ITEM SI WHERE ITEM.ITEM_CODE=SI.ITEM_CODE " +
								"  AND ITEM.ACTIVE='Y' AND SI.STATUS='Y' " +
								"  AND SI.SALES_PERS= ? AND " +
								"  ITEM.ITEM_USAGE IN("+itemUSage+") ORDER BY ITEM.ITEM_USAGE,ITEM.DESCR ";
				}
				else
				{
					   /*
						sql ="SELECT ITEM.ITEM_CODE AS ITEM_CODE ,ITEM.DESCR AS DESCR, ITEM.SH_DESCR AS SH_DESCR, ITEM.UNIT AS ITEM_UNIT, "+
								"(CASE WHEN ITEM.ITEM_USAGE ='G' THEN 'GIFT' WHEN ITEM.ITEM_USAGE ='S' THEN 'SAMPLE' WHEN ITEM.ITEM_USAGE ='GFT' THEN 'GIFT' WHEN ITEM.ITEM_USAGE ='SPK' THEN 'SAMPLE' END) AS ITEM_USAGE " +
								"FROM ITEM ITEM,SALES_PERS SP WHERE ITEM.ITEM_USAGE IN("+itemUSage+") AND ITEM.ITEM_SER=SP.ITEM_SER AND ITEM.ACTIVE='Y' "+
								"AND SP.SALES_PERS= ? ORDER BY ITEM.ITEM_USAGE,ITEM.DESCR ";
						*/
						
						//BY PRACHI ON 13JUNE2022 ID:W22CSUN019
					// Added by Hariom S for Aldevis common promotion data should display [Start]
					if(itemCnt > 0)
					{
						sql ="SELECT ITEM.ITEM_CODE AS ITEM_CODE ,ITEM.DESCR AS DESCR, ITEM.SH_DESCR AS SH_DESCR, ITEM.UNIT AS ITEM_UNIT, "+
								"ITEM_USAGE AS ITEM_USAGE " +
								"FROM ITEM ITEM,SALES_PERS SP WHERE ITEM.ITEM_USAGE IN("+itemUSage+") AND ITEM.ITEM_SER=SP.ITEM_SER AND ITEM.ACTIVE='Y' "+
								"AND SP.SALES_PERS= ? ORDER BY ITEM.ITEM_USAGE,ITEM.DESCR ";
					}
					else
					{
						sql ="SELECT ITEM.ITEM_CODE AS ITEM_CODE ,ITEM.DESCR AS DESCR, ITEM.SH_DESCR AS SH_DESCR, ITEM.UNIT AS ITEM_UNIT, "+
								"ITEM_USAGE AS ITEM_USAGE " +
								"FROM ITEM ITEM WHERE ITEM.ITEM_USAGE IN("+itemUSage+") AND ITEM.ITEM_SER IN("+itemSeries+") " +
								" AND ITEM.ACTIVE='Y' ORDER BY ITEM.ITEM_USAGE,ITEM.DESCR ";
					}
					// Added by Hariom S for Aldevis common promotion data should display [End]
				}
			}
			else if(itemMasterDataValue.trim().equalsIgnoreCase("6"))
			{				
				sql ="SELECT ITEM.ITEM_CODE AS ITEM_CODE ,ITEM.DESCR AS DESCR, ITEM.SH_DESCR AS SH_DESCR, ITEM.UNIT AS ITEM_UNIT, "+
						"ITEM_USAGE AS ITEM_USAGE " +
						"FROM ITEM ITEM WHERE ITEM.ITEM_USAGE IN("+itemUSage+") AND ITEM.ITEM_SER IN("+itemSeries+") " +
						" AND ITEM.ACTIVE='Y' ORDER BY ITEM.ITEM_USAGE,ITEM.DESCR ";
			}

			/*if("N".equalsIgnoreCase(parmSampleVal) || "C".equalsIgnoreCase(parmSampleVal) )
			{

				if(sampCnt>0)
				{
					if("C".equalsIgnoreCase(parmSampleVal) )
					{
					sql ="SELECT ITEM.ITEM_CODE AS ITEM_CODE ,ITEM.DESCR AS DESCR, ITEM.SH_DESCR AS SH_DESCR, ITEM.UNIT AS ITEM_UNIT, "+
								"  (CASE WHEN ITEM.ITEM_USAGE ='G' THEN 'GIFT' WHEN ITEM.ITEM_USAGE ='S' THEN 'SAMPLE' WHEN ITEM.ITEM_USAGE ='GFT' THEN 'GIFT' WHEN ITEM.ITEM_USAGE ='SPK' THEN 'SAMPLE' END) AS ITEM_USAGE " +
								"  FROM ITEM ITEM,SPRS_ITEM SI WHERE ITEM.ITEM_CODE=SI.ITEM_CODE " +
								"  AND SI.STATUS='Y' " +
								"  AND SI.SALES_PERS=? "+
								"  AND (CASE WHEN SI.QUANTITY IS NULL THEN 0 ELSE SI.QUANTITY END - CASE WHEN SI.ISSUE_QTY IS NULL THEN 0 ELSE SI.ISSUE_QTY END ) > 0" +
								"  AND ITEM.ITEM_USAGE IN("+itemUSage+") ORDER BY ITEM.ITEM_USAGE,ITEM.DESCR ";
					}
					else
					{
						sql ="SELECT ITEM.ITEM_CODE AS ITEM_CODE ,ITEM.DESCR AS DESCR, ITEM.SH_DESCR AS SH_DESCR, ITEM.UNIT AS ITEM_UNIT, "+
								"  (CASE WHEN ITEM.ITEM_USAGE ='G' THEN 'GIFT' WHEN ITEM.ITEM_USAGE ='S' THEN 'SAMPLE' WHEN ITEM.ITEM_USAGE ='GFT' THEN 'GIFT' WHEN ITEM.ITEM_USAGE ='SPK' THEN 'SAMPLE' END) AS ITEM_USAGE " +
								"  FROM ITEM ITEM,SPRS_ITEM SI WHERE ITEM.ITEM_CODE=SI.ITEM_CODE " +
								"  AND ITEM.ACTIVE='Y' AND SI.STATUS='Y' " +
								"  AND SI.SALES_PERS=? AND " +
								"  ITEM.ITEM_USAGE IN("+itemUSage+") ORDER BY ITEM.ITEM_USAGE,ITEM.DESCR ";
					}

				}
				else
				{
					sql ="SELECT ITEM.ITEM_CODE AS ITEM_CODE ,ITEM.DESCR AS DESCR, ITEM.SH_DESCR AS SH_DESCR, ITEM.UNIT AS ITEM_UNIT, "+
							"(CASE WHEN ITEM.ITEM_USAGE ='G' THEN 'GIFT' WHEN ITEM.ITEM_USAGE ='S' THEN 'SAMPLE' WHEN ITEM.ITEM_USAGE ='GFT' THEN 'GIFT' WHEN ITEM.ITEM_USAGE ='SPK' THEN 'SAMPLE' END) AS ITEM_USAGE " +
							"FROM ITEM ITEM,SALES_PERS SP WHERE ITEM.ITEM_USAGE IN("+itemUSage+") AND ITEM.ITEM_SER=SP.ITEM_SER AND ITEM.ACTIVE='Y' "+
							"AND SP.SALES_PERS= ? ORDER BY ITEM.ITEM_USAGE,ITEM.DESCR ";

				}


			}
			else if( "E".equalsIgnoreCase(parmSampleVal) )
			{
				sql = "SELECT DISTINCT ITEM.ITEM_CODE AS ITEM_CODE ,ITEM.DESCR AS DESCR, ITEM.SH_DESCR AS SH_DESCR, ITEM.UNIT AS ITEM_UNIT,(CASE WHEN ITEM.ITEM_USAGE ='G' THEN 'GIFT' WHEN ITEM.ITEM_USAGE ='S' THEN 'SAMPLE' WHEN ITEM.ITEM_USAGE ='GFT' THEN 'GIFT' WHEN ITEM.ITEM_USAGE ='SPK' THEN 'SAMPLE' END) AS ITEM_USAGE  FROM  ITEM ITEM, SAMPLE_INVTRACE SI"+
						" WHERE SI.ITEM_CODE = ITEM.ITEM_CODE AND SI.EMP_CODE = ? and SI.quantity > 0 ORDER BY ITEM_USAGE,ITEM.DESCR ";

			}*/
			//Added for consider item form data on the basis of sfaparm  -30-Dec-2020 [End]
			//commented & adde by mrunalini sinakar foe sample item related changes on 01-feb-2019(end)
			String dcrID = getDCRId(connectionObject,sprsCode, eventDate);
			HashMap itemMap = new HashMap();
			HashMap qtyMap = new HashMap();
			HashMap tranIDMap = new HashMap();
			//Added by ashutosh-10-Oct-17-[Start- to bring data for current and open stock ]

			// added and commented by rupali on 26/10/17 for applying condition of sfaparm for sample mgmt [start]
			String parmVal = "";
			String parmSql = "SELECT PARM_VALUE FROM SFAPARM WHERE PARM_NAME='IS_SAMPLE_ALLOW' AND ORG_UNIT='ALL'";
			pstmt = connectionObject.prepareStatement( parmSql );
			rs = pstmt.executeQuery();

			if(rs.next())
			{
				parmVal = checkNull(rs.getString("PARM_VALUE"));
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			ArrayList mapList = new ArrayList();
			//if( "Y".equalsIgnoreCase(parmVal) )
			/*if( "E".equalsIgnoreCase(parmSampleVal))
			{
				mapList = getsampleItemStockDetails(connectionObject, sprsCode, eventDate, selectedItem ,formNo);
			}*/
			// Added by Ashutosh on 10-11-17 [END]
			HashMap currSampleItemStockMap = new HashMap();
			HashMap sampleItemIssueMap = new HashMap();
			HashMap openingStockMap = new HashMap();
			HashMap itemDescrMap = new HashMap();
			HashMap sampleItemCurrStockMap = new HashMap();
			if(mapList != null && !mapList.isEmpty())
			{
				currSampleItemStockMap = (HashMap)mapList.get(0);
				sampleItemIssueMap = (HashMap)mapList.get(1);
				openingStockMap = (HashMap)mapList.get(2);
				itemDescrMap = (HashMap)mapList.get(3);
				sampleItemCurrStockMap = (HashMap)mapList.get(4);
			}
			/*ArrayList mapList = getsampleItemStockDetails(connectionObject, sprsCode, eventDate, selectedItem ,formNo);
					System.out.println("9974 mapList ["+mapList+"]");
					HashMap currSampleItemStockMap = (HashMap)mapList.get(0);
					HashMap sampleItemIssueMap = (HashMap)mapList.get(1);
					HashMap openingStockMap = (HashMap)mapList.get(2);
					HashMap itemDescrMap = (HashMap)mapList.get(3);
					HashMap sampleItemCurrStockMap = (HashMap)mapList.get(4);*/
			// added and commented by rupali on 26/10/17 for applying condition of sfaparm for sample mgmt [end]
			String maxSampleAllow = getMaxSampleAllow(connectionObject);
			//System.out.println("9924 currSampleItemStockMap["+currSampleItemStockMap+"] sampleItemIssueMap ["+sampleItemIssueMap+"] openingStockMap ["+openingStockMap+"]itemDescrMap ["+itemDescrMap+"] selectedItem ["+selectedItem+"]");
			String currStockQty = "0";
			//Added by ashutosh-10-Oct-17-[End- to bring data for current and open stock ]

			if ( selectedItem != null && selectedItem.trim().length() > 0 )
			{
				NodeList itemNodeList = ( genericUtility.parseString( selectedItem ) ).getElementsByTagName("Detail"+formNo+"");
				int nodeListLen = itemNodeList.getLength();
				for ( int i=0; i < nodeListLen ; i++ )
				{
					NodeList innerNodeList = itemNodeList.item( i ).getChildNodes();
					int innerNodeListLen = innerNodeList.getLength();
					String itemCode = "";
					String strgCodeSel = "";
					String lineNoSel = "";
					String pitch = "";
					String qty = "";
					String val = "";
					String columnValue = "";
					String itemDescr = "";
					String tranID = "";
					for ( int j = 0; j < innerNodeListLen; j++ )
					{
						Node currNode = innerNodeList.item( j );
						if ( "item_code".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild() != null)
							{
								itemCode = currNode.getFirstChild().getNodeValue().trim() ;
							}
						}
						else if ( "strg_code".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild() != null)
							{
								strgCodeSel = currNode.getFirstChild().getNodeValue().trim() ;
							}
						}
						else if ( "quantity".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild().getNodeValue() != null )
							{
								qty = currNode.getFirstChild().getNodeValue().trim();
							}
						}
						else if ( "line_no".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild() != null)
							{
								lineNoSel = currNode.getFirstChild().getNodeValue().trim() ;
							}
						}
						else if ( "item_descr".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild() != null)
							{
								itemDescr = checkNull(currNode.getFirstChild().getNodeValue());
							}
						}
						else if ( "tran_id".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild() != null)
							{
								tranID = checkNull(currNode.getFirstChild().getNodeValue());
							}
						}

					}
					itemMap.put( itemCode+"~"+strgCodeSel, lineNoSel);
					qtyMap.put( itemCode+"~"+strgCodeSel, qty);
					tranIDMap.put( itemCode+"~"+strgCodeSel, tranID);
				}
			}

			if(dcrID != null)
			{
				strgCode = checkNull(strgCode);
				if(dcrID.length()>0)
				{
					String checkModeSql = " SELECT MAX(LINE_NO) AS MAXLINENO FROM STRG_MEET_ITEMS WHERE DCR_ID= ?  AND STRG_CODE = ?";
					pstmt = connectionObject.prepareStatement(checkModeSql);
					pstmt.setString(1,dcrID);
					pstmt.setString(2,strgCode);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						maxLineNo = rs.getInt("MAXLINENO");
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					if(rs != null)
					{
						rs.close();
						rs = null;
					}
				}
			}
			String qty = "";
			String pitch = "";
			int num = 1;
			int lineNo=1;

			double value = 0d;
			double rate = 0d;

			if(rs != null)
			{
				rs.close(); rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close(); pstmt = null;
			}
			pstmt =  connectionObject.prepareStatement( sql );
			//commented & adde by mrunalini sinakar foe sample item related changes on 01-feb-2019(start)
			if((!itemMasterDataValue.trim().equalsIgnoreCase("6")) && itemCnt > 0)
			{
				pstmt.setString(1, sprsCode );
			}
			/*	if(strgCustCnt  > 0)
					{

						if( "E".equalsIgnoreCase(parmSampleVal) )
						{
							pstmt.setString(1, sprsCode );
						}
						//Changes By Mrunalini Sinkar To Remove Pricelist on 04-Oct-2018(start)

						else
						{
							pstmt.setString(1, strgCode);//changed by poonam
						}
						//Changes By Mrunalini Sinkar To Remove Pricelist on 04-Oct-2018(end)

					}
					else
					{
						pstmt.setString(1, paramValue);
					}*/
			//BY PRACHI ON 13JUNE2022 ID:W22CSUN019
			itemUsageMap = dcb.getItemUsageData(connectionObject);
			System.out.println("itemUsageMap:: is("+itemUsageMap+")");
			//commented & adde by mrunalini sinakar foe sample item related changes on 01-feb-2019(end)
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				String itemCode = checkNull(rs.getString("ITEM_CODE"));
				String itemUnit = checkNull(rs.getString("ITEM_UNIT"));
				String itemDescr = checkNull(rs.getString("DESCR"));
				String itemShDescr = checkNull(rs.getString("SH_DESCR"));

				String tranID = "";
				
				//BY PRACHI ON 13JUNE2022 ID:W22CSUN019
				String descr="";
				if ( itemUsageMap.get( (rs.getString("ITEM_USAGE")).trim()) != null )
				{
					descr=itemUsageMap.get((rs.getString("ITEM_USAGE")).trim());
					System.out.println("descr is::["+descr+"]");
				}
				//end

				if ( itemMap.get( itemCode+"~"+strgCode ) != null )
				{

					String data = ( String ) itemMap.get( itemCode+"~"+strgCode );
					qty = ( String ) qtyMap.get( itemCode+"~"+strgCode );

					if(tranIDMap.containsKey(itemCode+"~"+strgCode))
					{
						tranID = (String)tranIDMap.get( itemCode+"~"+strgCode );
					}
					selectedXmlString.append("<Detail"+formNo+" domID='"+num+"' selected = 'Y' formName='"+formName+"'>\r\n" );
					selectedXmlString.append( "<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\"/>\r\n");//Gaurav Singh on 03-06-15
					selectedXmlString.append("<selectbox><![CDATA[").append( "true" ).append("]]></selectbox>\n");
					selectedXmlString.append("<item_code><![CDATA[").append( rs.getString("ITEM_CODE") ).append("]]></item_code>\r\n");
					selectedXmlString.append("<tooltip_descr><![CDATA[").append(itemDescr).append("]]></tooltip_descr>\r\n");
					selectedXmlString.append("<line_no><![CDATA["+data+"]]></line_no>\r\n");
					selectedXmlString.append("<quantity><![CDATA["+qty+"]]></quantity>\r\n");
					selectedXmlString.append( "<dcr_id><![CDATA["+dcrID+"]]></dcr_id>\r\n" );
					selectedXmlString.append("<sales_pers><![CDATA[").append(sprsCode).append("]]></sales_pers>\r\n");
					selectedXmlString.append("<strg_code><![CDATA[").append( strgCode ).append("]]></strg_code>\r\n");
					selectedXmlString.append("<item_descr><![CDATA[").append(rs.getString("DESCR")).append("]]></item_descr>\r\n");
					selectedXmlString.append("<item_unit><![CDATA[").append(itemUnit).append("]]></item_unit>\r\n");
					selectedXmlString.append("<tran_id><![CDATA[" ).append(checkNull(tranID)).append( "]]></tran_id>\r\n" );//Gulzar on 04/07/17
					selectedXmlString.append( "<sample_allow><![CDATA[" ).append(parmSampleVal).append( "]]></sample_allow>\r\n" );//Mrunalini on 05-01-2018
					//selectedXmlString.append("<item_usage><![CDATA[").append( checkNull(rs.getString("ITEM_USAGE"))).append("]]></item_usage>\r\n");
					
					//BY PRACHI ON 13JUNE2022 ID:W22CSUN019
					selectedXmlString.append("<item_usage><![CDATA[").append(descr).append("]]></item_usage>\r\n");
					
					//Added by ashutosh-10-Oct-17-[Start- to bring data for current and open stock ]
					selectedXmlString.append("<max_sample_allow><![CDATA[").append( maxSampleAllow ).append("]]></max_sample_allow>\r\n");
					//selectedXmlString.append("<custom_input>");
					//System.out.println("10078 itemCode["+itemCode+"] openingStockMap.get(itemCode) ["+openingStockMap.get(itemCode)+"] currSampleItemStockMap ["+currSampleItemStockMap.get(itemCode)+"]");
					if(openingStockMap != null && openingStockMap.size() > 0 && openingStockMap.containsKey(itemCode))
					{
						selectedXmlString.append("<opening_stock_qty><![CDATA[" ).append( openingStockMap.get(itemCode) ).append( "]]></opening_stock_qty>\r\n" );
					}
					if(currSampleItemStockMap != null && currSampleItemStockMap.size() > 0 && currSampleItemStockMap.containsKey(itemCode))
					{
						selectedXmlString.append( "<curr_stock_qty><![CDATA[" ).append( currSampleItemStockMap.get(itemCode) ).append( "]]></curr_stock_qty>\r\n" );
					}
					if(sampleItemIssueMap != null && sampleItemIssueMap.size() > 0 && sampleItemIssueMap.containsKey(itemCode))
					{
						selectedXmlString.append( "<sample_issue_qty ><![CDATA[" ).append( sampleItemIssueMap.get(itemCode) ).append( "]]></sample_issue_qty>\r\n" );
					}
					else
					{
						selectedXmlString.append( "<sample_issue_qty><![CDATA[0]]></sample_issue_qty>\r\n" );
					}
					if(sampleItemCurrStockMap != null && sampleItemCurrStockMap.size() > 0 && sampleItemCurrStockMap.containsKey(itemCode))
					{
						selectedXmlString.append( "<curr_stock_qty_org><![CDATA[" ).append( sampleItemCurrStockMap.get(itemCode) ).append( "]]></curr_stock_qty_org>\r\n" );
					}
					//Added by ashutosh-10-Oct-17-[End- to bring data for current and open stock ]
					selectedXmlString.append( "</Detail"+formNo+">\r\n" );
					num++;
				}
				else
				{
					//System.out.println("10126 itemCode["+itemCode+"] openingStockMap.get(itemCode) ["+openingStockMap.get(itemCode)+"] currSampleItemStockMap ["+currSampleItemStockMap.get(itemCode)+"] maxSampleAllow ["+maxSampleAllow+"]");
					if("N".equalsIgnoreCase(parmSampleVal) || "C".equalsIgnoreCase(parmSampleVal) )
					{
						maxLineNo = maxLineNo +1;
						unselectedString.append("<Detail"+formNo+" domID='"+maxLineNo+"' selected = 'N' formName='"+formName+"'>\r\n" );
						unselectedString.append( "<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");//Gaurav Singh on 03-06-15
						unselectedString.append("<item_code><![CDATA[").append( rs.getString("ITEM_CODE") ).append("]]></item_code>\r\n");
						unselectedString.append("<tooltip_descr><![CDATA[").append(itemDescr).append("]]></tooltip_descr>\r\n");
						unselectedString.append("<line_no><![CDATA["+maxLineNo+"]]></line_no>\r\n");
						unselectedString.append( "<dcr_id><![CDATA["+dcrID+"]]></dcr_id>\r\n" );
						unselectedString.append("<sales_pers><![CDATA[").append(sprsCode).append("]]></sales_pers>\r\n");
						//unselectedString.append("<strg_code><![CDATA[").append( strgCode ).append("]]></strg_code>\r\n");
						unselectedString.append("<strg_code><![CDATA[").append( "" ).append("]]></strg_code>\r\n");
						unselectedString.append("<quantity><![CDATA[").append( "" ).append("]]></quantity>\r\n");
						unselectedString.append("<item_descr><![CDATA[").append(rs.getString("DESCR")).append("]]></item_descr>\r\n");
						unselectedString.append("<item_unit><![CDATA[").append(itemUnit).append("]]></item_unit>\r\n");
						//unselectedString.append("<item_usage><![CDATA[").append( checkNull(rs.getString("ITEM_USAGE"))).append("]]></item_usage>\r\n");

						//BY PRACHI ON 13JUNE2022 ID:W22CSUN019
						unselectedString.append("<item_usage><![CDATA[").append(descr).append("]]></item_usage>\r\n");
						
						unselectedString.append( "<tran_id><![CDATA[" ).append("").append( "]]></tran_id>\r\n" );//Gulzar on 04/07/17
						unselectedString.append( "<sample_allow><![CDATA[" ).append(parmSampleVal).append( "]]></sample_allow>\r\n" );//Mrunalini on 05-01-2018
						unselectedString.append( "</Detail"+formNo+">\r\n" );
					}
					if(openingStockMap != null && openingStockMap.size() > 0 && openingStockMap.containsKey(itemCode))
					{
						maxLineNo = maxLineNo +1;
						unselectedString.append("<Detail"+formNo+" domID='"+maxLineNo+"' selected = 'N' formName='"+formName+"'>\r\n" );
						unselectedString.append("<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");//Gaurav Singh on 03-06-15
						unselectedString.append("<item_code><![CDATA[").append( rs.getString("ITEM_CODE") ).append("]]></item_code>\r\n");
						unselectedString.append("<tooltip_descr><![CDATA[").append(itemDescr).append("]]></tooltip_descr>\r\n");
						unselectedString.append("<line_no><![CDATA["+maxLineNo+"]]></line_no>\r\n");
						unselectedString.append( "<dcr_id><![CDATA["+dcrID+"]]></dcr_id>\r\n" );
						unselectedString.append("<sales_pers><![CDATA[").append(sprsCode).append("]]></sales_pers>\r\n");
						//unselectedString.append("<strg_code><![CDATA[").append( strgCode ).append("]]></strg_code>\r\n");
						unselectedString.append("<strg_code><![CDATA[").append( "" ).append("]]></strg_code>\r\n");
						unselectedString.append("<quantity><![CDATA[").append( "" ).append("]]></quantity>\r\n");
						unselectedString.append("<item_descr><![CDATA[").append(rs.getString("DESCR")).append("]]></item_descr>\r\n");
						unselectedString.append("<item_unit><![CDATA[").append(itemUnit).append("]]></item_unit>\r\n");
						unselectedString.append( "<tran_id><![CDATA[" ).append("").append( "]]></tran_id>\r\n" );//Gulzar on 04/07/17
						unselectedString.append("<max_sample_allow><![CDATA[").append( maxSampleAllow ).append("]]></max_sample_allow>\r\n");
						unselectedString.append("<opening_stock_qty><![CDATA[" ).append( openingStockMap.get(itemCode) ).append( "]]></opening_stock_qty>\r\n" );
						//unselectedString.append("<item_usage><![CDATA[").append( checkNull(rs.getString("ITEM_USAGE"))).append("]]></item_usage>\r\n");

						//BY PRACHI ON 13JUNE2022 ID:W22CSUN019
						unselectedString.append("<item_usage><![CDATA[").append(descr).append("]]></item_usage>\r\n");
						
						if(currSampleItemStockMap != null && currSampleItemStockMap.size() > 0 && currSampleItemStockMap.containsKey(itemCode))
						{
							unselectedString.append("<curr_stock_qty><![CDATA[" ).append( currSampleItemStockMap.get(itemCode) ).append( "]]></curr_stock_qty>\r\n" );
						}
						if(sampleItemIssueMap != null && sampleItemIssueMap.size() > 0 && sampleItemIssueMap.containsKey(itemCode))
						{
							unselectedString.append("<sample_issue_qty><![CDATA[" ).append( sampleItemIssueMap.get(itemCode) ).append( "]]></sample_issue_qty>\r\n" );
						}
						else
						{
							unselectedString.append("<sample_issue_qty><![CDATA[0]]></sample_issue_qty>\r\n" );
						}
						if(sampleItemCurrStockMap != null && sampleItemCurrStockMap.size() > 0 && sampleItemCurrStockMap.containsKey(itemCode))
						{
							unselectedString.append("<curr_stock_qty_org><![CDATA[" ).append( sampleItemCurrStockMap.get(itemCode) ).append( "]]></curr_stock_qty_org>\r\n" );
						}
						unselectedString.append( "<sample_allow><![CDATA[" ).append(parmSampleVal).append( "]]></sample_allow>\r\n" );//Mrunalini on 05-01-2018

						unselectedString.append( "</Detail"+formNo+">\r\n" );
					}
				}
			}//end of while
			valueXmlString.append(selectedXmlString);
			valueXmlString.append(unselectedString);
			//System.out.println("outside detail  :- "+valueXmlString);
			if(rs != null)
			{
				rs.close(); rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close(); pstmt = null;
			}
			num = 1;

		}
		catch (Exception e)
		{
			e.printStackTrace();
			System.out.println( "Exception :ITMWizardStatefulEJB :getSalesPersItemList(String):" + e.getMessage() + ":" );
			//valueXmlString = valueXmlString.append( genericUtility.createErrorString( e ) );
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		finally
		{
			try
			{
				if( connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :ITMWizardStatefulEJB :getSalesPersItemList(String) :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		valueXmlString.append( "</Root>\r\n" );
		System.out.println( "\n****ValueXmlString :" + valueXmlString.toString() + ":********" );
		return valueXmlString.toString();
	}
	//For DND
	public String getDNDDetails( Document dom2 , String salePersCode, String wrkDate , String scCode, String localityDescr, String xtraParams,String formNo, String formName,Connection connectionObject ) throws ITMException // Changed by kailash on 20/dec/17
	{
		ResultSet rs = null;
		//Connection connectionObject = null;//commented by kailash on 20/dec/17
		boolean isLocalConn =false;// Added by kailash on 20/dec/17
		PreparedStatement pstmt = null;
		int domID = 1;
		int num = 0;
		StringBuffer valueXmlString = new StringBuffer();
		String wrkDateInDbFmt = "";
		String selectedItem = "";
		String dcrId="";
		String sql="";
		//String userId="";
		String dcrID="";
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		try
		{

			if(connectionObject ==null )
			{
				/*ConnDriver connDriver = new ConnDriver();
				connectionObject = connDriver.getConnectDB( "DriverValidator" );*/
				connectionObject = getConnection();//Changed by Kailash on [20-dec-17] to get connection
				isLocalConn =true;
			}
			DateFormat dtFormat = new SimpleDateFormat(getApplDateFormat());
			java.util.Date date = Calendar.getInstance().getTime();
			String currDate = dtFormat.format( date );
			//userId = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" );
			String loginEmpcode = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode");
			if( "".equalsIgnoreCase( checkNull( salePersCode ) ) )
			{
				salePersCode = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginEmpCode" );
			}

			String [] temp = scCode.split(",");
			if ( preDomExists( dom2, formNo ))
			{
				selectedItem = getPrevFormValues( dom2, formNo, new ArrayList<String>(Arrays.asList(temp)), "strg_code" ) ;
			}
			else
			{
				String newScCode = "";
				if(scCode != null && scCode.trim().length() > 0 && scCode.indexOf("'") == -1)
				{
					newScCode = "'"+scCode+"'";
				}
				else
				{
					newScCode = scCode;
				}
				selectedItem = getExistingDndDetailDisplay( salePersCode, wrkDate , newScCode, connectionObject, formNo ,formName) ;
				//selectedItem = getDNDDetailList( salePersCode, wrkDate , newScCode, scCode, formNo,formName, connectionObject ) ;
				System.out.println("selectedItem::::::::::"+selectedItem);
			}
			//
			//String itemDetails = getDNDItemList( salePersCode, scCode, selectedItem, wrkDate, localityDescr );
			//valueXmlString.append(itemDetails);
			//selectedItem = "<Root>" + selectedItem + "</Root>";// added by mrunalini sinkar
			String displayDetails = getDisplayDetailList(dom2, salePersCode, wrkDate , scCode, selectedItem, formNo,formName, connectionObject ) ;
			valueXmlString.append(displayDetails);
		}
		catch(Exception e)
		{
			System.out.println( "Exception :getDNDDetails( Document dom2 , String salePersCode, String wrkDate , String scCode, String xtraParams):" + e.getMessage() + ":" );
			e.printStackTrace();
			valueXmlString = valueXmlString.append( genericUtility.createErrorString( e ) );
		}
		finally
		{
			try
			{
				if (rs !=null )
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				// Changed by kailash on 20/dec/17 [Start]
				/*if (connectionObject != null)
				{
					connectionObject.close();
					connectionObject = null;
				}*/
				if( isLocalConn && connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
					pstmt = null;
				}
				// Changed by kailash on 20/dec/17 [End]
			}
			catch(Exception e)
			{
				System.out.println( "Exception :getDNDDetails( Document dom2 , String salePersCode, String wrkDate , String scCode, String xtraParams):" + e.getMessage() + ":" );
				System.out.println( "Exception :getDNDDetails :==>\n"+e.getMessage());
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		System.out.println("Return valueXmlString===>"+valueXmlString);
		return valueXmlString.toString();

	}
	private String getDNDDetailList( String salePersCode, String eventDate, String custList, String scCode, String formNo, String formName,Connection connectionObject) throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		//PreparedStatement pstmtParm = null;
		//ResultSet rsParm = null;
		//Connection connectionObject = null;//commented by kailash on 20/dec/17
		boolean isLocalConn =false; // Added by kailash on 20/dec/17
		int domID=0;
		int dispCount=0;
		//String parmVal = "";
		StringBuffer valueXmlString = new StringBuffer();

		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		try
		{
			//Changed by kailash on 20/dec/17 [Start]
			if(connectionObject == null )
			{
				/*ConnDriver connDriver = new ConnDriver();
				connectionObject = connDriver.getConnectDB( "DriverValidator" );*/
				connectionObject = getConnection();
				isLocalConn =true;
			}
			//Changed by kailash on 20/dec/17 [End]
			valueXmlString.append( "<Root>\r\n" );

			String smiQuery = "";

			String dcrID = getDCRId(connectionObject,salePersCode, eventDate);

			/*String dndParmSql = " SELECT PARM_VALUE FROM SFAPARM WHERE PARM_NAME = 'STRG_ITEM_DISPLAY' ";
				pstmtParm = connectionObject.prepareStatement(dndParmSql);
				rsParm = pstmtParm.executeQuery();
				while(rsParm.next())
				{
					parmVal = rsParm.getString("PARM_VALUE");
				}
				System.out.println(" parmVal ["+parmVal+"]");*/

			if (custList == null || custList.trim().length() == 0)
			{
				//commented & added by mrunalini sinkar on 30-nov-2018 for disp_type changes adding the disp_type,item_code,quantity in query(START)
				/*smiQuery = " SELECT DCR_ID, LINE_NO, STRG_CODE, DOC_ID, DOC_ID_1, DISPLAY_AREA ,TRAN_ID,DISP_TYPE,ITEM_CODE,QUANTITY FROM STRG_ITEM_DISPLAY " +
						" WHERE DCR_ID = '"+dcrID+"' ";*/
				smiQuery = " SELECT STD.DCR_ID, STD.LINE_NO, STD.STRG_CODE, STD.DOC_ID, STD.DOC_ID_1, STD.DISPLAY_AREA ,STD.TRAN_ID,STD.DISP_TYPE,STD.BRAND_CODE,STD.QUANTITY, "+         //Changed by Niraj s on 14-Dec-2018 for change Item_code to brand_code in display form
						" DT.ITEM_OPTION FROM STRG_ITEM_DISPLAY STD LEFT OUTER JOIN DISPLAY_TYPE DT ON STD.DISP_TYPE = DT.DISP_TYPE WHERE STD.DCR_ID = '"+dcrID+"' ";
				//commented & added by mrunalini sinkar on 30-nov-2018 for disp_type changes adding the disp_type,item_code,quantity in query(end)

			}
			else
			{
				//commented & added by mrunalini sinkar on 30-nov-2018 for disp_type changes adding the disp_type,item_code,quantity in query(START)
				/*smiQuery = " SELECT DCR_ID, LINE_NO, STRG_CODE, DOC_ID, DOC_ID_1, DISPLAY_AREA ,TRAN_ID,DISP_TYPE,ITEM_CODE,QUANTITY FROM STRG_ITEM_DISPLAY " +
						" WHERE DCR_ID = '"+dcrID+"'" + " AND STRG_CODE IN (" + custList + ")";*/
				smiQuery = " SELECT STD.DCR_ID, STD.LINE_NO, STD.STRG_CODE, STD.DOC_ID, STD.DOC_ID_1, STD.DISPLAY_AREA ,STD.TRAN_ID,STD.DISP_TYPE,STD.BRAND_CODE,STD.QUANTITY, "+        //Changed by Niraj s on 14-Dec-2018 for change Item_code to brand_code in display form
						" DT.ITEM_OPTION FROM STRG_ITEM_DISPLAY STD LEFT OUTER JOIN DISPLAY_TYPE DT ON STD.DISP_TYPE = DT.DISP_TYPE " +
						" WHERE DCR_ID = '"+dcrID+"'" + " AND STRG_CODE IN (" + custList + ")";
				//commented & added by mrunalini sinkar on 30-nov-2018 for disp_type changes adding the disp_type,item_code,quantity in query(end)

			}

			//if ( parmVal != null || parmVal.trim().length() > 0)
			//{
			pstmt = connectionObject.prepareStatement(smiQuery);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				String itemOption = checkNull(rs.getString("ITEM_OPTION"));
				domID++;
				valueXmlString.append("<Detail"+formNo+" domID='" + domID + "' selected = 'Y' formName='"+formName+"'>\r\n" );
				valueXmlString.append("<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\"/>\r\n");
				valueXmlString.append("<selectbox><![CDATA[").append( "true" ).append("]]></selectbox>\n");
				valueXmlString.append("<dcr_id><![CDATA[" ).append(checkNull(rs.getString("DCR_ID"))).append( "]]></dcr_id>\r\n" );
				valueXmlString.append("<line_no><![CDATA[").append(checkNull(rs.getString("LINE_NO"))).append("]]></line_no>\r\n");
				valueXmlString.append("<strg_code><![CDATA[").append(checkNull(rs.getString("STRG_CODE"))).append("]]></strg_code>\n");
				valueXmlString.append("<doc_id><![CDATA[").append(checkNull(rs.getString("DOC_ID"))).append("]]></doc_id>\n");
				valueXmlString.append("<doc_id_1><![CDATA[").append(checkNull(rs.getString("DOC_ID_1"))).append("]]></doc_id_1>\n");
				valueXmlString.append("<display_area><![CDATA[").append( checkNull(rs.getString("DISPLAY_AREA")) ).append("]]></display_area>\r\n");
				valueXmlString.append("<tran_id><![CDATA[").append( checkNull(rs.getString("TRAN_ID")) ).append("]]></tran_id>\r\n");
				//valueXmlString.append("<display_area_no><![CDATA[" ).append( checkNull(rs.getString("DISPLAY_AREA_NO")) ).append( "]]></display_area_no>\r\n" );
				//commented & added by mrunalini sinkar on 30-nov-2018 for disp_type changes adding the disp_type,item_code,quantity in query(end)
				valueXmlString.append("<disp_type><![CDATA[").append( checkNull(rs.getString("DISP_TYPE")) ).append("]]></disp_type>\r\n");

				if(itemOption.equalsIgnoreCase("1"))
				{
					valueXmlString.append( "<brand_code visible = '1'><![CDATA[" ).append( checkNull(rs.getString("BRAND_CODE")) ).append( "]]></brand_code>\r\n" );             //Changed by Niraj s on 14-Dec-2018 for change Item_code to brand_code in display form
					valueXmlString.append( "<quantity visible = '0'><![CDATA[" ).append( checkNull(rs.getString("QUANTITY")) ).append( "]]></quantity>\r\n" );
					valueXmlString.append( "<brand_descr visible = '1'><![CDATA[" ).append( "" ).append( "]]></brand_descr>\r\n" );
					valueXmlString.append( "<target_qty visible = '0'><![CDATA[" ).append( "" ).append( "]]></target_qty>\r\n" );
				}
				else if(itemOption.equalsIgnoreCase("2"))
				{
					valueXmlString.append( "<brand_code visible = '1'><![CDATA[" ).append( checkNull(rs.getString("BRAND_CODE")) ).append( "]]></brand_code>\r\n" );              //Changed by Niraj s on 14-Dec-2018 for change Item_code to brand_code in display form
					valueXmlString.append( "<quantity visible = '1'><![CDATA[" ).append( checkNull(rs.getString("QUANTITY")) ).append( "]]></quantity>\r\n" );
					valueXmlString.append( "<brand_descr visible = '1'><![CDATA[" ).append( "" ).append( "]]></brand_descr>\r\n" );
					valueXmlString.append( "<target_qty visible = '1'><![CDATA[" ).append( "" ).append( "]]></target_qty>\r\n" );
				}
				else if(itemOption.equalsIgnoreCase("3"))
				{
					valueXmlString.append( "<brand_code visible = '0'><![CDATA[" ).append( checkNull(rs.getString("BRAND_CODE"))).append( "]]></brand_code>\r\n" );               //Changed by Niraj s on 14-Dec-2018 for change Item_code to brand_code in display form
					valueXmlString.append( "<quantity visible = '1'><![CDATA[" ).append( checkNull(rs.getString("QUANTITY"))).append( "]]></quantity>\r\n" );
					valueXmlString.append( "<brand_descr visible = '0'><![CDATA[" ).append( "" ).append( "]]></brand_descr>\r\n" );
					valueXmlString.append( "<target_qty visible = '0'><![CDATA[" ).append( "" ).append( "]]></target_qty>\r\n" );
				}
				else
				{
					valueXmlString.append( "<brand_code visible = '0'><![CDATA[" ).append( "" ).append( "]]></brand_code>\r\n" );                                                 //Changed by Niraj s on 14-Dec-2018 for change Item_code to brand_code in display form
					valueXmlString.append( "<quantity visible = '0'><![CDATA[" ).append( "" ).append( "]]></quantity>\r\n" );
					valueXmlString.append( "<brand_descr visible = '0'><![CDATA[" ).append( "" ).append( "]]></brand_descr>\r\n" );
					valueXmlString.append( "<target_qty visible = '0'><![CDATA[" ).append( "" ).append( "]]></target_qty>\r\n" );
				}
				//commented & added by mrunalini sinkar on 30-nov-2018 for disp_type changes adding the disp_type,item_code,quantity in query(end)

				valueXmlString.append("</Detail"+formNo+">\r\n" );
			}
			else
			{

				//commented & added by mrunalini sinkar on 30-nov-2018 for disp_type changes adding the disp_type,item_code,quantity in query(start)
				String dispalySql = "SELECT DEAL.TRAN_ID,DEAL.TRAN_DATE,BRAND.BRAND_CODE AS CODE,BRAND.DESCRIPTION,DET.TARGET_QTY,DEAL.STATUS_DATE,DEAL.STRG_CODE AS CUST_CODE,"+
						"TRIM(SP.SALES_PERS) AS SALES_PERS, DET.REMARKS AS REMARKS "+
						"FROM BRAND BRAND, SALES_PERS SP, DND_DEAL DEAL, DND_DEAL_DET DET "+
						"WHERE SP.ITEM_SER = BRAND.ITEM_SER "+
						"AND SP.SALES_PERS = DEAL.SALES_PERS AND BRAND.BRAND_CODE = DET.BRAND_CODE AND DEAL.TRAN_ID = DET.TRAN_ID AND DEAL.APRV_STAT = 'A' "+
						"AND SP.SALES_PERS = ? AND DEAL.STRG_CODE = ? AND DEAL.EFF_FROM <= ? AND DEAL.VALID_UPTO >= ? ORDER BY TRAN_DATE,TRAN_ID ";

				PreparedStatement pstmtDisp = connectionObject.prepareStatement(dispalySql);
				pstmtDisp.setString(1, salePersCode);
				pstmtDisp.setString(2, scCode);
				pstmtDisp.setTimestamp( 3, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( eventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
				pstmtDisp.setTimestamp( 4, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( eventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
				ResultSet rsDisp = pstmtDisp.executeQuery();

				/*String itmOption="",disType="";
				String dispSql="SELECT ITEM_OPTION,DISP_TYPE FROM DISPLAY_TYPE ORDER BY DISP_TYPE" ;
				System.out.println(" dispSql is:["+dispSql+"]");

				PreparedStatement dispPstmt = connectionObject.prepareStatement(dispSql) ;
				ResultSet dispRs = dispPstmt.executeQuery();
				if(dispRs.next())
				{
					itmOption = checkNull(dispRs.getString("ITEM_OPTION"));
					disType = checkNull(dispRs.getString("DISP_TYPE"));

				}
				if (dispRs != null)
				{
					dispRs.close();
					dispRs = null;
				}
				if (dispPstmt != null)
				{
					dispPstmt.close();
					dispPstmt = null;
				}

				System.out.println("itmoption:["+itmOption+"]disType["+disType+"]");*/
				//commented & added by mrunalini sinkar on 30-nov-2018 for disp_type changes adding the disp_type,item_code,quantity in query(end)
				while(rsDisp.next())
				{
					dispCount++;
					domID++;
					valueXmlString.append("<Detail"+formNo+" domID='" + domID + "' selected = 'N' formName='"+formName+"'>\r\n" );
					valueXmlString.append("<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");
					valueXmlString.append("<dcr_id><![CDATA[" ).append(dcrID).append( "]]></dcr_id>\r\n" );
					valueXmlString.append("<line_no><![CDATA[").append(domID).append("]]></line_no>\r\n");
					valueXmlString.append("<strg_code><![CDATA[").append(scCode).append("]]></strg_code>\n");
					valueXmlString.append("<doc_id><![CDATA[").append("").append("]]></doc_id>\n");
					valueXmlString.append("<doc_id_1><![CDATA[").append("").append("]]></doc_id_1>\n");
					valueXmlString.append("<display_area><![CDATA[").append(checkNull(rsDisp.getString("REMARKS"))).append("]]></display_area>\r\n");
					valueXmlString.append("<tran_id><![CDATA[").append( "" ).append("]]></tran_id>\r\n");
					//commented & added by mrunalini sinkar on 30-nov-2018 for disp_type changes adding the disp_type,item_code,quantity in query(start)
					valueXmlString.append("<disp_type><![CDATA[" ).append("").append("]]></disp_type>\r\n");
					valueXmlString.append( "<brand_code visible = '0'><![CDATA[" ).append(checkNull(rsDisp.getString("CODE"))).append( "]]></brand_code>\r\n" );                     //Changed by Niraj s on 14-Dec-2018 for change Item_code to brand_code in display form
					valueXmlString.append( "<quantity visible = '1'><![CDATA[" ).append("").append( "]]></quantity>\r\n" );
					valueXmlString.append( "<brand_descr visible = '0'><![CDATA[" ).append(checkNull(rsDisp.getString("DESCRIPTION"))).append( "]]></brand_descr>\r\n" );
					valueXmlString.append( "<target_qty visible = '1'><![CDATA[" ).append(rsDisp.getInt("TARGET_QTY")).append( "]]></target_qty>\r\n" );
					valueXmlString.append("</Detail"+formNo+">\r\n" );
					/*if(itmOption.equalsIgnoreCase("1"))
					{
						valueXmlString.append( "<brand_code visible = '1'><![CDATA[" ).append("").append( "]]></brand_code>\r\n" );                     //Changed by Niraj s on 14-Dec-2018 for change Item_code to brand_code in display form
						valueXmlString.append( "<quantity visible = '0'><![CDATA[" ).append("").append( "]]></quantity>\r\n" );
						valueXmlString.append( "<brand_descr visible = '1'><![CDATA[" ).append( "" ).append( "]]></brand_descr>\r\n" );
						valueXmlString.append( "<target_qty visible = '0'><![CDATA[" ).append( "" ).append( "]]></target_qty>\r\n" );
					}
					else if(itmOption.equalsIgnoreCase("2"))
					{
						valueXmlString.append( "<brand_code visible = '1'><![CDATA[" ).append("").append( "]]></brand_code>\r\n" );                     //Changed by Niraj s on 14-Dec-2018 for change Item_code to brand_code in display form
						valueXmlString.append( "<quantity visible = '1'><![CDATA[" ).append("").append( "]]></quantity>\r\n" );
						valueXmlString.append( "<brand_descr visible = '1'><![CDATA[" ).append( "" ).append( "]]></brand_descr>\r\n" );
						valueXmlString.append( "<target_qty visible = '1'><![CDATA[" ).append( "" ).append( "]]></target_qty>\r\n" );
					}
					else if(itmOption.equalsIgnoreCase("3"))
					{
						valueXmlString.append( "<brand_code visible = '0'><![CDATA[" ).append("").append( "]]></brand_code>\r\n" );                     //Changed by Niraj s on 14-Dec-2018 for change Item_code to brand_code in display form
						valueXmlString.append( "<quantity visible = '1'><![CDATA[" ).append("").append( "]]></quantity>\r\n" );
						valueXmlString.append( "<brand_descr visible = '0'><![CDATA[" ).append( "" ).append( "]]></brand_descr>\r\n" );
						valueXmlString.append( "<target_qty visible = '0'><![CDATA[" ).append( "" ).append( "]]></target_qty>\r\n" );
					}
					else
					{
						valueXmlString.append( "<brand_code visible = '0'><![CDATA[" ).append( "" ).append( "]]></brand_code>\r\n" );                   //Changed by Niraj s on 14-Dec-2018 for change Item_code to brand_code in display form
						valueXmlString.append( "<quantity visible = '0'><![CDATA[" ).append( "" ).append( "]]></quantity>\r\n" );
						valueXmlString.append( "<brand_descr visible = '0'><![CDATA[" ).append( "" ).append( "]]></brand_descr>\r\n" );
						valueXmlString.append( "<target_qty visible = '0'><![CDATA[" ).append( "" ).append( "]]></target_qty>\r\n" );
					}*/

				}
				if (rsDisp!= null)
				{
					rsDisp.close();
					rsDisp = null;
				}
				if(pstmtDisp!=null)
				{
					pstmtDisp.close();
					pstmtDisp = null;
				}
				if(dispCount == 0)
				{
					domID++;
					valueXmlString.append("<Detail"+formNo+" domID='" + domID + "' selected = 'N' formName='"+formName+"'>\r\n" );
					valueXmlString.append("<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");
					valueXmlString.append("<dcr_id><![CDATA[" ).append(dcrID).append( "]]></dcr_id>\r\n" );
					valueXmlString.append("<line_no><![CDATA[").append(domID).append("]]></line_no>\r\n");
					valueXmlString.append("<strg_code><![CDATA[").append(scCode).append("]]></strg_code>\n");
					valueXmlString.append("<doc_id><![CDATA[").append("").append("]]></doc_id>\n");
					valueXmlString.append("<doc_id_1><![CDATA[").append("").append("]]></doc_id_1>\n");
					valueXmlString.append("<display_area><![CDATA[").append("").append("]]></display_area>\r\n");
					valueXmlString.append("<tran_id><![CDATA[").append( "" ).append("]]></tran_id>\r\n");
					//commented & added by mrunalini sinkar on 30-nov-2018 for disp_type changes adding the disp_type,item_code,quantity in query(start)
					valueXmlString.append("<disp_type><![CDATA[" ).append("").append("]]></disp_type>\r\n");
					valueXmlString.append( "<brand_code visible = '1'><![CDATA[" ).append("").append( "]]></brand_code>\r\n" );                     //Changed by Niraj s on 14-Dec-2018 for change Item_code to brand_code in display form
					valueXmlString.append( "<quantity visible = '1'><![CDATA[" ).append("").append( "]]></quantity>\r\n" );
					valueXmlString.append( "<brand_descr visible = '1'><![CDATA[" ).append("").append( "]]></brand_descr>\r\n" );
					valueXmlString.append( "<target_qty visible = '0'><![CDATA[" ).append("").append( "]]></target_qty>\r\n" );
					valueXmlString.append("</Detail"+formNo+">\r\n" );
				}
				/*domID++;
				valueXmlString.append("<Detail"+formNo+" domID='" + domID + "' selected = 'N' formName='"+formName+"'>\r\n" );
				valueXmlString.append("<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");
				valueXmlString.append("<dcr_id><![CDATA[" ).append(dcrID).append( "]]></dcr_id>\r\n" );
				valueXmlString.append("<line_no><![CDATA[").append(domID).append("]]></line_no>\r\n");
				valueXmlString.append("<strg_code><![CDATA[").append("").append("]]></strg_code>\n");
				valueXmlString.append("<doc_id><![CDATA[").append("").append("]]></doc_id>\n");
				valueXmlString.append("<doc_id_1><![CDATA[").append("").append("]]></doc_id_1>\n");
				valueXmlString.append("<display_area><![CDATA[").append( "" ).append("]]></display_area>\r\n");
				valueXmlString.append("<tran_id><![CDATA[").append( "" ).append("]]></tran_id>\r\n");
				//commented & added by mrunalini sinkar on 30-nov-2018 for disp_type changes adding the disp_type,item_code,quantity in query(start)
				valueXmlString.append("<disp_type><![CDATA[" ).append("").append("]]></disp_type>\r\n");
				if(itmOption.equalsIgnoreCase("1"))
				{
					valueXmlString.append( "<brand_code visible = '1'><![CDATA[" ).append("").append( "]]></brand_code>\r\n" );                     //Changed by Niraj s on 14-Dec-2018 for change Item_code to brand_code in display form
					valueXmlString.append( "<quantity visible = '0'><![CDATA[" ).append("").append( "]]></quantity>\r\n" );
					valueXmlString.append( "<brand_descr visible = '1'><![CDATA[" ).append( "" ).append( "]]></brand_descr>\r\n" );
					valueXmlString.append( "<target_qty visible = '0'><![CDATA[" ).append( "" ).append( "]]></target_qty>\r\n" );
				}
				else if(itmOption.equalsIgnoreCase("2"))
				{
					valueXmlString.append( "<brand_code visible = '1'><![CDATA[" ).append("").append( "]]></brand_code>\r\n" );                     //Changed by Niraj s on 14-Dec-2018 for change Item_code to brand_code in display form
					valueXmlString.append( "<quantity visible = '1'><![CDATA[" ).append("").append( "]]></quantity>\r\n" );
					valueXmlString.append( "<brand_descr visible = '1'><![CDATA[" ).append( "" ).append( "]]></brand_descr>\r\n" );
					valueXmlString.append( "<target_qty visible = '1'><![CDATA[" ).append( "" ).append( "]]></target_qty>\r\n" );
				}
				else if(itmOption.equalsIgnoreCase("3"))
				{
					valueXmlString.append( "<brand_code visible = '0'><![CDATA[" ).append("").append( "]]></brand_code>\r\n" );                     //Changed by Niraj s on 14-Dec-2018 for change Item_code to brand_code in display form
					valueXmlString.append( "<quantity visible = '1'><![CDATA[" ).append("").append( "]]></quantity>\r\n" );
					valueXmlString.append( "<brand_descr visible = '0'><![CDATA[" ).append( "" ).append( "]]></brand_descr>\r\n" );
					valueXmlString.append( "<target_qty visible = '0'><![CDATA[" ).append( "" ).append( "]]></target_qty>\r\n" );
				}
				else
				{
					valueXmlString.append( "<brand_code visible = '0'><![CDATA[" ).append( "" ).append( "]]></brand_code>\r\n" );                   //Changed by Niraj s on 14-Dec-2018 for change Item_code to brand_code in display form
					valueXmlString.append( "<quantity visible = '0'><![CDATA[" ).append( "" ).append( "]]></quantity>\r\n" );
					valueXmlString.append( "<brand_descr visible = '0'><![CDATA[" ).append( "" ).append( "]]></brand_descr>\r\n" );
					valueXmlString.append( "<target_qty visible = '0'><![CDATA[" ).append( "" ).append( "]]></target_qty>\r\n" );
				}
				 */
				//commented & added by mrunalini sinkar on 30-nov-2018 for disp_type changes adding the disp_type,item_code,quantity in query(start)
				//valueXmlString.append("</Detail"+formNo+">\r\n" );
			}
			/*for (int displayLine = domID ; displayLine < Integer.parseInt(parmVal) ; displayLine++)
					{
						domID++;
						valueXmlString.append("<Detail"+formNo+" domID='" + domID + "' selected = 'N'>\r\n" );
						valueXmlString.append("<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");
						valueXmlString.append("<dcr_id><![CDATA[" ).append(dcrID).append( "]]></dcr_id>\r\n" );
						valueXmlString.append("<line_no><![CDATA[").append(domID).append("]]></line_no>\r\n");
						valueXmlString.append("<strg_code><![CDATA[").append(scCode).append("]]></strg_code>\n");
						valueXmlString.append("<doc_id><![CDATA[").append("").append("]]></doc_id>\n");
						valueXmlString.append("<display_area><![CDATA[").append( "" ).append("]]></display_area>\r\n");
						//valueXmlString.append("<display_area_no><![CDATA[" ).append( "" ).append( "]]></display_area_no>\r\n" );
						valueXmlString.append("</Detail"+formNo+">\r\n" );
					}*/

			//}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		catch(Exception e)
		{
			System.out.println( "Exception :StrgMeetOTCGwtWizardComp : getExistingDNDDetail(Document,String):" + e.getMessage() + ":" );
			//valueXmlString = valueXmlString.append( genericUtility.createErrorString( e ) );
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		finally
		{
			try
			{
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				//Changed by kailash on 20/dec/17 for getconnection [Start]
				//if( connectionObject != null && ! connectionObject.isClosed() )
				if( isLocalConn && connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
					pstmt = null;
				}
				//Changed by kailash on 20/dec/17 [End]
			}
			catch(Exception e)
			{
				System.out.println( "Exception :StrgMeetOTCGwtWizardComp :getExistingDNDDetail :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		valueXmlString.append( "</Root>\r\n" );
		System.out.println( "\n****ValueXmlString :" + valueXmlString.toString() + ":********" );
		return valueXmlString.toString();
	}
	public String getExistingDndDetailDisplay( String spCode, String eventDate, String customers, Connection connectionObject,String formNo,String formName ) throws ITMException
	{
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		int domID=1;
		String sampleQuery="";
		StringBuffer valueXmlString = new StringBuffer();

		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		boolean isLocalConn = false;
		try
		{
			String dcrID = getDCRIdList(connectionObject, spCode, eventDate);
			//System.out.println(" dcrID :: ["+dcrID+"]");
			if ( dcrID != null && dcrID.trim().length() > 0 )
			{
				dcrID = "'" + dcrID.replaceAll(",", "','") + "'";
			}
			else
			{
				dcrID = "''";
			}
			if ( eventDate != null )
			{
				eventDate = genericUtility.getValidDateTimeString( eventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ;
			}
			// added customer argument in method getExistingDndDetailDisplay on 25-04-2017 (strat)

			// commentted and added by rupali on 19/01/19 for edit mode of display subform [start]
			/*sampleQuery = " SELECT DCR_ID, LINE_NO, STRG_CODE, DOC_ID, DOC_ID_1, DISPLAY_AREA, TRAN_ID,DISP_TYPE,BRAND_CODE,QUANTITY FROM STRG_ITEM_DISPLAY " +                      //Changed by Niraj s on 14-Dec-2018 for change Item_code to brand_code in display form
					" WHERE DCR_ID IN ("+dcrID+") AND STRG_CODE IN("+customers+")";*/

			/*String displaySql = "SELECT STD.DCR_ID, STD.LINE_NO, STD.STRG_CODE, STD.DOC_ID, STD.DOC_ID_1, STD.DISPLAY_AREA ," +
								"STD.TRAN_ID,STD.DISP_TYPE, STD.BRAND_CODE,STD.QUANTITY, DT.ITEM_OPTION, DET.REMARKS, DET.TARGET_QTY " +
								"FROM STRG_ITEM_DISPLAY STD LEFT OUTER JOIN DISPLAY_TYPE DT ON STD.DISP_TYPE = DT.DISP_TYPE " +
								"LEFT OUTER JOIN DND_DEAL DEAL ON STD.STRG_CODE = DEAL.STRG_CODE AND DEAL.SALES_PERS = " +
								"(SELECT SALES_PERS FROM STRG_MEET WHERE TRAN_ID = STD.TRAN_ID) LEFT OUTER JOIN DND_DEAL_DET DET " +
								"ON STD.BRAND_CODE = DET.BRAND_CODE AND DEAL.TRAN_ID = DET.TRAN_ID WHERE DCR_ID IN ("+dcrID+") AND STD.STRG_CODE IN("+customers+")";

			pstmt = connectionObject.prepareStatement(displaySql);*/

			String displaySql = "SELECT STD.DCR_ID, STD.LINE_NO, STD.STRG_CODE, STD.DOC_ID, STD.DOC_ID_1, STD.DISPLAY_AREA ," +
					"STD.TRAN_ID,STD.DISP_TYPE, STD.BRAND_CODE,STD.QUANTITY, DT.ITEM_OPTION, DET.REMARKS, DET.TARGET_QTY,B.DESCRIPTION " +
					"FROM STRG_ITEM_DISPLAY STD LEFT OUTER JOIN DISPLAY_TYPE DT ON STD.DISP_TYPE = DT.DISP_TYPE " +
					"LEFT OUTER JOIN DND_DEAL DEAL ON STD.STRG_CODE = DEAL.STRG_CODE AND DEAL.SALES_PERS = ? AND DEAL.EFF_FROM <= ? AND DEAL.VALID_UPTO >= ? " +
					"LEFT OUTER JOIN DND_DEAL_DET DET ON STD.BRAND_CODE = DET.BRAND_CODE AND DEAL.TRAN_ID = DET.TRAN_ID " +
					"LEFT OUTER JOIN BRAND B ON B.BRAND_CODE = STD.BRAND_CODE WHERE DCR_ID IN ("+dcrID+") AND STD.STRG_CODE IN("+customers+")";

			pstmt = connectionObject.prepareStatement(displaySql);
			pstmt.setString(1, spCode);
			pstmt.setTimestamp( 2, java.sql.Timestamp.valueOf(eventDate));
			pstmt.setTimestamp( 3, java.sql.Timestamp.valueOf(eventDate));
			// commentted and added by rupali on 19/01/19 for edit mode of display subform [end]
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				valueXmlString.append("<Detail"+formNo+" domID='" + domID + "' selected = 'Y' formName='"+formName+"'>\r\n" );
				valueXmlString.append("<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\"/>\r\n");
				valueXmlString.append("<dcr_id><![CDATA[" ).append(checkNull(rs.getString("DCR_ID"))).append( "]]></dcr_id>\r\n" );
				valueXmlString.append("<line_no><![CDATA[").append(checkNull(rs.getString("LINE_NO"))).append("]]></line_no>\r\n");
				valueXmlString.append("<strg_code><![CDATA[").append(checkNull(rs.getString("STRG_CODE"))).append("]]></strg_code>\n");
				valueXmlString.append("<doc_id><![CDATA[").append(checkNull(rs.getString("DOC_ID"))).append("]]></doc_id>\n");
				valueXmlString.append("<doc_id_1><![CDATA[").append(checkNull(rs.getString("DOC_ID_1"))).append("]]></doc_id_1>\n");
				valueXmlString.append("<display_area><![CDATA[").append( checkNull(rs.getString("DISPLAY_AREA")) ).append("]]></display_area>\r\n");
				//valueXmlString.append("<display_area_no><![CDATA[" ).append( checkNull(rs.getString("DISPLAY_AREA_NO")) ).append( "]]></display_area_no>\r\n" );
				//Added by mrunalini sinkar for CHC chnages for display subform 03-12-2018 (start)
				valueXmlString.append("<disp_type><![CDATA[").append( checkNull(rs.getString("DISP_TYPE")) ).append("]]></disp_type>\r\n");
				valueXmlString.append("<brand_code><![CDATA[").append( checkNull(rs.getString("BRAND_CODE")) ).append("]]></brand_code>\r\n");                                       //Changed by Niraj s on 14-Dec-2018 for change Item_code to brand_code in display form
				valueXmlString.append("<quantity><![CDATA[").append( checkNull(rs.getString("QUANTITY")) ).append("]]></quantity>\r\n");
				//Added by mrunalini sinkar for CHC chnages for display subform 03-12-2018 (end)
				valueXmlString.append( "<tran_id><![CDATA[" ).append(checkNull(rs.getString("TRAN_ID"))).append( "]]></tran_id>\r\n" );//GULZAR ON 04/07/17
				valueXmlString.append( "<target_qty><![CDATA[" ).append(checkNull(rs.getString("TARGET_QTY"))).append( "]]></target_qty>\r\n" ); // commentted and added by rupali on 19/01/19 for edit mode of display subform
				valueXmlString.append("</Detail"+formNo+">\r\n" );
				domID++;
			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		catch(Exception e)
		{
			System.out.println( "Exception :StrgMeetOTCGwtWizardComp :getExistingDndDetailDisplay :" + e.getMessage() + ":" );
			//valueXmlString = valueXmlString.append( genericUtility.createErrorString( e ) );
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		finally
		{
			try
			{
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :StrgMeetOTCGwtWizardComp :defaultDataWiz :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		return valueXmlString.toString();
	}
	public String getDCRIdList(Connection conn, String spCode, String dcrDate) throws ITMException
	{
		String dcrID = "";
		ArrayList dcrIdList = new  ArrayList();
		PreparedStatement pstmtDCRID = null;
		ResultSet rsDCRID = null;
		try
		{
			String activityCode = "";
			E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
			//Added by Gaurav Singh on 04-Dec-2015 [Start]
			/*if ( spCode != null && spCode.trim().length() > 0 )
				{
					spCode = "'" + spCode.replaceAll(",", "','") + "'";
				}*/
			/*else
				{
					spCode = "'" + sprsCode + "'";
				}*/
			//Added by Gaurav Singh on 04-Dec-2015 [End]
			//	System.out.println("spCode >>>>>>>>>>>>>> [" + spCode + "]");

			dcrDate = genericUtility.getValidDateTimeString( dcrDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );

			String dcrSql = "SELECT DCR_ID FROM SPRS_ACT_TRAN A, FIELDACTIVITY B WHERE A.ACTIVITY_CODE = B.ACTIVITY_CODE AND A.EVENT_DATE = ? AND A.SALES_PERS IN ('"+ spCode +"') AND B.ACTIVITY_TYPE <>'PR'" ;

			pstmtDCRID = conn.prepareStatement( dcrSql );
			pstmtDCRID.setTimestamp(1, java.sql.Timestamp.valueOf(dcrDate));
			//pstmtDCRID.setString(2, salesPers);
			rsDCRID = pstmtDCRID.executeQuery();
			while( rsDCRID.next() )
			{
				dcrID = (rsDCRID.getString("DCR_ID") == null )?"":rsDCRID.getString("DCR_ID");
				dcrIdList.add(dcrID);
			}
			dcrID = dcrIdList.toString();
			dcrID = dcrID.replace("[", "");
			dcrID = dcrID.replace("]", "");
			dcrID = dcrID.replace(" ", "");

		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rsDCRID != null)
				{
					rsDCRID.close();
					rsDCRID = null;
				}
				if(pstmtDCRID !=null)
				{
					pstmtDCRID.close();
					pstmtDCRID = null;
				}
			}
			catch(Exception e1){}
		}
		//System.out.println("dcrID =["+dcrID+"]");
		return dcrID;
	}

	public boolean isEmptyDOM(Document dom,String currentForm)
	{
		// System.out.println("isEmptyDOM is called.........");
		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;
		int ctr = 0;
		int noOfChilds = 0;
		int parentListLength = 0;
		boolean flg = true;
		try
		{
			parentList = dom.getElementsByTagName("Detail" + currentForm);
			parentListLength = parentList.getLength();
			if( parentListLength == 1 )
			{
				for (int prntCtr = 0; prntCtr < parentList.getLength(); prntCtr++ )
				{
					parentNode = parentList.item(prntCtr);
					// System.out.println("parentList ........."+parentList.getLength());
					childList = parentNode.getChildNodes();
					noOfChilds = childList.getLength();
					// System.out.println("noOfChilds ........."+noOfChilds);

					for(ctr = 0; ctr < noOfChilds; ctr++)
					{
						childNode = childList.item(ctr);
						if(childNode.getFirstChild() != null)
						{
							flg=false;
							break;
						}
					}
					if(!flg)
					{
						break;
					}
				}
			}
			else if( parentListLength > 1 )
			{
				flg=false;
			}
		}
		catch(Exception e)
		{
			// System.err.println("Exception :isEmptyDOM :\n"+e.getMessage());
			e.printStackTrace();
		}
		return flg;
	}
	public boolean isDeSelEmptyDOM(Document dom,String currentForm,String pstrgCode)
	{
		//System.out.println("isEmptyDOM is called for........."+ currentForm);
		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;
		int ctr = 0;
		int noOfChilds = 0;
		int parentListLength = 0;
		String childNodeName = "";
		String updateFlag = "";
		boolean flg = true;
		String strgCode = "";
		try
		{
			parentList = dom.getElementsByTagName("Detail" + currentForm);
			if(parentList != null)
			{
				parentListLength = parentList.getLength();
			}
			if( parentListLength > 0 )
			{
				for (int prntCtr = 0; prntCtr < parentList.getLength(); prntCtr++ )
				{

					parentNode = parentList.item(prntCtr);
					// System.out.println("parentList ........."+parentList.getLength());
					childList = parentNode.getChildNodes();
					noOfChilds = childList.getLength();
					// System.out.println("noOfChilds ........."+noOfChilds);

					for(ctr = 0; ctr < noOfChilds; ctr++)
					{
						childNode = childList.item(ctr);
						if( childNode.getNodeType() != Node.ELEMENT_NODE )
						{
							continue;
						}
						childNodeName = childNode.getNodeName();

						//System.out.println("childNodeName =["+childNodeName+"]");
						if(childNodeName.equalsIgnoreCase("attribute"))
						{
							if(childNode.getAttributes().getNamedItem("updateFlag") != null)
							{
								updateFlag = checkNull(childNode.getAttributes().getNamedItem("updateFlag").getNodeValue());
							}
						}
						else if(childNodeName.equalsIgnoreCase("strg_code"))
						{
							if( childNode.getFirstChild() != null )
							{
								strgCode = childNode.getFirstChild().getNodeValue();
							}
						}
						if(!updateFlag.equalsIgnoreCase("D"))
						{
							childNode = childList.item(ctr);
							if ( strgCode.equals( pstrgCode ) )
							{
								if(childNode.getFirstChild() != null)
								{
									flg=false;
									break;
								}
							}
						}
					}
					if(!flg)
					{
						break;
					}
				}
			}

		}
		catch(Exception e)
		{
			// System.err.println("Exception :isEmptyDOM :\n"+e.getMessage());
			e.printStackTrace();
		}
		return flg;
	}
	public String getObjNameFromDom( Document dom, String attribute , int currFormNo) throws ITMException
	{
		String objName = "";
		try
		{
			NodeList detailList = null;
			Node currDetail = null,reqDetail = null;
			int	detailListLength = 0;

			detailList = dom.getElementsByTagName("Detail" + currFormNo);
			detailListLength = detailList.getLength();
			for (int ctr = 0;ctr < detailListLength;ctr++)
			{
				currDetail = detailList.item(ctr);
				if( currDetail.getAttributes().getNamedItem(attribute) != null )
				{
					objName = currDetail.getAttributes().getNamedItem(attribute).getNodeValue();
					break;
				}
			}
			if( (objName == null || objName.trim().length() == 0) && currFormNo != 1 )
			{
				detailList = dom.getElementsByTagName("Detail1");
				detailListLength = detailList.getLength();
				for (int ctr = 0;ctr < detailListLength;ctr++)
				{
					currDetail = detailList.item(ctr);
					if( currDetail.getAttributes().getNamedItem(attribute) != null )
					{
						objName = currDetail.getAttributes().getNamedItem(attribute).getNodeValue();
						break;
					}
				}
			}
			if(objName == null || objName.trim().length() == 0)
			{
				NodeList objNameList = dom.getElementsByTagName("objName");
				if(objNameList != null && objNameList.getLength() > 0)
				{
					Node objNameNode = objNameList.item(0);
					if(objNameNode != null && objNameNode.getFirstChild() != null)
					{
						objName = checkNull(objNameNode.getFirstChild().getNodeValue());
					}
				}
			}
		}
		catch(Exception e)
		{
			System.out.println("Exception Inside getObjNameFromDom ::["+e.getMessage()+"]");
			e.printStackTrace();
		}
		return objName;
	}
	public String getFormNo(String objName, String formName, Connection connectionObject) throws ITMException
	{
		Statement stmt = null;
		ResultSet rs = null;
		String formNo = "";
		try
		{
			String sql = "SELECT FORM_NO FROM OBJ_FORMS WHERE WIN_NAME = '"+"w_"+objName+"'AND FORM_NAME = '"+formName+"'";
			stmt = connectionObject.createStatement();
			rs = stmt.executeQuery(sql);
			if( rs.next() )
			{
				formNo = checkNull(rs.getString("FORM_NO"));
			}
			if( rs !=null )
			{
				rs.close();
				rs = null;
			}
			if( stmt !=null )
			{
				stmt.close();
				stmt = null;
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		return formNo;
	}

	public HashMap getSubForms(String formNo, String objName, Connection conn) throws ITMException
	{
		PreparedStatement pStmt = null;
		PreparedStatement pStmtInner = null;
		ResultSet rs = null;
		ResultSet rsInner = null;
		String formType = "";
		HashMap<String, String> SubFormMap = new LinkedHashMap<String,String>();
		try
		{
			String winName = "w_"+objName;
			String sql = "SELECT FORM_NO,FORM_TYPE FROM OBJ_FORMS WHERE WIN_NAME = ? AND FORM_NO = ?";
			pStmt = conn.prepareStatement(sql);
			pStmt.setString(1, winName);
			pStmt.setString(2, formNo);
			rs = pStmt.executeQuery();
			if( rs.next() )
			{
				formType = checkNull(rs.getString("FORM_TYPE"));
			}
			if( rs !=null )
			{
				rs.close();
				rs = null;
			}
			if( pStmt !=null )
			{
				pStmt.close();
				pStmt = null;
			}
			String[] nextArr = formType.split(":",3);
			String  nextForm= nextArr[2];
			//System.out.println("nextForm val is :-"+nextForm);
			int nextFormNo = 0;
			int currFormNo = 0;
			if( nextForm != null && nextForm.trim().length() > 0 )
			{
				nextFormNo = Integer.parseInt( nextForm );
			}
			if( formNo != null && formNo.trim().length() > 0 )
			{
				currFormNo = Integer.parseInt( formNo );
			}
			String formNameSql = "SELECT FORM_NO,FORM_NAME FROM OBJ_FORMS WHERE WIN_NAME = ? AND FORM_NO = ? ";
			pStmtInner = conn.prepareStatement(formNameSql);

			for(int i = (currFormNo+1) ; i< nextFormNo; i++)
			{
				pStmtInner.setString(1, winName);
				pStmtInner.setInt(2, i);

				rsInner = pStmtInner.executeQuery();

				if(rsInner.next())
				{
					String _formNo = checkNull(rsInner.getString("FORM_NO"));
					String _formName = checkNull(rsInner.getString("FORM_NAME"));
					SubFormMap.put( _formName,_formNo);
				}
				pStmtInner.clearParameters();
				if( rsInner !=null )
				{
					rsInner.close();
					rsInner = null;
				}
			}

		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		finally
		{
			try
			{
				if( rs !=null )
				{
					rs.close();
					rs = null;
				}
				if( pStmt !=null )
				{
					pStmt.close();
					pStmt = null;
				}
				if( pStmtInner !=null )
				{
					pStmtInner.close();
					pStmtInner = null;
				}

			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return SubFormMap;
	}
	public String getParentformNo(String subFormNo, String objName, Connection conn) throws ITMException
	{
		PreparedStatement pStmt = null;
		ResultSet rs = null;
		int subFormNum = 0;
		String formNumber = "";
		String formType = "";
		boolean isMainForm = false;
		//System.out.println("subFormNosubFormNo"+subFormNo+"objName"+objName);
		try
		{
			String winName = "w_"+objName;
			if(conn == null)
			{
				conn = getConnection();
			}
			if( subFormNo != null && subFormNo.trim().length() > 0 )
			{
				subFormNum = Integer.parseInt( subFormNo );
			}
			String sql  = "SELECT FORM_NO,FORM_TYPE FROM OBJ_FORMS WHERE WIN_NAME = ? AND TO_NUMBER(FORM_NO) = ? ";
			pStmt = conn.prepareStatement(sql);

			for(int j = subFormNum; j>=1; j--)
			{
				pStmt.setString(1, winName);
				pStmt.setString(2, ""+j);

				rs = pStmt.executeQuery();
				if(rs.next())
				{
					formNumber = checkNull(rs.getString("FORM_NO"));
					formType = checkNull(rs.getString("FORM_TYPE"));
					//System.out.println("Value for sub form["+j+"] is [formtype ["+formType+"] form no is ["+formNumber+"]");
					if(formType.indexOf("MP")>=0)
					{
						isMainForm = true;
					}
				}
				pStmt.clearParameters();
				if( rs !=null )
				{
					rs.close();
					rs = null;
				}
				if(isMainForm)
				{
					break;
				}
			}
			if( rs !=null )
			{
				rs.close();
				rs = null;
			}

		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		finally
		{
			try
			{
				if( rs !=null )
				{
					rs.close();
					rs = null;
				}
				if( pStmt !=null )
				{
					pStmt.close();
					pStmt = null;
				}

			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		//System.out.println("formNumaver val:- "+formNumber);
		return formNumber;
	}

	public String getSplDescr(String strgCode,String sprsCode,Connection connectionObject) throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		PreparedStatement pstmt1 = null;
		ResultSet rs1 = null;

		String splCode = "";
		String spclDescr = "";
		try
		{

			String sql  = "SELECT SPL_CODE FROM STRG_SERIES WHERE SC_CODE  = ? AND SALES_PERS = ?";
			pstmt = connectionObject.prepareStatement(sql);
			pstmt.setString(1, strgCode);
			pstmt.setString(2, sprsCode);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				splCode = checkNull(rs.getString("SPL_CODE"));
			}
			//System.out.println("splCode splCode val:- "+splCode);
			if( rs !=null )
			{
				rs.close();
				rs = null;
			}
			if( pstmt !=null )
			{
				pstmt.close();
				pstmt = null;
			}

			if (splCode.length() > 0)
			{
				String sql1  = "SELECT DESCR FROM SPECIALITY WHERE SPL_CODE = ?";
				pstmt1 = connectionObject.prepareStatement(sql1);
				pstmt1.setString(1, splCode);
				rs1 = pstmt1.executeQuery();
				if(rs1.next())
				{
					spclDescr = checkNull(rs1.getString("DESCR"));
				}
				//System.out.println("spclDescr spclDescr val:- "+spclDescr);
				if( rs1 !=null )
				{
					rs1.close();
					rs1 = null;
				}
				if( pstmt1 !=null )
				{
					pstmt1.close();
					pstmt1 = null;
				}
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		finally
		{
			try
			{
				if( rs !=null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt !=null )
				{
					pstmt.close();
					pstmt = null;
				}
				if( rs1 !=null )
				{
					rs1.close();
					rs1 = null;
				}
				if( pstmt1 !=null )
				{
					pstmt1.close();
					pstmt1 = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		//System.out.println("spclDescr val:- "+spclDescr);
		return spclDescr;
	}
	public String getPitchTranId(Connection conn)throws ITMException
	{
		String tranId ="";
		PreparedStatement pstmtNextSeq = null;
		ResultSet rsNextSeq = null;
		//CHANGES DONE IN SQL FOR DB2 GETTIN ISSUE BY PRATHAMESH JANGAM ON 04/7/17
		String dbName =CommonConstants.DB_NAME;
		String getNextSeqSql= null;

		try
		{
			String nextSeq = "";
			String tempScCode = "0000000000";
			//changes done by prathamesh jangam for db2 in sql
			if(dbName.equalsIgnoreCase("DB2"))
			{
				getNextSeqSql = "select next value for SEQ_TRAN_ID AS NEXT_SEQ from DUAL";
			}
			else if(dbName.equalsIgnoreCase("ORACLE"))
			{
				getNextSeqSql = "SELECT SEQ_TRAN_ID.NEXTVAL AS NEXT_SEQ FROM DUAL";
			}

			pstmtNextSeq = conn.prepareStatement(getNextSeqSql);
			rsNextSeq = pstmtNextSeq.executeQuery();
			if(rsNextSeq.next())
			{
				nextSeq = rsNextSeq.getString("NEXT_SEQ");
			}
			tempScCode = tempScCode + nextSeq;
			tranId = tempScCode.substring(tempScCode.length()-10);
		}
		catch(Exception e)
		{
			//System.out.println("Exception getPitchTranId()::: "+ e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rsNextSeq != null)
				{
					rsNextSeq.close();
					rsNextSeq = null;
				}
				if (pstmtNextSeq != null)
				{
					pstmtNextSeq.close();
					pstmtNextSeq = null;
				}

			}
			catch(Exception e)
			{
				//System.out.println("Exception getPitchTranId() "+ e.getMessage());
			}
		}
		return tranId;
	}
	private ArrayList getDomIdListFromDom( Document dom, String attribute , int currFormNo) throws ITMException
	{
		String domID = "";
		ArrayList allSelectedDomIdList = new ArrayList();
		try
		{
			NodeList detailList = null;
			Node currDetail = null,reqDetail = null;
			int	detailListLength = 0;

			detailList = dom.getElementsByTagName("Detail" + currFormNo);
			detailListLength = detailList.getLength();
			for (int ctr = 0;ctr < detailListLength;ctr++)
			{
				currDetail = detailList.item(ctr);
				domID = currDetail.getAttributes().getNamedItem(attribute).getNodeValue();
				int intDomID = Integer.parseInt(domID);
				//System.out.println("DomiD value is := "+domID);
				allSelectedDomIdList.add(intDomID);

			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		//System.out.println("allSelected Donm id on previous DAR:- "+allSelectedDomIdList);
		return allSelectedDomIdList;
	}
	public String geteventTime()
	{
		Date date = new Date();
		String strDateFormat = "hh:mm a";
		DateFormat dateFormat = new SimpleDateFormat(strDateFormat);
		String formattedDate= dateFormat.format(date);
		//System.out.println("Current time of the day using Date - 12 hour format: " + formattedDate);
		return formattedDate;
	}

	public String getPriorVisits( String sprsCode, String strgCode, String eventDate, String tranId, Connection conn) throws ITMException //added by rupali on 06/03/17
	{

		//System.out.println("Inside getPriorVisits::::::::::::::::::"+eventDate);
		String visitDates = "";
		String sql="";
		PreparedStatement pstmtPriorVisit = null;
		ResultSet rsPriorVisit = null;
		PreparedStatement pstmt1 = null;
		PreparedStatement pstmtSfaParm = null;
		ResultSet rs1 = null;
		ResultSet rsSfaParm = null;
		int priorDate = 0;
		String parmValue = "";
		String scName = "";
		String newDate=null;
		String address = "";
		String addr1 = "";
		String addr2 = "";
		String addr3 = "";
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		int maxDate = 0;
		//Connection conn =null;
		StringBuffer sb = new StringBuffer();
		System.out.println("eventDate:::>>>:["+eventDate+"]");
		String currDcrDate = eventDate;//Added by vinayak on [28/07/16]
		boolean isLocalConn =false;
		String formatDate = "";
		StringBuffer valueXmlString = new StringBuffer("<Root>\r\n");
		try
		{
			//chnged by sachin satre on 9-nov-16 start
			if(conn == null)
			{
				/*ConnDriver connDriver = new ConnDriver();
					conn = connDriver.getConnectDB("DriverITM");*/
				conn =getConnection();//chnged by sachin satre on 9-nov-16
				isLocalConn =true;
			}
			//chnged by sachin satre on 9-nov-16 end
			int visitDtCnt = 0;
			SimpleDateFormat dtFormat = new SimpleDateFormat(genericUtility.getDBDateTimeFormat());
			String currDate = dtFormat.format(new java.util.Date());
			String reportTime=getSfaParmValue(sprsCode,"REPORT_TIME",conn); // added by mrunalini sinkar on 2-jul-2018(start)
			// added by rupali on 19/03/18 for showing data in dashboard link [start]
			if(tranId != null && tranId.trim().length() != 0)
			{
				String tranIdSql = "SELECT STRG_CODE, EVENT_DATE FROM STRG_MEET WHERE TRAN_ID = ?";
				pstmt1 = conn.prepareStatement(tranIdSql);
				pstmt1.setString(1,tranId);
				rs1=pstmt1.executeQuery();
				if(rs1.next())
				{
					strgCode = checkNull(rs1.getString("STRG_CODE"));
					eventDate = checkNull(rs1.getString("EVENT_DATE"));
					eventDate = genericUtility.getValidDateTimeString( eventDate, genericUtility.getDBDateFormat(),genericUtility.getApplDateFormat() );
					System.out.println("eventDate is:::>>>:["+eventDate+"] strgCode:::>>>:["+strgCode+"]");
				}
				if(rs1 != null)
				{
					rs1.close();
					rs1 = null;
				}
				if(pstmt1 != null)
				{
					pstmt1.close();
					pstmt1 = null;
				}
				currDcrDate = eventDate;
			}
			// added by rupali on 19/03/18 for showing data in dashboard link [end]
			String strgSql = "SELECT SC.SC_CODE CODE, UPPER(SC.FIRST_NAME)||' '||UPPER(SC.LAST_NAME) AS SC_NAME FROM STRG_CUSTOMER SC WHERE SC.SC_CODE = ? ";
			pstmt1 = conn.prepareStatement(strgSql);
			pstmt1.setString(1,strgCode);
			rs1=pstmt1.executeQuery();

			if(rs1.next())
			{
				scName = checkNull(rs1.getString("SC_NAME"));
			}
			System.out.println("scName =["+scName+"]");
			if(rs1 != null)
			{
				rs1.close();
				rs1 = null;
			}
			if(pstmt1 != null)
			{
				pstmt1.close();
				pstmt1 = null;
			}

			String sfaParmSql = "SELECT PARM_VALUE FROM SFAPARM WHERE PARM_NAME='STRG_PRIOR_VISITS' AND ? BETWEEN EFF_FROM AND VALID_UPTO AND ACTIVE='Y' ";
			pstmtSfaParm = conn.prepareStatement(sfaParmSql);
			pstmtSfaParm.setTimestamp(1, java.sql.Timestamp.valueOf(currDate));
			rsSfaParm = pstmtSfaParm.executeQuery();
			if (rsSfaParm.next())
			{
				parmValue = checkNull(rsSfaParm.getString("parm_value"));
			}
			if(rsSfaParm != null)
			{
				rsSfaParm.close();
				rsSfaParm = null;
			}
			if(pstmtSfaParm != null)
			{
				pstmtSfaParm.close();
				pstmtSfaParm = null;
			}
			System.out.println("parmValue[STRG_PRIOR_VISITS] =["+parmValue+"]");
			if(parmValue.length() > 0)
			{
				try
				{
					priorDate = Integer.parseInt(parmValue);
				}
				catch(NumberFormatException nfe )
				{
					priorDate = 0;
				}
			}
			/*if(currDcrDate.length()>0)
				{
					   //create SimpleDateFormat object with source string date format
				      SimpleDateFormat sdfSource = new SimpleDateFormat(genericUtility.getApplDateFormat());

				      Date date = sdfSource.parse(currDcrDate);
				      SimpleDateFormat sdfDestination = new SimpleDateFormat("MM-yy");
				      formatDate = sdfDestination.format(date);
				      formatDate = "%"+ formatDate;
				}*/
			//added by kailash on 29/03/17:start -for taking current month prior_visit
			if(currDcrDate != null && currDcrDate.trim().length()>0) // changes made by rupali on 25/07/18 for showing prior visits on customer and series master
			{
				//create SimpleDateFormat object with source string date format
				SimpleDateFormat sdfSource = new SimpleDateFormat(genericUtility.getApplDateFormat());
				java.util.Date date1 = sdfSource.parse(currDcrDate);
				Calendar cal = Calendar.getInstance();
				cal.setTime(date1);
				int dateVal = cal.get(Calendar.DATE);
				System.out.println("dateVal =["+dateVal+"]");
				cal.set(Calendar.DATE, 1);
				dateVal = cal.get(Calendar.DATE);
				System.out.println("dateVal =["+dateVal+"]");

				newDate = sdfSource.format(cal.getTime());
				System.out.println("newDate =["+newDate+"]");

			}
			//added by kailash on 29/03/17:end
			HashMap callNoteTypeMap = getCallNoteTypeMap(conn);

			if(eventDate != null && eventDate.trim().length()>0) // changes made by rupali on 25/07/18 for showing prior visits on customer and series master
			{
				eventDate = genericUtility.getValidDateTimeString( eventDate , getApplDateFormat() , getDBDateFormat());
			}
			//added by kailash on 29/03/2017 start
			if(newDate != null && newDate.trim().length()>0) // changes made by rupali on 25/07/18 for showing prior visits on customer and series master
			{
				newDate = genericUtility.getValidDateTimeString( newDate , getApplDateFormat() , getDBDateFormat());
			}
			//added by kailash on 29/03/2017 end

			//Commented by vinayak on [28/07/16] [changeed sql to show calloutcome][start]
			/*String priorVisitSql = " select  to_char(sm.event_date,'dd/mm/yyyy') as VisitDates,sm.meet_summ as callNotes,sm.remarks as remark from strg_meet sm,fieldactivity fa "+
					  " where sm.event_type = fa.activity_code and fa.activity_type not in ('LEAVE','NFW') and sm.strg_code = ? "+
					  " and sm.sales_pers = ? "+
					  " and sm.event_date <  ? order by sm.event_date desc ";*/
			//Commented by vinayak on [28/07/16] [changed sql to show calloutcome][end]

			//Commented by rupali on  15/03/17 changeed sql to show address of customer[start]
			//Added by vinayak on [28/07/16] [changeed sql to show calloutcome][start]
			/* String priorVisitSql = " select  to_char(sm.event_date,'dd-Mon-yy') as VisitDates,sm.meet_summ as callNotes,sm.remarks as remark,sm.call_outcome as callOutCome,sm.event_time_start as eventTime from strg_meet sm,fieldactivity fa "+
				  " where sm.event_type = fa.activity_code and fa.activity_type not in ('LEAVE','NFW') and sm.strg_code = '"+strgCode+"' "+
				  " and sm.sales_pers = '"+sprsCode+"' "+
				  " and sm.event_date <  ? order by sm.event_date desc "; */
			//Added by vinayak on [28/07/16] [changeed sql to show calloutcome][end]
			//Commented by rupali on  15/03/17 changeed sql to show address of customer[start]

			//added by Rupali on 15/03/17 for adding address column in prior visit [start]
			String priorVisitSql="";
			if(eventDate != null && eventDate.trim().length()>0) // changes made by rupali on 25/07/18 for showing prior visits on customer and series master
			{
				if("ORACLE".equalsIgnoreCase(CommonConstants.DB_NAME))
				{
					priorVisitSql = " select  to_char(sm.event_date,'dd-Mon-yy') as VisitDates,sm.meet_summ as callNotes,sm.remarks as remark,sm.call_outcome as callOutCome,sm.event_time_start as eventTime,sc.addr1 as addr1,sc.addr2 addr2,sc.addr3 addr3 from strg_meet sm,fieldactivity fa,strg_customer sc "+
							" where sm.event_type = fa.activity_code and fa.activity_type in ('FW') and sm.strg_code = '"+strgCode+"' "+
							" and sm.sales_pers = '"+sprsCode+"' "+
							" and sm.strg_code = sc.sc_code"+
							" and sm.event_date <  ? and sm.event_date >= ? order by sm.event_date desc ";
				}
				else if("DB2".equalsIgnoreCase(CommonConstants.DB_NAME))
				{
					priorVisitSql = " select translate(char(date(event_date ),EUR),'/','.') AS VisitDates,sm.meet_summ as callNotes,sm.remarks as remark,sm.call_outcome as callOutCome,sm.event_time_start as eventTime,sc.addr1 as addr1,sc.addr2 addr2,sc.addr3 addr3 from strg_meet sm,fieldactivity fa,strg_customer sc "+
							" where sm.event_type = fa.activity_code and fa.activity_type in ('FW') and sm.strg_code = '"+strgCode+"' "+
							" and sm.sales_pers = '"+sprsCode+"' "+
							" and sm.strg_code = sc.sc_code"+
							" and sm.event_date <  ? and sm.event_date >= ? order by sm.event_date desc ";
				}
				//added by kailash on 29/03/17 for taking current month date[end]
				//added by Rupali on 15/03/17 for adding address column in prior visit [end]

				System.out.println("priorVisitSql+++"+priorVisitSql);
				pstmtPriorVisit = conn.prepareStatement(priorVisitSql);
				//pstmtPriorVisit.setString(1,strgCode);
				//pstmtPriorVisit.setString(2,sprsCode);
				pstmtPriorVisit.setTimestamp(1,java.sql.Timestamp.valueOf(eventDate));
				//added by kailash on 29/03/17 start -for adding current month date into prepare statement
				pstmtPriorVisit.setTimestamp(2,java.sql.Timestamp.valueOf(newDate));
				//added by kailash on 29/03/17 end
			}
			// added by rupali on 25/07/18 for showing prior visits on customer and series master [start]
			else
			{
				if("ORACLE".equalsIgnoreCase(CommonConstants.DB_NAME))
				{
					priorVisitSql = " select  to_char(sm.event_date,'dd-Mon-yy') as VisitDates,sm.meet_summ as callNotes,sm.remarks as remark,sm.call_outcome as callOutCome,sm.event_time_start as eventTime,sc.addr1 as addr1,sc.addr2 addr2,sc.addr3 addr3 from strg_meet sm,fieldactivity fa,strg_customer sc "+
							" where sm.event_type = fa.activity_code and fa.activity_type in ('FW') and sm.strg_code = '"+strgCode+"' "+
							" and sm.strg_code = sc.sc_code"+
							" order by sm.event_date desc ";
				}
				else if("DB2".equalsIgnoreCase(CommonConstants.DB_NAME))
				{
					priorVisitSql = " select translate(char(date(event_date ),EUR),'/','.') AS VisitDates,sm.meet_summ as callNotes,sm.remarks as remark,sm.call_outcome as callOutCome,sm.event_time_start as eventTime,sc.addr1 as addr1,sc.addr2 addr2,sc.addr3 addr3 from strg_meet sm,fieldactivity fa,strg_customer sc "+
							" where sm.event_type = fa.activity_code and fa.activity_type in ('FW') and sm.strg_code = '"+strgCode+"' "+
							" and sm.strg_code = sc.sc_code"+
							" order by sm.event_date desc ";
				}
				System.out.println("priorVisitSql+++"+priorVisitSql);
				pstmtPriorVisit = conn.prepareStatement(priorVisitSql);
			}
			// added by rupali on 25/07/18 for showing prior visits on customer and series master [end]
			rsPriorVisit = pstmtPriorVisit.executeQuery();
			System.out.println("After Query");
			while (rsPriorVisit.next())
			{
				System.out.println("inside while loop.... ::");
				visitDtCnt++;

				String VisitDates = checkNull(rsPriorVisit.getString("VisitDates"));
				String callNotes = checkNull(rsPriorVisit.getString("callNotes"));
				String docRemark =  checkNull(rsPriorVisit.getString("remark")); //Added by vinayak to add remark column in prior visit on [03/05/2016]
				String callOutCome =  checkNull(rsPriorVisit.getString("callOutCome"));//Added by vinayak on [28/07/16]
				String eventTime =  checkNull(rsPriorVisit.getString("eventTime"));
				//added by Rupali on 15/03/17 for adding address column in prior visit [start]
				addr1 = checkNull(rsPriorVisit.getString("addr1"));
				addr2 = checkNull(rsPriorVisit.getString("addr2"));
				addr3 = checkNull(rsPriorVisit.getString("addr3"));
				address = addr1 +", "+addr2 +", "+addr3;
				//added by Rupali on 15/03/17 for adding address column in prior visit [end]
				if(callNotes.length() > 0)
				{
					String callNotesArr[] = callNotes.split(",");

					for(int i = 0; i < callNotesArr.length; i++)
					{
						String singleNotes = callNotesArr[i];

						if(singleNotes != null && singleNotes.trim().length() > 0)
						{
							String singleNoteArr[] = singleNotes.split(":");

							String noteType = "";
							String callNote = "";
							if(singleNoteArr.length >= 2)
							{
								noteType = checkNull(singleNoteArr[1]);
								callNote =checkNull(singleNoteArr[2]);
							}
							valueXmlString.append("<prior_visit >\r\n");
							if("DB2".equalsIgnoreCase(CommonConstants.DB_NAME))
							{
								System.out.println("inside db2");
								SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
								Date date = sdf.parse(VisitDates);
								sdf = new SimpleDateFormat("dd-MMM-yy");
								String visitEventDate=sdf.format(date);
								System.out.println("visitEventDate is"+visitEventDate);
								valueXmlString.append("<event_date><![CDATA[").append(visitEventDate).append("]]></event_date>\r\n");
							}
							else if("ORACLE".equalsIgnoreCase(CommonConstants.DB_NAME))
							{
								valueXmlString.append("<event_date><![CDATA[").append(VisitDates).append("]]></event_date>\r\n");
							}
							valueXmlString.append("<call_notes><![CDATA[" ).append(checkNull(callNote)).append( "]]></call_notes>\r\n" );
							valueXmlString.append("<remarks><![CDATA[").append(checkNull(docRemark)).append("]]></remarks>\r\n");//Added by vinayak to add remark column in prior visit on [03/05/2016]
							valueXmlString.append("<note_type><![CDATA[").append(checkNull((String)callNoteTypeMap.get(noteType))).append("]]></note_type>\r\n");
							valueXmlString.append("<strg_code><![CDATA[").append(checkNull(strgCode)).append("]]></strg_code>\r\n");
							valueXmlString.append("<strg_name><![CDATA[").append(checkNull(scName)).append("]]></strg_name>\r\n");
							valueXmlString.append("<call_outcome><![CDATA[").append(checkNull(callOutCome)).append("]]></call_outcome>\r\n");//Added by vinayak on [28/07/16] to get call outcome
							valueXmlString.append("<dcr_date><![CDATA[").append(checkNull(currDcrDate)).append("]]></dcr_date>\r\n");//Added by vinayak on [28/07/16]
							valueXmlString.append("<event_time_start><![CDATA[").append(checkNull(eventTime)).append("]]></event_time_start>\r\n");
							valueXmlString.append("<address><![CDATA[").append(checkNull(address)).append("]]></address>\r\n"); //added by Rupali on 15/03/17 for adding address column in prior visit
							valueXmlString.append("<report_time><![CDATA[").append(checkNull(reportTime)).append("]]></report_time>\r\n"); // added by mrunalini sinkar on 02-july-2018
							valueXmlString.append("</prior_visit>\r\n");
						}
					}

				}
				else
				{
					System.out.println("inside else loop.... ::");
					valueXmlString.append("<prior_visit >\r\n");
					if("DB2".equalsIgnoreCase(CommonConstants.DB_NAME))
					{
						System.out.println("inside db2");
						SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
						Date date = sdf.parse(VisitDates);
						sdf = new SimpleDateFormat("dd-MMM-yy");
						String visitEventDate=sdf.format(date);
						System.out.println("visitEventDate is"+visitEventDate);
						valueXmlString.append("<event_date><![CDATA[").append(visitEventDate).append("]]></event_date>\r\n");
					}
					else if("ORACLE".equalsIgnoreCase(CommonConstants.DB_NAME))
					{
						valueXmlString.append("<event_date><![CDATA[").append(VisitDates).append("]]></event_date>\r\n");
					}
					valueXmlString.append("<call_notes><![CDATA[" ).append("").append( "]]></call_notes>\r\n" );
					valueXmlString.append("<remarks><![CDATA[").append("").append("]]></remarks>\r\n");//Added by vinayak to add remark column in prior visit on [03/05/2016]
					valueXmlString.append("<note_type><![CDATA[").append("").append("]]></note_type>\r\n");
					valueXmlString.append("<strg_code><![CDATA[").append(checkNull(strgCode)).append("]]></strg_code>\r\n");
					valueXmlString.append("<strg_name><![CDATA[").append(checkNull(scName)).append("]]></strg_name>\r\n");
					valueXmlString.append("<call_outcome><![CDATA[").append(checkNull(callOutCome)).append("]]></call_outcome>\r\n");//Added by vinayak on [28/07/16] to get call outcome
					valueXmlString.append("<dcr_date><![CDATA[").append(checkNull(currDcrDate)).append("]]></dcr_date>\r\n");//Added by vinayak on [28/07/16]
					valueXmlString.append("<event_time_start><![CDATA[").append(checkNull(eventTime)).append("]]></event_time_start>\r\n");
					valueXmlString.append("<address><![CDATA[").append(checkNull(address)).append("]]></address>\r\n"); //added by Rupali on 15/03/17 for adding address column in prior visit
					valueXmlString.append("<report_time><![CDATA[").append(checkNull(reportTime)).append("]]></report_time>\r\n"); // added by mrunalini sinkar on 02-july-2018
					valueXmlString.append("</prior_visit>\r\n");

				}

				if(priorDate > 0 && visitDtCnt == priorDate)
				{
					break;
				}

			}
			//Added by Hariom for dirty connection close - 11-Feb-2021 [Start]
			if( rsPriorVisit !=null )
			{
				rsPriorVisit.close();
				rsPriorVisit = null;
			}
			if( pstmtPriorVisit !=null )
			{
				pstmtPriorVisit.close();
				pstmtPriorVisit = null;
			}
			//Added by Hariom for dirty connection close - 11-Feb-2021 [End]
			if(visitDtCnt == 0)
			{
				String addressSql = "select addr1,addr2,addr3 from strg_customer where sc_code = ?";
				pstmt1 = conn.prepareStatement(addressSql);
				pstmt1.setString(1,strgCode);
				rs1=pstmt1.executeQuery();
				if(rs1.next())
				{
					addr1 = checkNull(rs1.getString("addr1"));
					addr2 = checkNull(rs1.getString("addr2"));
					addr3 = checkNull(rs1.getString("addr3"));
				}
				address = addr1 +", "+addr2 +", "+addr3;
				if(rs1 != null)
				{
					rs1.close();
					rs1 = null;
				}
				if(pstmt1 != null)
				{
					pstmt1.close();
					pstmt1 = null;
				}
				System.out.println("outside while loop.... ::");
				valueXmlString.append("<prior_visit >\r\n");
				valueXmlString.append("<event_date><![CDATA[").append("").append("]]></event_date>\r\n");
				valueXmlString.append("<call_notes><![CDATA[" ).append("").append( "]]></call_notes>\r\n" );
				valueXmlString.append("<remarks><![CDATA[").append("").append("]]></remarks>\r\n");//Added by vinayak to add remark column in prior visit on [03/05/2016]
				valueXmlString.append("<note_type><![CDATA[").append("").append("]]></note_type>\r\n");
				valueXmlString.append("<strg_code><![CDATA[").append(checkNull(strgCode)).append("]]></strg_code>\r\n");
				valueXmlString.append("<strg_name><![CDATA[").append(checkNull(scName)).append("]]></strg_name>\r\n");
				valueXmlString.append("<call_outcome><![CDATA[").append("").append("]]></call_outcome>\r\n");//Added by vinayak on [28/07/16] to get call outcome
				valueXmlString.append("<dcr_date><![CDATA[").append(checkNull(currDcrDate)).append("]]></dcr_date>\r\n");//Added by vinayak on [28/07/16]
				valueXmlString.append("<event_time_start><![CDATA[").append("").append("]]></event_time_start>\r\n");
				valueXmlString.append("<address><![CDATA[").append(checkNull(address)).append("]]></address>\r\n"); //added by Rupali on 15/03/17 for adding address column in prior visit
				valueXmlString.append("</prior_visit>\r\n");
			}

		}

		catch(Exception e)
		{
			//System.out.println("Exception:----");
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(rs1 != null)
				{
					rs1.close();
					rs1 = null;
				}
				if(pstmt1 != null)
				{
					pstmt1.close();
					pstmt1 = null;
				}
				if(rsPriorVisit != null)
				{
					rsPriorVisit.close();
					rsPriorVisit = null;
				}
				if(pstmtPriorVisit != null)
				{
					pstmtPriorVisit.close();
					pstmtPriorVisit = null;
				}
				if(isLocalConn && conn != null && ! conn.isClosed() )
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{

			}
		}
		valueXmlString.append( "</Root>\r\n" );
		System.out.println( "\n****ValueXmlString :" + valueXmlString.toString() + ":********" );
		return valueXmlString.toString();

	}

	private HashMap getCallNoteTypeMap (Connection conn ) throws ITMException  //added by rupali on 06/03/17
	{
		PreparedStatement pstmtNoteType = null;
		ResultSet rsNoteType = null;
		HashMap callNoteTypeMap = new HashMap();
		String noteType = "";
		String descr = "";
		String shDescr = "";

		try
		{

			String noteTypeSql = "SELECT NOTE_TYPE, DESCR, SH_DESCR, REQ_FOLL_UP, TASK_TYPE FROM CALL_NOTE_TYPE ";
			pstmtNoteType = conn.prepareStatement(noteTypeSql);
			rsNoteType = pstmtNoteType.executeQuery();

			while(rsNoteType.next())
			{
				noteType = checkNull(rsNoteType.getString("NOTE_TYPE"));
				descr = checkNull(rsNoteType.getString("DESCR"));
				shDescr = checkNull(rsNoteType.getString("SH_DESCR"));

				callNoteTypeMap.put(noteType, shDescr);

			}
			//Added by Hariom for dirty connection close - 11-Feb-2021 [Start]
			if (rsNoteType != null)
			{
				rsNoteType.close();
				rsNoteType = null;
			}
			if(pstmtNoteType !=null)
			{
				pstmtNoteType.close();
				pstmtNoteType = null;
			}
			//Added by Hariom for dirty connection close - 11-Feb-2021 [End]
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rsNoteType != null)
				{
					rsNoteType.close();
					rsNoteType = null;
				}
				if(pstmtNoteType !=null)
				{
					pstmtNoteType.close();
					pstmtNoteType = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		System.out.println("callNoteTypeMap ::"+callNoteTypeMap);
		return callNoteTypeMap;
	}
	public ArrayList getCustType (Connection conn, String userId,String loginCode) throws ITMException  //added by rupali on 06/03/17
	{
		PreparedStatement pstmtCustType = null;
		ResultSet rsCustType = null;
		HashMap callNoteTypeMap = new HashMap();
		String noteType = "";
		String descr = "";
		String shDescr = "";
		ArrayList custTypeList = new ArrayList();

		try
		{


			//commented & Added by mrunalini sinkar to add dcr_group cahnges in strg_cust_type table on 3-dec-2018
			//String custTypeSql = "SELECT TYPE FROM STRG_CUST_TYPE";
			//String custTypeSql = "SELECT DISTINCT(DCR_GROUP) AS DCR_GROUP FROM STRG_CUST_TYPE";
			String custTypeSql = "SELECT DISTINCT(DCR_GROUP) AS DCR_GROUP FROM STRG_CUST_TYPE WHERE ENTERPRISE IS NULL OR (SELECT ENTERPRISE FROM USERS WHERE CODE = ?) " +
					"IN (SELECT REGEXP_SUBSTR(ENTERPRISE,'[^,]+', 1, LEVEL) FROM DUAL CONNECT BY REGEXP_SUBSTR(ENTERPRISE, '[^,]+', 1, LEVEL) IS NOT NULL) ";
			pstmtCustType = conn.prepareStatement(custTypeSql);
			pstmtCustType.setString(1, loginCode);
			rsCustType = pstmtCustType.executeQuery();
			while(rsCustType.next())
			{
				custTypeList.add(checkNull(rsCustType.getString("DCR_GROUP")));
			}
			if(rsCustType != null)
			{
				rsCustType.close();
				rsCustType = null;
			}
			if(pstmtCustType != null)
			{
				pstmtCustType.close();
				pstmtCustType = null;
			}
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rsCustType != null)
				{
					rsCustType.close();
					rsCustType = null;
				}
				if(pstmtCustType !=null)
				{
					pstmtCustType.close();
					pstmtCustType = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return custTypeList;
	}
	// added by rupali on 10/09/17 for added new subform on doctor screen [start]
	public String getBrandSurveyDetails( Document dom, Document dom2 , String salePersCode, String wrkDate , String scCode, String xtraParams, Connection connectionObject ,String formNo,String formName) throws ITMException //Chnaged by sachin satre on 09-nov-16
	{
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		int domID = 1;
		int num = 0;
		StringBuffer valueXmlString = new StringBuffer();
		String wrkDateInDbFmt = "";
		String selectedItem = "";
		String dcrId="";
		String sql="";
		String userId="";
		String dcrID="";
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		boolean isLocalConn =false;
		try
		{
			if(connectionObject ==  null )
			{
				connectionObject = getConnection();
				isLocalConn =true;
			}
			DateFormat dtFormat = new SimpleDateFormat(getApplDateFormat());
			java.util.Date date = Calendar.getInstance().getTime();
			String currDate = dtFormat.format( date );
			userId = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" );
			if( "".equalsIgnoreCase( checkNull( salePersCode ) ) )
			{
				salePersCode = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginEmpCode" );
			}


			String [] temp = scCode.split(",");
			if ( preDomExists( dom2, formNo ))
			{
				selectedItem = getPrevFormValues( dom2, formNo, new ArrayList<String>(Arrays.asList(temp)), "strg_code" ) ;
			}
			else
			{
				String newScCode = "";
				if(scCode != null && scCode.trim().length() > 0 && scCode.indexOf("'") == -1)
				{
					newScCode = "'"+scCode+"'";
				}
				else
				{
					newScCode = scCode;
				}
				System.out.println("bfor getExistingSurveyDetail selectedItem>>>"+selectedItem);
				selectedItem = getExistingBrandSurveyDetail( salePersCode, wrkDate , newScCode,formNo ,formName,connectionObject) ; //Chnaged by sachin satre on 09-nov-16
			}
			selectedItem = "<Root>" + selectedItem + "</Root>";
			//System.out.println("selectedItem>>>"+selectedItem);
			System.out.println("after getExistingSurveyDetail>>>"+selectedItem);
			String itemDetails = getBrandSurveyList(dom, salePersCode, scCode, selectedItem, wrkDate,formNo,formName );

			//System.out.println("itemDetails>>>"+itemDetails);
			valueXmlString.append(itemDetails);
		}
		catch(Exception e)
		{
			System.out.println( "Exception :StrgMeetITMMobileWizEJB:getItemDetails( Document dom2 , String salePersCode, String wrkDate , String scCode, String xtraParams):" + e.getMessage() + ":" );
			e.printStackTrace();
			//valueXmlString = valueXmlString.append( genericUtility.createErrorString( e ) );
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		finally
		{
			try
			{
				if (rs !=null )
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if (isLocalConn && connectionObject != null)
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :StrgMeetITMMobileWizEJB:getItemDetails( Document dom2 , String salePersCode, String wrkDate , String scCode, String xtraParams):" + e.getMessage() + ":" );
				System.out.println( "Exception :StrgMeetITMMobileWizEJB:defaultDataDAR :==>\n"+e.getMessage());
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		System.out.println("Return valueXmlString===>"+valueXmlString);
		return valueXmlString.toString();

	}
	public String getExistingBrandSurveyDetail( String salePersCode, String eventDate , String custList ,String formNo,String formName,Connection connectionObject) throws ITMException //Chnaged by sachin satre on 09-nov-16
	{

		ResultSet rs = null;
		//Connection connectionObject = null;
		PreparedStatement pstmt = null;
		int domID=1;
		StringBuffer valueXmlString = new StringBuffer();
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		boolean isLocalConn =false;
		try
		{
			if(connectionObject ==null )
			{
				/*ConnDriver connDriver = new ConnDriver();
				connectionObject = connDriver.getConnectDB( "DriverValidator" );*/
				connectionObject = getConnection();//chnged by sachin satre on [9-nov-16] to get connection
				isLocalConn =true;
			}
			String smiQuery = "";

			String dcrID = getDCRId(connectionObject,salePersCode, eventDate);

			/*smiQuery="SELECT SB.BRAND_CODE,SB.SURVEY_CODE,SB.SURVEY_RESULT,SB.STRG_CODE, SB.DCR_ID,SB.TRAN_ID__REF AS TRAN_ID, SM.DESCR, B.DESCRIPTION "
					+" FROM STRG_BRAND_SURVEY SB, SURVEY_MASTER SM, BRAND B"
					+" WHERE SB.BRAND_CODE = B.BRAND_CODE AND SB.SURVEY_CODE = SM.SURVEY_CODE"
					+" AND SB.DCR_ID =  '"+dcrID+"' "+
					"   AND SB.STRG_CODE IN (" + custList + ")";*/

			smiQuery="SELECT SB.ITEM_CODE,SB.SURVEY_CODE,SB.STRG_CODE, SB.DCR_ID,SB.TRAN_ID AS TRAN_ID, ITEM.DESCR AS ITEM_DESCR"
					+" FROM STRG_BRAND_SURVEY SB,ITEM ITEM"
					+" WHERE SB.ITEM_CODE = ITEM.ITEM_CODE "
					+" AND SB.DCR_ID =  '"+dcrID+"'"+
					" AND SB.STRG_CODE IN (" + custList + ")";



			//System.out.println(" StrgMeetSQL[ ---- >] "+smiQuery);
			pstmt = connectionObject.prepareStatement(smiQuery);
			rs = pstmt.executeQuery();
			while(rs.next())
			{

				//	String surveyDescr = checkNull(rs.getString("DESCR"));
				String itemDescr = checkNull(rs.getString("ITEM_DESCR"));
				//String sprogrp = checkNull(rs.getString("SPG_DESCR"));
				//System.out.println("item["+item+"]");

				valueXmlString.append( "<Detail"+formNo+" domID='" + domID + "' selected = 'Y' formName='"+formName+"'>\r\n" );
				valueXmlString.append( "<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\"/>\r\n");//Gaurav Singh on 03/06/15
				/*if( !surveyDescr.equals("") )
				{
					valueXmlString.append("<survey_descr>").append( surveyDescr ).append("</survey_descr>\n");
				}*/
				if( !itemDescr.equals("") )
				{
					//valueXmlString.append("<item_descr>").append( itemDescr ).append("</item_descr>\n");
					valueXmlString.append("<item_descr><![CDATA[").append( itemDescr).append("]]></item_descr>\r\n");

				}
				valueXmlString.append("<item_code><![CDATA[").append( checkNull(rs.getString("ITEM_CODE")) ).append("]]></item_code>\r\n");
				//valueXmlString.append("<brand_code><![CDATA[").append("").append("]]></brand_code>\n");
				//valueXmlString.append("<survey_code><![CDATA[").append( checkNull(rs.getString("SURVEY_CODE")) ).append("]]></survey_code>\r\n");
				//valueXmlString.append("<survey_result><![CDATA[").append( checkNull(rs.getString("SURVEY_RESULT")) ).append("]]></survey_result>\r\n");
				//valueXmlString.append("<sales_prod_grp><![CDATA[").append(checkNull(rs.getString("SALES_PROD_GRP"))).append("]]></sales_prod_grp>\n");
				//valueXmlString.append("<sales_prod_grp_descr><![CDATA[").append(checkNull(rs.getString("SPG_DESCR"))).append("]]></sales_prod_grp_descr>\n");
				valueXmlString.append("<strg_code><![CDATA[").append( checkNull(rs.getString("STRG_CODE")) ).append("]]></strg_code>\r\n");
				//valueXmlString.append("<scheme_code><![CDATA[").append(checkNull(rs.getString("SCHEME_CODE"))).append("]]></scheme_code>\n");
				//valueXmlString.append("<value>").append(checkNull(rs.getString("VALUE"))).append("</value>\n");
				//valueXmlString.append( "<item_type><![CDATA[" ).append( checkNull(rs.getString("ITEM_TYPE")) ).append( "]]></item_type>\r\n" );
				//valueXmlString.append( "<briefed><![CDATA[" ).append( checkNull(rs.getString("BRIEFED"))).append( "]]></briefed>\r\n" );
				//valueXmlString.append( "<item_pob><![CDATA[" ).append( checkNull(rs.getString("ITEM_POB")) ).append( "]]></item_pob>\r\n" );
				//valueXmlString.append( "<briefed_descr><![CDATA[" ).append( checkNull(rs.getString("BRIEFED_DESCR")) ).append( "]]></briefed_descr>\r\n" );
				//valueXmlString.append("<stockist_code><![CDATA[").append(checkNull(rs.getString("STOCKIST_CODE"))).append("]]></stockist_code>\n");
				valueXmlString.append( "<dcr_id><![CDATA[" ).append(checkNull(rs.getString("DCR_ID"))).append( "]]></dcr_id>\r\n" );
				valueXmlString.append( "<tran_id><![CDATA[" ).append(checkNull(rs.getString("TRAN_ID"))).append( "]]></tran_id>\r\n" );//Gulzar on 04/07/17
				valueXmlString.append( "</Detail"+formNo+">\r\n" );
				domID++;
			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		catch(Exception e)
		{
			System.out.println( "Exception :WsfaDSRMobileWizardEJB :defaultDataWiz(Document,String):" + e.getMessage() + ":" );
			//valueXmlString = valueXmlString.append( genericUtility.createErrorString( e ) );
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		finally
		{
			try
			{
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				if( isLocalConn && connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :WsfaDSRMobileWizardEJB :defaultDataWiz :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		return valueXmlString.toString();
	}
	public String getBrandSurveyList(Document dom, String sprsCode, String strgCode, String selectedItem, String eventDate,String formNo,String formName ) throws ITMException
	{
		//Form 4 defaultData()
		String sql = "";
		String sql1 = "";
		StringBuffer valueXmlString = new StringBuffer();
		Connection connectionObject = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		boolean isMasterPitchFound = false;
		int maxLineNo = 0;
		int currentFormNo=0;
		String custTranID = null;
		StringBuffer selectedXmlString = new StringBuffer();
		StringBuffer unselectedString = new StringBuffer();
		StringBuffer unlistedString = new StringBuffer();
		StringBuffer listedString = new StringBuffer();
		try
		{
			valueXmlString.append( "<Root>\r\n" );
			connectionObject = getConnection();//chnged by sachin satre on [11-nov-16] to get connection

			/*sql = " SELECT ITEM.ITEM_CODE AS ITEM_CODE ,ITEM.DESCR AS DESCR, ITEM.SH_DESCR AS SH_DESCR "+
					" FROM ITEM ITEM "+
					" WHERE ITEM.ITEM_USAGE NOT IN('S','G') ORDER BY ITEM.SH_DESCR  ";*/
			String itemUSage="";
			String parmItemUsage = getSfaParmValue(sprsCode,"SAMPLE_ITEM_USAGE",connectionObject);
			if(parmItemUsage!=null && parmItemUsage.trim().length()>0)
			{
				itemUSage=checkNull(getFormattedStringBuff( parmItemUsage ));
			}
			else
			{
				itemUSage="'G','S'";
			}

			int sampCnt = 0;
			String cntSql ="SELECT COUNT(*) AS COUNT " +
					"  FROM ITEM ITEM,SPRS_ITEM SI,SALES_PERS SP WHERE ITEM.ITEM_CODE=SI.ITEM_CODE " +
					"  AND ITEM.ACTIVE='Y' AND SI.STATUS='Y' " +
					"  AND SP.SALES_PERS=SI.SALES_PERS AND Sp.Item_Ser=Item.Item_Ser " +
					"  AND SP.SALES_PERS=? AND " +
					"  ITEM.ITEM_USAGE IN("+itemUSage+") ORDER BY ITEM.SH_DESCR ";

			pstmt = connectionObject.prepareStatement( cntSql );
			pstmt.setString(1, sprsCode);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				sampCnt = rs.getInt("COUNT");
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}

			if(sampCnt>0)
			{
				sql = "SELECT ITEM.ITEM_CODE AS ITEM_CODE ,ITEM.DESCR AS DESCR, ITEM.SH_DESCR AS SH_DESCR, ITEM.UNIT AS ITEM_UNIT " +
						" FROM ITEM ITEM,SPRS_ITEM SI,SALES_PERS SP WHERE ITEM.ITEM_CODE = SI.ITEM_CODE " +
						" AND ITEM.ACTIVE = 'Y' AND SI.STATUS = 'Y' " +
						" AND SP.SALES_PERS = SI.SALES_PERS AND SP.ITEM_SER = ITEM.ITEM_SER " +
						" AND SP.SALES_PERS = ? AND " +
						" ITEM.ITEM_USAGE IN("+itemUSage+") ORDER BY ITEM.SH_DESCR ";
			}
			else
			{
				sql = "SELECT ITEM.ITEM_CODE AS ITEM_CODE ,ITEM.DESCR AS DESCR, ITEM.SH_DESCR AS SH_DESCR, ITEM.UNIT AS ITEM_UNIT " +
						" FROM ITEM ITEM,SALES_PERS SP WHERE ITEM.ITEM_USAGE IN ("+itemUSage+") AND ITEM.ITEM_SER = SP.ITEM_SER AND ITEM.ACTIVE = 'Y' "+
						" AND SP.SALES_PERS = ? ORDER BY ITEM.SH_DESCR ";
			}

			String dcrID = getDCRId(connectionObject,sprsCode, eventDate);
			System.out.println("Value of dcr id is:- -"+dcrID);
			System.out.println(" selectedItem in dom vala parametr["+selectedItem+"]");
			HashMap itemMap = new HashMap();
			HashMap resMap = new HashMap();
			HashMap tranIDMap = new HashMap();


			if ( selectedItem != null && selectedItem.trim().length() > 0 )
			{
				NodeList itemNodeList = ( genericUtility.parseString( selectedItem ) ).getElementsByTagName("Detail"+formNo+"");
				int nodeListLen = itemNodeList.getLength();
				for ( int i=0; i < nodeListLen ; i++ )
				{
					NodeList innerNodeList = itemNodeList.item( i ).getChildNodes();
					int innerNodeListLen = innerNodeList.getLength();
					String brandCode = "";
					String surveyCode = "";
					String strgCodeSel = "";
					String pitch = "";
					String qty = "";
					String val = "";
					String columnValue = "";
					String itemDescr = "";
					String surveyDescr = "";
					String surveyRes = "";
					String tranID = "";
					String itemCode = "";
					for ( int j = 0; j < innerNodeListLen; j++ )
					{
						Node currNode = innerNodeList.item( j );
						System.out.println("COLUMNAME ["+ currNode.getNodeName()+"] COLUMKN VALUE["+currNode.getFirstChild()+"] ");
						if ( "brand_code".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild() != null)
							{
								brandCode = currNode.getFirstChild().getNodeValue().trim() ;
							}
						}
						else if ( "item_code".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild().getNodeValue() != null )
							{
								itemCode = currNode.getFirstChild().getNodeValue().trim();
							}
						}
						else if ( "survey_code".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild().getNodeValue() != null )
							{
								surveyCode = currNode.getFirstChild().getNodeValue().trim();
							}
						}
						else if ( "strg_code".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild() != null)
							{
								strgCodeSel = currNode.getFirstChild().getNodeValue().trim() ;
							}
						}
						else if ( "item_descr".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild() != null)
							{
								itemDescr = checkNull(currNode.getFirstChild().getNodeValue());
							}
						}
						else if ( "survey_descr".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild() != null)
							{
								surveyDescr = checkNull(currNode.getFirstChild().getNodeValue());
							}
						}
						else if ( "survey_result".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild() != null)
							{
								surveyRes = checkNull(currNode.getFirstChild().getNodeValue());
							}
						}
						else if ( "tran_id".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild() != null)
							{
								tranID = checkNull(currNode.getFirstChild().getNodeValue());
							}
						}

					}
					//System.out.println("itemCode["+itemCode+"] " );
					itemMap.put( itemCode+"~"+strgCodeSel, itemDescr);
					//	resMap.put( itemCode+"~"+surveyCode, itemDescr);
					tranIDMap.put( itemCode+"~"+strgCodeSel, tranID);
					System.out.println(" brandMap ["+itemMap+"]");

				}
			}

			System.out.println(" tranIDMap ["+tranIDMap+"]");

			String res = "";
			int num = 1;
			int lineNo=1;
			pstmt =  connectionObject.prepareStatement( sql );
			pstmt.setString(1, sprsCode);
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				String itmCode = checkNull(rs.getString("ITEM_CODE"));
				//	String surveyCode = checkNull(rs.getString("SURVEY_CODE"));
				String itemDescr = checkNull(rs.getString("DESCR"));
				//	String surveyDescr = checkNull(rs.getString("SURVEY_DESCR"));
				//	String resFormat = checkNull(rs.getString("RESULT_FORMAT"));
				//	String defaultRes = checkNull(rs.getString("DEFAULT_RESULT"));

				String tranID = "";

				if ( itemMap.get( itmCode+"~"+strgCode ) != null )
				{

					String data = ( String ) itemMap.get( itmCode+"~"+strgCode );
					//	res = ( String ) resMap.get( itmCode+"~"+itemDescr );
					System.out.println("brandCode inside if["+itmCode+"]");
					System.out.println("Item value from map : - "+data);
					if(tranIDMap.containsKey(itmCode+"~"+strgCode))
					{
						tranID = (String)tranIDMap.get( itmCode+"~"+strgCode );
					}
					selectedXmlString.append("<Detail"+formNo+" domID='"+num+"' selected = 'Y' formName='"+formName+"'>\r\n" );
					selectedXmlString.append( "<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\"/>\r\n");
					selectedXmlString.append("<selectbox><![CDATA[").append( "true" ).append("]]></selectbox>\n");
					selectedXmlString.append("<item_code><![CDATA[").append( rs.getString("ITEM_CODE") ).append("]]></item_code>\r\n");
					//	selectedXmlString.append("<survey_code><![CDATA[").append( rs.getString("SURVEY_CODE") ).append("]]></survey_code>\r\n");
					selectedXmlString.append("<tooltip_descr><![CDATA[").append(itemDescr).append("]]></tooltip_descr>\r\n");
					//	selectedXmlString.append("<survey_result><![CDATA["+res+"]]></survey_result>\r\n");
					selectedXmlString.append("<dcr_id><![CDATA["+dcrID+"]]></dcr_id>\r\n" );
					selectedXmlString.append("<sales_pers><![CDATA[").append(sprsCode).append("]]></sales_pers>\r\n");
					selectedXmlString.append("<strg_code><![CDATA[").append( strgCode ).append("]]></strg_code>\r\n");
					//	selectedXmlString.append("<survey_descr><![CDATA[").append(rs.getString("SURVEY_DESCR")).append("]]></survey_descr>\r\n");
					selectedXmlString.append("<item_descr><![CDATA[").append(rs.getString("DESCR")).append("]]></item_descr>\r\n");
					selectedXmlString.append("<tran_id><![CDATA[" ).append(checkNull(tranID)).append( "]]></tran_id>\r\n" );
					//	selectedXmlString.append("<brand_code><![CDATA[").append( "" ).append("]]></brand_code>\r\n");
					selectedXmlString.append( "</Detail"+formNo+">\r\n" );
					num++;
				}
				else
				{
					maxLineNo = maxLineNo +1;
					unselectedString.append("<Detail"+formNo+" domID='"+num+"' selected = 'N' formName='"+formName+"'>\r\n" );
					unselectedString.append( "<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");
					unselectedString.append("<item_code><![CDATA[").append( rs.getString("ITEM_CODE") ).append("]]></item_code>\r\n");
					//	unselectedString.append("<survey_code><![CDATA[").append( rs.getString("SURVEY_CODE") ).append("]]></survey_code>\r\n");
					unselectedString.append("<tooltip_descr><![CDATA[").append(itemDescr).append("]]></tooltip_descr>\r\n");
					unselectedString.append( "<dcr_id><![CDATA["+dcrID+"]]></dcr_id>\r\n" );
					unselectedString.append("<sales_pers><![CDATA[").append(sprsCode).append("]]></sales_pers>\r\n");
					unselectedString.append("<strg_code><![CDATA[").append( "" ).append("]]></strg_code>\r\n");
					//	unselectedString.append("<survey_result><![CDATA[").append( "" ).append("]]></survey_result>\r\n");
					//	unselectedString.append("<survey_descr><![CDATA[").append(rs.getString("SURVEY_DESCR")).append("]]></survey_descr>\r\n");
					unselectedString.append("<item_descr><![CDATA[").append(rs.getString("DESCR")).append("]]></item_descr>\r\n");
					unselectedString.append( "<tran_id><![CDATA[" ).append("").append( "]]></tran_id>\r\n" );//Gulzar on 04/07/17
					//	unselectedString.append("<brand_code><![CDATA[").append( "" ).append("]]></brand_code>\r\n");
					unselectedString.append( "</Detail"+formNo+">\r\n" );
				}
				num++;
			}//end of while
			valueXmlString.append(selectedXmlString);
			valueXmlString.append(unselectedString);
			//System.out.println("outside detail  :- "+valueXmlString);
			if(rs != null)
			{
				rs.close(); rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close(); pstmt = null;
			}
			num = 1;

		}
		catch (Exception e)
		{
			e.printStackTrace();
			System.out.println( "Exception :ITMWizardStatefulEJB :getSalesPersItemList(String):" + e.getMessage() + ":" );
			//valueXmlString = valueXmlString.append( genericUtility.createErrorString( e ) );
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		finally
		{
			try
			{
				if( connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :ITMWizardStatefulEJB :getSalesPersItemList(String) :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		valueXmlString.append( "</Root>\r\n" );
		System.out.println( "\n****ValueXmlString :" + valueXmlString.toString() + ":********" );
		return valueXmlString.toString();
	}
	// added by rupali on 10/09/17 for added new subform on doctor screen [end]
	//Added by Ashutosh on 10-Oct-17 [Start - For Diminishing stock ]
	private ArrayList getsampleItemStockDetails(Connection conn, String sprsCode, String eventDate, String selectedSampleItems,String formNo )throws ITMException
	{
		HashMap selItemStockMap = new HashMap();
		HashMap sampleItemStockMap = new HashMap();
		HashMap sampleItemCurrStockMap = new HashMap();
		HashMap sampleItemIssueMap = new HashMap();
		HashMap strgMeetItemsMap = new HashMap();
		HashMap strgMeetItemsAvailMap = new HashMap();
		HashMap strgMeetItemsUnconfMap = new HashMap();
		HashMap sampleStockMap = new HashMap();
		HashMap strgMeetItemsCurrDayMap = new HashMap();
		HashMap itemDescrMap = new HashMap();
		ArrayList mapList = new ArrayList();
		String drSampleItemAvail = "";//Added By Dipak On 31 Jul 2013
		String sampleInvEffDate="";

		String sql="";
		PreparedStatement pstmt = null;
		ResultSet rs = null;

		try
		{
			//GenericUtility genericUtility = GenericUtility.getInstance();
			System.out.println("11598 selectedSampleItems ["+selectedSampleItems+"] eventDate ["+eventDate+"]");
			eventDate = genericUtility.getValidDateTimeString( eventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );
			String dcrID = "";


			//ADDED BY SACHIN SATRE ON [13-OCT-2016] [START]

			sql = "SELECT PARM_VALUE FROM SFAPARM WHERE PARM_NAME='SAMPLE_EFF_DATE' AND ORG_UNIT='ALL'";

			pstmt = conn.prepareStatement( sql );
			rs = pstmt.executeQuery();
			if( rs.next() )
			{
				sampleInvEffDate = checkNull(rs.getString("PARM_VALUE"));
				System.out.println("sampleInvEffDate>>::"+sampleInvEffDate);
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			//ADDED BY SACHIN SATRE ON [13-OCT-2016] [END]
			System.out.println("sampleInvEffDate>>out::"+sampleInvEffDate+"] eventDate["+eventDate+"]" );
			// commented and added by rupali on 17/10/17 for making db2 compatible [start]
			//sampleInvEffDate=sampleInvEffDate + " 00:00:00";
			if("ORACLE".equalsIgnoreCase(CommonConstants.DB_NAME))
			{
				sampleInvEffDate=sampleInvEffDate + " 00:00:00";
			}
			else if("DB2".equalsIgnoreCase(CommonConstants.DB_NAME))
			{
				sampleInvEffDate=sampleInvEffDate;
			}
			// commented and added by rupali on 17/10/17 for making db2 compatible [end]
			System.out.println("sampleInvEffDate>>::after"+sampleInvEffDate);
			//sampleInvEffDate=genericUtility.getValidDateTimeString( sampleInvEffDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );
			System.out.println("sampleInvEffDate>>after convert:::"+sampleInvEffDate);

			// COMMENTED AND BELOW CHANGES DONE BY Dipak Chattar ON 31-JUL-13.

			/*String drSampleQtySql = "SELECT ITEM_CODE, SUM(CASE WHEN QUANTITY IS NULL THEN 0 ELSE QUANTITY END) AS DR_SAMPLE_QTY "+
									"FROM STRG_MEET_ITEMS WHERE DCR_ID IN(SELECT DCR_ID FROM SPRS_ACT_TRAN WHERE SALES_PERS  = ? AND EVENT_DATE <> ? AND "+
									"(CASE WHEN CONFIRMED IS NULL THEN 'N' ELSE CONFIRMED END)='N') GROUP BY ITEM_CODE ORDER BY ITEM_CODE";*/
			/*Added By Dipak On 31 Jul 2013 Start*/
			String drSampleQtySql = "SELECT ITEM_CODE, SUM(CASE WHEN QUANTITY IS NULL THEN 0 ELSE QUANTITY END) AS DR_SAMPLE_QTY "+
					"FROM STRG_MEET_ITEMS WHERE DCR_ID IN(SELECT DCR_ID FROM SPRS_ACT_TRAN WHERE SALES_PERS  = ? AND EVENT_DATE >= ?  )"+
					" GROUP BY ITEM_CODE ORDER BY ITEM_CODE";
			/*Ended By Dipak On 31 Jul 2013 */
			PreparedStatement pstmtDrSampleQty = conn.prepareStatement(drSampleQtySql);
			pstmtDrSampleQty.setString(1, sprsCode);
			pstmtDrSampleQty.setTimestamp(2, java.sql.Timestamp.valueOf(sampleInvEffDate));
			//pstmtDrSampleQty.setTimestamp(3, java.sql.Timestamp.valueOf(eventDate));

			ResultSet rsdrSampleQty = pstmtDrSampleQty.executeQuery();
			while(rsdrSampleQty.next())
			{
				int oldQty = 0;
				String drSampleItem = (rsdrSampleQty.getString("ITEM_CODE") == null) ?"" : rsdrSampleQty.getString("ITEM_CODE").trim();
				int drSampleItemQty = rsdrSampleQty.getInt("DR_SAMPLE_QTY");
				System.out.println("11802 rsdrSampleQty ["+rsdrSampleQty+"] drSampleItemQty ["+drSampleItemQty+"]");
				if(strgMeetItemsMap != null && strgMeetItemsMap.size() > 0 && strgMeetItemsMap.containsKey(drSampleItem))
				{
					try
					{
						oldQty = Integer.parseInt((String)strgMeetItemsMap.get(drSampleItem));
					}
					catch(NumberFormatException nfe)
					{
						oldQty = 0;
					}
				}
				strgMeetItemsMap.put( drSampleItem, ""+(oldQty + drSampleItemQty));
				System.out.println("oldQty :::::" + oldQty + "drSampleItemQty" + drSampleItemQty );
			}
			rsdrSampleQty.close(); rsdrSampleQty = null;
			pstmtDrSampleQty.close(); pstmtDrSampleQty = null;

			System.out.println("strgMeetItemsMap ::"+strgMeetItemsMap);

			if(strgMeetItemsMap != null && strgMeetItemsMap.size() > 0 )
			{
				//sampleItemIssueMap.putAll(strgMeetItemsMap);
			}
			/*//Gulzar on 14/10/16 : START
			String drStrgItemQtyCurrDayUnconfSql = "SELECT ITEM_CODE, SUM(CASE WHEN QUANTITY IS NULL THEN 0 ELSE QUANTITY END) AS DR_SAMPLE_QTY "+
					"FROM STRG_MEET_ITEMS WHERE DCR_ID IN(SELECT DCR_ID FROM SPRS_ACT_TRAN WHERE SALES_PERS  = ?  AND EVENT_DATE = ? AND "+
					"(CASE WHEN CONFIRMED IS NULL THEN 'N' ELSE CONFIRMED END)='N') GROUP BY ITEM_CODE ORDER BY ITEM_CODE";

			PreparedStatement pstmtStrgQtyCurrDayUnconf = conn.prepareStatement(drStrgItemQtyCurrDayUnconfSql);
			pstmtStrgQtyCurrDayUnconf.setString(1, sprsCode);
			pstmtStrgQtyCurrDayUnconf.setTimestamp(2, java.sql.Timestamp.valueOf(eventDate));
			//pstmtDrSampleQtyUnconf.setTimestamp(2, java.sql.Timestamp.valueOf(sampleInvEffDate));

			ResultSet rsdrStrgQtyCurrDayUnconf = pstmtStrgQtyCurrDayUnconf.executeQuery();
			while(rsdrStrgQtyCurrDayUnconf.next())
			{
				int oldQty = 0;
				String drSampleItemUnconf = (rsdrStrgQtyCurrDayUnconf.getString("ITEM_CODE") == null) ?"" : rsdrStrgQtyCurrDayUnconf.getString("ITEM_CODE").trim();
				int drSampleItemQtyUnconf = rsdrStrgQtyCurrDayUnconf.getInt("DR_SAMPLE_QTY");
				if(strgMeetItemsUnconfMap != null && strgMeetItemsUnconfMap.size() > 0 && strgMeetItemsUnconfMap.containsKey(drSampleItemUnconf))
				{
					try
					{
						oldQty = Integer.parseInt((String)strgMeetItemsUnconfMap.get(drSampleItemUnconf));
					}
					catch(NumberFormatException nfe)
					{
						oldQty = 0;
					}
				}
				strgMeetItemsUnconfMap.put( drSampleItemAvail, ""+(oldQty + drSampleItemQtyUnconf));
				System.out.println("oldQty :::::" + oldQty + ", drSampleItemQtyUnconf" + drSampleItemQtyUnconf );
			}
			rsdrStrgQtyCurrDayUnconf.close(); rsdrStrgQtyCurrDayUnconf = null;
			pstmtStrgQtyCurrDayUnconf.close(); pstmtStrgQtyCurrDayUnconf = null;

			System.out.println("strgMeetItemsUnconfMap ::"+strgMeetItemsUnconfMap);

			//Gulzar on 14/10/16 : END
			 */
			/*Added By Dipak On 31 Jul 2013 Start*/
			String drSampleQtyAvailSql = "SELECT ITEM_CODE, SUM(CASE WHEN QUANTITY IS NULL THEN 0 ELSE QUANTITY END) AS DR_SAMPLE_QTY "+
					"FROM STRG_MEET_ITEMS WHERE DCR_ID IN(SELECT DCR_ID FROM SPRS_ACT_TRAN WHERE SALES_PERS  = ? AND EVENT_DATE <= ? AND EVENT_DATE >= ?  AND "+
					"(CASE WHEN CONFIRMED IS NULL THEN 'N' ELSE CONFIRMED END)='Y') GROUP BY ITEM_CODE ORDER BY ITEM_CODE";

			PreparedStatement pstmtDrSampleQtyAvail = conn.prepareStatement(drSampleQtyAvailSql);
			pstmtDrSampleQtyAvail.setString(1, sprsCode);
			pstmtDrSampleQtyAvail.setTimestamp(2, java.sql.Timestamp.valueOf(eventDate));
			pstmtDrSampleQtyAvail.setTimestamp(3, java.sql.Timestamp.valueOf(sampleInvEffDate));

			ResultSet rsdrSampleQtyAvail = pstmtDrSampleQtyAvail.executeQuery();
			while(rsdrSampleQtyAvail.next())
			{
				int oldQty = 0;
				drSampleItemAvail = (rsdrSampleQtyAvail.getString("ITEM_CODE") == null) ?"" : rsdrSampleQtyAvail.getString("ITEM_CODE").trim();
				int drSampleItemQtyAvail = rsdrSampleQtyAvail.getInt("DR_SAMPLE_QTY");
				if(strgMeetItemsAvailMap != null && strgMeetItemsAvailMap.size() > 0 && strgMeetItemsAvailMap.containsKey(drSampleItemAvail))
				{
					try
					{
						oldQty = Integer.parseInt((String)strgMeetItemsAvailMap.get(drSampleItemAvail));
					}
					catch(NumberFormatException nfe)
					{
						oldQty = 0;
					}
				}
				strgMeetItemsAvailMap.put( drSampleItemAvail, ""+(oldQty + drSampleItemQtyAvail));
				System.out.println("11892 oldQty :::::" + oldQty + "drSampleItemQtyAvail" + drSampleItemQtyAvail );
			}
			rsdrSampleQtyAvail.close(); rsdrSampleQtyAvail = null;
			pstmtDrSampleQtyAvail.close(); pstmtDrSampleQtyAvail = null;

			System.out.println("11897 strgMeetItemsAvailMap ::"+strgMeetItemsAvailMap);

			String drSampleQtyUnconfSql = "SELECT ITEM_CODE, SUM(CASE WHEN QUANTITY IS NULL THEN 0 ELSE QUANTITY END) AS DR_SAMPLE_QTY "+
					"FROM STRG_MEET_ITEMS WHERE DCR_ID IN(SELECT DCR_ID FROM SPRS_ACT_TRAN WHERE SALES_PERS  = ?  AND EVENT_DATE >= ? AND EVENT_DATE <> ? AND "+
					"(CASE WHEN CONFIRMED IS NULL THEN 'N' ELSE CONFIRMED END)='N') GROUP BY ITEM_CODE ORDER BY ITEM_CODE";

			PreparedStatement pstmtDrSampleQtyUnconf = conn.prepareStatement(drSampleQtyUnconfSql);
			pstmtDrSampleQtyUnconf.setString(1, sprsCode);
			pstmtDrSampleQtyUnconf.setTimestamp(2, java.sql.Timestamp.valueOf(sampleInvEffDate));
			pstmtDrSampleQtyUnconf.setTimestamp(3, java.sql.Timestamp.valueOf(eventDate));

			ResultSet rsdrSampleQtyUnconf = pstmtDrSampleQtyUnconf.executeQuery();
			while(rsdrSampleQtyUnconf.next())
			{
				int oldQty = 0;
				String drSampleItemUnconf = (rsdrSampleQtyUnconf.getString("ITEM_CODE") == null) ?"" : rsdrSampleQtyUnconf.getString("ITEM_CODE").trim();
				int drSampleItemQtyUnconf = rsdrSampleQtyUnconf.getInt("DR_SAMPLE_QTY");
				System.out.println("11914 drSampleItemQtyUnconf ::"+drSampleItemQtyUnconf+"strgMeetItemsUnconfMap.get(drSampleItemUnconf)"+strgMeetItemsUnconfMap.get(drSampleItemUnconf)+"]");
				if(strgMeetItemsUnconfMap != null && strgMeetItemsUnconfMap.size() > 0 && strgMeetItemsUnconfMap.containsKey(drSampleItemUnconf))
				{
					try
					{
						oldQty = Integer.parseInt((String)strgMeetItemsUnconfMap.get(drSampleItemUnconf));
					}
					catch(NumberFormatException nfe)
					{
						oldQty = 0;
					}
				}
				//strgMeetItemsUnconfMap.put( drSampleItemAvail, ""+(oldQty + drSampleItemQtyUnconf));
				strgMeetItemsUnconfMap.put( drSampleItemUnconf, ""+(oldQty + drSampleItemQtyUnconf));//CHANGED BY SACHIN SATRE 1-JUN-17
				System.out.println("oldQty ::::>>,M:" + oldQty + ", drSampleItemQtyUnconf::>>:["+ drSampleItemQtyUnconf+"]");
			}
			rsdrSampleQtyUnconf.close(); rsdrSampleQtyUnconf = null;
			pstmtDrSampleQtyUnconf.close(); pstmtDrSampleQtyUnconf = null;

			System.out.println("strgMeetItemsUnconfMap ::"+strgMeetItemsUnconfMap);

			//if(strgMeetItemsUnconfMap != null && strgMeetItemsUnconfMap.size() > 0 )
			{
				sampleItemIssueMap.putAll(strgMeetItemsUnconfMap);
			}

			/*Ended By Dipak On 31 Jul 2013 */

			//Getting quantity from stock
			//String stockSql = "SELECT ITEM_CODE, SUM(CASE WHEN QUANTITY IS NULL THEN 0 ELSE QUANTITY END) AS STOCK_QTY FROM SAMPLE_STOCK WHERE EMP_CODE  = ? AND (CASE WHEN QUANTITY IS NULL THEN 0 ELSE QUANTITY END) > 0 GROUP BY ITEM_CODE";

			// COMMENTED AND BELOW CHANGES DONE BY Dipak Chattar ON 31-JUL-13.
			/*String stockSql = "SELECT I.ITEM_CODE ITEM_CODE, I.DESCR ITEM_DESCR, SUM(CASE WHEN S.QUANTITY IS NULL THEN 0 ELSE S.QUANTITY END) AS STOCK_QTY "+
			 "FROM SAMPLE_STOCK S, ITEM I WHERE S.ITEM_CODE = I.ITEM_CODE AND S.EMP_CODE  =? " +
			" AND S.SITE_CODE =(SELECT EMP_SITE FROM EMPLOYEE WHERE EMP_CODE= ?) "+
			" AND S.LOC_CODE='FRSH'"+
			" AND S.LOT_NO='Y'"+
			" AND S.LOT_SL='Y'"+
			" AND S.INV_STAT='SALE'"+
			" AND (CASE WHEN S.QUANTITY IS NULL THEN 0 ELSE S.QUANTITY END) > 0 GROUP BY I.ITEM_CODE,I.DESCR ORDER BY ITEM_CODE ";*/
			/*Added By Dipak On 31 Jul 2013 Start*/

			int currStock = 0;
			if ( selectedSampleItems != null && selectedSampleItems.trim().length() > 0 )
			{
				NodeList itemNodeList = ( genericUtility.parseString( selectedSampleItems ) ).getElementsByTagName("Detail"+formNo);
				int nodeListLen = itemNodeList.getLength();
				for ( int i=0; i < nodeListLen ; i++ )
				{
					NodeList innerNodeList = itemNodeList.item( i ).getChildNodes();
					int innerNodeListLen = innerNodeList.getLength();
					String selItemCode = "";
					String inputQty = "";
					String columnValue = "";
					String strgCode = "";

					for ( int j = 0; j < innerNodeListLen; j++ )
					{
						Node currNode = innerNodeList.item( j );
						System.out.println("12038 COLUMN NAME ["+ currNode.getNodeName()+"] COLUMN VALUE["+currNode.getFirstChild()+"] ");
						if ( "#text".equalsIgnoreCase( currNode.getNodeName() ) )
						{
							continue;
						}
						if ( "item_code".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild() != null)
							{
								selItemCode = currNode.getFirstChild().getNodeValue().trim() ;
							}
						}
						else if ( "strg_code".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild().getNodeValue() != null )
							{
								strgCode = currNode.getFirstChild().getNodeValue().trim();
							}
						}
						else if ( "quantity".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild().getNodeValue() != null )
							{
								inputQty = currNode.getFirstChild().getNodeValue().trim();
							}
						}
					}
					System.out.println("itemCode=["+selItemCode+"] strgCode=["+strgCode+"] inputQty=["+inputQty+"]" );

					int currQty = 0;
					try
					{
						currQty = Integer.parseInt(inputQty);
						currStock = currQty;
					}
					catch(NumberFormatException nfe)
					{
						currQty = 0;
					}
					if (sampleItemStockMap != null && sampleItemStockMap.size() > 0 && sampleItemStockMap.containsKey(selItemCode))
					{
						int stockQty = 0;

						try
						{
							stockQty = Integer.parseInt((String)sampleItemStockMap.get(selItemCode));
						}
						catch(NumberFormatException nfe)
						{
							stockQty = 0;
						}
						System.out.println("12035 stockQty =["+stockQty+"] and currQty =["+currQty+"]");
						sampleItemStockMap.put( selItemCode, ""+(stockQty -currQty));
					}
					int issueOldQty = 0;
					if (sampleItemIssueMap != null && sampleItemIssueMap.size() > 0 && sampleItemIssueMap.containsKey(selItemCode))
					{
						try
						{
							issueOldQty = Integer.parseInt((String)sampleItemIssueMap.get(selItemCode));
						}
						catch(NumberFormatException nfe)
						{
							issueOldQty = 0;
						}
					}
					sampleItemIssueMap.put( selItemCode, ""+(issueOldQty + currQty));
				}
			}

			String stockSql = "SELECT I.ITEM_CODE ITEM_CODE, I.DESCR ITEM_DESCR, SUM(CASE WHEN SI.EFF_QTY IS NULL THEN 0 ELSE SI.EFF_QTY END) " +
					" AS STOCK_QTY FROM ITEM I , SAMPLE_INVTRACE SI WHERE SI.ITEM_CODE = I.ITEM_CODE AND SI.EMP_CODE  = ? " +
					" AND SI.SITE_CODE =(SELECT EMP_SITE FROM EMPLOYEE WHERE EMP_CODE= ? ) " +
					" AND SI.LOC_CODE='FRSH' AND SI.LOT_NO='Y' AND SI.LOT_SL='Y' " +
					" AND 'SALE' =(SELECT INV_STAT FROM LOCATION WHERE LOC_CODE='FRSH') " +
					" AND SI.EFF_DATE <= ? " +
					" AND SI.EFF_DATE >= ? " + //Added by Shahu Mali on 30-11-13 for  EFF_DATE from sample Invtrace >= SAMPLE_INV_EFF_DATE from Properties table.
					//" AND (CASE WHEN SI.EFF_QTY IS NULL THEN 0 ELSE SI.EFF_QTY END) > 0  " +
					" GROUP BY I.ITEM_CODE,I.DESCR ORDER BY ITEM_CODE ";
			/*Ended By Dipak On 31 Jul 2013*/
			System.out.println("1183 sampleInvEffDate>>out::["+sampleInvEffDate+"] eventDate["+eventDate+"]" );
			PreparedStatement pstmtStock = conn.prepareStatement(stockSql);
			pstmtStock.setString(1, sprsCode);
			pstmtStock.setString(2, sprsCode);
			pstmtStock.setTimestamp(3, java.sql.Timestamp.valueOf(eventDate));//Added By Dipak On 31 Jul 2013
			pstmtStock.setTimestamp(4, java.sql.Timestamp.valueOf(sampleInvEffDate));
			ResultSet rsStock = pstmtStock.executeQuery();
			while(rsStock.next())
			{
				int oldQty = 0;
				int availMapStockQty = 0;
				int meetItemUnconfQty = 0;
				String stockItem = (rsStock.getString("ITEM_CODE") == null) ?"" : rsStock.getString("ITEM_CODE").trim();
				int stockQty = rsStock.getInt("STOCK_QTY");

				String itemDescr = (rsStock.getString("ITEM_DESCR") == null) ?"" : rsStock.getString("ITEM_DESCR").trim();

				if (strgMeetItemsUnconfMap.containsKey(stockItem))
				{
					meetItemUnconfQty = (Integer) ((strgMeetItemsUnconfMap.get(stockItem) == null) ? "0.0" : Integer.parseInt(strgMeetItemsUnconfMap.get(stockItem).toString()))  ;
				}
				System.out.println("strgMeetItemsAvailMap.get(stockItem) :::::" + strgMeetItemsAvailMap.get(stockItem));

				if (strgMeetItemsAvailMap.containsKey(stockItem))
				{
					availMapStockQty = (Integer) ((strgMeetItemsAvailMap.get(stockItem) == null) ? "0.0" : Integer.parseInt(strgMeetItemsAvailMap.get(stockItem).toString()))  ;
				}

				//sampleStockMap.put(stockItem, ""+stockQty);
				// commented and added by rupali on 09/01/18 for solving sample issue [start]
				/*	if(stockQty > 0 && availMapStockQty > 0 )
				{
					if(stockQty > availMapStockQty )
					{
						sampleStockMap.put(stockItem, ""+(stockQty - availMapStockQty));
					}
				} */
				if(stockQty > 0 )
				{
					if(stockQty > availMapStockQty )
					{
						//sampleStockMap.put(stockItem, ""+(stockQty - availMapStockQty));
						sampleStockMap.put(stockItem, ""+stockQty);
					}
				}
				// commented and added by rupali on 09/01/18 for solving sample issue [end]

				System.out.println("11994 stockQty---Item----::" + stockQty + "meetItemUnconfQty----item----::" + meetItemUnconfQty +"strgMeetItemsMap ["+strgMeetItemsMap+"]");
				itemDescrMap.put(stockItem, itemDescr);
				/*if(strgMeetItemsMap != null && strgMeetItemsMap.size() > 0 && strgMeetItemsMap.containsKey(stockItem))
				{
					try
					{
						oldQty = Integer.parseInt((String)strgMeetItemsMap.get(stockItem));
					}
					catch(NumberFormatException nfe)
					{
						oldQty = 0;
					}
				}
				sampleItemStockMap.put( stockItem, ""+(stockQty - oldQty));*/
				if(strgMeetItemsUnconfMap != null && strgMeetItemsUnconfMap.size() > 0 && strgMeetItemsUnconfMap.containsKey(stockItem))
				{
					try
					{
						oldQty = Integer.parseInt((String)strgMeetItemsUnconfMap.get(stockItem));
					}
					catch(NumberFormatException nfe)
					{
						oldQty = 0;
					}
				}
				sampleItemStockMap.put( stockItem, ""+(stockQty - oldQty));
				System.out.println("12008 stockQty---- :::::" + stockQty + "oldQty----::::" + oldQty +"stockItem --::"+stockItem);
			}
			rsStock.close(); rsStock = null;
			pstmtStock.close(); pstmtStock = null;

			System.out.println("sampleItemStockMap from stock::"+sampleItemStockMap);
			sampleItemCurrStockMap.putAll(sampleItemStockMap);

			/*if ( selectedSampleItems != null && selectedSampleItems.trim().length() > 0 )
			{
				NodeList itemNodeList = ( genericUtility.parseString( selectedSampleItems ) ).getElementsByTagName("Detail"+formNo);
				int nodeListLen = itemNodeList.getLength();
				for ( int i=0; i < nodeListLen ; i++ )
				{
					NodeList innerNodeList = itemNodeList.item( i ).getChildNodes();
					int innerNodeListLen = innerNodeList.getLength();
					String selItemCode = "";
					String inputQty = "";
					String columnValue = "";
					String strgCode = "";

					for ( int j = 0; j < innerNodeListLen; j++ )
					{
						Node currNode = innerNodeList.item( j );
						System.out.println("12038 COLUMN NAME ["+ currNode.getNodeName()+"] COLUMN VALUE["+currNode.getFirstChild()+"] ");
						if ( "#text".equalsIgnoreCase( currNode.getNodeName() ) )
						{
							continue;
						}
						if ( "item_code".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild() != null)
							{
								selItemCode = currNode.getFirstChild().getNodeValue().trim() ;
							}
						}
						else if ( "strg_code".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild().getNodeValue() != null )
							{
								strgCode = currNode.getFirstChild().getNodeValue().trim();
							}
						}
						else if ( "quantity".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild().getNodeValue() != null )
							{
								inputQty = currNode.getFirstChild().getNodeValue().trim();
							}
						}
					}
					System.out.println("itemCode=["+selItemCode+"] strgCode=["+strgCode+"] inputQty=["+inputQty+"]" );

					int currQty = 0;
					try
					{
						currQty = Integer.parseInt(inputQty);
					}
					catch(NumberFormatException nfe)
					{
						currQty = 0;
					}
					if (sampleItemStockMap != null && sampleItemStockMap.size() > 0 && sampleItemStockMap.containsKey(selItemCode))
					{
						int stockQty = 0;

						try
						{
							stockQty = Integer.parseInt((String)sampleItemStockMap.get(selItemCode));
						}
						catch(NumberFormatException nfe)
						{
							stockQty = 0;
						}
						System.out.println("12035 stockQty =["+stockQty+"] and currQty =["+currQty+"]");
						sampleItemStockMap.put( selItemCode, ""+(stockQty -currQty));
					}
					int issueOldQty = 0;
					if (sampleItemIssueMap != null && sampleItemIssueMap.size() > 0 && sampleItemIssueMap.containsKey(selItemCode))
					{
						try
						{
							issueOldQty = Integer.parseInt((String)sampleItemIssueMap.get(selItemCode));
						}
						catch(NumberFormatException nfe)
						{
							issueOldQty = 0;
						}
					}
					sampleItemIssueMap.put( selItemCode, ""+(issueOldQty + currQty));
				}
			}*/
			System.out.println("12101 sampleItemStockMap ["+sampleItemStockMap+"] sampleStockMap ["+sampleStockMap+"]");
			mapList.add(sampleItemStockMap);//Current stock
			mapList.add(sampleItemIssueMap);//Stock issued
			mapList.add(sampleStockMap);//Opening Stock
			mapList.add(itemDescrMap);
			mapList.add(sampleItemCurrStockMap);
		}
		catch(Exception e)
		{
			System.out.println( "Exception :StrgMeetWizardEJB :getMsgDescr():==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		System.out.println(" sampleItemIssueMap ["+sampleItemIssueMap+"]");
		System.out.println(" sampleItemStockMap final ["+sampleItemStockMap+"]");
		System.out.println(" sampleStockMap ["+sampleStockMap+"]");
		return mapList;
	}
	private String getMaxSampleAllow(Connection conn) throws Exception
	{
		String maxAllowance = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try
		{
			String selActType = "";
			String Sql = " SELECT PROP_VALUE FROM PROPERTIES WHERE PROP_NAME = 'MAX_SAMPLE_ALLOWANCE' ";

			pstmt = conn.prepareStatement( Sql );
			rs = pstmt.executeQuery();
			if( rs.next() )
			{
				maxAllowance = checkNull(rs.getString("PROP_VALUE"));
			}
			if (rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt !=null)
			{
				pstmt.close();
				pstmt = null;
			}

		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt !=null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e1){}
		}
		return maxAllowance;
	}
	public String getCustInfoData( String sprsCode, String strgCode, String eventDate, String tranId, Connection conn) throws ITMException //added by rupali on 06/03/17
	{

		System.out.println("Inside getPriorVisits::::::::::::::::::"+eventDate);
		String sql="";
		PreparedStatement pstmtPriorVisit = null;
		ResultSet rsPriorVisit = null;
		PreparedStatement pstmt1 = null;
		PreparedStatement pstmtSfaParm = null;
		ResultSet rs1 = null;
		ResultSet rsSfaParm = null;
		int priorDate = 0;
		String parmValue = "";
		String scName = "";
		String newDate=null;
		String address = "";
		String addr1 = "";
		String addr2 = "";
		String addr3 = "";
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		int maxDate = 0;
		//Connection conn =null;
		StringBuffer sb = new StringBuffer();
		System.out.println("eventDate:::>>>:["+eventDate+"]");
		String currDcrDate = eventDate;//Added by vinayak on [28/07/16]
		boolean isLocalConn =false;
		String formatDate = "";
		StringBuffer valueXmlString = new StringBuffer("<Root>\r\n");
		try
		{
			//chnged by sachin satre on 9-nov-16 start
			if(conn == null)
			{
				/*ConnDriver connDriver = new ConnDriver();
					conn = connDriver.getConnectDB("DriverITM");*/
				conn =getConnection();//chnged by sachin satre on 9-nov-16
				isLocalConn =true;
			}
			//chnged by sachin satre on 9-nov-16 end
			// added by rupali on 19/03/18 for showing data in dashboard link [start]
			if(tranId != null && tranId.trim().length() != 0)
			{
				String tranIdSql = "SELECT STRG_CODE FROM STRG_MEET WHERE TRAN_ID = ?";
				pstmt1 = conn.prepareStatement(tranIdSql);
				pstmt1.setString(1,tranId);
				rs1=pstmt1.executeQuery();
				if(rs1.next())
				{
					strgCode = checkNull(rs1.getString("STRG_CODE"));
					System.out.println("strgCode is:::>>>:["+strgCode+"]");
				}
				if(rs1 != null)
				{
					rs1.close();
					rs1 = null;
				}
				if(pstmt1 != null)
				{
					pstmt1.close();
					pstmt1 = null;
				}
			}
			// added by rupali on 19/03/18 for showing data in dashboard link [end]
			String custInfoSql="";

			custInfoSql = "SELECT UPPER(SC.FIRST_NAME)||' '||UPPER(SC.LAST_NAME) AS SC_NAME, sc.addr1  as addr1, sc.addr2 addr2, sc.addr3 addr3, sc.email_addr, sc.mobile_no, i.institute FROM strg_customer sc left outer join strg_institute si on sc.sc_code = si.sc_code left outer join institute i on si.inst_code = i.inst_code"+
					" where sc.sc_code = '"+strgCode+"'";

			System.out.println("custInfoSql+++"+custInfoSql);
			pstmtPriorVisit = conn.prepareStatement(custInfoSql);


			rsPriorVisit = pstmtPriorVisit.executeQuery();
			System.out.println("After Query");
			//while (rsPriorVisit.next())
			if(rsPriorVisit.next())
			{
				System.out.println("inside while loop.... ::");

				addr1 = checkNull(rsPriorVisit.getString("addr1"));
				addr2 = checkNull(rsPriorVisit.getString("addr2"));
				addr3 = checkNull(rsPriorVisit.getString("addr3"));
				address = addr1 +", "+addr2 +", "+addr3;
				//added by Rupali on 15/03/17 for adding address column in prior visit [end]
				String mobileNo = checkNull(rsPriorVisit.getString("mobile_no"));
				String emailId = checkNull(rsPriorVisit.getString("email_addr"));
				String instituteName = checkNull(rsPriorVisit.getString("institute"));
				scName = checkNull(rsPriorVisit.getString("SC_NAME"));

				valueXmlString.append("<prior_visit >\r\n");
				valueXmlString.append("<strg_code><![CDATA[").append(checkNull(strgCode)).append("]]></strg_code>\r\n");
				valueXmlString.append("<strg_name><![CDATA[").append(checkNull(scName)).append("]]></strg_name>\r\n");
				/*valueXmlString.append("<call_outcome><![CDATA[").append(checkNull(callOutCome)).append("]]></call_outcome>\r\n");//Added by vinayak on [28/07/16] to get call outcome
				 */				valueXmlString.append("<dcr_date><![CDATA[").append(checkNull(currDcrDate)).append("]]></dcr_date>\r\n");//Added by vinayak on [28/07/16]
				 /*valueXmlString.append("<event_time_start><![CDATA[").append(checkNull(eventTime)).append("]]></event_time_start>\r\n");*/
				 valueXmlString.append("<address><![CDATA[").append(checkNull(address)).append("]]></address>\r\n"); //added by Rupali on 15/03/17 for adding address column in prior visit
				 valueXmlString.append("<mobile_no><![CDATA[").append(checkNull(mobileNo)).append("]]></mobile_no>\r\n");
				 valueXmlString.append("<email_addr><![CDATA[").append(checkNull(emailId)).append("]]></email_addr>\r\n");
				 valueXmlString.append("<institue_name><![CDATA[").append(checkNull(instituteName)).append("]]></institue_name>\r\n");
				 valueXmlString.append("</prior_visit>\r\n");
			}
		}

		catch(Exception e)
		{
			//System.out.println("Exception:----");
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(rsPriorVisit != null)
				{
					rsPriorVisit.close();
					rsPriorVisit = null;
				}
				if(pstmtPriorVisit != null)
				{
					pstmtPriorVisit.close();
					pstmtPriorVisit = null;
				}
				if(isLocalConn && conn != null && ! conn.isClosed() )
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{

			}
		}
		valueXmlString.append( "</Root>\r\n" );
		System.out.println( "\n****ValueXmlString :" + valueXmlString.toString() + ":********" );
		return valueXmlString.toString();

	}
	//Added by Ashutosh on 10-Oct-17 [End-For Customerinfo stock ]
	static int monthsBetween(Date a, Date b) {
		Calendar cal = Calendar.getInstance();
		if (a.before(b)) {
			cal.setTime(a);
		} else {
			cal.setTime(b);
			b = a;
		}
		int c = 0;
		while (cal.getTime().before(b)) {
			cal.add(Calendar.MONTH, 1);
			c++;
		}
		return c - 1;
	}
	// added by rupali on 08/11/17 for displaying class code descr on customer screen [start]
	public String getClassCodeDesc(String classCode,String cusType,String userId,Connection connectionObject) throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String classDescr = "";
		String sql = "";
		try
		{
			String itemSer = checkNull(getItemSer(userId, connectionObject));
			int classCount = getCountFromSerClass(itemSer, classCode, connectionObject);
			if(classCount > 0)
			{
				sql =" SELECT CS.DESCR AS CLASS_CODE_DESCR FROM STRG_CLASS C , STRG_SER_CLASS CS  " +
						" WHERE  C.CLASS_CODE= CS.CLASS_CODE AND C.CLASS_CODE = ? AND C.ACTIVE_YN='Y'  AND CS.ITEM_SER = ?   ";
			}
			else
			{
				sql = "SELECT CLASS_CODE_DESCR FROM STRG_CUST_CLASS WHERE CLASS_CODE  = ? AND CUST_TYPE = ?";
			}

			//commented & added  by mrunalini sinkar for class code changes(end)
			pstmt = connectionObject.prepareStatement(sql);
			pstmt.setString(1, classCode);
			//commented & added  by mrunalini sinkar for class code changes(end)
			//pstmt.setString(2, cusType);
			if(classCount>0)
			{
				pstmt.setString(2, itemSer);

			}
			else
			{
				pstmt.setString(2, cusType);
			}
			//commented & added  by mrunalini sinkar for class code changes(end)

			rs = pstmt.executeQuery();
			if(rs.next())
			{
				classDescr = checkNull(rs.getString("CLASS_CODE_DESCR"));
			}
			if( rs !=null )
			{
				rs.close();
				rs = null;
			}
			if( pstmt !=null )
			{
				pstmt.close();
				pstmt = null;
			}

		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		finally
		{
			try
			{
				if( rs !=null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt !=null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		//System.out.println("classDescr val:- "+classDescr);
		return classDescr;
	}
	// added by rupali on 08/11/17 for displaying class code descr on customer screen [end]
	//added by mrunalini sinkar to  make server response  fast on 12-03-2020(start)

	public HashMap<String, String> getSerClassCodeDesc(String itemSer,Connection connectionObject) throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "";
		HashMap<String, String> serClassMap = new HashMap<String, String>();
		try
		{
			sql =" SELECT CS.DESCR AS CLASS_CODE_DESCR,CS.CLASS_CODE AS CLASS_CODE FROM STRG_CLASS C , STRG_SER_CLASS CS  " +
					" WHERE  C.CLASS_CODE= CS.CLASS_CODE  AND C.ACTIVE_YN='Y'  AND CS.ITEM_SER = ?   ";

			pstmt = connectionObject.prepareStatement(sql);
			pstmt.setString(1, itemSer);
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				String classCode = checkNull(rs.getString("CLASS_CODE"));
				String classDescr = checkNull(rs.getString("CLASS_CODE_DESCR"));
				serClassMap.put(classCode, classDescr);
			}
			if( rs !=null )
			{
				rs.close();
				rs = null;
			}
			if( pstmt !=null )
			{
				pstmt.close();
				pstmt = null;
			}

		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		finally
		{
			try
			{
				if( rs !=null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt !=null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return serClassMap;
	}
	public HashMap<String, String> getCustClassCodeDesc(String custType,Connection connectionObject) throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "";
		HashMap<String, String> custClassMap = new HashMap<String, String>();
		try
		{

			sql="SELECT SCC.CLASS_CODE AS CLASS_CODE,SCC.CLASS_CODE_DESCR AS CLASS_CODE_DESCR,SCC.CUST_TYPE AS CUST_TYPE FROM STRG_CUST_CLASS SCC,STRG_CUST_TYPE SCT " +
					"WHERE SCC.CUST_TYPE=SCT.TYPE AND SCT.DCR_GROUP = ? ";


			pstmt = connectionObject.prepareStatement(sql);
			pstmt.setString(1, custType);
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				String classCode = checkNull(rs.getString("CLASS_CODE"));
				String classCustType = checkNull(rs.getString("CUST_TYPE"));
				String classDescr = checkNull(rs.getString("CLASS_CODE_DESCR"));

				custClassMap.put(classCustType+"@"+classCode, classDescr);
			}
			if( rs !=null )
			{
				rs.close();
				rs = null;
			}
			if( pstmt !=null )
			{
				pstmt.close();
				pstmt = null;
			}

		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		finally
		{
			try
			{
				if( rs !=null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt !=null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		System.out.println("custClassMap for strg_cus_class["+custClassMap+"]");
		return custClassMap;
	}
	//added by mrunalini sinkar to  make server response  fast on 12-03-2020(end)
	// added by rupali on 10/11/17 for not allowing to enter DAR if 3 DCR are pending to confirm [start]
	public String getMsgDescr(String messageCode,Connection connectionObject)throws ITMException
	{
		//System.out.println(">>>>>>>>>>getMsgDescr()<<<<<<<<<<<<");
		String returnString="";
		String msgDescr="";
		boolean isLocalConn =false;
		try
		{
			//Connection connectionObject = null;
			PreparedStatement pstmtSelect = null;
			ResultSet resultSelect = null ;
			if(connectionObject == null)
			{
				/*ConnDriver connDriver = new ConnDriver();
					connectionObject = connDriver.getConnectDB("DriverValidator");*/
				connectionObject = getConnection();//chnged by sachin satre on [9-nov-16] to get connection
				isLocalConn =true;
			}
			String selectMsgDescrSql = "SELECT MSG_DESCR FROM MESSAGES WHERE MSG_NO= ? ";
			pstmtSelect = connectionObject.prepareStatement(selectMsgDescrSql);
			pstmtSelect.setString(1, messageCode);
			resultSelect = pstmtSelect.executeQuery();
			if(resultSelect.next())
			{
				msgDescr = (resultSelect.getString("MSG_DESCR") == null)?"":resultSelect.getString("MSG_DESCR").trim();
			}
			returnString=msgDescr;
			resultSelect.close();
			resultSelect=null;
			pstmtSelect.close();
			pstmtSelect=null;

		}
		catch(Exception e)
		{
			System.out.println( "Exception :StrgMeetWizardEJB:getMsgDescr():==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(isLocalConn && connectionObject != null)
				{
					connectionObject.close();
					connectionObject=null;
				}
			}
			catch (Exception e)
			{
				e.getMessage();
			}
		}
		return returnString;
	}
	// added by rupali on 10/11/17 for not allowing to enter DAR if 3 DCR are pending to confirm [end]
	public String getEmpCode(String userId,Connection connectionObject)throws ITMException
	{
		String empCode="";
		String entityCode="";
		boolean isLocalConn =false;
		PreparedStatement pstmtSelect = null;
		ResultSet resultSelect = null ;
		try
		{
			if(connectionObject == null)
			{
				connectionObject = getConnection();
				isLocalConn =true;
			}
			String selectMsgDescrSql = "SELECT EMP_CODE,ENTITY_CODE FROM USERS WHERE CODE= ? ";
			pstmtSelect = connectionObject.prepareStatement(selectMsgDescrSql);
			pstmtSelect.setString(1, userId);
			resultSelect = pstmtSelect.executeQuery();
			if(resultSelect.next())
			{
				empCode = checkNull(resultSelect.getString("EMP_CODE"));
				entityCode = checkNull(resultSelect.getString("ENTITY_CODE"));
			}
			if(resultSelect != null)
				{
					resultSelect.close();
					resultSelect = null;
				}
				if(pstmtSelect != null)
				{
					pstmtSelect.close();
					pstmtSelect = null;
				}
			if(empCode == null || empCode.trim().length() == 0)
			{
				empCode = entityCode;
			}

		}
		catch(Exception e)
		{
			System.out.println( "Exception :StrgMeetWizardEJB:getMsgDescr():==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(resultSelect != null)
				{
					resultSelect.close();
					resultSelect = null;
				}
				if(pstmtSelect != null)
				{
					pstmtSelect.close();
					pstmtSelect = null;
				}
				if(isLocalConn && connectionObject != null)
				{
					connectionObject.close();
					connectionObject=null;
				}
			}
			catch (Exception e)
			{
				e.getMessage();
			}
		}
		return empCode;
	}

	/*protected HashMap getItemAttributeDetails(Connection conn, String query, String bindValue, int strgCustCnt, String custList, String priceList, int sprsCnt) throws ITMException
	{
		HashMap itemAttribMap = new HashMap();
		PreparedStatement pStmt = null;
		PreparedStatement pstmtItemAttrib = null;
		//PreparedStatement pstmtAttribVal = null;
		//PreparedStatement pstmtAttrib2 = null;
		//PreparedStatement pstmtAttrib3 = null;
		ResultSet rs = null;
		//ResultSet rsAttrib2 = null;
		//ResultSet rsAttrib3 = null;
		//ResultSet rsAttribVal = null;
		String sqlStr = "";
		String productCode = "";
		String productType = "";
		try
		{
			String itemCode = "";
			String itemSize = "";
			String itemColor = "";
			String itemVariant = "";
			String itemAttribDescr = "";
			String itemCodeStr = "";
			String prodCode = "";
			String prodType = "";

			pStmt = conn.prepareStatement(query);
			if(bindValue != null && bindValue.trim().length() > 0)
			{
				pStmt.setString(1, bindValue);
			}
			rs = pStmt.executeQuery();
			while (rs.next())
			{
				itemCode = checkNull(rs.getString("ITEM_CODE"));
				prodCode = checkNull(rs.getString("PRODUCT_CODE"));
				prodType = checkNull(rs.getString("PRODUCT_TYPE"));

				if(itemCodeStr == null || itemCodeStr.trim().length() == 0)
				{
					itemCodeStr = itemCode;
				}
				else
				{
					itemCodeStr = itemCodeStr + "','" + itemCode;
				}
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pStmt != null)
			{
				pStmt.close();
				pStmt = null;
			}
			itemCodeStr = "'" + itemCodeStr + "'";

			System.out.println("itemCodeStr =["+itemCodeStr+"]");

			
			String itemAttribSql = "SELECT PHY_ATTRIB_1, PHY_ATTRIB_2, PHY_ATTRIB_3 FROM ITEM_TYPE WHERE ITEM_TYPE = ?";
			pstmtAttrib = conn.prepareStatement(itemAttribSql);

			String itemAttribValSql = " SELECT DISTINCT TRIM(V.ATTRIB_ID),SORT_ORDER AS PSIZE,V.DESCR FROM ITEM I, ITM_ATTRIB_VAL V WHERE V.ATTRIB_ID = I.PHY_ATTRIB_1 AND "
									+" I.PRODUCT_CODE = ? AND I.ITEM_CODE != ? AND V.ATTRIB_CODE = I.PHY_ATTRIB_22 "
									+" AND I.ACTIVE = 'Y' "
									+" order by SORT_ORDER ";
			pstmtAttribVal = conn.prepareStatement(itemAttribValSql);

			String itemAttrib2Sql = " SELECT DISTINCT I.PHY_ATTRIB_2,V.DESCR FROM ITEM I,ITM_ATTRIB_VAL V "
						+" WHERE I.PRODUCT_CODE = ? AND I.ITEM_CODE != ? "
						+" AND I.PHY_ATTRIB_2 = V.ATTRIB_ID "
						+" AND V.ATTRIB_CODE = ? "
						+" AND I.ACTIVE = 'Y' "
						+" ORDER BY I.PHY_ATTRIB_2";

			pstmtAttrib2 = conn.prepareStatement(itemAttrib2Sql);

			String itemAttrib3Sql = " SELECT DISTINCT I.PHY_ATTRIB_3,V.DESCR FROM ITEM I,ITM_ATTRIB_VAL V "
						+" WHERE I.PRODUCT_CODE = ? AND I.ITEM_CODE != ? AND I.PHY_ATTRIB_3 = V.ATTRIB_ID"
						+" AND V.ATTRIB_CODE= ? "
						+" AND I.ACTIVE = 'Y' "
						+" ORDER BY I.PHY_ATTRIB_3";

			pstmtAttrib3 = conn.prepareStatement(itemAttrib3Sql);
			 
			// changes made by rupali on 03/05/19 for mapping og physical attribute [start]
			String itemSizeCol = getSfaParmValue(bindValue,"ITEM_ATTRIB_SIZE",conn);
			String itemColorCol = getSfaParmValue(bindValue,"ITEM_ATTRIB_COLOR",conn);
			String itemVariantCol = getSfaParmValue(bindValue,"ITEM_ATTRIB_VARIANT",conn);
			String itemGroupCol = getSfaParmValue(bindValue,"ITEM_ATTRIB_GROUP",conn);

			if(itemSizeCol.trim().length() == 0)
			{
				itemSizeCol = "PHY_ATTRIB_1";
			}
			if(itemColorCol.trim().length() == 0)
			{
				itemColorCol = "PHY_ATTRIB_2";
			}
			if(itemVariantCol.trim().length() == 0)
			{
				itemVariantCol = "PHY_ATTRIB_3";
			}
			if(itemGroupCol.trim().length() == 0)
			{
				itemGroupCol = "PHY_ATTRIB_22";
			}

			String itemAttribSql = "SELECT DISTINCT ITEM.ITEM_CODE AS ITEM_CODE, ITEM.DESCR, "+
					"(SELECT DESCR FROM ITM_ATTRIB_VAL WHERE ITEM.PHY_ATTRIB_1=ATTRIB_ID) AS ITEM_SIZE, "+
					"(SELECT DESCR FROM ITM_ATTRIB_VAL WHERE ITEM.PHY_ATTRIB_2=ATTRIB_ID) AS ITEM_COLOR, "+
					"(SELECT DESCR FROM ITM_ATTRIB_VAL WHERE ITEM.PHY_ATTRIB_3=ATTRIB_ID) AS ITEM_VARIANT "+
					"FROM ITEM ITEM, ITM_ATTRIB_VAL ITEM_VAL "+
					"WHERE ITEM.PRODUCT_CODE= ? AND ITEM.PHY_ATTRIB_1 "+
					"IN(SELECT DISTINCT TRIM(V.ATTRIB_ID) FROM ITEM I, ITM_ATTRIB_VAL V WHERE V.ATTRIB_ID = I.PHY_ATTRIB_1 AND "+
					"I.PRODUCT_CODE = ? AND I.ITEM_CODE != ? AND V.ATTRIB_CODE = I.PHY_ATTRIB_22 "+
					"AND I.ACTIVE = 'Y' AND ITEM.ITEM_CODE IN("+itemCodeStr+")"+
					") order by item.item_code ";
			String itemAttribSql = "SELECT DISTINCT ITEM.ITEM_CODE AS ITEM_CODE, ITEM.DESCR, "+
					"(SELECT DESCR FROM ITM_ATTRIB_VAL WHERE ITEM."+itemSizeCol+"=ATTRIB_ID) AS ITEM_SIZE, "+
					"(SELECT DESCR FROM ITM_ATTRIB_VAL WHERE ITEM."+itemColorCol+"=ATTRIB_ID) AS ITEM_COLOR, "+
					"(SELECT DESCR FROM ITM_ATTRIB_VAL WHERE ITEM."+itemVariantCol+"=ATTRIB_ID) AS ITEM_VARIANT "+
					"FROM ITEM ITEM, ITM_ATTRIB_VAL ITEM_VAL "+
					"WHERE ITEM.PRODUCT_CODE= ? AND ITEM."+itemSizeCol+" "+
					"IN(SELECT DISTINCT TRIM(V.ATTRIB_ID) FROM ITEM I, ITM_ATTRIB_VAL V WHERE V.ATTRIB_ID = I."+itemSizeCol+" AND "+
					"I.PRODUCT_CODE = ? AND I.ITEM_CODE != ? AND V.ATTRIB_CODE = I."+itemGroupCol+" "+
					"AND I.ACTIVE = 'Y' AND ITEM.ITEM_CODE IN("+itemCodeStr+")"+
					") order by item.item_code ";
			// changes made by rupali on 03/05/19 for mapping og physical attribute [end]
			pstmtItemAttrib = conn.prepareStatement(itemAttribSql);

			// commentted and added by rupali on 01/02/19 for getting only active items [start]
			if(strgCustCnt  > 0)
			{
				sqlStr = " SELECT DISTINCT P.PRODUCT_CODE AS PRODUCT_CODE, P.PRODUCT_TYPE AS PRODUCT_TYPE " +
						" FROM  STRG_CUSTOMER SC, STATE S ,ITEM ITEM LEFT OUTER JOIN PRICELIST  PM ON ITEM.ITEM_CODE = PM.ITEM_CODE "+
						" LEFT OUTER JOIN PRODUCT P ON ITEM.PRODUCT_CODE = P.PRODUCT_CODE "+
						" WHERE SC.STATE_CODE = S.STATE_CODE AND S.PRICE_LIST = PM.PRICE_LIST "+
						" AND SC.SC_CODE in( "+ custList + ")" +
						" AND (CASE WHEN ITEM.ITEM_USAGE IS NULL THEN 'O' ELSE ITEM.ITEM_USAGE END ) NOT IN('S','G') ";
				pStmt = conn.prepareStatement(sqlStr);
			}
			else
			{
				sqlStr = " SELECT DISTINCT P.PRODUCT_CODE AS PRODUCT_CODE, P.PRODUCT_TYPE AS PRODUCT_TYPE " +
						" FROM ITEM ITEM LEFT OUTER JOIN PRICELIST  PM ON ITEM.ITEM_CODE = PM.ITEM_CODE "+
						" LEFT OUTER JOIN PRODUCT P ON ITEM.PRODUCT_CODE = P.PRODUCT_CODE "+
						" WHERE PM.PRICE_LIST= ? AND (CASE WHEN ITEM.ITEM_USAGE IS NULL THEN 'O' ELSE ITEM.ITEM_USAGE END ) NOT IN('S','G') ";
				pStmt = conn.prepareStatement(sqlStr);
				pStmt.setString(1, priceList);
			}
			// added by rupali on 02/05/19 for getting item from sprs_item if present [start]
			String itemUSage="";
			String parmItemUsage = getSfaParmValue(bindValue,"SAMPLE_ITEM_USAGE",conn);
			if(parmItemUsage!=null && parmItemUsage.trim().length()>0)
			{
				itemUSage=checkNull(getFormattedStringBuff( parmItemUsage ));
			}
			else
			{
				itemUSage="'G','S'";
			}

			if(sprsCnt > 0)
			{
				sqlStr = " SELECT DISTINCT P.PRODUCT_CODE AS PRODUCT_CODE, P.PRODUCT_TYPE AS PRODUCT_TYPE " +
						" FROM  SALES_PERS SP, STATE S ,ITEM ITEM LEFT OUTER JOIN PRICELIST  PM ON ITEM.ITEM_CODE = PM.ITEM_CODE "+
						" LEFT OUTER JOIN PRODUCT P ON ITEM.PRODUCT_CODE = P.PRODUCT_CODE "+
						" WHERE SP.STATE_CODE = S.STATE_CODE AND S.PRICE_LIST = PM.PRICE_LIST " +
						" AND SP.SALES_PERS = ? AND ITEM.ACTIVE = 'Y' "+
						" AND (CASE WHEN ITEM.ITEM_USAGE IS NULL THEN 'O' ELSE ITEM.ITEM_USAGE END ) NOT IN("+itemUSage+") ";
			}
			// added by rupali on 02/05/19 for getting item from sprs_item if present [end]
			else
			{
				sqlStr = " SELECT DISTINCT P.PRODUCT_CODE AS PRODUCT_CODE, P.PRODUCT_TYPE AS PRODUCT_TYPE " +
						" FROM  SALES_PERS SP, STATE S ,ITEM ITEM LEFT OUTER JOIN PRICELIST  PM ON ITEM.ITEM_CODE = PM.ITEM_CODE "+
						" LEFT OUTER JOIN PRODUCT P ON ITEM.PRODUCT_CODE = P.PRODUCT_CODE "+
						" WHERE SP.STATE_CODE = S.STATE_CODE AND S.PRICE_LIST = PM.PRICE_LIST " +
						" AND SP.SALES_PERS = ? AND SP.ITEM_SER = ITEM.ITEM_SER AND ITEM.ACTIVE = 'Y' "+
						" AND (CASE WHEN ITEM.ITEM_USAGE IS NULL THEN 'O' ELSE ITEM.ITEM_USAGE END ) NOT IN("+itemUSage+") ";
			}
			pStmt = conn.prepareStatement(sqlStr);
			pStmt.setString(1, bindValue);
			// commentted and added by rupali on 01/02/19 for getting only active items [end]

			rs = pStmt.executeQuery();
			while(rs.next())
			{
				productCode = "";
				productType = "";
				itemSize = "";
				itemColor = "";
				itemVariant = "";
				itemAttribDescr = "";
				productCode = checkNull(rs.getString("PRODUCT_CODE"));
				productType = checkNull(rs.getString("PRODUCT_TYPE"));

				pstmtItemAttrib.setString(1, productCode);
				pstmtItemAttrib.setString(2, productCode);
				pstmtItemAttrib.setString(3, productCode);
				ResultSet rsItemAttrib = pstmtItemAttrib.executeQuery();
				while(rsItemAttrib.next())
				{
					System.out.println("inside rsItemAttrib resultset");
					HashMap itemMap = new HashMap();
					itemCode = checkNull(rsItemAttrib.getString("ITEM_CODE"));
					itemSize = checkNull(rsItemAttrib.getString("ITEM_SIZE"));
					itemColor = checkNull(rsItemAttrib.getString("ITEM_COLOR"));
					itemVariant = checkNull(rsItemAttrib.getString("ITEM_VARIANT"));
					System.out.println("itemCode ::"+itemCode+" itemSize"+itemSize+" itemColor"+itemColor+" itemVariant"+itemVariant);

					if((itemColor == null || itemColor.trim().length() == 0) && (itemVariant.length() > 0))
					{
						itemAttribDescr = itemVariant;
					}
					else if((itemVariant == null || itemVariant.trim().length() == 0) && (itemColor.length() > 0))
					{
						itemAttribDescr = itemColor;
					}
					else if(itemColor.length() == 0 && itemVariant.length() == 0)
					{
						//itemAttribDescr = "Attribute not defined";
						itemAttribDescr = "";
					}
					if(itemColor.length() > 0 && itemVariant.length() > 0)
					{
						itemAttribDescr = itemVariant+"("+itemColor+")";
					}
					itemMap.put("ITEM_SIZE", itemSize);
					itemMap.put("ITEM_ATTRIBUTE", itemAttribDescr);

					itemAttribMap.put(itemCode, itemMap);

					//System.out.println("itemAttribMap ::"+itemAttribMap);
				}
				pstmtItemAttrib.clearParameters();
				if(rsItemAttrib != null)
				{
					rsItemAttrib.close();
					rsItemAttrib = null;
				}

			}
		}
		catch(SQLException se)
		{
			se.printStackTrace();
			throw new ITMException(se);

		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);

		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmtItemAttrib != null)
				{
					pstmtItemAttrib.close();
					pstmtItemAttrib = null;
				}
				if(pStmt != null)
				{
					pStmt.close();
					pStmt = null;
				}
			}
			catch(Exception ee)
			{

			}
		}
		System.out.println("getItemAttributeDetails >> itemAttribMap ::"+itemAttribMap);
		return itemAttribMap;
	}*/
	// added by rupali on 22/12/17 for getting total months between two dates [start]
	/*public String getTotalMonths(String itemCode, String stockInfo, Connection conn) throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String totMonths = "";
		try
		{
			String expDate = "";
			String sql = "select exp_date from item_lot_info where item_code = ? and  lot_no = ?";
			pstmt =  conn.prepareStatement(sql);
			pstmt.setString(1, itemCode);
			pstmt.setString(2, stockInfo);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				expDate = (rs.getString("exp_date") == null) ?"":rs.getString("exp_date").trim();
				System.out.println("expDate is::::::"+expDate);
			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
			Date date1 = Calendar.getInstance().getTime();
			DateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
			DateFormat sdf1 = new SimpleDateFormat("MM/yy");
			String today = sdf.format(date1);
			System.out.println("Today : " + today);
			String expDt = "";
			if(expDate.trim().length() != 0)
			{
				totMonths = "0";
				SimpleDateFormat inputFormat=new SimpleDateFormat(getDBDateFormat());
				Date eventDate1=null;
				eventDate1 = inputFormat.parse(expDate);
				expDate=sdf.format(eventDate1);
				System.out.println("expDate is:::::"+expDate);
				expDt=sdf1.format(eventDate1);
				System.out.println("expDt is:::::"+expDt);
				Date date3 = sdf.parse(today);
				Date date2 = sdf.parse(expDate);
				if (date3.compareTo(date2) < 0)
				{
					Calendar cal = Calendar.getInstance();
					if (date3.before(date2)) {
						cal.setTime(date3);
					} else {
						cal.setTime(date2);
						date2 = date3;
					}
					int differ = 0;
					while (cal.getTime().before(date2)) {
						cal.add(Calendar.MONTH, 1);
						differ++;
					}
					totMonths = Integer.toString(differ - 1);
				}
				totMonths = expDt + " (" + totMonths +" "+ "Months)";
			}
			System.out.println("totMonths:::::"+totMonths);
		}
		catch(Exception e)
		{
			System.out.println( "Exception :StrgMeetWizardEJB:getMsgDescr():==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch (Exception e)
			{
				e.getMessage();
			}
		}
		return totMonths;
	}
	// added by rupali on 22/12/17 for getting total months between two dates [end]
*/	public String getStokistName(String stockistCode,String sprsCode,String stockistTable,Connection connectionObject) throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String stockistName = "";
		try
		{
			String sql = "";
			if(stockistTable.equalsIgnoreCase("SPRS_STOCKIST"))
			{
				sql  = "SELECT CUST.CUST_NAME AS STRG_NAME FROM CUSTOMER CUST WHERE CUST_CODE = ? ";
			}
			else
			{
				sql  = "SELECT SC.FIRST_NAME || ' ' ||  SC.LAST_NAME AS STRG_NAME FROM STRG_CUSTOMER SC WHERE SC_CODE = ? ";
			}
			pstmt = connectionObject.prepareStatement(sql);
			pstmt.setString(1, stockistCode);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				stockistName = checkNull(rs.getString("STRG_NAME"));
			}
			if( rs !=null )
			{
				rs.close();
				rs = null;
			}
			if( pstmt !=null )
			{
				pstmt.close();
				pstmt = null;
			}

		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		finally
		{
			try
			{
				if( rs !=null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt !=null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return stockistName;
	}

	//added by mrunalini sinkar for offline on 10-feb-2018(start)
	public String getSubFormData(Document dom,Connection connectionObject) throws ITMException
	{
		StringBuffer valueXmlString = new StringBuffer();
        PreparedStatement pstmt=null;
        //Added by Pankaj R oon 15-JUL-21 [START]
        PreparedStatement pstmtCust = null;
        ResultSet custRs = null;
        //Added by Pankaj R oon 15-JUL-21 [END]
        ResultSet dispRs=null;
		PreparedStatement dispPstmt =null;
		ResultSet rs=null;
		String sql=null;
		String currDate = "";
		double rate = 0d;
		double mrprate = 0d;
		
		PreparedStatement pstmtTranId=null;
		ResultSet rsTranId=null;
		PreparedStatement pstmtAttach=null;
		ResultSet rsAttach=null;
		PreparedStatement pstmtDisp =null;
		ResultSet rsDisp=null;
		boolean brandAval=false;
		//ADDED BY PRACHI ON 13JUNE2022 ID:W22CSUN019
		HashMap<String, String> itemUsageMap = new HashMap<String, String>();
		PreparedStatement custPrcList =null;
		ResultSet rsCustPrc=null; 
		PreparedStatement pstmt1=null;
		ResultSet rs1=null;
		PreparedStatement pstmt2=null;
		ResultSet rs2=null;
		try
		{
			DARCommonBean darCommonBean= new DARCommonBean();
			DistCommon distCommon = new DistCommon();

			DateFormat applFormat = new SimpleDateFormat(getApplDateFormat());
			DateFormat dbFormat = new SimpleDateFormat(getDBDateFormat());

			java.util.Date date = Calendar.getInstance().getTime();
			currDate = applFormat.format( date );
			String salesPers = checkNull(genericUtility.getColumnValue("sales_pers", dom));
			salesPers = getEmpCode(salesPers, connectionObject);
			String objName = checkNull(genericUtility.getColumnValue("obj_name", dom));
			String formName = checkNull(genericUtility.getColumnValue("form_no", dom));
			String formNo = checkNull(getFormNo(objName,formName, connectionObject));

			valueXmlString.append( "<Root>\r\n" );
			System.out.println("form name inside getSubForm Data["+formName+"]");
			// added by mrunalini sinkar for default activity for CHC client on 07-02-2019[start]
			if("doctor".equalsIgnoreCase(formName))
			{
				String sampleOrder=checkNull(getFormNo(objName, "sampleorder", connectionObject));
				String doctorTeam=checkNull(getFormNo(objName, "team", connectionObject));
				String invoiceFormNo=checkNull(getFormNo(objName, "invoice", connectionObject));
				String collectionFormNo=checkNull(getFormNo(objName, "collection", connectionObject));
				//Added by Pooja on 18/12/19 [Coaching related detail form implementation] START
				String designCode = getDesignName(salesPers, connectionObject);
				String grade = getGrade(salesPers, connectionObject);
				String coachingDesignCode = getCoachingDesignCodes(connectionObject);
				//Added by Pooja on 18/12/19 [Coaching related detail form implementation] END
				ArrayList<String> holiList = new ArrayList<String>();
				ArrayList<String> pendDates = new ArrayList<String>();
				ArrayList<String> holPen =new ArrayList<String>();
				ArrayList custTypeList = new ArrayList();
				custTypeList=getTemplateSurvey(connectionObject, salesPers);
				//Added by mrunalini sinkar to showing headquarter in summary page (start)
				String stanCodeHQ="",headQaurter="";
				String hqSql="SELECT EMP.STAN_CODE__HQ AS STAN_CODE__HQ,ST.DESCR AS HEADQAURTER FROM EMPLOYEE EMP,STATION ST WHERE EMP.EMP_CODE=? AND EMP.STAN_CODE__HQ=ST.STAN_CODE";
				pstmt =  connectionObject.prepareStatement(hqSql);
				pstmt.setString(1, salesPers);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					stanCodeHQ = checkNull(rs.getString("STAN_CODE__HQ"));
					headQaurter = checkNull(rs.getString("HEADQAURTER"));
				}
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}

				//Added by mrunalini sinkar to showing headquarter in summary page (end)
				//Added by Bhagyashri T for showing Load_no and Vehicle no on summary page (start)
				String eventdate = genericUtility.getValidDateTimeString( currDate , getApplDateFormat() , getDBDateFormat());
				
				/*--Commented and changed by Gulzar on 02MAR24 as wrong load_no was populated if tow created on the same day
				//Added by mrunalini sinkar for Load Number changes28 Feb 2023(Start)
				String maxDaySummDate="";

				String daySummMaxSQL="SELECT MAX(EVENT_DATE) AS MAX_DAY_SUMM_DATE FROM SPRS_DAY_SUMM WHERE SALES_PERS=? AND EVENT_DATE<=? ";
				pstmt =  connectionObject.prepareStatement(daySummMaxSQL);
				pstmt.setString(1, salesPers);
				pstmt.setTimestamp(2, java.sql.Timestamp.valueOf(eventdate));
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					maxDaySummDate=checkNull(rs.getString("MAX_DAY_SUMM_DATE"));
				}
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				//Added by mrunalini sinkar for Load Number changes28 Feb 2023(End)

				String loadNo="",vehicleNo="";
				if(maxDaySummDate != null && maxDaySummDate.trim().length() > 0) 
				{
					String daySummSql="SELECT SDA.LOAD_NO AS LOAD_NO,SDA.VEH_NO AS VEHICLE_NO FROM SPRS_DAY_SUMM SDA WHERE TRIM(SDA.SALES_PERS)=TRIM(?) AND SDA.EVENT_DATE=?";
					pstmt =  connectionObject.prepareStatement(daySummSql);
					pstmt.setString(1, salesPers);
					pstmt.setTimestamp(2,java.sql.Timestamp.valueOf(maxDaySummDate));
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						loadNo = checkNull(rs.getString("LOAD_NO"));
						vehicleNo = checkNull(rs.getString("VEHICLE_NO"));
					}
					if (rs!= null)
					{
						rs.close();
						rs = null;
					}
					if(pstmt!=null)
					{
						pstmt.close();
						pstmt = null;
					}

				}
				*/
				String loadNo="",vehicleNo="";
				String daySummSql="SELECT MAX(TO_NUMBER(CASE WHEN LOAD_NO IS NULL THEN '0' ELSE LOAD_NO END)) AS LOAD_NO, MAX(VEH_NO) AS VEHICLE_NO FROM SPRS_DAY_SUMM WHERE SALES_PERS =? AND EVENT_DATE = (SELECT MAX(EVENT_DATE) FROM SPRS_DAY_SUMM WHERE SALES_PERS= ?)";
				pstmt =  connectionObject.prepareStatement(daySummSql);
				pstmt.setString(1, salesPers);
				pstmt.setString(2, salesPers);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					loadNo = checkNull(rs.getString("LOAD_NO"));
					vehicleNo = checkNull(rs.getString("VEHICLE_NO"));
				}
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				
				//End Changes by Gulzar on 02MAR24
				//Added by Bhagyashri T for showing Load_no and Vehicle no on summary page (end)
				
				//added by prachi on 28-DEC-2022/=
				ArrayList<String> strgCodeList=new ArrayList<String>();
				String strgCodeSql="select strg_code from strg_meet where event_date=? and sales_pers=?";
				pstmt =  connectionObject.prepareStatement(strgCodeSql);
				pstmt.setTimestamp(1, java.sql.Timestamp.valueOf(eventdate));
				pstmt.setString(2, salesPers);
				rs = pstmt.executeQuery();
				while(rs.next())
				{
					String strgCode = checkNull(rs.getString("strg_code"));
					strgCodeList.add(strgCode);
				}
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				System.out.println("strgCodeList::"+strgCodeList);
				//added by prachi end
				
				//added by mruanlini sinkar fro check sequentail reporting only when salesperson REP_CONT_CHK_DAYS value is 0 on 5-april-2019(start)
				int repContChkDays = 0;
				String repCNTSQL = " SELECT REP_CONT_CHK_DAYS FROM SALES_PERS WHERE SALES_PERS = ? ";
				PreparedStatement repPstmt = connectionObject.prepareStatement(repCNTSQL);
				repPstmt.setString(1, salesPers);
				ResultSet repRS = repPstmt.executeQuery();
				if (repRS.next())
				{
					repContChkDays = repRS.getInt("REP_CONT_CHK_DAYS");
				}
				if (repRS != null)
				{
					repRS.close();
					repRS = null;
				}
				if (repPstmt != null)
				{
					repPstmt.close();
					repPstmt = null;
				}

				//added by mruanlini sinkar fro check sequentail reporting only when salesperson REP_CONT_CHK_DAYS value is 0 on 5-april-2019(end)


				//String defACt = checkNull(getSfaParmValue(salesPers, "DEF_ACT_CODE", connectionObject));    commented by shweta m for child parent activity code
			    String defACt=checkNull(getSfaParmValue(salesPers,"DEF_ACT_REALCODE",connectionObject));  // adding new sfaParamValue for getting child activity code shweta m 31-05-21 
				String actDescr="",actType="",placReq="",locReq="";
				//Added by Bhagyashri T for Activity place[W21DSUN098][26/JUL/21]
				String actPlace=""; 
				//String defACtsql = "SELECT DESCR AS ACTIVITY_DESCR,ACTIVITY_TYPE,PLACE_REQUIRED,LOC_REQ FROM FIELDACTIVITY WHERE ACTIVITY_CODE = ? ";
				String defACtsql = "SELECT DESCR AS ACTIVITY_DESCR,ACTIVITY_TYPE,PLACE_REQUIRED,LOC_REQ,ACTIVITY_PLACE FROM FIELDACTIVITY WHERE ACTIVITY_CODE = ? ";//Added by Bhagyashri T for Activity place[W21DSUN098][26/JUL/21]
				pstmt = connectionObject.prepareStatement(defACtsql);
				pstmt.setString(1, defACt);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					actDescr = checkNull(rs.getString("ACTIVITY_DESCR"));
					actType = checkNull(rs.getString("ACTIVITY_TYPE"));
					placReq = checkNull(rs.getString("PLACE_REQUIRED"));
					//Added by Sadique S on 21/06/2020 [to validate on location validation required or not]
					locReq = checkNull(rs.getString("LOC_REQ"));
					actPlace = checkNull(rs.getString("ACTIVITY_PLACE")); //Added by Bhagyashri T for Activity place[W21DSUN098][26/JUL/21]
				}
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				// added by rupali on 14/02/19 for passing protect subform value in auto mode [start]
				String active="",parmVal="",formNum="";
				//String subFormsql = getSfaParmValue(salesPers,"IS_SUBFORM_PROTECT",connectionObject);
				parmVal = getSfaParmValue(salesPers,"IS_SUBFORM_PROTECT",connectionObject);

				if(parmVal.trim().length() > 0)
				{
					String subFormName = "";
					String [] subForm = parmVal.split(",");
					for(int i = 0 ;i < subForm.length;i++)
					{
						if(subFormName == null || subFormName.trim().length() == 0)
						{
							subFormName = subForm[i];
						}
						else
						{
							subFormName = subFormName + "','" + subForm[i];
						}
					}
					subFormName = "'" + subFormName + "'";

					//String objectName = getObjNameFromDom( dom, "objName" , 1);
					String objWinName = "w_"+objName;
					String objFormSql= "SELECT FORM_NO FROM OBJ_FORMS WHERE WIN_NAME= ? AND FORM_NAME IN("+subFormName+") ";
					PreparedStatement objFormpstmt = connectionObject.prepareStatement(objFormSql);
					objFormpstmt.setString(1, objWinName);
					ResultSet objFormrs = objFormpstmt.executeQuery();
					while(objFormrs.next())
					{
						String objFormNo = checkNull(objFormrs.getString("FORM_NO"));
						if(formNum == null || formNum.trim().length() == 0)
						{
							formNum = objFormNo;
						}
						else
						{
							formNum = formNum + "," + objFormNo;
						}
					}
					if(objFormrs != null)
					{
						objFormrs.close();
						objFormrs = null;
					}
					if(objFormpstmt != null)
					{
						objFormpstmt.close();
						objFormpstmt = null;
					}

				}

				String mgrCode = getMGREmployee(salesPers, connectionObject);

				// added by rupali on 14/02/19 for passing protect subform value in auto mode [end]
				// added by mrunalini sinkar for allw_delay_prd on 28-02-2019(start)
				int allwdPrd=0;
				String allDelaySql = "SELECT ALLWD_DELAY_PRD FROM SALES_PERS WHERE SALES_PERS=?";
				pstmt =  connectionObject.prepareStatement(allDelaySql);
				pstmt.setString(1, checkNull(salesPers));
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					allwdPrd = rs.getInt("ALLWD_DELAY_PRD");
				}
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}

				//added by mrunalini sinkar for allw_delay_prd on 28-02-2019(end)
				// added by mrunalini sinakr on 04-april-2019 for store holiday(start)
				//String eventdate = genericUtility.getValidDateTimeString( currDate , getApplDateFormat() , getDBDateFormat());
				String holtblno = getHoltblno(salesPers,eventdate, connectionObject);

				/*To get before date(start) */
				Calendar calBef = Calendar.getInstance();
				calBef.add(Calendar.DAY_OF_MONTH,-allwdPrd);
				java.util.Date befoDate = calBef.getTime();
				String befoDateAppl = applFormat.format( befoDate );
				String befoDateDB= genericUtility.getValidDateTimeString( befoDateAppl , getApplDateFormat() , getDBDateFormat());
				/*To get before date(end) */
				/*To get after date (start)*/
				Calendar calAft = Calendar.getInstance();
				calAft.add(Calendar.DAY_OF_MONTH,5);
				java.util.Date aftDate = calAft.getTime();
				String aftDateAppl = applFormat.format( aftDate );
				String aftDateDB= genericUtility.getValidDateTimeString( aftDateAppl , getApplDateFormat() , getDBDateFormat());
				/*To get after date (end)*/
				holiList =getHolidayList(befoDateDB,aftDateDB,holtblno,salesPers,connectionObject);//userId added by mrunalini sinkar for change_holiday(start)

				//added by mrunalini sinakr on 04-april-2019 for store holiday(end)

				// added by mrunalini sinkar on 05-april-2019 for pending dates validation(start)
				String parmValue = getSfaParmValue(salesPers,"SEQUENTIAL_DAR",connectionObject); // added by mrunalini sinkar on 21-Feb-2018(start)
				String seqDesignCode = getSfaParmValue(salesPers,"SEQ_DAR_NO_MANDATE",connectionObject); // added by mrunalini sinkar on 18-Feb-2020
				String displaytimeField = getSfaParmValue(salesPers,"HIDE_EVENT_TIME_END",connectionObject);//added by shraddha M for realtime visit time changes[17/07/2020]


				if(parmValue.equalsIgnoreCase("Y") && repContChkDays == 0)
				{
					pendDates = getPendigDates(connectionObject,salesPers,currDate);
				}
				/*if(!pendDates.isEmpty())
				{
					String penFirstDate=pendDates.get(0);
					String newDcrDateString = genericUtility.getValidDateTimeString( penFirstDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );

					boolean flag1 = validateHoliday( newDcrDateString ,salesPers, salesPers, connectionObject);
					if(flag1 == true)
					{
						pendDates.remove(penFirstDate);
					}

					String dbPendFDate= genericUtility.getValidDateTimeString( penFirstDate , getApplDateFormat() , getDBDateFormat());
					holPen = getHolidayList(dbPendFDate,eventdate,holtblno,connectionObject);
				}*/
				// added by mrunalini sinkar on 05-april-2019 for pending dates validation(end)
				//added by mrunalini sinkar to check bangldesh user or not(start)
				String brndParmData  = checkNull(getSfaParmValue(salesPers,"DAR_BRAND_MANDATE",connectionObject));
				
				
				if(brndParmData.equalsIgnoreCase("Y"))
				{

					String fromDate="",code="";
					String frDate="SELECT FR_DATE-1 AS FR_DATE FROM PERIOD WHERE ? BETWEEN FR_DATE AND TO_DATE" ;
					pstmt = connectionObject.prepareStatement(frDate);
					pstmt.setTimestamp(1, java.sql.Timestamp.valueOf(eventdate));
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						fromDate= checkNull(rs.getString("FR_DATE"));
					}

					if (rs!= null)
					{
						rs.close();
						rs = null;
					}

					if(pstmt !=null)
					{
						pstmt.close();
						pstmt = null;
					}


					String periodCode="SELECT CODE FROM PERIOD WHERE ? BETWEEN FR_DATE AND TO_DATE" ;
					pstmt = connectionObject.prepareStatement(periodCode);
					pstmt.setTimestamp(1,java.sql.Timestamp.valueOf(fromDate));
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						code= checkNull(rs.getString("CODE"));
					}

					if (rs!= null)
					{
						rs.close();
						rs = null;
					}

					if(pstmt !=null)
					{
						pstmt.close();
						pstmt = null;
					}

					String brandSql = "SELECT * FROM STRG_BRAND_ACT WHERE SALES_PERS = ? AND PRD_CODE = ? ";
					pstmt = connectionObject.prepareStatement(brandSql);
					pstmt.setString(1,salesPers);
					pstmt.setString(2,code);
					rs = pstmt.executeQuery();

					if(rs.next())
					{
						brandAval=true;
					}
					if (rs!= null)
					{
						rs.close();
						rs = null;
					}

					if(pstmt !=null)
					{
						pstmt.close();
						pstmt = null;
					}

				}

				//added by mrunalini sinkar to check bangldesh user or not(end)

				String localityDetail = getLocalityOrderDetails(salesPers,eventdate,connectionObject);

				// added by rupali on 24-08-19 for STP_DAR_BLOCK_DAYS validation [start]
				ResultSet stpRs = null;
				String empCodeHO="";
				String stpStatus="";
				String usrTypeLogin = "";
				String applyStpVal = "";
				empCodeHO = getHOEmployee( salesPers, connectionObject );
				String stpChksql="SELECT STP_STATUS FROM SALES_PERS WHERE SALES_PERS = ?";
				pstmt = connectionObject.prepareStatement(stpChksql);
				pstmt.setString(1,salesPers);
				stpRs = pstmt.executeQuery();
				if(stpRs.next())
				{
					stpStatus = checkNull(stpRs.getString("STP_STATUS"));
				}
				if ( empCodeHO != null && empCodeHO.trim().length() > 0 )
				{
					usrTypeLogin = "H";
				}

				if(!"H".equalsIgnoreCase(usrTypeLogin))
				{
					if(stpStatus.equalsIgnoreCase("2"))
					{
						int darBkdy=0;
						long daysDiff = getSTPApproveDateDiff(salesPers,connectionObject);
						String darBckDys = checkNull(getSfaParmValue(salesPers, "STP_DAR_BLOCK_DAYS", connectionObject));
						if(darBckDys != null && darBckDys.trim().length()>0)//Added by mrunalini sinkar if sfaparm is not exist
						{
							darBkdy = Integer.parseInt(darBckDys);
						}
						if(daysDiff > darBkdy )
						{
							applyStpVal = "Y";
						}
					}
				}
				if(stpRs != null)
				{
					stpRs.close();
					stpRs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				// added by rupali on 24-08-19 for STP_DAR_BLOCK_DAYS validation [start]

				String joinDate = "";
				String joinDateSql = "SELECT DATE_JOIN FROM EMPLOYEE WHERE EMP_CODE = ? ";
				pstmt = connectionObject.prepareStatement(joinDateSql);
				pstmt.setString(1, salesPers);
				rs = pstmt.executeQuery();
				if (rs.next())
				{
					joinDate = rs.getString("DATE_JOIN");
				}
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}

				String salesMode = "", deviceType = "", allowDarRep = "";
				String modeSql = "SELECT MODE_REPO FROM SALES_PERS WHERE SALES_PERS= ? ";
				pstmt = connectionObject.prepareStatement(modeSql);
				pstmt.setString(1,salesPers);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					salesMode = checkNull(rs.getString("MODE_REPO"));
				}
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}

				/*String deviceTypeSql = "SELECT DEVICE_TYPE, TO_CHAR(LOGINTIME, 'DD-MM-YYYY HH24:MI:SS A.M.') FROM LOGINTRACE WHERE USERID = ? AND LOGINTIME = (SELECT MAX(LOGINTIME) FROM LOGINTRACE WHERE USERID = ?)";
				pstmt = connectionObject.prepareStatement(deviceTypeSql);
				pstmt.setString(1,salesPers);
				pstmt.setString(2,salesPers);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					deviceType = checkNull(rs.getString("DEVICE_TYPE"));
					System.out.println("DEVICE_TYPE........"+deviceType);
				}
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}*/
				deviceType = getUserInfo().getDeviceType();

				String itemSer = checkNull(getItemSer(salesPers,connectionObject));
				String propValue = fetchPropertyValue("NETREPORT_MOBMODE_DISSALLOW" , itemSer , connectionObject);

				if (!deviceType.trim().equalsIgnoreCase("Browser") && salesMode.equalsIgnoreCase("W"))
				{
					allowDarRep = "INVLIDMODE";
				}

				if (deviceType.trim().equalsIgnoreCase("Browser"))
				{
					if (salesMode.equalsIgnoreCase("M") && propValue.indexOf("A") >= 0)
					{
						allowDarRep = "MOBNETNA";
					}
				}

				String futureDateAct = "";
				ArrayList<String> futureDateActList = new ArrayList<String>();
				String actSql = "SELECT ACTIVITY_CODE FROM FIELDACTIVITY WHERE FUTURE_DATE = 1 "+
						"AND (ITEM_SER IS NULL OR ITEM_SER = 'ALL' OR ITEM_SER = ?) "+
						"AND (SITE_CODE IS NULL OR SITE_CODE = 'ALL' OR (SELECT EMP_SITE FROM EMPLOYEE WHERE EMP_CODE = ?) IN "+
						"(SELECT REGEXP_SUBSTR(SITE_CODE,'[^,]+', 1, LEVEL) FROM DUAL CONNECT BY REGEXP_SUBSTR(SITE_CODE, '[^,]+', 1, LEVEL) IS NOT NULL) ) "+
						"ORDER BY DESCR ";
				pstmt = connectionObject.prepareStatement(actSql);
				pstmt.setString(1, itemSer);
				pstmt.setString(2, salesPers);
				rs = pstmt.executeQuery();
				while(rs.next())
				{
					futureDateAct = checkNull(rs.getString("ACTIVITY_CODE"));
					futureDateActList.add(futureDateAct);
				}
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}

				int totDelPrd = 0;
				long diffDays = 0;

				Calendar alwdPrdDateCal = Calendar.getInstance();
				alwdPrdDateCal.add(Calendar.DAY_OF_MONTH,-allwdPrd);
				java.util.Date tempDate = alwdPrdDateCal.getTime();

				Calendar currDateCal = Calendar.getInstance();
				java.util.Date tempCurrDate = currDateCal.getTime();
				aftDateAppl = applFormat.format( aftDate );
				aftDateDB= genericUtility.getValidDateTimeString( aftDateAppl , getApplDateFormat() , getDBDateFormat());
				holiList = getHolidayList(befoDateDB,aftDateDB,holtblno,salesPers,connectionObject);//userId added by mrunalini sinkar for change_holiday(start)

				int holCnt = holiList.size();
				totDelPrd = allwdPrd + holCnt;
				//added by mrunalini sinkar for member present validaiotn (start)
				String isMemberPresnt  = checkNull(getSfaParmValue(salesPers,"HIDE_UNLIST_DET",connectionObject));
				// added by shraddha M for Realtime auto mode[31-08-19:start]
				String realParmData = checkNull(getSfaParmValue(salesPers, "ALLOW_STOCKIST_DAR", connectionObject));
				// added by shraddha M for Realtime auto mode[31-08-19:start]
				//added by mrunalini sinkar for member present validaiotn (end)

				int listCnt = 0;
				//added by hariom shukla on 29/01/2020 for maximum customer allow validation [Start]
				String totAllwCallList="";
				String maxStrgCustomr="";
				WSFACommon wsfaCommon=new WSFACommon();
				HashMap<String,String> totCustList=  new HashMap<String, String>();
				totCustList =wsfaCommon.getVisitData(salesPers, itemSer, connectionObject);
				for(Map.Entry<String, String> m:totCustList.entrySet())
				{
					maxStrgCustomr =(String)m.getKey();
				}
				if(maxStrgCustomr != null && maxStrgCustomr.trim().length() != 0)
				{
					totAllwCallList = maxStrgCustomr;
				}
				else
				{
					totAllwCallList = checkNull(getSfaParmValue(salesPers, "TOT_ALLOW_CALL_LIST", connectionObject));

				}
				//added by hariom shukla on 29/01/2020 for maximum customer allow validation [End]
				// Added by Harion S for fortune server -18-May-2021 [Start]
				String isFortuneActivity  = checkNull(getSfaParmValue(salesPers,"IS_FORTUNE_ACTIVITY",connectionObject));
				String allowChgTime="";
				String ACTIVITYSql="SELECT ALLOW_CHG_VISITTIME FROM FIELDACTIVITY WHERE ACTIVITY_CODE = ? ";
				pstmt =  connectionObject.prepareStatement(ACTIVITYSql);
				pstmt.setString(1, defACt);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					allowChgTime= checkNull(rs.getString("ALLOW_CHG_VISITTIME"));
				}

				if (rs!= null)
				{
					rs.close();
					rs = null;
				}

				if(pstmt !=null)
				{
					pstmt.close();
					pstmt = null;
				}
				// Added by Harion S for fortune server -18-May-2021 [End]
				
				if(!"".equalsIgnoreCase(totAllwCallList))
				{
					int totAllwCallListCnt = Integer.parseInt(totAllwCallList);
					String sqlCount = "SELECT "+
							"(SELECT COUNT(*) AS COUNT FROM STRG_SERIES SS, STRG_CUSTOMER SC WHERE SS.SC_CODE = SC.SC_CODE AND SALES_PERS = ? AND SC.CUST_TYPE IN ('C','W') AND SS.STATUS = 'Y') "+
							"+ "+
							"(SELECT COUNT(*) AS COUNT FROM STRG_CUST_ADD WHERE SALES_PERS = ? AND WF_STATUS NOT IN ('A','R') AND STRG_TYPE IN ('C','W')) AS COUNT FROM DUAL ";
					pstmt = connectionObject.prepareStatement(sqlCount);
					pstmt.setString(1, salesPers);
					pstmt.setString(2, salesPers);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						listCnt = rs.getInt("COUNT");
					}
					if (rs != null)
					{
						rs.close();
						rs = null;
					}
					if (pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
				}
				//String designCode=checkNull(getDesignName(salesPers, connectionObject));// Added By Mrunalini Sinkar for adding JNJ changes in Head version
				String formMandatory ="";
				if( mgrCode.trim().length()!= 0)
				{
					formMandatory = getSfaParmValue(salesPers,"MGR_FORM_MANDATORY",connectionObject);
				}
				else
				{
					formMandatory = getSfaParmValue(salesPers,"IS_FORM_MANDATORY",connectionObject);
				}
				String setVisitTime = getSfaParmValue(salesPers,"SET_VISIT_TIME",connectionObject);

				//Added by mrunalini sinkar for getting the pitch_details list from gencodes(Start)
				String fldValue="",udfSTR="";
				ArrayList<String> pitchDetailList=new ArrayList<String>();
				String pitchSQL ="SELECT FLD_VALUE,UDF_STR1 FROM GENCODES WHERE FLD_NAME='PITCH_DETAIL' AND MOD_NAME='W_WSFA_FORTUNE' AND ACTIVE='Y' AND UDF_STR1 IS NOT NULL";
				pstmt = connectionObject.prepareStatement(pitchSQL);
				rs = pstmt.executeQuery();
				while(rs.next())
				{
					fldValue = checkNull(rs.getString("FLD_VALUE"));
					udfSTR = checkNull(rs.getString("UDF_STR1"));
					pitchDetailList.add(fldValue+"@"+udfSTR);

				}
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				
				//Added by prachi on 25/04/2022 [ W22AGOC002 ]
				String qualDescr="",qualif="";
				ArrayList<String> qualifList=new ArrayList<String>();
				String qualSQL ="select qlf_code from qualification";
				pstmt = connectionObject.prepareStatement(qualSQL);
				rs = pstmt.executeQuery();
				while(rs.next())
				{
					qualif = checkNull(rs.getString("qlf_code"));
					qualifList.add(qualif);
					//qualifList.add(qualif+"@"+qualDescr);
				}
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				
				String meetActCode="";
				String meetCallOutcome="";
				ArrayList<String> meetingStatusData=new ArrayList<String>();
				String meetinStatusSql ="SELECT ACTIVITY_CODE,CALL_OUTCOME FROM CALL_OUTCOME";
				pstmt = connectionObject.prepareStatement(meetinStatusSql);
				rs = pstmt.executeQuery();
				while(rs.next())
				{
					meetActCode = checkNull(rs.getString("ACTIVITY_CODE"));
					meetCallOutcome = checkNull(rs.getString("CALL_OUTCOME"));
					meetingStatusData.add(meetCallOutcome+"@"+meetActCode);

				}
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				//Added by mrunalini sinkar for getting the pitch_details list from gencodes(End)
				//Added by mrunalini sinkar for getting the pitch_details list from gencodes(End)
				//Added by bhagyashri T for getting EUIN NO from ENTITY_contact[][13/04/22][START]
				String euinScCode="";
				String euinCntPers="";
				ArrayList<String> euinScCntPers=new ArrayList<String>();
				ArrayList<String> contactPerson=new ArrayList<String>(); //Added by bhagyashri T [21/06/2022] for Fortune contact pers
				//Changes made by Rahul P. on 27-Sep-2023 [Start] add where clause ENTITY_TYPE='R'
				//String euinNo ="SELECT ENTITY_CODE AS STRG_CODE ,CONTACT_PERS AS EUIN_NO FROM ENTITY_CONTACT";
				String euinNo ="SELECT ENTITY_CODE AS STRG_CODE ,CONTACT_PERS AS EUIN_NO FROM ENTITY_CONTACT WHERE ENTITY_TYPE='R'";
				//Changes made by Rahul P. on 27-Sep-2023 [End]
				pstmt = connectionObject.prepareStatement(euinNo);
				rs = pstmt.executeQuery();
				while(rs.next())
				{
					//System.out.println("Inside Getting Euin with Sc Code");
					euinScCode = checkNull(rs.getString("STRG_CODE"));
					euinCntPers = checkNull(rs.getString("EUIN_NO"));
					euinScCntPers.add(euinScCode+"@"+euinCntPers);
					contactPerson.add(euinCntPers);
				}
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				//System.out.println("EUIN NO For All SC Codes are:["+euinScCntPers+"]");
				String cntPerscode="";
				String cntPers ="select CONTACT_PERS as EUINno from strg_meet where STRG_CODE IN(SELECT STRG_CODE from strg_cust_add where CONFIRMED='N') AND CONTACT_PERS IS NOT NULL";
				pstmt = connectionObject.prepareStatement(cntPers);
				rs = pstmt.executeQuery();
				while(rs.next())
				{
					//System.out.println("Inside get contact pers from strg_cust_add");
					cntPerscode = checkNull(rs.getString("EUINno"));
					contactPerson.add(cntPerscode);
				}
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				//System.out.println("EUIN NO For All SC Codes are alreay present:["+contactPerson+"]");
				//Added by bhagyashri T for getting EUIN NO from ENTITY_contact[][13/04/22][END]
				//Added by bhagyashri T for getting EUIN NO for Unlisted customer[][13/04/22][START]
				ArrayList<String> unlstScCodeData=new ArrayList<String>();

				// Commented by Hariom for 181236 customer list generated due to this issue occurs. Need to write this data in pophelp sql 03-July-2023 [Start]
				String unlstScCode="";
				/*String unScCode ="SELECT SC_CODE AS STRG_CODE FROM STRG_CUSTOMER WHERE TRIM(STATUS)='U'";
				pstmt = connectionObject.prepareStatement(unScCode);
				rs = pstmt.executeQuery();
				while(rs.next())
				{
					unlstScCode = checkNull(rs.getString("STRG_CODE"));
					unlstScCodeData.add(unlstScCode);

				}
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}*/
				// Commented by Hariom for 181236 customer list generated due to this issue occurs. Need to write this data in pophelp sql 03-July-2023 [End]
				
				//added by prachi on 02-aug-22 [W22EBAS002]
				System.out.println("sales_pers 19999 is:"+salesPers);
				String pricelist ="";
				String pricelistSQL = "SELECT ST.PRICE_LIST FROM STATE ST LEFT OUTER JOIN SALES_PERS SP ON ST.STATE_CODE=SP.STATE_CODE WHERE SP.SALES_PERS=? ";				
				pstmt = connectionObject.prepareStatement(pricelistSQL);
	            pstmt.setString(1, salesPers);
	            rs = pstmt.executeQuery();
	            if(rs.next())
	            {
	            	pricelist=checkNull(rs.getString("PRICE_LIST"));
	            }
	            if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				
				System.out.println("unlstScCodeData Customer list is:["+unlstScCodeData+"]");
				//Added by bhagyashri T for getting EUIN NO for Unlisted customer[][13/04/22][END]
				//Added by Bhagyashri T for CGST AND SGST[START][W22EBAS004]
				String totCgst ="";
				String totCgstSql = "SELECT DDF_TOTAL_TAX_AMOUNT( ? )AS TOTCGST FROM DUAL";
				pstmt = connectionObject.prepareStatement( totCgstSql );
				pstmt.setString(1, "CGST");
				ResultSet rset = pstmt.executeQuery();
				if ( rset.next() )
				{
					totCgst = checkNull( rset.getString( "TOTCGST" ) );
				}
				if (rset !=null )
				{
					rset.close();
					rset = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				String totSgst="";
				String totSgstSql = "SELECT DDF_TOTAL_TAX_AMOUNT( ? )AS TOTSGST FROM DUAL";
				pstmt = connectionObject.prepareStatement( totSgstSql );
				pstmt.setString(1, "SGST");
				rset = pstmt.executeQuery();
				if ( rset.next() )
				{
					totSgst = checkNull( rset.getString( "TOTSGST" ) );
				}
				if (rset !=null )
				{
					rset.close();
					rset = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				//Added by Bhagyashri T for CGST AND SGST[END][W22EBAS004]
				// added by shweta for cust_type validation started 13-05-21
				String custTypeData="";
				String custTypeDescr="";
				String custStrgType="";
				ArrayList<String>  cutTypeDateList = new ArrayList<String>();
				ArrayList<String> cutTypeListData = new ArrayList<String>();
				String cutTypesql ="SELECT FLD_VALUE AS CUST_TYPE ,DESCR AS SH_DESCR,'' AS STRG_TYPE FROM GENCODES  WHERE (INSTR(FLD_VALUE,'-'))= 0 AND MOD_NAME='W_STRG_MEET_DCR_REALTIME_WIZ' AND ACTIVE='Y' "
						         + "UNION SELECT  G.FLD_VALUE AS CUST_TYPE,SCT.SH_DESCR AS SH_DESCR,SCT.TYPE AS STRG_TYPE FROM GENCODES G , STRG_CUST_TYPE SCT WHERE (INSTR(FLD_VALUE,'-')) > 0 "
						         + "AND SUBSTR(G.FLD_VALUE,INSTR(G.FLD_VALUE,'-')+1,LENGTH(G.FLD_VALUE))=SCT.SH_DESCR AND G.MOD_NAME='W_STRG_MEET_DCR_REALTIME_WIZ' and G.ACTIVE='Y' "
						         + "AND (ENTERPRISE IS NULL OR (SELECT ENTERPRISE FROM USERS WHERE CODE = ?) "
						         + "IN (SELECT REGEXP_SUBSTR(ENTERPRISE,'[^,]+', 1, LEVEL) FROM DUAL CONNECT BY REGEXP_SUBSTR(ENTERPRISE, '[^,]+', 1, LEVEL) IS NOT NULL ))"; 
				pstmt = connectionObject.prepareStatement(cutTypesql);
				pstmt.setString(1, salesPers);
				rs = pstmt.executeQuery();
				while(rs.next())
				{
					custTypeData = checkNull(rs.getString("CUST_TYPE"));
					custTypeDescr=checkNull(rs.getString("SH_DESCR"));
					custStrgType=checkNull(rs.getString("STRG_TYPE"));
					cutTypeListData.add(custTypeData);
					cutTypeDateList.add(custTypeData+"@"+custStrgType);
				
				}
				
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
                // added by shweta for cuts_type validation ended 13-05-21
				String planDayRoute  = checkNull(getSfaParmValue(salesPers,"PLAN_DAYS_REQ",connectionObject));

				JSONArray jsonArray = new JSONArray();
	            JSONArray custJsonArr = new JSONArray();
	            JSONArray visitedCustJsonArr = new JSONArray();

				if("Y".equalsIgnoreCase(planDayRoute))
				{
					 //Added by Pankaj R on 15-JUL-21 to store the data related to route, customer and visited customer for datamodel download[START]
	                String localityCode = "", localityDescr = "", stockistCode = "", stockistName = "", visitedWith = "", itemSer1= "",stationType = "", stationDescr = "",
							routeTye = "", routeId = "",invoiceNo="";
					String localityData = "SELECT TRIM(pe.ROUTE_ID) AS ROUTE_ID,pe.INVOICE_SR_NO AS INVOICE_NO,pe.LOCALITY_CODE AS LOCALITY_CODE, pe.DESCR  AS DESCR,pe.STOCKIST_CODE AS STOCKIST_CODE,\n"
							+ "pe.STOCKIST_NAME AS STOCKIST_NAME ,TRIM(pe.VISITED_WITH_TEAM) AS VISITED_WITH_TEAM,pe.ITEM_SER AS ITEM_SER  ,PE.STATION_TYPE AS STATION_TYPE ,\n"
							+ "PE.STATION_DESCR AS STATION_DESCR,PE.ROUTE_TYPE AS ROUTE_TYPE, PE.PLAN_DAYS  FROM TABLE(localityCodePophelp.getlocalityPophelpData(?)) pe \n"
							+ "order by DESCR";
					pstmt = connectionObject.prepareStatement(localityData);
					pstmt.setString(1, salesPers);
					rs = pstmt.executeQuery();
	                while(rs.next())
					{
						JSONObject jsonObject = new JSONObject();
						JSONObject jsonObject2 = new JSONObject();
						
						routeId = checkNull(rs.getString("ROUTE_ID"));
						invoiceNo = checkNull(rs.getString("INVOICE_NO"));
						visitedWith = checkNull(rs.getString("VISITED_WITH_TEAM"));

						jsonObject2.put("ROUTE_ID", routeId );
						jsonObject2.put("INVOICE_NO", invoiceNo );
						jsonObject2.put("LOCALITY_CODE", checkNull(rs.getString("LOCALITY_CODE")));
						jsonObject2.put("DESCR", checkNull(rs.getString("DESCR")));
						jsonObject2.put("STOCKIST_CODE", checkNull(rs.getString("STOCKIST_CODE")));
						jsonObject2.put("STOCKIST_NAME", checkNull(rs.getString("STOCKIST_NAME")));
						jsonObject2.put("VISITED_WITH_TEAM", visitedWith);
						jsonObject2.put("ITEM_SER", checkNull(rs.getString("ITEM_SER")));
						jsonObject2.put("STATION_TYPE", checkNull(rs.getString("STATION_TYPE")));
						jsonObject2.put("STATION_DESCR", checkNull(rs.getString("STATION_DESCR")));
	                    jsonObject2.put("ROUTE_TYPE", checkNull(rs.getString("ROUTE_TYPE")));
	                    jsonObject2.put("PLAN_DAYS", checkNull(rs.getString("PLAN_DAYS")));
						
						jsonObject.put(visitedWith+"_"+routeId , jsonObject2);
	                    jsonArray.put(jsonObject);
	                    
	                    JSONObject custJsonObj = new JSONObject();
						String customerSql = "SELECT TRIM(pe.strg_code) AS STRG_CODE FROM TABLE(strgCodePophelp.getstrgCodePophelpData(?)) pe where pe.route_id = ? ";
						
						pstmtCust = connectionObject.prepareStatement(customerSql);
						pstmtCust.setString(1, salesPers);
						pstmtCust.setString(2, routeId);
						
						custRs = pstmtCust.executeQuery();
						String custCode = "";
						while(custRs.next())
						{
	                        String strgCode = checkNull(custRs.getString("STRG_CODE"));
							custCode = custCode+","+strgCode;
	                    }
	                    if(custCode.length() > 0)
	                    {
	                        custCode = custCode.substring(1, custCode.length());
	                    }
						custJsonObj.put(routeId, custCode);
						custJsonArr.put(custJsonObj);
						if (custRs != null)
						{
							custRs.close();
							custRs = null;
						}
						if (pstmtCust != null)
						{
							pstmtCust.close();
							pstmtCust = null;
						}
						
					}
					if (rs != null)
					{
						rs.close();
						rs = null;
					}
					if (pstmt != null)
					{
						pstmt.close();
						pstmt = null;
	                }
				}
               
                
                String visitedCust = "select ROUTE_ID, STRG_CODE from strg_meet where  sales_pers = ? and event_date = ? ";
                pstmt = connectionObject.prepareStatement(visitedCust);
                pstmt.setString(1, salesPers);
                pstmt.setTimestamp( 2, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( currDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
				rs = pstmt.executeQuery();
                TreeMap<String, String> hMap = new TreeMap<String, String>();
				while(rs.next())
				{
                    String rouString = "",strgCode = "";
					try
					{
                        rouString = checkNull(rs.getString("ROUTE_ID"));
						strgCode = checkNull(rs.getString("STRG_CODE"));
						
                        if(hMap.containsKey(rouString))
                        {
                            String existVal = hMap.get(rouString);
                            hMap.put(rouString, existVal+","+strgCode);
                        }
                        else
                        {
                            hMap.put(rouString, strgCode);
                        }
						// visitedCustJsonObj.put(rouString, (String)visitedCustJsonObj.getString(rouString)+","+strgCode);
					}
					catch(Exception e) {
                        System.out.println("Exception in get Data ... "+e);
						// visitedCustJsonObj.put(rouString, strgCode);
					}
					
				}
                // visitedCustJsonArr.put(visitedCustJsonObj);
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}

                for (Map.Entry<String, String> entry : hMap.entrySet())
                {
                    JSONObject visitedCustJsonObj = new JSONObject();
                    visitedCustJsonObj.put(entry.getKey(), entry.getValue());
                    visitedCustJsonArr.put(visitedCustJsonObj);
                }

                System.out.println(jsonArray);
                
                ArrayList<String> beatChnageReasonDescr=new ArrayList<String>();
                String  beatchangeReasonUdf="";

                String betchgReasonFldValue="";
                String betchgReasondescr="";
                String betchgReasoUdf="";
                String genSQL ="SELECT FLD_VALUE,DESCR,UDF_STR1 FROM GENCODES WHERE  MOD_NAME='W_STRG_MEET_DCR_REALTIME_WIZ' AND FLD_NAME='BEAT_CHG_REASON'" ; 

				pstmt = connectionObject.prepareStatement(genSQL);
				rs = pstmt.executeQuery();
				while(rs.next())
				{
					betchgReasonFldValue = checkNull(rs.getString("FLD_VALUE"));
					betchgReasondescr = checkNull(rs.getString("DESCR"));
					betchgReasoUdf=checkNull(rs.getString("UDF_STR1"));
					beatChnageReasonDescr.add(betchgReasonFldValue+"@"+betchgReasondescr);
					if(beatchangeReasonUdf==null ||beatchangeReasonUdf.trim().length()==0)
					{
						beatchangeReasonUdf=betchgReasonFldValue+"@"+betchgReasoUdf;
					}
					else
					{
						beatchangeReasonUdf=beatchangeReasonUdf+"#"+betchgReasonFldValue+"@"+betchgReasoUdf;

					}

				}
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
		         // Added By Sanket D to get param_value 
				String sfaParmValue = checkNull(getSfaParmValue(salesPers, "PREF_STKIST_MANDATE", connectionObject));
				System.out.println("Sanket sfaparamValue--->>>"+sfaParmValue);
				
				
                //Added by Pankaj R on 15-JUL-21 to store the data related to route, customer and visited customer for datamodel download[END]
                
				valueXmlString.append("<Detail"+formNo+" domID='1' selected = 'N' formName='"+formName+"'>\r\n" );
				valueXmlString.append("<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");
				valueXmlString.append( "<event_type protect = '0'><![CDATA[" ).append(defACt).append( "]]></event_type>\r\n" );
				valueXmlString.append( "<activity_descr protect = '1'><![CDATA[" ).append(actDescr).append( "]]></activity_descr>\r\n" );
				valueXmlString.append( "<activity_type><![CDATA[" ).append(actType).append( "]]></activity_type>\r\n" );
				valueXmlString.append( "<place_required><![CDATA[" ).append(placReq).append( "]]></place_required>\r\n" ); 
				valueXmlString.append( "<activity_place><![CDATA[" ).append(actPlace).append( "]]></activity_place>\r\n" );//Added by Bhagyashri T for Activity place[W21DSUN098][26/JUL/21]
				valueXmlString.append( "<subform_protect><![CDATA[" ).append(formNum).append( "]]></subform_protect>\r\n" );
				//Added by Pooja on 14-AUGUST-2020 [Coaching related detail form implementation]
				valueXmlString.append("<coaching_design_code><![CDATA[" ).append( coachingDesignCode ).append( "]]></coaching_design_code>\r\n" );
				if(mgrCode.trim().length()!= 0)
				{
					valueXmlString.append( "<grade_type><![CDATA[" ).append("M").append( "]]></grade_type>\r\n" );
					valueXmlString.append( "<view_to><![CDATA[" ).append("MGR").append( "]]></view_to>\r\n" );
				}
				else
				{
					valueXmlString.append( "<grade_type><![CDATA[" ).append("").append( "]]></grade_type>\r\n" );
					valueXmlString.append( "<view_to><![CDATA[" ).append("PSR").append( "]]></view_to>\r\n" );
				}
				//valueXmlString.append( "<allwd_delay_prd><![CDATA[" ).append( allwdPrd ).append( "]]></allwd_delay_prd>\r\n" );
				valueXmlString.append( "<allwd_delay_prd><![CDATA[" ).append( totDelPrd ).append( "]]></allwd_delay_prd>\r\n" );
				valueXmlString.append( "<holiday_dates><![CDATA[" ).append( holiList ).append( "]]></holiday_dates>\r\n" );
				valueXmlString.append( "<pending_dcr><![CDATA[" ).append( pendDates ).append( "]]></pending_dcr>\r\n" );
				//valueXmlString.append( "<holi_length><![CDATA[" ).append( holPen ).append( "]]></holi_length>\r\n" );
				valueXmlString.append( "<locality_order><![CDATA[" ).append( localityDetail ).append( "]]></locality_order>\r\n" );
				valueXmlString.append(" <host_url><![CDATA[" ).append(CommonConstants.TOMCAT_HOME).append( "]]></host_url>\r\n" );
				valueXmlString.append( "<order_form_no><![CDATA[" ).append( sampleOrder ).append( "]]></order_form_no>\r\n" );
				valueXmlString.append( "<team_form_no><![CDATA[" ).append( doctorTeam ).append( "]]></team_form_no>\r\n" );
				valueXmlString.append( "<invoice_form_no><![CDATA[" ).append( invoiceFormNo ).append( "]]></invoice_form_no>\r\n" );
				valueXmlString.append( "<collection_form_no><![CDATA[" ).append( collectionFormNo ).append( "]]></collection_form_no>\r\n" );
				valueXmlString.append("<cust_type_list><![CDATA[").append(custTypeList).append("]]></cust_type_list>\r\n");
				valueXmlString.append("<is_bangla><![CDATA[").append(brndParmData).append("]]></is_bangla>\r\n");
				valueXmlString.append("<bradn_aval><![CDATA[").append(brandAval).append("]]></bradn_aval>\r\n");
				valueXmlString.append("<apply_stp_val><![CDATA[").append(applyStpVal).append("]]></apply_stp_val>\r\n");
				valueXmlString.append( "<price_list><![CDATA[" ).append(pricelist).append( "]]></price_list>\r\n" );
				valueXmlString.append( "<total_cgst><![CDATA[" ).append(totCgst).append( "]]></total_cgst>\r\n" ); //Added by Bhagyashri T for CGST AND SGST[W22EBAS004]
				valueXmlString.append( "<total_sgst><![CDATA[" ).append(totSgst).append( "]]></total_sgst>\r\n" );
				valueXmlString.append( "<net_amt><![CDATA[" ).append("0").append( "]]></net_amt>\r\n" );
				valueXmlString.append( "<tax_amount><![CDATA[" ).append("0").append( "]]></tax_amount>\r\n" );
				valueXmlString.append( "<amount><![CDATA[" ).append("0").append( "]]></amount>\r\n" );
				valueXmlString.append("<basic_value><![CDATA[" ).append( "Basic:0" ).append( "]]></basic_value>\r\n" );
				valueXmlString.append("<total_gst><![CDATA[" ).append( "GST:0" ).append( "]]></total_gst>\r\n" );
				valueXmlString.append("<total_value><![CDATA[" ).append( "Total Amount:0" ).append( "]]></total_value>\r\n" );
				//Added by Bhagyashri T for details showing on summary
				valueXmlString.append( "<load_no><![CDATA[" ).append(loadNo).append( "]]></load_no>\r\n" );
				valueXmlString.append( "<vehicle_no><![CDATA[" ).append(vehicleNo).append( "]]></vehicle_no>\r\n" );
				
				if (joinDate != null && joinDate.trim().length()>0 )
				{
					valueXmlString.append( "<emp_join_date><![CDATA[" ).append( checkNull(genericUtility.getValidDateString( joinDate, genericUtility.getDBDateFormat() , genericUtility.getApplDateFormat())) ).append( "]]></emp_join_date>\r\n" );
				}
				valueXmlString.append("<allow_dar_rep><![CDATA[").append(allowDarRep).append("]]></allow_dar_rep>\r\n");
				valueXmlString.append("<future_date_act><![CDATA[").append(futureDateActList).append("]]></future_date_act>\r\n");
				valueXmlString.append("<is_member_present><![CDATA[").append(isMemberPresnt).append("]]></is_member_present>\r\n");
				// added by shraddha M for Realtime auto mode[31-08-19:start]
				valueXmlString.append("<allow_stockist_dar><![CDATA[").append(realParmData).append("]]></allow_stockist_dar>\r\n");
				// added by shraddha M for Realtime auto mode[31-08-19:end]
				valueXmlString.append( "<stan_code__hq><![CDATA[" ).append(stanCodeHQ).append( "]]></stan_code__hq>\r\n" );//Added by mrunalini sinkar to showing headquarter in summary page
				valueXmlString.append( "<headquarter><![CDATA[" ).append(headQaurter).append( "]]></headquarter>\r\n" );//Added by mrunalini sinkar to showing headquarter in summary page
				valueXmlString.append("<tot_call_list><![CDATA[").append(listCnt).append("]]></tot_call_list>\r\n");
				valueXmlString.append("<tot_allow_call_list><![CDATA[").append(totAllwCallList).append("]]></tot_allow_call_list>\r\n");
				valueXmlString.append("<emp_design><![CDATA[").append(designCode).append("]]></emp_design>\r\n");// Added By Mrunalini Sinkar for adding JNJ changes in Head version
				//Added by Pooja on 18/12/19 [Coaching related detail form implementation] START
				valueXmlString.append( "<grade_code><![CDATA[" ).append( grade ).append( "]]></grade_code>\r\n" );
				//Added by Pooja on 18/12/19 [Coaching related detail form implementation] END
				valueXmlString.append( "<form_mandatory><![CDATA[" ).append( formMandatory ).append( "]]></form_mandatory>\r\n" );
				valueXmlString.append( "<set_visit_time><![CDATA[" ).append( setVisitTime ).append( "]]></set_visit_time>\r\n" );
				valueXmlString.append( "<list_design_code><![CDATA[" ).append( seqDesignCode ).append( "]]></list_design_code>\r\n" );
				//Added by Sadique S on 21/06/2020 [to validate on location validation required or not]
				valueXmlString.append( "<loc_req><![CDATA[" ).append(locReq).append( "]]></loc_req>\r\n" );
				valueXmlString.append( "<display_time_fld><![CDATA[" ).append( displaytimeField ).append( "]]></display_time_fld>\r\n" );//added by shraddha M for realtime visit time changes[17/07/2020]
				// Added by Harion S for fortune server -18-May-2021 [End]
				valueXmlString.append( "<allow_chg_visittime><![CDATA[" ).append( allowChgTime ).append( "]]></allow_chg_visittime>\r\n" );
				valueXmlString.append( "<is_fortune_activity><![CDATA[" ).append( isFortuneActivity ).append( "]]></is_fortune_activity>\r\n" );
				// Added by Harion S for fortune server -18-May-2021 [End]
				valueXmlString.append( "<pitch_detail_data><![CDATA[" ).append( pitchDetailList ).append( "]]></pitch_detail_data>\r\n" );
				
				//added by prachi on 25-May-2022 [ W22AGOC002 ]
				valueXmlString.append( "<qualification_list><![CDATA[" ).append( qualifList ).append( "]]></qualification_list>\r\n" );
				valueXmlString.append( "<strg_code_list><![CDATA[" ).append( strgCodeList ).append( "]]></strg_code_list>\r\n" );
				
				valueXmlString.append( "<meeting_status_data><![CDATA[" ).append( meetingStatusData ).append( "]]></meeting_status_data>\r\n" );
				valueXmlString.append( "<cnt_pers_data><![CDATA[" ).append( euinScCntPers ).append( "]]></cnt_pers_data>\r\n" ); //added by bhagayshri T For Entity_contact data[13-04-22]
				valueXmlString.append( "<cnt_pers_code><![CDATA[" ).append( contactPerson ).append( "]]></cnt_pers_code>\r\n" ); //added by bhagayshri T For contact_person data[21-06-22]
				valueXmlString.append( "<unlst_sccode_data><![CDATA[" ).append( unlstScCodeData ).append( "]]></unlst_sccode_data>\r\n" );//added by bhagayshri T For unlisted sc code[13-04-22]
				valueXmlString.append( "<cust_type_data><![CDATA[" ).append(cutTypeListData).append( "]]></cust_type_data>" ); // added by shweta M for cutType validation change [13-05-21]
                valueXmlString.append( "<cust_type_detail><![CDATA[" ).append(cutTypeDateList).append( "]]></cust_type_detail>" ); // added by shweta M for cutType validation change [13-05-21]
                
                //Added by Pankaj R on 15-JUL-21 to store the data related to route, customer and visited customer for datamodel download[START]
                valueXmlString.append( "<route_data><![CDATA[" ).append( jsonArray.toString() ).append( "]]></route_data>\r\n" );
                valueXmlString.append( "<customer_data><![CDATA[" ).append( custJsonArr.toString() ).append( "]]></customer_data>\r\n" );
                valueXmlString.append( "<visited_customer><![CDATA[" ).append( visitedCustJsonArr.toString() ).append( "]]></visited_customer>\r\n" );
                valueXmlString.append( "<beat_change_descr><![CDATA[" ).append(beatChnageReasonDescr).append( "]]></beat_change_descr>\r\n" );
                valueXmlString.append( "<beat_change_udf><![CDATA[" ).append(beatchangeReasonUdf).append( "]]></beat_change_udf>\r\n" );
               //Added by Sanket D 
                valueXmlString.append( "<pref_stkist_mandate><![CDATA[" ).append(sfaParmValue).append( "]]></pref_stkist_mandate>\r\n" );

                //Added by Pankaj R on 15-JUL-21 to store the data related to route, customer and visited customer for datamodel download[START]

				valueXmlString.append("</Detail"+formNo+">\r\n" );

			}
			// added by mrunalini sinkar for default activity for CHC client on 07-02-2019[end]
			else if("sampleorder".equalsIgnoreCase(formName) || "retailersampleorder".equalsIgnoreCase(formName) || "stockistsampleorder".equalsIgnoreCase(formName) || "ncwsampleorder".equalsIgnoreCase(formName))
			{
				Double mQty = 1d;
				String orderParam = checkNull(getSfaParmValue(salesPers, "ORDER_QTY", connectionObject));
				String isStockInfo = getSfaParmValue(salesPers,"IS_STOCK_INFO",connectionObject);
				String itemSer = getProdItmSer(salesPers, connectionObject);
				String mrpPriceList = checkNull(getSfaParmValue(salesPers, "MRP_PRICELIST", connectionObject)); //Added By Haseeb Khan on [19-10-2021]


				// commentted and added by rupali on 01/02/19 for getting only active items [start]
				/*sql="SELECT DISTINCT ITEM.ITEM_CODE AS ITEM_CODE ,ITEM.DESCR AS DESCR, ITEM.SH_DESCR AS SH_DESCR, ITEM.UNIT AS ITEM_UNIT,S.PRICE_LIST AS PRICE_LIST, "+
						"P.PRODUCT_CODE AS PRODUCT_CODE, P.DESCR AS PRODUCT_DESCR, P.PRODUCT_TYPE, V.SORT_ORDER  FROM  SALES_PERS SC,STATE S ,ITEM ITEM LEFT OUTER JOIN PRICELIST  PM ON ITEM.ITEM_CODE = PM.ITEM_CODE " +
						"LEFT OUTER JOIN PRODUCT P ON ITEM.PRODUCT_CODE = P.PRODUCT_CODE LEFT OUTER JOIN ITM_ATTRIB_VAL V ON ITEM.PHY_ATTRIB_1=V.ATTRIB_ID "+
						"WHERE SC.STATE_CODE = S.STATE_CODE AND S.PRICE_LIST = PM.PRICE_LIST AND SC.SALES_PERS = ? "+
						"AND RTRIM((CASE WHEN ITEM.ITEM_USAGE IS NULL THEN 'O' ELSE ITEM.ITEM_USAGE END )) NOT IN('S','G') ORDER BY V.SORT_ORDER ";*/

				ArrayList<String> remarkList=new ArrayList<String>();
				String ordRemSql="SELECT FLD_VALUE,DESCR AS REMARK_DESCR FROM GENCODES WHERE MOD_NAME='W_STRG_MEET_DCR_REALTIME_WIZ' AND FLD_NAME='ORDER_REMARK' ORDER BY TO_NUMBER(FLD_VALUE)";
				PreparedStatement ordPstmt=connectionObject.prepareStatement(ordRemSql);
				ResultSet ordRS=ordPstmt.executeQuery();
				while(ordRS.next())
				{
					String remark = checkNull(ordRS.getString("FLD_VALUE"));
					String remarkDescr = checkNull(ordRS.getString("REMARK_DESCR"));
					remarkList.add(remark+"@"+remarkDescr);

				}
				if(ordRS != null)
				{
					ordRS.close();
					ordRS = null;
				}
				if(ordPstmt != null)
				{
					ordPstmt.close();
					ordPstmt = null;
				}
				String itemSizeCol = getSfaParmValue(salesPers,"ITEM_ATTRIB_SIZE",connectionObject);
				if(itemSizeCol.trim().length() == 0)
				{
					itemSizeCol = "PHY_ATTRIB_1";
				}
				String itemUSage="";
				String parmItemUsage = getSfaParmValue(salesPers,"SAMPLE_ITEM_USAGE",connectionObject);
				if(parmItemUsage!=null && parmItemUsage.trim().length()>0)
				{
					itemUSage=checkNull(getFormattedStringBuff( parmItemUsage ));
				}
				else
				{
					itemUSage="'G','S'";
				}
				String prcListTemplate="";
				String siteCode="";
				
				String siteCodeSql = "select emp_site from employee where emp_code = ?";
				custPrcList=connectionObject.prepareStatement(siteCodeSql);
				custPrcList.setString(1, salesPers);
				rsCustPrc =custPrcList.executeQuery();
				while(rsCustPrc.next())
				{
					siteCode= checkNull(rsCustPrc.getString("emp_site"));					
				}
				if(rsCustPrc != null)
				{
					rsCustPrc.close(); rsCustPrc = null;
				}
				if(custPrcList != null)
				{
					custPrcList.close(); custPrcList = null;
				}


				String siteSql = "select price_list from site_customer where site_code in (select emp_site from employee where emp_code = ?) and price_list is not null";
				custPrcList=connectionObject.prepareStatement(siteSql);
				custPrcList.setString(1, salesPers);
				rsCustPrc =custPrcList.executeQuery();
				while(rsCustPrc.next())
				{
					String teamplate= checkNull(rsCustPrc.getString("PRICE_LIST"));
					if(prcListTemplate==null || prcListTemplate.trim().length() == 0)
					{
						prcListTemplate = "'"+teamplate+"'";
					}
					else
					{
						prcListTemplate=prcListTemplate+","+"'"+teamplate+"'";
					}
				}
				if(rsCustPrc != null)
				{
					rsCustPrc.close(); rsCustPrc = null;
				}
				if(custPrcList != null)
				{
					custPrcList.close(); custPrcList = null;
				}

				//String custmerSql = "select price_list  from customer 	where cust_code =?";
				String custmerSql = "select price_list from customer where " +
						"cust_code in (SELECT SC.SC_CODE FROM STRG_CUSTOMER SC,STRG_SERIES SS " + 
						"WHERE SS.SALES_PERS IN (SELECT EMP_CODE  FROM EMPLOYEE START WITH EMP_CODE = ? CONNECT BY PRIOR EMP_CODE = REPORT_TO ) " + 
						"AND SS.STATUS='Y' AND SS.SC_CODE=SC.SC_CODE )";
				custPrcList=connectionObject.prepareStatement(custmerSql);
				custPrcList.setString(1, salesPers);
				rsCustPrc =custPrcList.executeQuery();
				while(rsCustPrc.next())
				{
					String teamplate= checkNull(rsCustPrc.getString("PRICE_LIST"));
					if(prcListTemplate==null || prcListTemplate.trim().length() == 0)
					{
						prcListTemplate = "'"+teamplate+"'";
					}
					else
					{
						prcListTemplate=prcListTemplate+","+"'"+teamplate+"'";
					}
				}
				if(rsCustPrc != null)
				{
					rsCustPrc.close(); rsCustPrc = null;
				}
				if(custPrcList != null)
				{
					custPrcList.close(); custPrcList = null;
				}


				String custPriceList="SELECT DISTINCT(SC.PRICE_LIST) AS PRICE_LIST FROM STRG_CUSTOMER SC,STRG_SERIES SS " + 
						" WHERE SS.SALES_PERS IN (SELECT EMP_CODE  FROM EMPLOYEE START WITH EMP_CODE = ? CONNECT BY PRIOR EMP_CODE = REPORT_TO ) "+
						" AND SS.STATUS='Y' AND SS.SC_CODE=SC.SC_CODE AND SC.PRICE_LIST IS NOT NULL";
				custPrcList=connectionObject.prepareStatement(custPriceList);
				custPrcList.setString(1, salesPers);
				rsCustPrc =custPrcList.executeQuery();
				while(rsCustPrc.next())
				{
					String teamplate= checkNull(rsCustPrc.getString("PRICE_LIST"));
					if(prcListTemplate==null || prcListTemplate.trim().length() == 0)
					{
						prcListTemplate = "'"+teamplate+"'";
					}
					else
					{
						prcListTemplate=prcListTemplate+","+"'"+teamplate+"'";
					}
				}
				if(rsCustPrc != null)
				{
					rsCustPrc.close(); rsCustPrc = null;
				}
				if(custPrcList != null)
				{
					custPrcList.close(); custPrcList = null;
				}
				System.out.println("Customer Price list Tempalate is::["+prcListTemplate+"]");
				String spPriceList="SELECT DISTINCT(ST.PRICE_LIST) AS PRICE_LIST FROM STATE ST LEFT OUTER JOIN SALES_PERS SP ON SP.STATE_CODE=ST.STATE_CODE " + 
						" WHERE  SP.SALES_PERS IN (SELECT EMP_CODE  FROM EMPLOYEE START WITH EMP_CODE = ? CONNECT BY PRIOR EMP_CODE = REPORT_TO)";
				custPrcList=connectionObject.prepareStatement(spPriceList);
				custPrcList.setString(1, salesPers);
				rsCustPrc =custPrcList.executeQuery();
				if(rsCustPrc.next())
				{
					String teamplate= checkNull(rsCustPrc.getString("PRICE_LIST"));
					if(prcListTemplate==null || prcListTemplate.trim().length() == 0)
					{
						prcListTemplate = "'"+teamplate+"'";
					}
					else
					{
						prcListTemplate=prcListTemplate+","+"'"+teamplate+"'";
					}
				}
				if(rsCustPrc != null)
				{
					rsCustPrc.close(); rsCustPrc = null;
				}
				if(custPrcList != null)
				{
					custPrcList.close(); custPrcList = null;
				}
				System.out.println("After Sales Person Price list Tempalate is::["+prcListTemplate+"]"); 


				int sprsCnt=0;
				int itemSerCnt=0;
				/*String sprsCntSql="SELECT COUNT(*) AS COUNT " +
						" FROM SALES_PERS SP, STATE S ,ITEM ITEM LEFT OUTER JOIN PRICELIST  PM ON ITEM.ITEM_CODE = PM.ITEM_CODE " +
						" LEFT OUTER JOIN PRODUCT P ON ITEM.PRODUCT_CODE = P.PRODUCT_CODE " +
						//" LEFT OUTER JOIN ITM_ATTRIB_VAL V ON ITEM.PHY_ATTRIB_1=V.ATTRIB_ID,SPRS_ITEM SI " + // changes made by rupali on 03/05/19 for mapping og physical attribute
						" LEFT OUTER JOIN ITM_ATTRIB_VAL V ON ITEM."+itemSizeCol+"=V.ATTRIB_ID,SPRS_ITEM SI " +
						" WHERE SP.STATE_CODE = S.STATE_CODE AND S.PRICE_LIST = PM.PRICE_LIST AND SI.ITEM_CODE= ITEM.ITEM_CODE AND SP.SALES_PERS=SI.SALES_PERS " +
						" AND SP.SALES_PERS = ?  AND ITEM.ACTIVE = 'Y'  AND SI.STATUS='Y' " +
						" AND RTRIM((CASE WHEN ITEM.ITEM_USAGE IS NULL THEN 'O' ELSE ITEM.ITEM_USAGE END )) NOT IN("+itemUSage+") " +
						" ORDER BY P.SORT_ORDER,V.SORT_ORDER";*/
				String sprsCntSql="SELECT COUNT(*) AS COUNT " +
						" FROM SALES_PERS SP, STATE S ,ITEM ITEM LEFT OUTER JOIN PRICELIST  PM ON ITEM.ITEM_CODE = PM.ITEM_CODE " +
						" LEFT OUTER JOIN PRODUCT P ON ITEM.PRODUCT_CODE = P.PRODUCT_CODE " +
						//" LEFT OUTER JOIN ITM_ATTRIB_VAL V ON ITEM.PHY_ATTRIB_1=V.ATTRIB_ID,SPRS_ITEM SI " + // changes made by rupali on 03/05/19 for mapping og physical attribute
						" LEFT OUTER JOIN ITM_ATTRIB_VAL V ON ITEM."+itemSizeCol+"=V.ATTRIB_ID,SPRS_ITEM SI " +
						" WHERE PM.PRICE_LIST IN ("+prcListTemplate+") AND SI.ITEM_CODE= ITEM.ITEM_CODE AND SP.SALES_PERS=SI.SALES_PERS " +
						" AND SP.SALES_PERS = ?  AND ITEM.ACTIVE = 'Y'  AND SI.STATUS='Y' " +
						" AND RTRIM((CASE WHEN ITEM.ITEM_USAGE IS NULL THEN 'O' ELSE ITEM.ITEM_USAGE END )) NOT IN("+itemUSage+") " +
						" ORDER BY P.SORT_ORDER,V.SORT_ORDER";

				PreparedStatement pstmtCnt = connectionObject.prepareStatement(sprsCntSql);
				pstmtCnt.setString(1, salesPers);
				rs = pstmtCnt.executeQuery();
				if(rs.next())
				{
					sprsCnt = rs.getInt("COUNT");
				}
				if(rs != null)
				{
					rs.close(); rs = null;
				}
				if(pstmtCnt != null)
				{
					pstmtCnt.close(); pstmtCnt = null;
				}
				
				String itemSerCntSql = " SELECT COUNT(*) AS CNT FROM STATE S ,ITEM ITEM LEFT OUTER JOIN PRICELIST  PM ON ITEM.ITEM_CODE = PM.ITEM_CODE "+
						" LEFT OUTER JOIN PRODUCT P ON ITEM.PRODUCT_CODE = P.PRODUCT_CODE "+
						" LEFT OUTER JOIN ITM_ATTRIB_VAL V ON ITEM."+itemSizeCol+"=V.ATTRIB_ID " +
						" WHERE PM.PRICE_LIST IN ("+prcListTemplate+") "+
						" AND ITEM.ITEM_SER IN("+itemSer+") AND ITEM.ACTIVE = 'Y' "+
						" AND RTRIM((CASE WHEN ITEM.ITEM_USAGE IS NULL THEN 'O' ELSE ITEM.ITEM_USAGE END )) NOT IN("+itemUSage+") "+
						" ORDER BY P.SORT_ORDER,V.SORT_ORDER ";
				PreparedStatement pstmtCnt1 = connectionObject.prepareStatement(itemSerCntSql);
				rs = pstmtCnt1.executeQuery();
				if(rs.next())
				{
					itemSerCnt = rs.getInt("CNT");
				}
				if(rs != null)
				{
					rs.close(); rs = null;
				}
				if(pstmtCnt1 != null)
				{
					pstmtCnt1.close(); pstmtCnt1 = null;
				}
				
				
				ArrayList itemCodeList=new ArrayList();
				ArrayList discountRateList=new ArrayList();
				ArrayList discountList=new ArrayList();

				if(sprsCnt > 0)
				{
					/*sql = " SELECT DISTINCT ITEM.ITEM_CODE AS ITEM_CODE ,ITEM.DESCR AS DESCR, ITEM.SH_DESCR AS SH_DESCR, ITEM.UNIT AS ITEM_UNIT,S.PRICE_LIST AS PRICE_LIST " +
							" ,P.PRODUCT_CODE AS PRODUCT_CODE, P.DESCR AS PRODUCT_DESCR, P.PRODUCT_TYPE, P.SORT_ORDER, V.SORT_ORDER  "+
							" FROM SALES_PERS SP, STATE S ,ITEM ITEM LEFT OUTER JOIN PRICELIST  PM ON ITEM.ITEM_CODE = PM.ITEM_CODE "+
							" LEFT OUTER JOIN PRODUCT P ON ITEM.PRODUCT_CODE = P.PRODUCT_CODE "+
							//" LEFT OUTER JOIN ITM_ATTRIB_VAL V ON ITEM.PHY_ATTRIB_1=V.ATTRIB_ID,SPRS_ITEM SI " + // changes made by rupali on 03/05/19 for mapping og physical attribute
							" LEFT OUTER JOIN ITM_ATTRIB_VAL V ON ITEM."+itemSizeCol+"=V.ATTRIB_ID,SPRS_ITEM SI " +
							" WHERE SP.STATE_CODE = S.STATE_CODE AND S.PRICE_LIST = PM.PRICE_LIST AND SI.ITEM_CODE= ITEM.ITEM_CODE AND SP.SALES_PERS=SI.SALES_PERS "+
							" AND SP.SALES_PERS = ? AND ITEM.ACTIVE = 'Y' AND SI.STATUS='Y' "+
							" AND RTRIM((CASE WHEN ITEM.ITEM_USAGE IS NULL THEN 'O' ELSE ITEM.ITEM_USAGE END )) NOT IN("+itemUSage+") "+
							" ORDER BY P.SORT_ORDER,V.SORT_ORDER ";*/
					sql = " SELECT DISTINCT ITEM.ITEM_CODE AS ITEM_CODE ,ITEM.DESCR AS DESCR, ITEM.SH_DESCR AS SH_DESCR, ITEM.UNIT AS ITEM_UNIT,PM.PRICE_LIST AS PRICE_LIST " +
							" ,P.PRODUCT_CODE AS PRODUCT_CODE, P.DESCR AS PRODUCT_DESCR, P.PRODUCT_TYPE, P.SORT_ORDER, V.SORT_ORDER "+
							", (CASE WHEN item.SALE_RATE IS NULL THEN 0 ELSE item.SALE_RATE END) AS SALE_RATE "+//Added by Hariom S for sale rate from item master -- 13-Sep-2023
							" FROM SALES_PERS SP, STATE S ,ITEM ITEM LEFT OUTER JOIN PRICELIST  PM ON ITEM.ITEM_CODE = PM.ITEM_CODE "+
							" LEFT OUTER JOIN PRODUCT P ON ITEM.PRODUCT_CODE = P.PRODUCT_CODE "+
							//" LEFT OUTER JOIN ITM_ATTRIB_VAL V ON ITEM.PHY_ATTRIB_1=V.ATTRIB_ID,SPRS_ITEM SI " + // changes made by rupali on 03/05/19 for mapping og physical attribute
							" LEFT OUTER JOIN ITM_ATTRIB_VAL V ON ITEM."+itemSizeCol+"=V.ATTRIB_ID,SPRS_ITEM SI " +
							" WHERE PM.PRICE_LIST IN ("+prcListTemplate+") AND SI.ITEM_CODE= ITEM.ITEM_CODE AND SP.SALES_PERS=SI.SALES_PERS "+
							" AND SP.SALES_PERS = ? AND ITEM.ACTIVE = 'Y' AND SI.STATUS='Y' "+
							" AND RTRIM((CASE WHEN ITEM.ITEM_USAGE IS NULL THEN 'O' ELSE ITEM.ITEM_USAGE END )) NOT IN("+itemUSage+") "+
							" ORDER BY P.SORT_ORDER,V.SORT_ORDER ";


				}
				// added by mrunalini sinkar for adding sprs_item condition to geeting item on  25-April-2019(end)
				else
				{
					if(itemSerCnt > 0)
					{
						/*sql = " SELECT DISTINCT ITEM.ITEM_CODE AS ITEM_CODE ,ITEM.DESCR AS DESCR, ITEM.SH_DESCR AS SH_DESCR, ITEM.UNIT AS ITEM_UNIT,S.PRICE_LIST AS PRICE_LIST " +
							" ,P.PRODUCT_CODE AS PRODUCT_CODE, P.DESCR AS PRODUCT_DESCR, P.PRODUCT_TYPE, P.SORT_ORDER, V.SORT_ORDER  "+
							" FROM SALES_PERS SP, STATE S ,ITEM ITEM LEFT OUTER JOIN PRICELIST  PM ON ITEM.ITEM_CODE = PM.ITEM_CODE "+
							" LEFT OUTER JOIN PRODUCT P ON ITEM.PRODUCT_CODE = P.PRODUCT_CODE "+
							//" LEFT OUTER JOIN ITM_ATTRIB_VAL V ON ITEM.PHY_ATTRIB_1=V.ATTRIB_ID " + // changes made by rupali on 03/05/19 for mapping og physical attribute
							" LEFT OUTER JOIN ITM_ATTRIB_VAL V ON ITEM."+itemSizeCol+"=V.ATTRIB_ID " +
							" WHERE SP.STATE_CODE = S.STATE_CODE AND S.PRICE_LIST = PM.PRICE_LIST "+
							" AND SP.SALES_PERS = ? AND SP.ITEM_SER = ITEM.ITEM_SER AND ITEM.ACTIVE = 'Y' "+
							" AND RTRIM((CASE WHEN ITEM.ITEM_USAGE IS NULL THEN 'O' ELSE ITEM.ITEM_USAGE END )) NOT IN("+itemUSage+") "+
							" ORDER BY P.SORT_ORDER,V.SORT_ORDER ";*/
						/*sql = " SELECT DISTINCT ITEM.ITEM_CODE AS ITEM_CODE ,ITEM.DESCR AS DESCR, ITEM.SH_DESCR AS SH_DESCR, ITEM.UNIT AS ITEM_UNIT,PM.PRICE_LIST AS PRICE_LIST " +
							" ,P.PRODUCT_CODE AS PRODUCT_CODE, P.DESCR AS PRODUCT_DESCR, P.PRODUCT_TYPE, P.SORT_ORDER, V.SORT_ORDER  "+
							" FROM SALES_PERS SP, STATE S ,ITEM ITEM LEFT OUTER JOIN PRICELIST  PM ON ITEM.ITEM_CODE = PM.ITEM_CODE "+
							" LEFT OUTER JOIN PRODUCT P ON ITEM.PRODUCT_CODE = P.PRODUCT_CODE "+
							//" LEFT OUTER JOIN ITM_ATTRIB_VAL V ON ITEM.PHY_ATTRIB_1=V.ATTRIB_ID " + // changes made by rupali on 03/05/19 for mapping og physical attribute
							" LEFT OUTER JOIN ITM_ATTRIB_VAL V ON ITEM."+itemSizeCol+"=V.ATTRIB_ID " +
							" WHERE PM.PRICE_LIST IN ("+prcListTemplate+") "+
							" AND SP.SALES_PERS = ? AND SP.ITEM_SER = ITEM.ITEM_SER AND ITEM.ACTIVE = 'Y' "+
							" AND RTRIM((CASE WHEN ITEM.ITEM_USAGE IS NULL THEN 'O' ELSE ITEM.ITEM_USAGE END )) NOT IN("+itemUSage+") "+
							" ORDER BY P.SORT_ORDER,V.SORT_ORDER ";*/
						sql = " SELECT DISTINCT ITEM.ITEM_CODE AS ITEM_CODE ,ITEM.DESCR AS DESCR, ITEM.SH_DESCR AS SH_DESCR, ITEM.UNIT AS ITEM_UNIT,PM.PRICE_LIST AS PRICE_LIST " +
								" ,P.PRODUCT_CODE AS PRODUCT_CODE, P.DESCR AS PRODUCT_DESCR, P.PRODUCT_TYPE, P.SORT_ORDER, V.SORT_ORDER "+
								", (CASE WHEN item.SALE_RATE IS NULL THEN 0 ELSE item.SALE_RATE END) AS SALE_RATE "+//Added by Hariom S for sale rate from item master -- 13-Sep-2023
								" FROM STATE S ,ITEM ITEM LEFT OUTER JOIN PRICELIST  PM ON ITEM.ITEM_CODE = PM.ITEM_CODE "+
								" LEFT OUTER JOIN PRODUCT P ON ITEM.PRODUCT_CODE = P.PRODUCT_CODE "+
								//" LEFT OUTER JOIN ITM_ATTRIB_VAL V ON ITEM.PHY_ATTRIB_1=V.ATTRIB_ID " + // changes made by rupali on 03/05/19 for mapping og physical attribute
								" LEFT OUTER JOIN ITM_ATTRIB_VAL V ON ITEM."+itemSizeCol+"=V.ATTRIB_ID " +
								" WHERE PM.PRICE_LIST IN ("+prcListTemplate+") "+
								" AND ITEM.ITEM_SER IN("+itemSer+") AND ITEM.ACTIVE = 'Y' "+
								" AND RTRIM((CASE WHEN ITEM.ITEM_USAGE IS NULL THEN 'O' ELSE ITEM.ITEM_USAGE END )) NOT IN("+itemUSage+") "+
								" ORDER BY P.SORT_ORDER,V.SORT_ORDER ";
					}
					else
					{
						sql = " SELECT DISTINCT ITEM.ITEM_CODE AS ITEM_CODE ,ITEM.DESCR AS DESCR, ITEM.SH_DESCR AS SH_DESCR, ITEM.UNIT AS ITEM_UNIT,'' AS PRICE_LIST " +
								" ,P.PRODUCT_CODE AS PRODUCT_CODE, P.DESCR AS PRODUCT_DESCR, P.PRODUCT_TYPE, P.SORT_ORDER, V.SORT_ORDER "+
								", (CASE WHEN item.SALE_RATE IS NULL THEN 0 ELSE item.SALE_RATE END) AS SALE_RATE "+//Added by Hariom S for sale rate from item master -- 13-Sep-2023
								" FROM STATE S ,ITEM ITEM LEFT OUTER JOIN PRICELIST  PM ON ITEM.ITEM_CODE = PM.ITEM_CODE "+
								" LEFT OUTER JOIN PRODUCT P ON ITEM.PRODUCT_CODE = P.PRODUCT_CODE "+
								" LEFT OUTER JOIN ITM_ATTRIB_VAL V ON ITEM."+itemSizeCol+"=V.ATTRIB_ID " +
								" WHERE ITEM.ITEM_SER IN("+itemSer+") AND ITEM.ACTIVE = 'Y' "+
								" AND RTRIM((CASE WHEN ITEM.ITEM_USAGE IS NULL THEN 'O' ELSE ITEM.ITEM_USAGE END )) NOT IN("+itemUSage+") "+
								" ORDER BY P.SORT_ORDER,V.SORT_ORDER ";
					}
				}


				// commentted and added by rupali on 01/02/19 for getting only active items [end]

				HashMap itemAttribMap = getItemOfflineAttributeDetails(connectionObject, sql,salesPers, sprsCnt,prcListTemplate);
				pstmt =  connectionObject.prepareStatement(sql);
				if(sprsCnt > 0)
				{
					pstmt.setString(1, salesPers);
				}
				rs = pstmt.executeQuery();
				int num=1;
				while(rs.next())
				{
					String stockInfoData = "";
					String tranID = "";
					String orderQty = "",stockQty="";

					String itemCode = checkNull(rs.getString("ITEM_CODE"));
					String itemDescr = checkNull(rs.getString("DESCR"));
					String itemShDescr = checkNull(rs.getString("SH_DESCR"));
					String priceList = checkNull(rs.getString("PRICE_LIST"));
					String productCode =  checkNull(rs.getString("PRODUCT_CODE"));
					String unit = checkNull(rs.getString("ITEM_UNIT"));
					double saleRate = rs.getDouble("SALE_RATE");
					ArrayList<String> tooltip = new ArrayList<String>();
					
					
					String priceListTypeFlag="";
					String listTypeSql="SELECT LIST_TYPE,ALLOW_CHG_SFA_ORD FROM PRICELIST_MST WHERE PRICE_LIST = ? ";
					pstmt1=	connectionObject.prepareStatement(listTypeSql);
					pstmt1.setString(1, priceList);   					 	
					rs1=pstmt1.executeQuery();
					if(rs1.next())
					{
						priceListTypeFlag=checkNull(rs1.getString("ALLOW_CHG_SFA_ORD"));
					}
					if(rs1 != null)
					{
						rs1.close();
						rs1 = null;
					}
					if(pstmt1 != null)
					{
						pstmt1.close(); 
						pstmt1 = null;
					}					

					String custCodeSql="SELECT DISTINCT(SM.STRG_CODE) AS ORDER_CUST_CODE FROM STRG_MEET SM ,STRG_MEET_ORDER SMO WHERE SALES_PERS=? " + 
							" AND SM.EVENT_DATE < ? " + 
							" AND SM.DCR_ID=SMO.DCR_ID AND SM.STRG_CODE=SMO.STRG_CODE AND ITEM_CODE=? AND sm.confirmed='Y' ";
					PreparedStatement custpstmt = connectionObject.prepareStatement(custCodeSql);
					custpstmt.setString(1,salesPers);
					custpstmt.setTimestamp(2, java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString( currDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat())));	
					custpstmt.setString(3,itemCode);
					ResultSet custoRs = custpstmt.executeQuery();
					while( custoRs.next() )
					{
						String custCode=checkNull(custoRs.getString("ORDER_CUST_CODE"));
						String maxTwoOrder=checkNull(darCommonBean.getPreviousTwoOrderDetails(itemCode,currDate,custCode,salesPers,connectionObject));
						tooltip.add(custCode+"@"+maxTwoOrder);
					}
					if( custoRs !=null )
					{
						custoRs.close();
						custoRs = null;
					}
					if( custpstmt !=null )
					{
						custpstmt.close();
						custpstmt = null;
					}
					
					//rate = darCommonBean.getLandingRate( "", itemCode, currDate, salesPers,priceList, connectionObject);

					//mrprate = darCommonBean.getLandingRate("", itemCode, currDate, salesPers, mrpPriceList, connectionObject); //Added By Haseeb Khan on [19-10-2021]					
					double custRate = 0d;
					double plistDisc = 0d;
					double discountRate = 0d;
					custRate = distCommon.pickRate(priceList, currDate, itemCode, "", "L", mQty,unit, connectionObject);
					//	System.out.println("custRate == ::"+custRate);
					String discountPricelist = getDiscountPricelist( "", itemCode, currDate, salesPers, connectionObject);					


					String priceListType="";
					String locCode="";
					String lotNo="";
					
						/*if(discountPricelist==null || discountPricelist.trim().length()==0)
						{
							priceListType= getPriceListType(priceList, connectionObject);
							if(!"L".equals(priceListType))
							{
								int cnt = 0;
								String ssql="   select count(*) from pricelist where  price_list = ? and list_type = 'I'";
								pstmt1=	connectionObject.prepareStatement(ssql);
								pstmt1.setString(1, priceList);   					 	
								rs1=pstmt1.executeQuery();
								if(rs1.next())
								{
									cnt =rs1.getInt(1);
								}
								rs1.close();
								rs1 = null;
								pstmt1.close();
								pstmt1 = null;

								if(cnt==0)
								{

									custRate=distCommon.pickRate(priceList, currDate, itemCode, lotNo, "D", mQty, connectionObject);//changes	required

								}
								else
								{
									String listTyp=   siteCode + "~t" + locCode + "~t" + lotNo;
									custRate=distCommon.pickRate(priceList, currDate, itemCode, listTyp, "I", mQty, connectionObject);//changes	required
								}

							}

						}
						else*/
					if(discountPricelist!=null || discountPricelist.trim().length()!=0)
					{	

						String priceListDiscType= getPriceListType(discountPricelist, connectionObject);
						if("M".equals(priceListDiscType))
						{
							discountRate=getDiscount(discountPricelist, currDate, itemCode, unit, mQty,connectionObject);

							priceListType= getPriceListType(priceList, connectionObject);
							/*if(!"L".equalsIgnoreCase(priceListType))
								{
									custRate=distCommon.pickRate(priceList, currDate, itemCode, lotNo, "D", mQty, connectionObject);//changes	required
								}*/
							custRate =calcRate(custRate, discountRate);

						}
						/*else
							{
								int cnt=0;
								String ssql="select count(*) from pricelist where price_list = ? and list_type = 'I'";
								pstmt1=	connectionObject.prepareStatement(ssql);
								pstmt1.setString(1, priceList);   					 	
								rs1=pstmt1.executeQuery();
								if(rs1.next())
								{
									cnt =rs1.getInt(1);
								}
								rs1.close();
								rs1 = null;
								pstmt1.close();
								pstmt1 = null;
								if(cnt==0)
								{
									priceListType= distCommon.getPriceListType(priceList, connectionObject);
									if("L".equalsIgnoreCase(priceListType))
									{
										custRate=distCommon.pickRate(priceList, currDate, itemCode, lotNo, "D", mQty, connectionObject);
									}else 
									{
										custRate=distCommon.pickRate(priceList, currDate, itemCode, lotNo, "D", mQty, connectionObject);
									}

								}
								else
								{
									custRate=distCommon.pickRate(priceList, currDate, itemCode, lotNo, "D", mQty, connectionObject);//changes	required****
								}
								//plistDisc=getDiscount(priceListDisc, ordDtTS, custCode, siteCode, itemCode, unit, discMerge, plDateTs, sordQty, conn);
								discountRate=getDiscount(discountPricelist, currDate, itemCode, unit, mQty,connectionObject);

							}	*/												
					}						
					System.out.println("discountRate == ::  "+discountRate);
					System.out.println("custRate == ::  "+custRate);
					System.out.println("saleRate == ::@@  "+saleRate);
					if(custRate <= 0)
					{
						custRate = saleRate;
					}


					System.out.println("custRate after== ::##  "+custRate);



					DecimalFormat df = new DecimalFormat("###.##");
					ArrayList<String> nonEcoProductList=getNonEcoProductCustomer(productCode,connectionObject);
					ArrayList<String> nonEcoItemList=getNonEcoItemCustomer(itemCode,productCode,connectionObject);

					ArrayList<String> focusProductList=getFocusProductCustomer(productCode,connectionObject);
					ArrayList<String> focusItemList=getFocusItemCustomer(itemCode,productCode,connectionObject);


					String expDate = "";
					valueXmlString.append("<Detail"+formNo+" domID='"+num+"' selected = 'N' formName='"+formName+"'>\r\n" );
					valueXmlString.append("<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");
					valueXmlString.append("<strg_code><![CDATA[").append( "" ).append("]]></strg_code>\r\n");
					valueXmlString.append("<tran_id><![CDATA[" ).append(checkNull(tranID)).append( "]]></tran_id>\r\n" );
					valueXmlString.append("<item_descr><![CDATA[").append(itemDescr).append("]]></item_descr>\r\n");
					valueXmlString.append("<quantity><![CDATA[" ).append(orderQty).append( "]]></quantity>\r\n" );
					valueXmlString.append("<landing_rate><![CDATA[" ).append(custRate).append( "]]></landing_rate>\r\n" );
					valueXmlString.append("<rate><![CDATA[" ).append(df.format(custRate)).append( "]]></rate>\r\n" );
					valueXmlString.append("<mrp_rate><![CDATA[" ).append(df.format(mrprate)).append( "]]></mrp_rate>\r\n" ); //Added By Haseeb Khan on [19-10-2021]					
					valueXmlString.append("<disc_perc><![CDATA[" ).append("").append( "]]></disc_perc>\r\n" );
					valueXmlString.append("<lot_no><![CDATA[" ).append("").append( "]]></lot_no>\r\n" );
					valueXmlString.append("<stock_qty><![CDATA[" ).append(stockQty).append( "]]></stock_qty>\r\n" );
					valueXmlString.append("<expiry_date><![CDATA[").append("").append("]]></expiry_date>\r\n");
					valueXmlString.append("<value><![CDATA[" ).append("").append( "]]></value>\r\n" );
					valueXmlString.append("<stock_value><![CDATA[" ).append("").append( "]]></stock_value>\r\n" );
					valueXmlString.append("<item_code><![CDATA[").append(itemCode).append("]]></item_code>\r\n");
					valueXmlString.append("<tooltip_descr><![CDATA[").append(itemDescr).append("]]></tooltip_descr>\r\n");
					valueXmlString.append("<line_no><![CDATA["+num+"]]></line_no>\r\n");
					valueXmlString.append("<dcr_id><![CDATA[" ).append("").append( "]]></dcr_id>\r\n" );
					valueXmlString.append("<sales_pers><![CDATA[").append(salesPers).append("]]></sales_pers>\r\n");
					valueXmlString.append("<stockist_code><![CDATA[").append("").append("]]></stockist_code>\r\n");
					valueXmlString.append("<stock_info><![CDATA[").append("").append("]]></stock_info>\r\n"); //added by rupali on 22/12/17 for getting data of stock_info field in edit mode
					valueXmlString.append("<price_list><![CDATA[" ).append(priceList).append( "]]></price_list>\r\n" );
					valueXmlString.append("<price_list__disc><![CDATA[" ).append(discountPricelist).append( "]]></price_list__disc>\r\n" );
					valueXmlString.append("<disc_rate><![CDATA[" ).append(custRate).append( "]]></disc_rate>\r\n" );
					valueXmlString.append("<discount_disc><![CDATA[" ).append(discountRate).append( "]]></discount_disc>\r\n" );
					valueXmlString.append("<prcelisttype_flag><![CDATA[" ).append(priceListTypeFlag).append( "]]></prcelisttype_flag>\r\n" );

					String itemSize = "";
					String itemAttribute = "";
					String itemUnit = "";
					String shortDescrFromUom= "";
					if(itemAttribMap != null && !itemAttribMap.isEmpty() && itemAttribMap.size() > 0 && itemAttribMap.containsKey(itemCode))
					{
						HashMap attribMap = (HashMap)itemAttribMap.get(itemCode);
						if(attribMap != null && !attribMap.isEmpty() && attribMap.size() > 0)
						{
							itemSize = (String)attribMap.get("ITEM_SIZE");
							itemAttribute = (String)attribMap.get("ITEM_ATTRIBUTE");
							itemUnit = checkNull(rs.getString("ITEM_UNIT"));
							//System.out.println("itemUnit ["+itemUnit+"]");
							shortDescrFromUom = getShortDescrFromUom(itemUnit,connectionObject);
							//System.out.println("shortDescrFromUom ["+shortDescrFromUom+"]");
						}
					}
					else
					{
						shortDescrFromUom = getShortDescrFromUom(unit,connectionObject);
						itemSize = itemDescr;
					}
					valueXmlString.append("<product_code><![CDATA[").append(productCode).append("]]></product_code>\r\n");
					valueXmlString.append("<product_descr><![CDATA[").append( checkNull(rs.getString("PRODUCT_DESCR")) ).append("]]></product_descr>\r\n");
					valueXmlString.append("<item_size><![CDATA[").append( itemSize +"#"+ shortDescrFromUom ).append("]]></item_size>\r\n");
					valueXmlString.append("<item_attrib_descr><![CDATA[").append( itemAttribute ).append("]]></item_attrib_descr>\r\n");
					valueXmlString.append("<promo_code><![CDATA[").append( "" ).append("]]></promo_code>\r\n");
					valueXmlString.append("<description><![CDATA[").append( "" ).append("]]></description>\r\n");
					valueXmlString.append("<order_qty><![CDATA[").append(orderParam).append("]]></order_qty>\r\n");
					valueXmlString.append("<is_stock_info><![CDATA[").append( isStockInfo ).append("]]></is_stock_info>\r\n"); //added by mrunalini sinkar on 10-august-2018
					//Added by Mrunalini Sinkar for chc enhancment(Start)
					valueXmlString.append("<remark_list><![CDATA[").append( remarkList ).append("]]></remark_list>\r\n");
					valueXmlString.append("<is_product_eco><![CDATA[").append(nonEcoProductList).append("]]></is_product_eco>\r\n");
					valueXmlString.append("<is_item_eco><![CDATA[").append(nonEcoItemList).append("]]></is_item_eco>\r\n");
					valueXmlString.append("<prev_two_order><![CDATA[").append(tooltip).append("]]></prev_two_order>\r\n");
					valueXmlString.append("<is_focus_product><![CDATA[").append(focusProductList).append("]]></is_focus_product>\r\n");
					valueXmlString.append("<is_focus_item><![CDATA[").append(focusItemList).append("]]></is_focus_item>\r\n");

					//Added by Mrunalini Sinkar for chc enhancment(End)
					valueXmlString.append("</Detail"+formNo+">\r\n" );
					num++;
					tooltip.clear();
				}
				if( rs !=null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt !=null )
				{
					pstmt.close();
					pstmt = null;
				}

			}
			else if("brand".equalsIgnoreCase(formName) || "retailerbrand".equalsIgnoreCase(formName) || "stockistbrand".equalsIgnoreCase(formName) || "ncwbrand".equalsIgnoreCase(formName))
			{
				String locality="",docAttach="",tranId="",pitchDetData="";
				String brandCode="",brandDescr="",tagLine="",shDescr="",pitchPriority="";

				int num=1;
				//HashMap<String, String> brand=new HashMap<String, String>();
				LinkedHashMap<String, String> brand=new LinkedHashMap<String, String>();// Changes by Harion S for order sequence as per PITCH_PRIORITY -- 01-Aug-2022
				brand=getBrandCodeList(salesPers,connectionObject);
				locality=getLocalityCode(salesPers,connectionObject);
				HashMap<String, String> document=new HashMap<String, String>();
				//System.out.println(" brand ::::["+brand+"]");
				document=getDocumentList(salesPers,locality,"","","",connectionObject);
				for(Entry<String, String> brandEntry: brand.entrySet())
				{
					brandCode= brandEntry.getKey();
					String brandValue=brandEntry.getValue();
					String [] splitMapValue=brandValue.split("@");
					brandDescr=checkNull(splitMapValue[0]);
					tagLine=checkNull(splitMapValue[1]);
					shDescr=checkNull(splitMapValue[2]);
					pitchPriority=checkNull(splitMapValue[3]);
					String scCode="";String attachment="";

					valueXmlString.append("<Detail"+formNo+" domID='"+num+"' selected = 'N' formName='"+formName+"'>\r\n" );
					valueXmlString.append("<attribute pkNames='' status='N' updateFlag='A' selected='N' />\r\n" );
					valueXmlString.append("<work_date><![CDATA[" ).append("").append( "]]></work_date>\r\n" );
					valueXmlString.append("<sales_pers><![CDATA[").append(checkNull(salesPers)).append("]]></sales_pers>\n");
					valueXmlString.append("<sc_code><![CDATA[").append("").append("]]></sc_code>\r\n");
					valueXmlString.append("<strg_code><![CDATA[").append("").append("]]></strg_code>\r\n");
					valueXmlString.append("<brand_code><![CDATA[").append(brandCode).append("]]></brand_code>\n");
					valueXmlString.append("<pitch_detail><![CDATA[]]></pitch_detail>\r\n" );
					valueXmlString.append("<pitch_feedback><![CDATA[]]></pitch_feedback>\r\n" );
					valueXmlString.append("<pres_pattern><![CDATA[]]></pres_pattern>\r\n" );
					valueXmlString.append("<remarks><![CDATA[]]></remarks>\r\n" );
					valueXmlString.append("<line_no><![CDATA["+num+"]]></line_no>\r\n" );
					valueXmlString.append("<pitch_priority><![CDATA[").append(pitchPriority).append("]]></pitch_priority>\n");
					valueXmlString.append("<pitch_sequence><![CDATA[").append("").append("]]></pitch_sequence>\n");
					valueXmlString.append("<item_code><![CDATA[").append(brandCode).append("]]></item_code>\n");
					valueXmlString.append("<item_descr><![CDATA[").append("").append("]]></item_descr>\n");
					valueXmlString.append("<brand_descr><![CDATA[").append(brandDescr).append("]]></brand_descr>\n");
					valueXmlString.append("<brand_type><![CDATA[]]></brand_type>\r\n" );
					valueXmlString.append("<cur_val><![CDATA[]]></cur_val>\r\n" );
					valueXmlString.append("<cur_nos><![CDATA[]]></cur_nos>\r\n" );
					valueXmlString.append("<source><![CDATA[]]></source>\r\n" );
					valueXmlString.append("<pitch_detail_data><![CDATA[" ).append( pitchDetData ).append( "]]></pitch_detail_data>\r\n" );
					valueXmlString.append("<tran_id><![CDATA[" ).append( tranId ).append( "]]></tran_id>\r\n" );
					valueXmlString.append("<dcr_id><![CDATA[" ).append( "" ).append( "]]></dcr_id>\r\n" );
					valueXmlString.append("<call_outcome_data><![CDATA[" ).append("").append( "]]></call_outcome_data>\r\n" );
					valueXmlString.append("<call_outcome><![CDATA[" ).append("").append( "]]></call_outcome>\r\n" );
					valueXmlString.append("<pitch_detail_descr><![CDATA[" ).append( "" ).append( "]]></pitch_detail_descr>\r\n" );
					valueXmlString.append("<sc_code_pitch><![CDATA[" ).append( "" ).append( "]]></sc_code_pitch>\r\n" );
					valueXmlString.append("<brand_tag_line><![CDATA[").append(tagLine).append("]]></brand_tag_line>\n");
					valueXmlString.append("<brand_sh_descr><![CDATA[").append(shDescr).append("]]></brand_sh_descr>\n");
					System.out.println("document in wizard 20601::"+document);
					if(document!=null && !document.isEmpty() && (document.containsValue(brandCode) || document.containsValue("STRG_CODE")))
					{
						System.out.println("20604");
						for (Entry<String, String> documentEntry: document.entrySet())
						{
							System.out.println("documentEntry.getValue()::"+documentEntry.getValue()+" brandCode:"+brandCode);
							
							if(brandCode.equals(documentEntry.getValue()) || "STRG_CODE".equalsIgnoreCase(documentEntry.getValue()))
							{
								String documentKey=documentEntry.getKey();
								//	System.out.println("docuemnet key:"+documentKey);
								String docPageInfo = "";
								String [] splitMapKey=documentKey.split("@");
								System.out.println("splitMapKey:"+splitMapKey);
								String docId=checkNull(splitMapKey[0]);
								String docName=checkNull(splitMapKey[1]);
								//String docRefId=checkNull(splitMapKey[3]);
								String docRefId=checkNull(splitMapKey[4]);
								if(splitMapKey[3].trim().length()>0)
								{
									docPageInfo = checkNull(splitMapKey[3]); // added by rupali on 30/07/18 for adding page_info in contents
								}
								if(splitMapKey[2].trim().length()>0)
								{
									scCode=checkNull(splitMapKey[2]);
								}
								System.out.println("docId:"+docId+" docName:"+docName+" docPageInfo:"+docPageInfo+"docRefId:"+docRefId);
								System.out.println("line no20628:: "+attachment);
								//System.out.println("brandCode is:"+brandCode+"Attachment is:"+attachment);
								if(attachment==null || attachment.trim().length()==0)
								{
									//commented and added by rupali on 30/07/18 for adding page_info in contents [start]
									//attachment=docId + "::" +docName + ",";
									// attachment=docId + "::" +docName + "::" +docPageInfo +",";
									attachment=docId + "::" +docName + "::" +docPageInfo +"~SEP~";
									System.out.println("lin2 20636: "+attachment);
									//commented and added by rupali on 30/07/18 for adding page_info in contents [end]
								}
								else
								{
									//commented and added by rupali on 30/07/18 for adding page_info in contents [start]
									//attachment=attachment+docId + "::" +docName + ",";
									// attachment=attachment+docId + "::" +docName + "::" +docPageInfo +",";
									attachment=attachment+docId + "::" +docName + "::" +docPageInfo +"~SEP~";
									System.out.println("lin2 20645: "+attachment);
									//commented and added by rupali on 30/07/18 for adding page_info in contents [end]

								}

							}

						}
						// if(attachment != null && attachment.length() > 0 && attachment.charAt(attachment.length() - 1) == ',')
						System.out.println("line 20654");
						if(attachment != null && attachment.length() > 0 && attachment.endsWith("~SEP~"))
						{
							attachment = attachment.substring(0, attachment.length() - 5);
							System.out.println("Attachment scCode is:"+attachment+"sccode is:"+scCode);
						}

						valueXmlString.append("<contents><![CDATA[").append(attachment).append("]]></contents>\n");
					}
					else
					{
						System.out.println("line 20665");
						valueXmlString.append("<contents><![CDATA[").append("").append("]]></contents>\n");
					}
					valueXmlString.append("</Detail"+formNo+">\r\n" );
					num++;
				}
			}
			else if("team".equalsIgnoreCase(formName) || "retailerteam".equalsIgnoreCase(formName) || "ncwteam".equalsIgnoreCase(formName) || "stockistteam".equalsIgnoreCase(formName))
			{
				int num=1;
				//Changed & Added By Vikas Lagad on 23-12-2019 [Changed logic for JNJ_coaching manager in team detail form ]Start
				String itemSer=checkNull(getItemSer(salesPers, connectionObject));
				//Added by Bhagyashri t for team subform add [W21KJOH015]
				String teamGradeLevel = "";
				String sql1="";
				sql = "select parm_value from sfaparm WHERE parm_name = ? and active = ? ";
				pstmt1= connectionObject.prepareStatement(sql);
				pstmt1.setString(1, "TEAM_GRADE_LEV");
				pstmt1.setString(2, "Y");
				rs1 = pstmt1.executeQuery();

				if(rs1.next())
				{
					teamGradeLevel = checkNull(rs1.getString(1));
				}
				else
				{
					teamGradeLevel = "4";
				}
				if(pstmt1 != null)
				{
					pstmt1.close();
					pstmt1 = null;
				}
				if(rs1 != null)
				{
					rs1.close();
					rs1 = null;
				}
				//Changed & Added By Vikas Lagad on 23-12-2019 [Changed logic for JNJ_coaching manager in team detail form ]End
				//Added by Bhagyashri t for team subform add [W21KJOH015][start]
				/*ArrayList<String> memCodeList=new ArrayList<String>();
				String memCodesql ="SELECT ENTITY_TYPE AS MEMBER_TYPE,ENTITY_CODE AS STRG_CODE,CONTACT_PERS AS MEM_CODE,CONTACT_PERS_NAME AS MEMEBR_NAME,MOBILE_NO AS MOBILE_NO FROM ENTITY_CONTACT WHERE ENTITY_TYPE ='C' " + 
						"UNION " + 
						"SELECT ENTITY_TYPE AS MEMBER_TYPE,ENTITY_CODE AS STRG_CODE,CONTACT_PERS AS MEM_CODE,CONTACT_PERS_NAME AS MEMEBR_NAME,MOBILE_NO AS MOBILE_NO  FROM ENTITY_CONTACT WHERE ENTITY_TYPE='E' " + 
						"AND ENTITY_CODE = ?";
				pstmt = connectionObject.prepareStatement(memCodesql);
				pstmt.setString(1, salesPers);
				rs = pstmt.executeQuery();
				while(rs.next())
				{
					String memtype = checkNull(rs.getString("MEMBER_TYPE")).trim();
					String strgCode = checkNull(rs.getString("STRG_CODE")).trim();
					String memCode = checkNull(rs.getString("MEM_CODE")).trim();
					String memName = checkNull(rs.getString("MEMEBR_NAME")).trim();
					String mobileNo = checkNull(rs.getString("MOBILE_NO")).trim();
					String memcodeTyp = memtype+"@"+strgCode+"@"+memCode;
					//String memcodeTyp = memtype.trim() +"@"+strgCode.trim() +"@"+memCode.trim() +"@"+memName.trim() +"@"+mobileNo.trim();
					memCodeList.add(memcodeTyp);

				}
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				//System.out.println("Member code details list is:["+memCodeList+"]");*/
				//Added by Bhagyashri t for team subform add [W21KJOH015][end]
				// added by rupali on 13/04/18 for org_structure related changes [start]
				ArrayList salesPersList = new ArrayList();
				String salesPersTemp="";
				String isOrgStrcture = getSfaParmValue(salesPers,"HIERARCY_FRM_ORG_STR",connectionObject);
				String isFortuneAct = getSfaParmValue(salesPers,"IS_FORTUNE_ACTIVITY",connectionObject);
				OrgStructure orgStructure = new OrgStructure();
				//System.out.println("isOrgStrcture is in realtime::::"+isOrgStrcture);
				//System.out.println("isFortuneAct is in realtime::::"+isFortuneAct);
				//Added by mrunalini SInkar fro NSM
				HashMap<String, String> employeeDesignationMap=darCommonBean.getEmployeeDesignationMap(itemSer,connectionObject);
				//System.out.println("employeeDesignationMap is["+employeeDesignationMap+"]");
				//Added by mrunalini SInkar fro NSM
				if("Y".equalsIgnoreCase(isOrgStrcture))
				{
				salesPersList = orgStructure.reportToUp(salesPers,currDate,connectionObject);
				//System.out.println("salesPersList is::::"+salesPersList);
					salesPersTemp = orgStructure.getFormattedList(salesPersList);
				}

				if(salesPersList != null && !salesPersList.isEmpty())
				{
					
					/*sql = "SELECT DISTINCT '2' AS SR_NO, EMP_CODE AS REPORT_TO,GET_EMP_DESIGNATION(EMP_CODE) DESIGNATION ,DDF_GET_EMPLOYEE_NAME(EMP.EMP_CODE) AS NAME,G.LEVEL_NO LEVEL_NO " + 
							"FROM EMPLOYEE EMP, GRADE G WHERE TRIM(EMP_CODE) IN (SELECT REGEXP_SUBSTR(TRIM(ENTITY_CODE),'[^,]+', 1, LEVEL) FROM ORG_ROLE_ASSIGN " + 
							"WHERE ORG_UNIT='"+itemSer+"' CONNECT BY REGEXP_SUBSTR(ENTITY_CODE, '[^,]+', 1, LEVEL) IS NOT NULL)AND EMP.GRADE=G.GRADE_CODE "+
							"UNION "+
							"SELECT DISTINCT '1' AS SR_NO,EMP.EMP_CODE AS REPORT_TO,GET_EMP_DESIGNATION(EMP.EMP_CODE) DESIGNATION,DDF_GET_EMPLOYEE_NAME(EMP.EMP_CODE) AS NAME,GRADE.LEVEL_NO AS LEVEL_NO "+
							 "FROM EMPLOYEE EMP,GRADE GRADE WHERE EMP.EMP_CODE IN ("+salesPersTemp+") AND EMP.GRADE=GRADE.GRADE_CODE AND GRADE.LEVEL_NO<='"+ teamGradeLevel +"' ORDER BY SR_NO,LEVEL_NO DESC";*/
					//Added by Bhagyashri t for team subform add [W21KJOH015][start]
					if("Y".equalsIgnoreCase(isFortuneAct))
					{
						sql = "SELECT DISTINCT '2' AS SR_NO,'' AS STRG_CODE, EMP_CODE AS REPORT_TO,GET_EMP_DESIGNATION(EMP_CODE) DESIGNATION ,DDF_GET_EMPLOYEE_NAME(EMP.EMP_CODE) AS NAME,G.LEVEL_NO LEVEL_NO,EMP.MOBILE_NO " + 
								"FROM EMPLOYEE EMP, GRADE G WHERE TRIM(EMP_CODE) IN (SELECT REGEXP_SUBSTR(TRIM(ENTITY_CODE),'[^,]+', 1, LEVEL) FROM ORG_ROLE_ASSIGN " + 
								"WHERE ORG_UNIT='"+itemSer+"' CONNECT BY REGEXP_SUBSTR(ENTITY_CODE, '[^,]+', 1, LEVEL) IS NOT NULL)AND EMP.GRADE=G.GRADE_CODE "+
								"UNION "+
								"SELECT DISTINCT '1' AS SR_NO,'' AS STRG_CODE,EMP.EMP_CODE AS REPORT_TO,GET_EMP_DESIGNATION(EMP.EMP_CODE) DESIGNATION,DDF_GET_EMPLOYEE_NAME(EMP.EMP_CODE) AS NAME,GRADE.LEVEL_NO AS LEVEL_NO,EMP.MOBILE_NO "+
								"FROM EMPLOYEE EMP,GRADE GRADE WHERE EMP.EMP_CODE IN ("+salesPersTemp+") AND EMP.GRADE=GRADE.GRADE_CODE AND GRADE.LEVEL_NO<='"+ teamGradeLevel +"' ORDER BY LEVEL_NO DESC";
					}
					else
					{
						//Changes made by Rahul P. on 27-Sep-2023 [Start] set ENTITY_TYPE='R'
						/*sql = "SELECT DISTINCT '2' AS SR_NO,'' AS STRG_CODE, EMP_CODE AS REPORT_TO,GET_EMP_DESIGNATION(EMP_CODE) DESIGNATION ,DDF_GET_EMPLOYEE_NAME(EMP.EMP_CODE) AS NAME,G.LEVEL_NO LEVEL_NO,EMP.MOBILE_NO " + 
								"FROM EMPLOYEE EMP, GRADE G WHERE TRIM(EMP_CODE) IN (SELECT REGEXP_SUBSTR(TRIM(ENTITY_CODE),'[^,]+', 1, LEVEL) FROM ORG_ROLE_ASSIGN " + 
								"WHERE ORG_UNIT='"+itemSer+"' CONNECT BY REGEXP_SUBSTR(ENTITY_CODE, '[^,]+', 1, LEVEL) IS NOT NULL)AND EMP.GRADE=G.GRADE_CODE "+
								"UNION "+
								"SELECT DISTINCT '1' AS SR_NO,'' AS STRG_CODE,EMP.EMP_CODE AS REPORT_TO,GET_EMP_DESIGNATION(EMP.EMP_CODE) DESIGNATION,DDF_GET_EMPLOYEE_NAME(EMP.EMP_CODE) AS NAME,GRADE.LEVEL_NO AS LEVEL_NO,EMP.MOBILE_NO "+
								"FROM EMPLOYEE EMP,GRADE GRADE WHERE EMP.EMP_CODE IN ("+salesPersTemp+") AND EMP.GRADE=GRADE.GRADE_CODE AND GRADE.LEVEL_NO<='"+ teamGradeLevel +"' " +
								"UNION "+
								"SELECT DISTINCT '3' AS SR_NO,EC.ENTITY_CODE AS STRG_CODE,EC.CONTACT_PERS AS REPORT_TO,'' AS DESIGNATION , " + 
								"EC.CONTACT_PERS_NAME AS NAME , 0 AS LEVEL_NO, EC.MOBILE_NO " + 
								"FROM ENTITY_CONTACT EC, STRG_SERIES SS WHERE EC.ENTITY_TYPE='C' " + 
								"AND EC.ENTITY_CODE=SS.SC_CODE AND SS.SALES_PERS=? AND SS.STATUS='Y' " + 
								"ORDER BY SR_NO,LEVEL_NO DESC";*/
						sql = "SELECT DISTINCT '2' AS SR_NO,'' AS STRG_CODE, EMP_CODE AS REPORT_TO,GET_EMP_DESIGNATION(EMP_CODE) DESIGNATION ,DDF_GET_EMPLOYEE_NAME(EMP.EMP_CODE) AS NAME,G.LEVEL_NO LEVEL_NO,EMP.MOBILE_NO " + 
								"FROM EMPLOYEE EMP, GRADE G WHERE TRIM(EMP_CODE) IN (SELECT REGEXP_SUBSTR(TRIM(ENTITY_CODE),'[^,]+', 1, LEVEL) FROM ORG_ROLE_ASSIGN " + 
								"WHERE ORG_UNIT='"+itemSer+"' CONNECT BY REGEXP_SUBSTR(ENTITY_CODE, '[^,]+', 1, LEVEL) IS NOT NULL)AND EMP.GRADE=G.GRADE_CODE "+
								"UNION "+
								"SELECT DISTINCT '1' AS SR_NO,'' AS STRG_CODE,EMP.EMP_CODE AS REPORT_TO,GET_EMP_DESIGNATION(EMP.EMP_CODE) DESIGNATION,DDF_GET_EMPLOYEE_NAME(EMP.EMP_CODE) AS NAME,GRADE.LEVEL_NO AS LEVEL_NO,EMP.MOBILE_NO "+
								"FROM EMPLOYEE EMP,GRADE GRADE WHERE EMP.EMP_CODE IN ("+salesPersTemp+") AND EMP.GRADE=GRADE.GRADE_CODE AND GRADE.LEVEL_NO<='"+ teamGradeLevel +"' " +
								"UNION "+
								"SELECT DISTINCT '3' AS SR_NO,EC.ENTITY_CODE AS STRG_CODE,EC.CONTACT_PERS AS REPORT_TO,'' AS DESIGNATION , " + 
								"EC.CONTACT_PERS_NAME AS NAME , 0 AS LEVEL_NO, EC.MOBILE_NO " + 
								"FROM ENTITY_CONTACT EC, STRG_SERIES SS WHERE EC.ENTITY_TYPE='R' " + 
								"AND EC.ENTITY_CODE=SS.SC_CODE AND SS.SALES_PERS=? AND SS.STATUS='Y' " + 
								"ORDER BY SR_NO,LEVEL_NO DESC"; 
						//Changes made by Rahul P. on 27-Sep-2023 [End]
					}
					//Added by Bhagyashri t for team subform add [W21KJOH015][end]
					sql1 = "SELECT DISTINCT '2' AS SR_NO,'' AS STRG_CODE, EMP_CODE AS REPORT_TO,GET_EMP_DESIGNATION(EMP_CODE) DESIGNATION ,DDF_GET_EMPLOYEE_NAME(EMP.EMP_CODE) AS NAME,G.LEVEL_NO LEVEL_NO,EMP.MOBILE_NO " + 
							"FROM EMPLOYEE EMP, GRADE G WHERE TRIM(EMP_CODE) IN (SELECT REGEXP_SUBSTR(TRIM(ENTITY_CODE),'[^,]+', 1, LEVEL) FROM ORG_ROLE_ASSIGN " + 
							"WHERE ORG_UNIT='"+itemSer+"' CONNECT BY REGEXP_SUBSTR(ENTITY_CODE, '[^,]+', 1, LEVEL) IS NOT NULL)AND EMP.GRADE=G.GRADE_CODE "+
							"UNION "+
							"SELECT DISTINCT '1' AS SR_NO,'' AS STRG_CODE,EMP.EMP_CODE AS REPORT_TO,GET_EMP_DESIGNATION(EMP.EMP_CODE) DESIGNATION,DDF_GET_EMPLOYEE_NAME(EMP.EMP_CODE) AS NAME,GRADE.LEVEL_NO AS LEVEL_NO,EMP.MOBILE_NO "+
							"FROM EMPLOYEE EMP,GRADE GRADE WHERE EMP.EMP_CODE IN ("+salesPersTemp+") AND EMP.GRADE=GRADE.GRADE_CODE AND GRADE.LEVEL_NO<='"+ teamGradeLevel +"' ";					//sql ="SELECT EMP.EMP_CODE AS REPORT_TO,GET_EMP_DESIGNATION(EMP.EMP_CODE) DESIGNATION,DDF_GET_EMPLOYEE_NAME(EMP.EMP_CODE) AS NAME FROM EMPLOYEE EMP,GRADE GRADE WHERE EMP.EMP_CODE IN ("+salesPersTemp+") AND EMP.GRADE=GRADE.GRADE_CODE AND GRADE.LEVEL_NO<='"+ teamGradeLevel +"' ORDER BY GRADE.LEVEL_NO DESC";
				}
				// added by rupali on 13/04/18 for org_structure related changes [end]
				else
				{
					ArrayList teamList = new ArrayList();

					String teamSql="SELECT REPORT_TO FROM EMPLOYEE START WITH EMP_CODE = ? CONNECT BY PRIOR  REPORT_TO = EMP_CODE AND REPORT_TO IS NOT NULL";
					PreparedStatement teamPstmt= connectionObject.prepareStatement(teamSql);
					teamPstmt.setString(1, salesPers);
					ResultSet teamRs= teamPstmt.executeQuery();
					while(teamRs.next())
					{
						String reportTo=checkNull(teamRs.getString("REPORT_TO"));
						teamList.add(reportTo);
					}
					if(teamPstmt != null)
					{
						teamPstmt.close();
						teamPstmt = null;
					}
					if(teamRs != null)
					{
						teamRs.close();
						teamRs = null;
					}


					String salesPersEmp=orgStructure.getFormattedList(teamList);
					
					/*sql = "SELECT DISTINCT '2' AS SR_NO, EMP_CODE AS REPORT_TO,GET_EMP_DESIGNATION(EMP_CODE) DESIGNATION ,DDF_GET_EMPLOYEE_NAME(EMP.EMP_CODE) AS NAME,G.LEVEL_NO LEVEL_NO " + 
							"FROM EMPLOYEE EMP, GRADE G WHERE TRIM(EMP_CODE) IN (SELECT REGEXP_SUBSTR(TRIM(ENTITY_CODE),'[^,]+', 1, LEVEL) FROM ORG_ROLE_ASSIGN " + 
							"WHERE ORG_UNIT='"+itemSer+"' CONNECT BY REGEXP_SUBSTR(ENTITY_CODE, '[^,]+', 1, LEVEL) IS NOT NULL)AND EMP.GRADE=G.GRADE_CODE "+
							"UNION "+
							"SELECT DISTINCT '1' AS SR_NO,EMP.EMP_CODE AS REPORT_TO,GET_EMP_DESIGNATION(EMP.EMP_CODE) DESIGNATION,DDF_GET_EMPLOYEE_NAME(EMP.EMP_CODE) AS NAME,GRADE.LEVEL_NO AS LEVEL_NO "+
							 "FROM EMPLOYEE EMP,GRADE GRADE WHERE EMP.EMP_CODE IN ("+salesPersEmp+") AND EMP.GRADE=GRADE.GRADE_CODE AND GRADE.LEVEL_NO<='"+ teamGradeLevel +"'  ORDER BY SR_NO,LEVEL_NO DESC";*/
					//Added by Bhagyashri t for team subform add [W21KJOH015][start]
					if("Y".equalsIgnoreCase(isFortuneAct))
					{
						sql = "SELECT DISTINCT '2' AS SR_NO,''AS STRG_CODE, EMP_CODE AS REPORT_TO,GET_EMP_DESIGNATION(EMP_CODE) DESIGNATION ,DDF_GET_EMPLOYEE_NAME(EMP.EMP_CODE) AS NAME,G.LEVEL_NO LEVEL_NO,EMP.MOBILE_NO " + 
								"FROM EMPLOYEE EMP, GRADE G WHERE TRIM(EMP_CODE) IN (SELECT REGEXP_SUBSTR(TRIM(ENTITY_CODE),'[^,]+', 1, LEVEL) FROM ORG_ROLE_ASSIGN " + 
								"WHERE ORG_UNIT='"+itemSer+"' CONNECT BY REGEXP_SUBSTR(ENTITY_CODE, '[^,]+', 1, LEVEL) IS NOT NULL)AND EMP.GRADE=G.GRADE_CODE "+
								"UNION "+
								"SELECT DISTINCT '1' AS SR_NO,'' AS STRG_CODE,EMP.EMP_CODE AS REPORT_TO,GET_EMP_DESIGNATION(EMP.EMP_CODE) DESIGNATION,DDF_GET_EMPLOYEE_NAME(EMP.EMP_CODE) AS NAME,GRADE.LEVEL_NO AS LEVEL_NO,EMP.MOBILE_NO "+
								"FROM EMPLOYEE EMP,GRADE GRADE WHERE EMP.EMP_CODE IN ("+salesPersEmp+") AND EMP.GRADE=GRADE.GRADE_CODE AND GRADE.LEVEL_NO<='"+ teamGradeLevel +"'  ORDER BY LEVEL_NO DESC";
					}
					else
					{
						//Changes made by Rahul P. on 27-Sep-2023 [Start] set ENTITY_TYPE='R'
						/*sql = "SELECT DISTINCT '2' AS SR_NO,''AS STRG_CODE, EMP_CODE AS REPORT_TO,GET_EMP_DESIGNATION(EMP_CODE) DESIGNATION ,DDF_GET_EMPLOYEE_NAME(EMP.EMP_CODE) AS NAME,G.LEVEL_NO LEVEL_NO,EMP.MOBILE_NO " + 
								"FROM EMPLOYEE EMP, GRADE G WHERE TRIM(EMP_CODE) IN (SELECT REGEXP_SUBSTR(TRIM(ENTITY_CODE),'[^,]+', 1, LEVEL) FROM ORG_ROLE_ASSIGN " + 
								"WHERE ORG_UNIT='"+itemSer+"' CONNECT BY REGEXP_SUBSTR(ENTITY_CODE, '[^,]+', 1, LEVEL) IS NOT NULL)AND EMP.GRADE=G.GRADE_CODE "+
								"UNION "+
								"SELECT DISTINCT '1' AS SR_NO,'' AS STRG_CODE,EMP.EMP_CODE AS REPORT_TO,GET_EMP_DESIGNATION(EMP.EMP_CODE) DESIGNATION,DDF_GET_EMPLOYEE_NAME(EMP.EMP_CODE) AS NAME,GRADE.LEVEL_NO AS LEVEL_NO,EMP.MOBILE_NO "+
								"FROM EMPLOYEE EMP,GRADE GRADE WHERE EMP.EMP_CODE IN ("+salesPersEmp+") AND EMP.GRADE=GRADE.GRADE_CODE AND GRADE.LEVEL_NO<='"+ teamGradeLevel +"' "+
								"UNION "+
								"SELECT DISTINCT '3' AS SR_NO,EC.entity_code as strg_code,EC.contact_pers as REPORT_TO,'' as DESIGNATION , " + 
								"EC.CONTACT_PERS_NAME as NAME , 0 AS LEVEL_NO, EC.MOBILE_NO  " + 
								"FROM ENTITY_CONTACT EC, STRG_SERIES SS WHERE EC.ENTITY_TYPE='C' " + 
								"AND EC.ENTITY_CODE=SS.SC_CODE AND SS.SALES_PERS=? AND SS.STATUS='Y' " + 
								"ORDER BY SR_NO,LEVEL_NO DESC";*/
						sql = "SELECT DISTINCT '2' AS SR_NO,''AS STRG_CODE, EMP_CODE AS REPORT_TO,GET_EMP_DESIGNATION(EMP_CODE) DESIGNATION ,DDF_GET_EMPLOYEE_NAME(EMP.EMP_CODE) AS NAME,G.LEVEL_NO LEVEL_NO,EMP.MOBILE_NO " + 
								"FROM EMPLOYEE EMP, GRADE G WHERE TRIM(EMP_CODE) IN (SELECT REGEXP_SUBSTR(TRIM(ENTITY_CODE),'[^,]+', 1, LEVEL) FROM ORG_ROLE_ASSIGN " + 
								"WHERE ORG_UNIT='"+itemSer+"' CONNECT BY REGEXP_SUBSTR(ENTITY_CODE, '[^,]+', 1, LEVEL) IS NOT NULL)AND EMP.GRADE=G.GRADE_CODE "+
								"UNION "+
								"SELECT DISTINCT '1' AS SR_NO,'' AS STRG_CODE,EMP.EMP_CODE AS REPORT_TO,GET_EMP_DESIGNATION(EMP.EMP_CODE) DESIGNATION,DDF_GET_EMPLOYEE_NAME(EMP.EMP_CODE) AS NAME,GRADE.LEVEL_NO AS LEVEL_NO,EMP.MOBILE_NO "+
								"FROM EMPLOYEE EMP,GRADE GRADE WHERE EMP.EMP_CODE IN ("+salesPersEmp+") AND EMP.GRADE=GRADE.GRADE_CODE AND GRADE.LEVEL_NO<='"+ teamGradeLevel +"' "+
								"UNION "+
								"SELECT DISTINCT '3' AS SR_NO,EC.entity_code as strg_code,EC.contact_pers as REPORT_TO,'' as DESIGNATION , " + 
								"EC.CONTACT_PERS_NAME as NAME , 0 AS LEVEL_NO, EC.MOBILE_NO  " + 
								"FROM ENTITY_CONTACT EC, STRG_SERIES SS WHERE EC.ENTITY_TYPE='R' " + 
								"AND EC.ENTITY_CODE=SS.SC_CODE AND SS.SALES_PERS=? AND SS.STATUS='Y' " + 
								"ORDER BY SR_NO,LEVEL_NO DESC"; 
						//Changes made by Rahul P. on 27-Sep-2023 [Start] change ENTITY_TYPE='R

					}
					
					sql1 = "SELECT DISTINCT '2' AS SR_NO,''AS STRG_CODE, EMP_CODE AS REPORT_TO,GET_EMP_DESIGNATION(EMP_CODE) DESIGNATION ,DDF_GET_EMPLOYEE_NAME(EMP.EMP_CODE) AS NAME,G.LEVEL_NO LEVEL_NO,EMP.MOBILE_NO " + 
							"FROM EMPLOYEE EMP, GRADE G WHERE TRIM(EMP_CODE) IN (SELECT REGEXP_SUBSTR(TRIM(ENTITY_CODE),'[^,]+', 1, LEVEL) FROM ORG_ROLE_ASSIGN " + 
							"WHERE ORG_UNIT='"+itemSer+"' CONNECT BY REGEXP_SUBSTR(ENTITY_CODE, '[^,]+', 1, LEVEL) IS NOT NULL)AND EMP.GRADE=G.GRADE_CODE "+
							"UNION "+
							"SELECT DISTINCT '1' AS SR_NO,'' AS STRG_CODE,EMP.EMP_CODE AS REPORT_TO,GET_EMP_DESIGNATION(EMP.EMP_CODE) DESIGNATION,DDF_GET_EMPLOYEE_NAME(EMP.EMP_CODE) AS NAME,GRADE.LEVEL_NO AS LEVEL_NO,EMP.MOBILE_NO "+
							"FROM EMPLOYEE EMP,GRADE GRADE WHERE EMP.EMP_CODE IN ("+salesPersEmp+") AND EMP.GRADE=GRADE.GRADE_CODE AND GRADE.LEVEL_NO<='"+ teamGradeLevel +"' ";

					//Added by Bhagyashri t for team subform add [W21KJOH015][end]
				}
				String teamHierarchy = getTeamFormHierarchy(sql1, connectionObject);
				pstmt = connectionObject.prepareStatement(sql);
				//Added by Bhagyashri For issue in team subform of fortune[21/06/22]
				if(!("Y".equalsIgnoreCase(isFortuneAct)))
				{
					pstmt.setString(1,salesPers);
				}
				rs = pstmt.executeQuery();
				while(rs.next())
				{
					String teamCode = checkNull(rs.getString("REPORT_TO"));
					//String empName = getEmpName(teamCode, connectionObject);
					String empDesign = getDesignName(teamCode, connectionObject);
					//Added by Bhagyashri t for team subform add [W21KJOH015][start]
					String mobileNo = checkNull(rs.getString("MOBILE_NO"));
					String strgCode = checkNull(rs.getString("STRG_CODE")).trim();
					//Added by Bhagyashri t for team subform add [W21KJOH015][end]
					//String designation = checkNull(rs.getString("DESIGNATION"));
					String empNameDesign = getEmpNameDesign(teamCode, connectionObject);
					String srNo = checkNull(rs.getString("SR_NO")).trim();
					String designation="";
					String empName ="";
					if("2".equalsIgnoreCase(srNo) && !employeeDesignationMap.isEmpty())
					{
						if(employeeDesignationMap.containsKey(teamCode))
						{
							designation=employeeDesignationMap.get(teamCode);

						}
						else
						{
							designation=empDesign;

						}
					}
					else
					{
						designation=empDesign;
					}
					//Added by Bhagyashri t for team subform add [W21KJOH015][start]
					if("3".equalsIgnoreCase(srNo))
					{
						empName = checkNull(rs.getString("NAME")).trim();
					}
					else
					{
						empName = getEmpName(teamCode, connectionObject);
					}
					//Added by Bhagyashri t for team subform add [W21KJOH015][end]
					if(empNameDesign!=null && empNameDesign.trim().length()>0)
					{
						empNameDesign=empNameDesign.substring(0, empNameDesign.lastIndexOf("("));
						empNameDesign=empNameDesign +"("+designation+")";

					}
					//Added by Bhagyashri t for team subform add [W21KJOH015][start]
					if("3".equalsIgnoreCase(srNo))
					{
						empNameDesign = checkNull(rs.getString("NAME")).trim();
					}
					else
					{
						empNameDesign = empNameDesign;
					}
					//Added by Bhagyashri t for team subform add [W21KJOH015][end]
					valueXmlString.append("<Detail"+formNo+" domID='"+num+"' selected = 'N' formName='"+formName+"'>\r\n" );
					valueXmlString.append("<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");
					valueXmlString.append("<sales_pers><![CDATA[").append( teamCode ).append("]]></sales_pers>\r\n");
					valueXmlString.append("<line_no><![CDATA["+num+"]]></line_no>\r\n");
					valueXmlString.append("<dcr_id><![CDATA[").append( "" ).append("]]></dcr_id>\r\n");
					valueXmlString.append("<strg_code><![CDATA[").append( strgCode ).append("]]></strg_code>\r\n");
					valueXmlString.append("<name><![CDATA[").append( empName ).append("]]></name>\r\n");
					valueXmlString.append("<member_name visible='0'><![CDATA[").append( empName ).append("]]></member_name>\r\n");
					valueXmlString.append("<sales_pers_sp_name ><![CDATA[").append( empName ).append("]]></sales_pers_sp_name>\r\n");
					valueXmlString.append("<design_code><![CDATA[").append( empDesign ).append("]]></design_code>\r\n");
					valueXmlString.append("<employee_designation><![CDATA[").append( designation ).append("]]></employee_designation>\r\n");
					valueXmlString.append("<visited_with_display><![CDATA[").append( empNameDesign ).append("]]></visited_with_display>\r\n");
					valueXmlString.append("<disp_descr visible='0'><![CDATA[" ).append( empDesign ).append("]]></disp_descr>\r\n");
					valueXmlString.append("<member_type visible='0'><![CDATA[").append("").append("]]></member_type>\r\n");
					valueXmlString.append("<mem_code visible='0'><![CDATA[").append( teamCode ).append("]]></mem_code>\r\n");
					valueXmlString.append("<team_mobile_no visible='0'><![CDATA[" ).append( mobileNo ).append("]]></team_mobile_no>\r\n");
					//valueXmlString.append("<mem_code_data><![CDATA[").append( memCodeList ).append("]]></mem_code_data>\r\n");
					valueXmlString.append("<team_hierarchy_list><![CDATA[" ).append( teamHierarchy ).append("]]></team_hierarchy_list>\r\n");

					valueXmlString.append( "</Detail"+formNo+">\r\n" );
					num++;
				}
				if( rs !=null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt !=null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			else if("display".equalsIgnoreCase(formName) || "retailerdisplay".equalsIgnoreCase(formName) || "stockistdisplay".equalsIgnoreCase(formName) || "ncwdisplay".equalsIgnoreCase(formName))
			{
				ArrayList<String> dispList = new ArrayList<String>();
				String dispSql="SELECT ITEM_OPTION,DISP_TYPE FROM DISPLAY_TYPE ORDER BY DISP_TYPE";
				String itemOption="";
				dispPstmt = connectionObject.prepareStatement(dispSql) ;
				dispRs = dispPstmt.executeQuery();
				while(dispRs.next())
				{
					String itmOption = checkNull(dispRs.getString("ITEM_OPTION"));
					String dispType = checkNull(dispRs.getString("DISP_TYPE"));
					String itmDispTyp = dispType.trim() +"@"+itmOption;
					dispList.add(itmDispTyp);
				}
				if (dispRs != null)
				{
					dispRs.close();
					dispRs = null;
				}
				if (dispPstmt != null)
				{
					dispPstmt.close();
					dispPstmt = null;
				}
				// commentted by rupali on 17/01/19 for getting deals against all customers of that sales person [start]
				/*
				String dcrId="";
				int domId=1;
				valueXmlString.append("<Detail"+formNo+" domID='" + domId + "' selected = 'N' formName='"+formName+"'>\r\n" );
				valueXmlString.append("<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");
				valueXmlString.append("<dcr_id><![CDATA[" ).append(dcrId).append( "]]></dcr_id>\r\n" );
				valueXmlString.append("<line_no><![CDATA[").append(domId).append("]]></line_no>\r\n");
				valueXmlString.append("<strg_code><![CDATA[").append("").append("]]></strg_code>\n");
				valueXmlString.append("<doc_id><![CDATA[").append("").append("]]></doc_id>\n");
				valueXmlString.append("<doc_id_1><![CDATA[").append("").append("]]></doc_id_1>\n");
				valueXmlString.append("<display_area><![CDATA[").append( "" ).append("]]></display_area>\r\n");
				valueXmlString.append("<tran_id><![CDATA[").append( "" ).append("]]></tran_id>\r\n");
				valueXmlString.append("<itm_display_type><![CDATA[").append(dispList).append("]]></itm_display_type>\r\n");
				if(!dispList.isEmpty())
				{
					String listElement = dispList.get(0);
					if(listElement!=null && listElement.trim().length()>0)
					{
						itemOption=listElement.split("@")[1];
					}
				}
				System.out.println("itemOption is:["+itemOption+"]dispList is["+dispList+"]");*/
				/*if(itemOption.equalsIgnoreCase("1"))
				{
					valueXmlString.append( "<item_code visible = '1'><![CDATA[" ).append("").append( "]]></item_code>\r\n" );
					valueXmlString.append( "<quantity visible = '0'><![CDATA[" ).append("").append( "]]></quantity>\r\n" );
				}
				else if(itemOption.equalsIgnoreCase("2"))
				{
					valueXmlString.append( "<item_code visible = '1'><![CDATA[" ).append("").append( "]]></item_code>\r\n" );
					valueXmlString.append( "<quantity visible = '1'><![CDATA[" ).append("").append( "]]></quantity>\r\n" );
				}
				else if(itemOption.equalsIgnoreCase("3"))
				{
					valueXmlString.append( "<item_code visible = '0'><![CDATA[" ).append("").append( "]]></item_code>\r\n" );
					valueXmlString.append( "<quantity visible = '1'><![CDATA[" ).append("").append( "]]></quantity>\r\n" );
				}
				else
				{
					valueXmlString.append( "<item_code visible = '0'><![CDATA[" ).append( "" ).append( "]]></item_code>\r\n" );
					valueXmlString.append( "<quantity visible = '0'><![CDATA[" ).append( "" ).append( "]]></quantity>\r\n" );
				}*/
				/*if(itemOption.equalsIgnoreCase("1"))
				{
					valueXmlString.append( "<brand_code visible = '1'><![CDATA[" ).append("").append( "]]></brand_code>\r\n" );                     //Changed by Niraj s on 14-Dec-2018 for change Item_code to brand_code in display form
					valueXmlString.append( "<quantity visible = '0'><![CDATA[" ).append("").append( "]]></quantity>\r\n" );
					valueXmlString.append( "<brand_descr visible = '1'><![CDATA[" ).append( "" ).append( "]]></brand_descr>\r\n" );
					valueXmlString.append( "<target_qty visible = '0'><![CDATA[" ).append( "" ).append( "]]></target_qty>\r\n" );
				}
				else if(itemOption.equalsIgnoreCase("2"))
				{
					valueXmlString.append( "<brand_code visible = '1'><![CDATA[" ).append("").append( "]]></brand_code>\r\n" );                     //Changed by Niraj s on 14-Dec-2018 for change Item_code to brand_code in display form
					valueXmlString.append( "<quantity visible = '1'><![CDATA[" ).append("").append( "]]></quantity>\r\n" );
					valueXmlString.append( "<brand_descr visible = '1'><![CDATA[" ).append( "" ).append( "]]></brand_descr>\r\n" );
					valueXmlString.append( "<target_qty visible = '0'><![CDATA[" ).append( "" ).append( "]]></target_qty>\r\n" );
				}
				else if(itemOption.equalsIgnoreCase("3"))
				{
					valueXmlString.append( "<brand_code visible = '0'><![CDATA[" ).append("").append( "]]></brand_code>\r\n" );                     //Changed by Niraj s on 14-Dec-2018 for change Item_code to brand_code in display form
					valueXmlString.append( "<quantity visible = '1'><![CDATA[" ).append("").append( "]]></quantity>\r\n" );
					valueXmlString.append( "<brand_descr visible = '0'><![CDATA[" ).append( "" ).append( "]]></brand_descr>\r\n" );
					valueXmlString.append( "<target_qty visible = '0'><![CDATA[" ).append( "" ).append( "]]></target_qty>\r\n" );
				}
				else
				{
					valueXmlString.append( "<brand_code visible = '0'><![CDATA[" ).append( "" ).append( "]]></brand_code>\r\n" );                   //Changed by Niraj s on 14-Dec-2018 for change Item_code to brand_code in display form
					valueXmlString.append( "<quantity visible = '0'><![CDATA[" ).append( "" ).append( "]]></quantity>\r\n" );
					valueXmlString.append( "<brand_descr visible = '0'><![CDATA[" ).append( "" ).append( "]]></brand_descr>\r\n" );
					valueXmlString.append( "<target_qty visible = '0'><![CDATA[" ).append( "" ).append( "]]></target_qty>\r\n" );
				}
				valueXmlString.append("</Detail"+formNo+">\r\n" );*/
				// commentted by rupali on 17/01/19 for getting deals against all customers of that sales person [end]
				// added by rupali on 17/01/19 for getting deals against all customers of that sales person [start]
				int num=1;
				int dispCount = 0;
				String dispalySql = "SELECT DEAL.TRAN_ID,DEAL.TRAN_DATE,BRAND.BRAND_CODE AS CODE,BRAND.DESCRIPTION,DET.TARGET_QTY,DEAL.STATUS_DATE,DEAL.STRG_CODE AS STRG_CODE,"+
						"TRIM(SP.SALES_PERS) AS SALES_PERS, DET.REMARKS AS REMARKS "+
						"FROM BRAND BRAND, SALES_PERS SP, DND_DEAL DEAL, DND_DEAL_DET DET "+
						"WHERE SP.ITEM_SER = BRAND.ITEM_SER "+
						"AND SP.SALES_PERS = DEAL.SALES_PERS AND BRAND.BRAND_CODE = DET.BRAND_CODE AND DEAL.TRAN_ID = DET.TRAN_ID AND DEAL.APRV_STAT = 'A' "+
						"AND SP.SALES_PERS = ? AND DEAL.EFF_FROM <= ? AND DEAL.VALID_UPTO >= ? ORDER BY TRAN_DATE,TRAN_ID ";

				pstmtDisp = connectionObject.prepareStatement(dispalySql);
				pstmtDisp.setString(1, salesPers);
				pstmtDisp.setTimestamp( 2, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( currDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
				pstmtDisp.setTimestamp( 3, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( currDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
				rsDisp = pstmtDisp.executeQuery();

				while(rsDisp.next())
				{
					dispCount++;
					valueXmlString.append("<Detail"+formNo+" domID='" + num + "' selected = 'N' formName='"+formName+"'>\r\n" );
					valueXmlString.append("<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");
					valueXmlString.append("<dcr_id><![CDATA[" ).append("").append( "]]></dcr_id>\r\n" );
					valueXmlString.append("<line_no><![CDATA[").append(domID).append("]]></line_no>\r\n");
					valueXmlString.append("<strg_code><![CDATA[").append(rsDisp.getString("STRG_CODE")).append("]]></strg_code>\n");
					valueXmlString.append("<doc_id><![CDATA[").append("").append("]]></doc_id>\n");
					valueXmlString.append("<doc_id_1><![CDATA[").append("").append("]]></doc_id_1>\n");
					valueXmlString.append("<display_area><![CDATA[").append(checkNull(rsDisp.getString("REMARKS"))).append("]]></display_area>\r\n");
					valueXmlString.append("<tran_id><![CDATA[").append( "" ).append("]]></tran_id>\r\n");
					valueXmlString.append("<disp_type><![CDATA[" ).append("").append("]]></disp_type>\r\n");
					valueXmlString.append( "<brand_code visible = '0'><![CDATA[" ).append(checkNull(rsDisp.getString("CODE"))).append( "]]></brand_code>\r\n" );                     //Changed by Niraj s on 14-Dec-2018 for change Item_code to brand_code in display form
					valueXmlString.append( "<quantity visible = '1'><![CDATA[" ).append("").append( "]]></quantity>\r\n" );
					valueXmlString.append( "<brand_descr visible = '1'><![CDATA[" ).append(checkNull(rsDisp.getString("DESCRIPTION"))).append( "]]></brand_descr>\r\n" );
					valueXmlString.append( "<target_qty visible = '1'><![CDATA[" ).append(rsDisp.getInt("TARGET_QTY")).append( "]]></target_qty>\r\n" );
					valueXmlString.append("<itm_display_type><![CDATA[").append(dispList).append("]]></itm_display_type>\r\n");
					valueXmlString.append("</Detail"+formNo+">\r\n" );
					num++;
				}
				if (rsDisp!= null)
				{
					rsDisp.close();
					rsDisp = null;
				}
				if(pstmtDisp!=null)
				{
					pstmtDisp.close();
					pstmtDisp = null;
				}
				// added by rupali on 17/01/19 for getting deals against all customers of that sales person [end]

				if(dispCount==0)
				{
					valueXmlString.append("<Detail"+formNo+" domID='" + num + "' selected = 'N' formName='"+formName+"'>\r\n" );
					valueXmlString.append("<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");
					valueXmlString.append("<dcr_id><![CDATA[" ).append("").append( "]]></dcr_id>\r\n" );
					valueXmlString.append("<line_no><![CDATA[").append(num).append("]]></line_no>\r\n");
					valueXmlString.append("<strg_code><![CDATA[").append("").append("]]></strg_code>\n");
					valueXmlString.append("<doc_id><![CDATA[").append("").append("]]></doc_id>\n");
					valueXmlString.append("<doc_id_1><![CDATA[").append("").append("]]></doc_id_1>\n");
					valueXmlString.append("<display_area><![CDATA[").append("").append("]]></display_area>\r\n");
					valueXmlString.append("<tran_id><![CDATA[").append( "" ).append("]]></tran_id>\r\n");
					valueXmlString.append("<disp_type><![CDATA[" ).append("").append("]]></disp_type>\r\n");
					valueXmlString.append("<brand_code visible = '0'><![CDATA[" ).append("").append( "]]></brand_code>\r\n" );                     //Changed by Niraj s on 14-Dec-2018 for change Item_code to brand_code in display form
					valueXmlString.append("<quantity visible = '1'><![CDATA[" ).append("").append( "]]></quantity>\r\n" );
					valueXmlString.append("<brand_descr visible = '1'><![CDATA[" ).append("").append( "]]></brand_descr>\r\n" );
					valueXmlString.append("<target_qty visible = '1'><![CDATA[" ).append("").append( "]]></target_qty>\r\n" );
					valueXmlString.append("<itm_display_type><![CDATA[").append(dispList).append("]]></itm_display_type>\r\n");
					valueXmlString.append("</Detail"+formNo+">\r\n" );
				}
			}
			//added by prachi on 03-AUG-22 [W22EBAS005]
			else if("collection".equalsIgnoreCase(formName))
			{
				int num=1;
				
				
				String MaxCashSalesAmt  = checkNull(getSfaParmValue(salesPers,"MAX_CASH_SALES_AMT",connectionObject)); 
				System.out.println("Value of parm_value:30/09/22"+MaxCashSalesAmt);
				
				valueXmlString.append("<Detail"+formNo+" domID='" + num + "' selected = 'N' formName='"+formName+"'>\r\n" );
				valueXmlString.append("<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");
				valueXmlString.append("<dcr_id><![CDATA[" ).append("").append( "]]></dcr_id>\r\n" );
				valueXmlString.append("<line_no><![CDATA[").append(num).append("]]></line_no>\r\n");
				valueXmlString.append("<strg_code><![CDATA[").append("").append("]]></strg_code>\n");
				valueXmlString.append("<tran_id><![CDATA[").append( "" ).append("]]></tran_id>\r\n");
				valueXmlString.append("<bill_amt><![CDATA[").append( "" ).append("]]></bill_amt>\r\n");
				valueXmlString.append("<bill_date><![CDATA[").append( "" ).append("]]></bill_date>\r\n");
				valueXmlString.append("<pay_mode><![CDATA[").append( "" ).append("]]></pay_mode>\r\n");
				valueXmlString.append("<ref_no><![CDATA[").append( "" ).append("]]></ref_no>\r\n");
				valueXmlString.append("<amount><![CDATA[").append( "" ).append("]]></amount>\r\n");
				valueXmlString.append("<ref_bank><![CDATA[").append( "" ).append("]]></ref_bank>\r\n");
				valueXmlString.append("<ref_date><![CDATA[").append( "" ).append("]]></ref_date>\r\n");
				valueXmlString.append("<remarks_collect><![CDATA[").append( "" ).append("]]></remarks_collect>\r\n");
				valueXmlString.append("<max_amount><![CDATA[").append(MaxCashSalesAmt).append("]]></max_amount>\r\n");
				valueXmlString.append("</Detail"+formNo+">\r\n" );
			}
			else if("sampleitem".equalsIgnoreCase(formName) || "retailersampleitem".equalsIgnoreCase(formName) || "stockistsampleitem".equalsIgnoreCase(formName) || "ncwsampleitem".equalsIgnoreCase(formName) )
			{
				//commented & adde by mrunalini sinakar foe sample item related changes on 01-feb-2019(start)

				/*sql = " SELECT ITEM.ITEM_CODE AS ITEM_CODE ,ITEM.DESCR AS DESCR, ITEM.SH_DESCR AS SH_DESCR, ITEM.UNIT AS ITEM_UNIT " +
						" FROM  ITEM ITEM "+
						"WHERE ITEM.ITEM_USAGE IN('S','G') "+
						"ORDER BY ITEM.SH_DESCR ";*/
				String itemMasterDataValue = getSfaParmValue(salesPers,"SHOW_SAMPLE_LIST",connectionObject);//Added for consider item form data on the basis of sfaparm  -30-Dec-2020
				
				
				String itemUSage="";
				String parmItemUsage = getSfaParmValue(salesPers,"SAMPLE_ITEM_USAGE",connectionObject);
				if(parmItemUsage!=null && parmItemUsage.trim().length()>0)
				{
					itemUSage=checkNull(getFormattedStringBuff( parmItemUsage ));
				}
				else
				{
					itemUSage="'G','S'";
				}
				String parmSampleVal = getSfaParmValue(salesPers,"SAMPLE_ALLOW",connectionObject);
				/*if( "E".equalsIgnoreCase(parmSampleVal) )
				{
					sql = "SELECT DISTINCT ITEM.ITEM_CODE AS ITEM_CODE ,ITEM.DESCR AS DESCR, ITEM.SH_DESCR AS SH_DESCR, ITEM.UNIT AS ITEM_UNIT,(CASE WHEN ITEM.ITEM_USAGE ='G' THEN 'GIFT' WHEN ITEM.ITEM_USAGE ='S' THEN 'SAMPLE'  END)AS ITEM_USAGE  FROM  ITEM ITEM, SAMPLE_INVTRACE SI"+
							" WHERE SI.ITEM_CODE = ITEM.ITEM_CODE AND SI.EMP_CODE = ? and SI.quantity > 0 ORDER BY ITEM_USAGE,ITEM.DESCR ";

				}
				else
				{*/
					int sampCnt=0;
					String cntSql ="SELECT COUNT(*) AS COUNT " +
							"  FROM ITEM ITEM,SPRS_ITEM SI WHERE ITEM.ITEM_CODE=SI.ITEM_CODE " +
							//"  AND  SI.STATUS='Y' " + 
							"  AND SI.SALES_PERS=? AND " +
							"  ITEM.ITEM_USAGE IN("+itemUSage+") ORDER BY ITEM.SH_DESCR ";

					pstmt = connectionObject.prepareStatement( cntSql );
					pstmt.setString(1, salesPers);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						sampCnt = rs.getInt("COUNT");
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					if(rs != null)
					{
						rs.close();
						rs = null;
					}
					// Added by Hariom S for Aldevis common promotion data should display [Start]
					String itemSeries = getProdItmSer(salesPers, connectionObject);

					int itemCnt=0;
					String itemSql ="SELECT COUNT(*) AS COUNT " +
							"FROM ITEM ITEM,SALES_PERS SP WHERE ITEM.ITEM_USAGE IN("+itemUSage+") AND ITEM.ITEM_SER=SP.ITEM_SER AND ITEM.ACTIVE='Y' "+
							"AND SP.SALES_PERS= ? ORDER BY ITEM.ITEM_USAGE,ITEM.DESCR ";
					pstmt = connectionObject.prepareStatement( itemSql );
					pstmt.setString(1, salesPers);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						itemCnt = rs.getInt("COUNT");
					}
					else
					{
						if(sampCnt>0)
						{
							itemCnt = 1;
						}
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					if(rs != null)
					{
						rs.close();
						rs = null;
					}
					// Added by Hariom S for Aldevis common promotion data should display [Start]
					//Added for consider item form data on the basis of sfaparm  -30-Dec-2020 [Start]
					if(itemMasterDataValue.trim().equalsIgnoreCase("1"))
					{
						/*
						sql ="SELECT ITEM.ITEM_CODE AS ITEM_CODE ,ITEM.DESCR AS DESCR, ITEM.SH_DESCR AS SH_DESCR, ITEM.UNIT AS ITEM_UNIT,(CASE WHEN ITEM.ITEM_USAGE ='G' THEN 'GIFT' WHEN ITEM.ITEM_USAGE ='S' THEN 'SAMPLE'  END)AS ITEM_USAGE " +
								"FROM ITEM ITEM,SALES_PERS SP WHERE ITEM.ITEM_USAGE IN("+itemUSage+") AND ITEM.ITEM_SER=SP.ITEM_SER AND ITEM.ACTIVE='Y' "+
								"AND SP.SALES_PERS= ? ORDER BY ITEM.ITEM_USAGE,ITEM.DESCR ";
						*///BY PRACHI ON 13JUNE2022 ID:W22CSUN019
						sql ="SELECT ITEM.ITEM_CODE AS ITEM_CODE ,ITEM.DESCR AS DESCR, ITEM.SH_DESCR AS SH_DESCR, ITEM.UNIT AS ITEM_UNIT,ITEM_USAGE AS ITEM_USAGE " +
								"FROM ITEM ITEM,SALES_PERS SP WHERE ITEM.ITEM_USAGE IN("+itemUSage+") AND ITEM.ITEM_SER=SP.ITEM_SER AND ITEM.ACTIVE='Y' "+
								"AND SP.SALES_PERS= ? ORDER BY ITEM.ITEM_USAGE,ITEM.DESCR ";
					}
					else if(itemMasterDataValue.trim().equalsIgnoreCase("2"))
					{
						/*
							sql ="SELECT ITEM.ITEM_CODE AS ITEM_CODE ,ITEM.DESCR AS DESCR, ITEM.SH_DESCR AS SH_DESCR, ITEM.UNIT AS ITEM_UNIT, " + 
									" (CASE WHEN ITEM.ITEM_USAGE ='G' THEN 'GIFT' WHEN ITEM.ITEM_USAGE ='S' THEN 'SAMPLE'  END)AS ITEM_USAGE FROM ITEM ITEM,SPRS_ITEM SI WHERE ITEM.ITEM_CODE=SI.ITEM_CODE " + 
									"  AND  SI.STATUS='Y' " + 
									"  AND SI.SALES_PERS=?  " + 
									"  AND (CASE WHEN SI.QUANTITY IS NULL THEN 0 ELSE SI.QUANTITY END - CASE WHEN SI.ISSUE_QTY IS NULL THEN 0 ELSE SI.ISSUE_QTY END ) > 0" + 
									"  AND ITEM.ITEM_USAGE IN("+itemUSage+") ORDER BY ITEM.ITEM_USAGE,ITEM.DESCR ";
							
							*///BY PRACHI ON 13JUNE2022 ID:W22CSUN019
						sql ="SELECT ITEM.ITEM_CODE AS ITEM_CODE ,ITEM.DESCR AS DESCR, ITEM.SH_DESCR AS SH_DESCR, ITEM.UNIT AS ITEM_UNIT, " + 
								" ITEM_USAGE AS ITEM_USAGE FROM ITEM ITEM,SPRS_ITEM SI WHERE ITEM.ITEM_CODE=SI.ITEM_CODE " + 
								"  AND  SI.STATUS='Y' " + 
								"  AND SI.SALES_PERS=?  " + 
								"  AND (CASE WHEN SI.QUANTITY IS NULL THEN 0 ELSE SI.QUANTITY END - CASE WHEN SI.ISSUE_QTY IS NULL THEN 0 ELSE SI.ISSUE_QTY END ) > 0" + 
								"  AND ITEM.ITEM_USAGE IN("+itemUSage+") ORDER BY ITEM.ITEM_USAGE,ITEM.DESCR ";	
					}
					else if(itemMasterDataValue.trim().equalsIgnoreCase("3"))
					{		
						/*
								sql ="SELECT ITEM.ITEM_CODE AS ITEM_CODE ,ITEM.DESCR AS DESCR, ITEM.SH_DESCR AS SH_DESCR, ITEM.UNIT AS ITEM_UNIT, " + 
										" (CASE WHEN ITEM.ITEM_USAGE ='G' THEN 'GIFT' WHEN ITEM.ITEM_USAGE ='S' THEN 'SAMPLE'  END)AS ITEM_USAGE FROM ITEM ITEM,SPRS_ITEM SI WHERE ITEM.ITEM_CODE=SI.ITEM_CODE " + 
										"  AND  SI.STATUS='Y' " + 
										"  AND SI.SALES_PERS=?  " + 
										"  AND ITEM.ITEM_USAGE IN("+itemUSage+") ORDER BY ITEM.ITEM_USAGE,ITEM.DESCR ";	
						*/	//BY PRACHI ON 13JUNE2022 ID:W22CSUN019	
								sql ="SELECT ITEM.ITEM_CODE AS ITEM_CODE ,ITEM.DESCR AS DESCR, ITEM.SH_DESCR AS SH_DESCR, ITEM.UNIT AS ITEM_UNIT, " + 
										"ITEM_USAGE AS ITEM_USAGE FROM ITEM ITEM,SPRS_ITEM SI WHERE ITEM.ITEM_CODE=SI.ITEM_CODE " + 
										"  AND  SI.STATUS='Y' " + 
										"  AND SI.SALES_PERS=?  " + 
										"  AND ITEM.ITEM_USAGE IN("+itemUSage+") ORDER BY ITEM.ITEM_USAGE,ITEM.DESCR ";	
					}
					else if(itemMasterDataValue.trim().equalsIgnoreCase("4"))
					{
						if(sampCnt>0)
						{
							if("C".equalsIgnoreCase(parmSampleVal) )
							{
								/*
								sql ="SELECT ITEM.ITEM_CODE AS ITEM_CODE ,ITEM.DESCR AS DESCR, ITEM.SH_DESCR AS SH_DESCR, ITEM.UNIT AS ITEM_UNIT, " + 
										" (CASE WHEN ITEM.ITEM_USAGE ='G' THEN 'GIFT' WHEN ITEM.ITEM_USAGE ='S' THEN 'SAMPLE'  END)AS ITEM_USAGE FROM ITEM ITEM,SPRS_ITEM SI WHERE ITEM.ITEM_CODE=SI.ITEM_CODE " + 
										"  AND  SI.STATUS='Y' " + 
										"  AND SI.SALES_PERS=?  " + 
										"  AND (CASE WHEN SI.QUANTITY IS NULL THEN 0 ELSE SI.QUANTITY END - CASE WHEN SI.ISSUE_QTY IS NULL THEN 0 ELSE SI.ISSUE_QTY END ) > 0" + 
										"  AND ITEM.ITEM_USAGE IN("+itemUSage+") ORDER BY ITEM.ITEM_USAGE,ITEM.DESCR ";
							    */
								//BY PRACHI ON 13JUNE2022 ID:W22CSUN019
								sql ="SELECT ITEM.ITEM_CODE AS ITEM_CODE ,ITEM.DESCR AS DESCR, ITEM.SH_DESCR AS SH_DESCR, ITEM.UNIT AS ITEM_UNIT, " + 
										" ITEM_USAGE AS ITEM_USAGE FROM ITEM ITEM,SPRS_ITEM SI WHERE ITEM.ITEM_CODE=SI.ITEM_CODE " + 
										"  AND  SI.STATUS='Y' " + 
										"  AND SI.SALES_PERS=?  " + 
										"  AND (CASE WHEN SI.QUANTITY IS NULL THEN 0 ELSE SI.QUANTITY END - CASE WHEN SI.ISSUE_QTY IS NULL THEN 0 ELSE SI.ISSUE_QTY END ) > 0" + 
										"  AND ITEM.ITEM_USAGE IN("+itemUSage+") ORDER BY ITEM.ITEM_USAGE,ITEM.DESCR ";
							}
							else
							{
								/*
								sql ="SELECT ITEM.ITEM_CODE AS ITEM_CODE ,ITEM.DESCR AS DESCR, ITEM.SH_DESCR AS SH_DESCR, ITEM.UNIT AS ITEM_UNIT, " +
										" (CASE WHEN ITEM.ITEM_USAGE ='G' THEN 'GIFT' WHEN ITEM.ITEM_USAGE ='S' THEN 'SAMPLE'  END)AS ITEM_USAGE FROM ITEM ITEM,SPRS_ITEM SI WHERE ITEM.ITEM_CODE=SI.ITEM_CODE " +
										"  AND ITEM.ACTIVE='Y' AND SI.STATUS='Y' " +
										"  AND SI.SALES_PERS=? AND " +
										"  ITEM.ITEM_USAGE IN("+itemUSage+") ORDER BY ITEM.ITEM_USAGE,ITEM.DESCR ";
								*///BY PRACHI ON 13JUNE2022 ID:W22CSUN019
								sql ="SELECT ITEM.ITEM_CODE AS ITEM_CODE ,ITEM.DESCR AS DESCR, ITEM.SH_DESCR AS SH_DESCR, ITEM.UNIT AS ITEM_UNIT, " +
										" ITEM_USAGE AS ITEM_USAGE FROM ITEM ITEM,SPRS_ITEM SI WHERE ITEM.ITEM_CODE=SI.ITEM_CODE " +
										"  AND ITEM.ACTIVE='Y' AND SI.STATUS='Y' " +
										"  AND SI.SALES_PERS=? AND " +
										"  ITEM.ITEM_USAGE IN("+itemUSage+") ORDER BY ITEM.ITEM_USAGE,ITEM.DESCR ";
							}
						}
						else
						{
							/*
							sql ="SELECT ITEM.ITEM_CODE AS ITEM_CODE ,ITEM.DESCR AS DESCR, ITEM.SH_DESCR AS SH_DESCR, ITEM.UNIT AS ITEM_UNIT,(CASE WHEN ITEM.ITEM_USAGE ='G' THEN 'GIFT' WHEN ITEM.ITEM_USAGE ='S' THEN 'SAMPLE'  END)AS ITEM_USAGE " +
									"FROM ITEM ITEM,SALES_PERS SP WHERE ITEM.ITEM_USAGE IN("+itemUSage+") AND ITEM.ITEM_SER=SP.ITEM_SER AND ITEM.ACTIVE='Y' "+
									"AND SP.SALES_PERS= ? ORDER BY ITEM.ITEM_USAGE,ITEM.DESCR ";
							*/
							//BY PRACHI ON 13JUNE2022 ID:W22CSUN019
							sql ="SELECT ITEM.ITEM_CODE AS ITEM_CODE ,ITEM.DESCR AS DESCR, ITEM.SH_DESCR AS SH_DESCR, ITEM.UNIT AS ITEM_UNIT,ITEM_USAGE AS ITEM_USAGE " +
									"FROM ITEM ITEM,SALES_PERS SP WHERE ITEM.ITEM_USAGE IN("+itemUSage+") AND ITEM.ITEM_SER=SP.ITEM_SER AND ITEM.ACTIVE='Y' "+
									"AND SP.SALES_PERS= ? ORDER BY ITEM.ITEM_USAGE,ITEM.DESCR ";
						}
					}
					else if(itemMasterDataValue.trim().equalsIgnoreCase("5"))
					{
						if(sampCnt > 0)
						{	
							/*
							sql ="SELECT ITEM.ITEM_CODE AS ITEM_CODE ,ITEM.DESCR AS DESCR, ITEM.SH_DESCR AS SH_DESCR, ITEM.UNIT AS ITEM_UNIT, " +
									" (CASE WHEN ITEM.ITEM_USAGE ='G' THEN 'GIFT' WHEN ITEM.ITEM_USAGE ='S' THEN 'SAMPLE'  END)AS ITEM_USAGE FROM ITEM ITEM,SPRS_ITEM SI WHERE ITEM.ITEM_CODE=SI.ITEM_CODE " +
									"  AND ITEM.ACTIVE='Y' AND SI.STATUS='Y' " +
									"  AND SI.SALES_PERS=? AND " +
									"  ITEM.ITEM_USAGE IN("+itemUSage+") ORDER BY ITEM.ITEM_USAGE,ITEM.DESCR ";
							*///BY PRACHI ON 13JUNE2022 ID:W22CSUN019
							sql ="SELECT ITEM.ITEM_CODE AS ITEM_CODE ,ITEM.DESCR AS DESCR, ITEM.SH_DESCR AS SH_DESCR, ITEM.UNIT AS ITEM_UNIT, " +
									"ITEM_USAGE AS ITEM_USAGE FROM ITEM ITEM,SPRS_ITEM SI WHERE ITEM.ITEM_CODE=SI.ITEM_CODE " +
									"  AND ITEM.ACTIVE='Y' AND SI.STATUS='Y' " +
									"  AND SI.SALES_PERS=? AND " +
									"  ITEM.ITEM_USAGE IN("+itemUSage+") ORDER BY ITEM.ITEM_USAGE,ITEM.DESCR ";
						}
						else
						{
							/*
							sql ="SELECT ITEM.ITEM_CODE AS ITEM_CODE ,ITEM.DESCR AS DESCR, ITEM.SH_DESCR AS SH_DESCR, ITEM.UNIT AS ITEM_UNIT,(CASE WHEN ITEM.ITEM_USAGE ='G' THEN 'GIFT' WHEN ITEM.ITEM_USAGE ='S' THEN 'SAMPLE'  END)AS ITEM_USAGE " +
									"FROM ITEM ITEM,SALES_PERS SP WHERE ITEM.ITEM_USAGE IN("+itemUSage+") AND ITEM.ITEM_SER=SP.ITEM_SER AND ITEM.ACTIVE='Y' "+
									"AND SP.SALES_PERS= ? ORDER BY ITEM.ITEM_USAGE,ITEM.DESCR ";
							*/
							//BY PRACHI ON 13JUNE2022 ID:W22CSUN019
							// Added by Hariom S for Aldevis common promotion data should display [Start]
							if(itemCnt > 0)
							{
								
								sql ="SELECT ITEM.ITEM_CODE AS ITEM_CODE ,ITEM.DESCR AS DESCR, ITEM.SH_DESCR AS SH_DESCR, ITEM.UNIT AS ITEM_UNIT,ITEM_USAGE AS ITEM_USAGE " +
										"FROM ITEM ITEM,SALES_PERS SP WHERE ITEM.ITEM_USAGE IN("+itemUSage+") AND ITEM.ITEM_SER=SP.ITEM_SER AND ITEM.ACTIVE='Y' "+
										"AND SP.SALES_PERS= ? ORDER BY ITEM.ITEM_USAGE,ITEM.DESCR ";
							}
							else
							{
								sql ="SELECT ITEM.ITEM_CODE AS ITEM_CODE ,ITEM.DESCR AS DESCR, ITEM.SH_DESCR AS SH_DESCR, ITEM.UNIT AS ITEM_UNIT, "+
										"ITEM_USAGE AS ITEM_USAGE " +
										"FROM ITEM ITEM WHERE ITEM.ITEM_USAGE IN("+itemUSage+") AND ITEM.ITEM_SER IN("+itemSeries+") " +
										" AND ITEM.ACTIVE='Y' ORDER BY ITEM.ITEM_USAGE,ITEM.DESCR ";
							}	
							// Added by Hariom S for Aldevis common promotion data should display [End]
						}
					}
					else if(itemMasterDataValue.trim().equalsIgnoreCase("6"))
					{								
							sql ="SELECT ITEM.ITEM_CODE AS ITEM_CODE ,ITEM.DESCR AS DESCR, ITEM.SH_DESCR AS SH_DESCR, ITEM.UNIT AS ITEM_UNIT, "+
									"ITEM_USAGE AS ITEM_USAGE " +
									"FROM ITEM ITEM WHERE ITEM.ITEM_USAGE IN("+itemUSage+") AND ITEM.ITEM_SER IN("+itemSeries+") " +
									" AND ITEM.ACTIVE='Y' ORDER BY ITEM.ITEM_USAGE,ITEM.DESCR ";
					}

					/*if(sampCnt>0)
					{
						if("C".equalsIgnoreCase(parmSampleVal) )
						{
							sql ="SELECT ITEM.ITEM_CODE AS ITEM_CODE ,ITEM.DESCR AS DESCR, ITEM.SH_DESCR AS SH_DESCR, ITEM.UNIT AS ITEM_UNIT, " + 
									" (CASE WHEN ITEM.ITEM_USAGE ='G' THEN 'GIFT' WHEN ITEM.ITEM_USAGE ='S' THEN 'SAMPLE'  END)AS ITEM_USAGE FROM ITEM ITEM,SPRS_ITEM SI WHERE ITEM.ITEM_CODE=SI.ITEM_CODE " + 
									"  AND  SI.STATUS='Y' " + 
									"  AND SI.SALES_PERS=?  " + 
									"  AND (CASE WHEN SI.QUANTITY IS NULL THEN 0 ELSE SI.QUANTITY END - CASE WHEN SI.ISSUE_QTY IS NULL THEN 0 ELSE SI.ISSUE_QTY END ) > 0" + 
									"  AND ITEM.ITEM_USAGE IN("+itemUSage+") ORDER BY ITEM.ITEM_USAGE,ITEM.DESCR ";
						}
						else
						{
						sql ="SELECT ITEM.ITEM_CODE AS ITEM_CODE ,ITEM.DESCR AS DESCR, ITEM.SH_DESCR AS SH_DESCR, ITEM.UNIT AS ITEM_UNIT, " +
								" (CASE WHEN ITEM.ITEM_USAGE ='G' THEN 'GIFT' WHEN ITEM.ITEM_USAGE ='S' THEN 'SAMPLE'  END)AS ITEM_USAGE FROM ITEM ITEM,SPRS_ITEM SI WHERE ITEM.ITEM_CODE=SI.ITEM_CODE " +
								"  AND ITEM.ACTIVE='Y' AND SI.STATUS='Y' " +
								"  AND SI.SALES_PERS=? AND " +
								"  ITEM.ITEM_USAGE IN("+itemUSage+") ORDER BY ITEM.ITEM_USAGE,ITEM.DESCR ";
					}

					}
					else
					{
						sql ="SELECT ITEM.ITEM_CODE AS ITEM_CODE ,ITEM.DESCR AS DESCR, ITEM.SH_DESCR AS SH_DESCR, ITEM.UNIT AS ITEM_UNIT,(CASE WHEN ITEM.ITEM_USAGE ='G' THEN 'GIFT' WHEN ITEM.ITEM_USAGE ='S' THEN 'SAMPLE'  END)AS ITEM_USAGE " +
								"FROM ITEM ITEM,SALES_PERS SP WHERE ITEM.ITEM_USAGE IN("+itemUSage+") AND ITEM.ITEM_SER=SP.ITEM_SER AND ITEM.ACTIVE='Y' "+
								"AND SP.SALES_PERS= ? ORDER BY ITEM.ITEM_USAGE,ITEM.DESCR ";

					}*/
			//	}
					//Added for consider item form data on the basis of sfaparm  -30-Dec-2020 [End]

				//commented & adde by mrunalini sinakar foe sample item related changes on 01-feb-2019(end)

				String parmVal = getSfaParmValue(salesPers,"IS_SAMPLE_ALLOW",connectionObject);
				ArrayList mapList = new ArrayList();
				//if( "Y".equalsIgnoreCase(parmVal) )
				if( "E".equalsIgnoreCase(parmSampleVal))
				{

					mapList = getsampleItemStockDetails(connectionObject, salesPers, currDate, "" ,formNo);
				}
				// Added by Ashutosh on 10-11-17 [END]
				HashMap currSampleItemStockMap = new HashMap();
				HashMap sampleItemIssueMap = new HashMap();
				HashMap openingStockMap = new HashMap();
				HashMap itemDescrMap = new HashMap();
				HashMap sampleItemCurrStockMap = new HashMap();
				if(mapList != null && !mapList.isEmpty())
				{
					currSampleItemStockMap = (HashMap)mapList.get(0);
					sampleItemIssueMap = (HashMap)mapList.get(1);
					openingStockMap = (HashMap)mapList.get(2);
					itemDescrMap = (HashMap)mapList.get(3);
					sampleItemCurrStockMap = (HashMap)mapList.get(4);
				}

				String maxSampleAllow = getMaxSampleAllow(connectionObject);
				String currStockQty = "0";


				int num=1;
				pstmt =  connectionObject.prepareStatement(sql);
				if((! itemMasterDataValue.trim().equalsIgnoreCase("6")) && itemCnt > 0)
				{
					pstmt.setString(1, salesPers);
				}
				rs = pstmt.executeQuery();
				itemUsageMap = darCommonBean.getItemUsageData(connectionObject);
				while(rs.next())
				{
					String itemCode = checkNull(rs.getString("ITEM_CODE"));
					String itemUnit = checkNull(rs.getString("ITEM_UNIT"));
					String itemDescr = checkNull(rs.getString("DESCR"));
					String itemShDescr = checkNull(rs.getString("SH_DESCR"));
					String itemUsage = checkNull(rs.getString("ITEM_USAGE"));

					//BY PRACHI ON 13JUNE2022 ID:W22CSUN019
					String descr="";
					if ( itemUsageMap.get( (rs.getString("ITEM_USAGE")).trim()) != null )
					{
						descr=itemUsageMap.get((rs.getString("ITEM_USAGE")).trim());
						System.out.println("descr is::["+descr+"]");
					}
					//end
					
					String tranID = "";
					if("E".equalsIgnoreCase(parmSampleVal))
					{
						if(openingStockMap != null && openingStockMap.size() > 0 && openingStockMap.containsKey(itemCode))
						{
							valueXmlString.append("<Detail"+formNo+" domID='"+num+"' selected = 'N' formName='"+formName+"'>\r\n" );
							valueXmlString.append("<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");							valueXmlString.append("<item_code><![CDATA[").append( rs.getString("ITEM_CODE") ).append("]]></item_code>\r\n");
							valueXmlString.append("<tooltip_descr><![CDATA[").append(itemDescr).append("]]></tooltip_descr>\r\n");
							valueXmlString.append("<line_no><![CDATA["+num+"]]></line_no>\r\n");
							valueXmlString.append("<dcr_id><![CDATA[").append( "" ).append("]]></dcr_id>\r\n");
							valueXmlString.append("<sales_pers><![CDATA[").append(salesPers).append("]]></sales_pers>\r\n");
							//valueXmlString.append("<strg_code><![CDATA[").append( strgCode ).append("]]></strg_code>\r\n");
							valueXmlString.append("<strg_code><![CDATA[").append( "" ).append("]]></strg_code>\r\n");
							valueXmlString.append("<quantity><![CDATA[").append( "" ).append("]]></quantity>\r\n");
							valueXmlString.append("<item_descr><![CDATA[").append(rs.getString("DESCR")).append("]]></item_descr>\r\n");
							valueXmlString.append("<item_unit><![CDATA[").append(itemUnit).append("]]></item_unit>\r\n");
							valueXmlString.append( "<tran_id><![CDATA[" ).append("").append( "]]></tran_id>\r\n" );//Gulzar on 04/07/17
							valueXmlString.append("<max_sample_allow><![CDATA[").append( maxSampleAllow ).append("]]></max_sample_allow>\r\n");
							valueXmlString.append("<opening_stock_qty><![CDATA[" ).append( openingStockMap.get(itemCode) ).append( "]]></opening_stock_qty>\r\n" );
							//valueXmlString.append("<item_usage><![CDATA[").append( checkNull(rs.getString("ITEM_USAGE"))).append("]]></item_usage>\r\n");
							//CHANGES BY PRACHI ON 13JUNE2022 ID:W22CSUN019
							valueXmlString.append("<item_usage><![CDATA[").append(descr).append("]]></item_usage>\r\n");

							if(currSampleItemStockMap != null && currSampleItemStockMap.size() > 0 && currSampleItemStockMap.containsKey(itemCode))
							{
								valueXmlString.append("<curr_stock_qty><![CDATA[" ).append( currSampleItemStockMap.get(itemCode) ).append( "]]></curr_stock_qty>\r\n" );
							}
							if(sampleItemIssueMap != null && sampleItemIssueMap.size() > 0 && sampleItemIssueMap.containsKey(itemCode))
							{
								valueXmlString.append("<sample_issue_qty><![CDATA[" ).append( sampleItemIssueMap.get(itemCode) ).append( "]]></sample_issue_qty>\r\n" );
							}
							else
							{
								valueXmlString.append("<sample_issue_qty><![CDATA[0]]></sample_issue_qty>\r\n" );
							}
							if(sampleItemCurrStockMap != null && sampleItemCurrStockMap.size() > 0 && sampleItemCurrStockMap.containsKey(itemCode))
			