
package ibase.webitm.ejb.wsfa.transactions;

import java.rmi.RemoteException;
import java.util.*;
import java.util.Date;
import java.text.DateFormat;
import java.sql.*;

import javax.ejb.*;
import javax.naming.InitialContext;
import org.w3c.dom.*;
import javax.xml.parsers.*;
import java.text.SimpleDateFormat;
import ibase.webitm.ejb.*;
import ibase.webitm.utility.*;
import ibase.system.config.*;
import ibase.webitm.utility.ITMException;
//import ibase.webitm.utility.GenericUtility;
import ibase.utility.E12GenericUtility;
import ibase.utility.CommonConstants;
//@javax.ejb.Stateless		commented by Sagar M [22 Nov 2018].

public class SalesPersCMEWizPreSaveEJB extends ValidatorEJB
{
	public String preSave()throws RemoteException,ITMException
	{
		return "";
	}


	public String preSave( String domString, String editFlag, String xtraParams,Connection conn ) throws RemoteException,ITMException
	{
		String retString = "";
		String objName = "";
		String eventDate = "";
		String sprsCode = "";
		PreparedStatement pStmtOuter = null;
		Document dom = null;

		boolean isError = false;
		boolean isLocalConn = false;

		try
		{

			isLocalConn = true;
			//changed by Rahul Barve on 3-sep-2014
			//GenericUtility genericUtility = GenericUtility.getInstance();
			 E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

			dom = genericUtility.parseString(domString);
			objName  = getObjNameFromDom( dom, "objName");
			System.out.println("objName["+objName+"]");
			System.out.println("domString StrgMeetWizPreSaveEJB ["+domString+"]");
			eventDate = genericUtility.getColumnValue("event_date", dom, "1", "");
			sprsCode = genericUtility.getColumnValue("sales_pers", dom, "1", "");
			System.out.println("salesPers [" + sprsCode + "]   travelDate [" + eventDate + "]");

			int updateCnt = 0;
			String sql = "SELECT COUNT(1) COUNT, DCR_ID FROM SPRS_ACT_TRAN WHERE SALES_PERS = ? AND EVENT_DATE = ? GROUP BY DCR_ID";
			System.out.println(" sql for checking previous record exists or not["+sql+"]");
			pStmtOuter = conn.prepareStatement( sql );
			pStmtOuter.setString( 1, sprsCode);
			pStmtOuter.setTimestamp( 2, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( eventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
			ResultSet recExist = pStmtOuter.executeQuery();
			while ( recExist.next() )
			{
				String dcrId = checkNull( recExist.getString("DCR_ID") );
				System.out.println("DCR_ID to be deleted [" + dcrId + "]");
				sql = "DELETE FROM SPRS_ACT_TRAN WHERE DCR_ID = ?";
				System.out.println(" Delete if record exist["+sql+"]");
				PreparedStatement pStmt = conn.prepareStatement( sql );
				pStmt.setString( 1, dcrId);
				updateCnt = pStmt.executeUpdate();
				pStmt.close(); pStmt = null;
				System.out.println("[StrgMeetWizPreSaveEJB]Update Count for deleting from sprs_act_tran:"+updateCnt);

				sql = "DELETE FROM SPRS_TRAVEL WHERE DCR_ID = ?";
				pStmt = conn.prepareStatement( sql );
				pStmt.setString( 1, dcrId);
				updateCnt = pStmt.executeUpdate();
				pStmt.close(); pStmt = null;
				System.out.println("[StrgMeetWizPreSaveEJB]Update Count for deleting from sprs_travel:"+updateCnt);


				sql = "DELETE FROM MKT_EVENT WHERE DCR_ID = ?";
				pStmt = conn.prepareStatement( sql );
				pStmt.setString( 1, dcrId);
				updateCnt = pStmt.executeUpdate();
				pStmt.close(); pStmt = null;
				System.out.println("[StrgMeetWizPreSaveEJB]Update Count for deleting from strg_meet:"+updateCnt);


				sql = "DELETE FROM MKT_EVENT_PARTICIPANT WHERE DCR_ID = ?";
				pStmt = conn.prepareStatement( sql );
				pStmt.setString( 1, dcrId);
				updateCnt = pStmt.executeUpdate();
				pStmt.close(); pStmt = null;
				System.out.println("[StrgMeetWizPreSaveEJB]Update Count for deleting from strg_meet_items:"+updateCnt);


				//Delete from old DCR tables based on the properties value
				String propValue = getPropertiesVal(conn, "DELETE_FROM_OLD_DCR_TABLES");
				if("Y".equalsIgnoreCase(propValue))
				{
					String deleteDrMainSql = "DELETE FROM DR_MAIN WHERE SALES_PERS= ? AND WORK_DATE=? ";
					pStmt =  conn.prepareStatement(deleteDrMainSql);
					pStmt.setString(1, sprsCode);
					pStmt.setTimestamp(2 ,java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString(eventDate,genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat())));
					pStmt.executeUpdate();
					pStmt.close(); pStmt = null;

					String deleteTravelDetailSql="DELETE FROM DR_TRAVEL_DETAILS WHERE SALES_PERS= ? AND WORK_DATE=? ";
					pStmt =  conn.prepareStatement(deleteTravelDetailSql);
					pStmt.setString(1, sprsCode);
					pStmt.setTimestamp(2, java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString(eventDate,genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat())));
					pStmt.executeUpdate();
					pStmt.close(); pStmt = null;


					//String deleteDrChemistVisitSql="DELETE FROM DR_CHEMIST_VISIT WHERE DCR_ID = ? ";
					String deleteDrDoctorVisitSql="DELETE FROM DR_DOCTOR_VISIT WHERE SALES_PERS= ?  AND WORK_DATE=?  ";
					pStmt =  conn.prepareStatement(deleteDrDoctorVisitSql);
					pStmt.setString(1, sprsCode);
					pStmt.setTimestamp(2, java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString(eventDate,genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat())));
					pStmt.executeUpdate();
					pStmt.close(); pStmt = null;

					String deleteDrSampleDistributedSql="DELETE FROM DR_SAMPLE_DISTRIBUTED WHERE SALES_PERS = ?  AND WORK_DATE=? ";
					pStmt =  conn.prepareStatement(deleteDrSampleDistributedSql);
					pStmt.setString(1, sprsCode);
					pStmt.setTimestamp(2, java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString(eventDate,genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat())));
					pStmt.executeUpdate();
					pStmt.close(); pStmt = null;
				}
				//End changes by Gulzar on 07/12/12
			}
			if(recExist != null)
			{
				recExist.close();
				recExist = null;
			}

		}
		catch(Exception e)
		{
			System.out.println("Exception :StrgMeetWizPreSaveEJB : :==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			try
			{

				if(pStmtOuter != null)
				{
					pStmtOuter.close();
					pStmtOuter = null;
				}
			}
			catch(Exception e)
			{
				System.out.println("Exception :StrgMeetWizPreSaveEJB : :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		System.out.println("Return string :"+retString);
		return retString;
	}

	private String getObjNameFromDom( Document dom, String attribute ) throws RemoteException,ITMException
	{
		String objName = "";
		try
		{
			NodeList detailList = null;
			Node currDetail = null,reqDetail = null;
			int	detailListLength = 0;

			detailList = dom.getElementsByTagName("Detail1");
			detailListLength = detailList.getLength();
			for (int ctr = 0;ctr < detailListLength;ctr++)
			{
				currDetail = detailList.item(ctr);
				objName = currDetail.getAttributes().getNamedItem(attribute).getNodeValue();

			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		return objName;
	}

	public String checkNull(String input)
	{
		if (input == null || "null".equalsIgnoreCase(input))
		{
			input= "";
		}
		return input.trim();
	}
	private String getPropertiesVal(Connection conn, String propName) throws Exception
	{
		String propVal = "";
		PreparedStatement pstmtProp = null;
		ResultSet rsProp = null;
		try
		{
			String propSql = "SELECT PROP_VALUE FROM PROPERTIES WHERE PROP_NAME = ?";
			pstmtProp = conn.prepareStatement(propSql);
			pstmtProp.setString(1,propName);
			rsProp = pstmtProp.executeQuery();
			if(rsProp.next())
			{
				propVal = (rsProp.getString("PROP_VALUE") == null) ?"":rsProp.getString("PROP_VALUE");
			}
		}
		catch(Exception e)
		{
			throw e;
		}
		finally
		{
			try
			{
				if(rsProp != null)
				{
					rsProp.close(); rsProp = null;
				}
				if(pstmtProp != null)
				{
					pstmtProp.close(); pstmtProp = null;
				}
			}
			catch(Exception e){}
		}
		System.out.println("propVal for "+propName+" =["+propVal+"]");
		return propVal;
	}

}
