/*
 * Decompiled with CFR 0.152.
 */
package ibase.wrkflw;

import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseException;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.EMail;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.wrkflw.WorkflowEngineEJB;
import ibase.wrkflw.WorkflowProcessDataMangerEJB;
import ibase.wrkflw.WorkflowProcessInstanceMonitorLocal;
import ibase.wrkflw.WorkflowProcessInstanceMonitorRemote;
import ibase.wrkflw.metadata.Activity;
import ibase.wrkflw.metadata.Application;
import ibase.wrkflw.metadata.ExtendedAttribute;
import ibase.wrkflw.metadata.ExtendedAttributes;
import ibase.wrkflw.metadata.Implementation;
import ibase.wrkflw.metadata.Tool;
import ibase.wrkflw.metadata.WorkflowProcess;
import ibase.wrkflw.schedule.WorkflowShedule;
import ibase.wrkflw.utility.WorkflowLogger;
import ibase.wrkflw.utility.WorkflowMetaDataManager;
import ibase.wrkflw.utility.WorkflowProcessIdGenerator;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;
import javax.naming.InitialContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.io.FileUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXParseException;

@Stateless
public class WorkflowProcessInstanceMonitorEJB
implements WorkflowProcessInstanceMonitorLocal,
WorkflowProcessInstanceMonitorRemote {
    SessionContext cSessionContext;
    String sysdateStr = "";
    Connection commonCon = null;
    StringBuffer logMessageBuf = new StringBuffer();
    private UserInfoBean userInfo = null;

    public UserInfoBean getUserInfo() {
        return this.userInfo;
    }

    public void setUserInfo(UserInfoBean userInfo) {
        this.userInfo = userInfo;
    }

    public WorkflowProcessInstanceMonitorEJB() {
        try {
            if (CommonConstants.TOMCAT_HOME == null || CommonConstants.TOMCAT_HOME.trim().length() == 0) {
                CommonConstants.setIBASEHOME();
            }
            this.sysdateStr = "DB2".equalsIgnoreCase(CommonConstants.DB_NAME) ? "fn_sysdate()" : ("mssql".equalsIgnoreCase(CommonConstants.DB_NAME) ? " getdate() " : " sysdate ");
        }
        catch (Exception e) {
            WorkflowLogger.info("Exception :WorkflowProcessInstanceMonitorEJB :ejbCreate :==>" + e);
        }
    }

    @PostConstruct
    public void ejbCreate() {
        try {
            if (CommonConstants.TOMCAT_HOME == null || CommonConstants.TOMCAT_HOME.trim().length() == 0) {
                CommonConstants.setIBASEHOME();
            }
            this.sysdateStr = "DB2".equalsIgnoreCase(CommonConstants.DB_NAME) ? "fn_sysdate()" : ("mssql".equalsIgnoreCase(CommonConstants.DB_NAME) ? " getdate() " : " sysdate ");
        }
        catch (Exception e) {
            WorkflowLogger.info("Exception :WorkflowProcessInstanceMonitorEJB :ejbCreate :==>" + e);
        }
    }

    public void ejbRemove() {
    }

    public void ejbActivate() {
    }

    public void ejbPassivate() {
    }

    public void setSessionContext(SessionContext mSessionContext) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String createProcessInstance(String processId, String objName, String refSer, String refId, String roleCodeInit, String entityCodeInit, String processInputXML, Connection remoteCon) throws RemoteException, BaseException {
        WorkflowLogger.info("WorkflowProcessInstanceMonitorEJB.createProcessInstance.SCHEDULER_INVOCATION_CTR [" + WorkflowShedule.SCHEDULER_INVOCATION_CTR + "]");
        this.logMessageBuf.append("\nWorkflowProcessInstanceMonitorEJB.createProcessInstance.SCHEDULER_INVOCATION_CTR [" + WorkflowShedule.SCHEDULER_INVOCATION_CTR + "]");
        String processInstanceId = "";
        Connection con = null;
        Statement pstmt = null;
        Statement proc = null;
        String isComplete = "false";
        E12GenericUtility genericUtility = new E12GenericUtility();
        int instanceId = 0;
        boolean isLocalConn = false;
        boolean isException = false;
        boolean isError = false;
        boolean isRecordLocked = false;
        String errorCode = "";
        try {
            try {
                WorkflowLogger.info("Create Process Instance for Process Id :[" + processId + "]");
                this.logMessageBuf.append("\nCreate Process Instance for Process Id :[" + processId + "], \nobjName =[" + objName + "], \nrefSer =[" + refSer + "], \nrefId =[" + refId + "], \nroleCodeInit =[" + roleCodeInit + "], \nentityCodeInit=[" + entityCodeInit + "]");
                this.logMessageBuf.append("\n" + processInputXML);
                this.logMessageBuf.append("\nisProcessMetadataExists(processId) is called ");
                if (!WorkflowMetaDataManager.getInstance().isProcessMetadataExists(processId)) {
                    con.rollback();
                    this.logMessageBuf.append("\nisProcessMetadataExists(" + processId + ") = false");
                    this.logMessageBuf.append("\nProcess Metadata does not exists.....");
                    isError = true;
                    errorCode = "WFERROR3";
                    throw new Exception("Process Metadata does not exists");
                }
                this.logMessageBuf.append("\nisProcessMetadataExists(" + processId + ") = true");
                WorkflowProcessDataMangerEJB workflowProcessDataManger = new WorkflowProcessDataMangerEJB();
                if (remoteCon != null) {
                    con = remoteCon;
                } else {
                    con = this.getConnection();
                    isLocalConn = true;
                    this.logMessageBuf.append("\nisLocalConn =[" + isLocalConn + "]");
                }
                if ("P".equalsIgnoreCase(this.getProcessStatus(processId, objName, refSer, refId, con))) {
                    this.logMessageBuf.append("\nCan't invoke Workflow, process initiated for current Transaction");
                    isError = true;
                    errorCode = "WFERROR2";
                    throw new Exception("Can't invoke Workflow, process initiated for current Transaction");
                }
                processInstanceId = WorkflowProcessIdGenerator.getInstance().createProcessId(processId);
                String maxInstSelQry = null;
                if ("db2".equalsIgnoreCase(CommonConstants.DB_NAME)) {
                    maxInstSelQry = "SELECT NEXTVAL FOR WF_INSTANCE_SEQ FROM DUAL";
                } else if ("mssql".equalsIgnoreCase(CommonConstants.DB_NAME)) {
                    proc = con.prepareCall("{ CALL GENERATESEQID() }");
                    proc.execute();
                    proc.close();
                    proc = null;
                    maxInstSelQry = "SELECT SEQ_ID FROM WRKFLWSEQTBL";
                } else {
                    maxInstSelQry = "SELECT WF_INSTANCE_SEQ.NEXTVAL FROM DUAL";
                }
                this.logMessageBuf.append("\nmaxInstSelQry =[" + maxInstSelQry + "]");
                pstmt = con.prepareStatement(maxInstSelQry);
                ResultSet rs = pstmt.executeQuery();
                if (rs.next()) {
                    instanceId = rs.getInt(1);
                }
                this.logMessageBuf.append("\nmax instanceId found for process_id [" + processId + "] is [" + instanceId + "]");
                WorkflowLogger.info(" max instanceId found for process_id [" + processId + "] is [" + instanceId + "]");
                rs.close();
                rs = null;
                pstmt.close();
                pstmt = null;
                WorkflowLogger.info("createProcessInstance refId [" + refId + "]");
                if (refId == null || refId != null && (refId.trim().length() == 0 || refId.equalsIgnoreCase("null"))) {
                    refId = String.valueOf(processId) + ":" + instanceId + ":" + processId;
                    WorkflowLogger.info("Created refId [" + refId + "]");
                }
                this.logMessageBuf.append("\nBefore inserting into WF_PRC_STATUS checkProcessInstanceStatus is called....");
                this.checkProcessInstanceStatus(processId, refId, refSer, con);
                BaseLogger.log("3", null, null, "WorkflowProcessInstanceMonitorEJB : createProcessInstance");
                String activityDescr = WorkflowMetaDataManager.getInstance().getActivityName(processId, processId);
                BaseLogger.log("3", null, null, "createProcessInstance : activityDescr = [" + activityDescr + "]");
                BaseLogger.log("3", null, null, "sysdateStr : " + this.sysdateStr);
                String createPrcInsQry = "INSERT INTO WF_PRC_STATUS(PROCESS_ID,INSTANCE_ID,ACTIVITY_ID,PROCESS_STATUS,STATUS_DATE,ROLE_CODE__INIT,ENTITY_CODE__INIT,OBJ_NAME,REF_SER,REF_ID,PREVIOUS_ACTIVITY,SEQ_ID,ACTIVITY_DESCR) VALUES ('" + processId + "'," + instanceId + ",'" + processId + "',0, " + this.sysdateStr + " ,'" + roleCodeInit + "','" + entityCodeInit + "','" + objName + "','" + refSer + "','" + refId + "','" + processId + "',1,'" + activityDescr + "')";
                this.logMessageBuf.append("\nCreate Process Instance Insert Query :[" + createPrcInsQry + "]");
                WorkflowLogger.info("Create Process Instance Insert Query :[" + createPrcInsQry + "]");
                pstmt = con.prepareStatement(createPrcInsQry);
                int noOfRowsInserted = pstmt.executeUpdate();
                this.logMessageBuf.append("\nnoOfRowsInserted in WF_PRC_STATUS :[" + noOfRowsInserted + "]");
                pstmt.close();
                pstmt = null;
                WorkflowLogger.info("\n@@@@@@@@ Saving with Inserting ................ noOfRowsInserted " + noOfRowsInserted + "]");
                this.logMessageBuf.append("\nworkflowProcessDataManger.saveProcessInputData(processId, instanceId, processInputXML, con) is called to insert into WF_PRC_DATA....");
                isComplete = workflowProcessDataManger.saveProcessInputData(processId, instanceId, processInputXML, con, refSer, refId);
                this.logMessageBuf.append("\nisComplete :[" + isComplete + "]");
                if (!isComplete.equalsIgnoreCase("true")) {
                    con.rollback();
                    this.logMessageBuf.append("\nFailed to invoke Workflow, Please re-save the transaction");
                    isError = true;
                    errorCode = "WFERROR1";
                    throw new Exception("Failed to invoke Workflow, Please re-save the transaction");
                }
                boolean isWfComplete = false;
                isWfComplete = this.checkForWorkflowEntry(con, processId, instanceId, refId);
                this.logMessageBuf.append("\nisWfComplete =[" + isWfComplete + "]");
                if (isWfComplete) return processInstanceId;
                isError = true;
                errorCode = "WFERROR4";
                return processInstanceId;
            }
            catch (SQLException sqe) {
                try {
                    isException = true;
                    String errMSg = sqe.getMessage();
                    if (errMSg.contains("Error Code: 1205") || errMSg.contains("SQLCODE: -911") || errMSg.contains("ORA-00054")) {
                        isRecordLocked = true;
                        errorCode = "ROWLOCKED";
                    }
                    StringWriter writerStr = new StringWriter();
                    PrintWriter traceWriter = new PrintWriter(writerStr);
                    sqe.printStackTrace(traceWriter);
                    String stackTraceStr = writerStr.toString();
                    this.logMessageBuf.append("\ncreateProcessInstance >> BaseException occurs.......... ::START");
                    this.logMessageBuf.append("\nstackTraceStr ::" + stackTraceStr);
                    this.logMessageBuf.append("\ncreateProcessInstance >> BaseException occurs.......... ::END");
                    throw new BaseException(sqe);
                }
                catch (Exception ee) {
                    throw new BaseException(ee);
                }
            }
            catch (BaseException be) {
                try {
                    isException = true;
                    String errMSg = be.getMessage();
                    if (errMSg.contains("Error Code: 1205") || errMSg.contains("SQLCODE: -911") || errMSg.contains("ORA-00054")) {
                        isRecordLocked = true;
                        errorCode = "ROWLOCKED";
                    }
                    StringWriter writerStr = new StringWriter();
                    PrintWriter traceWriter = new PrintWriter(writerStr);
                    be.printStackTrace(traceWriter);
                    String stackTraceStr = writerStr.toString();
                    this.logMessageBuf.append("\ncreateProcessInstance >> BaseException occurs.......... ::START");
                    this.logMessageBuf.append("\nstackTraceStr ::" + stackTraceStr);
                    this.logMessageBuf.append("\ncreateProcessInstance >> BaseException occurs.......... ::END");
                    throw be;
                }
                catch (Exception ee) {
                    throw new BaseException(ee);
                }
            }
            catch (Exception e) {
                try {
                    isException = true;
                    String errMSg = e.getMessage();
                    if (errMSg.contains("Error Code: 1205") || errMSg.contains("SQLCODE: -911") || errMSg.contains("ORA-00054")) {
                        isRecordLocked = true;
                        errorCode = "ROWLOCKED";
                    }
                    StringWriter writerStr = new StringWriter();
                    PrintWriter traceWriter = new PrintWriter(writerStr);
                    e.printStackTrace(traceWriter);
                    String stackTraceStr = writerStr.toString();
                    this.logMessageBuf.append("\ncreateProcessInstance >> Exception occurs.......... ::START");
                    this.logMessageBuf.append("\nstackTraceStr ::" + stackTraceStr);
                    this.logMessageBuf.append("\ncreateProcessInstance >> Exception occurs.......... ::END");
                    if (!isError) {
                        throw new BaseException(e);
                    }
                }
                catch (Exception ee) {
                    throw new BaseException(ee);
                }
                try {
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (con != null) {
                        if (proc != null) {
                            proc.close();
                            proc = null;
                        }
                        if (!con.isClosed() && isLocalConn) {
                            if (isException) {
                                con.rollback();
                            } else {
                                con.commit();
                            }
                            con.close();
                            con = null;
                        }
                    }
                    this.logMessageBuf.append("\nisError =[" + isError + "]");
                    if (isError) {
                        ITMDBAccessEJB itmDBAccessComp = new ITMDBAccessEJB();
                        processInstanceId = itmDBAccessComp.getErrorString("", errorCode, " ");
                        this.logMessageBuf.append("\nError String =[" + processInstanceId + "]");
                        itmDBAccessComp = null;
                    }
                    if (!isError) {
                        if (!isException) return processInstanceId;
                    }
                    try {
                        BufferedWriter logFileWriter = null;
                        String logString = "";
                        String logFileName = String.valueOf(processId) + ":" + refId + ":" + System.currentTimeMillis();
                        logFileName = String.valueOf(CommonConstants.JBOSSHOME) + "log" + File.separator + logFileName + ".txt";
                        this.logMessageBuf.append("\nlogFileName =[" + logFileName + "]");
                        this.logMessageBuf.append("\n Previous directory path =[" + CommonConstants.JBOSSHOME + File.separator + "log" + "]");
                        this.logMessageBuf.append("\n Previous logFilePath =[" + CommonConstants.JBOSSHOME + File.separator + "log" + File.separator + logFileName + ".txt" + "]");
                        logString = this.logMessageBuf.toString();
                        BaseLogger.log("3", null, null, "logString ::" + logString);
                        if (!new File(String.valueOf(CommonConstants.JBOSSHOME) + "log").exists()) {
                            new File(String.valueOf(CommonConstants.JBOSSHOME) + "log").mkdirs();
                        }
                        if (!new File(String.valueOf(CommonConstants.JBOSSHOME) + "log" + File.separator + logFileName + ".txt").exists()) {
                            new File(logFileName).createNewFile();
                        }
                        logFileWriter = new BufferedWriter(new FileWriter(logFileName));
                        logFileWriter.newLine();
                        logFileWriter.write(logString);
                        File makeReadOnly = new File(logFileName);
                        if (makeReadOnly.canWrite()) {
                            makeReadOnly.setReadOnly();
                        }
                        logFileWriter.flush();
                        logFileWriter.close();
                        logFileWriter = null;
                        return processInstanceId;
                    }
                    catch (Exception e2) {
                        BaseLogger.log("0", null, null, "BaseException in Workflow ProcessInstanceMonitorEJB ::607::[" + e2.getMessage() + "]");
                        throw new BaseException(e2);
                    }
                }
                catch (Exception e3) {
                    throw new BaseException(e3);
                }
            }
        }
        finally {
            block61: {
                try {
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (con != null) {
                        if (proc != null) {
                            proc.close();
                            proc = null;
                        }
                        if (!con.isClosed() && isLocalConn) {
                            if (isException) {
                                con.rollback();
                            } else {
                                con.commit();
                            }
                            con.close();
                            con = null;
                        }
                    }
                    this.logMessageBuf.append("\nisError =[" + isError + "]");
                    if (isError) {
                        ITMDBAccessEJB itmDBAccessComp = new ITMDBAccessEJB();
                        processInstanceId = itmDBAccessComp.getErrorString("", errorCode, " ");
                        this.logMessageBuf.append("\nError String =[" + processInstanceId + "]");
                        itmDBAccessComp = null;
                    }
                    if (!isError && !isException) break block61;
                    try {
                        BufferedWriter logFileWriter = null;
                        String logString = "";
                        String logFileName = String.valueOf(processId) + ":" + refId + ":" + System.currentTimeMillis();
                        logFileName = String.valueOf(CommonConstants.JBOSSHOME) + "log" + File.separator + logFileName + ".txt";
                        this.logMessageBuf.append("\nlogFileName =[" + logFileName + "]");
                        this.logMessageBuf.append("\n Previous directory path =[" + CommonConstants.JBOSSHOME + File.separator + "log" + "]");
                        this.logMessageBuf.append("\n Previous logFilePath =[" + CommonConstants.JBOSSHOME + File.separator + "log" + File.separator + logFileName + ".txt" + "]");
                        logString = this.logMessageBuf.toString();
                        BaseLogger.log("3", null, null, "logString ::" + logString);
                        if (!new File(String.valueOf(CommonConstants.JBOSSHOME) + "log").exists()) {
                            new File(String.valueOf(CommonConstants.JBOSSHOME) + "log").mkdirs();
                        }
                        if (!new File(String.valueOf(CommonConstants.JBOSSHOME) + "log" + File.separator + logFileName + ".txt").exists()) {
                            new File(logFileName).createNewFile();
                        }
                        logFileWriter = new BufferedWriter(new FileWriter(logFileName));
                        logFileWriter.newLine();
                        logFileWriter.write(logString);
                        File makeReadOnly = new File(logFileName);
                        if (makeReadOnly.canWrite()) {
                            makeReadOnly.setReadOnly();
                        }
                        logFileWriter.flush();
                        logFileWriter.close();
                        logFileWriter = null;
                    }
                    catch (Exception e) {
                        BaseLogger.log("0", null, null, "BaseException in Workflow ProcessInstanceMonitorEJB ::607::[" + e.getMessage() + "]");
                        throw new BaseException(e);
                    }
                }
                catch (Exception e) {
                    throw new BaseException(e);
                }
            }
        }
    }

    @Override
    public synchronized String createActivityInstance(String processInstanceId, String activityId, boolean isReverted) throws RemoteException, BaseException {
        block18: {
            WorkflowLogger.info("WorkflowProcessInstanceMonitorEJB.createProcessInstance.SCHEDULER_INVOCATION_CTR [" + WorkflowShedule.SCHEDULER_INVOCATION_CTR + "]");
            Connection con = null;
            Statement pstmt = null;
            try {
                try {
                    WorkflowLogger.info("Create Activity Instance for ProcessInstance Id :[" + processInstanceId + "]");
                    String processId = WorkflowProcessIdGenerator.getInstance().getProcessId(processInstanceId);
                    String instanceIdStr = WorkflowProcessIdGenerator.getInstance().getInstanceId(processInstanceId);
                    if (WorkflowMetaDataManager.getInstance().getActivity(processId, activityId) != null) {
                        String oldActivityId = WorkflowProcessIdGenerator.getInstance().getActivityId(processInstanceId);
                        int seqId = Integer.parseInt(WorkflowProcessIdGenerator.getInstance().getSeqId(processInstanceId));
                        int instanceId = Integer.parseInt(instanceIdStr);
                        con = this.getConnection();
                        String prevActSelQry = "SELECT ROLE_CODE__PERF_ACT,ENTITY_CODE__PERF_ACT,OBJ_NAME,REF_SER,REF_ID FROM WF_PRC_STATUS WHERE PROCESS_ID='" + processId + "' AND INSTANCE_ID=" + instanceId + " AND ACTIVITY_ID='" + oldActivityId + "' AND SEQ_ID=" + seqId;
                        WorkflowLogger.info("Retrieving existing Process Instance Details to create new activity");
                        pstmt = con.prepareStatement(prevActSelQry);
                        ResultSet rs = pstmt.executeQuery();
                        String roleCodeInit = null;
                        String entityCodeInit = null;
                        String objName = null;
                        String refSer = null;
                        String refId = null;
                        if (rs.next()) {
                            roleCodeInit = rs.getString("ROLE_CODE__PERF_ACT");
                            if (roleCodeInit != null && roleCodeInit.equals("null") && roleCodeInit.length() == 0) {
                                roleCodeInit = null;
                            }
                            if ((entityCodeInit = rs.getString("ENTITY_CODE__PERF_ACT")) != null && entityCodeInit.equals("null") && entityCodeInit.length() == 0) {
                                entityCodeInit = null;
                            }
                        } else {
                            throw new Exception("Process Instance missing :[" + processInstanceId + "]");
                        }
                        objName = rs.getString("OBJ_NAME");
                        refSer = rs.getString("REF_SER");
                        refId = rs.getString("REF_ID");
                        rs.close();
                        rs = null;
                        pstmt.close();
                        pstmt = null;
                        int newSeqId = this.getSequenceId(processId, instanceId);
                        if (isReverted) {
                            oldActivityId = "R-" + oldActivityId;
                        }
                        BaseLogger.log("3", null, null, "WorkflowProcessInstanceMonitorEJB : createActivityInstance");
                        String activityDescr = WorkflowMetaDataManager.getInstance().getActivityName(processId, activityId);
                        BaseLogger.log("3", null, null, "createActivityInstance : activityDescr = [" + activityDescr + "]");
                        String createActInsQry = "INSERT INTO WF_PRC_STATUS (PROCESS_ID,INSTANCE_ID,ACTIVITY_ID,PROCESS_STATUS,STATUS_DATE,ROLE_CODE__INIT,ENTITY_CODE__INIT,OBJ_NAME,REF_SER,REF_ID,PREVIOUS_ACTIVITY,SEQ_ID,ACTIVITY_DESCR) VALUES ('" + processId + "'," + instanceId + ",'" + activityId + "',0, " + this.sysdateStr + "," + (roleCodeInit == null ? "null" : "'" + roleCodeInit + "'") + "," + (entityCodeInit == null ? "null" : "'" + entityCodeInit + "'") + ",'" + objName + "','" + refSer + "','" + refId + "','" + oldActivityId + "'," + newSeqId + ",'" + activityDescr + "' )";
                        WorkflowLogger.info("Create Activity Instance Insert Query[" + createActInsQry + "]");
                        pstmt = con.prepareStatement(createActInsQry);
                        int noOfRowsInserted = pstmt.executeUpdate();
                        pstmt.close();
                        pstmt = null;
                        con.commit();
                        break block18;
                    }
                    throw new Exception("Activity Metadata does not exists");
                }
                catch (BaseException be) {
                    throw be;
                }
                catch (Exception e) {
                    throw new BaseException(e);
                }
            }
            finally {
                try {
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (con != null && !con.isClosed() && this.commonCon == null) {
                        con.close();
                        con = null;
                    }
                }
                catch (Exception e) {
                    throw new BaseException(e);
                }
            }
        }
        return processInstanceId;
    }

    @Override
    public synchronized String createActivityInstance(String processInstanceId, String activityId, boolean isReverted, Connection con) throws RemoteException, BaseException {
        block17: {
            WorkflowLogger.info("WorkflowProcessInstanceMonitorEJB.createActivityInstance connection pass.SCHEDULER_INVOCATION_CTR [" + WorkflowShedule.SCHEDULER_INVOCATION_CTR + "]");
            Statement pstmt = null;
            try {
                try {
                    WorkflowLogger.info("Create Activity Instance for ProcessInstance Id :[" + processInstanceId + "]");
                    String processId = WorkflowProcessIdGenerator.getInstance().getProcessId(processInstanceId);
                    String instanceIdStr = WorkflowProcessIdGenerator.getInstance().getInstanceId(processInstanceId);
                    if (WorkflowMetaDataManager.getInstance().getActivity(processId, activityId) != null) {
                        String oldActivityId = WorkflowProcessIdGenerator.getInstance().getActivityId(processInstanceId);
                        int seqId = Integer.parseInt(WorkflowProcessIdGenerator.getInstance().getSeqId(processInstanceId));
                        int instanceId = Integer.parseInt(instanceIdStr);
                        String prevActSelQry = "SELECT ROLE_CODE__PERF_ACT,ENTITY_CODE__PERF_ACT,OBJ_NAME,REF_SER,REF_ID FROM WF_PRC_STATUS WHERE PROCESS_ID='" + processId + "' AND INSTANCE_ID=" + instanceId + " AND ACTIVITY_ID='" + oldActivityId + "' AND SEQ_ID=" + seqId;
                        WorkflowLogger.info("Retrieving existing Process Instance Details to create new activity");
                        pstmt = con.prepareStatement(prevActSelQry);
                        ResultSet rs = pstmt.executeQuery(prevActSelQry);
                        String roleCodeInit = null;
                        String entityCodeInit = null;
                        String objName = null;
                        String refSer = null;
                        String refId = null;
                        if (rs.next()) {
                            roleCodeInit = rs.getString("ROLE_CODE__PERF_ACT");
                            if (roleCodeInit != null && roleCodeInit.equals("null") && roleCodeInit.length() == 0) {
                                roleCodeInit = null;
                            }
                            if ((entityCodeInit = rs.getString("ENTITY_CODE__PERF_ACT")) != null && entityCodeInit.equals("null") && entityCodeInit.length() == 0) {
                                entityCodeInit = null;
                            }
                        } else {
                            throw new Exception("Process Instance missing :[" + processInstanceId + "]");
                        }
                        objName = rs.getString("OBJ_NAME");
                        refSer = rs.getString("REF_SER");
                        refId = rs.getString("REF_ID");
                        rs.close();
                        rs = null;
                        pstmt.close();
                        pstmt = null;
                        int newSeqId = this.getSequenceId(processId, instanceId, con);
                        if (isReverted) {
                            oldActivityId = "R-" + oldActivityId;
                        }
                        BaseLogger.log("3", null, null, "WorkflowProcessInstanceMonitorEJB : createActivityInstance II");
                        String activityDescr = WorkflowMetaDataManager.getInstance().getActivityName(processId, activityId);
                        BaseLogger.log("3", null, null, "createActivityInstance II : activityDescr = [" + activityDescr + "]");
                        String createActInsQry = "INSERT INTO WF_PRC_STATUS (PROCESS_ID,INSTANCE_ID,ACTIVITY_ID,PROCESS_STATUS,STATUS_DATE,ROLE_CODE__INIT,ENTITY_CODE__INIT,OBJ_NAME,REF_SER,REF_ID,PREVIOUS_ACTIVITY,SEQ_ID,ACTIVITY_DESCR) VALUES ('" + processId + "'," + instanceId + ",'" + activityId + "',0, " + this.sysdateStr + "," + (roleCodeInit == null ? "null" : "'" + roleCodeInit + "'") + "," + (entityCodeInit == null ? "null" : "'" + entityCodeInit + "'") + ",'" + objName + "','" + refSer + "','" + refId + "','" + oldActivityId + "'," + newSeqId + ",'" + activityDescr + "' )";
                        WorkflowLogger.info("Create Activity Instance Insert Query[" + createActInsQry + "]");
                        pstmt = con.prepareStatement(createActInsQry);
                        int noOfRowsInserted = pstmt.executeUpdate();
                        pstmt.close();
                        pstmt = null;
                        break block17;
                    }
                    throw new Exception("Activity Metadata does not exists");
                }
                catch (BaseException be) {
                    throw be;
                }
                catch (Exception e) {
                    throw new BaseException(e);
                }
            }
            finally {
                try {
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                }
                catch (Exception e) {
                    throw new BaseException(e);
                }
            }
        }
        return processInstanceId;
    }

    @Override
    public void updateActivityStatus(String processInstanceId, String processStatus, String roleCodePerf, String entityCodePerf, String roleCodeAct, String entityCodeAct, String entityTypeAct, String resultXmlStr) throws RemoteException, BaseException {
        WorkflowLogger.info("WorkflowProcessInstanceMonitorEJB.updateActivityStatus.SCHEDULER_INVOCATION_CTR [" + WorkflowShedule.SCHEDULER_INVOCATION_CTR + "]");
        WorkflowLogger.info("WorkflowProcessInstanceMonitorEJB.updateActivityStatus.resultXmlStr length :[" + resultXmlStr.length() + "]");
        Connection con = null;
        Statement pstmt = null;
        boolean isException = false;
        try {
            try {
                String statusStr;
                String processId = WorkflowProcessIdGenerator.getInstance().getProcessId(processInstanceId);
                String activityId = WorkflowProcessIdGenerator.getInstance().getActivityId(processInstanceId);
                String instanceId = WorkflowProcessIdGenerator.getInstance().getInstanceId(processInstanceId);
                String seqId = WorkflowProcessIdGenerator.getInstance().getSeqId(processInstanceId);
                con = this.getConnection();
                String resultStr = (String)this.getValueOfField(resultXmlStr, "RESULT", "S");
                if (resultStr == null) {
                    resultStr = "";
                }
                if ((statusStr = (String)this.getValueOfField(resultXmlStr, "STATUS", "S")) == null && (resultXmlStr.indexOf("error") != -1 || resultXmlStr.indexOf("Error") != -1)) {
                    statusStr = "1";
                }
                StringBuffer updQueryBuff = new StringBuffer("UPDATE WF_PRC_STATUS SET STATUS_DATE= " + this.sysdateStr + " ");
                boolean isError = false;
                if ("0".equals(statusStr)) {
                    isError = true;
                } else if ("1".equals(statusStr)) {
                    updQueryBuff.append(", PROCESS_STATUS=" + processStatus).append(", ERR_STATUS='0'");
                } else {
                    isError = true;
                    resultStr = "Unhandled Exception :" + resultStr;
                }
                if (isError) {
                    int retryCount = this.checkForRetryCount(con, processId, instanceId, activityId, seqId);
                    if (retryCount <= 3) {
                        updQueryBuff.append(", ERR_STATUS='0', RETRY_COUNTER = " + ++retryCount);
                    } else {
                        updQueryBuff.append(", ERR_STATUS='1' ");
                    }
                }
                if (roleCodePerf != null && !roleCodePerf.equals("null")) {
                    updQueryBuff.append(", ROLE_CODE__PERF='").append(roleCodeAct).append("' ");
                }
                if (entityCodePerf != null && !entityCodePerf.equals("null")) {
                    updQueryBuff.append(", ENTITY_CODE__PERF='").append(entityCodePerf).append("' ");
                }
                if (roleCodeAct != null && !roleCodeAct.equals("null")) {
                    updQueryBuff.append(", ROLE_CODE__PERF_ACT='").append(roleCodeAct).append("' ");
                }
                if (entityCodeAct != null && !entityCodeAct.equals("null")) {
                    updQueryBuff.append(", ENTITY_CODE__PERF_ACT='").append(entityCodeAct).append("' ");
                }
                if (entityTypeAct != null && !entityTypeAct.equals("null")) {
                    updQueryBuff.append(", ENTITY_TYPE__PERF_ACT='").append(entityTypeAct).append("' ");
                }
                if (resultStr != null && !resultStr.equals("null")) {
                    updQueryBuff.append(", STATUS_REMARKS='").append(resultStr).append("'");
                }
                updQueryBuff.append(" WHERE PROCESS_ID='").append(processId).append("' AND INSTANCE_ID=").append(Integer.parseInt(instanceId)).append(" AND ACTIVITY_ID='").append(activityId).append("' AND SEQ_ID=" + seqId + " AND PROCESS_STATUS != 3");
                WorkflowLogger.info("Updating Activity Satus to :[" + processStatus + "], Query :[" + updQueryBuff.toString() + "]");
                pstmt = con.prepareStatement(updQueryBuff.toString());
                int noOfRowsUpdated = pstmt.executeUpdate();
                pstmt.close();
                pstmt = null;
                con.commit();
                if (noOfRowsUpdated != 1) {
                    throw new Exception("Invalid Activity Data, " + noOfRowsUpdated + " instances found :[" + processInstanceId + "] while Updating Activity Status ::[" + processStatus + "]");
                }
                WorkflowLogger.info("updateActivityStatus.processStatus [" + processStatus + "]");
                if (processStatus.equals("2") && !isError) {
                    WorkflowEngineEJB workflowEngine = new WorkflowEngineEJB();
                    workflowEngine.completeActivity(processInstanceId, resultXmlStr, con);
                    workflowEngine = null;
                } else {
                    WorkflowLogger.info("Not completing the activity because of statusStr [" + statusStr + "] for processInstanceId [" + processInstanceId + "]");
                }
            }
            catch (BaseException be) {
                isException = true;
                throw be;
            }
            catch (Exception e) {
                isException = true;
                throw new BaseException(e);
            }
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (con != null && !con.isClosed() && this.commonCon == null) {
                    if (isException) {
                        con.rollback();
                    } else {
                        con.commit();
                    }
                    con.close();
                    con = null;
                }
            }
            catch (Exception e) {
                throw new BaseException(e);
            }
        }
    }

    @Override
    public boolean updateActivityStatus(String processInstanceId, String processStatus, String roleCodePerf, String entityCodePerf, String roleCodeAct, String entityCodeAct, String entityTypeAct, String resultXmlStr, Connection con) throws RemoteException, BaseException {
        WorkflowLogger.info("WorkflowProcessInstanceMonitorEJB.updateActivityStatus with connection.SCHEDULER_INVOCATION_CTR [" + WorkflowShedule.SCHEDULER_INVOCATION_CTR + "]");
        WorkflowLogger.info("WorkflowProcessInstanceMonitorEJB.updateActivityStatus with connection.resultXmlStr length :[" + resultXmlStr.length() + "]");
        Statement pstmt = null;
        boolean isError = false;
        String activityId = null;
        String processId = null;
        String completeActivityStatus = "";
        E12GenericUtility genericUtility = new E12GenericUtility();
        try {
            try {
                String statusStr;
                processId = WorkflowProcessIdGenerator.getInstance().getProcessId(processInstanceId);
                activityId = WorkflowProcessIdGenerator.getInstance().getActivityId(processInstanceId);
                String instanceId = WorkflowProcessIdGenerator.getInstance().getInstanceId(processInstanceId);
                String seqId = WorkflowProcessIdGenerator.getInstance().getSeqId(processInstanceId);
                String resultStr = (String)this.getValueOfField(resultXmlStr, "RESULT", "S");
                if (resultStr == null) {
                    resultStr = "";
                }
                if ((statusStr = (String)this.getValueOfField(resultXmlStr, "STATUS", "S")) == null && (resultXmlStr.indexOf("error") != -1 || resultXmlStr.indexOf("Error") != -1)) {
                    statusStr = "1";
                }
                StringBuffer updQueryBuff = new StringBuffer("UPDATE WF_PRC_STATUS SET STATUS_DATE= " + this.sysdateStr + " ");
                if ("0".equals(statusStr)) {
                    int retryCount = this.checkForRetryCount(con, processId, instanceId, activityId, seqId);
                    if (retryCount <= 3) {
                        updQueryBuff.append(", ERR_STATUS='0', RETRY_COUNTER = " + ++retryCount);
                    } else {
                        updQueryBuff.append(", ERR_STATUS='1' ");
                        isError = true;
                    }
                    this.sendErrorMail(processInstanceId, resultStr, con);
                } else {
                    updQueryBuff.append(", PROCESS_STATUS=" + processStatus).append(", ERR_STATUS='0'");
                }
                if (roleCodePerf != null && !roleCodePerf.equals("null")) {
                    updQueryBuff.append(", ROLE_CODE__PERF='").append(roleCodeAct).append("' ");
                }
                if (entityCodePerf != null && !entityCodePerf.equals("null")) {
                    updQueryBuff.append(", ENTITY_CODE__PERF='").append(entityCodePerf).append("' ");
                }
                if (roleCodeAct != null && !roleCodeAct.equals("null")) {
                    updQueryBuff.append(", ROLE_CODE__PERF_ACT='").append(roleCodeAct).append("' ");
                }
                if (entityCodeAct != null && !entityCodeAct.equals("null")) {
                    updQueryBuff.append(", ENTITY_CODE__PERF_ACT='").append(entityCodeAct).append("' ");
                }
                if (entityTypeAct != null && !entityTypeAct.equals("null")) {
                    updQueryBuff.append(", ENTITY_TYPE__PERF_ACT='").append(entityTypeAct).append("' ");
                }
                if (resultStr != null && !resultStr.equals("null")) {
                    updQueryBuff.append(", STATUS_REMARKS='").append(resultStr).append("'");
                }
                updQueryBuff.append(" WHERE PROCESS_ID='").append(processId).append("' AND INSTANCE_ID=").append(Integer.parseInt(instanceId)).append(" AND ACTIVITY_ID='").append(activityId).append("' AND SEQ_ID=" + seqId + " AND PROCESS_STATUS != 3");
                WorkflowLogger.info("WorkflowProcessInstanceMonitorEJB with connection ::Updating Activity Satus to :[" + processStatus + "], Query :[" + updQueryBuff.toString() + "]");
                pstmt = con.prepareStatement(updQueryBuff.toString());
                int noOfRowsUpdated = pstmt.executeUpdate();
                pstmt.close();
                pstmt = null;
                if (noOfRowsUpdated != 1) {
                    isError = true;
                    genericUtility.generateLog("Invalid Activity Data, " + noOfRowsUpdated + " instances found :[" + processInstanceId + "] while Updating Activity Status ::[" + processStatus + "]", "", String.valueOf(processId) + "_" + activityId, false);
                    throw new Exception("Invalid Activity Data, " + noOfRowsUpdated + " instances found :[" + processInstanceId + "] while Updating Activity Status ::[" + processStatus + "]");
                }
                WorkflowLogger.info("WorkflowProcessInstanceMonitorEJB with connection ::updateActivityStatus.processStatus [" + processStatus + "]");
                if (processStatus.equals("2") && !isError) {
                    WorkflowEngineEJB workflowEngine = new WorkflowEngineEJB();
                    completeActivityStatus = workflowEngine.completeActivity(processInstanceId, resultXmlStr, con);
                    if ("Error".equals(completeActivityStatus)) {
                        isError = true;
                        this.sendErrorMail(processInstanceId, resultStr, con);
                    }
                    workflowEngine = null;
                }
            }
            catch (BaseException be) {
                try {
                    isError = true;
                    genericUtility.generateLog(genericUtility.writePrintStacktrace(be), "", String.valueOf(processId) + "_" + activityId, false);
                    throw be;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new BaseException(e);
                }
            }
            catch (Exception e) {
                try {
                    isError = true;
                    genericUtility.generateLog(genericUtility.writePrintStacktrace(e), "", String.valueOf(processId) + "_" + activityId, false);
                    throw new BaseException(e);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    throw new BaseException(ex);
                }
            }
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
            }
            catch (Exception e) {
                isError = true;
                throw new BaseException(e);
            }
        }
        return isError;
    }

    @Override
    public boolean updateActivityErrorStatus(String processInstanceId, String processStatus, String roleCodePerf, String entityCodePerf, String roleCodeAct, String entityCodeAct, String entityTypeAct, String exception, Connection con) throws RemoteException, BaseException {
        WorkflowLogger.info("WorkflowProcessInstanceMonitorEJB.updateActivityErrorStatus SCHEDULER_INVOCATION_CTR [" + WorkflowShedule.SCHEDULER_INVOCATION_CTR + "]");
        Statement pstmt = null;
        boolean isError = false;
        String activityId = null;
        String processId = null;
        E12GenericUtility genericUtility = new E12GenericUtility();
        if (con == null) {
            con = this.getConnection();
        }
        try {
            try {
                processId = WorkflowProcessIdGenerator.getInstance().getProcessId(processInstanceId);
                activityId = WorkflowProcessIdGenerator.getInstance().getActivityId(processInstanceId);
                String instanceId = WorkflowProcessIdGenerator.getInstance().getInstanceId(processInstanceId);
                String seqId = WorkflowProcessIdGenerator.getInstance().getSeqId(processInstanceId);
                StringBuffer updQueryBuff = new StringBuffer("UPDATE WF_PRC_STATUS SET STATUS_DATE= " + this.sysdateStr + " ");
                int retryCount = this.checkForRetryCount(con, processId, instanceId, activityId, seqId);
                if (retryCount <= 3) {
                    updQueryBuff.append(", ERR_STATUS='0', RETRY_COUNTER = " + ++retryCount);
                } else {
                    updQueryBuff.append(", ERR_STATUS='1' ");
                }
                if (roleCodePerf != null && !roleCodePerf.equals("null")) {
                    updQueryBuff.append(", ROLE_CODE__PERF='").append(roleCodeAct).append("' ");
                }
                if (entityCodePerf != null && !entityCodePerf.equals("null")) {
                    updQueryBuff.append(", ENTITY_CODE__PERF='").append(entityCodePerf).append("' ");
                }
                if (roleCodeAct != null && !roleCodeAct.equals("null")) {
                    updQueryBuff.append(", ROLE_CODE__PERF_ACT='").append(roleCodeAct).append("' ");
                }
                if (entityCodeAct != null && !entityCodeAct.equals("null")) {
                    updQueryBuff.append(", ENTITY_CODE__PERF_ACT='").append(entityCodeAct).append("' ");
                }
                if (entityTypeAct != null && !entityTypeAct.equals("null")) {
                    updQueryBuff.append(", ENTITY_TYPE__PERF_ACT='").append(entityTypeAct).append("' ");
                }
                if (exception != null && !exception.equals("null")) {
                    exception = exception.length() > 2000 ? exception.substring(0, 2000) : exception;
                    updQueryBuff.append(", STATUS_REMARKS='").append(exception).append("'");
                }
                updQueryBuff.append(" WHERE PROCESS_ID='").append(processId).append("' AND INSTANCE_ID=").append(Integer.parseInt(instanceId)).append(" AND ACTIVITY_ID='").append(activityId).append("' AND SEQ_ID=" + seqId + " AND PROCESS_STATUS != 3");
                WorkflowLogger.info("WorkflowProcessInstanceMonitorEJB with connection ::Updating Activity Satus to :[" + processStatus + "], Query :[" + updQueryBuff.toString() + "]");
                pstmt = con.prepareStatement(updQueryBuff.toString());
                int noOfRowsUpdated = pstmt.executeUpdate();
                pstmt.close();
                pstmt = null;
                if (noOfRowsUpdated != 1) {
                    isError = true;
                    genericUtility.generateLog("Invalid Activity Data, " + noOfRowsUpdated + " instances found :[" + processInstanceId + "] while Updating Activity Status ::[" + processStatus + "]", "", String.valueOf(processId) + "_" + activityId, false);
                    throw new Exception("Invalid Activity Data, " + noOfRowsUpdated + " instances found :[" + processInstanceId + "] while Updating Activity Status ::[" + processStatus + "]");
                }
            }
            catch (BaseException be) {
                try {
                    isError = true;
                    genericUtility.generateLog(genericUtility.writePrintStacktrace(be), "", String.valueOf(processId) + "_" + activityId, false);
                    throw be;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new BaseException(e);
                }
            }
            catch (Exception e) {
                try {
                    isError = true;
                    genericUtility.generateLog(genericUtility.writePrintStacktrace(e), "", String.valueOf(processId) + "_" + activityId, false);
                    throw new BaseException(e);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    throw new BaseException(ex);
                }
            }
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
            }
            catch (Exception e) {
                isError = true;
                throw new BaseException(e);
            }
        }
        return isError;
    }

    private boolean isWorkflowInitiated(String refSer, String objName, String refId, String processId) throws BaseException {
        WorkflowLogger.info("WorkflowProcessInstanceMonitorEJB.isWorkflowInitiated.SCHEDULER_INVOCATION_CTR [" + WorkflowShedule.SCHEDULER_INVOCATION_CTR + "]");
        boolean isExists = false;
        Connection con = null;
        Statement pstmt = null;
        try {
            try {
                con = this.getConnection();
                String prcStatusSelQry = "SELECT PROCESS_STATUS FROM WF_PRC_STATUS WHERE PROCESS_ID='" + processId + "' AND ACTIVITY_ID='" + processId + "' AND REF_SER='" + refSer + "' AND REF_ID='" + refId + "' AND OBJ_NAME='" + objName + "'";
                WorkflowLogger.info("Checking if workflow process already instantiated");
                pstmt = con.prepareStatement(prcStatusSelQry);
                ResultSet rs = pstmt.executeQuery();
                if (rs.next()) {
                    int prcStatus = rs.getInt(1);
                    if (prcStatus > 1) {
                        isExists = true;
                    } else if (prcStatus <= 1) {
                        this.destroyProcessInstance(con, refSer, objName, refId, processId);
                    }
                }
                rs.close();
                rs = null;
                pstmt.close();
                pstmt = null;
            }
            catch (BaseException be) {
                throw be;
            }
            catch (Exception e) {
                throw new BaseException(e);
            }
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (con != null && !con.isClosed() && this.commonCon == null) {
                    con.close();
                    con = null;
                }
            }
            catch (Exception e) {
                throw new BaseException(e);
            }
        }
        WorkflowLogger.info("Returning Process Exists Status :[" + isExists + "]");
        return isExists;
    }

    private boolean isWorkflowInitiated(String refSer, String objName, String refId, String processId, Connection con) throws BaseException {
        WorkflowLogger.info("WorkflowProcessInstanceMonitorEJB.isWorkflowInitiated.SCHEDULER_INVOCATION_CTR [" + WorkflowShedule.SCHEDULER_INVOCATION_CTR + "]");
        this.logMessageBuf.append("\nisWorkflowInitiated() is called......::START");
        boolean isExists = false;
        ResultSet rs = null;
        int prcStatus = 0;
        String prcStatusSelQry = "";
        PreparedStatement pstmtWf = null;
        try {
            try {
                prcStatusSelQry = "SELECT PROCESS_STATUS FROM WF_PRC_STATUS WHERE PROCESS_ID=? AND ACTIVITY_ID=? AND REF_SER=? AND REF_ID=? AND OBJ_NAME=? AND WF_ABORT IS NULL ";
                pstmtWf = con.prepareStatement(prcStatusSelQry);
                pstmtWf.setString(1, processId);
                pstmtWf.setString(2, processId);
                pstmtWf.setString(3, refSer);
                pstmtWf.setString(4, refId);
                pstmtWf.setString(5, objName);
                WorkflowLogger.info("Checking if workflow process already instantiated");
                this.logMessageBuf.append("\nprcStatusSelQry ::" + prcStatusSelQry);
                rs = pstmtWf.executeQuery();
                if (rs.next()) {
                    prcStatus = rs.getInt(1);
                }
                this.logMessageBuf.append("\nprcStatus =[" + prcStatus + "]");
                if (prcStatus > 1) {
                    isExists = true;
                }
            }
            catch (Exception e) {
                throw new BaseException(e);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmtWf != null) {
                    pstmtWf.close();
                    pstmtWf = null;
                }
            }
            catch (Exception e) {
                throw new BaseException(e);
            }
        }
        WorkflowLogger.info("Returning Process Exists Status :[" + isExists + "]");
        this.logMessageBuf.append("\nisExists =[" + isExists + "]");
        this.logMessageBuf.append("\nisWorkflowInitiated() is called......::END");
        return isExists;
    }

    private void destroyProcessInstance(Connection con, String refSer, String objName, String refId, String processId) throws BaseException {
        WorkflowLogger.info("WorkflowProcessInstanceMonitorEJB.destroyProcessInstance.SCHEDULER_INVOCATION_CTR [" + WorkflowShedule.SCHEDULER_INVOCATION_CTR + "]");
        this.logMessageBuf.append("\ndestroyProcessInstance() is called......::START");
        Statement pstmtUpd = null;
        Statement pstmtWf = null;
        boolean isError = false;
        boolean isConLocal = false;
        String prcStatusSelQry = "";
        ResultSet rsSel = null;
        try {
            try {
                WorkflowLogger.info("Destroying existing Process Instance for Ref Ser :[" + refSer + "] Obj Name :[" + objName + "] Ref Id :[" + refId + "] Process Id :[" + processId + "]");
                if (con == null) {
                    con = this.getConnection();
                    isConLocal = true;
                }
                String fromWfPRCStatus = "FROM WF_PRC_STATUS WHERE PROCESS_ID='" + processId + "' AND ACTIVITY_ID='" + processId + "' AND REF_SER='" + refSer + "' AND REF_ID='" + refId + "' AND OBJ_NAME='" + objName + "' AND WF_ABORT IS NULL ";
                String instanceId = "";
                int updCnt = 0;
                String dbName = CommonConstants.DB_NAME;
                prcStatusSelQry = "SELECT INSTANCE_ID FROM WF_PRC_STATUS WHERE PROCESS_ID=? AND ACTIVITY_ID=? AND REF_SER=? AND REF_ID=? AND OBJ_NAME=? AND WF_ABORT IS NULL ";
                pstmtWf = con.prepareStatement(prcStatusSelQry);
                pstmtWf.setString(1, processId);
                pstmtWf.setString(2, processId);
                pstmtWf.setString(3, refSer);
                pstmtWf.setString(4, refId);
                pstmtWf.setString(5, objName);
                rsSel = pstmtWf.executeQuery();
                if (rsSel.next()) {
                    instanceId = rsSel.getString("INSTANCE_ID");
                    String wfPrcUpdSql = "UPDATE WF_PRC_STATUS SET WF_ABORT = 'Y' WHERE PROCESS_ID = ? AND INSTANCE_ID = ? ";
                    pstmtUpd = con.prepareStatement(wfPrcUpdSql);
                    pstmtUpd.setString(1, processId);
                    pstmtUpd.setString(2, instanceId);
                    updCnt = pstmtUpd.executeUpdate();
                }
                BaseLogger.log("3", null, null, "destroyProcessInstance >> updCnt =[" + updCnt + "]");
                this.logMessageBuf.append("\ndestroyProcessInstance() updCnt =[" + updCnt + "]");
            }
            catch (BaseException be) {
                isError = true;
                throw be;
            }
            catch (Exception e) {
                isError = true;
                throw new BaseException(e);
            }
        }
        finally {
            try {
                this.logMessageBuf.append("\ndestroyProcessInstance() is called......::END");
                if (rsSel != null) {
                    rsSel.close();
                    rsSel = null;
                }
                if (pstmtWf != null) {
                    pstmtWf.close();
                    pstmtWf = null;
                }
                if (pstmtUpd != null) {
                    pstmtUpd.close();
                    pstmtUpd = null;
                }
                if (con != null && isConLocal) {
                    if (isError) {
                        con.rollback();
                    } else {
                        con.commit();
                    }
                    if (!con.isClosed() && this.commonCon == null) {
                        con.close();
                        con = null;
                    }
                }
            }
            catch (Exception e) {
                throw new BaseException(e);
            }
        }
    }

    private boolean isActivityCreated(String processId, int instanceId, String activityId) throws BaseException {
        WorkflowLogger.info("WorkflowProcessInstanceMonitorEJB.isActivityCreated.SCHEDULER_INVOCATION_CTR [" + WorkflowShedule.SCHEDULER_INVOCATION_CTR + "]");
        boolean isExists = false;
        Connection con = null;
        Statement pstmt = null;
        try {
            try {
                int recCount;
                con = this.getConnection();
                String actExistsSelQry = "SELECT COUNT(1) FROM WF_PRC_STATUS WHERE PROCESS_ID='" + processId + "' AND INSTANCE_ID=" + instanceId + " AND ACTIVITY_ID='" + activityId + "'";
                WorkflowLogger.info("Checking whether Activity already created Query for Process Id :[" + processId + "] Instance Id :[" + instanceId + "] Activity Id :[" + activityId + "]");
                pstmt = con.prepareStatement(actExistsSelQry);
                ResultSet rs = pstmt.executeQuery();
                if (rs.next() && (recCount = rs.getInt(1)) == 1) {
                    isExists = true;
                }
                rs.close();
                rs = null;
                pstmt.close();
                pstmt = null;
            }
            catch (BaseException be) {
                throw be;
            }
            catch (Exception e) {
                throw new BaseException(e);
            }
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (con != null && !con.isClosed() && this.commonCon == null) {
                    con.close();
                    con = null;
                }
            }
            catch (Exception e) {
                throw new BaseException(e);
            }
        }
        WorkflowLogger.info("Returning Activity isExists :[" + isExists + "]");
        return isExists;
    }

    @Override
    public int getActivityStatus(String processId, int instanceId, String activityId) throws RemoteException, BaseException {
        WorkflowLogger.info("WorkflowProcessInstanceMonitorEJB.getActivityStatus.SCHEDULER_INVOCATION_CTR [" + WorkflowShedule.SCHEDULER_INVOCATION_CTR + "]");
        int processStatus = -1;
        Connection con = null;
        Statement pstmt = null;
        try {
            try {
                con = this.getConnection();
                String prcStatusSelQry = "SELECT PROCESS_STATUS, SEQ_ID FROM WF_PRC_STATUS WHERE  PROCESS_ID='" + processId + "' AND INSTANCE_ID=" + instanceId + " AND ACTIVITY_ID='" + activityId + "' AND SEQ_ID = ( SELECT MAX(SEQ_ID) FROM WF_PRC_STATUS WHERE \tPROCESS_ID='" + processId + "' AND INSTANCE_ID=" + instanceId + "  AND ACTIVITY_ID='" + activityId + "' ) ";
                WorkflowLogger.info("Getting Activity Status for Process Id :[" + processId + "] Instance Id :[" + instanceId + "] Activity Id :[" + activityId + "]");
                pstmt = con.prepareStatement(prcStatusSelQry);
                ResultSet rs = pstmt.executeQuery();
                if (rs.next()) {
                    processStatus = rs.getInt(1);
                }
                rs.close();
                rs = null;
                pstmt.close();
                pstmt = null;
            }
            catch (BaseException be) {
                throw be;
            }
            catch (Exception e) {
                throw new BaseException(e);
            }
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (con != null && !con.isClosed() && this.commonCon == null) {
                    con.close();
                    con = null;
                }
            }
            catch (Exception e) {
                throw new BaseException(e);
            }
        }
        return processStatus;
    }

    @Override
    public int getActivityStatus(String processId, int instanceId, String activityId, Connection con) throws BaseException {
        WorkflowLogger.info("WorkflowProcessInstanceMonitorEJB.getActivityStatus.SCHEDULER_INVOCATION_CTR [" + WorkflowShedule.SCHEDULER_INVOCATION_CTR + "]");
        int processStatus = -1;
        Statement pstmt = null;
        try {
            try {
                String prcStatusSelQry = "SELECT PROCESS_STATUS, SEQ_ID FROM WF_PRC_STATUS WHERE  PROCESS_ID='" + processId + "' AND INSTANCE_ID=" + instanceId + " AND ACTIVITY_ID='" + activityId + "' AND SEQ_ID = ( SELECT MAX(SEQ_ID) FROM WF_PRC_STATUS WHERE \tPROCESS_ID='" + processId + "' AND INSTANCE_ID=" + instanceId + "  AND ACTIVITY_ID='" + activityId + "' ) ";
                WorkflowLogger.info("Getting Activity Status for Process Id :[" + processId + "] Instance Id :[" + instanceId + "] Activity Id :[" + activityId + "]");
                pstmt = con.prepareStatement(prcStatusSelQry);
                ResultSet rs = pstmt.executeQuery();
                if (rs.next()) {
                    processStatus = rs.getInt(1);
                }
                rs.close();
                rs = null;
            }
            catch (Exception e) {
                throw new BaseException(e);
            }
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
            }
            catch (Exception e) {
                throw new BaseException(e);
            }
        }
        return processStatus;
    }

    @Override
    public HashMap getActivitiesStatusMap(String processId, int instanceId, ArrayList activityIds) throws RemoteException, BaseException {
        HashMap<String, String> activitiesStatusMap = new HashMap<String, String>();
        try {
            int i = 0;
            while (i < activityIds.size()) {
                activitiesStatusMap.put("$" + activityIds.get(i) + "_STATUS", "" + this.getActivityStatus(processId, instanceId, (String)activityIds.get(i)));
                ++i;
            }
        }
        catch (BaseException be) {
            throw be;
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
        return activitiesStatusMap;
    }

    @Override
    public HashMap getActivitiesStatusMap(String processId, int instanceId, ArrayList activityIds, Connection con) throws RemoteException, BaseException {
        HashMap<String, String> activitiesStatusMap = new HashMap<String, String>();
        try {
            int i = 0;
            while (i < activityIds.size()) {
                activitiesStatusMap.put("$" + activityIds.get(i) + "_STATUS", "" + this.getActivityStatus(processId, instanceId, (String)activityIds.get(i), con));
                ++i;
            }
        }
        catch (BaseException be) {
            throw be;
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
        return activitiesStatusMap;
    }

    private boolean isActivityReverted(String processId, int instanceId, String activityId, int seqId) throws BaseException {
        boolean isReverted = false;
        Connection con = null;
        Statement pstmt = null;
        try {
            try {
                String prevActivity;
                con = this.getConnection();
                String actExistsSelQry = "SELECT PREVIOUS_ACTIVITY FROM WF_PRC_STATUS WHERE PROCESS_ID='" + processId + "' AND INSTANCE_ID=" + instanceId + " AND ACTIVITY_ID='" + activityId + "' AND SEQ_ID=" + seqId;
                WorkflowLogger.info("Checking whether Activity is reverted  actExistsSelQry [" + actExistsSelQry + "]");
                pstmt = con.prepareStatement(actExistsSelQry);
                ResultSet rs = pstmt.executeQuery();
                if (rs.next() && (prevActivity = rs.getString("PREVIOUS_ACTIVITY")).startsWith("R-")) {
                    isReverted = true;
                }
                rs.close();
                rs = null;
                pstmt.close();
                pstmt = null;
            }
            catch (BaseException be) {
                throw be;
            }
            catch (Exception e) {
                throw new BaseException(e);
            }
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (con != null && !con.isClosed() && this.commonCon == null) {
                    con.close();
                    con = null;
                }
            }
            catch (Exception e) {
                throw new BaseException(e);
            }
        }
        WorkflowLogger.info("Returning Activity Reverted :[" + isReverted + "]");
        return isReverted;
    }

    @Override
    public String getProcessStatus(String processId, String objName, String refSer, String refId) throws RemoteException, BaseException {
        WorkflowLogger.info("Getting Process Status for Process Id :[" + processId + "] Object Name :[" + objName + "] Ref Ser :[" + refSer + "] Ref Id :[" + refId + "]");
        String processStatus = "C";
        Connection con = null;
        Statement stmt = null;
        try {
            try {
                processStatus = this.getProcessStatus(processId, objName, refSer, refId, con);
            }
            catch (BaseException be) {
                throw be;
            }
            catch (Exception e) {
                throw new BaseException(e);
            }
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
                if (con != null && !con.isClosed() && this.commonCon == null) {
                    con.close();
                    con = null;
                }
            }
            catch (Exception e) {
                throw new BaseException(e);
            }
        }
        return processStatus;
    }

    @Override
    public String getProcessStatus(String processId, String objName, String refSer, String refId, Connection con) throws RemoteException, BaseException {
        WorkflowLogger.info("Getting Process Status for Process Id :[" + processId + "] Object Name :[" + objName + "] Ref Ser :[" + refSer + "] Ref Id :[" + refId + "]");
        this.logMessageBuf.append("\nGetting Process Status for Process Id :[" + processId + "] Object Name :[" + objName + "] Ref Ser :[" + refSer + "] Ref Id :[" + refId + "]");
        String processStatus = "C";
        Statement pstmt = null;
        boolean isLocalConn = false;
        boolean isException = false;
        PreparedStatement pstmtUpd = null;
        try {
            try {
                if (con == null) {
                    con = this.getConnection();
                    isLocalConn = true;
                }
                BaseLogger.log("3", null, null, "isLocalConn in getProcessStatus:[" + isLocalConn + "]");
                if (this.isWorkflowInitiated(refSer, objName, refId, processId, con)) {
                    ArrayList endActivitiesList = WorkflowMetaDataManager.getInstance().getEndActivitiesList(processId);
                    this.logMessageBuf.append("endActivitiesList : " + endActivitiesList);
                    String prcStatusSelQry = "SELECT ACTIVITY_ID, PROCESS_STATUS, INSTANCE_ID, SEQ_ID FROM WF_PRC_STATUS WHERE PROCESS_ID='" + processId + "' AND OBJ_NAME='" + objName + "' AND REF_SER='" + refSer + "' AND REF_ID='" + refId + "' AND WF_ABORT IS NULL";
                    this.logMessageBuf.append("\nprcStatusSelQry ::" + prcStatusSelQry);
                    pstmt = con.prepareStatement(prcStatusSelQry);
                    ResultSet rs = pstmt.executeQuery();
                    while (rs.next()) {
                        List toolList;
                        int prcStatus;
                        String activity = rs.getString("ACTIVITY_ID");
                        String instanceId = rs.getString("INSTANCE_ID");
                        String seqId = rs.getString("SEQ_ID");
                        if (!activity.equalsIgnoreCase(processId)) {
                            processStatus = "P";
                        }
                        if ((prcStatus = rs.getInt("PROCESS_STATUS")) == 0 || prcStatus == 1 || prcStatus == 2) {
                            processStatus = "P";
                        }
                        if (!endActivitiesList.contains(activity)) continue;
                        WorkflowLogger.info("Found End Activity :[" + activity + "] with status = 3 for process");
                        this.logMessageBuf.append("Found End Activity :[" + activity + "] with status = 3 for process");
                        if (prcStatus == 3) {
                            processStatus = "C";
                            break;
                        }
                        HashMap<String, String> attrNameValueMap = new HashMap<String, String>();
                        WorkflowProcess workflowProcess = WorkflowMetaDataManager.getInstance().getWorkflowProcess(processId);
                        Activity activity1 = WorkflowMetaDataManager.getInstance().getActivity(workflowProcess, activity);
                        Implementation implementation = (Implementation)activity1.getImplementation();
                        if (implementation != null && (toolList = implementation.getTool()) != null) {
                            int noOfTool = toolList.size();
                            int toolCtr = 0;
                            while (toolCtr < noOfTool) {
                                Tool tool = (Tool)toolList.get(toolCtr);
                                String applicationId = tool.getId();
                                Application application = WorkflowMetaDataManager.getInstance().getApplication(workflowProcess, applicationId);
                                ExtendedAttributes extAttr = (ExtendedAttributes)application.getExtendedAttributes();
                                List extendedAttributeList = extAttr.getExtendedAttribute();
                                int noOfExtendedAttribute = extendedAttributeList.size();
                                int extAttrCtr = 0;
                                while (extAttrCtr < noOfExtendedAttribute) {
                                    ExtendedAttribute extendedAttribute = (ExtendedAttribute)extendedAttributeList.get(extAttrCtr);
                                    attrNameValueMap.put(extendedAttribute.getName(), extendedAttribute.getValue());
                                    ++extAttrCtr;
                                }
                                ++toolCtr;
                            }
                        }
                        WorkflowLogger.info("WorkflowProcessInstanceMonitorEJB.getProcessStatus() attrNameValueMap :[" + attrNameValueMap + "] ");
                        if (attrNameValueMap == null) continue;
                        String compName = E12GenericUtility.checkNull((String)attrNameValueMap.get("COMP_NAME"));
                        String execMode = E12GenericUtility.checkNull((String)attrNameValueMap.get("EXEC_MODE"));
                        if (!"ASYNC".equalsIgnoreCase(execMode) || !"ibase.utility.EMail".equalsIgnoreCase(compName)) continue;
                        processStatus = "C";
                        String wfPrcUpdSql = "UPDATE WF_PRC_STATUS SET PROCESS_STATUS = ? WHERE PROCESS_ID = ? AND INSTANCE_ID = ? and ACTIVITY_ID = ? and SEQ_ID = ?";
                        pstmtUpd = con.prepareStatement(wfPrcUpdSql);
                        pstmtUpd.setString(1, "3");
                        pstmtUpd.setString(2, processId);
                        pstmtUpd.setString(3, instanceId);
                        pstmtUpd.setString(4, activity);
                        pstmtUpd.setString(5, seqId);
                        int updCnt = pstmtUpd.executeUpdate();
                        if (pstmtUpd == null) break;
                        pstmtUpd.close();
                        pstmtUpd = null;
                        break;
                    }
                    rs.close();
                    rs = null;
                    pstmt.close();
                    pstmt = null;
                    this.logMessageBuf.append("\nprocessStatus =[" + processStatus + "]");
                }
            }
            catch (SQLException sqe) {
                isException = true;
                sqe.printStackTrace();
                throw new BaseException(sqe);
            }
            catch (BaseException be) {
                isException = true;
                throw be;
            }
            catch (Exception e) {
                isException = true;
                throw new BaseException(e);
            }
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (con != null && isLocalConn) {
                    if (isException) {
                        con.rollback();
                    } else {
                        con.commit();
                    }
                    con.close();
                    con = null;
                }
            }
            catch (Exception e) {
                throw new BaseException(e);
            }
        }
        return processStatus;
    }

    @Override
    public String getPreviousActivity(String processId, int instanceId, String activityId, int seqId, Connection con) throws RemoteException, BaseException {
        Statement pstmt = null;
        String previousActivity = null;
        try {
            try {
                String prevActSelQry = "SELECT PREVIOUS_ACTIVITY FROM WF_PRC_STATUS WHERE PROCESS_ID='" + processId + "' AND INSTANCE_ID=" + instanceId + " AND ACTIVITY_ID='" + activityId + "' AND SEQ_ID=" + seqId;
                pstmt = con.prepareStatement(prevActSelQry);
                ResultSet rs = pstmt.executeQuery();
                if (rs.next()) {
                    previousActivity = rs.getString("PREVIOUS_ACTIVITY");
                }
                rs.close();
                rs = null;
                pstmt.close();
                pstmt = null;
            }
            catch (Exception e) {
                throw new BaseException(e);
            }
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
            }
            catch (Exception e) {
                throw new BaseException(e);
            }
        }
        WorkflowLogger.info("previousActivity [" + previousActivity + "]");
        return previousActivity;
    }

    @Override
    public String getPreviousActivity(String processId, int instanceId, String activityId, int seqId) throws RemoteException, BaseException {
        Connection con = null;
        Statement pstmt = null;
        String previousActivity = null;
        try {
            try {
                con = new ConnDriver().getConnectDB(CommonConstants.WRKFLW_DB);
                String prevActSelQry = "SELECT PREVIOUS_ACTIVITY FROM WF_PRC_STATUS WHERE PROCESS_ID='" + processId + "' AND INSTANCE_ID=" + instanceId + " AND ACTIVITY_ID='" + activityId + "' AND SEQ_ID=" + seqId;
                pstmt = con.prepareStatement(prevActSelQry);
                ResultSet rs = pstmt.executeQuery();
                if (rs.next()) {
                    previousActivity = rs.getString("PREVIOUS_ACTIVITY");
                }
                rs.close();
                rs = null;
                pstmt.close();
                pstmt = null;
            }
            catch (BaseException be) {
                throw be;
            }
            catch (Exception e) {
                throw new BaseException(e);
            }
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (con != null && !con.isClosed() && this.commonCon == null) {
                    con.close();
                    con = null;
                }
            }
            catch (Exception e) {
                throw new BaseException(e);
            }
        }
        WorkflowLogger.info("previousActivity [" + previousActivity + "]");
        return previousActivity;
    }

    private int getSequenceId(String processId, int instanceId) throws BaseException {
        WorkflowLogger.info("getSeqID : currentThread() [" + Thread.currentThread() + "]");
        int seqId = 1;
        Connection con = null;
        Statement pstmt = null;
        try {
            try {
                con = this.getConnection();
                String prcSeqIdSelQry = "SELECT MAX(SEQ_ID) FROM WF_PRC_STATUS WHERE PROCESS_ID='" + processId + "' AND INSTANCE_ID=" + instanceId;
                WorkflowLogger.info("Getting SeqId for Process Id :[" + processId + "] Instance Id :[" + instanceId + "] ");
                pstmt = con.prepareStatement(prcSeqIdSelQry);
                ResultSet rs = pstmt.executeQuery();
                if (rs.next()) {
                    seqId = rs.getInt(1) + 1;
                }
                rs.close();
                rs = null;
                pstmt.close();
                pstmt = null;
            }
            catch (BaseException be) {
                throw be;
            }
            catch (Exception e) {
                throw new BaseException(e);
            }
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (con != null && !con.isClosed()) {
                    con.close();
                    con = null;
                }
            }
            catch (Exception e) {
                throw new BaseException(e);
            }
        }
        return seqId;
    }

    private int getSequenceId(String processId, int instanceId, Connection con) throws BaseException {
        WorkflowLogger.info("getSeqID : currentThread() [" + Thread.currentThread() + "]");
        int seqId = 1;
        Statement pstmt = null;
        try {
            try {
                String prcSeqIdSelQry = "SELECT MAX(SEQ_ID) FROM WF_PRC_STATUS WHERE PROCESS_ID='" + processId + "' AND INSTANCE_ID=" + instanceId;
                WorkflowLogger.info("Getting SeqId for Process Id :[" + processId + "] Instance Id :[" + instanceId + "] ");
                pstmt = con.prepareStatement(prcSeqIdSelQry);
                ResultSet rs = pstmt.executeQuery();
                if (rs.next()) {
                    seqId = rs.getInt(1) + 1;
                }
                rs.close();
                rs = null;
                pstmt.close();
                pstmt = null;
            }
            catch (Exception e) {
                throw new BaseException(e);
            }
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
            }
            catch (Exception e) {
                throw new BaseException(e);
            }
        }
        return seqId;
    }

    private Object getValueOfField(String dataString, String currFieldName, String currFieldType) throws BaseException {
        WorkflowLogger.info("WorkflowProcessInstanceMonitorEJB.Getting value of :[" + currFieldName + "] from dataString LENGTH :[" + dataString.length() + "]");
        Object fieldValue = null;
        Node currField = null;
        try {
            Document dom = null;
            boolean parseRetry = false;
            try {
                dom = this.parseString(dataString);
            }
            catch (SAXParseException saxe) {
                WorkflowLogger.info("Exception :WorkflowProcessInstanceMonitorEJB:getValueOfField :parsingXMLString :==>\n" + saxe.getMessage());
                parseRetry = true;
            }
            if (parseRetry) {
                dom = this.parsingFile(dataString);
            }
            String currFieldValue = null;
            if (currFieldName.indexOf(".") != -1) {
                String detailName = currFieldName.substring(0, currFieldName.indexOf("."));
                String fieldName = currFieldName.substring(currFieldName.indexOf(".") + 1);
                NodeList detailNodeList = dom.getElementsByTagName(detailName).item(0).getChildNodes();
                int ctr = 0;
                while (ctr < detailNodeList.getLength()) {
                    Node currChild = detailNodeList.item(ctr);
                    if (currChild.getNodeName().equals(fieldName) && currChild.getFirstChild() != null) {
                        currField = currChild;
                    }
                    ++ctr;
                }
            } else {
                currField = dom.getElementsByTagName(currFieldName).item(0);
            }
            if (currField != null) {
                if (currField.getFirstChild() != null) {
                    currFieldValue = currField.getFirstChild().getNodeValue();
                }
                if (currFieldValue != null) {
                    fieldValue = currFieldType.equalsIgnoreCase("I") ? Integer.valueOf(currFieldValue.toString()) : (currFieldType.equalsIgnoreCase("Number") || currFieldType.equalsIgnoreCase("N") || currFieldType.equalsIgnoreCase("D") ? Double.valueOf(currFieldValue.toString()) : currFieldValue.trim());
                }
            }
        }
        catch (SAXParseException saxe) {
            WorkflowLogger.info("WorkflowProcessInstanceMonitorEJB [" + WorkflowShedule.SCHEDULER_INVOCATION_CTR + "] :Overlooking SAXParseException on getting value of :[" + currFieldName + "].....");
            throw new BaseException(saxe);
        }
        catch (BaseException be) {
            throw be;
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
        WorkflowLogger.info("Returning value :[" + fieldValue + "]");
        return fieldValue;
    }

    private Document parseString(String xmlString) throws Exception {
        Document dom = null;
        E12GenericUtility genericUtility = new E12GenericUtility();
        dom = genericUtility.parseString(xmlString);
        return dom;
    }

    private InitialContext getInitialContext() throws BaseException {
        InitialContext ctx = null;
        try {
            AppConnectParm appConnect = new AppConnectParm();
            ctx = new InitialContext(appConnect.getProperty());
        }
        catch (BaseException be) {
            throw be;
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
        return ctx;
    }

    private Connection getConnection() throws BaseException {
        Connection con = null;
        try {
            if (this.commonCon != null) {
                con = this.commonCon;
            } else if (this.userInfo != null && E12GenericUtility.checkNull(this.userInfo.getTransDB()).length() > 0) {
                ConnDriver connDriver = new ConnDriver();
                con = connDriver.getConnectDB(this.userInfo.getTransDB());
            } else {
                ConnDriver connDriver = new ConnDriver();
                con = connDriver.getConnectDB(CommonConstants.WRKFLW_DB);
            }
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
        return con;
    }

    private void checkProcessInstanceStatus(String processId, String refId, String refser, Connection con) throws BaseException {
        this.logMessageBuf.append("\ncheckProcessInstanceStatus() is called..........::START");
        Statement pstmt = null;
        Statement pstmtUpd = null;
        String instanceId = "";
        String processInstLockQuery = "";
        Statement pstmtLock = null;
        ResultSet rsLock = null;
        try {
            try {
                String processInstExist = "";
                String dbName = CommonConstants.DB_NAME;
                processInstExist = "SELECT INSTANCE_ID FROM WF_PRC_STATUS WHERE PROCESS_ID=? AND ACTIVITY_ID=? AND REF_SER=? AND REF_ID=? AND SEQ_ID=? AND WF_ABORT IS NULL ";
                this.logMessageBuf.append("\nChecking whether ProcessInstance already created Query for Process Id :[" + processId + "] REF_ID  :[" + refId + "]");
                WorkflowLogger.info("Checking whether ProcessInstance already created Query for Process Id :[" + processId + "] REF_ID  :[" + refId + "]");
                pstmt = con.prepareStatement(processInstExist);
                pstmt.setString(1, processId);
                pstmt.setString(2, processId);
                pstmt.setString(3, refser);
                pstmt.setString(4, refId);
                pstmt.setInt(5, 1);
                ResultSet rs = pstmt.executeQuery();
                if (rs.next()) {
                    instanceId = rs.getString("INSTANCE_ID");
                    this.logMessageBuf.append("\ninstanceId[" + instanceId + "]");
                    WorkflowLogger.info("instanceId[" + instanceId + "]");
                    pstmt.close();
                    pstmt = null;
                    processInstExist = "";
                }
                rs.close();
                rs = null;
                BaseLogger.log("3", null, null, "Before locking the wf_prc_status record checking if instance id found =[" + instanceId + "]");
                if (instanceId != null && instanceId.trim().length() > 0) {
                    if (dbName.equalsIgnoreCase("db2")) {
                        processInstLockQuery = "SELECT PROCESS_ID,INSTANCE_ID,ACTIVITY_ID,SEQ_ID FROM WF_PRC_STATUS WHERE PROCESS_ID=? AND INSTANCE_ID = ? AND ACTIVITY_ID = ? AND SEQ_ID=? AND REF_ID=? AND WF_ABORT IS NULL FOR UPDATE WITH RS ";
                    } else if (dbName.equalsIgnoreCase("mssql")) {
                        processInstLockQuery = "SELECT PROCESS_ID,INSTANCE_ID,ACTIVITY_ID,SEQ_ID FROM WF_PRC_STATUS (UPDLOCK) WHERE PROCESS_ID=? AND INSTANCE_ID = ? AND ACTIVITY_ID = ? AND SEQ_ID=? AND REF_ID=? AND WF_ABORT IS NULL ";
                    } else if (dbName.equalsIgnoreCase("oracle")) {
                        processInstLockQuery = "SELECT PROCESS_ID,INSTANCE_ID,ACTIVITY_ID,SEQ_ID FROM WF_PRC_STATUS WHERE PROCESS_ID=? AND INSTANCE_ID = ? AND ACTIVITY_ID = ? AND SEQ_ID=? AND REF_ID=? AND WF_ABORT IS NULL FOR UPDATE NOWAIT  ";
                    }
                    pstmtLock = con.prepareStatement(processInstLockQuery);
                    pstmtLock.setString(1, processId);
                    pstmtLock.setString(2, instanceId);
                    pstmtLock.setString(3, processId);
                    pstmtLock.setInt(4, 1);
                    pstmtLock.setString(5, refId);
                    rsLock = pstmtLock.executeQuery();
                    if (rsLock.next()) {
                        String wfPrcUpdSql = "UPDATE WF_PRC_STATUS SET WF_ABORT = 'Y' WHERE PROCESS_ID = ? AND REF_ID = ? ";
                        this.logMessageBuf.append("\nprocessId =[" + processId + "], refId=[" + refId + "]");
                        pstmtUpd = con.prepareStatement(wfPrcUpdSql);
                        pstmtUpd.setString(1, processId);
                        pstmtUpd.setString(2, refId);
                        int updCnt = pstmtUpd.executeUpdate();
                        this.logMessageBuf.append("\nUPDATE WF_PRC_STATUS SET WF_ABORT = 'Y' WHERE PROCESS_ID = ? AND REF_ID = ?  :: updCnt=[" + updCnt + "]");
                    }
                }
            }
            catch (Exception e) {
                throw new BaseException(e);
            }
        }
        finally {
            try {
                this.logMessageBuf.append("\ncheckProcessInstanceStatus() is called..........::END");
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (pstmtUpd != null) {
                    pstmtUpd.close();
                    pstmtUpd = null;
                }
                if (rsLock != null) {
                    rsLock.close();
                    rsLock = null;
                }
                if (pstmtLock != null) {
                    pstmtLock.close();
                    pstmtLock = null;
                }
            }
            catch (Exception e) {
                throw new BaseException(e);
            }
        }
    }

    private Document parsingFile(String writeFileString) throws BaseException {
        BufferedWriter parseFileWriter = null;
        Document dom = null;
        try {
            try {
                E12GenericUtility genericUtility = new E12GenericUtility();
                double randomNo = Math.random();
                if (!new File(String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "log").exists()) {
                    new File(String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "log").mkdirs();
                }
                if (!new File(String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "log" + File.separator + "workflwParseFile" + randomNo + ".xml").exists()) {
                    new File(String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "log" + File.separator + "workflwParseFile" + randomNo + ".xml").createNewFile();
                }
                String parseFileName = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "log" + File.separator + "workflwParseFile" + randomNo + ".xml";
                WorkflowLogger.info("writeParsingFile:parseFileName[" + parseFileName + "]");
                parseFileWriter = new BufferedWriter(new FileWriter(parseFileName));
                parseFileWriter.write(writeFileString);
                parseFileWriter.flush();
                parseFileWriter.close();
                parseFileWriter = null;
                dom = genericUtility.parseFile(parseFileName);
            }
            catch (Exception e) {
                dom = null;
                throw new BaseException(e);
            }
        }
        finally {
            try {
                if (parseFileWriter != null) {
                    parseFileWriter.flush();
                    parseFileWriter.close();
                    parseFileWriter = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                parseFileWriter = null;
            }
        }
        return dom;
    }

    private Document parseXMLFile(Object sourceXMLFile) throws Exception {
        Document dom = null;
        try {
            File file = null;
            file = sourceXMLFile.getClass().getName().equalsIgnoreCase("java.lang.String") ? new File((String)sourceXMLFile) : (File)sourceXMLFile;
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            dbf.setIgnoringComments(true);
            DocumentBuilder parser = dbf.newDocumentBuilder();
            dom = parser.parse(file);
        }
        catch (Exception e) {
            dom = null;
            WorkflowLogger.info("Exception :WorkflowEngineEJB :parseFile :\n" + e.getMessage());
            throw e;
        }
        return dom;
    }

    private void setCommonCon(Connection remoteCon) throws Exception {
        try {
            this.commonCon = remoteCon;
        }
        catch (Exception e) {
            this.commonCon = null;
            WorkflowLogger.info("Exception :WorkflowEngineEJB :parseFile :\n" + e.getMessage());
            throw e;
        }
    }

    @Override
    public String sendErrorMail(String processInstanceId, String resultStr) {
        String wrkflwErrDirectory = "";
        try {
            AppConnectParm appConnect = new AppConnectParm();
            InitialContext ctx = new InitialContext(appConnect.getProperty());
            DBAccessEJB dbAccessEJB = new DBAccessEJB();
            ArrayList mailDetailList = dbAccessEJB.getMailDetailList("WRKFLWERR");
            dbAccessEJB = null;
            BaseLogger.log("3", null, null, "[ITMMailInfo] mailDetailList  :" + mailDetailList + ":");
            if (mailDetailList.size() > 0) {
                if ((String)mailDetailList.get(0) != null) {
                    wrkflwErrDirectory = this.getWrkflwErrorDir(processInstanceId);
                    try {
                        String toAddr = (String)mailDetailList.get(0);
                        EMail emailObj = new EMail();
                        StringBuffer mailInfoXml = new StringBuffer();
                        mailInfoXml.append("<MAILINFO>");
                        mailInfoXml.append("<TO_ADD><![CDATA[" + toAddr + "]]></TO_ADD>");
                        mailInfoXml.append("<SUBJECT><![CDATA[ " + wrkflwErrDirectory + " : Error Occured during execution of process instance id " + processInstanceId + "]]></SUBJECT>");
                        mailInfoXml.append("<MESSAGE><![CDATA[ resultStr " + resultStr + "]]></MESSAGE>");
                        mailInfoXml.append("</MAILINFO>");
                        WorkflowLogger.info("Sending mail ...");
                    }
                    catch (Exception e) {
                        String toAddr = (String)mailDetailList.get(0);
                        EMail emailObj = new EMail();
                        StringBuffer mailInfoXml = new StringBuffer();
                        mailInfoXml.append("<MAILINFO>");
                        mailInfoXml.append("<TO_ADD><![CDATA[" + toAddr + "]]></TO_ADD>");
                        mailInfoXml.append("<SUBJECT><![CDATA[ " + wrkflwErrDirectory + " : Error Occured during execution of process instance id " + processInstanceId + "]]></SUBJECT>");
                        mailInfoXml.append("<MESSAGE><![CDATA[ Exception occured while parsing the result str ]]></MESSAGE>");
                        mailInfoXml.append("</MAILINFO>");
                        WorkflowLogger.info("Sending mail without exception details ");
                    }
                } else {
                    WorkflowLogger.info("To addr not defined for WRKFLWERR");
                }
            } else {
                WorkflowLogger.info("Mail format not defined for WRKFLWERR");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return wrkflwErrDirectory;
    }

    @Override
    public String sendErrorMail(String processInstanceId, String resultStr, Connection conn) {
        String wrkflwErrDirectory = "";
        try {
            BaseLogger.log("3", null, null, "In WorkflowEngineEJB 2897 conn calling sendErrorMail........!!!!");
            AppConnectParm appConnect = new AppConnectParm();
            InitialContext ctx = new InitialContext(appConnect.getProperty());
            DBAccessEJB dbAccessEJB = new DBAccessEJB();
            ArrayList mailDetailList = dbAccessEJB.getMailDetailList("WRKFLWERR", conn);
            dbAccessEJB = null;
            BaseLogger.log("3", null, null, "[ITMMailInfo] mailDetailList  :" + mailDetailList + ":");
            if (mailDetailList.size() > 0) {
                if ((String)mailDetailList.get(0) != null) {
                    wrkflwErrDirectory = this.getWrkflwErrorDir(processInstanceId);
                    try {
                        String toAddr = (String)mailDetailList.get(0);
                        EMail emailObj = new EMail();
                        StringBuffer mailInfoXml = new StringBuffer();
                        mailInfoXml.append("<MAILINFO>");
                        mailInfoXml.append("<TO_ADD><![CDATA[" + toAddr + "]]></TO_ADD>");
                        mailInfoXml.append("<SUBJECT><![CDATA[ " + wrkflwErrDirectory + " : Error Occured during execution of process instance id " + processInstanceId + "]]></SUBJECT>");
                        mailInfoXml.append("<MESSAGE><![CDATA[ resultStr " + resultStr + "]]></MESSAGE>");
                        mailInfoXml.append("</MAILINFO>");
                        WorkflowLogger.info("Sending mail ...");
                    }
                    catch (Exception e) {
                        String toAddr = (String)mailDetailList.get(0);
                        EMail emailObj = new EMail();
                        StringBuffer mailInfoXml = new StringBuffer();
                        mailInfoXml.append("<MAILINFO>");
                        mailInfoXml.append("<TO_ADD><![CDATA[" + toAddr + "]]></TO_ADD>");
                        mailInfoXml.append("<SUBJECT><![CDATA[ " + wrkflwErrDirectory + " : Error Occured during execution of process instance id " + processInstanceId + "]]></SUBJECT>");
                        mailInfoXml.append("<MESSAGE><![CDATA[ Exception occured while parsing the result str ]]></MESSAGE>");
                        mailInfoXml.append("</MAILINFO>");
                        WorkflowLogger.info("Sending mail without exception details ");
                    }
                } else {
                    WorkflowLogger.info("To addr not defined for WRKFLWERR");
                }
            } else {
                WorkflowLogger.info("Mail format not defined for WRKFLWERR");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return wrkflwErrDirectory;
    }

    @Override
    public String getWrkflwErrorDir(String processInstanceId) {
        String[] fileList;
        Timestamp currTime = new Timestamp(System.currentTimeMillis());
        String errDirName = "WERR:" + processInstanceId + ":" + currTime;
        String serverLogPath = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "server" + File.separator + "default" + File.separator + "log";
        File errDir = new File(String.valueOf(serverLogPath) + File.separator + errDirName);
        if (errDir != null && !errDir.exists()) {
            errDir.mkdir();
        } else {
            errDirName = "WERR:" + processInstanceId + ":" + currTime;
            errDir = new File(String.valueOf(serverLogPath) + File.separator + errDirName);
            errDir.mkdir();
        }
        String[] stringArray = fileList = new String[]{"server.log"};
        int n = fileList.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            try {
                File logFile = new File(String.valueOf(serverLogPath) + File.separator + fileName);
                if (logFile.exists()) {
                    FileUtils.copyFileToDirectory((File)logFile, (File)new File(String.valueOf(serverLogPath) + File.separator + errDirName), (boolean)true);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++n2;
        }
        BaseLogger.log("2", null, null, "Returning Directory Name [" + errDirName + "]");
        return errDirName;
    }

    private int randomNumberBetween(int start, int end) {
        int randomNumber = 0;
        randomNumber = (int)((double)(end - start + 1) * Math.random() + (double)start);
        return randomNumber;
    }

    private void copyFile(String srcFilePath, String destFilePath) {
        File srcFile = new File(srcFilePath);
        File destFile = new File(destFilePath);
        try {
            if (srcFile != null && srcFile.exists()) {
                FileInputStream ioStream = new FileInputStream(srcFile);
                FileOutputStream outStream = new FileOutputStream(destFile);
                byte[] b = new byte[1024];
                int len = 0;
                do {
                    len = ioStream.read(b);
                    BaseLogger.log("3", null, null, len);
                    outStream.write(b, 0, len);
                } while (len == 1024);
                ioStream.close();
                outStream.close();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            BaseLogger.log("0", null, null, "Source File not found [" + srcFilePath + "] \n FileNotFoundException [" + e.getMessage() + "]");
        }
        catch (IOException e) {
            e.printStackTrace();
            BaseLogger.log("0", null, null, "IOException [" + e.getMessage() + "]");
        }
    }

    @Override
    public String updateProcessInstance(String processId, String objName, String refSer, String refId, String roleCodeInit, String entityCodeInit, String processInputXML, Connection remoteCon) throws RemoteException, BaseException {
        WorkflowLogger.info("WorkflowProcessInstanceMonitorEJB.updateProcessInstance.SCHEDULER_INVOCATION_CTR [" + WorkflowShedule.SCHEDULER_INVOCATION_CTR + "]");
        this.logMessageBuf.append("\nupdateProcessInstance >> WorkflowProcessInstanceMonitorEJB.updateProcessInstance.SCHEDULER_INVOCATION_CTR [" + WorkflowShedule.SCHEDULER_INVOCATION_CTR + "]");
        String processInstanceId = "";
        Connection con = null;
        Statement pstmt = null;
        Statement proc = null;
        String isComplete = "false";
        E12GenericUtility genericUtility = new E12GenericUtility();
        int seqId = 1;
        int instanceId = 0;
        String maxSeqIdQry = "";
        boolean isLocalConn = false;
        boolean isException = false;
        boolean isError = false;
        boolean isRecordLocked = false;
        String errorCode = "";
        try {
            try {
                WorkflowLogger.info("Create Process Instance for Process Id :[" + processId + "]refId[" + refId + "]");
                this.logMessageBuf.append("\nupdateProcessInstance >> Create Process Instance for Process Id :[" + processId + "]refId[" + refId + "]");
                if (WorkflowMetaDataManager.getInstance().isProcessMetadataExists(processId)) {
                    WorkflowProcessDataMangerEJB workflowProcessDataManger = new WorkflowProcessDataMangerEJB();
                    if (remoteCon != null) {
                        con = remoteCon;
                    } else {
                        con = this.getConnection();
                        isLocalConn = true;
                        this.logMessageBuf.append("\nupdateProcessInstance >>isLocalConn = [" + isLocalConn + "]");
                    }
                    if (!"P".equalsIgnoreCase(this.getProcessStatus(processId, objName, refSer, refId, con))) {
                        String[] processInsatnceIdArry;
                        if (refId != null && refId.contains(":") && (processInsatnceIdArry = refId.split(":")).length > 1) {
                            instanceId = Integer.parseInt(processInsatnceIdArry[1] == null ? "0" : processInsatnceIdArry[1]);
                        }
                        maxSeqIdQry = "SELECT MAX(SEQ_ID) AS MAX_SEQ_ID FROM WF_PRC_STATUS WHERE PROCESS_ID ='" + processId + "' AND INSTANCE_ID ='" + instanceId + "'";
                        BaseLogger.log("3", null, null, "maxSeqIdQry --" + maxSeqIdQry);
                        this.logMessageBuf.append("\nupdateProcessInstance >> maxSeqIdQry ::" + maxSeqIdQry);
                        pstmt = con.prepareStatement(maxSeqIdQry);
                        ResultSet rs = pstmt.executeQuery();
                        if (rs.next()) {
                            seqId = rs.getInt("MAX_SEQ_ID");
                            ++seqId;
                        }
                        WorkflowLogger.info(" max instanceId found for process_id [" + processId + "] is [" + instanceId + "]");
                        rs.close();
                        rs = null;
                        pstmt.close();
                        pstmt = null;
                        this.logMessageBuf.append("\nupdateProcessInstance >>seqId = [" + seqId + "]");
                        WorkflowLogger.info("createProcessInstance refId [" + refId + "]");
                        if (refId == null || refId != null && (refId.trim().length() == 0 || refId.equalsIgnoreCase("null"))) {
                            refId = String.valueOf(processId) + ":" + instanceId + ":" + processId;
                            WorkflowLogger.info("Created refId [" + refId + "]");
                            this.logMessageBuf.append("\nupdateProcessInstance >> Created refId = [" + refId + "]");
                        }
                        BaseLogger.log("3", null, null, "WorkflowProcessInstanceMonitorEJB : updateProcessInstance");
                        String activityDescr = WorkflowMetaDataManager.getInstance().getActivityName(processId, processId);
                        BaseLogger.log("3", null, null, "updateProcessInstance : activityDescr = [" + activityDescr + "]");
                        String createPrcInsQry = "INSERT INTO WF_PRC_STATUS(PROCESS_ID,INSTANCE_ID,ACTIVITY_ID,PROCESS_STATUS,STATUS_DATE,ROLE_CODE__INIT,ENTITY_CODE__INIT,OBJ_NAME,REF_SER,REF_ID,PREVIOUS_ACTIVITY,SEQ_ID,ACTIVITY_DESCR) VALUES ('" + processId + "'," + instanceId + ",'" + processId + "',0, " + this.sysdateStr + " ,'" + roleCodeInit + "','" + entityCodeInit + "','" + objName + "','" + refSer + "','" + refId + "','" + processId + "'," + seqId + ",'" + activityDescr + "')";
                        this.logMessageBuf.append("\nupdateProcessInstance >> Create Process Instance Insert Query ::" + createPrcInsQry);
                        WorkflowLogger.info("Create Process Instance Insert Query :[" + createPrcInsQry + "]");
                        pstmt = con.prepareStatement(createPrcInsQry);
                        int noOfRowsInserted = pstmt.executeUpdate();
                        pstmt.close();
                        pstmt = null;
                        WorkflowLogger.info("\n@@@@@@@@ Saving with Inserting ................ noOfRowsInserted " + noOfRowsInserted + "]");
                        isComplete = workflowProcessDataManger.updateProcessInputData(processId, instanceId, processInputXML, con, refSer, refId);
                        this.logMessageBuf.append("\nupdateProcessInstance >>isComplete = [" + isComplete + "]");
                        if (!isComplete.equalsIgnoreCase("true")) {
                            con.rollback();
                            this.logMessageBuf.append("\nupdateProcessInstance >> Failed to invoke Workflow, Please re-save the transaction");
                            isError = true;
                            errorCode = "WFERROR1";
                        }
                    } else {
                        this.logMessageBuf.append("\nupdateProcessInstance >> Can't invoke Workflow, process initiated for current Transaction");
                        isError = true;
                        errorCode = "WFERROR2";
                    }
                } else {
                    con.rollback();
                    this.logMessageBuf.append("\nupdateProcessInstance >> Process Metadata does not exists");
                    isError = true;
                    errorCode = "WFERROR3";
                }
                boolean isWfComplete = false;
                isWfComplete = this.checkForWorkflowEntry(con, processId, instanceId, refId);
                this.logMessageBuf.append("\nisWfComplete =[" + isWfComplete + "]");
                if (!isWfComplete) {
                    isError = true;
                    errorCode = "WFERROR4";
                }
            }
            catch (SQLException sqe) {
                try {
                    con.rollback();
                    isException = true;
                    String errMSg = sqe.getMessage();
                    if (errMSg.contains("Error Code: 1205") || errMSg.contains("SQLCODE: -911") || errMSg.contains("ORA-00054")) {
                        isRecordLocked = true;
                        errorCode = "ROWLOCKED";
                    }
                    StringWriter writerStr = new StringWriter();
                    PrintWriter traceWriter = new PrintWriter(writerStr);
                    sqe.printStackTrace(traceWriter);
                    String stackTraceStr = writerStr.toString();
                    this.logMessageBuf.append("\nupdateProcessInstance >> BaseException occurs.......... ::START");
                    this.logMessageBuf.append("\nstackTraceStr ::" + stackTraceStr);
                    this.logMessageBuf.append("\nupdateProcessInstance >> BaseException occurs.......... ::END");
                    throw new BaseException(sqe);
                }
                catch (Exception ee) {
                    throw new BaseException(ee);
                }
            }
            catch (BaseException be) {
                try {
                    con.rollback();
                    isException = true;
                    String errMSg = be.getMessage();
                    if (errMSg.contains("Error Code: 1205") || errMSg.contains("SQLCODE: -911") || errMSg.contains("ORA-00054")) {
                        isRecordLocked = true;
                        errorCode = "ROWLOCKED";
                    }
                    StringWriter writerStr = new StringWriter();
                    PrintWriter traceWriter = new PrintWriter(writerStr);
                    be.printStackTrace(traceWriter);
                    String stackTraceStr = writerStr.toString();
                    this.logMessageBuf.append("\nupdateProcessInstance >> BaseException occurs.......... ::START");
                    this.logMessageBuf.append("\nupdateProcessInstance >> stackTraceStr ::" + stackTraceStr);
                    this.logMessageBuf.append("\nupdateProcessInstance >> BaseException occurs.......... ::END");
                    throw be;
                }
                catch (Exception ee) {
                    throw new BaseException(ee);
                }
            }
            catch (Exception e) {
                try {
                    con.rollback();
                    isException = true;
                    String errMSg = e.getMessage();
                    if (errMSg.contains("Error Code: 1205") || errMSg.contains("SQLCODE: -911") || errMSg.contains("ORA-00054")) {
                        isRecordLocked = true;
                        errorCode = "ROWLOCKED";
                    }
                    StringWriter writerStr = new StringWriter();
                    PrintWriter traceWriter = new PrintWriter(writerStr);
                    e.printStackTrace(traceWriter);
                    String stackTraceStr = writerStr.toString();
                    this.logMessageBuf.append("\nupdateProcessInstance>> Exception occurs.......... ::START");
                    this.logMessageBuf.append("\nupdateProcessInstance >> stackTraceStr ::" + stackTraceStr);
                    this.logMessageBuf.append("\nupdateProcessInstance >> Exception occurs.......... ::END");
                    throw new BaseException(e);
                }
                catch (Exception ee) {
                    throw new BaseException(ee);
                }
            }
        }
        finally {
            block45: {
                try {
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (con != null) {
                        if (proc != null) {
                            proc.close();
                            proc = null;
                        }
                        if (!con.isClosed() && isLocalConn) {
                            if (isException) {
                                con.rollback();
                            } else {
                                con.commit();
                            }
                            con.close();
                            con = null;
                        }
                    }
                    this.logMessageBuf.append("\nisError =[" + isError + "]");
                    if (isError) {
                        ITMDBAccessEJB itmDBAccessComp = new ITMDBAccessEJB();
                        processInstanceId = itmDBAccessComp.getErrorString("", errorCode, " ");
                        this.logMessageBuf.append("\nError String =[" + processInstanceId + "]");
                        itmDBAccessComp = null;
                    }
                    if (!isError && !isException) break block45;
                    try {
                        BufferedWriter logFileWriter = null;
                        String logString = "";
                        String logFileName = String.valueOf(processId) + ":" + refId + ":" + System.currentTimeMillis();
                        logFileName = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "log" + File.separator + logFileName + ".txt";
                        this.logMessageBuf.append("\nlogFileName =[" + logFileName + "]");
                        logString = this.logMessageBuf.toString();
                        BaseLogger.log("3", null, null, "logString ::" + logString);
                        if (!new File(String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "log").exists()) {
                            new File(String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "log").mkdirs();
                        }
                        if (!new File(String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "log" + File.separator + logFileName + ".txt").exists()) {
                            new File(String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "log" + File.separator + logFileName + ".txt").createNewFile();
                        }
                        logFileWriter = new BufferedWriter(new FileWriter(logFileName));
                        logFileWriter.newLine();
                        logFileWriter.write(logString);
                        logFileWriter.flush();
                        logFileWriter.close();
                        logFileWriter = null;
                    }
                    catch (Exception e) {
                        throw new BaseException(e);
                    }
                }
                catch (Exception e) {
                    throw new BaseException(e);
                }
            }
        }
        return processInstanceId;
    }

    private int checkForRetryCount(Connection conn, String processId, String instanceId, String activityId, String seqId) {
        int retryCount = 0;
        PreparedStatement pstmtRetryCount = null;
        ResultSet rsRetryCount = null;
        try {
            try {
                String retryCountSql = "SELECT (CASE WHEN RETRY_COUNTER IS NULL THEN 0 ELSE RETRY_COUNTER END) AS RETRY_COUNT FROM WF_PRC_STATUS WHERE PROCESS_ID = ? AND INSTANCE_ID = ? AND ACTIVITY_ID = ? AND SEQ_ID = ? ";
                pstmtRetryCount = conn.prepareStatement(retryCountSql);
                pstmtRetryCount.setString(1, processId);
                pstmtRetryCount.setString(2, instanceId);
                pstmtRetryCount.setString(3, activityId);
                pstmtRetryCount.setInt(4, Integer.parseInt(seqId));
                rsRetryCount = pstmtRetryCount.executeQuery();
                if (rsRetryCount.next()) {
                    retryCount = rsRetryCount.getInt("RETRY_COUNT");
                }
                BaseLogger.log("3", null, null, "retryCount[checkForRetryCount] =[" + retryCount + "]");
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (rsRetryCount != null) {
                        rsRetryCount.close();
                        rsRetryCount = null;
                    }
                    if (pstmtRetryCount != null) {
                        pstmtRetryCount.close();
                        pstmtRetryCount = null;
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                if (rsRetryCount != null) {
                    rsRetryCount.close();
                    rsRetryCount = null;
                }
                if (pstmtRetryCount != null) {
                    pstmtRetryCount.close();
                    pstmtRetryCount = null;
                }
            }
            catch (Exception exception) {}
        }
        return retryCount;
    }

    private boolean checkForWorkflowEntry(Connection conn, String processId, int instanceId, String refID) throws BaseException {
        this.logMessageBuf.append("\ncheckForWorkflowEntry() is called........ ::START");
        Statement pstmtWfData = null;
        Statement pstmtWfStatus = null;
        ResultSet rsWfData = null;
        ResultSet rsWfStatus = null;
        int wfPrcDataCnt = 0;
        int wfPrcStatusCnt = 0;
        boolean isWfEntryComplete = false;
        try {
            try {
                this.logMessageBuf.append("\nprocessId =[" + processId + "], instanceId =[" + instanceId + "], refID =[" + refID + "]");
                String wfDataSql = "SELECT COUNT(*) AS WF_DATA_COUNT FROM WF_PRC_DATA WHERE PROCESS_ID = ? AND INSTANCE_ID = ?";
                this.logMessageBuf.append("\nwfDataSql =[" + wfDataSql + "]");
                pstmtWfData = conn.prepareStatement(wfDataSql);
                pstmtWfData.setString(1, processId);
                pstmtWfData.setInt(2, instanceId);
                rsWfData = pstmtWfData.executeQuery();
                if (rsWfData.next()) {
                    wfPrcDataCnt = rsWfData.getInt("WF_DATA_COUNT");
                }
                this.logMessageBuf.append("\nwfPrcDataCnt =[" + wfPrcDataCnt + "]");
                BaseLogger.log("3", null, null, "wfPrcDataCnt[checkForWorkflowEntry] =[" + wfPrcDataCnt + "]");
                String wfPrcSql = "SELECT COUNT(*) AS WF_PRC_COUNT FROM WF_PRC_STATUS WHERE PROCESS_ID = ? AND INSTANCE_ID = ? AND REF_ID = ?";
                this.logMessageBuf.append("\nwfPrcSql =[" + wfPrcSql + "]");
                pstmtWfStatus = conn.prepareStatement(wfPrcSql);
                pstmtWfStatus.setString(1, processId);
                pstmtWfStatus.setInt(2, instanceId);
                pstmtWfStatus.setString(3, refID);
                rsWfStatus = pstmtWfStatus.executeQuery();
                if (rsWfStatus.next()) {
                    wfPrcStatusCnt = rsWfStatus.getInt("WF_PRC_COUNT");
                }
                this.logMessageBuf.append("\nwfPrcStatusCnt =[" + wfPrcStatusCnt + "]");
                BaseLogger.log("3", null, null, "wfPrcStatusCnt[checkForWorkflowEntry] =[" + wfPrcStatusCnt + "]");
                if (wfPrcDataCnt > 0 && wfPrcStatusCnt > 0) {
                    isWfEntryComplete = true;
                }
                this.logMessageBuf.append("\nisWfEntryComplete =[" + isWfEntryComplete + "]");
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BaseException(e);
            }
        }
        finally {
            try {
                if (rsWfData != null) {
                    rsWfData.close();
                    rsWfData = null;
                }
                if (rsWfStatus != null) {
                    rsWfStatus.close();
                    rsWfStatus = null;
                }
                if (pstmtWfData != null) {
                    pstmtWfData.close();
                    pstmtWfData = null;
                }
                if (pstmtWfStatus != null) {
                    pstmtWfStatus.close();
                    pstmtWfStatus = null;
                }
                this.logMessageBuf.append("\ncheckForWorkflowEntry() is called........ ::END");
            }
            catch (Exception exception) {}
        }
        return isWfEntryComplete;
    }
}

