--1) Create Table Workflow:

CREATE TABLE WF_DESIGN
(
	WF_DESIGN_ID VARCHAR2(20) NOT NULL,
	DESCR VARCHAR2(60) NOT NULL,
	DET_DESCR VARCHAR2(500),
	WF_TYPE CHAR(1) NOT NULL,
	OBJ_NAME__INVOKE VARCHAR2(60) NOT NULL,
	INVOKE_METHOD CHAR(1) NOT NULL,
	XPDL_FILE VARCHAR2(20) NOT NULL,
	CHG_DATE DATE NOT NULL,
	CHG_USER CHAR(10) NOT NULL,
	CHG_TERM VARCHAR2(300) NOT NULL,
	ADD_DATE DATE NOT NULL,
	ADD_USER CHAR(10) NOT NULL,
	ADD_TERM VARCHAR2(300) NOT NULL,
	ROLE_SQL_INPUT VARCHAR2(30),
	CONSTRAINT WF_DESIGN_PK PRIMARY KEY (WF_DESIGN_ID)
);

CREATE TABLE WF_DESIGN_ROLE
(
	WF_DESIGN_ID VARCHAR2(20) NOT NULL,
	LINE_NO NUMBER(3,0) NOT NULL,
	ROLE_CODE CHAR(10) NOT NULL,
	ROLE_TYPE VARCHAR2(1) NOT NULL,
	EVENT_CARR VARCHAR2(1) NOT NULL,
	DESCR VARCHAR2(60) NOT NULL,
	USER_ID CHAR(10),
	SUBJECT_STR VARCHAR2(200),
	INCLUDE_DATA VARCHAR2(1),
	EMAIL_ADDR VARCHAR2(120),
	ROLE_ENTITY VARCHAR2(1),
	ROLE_ENTITY_SQL VARCHAR2(1000),
	DYN_ROLE_REF CHAR(20),
	ROLE_SQL_INPUT VARCHAR2(30),
	CONSTRAINT WF_DESIGN_ROLE_PK PRIMARY KEY (WF_DESIGN_ID, LINE_NO)
);

CREATE TABLE WF_DESIGN_RULE
(
	WF_DESIGN_ID VARCHAR2(20) NOT NULL,
	LINE_NO NUMBER(3,0) NOT NULL,
	RULE_CODE CHAR(10) NOT NULL,
	DESCR VARCHAR2(60) NOT NULL,
	RULE_TYPE CHAR(1),
	RULE_EXPRESSION VARCHAR2(1000),
	EXPRESSION_INPUT VARCHAR2(500),
  	CONSTRAINT WF_DESIGN_RULE_PK PRIMARY KEY (WF_DESIGN_ID, LINE_NO)
);

CREATE TABLE WF_DESIGN_ROUTE
(
	WF_DESIGN_ID CHAR(10) NOT NULL,
	LINE_NO NUMBER(3,0) NOT NULL,
	ROUTE_NAME VARCHAR2(20) NOT NULL,
	ROUTE_BLOCK VARCHAR2(20) NOT NULL,
	RULE_CODE CHAR(30) NOT NULL,
	RULE_INPUT VARCHAR2(100),
	ACTIVITY_CODE VARCHAR2(20) NOT NULL,
	ACTIVITY_INPUT VARCHAR2(500),
	ROLE_CODE__PERFORM VARCHAR2(10) NOT NULL,
	ACTIVITY_CODE__PREV VARCHAR2(20),
	CONSTRAINT WF_DESIGN_ROUTE_PK PRIMARY KEY (WF_DESIGN_ID, LINE_NO)
);

ALTER TABLE WF_DESIGN_ROUTE ADD DESCR VARCHAR2(60);

--2)REFSER:

Insert into REFSER (REF_SER,DESCR,TYPE,SYS_SER,PREFIX,CHG_DATE,CHG_USER,CHG_TERM,SEQ_NAME,TAX_FORM_REQD,SKILL_CODE)
values('WDESIG','Workflow Design','S',null,null,null,null,'BASE','WF_DESIGN_SEQ',null,null);

CREATE SEQUENCE WF_DESIGN_SEQ 
INCREMENT BY 1 
START WITH 1;

--3)TRANSETUP:

Insert into TRANSETUP (TRAN_WINDOW, SAVE_FLAG, VAL_FLAG, KEY_FLAG, KEY_STRING, UDF_1, UDF_2, UDF_3, UDF_4, UDF_5, REPEATE_ADD, CHG_DATE, CHG_USER, CHG_TERM, EDI_OPTION, SITE_ACC_COL, CONFIRM_COL, CONFIRM_VAL, REPEAT_ADD_DET, REPEATADDDET, LOAD_MODE, AUTO_CONFIRM, LEDG_POST_CONF, CHG_DATE_ON_CONF, TRAN_ID_COL, MAIL_OPTION, CONFIRM_MODE, GARBAGE_OPT, VAL_FLAG_EDI, VERIFY_PASSWORD, CUST_ACC_COL, SALES_PERS_ACC_COL, SUPP_ACC_COL, ITEM_SER_ACC_CODE, EMP_ACC_COL, ITEM_SER_ACC_COL, WORKFLOW_OPT, TABLE_NAME, APPLICATION, TABLE_DESC, TRAN_DATE_COL, TRAN_ID__FROM, TRAN_ID__TO, TABLE_NAME_DET1, TABLE_NAME_DET2, TABLE_NAME_DET3, MULTITIRE_OPT, REF_SER, VIEW_MODE, TAX_FORMS, SIGN_STATUS, USER_TRAN_WINDOW, CUSTOM_PREVIEW_OBJ, IGNOREERRLIST_ONLOAD, CHILDDATA_ARGOPT, EDIT_TMPLT, WRKFLW_INIT, EDITTAX, FORMAL_ARGS, AUDIT_TRAIL_OPT, EDIT_OPT, CACHE_OPT, OPTIMIZE_MODE, EDIT_EXPR, RATE_COL, QTY_COL, EDIT_EXPR_INP, RCP_CACHE_STATUS, PRINT_CONTROL, TRANSFER_MODE, PROFILE_ID__RES, TRAN_COMPL_MSG, PERIOD_OPTION, WRKFLW_PRIORITY, EXEC_TYPE, DISP_META_DATA, ALLOW_ATTACH, START_FORM, ISATTACHMENT, HEADER_FORM_NO, CONFIRM_DATE_COL, CONFIRM_BY_COL, MSG_ONSAVE, WF_STATUS, RESTART_FORM, CMS_PATH, BROW_DATA_DEF, DEF_VIEW, VIEW_OPTS, ISGWTINITIATED, DEFAULT_DATA_ROW, IN_WF_VAL, IN_WF_COL, CANCEL_VAL, CANCEL_COL, THUMB_ALT_COL, THUMB_IMAGE_COL, THUMB_OBJ, ATTACH_COUNT_MIN, FUNCTION_TYPE, COMPL_ACTION, DEFAULT_EDITOR, MSG_NO, OBJ_TYPE, STATUS_COL, ENABLE_EDITOR, OFFLINE_OPT, CLOSE_COL, CLOSE_VAL)
values ('w_wf_design','2','2','A','_SEQ10',null,null,null,null,null,'N',to_date('21-04-06','DD-MM-RR'),'BASE','1','0',null,null,null,'Y',null,null,null,'N',null,'wf_design_id',null,'0',null,null,null,null,null,null,null,null,null,'0','WF_DESIGN',null,null,null,null,null,null,null,null,null,'WDESIG','F',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,'D',null,null,null,null,null,null,null,'first_name','first_name','wf_design',null,null,null,'compact',null,'C',null,null,null,null,null);

--4)ITM2MENU:

Insert into ITM2MENU (APPLICATION,LEVEL_1,LEVEL_2,LEVEL_3,LEVEL_4,LEVEL_5,WIN_NAME,DESCR,COMMENTS,MENU_PATH,ICON_PATH,CLOSE_ICON,OPEN_ICON,OBJ_TYPE,CHG_DATE,CHG_TERM,CHG_USER,MOB_DEPLOY,DEFAULT_STATE,DEF_ACTION,MOB_DEPLY,ENT_TYPES) 
values ('SYS',35,1,0,0,0,'w_wf_design','Workflow Design','Workflow Design','SYS.35.1.0.0.0','strgcustomer.png',null,null,'T',null,null,null,'B',null,null,null,'0');


--5)OBJ_FORMS:

Insert into OBJ_FORMS (WIN_NAME, TITLE, OBJ_BROW_NAME, OBJ_EDIT_NAME, CROSS_UPDATE_EXPR, EXPR_FLD_INFO, TARGET_FLD_INFO, EXPR_COMMENT, FORM_NO, SCR_FLAG, AUTO_ACCEPT_SCAN, SCAN_FLAG, SCAN_METADATA, PROPERTY_INFO, SCAN_DELIMITER, COLUMN_ON_SAVE, AFTER_SAVE, EXT_SETUP, EXT_METADATA, EXT_COM, AUTO_ACCEPT_WEIGHDATA, FORM_TYPE, DISP_METADATA, PARENT_KEY_COL, QTY_COL, RATE_COL, ASSISTED_MODE, STORAGE_KEY_METADATA, SELECTION_MODE, DEFAULT_VIEW, AUTO_ADDON_ENTRY, DUPLICATE_ADD, DEFAULT_ROW_CNT, FREEZE_COL_POS, IS_MANDATORY, TRAN_ID_COL, SELECTION_OPT, KEY_INFO, THUMB_OBJ, THUMB_IMAGE_COL, THUMB_ALT_COL, FORM_NAME, FORM_ICON, FORM_VIEW_OPTS, X_COLUMN, Y_COLUMN, ACTION_ARG)
values ('w_wf_design','Design Workflow','d_wf_design11','d_wf_design21',null,null,null,null,'1','F',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,'T',null,null,null,null,null,null,null,null,'user','chg_user','chg_user',null,'DetailForm.png',null,null,null,null);
Insert into OBJ_FORMS (WIN_NAME, TITLE, OBJ_BROW_NAME, OBJ_EDIT_NAME, CROSS_UPDATE_EXPR, EXPR_FLD_INFO, TARGET_FLD_INFO, EXPR_COMMENT, FORM_NO, SCR_FLAG, AUTO_ACCEPT_SCAN, SCAN_FLAG, SCAN_METADATA, PROPERTY_INFO, SCAN_DELIMITER, COLUMN_ON_SAVE, AFTER_SAVE, EXT_SETUP, EXT_METADATA, EXT_COM, AUTO_ACCEPT_WEIGHDATA, FORM_TYPE, DISP_METADATA, PARENT_KEY_COL, QTY_COL, RATE_COL, ASSISTED_MODE, STORAGE_KEY_METADATA, SELECTION_MODE, DEFAULT_VIEW, AUTO_ADDON_ENTRY, DUPLICATE_ADD, DEFAULT_ROW_CNT, FREEZE_COL_POS, IS_MANDATORY, TRAN_ID_COL, SELECTION_OPT, KEY_INFO, THUMB_OBJ, THUMB_IMAGE_COL, THUMB_ALT_COL, FORM_NAME, FORM_ICON, FORM_VIEW_OPTS, X_COLUMN, Y_COLUMN, ACTION_ARG)
values ('w_wf_design','Role','d_wf_design11','d_wf_design21',null,null,null,null,'2','T',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,'DetailForm.png',null,null,null,null);
Insert into OBJ_FORMS (WIN_NAME, TITLE, OBJ_BROW_NAME, OBJ_EDIT_NAME, CROSS_UPDATE_EXPR, EXPR_FLD_INFO, TARGET_FLD_INFO, EXPR_COMMENT, FORM_NO, SCR_FLAG, AUTO_ACCEPT_SCAN, SCAN_FLAG, SCAN_METADATA, PROPERTY_INFO, SCAN_DELIMITER, COLUMN_ON_SAVE, AFTER_SAVE, EXT_SETUP, EXT_METADATA, EXT_COM, AUTO_ACCEPT_WEIGHDATA, FORM_TYPE, DISP_METADATA, PARENT_KEY_COL, QTY_COL, RATE_COL, ASSISTED_MODE, STORAGE_KEY_METADATA, SELECTION_MODE, DEFAULT_VIEW, AUTO_ADDON_ENTRY, DUPLICATE_ADD, DEFAULT_ROW_CNT, FREEZE_COL_POS, IS_MANDATORY, TRAN_ID_COL, SELECTION_OPT, KEY_INFO, THUMB_OBJ, THUMB_IMAGE_COL, THUMB_ALT_COL, FORM_NAME, FORM_ICON, FORM_VIEW_OPTS, X_COLUMN, Y_COLUMN, ACTION_ARG)
values ('w_wf_design','Rule','d_wf_design11','d_wf_design21',null,null,null,null,'3','T',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,'DetailForm.png',null,null,null,null);
Insert into OBJ_FORMS (WIN_NAME, TITLE, OBJ_BROW_NAME, OBJ_EDIT_NAME, CROSS_UPDATE_EXPR, EXPR_FLD_INFO, TARGET_FLD_INFO, EXPR_COMMENT, FORM_NO, SCR_FLAG, AUTO_ACCEPT_SCAN, SCAN_FLAG, SCAN_METADATA, PROPERTY_INFO, SCAN_DELIMITER, COLUMN_ON_SAVE, AFTER_SAVE, EXT_SETUP, EXT_METADATA, EXT_COM, AUTO_ACCEPT_WEIGHDATA, FORM_TYPE, DISP_METADATA, PARENT_KEY_COL, QTY_COL, RATE_COL, ASSISTED_MODE, STORAGE_KEY_METADATA, SELECTION_MODE, DEFAULT_VIEW, AUTO_ADDON_ENTRY, DUPLICATE_ADD, DEFAULT_ROW_CNT, FREEZE_COL_POS, IS_MANDATORY, TRAN_ID_COL, SELECTION_OPT, KEY_INFO, THUMB_OBJ, THUMB_IMAGE_COL, THUMB_ALT_COL, FORM_NAME, FORM_ICON, FORM_VIEW_OPTS, X_COLUMN, Y_COLUMN, ACTION_ARG)
values ('w_wf_design','Route','d_wf_design11','d_wf_design21',null,null,null,null,'4','T',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,'DetailForm.png',null,null,null,null);

--6)OBJ_ACTIONS:

Insert into OBJ_ACTIONS (OBJ_NAME, LINE_NO, IMAGE, DESCRIPTION, SERVICE_CODE, INTERACTIVE, RIGHTS_CHAR, TITLE, FORM_NO, SERVICE_HANDLER, PLACEMENT, ACTION_TYPE, TRAN_TYPE, CHG_DATE, CHG_TERM, CHG_USER, IS_CONFIRMATION_REQ, SEP_DUTY_OPT, RE_AUTH_OPT, SHOW_IN_PANEL, PAGE_CONTEXT, TYPE, ACTION_ARG, SWIPE_POSITION, MULTI_ROW_OPT, ACTION_ID, DEF_NODATA, IN_PROC_INTRUPT, ESTIMATED_TIME, ACTION_GROUP, DISPLAY_OPT, DISPLAY_MODE, SHOW_CONFIRM, REC_SPECIFIC)
values ('wf_design',1,'ibase/resource/objaction/add.svg','Adding New','a','a','A','Add','1',null,null,'S',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,'2',null,null);

Insert into OBJ_ACTIONS (OBJ_NAME, LINE_NO, IMAGE, DESCRIPTION, SERVICE_CODE, INTERACTIVE, RIGHTS_CHAR, TITLE, FORM_NO, SERVICE_HANDLER, PLACEMENT, ACTION_TYPE, TRAN_TYPE, CHG_DATE, CHG_TERM, CHG_USER, IS_CONFIRMATION_REQ, SEP_DUTY_OPT, RE_AUTH_OPT, SHOW_IN_PANEL, PAGE_CONTEXT, TYPE, ACTION_ARG, SWIPE_POSITION, MULTI_ROW_OPT, ACTION_ID, DEF_NODATA, IN_PROC_INTRUPT, ESTIMATED_TIME, ACTION_GROUP, DISPLAY_OPT, DISPLAY_MODE, SHOW_CONFIRM, REC_SPECIFIC)
values ('wf_design',3,'ibase/resource/objaction/edit.svg','Editing Existing Record','a','a','E','Edit','1',null,null,'S',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,'2','000',null);

Insert into OBJ_ACTIONS (OBJ_NAME, LINE_NO, IMAGE, DESCRIPTION, SERVICE_CODE, INTERACTIVE, RIGHTS_CHAR, TITLE, FORM_NO, SERVICE_HANDLER, PLACEMENT, ACTION_TYPE, TRAN_TYPE, CHG_DATE, CHG_TERM, CHG_USER, IS_CONFIRMATION_REQ, SEP_DUTY_OPT, RE_AUTH_OPT, SHOW_IN_PANEL, PAGE_CONTEXT, TYPE, ACTION_ARG, SWIPE_POSITION, MULTI_ROW_OPT, ACTION_ID, DEF_NODATA, IN_PROC_INTRUPT, ESTIMATED_TIME, ACTION_GROUP, DISPLAY_OPT, DISPLAY_MODE, SHOW_CONFIRM, REC_SPECIFIC)
values ('wf_design',4,'ibase/resource/objaction/createXML.svg','Adding New','wf_design_create_xml','1','D','Create XML','1','1','1','U',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,'2',null,null);

--7) OBJ_ITEMCHANGE:

Insert into OBJ_ITEMCHANGE (OBJ_NAME, FORM_NO, FIELD_NAME, MANDATORY)
values ('wf_design','1','itm_default','Y');
Insert into OBJ_ITEMCHANGE (OBJ_NAME, FORM_NO, FIELD_NAME, MANDATORY)
values ('wf_design','1','itm_defaultedit','Y');
Insert into OBJ_ITEMCHANGE (OBJ_NAME, FORM_NO, FIELD_NAME, MANDATORY)
values ('wf_design','2','itm_default','Y');
Insert into OBJ_ITEMCHANGE (OBJ_NAME, FORM_NO, FIELD_NAME, MANDATORY)
values ('wf_design','2','itm_defaultedit','Y');
Insert into OBJ_ITEMCHANGE (OBJ_NAME, FORM_NO, FIELD_NAME, MANDATORY)
values ('wf_design','2','role_code','Y');
Insert into OBJ_ITEMCHANGE (OBJ_NAME, FORM_NO, FIELD_NAME, MANDATORY)
values ('wf_design','3','rule_code','Y');
Insert into OBJ_ITEMCHANGE (OBJ_NAME, FORM_NO, FIELD_NAME, MANDATORY)
values ('wf_design','3','itm_default','Y');
Insert into OBJ_ITEMCHANGE (OBJ_NAME, FORM_NO, FIELD_NAME, MANDATORY)
values ('wf_design','3','itm_defaultedit','Y');
Insert into OBJ_ITEMCHANGE (OBJ_NAME,FORM_NO,FIELD_NAME,MANDATORY) values ('wf_design','4  ','activity_code','Y');
Insert into OBJ_ITEMCHANGE (OBJ_NAME,FORM_NO,FIELD_NAME,MANDATORY) values ('wf_design','4  ','activity_code__prev','Y');
Insert into OBJ_ITEMCHANGE (OBJ_NAME,FORM_NO,FIELD_NAME,MANDATORY) values ('wf_design','4  ','activity_input','Y');
Insert into OBJ_ITEMCHANGE (OBJ_NAME,FORM_NO,FIELD_NAME,MANDATORY) values ('wf_design','4  ','itm_default','Y');
Insert into OBJ_ITEMCHANGE (OBJ_NAME,FORM_NO,FIELD_NAME,MANDATORY) values ('wf_design','4  ','itm_defaultedit','Y');
Insert into OBJ_ITEMCHANGE (OBJ_NAME,FORM_NO,FIELD_NAME,MANDATORY) values ('wf_design','4  ','role_code__perform','Y');
Insert into OBJ_ITEMCHANGE (OBJ_NAME,FORM_NO,FIELD_NAME,MANDATORY) values ('wf_design','4  ','rule_code','Y');

--8) SYSTEM_EVENTS

Insert into SYSTEM_EVENTS (OBJ_NAME, EVENT_CODE, EVENT_CONTEXT, SERVICE_CODE, METHOD_RULE, OVERWRITE_CORE, CHG_DATE, CHG_USER, CHG_TERM, RESULT_HANDLE, COMP_TYPE, COMP_NAME, COMM_FORMAT)
values ('wf_design','post_item_change','1','poic_wf_design',null,'0',to_date('12-11-20','DD-MM-RR'),'base','BASE','2','JB','ibase.webitm.ejb.sys.WfDesign',null);

Insert into SYSTEM_EVENTS (OBJ_NAME, EVENT_CODE, EVENT_CONTEXT, SERVICE_CODE, METHOD_RULE, OVERWRITE_CORE, CHG_DATE, CHG_USER, CHG_TERM, RESULT_HANDLE, COMP_TYPE, COMP_NAME, COMM_FORMAT)
values ('wf_design','pre_validate','1','prv_wf_design',null,'0',to_date('12-11-20','DD-MM-RR'),'base','BASE','2','JB','ibase.webitm.ejb.sys.WfDesign',null);

--Insert into SYSTEM_EVENTS (OBJ_NAME, EVENT_CODE, EVENT_CONTEXT, SERVICE_CODE, METHOD_RULE, OVERWRITE_CORE, CHG_DATE, CHG_USER, CHG_TERM, RESULT_HANDLE, COMP_TYPE, COMP_NAME, COMM_FORMAT)
--values ('wf_design','wf_design_create_xml','1','wf_design_create_xml',null,'0',to_date('12-11-20','DD-MM-RR'),'base','BASE','2',null,null,null);

--9)SYSTEM_EVENT_SERVICES

Insert into SYSTEM_EVENT_SERVICES (SERVICE_CODE, SERVICE_DESCR, SERVICE_URI, SERVICE_PROVIDER, METHOD_NAME, RETURN_VALUE, RETURN_TYPE, RETURN_DESCR, RETURN_XFRM, CHG_DATE, CHG_USER, CHG_TERM, SERVICE_NAMESPACE, RES_ELEM, SOAP_ACTION)
values ('poic_wf_design','itemChanged ','http://localhost:9090/axis/services/ValidatorService',null,'itemChanged','String','S',null,null,to_date('12-11-20','DD-MM-RR'),'base ','User',null,null,null);

Insert into SYSTEM_EVENT_SERVICES (SERVICE_CODE, SERVICE_DESCR, SERVICE_URI, SERVICE_PROVIDER, METHOD_NAME, RETURN_VALUE, RETURN_TYPE, RETURN_DESCR, RETURN_XFRM, CHG_DATE, CHG_USER, CHG_TERM, SERVICE_NAMESPACE, RES_ELEM, SOAP_ACTION)
values ('prv_wf_design','validation','http://localhost:9090/axis/services/ValidatorService',null,'wfValData','String','S',null,null,to_date('12-11-20','DD-MM-RR'),'base   ','user',null,null,null);

Insert into SYSTEM_EVENT_SERVICES (SERVICE_CODE, SERVICE_DESCR, SERVICE_URI, SERVICE_PROVIDER, METHOD_NAME, RETURN_VALUE, RETURN_TYPE, RETURN_DESCR, RETURN_XFRM, CHG_DATE, CHG_USER, CHG_TERM, SERVICE_NAMESPACE, RES_ELEM, SOAP_ACTION)
values ('wf_design_create_xml',null,'/ibase/webitm/jsp/WorkflowDesign.jsp',null,'doPost','String','S',null,null,to_date('12-11-20','DD-MM-RR'),'base   ','user',null,null,null);

--10)SYSTEM _SERVICE_ARGS

Insert into SYSTEM_SERVICE_ARGS (SERVICE_CODE, LINE_NO, ARG_NAME, ARG_MODE, DESCR, ARG_TYPE, ARG_XFRM, CHG_DATE, CHG_USER, CHG_TERM, ARG_VALUE)
values ('poic_wf_design',1,'COMPONENT_TYPE','I',null,'S',null,to_date('05-08-07','DD-MM-RR'),null,null,'JB');

Insert into SYSTEM_SERVICE_ARGS (SERVICE_CODE, LINE_NO, ARG_NAME, ARG_MODE, DESCR, ARG_TYPE, ARG_XFRM, CHG_DATE, CHG_USER, CHG_TERM, ARG_VALUE)
values ('poic_wf_design',2,'COMPONENT_NAME','I',null,'S',null,to_date('05-08-07','DD-MM-RR'),null,null,'ibase.webitm.ejb.sys.WfDesign');

Insert into SYSTEM_SERVICE_ARGS (SERVICE_CODE, LINE_NO, ARG_NAME, ARG_MODE, DESCR, ARG_TYPE, ARG_XFRM, CHG_DATE, CHG_USER, CHG_TERM, ARG_VALUE)
values ('poic_wf_design',3,'XML_DATA','I',null,'S',null,to_date('05-08-07','DD-MM-RR'),null,null,null);

Insert into SYSTEM_SERVICE_ARGS (SERVICE_CODE, LINE_NO, ARG_NAME, ARG_MODE, DESCR, ARG_TYPE, ARG_XFRM, CHG_DATE, CHG_USER, CHG_TERM, ARG_VALUE)
values ('poic_wf_design',4,'XML_DATA_1','I',null,'S',null,to_date('05-08-07','DD-MM-RR'),null,null,null);

Insert into SYSTEM_SERVICE_ARGS (SERVICE_CODE, LINE_NO, ARG_NAME, ARG_MODE, DESCR, ARG_TYPE, ARG_XFRM, CHG_DATE, CHG_USER, CHG_TERM, ARG_VALUE)
values ('poic_wf_design',5,'XML_DATA_2','I',null,'S',null,to_date('05-08-07','DD-MM-RR'),null,null,null);

Insert into SYSTEM_SERVICE_ARGS (SERVICE_CODE, LINE_NO, ARG_NAME, ARG_MODE, DESCR, ARG_TYPE, ARG_XFRM, CHG_DATE, CHG_USER, CHG_TERM, ARG_VALUE)
values ('poic_wf_design',6,'OBJ_CONTEXT','I',null,'S',null,to_date('05-08-07','DD-MM-RR'),'SISIR     ','BASE',null);

Insert into SYSTEM_SERVICE_ARGS (SERVICE_CODE, LINE_NO, ARG_NAME, ARG_MODE, DESCR, ARG_TYPE, ARG_XFRM, CHG_DATE, CHG_USER, CHG_TERM, ARG_VALUE)
values ('poic_wf_design',7,'FOCUSED_COLUMN','I',null,'S',null,to_date('05-08-07','DD-MM-RR'),'SISIR     ','BASE',null);

Insert into SYSTEM_SERVICE_ARGS (SERVICE_CODE, LINE_NO, ARG_NAME, ARG_MODE, DESCR, ARG_TYPE, ARG_XFRM, CHG_DATE, CHG_USER, CHG_TERM, ARG_VALUE)
values ('poic_wf_design',8,'EDIT_FLAG','I',null,'S',null,to_date('05-08-07','DD-MM-RR'),'SISIR     ','BASE',null);

Insert into SYSTEM_SERVICE_ARGS (SERVICE_CODE, LINE_NO, ARG_NAME, ARG_MODE, DESCR, ARG_TYPE, ARG_XFRM, CHG_DATE, CHG_USER, CHG_TERM, ARG_VALUE)
values ('poic_wf_design',9,'XTRA_PARAMS','I',null,'S',null,to_date('05-08-07','DD-MM-RR'),'SISIR     ','BASE',null);

Insert into SYSTEM_SERVICE_ARGS (SERVICE_CODE, LINE_NO, ARG_NAME, ARG_MODE, DESCR, ARG_TYPE, ARG_XFRM, CHG_DATE, CHG_USER, CHG_TERM, ARG_VALUE)
values ('prv_wf_design',1,'COMPONENT_TYPE','I',null,'S',null,to_date('05-08-07','DD-MM-RR'),null,null,'JB');

Insert into SYSTEM_SERVICE_ARGS (SERVICE_CODE, LINE_NO, ARG_NAME, ARG_MODE, DESCR, ARG_TYPE, ARG_XFRM, CHG_DATE, CHG_USER, CHG_TERM, ARG_VALUE)
values ('prv_wf_design',2,'COMPONENT_NAME','I',null,'S',null,to_date('05-08-07','DD-MM-RR'),null,null,'ibase.webitm.ejb.sys.WfDesign');

Insert into SYSTEM_SERVICE_ARGS (SERVICE_CODE, LINE_NO, ARG_NAME, ARG_MODE, DESCR, ARG_TYPE, ARG_XFRM, CHG_DATE, CHG_USER, CHG_TERM, ARG_VALUE)
values ('prv_wf_design',3,'XML_DATA','I',null,'S',null,to_date('05-08-07','DD-MM-RR'),null,null,null);

Insert into SYSTEM_SERVICE_ARGS (SERVICE_CODE, LINE_NO, ARG_NAME, ARG_MODE, DESCR, ARG_TYPE, ARG_XFRM, CHG_DATE, CHG_USER, CHG_TERM, ARG_VALUE)
values ('prv_wf_design',4,'XML_DATA_1','I',null,'S',null,to_date('05-08-07','DD-MM-RR'),null,null,null);

Insert into SYSTEM_SERVICE_ARGS (SERVICE_CODE, LINE_NO, ARG_NAME, ARG_MODE, DESCR, ARG_TYPE, ARG_XFRM, CHG_DATE, CHG_USER, CHG_TERM, ARG_VALUE)
values ('prv_wf_design',5,'XML_DATA_2','I',null,'S',null,to_date('05-08-07','DD-MM-RR'),'SISIR     ','BASE',null);

Insert into SYSTEM_SERVICE_ARGS (SERVICE_CODE, LINE_NO, ARG_NAME, ARG_MODE, DESCR, ARG_TYPE, ARG_XFRM, CHG_DATE, CHG_USER, CHG_TERM, ARG_VALUE)
values ('prv_wf_design',6,'OBJ_CONTEXT','I',null,'S',null,to_date('05-08-07','DD-MM-RR'),'SISIR     ','BASE',null);

Insert into SYSTEM_SERVICE_ARGS (SERVICE_CODE, LINE_NO, ARG_NAME, ARG_MODE, DESCR, ARG_TYPE, ARG_XFRM, CHG_DATE, CHG_USER, CHG_TERM, ARG_VALUE)
values ('prv_wf_design',7,'EDIT_FLAG','I',null,'S',null,to_date('05-08-07','DD-MM-RR'),'SISIR     ','BASE',null);

Insert into SYSTEM_SERVICE_ARGS (SERVICE_CODE, LINE_NO, ARG_NAME, ARG_MODE, DESCR, ARG_TYPE, ARG_XFRM, CHG_DATE, CHG_USER, CHG_TERM, ARG_VALUE)
values ('prv_wf_design',8,'XTRA_PARAMS','I',null,'S',null,to_date('05-08-07','DD-MM-RR'),'SISIR     ','BASE',null);

--11) pophelp

Insert into POPHELP (FIELD_NAME, MOD_NAME, SQL_STR, DW_OBJECT, MSG_TITLE, WIDTH, HEIGHT, CHG_DATE, CHG_USER, CHG_TERM, DIST_OPT, FILTER_STRING, SQL_INPUT, DEFAULT_COL, POP_ALIGN, QUERY_MODE, PAGE_CONTEXT, POPHELP_COLS, POPHELP_SOURCE, MULTI_OPT, HELP_OPTION, POPUP_XSL_NAME, AUTO_FILL_LEN, THUMB_OBJ, THUMB_IMAGE_COL, THUMB_ALT_COL, AUTO_MIN_LENGTH, OBJ_NAME__DS, DATA_MODEL_NAME, VALIDATE_DATA, ITEM_CHANGE, MSG_NO, FILTER_EXPR, LAYOUT)
values ('ROLE_CODE','W_WF_DESIGN','SELECT ROLE_CODE, DESCR, ROLE_TYPE FROM WF_ROLE',null,'ROLE CODE',null,null,to_date('17-JUN-11','DD-MON-RR'),'BASE','BASE',null,null,null,null,null,null,null,null,null,null,'2',null,'3',null,null,null,'2 ',null,null,null,null,null,null,null);

Insert into POPHELP (FIELD_NAME, MOD_NAME, SQL_STR, DW_OBJECT, MSG_TITLE, WIDTH, HEIGHT, CHG_DATE, CHG_USER, CHG_TERM, DIST_OPT, FILTER_STRING, SQL_INPUT, DEFAULT_COL, POP_ALIGN, QUERY_MODE, PAGE_CONTEXT, POPHELP_COLS, POPHELP_SOURCE, MULTI_OPT, HELP_OPTION, POPUP_XSL_NAME, AUTO_FILL_LEN, THUMB_OBJ, THUMB_IMAGE_COL, THUMB_ALT_COL, AUTO_MIN_LENGTH, OBJ_NAME__DS, DATA_MODEL_NAME, VALIDATE_DATA, ITEM_CHANGE, MSG_NO, FILTER_EXPR, LAYOUT)
values ('RULE_CODE','W_WF_DESIGN','SELECT RULE_CODE, DESCR, RULE_TYPE FROM WF_RULE',null,'RULE CODE',null,null,to_date('17-JUN-11','DD-MON-RR'),'BASE','BASE',null,null,null,null,null,null,null,null,null,null,'2',null,'3',null,null,null,'2 ',null,null,null,null,null,null,null);

Insert into POPHELP (FIELD_NAME,MOD_NAME,SQL_STR,DW_OBJECT,MSG_TITLE,WIDTH,HEIGHT,CHG_DATE,CHG_USER,CHG_TERM,DIST_OPT,FILTER_STRING,SQL_INPUT,DEFAULT_COL,POP_ALIGN,QUERY_MODE,PAGE_CONTEXT,POPHELP_COLS,POPHELP_SOURCE,MULTI_OPT,HELP_OPTION,POPUP_XSL_NAME,AUTO_FILL_LEN,THUMB_OBJ,THUMB_IMAGE_COL,THUMB_ALT_COL,AUTO_MIN_LENGTH,OBJ_NAME__DS,DATA_MODEL_NAME,VALIDATE_DATA,ITEM_CHANGE,MSG_NO,FILTER_EXPR,LAYOUT) 
values ('ACTIVITY_CODE','W_WF_DESIGN','SELECT ACTIVITY_CODE, DESCR FROM WF_ACTIVITY',null,'ACTIVITY CODE',0,0,to_date('30-03-21','DD-MM-RR'),'BASE      ','BASE','0',null,null,null,null,null,null,null,null,null,'1',null,null,null,null,null,null,null,null,null,null,null,null,null);
Insert into POPHELP (FIELD_NAME,MOD_NAME,SQL_STR,DW_OBJECT,MSG_TITLE,WIDTH,HEIGHT,CHG_DATE,CHG_USER,CHG_TERM,DIST_OPT,FILTER_STRING,SQL_INPUT,DEFAULT_COL,POP_ALIGN,QUERY_MODE,PAGE_CONTEXT,POPHELP_COLS,POPHELP_SOURCE,MULTI_OPT,HELP_OPTION,POPUP_XSL_NAME,AUTO_FILL_LEN,THUMB_OBJ,THUMB_IMAGE_COL,THUMB_ALT_COL,AUTO_MIN_LENGTH,OBJ_NAME__DS,DATA_MODEL_NAME,VALIDATE_DATA,ITEM_CHANGE,MSG_NO,FILTER_EXPR,LAYOUT) 
values ('ACTIVITY_CODE__PREV','W_WF_DESIGN','SELECT ACTIVITY_CODE, DESCR FROM WF_ACTIVITY',null,'ACTIVITY CODE',0,0,to_date('30-03-21','DD-MM-RR'),'BASE      ','BASE','0',null,null,null,null,null,null,null,null,null,'1',null,null,null,null,null,null,null,null,null,null,null,null,null);
Insert into POPHELP (FIELD_NAME,MOD_NAME,SQL_STR,DW_OBJECT,MSG_TITLE,WIDTH,HEIGHT,CHG_DATE,CHG_USER,CHG_TERM,DIST_OPT,FILTER_STRING,SQL_INPUT,DEFAULT_COL,POP_ALIGN,QUERY_MODE,PAGE_CONTEXT,POPHELP_COLS,POPHELP_SOURCE,MULTI_OPT,HELP_OPTION,POPUP_XSL_NAME,AUTO_FILL_LEN,THUMB_OBJ,THUMB_IMAGE_COL,THUMB_ALT_COL,AUTO_MIN_LENGTH,OBJ_NAME__DS,DATA_MODEL_NAME,VALIDATE_DATA,ITEM_CHANGE,MSG_NO,FILTER_EXPR,LAYOUT) 
values ('ROLE_CODE__PERFORM','W_WF_DESIGN','SELECT ROLE_CODE, DESCR, ROLE_TYPE FROM WF_ROLE',null,'Role Code',0,0,to_date('08-06-15','DD-MM-RR'),'BASE      ','BASE           ','0',null,null,null,null,null,null,null,null,null,'1',null,null,null,null,null,null,null,null,null,null,null,null,null);

--12)MESSAGES

Insert into MESSAGES (MSG_NO, MSG_STR, MSG_DESCR, MSG_TYPE, MSG_OPT, MSG_TIME, ALARM, ERR_SOURCE, CHG_DATE, CHG_USER, CHG_TERM, OVERRIDE_INPUT, MAIL_OPTION)
values ('XPDLFLNUL','XPDL File null','XPDL File cannot be null','E','Y',null,null,null,to_date('21-08-15','DD-MM-RR'),'BASE','BASE',null,null);
Insert into MESSAGES (MSG_NO, MSG_STR, MSG_DESCR, MSG_TYPE, MSG_OPT, MSG_TIME, ALARM, ERR_SOURCE, CHG_DATE, CHG_USER, CHG_TERM, OVERRIDE_INPUT, MAIL_OPTION)
values ('RUCODINV','Invalid Rule Code','Please enter a valid Rule Code','E','Y',null,null,null,to_date('21-08-15','DD-MM-RR'),'BASE','BASE',null,null);
Insert into MESSAGES (MSG_NO, MSG_STR, MSG_DESCR, MSG_TYPE, MSG_OPT, MSG_TIME, ALARM, ERR_SOURCE, CHG_DATE, CHG_USER, CHG_TERM, OVERRIDE_INPUT, MAIL_OPTION)
values ('ROCODINV','Invalid Role Code','Please enter a valid Role Code','E','Y',null,null,null,to_date('21-08-15','DD-MM-RR'),'BASE','BASE',null,null);

update sysvis.obj_forms set Disp_Metadata = '<html>
<b style="white-space: normal !important; word-break: break-word;">{descr} - <span class="optional">{obj_name__invoke} </span></b>
<br> {wf_type} on <b>{invoke_method} </b>
<span style="float:right;">{wf_design_id}</span>
</html>' where win_name = 'w_wf_design' and Form_No = '1';
update sysvis.obj_forms set Disp_Metadata = '<html>
<b><span style="white-space: normal !important; word-break: break-word;">{descr}</span></b>
<span style="float:right;">{line_no}</span>
</html>' where win_name = 'w_wf_design' and Form_No = '2';
update sysvis.obj_forms set Disp_Metadata = '<html>
<b><span style="white-space: normal !important; word-break: break-word;">{descr}</span></b>
<span style="float:right;">{line_no}</span>
</html>' where win_name = 'w_wf_design' and Form_No = '3';
update sysvis.obj_forms set Disp_Metadata = '<html>
<b><span style="white-space: normal !important; word-break: break-word;">Activity - {activity_code_descr}</span></b>
<span style="float:right;">{route_name}</span>
<br/>
<span style="white-space: normal !important; word-break: break-word;">When {rule_descr}, After activity - {activity_code_prev_descr}</span>
<span style="float:right;">Performer: {role_code_descr}</span>
</html>' where win_name = 'w_wf_design' and Form_No = '4';