package ibase.webitm.ejb.wsfa.masters;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

import org.w3c.dom.Document;

import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;

public class SellInItemPostSave extends ValidatorEJB
{
	public String postSave()throws RemoteException,ITMException
	{
		return "";
	}

	public String postSave( String domString, String tranID ,String editFlag, String xtraParams, Connection conn ) throws RemoteException,ITMException
	{
		PreparedStatement pstmt = null;
		Document dom = null;                

		try
		{
			E12GenericUtility genericUtility = new E12GenericUtility();
			dom = genericUtility.parseString( domString );

			tranID = genericUtility.getColumnValue("tran_id", dom);
			System.out.println( "tranID : ["+ tranID +"]" );

			String sellPlanningSql = "UPDATE SELL_IN SET STATUS = ?, STATUS_DATE = SYSDATE WHERE TRAN_ID = ?";
			pstmt = conn.prepareStatement( sellPlanningSql );
			pstmt.setString(1, "Y" );
			pstmt.setString(2, tranID);
			
			int updCnt = pstmt.executeUpdate();
			if( updCnt > 0 )
			{
				System.out.println("POST SAVE updCnt success =["+updCnt+"]");
			}
			pstmt.close();
			pstmt = null;
			
			updCnt = updateSellStock( tranID, conn );
			System.out.println("POST_SAVE updateSellStock ["+ updCnt +"]");
		}
		catch(Exception e)
		{
			System.out.println( "The Exception occurs in SELL_IN POST SAVE :"+e );
			e.printStackTrace();
			throw new ITMException( e );
		}
		finally
		{
			try
			{
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				throw new ITMException(e);
			}
		}
		return "";
	}
	
	private int updateSellStock( String tranId, Connection conn ) throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet resultSet = null;
		int updateCnt = 0;
		try
		{
			String sellPlanningSql = "SELECT SELL_IN.SC_CODE, "
					+ "(SELECT STAN_CODE FROM STRG_CUSTOMER WHERE SC_CODE = SELL_IN.SC_CODE) STAN_CODE, "
					+ "(SELECT CODE FROM PERIOD WHERE FR_DATE <= SELL_IN.REF_DATE AND TO_DATE >= SELL_IN.REF_DATE) PRD_CODE, "
					+ "SELL_IN_ITEM.ITEM_CODE, "
					+ "SUM(SELL_IN_ITEM.SELL_IN_QTY) SELL_IN_QTY, "
					+ "(SELECT CODE FROM PERIOD WHERE FR_DATE = (SELECT ADD_MONTHS(TRUNC(SELL_IN.REF_DATE,'MM'),-1) FROM DUAL)) PRV_PRD_CODE, "
					+ "FN_GET_SELLS_CLOSING_STK( (SELECT STAN_CODE FROM STRG_CUSTOMER WHERE SC_CODE = SELL_IN.SC_CODE), SELL_IN.SC_CODE, SELL_IN_ITEM.ITEM_CODE, SELL_IN.REF_DATE ) PRV_MTH_CLOSING_STK "
					+ "FROM SELL_IN_ITEM SELL_IN_ITEM, SELL_IN SELL_IN "
					+ "WHERE SELL_IN.TRAN_ID = SELL_IN_ITEM.TRAN_ID "
					+ "AND SELL_IN.TRAN_ID = ? "
					+ "GROUP BY SELL_IN_ITEM.ITEM_CODE, SELL_IN.SC_CODE, SELL_IN.REF_DATE";
			pstmt = conn.prepareStatement( sellPlanningSql );
			pstmt.setString( 1, tranId );
			
			resultSet = pstmt.executeQuery();
			String scCode = "", stanCode = "", prdCode = "", itemCode = "", prvPrdCode = "";
			double sellInQty = 0, closingStk = 0;
			while( resultSet.next() )
			{
				sellInQty = 0;
				closingStk = 0;
				
				scCode = resultSet.getString( "SC_CODE" );
				stanCode = resultSet.getString( "STAN_CODE" );
				prdCode = resultSet.getString( "PRD_CODE" );
				itemCode = resultSet.getString( "ITEM_CODE" );
				sellInQty = resultSet.getDouble( "SELL_IN_QTY" );
				System.out.println( "scCode ["+ scCode +"], stanCode : ["+ stanCode +"], itemCode ["+ itemCode +"], sellInQty ["+ sellInQty +"]" );
				
				int existingStkQty = getExistingStock( scCode, prdCode, itemCode, conn );
				System.out.println( "prdCode ["+ prdCode +"], existingStkQty ["+ existingStkQty +"]" );
				boolean isStockExist = true;
				if ( existingStkQty == -1 )
				{
					isStockExist = false;
				}
				else
				{
					sellInQty += existingStkQty;
				}
				updateCnt += updateSellStock( scCode, stanCode, prdCode, itemCode, sellInQty, closingStk, isStockExist, conn );
				System.out.println( "prdCode ["+ prdCode +"], itemCode ["+ itemCode +"], updateCnt : ["+ updateCnt +"]" );
				
				prvPrdCode = resultSet.getString( "PRV_PRD_CODE" );
				closingStk = resultSet.getDouble( "PRV_MTH_CLOSING_STK" );
				System.out.println( "prvPrdCode ["+ prvPrdCode +"], closingStk : ["+ closingStk +"]" );
				existingStkQty = getExistingStock( scCode, prvPrdCode, itemCode, conn );
				isStockExist = true;
				if ( existingStkQty == -1 )
				{
					isStockExist = false;
					existingStkQty = 0;
				}
				updateCnt += updateSellStock( scCode, stanCode, prvPrdCode, itemCode, existingStkQty, closingStk, isStockExist, conn );
				System.out.println( "prvPrdCode ["+ prvPrdCode +"], itemCode ["+ itemCode +"], updateCnt : ["+ updateCnt +"]" );
			}
			pstmt.close();
			pstmt = null;
			
			System.out.println( "updateSellStock :: updateCnt : ["+ updateCnt +"]" );
		}
		catch(Exception e)
		{
			System.out.println( "Exception :: updateSellStock : ["+ e.getMessage() +"]" );
			e.printStackTrace();
			throw new ITMException( e );
		}
		finally
		{
			try
			{
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				throw new ITMException(e);
			}
		}
		return updateCnt;
	}
	
	private int getExistingStock( String scCode, String prdCode, String itemCode, Connection conn ) throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet resultSet = null;
		int sellInQty = 0;
		try
		{
			String strgSellStkSql = "SELECT SELL_IN_QTY FROM STRG_SELL_STK WHERE SC_CODE = ? AND PRD_CODE = ? AND ITEM_CODE = ?";
			pstmt = conn.prepareStatement( strgSellStkSql );
			pstmt.setString( 1, scCode );
			pstmt.setString( 2, prdCode );
			pstmt.setString( 3, itemCode );
			
			resultSet = pstmt.executeQuery();
			boolean isRecFound = false;
			if( resultSet.next() )
			{
				isRecFound = true;
				sellInQty = resultSet.getInt( "SELL_IN_QTY" );
			}
			
			if ( ! isRecFound )
			{
				sellInQty = -1;
			}
			
			pstmt.close();
			pstmt = null;
		}
		catch(Exception e)
		{
			System.out.println( "The Exception occurs in SELL_IN POST SAVE :"+e );
			e.printStackTrace();
			throw new ITMException( e );
		}
		finally
		{
			try
			{
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				throw new ITMException(e);
			}
		}
		return sellInQty;
	}
	
	private int updateSellStock( String scCode, String stanCode, String prdCode, String itemCode, double sellInQty, double closingStk, boolean isStockExist, Connection conn ) throws ITMException
	{
		PreparedStatement pstmt = null;
		int updateCnt = 0;
		try
		{
			System.out.println( "isStockExist :["+ isStockExist +"]" );
			String strgSellStkSql = "";
			if ( ! isStockExist )
			{
				strgSellStkSql = "INSERT INTO STRG_SELL_STK (SC_CODE, STAN_CODE, PRD_CODE, ITEM_CODE, SELL_IN_QTY, CLOSING_STK) VALUES (?,?,?,?,?,?)";
				pstmt = conn.prepareStatement( strgSellStkSql );
				pstmt.setString( 1, scCode );
				pstmt.setString( 2, stanCode );
				pstmt.setString( 3, prdCode );
				pstmt.setString( 4, itemCode );
				pstmt.setDouble( 5, sellInQty );
				pstmt.setDouble( 6, closingStk );
				
				updateCnt = pstmt.executeUpdate();
			}
			else
			{
				strgSellStkSql = "UPDATE STRG_SELL_STK SET SELL_IN_QTY = ?, CLOSING_STK = ? "
						+ " WHERE SC_CODE = ? "
						+ " and STAN_CODE = ?"
						+ " AND PRD_CODE = ?"
						+ " AND ITEM_CODE = ?";
				pstmt = conn.prepareStatement( strgSellStkSql );
				pstmt.setDouble( 1, sellInQty );
				pstmt.setDouble( 2, closingStk );
				pstmt.setString( 3, scCode );
				pstmt.setString( 4, stanCode );
				pstmt.setString( 5, prdCode );
				pstmt.setString( 6, itemCode );
				
				updateCnt = pstmt.executeUpdate();
			}
			System.out.println( "updateCnt :["+ updateCnt +"]" );
			
			pstmt.close();
			pstmt = null;
		}
		catch(Exception e)
		{
			System.out.println( "Exception :: updateSellStock :["+ e.getMessage() +"]" );
			e.printStackTrace();
			throw new ITMException( e );
		}
		finally
		{
			try
			{
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				throw new ITMException(e);
			}
		}
		return updateCnt;
	}
}
