/**
Title : SFAPlanParamAct
Date  : 02/02/2017
Author: Samadhan Pawar
Request Id: W16JJOH003
*/
package ibase.webitm.ejb.wsfa.masters;

import ibase.webitm.ejb.ActionHandlerEJB;
import ibase.utility.E12GenericUtility;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import javax.ejb.Stateless;
import org.w3c.dom.Document;

//@Stateless		commented by Sagar M [22 Nov 2018].
public class SFAPlanParamAct extends ActionHandlerEJB implements SFAPlanParamActLocal, SFAPlanParamActRemote
{
	public String actionHandler(String actionType, String xmlString, String xmlString1, String objContext, String xtraParams)throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		String retString = "";
		System.out.println("actionHandler:" + actionType);
		E12GenericUtility genericUtility = new E12GenericUtility();
		try {
			if ((xmlString != null) && (xmlString.trim().length() != 0))
			{
				System.out.println("XML String :" + xmlString);
				dom = genericUtility.parseString(xmlString);
			}
			if ((xmlString1 != null) && (xmlString1.trim().length() != 0))
			{
				System.out.println("XML String1 :" + xmlString1);
				dom1 = genericUtility.parseString(xmlString1);
			}
			if (actionType.equalsIgnoreCase("STANTYPE"))
			{
				retString = getStanTypes(dom, dom1, "", null, false);
			}

			System.out.println("actionType:" + actionType + ":");
		}
		catch (Exception e)
		{
			System.out.println("Exception :SFAPlanParamAct :actionHandler(String xmlString):" + e.getMessage() + ":");
			e.printStackTrace();
			throw new ITMException(e);
		}
		System.out.println("returning String from SFAPlanParamAct : actionHandler" + retString);
		return retString;
	}
	private String getStanTypes(Document dom, Document dom1, String string,Object object, boolean b) throws RemoteException, ITMException, SQLException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		Connection 	conn=null;
		StringBuffer xmlString = new StringBuffer();
		String Descr="";
		try
		{
			E12GenericUtility genericUtility = new E12GenericUtility();
			conn = getConnection();
			xmlString.append("<Root>");
			//Added By Nilesh Start :: 23-03-19
			/*String sql = "SELECT DISTINCT STAN_TYPE, DESCR FROM STANTYPE";*/
			String sql = "SELECT DISTINCT STAN_CLASS  FROM STANTYPE WHERE STAN_CLASS IS NOT NULL";
			//Added By Nilesh End :: 23-03-19
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			
			while (rs.next())
			{
				xmlString.append("<Detail>");
				//Added By Nilesh Start :: 23-03-19
				/*xmlString.append("<stan_type>").append("<![CDATA[").append( checkNull( rs.getString("STAN_TYPE") ) ).append( "]]>" ).append("</stan_type>");*/
				String StanClass=rs.getString("STAN_CLASS");
				xmlString.append("<stan_type>").append("<![CDATA[").append( checkNull( rs.getString("STAN_CLASS") ) ).append( "]]>" ).append("</stan_type>");
				/*xmlString.append("<descr>").append("<![CDATA[").append( checkNull( rs.getString("DESCR") ) ).append( "]]>" ).append("</descr>");*/
				if(StanClass.equalsIgnoreCase("OS"))
				{
					Descr="OUT STATION ";
				}
				if(StanClass.equalsIgnoreCase("EX"))
				{
					Descr=" EX STATION  ";
				}
				if(StanClass.equalsIgnoreCase("HQ"))
				{
					Descr="HEAD QUARTER ";
				}
				xmlString.append("<descr>").append("<![CDATA[").append( checkNull(Descr) ).append( "]]>" ).append("</descr>");
				//Added By Nilesh End :: 23-03-19
				xmlString.append("</Detail>");
			}
			//added by mrunalini sinkar on 9-april-2018(start)
			if (rs != null)
			{
				rs.close();
				rs = null;
			}
			if (pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			//added by mrunalini sinkar on 9-april-2018(end)
			xmlString.append("</Root>");
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e); //added by Kailash on 11-04-2018.
		}
		finally
		{
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
			if( conn != null && ! conn.isClosed() )
			{
				conn.close();
				conn = null;
			}
		}

		return xmlString.toString();
	}

	private String checkNull(String inputVal)
	{
		if (inputVal == null)
		{
			inputVal = "";
		}
		return inputVal;
	}
}
