package ibase.webitm.ejb.wsfa.masters;

import java.io.*;
import java.rmi.RemoteException;
import java.sql.*;
import java.util.*;
import java.text.*;
import javax.ejb.*;
import javax.naming.InitialContext;
import javax.xml.parsers.*;
import org.w3c.dom.*;

import ibase.ejb.*;
import ibase.system.config.*;
import ibase.webitm.ejb.*;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
//import oracle.jdbc.driver.OraclePreparedStatement; 
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;

@Stateless
public class RetSeries extends ValidatorEJB implements RetSeriesLocal,RetSeriesRemote
{
	E12GenericUtility genericUtility = new E12GenericUtility();
	protected static String database = CommonConstants.DB_NAME;

	public String wfValData() throws RemoteException, ITMException
	{
		return "";
	}
	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = null;
		System.out.println("xmlString["+xmlString+"]");
		System.out.println("xmlString1["+xmlString1+"]");
		System.out.println("xmlString2["+xmlString2+"]");
		//E12GenericUtility genericUtility = new E12GenericUtility(); //Commented by vinayak on [29/04/2016] as object has been declared on class level
		try
		{
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString); 
			}
			if(xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1); 
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2); 
			}
			errString = wfValData(dom, dom1, dom2, objContext, editFlag, xtraParams);
			System.out.println("ErrString: " + errString);
		}
		catch(Exception e)
		{
			System.out.println("Exception: RetailerSeries: wfValData(String xmlString): " + e.getMessage() + ":");
			errString = genericUtility.createErrorString(e);
			e.printStackTrace();
		}
		System.out.println("Returning from RetailerSeries wfValData");
		return (errString); 
	}
	
	public String wfValData(Document dom, Document dom1, Document dom2, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		String columnName = "";
		String columnValue = "";
		String userId = "";
		String errString = "";
		Connection connectionObject = null;		
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql="";
		
		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;
		String childNodeName = null;

		int intDtRet = 0;
		int ctr = 0;
		int noOfChilds = 0;
		int currentFormNo = 0;
		int count = 0;
		String totalBusiness = "";
		int cntSP=0;
		int cntCS=0;
		String item_ser="";
		

		//E12GenericUtility genericUtility = new E12GenericUtility(); //Commented by vinayak on [29/04/2016] as object has been declared on class level

		try
		{
	
			//Commented by vinayak on [11/07/2016] [start]
			/*ConnDriver connDriver = null;
			connDriver = new ConnDriver();
			connectionObject = connDriver.getConnectDB("DriverValidator");*/
			//Commented by vinayak on [11/07/2016] [end]
			connectionObject = getConnection();//Added by vinayak on [11/07/2016] to get connection.
			userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			parentList = dom.getElementsByTagName("Detail" + currentFormNo);
			parentNode = parentList.item(0);
			childList = parentNode.getChildNodes();
			noOfChilds = childList.getLength();
			for(ctr = 0; ctr < noOfChilds; ctr++)
			{
				childNode = childList.item(ctr);
				childNodeName = childNode.getNodeName();
				switch(currentFormNo)
				{
					case 1:
						if(childNodeName.equalsIgnoreCase("retailer_code"))
						{
							if(childNode.getFirstChild() == null)				
							{
								errString = getErrorString( "retailer_code", "NULLRETCOD", userId );
							}
							else
							{
								String retailerCode= getColumnValue("retailer_code",dom,"1");
								sql = "Select count(*) from retailer where retailer_code ='"+retailerCode.trim()+"'";
								pstmt=connectionObject.prepareStatement(sql);
								rs=pstmt.executeQuery();
								
								if(rs.next())
								 {
									count = rs.getInt(1);
								 }
								pstmt.close();
								rs.close();
								pstmt = null;
								rs = null;
									if(count == 0)
									{											
										errString = getErrorString("retailer_code","VTRETNOMAS",userId);
										break;
									}
									
									
								columnValue = childNode.getFirstChild().getNodeValue().trim();
								if( columnValue != null )
								{
									
									if ( editFlag != null && "A".equalsIgnoreCase(editFlag.trim()) )
									{
										String salesPers = checkNull(genericUtility.getColumnValue("sales_pers",dom));
										
										String localityCode = checkNull(genericUtility.getColumnValue("locality_code",dom));
										String itemSer = checkNull(genericUtility.getColumnValue("item_ser",dom));
											sql = "SELECT COUNT(*) AS COUNT FROM RETAILER_SERIES WHERE RETAILER_CODE = ? AND ITEM_SER = ? AND SALES_PERS = ? AND ROUTE_ID = (SELECT ROUTE_ID FROM SPRS_ROUTE WHERE SPRS_CODE = ? AND LOCALITY_CODE = ? )";
											pstmt = connectionObject.prepareStatement(sql);
											pstmt.setString(1, columnValue);
											pstmt.setString(2, itemSer);
											pstmt.setString(3, salesPers);
											pstmt.setString(4, salesPers);
											pstmt.setString(5, localityCode);
										
											rs = pstmt.executeQuery();
											pstmt.clearParameters();
											if ( rs.next() )
											{
												count = rs.getInt("COUNT");
											}
											if ( count > 0 )
											{
												errString = getErrorString( "retailer_code", "VTDURECEXT", userId );
												break;
											}
											rs.close();
											rs = null;

											
										
										if(pstmt != null)
										{
											pstmt.close();
											pstmt = null;
										}
									}					
								}
							}//END ELSE
						}//END IF
						else if(childNodeName.equalsIgnoreCase("item_ser"))
						{
							if(childNode.getFirstChild() == null)				
							{
								errString = getErrorString( "item_ser", "NULITMSER", userId );
							}
							else
							{
								sql = "SELECT * FROM ITEMSER WHERE ITEM_SER = ?";
								columnValue = childNode.getFirstChild().getNodeValue().trim();
								pstmt = connectionObject.prepareStatement(sql);
								pstmt.setString(1, columnValue);
								rs = pstmt.executeQuery();
								if ( !rs.next() )
								{
									errString = getErrorString( "item_ser", "ITMNOTEXT", userId );
								}
								rs.close();
								rs = null;
								if(pstmt != null)
								{
									pstmt.close();
									pstmt = null;
								}
							}
						}
						else if(childNodeName.equalsIgnoreCase("sales_pers"))
						{
							if(childNode.getFirstChild() == null)				
							{
								errString = getErrorString( "sales_pers", "NULSLSPER", userId );
							}
							else
							{
									String	validateSalesPersSql = "SELECT * FROM SALES_PERS WHERE SALES_PERS = ? AND SALES_PERS IN ( SELECT EMP_CODE FROM EMPLOYEE START WITH EMP_CODE = ? CONNECT BY PRIOR EMP_CODE = REPORT_TO )";	
								columnValue = childNode.getFirstChild().getNodeValue().trim();
								pstmt = connectionObject.prepareStatement(validateSalesPersSql);
								pstmt.setString(1, columnValue);
								pstmt.setString(2, columnValue); 

								rs = pstmt.executeQuery();
								if ( !rs.next() )
								{
									errString = getErrorString( "sales_pers", "SLPNOTVAL", userId );	
								}
								rs.close();
								rs = null;
								if(pstmt != null)
								{
									pstmt.close();
									pstmt = null;
								}						
							}
						}	
						
					// NEED TO BE CHECKED 
						/* COMMENTED BY VISHAKHA TO AVOID VALIDATION OFR NO_VISIT [START]
						 
 						else if(childNodeName.equalsIgnoreCase("no_visit"))// CHECK
						{
							
							String noVisit = checkNull(genericUtility.getColumnValue("no_visit",dom));
							String itemSer = checkNull(genericUtility.getColumnValue("item_ser",dom));
							System.out.println("value of item ser is::"+itemSer);
							System.out.println("value of no visit::"+noVisit);
							if(noVisit == null || noVisit.trim().length()==0)				
							{
								errString = getErrorString( "no_visit", "VTNULNOVIS", userId );
							}
							else if(Integer.parseInt(noVisit) <= 0)
							{
								errString = getErrorString( "no_visit", "VTNTVNOVIS", userId );
							}
							else
							{
								Boolean itemSerFound = false;
								if (itemSer == null || itemSer.trim().length() == 0)
								{
									itemSer = "ALL";
								}
								sql = "SELECT PROP_VALUE FROM PROPERTIES WHERE PROP_NAME = 'DOCTOR_MAXVISIT_INMONTH' AND ITEM_SER = ?";
								int propValue = 0;
								pstmt = connectionObject.prepareStatement(sql);
								pstmt.setString(1, itemSer);
								rs = pstmt.executeQuery();
								if ( rs.next() )
								{
									propValue = rs.getInt("PROP_VALUE");
									itemSerFound = true;
								}
								if (rs != null)
								{
									rs.close();
									rs = null;
								}
								if (pstmt != null)
								{
									pstmt.close();
									pstmt = null;
								}
								if (!itemSerFound)
								{
									sql = "SELECT PROP_VALUE FROM PROPERTIES WHERE PROP_NAME = 'DOCTOR_MAXVISIT_INMONTH' AND ITEM_SER = 'ALL'";
									pstmt =  connectionObject.prepareStatement( sql );									
									rs = pstmt.executeQuery();
									if(rs.next()) 
									{
										propValue = rs.getInt("PROP_VALUE");
									}
								
									if (rs != null)
									{
										rs.close();
										rs = null;
									}
									if (pstmt != null)
									{
										pstmt.close();
										pstmt = null;
									}
								}
								System.out.println("vale from properties ::"+propValue);
								if(Integer.parseInt(noVisit) > propValue)
								{
									errString = getErrorString( "no_visit", "VTEXCNOVIS", userId );
								}	
							}
						}
						COMMENTED BY VISHAKHA TO AVOID VALIDATION OFR NO_VISIT [END]
						*/	
					

						else if(childNodeName.equalsIgnoreCase("status"))
						{
							String status = genericUtility.getColumnValue("status",dom);
							if(childNode.getFirstChild() == null)				
							{
								errString = getErrorString( "status", "NULSTATUS", userId );
							}			
							else if(!("Y".equals(status) || "N".equals(status)) )
							{
								errString = getErrorString( "status", "INVLSTATUS", userId );
								break;
							}		
							else
							{
								/**
								* While adding new series and trying to activate the series if route is not active
								* means status ='N' is found in sprs_route then system should throw error
								*	
								*/
								String seriesStatus = "";
								String routeStatus = "";
								String routeSql = "";
								String selectSql = "";
								String scCode = checkNull(genericUtility.getColumnValue("retailer_code",dom));
								String itemSer = checkNull(genericUtility.getColumnValue("item_ser",dom));
								String salesPers = checkNull(genericUtility.getColumnValue("sales_pers",dom));
								String routeID = checkNull(genericUtility.getColumnValue("route_id",dom));
								String statusDom = checkNull(genericUtility.getColumnValue("status",dom));

								selectSql = "SELECT STATUS FROM RETAILER_SERIES WHERE RETAILER_CODE = ? AND SALES_PERS = ? AND ITEM_SER = ? AND ROUTE_ID= ? ";
								pstmt = connectionObject.prepareStatement(selectSql);
								pstmt.setString(1, scCode);
								pstmt.setString(2, salesPers);
								pstmt.setString(3, itemSer);
								pstmt.setString(4, routeID);
								rs = pstmt.executeQuery();
								if ( rs.next() )
								{
									seriesStatus = checkNull(rs.getString("STATUS"));
								}
								pstmt.clearParameters();
								rs.close();
								rs = null;
								pstmt.close();
								pstmt = null;
								routeSql = "SELECT STATUS FROM SPRS_ROUTE WHERE SPRS_CODE = ? AND ROUTE_ID = ? ";
								pstmt = connectionObject.prepareStatement(routeSql);
								pstmt.setString(1, salesPers);
								pstmt.setString(2, routeID);
								rs = pstmt.executeQuery();
								if ( rs.next() )
								{
									routeStatus = checkNull(rs.getString("STATUS"));
								}
								pstmt.clearParameters();
								rs.close();
								rs = null;
								pstmt.close();
								pstmt = null;
								System.out.println("editFlag...........::["+editFlag+"]");
								System.out.println("seriesStatus...........::["+seriesStatus+"]");
								System.out.println("statusDom...........::["+statusDom+"]");
								System.out.println("routeStatus...........::["+routeStatus+"]");
								if ( editFlag != null && "A".equalsIgnoreCase(editFlag.trim()) )
								{
									if ( routeStatus.equalsIgnoreCase("N") )
									{
										errString = getErrorString( "STATUS", "INACTROUTE", userId );
										break;
									}
								}
								else if ( editFlag != null && "E".equalsIgnoreCase(editFlag.trim()) )
								{
									if ( seriesStatus.equalsIgnoreCase("N") && statusDom.equalsIgnoreCase("Y") && routeStatus.equalsIgnoreCase("N") )
									{
										errString = getErrorString( "STATUS", "INACTROUTE", userId );
										break;
									}
								}
								
							}
						}
					
						else if(childNodeName.equalsIgnoreCase("route_id"))
						{
							if(childNode.getFirstChild() == null)				
							{
								errString = getErrorString( "route_id", "NULROUTID", userId );
							}

							//[To throw error message for Route Types "M" and "T" ] [Start]
							else
							{
								String [] propValueArr = null;
								String propValues = "";
								Vector vector = new Vector();
								String salesPers = checkNull(genericUtility.getColumnValue("sales_pers",dom));
								String routeID = checkNull(genericUtility.getColumnValue("route_id",dom));
								String routeTypeSql = "";
								String routeType = "";
								routeTypeSql = "SELECT ROUTE_TYPE FROM SPRS_ROUTE WHERE SPRS_CODE = ? AND ROUTE_ID = ? ";
								pstmt = connectionObject.prepareStatement(routeTypeSql);
								pstmt.setString(1, salesPers);
								pstmt.setString(2, routeID);
								rs = pstmt.executeQuery();
								if ( rs.next() )
								{
									routeType = checkNull(rs.getString("ROUTE_TYPE"));
								}
								//Added by Sanjaya for validate on ROUTE TYPE Start--
								if(!("X".equalsIgnoreCase(routeType) || "O".equalsIgnoreCase(routeType) || "H".equalsIgnoreCase(routeType) ))
								{
									errString = getErrorString( "route_id", "IVROUTTYPE", userId );
									break;
								}
								//Added by Sanjaya for validate on ROUTE TYPE --End--
								
								pstmt.clearParameters();
								if ( rs != null )
								{
									rs.close();
									rs = null;
								}
								if ( pstmt != null )
								{
									pstmt.close();
									pstmt = null;
								}
								propValues = getAllowedRouteType( salesPers, connectionObject );
								if (propValues.trim().length() > 0)
								{
									if(propValues.indexOf(',') > 0)
									{
										propValueArr = propValues.split(",");
									}
									else 
									{
										propValueArr = new String[1];
										propValueArr[0] = propValues;
									}
									for(int k=0 ; k<propValueArr.length ; k++)
									{
										vector.add(propValueArr[k]);
									}
									if (vector.contains(routeType))
									{
										errString = getErrorString( "route_id", "VPDTROUTE3", userId );
										break;
									}
								}
							}
							// [To throw error message for Route Types "M" and "T" ] [End]
						}
						
						else if(childNodeName.equalsIgnoreCase("wf_status"))
						{
							String wrkFlowStatus = genericUtility.getColumnValue("wf_status",dom);
							if(wrkFlowStatus != null)
							{
								if(!("D".equals(wrkFlowStatus) || "S".equals(wrkFlowStatus) || "C".equalsIgnoreCase(wrkFlowStatus)) )
								{
									errString = getErrorString( "wf_status", "IVWFSTATUS", userId );
									break;
								}
							}
						}
						
						else if(childNodeName.equalsIgnoreCase("business_to_us"))
						{
				
							String businessToDiv = checkNull(genericUtility.getColumnValue("business_to_us",dom)) == ""?"0":genericUtility.getColumnValue("business_to_us",dom);

							//String businessToUs = checkNull(genericUtility.getColumnValue("business_to_us",dom));
							if(( businessToDiv.trim().length() > 7 ) || ( businessToDiv.trim().indexOf('.') != -1 ))
							{
								errString = getErrorString( "business_to_us", "INVBSNSDIV", userId );
								break;
							}

							else if(Double.parseDouble(businessToDiv) < 0)
							{
								errString = getErrorString( "business_to_us", "IVBSNSSDIV", userId );
							}
						}
						else if(childNodeName.equalsIgnoreCase("total_business"))
						{
							totalBusiness = checkNull(genericUtility.getColumnValue("total_business",dom)) == ""?"0":genericUtility.getColumnValue("total_business",dom);
							//String totalBusiness = checkNull(genericUtility.getColumnValue("total_business",dom));
							if(( totalBusiness.trim().length() >10) ||( totalBusiness.trim().indexOf('.') != -1 ))
							{
								errString = getErrorString( "total_business", "INVTOTBSNS", userId );
								break;
							}
							else if(Double.parseDouble(totalBusiness) < 0)
							{
								errString = getErrorString( "total_business", "IVTOTLBSNS", userId );
							}
							
						}
						
				}	
				if (errString != null && errString.trim().length()>0)
				{
					break;
				}
			}
		}
		catch(SQLException se)
		{
			System.out.println("Exception: RETAILERSERIES: wfValData(Document dom): " + se.getMessage() + ":");
			errString = genericUtility.createErrorString(se);
		}
		catch(Exception e)
		{
			System.out.println("Exception: RETAILERSERIES: wfValData(Document dom): " + e.getMessage() + ":");
			errString = genericUtility.createErrorString(e);
		}
		
		finally 
		{
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if ( connectionObject != null )
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e){}
		}
		return (errString);
	}
	
	public String itemChanged() throws RemoteException, ITMException
	{
		return "";
	}

	public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = null;
		//E12GenericUtility genericUtility = new E12GenericUtility(); //Commented by vinayak on [29/04/2016] as object has been declared on class level
		try
		{
			if (xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString); 
			}
			if (xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1); 
			}
			if (xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2); 
			}
			errString = itemChanged(dom, dom1, dom2, objContext, currentColumn, editFlag, xtraParams);
			System.out.println ("ErrString :" + errString);
		}
		catch (Exception e)
		{
			System.out.println ("Exception :RETAILERSERIES :itemChanged(String,String):" + e.getMessage() + ":");
			errString = genericUtility.createErrorString(e);
		}
		System.out.println ("returning from RETAILERSERIES itemChanged");
		return errString;
	}

	public String itemChanged(Document dom, Document dom1, Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		System.out.println("STRGSERIES EJB ITEMCHANGE");
		String columnValue = "";
		String returnString = "";	
		String itemSer = ""; 
		String routeID = "";
		String splCode = "";
		String salesPersOld = "";
		String currentDate = ""; 		String scCode = "";
		String logInEmpCode = "";
		String loginName =  "";
		String selectSql = ""; 

		
		
		int count = 0;
		int noOfVisit = 0;
		
		Connection connectionObject = null;		
		PreparedStatement pstmt = null;
		Statement stmt = null; 
		ResultSet rs = null;		
		StringBuffer valueXmlString = new StringBuffer();

		int currentFormNo = 0;
		//E12GenericUtility genericUtility = new E12GenericUtility(); //Commented by vinayak on [29/04/2016] as object has been declared on class level
		
		try
		{
			//Commented by vinayak on [11/07/2016] [start]
			/*ConnDriver connDriver = null;
			connDriver = new ConnDriver();
			connectionObject = connDriver.getConnectDB("DriverValidator");*/
			//Commented by vinayak on [11/07/2016] [end]
			connectionObject = getConnection();//Added by vinayak on [11/07/2016] to get connection.
			logInEmpCode = getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode");
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat()); 
			currentDate = sdf.format(new java.util.Date()); 
			
			columnValue = genericUtility.getColumnValue(currentColumn,dom);
			if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
		
			valueXmlString = new StringBuffer("<?xml version=\"1.0\" encoding='UTF-8'?>\r\n<Root>\r\n<Header>\r\n<editFlag>");
	
			valueXmlString.append(editFlag).append("</editFlag>\r\n</Header>\r\n");
			switch (currentFormNo)
			{
				case 1:
					valueXmlString.append("<Detail1 domId =\"1\">\r\n");
						if(currentColumn.equalsIgnoreCase("itm_default"))
						{
							System.out.println("*******************xtraParams["+xtraParams+"]");
							//Added by sachin satre [29/12/2015 ] [start]
							System.out.println("Added by sachin satre start");
							valueXmlString.append("<total_business><![CDATA[").append("0").append("]]></total_business>\r\n");
							valueXmlString.append("<business_to_us><![CDATA[").append("0").append("]]></business_to_us>\r\n");
							valueXmlString.append("<no_visit><![CDATA[").append("0").append( "]]></no_visit>\r\n");
							//Added by sachin satre [29/12/2015 ] [end]
							System.out.println("Added by sachin satre end");
							
							String salesPers = checkNull(genericUtility.getColumnValue("sales_pers",dom));
							String entityCode = checkNull(genericUtility.getValueFromXTRA_PARAMS(xtraParams,"entityCode"));
							if(logInEmpCode != null && logInEmpCode.trim().length()>0 && !"null".equalsIgnoreCase(logInEmpCode))
							{
							
							valueXmlString.append("<strg_series__initiator>").append("<![CDATA["+logInEmpCode.trim()+"]]>").append("</strg_series__initiator>");
							String sql = "SELECT  EMP_FNAME ||' '|| EMP_MNAME ||' '|| EMP_LNAME AS EMP_NAME " +
									" FROM EMPLOYEE WHERE EMP_CODE = ? ";
							pstmt = connectionObject.prepareStatement(sql);
							pstmt.setString(1, logInEmpCode);
							rs = pstmt.executeQuery();
							if( rs.next())
							{	
								loginName =  rs.getString("EMP_NAME")   ==null ? "":rs.getString("EMP_NAME");		
							}	
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
							
							valueXmlString.append("<initiator>").append("<![CDATA[" + loginName + "]]>").append("</initiator>");
						
							}
							String getSalesPerData = "SELECT SALES_PERS.SALES_PERS,SALES_PERS.SP_NAME,SALES_PERS.ITEM_SER,ITEMSER.DESCR FROM ITEMSER,SALES_PERS  WHERE ( ITEMSER.ITEM_SER = SALES_PERS.ITEM_SER(+) )AND  SALES_PERS.SALES_PERS = ?";
							String getMCRCode = "SELECT MAX(CASE WHEN SHORT_ID IS NULL THEN 0 ELSE SHORT_ID END) + 1 FROM RETAILER_SERIES WHERE SALES_PERS = ?";
							pstmt = connectionObject.prepareStatement(getSalesPerData);
							pstmt.setString(1, logInEmpCode);
							rs = pstmt.executeQuery();
							if( rs.next())
							{	
								valueXmlString.append("<sales_pers protect='1'><![CDATA[").append(checkNull(rs.getString("SALES_PERS"))).append("]]></sales_pers>\r\n");	
								valueXmlString.append("<sp_name><![CDATA[").append(checkNull(rs.getString("SP_NAME"))).append("]]></sp_name>\r\n");	
								valueXmlString.append("<item_ser protect='1'><![CDATA[").append(checkNull(rs.getString("ITEM_SER"))).append("]]></item_ser>\r\n");	
								valueXmlString.append("<descr><![CDATA[").append(checkNull(rs.getString("DESCR"))).append("]]></descr>\r\n");	
							}	
							else
							{	
								valueXmlString.append("<sales_pers protect='1'><![CDATA[").append(checkNull(rs.getString(""))).append("]]></sales_pers>\r\n");	
								valueXmlString.append("<sp_name><![CDATA[").append("").append("]]></sp_name>\r\n");				
								valueXmlString.append("<item_ser protect='1'><![CDATA[").append("").append("]]></item_ser>\r\n");	
								valueXmlString.append("<descr><![CDATA[").append("").append("]]></descr>\r\n");	
							}
							rs.close();
							rs = null;
							if(pstmt != null)
							{
								pstmt.clearParameters();
								pstmt.close();
								pstmt = null;
							}

							pstmt = connectionObject.prepareStatement(getMCRCode);
							pstmt.setString(1, logInEmpCode);
							
							rs = pstmt.executeQuery();
							if( rs.next())
							{	
								valueXmlString.append("<short_id><![CDATA[").append(rs.getInt(1)).append("]]></short_id>\r\n");
							}	
							else
							{	
								valueXmlString.append("<short_id><![CDATA[").append("").append("]]></short_id>\r\n");
							}
							rs.close();
							rs = null;
							if(pstmt != null)
							{
								pstmt.clearParameters();
								pstmt.close();
								pstmt = null;
							}
							java.util.Calendar dateCreated = java.util.Calendar.getInstance();
							java.text.DateFormat df = new java.text.SimpleDateFormat(genericUtility.getApplDateFormat());
							String sysDate = df.format(dateCreated.getTime());	
							valueXmlString.append("<eff_date><![CDATA[").append(sysDate).append("]]></eff_date>\r\n");	
							valueXmlString.append("<wf_status><![CDATA[").append("S").append("]]></wf_status>\r\n");
							valueXmlString.append("<status protect = '0'><![CDATA[").append("Y").append("]]></status>\r\n");
						}
					
						else if (currentColumn.equalsIgnoreCase("sales_pers"))
						{
							String salesPers = checkNull(genericUtility.getColumnValue("sales_pers",dom));
							String salesPersFarg = checkNull(genericUtility.getValueFromXTRA_PARAMS(xtraParams,"SALES_PERS_FARG"));
							String entityCode = checkNull(genericUtility.getValueFromXTRA_PARAMS(xtraParams,"entityCode"));
							if(logInEmpCode != null && logInEmpCode.trim().length()>0 && !"null".equalsIgnoreCase(logInEmpCode))
							{
								valueXmlString.append("<strg_series__initiator>").append("<![CDATA["+logInEmpCode.trim()+"]]>").append("</strg_series__initiator>");
								String sql = "SELECT  EMP_FNAME ||' '|| EMP_MNAME ||' '|| EMP_LNAME AS EMP_NAME " +
										" FROM EMPLOYEE WHERE EMP_CODE = ? ";
								pstmt = connectionObject.prepareStatement(sql);
								pstmt.setString(1, logInEmpCode);
								rs = pstmt.executeQuery();
								if( rs.next())
								{
									loginName =  rs.getString("EMP_NAME")   ==null ? "":rs.getString("EMP_NAME");		
								}
								rs.close();
								rs = null;
								pstmt.close();
								pstmt = null;

								valueXmlString.append("<initiator>").append("<![CDATA[" + loginName + "]]>").append("</initiator>");
							}
							if ( salesPers.trim().length() == 0 )
							{
								salesPers = ( salesPersFarg.trim().length() == 0 ) ? entityCode: salesPersFarg;
							}
							String getSalesPerData = "SELECT SALES_PERS.SALES_PERS,SALES_PERS.SP_NAME,SALES_PERS.ITEM_SER,ITEMSER.DESCR FROM ITEMSER,SALES_PERS  WHERE ( ITEMSER.ITEM_SER = SALES_PERS.ITEM_SER(+) )AND  SALES_PERS.SALES_PERS = ?";
							
							String getMCRCode = "SELECT MAX(CASE WHEN SHORT_ID IS NULL THEN 0 ELSE SHORT_ID END) + 1 FROM RETAILER_SERIES WHERE SALES_PERS = ?";
							

							pstmt = connectionObject.prepareStatement(getSalesPerData);
							pstmt.setString(1, salesPers);
							
							rs = pstmt.executeQuery();
							if( rs.next())
							{	
							valueXmlString.append("<sp_name><![CDATA[").append(checkNull(rs.getString("SP_NAME"))).append("]]></sp_name>\r\n");	
								valueXmlString.append("<item_ser protect='1'><![CDATA[").append(checkNull(rs.getString("ITEM_SER"))).append("]]></item_ser>\r\n");	
								valueXmlString.append("<descr><![CDATA[").append(checkNull(rs.getString("DESCR"))).append("]]></descr>\r\n");	
								
							}	
							else
							{	
								valueXmlString.append("<sp_name><![CDATA[").append("").append("]]></sp_name>\r\n");				
								valueXmlString.append("<item_ser protect='1'><![CDATA[").append("").append("]]></item_ser>\r\n");	
								valueXmlString.append("<descr><![CDATA[").append("").append("]]></descr>\r\n");	
							}
							rs.close();
							rs = null;
							if(pstmt != null)
							{
								pstmt.clearParameters();
								pstmt.close();
								pstmt = null;
							}

							pstmt = connectionObject.prepareStatement(getMCRCode);
							pstmt.setString(1, salesPers);
							rs = pstmt.executeQuery();
							if( rs.next())
							{	
								valueXmlString.append("<short_id><![CDATA[").append(rs.getInt(1)).append("]]></short_id>\r\n");
							}	
							else
							{	
								valueXmlString.append("<short_id><![CDATA[").append("").append("]]></short_id>\r\n");
							}
							rs.close();
							rs = null;
							if(pstmt != null)
							{
								pstmt.clearParameters();
								pstmt.close();
								pstmt = null;
							}

							java.util.Calendar dateCreated = java.util.Calendar.getInstance();
							java.text.DateFormat df = new java.text.SimpleDateFormat(genericUtility.getApplDateFormat());
							String sysDate = df.format(dateCreated.getTime());	
							valueXmlString.append("<eff_date><![CDATA[").append(sysDate).append("]]></eff_date>\r\n");	
							valueXmlString.append("<wf_status><![CDATA[").append("S").append("]]></wf_status>\r\n");
							valueXmlString.append("<status><![CDATA[").append("Y").append("]]></status>\r\n");
						}
						else if(currentColumn.equalsIgnoreCase("itm_defaultedit")) 
						{
						
							
							if(logInEmpCode != null && logInEmpCode.trim().length()>0 && !"null".equalsIgnoreCase(logInEmpCode))
							{
						
							valueXmlString.append("<strg_series__initiator>").append("<![CDATA["+logInEmpCode.trim()+"]]>").append("</strg_series__initiator>");
							String sql = "SELECT  EMP_FNAME ||' '|| EMP_MNAME ||' '|| EMP_LNAME AS EMP_NAME " +
									" FROM EMPLOYEE WHERE EMP_CODE = ? ";
							pstmt = connectionObject.prepareStatement(sql);
							pstmt.setString(1, logInEmpCode);
							rs = pstmt.executeQuery();
							if( rs.next())
							{	
								loginName =  rs.getString("EMP_NAME")   ==null ? "":rs.getString("EMP_NAME");		
							}	
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
							
							valueXmlString.append("<initiator>").append("<![CDATA[" + loginName + "]]>").append("</initiator>");
							}
						}
						
						else if(currentColumn.equalsIgnoreCase("strg_series__initiator"))
						{
							if(logInEmpCode != null && logInEmpCode.trim().length()>0 && !"null".equalsIgnoreCase(logInEmpCode))
							{
							valueXmlString.append("<strg_series__initiator>").append("<![CDATA["+logInEmpCode.trim()+"]]>").append("</strg_series__initiator>");
							String sql = "SELECT  EMP_FNAME ||' '|| EMP_MNAME ||' '|| EMP_LNAME AS EMP_NAME " +
									" FROM EMPLOYEE WHERE EMP_CODE = ? ";
							pstmt = connectionObject.prepareStatement(sql);
							pstmt.setString(1, logInEmpCode);
							rs = pstmt.executeQuery();
							if( rs.next())
							{	
								loginName =  rs.getString("EMP_NAME")   ==null ? "":rs.getString("EMP_NAME");		
							}	
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
							
							valueXmlString.append("<initiator>").append("<![CDATA[" + loginName + "]]>").append("</initiator>");
							}
							
						}
						else if(currentColumn.equalsIgnoreCase("retailer_code"))
						{
							PreparedStatement pstmtInner = null;
							ResultSet rsInner = null;
							columnValue = genericUtility.getColumnValue(currentColumn,dom);
							String salesPers = genericUtility.getColumnValue("sales_pers",dom1);	
							String selRouteSql = "SELECT ROUTE_ID FROM SPRS_ROUTE WHERE SPRS_CODE = ? AND LOCALITY_CODE = (SELECT LOCALITY_CODE FROM RETAILER WHERE RETAILER_CODE = ? )";
																																																
							pstmt = connectionObject.prepareStatement(selRouteSql);
							pstmt.setString(1, salesPers);
							pstmt.setString(2, columnValue);
							rs = pstmt.executeQuery();
							if( rs.next())
							{
								routeID = rs.getString("ROUTE_ID"); 
					
								valueXmlString.append("<route_id protect='1'>").append(checkNull( rs.getString("ROUTE_ID") )).append("</route_id>\r\n");
							}	
							else
							{	
								valueXmlString.append("<route_id protect='1'>").append("").append("</route_id>\r\n");
							}
							if(pstmt != null)
							{
								pstmt.close();
							}
                            String strgDocQuery = "SELECT Retailer.RETAILER_NAME,Retailer.ADDR1,Retailer.ADDR2,Retailer.ADDR3,Retailer.CITY,Retailer.DISTRICT,Retailer.STAN_CODE,Retailer.STATE_CODE,Retailer.PIN,Retailer.COUNT_CODE,Retailer.TELE1,Retailer.TELE2,Retailer.TELE_EXT,Retailer.FAX,Retailer.MOBILE_NO,Retailer.EMAIL_ADDR,Retailer.CONT_PERS1,Retailer.CONT_PERS2,Retailer.LOCALITY_CODE FROM RETAILER Retailer WHERE Retailer.RETAILER_CODE =?"; 							
							pstmt = connectionObject.prepareStatement(strgDocQuery);
							pstmt.setString(1, columnValue);
							rs = pstmt.executeQuery();
							String resLocCode = ""; 
							if( rs.next())
							{
								
								valueXmlString.append("<retailer_name protect='1'><![CDATA[").append(checkNull( rs.getString("RETAILER_NAME") )).append("]]></retailer_name>");
							    valueXmlString.append("<addr1><![CDATA[").append(checkNull( rs.getString("ADDR1") )).append("]]></addr1>");
								valueXmlString.append("<addr2><![CDATA[").append(checkNull( rs.getString("ADDR2") )).append("]]></addr2>");
								valueXmlString.append("<addr3><![CDATA[").append(checkNull( rs.getString("ADDR3") )).append("]]></addr3>");
								valueXmlString.append("<city><![CDATA[").append(checkNull( rs.getString("CITY") )).append("]]></city>");
								valueXmlString.append("<district><![CDATA[").append(checkNull( rs.getString("DISTRICT") )).append("]]></district>");
								valueXmlString.append("<stan_code><![CDATA[").append(checkNull( rs.getString("STAN_CODE") )).append("]]></stan_code>");
								valueXmlString.append("<state_code><![CDATA[").append(checkNull( rs.getString("STATE_CODE") )).append("]]></state_code>");
								valueXmlString.append("<pin><![CDATA[").append(checkNull( rs.getString("PIN") )).append("]]></pin>");
								valueXmlString.append("<count_code><![CDATA[").append(checkNull( rs.getString("COUNT_CODE") )).append("]]></count_code>");
								valueXmlString.append("<tele1><![CDATA[").append(checkNull( rs.getString("TELE1") )).append("]]></tele1>");
								valueXmlString.append("<tele2><![CDATA[").append(checkNull( rs.getString("TELE2") )).append("]]></tele2>");
								valueXmlString.append("<tele_ext><![CDATA[").append(checkNull( rs.getString("TELE_EXT") )).append("]]></tele_ext>");
								valueXmlString.append("<fax><![CDATA[").append(checkNull( rs.getString("FAX") )).append("]]></fax>");
								valueXmlString.append("<mobile_no><![CDATA[").append(checkNull( rs.getString("MOBILE_NO") )).append("]]></mobile_no>");
								valueXmlString.append("<email_addr><![CDATA[").append(checkNull( rs.getString("EMAIL_ADDR") )).append("]]></email_addr>");
								valueXmlString.append("<cont_pers1><![CDATA[").append(checkNull( rs.getString("CONT_PERS1") )).append("]]></cont_pers1>");
								valueXmlString.append("<cont_pers2><![CDATA[").append(checkNull( rs.getString("CONT_PERS2") )).append("]]></cont_pers2>");
								valueXmlString.append("<locality_code><![CDATA[").append(checkNull( rs.getString("LOCALITY_CODE") )).append("]]></locality_code>");
								
									if ( routeID != null && routeID.trim().length() > 0 )
								{/*
									selectSql = "SELECT COUNT(*) AS COUNT FROM RETAILER_SERIES WHERE SALES_PERS = ? AND RETAILER_CODE = ? AND ROUTE_ID = ? ";
									System.out.println("selectSql [COUNT FROM RETAILERSERIES] ::"+selectSql);
									System.out.println("Bind Variables Are ::["+salesPers + "," + columnValue + "," + routeID +"]");
									pstmtInner = connectionObject.prepareStatement(selectSql);
									pstmtInner.setString(1, salesPers);
									pstmtInner.setString(2, columnValue);
									pstmtInner.setString(3, routeID);
									//End Changes - Gulzar - 04/09/08 Req ID :SY89SUN019
									rsInner = pstmtInner.executeQuery();
									if ( rsInner.next() )
									{
										count = rsInner.getInt("COUNT");
									}
									rsInner.close();
									pstmtInner.close();
									if ( count > 0 )
									{
										selectSql = "SELECT STATUS, NO_VISIT, EFF_DATE, " + 
													"BUSINESS_TO_US, REASON, SP_NAME " +
													"FROM RETAILER_SERIES, SALES_PERS " +
													"WHERE RETAILER_SERIES.SALES_PERS = SALES_PERS.SALES_PERS " +
													"AND RETAILER_SERIES.SALES_PERS = ? "+
													"AND RETAILER_SERIES.RETAILER_CODE = ? "+
													"AND RETAILER_SERIES.ROUTE_ID = ? ";
										System.out.println("selectSql [if count > 0] ::"+selectSql);
										System.out.println("Bind Variables Are ::["+salesPers + "," + columnValue + "," + routeID +"]");
										pstmtInner = connectionObject.prepareStatement(selectSql);
										pstmtInner.setString(1, salesPers);
										pstmtInner.setString(2, columnValue);
										pstmtInner.setString(3, routeID);
										//End Changes - Gulzar - 04/09/08 Req ID :SY89SUN019
										rsInner = pstmtInner.executeQuery();
										if ( rsInner.next() )
										{
											
											noOfVisit = rsInner.getInt("NO_VISIT");
								
											String effDate = rsInner.getString("EFF_DATE");
											String effectiveDate = (effDate.length() != 0 ?genericUtility.getValidDateString(effDate, genericUtility.getDBDateFormat(), genericUtility.getApplDateFormat()):"");
													//valueXmlString.append("<eff_date protect='1'>").append(effectiveDate).append("</eff_date>");//Added by Sanjaya on [06/Nov/13short]
											//valueXmlString.append("<status protect='1'>").append(checkNull( rsInner.getString("STATUS") )).append("</status>");//Commented by Gulzar - 14/10/10
											valueXmlString.append("<eff_date protect='1'><![CDATA[").append(currentDate).append("]]></eff_date>"); // Gulzar - 9/19/2008 
											valueXmlString.append("<business_to_us protect='1'><![CDATA[").append(checkNull( rsInner.getString("BUSINESS_TO_US") )).append("]]></business_to_us>");
											//valueXmlString.append("<sales_pers__old protect='1'><![CDATA[").append(checkNull( salesPersOld )).append("]]></sales_pers__old>");
											//valueXmlString.append("<reason protect='1'>").append(checkNull( rsInner.getString("REASON") )).append("</reason>");//Commented by Gulzar - 14/10/10
											valueXmlString.append("<sp_name><![CDATA[").append(checkNull( rsInner.getString("SP_NAME") )).append("]]></sp_name>");
											//Modified By Ganesh [13/05/2013][To set the value in cdata of xml][End]
											
										}
										rsInner.close();
										pstmtInner.close();

										selectSql = "SELECT ROUTE_ID FROM SPRS_ROUTE WHERE LOCALITY_CODE = ? AND SPRS_CODE = ? ";
										System.out.println("selectSql [For ROUTE_ID FROM SPRS_ROUTE] ::"+selectSql);
										System.out.println("Bind Variables Are ::["+resLocCode + "," + salesPers +"]");
										pstmtInner = connectionObject.prepareStatement(selectSql);
										pstmtInner.setString(1, resLocCode);
										pstmtInner.setString(2, salesPers);
										//End Changes - Gulzar - 04/09/08 Req ID :SY89SUN019
										rsInner = pstmtInner.executeQuery();
										if ( rsInner.next() )
										{
											//Modified By Ganesh [13/05/2013][To set the value in cdata of xml][Start]
											//valueXmlString.append("<route_id protect='1'>").append(checkNull( rsInner.getString("ROUTE_ID") )).append("</route_id>");
											valueXmlString.append("<route_id protect='1'><![CDATA[").append(checkNull( rsInner.getString("ROUTE_ID") )).append("]]></route_id>");
											//Modified By Ganesh [13/05/2013][To set the value in cdata of xml][Start]
										}
										rsInner.close();
										pstmtInner.close();

										selectSql = "SELECT SP_NAME FROM SALES_PERS WHERE SALES_PERS = ? ";
										System.out.println("selectSql [For SP_NAME FROM SALES_PERS] ::"+selectSql);
										System.out.println("Bind Variables Are ::["+salesPersOld +"]");
										pstmtInner = connectionObject.prepareStatement(selectSql);
										pstmtInner.setString(1, salesPersOld);
										//End Changes - Gulzar - 04/09/08 Req ID :SY89SUN019
										rsInner = pstmtInner.executeQuery();
										if ( rsInner.next() )
										{
											//Modified By Ganesh [13/05/2013][To set the value in cdata of xml][Start]
											//valueXmlString.append("<sp_name1>").append(checkNull( rsInner.getString("SP_NAME") )).append("</sp_name1>");
											valueXmlString.append("<sp_name><![CDATA[").append(checkNull( rsInner.getString("SP_NAME") )).append("]]></sp_name>");
											//Modified By Ganesh [13/05/2013][To set the value in cdata of xml][End]
										}
										rsInner.close();
										pstmtInner.close();

										selectSql = "SELECT DESCR FROM SPECIALITY WHERE SPL_CODE = ? ";
										System.out.println("selectSql [For DESCR FROM SPECIALITY] ::"+selectSql);
										System.out.println("Bind Variables Are ::["+splCode +"]");
								//VINAYAK		pstmtInner = connectionObject.prepareStatement(selectSql);
										pstmtInner.setString(1, splCode);
										//End Changes - Gulzar - 04/09/08 Req ID :SY89SUN019
										rsInner = pstmtInner.executeQuery();
										if ( rsInner.next() )
										{
											//Modified By Ganesh [13/05/2013][To set the value in cdata of xml][Start]
											//valueXmlString.append("<speciality_descr>").append(checkNull( rsInner.getString("DESCR") )).append("</speciality_descr>");
											valueXmlString.append("<speciality_descr><![CDATA[").append(checkNull( rsInner.getString("DESCR") )).append("]]></speciality_descr>");
											//Modified By Ganesh [13/05/2013][To set the value in cdata of xml][End]
										}
										rsInner.close();
										pstmtInner.close();
									}
									else
									{
										//Modified By Ganesh [13/05/2013][To set the value in cdata of xml][Start]
									//VINAYAK	//valueXmlString.append("<route_id protect='1'>").append(checkNull( routeID )).append("</route_id>");
										valueXmlString.append("<route_id protect='1'><![CDATA[").append(checkNull( routeID )).append("]]></route_id>");
										//Modified By Ganesh [13/05/2013][To set the value in cdata of xml][End]
									}
								*/}
								
								//itemSer		= genericUtility.getColumnValue("item_ser",dom);

						/*@ BY VINAYAK	*/	/*selectSql = "SELECT NO_VISIT FROM RETAILER_SERIES WHERE RETAILER_CODE = ? AND ITEM_SER = ? AND SALES_PERS = ? ";
								System.out.println("selectSql [For NO_VISIT FROM RETAILERSERIES] ::"+selectSql);
								System.out.println("Bind Variables Are ::["+columnValue + "," + itemSer + "," + salesPers +"]");
								pstmtInner = connectionObject.prepareStatement(selectSql);
								pstmtInner.setString(1, columnValue);
								pstmtInner.setString(2, itemSer);
								pstmtInner.setString(3, salesPers);
								rsInner = pstmtInner.executeQuery();
								if ( rsInner.next() )
								{
									valueXmlString.append("<no_visit protect='1'><![CDATA[").append(checkNull( rsInner.getString("NO_VISIT") )).append("]]></no_visit>");
								}
								else
								{
									if ( noOfVisit > 0 )
									{
										
										valueXmlString.append("<no_visit protect='1'><![CDATA[").append(noOfVisit).append("]]></no_visit>");
										
									}
								}
								rsInner.close();
								pstmtInner.close();*/
								//End Changes - Gulzar - 02/04/08 - Req ID : SY78SUN029
								//Added - Gulzar - 10/01/11 - WS01SUN038
								/*String category = "";
								scCode = checkNull(genericUtility.getColumnValue("sc_code",dom));
								String strgSql = "SELECT CATEGORY FROM STRG_SERIES WHERE SC_CODE = ? AND ITEM_SER = ? AND SALES_PERS = ? AND ROUTE_ID = ?";
								pstmt = connectionObject.prepareStatement(strgSql);
								pstmt.setString(1, scCode);
								pstmt.setString(2, itemSer);
								pstmt.setString(3, salesPers);
								pstmt.setString(4, routeID);
								rs = pstmt.executeQuery();
								if( rs.next())
								{
									category = checkNull(rs.getString("CATEGORY"));
								}
								rs.close();
								pstmt.close();
								if ( category != null && category.length() > 0 )
								{
									valueXmlString.append("<category><![CDATA[").append(category).append("]]></category>\r\n");
								}*/
								//End added gulzar - 10/01/11 - WS01SUN038
							}
							else
							{
								
							
								valueXmlString.append("<retailer_name><![CDATA[").append("").append("]]></retailer_name>");
					
								valueXmlString.append("<addr1><![CDATA[").append("").append("]]></addr1>");
								valueXmlString.append("<addr2><![CDATA[").append("").append("]]></addr2>");
								valueXmlString.append("<addr3><![CDATA[").append("").append("]]></addr3>");
								valueXmlString.append("<city><![CDATA[").append("").append("]]></city>");
								valueXmlString.append("<stan_code><![CDATA[").append("").append("]]></stan_code>");
								valueXmlString.append("<state_code><![CDATA[").append("").append("]]></state_code>");
								valueXmlString.append("<pin><![CDATA[").append("").append("]]></pin>");
								valueXmlString.append("<count_code><![CDATA[").append("").append("]]></count_code>");
								valueXmlString.append("<tele1><![CDATA[").append("").append("]]></tele1>");
								valueXmlString.append("<tele2><![CDATA[").append("").append("]]></tele2>");
								valueXmlString.append("<tele_ext><![CDATA[").append("").append("]]></tele_ext>");
								valueXmlString.append("<fax><![CDATA[").append("").append("]]></fax>");
								valueXmlString.append("<mobile_no><![CDATA[").append("").append("]]></mobile_no>");
									//valueXmlString.append("<visit_no><![CDATA[").append("").append("]]></visit_no>");
								valueXmlString.append("<email_addr><![CDATA[").append("").append("]]></email_addr>");
								valueXmlString.append("<cont_pers1><![CDATA[").append("").append("]]></cont_pers1>");
								valueXmlString.append("<cont_pers2><![CDATA[").append("").append("]]></cont_pers2>");
								valueXmlString.append("<locality_code><![CDATA[").append("").append("]]></locality_code>");

								//valueXmlString.append("<locality_code><![CDATA[").append("").append("]]></locality_code>");
								//valueXmlString.append("<total_business><![CDATA[").append("0").append("]]></total_business>"); 
								//valueXmlString.append("<no_visit protect='0'><![CDATA[").append("1").append("]]></no_visit>");
								//valueXmlString.append("<status protect='0'><![CDATA[").append("Y").append("]]></status>");
								//valueXmlString.append("<business_to_us protect='0'><![CDATA[").append("").append("]]></business_to_us>");
								//valueXmlString.append("<sp_name><![CDATA[").append("").append("]]></sp_name>");
								//valueXmlString.append("<reason protect='0'><![CDATA[").append("").append("]]></reason>");
					

							}
							if(pstmt != null)
							{
								pstmt.close();
							}
							if(pstmtInner != null)
							{
								pstmtInner.close();
							}
						}

						//modified by Ramchandra on [12/09/2012] [To update eff_date as current date when status is changes from 'N' to 'Y'][Start]
						else if(currentColumn.equalsIgnoreCase("status"))
						{
							java.util.Calendar dateCreated = java.util.Calendar.getInstance();
							java.text.DateFormat df = new java.text.SimpleDateFormat(genericUtility.getApplDateFormat());
							String statusOld = "";
							java.util.Date effDateOld = null;
							String statusNew = genericUtility.getColumnValue("status",dom);
							String salesPersDom = checkNull(genericUtility.getColumnValue("sales_pers",dom));
							String	retCodeDom = checkNull(genericUtility.getColumnValue("retailer_code",dom));
							String	itemSerDom	= genericUtility.getColumnValue("item_ser",dom);
							String	routeIDDom = genericUtility.getColumnValue("route_id",dom);
							String statusSql = "SELECT STATUS,EFF_DATE FROM RETAILER_SERIES WHERE RETAILER_CODE = ? AND ITEM_SER = ? AND SALES_PERS = ? AND ROUTE_ID = ?";
							pstmt = connectionObject.prepareStatement(statusSql);
							pstmt.setString(1, retCodeDom);
							pstmt.setString(2, itemSerDom);
							pstmt.setString(3, salesPersDom);
							pstmt.setString(4, routeIDDom);
							rs = pstmt.executeQuery();
							if( rs.next())
							{
								statusOld = rs.getString("STATUS");
								effDateOld = rs.getDate("EFF_DATE");
							}
							if(rs != null)
							{								
								rs.close();
								rs = null;
							}
							if(pstmt != null)
							{
								pstmt.clearParameters();
								pstmt.close();
								pstmt = null;
							}
							System.out.println("[RetailerSeries][itemchanged][statusNew" +statusNew +"]");
							System.out.println("[RetailerSeries][itemchanged][statusOld" +statusOld +"]");
							if (!statusOld.equals(statusNew) && statusNew.equalsIgnoreCase("Y"))
							{
								String systemDate = df.format(dateCreated.getTime());	
								System.out.println("[RetauilerSeries][itemchanged][systemDate" +systemDate +"]");
								
								valueXmlString.append("<eff_date><![CDATA[").append(systemDate).append("]]></eff_date>\r\n");
								
							}
						}
						
						
					valueXmlString.append("</Detail1>\r\n");
			}
		}
		catch(SQLException se)//Gulzar - 04/09/08 Req ID :SY89SUN019
		{
			System.out.println("Exception: RET SERIES EJB: itemChanged(Document,String): " + se.getMessage() + ":");
			valueXmlString = valueXmlString.append(genericUtility.createErrorString(se));
		}
		catch(Exception e)
		{
			System.out.println("Exception :RET SERIES EJB :itemChanged[" + e.getMessage() + "]");
			valueXmlString = valueXmlString.append(genericUtility.createErrorString(e));
		}
		finally  //Gulzar - 04/09/08 Req ID :SY89SUN019
		{
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if ( connectionObject != null )
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e){}
		}
		valueXmlString.append("</Root>\r\n");	
		System.out.println("\n****ValueXmlString :" + valueXmlString + ":********");
		return valueXmlString.toString();
	}
	private String checkNull(String input)
	{
		if (input==null)
		{
			input="";
		}
		else
		{
			input = input.trim();
		}
		return input;
	}
	protected InitialContext getInitialContext()throws ITMException
	{
		InitialContext ctx = null;
		try
		{
			AppConnectParm appConnect = new AppConnectParm();
			ctx = new InitialContext(appConnect.getProperty());
		}
		catch(ITMException itme)
		{
			System.out.println("ITMException :[RETAILERSERIES] :getInitialContext :==>");
			throw itme;
		}
		catch(Exception e)
		{
			System.out.println("Exception :[RETAILERSERIES] :getInitialContext :==>");
			throw new ITMException(e);
		}
		return ctx;
	}

	//Modified by Ramchandra on [25/07/2012] [To throw error message for Route Types "M" and "T" ] [Start]
	private String getAllowedRouteType( String loginEmpCode, Connection conn ) throws ITMException
	{
		Statement stmt = null;
		ResultSet rs = null;
		String propValue = "";
		String propSql = "";
		Statement stmt1 = null;
		ResultSet rs1 = null;
		String propSql1 = "";
		Boolean isPropFound = false;
		try
		{			
			propSql = "SELECT PROP_VALUE FROM PROPERTIES WHERE PROP_NAME = 'SPRSALLOWEDROUTETYPE' AND ITEM_SER = (SELECT ITEM_SER FROM SALES_PERS WHERE SALES_PERS = '"+loginEmpCode+"') "  ;
			stmt = conn.createStatement();
			rs = stmt.executeQuery(propSql);	
			System.out.println("[RETAILERSERIES][getAllowedRouteType()][QUERY] " +propSql + ":");
			if(rs.next())
			{
				propValue = checkNull(rs.getString("PROP_VALUE"));	
				isPropFound = true;
			}
			System.out.println("[RETSERIES][getAllowedRouteType()][propValue] " +propValue + ":");
			if(isPropFound == false)
			{
				propSql1 = "SELECT PROP_VALUE FROM PROPERTIES WHERE PROP_NAME = 'SPRSALLOWEDROUTETYPE' AND ITEM_SER ='ALL' "  ;
				stmt1 = conn.createStatement();
				rs1 = stmt1.executeQuery(propSql1);	
				if(rs1.next())
				{
					propValue = checkNull(rs1.getString("PROP_VALUE"));	
				}
				System.out.println("[RetailerSeriesPsrCopy] [getAllowedRouteType()][propValue@IF:::] " +propValue);
			}

			if (rs != null)
			{
				rs.close();
				rs = null;
			}
			if ( stmt != null )
			{
				stmt.close();
				stmt = null;
			}
			if (rs1 != null)
			{
				rs1.close();
				rs1 = null;
			}
			if ( stmt1 != null )
			{
				stmt1.close();
				stmt1 = null;
			}
			if (propValue == null)
			{
				propValue = "";
			}

		}
		catch ( Exception e )
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if ( stmt != null )
				{
					stmt.close();
					stmt = null;
				}
				if (rs1 != null)
				{
					rs1.close();
					rs1 = null;
				}
				if ( stmt1 != null )
				{
					stmt1.close();
					stmt1 = null;
				}
				
			}
			catch(Exception e1){}
		}
		return propValue;
	}
//Modified by Ramchandra on [25/07/2012] [To throw error message for Route Types "M" and "T" ] [End]

}
