package ibase.webitm.bean.wsfa;

import ibase.utility.*;
import ibase.system.config.*;
import ibase.webitm.ejb.*;
import ibase.webitm.utility.*;
import ibase.webitm.utility.GenericUtility;

import javax.servlet.http.*;

import java.io.*;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

import javax.naming.InitialContext;

import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import ibase.webitm.ejb.wsfa.transactions.SalePersCmeWizardEJB;
import ibase.webitm.ejb.wsfa.transactions.SalesPersCmeWIzardRemote;
import ibase.webitm.ejb.wsfa.transactions.StrgCustDeactive;
import ibase.webitm.ejb.wsfa.transactions.StrgCustDeactiveRemote;
import ibase.webitm.ejb.wsfa.transactions.StrgMeetWizardRemote;
import ibase.webitm.ejb.wsfa.transactions.WsfaZuviusMgrWizardEJB;


public class WsfaFlmDsrWizardBean 
{

	private ibase.utility.UserInfoBean userInfo = null;
	private HttpSession sessionCtx = null;
	private String objName = "";
	private String user_lang ="en"; 
	private String user_country = "US";
	private UserInfoBean userInfoBean = null;
	static int num = 1;
	
	public WsfaFlmDsrWizardBean( String objName, HttpSession sessionCtx ) throws ITMException
	{
		try
		{
			this.objName = objName;
			this.sessionCtx = sessionCtx;
			this.userInfo = ( ibase.utility.UserInfoBean ) this.sessionCtx.getAttribute("USER_INFO");
			
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
	}

	public WsfaFlmDsrWizardBean() throws ITMException
	{
	}
	//Added by Gaurav Singh on 20-APR-2015 for displaying item and team data [Start]
	
	public String getSalesPersTeamList( String salesPers, String strgCode, String selectedTeam ) throws ITMException
	{
		String teamData = "";
		//ITMWizardStatefulRemote itmWizardRemoteTemp = null;
		try
		{
			System.out.println("StrgMeetWizardBean : getSalesPersTeamListMitoch() ::");
			//InitialContext ctx = new InitialContext( new AppConnectParm().getProperty() );
			//itmWizardRemoteTemp = (ibase.webitm.ejb.ITMWizardStatefulRemote)ctx.lookup("ibase/ITMWizardStatefulEJB/remote");
			//teamData = itmWizardRemoteTemp.getSalesPersTeamList( salesPers, strgCode, selectedTeam );
			teamData = getSalesPersTeamListMitoch( salesPers, strgCode, selectedTeam );
			//itmWizardRemoteTemp.remove();
			//itmWizardRemoteTemp = null;

			String xslFileName = getXSLFileName( "wsfa_mgr_dsr_team_wiz_" + this.user_lang + "_" + this.user_country + ".xsl" );
			teamData = ( new ibase.webitm.utility.GenericUtility() ).transformToString( xslFileName, teamData, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			/*if ( itmWizardRemoteTemp != null )
			{
				itmWizardRemoteTemp.remove();
				itmWizardRemoteTemp = null;
			}*/
		}
		return teamData;
	}
	
	public String getSalesPersTeamListMitoch(String salesPers, String strgCode,String selectedTeam) throws ITMException
	{
		String sql = "";
		String[] team = new String[25];
		StringBuffer valueXmlString = new StringBuffer("<Root>\r\n");
		Connection connectionObject = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		ResultSet rset = null;
		GenericUtility genericUtility = GenericUtility.getInstance();
        String transDB = null;
		try
		{
			ConnDriver connDriver = new ConnDriver();

			if(this.userInfoBean!=null)
			{
				transDB = this.userInfoBean.getTransDB();
			}
			
			if(transDB!=null && (transDB.trim().length() >0 ))
			{
				connectionObject = connDriver.getConnectDB(transDB);
			}
			else
			{
				connectionObject = connDriver.getConnectDB("DriverITM");
			}
			selectedTeam = (selectedTeam != null) ? selectedTeam.trim() : selectedTeam;
			team = selectedTeam.split(",");
			System.out.println("Team selected [" + Arrays.asList(team)+ "] strgCode[" + strgCode + "]");
			sql = "SELECT SQL_STR FROM POPHELP WHERE FIELD_NAME='SALES_PERS' AND MOD_NAME='W_STRG_MEET'";
			pstmt = connectionObject.prepareStatement(sql);
			rs = pstmt.executeQuery();
			int num = 1;
			if (rs.next()) 
			{
				sql = rs.getString("SQL_STR").trim().replace("'?'", "?");
				pstmt = connectionObject.prepareStatement(sql);
				pstmt.setString(1, salesPers);
				rs = pstmt.executeQuery();
				while (rs.next()) 
				{
					String reportTo = rs.getString("REPORT_TO");
					String desgn = rs.getString("DESIGNATION");
					System.out.println("reportTo[" + reportTo + "] desgn ["	+ desgn + "]");
					reportTo = (reportTo != null) ? reportTo.trim() : reportTo;
					if (new ArrayList<String>(Arrays.asList(team)).contains(reportTo)) 
					{
						valueXmlString.append("<Detail7 domID='" + num	+ "' selected = 'Y'>\r\n");
					} 
					else 
					{
						valueXmlString.append("<Detail7 domID='" + num	+ "' selected = 'N'>\r\n");
					}

					valueXmlString.append("<sales_pers><![CDATA[").append(reportTo).append("]]></sales_pers>\r\n");
					valueXmlString.append("<name><![CDATA[").append(rs.getString("NAME")).append("]]></name>\r\n");
					valueXmlString.append("<designation><![CDATA[").append(rs.getString("DESIGNATION")).append(	"]]></designation>\r\n");
					valueXmlString.append("<strg_code><![CDATA[").append(strgCode).append("]]></strg_code>\r\n");
					valueXmlString.append("<role_code><![CDATA[]]></role_code>\r\n");

					sql = "SELECT DESIGN_CODE FROM EMPLOYEE WHERE EMP_CODE = ?";
					pstmt = connectionObject.prepareStatement(sql);
					pstmt.setString(1, reportTo);
					rset = pstmt.executeQuery();
					if (rset.next()) 
					{
						String desgnCode = rset.getString("DESIGN_CODE") != null ? rset.getString("DESIGN_CODE").trim(): "";
						valueXmlString.append("<design_code><![CDATA[").append(desgnCode).append("]]></design_code>\r\n");
					}

					valueXmlString.append("<line_no><![CDATA[]]></line_no>\r\n");
					valueXmlString.append("<tran_id><![CDATA[]]></tran_id>\r\n");
					//valueXmlString.append("<dcr_id><![CDATA[]]></dcr_id>\r\n");
					valueXmlString.append("</Detail7>\r\n");
					num++;
				}
			}

			rs.close();
			rs = null;

			rset.close();
			rset = null;

			pstmt.close();
			pstmt = null;

		} 
		catch (Exception e) 
		{
			e.printStackTrace();
			System.out.println("Exception :ITMWizardStatefulEJB :getSalesPersTeamList(String):"+ e.getMessage() + ":");
			valueXmlString = valueXmlString.append(genericUtility.createErrorString(e));
		} 
		finally 
		{
			try 
			{
				if (connectionObject != null && !connectionObject.isClosed()) 
				{
					connectionObject.close();
					connectionObject = null;
				}
				if (rs != null) 
				{
					rs.close();
					rs = null;
				}

				if (rset != null) 
				{
					rset.close();
					rset = null;
				}

				if (pstmt != null) 
				{
					pstmt.close();
					pstmt = null;
				}
			} 
			catch (Exception e) 
			{
				System.out.println("Exception :ITMWizardStatefulEJB :getSalesPersTeamList(String) :==>\n"+ e.getMessage());
				throw new ITMException(e);
			}
		}
		valueXmlString.append("</Root>\r\n");
		System.out.println("\n****ValueXmlString :" + valueXmlString.toString()+ ":********");
		return valueXmlString.toString();

	}
	
	public String getSalesPersItemList( String salesPers, String strgCode, String selectedItem ) throws ITMException
	{
		String itemData = "";
		//ITMWizardStatefulRemote itmWizardRemoteTemp = null;
		try
		{
			System.out.println("WsfaFlmDsrWizardBean :getSalesPersItemList()");
			//InitialContext ctx = new InitialContext( new AppConnectParm().getProperty() );
			//itmWizardRemoteTemp = (ibase.webitm.ejb.ITMWizardStatefulRemote)ctx.lookup("ibase/ITMWizardStatefulEJB/remote");
			//itemData = itmWizardRemoteTemp.getSalesPersItemList( salesPers, strgCode, selectedItem );
			itemData = getSalesPersItemListMitoch( salesPers, strgCode, selectedItem );
			
			//itmWizardRemoteTemp.remove();			
			//itmWizardRemoteTemp = null;
			
			String xslFileName = getXSLFileName( "wsfa_mgr_dsr_item_wiz_" + this.user_lang + "_" + this.user_country + ".xsl" );

			itemData = ( new ibase.webitm.utility.GenericUtility() ).transformToString( xslFileName, itemData, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			/*if ( itmWizardRemoteTemp != null )
			{
				itmWizardRemoteTemp.remove();
				itmWizardRemoteTemp = null;
			}*/
		}
		return itemData;
	
	}
	
	public String getSalesPersItemListMitoch(String sprsCode, String strgCode,String selectedItem) throws ITMException 
	{
		System.out.println("getSalesPersItemListMitoch called......:::::");
		// Form 5 defaultData()
		String sql = "";
		String sql1 = "";
		StringBuffer valueXmlString = new StringBuffer();
		Connection connectionObject = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		GenericUtility genericUtility = GenericUtility.getInstance();
		String transDB=null;
		try 
		{
			ConnDriver connDriver = new ConnDriver();
			if(this.userInfoBean!=null)
			{
				transDB = this.userInfoBean.getTransDB();
			}
			
			if(transDB != null && !"null".equalsIgnoreCase(transDB.trim()) && transDB.trim().length() > 0)
			{
				connectionObject = connDriver.getConnectDB(transDB);
			}
			else
			{
				connectionObject = connDriver.getConnectDB("DriverValidator");
			}

			sql = "SELECT DISTINCT SPG.SALES_PROD_GRP ITEM, SPG.DESCR DESCR FROM SALES_PROD_GRP SPG, ITEM M  WHERE M.ITEM_CODE IN ( SELECT ITEM_CODE FROM SPRS_ITEM WHERE SALES_PERS = ? ) AND M.SALES_PROD_GRP = SPG.SALES_PROD_GRP( + )";

			sql1 = "SELECT M.ITEM_CODE ITEM, M.DESCR DESCR FROM ITEM M, SALES_PROD_GRP SPG WHERE M.ITEM_CODE IN ( SELECT ITEM_CODE FROM SPRS_ITEM WHERE SALES_PERS = ? ) AND M.SALES_PROD_GRP = SPG.SALES_PROD_GRP( + )";

			System.out.println(" selectedItem [" + selectedItem + "]");

			HashMap itemMap = new HashMap();
			if (selectedItem != null && selectedItem.trim().length() > 0) 
			{
				NodeList itemNodeList = (genericUtility.parseString(selectedItem)).getElementsByTagName("strg_item");
				int nodeListLen = itemNodeList.getLength();
				for (int i = 0; i < nodeListLen; i++) 
				{
					NodeList innerNodeList = itemNodeList.item(i).getChildNodes();
					int innerNodeListLen = innerNodeList.getLength();
					String itemCode = "";
					String pitch = "";
					String qty = "";
					String columnValue = "";

					for (int j = 0; j < innerNodeListLen; j++) 
					{
						Node currNode = innerNodeList.item(j);
						System.out.println("COLUMNAME ["+ currNode.getNodeName() + "] COLUMKN VALUE["+ currNode.getFirstChild() + "] ");
						if ("item_code".equals(currNode.getNodeName())) 
						{
							if (currNode.getFirstChild() != null) 
							{
								itemCode = currNode.getFirstChild().getNodeValue().trim();
							}
						} 
						else if ("sales_prod_grp".equals(currNode.getNodeName())) 
						{
							if (currNode.getFirstChild() != null) 
							{
								itemCode = currNode.getFirstChild().getNodeValue().trim()+ "-SPG";
							}
						} 
						else if ("briefed_descr".equals(currNode.getNodeName())) 
						{
							if (currNode.getFirstChild().getNodeValue() != null) 
							{
								pitch = currNode.getFirstChild().getNodeValue().trim();
							}
						} 
						else if ("quantity".equals(currNode.getNodeName())) 
						{
							if (currNode.getFirstChild().getNodeValue() != null) 
							{
								qty = currNode.getFirstChild().getNodeValue().trim();
							}
						}
					}
					System.out.println("itemCode[" + itemCode + "] pitch["+ pitch + "] qty[" + qty + "]");
					itemMap.put(itemCode, pitch + "~" + qty);

					System.out.println(" itemMap [" + itemMap + "]");
				}
			}

			valueXmlString.append("<Root>\r\n");
			String qty = "0";
			String pitch = "";

			pstmt = connectionObject.prepareStatement(sql);
			pstmt.setString(1, sprsCode);
			rs = pstmt.executeQuery();
			while (rs.next()) 
			{
				String itemCode = (rs.getString("ITEM")).trim() + "-SPG";
				System.out.println("itemCode[" + itemCode + "]");
				if (itemMap.get(itemCode) != null) 
				{
					String data = (String) itemMap.get(itemCode);
					pitch = data.substring(0, data.indexOf("~"));
					qty = data.substring(data.indexOf("~") + 1);
					valueXmlString.append("<Detail6 domID='" + num+ "' selected = 'Y'>\r\n");
				} 
				else 
				{
					valueXmlString.append("<Detail6 domID='" + num+ "' selected = 'N'>\r\n");
				}

				valueXmlString.append("<item_descr><![CDATA[").append(rs.getString("DESCR")).append("]]></item_descr>\r\n");
				valueXmlString.append("<quantity><![CDATA[").append(qty).append("]]></quantity>\r\n");
				valueXmlString.append("<item_code><![CDATA[").append("").append("]]></item_code>\r\n");
				valueXmlString.append("<sales_prod_grp><![CDATA[").append(rs.getString("ITEM")).append("]]></sales_prod_grp>\r\n");
				valueXmlString.append("<strg_code><![CDATA[").append(strgCode).append("]]></strg_code>\r\n");
				valueXmlString.append("<line_no><![CDATA[]]></line_no>\r\n");
				valueXmlString.append("<item_type><![CDATA[").append("").append("]]></item_type>\r\n");
				valueXmlString.append("<briefed_descr><![CDATA[").append(pitch).append("]]></briefed_descr>\r\n");
				valueXmlString.append("<item_pob><![CDATA[").append("").append(	"]]></item_pob>\r\n");
				valueXmlString.append("<dcr_id><![CDATA[]]></dcr_id>\r\n");
				valueXmlString.append("</Detail6>\r\n");
				num++;
				qty = "0";
				pitch = "";
			}

			pstmt = connectionObject.prepareStatement(sql1);
			pstmt.setString(1, sprsCode);
			rs = pstmt.executeQuery();
			while (rs.next()) 
			{
				String itemCode = rs.getString("ITEM");
				if (itemMap.get(itemCode.trim()) != null) 
				{
					String data = (String) itemMap.get(itemCode.trim());
					qty = data.substring(data.indexOf("~") + 1);
					valueXmlString.append("<Detail6 domID='" + num+ "' selected = 'Y'>\r\n");
				} 
				else 
				{
					valueXmlString.append("<Detail6 domID='" + num+ "' selected = 'N'>\r\n");
				}

				valueXmlString.append("<strg_code><![CDATA[").append(strgCode).append("]]></strg_code>\r\n");
				valueXmlString.append("<item_descr><![CDATA[").append(rs.getString("DESCR")).append("]]></item_descr>\r\n");
				valueXmlString.append("<quantity><![CDATA[").append(qty).append("]]></quantity>\r\n");
				valueXmlString.append("<item_code><![CDATA[").append(rs.getString("ITEM")).append("]]></item_code>\r\n");
				valueXmlString.append("<line_no><![CDATA[]]></line_no>\r\n");
				valueXmlString.append("<item_type><![CDATA[").append("").append("]]></item_type>\r\n");
				valueXmlString.append("<briefed_descr><![CDATA[").append("Promo Material").append("]]></briefed_descr>\r\n");
				valueXmlString.append("<sales_prod_grp><![CDATA[").append("").append("]]></sales_prod_grp>\r\n");
				valueXmlString.append("<item_pob><![CDATA[").append("").append("]]></item_pob>\r\n");
				valueXmlString.append("<dcr_id><![CDATA[]]></dcr_id>\r\n");
				valueXmlString.append("</Detail6>\r\n");
				qty = "0";
				num++;
			}// end of while
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			num = 1;
		} 
		catch (Exception e) 
		{
			e.printStackTrace();
			System.out.println("Exception :ITMWizardStatefulEJB :getSalesPersItemListMitoch(String):"	+ e.getMessage() + ":");
			valueXmlString = valueXmlString.append(genericUtility.createErrorString(e));
		} 
		finally 
		{
			try 
			{
				if (connectionObject != null && !connectionObject.isClosed()) 
				{
					connectionObject.close();
					connectionObject = null;
				}
			} 
			catch (Exception e) 
			{
				System.out.println("Exception :ITMWizardStatefulEJB :getSalesPersItemListMitoch(String) :==>\n"+ e.getMessage());
				throw new ITMException(e);
			}
		}
		valueXmlString.append("</Root>\r\n");
		System.out.println("\n****ValueXmlString :" + valueXmlString.toString()
				+ ":********");
		return valueXmlString.toString();
	}
	//Added by Gaurav Singh on 20-APR-2015 for displaying item and team data [End]
	
	/*public String getSalesPersItemList( String salesPers, String strgCode, String selectedItem, String eventDate ) throws ITMException
	{
		String itemData = "";
		//StrgMeetWizardRemote itmWizardRemoteTemp = null;
		try
		{
			
			InitialContext ctx = new InitialContext( new AppConnectParm().getProperty() );
			itmWizardRemoteTemp = (ibase.webitm.ejb.wsfa.transactions.StrgMeetWizardRemote)ctx.lookup("ibase/StrgMeetWizardEJB/remote");
			itemData = itmWizardRemoteTemp.getSalesPersItemList( salesPers, strgCode, selectedItem, eventDate );
			itmWizardRemoteTemp = null;
			
			itemData = new WsfaFlmDsrWizardEJB().getSalesPersItemList( salesPers, strgCode, selectedItem, eventDate );
			String xslFileName = getXSLFileName( "wsfa_mgr_dsr_item_wiz_" + this.user_lang + "_" + this.user_country + ".xsl" );
			//changed by Rahul Barve on 3-sep-2014
			//itemData = (  ibase.webitm.utility. GenericUtility.getInstance()  ).transformToString( xslFileName, itemData, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );
			itemData = ( new ibase.utility.E12GenericUtility() ).transformToString( xslFileName, itemData, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );

		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			
			if ( itmWizardRemoteTemp != null )
			{
				itmWizardRemoteTemp = null;
			}
			
		}
		return itemData;
	
	}*/
	/*public String getSalesPersTeamList( String salesPers, String strgCode, String selectedTeam, String workWith ) throws ITMException
	{
		System.out.println("workWith in getSalesPersTeamList =["+workWith+"]");
		String teamData = "";
		//StrgMeetWizardRemote itmWizardRemoteTemp = null;
		try
		{
			
			InitialContext ctx = new InitialContext( new AppConnectParm().getProperty() );
			itmWizardRemoteTemp = (ibase.webitm.ejb.wsfa.transactions.StrgMeetWizardRemote)ctx.lookup("ibase/StrgMeetWizardEJB/remote");
			teamData = itmWizardRemoteTemp.getSalesPersTeamList( salesPers, strgCode, selectedTeam, workWith );
			itmWizardRemoteTemp = null;
			
			teamData = new WsfaFlmDsrWizardEJB().getSalesPersTeamList( salesPers, strgCode, selectedTeam, workWith );
			String xslFileName = getXSLFileName( "wsfa_mgr_dsr_mitoch_team_wiz_" + this.user_lang + "_" + this.user_country + ".xsl" );
			//changed by Rahul Barve on 3-sep-2014
			//teamData = (   ibase.webitm.utility. GenericUtility.getInstance()  ).transformToString( xslFileName, teamData, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );
			teamData = ( new ibase.utility.E12GenericUtility() ).transformToString( xslFileName, teamData, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );

		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			
			if ( itmWizardRemoteTemp != null )
			{
				itmWizardRemoteTemp = null;
			}
			
		}
		System.out.println("teamData:::"+teamData);
		return teamData;
	}*/
	
	public String getSalesPersonList( String loginCode ) throws ITMException
	{
		System.out.println("loginCode in getSalesPersonList =["+loginCode+"]");
		String salesPerspList = "";
		StrgCustDeactive strgCustDeactiveRemote = null;// modified by kailash.
		try
		{
			InitialContext ctx = new InitialContext( new AppConnectParm().getProperty() );
			//Commented and modified by kailash on 20-07-18 as per gulzar sir[Start]
			//strgCustDeactiveRemote = (ibase.webitm.ejb.wsfa.transactions.StrgCustDeactiveRemote)ctx.lookup("ibase/StrgCustDeactive/remote");
			strgCustDeactiveRemote = new StrgCustDeactive();
			//Commented and modified by kailash on 20-07-18 as per gulzar sir[End]
			salesPerspList = strgCustDeactiveRemote.getSalesPersonList( loginCode );

			String xslFileName = getXSLFileName( "customer_deact_sales_pers_wiz_" + this.user_lang + "_" + this.user_country + ".xsl" );
			//changed by Rahul Barve on 3-sep-2014
			//salesPerspList = (   ibase.webitm.utility. GenericUtility.getInstance()  ).transformToString( xslFileName, salesPerspList, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );
			salesPerspList = ( new ibase.utility.E12GenericUtility() ).transformToString( xslFileName, salesPerspList, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );

		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			if ( strgCustDeactiveRemote != null )
			{
				strgCustDeactiveRemote = null;
			}
		}
		return salesPerspList;
	}
	
	// Added By Rakesh kumar 26/02/13 START:.
	public String getCmeActivityCodeList( String salesPers, String selectedActCode )
	{
		String activityCodeData = "";
		try
		{
			InitialContext ctx = new InitialContext( new AppConnectParm().getProperty() );
			activityCodeData = new SalePersCmeWizardEJB().getCmeActivityCodeList( salesPers, selectedActCode );
			String xslFileName = getXSLFileName( "sales_pers_act_code_wiz_" + this.user_lang + "_" + this.user_country + ".xsl" );
			//changed by Rahul Barve on 3-sep-2014
			//activityCodeData = (   ibase.webitm.utility. GenericUtility.getInstance() ).transformToString( xslFileName, activityCodeData, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );
			activityCodeData = ( new ibase.utility.E12GenericUtility() ).transformToString( xslFileName, activityCodeData, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );

			System.out.println("@@@@@@@@@@@ activityCoddeData @@@@@@@@@ ");
		}
		catch ( Exception e  )
		{
			e.printStackTrace();
		}
		finally
		{
			
		}
		return activityCodeData;
	}
	//Added By Rakesh kumar 26/02/13 END:.
	
	
	
	
	private String getXSLFileName( String xslFileName )throws ITMException
	{   
		String retFileName = null;
		try
		{
			String defaultPath = null;
			if( CommonConstants.APPLICATION_CONTEXT != null )
			{
				defaultPath = CommonConstants.APPLICATION_CONTEXT + CommonConstants.ITM_CONTEXT + File.separator;
			}
			else
			{
				defaultPath = ".." + File.separator + "webapps" + File.separator + "ibase" + File.separator + CommonConstants.ITM_CONTEXT + File.separator;
			}
			File xslPath = new File( defaultPath + File.separator  + "xsl" + File.separator + CommonConstants.THEME + File.separator + "WIZARD");
			if ( !xslPath.exists() )
			{
				xslPath.mkdir();
			}
			System.out.println( " xslPath [" + xslPath +"] xslFileName ["+xslFileName +"]");
			File xslFile = new File(xslPath , xslFileName);
			if( xslFile.exists() )
			{
				retFileName = xslFile.getAbsolutePath();
			}
			else
			{
				throw new ITMException( new Exception( retFileName + " Wizard XSL file Not Found") );	
			}
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		return retFileName;
	}

}