/*
 * Decompiled with CFR 0.152.
 */
package ibase.bankIntegration;

import ibase.bankIntegration.UpdatePaymentStatus;
import ibase.bankIntegration.unsHsbc.SFTPFileUploader;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.utility.ITMException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CommonMethods {
    public static Document readXML(String filePath) {
        try {
            System.out.println("Inside CommonMethods readXML");
            File xmlFile = new File(filePath);
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", false);
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            return dBuilder.parse(xmlFile);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void modifyElementValue(Element root, String parentElementName, String elementName, String newValue) {
        System.out.println("Inside CommonMethods modifyElementValue");
        NodeList parentList = root.getElementsByTagName(parentElementName);
        if (parentList.getLength() > 0) {
            Element parentElement = (Element)parentList.item(0);
            NodeList nodeList = parentElement.getElementsByTagName(elementName);
            if (nodeList.getLength() > 0) {
                Node elementNode = nodeList.item(0);
                elementNode.setTextContent(newValue);
            } else {
                System.out.println("Element not found: " + elementName);
            }
        } else {
            System.out.println("Parent element not found: " + parentElementName);
        }
    }

    public static void saveChanges(Document doc, String filePath) throws Exception {
        System.out.println("Inside CommonMethods saveChanges filePath: [" + filePath + "]");
        System.out.println("Inside CommonMethods saveChanges doc: [" + doc.toString() + "]");
        File file = new File(filePath);
        if (!file.exists()) {
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            file.createNewFile();
        }
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(file);
        transformer.transform(source, result);
    }

    public static String generateRandomString(int length) {
        String characters = "0123456789";
        StringBuilder randomString = new StringBuilder();
        Random random = new Random();
        int i = 0;
        while (i < length) {
            int index = random.nextInt(characters.length());
            randomString.append(characters.charAt(index));
            ++i;
        }
        return randomString.toString();
    }

    public static JsonObject parseJsonString(String jsonString) {
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(jsonString));
        return jsonReader.readObject();
    }

    public static String getValueFromJson(JsonObject jsonObject, String key) {
        if (jsonObject.containsKey((Object)key)) {
            return jsonObject.getString(key);
        }
        return null;
    }

    public static String getPayIntArgsFromBankMaster(String tranID, UserInfoBean userInfo) throws SQLException {
        String payIntArgs = "";
        BaseLogger.log((String)"3", null, null, (Object)"Inside getBankCodeFromTranID method of BankIntegration class ...");
        Connection connection = null;
        Statement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                ConnDriver connDriver = new ConnDriver();
                connection = connDriver.getConnectDB(userInfo.getTransDB());
                String getPayIntArgsSQL = "SELECT B.PAY_INT_ARGS\nFROM BANK B\nINNER JOIN MISC_PAYMENT M ON B.BANK_CODE = M.BANK_CODE\nWHERE M.TRAN_ID = ?";
                pstmt = connection.prepareStatement(getPayIntArgsSQL);
                pstmt.setString(1, tranID);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    payIntArgs = rs.getString("PAY_INT_ARGS");
                    BaseLogger.log((String)"3", null, null, (Object)("Inside isIntegrated method of BankIntegration class PAY_INT_ARGS [" + payIntArgs + "]"));
                }
            }
            catch (Exception exp) {
                exp.printStackTrace();
                if (connection != null) {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (connection != null) {
                        connection.close();
                        connection = null;
                    }
                }
            }
        }
        finally {
            if (connection != null) {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (connection != null) {
                    connection.close();
                    connection = null;
                }
            }
        }
        return payIntArgs;
    }

    public static String getEventNotifyEmailFromBankMaster(String tranID, UserInfoBean userInfo) throws SQLException {
        String eventNotifyEmail = "";
        BaseLogger.log((String)"3", null, null, (Object)"Inside getBankCodeFromTranID method of BankIntegration class ...");
        Connection connection = null;
        Statement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                ConnDriver connDriver = new ConnDriver();
                connection = connDriver.getConnectDB(userInfo.getTransDB());
                String getEventNotifyEmailSQL = "SELECT B.EVENT_NOTIFY_EMAIL\nFROM BANK B\nINNER JOIN MISC_PAYMENT M ON B.BANK_CODE = M.BANK_CODE\nWHERE M.TRAN_ID = ?";
                pstmt = connection.prepareStatement(getEventNotifyEmailSQL);
                pstmt.setString(1, tranID);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    eventNotifyEmail = rs.getString("EVENT_NOTIFY_EMAIL");
                    BaseLogger.log((String)"3", null, null, (Object)("Inside isIntegrated method of BankIntegration class eventNotifyEmail [" + eventNotifyEmail + "]"));
                }
            }
            catch (Exception exp) {
                exp.printStackTrace();
                if (connection != null) {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (connection != null) {
                        connection.close();
                        connection = null;
                    }
                }
            }
        }
        finally {
            if (connection != null) {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (connection != null) {
                    connection.close();
                    connection = null;
                }
            }
        }
        return eventNotifyEmail;
    }

    public static String getBillNo(String tranID, UserInfoBean userInfo) throws ITMException {
        BaseLogger.log((String)"2", null, null, (Object)"getBillNo calling rsk------------------");
        Connection connection = null;
        Statement pstmt = null;
        ResultSet rs = null;
        String billno = "";
        StringBuffer bufferbillnumber = new StringBuffer();
        try {
            try {
                ConnDriver connDriver = new ConnDriver();
                connection = connDriver.getConnectDB(userInfo.getTransDB());
                String voucherTableNameOfNum = "";
                DBAccessEJB dbAccessEJB = new DBAccessEJB();
                connection = connDriver.getConnectDB(userInfo.getTransDB());
                String tranSerNumber = "";
                tranSerNumber = dbAccessEJB.getDBColumnValue("MISC_PAYDET", "TRAN_SER", "TRAN_ID  = '" + tranID + "'", userInfo.getTransDB());
                BaseLogger.log((String)"3", null, null, (Object)("Value of refserfor billnumber... [" + tranSerNumber + "]"));
                if (tranSerNumber.equalsIgnoreCase("M-VOUC")) {
                    voucherTableNameOfNum = "MISC_VOUCHER";
                } else if (tranSerNumber.equalsIgnoreCase("VOUCH")) {
                    voucherTableNameOfNum = "VOUCHER";
                }
                String result = "SELECT BILL_NO FROM " + voucherTableNameOfNum + " WHERE TRAN_ID in (select VOUCH_NO from MISC_PAYDET where tran_id = ?)";
                BaseLogger.log((String)"3", null, null, (Object)"getBillNo calling inside Confirm tan_id-----------");
                pstmt = connection.prepareStatement(result);
                pstmt.setString(1, tranID);
                rs = pstmt.executeQuery();
                StringBuilder resultLine = new StringBuilder();
                while (rs.next()) {
                    billno = rs.getString("BILL_NO");
                    resultLine.append(billno).append(",");
                    StringBuffer buffer = new StringBuffer();
                    buffer.append(tranID);
                    buffer.append(bufferbillnumber);
                }
                if (resultLine.length() > 0) {
                    resultLine.deleteCharAt(resultLine.length() - 1);
                }
                BaseLogger.log((String)"3", null, null, (Object)("****BILL_NO = " + resultLine.toString()));
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                bufferbillnumber.append(billno);
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return bufferbillnumber.toString();
    }

    public static String getBillDate(String tranID, UserInfoBean userInfo) throws ITMException {
        BaseLogger.log((String)"2", null, null, (Object)"getBillDate calling rsk--------------------");
        Connection connection = null;
        Statement pstmt = null;
        ResultSet rs = null;
        String billdate = "";
        StringBuffer bufferbilldate = new StringBuffer();
        try {
            try {
                ConnDriver connDriver = new ConnDriver();
                connection = connDriver.getConnectDB(userInfo.getTransDB());
                String voucherTableNameOfDate = "";
                DBAccessEJB dbAccessEJB = new DBAccessEJB();
                connection = connDriver.getConnectDB(userInfo.getTransDB());
                String tranSer = "";
                tranSer = dbAccessEJB.getDBColumnValue("MISC_PAYDET", "TRAN_SER", "TRAN_ID  = '" + tranID + "'", userInfo.getTransDB());
                BaseLogger.log((String)"3", null, null, (Object)("Value of tranSer... [" + tranSer + "]"));
                if (tranSer.equalsIgnoreCase("M-VOUC")) {
                    voucherTableNameOfDate = "MISC_VOUCHER";
                } else if (tranSer.equalsIgnoreCase("VOUCH")) {
                    voucherTableNameOfDate = "VOUCHER";
                }
                String result = "SELECT BILL_DATE FROM " + voucherTableNameOfDate + " WHERE TRAN_ID in (select VOUCH_NO from MISC_PAYDET where tran_id = ?)";
                BaseLogger.log((String)"3", null, null, (Object)"getBillDate calling inside Confirm tan_id-----------");
                pstmt = connection.prepareStatement(result);
                pstmt.setString(1, tranID);
                rs = pstmt.executeQuery();
                StringBuilder resultLineOfDate = new StringBuilder();
                while (rs.next()) {
                    billdate = rs.getString("BILL_DATE");
                    billdate = CommonMethods.extractDate(billdate);
                    resultLineOfDate.append(billdate).append(",");
                    StringBuffer buffer = new StringBuffer();
                    buffer.append(tranID);
                    buffer.append(bufferbilldate);
                }
                if (resultLineOfDate.length() > 0) {
                    resultLineOfDate.deleteCharAt(resultLineOfDate.length() - 1);
                }
                BaseLogger.log((String)"3", null, null, (Object)("****BILL_Date = " + resultLineOfDate.toString()));
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                bufferbilldate.append(billdate);
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return bufferbilldate.toString();
    }

    public static HashMap<String, String> getBillNoAndBillDate(String tranID, UserInfoBean userInfo) throws ITMException {
        BaseLogger.log((String)"2", null, null, (Object)"getBillNoAndBillDate calling rsk------------------");
        HashMap<String, String> billNoAndBillDate = new HashMap<String, String>();
        Connection connection = null;
        Statement pstmt = null;
        ResultSet rs = null;
        String billNo = "";
        String billDate = "";
        try {
            try {
                ConnDriver connDriver = new ConnDriver();
                connection = connDriver.getConnectDB(userInfo.getTransDB());
                DBAccessEJB dbAccessEJB = new DBAccessEJB();
                connection = connDriver.getConnectDB(userInfo.getTransDB());
                String tranSer = "";
                String refNo = "";
                tranSer = dbAccessEJB.getDBColumnValue("MISC_PAYDET", "TRAN_SER", "TRAN_ID  = '" + tranID + "'", userInfo.getTransDB());
                BaseLogger.log((String)"3", null, null, (Object)("Value of refserfor billnumber... [" + tranSer + "]"));
                refNo = dbAccessEJB.getDBColumnValue("MISC_PAYDET", "VOUCH_NO", "TRAN_ID  = '" + tranID + "'", userInfo.getTransDB());
                BaseLogger.log((String)"3", null, null, (Object)("Value of refNo billnumber... [" + refNo + "]"));
                String sql = "SELECT MISC_PAYABLES.BILL_NO, MISC_PAYABLES.BILL_DATE FROM MISC_PAYABLES WHERE REF_NO = ? AND TRAN_SER = ?";
                BaseLogger.log((String)"3", null, null, (Object)"");
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, refNo);
                pstmt.setString(2, tranSer);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    billNo = E12GenericUtility.checkNull((String)rs.getString("BILL_NO"));
                    billDate = E12GenericUtility.checkNull((String)rs.getString("BILL_DATE"));
                    billDate = CommonMethods.extractDate(billDate);
                    billNoAndBillDate.put("BILL_NO", billNo);
                    billNoAndBillDate.put("BILL_DATE", billDate);
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return billNoAndBillDate;
    }

    public static String getCurrentDate() {
        BaseLogger.log((String)"3", null, null, (Object)"inside getCurrentDate .. ");
        LocalDateTime currentDateTime = LocalDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd/MM/yy HH:mm:ss");
        BaseLogger.log((String)"3", null, null, (Object)("currentDateTime is .. [" + currentDateTime.format(formatter) + "]"));
        return currentDateTime.format(formatter);
    }

    private static String getElementValueByTagName(Document document, String tagName) {
        NodeList nodeList = document.getElementsByTagName(tagName);
        if (nodeList.getLength() > 0) {
            Element element = (Element)nodeList.item(0);
            return element.getTextContent();
        }
        return null;
    }

    private static String getElementValue(Element parentElement, String parentTagName, String tagName) {
        NodeList parentNodes = parentElement.getElementsByTagName(parentTagName);
        int i = 0;
        while (i < parentNodes.getLength()) {
            int j = 0;
            Element parent = (Element)parentNodes.item(i);
            NodeList nodeList = parent.getElementsByTagName(tagName);
            if (j < nodeList.getLength()) {
                Element element = (Element)nodeList.item(j);
                return element.getTextContent();
            }
            ++i;
        }
        return null;
    }

    public static String getAcknowledgmentTagValue(String filePath, String tagName, String parentTagName) {
        String result = "";
        BaseLogger.log((String)"3", null, null, (Object)("Inside checkFirstAcknowledgement method filePath [" + filePath + "]"));
        BaseLogger.log((String)"3", null, null, (Object)("Inside checkFirstAcknowledgement method tagName [" + tagName + "]"));
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new File(filePath));
            BaseLogger.log((String)"3", null, null, (Object)("Acknowledgement document:[" + E12GenericUtility.documentToString((Document)document) + "]"));
            if (parentTagName.equalsIgnoreCase("")) {
                result = CommonMethods.getElementValueByTagName(document, tagName);
            } else {
                Element rootElement = document.getDocumentElement();
                System.out.println("Root Element gsb: " + document.getDocumentElement().getTagName());
                result = CommonMethods.getElementValue(rootElement, parentTagName, tagName);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        BaseLogger.log((String)"3", null, null, (Object)("result from getAcknowledgmentTagValue:[" + result + "]"));
        return result;
    }

    public static String generateBankXMLName(String tranId) {
        Date currentDate = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("ddMMyyHHmmss");
        String formattedDate = dateFormat.format(currentDate);
        String formattedTranId = String.valueOf(tranId) + formattedDate;
        BaseLogger.log((String)"3", null, null, (Object)(" value of formattedTranId [" + formattedTranId + "]"));
        return formattedTranId;
    }

    public static String extractDate(String dateTimeString) {
        if (dateTimeString.equalsIgnoreCase("")) {
            return "";
        }
        DateTimeFormatter inputFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDateTime dateTime = LocalDateTime.parse(dateTimeString, inputFormatter);
        DateTimeFormatter outputFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        String datePart = dateTime.format(outputFormatter);
        return datePart;
    }

    public static String dateFormatter(String inputDateString) {
        String result = "";
        String inputFormat = "yyyy-MM-dd HH:mm:ss";
        String outputFormat = "dd/MM/yy HH:mm:ss";
        try {
            SimpleDateFormat inputFormatter = new SimpleDateFormat(inputFormat);
            Date date = inputFormatter.parse(inputDateString);
            SimpleDateFormat outputFormatter = new SimpleDateFormat(outputFormat);
            String outputDateString = outputFormatter.format(date);
            System.out.println("Input Date: " + inputDateString);
            System.out.println("Formatted Date: " + outputDateString);
            result = outputDateString;
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static void modifyElementValue(Element element, String parentTagName, String tagName, String newValue, int occurrence) {
        Element parentElement;
        NodeList nodeList;
        NodeList parentList = element.getElementsByTagName(parentTagName);
        if (parentList.getLength() > 0 && (nodeList = (parentElement = (Element)parentList.item(0)).getElementsByTagName(tagName)).getLength() > occurrence) {
            Element childElement = (Element)nodeList.item(occurrence);
            childElement.setTextContent(newValue);
        }
    }

    public static void modifyIdValue(Element root, String newValue, int occurrence) {
        NodeList cdtrAcctList = root.getElementsByTagName("CdtrAcct");
        if (cdtrAcctList.getLength() > 0) {
            Element cdtrAcctElement = (Element)cdtrAcctList.item(0);
            NodeList idList = cdtrAcctElement.getElementsByTagName("Id");
            if (idList.getLength() > occurrence) {
                Element idElement = (Element)idList.item(occurrence);
                NodeList othrList = idElement.getElementsByTagName("Othr");
                if (othrList.getLength() > 0) {
                    Element othrElement = (Element)othrList.item(0);
                    NodeList idValueList = othrElement.getElementsByTagName("Id");
                    if (idValueList.getLength() > 0) {
                        Element idValueElement = (Element)idValueList.item(0);
                        idValueElement.setTextContent(newValue);
                    } else {
                        System.out.println("Id value element not found inside <Othr>");
                    }
                } else {
                    System.out.println("Othr element not found inside <Id>");
                }
            } else {
                System.out.println("Id element not found inside <CdtrAcct>");
            }
        } else {
            System.out.println("CdtrAcct element not found");
        }
    }

    public static void modifyCdtrAgtValues(Element root, String mmbIdValue, String nmValue) {
        NodeList cdtrAgtList = root.getElementsByTagName("CdtrAgt");
        if (cdtrAgtList.getLength() > 0) {
            Element cdtrAgtElement = (Element)cdtrAgtList.item(0);
            NodeList finInstnIdList = cdtrAgtElement.getElementsByTagName("FinInstnId");
            if (finInstnIdList.getLength() > 0) {
                Element finInstnIdElement = (Element)finInstnIdList.item(0);
                NodeList mmbIdList = finInstnIdElement.getElementsByTagName("MmbId");
                if (mmbIdList.getLength() > 0) {
                    Element mmbIdElement = (Element)mmbIdList.item(0);
                    mmbIdElement.setTextContent(mmbIdValue);
                } else {
                    System.out.println("MmbId element not found inside <ClrSysMmbId>");
                }
                NodeList nmList = finInstnIdElement.getElementsByTagName("Nm");
                if (nmList.getLength() > 0) {
                    Element nmElement = (Element)nmList.item(0);
                    nmElement.setTextContent(nmValue);
                } else {
                    System.out.println("Nm element not found inside <FinInstnId>");
                }
            } else {
                System.out.println("FinInstnId element not found inside <CdtrAgt>");
            }
        } else {
            System.out.println("CdtrAgt element not found");
        }
    }

    public static String concatenateXmlFiles(String filePath) throws IOException {
        String result = "";
        File outputDir = new File(filePath);
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        System.out.println("OutputFileName :: [" + outputDir + "]");
        File[] xmlFiles = new File(filePath).listFiles((dir, name) -> name.toLowerCase().endsWith(".xml"));
        String filenameToRemove = "UNS_HSBC_XML_Template.xml";
        ArrayList<File> filteredFiles = new ArrayList<File>();
        File[] fileArray = xmlFiles;
        int n = xmlFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (!file.getName().equalsIgnoreCase(filenameToRemove)) {
                filteredFiles.add(file);
            }
            ++n2;
        }
        xmlFiles = filteredFiles.toArray(new File[0]);
        if (xmlFiles == null || xmlFiles.length == 0) {
            String errString = "No XML files found in the specified directory.";
            System.err.println(errString);
            return errString;
        }
        result = CommonMethods.generateConsolidatedXMLFileName();
        Throwable throwable = null;
        Object var7_11 = null;
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(new File(outputDir, result)));){
            writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            writer.write("<Document xmlns=\"urn:iso:std:iso:20022:tech:xsd:pain.001.001.03\">");
            int i = 0;
            while (i < xmlFiles.length) {
                String content = new String(Files.readAllBytes(xmlFiles[i].toPath()));
                int startIdxOfMsgId = content.indexOf("<MsgId>");
                int endIdxOfMsgId = content.indexOf("</MsgId>") + "</MsgId>".length();
                if (startIdxOfMsgId != -1 && endIdxOfMsgId != -1) {
                    String updatedMsgIdTag = "<MsgId>" + CommonMethods.getFileNameWithoutExtension(result) + "</MsgId>";
                    content = String.valueOf(content.substring(0, startIdxOfMsgId)) + updatedMsgIdTag + content.substring(endIdxOfMsgId);
                }
                int startIdxOfPmtInfId = content.indexOf("<PmtInfId>");
                int endIdxOfPmtInfId = content.indexOf("</PmtInfId>") + "</PmtInfId>".length();
                if (startIdxOfPmtInfId != -1 && endIdxOfPmtInfId != -1) {
                    String updatedPmtInfIdTag = "<PmtInfId>" + CommonMethods.getFileNameWithoutExtension(CommonMethods.generateConsolidatedXMLFileName()) + "</PmtInfId>";
                    content = String.valueOf(content.substring(0, startIdxOfPmtInfId)) + updatedPmtInfIdTag + content.substring(endIdxOfPmtInfId);
                }
                int startIdxOfCtrlSum = content.indexOf("<CtrlSum>");
                int endIdxOfCtrlSum = content.indexOf("</CtrlSum>", startIdxOfCtrlSum);
                System.out.println("startIdxOfCtrlSum :: [" + startIdxOfCtrlSum + "]");
                System.out.println("endIdxOfCtrlSum :: [" + endIdxOfCtrlSum + "]");
                if (i == 0) {
                    int totalCtrlSum = 0;
                    int j = 0;
                    while (j < xmlFiles.length) {
                        String tempContent = content;
                        if (startIdxOfCtrlSum != -1 && endIdxOfCtrlSum != -1) {
                            String ctrlSumValueStr = tempContent.substring(startIdxOfCtrlSum + "<CtrlSum>".length(), endIdxOfCtrlSum);
                            int ctrlSumValue = Integer.parseInt(ctrlSumValueStr);
                            tempContent = String.valueOf(tempContent.substring(0, startIdxOfCtrlSum)) + tempContent.substring(endIdxOfCtrlSum + "</CtrlSum>".length());
                            System.out.println("totalCtrlSum : " + (totalCtrlSum += ctrlSumValue));
                        }
                        ++j;
                    }
                    content = String.valueOf(content.substring(0, startIdxOfCtrlSum + "<CtrlSum>".length())) + totalCtrlSum + content.substring(endIdxOfCtrlSum);
                    int startIdxOfNbOfTxsTag = content.indexOf("<NbOfTxs>");
                    int endIdxOfNbOfTxsTag = content.indexOf("</NbOfTxs>") + "</NbOfTxs>".length();
                    if (startIdxOfNbOfTxsTag != -1 && endIdxOfNbOfTxsTag != -1) {
                        String updatedNbOfTxsTag = "<NbOfTxs>" + xmlFiles.length + "</NbOfTxs>";
                        content = String.valueOf(content.substring(0, startIdxOfNbOfTxsTag)) + updatedNbOfTxsTag + content.substring(endIdxOfNbOfTxsTag);
                    }
                    int startIdx = content.indexOf("<CstmrCdtTrfInitn>");
                    int endIdx = content.lastIndexOf("</CdtTrfTxInf>") + "</CdtTrfTxInf>".length();
                    if (startIdx != -1 && endIdx != -1) {
                        content = content.substring(startIdx, endIdx);
                    }
                    int startIdxOfPmtInf = content.indexOf("<PmtInf>");
                    int endIdxOfPmtInf = content.indexOf("</Dbtr>", startIdxOfPmtInf);
                    if (startIdxOfPmtInf != -1 && endIdxOfPmtInf != -1) {
                        int startIdxOfCtrlSumPmtInf = content.indexOf("<CtrlSum>", startIdxOfPmtInf);
                        int endIdxOfCtrlSumPmtInf = content.indexOf("</CtrlSum>", startIdxOfPmtInf);
                        System.out.println("value startIdxOfCtrlSumPmtInf is : " + startIdxOfCtrlSumPmtInf);
                        if (startIdxOfCtrlSumPmtInf != -1 && endIdxOfCtrlSumPmtInf != -1) {
                            content = String.valueOf(content.substring(0, startIdxOfCtrlSumPmtInf + "<CtrlSum>".length())) + totalCtrlSum + content.substring(endIdxOfCtrlSumPmtInf);
                            System.out.println("value of totalCtrlSum in pmtinf is : " + totalCtrlSum);
                        }
                        content = String.valueOf(content.substring(0, startIdxOfCtrlSumPmtInf + "<CtrlSum>".length())) + totalCtrlSum + content.substring(endIdxOfCtrlSumPmtInf);
                    }
                    int startIdxOfNbOfTxsPmtInf = content.indexOf("<NbOfTxs>", startIdxOfPmtInf);
                    int endIdxOfNbOfTxsPmtInf = content.indexOf("</NbOfTxs>", startIdxOfPmtInf);
                    if (startIdxOfNbOfTxsPmtInf != -1 && endIdxOfNbOfTxsPmtInf != -1) {
                        content = String.valueOf(content.substring(0, startIdxOfNbOfTxsPmtInf + "<NbOfTxs>".length())) + xmlFiles.length + content.substring(endIdxOfNbOfTxsPmtInf);
                    }
                } else {
                    int startIdx = content.indexOf("<CdtTrfTxInf>");
                    int endIdx = content.indexOf("</CdtTrfTxInf>") + "</CdtTrfTxInf>".length();
                    if (startIdx != -1 && endIdx != -1) {
                        content = content.substring(startIdx, endIdx);
                    }
                }
                writer.write(content);
                ++i;
            }
            writer.write("</PmtInf>");
            writer.write("</CstmrCdtTrfInitn>");
            writer.write("</Document>");
            CommonMethods.moveFilesToArchive(filePath, CommonMethods.generateArchiveFolderNameForScheduler(), result);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return result;
    }

    private static String generateConsolidatedXMLFileName() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("ddMMyyyyHHmm");
        String formattedDate = dateFormat.format(new Date());
        return String.valueOf(formattedDate) + ".xml";
    }

    private static String getFileNameWithoutExtension(String formattedDate) {
        int lastDotIndex = formattedDate.lastIndexOf(".");
        if (lastDotIndex != -1) {
            return formattedDate.substring(0, lastDotIndex);
        }
        return formattedDate;
    }

    private static void moveFilesToArchive(String filePath, String archiveFolderName, String consolidateXMLFileName) throws IOException {
        File archiveDir = new File(String.valueOf(filePath) + File.separator + archiveFolderName);
        if (!archiveDir.exists()) {
            archiveDir.mkdirs();
        }
        String[] filenamesToRemove = new String[]{"UNS_HSBC_XML_Template.xml", consolidateXMLFileName};
        File[] xmlFiles = new File(filePath).listFiles((dir, name) -> name.toLowerCase().endsWith(".xml"));
        List<String> filenamesToRemoveList = Arrays.asList(filenamesToRemove);
        ArrayList<File> filteredFiles = new ArrayList<File>();
        File[] fileArray = xmlFiles;
        int n = xmlFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (!filenamesToRemoveList.contains(file.getName())) {
                filteredFiles.add(file);
            }
            ++n2;
        }
        xmlFiles = filteredFiles.toArray(new File[0]);
        if (xmlFiles != null) {
            fileArray = xmlFiles;
            n = xmlFiles.length;
            n2 = 0;
            while (n2 < n) {
                File xmlFile = fileArray[n2];
                Path sourcePath = Paths.get(xmlFile.getAbsolutePath(), new String[0]);
                Path destinationPath = Paths.get(String.valueOf(archiveDir.getAbsolutePath()) + File.separator + xmlFile.getName(), new String[0]);
                Files.move(sourcePath, destinationPath, StandardCopyOption.REPLACE_EXISTING);
                ++n2;
            }
        }
    }

    private static String generateArchiveFolderNameForScheduler() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd-HH");
        return dateFormat.format(new Date());
    }

    public static void deleteOldFiles(String directoryPath, String[] filesToIgnore) {
        File directory = new File(directoryPath);
        if (!directory.exists() || !directory.isDirectory()) {
            System.err.println("Invalid directory path: " + directoryPath);
            return;
        }
        File[] files = directory.listFiles();
        if (files == null) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        long twoWeeksInMillis = TimeUnit.DAYS.toMillis(14L);
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            long fileLastModified;
            File file = fileArray[n2];
            if (file.isDirectory()) {
                CommonMethods.deleteOldFiles(file.getAbsolutePath(), filesToIgnore);
            } else if (!CommonMethods.shouldIgnore(file.getName(), filesToIgnore) && currentTime - (fileLastModified = file.lastModified()) > twoWeeksInMillis) {
                System.out.println("Deleting file: " + file.getAbsolutePath());
                file.delete();
            }
            ++n2;
        }
    }

    private static boolean shouldIgnore(String fileName, String[] filesToIgnore) {
        String[] stringArray = filesToIgnore;
        int n = filesToIgnore.length;
        int n2 = 0;
        while (n2 < n) {
            String ignore = stringArray[n2];
            if (fileName.equals(ignore)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public String uploadFileToSFTP(String bankCode, UserInfoBean userInfo) {
        String result = "";
        String tranID = "";
        String consolidatedXMLFileName = "";
        try {
            try {
                DBAccessEJB dbAccessEJB = new DBAccessEJB();
                String payIntArgs = dbAccessEJB.getDBColumnValue("BANK", "PAY_INT_ARGS", "BANK_CODE  = '" + bankCode + "'", userInfo.getTransDB());
                BaseLogger.log((String)"3", null, null, (Object)("Inside actionHandler generateXML.. payIntArgs[ " + payIntArgs + "]"));
                JsonObject payIntArgsJSON = CommonMethods.parseJsonString(payIntArgs);
                String localFolderPath = CommonMethods.getValueFromJson(payIntArgsJSON, "bank_specific_folder");
                localFolderPath = String.valueOf(localFolderPath) + File.separator + "XML_files";
                BaseLogger.log((String)"3", null, null, (Object)("Inside localFolderPath[ " + localFolderPath + "]"));
                String[] filesToIgnore = new String[]{"UNS_HSBC_XML_Template.xml"};
                CommonMethods.deleteOldFiles(localFolderPath, filesToIgnore);
                consolidatedXMLFileName = CommonMethods.concatenateXmlFiles(localFolderPath);
                BaseLogger.log((String)"3", null, null, (Object)("consolidatedXMLFileName[ " + consolidatedXMLFileName + "]"));
                BaseLogger.log((String)"3", null, null, (Object)("consolidatedXMLFileName + path[ " + localFolderPath + File.separator + consolidatedXMLFileName + "]"));
                String[] transactionIds = new String[]{};
                try {
                    String[] stringArray = transactionIds = CommonMethods.parseXmlForInstrIds(String.valueOf(localFolderPath) + File.separator + consolidatedXMLFileName);
                    int n = transactionIds.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String transactionId;
                        tranID = transactionId = stringArray[n2];
                        System.out.println("transactionId: " + transactionId);
                        ++n2;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.updateBankTransferID(consolidatedXMLFileName, transactionIds, userInfo);
                SFTPFileUploader sftpFileUploader = new SFTPFileUploader(payIntArgsJSON);
                result = sftpFileUploader.uploadSingleFile(String.valueOf(localFolderPath) + File.separator + consolidatedXMLFileName, "/");
                BaseLogger.log((String)"3", null, null, (Object)("result from sftpFileUploader.uploadSingleFile [ " + result + "]"));
            }
            catch (Exception exception) {
                UpdatePaymentStatus updatePaymentStatus = new UpdatePaymentStatus();
                DBAccessEJB dbAccessEJB = new DBAccessEJB();
                String paymentTransXML1stStage = "";
                try {
                    String refSer = dbAccessEJB.getDBColumnValue("BANKTRAN_LOG", "TRAN_SER", "TRAN_NO  = '" + tranID + "'", userInfo.getTransDB());
                    BaseLogger.log((String)"3", null, null, (Object)("Value of refSer... [" + refSer + "]"));
                    paymentTransXML1stStage = result.equalsIgnoreCase("File uploaded successfully") ? updatePaymentStatus.getTransXML(consolidatedXMLFileName, refSer, "Payment Initiated", "File Uploaded to Bank's SFTP Server", "") : updatePaymentStatus.getTransXML(consolidatedXMLFileName, refSer, "Payment Initiated", "Error" + result, "");
                    updatePaymentStatus.updatePaymentStatus(paymentTransXML1stStage, userInfo);
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
                catch (ITMException e) {
                    e.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            UpdatePaymentStatus updatePaymentStatus = new UpdatePaymentStatus();
            DBAccessEJB dbAccessEJB = new DBAccessEJB();
            String paymentTransXML1stStage = "";
            try {
                String refSer = dbAccessEJB.getDBColumnValue("BANKTRAN_LOG", "TRAN_SER", "TRAN_NO  = '" + tranID + "'", userInfo.getTransDB());
                BaseLogger.log((String)"3", null, null, (Object)("Value of refSer... [" + refSer + "]"));
                paymentTransXML1stStage = result.equalsIgnoreCase("File uploaded successfully") ? updatePaymentStatus.getTransXML(consolidatedXMLFileName, refSer, "Payment Initiated", "File Uploaded to Bank's SFTP Server", "") : updatePaymentStatus.getTransXML(consolidatedXMLFileName, refSer, "Payment Initiated", "Error" + result, "");
                updatePaymentStatus.updatePaymentStatus(paymentTransXML1stStage, userInfo);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
            catch (ITMException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public void updateBankTransferID(String bankTransferId, String[] transactionIds, UserInfoBean userInfo) throws SQLException {
        Connection connection = null;
        PreparedStatement psmt = null;
        ConnDriver connDriver = new ConnDriver();
        String transDB = userInfo.getTransDB();
        try {
            connection = connDriver.getConnectDB(transDB);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        String sql = "UPDATE misc_payment SET bank_transfer_id = ? WHERE TRAN_ID IN (";
        int i = 0;
        while (i < transactionIds.length) {
            sql = String.valueOf(sql) + (i == 0 ? "?" : ", ?");
            ++i;
        }
        sql = String.valueOf(sql) + ")";
        try {
            try {
                psmt = connection.prepareStatement(sql);
                psmt.setString(1, bankTransferId);
                i = 0;
                while (i < transactionIds.length) {
                    psmt.setString(i + 2, transactionIds[i]);
                    ++i;
                }
                int rowsAffected = psmt.executeUpdate();
                System.out.println("Rows affected: " + rowsAffected);
                connection.commit();
            }
            catch (SQLException e) {
                if (connection != null) {
                    try {
                        connection.rollback();
                    }
                    catch (SQLException ex) {
                        ex.printStackTrace();
                    }
                }
                e.printStackTrace();
                try {
                    if (psmt != null) {
                        psmt.close();
                    }
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (SQLException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (psmt != null) {
                    psmt.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public static String[] parseXmlForInstrIds(String filePath) throws Exception {
        ArrayList<String> instrIdsList = new ArrayList<String>();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(new File(filePath));
        NodeList nodeList = document.getElementsByTagNameNS("*", "InstrId");
        int i = 0;
        while (i < nodeList.getLength()) {
            Element element = (Element)nodeList.item(i);
            String instrId = element.getTextContent();
            instrIdsList.add(instrId);
            ++i;
        }
        String[] instrIdsArray = instrIdsList.toArray(new String[0]);
        return instrIdsArray;
    }
}

